/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.validation.lotl.AdditionalServiceInformationExtension;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ServiceChronologicalInfo {
    static final String GRANTED = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/granted";
    static final String GRANTED_NATIONALLY = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/recognisedatnationallevel";
    static final String ACCREDITED = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/accredited";
    static final String SET_BY_NATIONAL_LAW = "http://uri.etsi.org/TrstSvc/TrustedList/Svcstatus/setbynationallaw";
    private static final Set<String> validStatuses = new HashSet<String>();
    private final List<AdditionalServiceInformationExtension> extensions = new ArrayList<AdditionalServiceInformationExtension>();
    private final DateTimeFormatter statusStartDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private String serviceStatus;
    private LocalDateTime serviceStatusStartingTime;

    ServiceChronologicalInfo() {
    }

    ServiceChronologicalInfo(String serviceStatus, LocalDateTime serviceStatusStartingTime) {
        this.serviceStatus = serviceStatus;
        this.serviceStatusStartingTime = serviceStatusStartingTime;
    }

    static boolean isStatusValid(String status) {
        return validStatuses.contains(status);
    }

    String getServiceStatus() {
        return this.serviceStatus;
    }

    void setServiceStatus(String serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    LocalDateTime getServiceStatusStartingTime() {
        return this.serviceStatusStartingTime;
    }

    void setServiceStatusStartingTime(String timeString) {
        this.serviceStatusStartingTime = this.statusStartDateFormat.parse((CharSequence)timeString, LocalDateTime::from);
    }

    void setServiceStatusStartingTime(LocalDateTime serviceStatusStartingTime) {
        this.serviceStatusStartingTime = serviceStatusStartingTime;
    }

    void addExtension(AdditionalServiceInformationExtension extension) {
        this.extensions.add(extension);
    }

    List<AdditionalServiceInformationExtension> getExtensions() {
        return this.extensions;
    }

    static {
        validStatuses.add(GRANTED);
        validStatuses.add(GRANTED_NATIONALLY);
        validStatuses.add(ACCREDITED);
        validStatuses.add(SET_BY_NATIONAL_LAW);
    }
}

