/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.validation.lotl.AbstractXmlCertificateHandler;
import com.itextpdf.signatures.validation.lotl.AdditionalServiceInformationExtension;
import com.itextpdf.signatures.validation.lotl.CountryServiceContext;
import com.itextpdf.signatures.validation.lotl.ServiceChronologicalInfo;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class XmlCountryCertificateHandler
extends AbstractXmlCertificateHandler {
    private static final List<String> INFORMATION_TAGS = new ArrayList<String>();
    private final Set<String> serviceTypes;
    private StringBuilder information;
    private CountryServiceContext currentServiceContext = null;
    private ServiceChronologicalInfo currentServiceChronologicalInfo = null;
    private AdditionalServiceInformationExtension currentExtension = null;

    XmlCountryCertificateHandler(Set<String> serviceTypes) {
        this.serviceTypes = new HashSet<String>(serviceTypes);
    }

    @Override
    public void startElement(String uri, String localName, String qName, HashMap<String, String> attributes) {
        if ("TSPService".equals(localName)) {
            this.startProvider();
        } else if ("ServiceHistoryInstance".equals(localName) || "ServiceInformation".equals(localName)) {
            this.currentServiceChronologicalInfo = new ServiceChronologicalInfo();
        } else if ("AdditionalServiceInformation".equals(localName)) {
            this.currentExtension = new AdditionalServiceInformationExtension();
        } else if (INFORMATION_TAGS.contains(localName)) {
            this.information = new StringBuilder();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (localName) {
            case "TSPService": {
                this.endProvider();
                break;
            }
            case "X509Certificate": {
                this.addCertificateToContext(this.information.toString());
                this.information = null;
                break;
            }
            case "ServiceStatus": {
                if (this.currentServiceChronologicalInfo != null) {
                    this.currentServiceChronologicalInfo.setServiceStatus(this.information.toString());
                }
                this.information = null;
                break;
            }
            case "ServiceTypeIdentifier": {
                if (this.currentServiceContext != null) {
                    if (this.serviceTypes.isEmpty() || this.serviceTypes.contains(this.information.toString())) {
                        this.currentServiceContext.setServiceType(this.information.toString());
                    } else {
                        this.currentServiceContext = null;
                    }
                }
                this.information = null;
                break;
            }
            case "StatusStartingTime": {
                if (this.currentServiceChronologicalInfo != null) {
                    this.currentServiceChronologicalInfo.setServiceStatusStartingTime(this.information.toString());
                }
                this.information = null;
                break;
            }
            case "ServiceInformation": 
            case "ServiceHistoryInstance": {
                if (this.currentServiceContext != null) {
                    this.currentServiceContext.addServiceChronologicalInfo(this.currentServiceChronologicalInfo);
                }
                this.currentServiceChronologicalInfo = null;
                break;
            }
            case "URI": {
                if (this.currentExtension == null) break;
                this.currentExtension.setUri(this.information.toString());
                break;
            }
            case "AdditionalServiceInformation": {
                if (this.currentServiceChronologicalInfo != null) {
                    this.currentServiceChronologicalInfo.addExtension(this.currentExtension);
                }
                this.currentExtension = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.information != null) {
            this.information.append(ch, start, length);
        }
    }

    void startProvider() {
        this.currentServiceContext = new CountryServiceContext();
    }

    void addCertificateToContext(String certificateString) {
        if (this.currentServiceContext == null) {
            return;
        }
        X509Certificate certificate = CertificateUtil.createCertificateFromEncodedData(XmlCountryCertificateHandler.removeWhitespacesAndBreakLines(certificateString));
        this.currentServiceContext.addCertificate(certificate);
    }

    void endProvider() {
        if (this.currentServiceContext != null) {
            this.serviceContextList.add(this.currentServiceContext);
            this.currentServiceContext = null;
        }
    }

    private static String removeWhitespacesAndBreakLines(String data) {
        return data.replace(" ", "").replace("\n", "");
    }

    static {
        INFORMATION_TAGS.add("ServiceTypeIdentifier");
        INFORMATION_TAGS.add("ServiceStatus");
        INFORMATION_TAGS.add("X509Certificate");
        INFORMATION_TAGS.add("StatusStartingTime");
        INFORMATION_TAGS.add("URI");
    }
}

