/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.javasimon.utils.bean.BeanUtilsException;
import org.javasimon.utils.bean.ClassUtils;
import org.javasimon.utils.bean.ConvertException;
import org.javasimon.utils.bean.Converter;
import org.javasimon.utils.bean.NestedResolver;
import org.javasimon.utils.bean.ToBooleanConverter;
import org.javasimon.utils.bean.ToByteConverter;
import org.javasimon.utils.bean.ToCharConverter;
import org.javasimon.utils.bean.ToDoubleConverter;
import org.javasimon.utils.bean.ToFloatConverter;
import org.javasimon.utils.bean.ToIntegerConverter;
import org.javasimon.utils.bean.ToLongConverter;
import org.javasimon.utils.bean.ToShortConverter;
import org.javasimon.utils.bean.ToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimonBeanUtils {
    private static final Logger logger = LoggerFactory.getLogger(SimonBeanUtils.class);
    private static final SimonBeanUtils INSTANCE = new SimonBeanUtils();
    private final Map<Class<?>, Converter> converters = new ConcurrentHashMap();

    public SimonBeanUtils() {
        this.converters.put(String.class, new ToStringConverter());
        this.converters.put(Boolean.TYPE, new ToBooleanConverter());
        this.converters.put(Boolean.class, new ToBooleanConverter());
        this.converters.put(Byte.TYPE, new ToByteConverter());
        this.converters.put(Byte.class, new ToByteConverter());
        this.converters.put(Short.TYPE, new ToShortConverter());
        this.converters.put(Short.class, new ToShortConverter());
        this.converters.put(Integer.TYPE, new ToIntegerConverter());
        this.converters.put(Integer.class, new ToIntegerConverter());
        this.converters.put(Long.TYPE, new ToLongConverter());
        this.converters.put(Long.class, new ToLongConverter());
        this.converters.put(Float.TYPE, new ToFloatConverter());
        this.converters.put(Float.class, new ToFloatConverter());
        this.converters.put(Double.TYPE, new ToDoubleConverter());
        this.converters.put(Double.class, new ToDoubleConverter());
        this.converters.put(Character.TYPE, new ToCharConverter());
        this.converters.put(Character.class, new ToCharConverter());
    }

    public static SimonBeanUtils getInstance() {
        return INSTANCE;
    }

    public void setProperty(Object target, String property, Object value) {
        NestedResolver resolver = new NestedResolver(target, property);
        if (value instanceof String) {
            this.convertStringValue(resolver.getNestedTarget(), resolver.getProperty(), (String)value);
        } else {
            this.setObjectValue(resolver.getNestedTarget(), resolver.getProperty(), value);
        }
    }

    private void convertStringValue(Object target, String property, String strVal) {
        Set<Method> potentialSetters = ClassUtils.getSetters(target.getClass(), property);
        boolean converted = false;
        for (Method setter : potentialSetters) {
            try {
                Class<?> setterType = ClassUtils.getSetterType(setter);
                Converter converter = this.getConverterTo(setterType);
                if (converter != null) {
                    Object value = converter.convert(setterType, strVal);
                    this.invokeSetter(target, setter, value);
                    converted = true;
                    break;
                }
                logger.debug("Failed to find converter for method '{}'", (Object)setter);
            }
            catch (ConvertException ex) {
                logger.debug("Failed to convert value '{}' for method '{}'", (Object)strVal, (Object)setter);
            }
        }
        if (!converted) {
            Class<?> fieldType;
            Converter converter;
            Field field = ClassUtils.getField(target.getClass(), property);
            if (field != null && (converter = this.getConverterTo(fieldType = field.getType())) != null) {
                Object value = converter.convert(fieldType, strVal);
                this.setValueUsingField(field, target, value);
                return;
            }
            throw new BeanUtilsException(String.format("Failed to find find setter/field for property '%s' and value '%s'", property, strVal));
        }
    }

    private Converter getConverterTo(Class<?> setterType) {
        return this.converters.get(setterType);
    }

    private void setObjectValue(Object target, String property, Object value) {
        Method setter = ClassUtils.getSetter(target.getClass(), property, value.getClass());
        if (setter != null) {
            this.invokeSetter(target, setter, value);
        } else {
            Field field = ClassUtils.getField(target.getClass(), property);
            if (field != null) {
                this.setValueUsingField(field, target, value);
            } else {
                throw new BeanUtilsException("Failed to find field/setter for property " + property);
            }
        }
    }

    private void invokeSetter(Object target, Method setter, Object value) {
        try {
            setter.setAccessible(true);
            setter.invoke(target, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BeanUtilsException(e);
        }
    }

    private void setValueUsingField(Field field, Object target, Object value) {
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException | SecurityException ex) {
            throw new BeanUtilsException(ex);
        }
    }

    public void registerConverter(Class<?> targetClass, Converter converter) {
        this.converters.put(targetClass, converter);
    }
}

