/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectSet;

final class CoordinateOperationSet
extends IdentifiedObjectSet {
    private static final long serialVersionUID = -2421669857023064667L;
    static final Set<String> EXCLUDED_OPERATIONS = new HashSet<String>(Set.of("9688"));
    private Map<String, String> projections;

    public CoordinateOperationSet(AuthorityFactory factory) {
        super(factory);
    }

    public static boolean isExcludedOperation(String operationCode) {
        return EXCLUDED_OPERATIONS.contains(operationCode);
    }

    public boolean addAuthorityCode(String code, String crs) {
        if (crs != null) {
            if (this.projections == null) {
                this.projections = new HashMap<String, String>();
            }
            this.projections.put(code, crs);
        }
        return super.addAuthorityCode(code);
    }

    @Override
    protected IdentifiedObject createObject(String code) throws FactoryException {
        String crs;
        if (this.projections != null && (crs = this.projections.get(code)) != null) {
            return ((CRSAuthorityFactory)this.factory).createProjectedCRS(crs).getConversionFromBase();
        }
        return ((CoordinateOperationAuthorityFactory)this.factory).createCoordinateOperation(code);
    }
}

