/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.List;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.ConicProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.measure.Latitude;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;

public class AlbersEqualArea
extends MapProjection {
    private static final long serialVersionUID = -3024658742514888646L;
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double EPSILON = 1.0E-6;
    private final double n;
    private final double c;
    private final double rho0;
    private final double ec;
    private final double phi1;
    private double phi2;

    protected AlbersEqualArea(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        boolean secant;
        List expected = this.getParameterDescriptors().descriptors();
        this.phi1 = this.doubleValue(expected, Provider.STANDARD_PARALLEL_1, parameters);
        AlbersEqualArea.ensureLatitudeInRange(Provider.STANDARD_PARALLEL_1, this.phi1, true);
        this.phi2 = this.doubleValue(expected, Provider.STANDARD_PARALLEL_2, parameters);
        if (Double.isNaN(this.phi2)) {
            this.phi2 = this.phi1;
        }
        AlbersEqualArea.ensureLatitudeInRange(Provider.STANDARD_PARALLEL_2, this.phi2, true);
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-6) {
            Latitude arg0 = new Latitude(Math.toDegrees(this.phi1));
            Latitude arg1 = new Latitude(Math.toDegrees(this.phi2));
            throw new IllegalArgumentException(MessageFormat.format("Latitudes {0} and {1} are opposite.", arg0, arg1));
        }
        double sinphi = Math.sin(this.phi1);
        double cosphi = Math.cos(this.phi1);
        double n = sinphi;
        boolean bl = secant = Math.abs(this.phi1 - this.phi2) >= 1.0E-6;
        if (this.isSpherical) {
            if (secant) {
                n = 0.5 * (n + Math.sin(this.phi2));
            }
            this.c = cosphi * cosphi + n * 2.0 * sinphi;
            this.rho0 = Math.sqrt(this.c - n * 2.0 * Math.sin(this.latitudeOfOrigin)) / n;
            this.ec = Double.NaN;
        } else {
            double m1 = this.msfn(sinphi, cosphi);
            double q1 = this.qsfn(sinphi);
            if (secant) {
                sinphi = Math.sin(this.phi2);
                cosphi = Math.cos(this.phi2);
                double m2 = this.msfn(sinphi, cosphi);
                double q2 = this.qsfn(sinphi);
                n = (m1 * m1 - m2 * m2) / (q2 - q1);
            }
            this.c = m1 * m1 + n * q1;
            this.rho0 = Math.sqrt(this.c - n * this.qsfn(Math.sin(this.latitudeOfOrigin))) / n;
            this.ec = 1.0 - 0.5 * (1.0 - this.excentricitySquared) * Math.log((1.0 - this.excentricity) / (1.0 + this.excentricity)) / this.excentricity;
        }
        this.n = n;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        List expected = this.getParameterDescriptors().descriptors();
        this.set(expected, Provider.STANDARD_PARALLEL_1, values, this.phi1);
        this.set(expected, Provider.STANDARD_PARALLEL_2, values, this.phi2);
        return values;
    }

    @Override
    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        x *= this.n;
        double rho = this.isSpherical ? this.c - this.n * 2.0 * Math.sin(y) : this.c - this.n * this.qsfn(Math.sin(y));
        if (rho < 0.0) {
            if (rho > -1.0E-6) {
                rho = 0.0;
            } else {
                throw new ProjectionException("Tolerance error.");
            }
        }
        rho = Math.sqrt(rho) / this.n;
        y = this.rho0 - rho * Math.cos(x);
        x = rho * Math.sin(x);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho = Math.hypot(x, y = this.rho0 - y);
        if (rho > 1.0E-6) {
            if (this.n < 0.0) {
                rho = -rho;
                x = -x;
                y = -y;
            }
            x = Math.atan2(x, y) / this.n;
            y = rho * this.n;
            y = this.isSpherical ? (Math.abs(y = (this.c - y * y) / (this.n * 2.0)) <= 1.0 ? Math.asin(y) : (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966)) : (Math.abs(this.ec - Math.abs(y = (this.c - y * y) / this.n)) > 1.0E-6 ? this.phi1(y) : (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966));
        } else {
            x = 0.0;
            double d = y = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    private double phi1(double qs) throws ProjectionException {
        double tone_es = 1.0 - this.excentricitySquared;
        double phi = Math.asin(0.5 * qs);
        if (this.excentricity < 1.0E-6) {
            return phi;
        }
        for (int i = 0; i < 15; ++i) {
            double sinpi = Math.sin(phi);
            double cospi = Math.cos(phi);
            double con = this.excentricity * sinpi;
            double com = 1.0 - con * con;
            double dphi = 0.5 * com * com / cospi * (qs / tone_es - sinpi / com + 0.5 / this.excentricity * Math.log((1.0 - con) / (1.0 + con)));
            phi += dphi;
            if (!(Math.abs(dphi) <= 1.0E-10)) continue;
            return phi;
        }
        throw new ProjectionException("Transformation doesn't convergence.");
    }

    private double qsfn(double sinphi) {
        double one_es = 1.0 - this.excentricitySquared;
        if (this.excentricity >= 1.0E-6) {
            double con = this.excentricity * sinphi;
            return one_es * (sinphi / (1.0 - con * con) - 0.5 / this.excentricity * Math.log((1.0 - con) / (1.0 + con)));
        }
        return sinphi + sinphi;
    }

    @Override
    public int hashCode() {
        long code = Double.doubleToLongBits(this.c);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            AlbersEqualArea that = (AlbersEqualArea)object;
            return AlbersEqualArea.equals(this.n, that.n) && AlbersEqualArea.equals(this.c, that.c) && AlbersEqualArea.equals(this.rho0, that.rho0) && AlbersEqualArea.equals(this.phi1, that.phi1) && AlbersEqualArea.equals(this.phi2, that.phi2);
        }
        return false;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -7489679528438418778L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Albers_Conic_Equal_Area"), new NamedIdentifier(Citations.EPSG, "Albers Equal Area"), new NamedIdentifier(Citations.EPSG, "9822"), new NamedIdentifier(Citations.GEOTIFF, "CT_AlbersEqualArea"), new NamedIdentifier(Citations.ESRI, "Albers"), new NamedIdentifier(Citations.ESRI, "Albers Equal Area Conic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)3)), new NamedIdentifier(Citations.PROJ, "aea")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<ConicProjection> getOperationType() {
            return ConicProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new AlbersEqualArea(parameters);
        }
    }
}

