/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PdfAllowedTagRelations {
    public static final String NUMBERED_HEADER = "Hn";
    public static final String ACTUAL_CONTENT = "CONTENT";
    private static final Pattern numberedHeaderPattern = Pattern.compile("H(\\d+)");
    protected final Map<String, Collection<String>> allowedParentChildRelations = new HashMap<String, Collection<String>>();

    public PdfAllowedTagRelations() {
        this.allowedParentChildRelations.put("StructTreeRoot", Collections.singleton("Document"));
        this.allowedParentChildRelations.put("Document", Arrays.asList("Document", "DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Link", "Annot", "Form", "FENote", "Index", "L", "Table", "Figure", "Formula", "Artifact"));
        this.allowedParentChildRelations.put("DocumentFragment", Arrays.asList("Document", "DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Link", "Annot", "Form", "FENote", "Index", "L", "Table", "Figure", "Formula", "Artifact"));
        this.allowedParentChildRelations.put("Part", Arrays.asList("Document", "DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "TOCI", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Sub", "Lbl", "Link", "Reference", "Annot", "Form", "FENote", "Index", "L", "BibEntry", "Table", "Caption", "Figure", "Formula", "Artifact"));
        this.allowedParentChildRelations.put("Div", Arrays.asList("Document", "DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "TOCI", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "RB", "RT", "RP", "Warichu", "WT", "WP", "FENote", "Index", "L", "LI", "LBody", "BibEntry", "Table", "TR", "TH", "TD", "THead", "TBody", "TFoot", "Caption", "Figure", "Formula", "Artifact"));
        this.allowedParentChildRelations.put("Art", Arrays.asList("DocumentFragment", "Part", "Div", "Sect", "TOC", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Lbl", "Link", "Annot", "Form", "FENote", "Index", "L", "Table", "Caption", "Figure", "Formula", "Artifact"));
        this.allowedParentChildRelations.put("Sect", Arrays.asList("DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Lbl", "Link", "Annot", "Form", "FENote", "Index", "L", "Table", "Caption", "Figure", "Formula", "Artifact"));
        this.allowedParentChildRelations.put("TOC", Arrays.asList("Part", "TOC", "TOCI", "NonStruct", "Private", "Caption", "Artifact"));
        this.allowedParentChildRelations.put("TOCI", Arrays.asList("Div", "TOC", "NonStruct", "Private", "P", "Lbl", "Reference", "Artifact"));
        this.allowedParentChildRelations.put("Aside", Arrays.asList("Document", "DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Lbl", "Link", "Reference", "Annot", "Form", "FENote", "Index", "L", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("BlockQuote", Arrays.asList("Document", "DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Lbl", "Link", "Reference", "Annot", "Form", "FENote", "Index", "L", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("NonStruct", Arrays.asList("Document", "DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "TOCI", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "RB", "RT", "RP", "Warichu", "WT", "WP", "FENote", "Index", "L", "LI", "LBody", "BibEntry", "Table", "TR", "TH", "TD", "THead", "TBody", "TFoot", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Private", Arrays.asList("Document", "DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "TOCI", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "RB", "RT", "RP", "Warichu", "WT", "WP", "FENote", "Index", "L", "LI", "LBody", "BibEntry", "Table", "TR", "TH", "TD", "THead", "TBody", "TFoot", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Title", Arrays.asList("Part", "Div", "Aside", "NonStruct", "Private", "P", "Note", "Code", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "L", "BibEntry", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Sub", Arrays.asList("NonStruct", "Private", "Note", "Code", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "L", "BibEntry", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("P", Arrays.asList("NonStruct", "Private", "Note", "Code", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "L", "BibEntry", "Table", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Note", Arrays.asList("DocumentFragment", "Part", "Art", "Div", "Sect", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "Index", "L", "BibEntry", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Code", Arrays.asList("DocumentFragment", "Part", "Div", "NonStruct", "Private", "Note", "Em", "Strong", "Span", "Link", "Reference", "Annot", "FENote", "BibEntry", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put(NUMBERED_HEADER, Arrays.asList("Art", "Sect", "NonStruct", "Private", "Note", "Code", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "BibEntry", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("H", Arrays.asList("Art", "Sect", "NonStruct", "Private", "Note", "Code", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "BibEntry", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Lbl", Arrays.asList("NonStruct", "Private", "Note", "Code", "Sub", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "BibEntry", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Em", Arrays.asList("NonStruct", "Private", "Note", "Code", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "BibEntry", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Strong", Arrays.asList("NonStruct", "Private", "Note", "Code", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "BibEntry", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Span", Arrays.asList("NonStruct", "Private", "Note", "Code", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "BibEntry", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Quote", Arrays.asList("NonStruct", "Private", "Note", "Code", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "BibEntry", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Link", Arrays.asList("DocumentFragment", "Part", "Art", "Div", "Sect", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "L", "BibEntry", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Reference", Arrays.asList("NonStruct", "Private", "Note", "Lbl", "Em", "Strong", "Span", "Link", "Annot", "FENote", "BibEntry", "Figure", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Annot", Arrays.asList("DocumentFragment", "Part", "Art", "Div", "Sect", "Aside", "BlockQuote", "NonStruct", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "L", "BibEntry", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Form", Arrays.asList("Part", "Div", "NonStruct", "Private", "Note", "Code", "Lbl", "Reference", "FENote", "L", "BibEntry", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Ruby", Arrays.asList("NonStruct", "Private", "RB", "RT", "RP", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("RB", Arrays.asList("NonStruct", "Private", "Sub", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("RT", Arrays.asList("NonStruct", "Private", "Sub", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("RP", Arrays.asList("NonStruct", "Private", "Sub", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Warichu", Arrays.asList("NonStruct", "Private", "WT", "WP", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("WT", Arrays.asList("NonStruct", "Private", "Sub", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("WP", Arrays.asList(ACTUAL_CONTENT, "NonStruct", "Private", "Sub", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Figure", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("FENote", Arrays.asList("DocumentFragment", "Part", "Art", "Div", "Sect", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "L", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Index", Arrays.asList("Part", "Div", "Sect", "NonStruct", "Private", "P", "Note", NUMBERED_HEADER, "H", "Reference", "Annot", "FENote", "L", "Table", "Caption", "Figure", "Formula", "Artifact"));
        this.allowedParentChildRelations.put("L", Arrays.asList("NonStruct", "Private", "L", "LI", "Caption", "Artifact"));
        this.allowedParentChildRelations.put("LI", Arrays.asList("Div", "NonStruct", "Private", "Lbl", "LBody", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("LBody", Arrays.asList("Part", "Art", "Div", "Sect", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Sub", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "Index", "L", "BibEntry", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("BibEntry", Arrays.asList("Part", "Div", "NonStruct", "Private", "P", "Note", "Lbl", "Em", "Strong", "Span", "Link", "Reference", "Annot", "FENote", "Figure", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Table", Arrays.asList("NonStruct", "Private", "TR", "THead", "TBody", "TFoot", "Caption", "Artifact"));
        this.allowedParentChildRelations.put("TR", Arrays.asList("NonStruct", "Private", "TH", "TD", "Artifact"));
        this.allowedParentChildRelations.put("TH", Arrays.asList("Art", "Div", "Sect", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "Index", "L", "BibEntry", "Table", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("TD", Arrays.asList("Art", "Div", "Sect", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "Index", "L", "BibEntry", "Table", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("THead", Arrays.asList("NonStruct", "Private", "TR", "Artifact"));
        this.allowedParentChildRelations.put("TBody", Arrays.asList("NonStruct", "Private", "TR", "Artifact"));
        this.allowedParentChildRelations.put("TFoot", Arrays.asList("NonStruct", "Private", "TR", "Artifact"));
        this.allowedParentChildRelations.put("Caption", Arrays.asList("DocumentFragment", "Part", "Art", "Div", "Sect", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "Index", "L", "BibEntry", "Table", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Figure", Arrays.asList("Part", "Art", "Div", "Sect", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "Index", "L", "BibEntry", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Formula", Arrays.asList("Part", "Div", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "Warichu", "FENote", "Index", "L", "BibEntry", "Table", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
        this.allowedParentChildRelations.put("Artifact", Arrays.asList("Document", "DocumentFragment", "Part", "Art", "Div", "Sect", "TOC", "TOCI", "Aside", "BlockQuote", "NonStruct", "Private", "P", "Note", "Code", NUMBERED_HEADER, "H", "Title", "Sub", "Lbl", "Em", "Strong", "Span", "Quote", "Link", "Reference", "Annot", "Form", "Ruby", "RB", "RT", "RP", "Warichu", "WT", "WP", "FENote", "Index", "L", "LI", "LBody", "BibEntry", "Table", "TR", "TH", "TD", "THead", "TBody", "TFoot", "Caption", "Figure", "Formula", "Artifact", ACTUAL_CONTENT));
    }

    public boolean isRelationAllowed(String parentRole, String childRole) {
        Collection<String> allowedChildren = this.allowedParentChildRelations.get(this.normalizeRole(parentRole));
        if (allowedChildren != null) {
            return allowedChildren.contains(this.normalizeRole(childRole));
        }
        throw new IllegalArgumentException("parentRole " + parentRole + " is not a valid structure tree role");
    }

    public boolean isContentAllowedInRole(String parentRole) {
        Collection<String> allowedChildren = this.allowedParentChildRelations.get(this.normalizeRole(parentRole));
        if (allowedChildren != null) {
            return allowedChildren.contains(ACTUAL_CONTENT);
        }
        throw new IllegalArgumentException("parentRole " + parentRole + " is not a valid structure tree role");
    }

    public String normalizeRole(String role) {
        if (role == null) {
            return null;
        }
        if (numberedHeaderPattern.matcher(role).matches()) {
            return NUMBERED_HEADER;
        }
        return role;
    }
}

