/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.entity;

import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.xml.GbavXMLReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class GbavBericht
extends Bericht {
    private static final Log LOG = LogFactory.getLog(GbavXMLReader.class);
    private boolean xpathEvaluated = false;
    private boolean hasAddedBSNHashes = false;
    private String bsn = null;
    private List<String> bsnList = new ArrayList<String>();

    public GbavBericht(String brXml) {
        super(brXml);
        super.setSoort("gbav");
    }

    private void evaluateXPath() {
        if (this.xpathEvaluated) {
            return;
        }
        this.xpathEvaluated = true;
        if (this.datum != null && this.bsn != null && !this.bsnList.isEmpty()) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(this.getBrXml())));
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("persoon/categorieen/categorie[nummer='01']/rubrieken/rubriek[nummer='8220']/waarde/text()");
            this.setDatumAsString(expr.evaluate(doc));
            if (this.getDatum() == null) {
                expr = xpath.compile("persoon/categorieen/categorie[nummer='04']/rubrieken/rubriek[nummer='8220']/waarde/text()");
                this.setDatumAsString(expr.evaluate(doc));
            }
            expr = xpath.compile("persoon/categorieen/categorie[nummer='01']/rubrieken/rubriek[nummer='0120']/waarde/text()");
            this.bsn = expr.evaluate(doc);
            this.bsnList.add(this.bsn);
            expr = xpath.compile("persoon/categorieen/categorie[nummer='02']/rubrieken/rubriek[nummer='0120']/waarde/text()");
            String _bsn = expr.evaluate(doc);
            if (_bsn != null && _bsn != "") {
                this.bsnList.add(_bsn);
            }
            if ((_bsn = (expr = xpath.compile("persoon/categorieen/categorie[nummer='03']/rubrieken/rubriek[nummer='0120']/waarde/text()")).evaluate(doc)) != null && _bsn != "") {
                this.bsnList.add(_bsn);
            }
            if ((_bsn = (expr = xpath.compile("persoon/categorieen/categorie[nummer='05']/rubrieken/rubriek[nummer='0120']/waarde/text()")).evaluate(doc)) != null && _bsn != "") {
                this.bsnList.add(_bsn);
            }
            if ((_bsn = (expr = xpath.compile("persoon/categorieen/categorie[nummer='09']/rubrieken/rubriek[nummer='0120']/waarde/text()")).evaluate(doc)) != null && _bsn != "") {
                this.bsnList.add(_bsn);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Fout tijdens parsen van gbav xml", (Throwable)e);
        }
    }

    public Date parseDatum() {
        this.evaluateXPath();
        return this.datum;
    }

    public String getBsn() {
        this.evaluateXPath();
        return this.bsn;
    }

    public List<String> getBsnList() {
        this.evaluateXPath();
        return this.bsnList;
    }

    public void setBsnMap(Map<String, String> bsnHashes) {
        if (!this.hasAddedBSNHashes) {
            StringBuilder sb = new StringBuilder("<bsnhashes>\n");
            for (Map.Entry<String, String> entry : bsnHashes.entrySet()) {
                if (entry.getKey().isEmpty() || entry.getValue().isEmpty()) continue;
                sb.append("<").append("NL.BRP.Persoon.").append(entry.getKey()).append('>').append(entry.getValue()).append("</").append("NL.BRP.Persoon.").append(entry.getKey()).append(">\n");
            }
            sb.append("</bsnhashes>\n");
            this.hasAddedBSNHashes = true;
            LOG.debug((Object)("toevoegen bsn hashes aan br_xml: " + String.valueOf(sb)));
            sb.insert(0, "<root>\n");
            int endOfProlog = this.getBrXml().indexOf("?>");
            endOfProlog = endOfProlog > 0 ? (endOfProlog += 2) : 0;
            StringBuilder br = new StringBuilder(this.getBrXml());
            br.insert(endOfProlog, sb).append("</root>");
            this.setBrXml(br.toString());
        }
    }

    public void setDatumAsString(String d) {
        if (d == null || d.isEmpty()) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            this.datum = sdf.parse(d);
        }
        catch (ParseException pe) {
            LOG.error((Object)("Error while parsing date: " + String.valueOf(this.datum)), (Throwable)pe);
        }
    }
}

