/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractTrueTypeFontModifier {
    private static final String[] TABLE_NAMES_SUBSET = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep", "cmap", "OS/2"};
    private static final String[] TABLE_NAMES = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep", "cmap", "OS/2", "name", "post"};
    private static final int[] ENTRY_SELECTORS = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4};
    private static final int TABLE_CHECKSUM = 0;
    private static final int TABLE_OFFSET = 1;
    private static final int TABLE_LENGTH = 2;
    private static final int HEAD_LOCA_FORMAT_OFFSET = 51;
    protected Map<String, int[]> tableDirectory;
    protected Map<Integer, byte[]> glyphDataMap;
    protected final Map<String, byte[]> modifiedTables = new HashMap<String, byte[]>();
    protected RandomAccessFileOrArray raf;
    protected int directoryOffset;
    protected final String fontName;
    private FontRawData outFont;
    private final String[] tableNames;

    AbstractTrueTypeFontModifier(String fontName, boolean subsetTables) {
        this.tableNames = subsetTables ? TABLE_NAMES_SUBSET : TABLE_NAMES;
        this.fontName = fontName;
    }

    byte[] process() throws IOException {
        try {
            this.createTableDirectory();
            this.mergeTables();
            this.assembleFont();
            byte[] byArray = this.outFont.getData();
            return byArray;
        }
        finally {
            try {
                this.raf.close();
            }
            catch (Exception exception) {}
        }
    }

    abstract void mergeTables() throws IOException;

    protected void createNewGlyfAndLocaTables() throws IOException {
        int[] activeGlyphs = new int[this.glyphDataMap.size()];
        int i = 0;
        int glyfSize = 0;
        for (Map.Entry<Integer, byte[]> entry : this.glyphDataMap.entrySet()) {
            activeGlyphs[i++] = entry.getKey();
            glyfSize += entry.getValue().length;
        }
        Arrays.sort(activeGlyphs);
        int locaSize = activeGlyphs[activeGlyphs.length - 1] + 2;
        boolean isLocaShortTable = this.isLocaShortTable();
        int newLocaTableSize = isLocaShortTable ? locaSize * 2 : locaSize * 4;
        byte[] newLoca = new byte[newLocaTableSize + 3 & 0xFFFFFFFC];
        byte[] newGlyf = new byte[glyfSize + 3 & 0xFFFFFFFC];
        int glyfPtr = 0;
        int listGlyf = 0;
        for (int k = 0; k < locaSize; ++k) {
            AbstractTrueTypeFontModifier.writeToLoca(newLoca, k, glyfPtr, isLocaShortTable);
            if (listGlyf >= activeGlyphs.length || activeGlyphs[listGlyf] != k) continue;
            ++listGlyf;
            byte[] glyphData = this.glyphDataMap.get(k);
            System.arraycopy(glyphData, 0, newGlyf, glyfPtr, glyphData.length);
            glyfPtr += glyphData.length;
        }
        this.modifiedTables.put("glyf", newGlyf);
        this.modifiedTables.put("loca", newLoca);
    }

    private void createTableDirectory() throws IOException {
        this.tableDirectory = new HashMap<String, int[]>();
        this.raf.seek(this.directoryOffset);
        int id = this.raf.readInt();
        if (id != 65536) {
            throw new com.itextpdf.io.exceptions.IOException("{0} is not a true type file").setMessageParams(this.fontName);
        }
        int numTables = this.raf.readUnsignedShort();
        this.raf.skipBytes(6);
        for (int k = 0; k < numTables; ++k) {
            String tag = this.readTag();
            int[] tableLocation = new int[]{this.raf.readInt(), this.raf.readInt(), this.raf.readInt()};
            this.tableDirectory.put(tag, tableLocation);
        }
    }

    private boolean isLocaShortTable() throws IOException {
        int[] tableLocation = this.tableDirectory.get("head");
        if (tableLocation == null) {
            throw new com.itextpdf.io.exceptions.IOException("Table {0} does not exist in {1}").setMessageParams("head", this.fontName);
        }
        this.raf.seek(tableLocation[1] + 51);
        return this.raf.readUnsignedShort() == 0;
    }

    private void assembleFont() throws IOException {
        int[] tableLocation;
        int fullFontSize = 0;
        int tablesUsed = this.modifiedTables.size();
        for (String name : this.tableNames) {
            if (this.modifiedTables.containsKey(name) || (tableLocation = this.tableDirectory.get(name)) == null) continue;
            ++tablesUsed;
            fullFontSize += tableLocation[2] + 3 & 0xFFFFFFFC;
        }
        for (byte[] table : this.modifiedTables.values()) {
            fullFontSize += table.length;
        }
        int reference = 16 * tablesUsed + 12;
        this.outFont = new FontRawData(fullFontSize += reference);
        this.outFont.writeFontInt(65536);
        this.outFont.writeFontShort(tablesUsed);
        int selector = ENTRY_SELECTORS[tablesUsed];
        this.outFont.writeFontShort((1 << selector) * 16);
        this.outFont.writeFontShort(selector);
        this.outFont.writeFontShort((tablesUsed - (1 << selector)) * 16);
        for (String name : this.tableNames) {
            int len;
            tableLocation = this.tableDirectory.get(name);
            if (tableLocation == null) continue;
            this.outFont.writeFontString(name);
            if (this.modifiedTables.containsKey(name)) {
                byte[] table = this.modifiedTables.get(name);
                this.outFont.writeFontInt(this.calculateChecksum(table));
                len = table.length;
            } else {
                this.outFont.writeFontInt(tableLocation[0]);
                len = tableLocation[2];
            }
            this.outFont.writeFontInt(reference);
            this.outFont.writeFontInt(len);
            reference += len + 3 & 0xFFFFFFFC;
        }
        for (String name : this.tableNames) {
            tableLocation = this.tableDirectory.get(name);
            if (tableLocation == null) continue;
            if (this.modifiedTables.containsKey(name)) {
                byte[] table = this.modifiedTables.get(name);
                this.outFont.writeFontTable(table);
                continue;
            }
            this.raf.seek(tableLocation[1]);
            this.outFont.writeFontTable(this.raf, tableLocation[2]);
        }
    }

    private String readTag() throws IOException {
        byte[] buf = new byte[4];
        this.raf.readFully(buf);
        try {
            return new String(buf, "Cp1252");
        }
        catch (Exception e) {
            throw new com.itextpdf.io.exceptions.IOException("TrueType font", e);
        }
    }

    private static void writeToLoca(byte[] loca, int index, int location, boolean isLocaShortTable) {
        if (isLocaShortTable) {
            loca[index *= 2] = (byte)((location /= 2) >> 8);
            loca[index + 1] = (byte)location;
        } else {
            loca[index *= 4] = (byte)(location >> 24);
            loca[index + 1] = (byte)(location >> 16);
            loca[index + 2] = (byte)(location >> 8);
            loca[index + 3] = (byte)location;
        }
    }

    private int calculateChecksum(byte[] b) {
        int len = b.length / 4;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        int ptr = 0;
        for (int k = 0; k < len; ++k) {
            v3 += b[ptr++] & 0xFF;
            v2 += b[ptr++] & 0xFF;
            v1 += b[ptr++] & 0xFF;
            v0 += b[ptr++] & 0xFF;
        }
        return v0 + (v1 << 8) + (v2 << 16) + (v3 << 24);
    }

    private static class FontRawData {
        private final byte[] data;
        private int ptr;

        FontRawData(int size) {
            this.data = new byte[size];
            this.ptr = 0;
        }

        public byte[] getData() {
            return this.data;
        }

        void writeFontTable(RandomAccessFileOrArray raf, int tableLength) throws IOException {
            raf.readFully(this.data, this.ptr, tableLength);
            this.ptr += tableLength + 3 & 0xFFFFFFFC;
        }

        void writeFontTable(byte[] tableData) {
            System.arraycopy(tableData, 0, this.data, this.ptr, tableData.length);
            this.ptr += tableData.length;
        }

        void writeFontShort(int n) {
            this.data[this.ptr++] = (byte)(n >> 8);
            this.data[this.ptr++] = (byte)n;
        }

        void writeFontInt(int n) {
            this.data[this.ptr++] = (byte)(n >> 24);
            this.data[this.ptr++] = (byte)(n >> 16);
            this.data[this.ptr++] = (byte)(n >> 8);
            this.data[this.ptr++] = (byte)n;
        }

        void writeFontString(String s) {
            byte[] b = PdfEncodings.convertToBytes(s, "Cp1252");
            System.arraycopy(b, 0, this.data, this.ptr, b.length);
            this.ptr += b.length;
        }
    }
}

