/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.api.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.FeatureEvent;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.WeakHashSet;
import org.geotools.util.logging.Logging;

public class BatchFeatureEvent
extends FeatureEvent {
    static final Logger LOGGER = Logging.getLogger(BatchFeatureEvent.class);
    private static final long serialVersionUID = 3154238322369916486L;
    protected WeakHashSet<Identifier> fids = new WeakHashSet(Identifier.class);

    public BatchFeatureEvent(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        this(featureSource, new ReferencedEnvelope(), (Filter)Filter.EXCLUDE);
    }

    public BatchFeatureEvent(FeatureSource<? extends FeatureType, ? extends Feature> featureSource, ReferencedEnvelope bounds, Filter filter) {
        super(featureSource, FeatureEvent.Type.COMMIT, bounds, filter);
    }

    public void setType(FeatureEvent.Type type) {
        this.type = type;
    }

    public void add(FeatureEvent change) {
        if (change.getType() == FeatureEvent.Type.ADDED) {
            if (change.getFilter() instanceof Id) {
                Id newFeatureIds = (Id)change.getFilter();
                this.fids.addAll((Collection)newFeatureIds.getIdentifiers());
            } else {
                LOGGER.log(Level.FINE, "Found added features without an id filter associated with them: {0}", change.getFilter());
            }
        }
        if (this.filter == Filter.INCLUDE || this.bounds == ReferencedEnvelope.EVERYTHING) {
            return;
        }
        if (change.getFilter() == Filter.INCLUDE || change.getBounds() == ReferencedEnvelope.EVERYTHING) {
            this.filter = Filter.INCLUDE;
            this.bounds = ReferencedEnvelope.EVERYTHING;
            return;
        }
        this.bounds.expandToInclude(change.getBounds());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        if (this.filter == Filter.EXCLUDE) {
            this.filter = change.getFilter();
        } else if (this.filter instanceof And) {
            And and = (And)this.filter;
            ArrayList<Filter> children = new ArrayList<Filter>(and.getChildren());
            children.add(change.getFilter());
            this.filter = ff.and(children);
        } else {
            this.filter = ff.and(this.filter, change.getFilter());
        }
    }

    public void replaceFid(String tempFid, String actualFid) {
        for (Identifier id : this.fids) {
            if (!tempFid.equals(id.getID()) || !(id instanceof FeatureIdImpl)) continue;
            FeatureIdImpl featureId = (FeatureIdImpl)id;
            featureId.setID(actualFid);
        }
    }

    public WeakHashSet<Identifier> getCreatedFeatureIds() {
        return this.fids;
    }
}

