/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.measure.Units;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.styling.visitor.Measure;
import org.geotools.styling.visitor.RescalingMode;

public class UomRescaleStyleVisitor
extends DuplicatingStyleVisitor {
    double mapScale;

    public UomRescaleStyleVisitor(double mapScale) {
        if (mapScale <= 0.0) {
            throw new IllegalArgumentException("The mapScale is out of range. Value is " + Double.toString(mapScale) + ". It must be positive.");
        }
        this.mapScale = mapScale;
    }

    protected Expression rescale(Expression unscaled, Unit<Length> uom) {
        if (unscaled == null || unscaled.equals(Expression.NIL)) {
            return unscaled;
        }
        Measure m = new Measure(unscaled, uom);
        return RescalingMode.RealWorld.rescaleToExpression((Expression)this.ff.literal(this.mapScale), m);
    }

    protected List<Expression> rescaleDashArray(List<Expression> expressions, Unit<Length> uom) {
        if (expressions == null || expressions.isEmpty()) {
            return expressions;
        }
        ArrayList<Expression> rescaled = new ArrayList<Expression>(expressions.size());
        Expression scale = this.rescale((Expression)this.ff.literal(1), uom);
        for (Expression expression : expressions) {
            Function rescale = this.ff.function("listMultiply", new Expression[]{scale, expression});
            if (expression instanceof Literal) {
                rescaled.add((Expression)this.ff.literal(rescale.evaluate(null)));
                continue;
            }
            rescaled.add((Expression)rescale);
        }
        return rescaled;
    }

    protected String rescale(String unscaled, Unit<Length> uom) {
        if (unscaled == null) {
            return unscaled;
        }
        Measure v = new Measure(unscaled, uom);
        return RescalingMode.RealWorld.rescaleToString(this.mapScale, v);
    }

    protected void rescaleStroke(Stroke stroke, Unit<Length> uom) {
        if (stroke != null) {
            stroke.setWidth(this.rescale(stroke.getWidth(), uom));
            stroke.setDashArray(this.rescaleDashArray(stroke.dashArray(), uom));
            stroke.setDashOffset(this.rescale(stroke.getDashOffset(), uom));
            this.rescale(stroke.getGraphicFill(), uom);
            this.rescale(stroke.getGraphicStroke(), uom);
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        super.visit(ps);
        PointSymbolizer copy = (PointSymbolizer)this.pages.peek();
        Unit uom = copy.getUnitOfMeasure();
        Graphic copyGraphic = copy.getGraphic();
        this.rescale(copyGraphic, (Unit<Length>)uom);
        copy.setUnitOfMeasure(Units.PIXEL);
    }

    private void rescale(Graphic graphic, Unit<Length> unit) {
        if (graphic != null) {
            graphic.setSize(this.rescale(graphic.getSize(), unit));
            graphic.setGap(this.rescale(graphic.getGap(), unit));
            Displacement disp = graphic.getDisplacement();
            if (disp != null) {
                disp.setDisplacementX(this.rescale(disp.getDisplacementX(), unit));
                disp.setDisplacementY(this.rescale(disp.getDisplacementY(), unit));
                graphic.setDisplacement(disp);
            }
            if (graphic.graphicalSymbols() != null) {
                for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
                    if (!(gs instanceof Mark)) continue;
                    Mark mark = (Mark)gs;
                    this.rescaleStroke(mark.getStroke(), unit);
                    this.rescaleFill(mark.getFill(), unit);
                }
            }
        }
    }

    @Override
    public void visit(LineSymbolizer line) {
        super.visit(line);
        LineSymbolizer copy = (LineSymbolizer)this.pages.peek();
        Unit uom = copy.getUnitOfMeasure();
        Stroke copyStroke = copy.getStroke();
        this.rescaleStroke(copyStroke, (Unit<Length>)uom);
        copy.setPerpendicularOffset(this.rescale(copy.getPerpendicularOffset(), (Unit<Length>)uom));
        copy.setUnitOfMeasure(Units.PIXEL);
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        super.visit(poly);
        PolygonSymbolizer copy = (PolygonSymbolizer)this.pages.peek();
        Unit uom = copy.getUnitOfMeasure();
        this.rescaleStroke(copy.getStroke(), (Unit<Length>)uom);
        this.rescaleFill(copy.getFill(), (Unit<Length>)uom);
        this.scaleIntArrayOption(copy.getOptions(), "graphic-margin", (Unit<Length>)uom);
        copy.setUnitOfMeasure(Units.PIXEL);
    }

    private void rescaleFill(Fill copyFill, Unit<Length> unit) {
        if (copyFill != null) {
            this.rescale(copyFill.getGraphicFill(), unit);
        }
    }

    @Override
    public void visit(TextSymbolizer text) {
        super.visit(text);
        TextSymbolizer copy = (TextSymbolizer)this.pages.peek();
        Unit uom = copy.getUnitOfMeasure();
        for (Font font : copy.fonts()) {
            font.setSize(this.rescale(font.getSize(), (Unit<Length>)uom));
        }
        LabelPlacement placement = copy.getLabelPlacement();
        if (placement instanceof PointPlacement) {
            PointPlacement pointPlacement = (PointPlacement)placement;
            Displacement disp = pointPlacement.getDisplacement();
            if (disp != null) {
                disp.setDisplacementX(this.rescale(disp.getDisplacementX(), (Unit<Length>)uom));
                disp.setDisplacementY(this.rescale(disp.getDisplacementY(), (Unit<Length>)uom));
                pointPlacement.setDisplacement(disp);
            }
        } else if (placement instanceof LinePlacement) {
            LinePlacement linePlacement = (LinePlacement)placement;
            linePlacement.setGap(this.rescale(linePlacement.getGap(), (Unit<Length>)uom));
            linePlacement.setInitialGap(this.rescale(linePlacement.getInitialGap(), (Unit<Length>)uom));
            linePlacement.setPerpendicularOffset(this.rescale(linePlacement.getPerpendicularOffset(), (Unit<Length>)uom));
        }
        copy.setLabelPlacement(placement);
        if (copy.getHalo() != null) {
            copy.getHalo().setRadius(this.rescale(copy.getHalo().getRadius(), (Unit<Length>)uom));
        }
        this.rescale(copy.getGraphic(), (Unit<Length>)uom);
        Map options = copy.getOptions();
        this.scaleIntOption(options, "maxDisplacement", (Unit<Length>)uom);
        this.scaleIntOption(options, "spaceAround", (Unit<Length>)uom);
        this.scaleIntOption(options, "minGroupDistance", (Unit<Length>)uom);
        this.scaleIntOption(options, "repeat", (Unit<Length>)uom);
        this.scaleIntOption(options, "autoWrap", (Unit<Length>)uom);
        this.scaleIntArrayOption(options, "graphic-margin", (Unit<Length>)uom);
        copy.setUnitOfMeasure(Units.PIXEL);
    }

    private void scaleIntOption(Map<String, String> options, String optionName, Unit<Length> uom) {
        String strValue;
        if (options.containsKey(optionName) && (strValue = options.get(optionName)) != null) {
            options.put(optionName, this.toInt(this.rescale(strValue, uom)));
        }
    }

    private void scaleIntArrayOption(Map<String, String> options, String optionName, Unit<Length> uom) {
        String strValue;
        if (options.containsKey(optionName) && (strValue = options.get(optionName)) != null) {
            String[] splitted = strValue.split("\\s+");
            StringBuilder sb = new StringBuilder();
            for (String value : splitted) {
                String rescaled = this.rescale(value, uom);
                sb.append(this.toInt(rescaled)).append(" ");
            }
            sb.setLength(sb.length() - 1);
            options.put(optionName, sb.toString());
        }
    }

    String toInt(String value) {
        Double dv = Double.valueOf(value);
        return String.valueOf(dv.intValue());
    }
}

