--
-- BRMO RSGB script voor oracle
-- Applicatie versie: 1.4.3
-- Gegenereerd op 2017-03-03T13:28:09.381+01:00
--


-- voor ander tooling dan sqldeveloper define evt. uitzetten omdat er ampersand 
--   tekens in sommige gemeente/plaats/buurt namen voorkomen.
set define off;

create table sbi_activiteit(
	omschr varchar2(60),
	sbi_code varchar2(6) not null
);
alter table sbi_activiteit add constraint sbi_activiteit_pk primary key(sbi_code);

comment on table sbi_activiteit is 'RSGB referentielijst SBI ACTIVITEIT';
comment on column sbi_activiteit.omschr is 'Referentielijst property SBI ACTIVITEIT.Omschrijving - Omschrijving';
comment on column sbi_activiteit.sbi_code is 'Referentielijst property SBI ACTIVITEIT.SBI code - SBI code';

create table aard_recht_verkort(
	aand varchar2(4) not null,
	omschr varchar2(100)
);
alter table aard_recht_verkort add constraint aard_recht_verkort_pk primary key(aand);

comment on table aard_recht_verkort is 'RSGB referentielijst AARD RECHT VERKORT';
comment on column aard_recht_verkort.aand is 'Referentielijst property AARD RECHT VERKORT.Aanduiding aard recht verkort - Aanduiding aard recht verkort';
comment on column aard_recht_verkort.omschr is 'Referentielijst property AARD RECHT VERKORT.Omschrijving aard recht verkort - Omschrijving aard recht verkort';

create table aard_verkregen_recht(
	aand varchar2(6) not null,
	omschr_aard_verkregenr_recht varchar2(200)
);
alter table aard_verkregen_recht add constraint aard_verkregen_recht_pk primary key(aand);

comment on table aard_verkregen_recht is 'RSGB referentielijst AARD VERKREGEN RECHT';
comment on column aard_verkregen_recht.aand is 'Referentielijst property AARD VERKREGEN RECHT.Aanduiding aard verkregen recht - Aanduiding aard verkregen recht';
comment on column aard_verkregen_recht.omschr_aard_verkregenr_recht is 'Referentielijst property AARD VERKREGEN RECHT.Omschrijving aard verkregenr recht - Omschrijving aard verkregenr recht';

create table academische_titel(
	code varchar2(3) not null,
	dat_beg_geldh_titel varchar2(19),
	datum_einde_geldh_titel varchar2(19),
	omschr varchar2(80),
	positie_tov_naam varchar2(1)
);
alter table academische_titel add constraint academische_titel_pk primary key(code);

comment on table academische_titel is 'RSGB referentielijst ACADEMISCHE TITEL';
comment on column academische_titel.code is 'Referentielijst property ACADEMISCHE TITEL.Academische titelcode - Academische titelcode';
comment on column academische_titel.dat_beg_geldh_titel is 'Referentielijst property ACADEMISCHE TITEL.Datum begin geldigheid titel - Datum begin geldigheid titel';
comment on column academische_titel.datum_einde_geldh_titel is 'Referentielijst property ACADEMISCHE TITEL.Datum einde geldigheid titel - Datum einde geldigheid titel';
comment on column academische_titel.omschr is 'Referentielijst property ACADEMISCHE TITEL.Omschrijving academische titel - Omschrijving academische titel';
comment on column academische_titel.positie_tov_naam is 'Referentielijst property ACADEMISCHE TITEL.Positie academische titel tov naam - Positie academische titel tov naam';

create table land(
	eindd varchar2(19),
	ingangsdatum varchar2(19),
	code decimal(4,0),
	code_iso varchar2(2) not null,
	naam varchar2(40)
);
alter table land add constraint land_pk primary key(code_iso);

comment on table land is 'RSGB referentielijst LAND';
comment on column land.eindd is 'Referentielijst property LAND.Einddatum land - Einddatum land';
comment on column land.ingangsdatum is 'Referentielijst property LAND.Ingangsdatum land - Ingangsdatum land';
comment on column land.code is 'Referentielijst property LAND.Landcode - Landcode';
comment on column land.code_iso is 'Referentielijst property LAND.Landcode ISO - Landcode ISO';
comment on column land.naam is 'Referentielijst property LAND.Landnaam - Landnaam';

create table nation(
	begindatum_geldh varchar2(19),
	eindd_geldh varchar2(19),
	code decimal(4,0) not null,
	omschr varchar2(42)
);
alter table nation add constraint nation_pk primary key(code);

comment on table nation is 'RSGB referentielijst NATIONALITEIT';
comment on column nation.begindatum_geldh is 'Referentielijst property NATIONALITEIT.Begindatum geldigheid nationaliteit - Begindatum geldigheid nationaliteit';
comment on column nation.eindd_geldh is 'Referentielijst property NATIONALITEIT.Einddatum geldigheid nationaliteit - Einddatum geldigheid nationaliteit';
comment on column nation.code is 'Referentielijst property NATIONALITEIT.Nationaliteitcode - Nationaliteitcode';
comment on column nation.omschr is 'Referentielijst property NATIONALITEIT.Nationaliteitomschrijving - Nationaliteitomschrijving';

create table rsdocsoort(
	begindatum_geldh varchar2(19),
	eindd_geldh varchar2(19),
	rsdoccode varchar2(2) not null,
	rsdocomschr varchar2(80)
);
alter table rsdocsoort add constraint rsdocsoort_pk primary key(rsdoccode);

comment on table rsdocsoort is 'RSGB referentielijst REISDOCUMENTSOORT';
comment on column rsdocsoort.begindatum_geldh is 'Referentielijst property REISDOCUMENTSOORT.Begindatum geldigheid reisdocumentsoort - Begindatum geldigheid reisdocumentsoort';
comment on column rsdocsoort.eindd_geldh is 'Referentielijst property REISDOCUMENTSOORT.Einddatum geldigheid reisdocumentsoort - Einddatum geldigheid reisdocumentsoort';
comment on column rsdocsoort.rsdoccode is 'Referentielijst property REISDOCUMENTSOORT.Reisdocumentcode - Reisdocumentcode';
comment on column rsdocsoort.rsdocomschr is 'Referentielijst property REISDOCUMENTSOORT.Reisdocumentomschrijving - Reisdocumentomschrijving';

create table addresseerb_obj_aand(
	dat_beg_geldh varchar2(19),
	identif varchar2(16) not null,
	clazz varchar2(255),
	dat_eind_geldh varchar2(19),
	huisletter varchar2(1),
	huinummer decimal(5,0),
	huinummertoevoeging varchar2(4),
	postcode varchar2(6),
	fk_6wpl_identif varchar2(4),
	fk_7opr_identifcode varchar2(16)
);
alter table addresseerb_obj_aand add constraint addresseerb_obj_aand_pk primary key(identif);

comment on table addresseerb_obj_aand is 'RSGB class ADRESSEERBAAR OBJECT AANDUIDING. Directe superclass van: NUMMERAANDUIDING, OVERIGE ADRESSEERBAAR OBJECT AANDUIDING';
comment on column addresseerb_obj_aand.identif is '[PK] AN16 - Identificatie adresseerbaar object aanduiding';
comment on column addresseerb_obj_aand.clazz is 'Aanduiding subclass';
comment on column addresseerb_obj_aand.dat_eind_geldh is 'OnvolledigeDatum - Datum einde geldigheid addresserbaar object aanduiding';
comment on column addresseerb_obj_aand.huisletter is 'AN1 - Huisletter';
comment on column addresseerb_obj_aand.huinummer is 'N5 - Huisnummer';
comment on column addresseerb_obj_aand.huinummertoevoeging is 'AN4 - Huisnummertoevoeging';
comment on column addresseerb_obj_aand.postcode is 'AN6 - Postcode';
comment on column addresseerb_obj_aand.fk_6wpl_identif is '[FK] AN4, FK naar wnplts.identif: "ligt in"';
comment on column addresseerb_obj_aand.fk_7opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "ligt aan"';

create table ander_btnlnds_niet_nat_prs(
	sc_identif varchar2(32) not null
);
alter table ander_btnlnds_niet_nat_prs add constraint ander_btnlnds_niet_nat_prs_pk primary key(sc_identif);

comment on table ander_btnlnds_niet_nat_prs is 'RSGB class ANDER BUITENLANDS NIET-NATUURLIJK PERSOON. Subclass van: NIET-NATUURLIJK PERSOON -> PERSOON -> SUBJECT';
comment on column ander_btnlnds_niet_nat_prs.sc_identif is '[PK] AN32, FK naar niet_nat_prs.sc_identif - Identificatie';

create table ander_nat_prs(
	sc_identif varchar2(32) not null,
	geboortedatum decimal(8,0),
	overlijdensdatum decimal(8,0),
	fk_3aoa_identif varchar2(16)
);
alter table ander_nat_prs add constraint ander_nat_prs_pk primary key(sc_identif);

comment on table ander_nat_prs is 'RSGB class ANDER NATUURLIJK PERSOON. Subclass van: NATUURLIJK PERSOON -> PERSOON -> SUBJECT';
comment on column ander_nat_prs.sc_identif is '[PK] AN32, FK naar nat_prs.sc_identif - Identificatie';
comment on column ander_nat_prs.geboortedatum is 'N8 - Geboortedatum';
comment on column ander_nat_prs.overlijdensdatum is 'N8 - Overlijdensdatum';
comment on column ander_nat_prs.fk_3aoa_identif is '[FK] AN16, FK naar addresseerb_obj_aand.identif: "heeft als bezoekadres"';

create table app_re(
	sc_kad_identif decimal(15,0) not null,
	fk_2nnp_sc_identif varchar2(32),
	ka_appartementsindex varchar2(4),
	ka_kad_gemeentecode varchar2(5),
	ka_perceelnummer varchar2(15),
	ka_sectie varchar2(255)
);
alter table app_re add constraint app_re_pk primary key(sc_kad_identif);

comment on table app_re is 'RSGB class APPARTEMENTSRECHT. Subclass van: KADASTRALE ONROERENDE ZAAK';
comment on column app_re.sc_kad_identif is '[PK] N15, FK naar kad_onrrnd_zk.kad_identif - Kadastrale identificatie';
comment on column app_re.fk_2nnp_sc_identif is '[FK] AN32, FK naar niet_nat_prs.sc_identif (is FK naar superclass SUBJECT): "maakt deel uit van appartementencomplex met als vereniging van eigenaars"';
comment on column app_re.ka_appartementsindex is 'Groepsattribuut Kadastrale aanduiding APPARTEMENTSRECHT.Appartementsindex - Appartementsindex';
comment on column app_re.ka_kad_gemeentecode is 'Groepsattribuut Kadastrale aanduiding APPARTEMENTSRECHT.Kadastrale gemeentecode - Kadastrale gemeentecode';
comment on column app_re.ka_perceelnummer is 'Groepsattribuut Kadastrale aanduiding APPARTEMENTSRECHT.Perceelnummer - Perceelnummer';
comment on column app_re.ka_sectie is 'Groepsattribuut Kadastrale aanduiding APPARTEMENTSRECHT.Sectie - Sectie';

create table begr_terr_dl(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	fysiek_voork_begr_terrein varchar2(20),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	fk_8opr_identifcode varchar2(16)
);
alter table begr_terr_dl add constraint begr_terr_dl_pk primary key(identif);
insert into user_sdo_geom_metadata values('begr_terr_dl', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table begr_terr_dl add(geom sdo_geometry );
CREATE INDEX begr_terr_dl_geom1_idx ON begr_terr_dl (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('begr_terr_dl', 'kruinlijngeom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table begr_terr_dl add(kruinlijngeom sdo_geometry );
CREATE INDEX begr_terr_dl_kruinlijngeo2_idx ON begr_terr_dl (kruinlijngeom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=LINE');

comment on table begr_terr_dl is 'RSGB class BEGROEID TERREINDEEL. Directe superclass van: BEGROEID TERREINVAKONDERDEEL';
comment on column begr_terr_dl.identif is '[PK] NEN3610ID - Identificatie begroeid terreindeel';
comment on column begr_terr_dl.clazz is 'Aanduiding subclass';
comment on column begr_terr_dl.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid begroeid terreindeel';
comment on column begr_terr_dl.fysiek_voork_begr_terrein is 'AN20 - Fysiek voorkomen begroeid terrein';
comment on column begr_terr_dl.geom is 'GM_Surface - Geometrie begroeid terreindeel';
comment on column begr_terr_dl.kruinlijngeom is 'GM_Curve - Kruinlijneometrie begroeid terreindeel';
comment on column begr_terr_dl.relve_hoogteligging is 'N1 - Relatieve hoogteligging begroeid terreindeel';
comment on column begr_terr_dl.status is 'A8 - Status begroeid terreindeel';
comment on column begr_terr_dl.fk_8opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table begr_terreinvakonderd(
	sc_identif varchar2(255) not null,
	fk_1btd_identif varchar2(255)
);
alter table begr_terreinvakonderd add constraint begr_terreinvakonderd_pk primary key(sc_identif);

comment on table begr_terreinvakonderd is 'RSGB class BEGROEID TERREINVAKONDERDEEL. Subclass van: BEGROEID TERREINDEEL';
comment on column begr_terreinvakonderd.sc_identif is '[PK] NEN3610ID, FK naar begr_terr_dl.identif - Identificatie begroeid terreindeel';
comment on column begr_terreinvakonderd.fk_1btd_identif is '[FK] NEN3610ID, FK naar begr_terr_dl.identif';

create table benoemd_obj(
	identif varchar2(16) not null,
	clazz varchar2(255)
);
alter table benoemd_obj add constraint benoemd_obj_pk primary key(identif);

comment on table benoemd_obj is 'RSGB class BENOEMD OBJECT. Directe superclass van: BENOEMD TERREIN, GEBOUWD OBJECT';
comment on column benoemd_obj.identif is '[PK] AN16 - Benoemd object identificatie';
comment on column benoemd_obj.clazz is 'Aanduiding subclass';

create table benoemd_terrein(
	dat_beg_geldh varchar2(19),
	sc_identif varchar2(16) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19)
);
alter table benoemd_terrein add constraint benoemd_terrein_pk primary key(sc_identif);
insert into user_sdo_geom_metadata values('benoemd_terrein', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table benoemd_terrein add(geom sdo_geometry );
CREATE INDEX benoemd_terrein_geom1_idx ON benoemd_terrein (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table benoemd_terrein is 'RSGB class BENOEMD TERREIN. Subclass van: BENOEMD OBJECT. Directe superclass van: LIGPLAATS, OVERIG TERREIN, STANDPLAATS';
comment on column benoemd_terrein.sc_identif is '[PK] AN16, FK naar benoemd_obj.identif - Benoemd object identificatie';
comment on column benoemd_terrein.clazz is 'Aanduiding subclass';
comment on column benoemd_terrein.geom is 'GM_Surface - Benoemd terrein geometrie';
comment on column benoemd_terrein.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid benoemd terrein';

create table brugconstructie_element(
	sc_identif varchar2(255) not null,
	type varchar2(40)
);
alter table brugconstructie_element add constraint brugconstructie_element_pk primary key(sc_identif);

comment on table brugconstructie_element is 'RSGB class BRUGCONSTRUCTIE ELEMENT. Subclass van: KUNSTWERKDEEL';
comment on column brugconstructie_element.sc_identif is '[PK] NEN3610ID, FK naar kunstwerkdeel.identif - Identificatie kunstwerkdeel';
comment on column brugconstructie_element.type is 'AN40 - Type brugconstructie element';

create table buurt(
	code decimal(8,0) not null,
	dat_beg_geldh varchar2(19),
	naam varchar2(80),
	datum_einde_geldh varchar2(19),
	identif_imgeobrt varchar2(255),
	relve_hoogteligging decimal(1,0),
	status varchar2(8)
);
alter table buurt add constraint buurt_pk primary key(code);
insert into user_sdo_geom_metadata values('buurt', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table buurt add(geom sdo_geometry );
CREATE INDEX buurt_geom1_idx ON buurt (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table buurt is 'RSGB class BUURT';
comment on column buurt.code is '[PK] N8 - Buurtcode';
comment on column buurt.geom is 'GM_Surface - Buurtgeometrie';
comment on column buurt.naam is 'AN80 - Buurtnaam';
comment on column buurt.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid buurt';
comment on column buurt.identif_imgeobrt is 'NEN3610ID - Identificatie IMGeoBRT';
comment on column buurt.relve_hoogteligging is 'N1 - Relatieve hoogteligging buurt';
comment on column buurt.status is 'A8 - Status buurt';

create table functioneel_gebied(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	naam varchar2(40),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(255)
);
alter table functioneel_gebied add constraint functioneel_gebied_pk primary key(identif);
insert into user_sdo_geom_metadata values('functioneel_gebied', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table functioneel_gebied add(geom sdo_geometry );
CREATE INDEX functioneel_gebied_geom1_idx ON functioneel_gebied (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table functioneel_gebied is 'RSGB class FUNCTIONEEL GEBIED';
comment on column functioneel_gebied.identif is '[PK] NEN3610ID - Identificatie functioneel gebied';
comment on column functioneel_gebied.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid functioneel gebied';
comment on column functioneel_gebied.geom is 'GM_Surface - Geometrie functioneel gebied';
comment on column functioneel_gebied.naam is 'AN40 - Naam functioneel gebied';
comment on column functioneel_gebied.relve_hoogteligging is 'N1 - Relatieve hoogteligging functioneel gebied';
comment on column functioneel_gebied.status is 'A8 - Status functioneel gebied';
comment on column functioneel_gebied.type is '[geen RSGB type] - Type functioneel gebied';

create table gebouwd_obj(
	dat_beg_geldh varchar2(19),
	sc_identif varchar2(16) not null,
	clazz varchar2(255),
	bouwk_best_act varchar2(255),
	bruto_inhoud decimal(6,0),
	datum_einde_geldh varchar2(19),
	inwwijze_oppervlakte varchar2(24),
	oppervlakte_obj decimal(6,0),
	status_voortgang_bouw integer
);
alter table gebouwd_obj add constraint gebouwd_obj_pk primary key(sc_identif);
insert into user_sdo_geom_metadata values('gebouwd_obj', 'vlakgeom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table gebouwd_obj add(vlakgeom sdo_geometry );
CREATE INDEX gebouwd_obj_vlakgeom1_idx ON gebouwd_obj (vlakgeom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('gebouwd_obj', 'puntgeom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table gebouwd_obj add(puntgeom sdo_geometry );
CREATE INDEX gebouwd_obj_puntgeom2_idx ON gebouwd_obj (puntgeom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=POINT');

comment on table gebouwd_obj is 'RSGB class GEBOUWD OBJECT. Subclass van: BENOEMD OBJECT. Directe superclass van: OVERIG GEBOUWD OBJECT, VERBLIJFSOBJECT';
comment on column gebouwd_obj.sc_identif is '[PK] AN16, FK naar benoemd_obj.identif - Benoemd object identificatie';
comment on column gebouwd_obj.clazz is 'Aanduiding subclass';
comment on column gebouwd_obj.bouwk_best_act is '[Enumeratie] - Bouwkundige bestemming actueel';
comment on column gebouwd_obj.bruto_inhoud is 'N6 - Bruto inhoud';
comment on column gebouwd_obj.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid gebouwd object';
comment on column gebouwd_obj.vlakgeom is 'GM_Surface - Gebouwd object vlakgeometrie';
comment on column gebouwd_obj.puntgeom is 'GM_Point - Gebouwd objectpuntgeometrie';
comment on column gebouwd_obj.inwwijze_oppervlakte is 'AN24 - Inwinningswijze oppervlakte';
comment on column gebouwd_obj.oppervlakte_obj is 'N6 - Oppervlakte (verblijfs)object';
comment on column gebouwd_obj.status_voortgang_bouw is 'long - Status voortgang bouw';

create table gebouwinstallatie(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table gebouwinstallatie add constraint gebouwinstallatie_pk primary key(identif);
insert into user_sdo_geom_metadata values('gebouwinstallatie', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table gebouwinstallatie add(geom sdo_geometry );
CREATE INDEX gebouwinstallatie_geom1_idx ON gebouwinstallatie (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table gebouwinstallatie is 'RSGB class GEBOUWINSTALLATIE';
comment on column gebouwinstallatie.identif is '[PK] NEN3610ID - Identificatie gebouwinstallatie';
comment on column gebouwinstallatie.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid gebouwinstallatie';
comment on column gebouwinstallatie.geom is 'GM_Surface - Geometrie gebouwinstallatie';
comment on column gebouwinstallatie.relve_hoogteligging is 'N1 - Relatieve hoogteligging gebouwinstallatie';
comment on column gebouwinstallatie.status is 'A8 - Status gebouwinstallatie';
comment on column gebouwinstallatie.type is 'AN40 - Type gebouwinstallatie';

create table gemeente(
	dat_beg_geldh varchar2(19),
	code decimal(4,0) not null,
	datum_einde_geldh varchar2(19),
	naam varchar2(40),
	naam_nen varchar2(24)
);
alter table gemeente add constraint gemeente_pk primary key(code);
insert into user_sdo_geom_metadata values('gemeente', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table gemeente add(geom sdo_geometry );
CREATE INDEX gemeente_geom1_idx ON gemeente (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table gemeente is 'RSGB class GEMEENTE';
comment on column gemeente.code is '[PK] N4 - Gemeentecode';
comment on column gemeente.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid gemeente';
comment on column gemeente.geom is 'GM_Surface - Gemeentegeometrie';
comment on column gemeente.naam is 'AN40 - Gemeentenaam';
comment on column gemeente.naam_nen is 'AN24 - Gemeentenaam NEN';

create table gem_openb_rmte(
	dat_beg_geldh varchar2(19),
	identifcode varchar2(16) not null,
	datum_einde_geldh varchar2(19),
	indic_geconst_openb_rmte varchar2(1),
	naam_openb_rmte varchar2(80),
	status_openb_rmte varchar2(80),
	straatnaam varchar2(24),
	type_openb_rmte varchar2(40),
	fk_7gem_code decimal(4,0)
);
alter table gem_openb_rmte add constraint gem_openb_rmte_pk primary key(identifcode);

comment on table gem_openb_rmte is 'RSGB class GEMEENTELIJKE OPENBARE RUIMTE';
comment on column gem_openb_rmte.identifcode is '[PK] AN16 - Identificatiecode gemeentelijke openbare ruimte';
comment on column gem_openb_rmte.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid gemeentelijke openbare ruimte';
comment on column gem_openb_rmte.indic_geconst_openb_rmte is 'AN1 - Indicatie geconstateerde openbare ruimte';
comment on column gem_openb_rmte.naam_openb_rmte is 'AN80 - Naam openbare ruimte';
comment on column gem_openb_rmte.status_openb_rmte is 'AN80 - Status openbare ruimte';
comment on column gem_openb_rmte.straatnaam is 'AN24 - Straatnaam';
comment on column gem_openb_rmte.type_openb_rmte is 'AN40 - Type openbare ruimte';
comment on column gem_openb_rmte.fk_7gem_code is '[FK] N4, FK naar gemeente.code: "ligt in"';

create table huishouden(
	dat_beg_geldh varchar2(19),
	nummer decimal(12,0) not null,
	datum_einde_geldh varchar2(19),
	grootte decimal(2,0),
	soort decimal(2,0),
	fk_4vbo_sc_identif varchar2(16),
	fk_5lpl_sc_identif varchar2(16),
	fk_7spl_sc_identif varchar2(16)
);
alter table huishouden add constraint huishouden_pk primary key(nummer);

comment on table huishouden is 'RSGB class HUISHOUDEN';
comment on column huishouden.nummer is '[PK] N12 - Huishoudennummer';
comment on column huishouden.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid huishouden';
comment on column huishouden.grootte is 'N2 - Huishoudengrootte';
comment on column huishouden.soort is 'N2 - Huishoudensoort';
comment on column huishouden.fk_4vbo_sc_identif is '[FK] AN16, FK naar verblijfsobj.sc_identif (is FK naar superclass BENOEMD OBJECT): "is gehuisvest in"';
comment on column huishouden.fk_5lpl_sc_identif is '[FK] AN16, FK naar ligplaats.sc_identif (is FK naar superclass BENOEMD OBJECT): "is gehuisvest op"';
comment on column huishouden.fk_7spl_sc_identif is '[FK] AN16, FK naar standplaats.sc_identif (is FK naar superclass BENOEMD OBJECT): "is gehuisvest op"';

create table ingeschr_niet_nat_prs(
	sc_identif varchar2(32) not null,
	typering varchar2(35),
	ovrg_privaatr_rechtsvorm varchar2(200),
	publiekrechtelijke_rechtsvorm varchar2(40),
	rechtstoestand varchar2(30),
	rechtsvorm varchar2(50),
	rsin decimal(9,0),
	statutaire_zetel varchar2(40),
	fk_8aoa_identif varchar2(16)
);
alter table ingeschr_niet_nat_prs add constraint ingeschr_niet_nat_prs_pk primary key(sc_identif);

comment on table ingeschr_niet_nat_prs is 'RSGB class INGESCHREVEN NIET-NATUURLIJK PERSOON. Subclass van: NIET-NATUURLIJK PERSOON -> PERSOON -> SUBJECT';
comment on column ingeschr_niet_nat_prs.sc_identif is '[PK] AN32, FK naar niet_nat_prs.sc_identif - Identificatie';
comment on column ingeschr_niet_nat_prs.typering is 'AN35 - Ingeschreven niet-natuurlijk persoon typering';
comment on column ingeschr_niet_nat_prs.ovrg_privaatr_rechtsvorm is 'AN200 - Overige privaatrechtelijk rechtsvorm';
comment on column ingeschr_niet_nat_prs.publiekrechtelijke_rechtsvorm is 'AN40 - Publiekrechtelijke rechtsvorm';
comment on column ingeschr_niet_nat_prs.rechtstoestand is 'AN30 - Rechtstoestand';
comment on column ingeschr_niet_nat_prs.rechtsvorm is 'AN50 - Rechtsvorm';
comment on column ingeschr_niet_nat_prs.rsin is 'N9 - RSIN';
comment on column ingeschr_niet_nat_prs.statutaire_zetel is 'AN40 - Statutaire zetel';
comment on column ingeschr_niet_nat_prs.fk_8aoa_identif is '[FK] AN16, FK naar addresseerb_obj_aand.identif: "heeft als bezoekadres"';

create table ingeschr_nat_prs(
	sc_identif varchar2(32) not null,
	clazz varchar2(255),
	a_nummer decimal(10,0),
	btnlnds_rsdoc decimal(1,0),
	burgerlijke_staat decimal(1,0),
	bsn decimal(9,0),
	dat_beg_geldh_verblijfpl varchar2(19),
	datum_inschrijving_in_gemeente varchar2(19),
	datum_opschorting_bijhouding varchar2(19),
	datum_verkr_nation varchar2(19),
	datum_verlies_nation varchar2(19),
	datum_vertrek_uit_nederland varchar2(19),
	datum_vestg_in_nederland varchar2(19),
	gemeente_van_inschrijving decimal(4,0),
	handelingsbekwaam varchar2(3),
	indic_geheim decimal(1,0),
	rechtstoestand varchar2(22),
	reden_opschorting_bijhouding varchar2(1),
	signalering_rsdoc decimal(1,0),
	fk_27lpl_sc_identif varchar2(16),
	fk_28nra_sc_identif varchar2(16),
	fk_29wpl_identif varchar2(4),
	fk_30spl_sc_identif varchar2(16),
	fk_31vbo_sc_identif varchar2(16),
	fk_1rsd_nummer varchar2(9),
	gb_geboortedatum decimal(8,0),
	fk_gb_lnd_code_iso varchar2(2),
	gb_geboorteplaats varchar2(40),
	nt_aand_bijzonder_nlschap varchar2(1),
	fk_nt_nat_code decimal(4,0),
	nt_reden_verkr_nlse_nation decimal(3,0),
	nt_reden_verlies_nlse_nation decimal(3,0),
	fk_ol_lnd_code_iso varchar2(2),
	ol_overlijdensdatum decimal(8,0),
	ol_overlijdensplaats varchar2(40),
	va_adresherkomst varchar2(1),
	va_loc_beschrijving varchar2(255),
	fk_va_3_vbo_sc_identif varchar2(16),
	fk_va_4_spl_sc_identif varchar2(16),
	fk_va_5_nra_sc_identif varchar2(16),
	fk_va_6_wpl_identif varchar2(4),
	fk_va_7_lpl_sc_identif varchar2(16),
	fk_3nat_code decimal(4,0),
	fk_17lnd_code_iso varchar2(2),
	fk_18lnd_code_iso varchar2(2)
);
alter table ingeschr_nat_prs add constraint ingeschr_nat_prs_pk primary key(sc_identif);

comment on table ingeschr_nat_prs is 'RSGB class INGESCHREVEN NATUURLIJK PERSOON. Subclass van: NATUURLIJK PERSOON -> PERSOON -> SUBJECT. Directe superclass van: INGEZETENE, NIET-INGEZETENE';
comment on column ingeschr_nat_prs.sc_identif is '[PK] AN32, FK naar nat_prs.sc_identif - Identificatie';
comment on column ingeschr_nat_prs.clazz is 'Aanduiding subclass';
comment on column ingeschr_nat_prs.a_nummer is 'N10 - A-nummer';
comment on column ingeschr_nat_prs.btnlnds_rsdoc is 'N1 - Buitenlands reisdocument';
comment on column ingeschr_nat_prs.burgerlijke_staat is 'N1 - Burgerlijke staat';
comment on column ingeschr_nat_prs.bsn is 'N9 - Burgerservicenummer';
comment on column ingeschr_nat_prs.dat_beg_geldh_verblijfpl is 'OnvolledigeDatum - Datum begin geldigheid verblijfplaats';
comment on column ingeschr_nat_prs.datum_inschrijving_in_gemeente is 'OnvolledigeDatum - Datum inschrijving in gemeente';
comment on column ingeschr_nat_prs.datum_opschorting_bijhouding is 'OnvolledigeDatum - Datum opschorting bijhouding';
comment on column ingeschr_nat_prs.datum_verkr_nation is 'OnvolledigeDatum - Datum verkrijging nationaliteit';
comment on column ingeschr_nat_prs.datum_verlies_nation is 'OnvolledigeDatum - Datum verlies nationaliteit';
comment on column ingeschr_nat_prs.datum_vertrek_uit_nederland is 'OnvolledigeDatum - Datum vertrek uit Nederland';
comment on column ingeschr_nat_prs.datum_vestg_in_nederland is 'OnvolledigeDatum - Datum vestiging in Nederland';
comment on column ingeschr_nat_prs.gemeente_van_inschrijving is 'N4 - Gemeente van inschrijving';
comment on column ingeschr_nat_prs.handelingsbekwaam is 'AN3 - Handelingsbekwaam';
comment on column ingeschr_nat_prs.indic_geheim is 'N1 - Indicatie geheim';
comment on column ingeschr_nat_prs.rechtstoestand is 'AN22 - Rechtstoestand';
comment on column ingeschr_nat_prs.reden_opschorting_bijhouding is 'AN1 - Reden opschorting bijhouding';
comment on column ingeschr_nat_prs.signalering_rsdoc is 'N1 - Signalering reisdocument';
comment on column ingeschr_nat_prs.fk_27lpl_sc_identif is '[FK] AN16, FK naar ligplaats.sc_identif (is FK naar superclass BENOEMD OBJECT): "verblijft op"';
comment on column ingeschr_nat_prs.fk_28nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "is ingeschreven op"';
comment on column ingeschr_nat_prs.fk_29wpl_identif is '[FK] AN4, FK naar wnplts.identif: "verblijft op locatie in"';
comment on column ingeschr_nat_prs.fk_30spl_sc_identif is '[FK] AN16, FK naar standplaats.sc_identif (is FK naar superclass BENOEMD OBJECT): "verblijft op"';
comment on column ingeschr_nat_prs.fk_31vbo_sc_identif is '[FK] AN16, FK naar verblijfsobj.sc_identif (is FK naar superclass BENOEMD OBJECT): "verblijft in"';
comment on column ingeschr_nat_prs.fk_1rsd_nummer is '[FK] AN9, FK naar rsdoc.nummer';
comment on column ingeschr_nat_prs.gb_geboortedatum is 'Groepsattribuut Geboorte INGESCHREVEN NATUURLIJK PERSOON.Geboortedatum - Geboortedatum';
comment on column ingeschr_nat_prs.fk_gb_lnd_code_iso is '[FK] A2, FK naar land.code_iso: "Groepsattribuut referentielijst Geboorteland"';
comment on column ingeschr_nat_prs.gb_geboorteplaats is 'Groepsattribuut Geboorte INGESCHREVEN NATUURLIJK PERSOON.Geboorteplaats - Geboorteplaats';
comment on column ingeschr_nat_prs.nt_aand_bijzonder_nlschap is 'Groepsattribuut Nederlandse nationaliteit INGESCHREVEN NATUURLIJK PERSOON.Aanduiding bijzonder Nederlanderschap - Aanduiding bijzonder Nederlanderschap';
comment on column ingeschr_nat_prs.fk_nt_nat_code is '[FK] N4, FK naar nation.code: "Groepsattribuut referentielijst Nationaliteit"';
comment on column ingeschr_nat_prs.nt_reden_verkr_nlse_nation is 'Groepsattribuut Nederlandse nationaliteit INGESCHREVEN NATUURLIJK PERSOON.Reden verkrijging Nederlandse nationaliteit - Reden verkrijging Nederlandse nationaliteit';
comment on column ingeschr_nat_prs.nt_reden_verlies_nlse_nation is 'Groepsattribuut Nederlandse nationaliteit INGESCHREVEN NATUURLIJK PERSOON.Reden verlies Nederlandse nationaliteit - Reden verlies Nederlandse nationaliteit';
comment on column ingeschr_nat_prs.fk_ol_lnd_code_iso is '[FK] A2, FK naar land.code_iso: "Groepsattribuut referentielijst Land overlijden"';
comment on column ingeschr_nat_prs.ol_overlijdensdatum is 'Groepsattribuut Overlijden INGESCHREVEN NATUURLIJK PERSOON.Overlijdensdatum - Overlijdensdatum';
comment on column ingeschr_nat_prs.ol_overlijdensplaats is 'Groepsattribuut Overlijden INGESCHREVEN NATUURLIJK PERSOON.Overlijdensplaats - Overlijdensplaats';
comment on column ingeschr_nat_prs.va_adresherkomst is 'Groepsattribuut Verblijfadres INGESCHREVEN NATUURLIJK PERSOON.Adresherkomst - Adresherkomst';
comment on column ingeschr_nat_prs.va_loc_beschrijving is 'Groepsattribuut Verblijfadres INGESCHREVEN NATUURLIJK PERSOON.Locatie beschrijving - Locatie beschrijving';
comment on column ingeschr_nat_prs.fk_va_3_vbo_sc_identif is '[FK] AN16, FK naar verblijfsobj.sc_identif (is FK naar superclass BENOEMD OBJECT): "Groepsattribuut Verblijfadres INGESCHREVEN NATUURLIJK PERSOON.verblijfsobject"';
comment on column ingeschr_nat_prs.fk_va_4_spl_sc_identif is '[FK] AN16, FK naar standplaats.sc_identif (is FK naar superclass BENOEMD OBJECT): "Groepsattribuut Verblijfadres INGESCHREVEN NATUURLIJK PERSOON.standplaats"';
comment on column ingeschr_nat_prs.fk_va_5_nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "Groepsattribuut Verblijfadres INGESCHREVEN NATUURLIJK PERSOON.nummeraanduiding"';
comment on column ingeschr_nat_prs.fk_va_6_wpl_identif is '[FK] AN4, FK naar wnplts.identif: "Groepsattribuut Verblijfadres INGESCHREVEN NATUURLIJK PERSOON.woonplaats"';
comment on column ingeschr_nat_prs.fk_va_7_lpl_sc_identif is '[FK] AN16, FK naar ligplaats.sc_identif (is FK naar superclass BENOEMD OBJECT): "Groepsattribuut Verblijfadres INGESCHREVEN NATUURLIJK PERSOON.ligplaats"';
comment on column ingeschr_nat_prs.fk_3nat_code is '[FK] N4, FK naar nation.code: "Referentielijst INGESCHREVEN NATUURLIJK PERSOON.Buitenlandse nationaliteit"';
comment on column ingeschr_nat_prs.fk_17lnd_code_iso is '[FK] A2, FK naar land.code_iso: "Referentielijst INGESCHREVEN NATUURLIJK PERSOON.Land vanwaar ingeschreven"';
comment on column ingeschr_nat_prs.fk_18lnd_code_iso is '[FK] A2, FK naar land.code_iso: "Referentielijst INGESCHREVEN NATUURLIJK PERSOON.Land waarnaar vertrokken"';

create table ingezetene(
	sc_identif varchar2(32) not null,
	datum_verkr_verblijfstitel varchar2(19),
	datum_verlies_verblijfstitel varchar2(19),
	indic_blokkering varchar2(1),
	indic_curateleregister decimal(1,0),
	indic_gezag_minderjarige varchar2(2),
	fk_8vbt_aand decimal(2,0),
	ek_aand_euro_kiesr decimal(1,0),
	ek_verw_eindd_uitsl_euro_kiesr decimal(8,0),
	uk_aand_uitgesloten_kiesr varchar2(1),
	uk_verw_eindd_uitsl_kiesr decimal(8,0)
);
alter table ingezetene add constraint ingezetene_pk primary key(sc_identif);

comment on table ingezetene is 'RSGB class INGEZETENE. Subclass van: INGESCHREVEN NATUURLIJK PERSOON -> NATUURLIJK PERSOON -> PERSOON -> SUBJECT';
comment on column ingezetene.sc_identif is '[PK] AN32, FK naar ingeschr_nat_prs.sc_identif - Identificatie';
comment on column ingezetene.datum_verkr_verblijfstitel is 'OnvolledigeDatum - Datum verkrijging verblijfstitel';
comment on column ingezetene.datum_verlies_verblijfstitel is 'OnvolledigeDatum - Datum verlies verblijfstitel';
comment on column ingezetene.indic_blokkering is 'AN1 - Indicatie blokkering';
comment on column ingezetene.indic_curateleregister is 'N1 - Indicatie curateleregister';
comment on column ingezetene.indic_gezag_minderjarige is 'AN2 - Indicatie gezag minderjarige';
comment on column ingezetene.fk_8vbt_aand is '[FK] N2, FK naar verblijfstitel.aand: "heeft"';
comment on column ingezetene.ek_aand_euro_kiesr is 'Groepsattribuut Europees kiesrecht INGEZETENE.Aanduiding Europees kiesrecht - Aanduiding Europees kiesrecht';
comment on column ingezetene.ek_verw_eindd_uitsl_euro_kiesr is 'Groepsattribuut Europees kiesrecht INGEZETENE.Verwachte einddatum uitsluiting Europees kiesrecht - Verwachte einddatum uitsluiting Europees kiesrecht';
comment on column ingezetene.uk_aand_uitgesloten_kiesr is 'Groepsattribuut Uitsluiting kiesrecht INGEZETENE.Aanduiding uitgesloten kiesrecht - Aanduiding uitgesloten kiesrecht';
comment on column ingezetene.uk_verw_eindd_uitsl_kiesr is 'Groepsattribuut Uitsluiting kiesrecht INGEZETENE.Verwachte einddatum uitsluiting kiesrecht - Verwachte einddatum uitsluiting kiesrecht';

create table inrichtingselement(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	typering varchar2(40),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(30)
);
alter table inrichtingselement add constraint inrichtingselement_pk primary key(identif);
insert into user_sdo_geom_metadata values('inrichtingselement', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table inrichtingselement add(geom sdo_geometry );
CREATE INDEX inrichtingselement_geom1_idx ON inrichtingselement (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=COLLECTION');

comment on table inrichtingselement is 'RSGB class INRICHTINGSELEMENT';
comment on column inrichtingselement.identif is '[PK] NEN3610ID - Identificatie inrichtingselement';
comment on column inrichtingselement.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid inrichtingselement';
comment on column inrichtingselement.geom is 'PuntLijnVlak - Geometrie inrichtingselement';
comment on column inrichtingselement.typering is 'AN40 - Inrichtingselementtypering';
comment on column inrichtingselement.relve_hoogteligging is 'N1 - Relatieve hoogteligging inrichtingselement';
comment on column inrichtingselement.status is 'AN8 - Status inrichtingselement';
comment on column inrichtingselement.type is 'AN30 - Type inrichtingselement';

create table kad_perceel(
	sc_kad_identif decimal(15,0) not null,
	aand_soort_grootte char(1),
	grootte_perceel decimal(8,0),
	omschr_deelperceel varchar2(1120),
	fk_7kdp_sc_kad_identif decimal(15,0),
	ka_deelperceelnummer varchar2(4),
	ka_kad_gemeentecode varchar2(5),
	ka_perceelnummer varchar2(5),
	ka_sectie varchar2(255)
);
alter table kad_perceel add constraint kad_perceel_pk primary key(sc_kad_identif);
insert into user_sdo_geom_metadata values('kad_perceel', 'begrenzing_perceel', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table kad_perceel add(begrenzing_perceel sdo_geometry );
CREATE INDEX kad_perceel_begrenzing_pe1_idx ON kad_perceel (begrenzing_perceel) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('kad_perceel', 'plaatscoordinaten_perceel', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table kad_perceel add(plaatscoordinaten_perceel sdo_geometry );
CREATE INDEX kad_perceel_plaatscoordin2_idx ON kad_perceel (plaatscoordinaten_perceel) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=POINT');

comment on table kad_perceel is 'RSGB class KADASTRAAL PERCEEL. Subclass van: KADASTRALE ONROERENDE ZAAK';
comment on column kad_perceel.sc_kad_identif is '[PK] N15, FK naar kad_onrrnd_zk.kad_identif - Kadastrale identificatie';
comment on column kad_perceel.aand_soort_grootte is 'boolean - Aanduiding soort grootte';
comment on column kad_perceel.begrenzing_perceel is 'GM_Surface - Begrenzing perceel';
comment on column kad_perceel.grootte_perceel is 'N8 - Grootte perceel';
comment on column kad_perceel.omschr_deelperceel is 'AN1120 - Omschrijving deelperceel';
comment on column kad_perceel.plaatscoordinaten_perceel is 'GM_Point - Plaatscoördinaten perceel';
comment on column kad_perceel.fk_7kdp_sc_kad_identif is '[FK] N15, FK naar kad_perceel.sc_kad_identif (is FK naar superclass KADASTRALE ONROERENDE ZAAK): "ligt binnen"';
comment on column kad_perceel.ka_deelperceelnummer is 'Groepsattribuut Kadastrale aanduiding KADASTRAAL PERCEEL.Deelperceelnummer - Deelperceelnummer';
comment on column kad_perceel.ka_kad_gemeentecode is 'Groepsattribuut Kadastrale aanduiding KADASTRAAL PERCEEL.Kadastrale gemeentecode - Kadastrale gemeentecode';
comment on column kad_perceel.ka_perceelnummer is 'Groepsattribuut Kadastrale aanduiding KADASTRAAL PERCEEL.Perceelnummer - Perceelnummer';
comment on column kad_perceel.ka_sectie is 'Groepsattribuut Kadastrale aanduiding KADASTRAAL PERCEEL.Sectie - Sectie';

create table kad_gemeente(
	code varchar2(5) not null,
	indic_vervallen char(1),
	naam varchar2(40)
);
alter table kad_gemeente add constraint kad_gemeente_pk primary key(code);

comment on table kad_gemeente is 'RSGB class KADASTRALE GEMEENTE';
comment on column kad_gemeente.code is '[PK] AN5 - Kadastrale gemeentecode';
comment on column kad_gemeente.indic_vervallen is 'boolean - Indicatie vervallen';
comment on column kad_gemeente.naam is 'AN40 - naam';

create table kad_onrrnd_zk(
	dat_beg_geldh varchar2(19),
	kad_identif decimal(15,0) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	typering varchar2(1),
	fk_7kdg_code varchar2(5),
	fk_10pes_sc_identif varchar2(32),
	cu_aard_bebouwing varchar2(255),
	cu_aard_cultuur_onbebouwd varchar2(65),
	cu_meer_culturen char(1),
	ks_aard_bedrag varchar2(255),
	ks_bedrag decimal(9,0),
	ks_koopjaar integer,
	ks_meer_onroerendgoed char(1),
	ks_transactiedatum timestamp,
	ks_valutasoort varchar2(255),
	lr_aand_aard_liproject varchar2(1),
	lr_aard_bedrag varchar2(255),
	lr_bedrag varchar2(255),
	lr_eindjaar integer,
	lr_valutasoort varchar2(3),
	lo_cultuur_bebouwd varchar2(65),
	lo_loc__omschr varchar2(255)
);
alter table kad_onrrnd_zk add constraint kad_onrrnd_zk_pk primary key(kad_identif);

comment on table kad_onrrnd_zk is 'RSGB class KADASTRALE ONROERENDE ZAAK. Directe superclass van: APPARTEMENTSRECHT, KADASTRAAL PERCEEL';
comment on column kad_onrrnd_zk.kad_identif is '[PK] N15 - Kadastrale identificatie';
comment on column kad_onrrnd_zk.clazz is 'Aanduiding subclass';
comment on column kad_onrrnd_zk.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid kadastrale onroerende zaak';
comment on column kad_onrrnd_zk.typering is 'AN1 - Kadastrale onroerende zaak typering';
comment on column kad_onrrnd_zk.fk_7kdg_code is '[FK] AN5, FK naar kad_gemeente.code: "ligt in"';
comment on column kad_onrrnd_zk.fk_10pes_sc_identif is '[FK] AN32, FK naar prs.sc_identif (is FK naar superclass SUBJECT): "heeft als voornaamste zakelijk gerechtigde"';
comment on column kad_onrrnd_zk.cu_aard_bebouwing is 'Groepsattribuut Cultuur onbebouwd KADASTRALE ONROERENDE ZAAK.Aard bebouwing - Aard bebouwing';
comment on column kad_onrrnd_zk.cu_aard_cultuur_onbebouwd is 'Groepsattribuut Cultuur onbebouwd KADASTRALE ONROERENDE ZAAK.Aard cultuur onbebouwd - Aard cultuur onbebouwd';
comment on column kad_onrrnd_zk.cu_meer_culturen is 'Groepsattribuut Cultuur onbebouwd KADASTRALE ONROERENDE ZAAK.Meer culturen - Meer culturen';
comment on column kad_onrrnd_zk.ks_aard_bedrag is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Aard bedrag - Aard bedrag';
comment on column kad_onrrnd_zk.ks_bedrag is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Bedrag - Bedrag';
comment on column kad_onrrnd_zk.ks_koopjaar is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Koopjaar - Koopjaar';
comment on column kad_onrrnd_zk.ks_meer_onroerendgoed is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Meer onroerendgoed - Meer onroerendgoed';
comment on column kad_onrrnd_zk.ks_transactiedatum is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Transactiedatum - Transactiedatum';
comment on column kad_onrrnd_zk.ks_valutasoort is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Valutasoort - Valutasoort';
comment on column kad_onrrnd_zk.lr_aand_aard_liproject is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Aanduiding aard LIproject - Aanduiding aard LIproject';
comment on column kad_onrrnd_zk.lr_aard_bedrag is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Aard bedrag - Aard bedrag';
comment on column kad_onrrnd_zk.lr_bedrag is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Bedrag - Bedrag';
comment on column kad_onrrnd_zk.lr_eindjaar is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Eindjaar - Eindjaar';
comment on column kad_onrrnd_zk.lr_valutasoort is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Valutasoort - Valutasoort';
comment on column kad_onrrnd_zk.lo_cultuur_bebouwd is 'Groepsattribuut Locatie onroerende zaak KADASTRALE ONROERENDE ZAAK.Cultuur bebouwd - Cultuur bebouwd';
comment on column kad_onrrnd_zk.lo_loc__omschr is 'Groepsattribuut Locatie onroerende zaak KADASTRALE ONROERENDE ZAAK.Locatie- omschrijving - Locatie- omschrijving';

create table kad_onrrnd_zk_aantek(
	begindatum_aantek_kad_obj varchar2(19),
	kadaster_identif_aantek varchar2(255) not null,
	aard_aantek_kad_obj varchar2(255),
	beschrijving_aantek_kad_obj varchar2(124),
	eindd_aantek_kad_obj varchar2(19),
	fk_4koz_kad_identif decimal(15,0),
	fk_5pes_sc_identif varchar2(32)
);
alter table kad_onrrnd_zk_aantek add constraint kad_onrrnd_zk_aantek_pk primary key(kadaster_identif_aantek);

comment on table kad_onrrnd_zk_aantek is 'RSGB class KADASTRALE ONROERENDE ZAAK AANTEKENING';
comment on column kad_onrrnd_zk_aantek.kadaster_identif_aantek is '[PK] AN255 - Kadaster identificatie aantekening';
comment on column kad_onrrnd_zk_aantek.aard_aantek_kad_obj is '[Enumeratie] - Aard aantekening kadastraal object';
comment on column kad_onrrnd_zk_aantek.beschrijving_aantek_kad_obj is 'AN124 - Beschrijving aantekening kadastraal object';
comment on column kad_onrrnd_zk_aantek.eindd_aantek_kad_obj is 'OnvolledigeDatum - Einddatum aantekening kadastraal object';
comment on column kad_onrrnd_zk_aantek.fk_4koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif: "behoort bij"';
comment on column kad_onrrnd_zk_aantek.fk_5pes_sc_identif is '[FK] AN32, FK naar prs.sc_identif (is FK naar superclass SUBJECT): "heeft betrokken"';

create table kunstwerkdeel(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type_kunstwerk varchar2(40)
);
alter table kunstwerkdeel add constraint kunstwerkdeel_pk primary key(identif);
insert into user_sdo_geom_metadata values('kunstwerkdeel', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table kunstwerkdeel add(geom sdo_geometry );
CREATE INDEX kunstwerkdeel_geom1_idx ON kunstwerkdeel (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=COLLECTION');

comment on table kunstwerkdeel is 'RSGB class KUNSTWERKDEEL. Directe superclass van: BRUGCONSTRUCTIE ELEMENT';
comment on column kunstwerkdeel.identif is '[PK] NEN3610ID - Identificatie kunstwerkdeel';
comment on column kunstwerkdeel.clazz is 'Aanduiding subclass';
comment on column kunstwerkdeel.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid kunstwerkdeel';
comment on column kunstwerkdeel.geom is 'LijnVlak - Geometrie kunstwerkdeel';
comment on column kunstwerkdeel.relve_hoogteligging is 'N1 - Relatieve hoogteligging kunstwerkdeel';
comment on column kunstwerkdeel.status is 'A8 - Status kunstwerkdeel';
comment on column kunstwerkdeel.type_kunstwerk is 'AN40 - Type kunstwerk';

create table ligplaats(
	sc_identif varchar2(16) not null,
	indic_geconst varchar2(1),
	status varchar2(80),
	fk_4nra_sc_identif varchar2(16)
);
alter table ligplaats add constraint ligplaats_pk primary key(sc_identif);

comment on table ligplaats is 'RSGB class LIGPLAATS. Subclass van: BENOEMD TERREIN -> BENOEMD OBJECT';
comment on column ligplaats.sc_identif is '[PK] AN16, FK naar benoemd_terrein.sc_identif - Benoemd object identificatie';
comment on column ligplaats.indic_geconst is 'AN1 - Indicatie geconstateerde ligplaats';
comment on column ligplaats.status is 'AN80 - Ligplaatsstatus';
comment on column ligplaats.fk_4nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als hoofdadres"';

create table maatschapp_activiteit(
	kvk_nummer decimal(8,0) not null,
	datum_aanvang varchar2(19),
	datum_einde_geldig varchar2(19),
	fk_3ond_kvk_nummer decimal(8,0),
	fk_4pes_sc_identif varchar2(32)
);
alter table maatschapp_activiteit add constraint maatschapp_activiteit_pk primary key(kvk_nummer);

comment on table maatschapp_activiteit is 'RSGB class MAATSCHAPPELIJKE ACTIVITEIT';
comment on column maatschapp_activiteit.kvk_nummer is '[PK] N8 - KvK-nummer';
comment on column maatschapp_activiteit.datum_aanvang is 'OnvolledigeDatum - Datum aanvang';
comment on column maatschapp_activiteit.datum_einde_geldig is 'OnvolledigeDatum - Datum einde geldig (beeindiging)';
comment on column maatschapp_activiteit.fk_3ond_kvk_nummer is '[FK] N8, FK naar ondrnmng.kvk_nummer: "manifesteert zich als"';
comment on column maatschapp_activiteit.fk_4pes_sc_identif is '[FK] AN32, FK naar prs.sc_identif (is FK naar superclass SUBJECT): "heeft als eigenaar"';

create table nat_prs(
	sc_identif varchar2(32) not null,
	clazz varchar2(255),
	aand_naamgebruik varchar2(1),
	geslachtsaand varchar2(1),
	nm_adellijke_titel_predikaat varchar2(10),
	nm_geslachtsnaam varchar2(200),
	nm_voornamen varchar2(200),
	nm_voorvoegsel_geslachtsnaam varchar2(10),
	na_aanhef_aanschrijving varchar2(50),
	na_geslachtsnaam_aanschrijving varchar2(200),
	na_voorletters_aanschrijving varchar2(20),
	na_voornamen_aanschrijving varchar2(200),
	fk_2acd_code varchar2(3)
);
alter table nat_prs add constraint nat_prs_pk primary key(sc_identif);

comment on table nat_prs is 'RSGB class NATUURLIJK PERSOON. Subclass van: PERSOON -> SUBJECT. Directe superclass van: ANDER NATUURLIJK PERSOON, INGESCHREVEN NATUURLIJK PERSOON';
comment on column nat_prs.sc_identif is '[PK] AN32, FK naar prs.sc_identif - Identificatie';
comment on column nat_prs.clazz is 'Aanduiding subclass';
comment on column nat_prs.aand_naamgebruik is 'AN1 - Aanduiding naamgebruik';
comment on column nat_prs.geslachtsaand is 'AN1 - Geslachtsaanduiding';
comment on column nat_prs.nm_adellijke_titel_predikaat is 'Groepsattribuut Naam NATUURLIJK PERSOON.Adellijke titel/ predikaat - Adellijke titel/ predikaat';
comment on column nat_prs.nm_geslachtsnaam is 'Groepsattribuut Naam NATUURLIJK PERSOON.Geslachtsnaam - Geslachtsnaam';
comment on column nat_prs.nm_voornamen is 'Groepsattribuut Naam NATUURLIJK PERSOON.Voornamen - Voornamen';
comment on column nat_prs.nm_voorvoegsel_geslachtsnaam is 'Groepsattribuut Naam NATUURLIJK PERSOON.Voorvoegsel geslachtsnaam - Voorvoegsel geslachtsnaam';
comment on column nat_prs.na_aanhef_aanschrijving is 'Groepsattribuut Naam aanschrijving NATUURLIJK PERSOON.Aanhef aanschrijving - Aanhef aanschrijving';
comment on column nat_prs.na_geslachtsnaam_aanschrijving is 'Groepsattribuut Naam aanschrijving NATUURLIJK PERSOON.Geslachtsnaam aanschrijving - Geslachtsnaam aanschrijving';
comment on column nat_prs.na_voorletters_aanschrijving is 'Groepsattribuut Naam aanschrijving NATUURLIJK PERSOON.Voorletters aanschrijving - Voorletters aanschrijving';
comment on column nat_prs.na_voornamen_aanschrijving is 'Groepsattribuut Naam aanschrijving NATUURLIJK PERSOON.Voornamen aanschrijving - Voornamen aanschrijving';
comment on column nat_prs.fk_2acd_code is '[FK] AN3, FK naar academische_titel.code: "Referentielijst NATUURLIJK PERSOON.Academische titel"';

create table niet_ingezetene(
	sc_identif varchar2(32) not null
);
alter table niet_ingezetene add constraint niet_ingezetene_pk primary key(sc_identif);

comment on table niet_ingezetene is 'RSGB class NIET-INGEZETENE. Subclass van: INGESCHREVEN NATUURLIJK PERSOON -> NATUURLIJK PERSOON -> PERSOON -> SUBJECT';
comment on column niet_ingezetene.sc_identif is '[PK] AN32, FK naar ingeschr_nat_prs.sc_identif - Identificatie';

create table niet_nat_prs(
	sc_identif varchar2(32) not null,
	clazz varchar2(255),
	naam varchar2(500),
	datum_aanvang varchar2(19),
	datum_beeindiging varchar2(19),
	verkorte_naam varchar2(45)
);
alter table niet_nat_prs add constraint niet_nat_prs_pk primary key(sc_identif);

comment on table niet_nat_prs is 'RSGB class NIET-NATUURLIJK PERSOON. Subclass van: PERSOON -> SUBJECT. Directe superclass van: ANDER BUITENLANDS NIET-NATUURLIJK PERSOON, INGESCHREVEN NIET-NATUURLIJK PERSOON';
comment on column niet_nat_prs.sc_identif is '[PK] AN32, FK naar prs.sc_identif - Identificatie';
comment on column niet_nat_prs.clazz is 'Aanduiding subclass';
comment on column niet_nat_prs.naam is 'AN500 - (Statutaire) Naam';
comment on column niet_nat_prs.datum_aanvang is 'OnvolledigeDatum - Datum aanvang';
comment on column niet_nat_prs.datum_beeindiging is 'OnvolledigeDatum - Datum beeindiging';
comment on column niet_nat_prs.verkorte_naam is 'AN45 - Verkorte naam';

create table nummeraand(
	sc_identif varchar2(16) not null,
	indic_geconst varchar2(1),
	indic_hoofdadres char(1),
	status varchar2(80)
);
alter table nummeraand add constraint nummeraand_pk primary key(sc_identif);

comment on table nummeraand is 'RSGB class NUMMERAANDUIDING. Subclass van: ADRESSEERBAAR OBJECT AANDUIDING';
comment on column nummeraand.sc_identif is '[PK] AN16, FK naar addresseerb_obj_aand.identif - Identificatie adresseerbaar object aanduiding';
comment on column nummeraand.indic_geconst is 'AN1 - Indicatie geconstateerde nummeraanduiding';
comment on column nummeraand.indic_hoofdadres is 'boolean - Indicatie hoofdadres';
comment on column nummeraand.status is 'AN80 - Nummeraanduidingstatus';

create table onbegr_terr_dl(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	fysiek_voork_onbegr_terrein varchar2(20),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	fk_8opr_identifcode varchar2(16)
);
alter table onbegr_terr_dl add constraint onbegr_terr_dl_pk primary key(identif);
insert into user_sdo_geom_metadata values('onbegr_terr_dl', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table onbegr_terr_dl add(geom sdo_geometry );
CREATE INDEX onbegr_terr_dl_geom1_idx ON onbegr_terr_dl (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('onbegr_terr_dl', 'kruinlijngeom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table onbegr_terr_dl add(kruinlijngeom sdo_geometry );
CREATE INDEX onbegr_terr_dl_kruinlijng2_idx ON onbegr_terr_dl (kruinlijngeom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=LINE');

comment on table onbegr_terr_dl is 'RSGB class ONBEGROEID TERREINDEEL. Directe superclass van: ONBEGROEID TERREINVAKONDERDEEL';
comment on column onbegr_terr_dl.identif is '[PK] NEN3610ID - Identificatie onbegroeid terreindeel';
comment on column onbegr_terr_dl.clazz is 'Aanduiding subclass';
comment on column onbegr_terr_dl.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid onbegroeid terreindeel';
comment on column onbegr_terr_dl.fysiek_voork_onbegr_terrein is 'AN20 - Fysiek voorkomen onbegroeid terrein';
comment on column onbegr_terr_dl.geom is 'GM_Surface - Geometrie onbegroeid terreindeel';
comment on column onbegr_terr_dl.kruinlijngeom is 'GM_Curve - Kruinlijngeometrie onbegroeid terreindeel';
comment on column onbegr_terr_dl.relve_hoogteligging is 'N1 - Relatieve hoogteligging onbegroeid terreindeel';
comment on column onbegr_terr_dl.status is 'A8 - Status onbegroeid terreindeel';
comment on column onbegr_terr_dl.fk_8opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table onbegr_terreinvakonderd(
	sc_identif varchar2(255) not null,
	fk_1obt_identif varchar2(255)
);
alter table onbegr_terreinvakonderd add constraint onbegr_terreinvakonderd_pk primary key(sc_identif);

comment on table onbegr_terreinvakonderd is 'RSGB class ONBEGROEID TERREINVAKONDERDEEL. Subclass van: ONBEGROEID TERREINDEEL';
comment on column onbegr_terreinvakonderd.sc_identif is '[PK] NEN3610ID, FK naar onbegr_terr_dl.identif - Identificatie onbegroeid terreindeel';
comment on column onbegr_terreinvakonderd.fk_1obt_identif is '[FK] NEN3610ID, FK naar onbegr_terr_dl.identif';

create table ondrnmng(
	kvk_nummer decimal(8,0) not null,
	datum_aanvang varchar2(19),
	datum_einde varchar2(19),
	fk_4mac_kvk_nummer decimal(8,0),
	fk_1ond_kvk_nummer decimal(8,0)
);
alter table ondrnmng add constraint ondrnmng_pk primary key(kvk_nummer);

comment on table ondrnmng is 'RSGB class ONDERNEMING';
comment on column ondrnmng.kvk_nummer is '[PK] N8 - KvK-nummer';
comment on column ondrnmng.datum_aanvang is 'OnvolledigeDatum - Datum aanvang';
comment on column ondrnmng.datum_einde is 'OnvolledigeDatum - Datum einde';
comment on column ondrnmng.fk_4mac_kvk_nummer is '[FK] N8, FK naar maatschapp_activiteit.kvk_nummer: "is voortgezet door"';
comment on column ondrnmng.fk_1ond_kvk_nummer is '[FK] N8, FK naar ondrnmng.kvk_nummer';

create table ondersteunend_wegdeel(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	functie varchar2(25),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	fk_6opr_identifcode varchar2(16)
);
alter table ondersteunend_wegdeel add constraint ondersteunend_wegdeel_pk primary key(identif);
insert into user_sdo_geom_metadata values('ondersteunend_wegdeel', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table ondersteunend_wegdeel add(geom sdo_geometry );
CREATE INDEX ondersteunend_wegdeel_geo1_idx ON ondersteunend_wegdeel (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table ondersteunend_wegdeel is 'RSGB class ONDERSTEUNEND WEGDEEL';
comment on column ondersteunend_wegdeel.identif is '[PK] NEN3610ID - Identificatie ondersteunend wegdeel';
comment on column ondersteunend_wegdeel.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid ondersteunend wegdeel';
comment on column ondersteunend_wegdeel.functie is 'AN25 - Functie ondersteunend wegdeel';
comment on column ondersteunend_wegdeel.geom is 'GM_Surface - Geometrie ondersteunend wegdeel';
comment on column ondersteunend_wegdeel.relve_hoogteligging is 'N1 - Relatieve hoogteligging ondersteunend wegdeel';
comment on column ondersteunend_wegdeel.status is 'A8 - Status ondersteunend wegdeel';
comment on column ondersteunend_wegdeel.fk_6opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table openb_rmte(
	identifcode varchar2(16) not null,
	huisnrrange_on_even_nummers varchar2(11),
	huisnrrange_even_nummers varchar2(11),
	huisnrrange_oneven_nummers varchar2(11),
	identif_bgtopr varchar2(255)
);
alter table openb_rmte add constraint openb_rmte_pk primary key(identifcode);

comment on table openb_rmte is 'RSGB class OPENBARE RUIMTE';
comment on column openb_rmte.identifcode is '[PK] AN16 - Identificatiecode openbare ruimte';
comment on column openb_rmte.huisnrrange_on_even_nummers is 'AN11 (NNNNN-NNNNN) - Huisnummerrange even en oneven nummers';
comment on column openb_rmte.huisnrrange_even_nummers is 'AN11 (NNNNN-NNNNN) - Huisnummerrange even nummers';
comment on column openb_rmte.huisnrrange_oneven_nummers is 'AN11 (NNNNN-NNNNN) - Huisnummerrange oneven nummers';
comment on column openb_rmte.identif_bgtopr is 'NEN3610ID - Identificatie BGTOPR';

create table ovrg_addresseerb_obj_aand(
	sc_identif varchar2(16) not null
);
alter table ovrg_addresseerb_obj_aand add constraint ovrg_addresseerb_obj_aand_pk primary key(sc_identif);

comment on table ovrg_addresseerb_obj_aand is 'RSGB class OVERIGE ADRESSEERBAAR OBJECT AANDUIDING. Subclass van: ADRESSEERBAAR OBJECT AANDUIDING';
comment on column ovrg_addresseerb_obj_aand.sc_identif is '[PK] AN16, FK naar addresseerb_obj_aand.identif - Identificatie adresseerbaar object aanduiding';

create table overig_bouwwerk(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table overig_bouwwerk add constraint overig_bouwwerk_pk primary key(identif);
insert into user_sdo_geom_metadata values('overig_bouwwerk', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table overig_bouwwerk add(geom sdo_geometry );
CREATE INDEX overig_bouwwerk_geom1_idx ON overig_bouwwerk (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table overig_bouwwerk is 'RSGB class OVERIG BOUWWERK';
comment on column overig_bouwwerk.identif is '[PK] NEN3610ID - Identificatie overig bouwwerk';
comment on column overig_bouwwerk.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid overig bouwwerk';
comment on column overig_bouwwerk.geom is 'GM_Surface - Geometrie overig bouwwerk';
comment on column overig_bouwwerk.relve_hoogteligging is 'N1 - Relatieve hoogteligging overig bouwwerk';
comment on column overig_bouwwerk.status is 'A8 - Status overig bouwwerk';
comment on column overig_bouwwerk.type is 'AN40 - Type overig bouwwerk';

create table overig_gebouwd_obj(
	sc_identif varchar2(16) not null,
	bouwjaar decimal(4,0),
	loc_aand varchar2(40),
	type varchar2(40),
	fk_4oao_sc_identif varchar2(16),
	fk_5nra_sc_identif varchar2(16),
	fk_6opr_identifcode varchar2(16)
);
alter table overig_gebouwd_obj add constraint overig_gebouwd_obj_pk primary key(sc_identif);

comment on table overig_gebouwd_obj is 'RSGB class OVERIG GEBOUWD OBJECT. Subclass van: GEBOUWD OBJECT -> BENOEMD OBJECT';
comment on column overig_gebouwd_obj.sc_identif is '[PK] AN16, FK naar gebouwd_obj.sc_identif - Benoemd object identificatie';
comment on column overig_gebouwd_obj.bouwjaar is 'N4 - Bouwjaar';
comment on column overig_gebouwd_obj.loc_aand is 'AN40 - Overig gebouwd object locatie-aanduiding';
comment on column overig_gebouwd_obj.type is 'AN40 - Overig gebouwd object type';
comment on column overig_gebouwd_obj.fk_4oao_sc_identif is '[FK] AN16, FK naar ovrg_addresseerb_obj_aand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als officieel adres"';
comment on column overig_gebouwd_obj.fk_5nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft locatie-adres i.c.m."';
comment on column overig_gebouwd_obj.fk_6opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "heeft straatadres i.c.m."';

create table ovrg_scheiding(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table ovrg_scheiding add constraint ovrg_scheiding_pk primary key(identif);
insert into user_sdo_geom_metadata values('ovrg_scheiding', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table ovrg_scheiding add(geom sdo_geometry );
CREATE INDEX ovrg_scheiding_geom1_idx ON ovrg_scheiding (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=COLLECTION');

comment on table ovrg_scheiding is 'RSGB class OVERIGE SCHEIDING';
comment on column ovrg_scheiding.identif is '[PK] NEN3610ID - Identificatie overige scheiding';
comment on column ovrg_scheiding.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid overige scheiding';
comment on column ovrg_scheiding.geom is 'LijnVlak - Geometrie overige scheiding';
comment on column ovrg_scheiding.relve_hoogteligging is 'N1 - Relatieve hoogteligging overige scheiding';
comment on column ovrg_scheiding.status is 'A8 - Status overige scheiding';
comment on column ovrg_scheiding.type is 'AN40 - Type overige scheiding';

create table overig_terrein(
	sc_identif varchar2(16) not null,
	fk_2oao_sc_identif varchar2(16)
);
alter table overig_terrein add constraint overig_terrein_pk primary key(sc_identif);

comment on table overig_terrein is 'RSGB class OVERIG TERREIN. Subclass van: BENOEMD TERREIN -> BENOEMD OBJECT';
comment on column overig_terrein.sc_identif is '[PK] AN16, FK naar benoemd_terrein.sc_identif - Benoemd object identificatie';
comment on column overig_terrein.fk_2oao_sc_identif is '[FK] AN16, FK naar ovrg_addresseerb_obj_aand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als officieel adres"';

create table pand(
	dat_beg_geldh varchar2(19),
	identif varchar2(16) not null,
	bruto_inhoud decimal(6,0),
	datum_einde_geldh varchar2(19),
	hoogste_bouwlaag decimal(3,0),
	identif_bgtpnd varchar2(255),
	indic_geconstateerd varchar2(1),
	inwwijze_geom_bovenaanzicht varchar2(24),
	inwwijze_geom_maaiveld varchar2(24),
	laagste_bouwlaag decimal(3,0),
	oorspronkelijk_bouwjaar decimal(4,0),
	oppervlakte decimal(6,0),
	status varchar2(80),
	relve_hoogteligging decimal(1,0),
	status_voortgang_bouw varchar2(24)
);
alter table pand add constraint pand_pk primary key(identif);
insert into user_sdo_geom_metadata values('pand', 'geom_bovenaanzicht', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table pand add(geom_bovenaanzicht sdo_geometry );
CREATE INDEX pand_geom_bovenaanzicht1_idx ON pand (geom_bovenaanzicht) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('pand', 'geom_maaiveld', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table pand add(geom_maaiveld sdo_geometry );
CREATE INDEX pand_geom_maaiveld2_idx ON pand (geom_maaiveld) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table pand is 'RSGB class PAND';
comment on column pand.identif is '[PK] AN16 - Pandidentificatie';
comment on column pand.bruto_inhoud is 'N6 - Bruto inhoud pand';
comment on column pand.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid pand';
comment on column pand.hoogste_bouwlaag is 'N3 - Hoogste bouwlaag pand';
comment on column pand.identif_bgtpnd is 'NEN3610ID - Identificatie BGTPND';
comment on column pand.indic_geconstateerd is 'AN1 - Indicatie geconstateerd pand';
comment on column pand.inwwijze_geom_bovenaanzicht is 'AN24 - Inwinningswijze geometrie bovenaanzicht';
comment on column pand.inwwijze_geom_maaiveld is 'AN24 - Inwinningswijze geometrie maaiveld';
comment on column pand.laagste_bouwlaag is 'N3 - Laagste bouwlaag pand';
comment on column pand.oorspronkelijk_bouwjaar is 'N4 - Oorspronkelijk bouwjaar pand';
comment on column pand.oppervlakte is 'N6 - Oppervlakte pand';
comment on column pand.geom_bovenaanzicht is 'GM_Surface - Pandgeometrie bovenaanzicht';
comment on column pand.geom_maaiveld is 'GM_MultiSurface - Pandgeometrie maaiveld';
comment on column pand.status is 'AN80 - Pandstatus';
comment on column pand.relve_hoogteligging is 'N1 - Relatieve hoogteligging pand';
comment on column pand.status_voortgang_bouw is 'AN24 - Status voortgang bouw';

create table prs(
	sc_identif varchar2(32) not null,
	clazz varchar2(255)
);
alter table prs add constraint prs_pk primary key(sc_identif);

comment on table prs is 'RSGB class PERSOON. Subclass van: SUBJECT. Directe superclass van: NATUURLIJK PERSOON, NIET-NATUURLIJK PERSOON';
comment on column prs.sc_identif is '[PK] AN32, FK naar subject.identif - Identificatie';
comment on column prs.clazz is 'Aanduiding subclass';

create table rsdoc(
	nummer varchar2(9) not null,
	aand_inhouding_of_vermissing varchar2(1),
	autoriteit_uitgifte varchar2(6),
	datum_inhouding_of_vermissing decimal(8,0),
	datum_uitgifte decimal(8,0),
	eindd_geldh_document decimal(8,0),
	lengte_houder decimal(8,0),
	fk_7rds_rsdoccode varchar2(2)
);
alter table rsdoc add constraint rsdoc_pk primary key(nummer);

comment on table rsdoc is 'RSGB class REISDOCUMENT';
comment on column rsdoc.nummer is '[PK] AN9 - Reisdocumentnummer';
comment on column rsdoc.aand_inhouding_of_vermissing is 'AN1 - Aanduiding inhouding of vermissing';
comment on column rsdoc.autoriteit_uitgifte is 'AN6 - Autoriteit uitgifte';
comment on column rsdoc.datum_inhouding_of_vermissing is 'N8 - Datum inhouding of vermissing';
comment on column rsdoc.datum_uitgifte is 'N8 - Datum uitgifte';
comment on column rsdoc.eindd_geldh_document is 'N8 - Einddatum geldigheid document';
comment on column rsdoc.lengte_houder is 'N8 - Lengte houder';
comment on column rsdoc.fk_7rds_rsdoccode is '[FK] A2, FK naar rsdocsoort.rsdoccode: "Referentielijst REISDOCUMENT.Soort"';

create table scheiding(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table scheiding add constraint scheiding_pk primary key(identif);
insert into user_sdo_geom_metadata values('scheiding', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table scheiding add(geom sdo_geometry );
CREATE INDEX scheiding_geom1_idx ON scheiding (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=COLLECTION');

comment on table scheiding is 'RSGB class SCHEIDING';
comment on column scheiding.identif is '[PK] NEN3610ID - Identificatie scheiding';
comment on column scheiding.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid scheiding';
comment on column scheiding.geom is 'LijnVlak - Geometrie scheiding';
comment on column scheiding.relve_hoogteligging is 'N1 - Relatieve hoogteligging scheiding';
comment on column scheiding.status is 'A8 - Status scheiding';
comment on column scheiding.type is 'AN40 - Type scheiding';

create table spoor(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	functie varchar2(25),
	relve_hoogteligging decimal(1,0),
	status varchar2(8)
);
alter table spoor add constraint spoor_pk primary key(identif);
insert into user_sdo_geom_metadata values('spoor', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table spoor add(geom sdo_geometry );
CREATE INDEX spoor_geom1_idx ON spoor (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=LINE');

comment on table spoor is 'RSGB class SPOOR';
comment on column spoor.identif is '[PK] NEN3610ID - Identificatie spoor';
comment on column spoor.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid spoor';
comment on column spoor.functie is 'AN25 - Functie spoor';
comment on column spoor.geom is 'GM_Curve - Geometrie spoor';
comment on column spoor.relve_hoogteligging is 'N1 - Relatieve hoogteligging spoor';
comment on column spoor.status is 'A8 - Status spoor';

create table stadsdeel(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	naam varchar2(40),
	status varchar2(8)
);
alter table stadsdeel add constraint stadsdeel_pk primary key(identif);
insert into user_sdo_geom_metadata values('stadsdeel', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table stadsdeel add(geom sdo_geometry );
CREATE INDEX stadsdeel_geom1_idx ON stadsdeel (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table stadsdeel is 'RSGB class STADSDEEL';
comment on column stadsdeel.identif is '[PK] NEN3610ID - Identificatie stadsdeel';
comment on column stadsdeel.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid stadsdeel';
comment on column stadsdeel.relve_hoogteligging is 'N1 - Relatieve hoogteligging stadsdeel';
comment on column stadsdeel.geom is 'GM_Surface - Stadsdeelgeometrie';
comment on column stadsdeel.naam is 'AN40 - Stadsdeelnaam';
comment on column stadsdeel.status is 'A8 - Status stadsdeel';

create table standplaats(
	sc_identif varchar2(16) not null,
	indic_geconst varchar2(1),
	status varchar2(80),
	fk_4nra_sc_identif varchar2(16)
);
alter table standplaats add constraint standplaats_pk primary key(sc_identif);

comment on table standplaats is 'RSGB class STANDPLAATS. Subclass van: BENOEMD TERREIN -> BENOEMD OBJECT';
comment on column standplaats.sc_identif is '[PK] AN16, FK naar benoemd_terrein.sc_identif - Benoemd object identificatie';
comment on column standplaats.indic_geconst is 'AN1 - Indicatie geconstateerde standplaats';
comment on column standplaats.status is 'AN80 - Standplaatsstatus';
comment on column standplaats.fk_4nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als hoofdadres"';

create table subject(
	identif varchar2(32) not null,
	clazz varchar2(255),
	adres_binnenland varchar2(257),
	adres_buitenland varchar2(149),
	emailadres varchar2(254),
	fax_nummer varchar2(20),
	kvk_nummer decimal(8,0),
	naam varchar2(500),
	typering varchar2(50),
	telefoonnummer varchar2(20),
	website_url varchar2(200),
	fk_13wpl_identif varchar2(4),
	fk_14aoa_identif varchar2(16),
	fk_15aoa_identif varchar2(16),
	pa_postadres_postcode varchar2(6),
	pa_postadrestype varchar2(1),
	pa_postbus__of_antwoordnummer decimal(5,0),
	fk_pa_4_wpl_identif varchar2(4),
	rn_bankrekeningnummer decimal(10,0),
	rn_bic varchar2(11),
	rn_iban varchar2(34),
	vb_adres_buitenland_1 varchar2(35),
	vb_adres_buitenland_2 varchar2(35),
	vb_adres_buitenland_3 varchar2(35),
	fk_vb_lnd_code_iso varchar2(2)
);
alter table subject add constraint subject_pk primary key(identif);

comment on table subject is 'RSGB class SUBJECT. Directe superclass van: PERSOON, VESTIGING';
comment on column subject.identif is '[PK] AN32 - Identificatie';
comment on column subject.clazz is 'Aanduiding subclass';
comment on column subject.adres_binnenland is 'AN257 - Adres binnenland';
comment on column subject.adres_buitenland is 'AN149 - Adres buitenland';
comment on column subject.emailadres is 'AN254 - Emailadres';
comment on column subject.fax_nummer is 'AN20 - Fax-nummer';
comment on column subject.kvk_nummer is 'N8 - KvK-nummer';
comment on column subject.naam is 'AN500 - Naam';
comment on column subject.typering is 'AN50 - Subjecttypering';
comment on column subject.telefoonnummer is 'AN20 - Telefoonnummer';
comment on column subject.website_url is 'AN200 - Website-URL';
comment on column subject.fk_13wpl_identif is '[FK] AN4, FK naar wnplts.identif: "heeft als correspondentieadres"';
comment on column subject.fk_14aoa_identif is '[FK] AN16, FK naar addresseerb_obj_aand.identif: "heeft als factuuradres"';
comment on column subject.fk_15aoa_identif is '[FK] AN16, FK naar addresseerb_obj_aand.identif: "heeft als correspondentieadres"';
comment on column subject.pa_postadres_postcode is 'Groepsattribuut Postadres SUBJECT.Postadres postcode - Postadres postcode';
comment on column subject.pa_postadrestype is 'Groepsattribuut Postadres SUBJECT.Postadrestype - Postadrestype';
comment on column subject.pa_postbus__of_antwoordnummer is 'Groepsattribuut Postadres SUBJECT.Postbus- of antwoordnummer - Postbus- of antwoordnummer';
comment on column subject.fk_pa_4_wpl_identif is '[FK] AN4, FK naar wnplts.identif: "Groepsattribuut Postadres SUBJECT.woonplaats"';
comment on column subject.rn_bankrekeningnummer is 'Groepsattribuut Rekeningnummer SUBJECT.Bankrekeningnummer - Bankrekeningnummer';
comment on column subject.rn_bic is 'Groepsattribuut Rekeningnummer SUBJECT.BIC - BIC';
comment on column subject.rn_iban is 'Groepsattribuut Rekeningnummer SUBJECT.IBAN - IBAN';
comment on column subject.vb_adres_buitenland_1 is 'Groepsattribuut Verblijf buitenland SUBJECT.Adres buitenland 1 - Adres buitenland 1';
comment on column subject.vb_adres_buitenland_2 is 'Groepsattribuut Verblijf buitenland SUBJECT.Adres buitenland 2 - Adres buitenland 2';
comment on column subject.vb_adres_buitenland_3 is 'Groepsattribuut Verblijf buitenland SUBJECT.Adres buitenland 3 - Adres buitenland 3';
comment on column subject.fk_vb_lnd_code_iso is '[FK] A2, FK naar land.code_iso: "Groepsattribuut referentielijst Land verblijfadres"';

create table verblijfsobj(
	sc_identif varchar2(16) not null,
	aantal_kamers decimal(2,0),
	hoogste_bouwlaag decimal(3,0),
	indic_geconstateerd varchar2(1),
	laagste_bouwlaag decimal(3,0),
	ontsluiting_verdieping varchar2(3),
	soort_woonobj decimal(1,0),
	toegang_bouwlaag decimal(3,0),
	status varchar2(80),
	fk_11nra_sc_identif varchar2(16)
);
alter table verblijfsobj add constraint verblijfsobj_pk primary key(sc_identif);

comment on table verblijfsobj is 'RSGB class VERBLIJFSOBJECT. Subclass van: GEBOUWD OBJECT -> BENOEMD OBJECT';
comment on column verblijfsobj.sc_identif is '[PK] AN16, FK naar gebouwd_obj.sc_identif - Benoemd object identificatie';
comment on column verblijfsobj.aantal_kamers is 'N2 - Aantal kamers';
comment on column verblijfsobj.hoogste_bouwlaag is 'N3 - Hoogste bouwlaag verblijfsobject';
comment on column verblijfsobj.indic_geconstateerd is 'AN1 - Indicatie geconstateerd verblijfsobject';
comment on column verblijfsobj.laagste_bouwlaag is 'N3 - Laagste bouwlaag verblijfsobject';
comment on column verblijfsobj.ontsluiting_verdieping is 'AN3 - Ontsluiting verdieping';
comment on column verblijfsobj.soort_woonobj is 'N1 - Soort woonobject';
comment on column verblijfsobj.toegang_bouwlaag is 'N3 - Toegang bouwlaag verblijfsobject';
comment on column verblijfsobj.status is 'AN80 - Verblijfsobjectstatus';
comment on column verblijfsobj.fk_11nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als hoofdadres"';

create table verblijfstitel(
	aand decimal(2,0) not null,
	begindatum_geldh varchar2(19),
	eindd_geldh varchar2(19),
	omschr varchar2(100)
);
alter table verblijfstitel add constraint verblijfstitel_pk primary key(aand);

comment on table verblijfstitel is 'RSGB class VERBLIJFSTITEL';
comment on column verblijfstitel.aand is '[PK] N2 - Aanduiding verblijfstitel';
comment on column verblijfstitel.eindd_geldh is 'OnvolledigeDatum - Einddatum geldigheid verblijfstitel';
comment on column verblijfstitel.omschr is 'AN100 - Verblijfstitelomschrijving';

create table vestg(
	sc_identif varchar2(32) not null,
	activiteit_omschr varchar2(2000),
	datum_aanvang varchar2(19),
	datum_beeindiging varchar2(19),
	datum_voortzetting varchar2(19),
	fulltime_werkzame_mannen decimal(5,0),
	fulltime_werkzame_vrouwen decimal(5,0),
	parttime_werkzame_mannen decimal(5,0),
	parttime_werkzame_vrouwen decimal(5,0),
	toevoeging_adres varchar2(100),
	verkorte_naam varchar2(45),
	typering varchar2(26),
	fk_15ond_kvk_nummer decimal(8,0),
	fk_16tgo_identif varchar2(16),
	fk_17mac_kvk_nummer decimal(8,0),
	fk_18ves_sc_identif varchar2(32),
	fk_19mac_kvk_nummer decimal(8,0),
	fk_20aoa_identif varchar2(16),
	sa_indic_hoofdactiviteit varchar2(3),
	fk_sa_sbi_activiteit_sbi_code varchar2(6)
);
alter table vestg add constraint vestg_pk primary key(sc_identif);

comment on table vestg is 'RSGB class VESTIGING. Subclass van: SUBJECT';
comment on column vestg.sc_identif is '[PK] AN32, FK naar subject.identif - Identificatie';
comment on column vestg.activiteit_omschr is 'AN2000 - Activiteit omschrijving';
comment on column vestg.datum_aanvang is 'OnvolledigeDatum - Datum aanvang';
comment on column vestg.datum_beeindiging is 'OnvolledigeDatum - Datum beeindiging';
comment on column vestg.datum_voortzetting is 'OnvolledigeDatum - Datum voortzetting';
comment on column vestg.fulltime_werkzame_mannen is 'N5 - Fulltime werkzame mannen';
comment on column vestg.fulltime_werkzame_vrouwen is 'N5 - Fulltime werkzame vrouwen';
comment on column vestg.parttime_werkzame_mannen is 'N5 - Parttime werkzame mannen';
comment on column vestg.parttime_werkzame_vrouwen is 'N5 - Parttime werkzame vrouwen';
comment on column vestg.toevoeging_adres is 'AN100 - Toevoeging adres';
comment on column vestg.verkorte_naam is 'AN45 - Verkorte naam';
comment on column vestg.typering is 'AN26 - Vestigingtypering';
comment on column vestg.fk_15ond_kvk_nummer is '[FK] N8, FK naar ondrnmng.kvk_nummer: "betreft uitoefening van activiteiten door"';
comment on column vestg.fk_16tgo_identif is '[FK] AN16, FK naar benoemd_obj.identif: "heeft hoofdlocatie in of op"';
comment on column vestg.fk_17mac_kvk_nummer is '[FK] N8, FK naar maatschapp_activiteit.kvk_nummer: "betreft uitoefening van activiteiten door"';
comment on column vestg.fk_18ves_sc_identif is '[FK] AN32, FK naar vestg.sc_identif (is FK naar superclass SUBJECT): "is samengevoegd met"';
comment on column vestg.fk_19mac_kvk_nummer is '[FK] N8, FK naar maatschapp_activiteit.kvk_nummer: "is hoofdvestiging van"';
comment on column vestg.fk_20aoa_identif is '[FK] AN16, FK naar addresseerb_obj_aand.identif: "heeft als locatie-adres"';
comment on column vestg.sa_indic_hoofdactiviteit is 'Groepsattribuut SBI activiteit VESTIGING.Indicatie hoofdactiviteit - Indicatie hoofdactiviteit';
comment on column vestg.fk_sa_sbi_activiteit_sbi_code is '[FK] AN6, FK naar sbi_activiteit.sbi_code: "Groepsattribuut referentielijst SBI activiteit"';

create table vrijstaand_vegetatie_obj(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table vrijstaand_vegetatie_obj add constraint vrijstaand_vegetatie_obj_pk primary key(identif);
insert into user_sdo_geom_metadata values('vrijstaand_vegetatie_obj', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table vrijstaand_vegetatie_obj add(geom sdo_geometry );
CREATE INDEX vrijstaand_vegetatie_obj_1_idx ON vrijstaand_vegetatie_obj (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table vrijstaand_vegetatie_obj is 'RSGB class VRIJSTAAND VEGETATIE OBJECT';
comment on column vrijstaand_vegetatie_obj.identif is '[PK] NEN3610ID - Identificatie vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_obj.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_obj.geom is 'GM_Surface - Geometrie vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_obj.relve_hoogteligging is 'N1 - Relatieve hoogteligging vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_obj.status is 'A8 - Status vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_obj.type is 'AN40 - Type vrijstaand vegetatie object';

create table waterdeel(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	droogvallend varchar2(1),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40),
	fk_7opr_identifcode varchar2(16)
);
alter table waterdeel add constraint waterdeel_pk primary key(identif);
insert into user_sdo_geom_metadata values('waterdeel', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table waterdeel add(geom sdo_geometry );
CREATE INDEX waterdeel_geom1_idx ON waterdeel (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table waterdeel is 'RSGB class WATERDEEL. Directe superclass van: WATERVAKONDERDEEL';
comment on column waterdeel.identif is '[PK] NEN3610ID - Identificatie waterdeel';
comment on column waterdeel.clazz is 'Aanduiding subclass';
comment on column waterdeel.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid waterdeel';
comment on column waterdeel.droogvallend is 'AN1 - Droogvallend';
comment on column waterdeel.geom is 'GM_Surface - Geometrie waterdeel';
comment on column waterdeel.relve_hoogteligging is 'N1 - Relatieve hoogteligging waterdeel';
comment on column waterdeel.status is 'A8 - Status waterdeel';
comment on column waterdeel.type is 'AN40 - Type waterdeel';
comment on column waterdeel.fk_7opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table watervakonderdeel(
	sc_identif varchar2(255) not null,
	fk_1wad_identif varchar2(255)
);
alter table watervakonderdeel add constraint watervakonderdeel_pk primary key(sc_identif);

comment on table watervakonderdeel is 'RSGB class WATERVAKONDERDEEL. Subclass van: WATERDEEL';
comment on column watervakonderdeel.sc_identif is '[PK] NEN3610ID, FK naar waterdeel.identif - Identificatie waterdeel';
comment on column watervakonderdeel.fk_1wad_identif is '[FK] NEN3610ID, FK naar waterdeel.identif';

create table waterschap(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	naam varchar2(40)
);
alter table waterschap add constraint waterschap_pk primary key(identif);
insert into user_sdo_geom_metadata values('waterschap', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table waterschap add(geom sdo_geometry );
CREATE INDEX waterschap_geom1_idx ON waterschap (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table waterschap is 'RSGB class WATERSCHAP';
comment on column waterschap.identif is '[PK] NEN3610ID - Identificatie waterschap';
comment on column waterschap.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid waterschap';
comment on column waterschap.relve_hoogteligging is 'N1 - Relatieve hoogteligging waterschap';
comment on column waterschap.status is 'A8 - Status waterschap';
comment on column waterschap.geom is 'GM_Surface - Waterschapgeometrie';
comment on column waterschap.naam is 'AN40 - Waterschapnaam';

create table wegdeel(
	dat_beg_geldh varchar2(19),
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	functie varchar2(25),
	fysiek_voork varchar2(20),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	fk_8opr_identifcode varchar2(16)
);
alter table wegdeel add constraint wegdeel_pk primary key(identif);
insert into user_sdo_geom_metadata values('wegdeel', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table wegdeel add(geom sdo_geometry );
CREATE INDEX wegdeel_geom1_idx ON wegdeel (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table wegdeel is 'RSGB class WEGDEEL. Directe superclass van: WEGVAKONDERDEEL';
comment on column wegdeel.identif is '[PK] NEN3610ID - Identificatie wegdeel';
comment on column wegdeel.clazz is 'Aanduiding subclass';
comment on column wegdeel.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid wegdeel';
comment on column wegdeel.functie is 'AN25 - Functie wegdeel';
comment on column wegdeel.fysiek_voork is 'AN20 - Fysiek voorkomen wegdeel';
comment on column wegdeel.geom is 'GM_Surface - Geometrie wegdeel';
comment on column wegdeel.relve_hoogteligging is 'N1 - Relatieve hoogteligging wegdeel';
comment on column wegdeel.status is 'A8 - Status wegdeel';
comment on column wegdeel.fk_8opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table wegvakonderdeel(
	sc_identif varchar2(255) not null,
	fk_1wgd_identif varchar2(255)
);
alter table wegvakonderdeel add constraint wegvakonderdeel_pk primary key(sc_identif);

comment on table wegvakonderdeel is 'RSGB class WEGVAKONDERDEEL. Subclass van: WEGDEEL';
comment on column wegvakonderdeel.sc_identif is '[PK] NEN3610ID, FK naar wegdeel.identif - Identificatie wegdeel';
comment on column wegvakonderdeel.fk_1wgd_identif is '[FK] NEN3610ID, FK naar wegdeel.identif';

create table wijk(
	dat_beg_geldh varchar2(19),
	code decimal(6,0) not null,
	datum_einde_geldh varchar2(19),
	identif_imgeowyk varchar2(255),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	naam varchar2(80)
);
alter table wijk add constraint wijk_pk primary key(code);
insert into user_sdo_geom_metadata values('wijk', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table wijk add(geom sdo_geometry );
CREATE INDEX wijk_geom1_idx ON wijk (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table wijk is 'RSGB class WIJK';
comment on column wijk.code is '[PK] N6 - Wijkcode';
comment on column wijk.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid wijk';
comment on column wijk.identif_imgeowyk is 'NEN3610ID - Identificatie IMGeoWYK';
comment on column wijk.relve_hoogteligging is 'N1 - Relatieve hoogteligging wijk';
comment on column wijk.status is 'A8 - Status wijk';
comment on column wijk.geom is 'GM_Surface - Wijkgeometrie';
comment on column wijk.naam is 'AN80 - Wijknaam';

create table wnplts(
	dat_beg_geldh varchar2(19),
	identif varchar2(4) not null,
	datum_einde_geldh varchar2(19),
	indic_geconst varchar2(1),
	naam varchar2(80),
	naam_nen varchar2(24),
	status varchar2(80),
	fk_7gem_code decimal(4,0)
);
alter table wnplts add constraint wnplts_pk primary key(identif);
insert into user_sdo_geom_metadata values('wnplts', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table wnplts add(geom sdo_geometry );
CREATE INDEX wnplts_geom1_idx ON wnplts (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table wnplts is 'RSGB class WOONPLAATS';
comment on column wnplts.identif is '[PK] AN4 - Woonplaatsidentificatie';
comment on column wnplts.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid woonplaats';
comment on column wnplts.indic_geconst is 'AN1 - Indicatie geconstateerde woonplaats';
comment on column wnplts.geom is 'GM_Surface - Woonplaatsgeometrie';
comment on column wnplts.naam is 'AN80 - Woonplaatsnaam';
comment on column wnplts.naam_nen is 'AN24 - Woonplaatsnaam NEN';
comment on column wnplts.status is 'AN80 - Woonplaatsstatus';
comment on column wnplts.fk_7gem_code is '[FK] N4, FK naar gemeente.code: "ligt in"';

create table woz_deelobj(
	dat_beg_geldh_deelobj decimal(8,0),
	nummer decimal(6,0) not null,
	code varchar2(4),
	datum_einde_geldh_deelobj decimal(8,0),
	status decimal(2,0),
	fk_4pnd_identif varchar2(16),
	fk_5tgo_identif varchar2(16),
	fk_6woz_nummer decimal(12,0)
);
alter table woz_deelobj add constraint woz_deelobj_pk primary key(nummer);

comment on table woz_deelobj is 'RSGB class WOZ-DEELOBJECT';
comment on column woz_deelobj.nummer is '[PK] N6 - Nummer WOZ-deelobject';
comment on column woz_deelobj.code is 'AN4 - Code WOZ-deelobject';
comment on column woz_deelobj.datum_einde_geldh_deelobj is 'N8 - Datum einde geldigheid deelobject';
comment on column woz_deelobj.status is 'N2 - Status WOZ-deelobject';
comment on column woz_deelobj.fk_4pnd_identif is '[FK] AN16, FK naar pand.identif: "bestaat uit"';
comment on column woz_deelobj.fk_5tgo_identif is '[FK] AN16, FK naar benoemd_obj.identif: "bestaat uit"';
comment on column woz_deelobj.fk_6woz_nummer is '[FK] N12, FK naar woz_obj.nummer: "is onderdeel van"';

create table woz_obj(
	dat_beg_geldh varchar2(19),
	nummer decimal(12,0) not null,
	datum_einde_geldh varchar2(19),
	gebruikscode decimal(2,0),
	grondoppervlakte decimal(11,0),
	soort_obj_code decimal(4,0),
	status decimal(2,0),
	vastgestelde_waarde decimal(11,0),
	waardepeildatum date
);
alter table woz_obj add constraint woz_obj_pk primary key(nummer);
insert into user_sdo_geom_metadata values('woz_obj', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table woz_obj add(geom sdo_geometry );
CREATE INDEX woz_obj_geom1_idx ON woz_obj (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table woz_obj is 'RSGB class WOZ-OBJECT';
comment on column woz_obj.nummer is '[PK] N12 - WOZ-objectnummer';
comment on column woz_obj.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid WOZ-object';
comment on column woz_obj.gebruikscode is 'N2 - Gebruikscode';
comment on column woz_obj.geom is 'GM_Surface - Geometrie WOZ-object';
comment on column woz_obj.grondoppervlakte is 'N11 - Grondoppervlakte';
comment on column woz_obj.soort_obj_code is 'N4 - Soort-object-code';
comment on column woz_obj.status is 'N2 - Status WOZ-object';
comment on column woz_obj.vastgestelde_waarde is 'N11 - Vastgestelde waarde';
comment on column woz_obj.waardepeildatum is 'Datum - Waardepeildatum';

create table woz_waarde(
	waardepeildatum decimal(8,0),
	status_beschikking decimal(2,0),
	toestandspeildatum decimal(8,0),
	vastgestelde_waarde decimal(11,0),
	fk_1woz_nummer decimal(12,0)
);

comment on table woz_waarde is 'RSGB class WOZ-WAARDE';
comment on column woz_waarde.status_beschikking is 'N2 - Status beschikking';
comment on column woz_waarde.toestandspeildatum is 'N8 - Toestandspeildatum';
comment on column woz_waarde.vastgestelde_waarde is 'N11 - Vastgestelde waarde';
comment on column woz_waarde.fk_1woz_nummer is '[FK] N12, FK naar woz_obj.nummer';

create table zak_recht(
	kadaster_identif varchar2(255) not null,
	eindd_recht varchar2(255),
	indic_betrokken_in_splitsing varchar2(255),
	ingangsdatum_recht varchar2(19),
	fk_7koz_kad_identif decimal(15,0),
	fk_8pes_sc_identif varchar2(32),
	ar_noemer decimal(8,0),
	ar_teller decimal(8,0),
	fk_2aard_recht_verkort_aand varchar2(4),
	fk_3avr_aand varchar2(6)
);
alter table zak_recht add constraint zak_recht_pk primary key(kadaster_identif);

comment on table zak_recht is 'RSGB class ZAKELIJK RECHT';
comment on column zak_recht.kadaster_identif is '[PK]  - Kadaster identificatie zakelijk recht';
comment on column zak_recht.eindd_recht is '[geen RSGB type] - Einddatum recht';
comment on column zak_recht.indic_betrokken_in_splitsing is '[geen RSGB type] - Indicatie betrokken in splitsing';
comment on column zak_recht.ingangsdatum_recht is 'OnvolledigeDatum - Ingangsdatum recht';
comment on column zak_recht.fk_7koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif: "betreft"';
comment on column zak_recht.fk_8pes_sc_identif is '[FK] AN32, FK naar prs.sc_identif (is FK naar superclass SUBJECT): "heeft als gerechtigde"';
comment on column zak_recht.ar_noemer is 'Groepsattribuut Aandeel in recht ZAKELIJK RECHT.Noemer - Noemer';
comment on column zak_recht.ar_teller is 'Groepsattribuut Aandeel in recht ZAKELIJK RECHT.Teller - Teller';
comment on column zak_recht.fk_2aard_recht_verkort_aand is '[FK] AN4, FK naar aard_recht_verkort.aand: "Referentielijst ZAKELIJK RECHT.Aanduiding aard recht verkort"';
comment on column zak_recht.fk_3avr_aand is '[FK] AN6, FK naar aard_verkregen_recht.aand: "Referentielijst ZAKELIJK RECHT.Aanduiding aard verkregen recht"';

create table zak_recht_aantek(
	kadaster_identif_aantek_recht varchar2(255) not null,
	aard_aantek_recht varchar2(255),
	begindatum_aantek_recht varchar2(19),
	beschrijving_aantek_recht varchar2(255),
	eindd_aantek_recht varchar2(255),
	fk_5zkr_kadaster_identif varchar2(255),
	fk_6pes_sc_identif varchar2(32)
);
alter table zak_recht_aantek add constraint zak_recht_aantek_pk primary key(kadaster_identif_aantek_recht);

comment on table zak_recht_aantek is 'RSGB class ZAKELIJK RECHT AANTEKENING';
comment on column zak_recht_aantek.kadaster_identif_aantek_recht is '[PK]  - Kadaster identificatie aantekening recht';
comment on column zak_recht_aantek.aard_aantek_recht is '[geen RSGB type] - Aard aantekening recht';
comment on column zak_recht_aantek.begindatum_aantek_recht is 'OnvolledigeDatum - Begindatum aantekening recht';
comment on column zak_recht_aantek.beschrijving_aantek_recht is '[geen RSGB type] - Beschrijving aantekening recht';
comment on column zak_recht_aantek.eindd_aantek_recht is '[geen RSGB type] - Einddatum aantekening recht';
comment on column zak_recht_aantek.fk_5zkr_kadaster_identif is '[FK] , FK naar zak_recht.kadaster_identif: "behoort bij"';
comment on column zak_recht_aantek.fk_6pes_sc_identif is '[FK] AN32, FK naar prs.sc_identif (is FK naar superclass SUBJECT): "heeft betrokken"';

create table gebouwd_obj_gebruiksdoel(
	gebruiksdoel_gebouwd_obj varchar2(80),
	fk_gbo_sc_identif varchar2(16)
);

comment on table gebouwd_obj_gebruiksdoel is 'RSGB class voor een-op-meer kolom GEBOUWD OBJECT Gebruiksdoel gebouwd object';
comment on column gebouwd_obj_gebruiksdoel.gebruiksdoel_gebouwd_obj is 'AN80 - Gebruiksdoel gebouwd object';
comment on column gebouwd_obj_gebruiksdoel.fk_gbo_sc_identif is '[FK] AN16, FK naar gebouwd_obj.sc_identif (is FK naar superclass BENOEMD OBJECT)';

create table overig_terrein_gebruiksdoel(
	gebruiksdoel_overig_terrein varchar2(80),
	fk_otr_sc_identif varchar2(16)
);

comment on table overig_terrein_gebruiksdoel is 'RSGB class voor een-op-meer kolom OVERIG TERREIN Gebruiksdoel overig terrein';
comment on column overig_terrein_gebruiksdoel.gebruiksdoel_overig_terrein is 'AN80 - Gebruiksdoel overig terrein';
comment on column overig_terrein_gebruiksdoel.fk_otr_sc_identif is '[FK] AN16, FK naar overig_terrein.sc_identif (is FK naar superclass BENOEMD OBJECT)';

create table vestg_naam(
	naam varchar2(500),
	fk_ves_sc_identif varchar2(32)
);

comment on table vestg_naam is 'RSGB class voor een-op-meer kolom VESTIGING (Handels)naam';
comment on column vestg_naam.naam is 'AN500 - (Handels)naam';
comment on column vestg_naam.fk_ves_sc_identif is '[FK] AN32, FK naar vestg.sc_identif (is FK naar superclass SUBJECT)';

create table functionaris(
	fk_sc_lh_pes_sc_identif varchar2(32) not null,
	fk_sc_rh_pes_sc_identif varchar2(32) not null,
	beperking_bev_in_euros decimal(18,0),
	bv_beperking_in_geld decimal(18,0),
	bv_omschr_ovrg_beperkingen varchar2(2000),
	bv_ovrg_volmacht varchar2(3),
	bv_soort_handeling varchar2(35),
	bev_met_andere_prsn varchar2(3),
	datum_toetr varchar2(19),
	datum_uittreding varchar2(19),
	functie varchar2(80),
	functionaristypering varchar2(35),
	indic_statutair_volmacht varchar2(3),
	ovrg_beperking_bev varchar2(3),
	soort_bev varchar2(30),
	volledig_beperkt_volmacht varchar2(1)
);
alter table functionaris add constraint functionaris_pk primary key(fk_sc_lh_pes_sc_identif,fk_sc_rh_pes_sc_identif);

comment on table functionaris is 'RSGB superclass FUNCTIONARIS';
comment on column functionaris.fk_sc_lh_pes_sc_identif is '[FK] AN32, FK naar prs.sc_identif (is FK naar superclass SUBJECT)';
comment on column functionaris.fk_sc_rh_pes_sc_identif is '[FK] AN32, FK naar prs.sc_identif (is FK naar superclass SUBJECT)';
comment on column functionaris.beperking_bev_in_euros is 'N18 - Beperking bevoegdheid  in euros';
comment on column functionaris.bv_beperking_in_geld is 'Groepsattribuut Beperkte volmacht FUNCTIONARIS.Beperking in geld - Beperking in geld';
comment on column functionaris.bv_omschr_ovrg_beperkingen is 'Groepsattribuut Beperkte volmacht FUNCTIONARIS.Omschrijving overige beperkingen - Omschrijving overige beperkingen';
comment on column functionaris.bv_ovrg_volmacht is 'Groepsattribuut Beperkte volmacht FUNCTIONARIS.Overige volmacht - Overige volmacht';
comment on column functionaris.bv_soort_handeling is 'Groepsattribuut Beperkte volmacht FUNCTIONARIS.Soort handeling - Soort handeling';
comment on column functionaris.bev_met_andere_prsn is 'AN3 - Bevoegdheid met andere personen';
comment on column functionaris.datum_toetr is 'OnvolledigeDatum - Datum toetreding';
comment on column functionaris.datum_uittreding is 'OnvolledigeDatum - Datum uittreding';
comment on column functionaris.functie is 'AN80 - Functie';
comment on column functionaris.functionaristypering is 'AN35 - Functionaristypering';
comment on column functionaris.indic_statutair_volmacht is 'AN3 - Indicatie statutair volmacht';
comment on column functionaris.ovrg_beperking_bev is 'AN3 - Overige beperking bevoegdheid';
comment on column functionaris.soort_bev is 'AN30 - Soort Bevoegdheid';
comment on column functionaris.volledig_beperkt_volmacht is 'AN1 - Volledig Beperkt volmacht';

create table huishoudenrel(
	fk_sc_lh_inp_sc_identif varchar2(32) not null,
	fk_sc_rh_hhd_nummer decimal(12,0) not null,
	huishoudenrelcode decimal(1,0)
);
alter table huishoudenrel add constraint huishoudenrel_pk primary key(fk_sc_lh_inp_sc_identif,fk_sc_rh_hhd_nummer);

comment on table huishoudenrel is 'RSGB superclass HUISHOUDENRELATIE';
comment on column huishoudenrel.fk_sc_lh_inp_sc_identif is '[FK] AN32, FK naar ingeschr_nat_prs.sc_identif (is FK naar superclass SUBJECT)';
comment on column huishoudenrel.fk_sc_rh_hhd_nummer is '[FK] N12, FK naar huishouden.nummer';
comment on column huishoudenrel.huishoudenrelcode is 'N1 - Huishoudenrelatiecode';

create table huw_ger_partn(
	fk_sc_lh_inp_sc_identif varchar2(32) not null,
	fk_sc_rh_inp_sc_identif varchar2(32) not null,
	hs_datum_aangaan decimal(8,0),
	fk_hs_lnd_code_iso varchar2(2),
	hs_plaats varchar2(40),
	ho_datum_ontb_huw_ger_partn decimal(8,0),
	fk_ho_lnd_code_iso varchar2(2),
	ho_plaats_ontb_huw_ger_partn varchar2(40),
	ho_reden_ontb_huw_ger_partn varchar2(1),
	soort_verbintenis varchar2(1)
);
alter table huw_ger_partn add constraint huw_ger_partn_pk primary key(fk_sc_lh_inp_sc_identif,fk_sc_rh_inp_sc_identif);

comment on table huw_ger_partn is 'RSGB superclass HUWELIJK/GEREGISTREERD PARTNERSCHAP';
comment on column huw_ger_partn.fk_sc_lh_inp_sc_identif is '[FK] AN32, FK naar ingeschr_nat_prs.sc_identif (is FK naar superclass SUBJECT)';
comment on column huw_ger_partn.fk_sc_rh_inp_sc_identif is '[FK] AN32, FK naar ingeschr_nat_prs.sc_identif (is FK naar superclass SUBJECT)';
comment on column huw_ger_partn.hs_datum_aangaan is 'Groepsattribuut Sluiting/aangaan HUWELIJK/GEREGISTREERD PARTNERSCHAP.Datum huwelijkssluiting/aangaan geregistreerd partnerschap - Datum huwelijkssluiting/aangaan geregistreerd partnerschap';
comment on column huw_ger_partn.fk_hs_lnd_code_iso is '[FK] A2, FK naar land.code_iso: "Groepsattribuut referentielijst Land huwelijkssluiting/aangaan geregistreerd partnerschap"';
comment on column huw_ger_partn.hs_plaats is 'Groepsattribuut Sluiting/aangaan HUWELIJK/GEREGISTREERD PARTNERSCHAP.Plaats huwelijkssluiting/aangaan geregistreerd partnerschap - Plaats huwelijkssluiting/aangaan geregistreerd partnerschap';
comment on column huw_ger_partn.ho_datum_ontb_huw_ger_partn is 'Groepsattribuut Ontbinding HUWELIJK/GEREGISTREERD PARTNERSCHAP.Datum ontbinding huwelijk/geregistreerd partnerschap - Datum ontbinding huwelijk/geregistreerd partnerschap';
comment on column huw_ger_partn.fk_ho_lnd_code_iso is '[FK] A2, FK naar land.code_iso: "Groepsattribuut referentielijst Land ontbinding huwelijk/geregistreerd partnerschap"';
comment on column huw_ger_partn.ho_plaats_ontb_huw_ger_partn is 'Groepsattribuut Ontbinding HUWELIJK/GEREGISTREERD PARTNERSCHAP.Plaats ontbinding huwelijk/geregistreerd partnerschap - Plaats ontbinding huwelijk/geregistreerd partnerschap';
comment on column huw_ger_partn.ho_reden_ontb_huw_ger_partn is 'Groepsattribuut Ontbinding HUWELIJK/GEREGISTREERD PARTNERSCHAP.Reden ontbinding huwelijk/geregistreerd partnerschap - Reden ontbinding huwelijk/geregistreerd partnerschap';
comment on column huw_ger_partn.soort_verbintenis is 'AN1 - Soort verbintenis';

create table kad_onrrnd_zk_his_rel(
	fk_sc_lh_koz_kad_identif decimal(15,0) not null,
	fk_sc_rh_koz_kad_identif decimal(15,0) not null,
	aard varchar2(255),
	overgangsgrootte varchar2(255)
);
alter table kad_onrrnd_zk_his_rel add constraint kad_onrrnd_zk_his_rel_pk primary key(fk_sc_lh_koz_kad_identif,fk_sc_rh_koz_kad_identif);

comment on table kad_onrrnd_zk_his_rel is 'RSGB superclass KADASTRALE ONROERENDE ZAAK HISTORIE RELATIE';
comment on column kad_onrrnd_zk_his_rel.fk_sc_lh_koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif';
comment on column kad_onrrnd_zk_his_rel.fk_sc_rh_koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif';
comment on column kad_onrrnd_zk_his_rel.aard is ' - Aard';
comment on column kad_onrrnd_zk_his_rel.overgangsgrootte is ' - Overgangsgrootte';

create table locaand_adres(
	fk_sc_lh_aoa_identif varchar2(16) not null,
	fk_sc_rh_woz_nummer decimal(12,0) not null,
	locomschr varchar2(40)
);
alter table locaand_adres add constraint locaand_adres_pk primary key(fk_sc_lh_aoa_identif,fk_sc_rh_woz_nummer);

comment on table locaand_adres is 'RSGB superclass LOCATIEAANDUIDING ADRES';
comment on column locaand_adres.fk_sc_lh_aoa_identif is '[FK] AN16, FK naar addresseerb_obj_aand.identif';
comment on column locaand_adres.fk_sc_rh_woz_nummer is '[FK] N12, FK naar woz_obj.nummer';
comment on column locaand_adres.locomschr is 'AN40 - Locatieomschrijving';

create table locaand_openb_rmte(
	fk_sc_lh_opr_identifcode varchar2(16) not null,
	fk_sc_rh_woz_nummer decimal(12,0) not null,
	locomschr varchar2(40)
);
alter table locaand_openb_rmte add constraint locaand_openb_rmte_pk primary key(fk_sc_lh_opr_identifcode,fk_sc_rh_woz_nummer);

comment on table locaand_openb_rmte is 'RSGB superclass LOCATIEAANDUIDING OPENBARE RUIMTE';
comment on column locaand_openb_rmte.fk_sc_lh_opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode';
comment on column locaand_openb_rmte.fk_sc_rh_woz_nummer is '[FK] N12, FK naar woz_obj.nummer';
comment on column locaand_openb_rmte.locomschr is 'AN40 - Locatieomschrijving';

create table ouder_kind_rel(
	fk_sc_lh_inp_sc_identif varchar2(32) not null,
	fk_sc_rh_inp_sc_identif varchar2(32) not null,
	datum_einde_fam_recht_betr varchar2(19),
	datum_ingang_fam_recht_betr decimal(8,0),
	ouder_aand varchar2(6)
);
alter table ouder_kind_rel add constraint ouder_kind_rel_pk primary key(fk_sc_lh_inp_sc_identif,fk_sc_rh_inp_sc_identif);

comment on table ouder_kind_rel is 'RSGB superclass OUDER-KIND-RELATIE';
comment on column ouder_kind_rel.fk_sc_lh_inp_sc_identif is '[FK] AN32, FK naar ingeschr_nat_prs.sc_identif (is FK naar superclass SUBJECT)';
comment on column ouder_kind_rel.fk_sc_rh_inp_sc_identif is '[FK] AN32, FK naar ingeschr_nat_prs.sc_identif (is FK naar superclass SUBJECT)';
comment on column ouder_kind_rel.datum_einde_fam_recht_betr is 'OnvolledigeDatum - Datum einde familierechtelijke betrekking';
comment on column ouder_kind_rel.datum_ingang_fam_recht_betr is 'N8 - Datum ingang familierechtelijke betrekking';
comment on column ouder_kind_rel.ouder_aand is 'AN6 - Ouder-aanduiding';

create table woz_belang(
	fk_sc_lh_sub_identif varchar2(32) not null,
	fk_sc_rh_woz_nummer decimal(12,0) not null,
	aand_eigenaargebruiker varchar2(1)
);
alter table woz_belang add constraint woz_belang_pk primary key(fk_sc_lh_sub_identif,fk_sc_rh_woz_nummer);

comment on table woz_belang is 'RSGB superclass WOZ-BELANG';
comment on column woz_belang.fk_sc_lh_sub_identif is '[FK] AN32, FK naar subject.identif';
comment on column woz_belang.fk_sc_rh_woz_nummer is '[FK] N12, FK naar woz_obj.nummer';
comment on column woz_belang.aand_eigenaargebruiker is 'AN1 - Aanduiding eigenaar/gebruiker';

create table app_re_kad_perceel(
	fk_nn_lh_apr_sc_kad_identif decimal(15,0) not null,
	fk_nn_lh_apr_sc_dat_beg_geldh varchar2(19),
	fk_nn_rh_kdp_sc_kad_identif decimal(15,0) not null
);
alter table app_re_kad_perceel add constraint app_re_kad_perceel_pk primary key(fk_nn_lh_apr_sc_kad_identif,fk_nn_rh_kdp_sc_kad_identif);

comment on table app_re_kad_perceel is 'N - N relatie: APPARTEMENTSRECHT "maakt deel uit van appartementencomplex dat staat op" KADASTRAAL PERCEEL';
comment on column app_re_kad_perceel.fk_nn_lh_apr_sc_kad_identif is '[FK] N15, FK naar app_re.sc_kad_identif (is FK naar superclass KADASTRALE ONROERENDE ZAAK)';
comment on column app_re_kad_perceel.fk_nn_rh_kdp_sc_kad_identif is '[FK] N15, FK naar kad_perceel.sc_kad_identif (is FK naar superclass KADASTRALE ONROERENDE ZAAK)';

create table benoemd_obj_kad_onrrnd_zk(
	fk_nn_lh_tgo_identif varchar2(16) not null,
	fk_nn_rh_koz_kad_identif decimal(15,0) not null
);
alter table benoemd_obj_kad_onrrnd_zk add constraint benoemd_obj_kad_onrrnd_zk_pk primary key(fk_nn_lh_tgo_identif,fk_nn_rh_koz_kad_identif);

comment on table benoemd_obj_kad_onrrnd_zk is 'N - N relatie: BENOEMD OBJECT "staat op of heeft ruimtelijke overlap met" KADASTRALE ONROERENDE ZAAK';
comment on column benoemd_obj_kad_onrrnd_zk.fk_nn_lh_tgo_identif is '[FK] AN16, FK naar benoemd_obj.identif';
comment on column benoemd_obj_kad_onrrnd_zk.fk_nn_rh_koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif';

create table benoemd_terrein_benoemd_terrei(
	fk_nn_lh_btr_sc_identif varchar2(16) not null,
	fk_nn_lh_btr_dat_beg_geldh varchar2(19),
	fk_nn_rh_btr_sc_identif varchar2(16) not null
);
alter table benoemd_terrein_benoemd_terrei add constraint benoemd_terrein_benoemd_ter_pk primary key(fk_nn_lh_btr_sc_identif,fk_nn_rh_btr_sc_identif);

comment on table benoemd_terrein_benoemd_terrei is 'N - N relatie: BENOEMD TERREIN "is ontstaan uit / overgegaan in" BENOEMD TERREIN';
comment on column benoemd_terrein_benoemd_terrei.fk_nn_lh_btr_sc_identif is '[FK] AN16, FK naar benoemd_terrein.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column benoemd_terrein_benoemd_terrei.fk_nn_rh_btr_sc_identif is '[FK] AN16, FK naar benoemd_terrein.sc_identif (is FK naar superclass BENOEMD OBJECT)';

create table gemeente_gemeente(
	fk_nn_lh_gem_code decimal(4,0) not null,
	fk_nn_lh_gem_dat_beg_geldh varchar2(19),
	fk_nn_rh_gem_code decimal(4,0) not null
);
alter table gemeente_gemeente add constraint gemeente_gemeente_pk primary key(fk_nn_lh_gem_code,fk_nn_rh_gem_code);

comment on table gemeente_gemeente is 'N - N relatie: GEMEENTE "is overgegaan in" GEMEENTE';
comment on column gemeente_gemeente.fk_nn_lh_gem_code is '[FK] N4, FK naar gemeente.code';
comment on column gemeente_gemeente.fk_nn_rh_gem_code is '[FK] N4, FK naar gemeente.code';

create table kad_onrrnd_zk_kad_onrrnd_zk(
	fk_nn_lh_koz_kad_identif decimal(15,0) not null,
	fk_nn_lh_koz_dat_beg_geldh varchar2(19),
	fk_nn_rh_koz_kad_identif decimal(15,0) not null
);
alter table kad_onrrnd_zk_kad_onrrnd_zk add constraint kad_onrrnd_zk_kad_onrrnd_zk_pk primary key(fk_nn_lh_koz_kad_identif,fk_nn_rh_koz_kad_identif);

comment on table kad_onrrnd_zk_kad_onrrnd_zk is 'N - N relatie: KADASTRALE ONROERENDE ZAAK "is hoofdperceel bij mandelige" KADASTRALE ONROERENDE ZAAK';
comment on column kad_onrrnd_zk_kad_onrrnd_zk.fk_nn_lh_koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif';
comment on column kad_onrrnd_zk_kad_onrrnd_zk.fk_nn_rh_koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif';

create table ligplaats_nummeraand(
	fk_nn_lh_lpl_sc_identif varchar2(16) not null,
	fk_nn_lh_lpl_sc_dat_beg_geldh varchar2(19),
	fk_nn_rh_nra_sc_identif varchar2(16) not null
);
alter table ligplaats_nummeraand add constraint ligplaats_nummeraand_pk primary key(fk_nn_lh_lpl_sc_identif,fk_nn_rh_nra_sc_identif);

comment on table ligplaats_nummeraand is 'N - N relatie: LIGPLAATS "heeft als nevenadressen" NUMMERAANDUIDING';
comment on column ligplaats_nummeraand.fk_nn_lh_lpl_sc_identif is '[FK] AN16, FK naar ligplaats.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column ligplaats_nummeraand.fk_nn_rh_nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING)';

create table openb_rmte_gem_openb_rmte(
	fk_nn_lh_opr_identifcode varchar2(16) not null,
	fk_nn_rh_gor_identifcode varchar2(16) not null
);
alter table openb_rmte_gem_openb_rmte add constraint openb_rmte_gem_openb_rmte_pk primary key(fk_nn_lh_opr_identifcode,fk_nn_rh_gor_identifcode);

comment on table openb_rmte_gem_openb_rmte is 'N - N relatie: OPENBARE RUIMTE "maakt deel uit van" GEMEENTELIJKE OPENBARE RUIMTE';
comment on column openb_rmte_gem_openb_rmte.fk_nn_lh_opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode';
comment on column openb_rmte_gem_openb_rmte.fk_nn_rh_gor_identifcode is '[FK] AN16, FK naar gem_openb_rmte.identifcode';

create table openb_rmte_wnplts(
	fk_nn_lh_opr_identifcode varchar2(16) not null,
	fk_nn_rh_wpl_identif varchar2(4) not null
);
alter table openb_rmte_wnplts add constraint openb_rmte_wnplts_pk primary key(fk_nn_lh_opr_identifcode,fk_nn_rh_wpl_identif);

comment on table openb_rmte_wnplts is 'N - N relatie: OPENBARE RUIMTE "ligt in" WOONPLAATS';
comment on column openb_rmte_wnplts.fk_nn_lh_opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode';
comment on column openb_rmte_wnplts.fk_nn_rh_wpl_identif is '[FK] AN4, FK naar wnplts.identif';

create table rsdoc_ingeschr_nat_prs(
	fk_nn_lh_rsd_nummer varchar2(9) not null,
	fk_nn_rh_inp_sc_identif varchar2(32) not null
);
alter table rsdoc_ingeschr_nat_prs add constraint rsdoc_ingeschr_nat_prs_pk primary key(fk_nn_lh_rsd_nummer,fk_nn_rh_inp_sc_identif);

comment on table rsdoc_ingeschr_nat_prs is 'N - N relatie: REISDOCUMENT "heeft als houder" INGESCHREVEN NATUURLIJK PERSOON';
comment on column rsdoc_ingeschr_nat_prs.fk_nn_lh_rsd_nummer is '[FK] AN9, FK naar rsdoc.nummer';
comment on column rsdoc_ingeschr_nat_prs.fk_nn_rh_inp_sc_identif is '[FK] AN32, FK naar ingeschr_nat_prs.sc_identif (is FK naar superclass SUBJECT)';

create table standplaats_nummeraand(
	fk_nn_lh_spl_sc_identif varchar2(16) not null,
	fk_nn_lh_spl_sc_dat_beg_geldh varchar2(19),
	fk_nn_rh_nra_sc_identif varchar2(16) not null
);
alter table standplaats_nummeraand add constraint standplaats_nummeraand_pk primary key(fk_nn_lh_spl_sc_identif,fk_nn_rh_nra_sc_identif);

comment on table standplaats_nummeraand is 'N - N relatie: STANDPLAATS "heeft als nevenadressen" NUMMERAANDUIDING';
comment on column standplaats_nummeraand.fk_nn_lh_spl_sc_identif is '[FK] AN16, FK naar standplaats.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column standplaats_nummeraand.fk_nn_rh_nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING)';

create table verblijfsobj_pand(
	fk_nn_lh_vbo_sc_identif varchar2(16) not null,
	fk_nn_lh_vbo_sc_dat_beg_geldh varchar2(19),
	fk_nn_rh_pnd_identif varchar2(16) not null
);
alter table verblijfsobj_pand add constraint verblijfsobj_pand_pk primary key(fk_nn_lh_vbo_sc_identif,fk_nn_rh_pnd_identif);

comment on table verblijfsobj_pand is 'N - N relatie: VERBLIJFSOBJECT "maakt deel uit van" PAND';
comment on column verblijfsobj_pand.fk_nn_lh_vbo_sc_identif is '[FK] AN16, FK naar verblijfsobj.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column verblijfsobj_pand.fk_nn_rh_pnd_identif is '[FK] AN16, FK naar pand.identif';

create table verblijfsobj_nummeraand(
	fk_nn_lh_vbo_sc_identif varchar2(16) not null,
	fk_nn_lh_vbo_sc_dat_beg_geldh varchar2(19),
	fk_nn_rh_nra_sc_identif varchar2(16) not null
);
alter table verblijfsobj_nummeraand add constraint verblijfsobj_nummeraand_pk primary key(fk_nn_lh_vbo_sc_identif,fk_nn_rh_nra_sc_identif);

comment on table verblijfsobj_nummeraand is 'N - N relatie: VERBLIJFSOBJECT "heeft als nevenadres(sen)" NUMMERAANDUIDING';
comment on column verblijfsobj_nummeraand.fk_nn_lh_vbo_sc_identif is '[FK] AN16, FK naar verblijfsobj.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column verblijfsobj_nummeraand.fk_nn_rh_nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING)';

create table vestg_benoemd_obj(
	fk_nn_lh_ves_sc_identif varchar2(32) not null,
	fk_nn_rh_tgo_identif varchar2(16) not null
);
alter table vestg_benoemd_obj add constraint vestg_benoemd_obj_pk primary key(fk_nn_lh_ves_sc_identif,fk_nn_rh_tgo_identif);

comment on table vestg_benoemd_obj is 'N - N relatie: VESTIGING "heeft nevenlocatie in of op" BENOEMD OBJECT';
comment on column vestg_benoemd_obj.fk_nn_lh_ves_sc_identif is '[FK] AN32, FK naar vestg.sc_identif (is FK naar superclass SUBJECT)';
comment on column vestg_benoemd_obj.fk_nn_rh_tgo_identif is '[FK] AN16, FK naar benoemd_obj.identif';

create table meta_enumeratie_waardes(
	naam varchar2(255) not null,
	waarde varchar2(255) not null
);
alter table meta_enumeratie_waardes add constraint meta_enumeratie_waardes_pk primary key(naam,waarde);

comment on table meta_enumeratie_waardes is 'RSGB class meta_enumeratie_waardes';
comment on column meta_enumeratie_waardes.naam is 'naam van de enum - naam';
comment on column meta_enumeratie_waardes.waarde is 'waarde van de enum - waarde';

create table meta_enumeratie(
	tabel varchar2(255) not null,
	kolom varchar2(255) not null,
	enumeratie varchar2(255)
);
alter table meta_enumeratie add constraint meta_enumeratie_pk primary key(tabel,kolom);

comment on table meta_enumeratie is 'RSGB class meta_enumeratie';
comment on column meta_enumeratie.tabel is '[PK] tabel - tabel';
comment on column meta_enumeratie.kolom is '[PK] kolom - kolom';
comment on column meta_enumeratie.enumeratie is 'enumeratie - enumeratie';

create table meta_referentielijsten(
	tabel varchar2(255) not null,
	kolom varchar2(255) not null,
	referentielijst varchar2(255)
);
alter table meta_referentielijsten add constraint meta_referentielijsten_pk primary key(tabel,kolom);

comment on table meta_referentielijsten is 'RSGB class meta_referentielijsten';
comment on column meta_referentielijsten.tabel is '[PK] tabel - tabel';
comment on column meta_referentielijsten.kolom is '[PK] kolom - kolom';
comment on column meta_referentielijsten.referentielijst is 'referentielijst - referentielijst';


-- Foreign keys voor tabel addresseerb_obj_aand
alter table addresseerb_obj_aand add constraint fk_aoa_as_6 foreign key (fk_6wpl_identif) references wnplts (identif) on delete cascade;
alter table addresseerb_obj_aand add constraint fk_aoa_as_7 foreign key (fk_7opr_identifcode) references openb_rmte (identifcode) on delete cascade;

-- Foreign keys voor tabel ander_btnlnds_niet_nat_prs
alter table ander_btnlnds_niet_nat_prs add constraint fk_ann_sc foreign key (sc_identif) references niet_nat_prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel ander_nat_prs
alter table ander_nat_prs add constraint fk_anp_sc foreign key (sc_identif) references nat_prs (sc_identif) on delete cascade;
alter table ander_nat_prs add constraint fk_anp_as_3 foreign key (fk_3aoa_identif) references addresseerb_obj_aand (identif) on delete cascade;

-- Foreign keys voor tabel app_re
alter table app_re add constraint fk_apr_sc foreign key (sc_kad_identif) references kad_onrrnd_zk (kad_identif) on delete cascade;
alter table app_re add constraint fk_apr_as_2 foreign key (fk_2nnp_sc_identif) references niet_nat_prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel begr_terr_dl
alter table begr_terr_dl add constraint fk_btd_as_8 foreign key (fk_8opr_identifcode) references openb_rmte (identifcode) on delete cascade;

-- Foreign keys voor tabel begr_terreinvakonderd
alter table begr_terreinvakonderd add constraint fk_btv_sc foreign key (sc_identif) references begr_terr_dl (identif) on delete cascade;
alter table begr_terreinvakonderd add constraint fk_btv_1n_1 foreign key (fk_1btd_identif) references begr_terr_dl (identif) on delete cascade;

-- Foreign keys voor tabel benoemd_terrein
alter table benoemd_terrein add constraint fk_btr_sc foreign key (sc_identif) references benoemd_obj (identif) on delete cascade;

-- Foreign keys voor tabel brugconstructie_element
alter table brugconstructie_element add constraint fk_bce_sc foreign key (sc_identif) references kunstwerkdeel (identif) on delete cascade;

-- Foreign keys voor tabel gebouwd_obj
alter table gebouwd_obj add constraint fk_gbo_sc foreign key (sc_identif) references benoemd_obj (identif) on delete cascade;

-- Foreign keys voor tabel gem_openb_rmte
alter table gem_openb_rmte add constraint fk_gor_as_7 foreign key (fk_7gem_code) references gemeente (code) on delete cascade;

-- Foreign keys voor tabel huishouden
alter table huishouden add constraint fk_hhd_as_4 foreign key (fk_4vbo_sc_identif) references verblijfsobj (sc_identif) on delete cascade;
alter table huishouden add constraint fk_hhd_as_5 foreign key (fk_5lpl_sc_identif) references ligplaats (sc_identif) on delete cascade;
alter table huishouden add constraint fk_hhd_as_7 foreign key (fk_7spl_sc_identif) references standplaats (sc_identif) on delete cascade;

-- Foreign keys voor tabel ingeschr_niet_nat_prs
alter table ingeschr_niet_nat_prs add constraint fk_inn_sc foreign key (sc_identif) references niet_nat_prs (sc_identif) on delete cascade;
alter table ingeschr_niet_nat_prs add constraint fk_inn_as_8 foreign key (fk_8aoa_identif) references addresseerb_obj_aand (identif) on delete cascade;

-- Foreign keys voor tabel ingeschr_nat_prs
alter table ingeschr_nat_prs add constraint fk_inp_sc foreign key (sc_identif) references nat_prs (sc_identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_as_27 foreign key (fk_27lpl_sc_identif) references ligplaats (sc_identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_as_28 foreign key (fk_28nra_sc_identif) references nummeraand (sc_identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_as_29 foreign key (fk_29wpl_identif) references wnplts (identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_as_30 foreign key (fk_30spl_sc_identif) references standplaats (sc_identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_as_31 foreign key (fk_31vbo_sc_identif) references verblijfsobj (sc_identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_1n_1 foreign key (fk_1rsd_nummer) references rsdoc (nummer) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_gb_2 foreign key (fk_gb_lnd_code_iso) references land (code_iso) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_nt_2 foreign key (fk_nt_nat_code) references nation (code) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_ol_1 foreign key (fk_ol_lnd_code_iso) references land (code_iso) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_va_as_3 foreign key (fk_va_3_vbo_sc_identif) references verblijfsobj (sc_identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_va_as_4 foreign key (fk_va_4_spl_sc_identif) references standplaats (sc_identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_va_as_5 foreign key (fk_va_5_nra_sc_identif) references nummeraand (sc_identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_va_as_6 foreign key (fk_va_6_wpl_identif) references wnplts (identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_va_as_7 foreign key (fk_va_7_lpl_sc_identif) references ligplaats (sc_identif) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_rl_3 foreign key (fk_3nat_code) references nation (code) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_rl_17 foreign key (fk_17lnd_code_iso) references land (code_iso) on delete cascade;
alter table ingeschr_nat_prs add constraint fk_inp_rl_18 foreign key (fk_18lnd_code_iso) references land (code_iso) on delete cascade;

-- Foreign keys voor tabel ingezetene
alter table ingezetene add constraint fk_ing_sc foreign key (sc_identif) references ingeschr_nat_prs (sc_identif) on delete cascade;
alter table ingezetene add constraint fk_ing_as_8 foreign key (fk_8vbt_aand) references verblijfstitel (aand) on delete cascade;

-- Foreign keys voor tabel kad_perceel
alter table kad_perceel add constraint fk_kdp_sc foreign key (sc_kad_identif) references kad_onrrnd_zk (kad_identif) on delete cascade;
alter table kad_perceel add constraint fk_kdp_as_7 foreign key (fk_7kdp_sc_kad_identif) references kad_perceel (sc_kad_identif) on delete cascade;

-- Foreign keys voor tabel kad_onrrnd_zk
alter table kad_onrrnd_zk add constraint fk_koz_as_7 foreign key (fk_7kdg_code) references kad_gemeente (code) on delete cascade;
alter table kad_onrrnd_zk add constraint fk_koz_as_10 foreign key (fk_10pes_sc_identif) references prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel kad_onrrnd_zk_aantek
alter table kad_onrrnd_zk_aantek add constraint fk_kza_as_4 foreign key (fk_4koz_kad_identif) references kad_onrrnd_zk (kad_identif) on delete cascade;
alter table kad_onrrnd_zk_aantek add constraint fk_kza_as_5 foreign key (fk_5pes_sc_identif) references prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel ligplaats
alter table ligplaats add constraint fk_lpl_sc foreign key (sc_identif) references benoemd_terrein (sc_identif) on delete cascade;
alter table ligplaats add constraint fk_lpl_as_4 foreign key (fk_4nra_sc_identif) references nummeraand (sc_identif) on delete cascade;

-- Foreign keys voor tabel maatschapp_activiteit
alter table maatschapp_activiteit add constraint fk_mac_as_3 foreign key (fk_3ond_kvk_nummer) references ondrnmng (kvk_nummer) on delete cascade;
alter table maatschapp_activiteit add constraint fk_mac_as_4 foreign key (fk_4pes_sc_identif) references prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel nat_prs
alter table nat_prs add constraint fk_nps_sc foreign key (sc_identif) references prs (sc_identif) on delete cascade;
alter table nat_prs add constraint fk_nps_rl_2 foreign key (fk_2acd_code) references academische_titel (code) on delete cascade;

-- Foreign keys voor tabel niet_ingezetene
alter table niet_ingezetene add constraint fk_nin_sc foreign key (sc_identif) references ingeschr_nat_prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel niet_nat_prs
alter table niet_nat_prs add constraint fk_nnp_sc foreign key (sc_identif) references prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel nummeraand
alter table nummeraand add constraint fk_nra_sc foreign key (sc_identif) references addresseerb_obj_aand (identif) on delete cascade;

-- Foreign keys voor tabel onbegr_terr_dl
alter table onbegr_terr_dl add constraint fk_obt_as_8 foreign key (fk_8opr_identifcode) references openb_rmte (identifcode) on delete cascade;

-- Foreign keys voor tabel onbegr_terreinvakonderd
alter table onbegr_terreinvakonderd add constraint fk_otv_sc foreign key (sc_identif) references onbegr_terr_dl (identif) on delete cascade;
alter table onbegr_terreinvakonderd add constraint fk_otv_1n_1 foreign key (fk_1obt_identif) references onbegr_terr_dl (identif) on delete cascade;

-- Foreign keys voor tabel ondrnmng
alter table ondrnmng add constraint fk_ond_as_4 foreign key (fk_4mac_kvk_nummer) references maatschapp_activiteit (kvk_nummer) on delete cascade;
alter table ondrnmng add constraint fk_ond_1n_1 foreign key (fk_1ond_kvk_nummer) references ondrnmng (kvk_nummer) on delete cascade;

-- Foreign keys voor tabel ondersteunend_wegdeel
alter table ondersteunend_wegdeel add constraint fk_owd_as_6 foreign key (fk_6opr_identifcode) references openb_rmte (identifcode) on delete cascade;

-- Foreign keys voor tabel ovrg_addresseerb_obj_aand
alter table ovrg_addresseerb_obj_aand add constraint fk_oao_sc foreign key (sc_identif) references addresseerb_obj_aand (identif) on delete cascade;

-- Foreign keys voor tabel overig_gebouwd_obj
alter table overig_gebouwd_obj add constraint fk_ogo_sc foreign key (sc_identif) references gebouwd_obj (sc_identif) on delete cascade;
alter table overig_gebouwd_obj add constraint fk_ogo_as_4 foreign key (fk_4oao_sc_identif) references ovrg_addresseerb_obj_aand (sc_identif) on delete cascade;
alter table overig_gebouwd_obj add constraint fk_ogo_as_5 foreign key (fk_5nra_sc_identif) references nummeraand (sc_identif) on delete cascade;
alter table overig_gebouwd_obj add constraint fk_ogo_as_6 foreign key (fk_6opr_identifcode) references openb_rmte (identifcode) on delete cascade;

-- Foreign keys voor tabel overig_terrein
alter table overig_terrein add constraint fk_otr_sc foreign key (sc_identif) references benoemd_terrein (sc_identif) on delete cascade;
alter table overig_terrein add constraint fk_otr_as_2 foreign key (fk_2oao_sc_identif) references ovrg_addresseerb_obj_aand (sc_identif) on delete cascade;

-- Foreign keys voor tabel prs
alter table prs add constraint fk_pes_sc foreign key (sc_identif) references subject (identif) on delete cascade;

-- Foreign keys voor tabel rsdoc
alter table rsdoc add constraint fk_rsd_rl_7 foreign key (fk_7rds_rsdoccode) references rsdocsoort (rsdoccode) on delete cascade;

-- Foreign keys voor tabel standplaats
alter table standplaats add constraint fk_spl_sc foreign key (sc_identif) references benoemd_terrein (sc_identif) on delete cascade;
alter table standplaats add constraint fk_spl_as_4 foreign key (fk_4nra_sc_identif) references nummeraand (sc_identif) on delete cascade;

-- Foreign keys voor tabel subject
alter table subject add constraint fk_sub_as_13 foreign key (fk_13wpl_identif) references wnplts (identif) on delete cascade;
alter table subject add constraint fk_sub_as_14 foreign key (fk_14aoa_identif) references addresseerb_obj_aand (identif) on delete cascade;
alter table subject add constraint fk_sub_as_15 foreign key (fk_15aoa_identif) references addresseerb_obj_aand (identif) on delete cascade;
alter table subject add constraint fk_sub_pa_as_4 foreign key (fk_pa_4_wpl_identif) references wnplts (identif) on delete cascade;
alter table subject add constraint fk_sub_vb_4 foreign key (fk_vb_lnd_code_iso) references land (code_iso) on delete cascade;

-- Foreign keys voor tabel verblijfsobj
alter table verblijfsobj add constraint fk_vbo_sc foreign key (sc_identif) references gebouwd_obj (sc_identif) on delete cascade;
alter table verblijfsobj add constraint fk_vbo_as_11 foreign key (fk_11nra_sc_identif) references nummeraand (sc_identif) on delete cascade;

-- Foreign keys voor tabel vestg
alter table vestg add constraint fk_ves_sc foreign key (sc_identif) references subject (identif) on delete cascade;
alter table vestg add constraint fk_ves_as_15 foreign key (fk_15ond_kvk_nummer) references ondrnmng (kvk_nummer) on delete cascade;
alter table vestg add constraint fk_ves_as_16 foreign key (fk_16tgo_identif) references benoemd_obj (identif) on delete cascade;
alter table vestg add constraint fk_ves_as_17 foreign key (fk_17mac_kvk_nummer) references maatschapp_activiteit (kvk_nummer) on delete cascade;
alter table vestg add constraint fk_ves_as_18 foreign key (fk_18ves_sc_identif) references vestg (sc_identif) on delete cascade;
alter table vestg add constraint fk_ves_as_19 foreign key (fk_19mac_kvk_nummer) references maatschapp_activiteit (kvk_nummer) on delete cascade;
alter table vestg add constraint fk_ves_as_20 foreign key (fk_20aoa_identif) references addresseerb_obj_aand (identif) on delete cascade;
alter table vestg add constraint fk_ves_sa_2 foreign key (fk_sa_sbi_activiteit_sbi_code) references sbi_activiteit (sbi_code) on delete cascade;

-- Foreign keys voor tabel waterdeel
alter table waterdeel add constraint fk_wad_as_7 foreign key (fk_7opr_identifcode) references openb_rmte (identifcode) on delete cascade;

-- Foreign keys voor tabel watervakonderdeel
alter table watervakonderdeel add constraint fk_wav_sc foreign key (sc_identif) references waterdeel (identif) on delete cascade;
alter table watervakonderdeel add constraint fk_wav_1n_1 foreign key (fk_1wad_identif) references waterdeel (identif) on delete cascade;

-- Foreign keys voor tabel wegdeel
alter table wegdeel add constraint fk_wgd_as_8 foreign key (fk_8opr_identifcode) references openb_rmte (identifcode) on delete cascade;

-- Foreign keys voor tabel wegvakonderdeel
alter table wegvakonderdeel add constraint fk_wvd_sc foreign key (sc_identif) references wegdeel (identif) on delete cascade;
alter table wegvakonderdeel add constraint fk_wvd_1n_1 foreign key (fk_1wgd_identif) references wegdeel (identif) on delete cascade;

-- Foreign keys voor tabel wnplts
alter table wnplts add constraint fk_wpl_as_7 foreign key (fk_7gem_code) references gemeente (code) on delete cascade;

-- Foreign keys voor tabel woz_deelobj
alter table woz_deelobj add constraint fk_wdo_as_4 foreign key (fk_4pnd_identif) references pand (identif) on delete cascade;
alter table woz_deelobj add constraint fk_wdo_as_5 foreign key (fk_5tgo_identif) references benoemd_obj (identif) on delete cascade;
alter table woz_deelobj add constraint fk_wdo_as_6 foreign key (fk_6woz_nummer) references woz_obj (nummer) on delete cascade;

-- Foreign keys voor tabel woz_waarde
alter table woz_waarde add constraint fk_wrd_1n_1 foreign key (fk_1woz_nummer) references woz_obj (nummer) on delete cascade;

-- Foreign keys voor tabel zak_recht
alter table zak_recht add constraint fk_zkr_as_7 foreign key (fk_7koz_kad_identif) references kad_onrrnd_zk (kad_identif) on delete cascade;
alter table zak_recht add constraint fk_zkr_as_8 foreign key (fk_8pes_sc_identif) references prs (sc_identif) on delete cascade;
alter table zak_recht add constraint fk_zkr_rl_2 foreign key (fk_2aard_recht_verkort_aand) references aard_recht_verkort (aand) on delete cascade;
alter table zak_recht add constraint fk_zkr_rl_3 foreign key (fk_3avr_aand) references aard_verkregen_recht (aand) on delete cascade;

-- Foreign keys voor tabel zak_recht_aantek
alter table zak_recht_aantek add constraint fk_zra_as_5 foreign key (fk_5zkr_kadaster_identif) references zak_recht (kadaster_identif) on delete cascade;
alter table zak_recht_aantek add constraint fk_zra_as_6 foreign key (fk_6pes_sc_identif) references prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel gebouwd_obj_gebruiksdoel
alter table gebouwd_obj_gebruiksdoel add constraint fk_gbo7 foreign key (fk_gbo_sc_identif) references gebouwd_obj (sc_identif) on delete cascade;

-- Foreign keys voor tabel overig_terrein_gebruiksdoel
alter table overig_terrein_gebruiksdoel add constraint fk_otr1 foreign key (fk_otr_sc_identif) references overig_terrein (sc_identif) on delete cascade;

-- Foreign keys voor tabel vestg_naam
alter table vestg_naam add constraint fk_ves1 foreign key (fk_ves_sc_identif) references vestg (sc_identif) on delete cascade;

-- Foreign keys voor tabel functionaris
alter table functionaris add constraint fk_functionaris_sc_lh foreign key (fk_sc_lh_pes_sc_identif) references prs (sc_identif) on delete cascade;
alter table functionaris add constraint fk_functionaris_sc_rh foreign key (fk_sc_rh_pes_sc_identif) references prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel huishoudenrel
alter table huishoudenrel add constraint fk_huishoudenrel_sc_lh foreign key (fk_sc_lh_inp_sc_identif) references ingeschr_nat_prs (sc_identif) on delete cascade;
alter table huishoudenrel add constraint fk_huishoudenrel_sc_rh foreign key (fk_sc_rh_hhd_nummer) references huishouden (nummer) on delete cascade;

-- Foreign keys voor tabel huw_ger_partn
alter table huw_ger_partn add constraint fk_huw_ger_partn_sc_lh foreign key (fk_sc_lh_inp_sc_identif) references ingeschr_nat_prs (sc_identif) on delete cascade;
alter table huw_ger_partn add constraint fk_huw_ger_partn_sc_rh foreign key (fk_sc_rh_inp_sc_identif) references ingeschr_nat_prs (sc_identif) on delete cascade;
alter table huw_ger_partn add constraint fk_huw_ger_partn_hs_2 foreign key (fk_hs_lnd_code_iso) references land (code_iso) on delete cascade;
alter table huw_ger_partn add constraint fk_huw_ger_partn_ho_2 foreign key (fk_ho_lnd_code_iso) references land (code_iso) on delete cascade;

-- Foreign keys voor tabel kad_onrrnd_zk_his_rel
alter table kad_onrrnd_zk_his_rel add constraint fk_kad_onrrnd_zk_his_rel_sc_lh foreign key (fk_sc_lh_koz_kad_identif) references kad_onrrnd_zk (kad_identif) on delete cascade;
alter table kad_onrrnd_zk_his_rel add constraint fk_kad_onrrnd_zk_his_rel_sc_rh foreign key (fk_sc_rh_koz_kad_identif) references kad_onrrnd_zk (kad_identif) on delete cascade;

-- Foreign keys voor tabel locaand_adres
alter table locaand_adres add constraint fk_locaand_adres_sc_lh foreign key (fk_sc_lh_aoa_identif) references addresseerb_obj_aand (identif) on delete cascade;
alter table locaand_adres add constraint fk_locaand_adres_sc_rh foreign key (fk_sc_rh_woz_nummer) references woz_obj (nummer) on delete cascade;

-- Foreign keys voor tabel locaand_openb_rmte
alter table locaand_openb_rmte add constraint fk_locaand_openb_rmte_sc_lh foreign key (fk_sc_lh_opr_identifcode) references openb_rmte (identifcode) on delete cascade;
alter table locaand_openb_rmte add constraint fk_locaand_openb_rmte_sc_rh foreign key (fk_sc_rh_woz_nummer) references woz_obj (nummer) on delete cascade;

-- Foreign keys voor tabel ouder_kind_rel
alter table ouder_kind_rel add constraint fk_ouder_kind_rel_sc_lh foreign key (fk_sc_lh_inp_sc_identif) references ingeschr_nat_prs (sc_identif) on delete cascade;
alter table ouder_kind_rel add constraint fk_ouder_kind_rel_sc_rh foreign key (fk_sc_rh_inp_sc_identif) references ingeschr_nat_prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel woz_belang
alter table woz_belang add constraint fk_woz_belang_sc_lh foreign key (fk_sc_lh_sub_identif) references subject (identif) on delete cascade;
alter table woz_belang add constraint fk_woz_belang_sc_rh foreign key (fk_sc_rh_woz_nummer) references woz_obj (nummer) on delete cascade;

-- Foreign keys voor tabel app_re_kad_perceel
alter table app_re_kad_perceel add constraint fk_apr_kdp_nn_lh foreign key (fk_nn_lh_apr_sc_kad_identif) references app_re (sc_kad_identif) on delete cascade;
alter table app_re_kad_perceel add constraint fk_apr_kdp_nn_rh foreign key (fk_nn_rh_kdp_sc_kad_identif) references kad_perceel (sc_kad_identif) on delete cascade;

-- Foreign keys voor tabel benoemd_obj_kad_onrrnd_zk
alter table benoemd_obj_kad_onrrnd_zk add constraint fk_tgo_koz_nn_lh foreign key (fk_nn_lh_tgo_identif) references benoemd_obj (identif) on delete cascade;
alter table benoemd_obj_kad_onrrnd_zk add constraint fk_tgo_koz_nn_rh foreign key (fk_nn_rh_koz_kad_identif) references kad_onrrnd_zk (kad_identif) on delete cascade;

-- Foreign keys voor tabel benoemd_terrein_benoemd_terrei
alter table benoemd_terrein_benoemd_terrei add constraint fk_btr_btr_nn_lh foreign key (fk_nn_lh_btr_sc_identif) references benoemd_terrein (sc_identif) on delete cascade;
alter table benoemd_terrein_benoemd_terrei add constraint fk_btr_btr_nn_rh foreign key (fk_nn_rh_btr_sc_identif) references benoemd_terrein (sc_identif) on delete cascade;

-- Foreign keys voor tabel gemeente_gemeente
alter table gemeente_gemeente add constraint fk_gem_gem_nn_lh foreign key (fk_nn_lh_gem_code) references gemeente (code) on delete cascade;
alter table gemeente_gemeente add constraint fk_gem_gem_nn_rh foreign key (fk_nn_rh_gem_code) references gemeente (code) on delete cascade;

-- Foreign keys voor tabel kad_onrrnd_zk_kad_onrrnd_zk
alter table kad_onrrnd_zk_kad_onrrnd_zk add constraint fk_koz_koz_nn_lh foreign key (fk_nn_lh_koz_kad_identif) references kad_onrrnd_zk (kad_identif) on delete cascade;
alter table kad_onrrnd_zk_kad_onrrnd_zk add constraint fk_koz_koz_nn_rh foreign key (fk_nn_rh_koz_kad_identif) references kad_onrrnd_zk (kad_identif) on delete cascade;

-- Foreign keys voor tabel ligplaats_nummeraand
alter table ligplaats_nummeraand add constraint fk_lpl_nra_nn_lh foreign key (fk_nn_lh_lpl_sc_identif) references ligplaats (sc_identif) on delete cascade;
alter table ligplaats_nummeraand add constraint fk_lpl_nra_nn_rh foreign key (fk_nn_rh_nra_sc_identif) references nummeraand (sc_identif) on delete cascade;

-- Foreign keys voor tabel openb_rmte_gem_openb_rmte
alter table openb_rmte_gem_openb_rmte add constraint fk_opr_gor_nn_lh foreign key (fk_nn_lh_opr_identifcode) references openb_rmte (identifcode) on delete cascade;
alter table openb_rmte_gem_openb_rmte add constraint fk_opr_gor_nn_rh foreign key (fk_nn_rh_gor_identifcode) references gem_openb_rmte (identifcode) on delete cascade;

-- Foreign keys voor tabel openb_rmte_wnplts
alter table openb_rmte_wnplts add constraint fk_opr_wpl_nn_lh foreign key (fk_nn_lh_opr_identifcode) references openb_rmte (identifcode) on delete cascade;
alter table openb_rmte_wnplts add constraint fk_opr_wpl_nn_rh foreign key (fk_nn_rh_wpl_identif) references wnplts (identif) on delete cascade;

-- Foreign keys voor tabel rsdoc_ingeschr_nat_prs
alter table rsdoc_ingeschr_nat_prs add constraint fk_rsd_inp_nn_lh foreign key (fk_nn_lh_rsd_nummer) references rsdoc (nummer) on delete cascade;
alter table rsdoc_ingeschr_nat_prs add constraint fk_rsd_inp_nn_rh foreign key (fk_nn_rh_inp_sc_identif) references ingeschr_nat_prs (sc_identif) on delete cascade;

-- Foreign keys voor tabel standplaats_nummeraand
alter table standplaats_nummeraand add constraint fk_spl_nra_nn_lh foreign key (fk_nn_lh_spl_sc_identif) references standplaats (sc_identif) on delete cascade;
alter table standplaats_nummeraand add constraint fk_spl_nra_nn_rh foreign key (fk_nn_rh_nra_sc_identif) references nummeraand (sc_identif) on delete cascade;

-- Foreign keys voor tabel verblijfsobj_pand
alter table verblijfsobj_pand add constraint fk_vbo_pnd_nn_lh foreign key (fk_nn_lh_vbo_sc_identif) references verblijfsobj (sc_identif) on delete cascade;
alter table verblijfsobj_pand add constraint fk_vbo_pnd_nn_rh foreign key (fk_nn_rh_pnd_identif) references pand (identif) on delete cascade;

-- Foreign keys voor tabel verblijfsobj_nummeraand
alter table verblijfsobj_nummeraand add constraint fk_vbo_nra_nn_lh foreign key (fk_nn_lh_vbo_sc_identif) references verblijfsobj (sc_identif) on delete cascade;
alter table verblijfsobj_nummeraand add constraint fk_vbo_nra_nn_rh foreign key (fk_nn_rh_nra_sc_identif) references nummeraand (sc_identif) on delete cascade;

-- Foreign keys voor tabel vestg_benoemd_obj
alter table vestg_benoemd_obj add constraint fk_ves_tgo_nn_lh foreign key (fk_nn_lh_ves_sc_identif) references vestg (sc_identif) on delete cascade;
alter table vestg_benoemd_obj add constraint fk_ves_tgo_nn_rh foreign key (fk_nn_rh_tgo_identif) references benoemd_obj (identif) on delete cascade;

-- Archief tabellen

create table addresseerb_obj_aand_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(16) not null,
	clazz varchar2(255),
	dat_eind_geldh varchar2(19),
	huisletter varchar2(1),
	huinummer decimal(5,0),
	huinummertoevoeging varchar2(4),
	postcode varchar2(6),
	fk_6wpl_identif varchar2(4),
	fk_7opr_identifcode varchar2(16)
);
alter table addresseerb_obj_aand_archief add constraint ar_addresseerb_obj_aand_pk primary key(dat_beg_geldh,identif);

comment on table addresseerb_obj_aand_archief is 'RSGB class ADRESSEERBAAR OBJECT AANDUIDING. Directe superclass van: NUMMERAANDUIDING, OVERIGE ADRESSEERBAAR OBJECT AANDUIDING';
comment on column addresseerb_obj_aand_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid addresserbaar object aanduiding';
comment on column addresseerb_obj_aand_archief.identif is '[PK] AN16 - Identificatie adresseerbaar object aanduiding';
comment on column addresseerb_obj_aand_archief.clazz is 'Aanduiding subclass';
comment on column addresseerb_obj_aand_archief.dat_eind_geldh is 'OnvolledigeDatum - Datum einde geldigheid addresserbaar object aanduiding';
comment on column addresseerb_obj_aand_archief.huisletter is 'AN1 - Huisletter';
comment on column addresseerb_obj_aand_archief.huinummer is 'N5 - Huisnummer';
comment on column addresseerb_obj_aand_archief.huinummertoevoeging is 'AN4 - Huisnummertoevoeging';
comment on column addresseerb_obj_aand_archief.postcode is 'AN6 - Postcode';
comment on column addresseerb_obj_aand_archief.fk_6wpl_identif is '[FK] AN4, FK naar wnplts.identif: "ligt in"';
comment on column addresseerb_obj_aand_archief.fk_7opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "ligt aan"';

create table app_re_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_kad_identif decimal(15,0) not null,
	fk_2nnp_sc_identif varchar2(32),
	ka_appartementsindex varchar2(4),
	ka_kad_gemeentecode varchar2(5),
	ka_perceelnummer varchar2(15),
	ka_sectie varchar2(255)
);
alter table app_re_archief add constraint ar_app_re_pk primary key(sc_dat_beg_geldh,sc_kad_identif);

comment on table app_re_archief is 'RSGB class APPARTEMENTSRECHT. Subclass van: KADASTRALE ONROERENDE ZAAK';
comment on column app_re_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar kad_onrrnd_zk.dat_beg_geldh - Datum begin geldigheid kadastrale onroerende zaak';
comment on column app_re_archief.sc_kad_identif is '[PK] N15, FK naar kad_onrrnd_zk.kad_identif - Kadastrale identificatie';
comment on column app_re_archief.fk_2nnp_sc_identif is '[FK] AN32, FK naar niet_nat_prs.sc_identif (is FK naar superclass SUBJECT): "maakt deel uit van appartementencomplex met als vereniging van eigenaars"';
comment on column app_re_archief.ka_appartementsindex is 'Groepsattribuut Kadastrale aanduiding APPARTEMENTSRECHT.Appartementsindex - Appartementsindex';
comment on column app_re_archief.ka_kad_gemeentecode is 'Groepsattribuut Kadastrale aanduiding APPARTEMENTSRECHT.Kadastrale gemeentecode - Kadastrale gemeentecode';
comment on column app_re_archief.ka_perceelnummer is 'Groepsattribuut Kadastrale aanduiding APPARTEMENTSRECHT.Perceelnummer - Perceelnummer';
comment on column app_re_archief.ka_sectie is 'Groepsattribuut Kadastrale aanduiding APPARTEMENTSRECHT.Sectie - Sectie';

create table begr_terr_dl_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	fysiek_voork_begr_terrein varchar2(20),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	fk_8opr_identifcode varchar2(16)
);
alter table begr_terr_dl_archief add constraint ar_begr_terr_dl_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('begr_terr_dl_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table begr_terr_dl_archief add(geom sdo_geometry );
CREATE INDEX begr_terr_dl_archief_geom1_idx ON begr_terr_dl_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('begr_terr_dl_archief', 'kruinlijngeom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table begr_terr_dl_archief add(kruinlijngeom sdo_geometry );
CREATE INDEX begr_terr_dl_archief_krui2_idx ON begr_terr_dl_archief (kruinlijngeom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=LINE');

comment on table begr_terr_dl_archief is 'RSGB class BEGROEID TERREINDEEL. Directe superclass van: BEGROEID TERREINVAKONDERDEEL';
comment on column begr_terr_dl_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid begroeid terreindeel';
comment on column begr_terr_dl_archief.identif is '[PK] NEN3610ID - Identificatie begroeid terreindeel';
comment on column begr_terr_dl_archief.clazz is 'Aanduiding subclass';
comment on column begr_terr_dl_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid begroeid terreindeel';
comment on column begr_terr_dl_archief.fysiek_voork_begr_terrein is 'AN20 - Fysiek voorkomen begroeid terrein';
comment on column begr_terr_dl_archief.geom is 'GM_Surface - Geometrie begroeid terreindeel';
comment on column begr_terr_dl_archief.kruinlijngeom is 'GM_Curve - Kruinlijneometrie begroeid terreindeel';
comment on column begr_terr_dl_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging begroeid terreindeel';
comment on column begr_terr_dl_archief.status is 'A8 - Status begroeid terreindeel';
comment on column begr_terr_dl_archief.fk_8opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table begr_terreinvakonderd_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(255) not null,
	fk_1btd_identif varchar2(255)
);
alter table begr_terreinvakonderd_archief add constraint ar_begr_terreinvakonderd_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table begr_terreinvakonderd_archief is 'RSGB class BEGROEID TERREINVAKONDERDEEL. Subclass van: BEGROEID TERREINDEEL';
comment on column begr_terreinvakonderd_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar begr_terr_dl.dat_beg_geldh - Datum begin geldigheid begroeid terreindeel';
comment on column begr_terreinvakonderd_archief.sc_identif is '[PK] NEN3610ID, FK naar begr_terr_dl.identif - Identificatie begroeid terreindeel';
comment on column begr_terreinvakonderd_archief.fk_1btd_identif is '[FK] NEN3610ID, FK naar begr_terr_dl.identif';

create table benoemd_terrein_archief(
	dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(16) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19)
);
alter table benoemd_terrein_archief add constraint ar_benoemd_terrein_pk primary key(dat_beg_geldh,sc_identif);
insert into user_sdo_geom_metadata values('benoemd_terrein_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table benoemd_terrein_archief add(geom sdo_geometry );
CREATE INDEX benoemd_terrein_archief_g1_idx ON benoemd_terrein_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table benoemd_terrein_archief is 'RSGB class BENOEMD TERREIN. Subclass van: BENOEMD OBJECT. Directe superclass van: LIGPLAATS, OVERIG TERREIN, STANDPLAATS';
comment on column benoemd_terrein_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid benoemd terrein';
comment on column benoemd_terrein_archief.sc_identif is '[PK] AN16, FK naar benoemd_obj.identif - Benoemd object identificatie';
comment on column benoemd_terrein_archief.clazz is 'Aanduiding subclass';
comment on column benoemd_terrein_archief.geom is 'GM_Surface - Benoemd terrein geometrie';
comment on column benoemd_terrein_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid benoemd terrein';

create table brugconstructie_elemen_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(255) not null,
	type varchar2(40)
);
alter table brugconstructie_elemen_archief add constraint ar_brugconstructie_element_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table brugconstructie_elemen_archief is 'RSGB class BRUGCONSTRUCTIE ELEMENT. Subclass van: KUNSTWERKDEEL';
comment on column brugconstructie_elemen_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar kunstwerkdeel.dat_beg_geldh - Datum begin geldigheid kunstwerkdeel';
comment on column brugconstructie_elemen_archief.sc_identif is '[PK] NEN3610ID, FK naar kunstwerkdeel.identif - Identificatie kunstwerkdeel';
comment on column brugconstructie_elemen_archief.type is 'AN40 - Type brugconstructie element';

create table buurt_archief(
	code decimal(8,0) not null,
	dat_beg_geldh varchar2(19) not null,
	naam varchar2(80),
	datum_einde_geldh varchar2(19),
	identif_imgeobrt varchar2(255),
	relve_hoogteligging decimal(1,0),
	status varchar2(8)
);
alter table buurt_archief add constraint ar_buurt_pk primary key(code,dat_beg_geldh);
insert into user_sdo_geom_metadata values('buurt_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table buurt_archief add(geom sdo_geometry );
CREATE INDEX buurt_archief_geom1_idx ON buurt_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table buurt_archief is 'RSGB class BUURT';
comment on column buurt_archief.code is '[PK] N8 - Buurtcode';
comment on column buurt_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid buurt';
comment on column buurt_archief.geom is 'GM_Surface - Buurtgeometrie';
comment on column buurt_archief.naam is 'AN80 - Buurtnaam';
comment on column buurt_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid buurt';
comment on column buurt_archief.identif_imgeobrt is 'NEN3610ID - Identificatie IMGeoBRT';
comment on column buurt_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging buurt';
comment on column buurt_archief.status is 'A8 - Status buurt';

create table functioneel_gebied_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	naam varchar2(40),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(255)
);
alter table functioneel_gebied_archief add constraint ar_functioneel_gebied_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('functioneel_gebied_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table functioneel_gebied_archief add(geom sdo_geometry );
CREATE INDEX functioneel_gebied_archie1_idx ON functioneel_gebied_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table functioneel_gebied_archief is 'RSGB class FUNCTIONEEL GEBIED';
comment on column functioneel_gebied_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid functioneel gebied';
comment on column functioneel_gebied_archief.identif is '[PK] NEN3610ID - Identificatie functioneel gebied';
comment on column functioneel_gebied_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid functioneel gebied';
comment on column functioneel_gebied_archief.geom is 'GM_Surface - Geometrie functioneel gebied';
comment on column functioneel_gebied_archief.naam is 'AN40 - Naam functioneel gebied';
comment on column functioneel_gebied_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging functioneel gebied';
comment on column functioneel_gebied_archief.status is 'A8 - Status functioneel gebied';
comment on column functioneel_gebied_archief.type is '[geen RSGB type] - Type functioneel gebied';

create table gebouwd_obj_archief(
	dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(16) not null,
	clazz varchar2(255),
	bouwk_best_act varchar2(255),
	bruto_inhoud decimal(6,0),
	datum_einde_geldh varchar2(19),
	inwwijze_oppervlakte varchar2(24),
	oppervlakte_obj decimal(6,0),
	status_voortgang_bouw integer
);
alter table gebouwd_obj_archief add constraint ar_gebouwd_obj_pk primary key(dat_beg_geldh,sc_identif);
insert into user_sdo_geom_metadata values('gebouwd_obj_archief', 'vlakgeom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table gebouwd_obj_archief add(vlakgeom sdo_geometry );
CREATE INDEX gebouwd_obj_archief_vlakg1_idx ON gebouwd_obj_archief (vlakgeom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('gebouwd_obj_archief', 'puntgeom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table gebouwd_obj_archief add(puntgeom sdo_geometry );
CREATE INDEX gebouwd_obj_archief_puntg2_idx ON gebouwd_obj_archief (puntgeom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=POINT');

comment on table gebouwd_obj_archief is 'RSGB class GEBOUWD OBJECT. Subclass van: BENOEMD OBJECT. Directe superclass van: OVERIG GEBOUWD OBJECT, VERBLIJFSOBJECT';
comment on column gebouwd_obj_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid gebouwd object';
comment on column gebouwd_obj_archief.sc_identif is '[PK] AN16, FK naar benoemd_obj.identif - Benoemd object identificatie';
comment on column gebouwd_obj_archief.clazz is 'Aanduiding subclass';
comment on column gebouwd_obj_archief.bouwk_best_act is '[Enumeratie] - Bouwkundige bestemming actueel';
comment on column gebouwd_obj_archief.bruto_inhoud is 'N6 - Bruto inhoud';
comment on column gebouwd_obj_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid gebouwd object';
comment on column gebouwd_obj_archief.vlakgeom is 'GM_Surface - Gebouwd object vlakgeometrie';
comment on column gebouwd_obj_archief.puntgeom is 'GM_Point - Gebouwd objectpuntgeometrie';
comment on column gebouwd_obj_archief.inwwijze_oppervlakte is 'AN24 - Inwinningswijze oppervlakte';
comment on column gebouwd_obj_archief.oppervlakte_obj is 'N6 - Oppervlakte (verblijfs)object';
comment on column gebouwd_obj_archief.status_voortgang_bouw is 'long - Status voortgang bouw';

create table gebouwinstallatie_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table gebouwinstallatie_archief add constraint ar_gebouwinstallatie_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('gebouwinstallatie_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table gebouwinstallatie_archief add(geom sdo_geometry );
CREATE INDEX gebouwinstallatie_archief1_idx ON gebouwinstallatie_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table gebouwinstallatie_archief is 'RSGB class GEBOUWINSTALLATIE';
comment on column gebouwinstallatie_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid gebouwinstallatie';
comment on column gebouwinstallatie_archief.identif is '[PK] NEN3610ID - Identificatie gebouwinstallatie';
comment on column gebouwinstallatie_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid gebouwinstallatie';
comment on column gebouwinstallatie_archief.geom is 'GM_Surface - Geometrie gebouwinstallatie';
comment on column gebouwinstallatie_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging gebouwinstallatie';
comment on column gebouwinstallatie_archief.status is 'A8 - Status gebouwinstallatie';
comment on column gebouwinstallatie_archief.type is 'AN40 - Type gebouwinstallatie';

create table gemeente_archief(
	dat_beg_geldh varchar2(19) not null,
	code decimal(4,0) not null,
	datum_einde_geldh varchar2(19),
	naam varchar2(40),
	naam_nen varchar2(24)
);
alter table gemeente_archief add constraint ar_gemeente_pk primary key(dat_beg_geldh,code);
insert into user_sdo_geom_metadata values('gemeente_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table gemeente_archief add(geom sdo_geometry );
CREATE INDEX gemeente_archief_geom1_idx ON gemeente_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table gemeente_archief is 'RSGB class GEMEENTE';
comment on column gemeente_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid gemeente';
comment on column gemeente_archief.code is '[PK] N4 - Gemeentecode';
comment on column gemeente_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid gemeente';
comment on column gemeente_archief.geom is 'GM_Surface - Gemeentegeometrie';
comment on column gemeente_archief.naam is 'AN40 - Gemeentenaam';
comment on column gemeente_archief.naam_nen is 'AN24 - Gemeentenaam NEN';

create table gem_openb_rmte_archief(
	dat_beg_geldh varchar2(19) not null,
	identifcode varchar2(16) not null,
	datum_einde_geldh varchar2(19),
	indic_geconst_openb_rmte varchar2(1),
	naam_openb_rmte varchar2(80),
	status_openb_rmte varchar2(80),
	straatnaam varchar2(24),
	type_openb_rmte varchar2(40),
	fk_7gem_code decimal(4,0)
);
alter table gem_openb_rmte_archief add constraint ar_gem_openb_rmte_pk primary key(dat_beg_geldh,identifcode);

comment on table gem_openb_rmte_archief is 'RSGB class GEMEENTELIJKE OPENBARE RUIMTE';
comment on column gem_openb_rmte_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid gemeentelijke openbare ruimte';
comment on column gem_openb_rmte_archief.identifcode is '[PK] AN16 - Identificatiecode gemeentelijke openbare ruimte';
comment on column gem_openb_rmte_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid gemeentelijke openbare ruimte';
comment on column gem_openb_rmte_archief.indic_geconst_openb_rmte is 'AN1 - Indicatie geconstateerde openbare ruimte';
comment on column gem_openb_rmte_archief.naam_openb_rmte is 'AN80 - Naam openbare ruimte';
comment on column gem_openb_rmte_archief.status_openb_rmte is 'AN80 - Status openbare ruimte';
comment on column gem_openb_rmte_archief.straatnaam is 'AN24 - Straatnaam';
comment on column gem_openb_rmte_archief.type_openb_rmte is 'AN40 - Type openbare ruimte';
comment on column gem_openb_rmte_archief.fk_7gem_code is '[FK] N4, FK naar gemeente.code: "ligt in"';

create table huishouden_archief(
	dat_beg_geldh varchar2(19) not null,
	nummer decimal(12,0) not null,
	datum_einde_geldh varchar2(19),
	grootte decimal(2,0),
	soort decimal(2,0),
	fk_4vbo_sc_identif varchar2(16),
	fk_5lpl_sc_identif varchar2(16),
	fk_7spl_sc_identif varchar2(16)
);
alter table huishouden_archief add constraint ar_huishouden_pk primary key(dat_beg_geldh,nummer);

comment on table huishouden_archief is 'RSGB class HUISHOUDEN';
comment on column huishouden_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid huishouden';
comment on column huishouden_archief.nummer is '[PK] N12 - Huishoudennummer';
comment on column huishouden_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid huishouden';
comment on column huishouden_archief.grootte is 'N2 - Huishoudengrootte';
comment on column huishouden_archief.soort is 'N2 - Huishoudensoort';
comment on column huishouden_archief.fk_4vbo_sc_identif is '[FK] AN16, FK naar verblijfsobj.sc_identif (is FK naar superclass BENOEMD OBJECT): "is gehuisvest in"';
comment on column huishouden_archief.fk_5lpl_sc_identif is '[FK] AN16, FK naar ligplaats.sc_identif (is FK naar superclass BENOEMD OBJECT): "is gehuisvest op"';
comment on column huishouden_archief.fk_7spl_sc_identif is '[FK] AN16, FK naar standplaats.sc_identif (is FK naar superclass BENOEMD OBJECT): "is gehuisvest op"';

create table inrichtingselement_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	typering varchar2(40),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(30)
);
alter table inrichtingselement_archief add constraint ar_inrichtingselement_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('inrichtingselement_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table inrichtingselement_archief add(geom sdo_geometry );
CREATE INDEX inrichtingselement_archie1_idx ON inrichtingselement_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=COLLECTION');

comment on table inrichtingselement_archief is 'RSGB class INRICHTINGSELEMENT';
comment on column inrichtingselement_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid inrichtingselement';
comment on column inrichtingselement_archief.identif is '[PK] NEN3610ID - Identificatie inrichtingselement';
comment on column inrichtingselement_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid inrichtingselement';
comment on column inrichtingselement_archief.geom is 'PuntLijnVlak - Geometrie inrichtingselement';
comment on column inrichtingselement_archief.typering is 'AN40 - Inrichtingselementtypering';
comment on column inrichtingselement_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging inrichtingselement';
comment on column inrichtingselement_archief.status is 'AN8 - Status inrichtingselement';
comment on column inrichtingselement_archief.type is 'AN30 - Type inrichtingselement';

create table kad_perceel_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_kad_identif decimal(15,0) not null,
	aand_soort_grootte char(1),
	grootte_perceel decimal(8,0),
	omschr_deelperceel varchar2(1120),
	fk_7kdp_sc_kad_identif decimal(15,0),
	ka_deelperceelnummer varchar2(4),
	ka_kad_gemeentecode varchar2(5),
	ka_perceelnummer varchar2(5),
	ka_sectie varchar2(255)
);
alter table kad_perceel_archief add constraint ar_kad_perceel_pk primary key(sc_dat_beg_geldh,sc_kad_identif);
insert into user_sdo_geom_metadata values('kad_perceel_archief', 'begrenzing_perceel', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table kad_perceel_archief add(begrenzing_perceel sdo_geometry );
CREATE INDEX kad_perceel_archief_begre1_idx ON kad_perceel_archief (begrenzing_perceel) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('kad_perceel_archief', 'plaatscoordinaten_perceel', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table kad_perceel_archief add(plaatscoordinaten_perceel sdo_geometry );
CREATE INDEX kad_perceel_archief_plaat2_idx ON kad_perceel_archief (plaatscoordinaten_perceel) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=POINT');

comment on table kad_perceel_archief is 'RSGB class KADASTRAAL PERCEEL. Subclass van: KADASTRALE ONROERENDE ZAAK';
comment on column kad_perceel_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar kad_onrrnd_zk.dat_beg_geldh - Datum begin geldigheid kadastrale onroerende zaak';
comment on column kad_perceel_archief.sc_kad_identif is '[PK] N15, FK naar kad_onrrnd_zk.kad_identif - Kadastrale identificatie';
comment on column kad_perceel_archief.aand_soort_grootte is 'boolean - Aanduiding soort grootte';
comment on column kad_perceel_archief.begrenzing_perceel is 'GM_Surface - Begrenzing perceel';
comment on column kad_perceel_archief.grootte_perceel is 'N8 - Grootte perceel';
comment on column kad_perceel_archief.omschr_deelperceel is 'AN1120 - Omschrijving deelperceel';
comment on column kad_perceel_archief.plaatscoordinaten_perceel is 'GM_Point - Plaatscoördinaten perceel';
comment on column kad_perceel_archief.fk_7kdp_sc_kad_identif is '[FK] N15, FK naar kad_perceel.sc_kad_identif (is FK naar superclass KADASTRALE ONROERENDE ZAAK): "ligt binnen"';
comment on column kad_perceel_archief.ka_deelperceelnummer is 'Groepsattribuut Kadastrale aanduiding KADASTRAAL PERCEEL.Deelperceelnummer - Deelperceelnummer';
comment on column kad_perceel_archief.ka_kad_gemeentecode is 'Groepsattribuut Kadastrale aanduiding KADASTRAAL PERCEEL.Kadastrale gemeentecode - Kadastrale gemeentecode';
comment on column kad_perceel_archief.ka_perceelnummer is 'Groepsattribuut Kadastrale aanduiding KADASTRAAL PERCEEL.Perceelnummer - Perceelnummer';
comment on column kad_perceel_archief.ka_sectie is 'Groepsattribuut Kadastrale aanduiding KADASTRAAL PERCEEL.Sectie - Sectie';

create table kad_onrrnd_zk_archief(
	dat_beg_geldh varchar2(19) not null,
	kad_identif decimal(15,0) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	typering varchar2(1),
	fk_7kdg_code varchar2(5),
	fk_10pes_sc_identif varchar2(32),
	cu_aard_bebouwing varchar2(255),
	cu_aard_cultuur_onbebouwd varchar2(65),
	cu_meer_culturen char(1),
	ks_aard_bedrag varchar2(255),
	ks_bedrag decimal(9,0),
	ks_koopjaar integer,
	ks_meer_onroerendgoed char(1),
	ks_transactiedatum timestamp,
	ks_valutasoort varchar2(255),
	lr_aand_aard_liproject varchar2(1),
	lr_aard_bedrag varchar2(255),
	lr_bedrag varchar2(255),
	lr_eindjaar integer,
	lr_valutasoort varchar2(3),
	lo_cultuur_bebouwd varchar2(65),
	lo_loc__omschr varchar2(255)
);
alter table kad_onrrnd_zk_archief add constraint ar_kad_onrrnd_zk_pk primary key(dat_beg_geldh,kad_identif);

comment on table kad_onrrnd_zk_archief is 'RSGB class KADASTRALE ONROERENDE ZAAK. Directe superclass van: APPARTEMENTSRECHT, KADASTRAAL PERCEEL';
comment on column kad_onrrnd_zk_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid kadastrale onroerende zaak';
comment on column kad_onrrnd_zk_archief.kad_identif is '[PK] N15 - Kadastrale identificatie';
comment on column kad_onrrnd_zk_archief.clazz is 'Aanduiding subclass';
comment on column kad_onrrnd_zk_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid kadastrale onroerende zaak';
comment on column kad_onrrnd_zk_archief.typering is 'AN1 - Kadastrale onroerende zaak typering';
comment on column kad_onrrnd_zk_archief.fk_7kdg_code is '[FK] AN5, FK naar kad_gemeente.code: "ligt in"';
comment on column kad_onrrnd_zk_archief.fk_10pes_sc_identif is '[FK] AN32, FK naar prs.sc_identif (is FK naar superclass SUBJECT): "heeft als voornaamste zakelijk gerechtigde"';
comment on column kad_onrrnd_zk_archief.cu_aard_bebouwing is 'Groepsattribuut Cultuur onbebouwd KADASTRALE ONROERENDE ZAAK.Aard bebouwing - Aard bebouwing';
comment on column kad_onrrnd_zk_archief.cu_aard_cultuur_onbebouwd is 'Groepsattribuut Cultuur onbebouwd KADASTRALE ONROERENDE ZAAK.Aard cultuur onbebouwd - Aard cultuur onbebouwd';
comment on column kad_onrrnd_zk_archief.cu_meer_culturen is 'Groepsattribuut Cultuur onbebouwd KADASTRALE ONROERENDE ZAAK.Meer culturen - Meer culturen';
comment on column kad_onrrnd_zk_archief.ks_aard_bedrag is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Aard bedrag - Aard bedrag';
comment on column kad_onrrnd_zk_archief.ks_bedrag is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Bedrag - Bedrag';
comment on column kad_onrrnd_zk_archief.ks_koopjaar is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Koopjaar - Koopjaar';
comment on column kad_onrrnd_zk_archief.ks_meer_onroerendgoed is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Meer onroerendgoed - Meer onroerendgoed';
comment on column kad_onrrnd_zk_archief.ks_transactiedatum is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Transactiedatum - Transactiedatum';
comment on column kad_onrrnd_zk_archief.ks_valutasoort is 'Groepsattribuut Koopsom KADASTRALE ONROERENDE ZAAK.Valutasoort - Valutasoort';
comment on column kad_onrrnd_zk_archief.lr_aand_aard_liproject is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Aanduiding aard LIproject - Aanduiding aard LIproject';
comment on column kad_onrrnd_zk_archief.lr_aard_bedrag is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Aard bedrag - Aard bedrag';
comment on column kad_onrrnd_zk_archief.lr_bedrag is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Bedrag - Bedrag';
comment on column kad_onrrnd_zk_archief.lr_eindjaar is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Eindjaar - Eindjaar';
comment on column kad_onrrnd_zk_archief.lr_valutasoort is 'Groepsattribuut Landinrichtingsrente KADASTRALE ONROERENDE ZAAK.Valutasoort - Valutasoort';
comment on column kad_onrrnd_zk_archief.lo_cultuur_bebouwd is 'Groepsattribuut Locatie onroerende zaak KADASTRALE ONROERENDE ZAAK.Cultuur bebouwd - Cultuur bebouwd';
comment on column kad_onrrnd_zk_archief.lo_loc__omschr is 'Groepsattribuut Locatie onroerende zaak KADASTRALE ONROERENDE ZAAK.Locatie- omschrijving - Locatie- omschrijving';

create table kad_onrrnd_zk_aantek_archief(
	begindatum_aantek_kad_obj varchar2(19) not null,
	kadaster_identif_aantek varchar2(255) not null,
	aard_aantek_kad_obj varchar2(255),
	beschrijving_aantek_kad_obj varchar2(124),
	eindd_aantek_kad_obj varchar2(19),
	fk_4koz_kad_identif decimal(15,0),
	fk_5pes_sc_identif varchar2(32)
);
alter table kad_onrrnd_zk_aantek_archief add constraint ar_kad_onrrnd_zk_aantek_pk primary key(begindatum_aantek_kad_obj,kadaster_identif_aantek);

comment on table kad_onrrnd_zk_aantek_archief is 'RSGB class KADASTRALE ONROERENDE ZAAK AANTEKENING';
comment on column kad_onrrnd_zk_aantek_archief.begindatum_aantek_kad_obj is '[PK] OnvolledigeDatum - Begindatum aantekening kadastraal object';
comment on column kad_onrrnd_zk_aantek_archief.kadaster_identif_aantek is '[PK] AN255 - Kadaster identificatie aantekening';
comment on column kad_onrrnd_zk_aantek_archief.aard_aantek_kad_obj is '[Enumeratie] - Aard aantekening kadastraal object';
comment on column kad_onrrnd_zk_aantek_archief.beschrijving_aantek_kad_obj is 'AN124 - Beschrijving aantekening kadastraal object';
comment on column kad_onrrnd_zk_aantek_archief.eindd_aantek_kad_obj is 'OnvolledigeDatum - Einddatum aantekening kadastraal object';
comment on column kad_onrrnd_zk_aantek_archief.fk_4koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif: "behoort bij"';
comment on column kad_onrrnd_zk_aantek_archief.fk_5pes_sc_identif is '[FK] AN32, FK naar prs.sc_identif (is FK naar superclass SUBJECT): "heeft betrokken"';

create table kunstwerkdeel_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type_kunstwerk varchar2(40)
);
alter table kunstwerkdeel_archief add constraint ar_kunstwerkdeel_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('kunstwerkdeel_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table kunstwerkdeel_archief add(geom sdo_geometry );
CREATE INDEX kunstwerkdeel_archief_geo1_idx ON kunstwerkdeel_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=COLLECTION');

comment on table kunstwerkdeel_archief is 'RSGB class KUNSTWERKDEEL. Directe superclass van: BRUGCONSTRUCTIE ELEMENT';
comment on column kunstwerkdeel_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid kunstwerkdeel';
comment on column kunstwerkdeel_archief.identif is '[PK] NEN3610ID - Identificatie kunstwerkdeel';
comment on column kunstwerkdeel_archief.clazz is 'Aanduiding subclass';
comment on column kunstwerkdeel_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid kunstwerkdeel';
comment on column kunstwerkdeel_archief.geom is 'LijnVlak - Geometrie kunstwerkdeel';
comment on column kunstwerkdeel_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging kunstwerkdeel';
comment on column kunstwerkdeel_archief.status is 'A8 - Status kunstwerkdeel';
comment on column kunstwerkdeel_archief.type_kunstwerk is 'AN40 - Type kunstwerk';

create table ligplaats_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(16) not null,
	indic_geconst varchar2(1),
	status varchar2(80),
	fk_4nra_sc_identif varchar2(16)
);
alter table ligplaats_archief add constraint ar_ligplaats_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table ligplaats_archief is 'RSGB class LIGPLAATS. Subclass van: BENOEMD TERREIN -> BENOEMD OBJECT';
comment on column ligplaats_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar benoemd_terrein.dat_beg_geldh - Datum begin geldigheid benoemd terrein';
comment on column ligplaats_archief.sc_identif is '[PK] AN16, FK naar benoemd_terrein.sc_identif - Benoemd object identificatie';
comment on column ligplaats_archief.indic_geconst is 'AN1 - Indicatie geconstateerde ligplaats';
comment on column ligplaats_archief.status is 'AN80 - Ligplaatsstatus';
comment on column ligplaats_archief.fk_4nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als hoofdadres"';

create table nummeraand_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(16) not null,
	indic_geconst varchar2(1),
	indic_hoofdadres char(1),
	status varchar2(80)
);
alter table nummeraand_archief add constraint ar_nummeraand_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table nummeraand_archief is 'RSGB class NUMMERAANDUIDING. Subclass van: ADRESSEERBAAR OBJECT AANDUIDING';
comment on column nummeraand_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar addresseerb_obj_aand.dat_beg_geldh - Datum begin geldigheid addresserbaar object aanduiding';
comment on column nummeraand_archief.sc_identif is '[PK] AN16, FK naar addresseerb_obj_aand.identif - Identificatie adresseerbaar object aanduiding';
comment on column nummeraand_archief.indic_geconst is 'AN1 - Indicatie geconstateerde nummeraanduiding';
comment on column nummeraand_archief.indic_hoofdadres is 'boolean - Indicatie hoofdadres';
comment on column nummeraand_archief.status is 'AN80 - Nummeraanduidingstatus';

create table onbegr_terr_dl_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	fysiek_voork_onbegr_terrein varchar2(20),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	fk_8opr_identifcode varchar2(16)
);
alter table onbegr_terr_dl_archief add constraint ar_onbegr_terr_dl_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('onbegr_terr_dl_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table onbegr_terr_dl_archief add(geom sdo_geometry );
CREATE INDEX onbegr_terr_dl_archief_ge1_idx ON onbegr_terr_dl_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('onbegr_terr_dl_archief', 'kruinlijngeom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table onbegr_terr_dl_archief add(kruinlijngeom sdo_geometry );
CREATE INDEX onbegr_terr_dl_archief_kr2_idx ON onbegr_terr_dl_archief (kruinlijngeom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=LINE');

comment on table onbegr_terr_dl_archief is 'RSGB class ONBEGROEID TERREINDEEL. Directe superclass van: ONBEGROEID TERREINVAKONDERDEEL';
comment on column onbegr_terr_dl_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid onbegroeid terreindeel';
comment on column onbegr_terr_dl_archief.identif is '[PK] NEN3610ID - Identificatie onbegroeid terreindeel';
comment on column onbegr_terr_dl_archief.clazz is 'Aanduiding subclass';
comment on column onbegr_terr_dl_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid onbegroeid terreindeel';
comment on column onbegr_terr_dl_archief.fysiek_voork_onbegr_terrein is 'AN20 - Fysiek voorkomen onbegroeid terrein';
comment on column onbegr_terr_dl_archief.geom is 'GM_Surface - Geometrie onbegroeid terreindeel';
comment on column onbegr_terr_dl_archief.kruinlijngeom is 'GM_Curve - Kruinlijngeometrie onbegroeid terreindeel';
comment on column onbegr_terr_dl_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging onbegroeid terreindeel';
comment on column onbegr_terr_dl_archief.status is 'A8 - Status onbegroeid terreindeel';
comment on column onbegr_terr_dl_archief.fk_8opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table onbegr_terreinvakonder_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(255) not null,
	fk_1obt_identif varchar2(255)
);
alter table onbegr_terreinvakonder_archief add constraint ar_onbegr_terreinvakonderd_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table onbegr_terreinvakonder_archief is 'RSGB class ONBEGROEID TERREINVAKONDERDEEL. Subclass van: ONBEGROEID TERREINDEEL';
comment on column onbegr_terreinvakonder_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar onbegr_terr_dl.dat_beg_geldh - Datum begin geldigheid onbegroeid terreindeel';
comment on column onbegr_terreinvakonder_archief.sc_identif is '[PK] NEN3610ID, FK naar onbegr_terr_dl.identif - Identificatie onbegroeid terreindeel';
comment on column onbegr_terreinvakonder_archief.fk_1obt_identif is '[FK] NEN3610ID, FK naar onbegr_terr_dl.identif';

create table ondersteunend_wegdeel_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	functie varchar2(25),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	fk_6opr_identifcode varchar2(16)
);
alter table ondersteunend_wegdeel_archief add constraint ar_ondersteunend_wegdeel_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('ondersteunend_wegdeel_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table ondersteunend_wegdeel_archief add(geom sdo_geometry );
CREATE INDEX ondersteunend_wegdeel_arc1_idx ON ondersteunend_wegdeel_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table ondersteunend_wegdeel_archief is 'RSGB class ONDERSTEUNEND WEGDEEL';
comment on column ondersteunend_wegdeel_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid ondersteunend wegdeel';
comment on column ondersteunend_wegdeel_archief.identif is '[PK] NEN3610ID - Identificatie ondersteunend wegdeel';
comment on column ondersteunend_wegdeel_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid ondersteunend wegdeel';
comment on column ondersteunend_wegdeel_archief.functie is 'AN25 - Functie ondersteunend wegdeel';
comment on column ondersteunend_wegdeel_archief.geom is 'GM_Surface - Geometrie ondersteunend wegdeel';
comment on column ondersteunend_wegdeel_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging ondersteunend wegdeel';
comment on column ondersteunend_wegdeel_archief.status is 'A8 - Status ondersteunend wegdeel';
comment on column ondersteunend_wegdeel_archief.fk_6opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table ovrg_addresseerb_obj_a_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(16) not null
);
alter table ovrg_addresseerb_obj_a_archief add constraint ar_ovrg_addresseerb_obj_aan_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table ovrg_addresseerb_obj_a_archief is 'RSGB class OVERIGE ADRESSEERBAAR OBJECT AANDUIDING. Subclass van: ADRESSEERBAAR OBJECT AANDUIDING';
comment on column ovrg_addresseerb_obj_a_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar addresseerb_obj_aand.dat_beg_geldh - Datum begin geldigheid addresserbaar object aanduiding';
comment on column ovrg_addresseerb_obj_a_archief.sc_identif is '[PK] AN16, FK naar addresseerb_obj_aand.identif - Identificatie adresseerbaar object aanduiding';

create table overig_bouwwerk_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table overig_bouwwerk_archief add constraint ar_overig_bouwwerk_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('overig_bouwwerk_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table overig_bouwwerk_archief add(geom sdo_geometry );
CREATE INDEX overig_bouwwerk_archief_g1_idx ON overig_bouwwerk_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table overig_bouwwerk_archief is 'RSGB class OVERIG BOUWWERK';
comment on column overig_bouwwerk_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid overig bouwwerk';
comment on column overig_bouwwerk_archief.identif is '[PK] NEN3610ID - Identificatie overig bouwwerk';
comment on column overig_bouwwerk_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid overig bouwwerk';
comment on column overig_bouwwerk_archief.geom is 'GM_Surface - Geometrie overig bouwwerk';
comment on column overig_bouwwerk_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging overig bouwwerk';
comment on column overig_bouwwerk_archief.status is 'A8 - Status overig bouwwerk';
comment on column overig_bouwwerk_archief.type is 'AN40 - Type overig bouwwerk';

create table overig_gebouwd_obj_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(16) not null,
	bouwjaar decimal(4,0),
	loc_aand varchar2(40),
	type varchar2(40),
	fk_4oao_sc_identif varchar2(16),
	fk_5nra_sc_identif varchar2(16),
	fk_6opr_identifcode varchar2(16)
);
alter table overig_gebouwd_obj_archief add constraint ar_overig_gebouwd_obj_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table overig_gebouwd_obj_archief is 'RSGB class OVERIG GEBOUWD OBJECT. Subclass van: GEBOUWD OBJECT -> BENOEMD OBJECT';
comment on column overig_gebouwd_obj_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar gebouwd_obj.dat_beg_geldh - Datum begin geldigheid gebouwd object';
comment on column overig_gebouwd_obj_archief.sc_identif is '[PK] AN16, FK naar gebouwd_obj.sc_identif - Benoemd object identificatie';
comment on column overig_gebouwd_obj_archief.bouwjaar is 'N4 - Bouwjaar';
comment on column overig_gebouwd_obj_archief.loc_aand is 'AN40 - Overig gebouwd object locatie-aanduiding';
comment on column overig_gebouwd_obj_archief.type is 'AN40 - Overig gebouwd object type';
comment on column overig_gebouwd_obj_archief.fk_4oao_sc_identif is '[FK] AN16, FK naar ovrg_addresseerb_obj_aand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als officieel adres"';
comment on column overig_gebouwd_obj_archief.fk_5nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft locatie-adres i.c.m."';
comment on column overig_gebouwd_obj_archief.fk_6opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "heeft straatadres i.c.m."';

create table ovrg_scheiding_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table ovrg_scheiding_archief add constraint ar_ovrg_scheiding_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('ovrg_scheiding_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table ovrg_scheiding_archief add(geom sdo_geometry );
CREATE INDEX ovrg_scheiding_archief_ge1_idx ON ovrg_scheiding_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=COLLECTION');

comment on table ovrg_scheiding_archief is 'RSGB class OVERIGE SCHEIDING';
comment on column ovrg_scheiding_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid overige scheiding';
comment on column ovrg_scheiding_archief.identif is '[PK] NEN3610ID - Identificatie overige scheiding';
comment on column ovrg_scheiding_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid overige scheiding';
comment on column ovrg_scheiding_archief.geom is 'LijnVlak - Geometrie overige scheiding';
comment on column ovrg_scheiding_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging overige scheiding';
comment on column ovrg_scheiding_archief.status is 'A8 - Status overige scheiding';
comment on column ovrg_scheiding_archief.type is 'AN40 - Type overige scheiding';

create table overig_terrein_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(16) not null,
	fk_2oao_sc_identif varchar2(16)
);
alter table overig_terrein_archief add constraint ar_overig_terrein_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table overig_terrein_archief is 'RSGB class OVERIG TERREIN. Subclass van: BENOEMD TERREIN -> BENOEMD OBJECT';
comment on column overig_terrein_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar benoemd_terrein.dat_beg_geldh - Datum begin geldigheid benoemd terrein';
comment on column overig_terrein_archief.sc_identif is '[PK] AN16, FK naar benoemd_terrein.sc_identif - Benoemd object identificatie';
comment on column overig_terrein_archief.fk_2oao_sc_identif is '[FK] AN16, FK naar ovrg_addresseerb_obj_aand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als officieel adres"';

create table pand_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(16) not null,
	bruto_inhoud decimal(6,0),
	datum_einde_geldh varchar2(19),
	hoogste_bouwlaag decimal(3,0),
	identif_bgtpnd varchar2(255),
	indic_geconstateerd varchar2(1),
	inwwijze_geom_bovenaanzicht varchar2(24),
	inwwijze_geom_maaiveld varchar2(24),
	laagste_bouwlaag decimal(3,0),
	oorspronkelijk_bouwjaar decimal(4,0),
	oppervlakte decimal(6,0),
	status varchar2(80),
	relve_hoogteligging decimal(1,0),
	status_voortgang_bouw varchar2(24)
);
alter table pand_archief add constraint ar_pand_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('pand_archief', 'geom_bovenaanzicht', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table pand_archief add(geom_bovenaanzicht sdo_geometry );
CREATE INDEX pand_archief_geom_bovenaa1_idx ON pand_archief (geom_bovenaanzicht) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
insert into user_sdo_geom_metadata values('pand_archief', 'geom_maaiveld', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table pand_archief add(geom_maaiveld sdo_geometry );
CREATE INDEX pand_archief_geom_maaivel2_idx ON pand_archief (geom_maaiveld) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table pand_archief is 'RSGB class PAND';
comment on column pand_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid pand';
comment on column pand_archief.identif is '[PK] AN16 - Pandidentificatie';
comment on column pand_archief.bruto_inhoud is 'N6 - Bruto inhoud pand';
comment on column pand_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid pand';
comment on column pand_archief.hoogste_bouwlaag is 'N3 - Hoogste bouwlaag pand';
comment on column pand_archief.identif_bgtpnd is 'NEN3610ID - Identificatie BGTPND';
comment on column pand_archief.indic_geconstateerd is 'AN1 - Indicatie geconstateerd pand';
comment on column pand_archief.inwwijze_geom_bovenaanzicht is 'AN24 - Inwinningswijze geometrie bovenaanzicht';
comment on column pand_archief.inwwijze_geom_maaiveld is 'AN24 - Inwinningswijze geometrie maaiveld';
comment on column pand_archief.laagste_bouwlaag is 'N3 - Laagste bouwlaag pand';
comment on column pand_archief.oorspronkelijk_bouwjaar is 'N4 - Oorspronkelijk bouwjaar pand';
comment on column pand_archief.oppervlakte is 'N6 - Oppervlakte pand';
comment on column pand_archief.geom_bovenaanzicht is 'GM_Surface - Pandgeometrie bovenaanzicht';
comment on column pand_archief.geom_maaiveld is 'GM_MultiSurface - Pandgeometrie maaiveld';
comment on column pand_archief.status is 'AN80 - Pandstatus';
comment on column pand_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging pand';
comment on column pand_archief.status_voortgang_bouw is 'AN24 - Status voortgang bouw';

create table scheiding_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table scheiding_archief add constraint ar_scheiding_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('scheiding_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table scheiding_archief add(geom sdo_geometry );
CREATE INDEX scheiding_archief_geom1_idx ON scheiding_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=COLLECTION');

comment on table scheiding_archief is 'RSGB class SCHEIDING';
comment on column scheiding_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid scheiding';
comment on column scheiding_archief.identif is '[PK] NEN3610ID - Identificatie scheiding';
comment on column scheiding_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid scheiding';
comment on column scheiding_archief.geom is 'LijnVlak - Geometrie scheiding';
comment on column scheiding_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging scheiding';
comment on column scheiding_archief.status is 'A8 - Status scheiding';
comment on column scheiding_archief.type is 'AN40 - Type scheiding';

create table spoor_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	functie varchar2(25),
	relve_hoogteligging decimal(1,0),
	status varchar2(8)
);
alter table spoor_archief add constraint ar_spoor_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('spoor_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table spoor_archief add(geom sdo_geometry );
CREATE INDEX spoor_archief_geom1_idx ON spoor_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=LINE');

comment on table spoor_archief is 'RSGB class SPOOR';
comment on column spoor_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid spoor';
comment on column spoor_archief.identif is '[PK] NEN3610ID - Identificatie spoor';
comment on column spoor_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid spoor';
comment on column spoor_archief.functie is 'AN25 - Functie spoor';
comment on column spoor_archief.geom is 'GM_Curve - Geometrie spoor';
comment on column spoor_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging spoor';
comment on column spoor_archief.status is 'A8 - Status spoor';

create table stadsdeel_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	naam varchar2(40),
	status varchar2(8)
);
alter table stadsdeel_archief add constraint ar_stadsdeel_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('stadsdeel_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table stadsdeel_archief add(geom sdo_geometry );
CREATE INDEX stadsdeel_archief_geom1_idx ON stadsdeel_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table stadsdeel_archief is 'RSGB class STADSDEEL';
comment on column stadsdeel_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid stadsdeel';
comment on column stadsdeel_archief.identif is '[PK] NEN3610ID - Identificatie stadsdeel';
comment on column stadsdeel_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid stadsdeel';
comment on column stadsdeel_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging stadsdeel';
comment on column stadsdeel_archief.geom is 'GM_Surface - Stadsdeelgeometrie';
comment on column stadsdeel_archief.naam is 'AN40 - Stadsdeelnaam';
comment on column stadsdeel_archief.status is 'A8 - Status stadsdeel';

create table standplaats_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(16) not null,
	indic_geconst varchar2(1),
	status varchar2(80),
	fk_4nra_sc_identif varchar2(16)
);
alter table standplaats_archief add constraint ar_standplaats_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table standplaats_archief is 'RSGB class STANDPLAATS. Subclass van: BENOEMD TERREIN -> BENOEMD OBJECT';
comment on column standplaats_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar benoemd_terrein.dat_beg_geldh - Datum begin geldigheid benoemd terrein';
comment on column standplaats_archief.sc_identif is '[PK] AN16, FK naar benoemd_terrein.sc_identif - Benoemd object identificatie';
comment on column standplaats_archief.indic_geconst is 'AN1 - Indicatie geconstateerde standplaats';
comment on column standplaats_archief.status is 'AN80 - Standplaatsstatus';
comment on column standplaats_archief.fk_4nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als hoofdadres"';

create table verblijfsobj_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(16) not null,
	aantal_kamers decimal(2,0),
	hoogste_bouwlaag decimal(3,0),
	indic_geconstateerd varchar2(1),
	laagste_bouwlaag decimal(3,0),
	ontsluiting_verdieping varchar2(3),
	soort_woonobj decimal(1,0),
	toegang_bouwlaag decimal(3,0),
	status varchar2(80),
	fk_11nra_sc_identif varchar2(16)
);
alter table verblijfsobj_archief add constraint ar_verblijfsobj_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table verblijfsobj_archief is 'RSGB class VERBLIJFSOBJECT. Subclass van: GEBOUWD OBJECT -> BENOEMD OBJECT';
comment on column verblijfsobj_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar gebouwd_obj.dat_beg_geldh - Datum begin geldigheid gebouwd object';
comment on column verblijfsobj_archief.sc_identif is '[PK] AN16, FK naar gebouwd_obj.sc_identif - Benoemd object identificatie';
comment on column verblijfsobj_archief.aantal_kamers is 'N2 - Aantal kamers';
comment on column verblijfsobj_archief.hoogste_bouwlaag is 'N3 - Hoogste bouwlaag verblijfsobject';
comment on column verblijfsobj_archief.indic_geconstateerd is 'AN1 - Indicatie geconstateerd verblijfsobject';
comment on column verblijfsobj_archief.laagste_bouwlaag is 'N3 - Laagste bouwlaag verblijfsobject';
comment on column verblijfsobj_archief.ontsluiting_verdieping is 'AN3 - Ontsluiting verdieping';
comment on column verblijfsobj_archief.soort_woonobj is 'N1 - Soort woonobject';
comment on column verblijfsobj_archief.toegang_bouwlaag is 'N3 - Toegang bouwlaag verblijfsobject';
comment on column verblijfsobj_archief.status is 'AN80 - Verblijfsobjectstatus';
comment on column verblijfsobj_archief.fk_11nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING): "heeft als hoofdadres"';

create table verblijfstitel_archief(
	aand decimal(2,0) not null,
	begindatum_geldh varchar2(19) not null,
	eindd_geldh varchar2(19),
	omschr varchar2(100)
);
alter table verblijfstitel_archief add constraint ar_verblijfstitel_pk primary key(aand,begindatum_geldh);

comment on table verblijfstitel_archief is 'RSGB class VERBLIJFSTITEL';
comment on column verblijfstitel_archief.aand is '[PK] N2 - Aanduiding verblijfstitel';
comment on column verblijfstitel_archief.begindatum_geldh is '[PK] OnvolledigeDatum - Begindatum geldigheid verblijfstitel';
comment on column verblijfstitel_archief.eindd_geldh is 'OnvolledigeDatum - Einddatum geldigheid verblijfstitel';
comment on column verblijfstitel_archief.omschr is 'AN100 - Verblijfstitelomschrijving';

create table vrijstaand_vegetatie_o_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40)
);
alter table vrijstaand_vegetatie_o_archief add constraint ar_vrijstaand_vegetatie_obj_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('vrijstaand_vegetatie_o_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table vrijstaand_vegetatie_o_archief add(geom sdo_geometry );
CREATE INDEX vrijstaand_vegetatie_o_ar1_idx ON vrijstaand_vegetatie_o_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table vrijstaand_vegetatie_o_archief is 'RSGB class VRIJSTAAND VEGETATIE OBJECT';
comment on column vrijstaand_vegetatie_o_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_o_archief.identif is '[PK] NEN3610ID - Identificatie vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_o_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_o_archief.geom is 'GM_Surface - Geometrie vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_o_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_o_archief.status is 'A8 - Status vrijstaand vegetatie object';
comment on column vrijstaand_vegetatie_o_archief.type is 'AN40 - Type vrijstaand vegetatie object';

create table waterdeel_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	droogvallend varchar2(1),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	type varchar2(40),
	fk_7opr_identifcode varchar2(16)
);
alter table waterdeel_archief add constraint ar_waterdeel_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('waterdeel_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table waterdeel_archief add(geom sdo_geometry );
CREATE INDEX waterdeel_archief_geom1_idx ON waterdeel_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table waterdeel_archief is 'RSGB class WATERDEEL. Directe superclass van: WATERVAKONDERDEEL';
comment on column waterdeel_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid waterdeel';
comment on column waterdeel_archief.identif is '[PK] NEN3610ID - Identificatie waterdeel';
comment on column waterdeel_archief.clazz is 'Aanduiding subclass';
comment on column waterdeel_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid waterdeel';
comment on column waterdeel_archief.droogvallend is 'AN1 - Droogvallend';
comment on column waterdeel_archief.geom is 'GM_Surface - Geometrie waterdeel';
comment on column waterdeel_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging waterdeel';
comment on column waterdeel_archief.status is 'A8 - Status waterdeel';
comment on column waterdeel_archief.type is 'AN40 - Type waterdeel';
comment on column waterdeel_archief.fk_7opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table watervakonderdeel_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(255) not null,
	fk_1wad_identif varchar2(255)
);
alter table watervakonderdeel_archief add constraint ar_watervakonderdeel_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table watervakonderdeel_archief is 'RSGB class WATERVAKONDERDEEL. Subclass van: WATERDEEL';
comment on column watervakonderdeel_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar waterdeel.dat_beg_geldh - Datum begin geldigheid waterdeel';
comment on column watervakonderdeel_archief.sc_identif is '[PK] NEN3610ID, FK naar waterdeel.identif - Identificatie waterdeel';
comment on column watervakonderdeel_archief.fk_1wad_identif is '[FK] NEN3610ID, FK naar waterdeel.identif';

create table waterschap_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	datum_einde_geldh varchar2(19),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	naam varchar2(40)
);
alter table waterschap_archief add constraint ar_waterschap_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('waterschap_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table waterschap_archief add(geom sdo_geometry );
CREATE INDEX waterschap_archief_geom1_idx ON waterschap_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table waterschap_archief is 'RSGB class WATERSCHAP';
comment on column waterschap_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid waterschap';
comment on column waterschap_archief.identif is '[PK] NEN3610ID - Identificatie waterschap';
comment on column waterschap_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid waterschap';
comment on column waterschap_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging waterschap';
comment on column waterschap_archief.status is 'A8 - Status waterschap';
comment on column waterschap_archief.geom is 'GM_Surface - Waterschapgeometrie';
comment on column waterschap_archief.naam is 'AN40 - Waterschapnaam';

create table wegdeel_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(255) not null,
	clazz varchar2(255),
	datum_einde_geldh varchar2(19),
	functie varchar2(25),
	fysiek_voork varchar2(20),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	fk_8opr_identifcode varchar2(16)
);
alter table wegdeel_archief add constraint ar_wegdeel_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('wegdeel_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table wegdeel_archief add(geom sdo_geometry );
CREATE INDEX wegdeel_archief_geom1_idx ON wegdeel_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table wegdeel_archief is 'RSGB class WEGDEEL. Directe superclass van: WEGVAKONDERDEEL';
comment on column wegdeel_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid wegdeel';
comment on column wegdeel_archief.identif is '[PK] NEN3610ID - Identificatie wegdeel';
comment on column wegdeel_archief.clazz is 'Aanduiding subclass';
comment on column wegdeel_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid wegdeel';
comment on column wegdeel_archief.functie is 'AN25 - Functie wegdeel';
comment on column wegdeel_archief.fysiek_voork is 'AN20 - Fysiek voorkomen wegdeel';
comment on column wegdeel_archief.geom is 'GM_Surface - Geometrie wegdeel';
comment on column wegdeel_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging wegdeel';
comment on column wegdeel_archief.status is 'A8 - Status wegdeel';
comment on column wegdeel_archief.fk_8opr_identifcode is '[FK] AN16, FK naar openb_rmte.identifcode: "maakt deel uit van"';

create table wegvakonderdeel_archief(
	sc_dat_beg_geldh varchar2(19) not null,
	sc_identif varchar2(255) not null,
	fk_1wgd_identif varchar2(255)
);
alter table wegvakonderdeel_archief add constraint ar_wegvakonderdeel_pk primary key(sc_dat_beg_geldh,sc_identif);

comment on table wegvakonderdeel_archief is 'RSGB class WEGVAKONDERDEEL. Subclass van: WEGDEEL';
comment on column wegvakonderdeel_archief.sc_dat_beg_geldh is '[PK] OnvolledigeDatum, FK naar wegdeel.dat_beg_geldh - Datum begin geldigheid wegdeel';
comment on column wegvakonderdeel_archief.sc_identif is '[PK] NEN3610ID, FK naar wegdeel.identif - Identificatie wegdeel';
comment on column wegvakonderdeel_archief.fk_1wgd_identif is '[FK] NEN3610ID, FK naar wegdeel.identif';

create table wijk_archief(
	dat_beg_geldh varchar2(19) not null,
	code decimal(6,0) not null,
	datum_einde_geldh varchar2(19),
	identif_imgeowyk varchar2(255),
	relve_hoogteligging decimal(1,0),
	status varchar2(8),
	naam varchar2(80)
);
alter table wijk_archief add constraint ar_wijk_pk primary key(dat_beg_geldh,code);
insert into user_sdo_geom_metadata values('wijk_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table wijk_archief add(geom sdo_geometry );
CREATE INDEX wijk_archief_geom1_idx ON wijk_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table wijk_archief is 'RSGB class WIJK';
comment on column wijk_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid wijk';
comment on column wijk_archief.code is '[PK] N6 - Wijkcode';
comment on column wijk_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid wijk';
comment on column wijk_archief.identif_imgeowyk is 'NEN3610ID - Identificatie IMGeoWYK';
comment on column wijk_archief.relve_hoogteligging is 'N1 - Relatieve hoogteligging wijk';
comment on column wijk_archief.status is 'A8 - Status wijk';
comment on column wijk_archief.geom is 'GM_Surface - Wijkgeometrie';
comment on column wijk_archief.naam is 'AN80 - Wijknaam';

create table wnplts_archief(
	dat_beg_geldh varchar2(19) not null,
	identif varchar2(4) not null,
	datum_einde_geldh varchar2(19),
	indic_geconst varchar2(1),
	naam varchar2(80),
	naam_nen varchar2(24),
	status varchar2(80),
	fk_7gem_code decimal(4,0)
);
alter table wnplts_archief add constraint ar_wnplts_pk primary key(dat_beg_geldh,identif);
insert into user_sdo_geom_metadata values('wnplts_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table wnplts_archief add(geom sdo_geometry );
CREATE INDEX wnplts_archief_geom1_idx ON wnplts_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table wnplts_archief is 'RSGB class WOONPLAATS';
comment on column wnplts_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid woonplaats';
comment on column wnplts_archief.identif is '[PK] AN4 - Woonplaatsidentificatie';
comment on column wnplts_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid woonplaats';
comment on column wnplts_archief.indic_geconst is 'AN1 - Indicatie geconstateerde woonplaats';
comment on column wnplts_archief.geom is 'GM_Surface - Woonplaatsgeometrie';
comment on column wnplts_archief.naam is 'AN80 - Woonplaatsnaam';
comment on column wnplts_archief.naam_nen is 'AN24 - Woonplaatsnaam NEN';
comment on column wnplts_archief.status is 'AN80 - Woonplaatsstatus';
comment on column wnplts_archief.fk_7gem_code is '[FK] N4, FK naar gemeente.code: "ligt in"';

create table woz_deelobj_archief(
	dat_beg_geldh_deelobj decimal(8,0) not null,
	nummer decimal(6,0) not null,
	code varchar2(4),
	datum_einde_geldh_deelobj decimal(8,0),
	status decimal(2,0),
	fk_4pnd_identif varchar2(16),
	fk_5tgo_identif varchar2(16),
	fk_6woz_nummer decimal(12,0)
);
alter table woz_deelobj_archief add constraint ar_woz_deelobj_pk primary key(dat_beg_geldh_deelobj,nummer);

comment on table woz_deelobj_archief is 'RSGB class WOZ-DEELOBJECT';
comment on column woz_deelobj_archief.dat_beg_geldh_deelobj is '[PK] N8 - Datum begin geldigheid deelobject';
comment on column woz_deelobj_archief.nummer is '[PK] N6 - Nummer WOZ-deelobject';
comment on column woz_deelobj_archief.code is 'AN4 - Code WOZ-deelobject';
comment on column woz_deelobj_archief.datum_einde_geldh_deelobj is 'N8 - Datum einde geldigheid deelobject';
comment on column woz_deelobj_archief.status is 'N2 - Status WOZ-deelobject';
comment on column woz_deelobj_archief.fk_4pnd_identif is '[FK] AN16, FK naar pand.identif: "bestaat uit"';
comment on column woz_deelobj_archief.fk_5tgo_identif is '[FK] AN16, FK naar benoemd_obj.identif: "bestaat uit"';
comment on column woz_deelobj_archief.fk_6woz_nummer is '[FK] N12, FK naar woz_obj.nummer: "is onderdeel van"';

create table woz_obj_archief(
	dat_beg_geldh varchar2(19) not null,
	nummer decimal(12,0) not null,
	datum_einde_geldh varchar2(19),
	gebruikscode decimal(2,0),
	grondoppervlakte decimal(11,0),
	soort_obj_code decimal(4,0),
	status decimal(2,0),
	vastgestelde_waarde decimal(11,0),
	waardepeildatum date
);
alter table woz_obj_archief add constraint ar_woz_obj_pk primary key(dat_beg_geldh,nummer);
insert into user_sdo_geom_metadata values('woz_obj_archief', 'geom', MDSYS.SDO_DIM_ARRAY(
	MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
	MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)),
	28992
);
alter table woz_obj_archief add(geom sdo_geometry );
CREATE INDEX woz_obj_archief_geom1_idx ON woz_obj_archief (geom) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');

comment on table woz_obj_archief is 'RSGB class WOZ-OBJECT';
comment on column woz_obj_archief.dat_beg_geldh is '[PK] OnvolledigeDatum - Datum begin geldigheid WOZ-object';
comment on column woz_obj_archief.nummer is '[PK] N12 - WOZ-objectnummer';
comment on column woz_obj_archief.datum_einde_geldh is 'OnvolledigeDatum - Datum einde geldigheid WOZ-object';
comment on column woz_obj_archief.gebruikscode is 'N2 - Gebruikscode';
comment on column woz_obj_archief.geom is 'GM_Surface - Geometrie WOZ-object';
comment on column woz_obj_archief.grondoppervlakte is 'N11 - Grondoppervlakte';
comment on column woz_obj_archief.soort_obj_code is 'N4 - Soort-object-code';
comment on column woz_obj_archief.status is 'N2 - Status WOZ-object';
comment on column woz_obj_archief.vastgestelde_waarde is 'N11 - Vastgestelde waarde';
comment on column woz_obj_archief.waardepeildatum is 'Datum - Waardepeildatum';

create table woz_waarde_archief(
	waardepeildatum decimal(8,0) not null,
	status_beschikking decimal(2,0),
	toestandspeildatum decimal(8,0),
	vastgestelde_waarde decimal(11,0),
	fk_1woz_nummer decimal(12,0)
);
alter table woz_waarde_archief add constraint ar_woz_waarde_pk primary key(waardepeildatum);

comment on table woz_waarde_archief is 'RSGB class WOZ-WAARDE';
comment on column woz_waarde_archief.waardepeildatum is '[PK] N8 - Waardepeildatum';
comment on column woz_waarde_archief.status_beschikking is 'N2 - Status beschikking';
comment on column woz_waarde_archief.toestandspeildatum is 'N8 - Toestandspeildatum';
comment on column woz_waarde_archief.vastgestelde_waarde is 'N11 - Vastgestelde waarde';
comment on column woz_waarde_archief.fk_1woz_nummer is '[FK] N12, FK naar woz_obj.nummer';

create table app_re_kad_perceel_archief(
	fk_nn_lh_apr_sc_kad_identif decimal(15,0) not null,
	fk_nn_lh_apr_sc_dat_beg_geldh varchar2(19) not null,
	fk_nn_rh_kdp_sc_kad_identif decimal(15,0) not null
);
alter table app_re_kad_perceel_archief add constraint ar_app_re_kad_perceel_pk primary key(fk_nn_lh_apr_sc_kad_identif,fk_nn_lh_apr_sc_dat_beg_geldh,fk_nn_rh_kdp_sc_kad_identif);

comment on table app_re_kad_perceel_archief is 'N - N relatie: APPARTEMENTSRECHT "maakt deel uit van appartementencomplex dat staat op" KADASTRAAL PERCEEL';
comment on column app_re_kad_perceel_archief.fk_nn_lh_apr_sc_kad_identif is '[FK] N15, FK naar app_re.sc_kad_identif (is FK naar superclass KADASTRALE ONROERENDE ZAAK)';
comment on column app_re_kad_perceel_archief.fk_nn_lh_apr_sc_dat_beg_geldh is '[FK] OnvolledigeDatum, FK naar app_re.sc_dat_beg_geldh (is FK naar superclass KADASTRALE ONROERENDE ZAAK)';
comment on column app_re_kad_perceel_archief.fk_nn_rh_kdp_sc_kad_identif is '[FK] N15, FK naar kad_perceel.sc_kad_identif (is FK naar superclass KADASTRALE ONROERENDE ZAAK)';

create table benoemd_terrein_benoem_archief(
	fk_nn_lh_btr_sc_identif varchar2(16) not null,
	fk_nn_lh_btr_dat_beg_geldh varchar2(19) not null,
	fk_nn_rh_btr_sc_identif varchar2(16) not null
);
alter table benoemd_terrein_benoem_archief add constraint ar_benoemd_terrein_benoemd__pk primary key(fk_nn_lh_btr_sc_identif,fk_nn_lh_btr_dat_beg_geldh,fk_nn_rh_btr_sc_identif);

comment on table benoemd_terrein_benoem_archief is 'N - N relatie: BENOEMD TERREIN "is ontstaan uit / overgegaan in" BENOEMD TERREIN';
comment on column benoemd_terrein_benoem_archief.fk_nn_lh_btr_sc_identif is '[FK] AN16, FK naar benoemd_terrein.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column benoemd_terrein_benoem_archief.fk_nn_lh_btr_dat_beg_geldh is '[FK] OnvolledigeDatum, FK naar benoemd_terrein.dat_beg_geldh';
comment on column benoemd_terrein_benoem_archief.fk_nn_rh_btr_sc_identif is '[FK] AN16, FK naar benoemd_terrein.sc_identif (is FK naar superclass BENOEMD OBJECT)';

create table gemeente_gemeente_archief(
	fk_nn_lh_gem_code decimal(4,0) not null,
	fk_nn_lh_gem_dat_beg_geldh varchar2(19) not null,
	fk_nn_rh_gem_code decimal(4,0) not null
);
alter table gemeente_gemeente_archief add constraint ar_gemeente_gemeente_pk primary key(fk_nn_lh_gem_code,fk_nn_lh_gem_dat_beg_geldh,fk_nn_rh_gem_code);

comment on table gemeente_gemeente_archief is 'N - N relatie: GEMEENTE "is overgegaan in" GEMEENTE';
comment on column gemeente_gemeente_archief.fk_nn_lh_gem_code is '[FK] N4, FK naar gemeente.code';
comment on column gemeente_gemeente_archief.fk_nn_lh_gem_dat_beg_geldh is '[FK] OnvolledigeDatum, FK naar gemeente.dat_beg_geldh';
comment on column gemeente_gemeente_archief.fk_nn_rh_gem_code is '[FK] N4, FK naar gemeente.code';

create table kad_onrrnd_zk_kad_onrr_archief(
	fk_nn_lh_koz_kad_identif decimal(15,0) not null,
	fk_nn_lh_koz_dat_beg_geldh varchar2(19) not null,
	fk_nn_rh_koz_kad_identif decimal(15,0) not null
);
alter table kad_onrrnd_zk_kad_onrr_archief add constraint ar_kad_onrrnd_zk_kad_onrrnd_pk primary key(fk_nn_lh_koz_kad_identif,fk_nn_lh_koz_dat_beg_geldh,fk_nn_rh_koz_kad_identif);

comment on table kad_onrrnd_zk_kad_onrr_archief is 'N - N relatie: KADASTRALE ONROERENDE ZAAK "is hoofdperceel bij mandelige" KADASTRALE ONROERENDE ZAAK';
comment on column kad_onrrnd_zk_kad_onrr_archief.fk_nn_lh_koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif';
comment on column kad_onrrnd_zk_kad_onrr_archief.fk_nn_lh_koz_dat_beg_geldh is '[FK] OnvolledigeDatum, FK naar kad_onrrnd_zk.dat_beg_geldh';
comment on column kad_onrrnd_zk_kad_onrr_archief.fk_nn_rh_koz_kad_identif is '[FK] N15, FK naar kad_onrrnd_zk.kad_identif';

create table ligplaats_nummeraand_archief(
	fk_nn_lh_lpl_sc_identif varchar2(16) not null,
	fk_nn_lh_lpl_sc_dat_beg_geldh varchar2(19) not null,
	fk_nn_rh_nra_sc_identif varchar2(16) not null
);
alter table ligplaats_nummeraand_archief add constraint ar_ligplaats_nummeraand_pk primary key(fk_nn_lh_lpl_sc_identif,fk_nn_lh_lpl_sc_dat_beg_geldh,fk_nn_rh_nra_sc_identif);

comment on table ligplaats_nummeraand_archief is 'N - N relatie: LIGPLAATS "heeft als nevenadressen" NUMMERAANDUIDING';
comment on column ligplaats_nummeraand_archief.fk_nn_lh_lpl_sc_identif is '[FK] AN16, FK naar ligplaats.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column ligplaats_nummeraand_archief.fk_nn_lh_lpl_sc_dat_beg_geldh is '[FK] OnvolledigeDatum, FK naar ligplaats.sc_dat_beg_geldh (is FK naar superclass BENOEMD TERREIN)';
comment on column ligplaats_nummeraand_archief.fk_nn_rh_nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING)';

create table standplaats_nummeraand_archief(
	fk_nn_lh_spl_sc_identif varchar2(16) not null,
	fk_nn_lh_spl_sc_dat_beg_geldh varchar2(19) not null,
	fk_nn_rh_nra_sc_identif varchar2(16) not null
);
alter table standplaats_nummeraand_archief add constraint ar_standplaats_nummeraand_pk primary key(fk_nn_lh_spl_sc_identif,fk_nn_lh_spl_sc_dat_beg_geldh,fk_nn_rh_nra_sc_identif);

comment on table standplaats_nummeraand_archief is 'N - N relatie: STANDPLAATS "heeft als nevenadressen" NUMMERAANDUIDING';
comment on column standplaats_nummeraand_archief.fk_nn_lh_spl_sc_identif is '[FK] AN16, FK naar standplaats.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column standplaats_nummeraand_archief.fk_nn_lh_spl_sc_dat_beg_geldh is '[FK] OnvolledigeDatum, FK naar standplaats.sc_dat_beg_geldh (is FK naar superclass BENOEMD TERREIN)';
comment on column standplaats_nummeraand_archief.fk_nn_rh_nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING)';

create table verblijfsobj_pand_archief(
	fk_nn_lh_vbo_sc_identif varchar2(16) not null,
	fk_nn_lh_vbo_sc_dat_beg_geldh varchar2(19) not null,
	fk_nn_rh_pnd_identif varchar2(16) not null
);
alter table verblijfsobj_pand_archief add constraint ar_verblijfsobj_pand_pk primary key(fk_nn_lh_vbo_sc_identif,fk_nn_lh_vbo_sc_dat_beg_geldh,fk_nn_rh_pnd_identif);

comment on table verblijfsobj_pand_archief is 'N - N relatie: VERBLIJFSOBJECT "maakt deel uit van" PAND';
comment on column verblijfsobj_pand_archief.fk_nn_lh_vbo_sc_identif is '[FK] AN16, FK naar verblijfsobj.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column verblijfsobj_pand_archief.fk_nn_lh_vbo_sc_dat_beg_geldh is '[FK] OnvolledigeDatum, FK naar verblijfsobj.sc_dat_beg_geldh (is FK naar superclass GEBOUWD OBJECT)';
comment on column verblijfsobj_pand_archief.fk_nn_rh_pnd_identif is '[FK] AN16, FK naar pand.identif';

create table verblijfsobj_nummeraan_archief(
	fk_nn_lh_vbo_sc_identif varchar2(16) not null,
	fk_nn_lh_vbo_sc_dat_beg_geldh varchar2(19) not null,
	fk_nn_rh_nra_sc_identif varchar2(16) not null
);
alter table verblijfsobj_nummeraan_archief add constraint ar_verblijfsobj_nummeraand_pk primary key(fk_nn_lh_vbo_sc_identif,fk_nn_lh_vbo_sc_dat_beg_geldh,fk_nn_rh_nra_sc_identif);

comment on table verblijfsobj_nummeraan_archief is 'N - N relatie: VERBLIJFSOBJECT "heeft als nevenadres(sen)" NUMMERAANDUIDING';
comment on column verblijfsobj_nummeraan_archief.fk_nn_lh_vbo_sc_identif is '[FK] AN16, FK naar verblijfsobj.sc_identif (is FK naar superclass BENOEMD OBJECT)';
comment on column verblijfsobj_nummeraan_archief.fk_nn_lh_vbo_sc_dat_beg_geldh is '[FK] OnvolledigeDatum, FK naar verblijfsobj.sc_dat_beg_geldh (is FK naar superclass GEBOUWD OBJECT)';
comment on column verblijfsobj_nummeraan_archief.fk_nn_rh_nra_sc_identif is '[FK] AN16, FK naar nummeraand.sc_identif (is FK naar superclass ADRESSEERBAAR OBJECT AANDUIDING)';

insert into meta_enumeratie_waardes (naam,waarde) values ('Aard aantekening kadastraal object','koopovereenkomst waarvan de inschrijving resulteert in een koperbescherming volgens artikel 7:3 BW');
insert into meta_enumeratie_waardes (naam,waarde) values ('Aard aantekening kadastraal object','koopovereenkomst of voorovereenkomst tot koop waarvan de inschrijving resulteert in koperbescherming volgens artikel 10 Wvg');
insert into meta_enumeratie_waardes (naam,waarde) values ('Aard aantekening kadastraal object','vervallen van de koopovereenkomst of voorovereenkomst tot koop die zijn ingeschreven op grond van artikel 7:3 of artikel 10 Wvg');
insert into meta_enumeratie_waardes (naam,waarde) values ('Aard aantekening kadastraal object','voorwaardelijke verkrijging');
insert into meta_enumeratie_waardes (naam,waarde) values ('Aard aantekening kadastraal object','erfdienstbaarheid');
insert into meta_enumeratie_waardes (naam,waarde) values ('Aard aantekening kadastraal object','kwalitatieve verplichting alsin art 6:25 BW');
insert into meta_enumeratie_waardes (naam,waarde) values ('Aard aantekening kadastraal object','onderbewindstelling van een grondstuk');
insert into meta_enumeratie_waardes (naam,waarde) values ('Aard aantekening kadastraal object','publiekrechtelijke beperking');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor wonen');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','eensgezinswoning');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','bejaardenwoning');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','recreatiewoning');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','meergezinswoning');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','dienstwoning');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','zorgwoonverblijf');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','aanleunwoonverblijf');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','bejaardenwoonverblijf (in bejaardenoord, centrale keuken)');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','jongerenwooneenheid');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','gehandicaptenwooneenheid');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor niet-wonen');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor handel, horeca en bedrijf');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','detailhandel');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','cafe/bar/restaurant');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','hotel/logies');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','kantoor');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','opslag en distributie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','fabricage en productie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','onderhoud en reparatie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','laboratoria');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','overige doeleinden voor niet-wonen');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor cultuur');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','wijk-/buurt-/verenigingsactiviteiten');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','congres');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','theater en concert');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','musea');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','expositie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','bioscoop');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','bibliotheek');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','overige doeleinden voor cultuur');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor recreatie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','sport buiten');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','sport binnen');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','recreatie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','zwembad');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','dierenverzorging');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','natuur en landschap');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','overige doeleinden voor recreatie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor agrarisch bedrijf');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','akkerbouw');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','veeteelt');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','tuinbouw');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','gemengd bedrijf');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','overige doeleinden voor agrarisch bedrijf');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor onderwijs');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','kinderopvang');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','basisschool');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','algemeen voortgezet onderwijs');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','hoger beroepsonderwijs');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','academisch onderwijs');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','bijzonder onderwijs');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','vrijetijds onderwijs');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','overige doeleinden voor onderwijs');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor gezondheidszorg');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','ziekenhuis');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','polikliniek');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','praktijkruimte');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','verpleegtehuis');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','verzorgingstehuis en bejaardentehuis');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','dagverblijf');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','wijkverzorging');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','psychiatrische inrichting');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','overige doeleinden voor gezondheidszorg');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor verkeer');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','stalling (fietsen/auto''s)');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','wegverkeer');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','spoorwegverkeer');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','luchtvaart');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','scheepvaart');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','overige doeleinden voor verkeer');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','doeleinden voor nutsvoorzieningen');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','waternuts doeleinden');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','gas');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','elektriciteit');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','CAI');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','telecommunicatie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','waterschaps en waterverdediging');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','overige doeleinden voor nutsvoorzieningen');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','andere doeleinden van openbaar nut');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','gemeentehuis');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','politie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','brandweer');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','gevangenis/gesticht');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','begraafplaats/crematorium');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','godsdienst (kerk, klooster e.d.)');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','defensie');
insert into meta_enumeratie_waardes (naam,waarde) values ('Bouwkundige bestemming actueel GEBOUWD OBJECT','overige andere doeleinden van openbaar nut');
insert into meta_enumeratie_waardes (naam,waarde) values ('Huishoudensoort','institutioneel huishouden');
insert into meta_enumeratie_waardes (naam,waarde) values ('Huishoudensoort','alleenstaand (inclusief andere personen die in hetzelfde object wonen, maar een eigen huishouding voeren)');
insert into meta_enumeratie_waardes (naam,waarde) values ('Huishoudensoort','2 personen, vaste partners, geen thuiswonende kinderen');
insert into meta_enumeratie_waardes (naam,waarde) values ('Huishoudensoort','2 personen, vaste partners, een of meer thuiswonende kinderen');
insert into meta_enumeratie_waardes (naam,waarde) values ('Huishoudensoort','eenoudergezin, ouder met een of meer thuiswonende kinderen');
insert into meta_enumeratie_waardes (naam,waarde) values ('Huishoudensoort','overig particulier huishouden (samenwoning van personen die geen partnerrelatie onderhouden of een ouder-kindrelatie hebben, maar wel gezamenlijk een huishouding voeren)');
insert into meta_enumeratie (tabel,kolom,enumeratie) values ('gebouwd_obj','bouwk_best_act','Bouwkundige bestemming actueel GEBOUWD OBJECT');
insert into meta_enumeratie (tabel,kolom,enumeratie) values ('kad_onrrnd_zk_aantek','aard_aantek_kad_obj','Aard aantekening kadastraal object');
insert into meta_referentielijsten (tabel,kolom,referentielijst) values ('ingeschr_nat_prs','btnlndse_nation','NATIONALITEIT');
insert into meta_referentielijsten (tabel,kolom,referentielijst) values ('ingeschr_nat_prs','land_vanwaar_ingeschr','LAND');
insert into meta_referentielijsten (tabel,kolom,referentielijst) values ('ingeschr_nat_prs','land_waarnaar_vertrokken','LAND');
insert into meta_referentielijsten (tabel,kolom,referentielijst) values ('nat_prs','academische_titel','ACADEMISCHE TITEL');
insert into meta_referentielijsten (tabel,kolom,referentielijst) values ('rsdoc','soort','REISDOCUMENTSOORT');
insert into meta_referentielijsten (tabel,kolom,referentielijst) values ('zak_recht','aand_aard_recht_verkort','AARD RECHT VERKORT');
insert into meta_referentielijsten (tabel,kolom,referentielijst) values ('zak_recht','aand_aard_verkregen_recht','AARD VERKREGEN RECHT');

-- Handmatige scripts

-- Script: 101_herkomst_metadata.sql


create table herkomst_metadata (
    id number,
    tabel varchar2(255),
    kolom varchar2(255),
    waarde varchar2(255),
    herkomst_br varchar2(255),
    datum timestamp,
    primary key(tabel, kolom, waarde, herkomst_br, datum)
);
-- Script: 102_metagegevens_brondocument.sql


-- Een brondocument wordt niet in de originele tabel opgenomen omdat dit een
-- 0..n relatie kan zijn en niet altijd een 0..1. 

-- In deze tabel wordt verwezen naar de tabel waarop het metagegeven brondocument
-- van toepassing is. Voor de identificatie van de rij van de tabel naar waar
-- wordt verwezen is een enkele kolom gebruikt: composite keys worden niet ondersteund.
-- Composite keys worden toch voornamelijk toegepast bij een combinate met datum
-- begin geldigheid.

create table brondocument (
  tabel varchar2(30),
  tabel_identificatie varchar2(50),
  identificatie varchar2(50),
  gemeente number,
  omschrijving varchar2(255),
  datum date,
  ref_id varchar2(50),
  primary key(tabel,tabel_identificatie,identificatie)
);
  
-- Script: 103_woz_waarde.sql

alter table woz_waarde add constraint woz_waarde_pk primary key (fk_1woz_nummer);

alter table woz_waarde_archief drop constraint ar_woz_waarde_pk;
alter table woz_waarde_archief add constraint woz_waarde_archief_pk primary key(waardepeildatum,fk_1woz_nummer);
-- Script: 104_brondocument_indices.sql

create index brondocument_tabel_idx on brondocument(tabel);
create index brondocument_tabel_identif_idx on brondocument(tabel_identificatie);
create index brondocument_identificatie_idx on brondocument(identificatie);
CREATE INDEX BRONDOCUMENT_OMSCHRIJVING_IDX ON BRONDOCUMENT(OMSCHRIJVING);

CREATE INDEX brondocument_ref_id  ON brondocument (ref_id);

-- Script: 105_appartements_rechten.sql

-- selecteer parent en child app_re-s die een ondersplitsing zijn of zijn geworden


CREATE OR REPLACE VIEW v_bd_app_re_app_re AS 
 SELECT b1.ref_id AS app_re_identif,
    b2.ref_id AS parent_app_re_identif
   FROM brondocument b1
     JOIN brondocument b2 ON b2.identificatie = b1.identificatie
  WHERE b2.omschrijving = 'betrokkenBij Ondersplitsing' AND b1.omschrijving = 'ontstaanUit Ondersplitsing'
  GROUP BY b1.ref_id, b2.ref_id;


-- Haalt alle percelen ids op met 1 of meer app_re (dient als basis voor de view voor de kaart)

CREATE OR REPLACE VIEW v_bd_kad_perceel_with_app_re AS 
 SELECT DISTINCT b2.ref_id AS perceel_identif
   FROM brondocument b1
     JOIN brondocument b2 ON b2.identificatie = b1.identificatie
  WHERE b2.omschrijving = 'betrokkenBij HoofdSplitsing' AND b1.omschrijving = 'ontstaanUit HoofdSplitsing';

-- view om kaart te maken met percelen die 1 of meerdere appartementen hebben

CREATE OR REPLACE VIEW v_bd_kad_perceel_met_app AS 
 SELECT v.perceel_identif,
    kp.sc_kad_identif,
    kp.aand_soort_grootte,
    kp.grootte_perceel,
    kp.omschr_deelperceel,
    kp.fk_7kdp_sc_kad_identif,
    kp.ka_deelperceelnummer,
    kp.ka_kad_gemeentecode,
    kp.ka_perceelnummer,
    kp.ka_sectie,
    kp.begrenzing_perceel,
    kp.plaatscoordinaten_perceel
   FROM v_bd_kad_perceel_with_app_re v
     JOIN kad_perceel kp ON v.perceel_identif = kp.sc_kad_identif;

-- view om vlakken kaart te maken met percelen die 1 of meerdere appartementen hebben
CREATE OR REPLACE VIEW v_bd_kad_perceel_met_app_vlak AS 
 SELECT 
    CAST(ROWNUM AS INTEGER) AS objectid,
    v.perceel_identif,
    kp.sc_kad_identif,
    kp.aand_soort_grootte,
    kp.grootte_perceel,
    kp.omschr_deelperceel,
    kp.fk_7kdp_sc_kad_identif,
    kp.ka_deelperceelnummer,
    kp.ka_kad_gemeentecode,
    kp.ka_perceelnummer,
    kp.ka_sectie,
    kp.begrenzing_perceel
   FROM v_bd_kad_perceel_with_app_re v
     JOIN kad_perceel kp ON v.perceel_identif = kp.sc_kad_identif;

---Views om app_res op te zoeken (inclusief ondersplitsingen)
-- oracle ondersteund geen recursive/iteratieve/hierarchische queries met joins/unions (https://community.oracle.com/thread/55016?start=0&tstart=0), dus meerdere views (itt postgres die toffe recursieve queries ondersteunt

CREATE OR REPLACE VIEW v_bd_app_re_kad_perceel AS 
 SELECT b1.ref_id AS app_re_identif,
    b2.ref_id AS perceel_identif
   FROM brondocument b1
     JOIN brondocument b2 ON b2.identificatie = b1.identificatie
  WHERE b2.omschrijving = 'betrokkenBij HoofdSplitsing' AND b1.omschrijving = 'ontstaanUit HoofdSplitsing'
  GROUP BY b1.ref_id, b2.ref_id;

CREATE OR REPLACE VIEW v_bd_app_re_2_kad_perceel AS 
 SELECT vaa.app_re_identif,
    vap.perceel_identif
   FROM v_bd_app_re_app_re vaa
     JOIN v_bd_app_re_kad_perceel vap ON vaa.parent_app_re_identif = vap.app_re_identif
  GROUP BY vaa.app_re_identif, vap.perceel_identif;

CREATE OR REPLACE VIEW v_bd_app_re_3_kad_perceel AS 
 SELECT vaa.app_re_identif,
    vap.perceel_identif
   FROM v_bd_app_re_app_re vaa
     JOIN v_bd_app_re_2_kad_perceel vap ON vaa.parent_app_re_identif = vap.app_re_identif
  GROUP BY vaa.app_re_identif, vap.perceel_identif;



CREATE OR REPLACE VIEW v_bd_app_re_all_kad_perceel AS 

select * from v_bd_app_re_kad_perceel
union
select * from v_bd_app_re_2_kad_perceel
union 
select * from v_bd_app_re_3_kad_perceel;

-- view om app_re' s bij percelen op te zoeken
CREATE OR REPLACE VIEW v_bd_app_re_bij_perceel AS 
 SELECT 
    CAST(ROWNUM AS INTEGER) AS objectid,
    ar.sc_kad_identif,
    ar.fk_2nnp_sc_identif,
    ar.ka_appartementsindex,
    ar.ka_kad_gemeentecode,
    ar.ka_perceelnummer,
    ar.ka_sectie,
    kp.begrenzing_perceel
   FROM v_bd_app_re_all_kad_perceel v
     JOIN kad_perceel kp ON v.perceel_identif = kp.sc_kad_identif
     JOIN app_re ar ON v.app_re_identif = ar.sc_kad_identif;



-- Script: 106_bag_views.sql

/*
Views for visualizing the bag data.
*/
-- DROP VIEWS
-- DROP VIEW V_ADRES_TOTAAL;
-- DROP VIEW V_ADRES_STANDPLAATS;
-- DROP VIEW V_ADRES_LIGPLAATS;
-- DROP VIEW V_ADRES;
-- DROP VIEW V_LIGPLAATS;
-- DROP VIEW V_STANDPLAATS;
-- DROP VIEW V_LIGPLAATS_ALLES;
-- DROP VIEW V_STANDPLAATS_ALLES;
-- DROP VIEW V_PAND_GEBRUIK_NIET_INGEMETEN;
-- DROP VIEW V_PAND_IN_GEBRUIK;
-- DROP VIEW V_VERBLIJFSOBJECT;
-- DROP VIEW V_VERBLIJFSOBJECT_GEVORMD;
-- DROP VIEW V_VERBLIJFSOBJECT_ALLES;

-------------------------------------------------
-- V_VERBLIJFSOBJECT_ALLES
-------------------------------------------------
CREATE OR REPLACE VIEW
    V_VERBLIJFSOBJECT_ALLES
    (
        OBJECTID,
        FID,
        PAND_ID,
        GEMEENTE,
        WOONPLAATS,
        STRAATNAAM,
        HUISNUMMER,
        HUISLETTER,
        HUISNUMMER_TOEV,
        POSTCODE,
        STATUS,
        OPPERVLAKTE,
        THE_GEOM
    ) AS
SELECT
    CAST(ROWNUM AS INTEGER)     AS OBJECTID,
    VBO.SC_IDENTIF              AS FID,
    FKPAND.FK_NN_RH_PND_IDENTIF AS PAND_ID,
    GEM.NAAM                    AS GEMEENTE,
    CASE
         WHEN ADDROBJ.FK_6WPL_IDENTIF IS NOT NULL
         -- opzoeken want in andere woonplaats
         THEN  (SELECT NAAM FROM WNPLTS WHERE IDENTIF = FK_6WPL_IDENTIF)
         ELSE WP.NAAM           
    END                         AS WOONPLAATS,
    GEOR.NAAM_OPENB_RMTE        AS STRAATNAAM,
    ADDROBJ.HUINUMMER           AS HUISNUMMER,
    ADDROBJ.HUISLETTER,
    ADDROBJ.HUINUMMERTOEVOEGING AS HUISNUMMER_TOEV,
    ADDROBJ.POSTCODE,
    VBO.STATUS,
    GOBJ.OPPERVLAKTE_OBJ AS OPPERVLAKTE,
    GOBJ.PUNTGEOM        AS THE_GEOM
FROM
    ((((((((VERBLIJFSOBJ VBO
JOIN
    VERBLIJFSOBJ_PAND FKPAND
ON
    ((FKPAND.FK_NN_LH_VBO_SC_IDENTIF = VBO.SC_IDENTIF)))
JOIN
    GEBOUWD_OBJ GOBJ
ON
    ((GOBJ.SC_IDENTIF = VBO.SC_IDENTIF)))
JOIN
    NUMMERAAND NA
ON
    ((NA.SC_IDENTIF = VBO.FK_11NRA_SC_IDENTIF)))
JOIN
    ADDRESSEERB_OBJ_AAND ADDROBJ
ON
    ((ADDROBJ.IDENTIF = NA.SC_IDENTIF)))
JOIN
    GEM_OPENB_RMTE GEOR
ON
    ((GEOR.IDENTIFCODE = ADDROBJ.FK_7OPR_IDENTIFCODE)))
LEFT JOIN
    OPENB_RMTE_WNPLTS ORWP
ON
    ((GEOR.IDENTIFCODE = ORWP.FK_NN_LH_OPR_IDENTIFCODE)))
LEFT JOIN
    WNPLTS WP
ON
    ((ORWP.FK_NN_RH_WPL_IDENTIF = WP.IDENTIF)))
LEFT JOIN
    GEMEENTE GEM
ON
    ((
            WP.FK_7GEM_CODE = GEM.CODE)))
WHERE
    ((((
                    ADDROBJ.DAT_EIND_GELDH IS NULL)
            AND (
                    GEOR.DATUM_EINDE_GELDH IS NULL))
        AND (
                GEM.DATUM_EINDE_GELDH IS NULL))
    AND (
            GOBJ.DATUM_EINDE_GELDH IS NULL));
-------------------------------------------------
-- V_VERBLIJFSOBJECT_GEVORMD
-------------------------------------------------
CREATE OR REPLACE VIEW
    V_VERBLIJFSOBJECT_GEVORMD
    (
        OBJECTID,
        FID,
        PAND_ID,
        GEMEENTE,
        WOONPLAATS,
        STRAATNAAM,
        HUISNUMMER,
        HUISLETTER,
        HUISNUMMER_TOEV,
        POSTCODE,
        --GEBRUIKSDOEL,
        STATUS,
        OPPERVLAKTE,
        THE_GEOM
    ) AS
SELECT
    OBJECTID,
    FID,
    PAND_ID,
    GEMEENTE,
    WOONPLAATS,
    STRAATNAAM,
    HUISNUMMER,
    HUISLETTER,
    HUISNUMMER_TOEV,
    POSTCODE,
    --GEBRUIKSDOEL,
    STATUS,
    OPPERVLAKTE,
    THE_GEOM
FROM
    V_VERBLIJFSOBJECT_ALLES
WHERE
    STATUS = 'Verblijfsobject gevormd';
-------------------------------------------------
-- V_VERBLIJFSOBJECT
-------------------------------------------------
CREATE OR REPLACE VIEW
    V_VERBLIJFSOBJECT
    (
        OBJECTID,
        FID,
        PAND_ID,
        GEMEENTE,
        WOONPLAATS,
        STRAATNAAM,
        HUISNUMMER,
        HUISLETTER,
        HUISNUMMER_TOEV,
        POSTCODE,
        --GEBRUIKSDOEL,
        STATUS,
        OPPERVLAKTE,
        THE_GEOM
    ) AS
SELECT
    OBJECTID,
    FID,
    PAND_ID,
    GEMEENTE,
    WOONPLAATS,
    STRAATNAAM,
    HUISNUMMER,
    HUISLETTER,
    HUISNUMMER_TOEV,
    POSTCODE,
    --GEBRUIKSDOEL,
    STATUS,
    OPPERVLAKTE,
    THE_GEOM
FROM
    V_VERBLIJFSOBJECT_ALLES
WHERE
    STATUS = 'Verblijfsobject in gebruik (niet ingemeten)'
OR  STATUS = 'Verblijfsobject in gebruik';
-------------------------------------------------
-- V_PAND_IN_GEBRUIK
-------------------------------------------------
CREATE  OR REPLACE VIEW
    V_PAND_IN_GEBRUIK
    (
        OBJECTID,
        FID,
        EIND_DATUM_GELDIG,
        BEGIN_DATUM_GELDIG,
        STATUS,
        BOUWJAAR,
        THE_GEOM
    ) AS
SELECT
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    P.IDENTIF               AS FID,
    P.DATUM_EINDE_GELDH     AS EIND_DATUM_GELDIG,
    P.DAT_BEG_GELDH         AS BEGIN_DATUM_GELDIG,
    P.STATUS,
    P.OORSPRONKELIJK_BOUWJAAR AS BOUWJAAR,
    P.GEOM_BOVENAANZICHT      AS THE_GEOM
FROM
    PAND P
WHERE
    STATUS IN ('Sloopvergunning verleend',
               'Pand in gebruik (niet ingemeten)',
               'Pand in gebruik',
               'Bouw gestart')
AND DATUM_EINDE_GELDH IS NULL;
-------------------------------------------------
-- V_PAND_GEBRUIK_NIET_INGEMETEN
-------------------------------------------------
CREATE OR REPLACE VIEW
    V_PAND_GEBRUIK_NIET_INGEMETEN
    (
        OBJECTID,
        FID,
        BEGIN_DATUM_GELDIG,
        STATUS,
        BOUWJAAR,
        THE_GEOM
    ) AS
SELECT
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    P.IDENTIF               AS FID,
    P.DAT_BEG_GELDH         AS BEGIN_DATUM_GELDIG,
    P.STATUS,
    P.OORSPRONKELIJK_BOUWJAAR AS BOUWJAAR,
    P.GEOM_BOVENAANZICHT      AS THE_GEOM
FROM
    PAND P
WHERE
    STATUS = 'Pand in gebruik (niet ingemeten)'
AND DATUM_EINDE_GELDH IS NULL;
-------------------------------------------------
-- V_STANDPLAATS
-------------------------------------------------
CREATE OR REPLACE VIEW
    V_STANDPLAATS
    (
        OBJECTID,
        SC_IDENTIF,
        STATUS,
        FK_4NRA_SC_IDENTIF,
        DATUM_BEGIN_GELDH,
        GEOMETRIE
    ) AS
SELECT
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    SP.SC_IDENTIF,
    SP.STATUS,
    SP.FK_4NRA_SC_IDENTIF,
    BT.DAT_BEG_GELDH,
    BT.GEOM AS GEOMETRIE
FROM
    STANDPLAATS SP
LEFT JOIN
    BENOEMD_TERREIN BT
ON
    (
        SP.SC_IDENTIF = BT.SC_IDENTIF);
-------------------------------------------------
-- V_LIGPLAATS
-------------------------------------------------
CREATE OR REPLACE VIEW
    V_LIGPLAATS
    (
        OBJECTID,
        SC_IDENTIF,
        STATUS,
        FK_4NRA_SC_IDENTIF,
        DAT_BEG_GELDH,
        GEOMETRIE
    ) AS
SELECT
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    LP.SC_IDENTIF,
    LP.STATUS,
    LP.FK_4NRA_SC_IDENTIF,
    BT.DAT_BEG_GELDH,
    BT.GEOM AS GEOMETRIE
FROM
    LIGPLAATS LP
LEFT JOIN
    BENOEMD_TERREIN BT
ON
    (
        LP.SC_IDENTIF = BT.SC_IDENTIF) ;
-------------------------------------------------
-- V_LIGPLAATS_ALLES
-------------------------------------------------
/*
LIGPLAATS MET HOOFDADRES
*/		
CREATE OR REPLACE VIEW
    V_LIGPLAATS_ALLES
    (
        OBJECTID,
        FID,
        GEMEENTE,
        WOONPLAATS,
        STRAATNAAM,
        HUISNUMMER,
        HUISLETTER,
        HUISNUMMER_TOEV,
        POSTCODE,
        STATUS,
        THE_GEOM
    ) AS
SELECT
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    LP.SC_IDENTIF           AS FID,
    GEM.NAAM                AS GEMEENTE,
    CASE
         WHEN ADDROBJ.FK_6WPL_IDENTIF IS NOT NULL
         -- opzoeken want in andere woonplaats
         THEN  (SELECT NAAM FROM WNPLTS WHERE IDENTIF = FK_6WPL_IDENTIF)
         ELSE WP.NAAM           
    END                     AS WOONPLAATS,
    GEOR.NAAM_OPENB_RMTE    AS STRAATNAAM,
    ADDROBJ.HUINUMMER       AS HUISNUMMER,
    ADDROBJ.HUISLETTER,
    ADDROBJ.HUINUMMERTOEVOEGING AS HUISNUMMER_TOEV,
    ADDROBJ.POSTCODE,
    LP.STATUS,
    BT.GEOM AS THE_GEOM
FROM
    (((((((LIGPLAATS LP
JOIN
    BENOEMD_TERREIN BT
ON
    ((LP.SC_IDENTIF = BT.SC_IDENTIF)))
JOIN
    NUMMERAAND NA
ON
    ((NA.SC_IDENTIF = LP.FK_4NRA_SC_IDENTIF)))
JOIN
    ADDRESSEERB_OBJ_AAND ADDROBJ
ON
    ((ADDROBJ.IDENTIF = NA.SC_IDENTIF)))
JOIN
    GEM_OPENB_RMTE GEOR
ON
    ((GEOR.IDENTIFCODE = ADDROBJ.FK_7OPR_IDENTIFCODE)))
LEFT JOIN
    OPENB_RMTE_WNPLTS ORWP
ON
    ((GEOR.IDENTIFCODE = ORWP.FK_NN_LH_OPR_IDENTIFCODE)))
LEFT JOIN
    WNPLTS WP
ON
    ((ORWP.FK_NN_RH_WPL_IDENTIF = WP.IDENTIF)))
LEFT JOIN
    GEMEENTE GEM
ON
    ((
            WP.FK_7GEM_CODE = GEM.CODE)))
WHERE
    ((((
                    ADDROBJ.DAT_EIND_GELDH IS NULL)
            AND (
                    GEOR.DATUM_EINDE_GELDH IS NULL))
        AND (
                GEM.DATUM_EINDE_GELDH IS NULL))
    AND (
            BT.DATUM_EINDE_GELDH IS NULL));	
-------------------------------------------------
-- V_STANDPLAATS_ALLES
-------------------------------------------------
/*
STANDPLAATS MET HOOFDADRES
*/		
CREATE OR REPLACE VIEW
    V_STANDPLAATS_ALLES
    (
        OBJECTID,
        FID,
        GEMEENTE,
        WOONPLAATS,
        STRAATNAAM,
        HUISNUMMER,
        HUISLETTER,
        HUISNUMMER_TOEV,
        POSTCODE,
        STATUS,
        THE_GEOM
    ) AS
SELECT
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    SP.SC_IDENTIF           AS FID,
    GEM.NAAM                AS GEMEENTE,
    CASE
         WHEN ADDROBJ.FK_6WPL_IDENTIF IS NOT NULL
         -- opzoeken want in andere woonplaats
         THEN  (SELECT NAAM FROM WNPLTS WHERE IDENTIF = FK_6WPL_IDENTIF)
         ELSE WP.NAAM           
    END                     AS WOONPLAATS,
    GEOR.NAAM_OPENB_RMTE    AS STRAATNAAM,
    ADDROBJ.HUINUMMER       AS HUISNUMMER,
    ADDROBJ.HUISLETTER,
    ADDROBJ.HUINUMMERTOEVOEGING AS HUISNUMMER_TOEV,
    ADDROBJ.POSTCODE,
    SP.STATUS,
    BT.GEOM AS THE_GEOM
FROM
    (((((((STANDPLAATS SP
JOIN
    BENOEMD_TERREIN BT
ON
    ((SP.SC_IDENTIF = BT.SC_IDENTIF)))
JOIN
    NUMMERAAND NA
ON
    ((NA.SC_IDENTIF = SP.FK_4NRA_SC_IDENTIF)))
JOIN
    ADDRESSEERB_OBJ_AAND ADDROBJ
ON
    ((ADDROBJ.IDENTIF = NA.SC_IDENTIF)))
JOIN
    GEM_OPENB_RMTE GEOR
ON
    ((GEOR.IDENTIFCODE = ADDROBJ.FK_7OPR_IDENTIFCODE)))
LEFT JOIN
    OPENB_RMTE_WNPLTS ORWP
ON
    ((GEOR.IDENTIFCODE = ORWP.FK_NN_LH_OPR_IDENTIFCODE)))
LEFT JOIN
    WNPLTS WP
ON
    ((ORWP.FK_NN_RH_WPL_IDENTIF = WP.IDENTIF)))
LEFT JOIN
    GEMEENTE GEM
ON
    ((
            WP.FK_7GEM_CODE = GEM.CODE)))
WHERE
    ((((
                    ADDROBJ.DAT_EIND_GELDH IS NULL)
            AND (
                    GEOR.DATUM_EINDE_GELDH IS NULL))
        AND (
                GEM.DATUM_EINDE_GELDH IS NULL))
    AND (
            BT.DATUM_EINDE_GELDH IS NULL));			
-------------------------------------------------
-- V_ADRES
-------------------------------------------------
/*
VOLLEDIGE ADRESSENLIJST
STANDPLAATS EN LIGPLAATS VIA BENOEMD_TERREIN, 
WAARBIJ CENTROIDE VAN POLYGON WORDT GENOMEN
PLUS VERBLIJFSOBJECT VIA PUNT OBJECT VAN GEBOUWD_OBJ
*/
CREATE OR REPLACE VIEW
    V_ADRES
    (
        OBJECTID,
        FID,
        GEMEENTE,
        WOONPLAATS,
        STRAATNAAM,
        HUISNUMMER,
        HUISLETTER,
        HUISNUMMER_TOEV,
        POSTCODE,
        STATUS,
        OPPERVLAKTE,
        THE_GEOM
    ) AS
SELECT
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    VBO.SC_IDENTIF          AS FID,
    GEM.NAAM                AS GEMEENTE,
    CASE
         WHEN ADDROBJ.FK_6WPL_IDENTIF IS NOT NULL
         -- opzoeken want in andere woonplaats
         THEN  (SELECT NAAM FROM WNPLTS WHERE IDENTIF = FK_6WPL_IDENTIF)
         ELSE WP.NAAM           
    END                     AS WOONPLAATS,
    GEOR.NAAM_OPENB_RMTE    AS STRAATNAAM,
    ADDROBJ.HUINUMMER       AS HUISNUMMER,
    ADDROBJ.HUISLETTER,
    ADDROBJ.HUINUMMERTOEVOEGING AS HUISNUMMER_TOEV,
    ADDROBJ.POSTCODE,
    VBO.STATUS,
    GOBJ.OPPERVLAKTE_OBJ || ' m2' AS OPPERVLAKTE,
    GOBJ.PUNTGEOM                 AS THE_GEOM
FROM
    VERBLIJFSOBJ VBO
JOIN
    GEBOUWD_OBJ GOBJ
ON
    (
        GOBJ.SC_IDENTIF = VBO.SC_IDENTIF )
LEFT JOIN
    VERBLIJFSOBJ_NUMMERAAND VNA
ON
    (
        VNA.FK_NN_LH_VBO_SC_IDENTIF = VBO.SC_IDENTIF )
LEFT JOIN
    NUMMERAAND NA
ON
    (
        NA.SC_IDENTIF = VBO.FK_11NRA_SC_IDENTIF)
LEFT JOIN
    ADDRESSEERB_OBJ_AAND ADDROBJ
ON
    (
        ADDROBJ.IDENTIF = NA.SC_IDENTIF )
JOIN
    GEM_OPENB_RMTE GEOR
ON
    (
        GEOR.IDENTIFCODE = ADDROBJ.FK_7OPR_IDENTIFCODE )
LEFT JOIN
    OPENB_RMTE_WNPLTS ORWP
ON
    (
        GEOR.IDENTIFCODE = ORWP.FK_NN_LH_OPR_IDENTIFCODE)
LEFT JOIN
    WNPLTS WP
ON
    (
        ORWP.FK_NN_RH_WPL_IDENTIF = WP.IDENTIF)
LEFT JOIN
    GEMEENTE GEM
ON
    (
        WP.FK_7GEM_CODE = GEM.CODE )
WHERE
    NA.STATUS = 'Naamgeving uitgegeven'
AND (
        VBO.STATUS = 'Verblijfsobject in gebruik (niet ingemeten)'
    OR  VBO.STATUS = 'Verblijfsobject in gebruik');
-------------------------------------------------
-- V_ADRES_LIGPLAATS
-------------------------------------------------
CREATE  OR REPLACE VIEW
    V_ADRES_LIGPLAATS
    (
        FID,
        GEMEENTE,
        WOONPLAATS,
        STRAATNAAM,
        HUISNUMMER,
        HUISLETTER,
        HUISNUMMER_TOEV,
        POSTCODE,
        STATUS,
        THE_GEOM,
        CENTROIDE
    ) AS
SELECT
    LPA.SC_IDENTIF       AS FID,
    GEM.NAAM             AS GEMEENTE,
    CASE
         WHEN ADDROBJ.FK_6WPL_IDENTIF IS NOT NULL
         -- opzoeken want in andere woonplaats
         THEN  (SELECT NAAM FROM WNPLTS WHERE IDENTIF = FK_6WPL_IDENTIF)
         ELSE WP.NAAM           
    END                  AS WOONPLAATS,
    GEOR.NAAM_OPENB_RMTE AS STRAATNAAM,
    ADDROBJ.HUINUMMER    AS HUISNUMMER,
    ADDROBJ.HUISLETTER,
    ADDROBJ.HUINUMMERTOEVOEGING AS HUISNUMMER_TOEV,
    ADDROBJ.POSTCODE,
    LPA.STATUS,
    BENTER.GEOM AS THE_GEOM,
    SDO_GEOM.SDO_CENTROID(BENTER.GEOM,2)
FROM
    LIGPLAATS LPA
JOIN
    BENOEMD_TERREIN BENTER
ON
    (
        BENTER.SC_IDENTIF = LPA.SC_IDENTIF )
LEFT JOIN
    LIGPLAATS_NUMMERAAND LNA
ON
    (
        LNA.FK_NN_LH_LPL_SC_IDENTIF = LPA.SC_IDENTIF )
LEFT JOIN
    NUMMERAAND NA
ON
    (
        NA.SC_IDENTIF = LPA.FK_4NRA_SC_IDENTIF )
LEFT JOIN
    ADDRESSEERB_OBJ_AAND ADDROBJ
ON
    (
        ADDROBJ.IDENTIF = NA.SC_IDENTIF )
JOIN
    GEM_OPENB_RMTE GEOR
ON
    (
        GEOR.IDENTIFCODE = ADDROBJ.FK_7OPR_IDENTIFCODE )
LEFT JOIN
    OPENB_RMTE_WNPLTS ORWP
ON
    (
        GEOR.IDENTIFCODE = ORWP.FK_NN_LH_OPR_IDENTIFCODE)
LEFT JOIN
    WNPLTS WP
ON
    (
        ORWP.FK_NN_RH_WPL_IDENTIF = WP.IDENTIF)
LEFT JOIN
    GEMEENTE GEM
ON
    (
        WP.FK_7GEM_CODE = GEM.CODE )
WHERE
    NA.STATUS = 'Naamgeving uitgegeven'
AND LPA.STATUS = 'Plaats aangewezen';
-------------------------------------------------
-- V_ADRES_STANDPLAATS
-------------------------------------------------
CREATE OR REPLACE VIEW
    V_ADRES_STANDPLAATS
    (
        FID,
        GEMEENTE,
        WOONPLAATS,
        STRAATNAAM,
        HUISNUMMER,
        HUISLETTER,
        HUISNUMMER_TOEV,
        POSTCODE,
        STATUS,
        THE_GEOM,
        CENTROIDE
    ) AS
SELECT
    SPL.SC_IDENTIF       AS FID,
    GEM.NAAM             AS GEMEENTE,
    CASE
         WHEN ADDROBJ.FK_6WPL_IDENTIF IS NOT NULL
         -- opzoeken want in andere woonplaats
         THEN  (SELECT NAAM FROM WNPLTS WHERE IDENTIF = FK_6WPL_IDENTIF)
         ELSE WP.NAAM           
    END                  AS WOONPLAATS,
    GEOR.NAAM_OPENB_RMTE AS STRAATNAAM,
    ADDROBJ.HUINUMMER    AS HUISNUMMER,
    ADDROBJ.HUISLETTER,
    ADDROBJ.HUINUMMERTOEVOEGING AS HUISNUMMER_TOEV,
    ADDROBJ.POSTCODE,
    SPL.STATUS,
    BENTER.GEOM AS THE_GEOM,
    SDO_GEOM.SDO_CENTROID(BENTER.GEOM,2)
FROM
    STANDPLAATS SPL
JOIN
    BENOEMD_TERREIN BENTER
ON
    (
        BENTER.SC_IDENTIF = SPL.SC_IDENTIF )
LEFT JOIN
    STANDPLAATS_NUMMERAAND SNA
ON
    (
        SNA.FK_NN_LH_SPL_SC_IDENTIF = SPL.SC_IDENTIF )
LEFT JOIN
    NUMMERAAND NA
ON
    (
        NA.SC_IDENTIF = SPL.FK_4NRA_SC_IDENTIF)
LEFT JOIN
    ADDRESSEERB_OBJ_AAND ADDROBJ
ON
    (
        ADDROBJ.IDENTIF = NA.SC_IDENTIF )
JOIN
    GEM_OPENB_RMTE GEOR
ON
    (
        GEOR.IDENTIFCODE = ADDROBJ.FK_7OPR_IDENTIFCODE )
LEFT JOIN
    OPENB_RMTE_WNPLTS ORWP
ON
    (
        GEOR.IDENTIFCODE = ORWP.FK_NN_LH_OPR_IDENTIFCODE)
LEFT JOIN
    WNPLTS WP
ON
    (
        ORWP.FK_NN_RH_WPL_IDENTIF = WP.IDENTIF)
LEFT JOIN
    GEMEENTE GEM
ON
    (
        WP.FK_7GEM_CODE = GEM.CODE )
WHERE
    NA.STATUS = 'Naamgeving uitgegeven'
AND SPL.STATUS = 'Plaats aangewezen';
-------------------------------------------------
-- V_ADRES_TOTAAL
-------------------------------------------------
CREATE OR REPLACE VIEW
    V_ADRES_TOTAAL
    (
        OBJECTID,
        FID,
        STRAATNAAM,
        HUISNUMMER,
        HUISLETTER,
        HUISNUMMER_TOEV,
        POSTCODE,
        GEMEENTE,
        WOONPLAATS,
        THE_GEOM
    ) AS
  SELECT
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    QRY.*
    FROM (
        SELECT
            FID ,
            STRAATNAAM,
            HUISNUMMER,
            HUISLETTER,
            HUISNUMMER_TOEV,
            POSTCODE,
            GEMEENTE,
        		WOONPLAATS,
            THE_GEOM
        FROM
            V_ADRES
        UNION ALL
        SELECT
            FID ,
            STRAATNAAM,
            HUISNUMMER,
            HUISLETTER,
            HUISNUMMER_TOEV,
            POSTCODE,
            GEMEENTE,
        		WOONPLAATS,
            CENTROIDE AS THE_GEOM
        FROM
            V_ADRES_LIGPLAATS
        UNION ALL
        SELECT
            FID ,
            STRAATNAAM,
            HUISNUMMER,
            HUISLETTER,
            HUISNUMMER_TOEV,
            POSTCODE,
            GEMEENTE,
        		WOONPLAATS,
            CENTROIDE AS THE_GEOM
        FROM
            V_ADRES_STANDPLAATS
    ) QRY;
    
    
-------------------------------------------------
-- v_adres_pandvlak: adressen met (maaiveld) pandvlak
-------------------------------------------------
CREATE OR REPLACE VIEW
    v_adres_pandvlak
    (
        objectid,
        fid,
        pand_id,
        gemeente,
        woonplaats,
        straatnaam,
        huisnummer,
        huisletter,
        huisnummer_toev,
        postcode,
        status,
        the_geom
    ) AS
SELECT
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    vbo.sc_identif              AS fid,
    fkpand.fk_nn_rh_pnd_identif AS pand_id,
    gem.naam                    AS gemeente,
    CASE
        WHEN addrobj.fk_6wpl_identif IS NOT NULL
        -- opzoeken want in andere woonplaats
        THEN  (select naam from wnplts where identif = fk_6wpl_identif)
        ELSE wp.naam           
    END                  AS woonplaats,
    geor.naam_openb_rmte AS straatnaam,
    addrobj.huinummer    AS huisnummer,
    addrobj.huisletter,
    addrobj.huinummertoevoeging AS huisnummer_toev,
    addrobj.postcode,
    vbo.status,
    pand.geom_bovenaanzicht AS the_geom
FROM (
    verblijfsobj vbo
JOIN
    verblijfsobj_pand fkpand
ON
    (fkpand.fk_nn_lh_vbo_sc_identif = vbo.sc_identif)
JOIN 
    pand 
ON 
    (fkpand.fk_nn_rh_pnd_identif = pand.identif) 
)    
LEFT JOIN
    verblijfsobj_nummeraand vna
ON
    (vna.fk_nn_lh_vbo_sc_identif = vbo.sc_identif)

LEFT JOIN
    nummeraand na
ON
    (na.sc_identif = vbo.fk_11nra_sc_identif)

LEFT JOIN
    addresseerb_obj_aand addrobj
ON
    (addrobj.identif = na.sc_identif)
JOIN
    gem_openb_rmte geor
ON
    ( geor.identifcode = addrobj.fk_7opr_identifcode )
    
LEFT JOIN
    openb_rmte_wnplts orwp
ON
    ( geor.identifcode = orwp.fk_nn_lh_opr_identifcode)

LEFT JOIN
    wnplts wp
ON
    ( orwp.fk_nn_rh_wpl_identif = wp.identif)

LEFT JOIN
    gemeente gem
ON
    ( wp.fk_7gem_code = gem.code )
WHERE
    na.status = 'Naamgeving uitgegeven'
AND ( vbo.status = 'Verblijfsobject in gebruik (niet ingemeten)'
    OR  vbo.status = 'Verblijfsobject in gebruik');

-------------------------------------------------
-- v_adres_totaal_vlak: adressen met maaiveld vlak van pand 
--   of openbare ruimte in geval stand of ligplaats
-------------------------------------------------
CREATE OR REPLACE VIEW 
    v_adres_totaal_vlak
    (
        objectid,
        fid,
        straatnaam,
        huisnummer,
        huisletter,
        huisnummer_toev,
        postcode,
        gemeente,
        woonplaats,
        the_geom
    ) AS
SELECT 
    CAST(ROWNUM AS INTEGER) AS OBJECTID,
    qry.*
    FROM (
        SELECT
            fid,
            straatnaam,
            huisnummer,
            huisletter,
            huisnummer_toev,
            postcode,
            gemeente,
            woonplaats,
            the_geom
        FROM
            v_adres_pandvlak
        UNION ALL
        SELECT
            fid ,
            straatnaam,
            huisnummer,
            huisletter,
            huisnummer_toev,
            postcode,
            gemeente,
            woonplaats,
            the_geom
        FROM
            v_adres_ligplaats
        UNION ALL
        SELECT
            fid ,
            straatnaam,
            huisnummer,
            huisletter,
            huisnummer_toev,
            postcode,
            gemeente,
            woonplaats,
            the_geom
        FROM
            v_adres_standplaats
    ) qry;

-- Script: 107_brk_views.sql


create view v_map_kad_perceel as
select
    CAST(ROWNUM AS INTEGER) AS objectid,
    p.sc_kad_identif,
    p.begrenzing_perceel,
    p.ka_sectie || ' ' || p.ka_perceelnummer AS aanduiding,
    p.grootte_perceel,
    z.ks_koopjaar,
    z.ks_bedrag,
    z.cu_aard_cultuur_onbebouwd
from kad_perceel p
join kad_onrrnd_zk z on (z.kad_identif = p.sc_kad_identif);

create table prs_eigendom (
    fk_prs_sc_identif varchar(32), 
    primary key (fk_prs_sc_identif), 
    foreign key (fk_prs_sc_identif) references prs(sc_identif)
);

create or replace view v_kad_perceel_in_eigendom as
select 
    CAST(ROWNUM AS INTEGER) AS objectid,
    p.begrenzing_perceel,
    p.sc_kad_identif,
    p.aanduiding,
    p.grootte_perceel,
    p.ks_koopjaar,
    p.ks_bedrag,
    p.cu_aard_cultuur_onbebouwd,
    nnprs.naam
    -- rownum as wtf -- Anders Oracle ORA-13276 SRID 0 not found.
from v_map_kad_perceel p
join zak_recht zr on (zr.fk_7koz_kad_identif = p.sc_kad_identif)
join prs_eigendom prs_e on (prs_e.fk_prs_sc_identif = zr.fk_8pes_sc_identif)
left join niet_nat_prs nnprs on (nnprs.sc_identif = prs_e.fk_prs_sc_identif)
where p.begrenzing_perceel.sdo_srid is not null;

create or replace view v_kad_perceel_adres as 
select distinct 
        kp.sc_kad_identif,
        kpvbo.FK_NN_LH_TGO_IDENTIF as kad_bag_koppeling_benobj,
        gor.naam_openb_rmte as straat,
        aoa.huinummer as huisnummer,
        aoa.huisletter,
        aoa.huinummertoevoeging as toevoeging,
        aoa.postcode,
        wp.naam as woonplaats
from kad_perceel kp
join benoemd_obj_kad_onrrnd_zk kpvbo on (kpvbo.FK_NN_RH_KOZ_KAD_IDENTIF = kp.SC_KAD_IDENTIF)
left join verblijfsobj vbo on (vbo.SC_IDENTIF = kpvbo.FK_NN_LH_TGO_IDENTIF)
left join nummeraand na on (na.SC_IDENTIF = vbo.FK_11NRA_SC_IDENTIF)
left join addresseerb_obj_aand aoa on (aoa.IDENTIF = na.SC_IDENTIF)
left join gem_openb_rmte gor on (gor.IDENTIFCODE = aoa.FK_7OPR_IDENTIFCODE)
left join openb_rmte_wnplts oprw on (oprw.FK_NN_LH_OPR_IDENTIFCODE = gor.IDENTIFCODE)
left join wnplts wp on (wp.IDENTIF = oprw.FK_NN_RH_WPL_IDENTIF);

create or replace view v_kad_perceel_eenvoudig as
select
        CAST(ROWNUM AS INTEGER) AS objectid,
        p.sc_kad_identif,
        p.begrenzing_perceel,
        p.ka_sectie || ' ' || p.ka_perceelnummer AS aanduiding,
        p.grootte_perceel,   
        p_adr.kad_bag_koppeling_benobj,             
        p_adr.straat,
        p_adr.huisnummer,
        p_adr.huisletter,
        p_adr.toevoeging,
        p_adr.postcode,
        p_adr.woonplaats
from kad_perceel p
join v_kad_perceel_adres p_adr on (p_adr.sc_kad_identif = p.sc_kad_identif);

create or replace view v_kad_perceel_zak_recht as
  select 
    p.sc_kad_identif as Kadaster_identificatie,
    zr.AR_TELLER  as Aandeel_teller,
    zr.AR_NOEMER as Aandeel_noemer,
    zr.FK_3AVR_AAND as Aard_recht_aand,
--    ark.omschr as Aard_recht_omschrijving_verkort, XXX referentielijst niet gevuld
--    ar.omschr_aard_verkregenr_recht as Aard_recht_omschrijving, XXX referentielijst niet gevuld
    case when np.sc_identif is not null then 'Natuurlijk persoon' else 'Niet natuurlijk persoon' end as soort_eigenaar,
    np.NM_GESLACHTSNAAM as Geslachtsnaam,
    np.NM_VOORVOEGSEL_GESLACHTSNAAM as Voorvoegsel,
    np.NM_VOORNAMEN as Voornamen,
    np.GESLACHTSAAND as Geslacht,
    inp.VA_LOC_BESCHRIJVING as Woonadres,
    inp.GB_GEBOORTEDATUM as Geboortedatum,
--    inp.GB_GEBOORTELAND as Code_geboorteland, XXX in XSL conversie naar 2-letterige ISO code
    inp.GB_GEBOORTEPLAATS as Geboorteplaats,
    inp.OL_OVERLIJDENSDATUM as Overlijdensdatum,
    nnp.NAAM as Naam_niet_natuurlijk_persoon,
    innp.RECHTSVORM as Rechtsvorm,
    innp.STATUTAIRE_ZETEL as Statutaire_zetel,
    innp_subject.kvk_nummer
  from kad_perceel p
  join zak_recht zr on (zr.FK_7KOZ_KAD_IDENTIF = p.sc_kad_identif)
  left join aard_recht_verkort ark on (zr.FK_3AVR_AAND = ark.AAND)
  left join aard_verkregen_recht ar on (zr.FK_3AVR_AAND = ar.AAND)
  left join nat_prs np on (np.SC_IDENTIF = zr.FK_8PES_SC_IDENTIF)
  left join ingeschr_nat_prs inp on (inp.SC_IDENTIF = np.SC_IDENTIF)
  left join niet_nat_prs nnp on (nnp.sc_identif = zr.FK_8PES_SC_IDENTIF)
  left join ingeschr_niet_nat_prs innp on (innp.SC_IDENTIF = nnp.sc_identif)
  left join subject innp_subject on (innp_subject.identif = innp.sc_identif)
  where np.NM_GESLACHTSNAAM is not null or nnp.NAAM is not null;
  
create or replace view v_kad_perceel_zr_adressen as 
select 
  CAST(ROWNUM AS INTEGER) AS objectid,
  kp.SC_KAD_IDENTIF,
  kp.BEGRENZING_PERCEEL,
  kp.AANDUIDING,
  kp.GROOTTE_PERCEEL,
  kp.STRAAT,
  kp.HUISNUMMER,
  kp.HUISLETTER,
  kp.TOEVOEGING,
  kp.POSTCODE,
  kp.WOONPLAATS,
  zr.AANDEEL_TELLER,
  zr.AANDEEL_NOEMER,
  zr.AARD_RECHT_AAND,
  zr.SOORT_EIGENAAR,
  zr.GESLACHTSNAAM,
  zr.VOORVOEGSEL,
  zr.VOORNAMEN,
  zr.GESLACHT,
  zr.WOONADRES,
  zr.GEBOORTEDATUM,
  zr.GEBOORTEPLAATS,
  zr.OVERLIJDENSDATUM,
  zr.NAAM_NIET_NATUURLIJK_PERSOON,
  zr.RECHTSVORM,
  zr.STATUTAIRE_ZETEL,
  zr.KVK_NUMMER
from v_kad_perceel_eenvoudig kp
join v_kad_perceel_zak_recht zr on (zr.KADASTER_IDENTIFICATIE = kp.sc_kad_identif);

create or replace view v_kad_perceel_app_rechten as
select 
 kpe.SC_KAD_IDENTIF as perceel_identificatie,
-- kpe.KA_SECTIE || ' ' || kpe.KA_PERCEELNUMMER as perceelnr,
 kpe.aanduiding,
 kpe.straat, kpe.huisnummer, kpe.toevoeging, kpe.huisletter,
 kpe.straat || ' ' || kpe.huisnummer || ' ' || kpe.huisletter || ' ' || kpe.toevoeging || ' ' || kpe.postcode as adres,
-- zr.kadaster_identif as links_zak_recht,
 zr.FK_3AVR_AAND as complex_zak_recht_aard_aand,
-- zr.FK2_PERSOON as links_zak_recht_persoon,

--    case when np1.PK_PERSOON is not null then 'Natuurlijk persoon' else 'Niet natuurlijk persoon' end as l_soort_eigenaar,
    case when np1.sc_identif is not null then np1.NM_GESLACHTSNAAM || ', ' || np1.NM_VOORNAMEN || ' ' || np1.NM_VOORVOEGSEL_GESLACHTSNAAM else nnp1.NAAM end as perceel_zak_recht_naam,
--    nnp1.NAAM as l_nnp,
    
-- bd1.identificatie as brondocument, 
-- zr2.kadaster_identif as rechts_zak_recht,
 zr2.FK_3AVR_AAND as app_re_zak_recht_aard_aand,
-- zr2.FK2_PERSOON as rechts_zak_recht_persoon,

--    case when np2.PK_PERSOON is not null then 'Natuurlijk persoon' else 'Niet natuurlijk persoon' end as r_soort_eigenaar,
    case when np2.sc_identif is not null then np2.NM_GESLACHTSNAAM || ', ' || np2.NM_VOORNAMEN || ' ' || np2.NM_VOORVOEGSEL_GESLACHTSNAAM else nnp2.NAAM end as app_re_zak_recht_naam,
--    nnp2.NAAM as r_nnp,

ar.SC_KAD_IDENTIF as app_re_identificatie,
 to_number(ar.KA_APPARTEMENTSINDEX) as appartementsindex --,
-- ar.FK1_NIET_NAT_PERSOON as app_re_vve,
-- ar_vve_nnp.naam as app_re_vve_naam,
-- ar_vve_innp.rechtsvorm as app_re_vve_rechtsvorm,
-- ar_vve_innp.rsin as app_re_vve_rsin
from v_kad_perceel_eenvoudig kpe
join zak_recht zr on (zr.FK_7KOZ_KAD_IDENTIF = kpe.SC_KAD_IDENTIF)

  left join nat_prs np1 on (np1.SC_IDENTIF = zr.FK_8PES_SC_IDENTIF)
  left join ingeschr_nat_prs inp1 on (inp1.SC_IDENTIF = np1.SC_IDENTIF)
  left join niet_nat_prs nnp1 on (nnp1.sc_identif = zr.FK_8PES_SC_IDENTIF)
  left join ingeschr_niet_nat_prs innp1 on (innp1.sc_identif = nnp1.sc_identif)

join brondocument bd1 on (bd1.tabel = 'ZAK_RECHT' and bd1.tabel_identificatie = zr.kadaster_identif)
join brondocument bd2 on (bd2.tabel = 'ZAK_RECHT' and bd2.tabel_identificatie <> zr.kadaster_identif and bd2.identificatie = bd1.identificatie)
join zak_recht zr2 on (zr2.kadaster_identif = bd2.tabel_identificatie)


  left join nat_prs np2 on (np2.SC_IDENTIF = zr2.FK_8PES_SC_IDENTIF)
  left join ingeschr_nat_prs inp2 on (inp2.SC_IDENTIF = np2.SC_IDENTIF)
  left join niet_nat_prs nnp2 on (nnp2.sc_identif = zr2.FK_8PES_SC_IDENTIF)
  left join ingeschr_niet_nat_prs innp2 on (innp2.sc_identif = nnp2.sc_identif)

join app_re ar on (ar.SC_KAD_IDENTIF = zr2.FK_7KOZ_KAD_IDENTIF)
join niet_nat_prs ar_vve_nnp on (ar_vve_nnp.sc_identif = ar.FK_2NNP_SC_IDENTIF)
join INGESCHR_NIET_NAT_PRS ar_vve_innp on (ar_vve_innp.sc_identif = ar_vve_nnp.sc_identif)
where bd1.omschrijving like 'betrokkenBij%'
and zr2.FK_8PES_SC_IDENTIF is not null
order by kpe.SC_KAD_IDENTIF, kpe.straat, kpe.huisnummer, kpe.toevoeging, kpe.huisletter,  to_number(KA_APPARTEMENTSINDEX);

-- percelen plus appartementen op de percelen
CREATE OR REPLACE VIEW v_bd_app_re_and_kad_perceel
                                 AS
  SELECT CAST(ROWNUM AS INTEGER) AS objectid,
    qry.*
  FROM
    (SELECT p.sc_kad_identif AS kadaster_identificatie,
      'perceel'              AS type,
      p.ka_deelperceelnummer,
      '' AS ka_appartementsindex,
      p.ka_perceelnummer,
      p.ka_kad_gemeentecode,
      p.ka_sectie,
      p.begrenzing_perceel
    FROM kad_perceel p
    UNION ALL
    SELECT ar.sc_kad_identif AS kadaster_identificatie,
      'appartement'          AS type,
      ''                     AS ka_deelperceelnummer,
      ar.ka_appartementsindex,
      ar.ka_perceelnummer,
      ar.ka_kad_gemeentecode,
      ar.ka_sectie,
      kp.begrenzing_perceel
    FROM v_bd_app_re_all_kad_perceel v
    JOIN kad_perceel kp
    ON v.perceel_identif = kp.sc_kad_identif
    JOIN app_re ar
    ON v.app_re_identif = ar.sc_kad_identif
    ) qry ;

-- aankoopdatum uit brondocumenten
CREATE OR REPLACE VIEW
    V_AANKOOPDATUM
    (
        KADASTER_IDENTIFICATIE,
        AANKOOPDATUM
    ) AS
SELECT
    b.ref_id AS KADASTER_IDENTIFICATIE,
    b.datum  AS AANKOOPDATUM
FROM
    (
        SELECT
            ref_id ,
            datum ,
            row_number() over (partition BY ref_id ORDER BY datum DESC) AS rnk
        FROM
            brondocument
        WHERE
            omschrijving = 'Akte van Koop en Verkoop' ) b
WHERE
    b.rnk = 1;

-- Eigenarenkaart - percelen en appartementen met hun eigenaren
CREATE MATERIALIZED VIEW VM_KAD_EIGENARENKAART
    (
        OBJECTID,
        KADASTER_IDENTIFICATIE,
        TYPE,
        ZAKELIJK_RECHT_IDENTIFICATIE,
        AANDEEL_TELLER,
        AANDEEL_NOEMER,
        AARD_RECHT_AAND,
        ZAKELIJK_RECHT_OMSCHRIJVING,
        AANKOOPDATUM,
        SOORT_EIGENAAR,
        GESLACHTSNAAM,
        VOORVOEGSEL,
        VOORNAMEN,
        GESLACHT,
        PERCEEL_ZAK_RECHT_NAAM,
        PERSOON_IDENTIFICATIE,
        WOONADRES,
        GEBOORTEDATUM,
        GEBOORTEPLAATS,
        OVERLIJDENSDATUM,
        NAAM_NIET_NATUURLIJK_PERSOON,
        RECHTSVORM,
        STATUTAIRE_ZETEL,
        KVK_NUMMER,
        KA_APPARTEMENTSINDEX,
        KA_DEELPERCEELNUMMER,
        KA_PERCEELNUMMER,
        KA_KAD_GEMEENTECODE,
        KA_SECTIE,
        BEGRENZING_PERCEEL
    ) BUILD IMMEDIATE AS
SELECT
    CAST(ROWNUM AS INTEGER) AS objectid,
    p.kadaster_identificatie    AS kadaster_identificatie,
    p.type,
    zr.kadaster_identif AS zakelijk_recht_identificatie,
    zr.ar_teller        AS aandeel_teller,
    zr.ar_noemer        AS aandeel_noemer,
    zr.fk_3avr_aand     AS aard_recht_aand,
    ark.omschr          AS zakelijk_recht_omschrijving,
    b.aankoopdatum,
    CASE
        WHEN np.sc_identif IS NOT NULL
        THEN 'Natuurlijk persoon'
        WHEN nnp.sc_identif IS NOT NULL
        THEN 'Niet natuurlijk persoon'
        ELSE 'Onbekend'
    END                             AS soort_eigenaar,
    np.nm_geslachtsnaam             AS geslachtsnaam,
    np.nm_voorvoegsel_geslachtsnaam AS voorvoegsel,
    np.nm_voornamen                 AS voornamen,
    np.geslachtsaand                AS geslacht,
    CASE
        WHEN np.sc_identif IS NOT NULL
        THEN np.NM_GESLACHTSNAAM || ', ' || np.NM_VOORNAMEN || ' ' ||
            np.NM_VOORVOEGSEL_GESLACHTSNAAM
        WHEN nnp.sc_identif IS NOT NULL
        THEN nnp.NAAM
        ELSE 'Onbekend'
    END                     AS perceel_zak_recht_naam,
    inp.sc_identif          AS persoon_identificatie,
    inp.va_loc_beschrijving AS woonadres,
    inp.gb_geboortedatum    AS geboortedatum,
    inp.gb_geboorteplaats   AS geboorteplaats,
    inp.ol_overlijdensdatum AS overlijdensdatum,
    nnp.naam                AS naam_niet_natuurlijk_persoon,
    innp.rechtsvorm,
    innp.statutaire_zetel,
    innp_subject.kvk_nummer,
    p.ka_appartementsindex,
    p.ka_deelperceelnummer,
    p.ka_perceelnummer,
    p.ka_kad_gemeentecode,
    p.ka_sectie,
    p.begrenzing_perceel
FROM
    v_bd_app_re_and_kad_perceel p
JOIN
    zak_recht zr
ON
    zr.fk_7koz_kad_identif = p.kadaster_identificatie
LEFT JOIN
    aard_recht_verkort ark
ON
    zr.fk_3avr_aand = ark.aand
LEFT JOIN
    aard_verkregen_recht ar
ON
    zr.fk_3avr_aand = ar.aand
LEFT JOIN
    nat_prs np
ON
    np.sc_identif = zr.fk_8pes_sc_identif
LEFT JOIN
    ingeschr_nat_prs inp
ON
    inp.sc_identif = np.sc_identif
LEFT JOIN
    niet_nat_prs nnp
ON
    nnp.sc_identif = zr.fk_8pes_sc_identif
LEFT JOIN
    ingeschr_niet_nat_prs innp
ON
    innp.sc_identif = nnp.sc_identif
LEFT JOIN
    subject innp_subject
ON
    innp_subject.identif = innp.sc_identif
LEFT JOIN
    v_aankoopdatum b
ON
    b.kadaster_identificatie = p.kadaster_identificatie
WHERE
    zr.kadaster_identif like 'NL.KAD.T%';

CREATE UNIQUE INDEX VM_KAD_EIGENARENKAART_OID_IDX ON VM_KAD_EIGENARENKAART (OBJECTID ASC);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('VM_KAD_EIGENARENKAART', 'BEGRENZING_PERCEEL', MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)), 28992);
CREATE INDEX VM_KAD_EIGENARENKAART_PERC_IDX ON VM_KAD_EIGENARENKAART (BEGRENZING_PERCEEL) INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ( 'LAYER_GTYPE=MULTIPOLYGON');
-- Script: 108_insert_aard_recht_verkort.sql

INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('1', 'Beklemrecht');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('2', 'Eigendom (recht van)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('3', 'Erfpacht (recht van)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('4', 'Gebruik en bewoning (recht van)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('5', 'Grondrente (recht van)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('6', 'Huurrecht (zakelijk)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('7', 'Opstal (recht van)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('8', 'Optierecht (zakelijk)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('9', 'Oud-vaderlandsrecht');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('10', 'Privaatrechtelijke belemmering (als bedoeld in artikel 5, lid 3, onder b)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('11', 'Stadsmeierrecht');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('12', 'Vruchtgebruik (recht van)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('13', 'Erfpacht en Opstal (recht van)');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('14', 'Opstalrecht Nutsvoorzieningen');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('15', 'Eigendom Telecommunicatienetwerk');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('16', 'Erfpachtrecht Telecommunicatienetwerk');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('17', 'Vruchtgebruik Telecommunicatienetwerk');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('18', 'Overige zakelijke rechten');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('19', 'Voorrecht');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('20', 'Zakelijk recht na twee of meer zakelijke belastingen');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('21', 'Zakelijke belasting derde of volgende');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('22', 'BP-recht');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('23', 'Opstalrecht Nutsvoorzieningen op gedeelte van perceel');
INSERT INTO aard_recht_verkort (aand, omschr) VALUES ('24', 'Zakelijk recht (als bedoeld in artikel 5, lid 3, onder b)');
-- Script: 109_insert_aard_verkregen_recht.sql

INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('1', 'Beklemrecht');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('2', 'Eigendom (recht van)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('3', 'Erfpacht (recht van)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('4', 'Gebruik en bewoning (recht van)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('5', 'Grondrente (recht van)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('6', 'Huurrecht (zakelijk)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('7', 'Opstal (recht van)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('8', 'Optierecht (zakelijk)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('9', 'Oud-vaderlandsrecht');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('10', 'Privaatrechtelijke belemmering (als bedoeld in artikel 5, lid 3, onder b, Belemmeringenwet Privaatrecht)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('11', 'Stadsmeierrecht');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('12', 'Vruchtgebruik (recht van)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('13', 'Erfpacht en Opstal (recht van)');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('14', 'Opstalrecht Nutsvoorzieningen');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('15', 'Eigendom Telecommunicatienetwerk');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('16', 'Erfpachtrecht Telecommunicatienetwerk');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('17', 'Vruchtgebruik Telecommunicatienetwerk');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('18', 'Overige zakelijke rechten');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('19', 'Voorrecht');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('20', 'Zakelijk recht na twee of meer zakelijke belastingen');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('21', 'Zakelijke belasting derde of volgende');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('22', 'BP-recht');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('23', 'Opstalrecht Nutsvoorzieningen op gedeelte van perceel');
INSERT INTO aard_verkregen_recht (aand, omschr_aard_verkregenr_recht) VALUES ('24', 'Zakelijk recht als bedoeld in artikel 5, lid 3, onder b, van de Belemmeringenwet Privaatrecht op gedeelte van perceel');
-- Script: 110_gebruiksdoel_primary_key.sql

ALTER TABLE gebouwd_obj_gebruiksdoel
  ADD CONSTRAINT pk_geb_obj_gebr_doel PRIMARY KEY (gebruiksdoel_gebouwd_obj, fk_gbo_sc_identif);
-- Script: 111_insert_gemeente.sql

INSERT INTO gemeente (code, naam) VALUES (1930, 'Nissewaard');
INSERT INTO gemeente (code, naam) VALUES (1931, 'Krimpenerwaard');
INSERT INTO gemeente (code, naam) VALUES (55, 'Boarnsterhim');
INSERT INTO gemeente (code, naam) VALUES (51, 'Skarsterlân');
INSERT INTO gemeente (code, naam) VALUES (15, 'Grootegast');
INSERT INTO gemeente (code, naam) VALUES (17, 'Haren');
INSERT INTO gemeente (code, naam) VALUES (22, 'Leek');
INSERT INTO gemeente (code, naam) VALUES (24, 'Loppersum');
INSERT INTO gemeente (code, naam) VALUES (1663, 'De Marne');
INSERT INTO gemeente (code, naam) VALUES (1895, 'Oldambt');
INSERT INTO gemeente (code, naam) VALUES (765, 'Pekela');
INSERT INTO gemeente (code, naam) VALUES (37, 'Stadskanaal');
INSERT INTO gemeente (code, naam) VALUES (56, 'Zuidhorn');
INSERT INTO gemeente (code, naam) VALUES (59, 'Achtkarspelen');
INSERT INTO gemeente (code, naam) VALUES (63, 'het Bildt');
INSERT INTO gemeente (code, naam) VALUES (58, 'Dongeradeel');
INSERT INTO gemeente (code, naam) VALUES (72, 'Harlingen');
INSERT INTO gemeente (code, naam) VALUES (80, 'Leeuwarden');
INSERT INTO gemeente (code, naam) VALUES (85, 'Ooststellingwerf');
INSERT INTO gemeente (code, naam) VALUES (86, 'Opsterland');
INSERT INTO gemeente (code, naam) VALUES (737, 'Tytsjerksteradiel');
INSERT INTO gemeente (code, naam) VALUES (98, 'Weststellingwerf');
INSERT INTO gemeente (code, naam) VALUES (114, 'Emmen');
INSERT INTO gemeente (code, naam) VALUES (118, 'Hoogeveen');
INSERT INTO gemeente (code, naam) VALUES (1730, 'Tynaarlo');
INSERT INTO gemeente (code, naam) VALUES (1701, 'Westerveld');
INSERT INTO gemeente (code, naam) VALUES (1690, 'De Wolden');
INSERT INTO gemeente (code, naam) VALUES (1774, 'Dinkelland');
INSERT INTO gemeente (code, naam) VALUES (153, 'Enschede');
INSERT INTO gemeente (code, naam) VALUES (164, 'Hengelo');
INSERT INTO gemeente (code, naam) VALUES (166, 'Kampen');
INSERT INTO gemeente (code, naam) VALUES (173, 'Oldenzaal');
INSERT INTO gemeente (code, naam) VALUES (175, 'Ommen');
INSERT INTO gemeente (code, naam) VALUES (177, 'Raalte');
INSERT INTO gemeente (code, naam) VALUES (180, 'Staphorst');
INSERT INTO gemeente (code, naam) VALUES (1708, 'Steenwijkerland');
INSERT INTO gemeente (code, naam) VALUES (1700, 'Twenterand');
INSERT INTO gemeente (code, naam) VALUES (1896, 'Zwartewaterland');
INSERT INTO gemeente (code, naam) VALUES (193, 'Zwolle');
INSERT INTO gemeente (code, naam) VALUES (184, 'Urk');
INSERT INTO gemeente (code, naam) VALUES (50, 'Zeewolde');
INSERT INTO gemeente (code, naam) VALUES (197, 'Aalten');
INSERT INTO gemeente (code, naam) VALUES (1859, 'Berkelland');
INSERT INTO gemeente (code, naam) VALUES (209, 'Beuningen');
INSERT INTO gemeente (code, naam) VALUES (221, 'Doesburg');
INSERT INTO gemeente (code, naam) VALUES (225, 'Druten');
INSERT INTO gemeente (code, naam) VALUES (230, 'Elburg');
INSERT INTO gemeente (code, naam) VALUES (241, 'Groesbeek');
INSERT INTO gemeente (code, naam) VALUES (243, 'Harderwijk');
INSERT INTO gemeente (code, naam) VALUES (244, 'Hattem');
INSERT INTO gemeente (code, naam) VALUES (304, 'Neerijnen');
INSERT INTO gemeente (code, naam) VALUES (267, 'Nijkerk');
INSERT INTO gemeente (code, naam) VALUES (268, 'Nijmegen');
INSERT INTO gemeente (code, naam) VALUES (1509, 'Oude IJsselstreek');
INSERT INTO gemeente (code, naam) VALUES (273, 'Putten');
INSERT INTO gemeente (code, naam) VALUES (281, 'Tiel');
INSERT INTO gemeente (code, naam) VALUES (285, 'Voorst');
INSERT INTO gemeente (code, naam) VALUES (293, 'Westervoort');
INSERT INTO gemeente (code, naam) VALUES (296, 'Wijchen');
INSERT INTO gemeente (code, naam) VALUES (297, 'Zaltbommel');
INSERT INTO gemeente (code, naam) VALUES (301, 'Zutphen');
INSERT INTO gemeente (code, naam) VALUES (307, 'Amersfoort');
INSERT INTO gemeente (code, naam) VALUES (313, 'Bunschoten');
INSERT INTO gemeente (code, naam) VALUES (317, 'Eemnes');
INSERT INTO gemeente (code, naam) VALUES (321, 'Houten');
INSERT INTO gemeente (code, naam) VALUES (356, 'Nieuwegein');
INSERT INTO gemeente (code, naam) VALUES (530, 'Hellevoetsluis');
INSERT INTO gemeente (code, naam) VALUES (518, '''s-Gravenhage');
INSERT INTO gemeente (code, naam) VALUES (796, '''s-Hertogenbosch');
INSERT INTO gemeente (code, naam) VALUES (10, 'Delfzijl');
INSERT INTO gemeente (code, naam) VALUES (14, 'Groningen');
INSERT INTO gemeente (code, naam) VALUES (1987, 'Menterwolde');
INSERT INTO gemeente (code, naam) VALUES (47, 'Veendam');
INSERT INTO gemeente (code, naam) VALUES (48, 'Vlagtwedde');
INSERT INTO gemeente (code, naam) VALUES (53, 'Winsum');
INSERT INTO gemeente (code, naam) VALUES (1921, 'De Friese Meren');
INSERT INTO gemeente (code, naam) VALUES (1722, 'Ferwerderadiel');
INSERT INTO gemeente (code, naam) VALUES (74, 'Heerenveen');
INSERT INTO gemeente (code, naam) VALUES (79, 'Kollumerland en Nieuwkruisland');
INSERT INTO gemeente (code, naam) VALUES (140, 'Littenseradiel');
INSERT INTO gemeente (code, naam) VALUES (1908, 'Menameradiel');
INSERT INTO gemeente (code, naam) VALUES (88, 'Schiermonnikoog');
INSERT INTO gemeente (code, naam) VALUES (90, 'Smallingerland');
INSERT INTO gemeente (code, naam) VALUES (1900, 'Súdwest-Fryslân');
INSERT INTO gemeente (code, naam) VALUES (96, 'Vlieland');
INSERT INTO gemeente (code, naam) VALUES (1680, 'Aa en Hunze');
INSERT INTO gemeente (code, naam) VALUES (106, 'Assen');
INSERT INTO gemeente (code, naam) VALUES (109, 'Coevorden');
INSERT INTO gemeente (code, naam) VALUES (119, 'Meppel');
INSERT INTO gemeente (code, naam) VALUES (1731, 'Midden-Drenthe');
INSERT INTO gemeente (code, naam) VALUES (1699, 'Noordenveld');
INSERT INTO gemeente (code, naam) VALUES (148, 'Dalfsen');
INSERT INTO gemeente (code, naam) VALUES (150, 'Deventer');
INSERT INTO gemeente (code, naam) VALUES (158, 'Haaksbergen');
INSERT INTO gemeente (code, naam) VALUES (160, 'Hardenberg');
INSERT INTO gemeente (code, naam) VALUES (163, 'Hellendoorn');
INSERT INTO gemeente (code, naam) VALUES (168, 'Losser');
INSERT INTO gemeente (code, naam) VALUES (1773, 'Olst-Wijhe');
INSERT INTO gemeente (code, naam) VALUES (189, 'Wierden');
INSERT INTO gemeente (code, naam) VALUES (303, 'Dronten');
INSERT INTO gemeente (code, naam) VALUES (995, 'Lelystad');
INSERT INTO gemeente (code, naam) VALUES (171, 'Noordoostpolder');
INSERT INTO gemeente (code, naam) VALUES (202, 'Arnhem');
INSERT INTO gemeente (code, naam) VALUES (1876, 'Bronckhorst');
INSERT INTO gemeente (code, naam) VALUES (214, 'Buren');
INSERT INTO gemeente (code, naam) VALUES (216, 'Culemborg');
INSERT INTO gemeente (code, naam) VALUES (222, 'Doetinchem');
INSERT INTO gemeente (code, naam) VALUES (226, 'Duiven');
INSERT INTO gemeente (code, naam) VALUES (228, 'Ede');
INSERT INTO gemeente (code, naam) VALUES (232, 'Epe');
INSERT INTO gemeente (code, naam) VALUES (236, 'Geldermalsen');
INSERT INTO gemeente (code, naam) VALUES (246, 'Heerde');
INSERT INTO gemeente (code, naam) VALUES (733, 'Lingewaal');
INSERT INTO gemeente (code, naam) VALUES (1705, 'Lingewaard');
INSERT INTO gemeente (code, naam) VALUES (262, 'Lochem');
INSERT INTO gemeente (code, naam) VALUES (1740, 'Neder-Betuwe');
INSERT INTO gemeente (code, naam) VALUES (269, 'Oldebroek');
INSERT INTO gemeente (code, naam) VALUES (1734, 'Overbetuwe');
INSERT INTO gemeente (code, naam) VALUES (275, 'Rheden');
INSERT INTO gemeente (code, naam) VALUES (277, 'Rozendaal');
INSERT INTO gemeente (code, naam) VALUES (279, 'Scherpenzeel');
INSERT INTO gemeente (code, naam) VALUES (299, 'Zevenaar');
INSERT INTO gemeente (code, naam) VALUES (310, 'De Bilt');
INSERT INTO gemeente (code, naam) VALUES (327, 'Leusden');
INSERT INTO gemeente (code, naam) VALUES (331, 'Lopik');
INSERT INTO gemeente (code, naam) VALUES (335, 'Montfoort');
INSERT INTO gemeente (code, naam) VALUES (340, 'Rhenen');
INSERT INTO gemeente (code, naam) VALUES (736, 'De Ronde Venen');
INSERT INTO gemeente (code, naam) VALUES (1581, 'Utrechtse Heuvelrug');
INSERT INTO gemeente (code, naam) VALUES (351, 'Woudenberg');
INSERT INTO gemeente (code, naam) VALUES (361, 'Alkmaar');
INSERT INTO gemeente (code, naam) VALUES (363, 'Amsterdam');
INSERT INTO gemeente (code, naam) VALUES (388, 'Enkhuizen');
INSERT INTO gemeente (code, naam) VALUES (396, 'Heemskerk');
INSERT INTO gemeente (code, naam) VALUES (402, 'Hilversum');
INSERT INTO gemeente (code, naam) VALUES (405, 'Hoorn');
INSERT INTO gemeente (code, naam) VALUES (415, 'Landsmeer');
INSERT INTO gemeente (code, naam) VALUES (420, 'Medemblik');
INSERT INTO gemeente (code, naam) VALUES (424, 'Muiden');
INSERT INTO gemeente (code, naam) VALUES (439, 'Purmerend');
INSERT INTO gemeente (code, naam) VALUES (532, 'Stede Broec');
INSERT INTO gemeente (code, naam) VALUES (450, 'Uitgeest');
INSERT INTO gemeente (code, naam) VALUES (457, 'Weesp');
INSERT INTO gemeente (code, naam) VALUES (1696, 'Wijdemeren');
INSERT INTO gemeente (code, naam) VALUES (880, 'Wormerland');
INSERT INTO gemeente (code, naam) VALUES (473, 'Zandvoort');
INSERT INTO gemeente (code, naam) VALUES (478, 'Zeevang');
INSERT INTO gemeente (code, naam) VALUES (489, 'Barendrecht');
INSERT INTO gemeente (code, naam) VALUES (1901, 'Bodegraven-Reeuwijk');
INSERT INTO gemeente (code, naam) VALUES (502, 'Capelle aan den IJssel');
INSERT INTO gemeente (code, naam) VALUES (855, 'Tilburg');
INSERT INTO gemeente (code, naam) VALUES (523, 'Hardinxveld-Giessendam');
INSERT INTO gemeente (code, naam) VALUES (798, 'Hilvarenbeek');
INSERT INTO gemeente (code, naam) VALUES (809, 'Loon op Zand');
INSERT INTO gemeente (code, naam) VALUES (826, 'Oosterhout');
INSERT INTO gemeente (code, naam) VALUES (828, 'Oss');
INSERT INTO gemeente (code, naam) VALUES (1674, 'Roosendaal');
INSERT INTO gemeente (code, naam) VALUES (846, 'Sint-Oedenrode');
INSERT INTO gemeente (code, naam) VALUES (263, 'Maasdriel');
INSERT INTO gemeente (code, naam) VALUES (302, 'Nunspeet');
INSERT INTO gemeente (code, naam) VALUES (1586, 'Oost Gelre');
INSERT INTO gemeente (code, naam) VALUES (274, 'Renkum');
INSERT INTO gemeente (code, naam) VALUES (196, 'Rijnwaarden');
INSERT INTO gemeente (code, naam) VALUES (289, 'Wageningen');
INSERT INTO gemeente (code, naam) VALUES (668, 'West Maas en Waal');
INSERT INTO gemeente (code, naam) VALUES (294, 'Winterswijk');
INSERT INTO gemeente (code, naam) VALUES (308, 'Baarn');
INSERT INTO gemeente (code, naam) VALUES (312, 'Bunnik');
INSERT INTO gemeente (code, naam) VALUES (353, 'IJsselstein');
INSERT INTO gemeente (code, naam) VALUES (589, 'Oudewater');
INSERT INTO gemeente (code, naam) VALUES (339, 'Renswoude');
INSERT INTO gemeente (code, naam) VALUES (342, 'Soest');
INSERT INTO gemeente (code, naam) VALUES (1904, 'Stichtse Vecht');
INSERT INTO gemeente (code, naam) VALUES (344, 'Utrecht');
INSERT INTO gemeente (code, naam) VALUES (345, 'Veenendaal');
INSERT INTO gemeente (code, naam) VALUES (620, 'Vianen');
INSERT INTO gemeente (code, naam) VALUES (352, 'Wijk bij Duurstede');
INSERT INTO gemeente (code, naam) VALUES (632, 'Woerden');
INSERT INTO gemeente (code, naam) VALUES (355, 'Zeist');
INSERT INTO gemeente (code, naam) VALUES (358, 'Aalsmeer');
INSERT INTO gemeente (code, naam) VALUES (362, 'Amstelveen');
INSERT INTO gemeente (code, naam) VALUES (370, 'Beemster');
INSERT INTO gemeente (code, naam) VALUES (373, 'Bergen (NH.)');
INSERT INTO gemeente (code, naam) VALUES (375, 'Beverwijk');
INSERT INTO gemeente (code, naam) VALUES (376, 'Blaricum');
INSERT INTO gemeente (code, naam) VALUES (377, 'Bloemendaal');
INSERT INTO gemeente (code, naam) VALUES (381, 'Bussum');
INSERT INTO gemeente (code, naam) VALUES (383, 'Castricum');
INSERT INTO gemeente (code, naam) VALUES (384, 'Diemen');
INSERT INTO gemeente (code, naam) VALUES (498, 'Drechterland');
INSERT INTO gemeente (code, naam) VALUES (385, 'Edam-Volendam');
INSERT INTO gemeente (code, naam) VALUES (392, 'Haarlem');
INSERT INTO gemeente (code, naam) VALUES (393, 'Haarlemmerliede en Spaarnwoude');
INSERT INTO gemeente (code, naam) VALUES (394, 'Haarlemmermeer');
INSERT INTO gemeente (code, naam) VALUES (397, 'Heemstede');
INSERT INTO gemeente (code, naam) VALUES (398, 'Heerhugowaard');
INSERT INTO gemeente (code, naam) VALUES (399, 'Heiloo');
INSERT INTO gemeente (code, naam) VALUES (400, 'Den Helder');
INSERT INTO gemeente (code, naam) VALUES (1911, 'Hollands Kroon');
INSERT INTO gemeente (code, naam) VALUES (406, 'Huizen');
INSERT INTO gemeente (code, naam) VALUES (1598, 'Koggenland');
INSERT INTO gemeente (code, naam) VALUES (416, 'Langedijk');
INSERT INTO gemeente (code, naam) VALUES (417, 'Laren');
INSERT INTO gemeente (code, naam) VALUES (425, 'Naarden');
INSERT INTO gemeente (code, naam) VALUES (431, 'Oostzaan');
INSERT INTO gemeente (code, naam) VALUES (432, 'Opmeer');
INSERT INTO gemeente (code, naam) VALUES (437, 'Ouder-Amstel');
INSERT INTO gemeente (code, naam) VALUES (441, 'Schagen');
INSERT INTO gemeente (code, naam) VALUES (448, 'Texel');
INSERT INTO gemeente (code, naam) VALUES (451, 'Uithoorn');
INSERT INTO gemeente (code, naam) VALUES (453, 'Velsen');
INSERT INTO gemeente (code, naam) VALUES (852, 'Waterland');
INSERT INTO gemeente (code, naam) VALUES (479, 'Zaanstad');
INSERT INTO gemeente (code, naam) VALUES (482, 'Alblasserdam');
INSERT INTO gemeente (code, naam) VALUES (613, 'Albrandswaard');
INSERT INTO gemeente (code, naam) VALUES (484, 'Alphen aan den Rijn');
INSERT INTO gemeente (code, naam) VALUES (585, 'Binnenmaas');
INSERT INTO gemeente (code, naam) VALUES (501, 'Brielle');
INSERT INTO gemeente (code, naam) VALUES (611, 'Cromstrijen');
INSERT INTO gemeente (code, naam) VALUES (503, 'Delft');
INSERT INTO gemeente (code, naam) VALUES (505, 'Dordrecht');
INSERT INTO gemeente (code, naam) VALUES (689, 'Giessenlanden');
INSERT INTO gemeente (code, naam) VALUES (1924, 'Goeree-Overflakkee');
INSERT INTO gemeente (code, naam) VALUES (512, 'Gorinchem');
INSERT INTO gemeente (code, naam) VALUES (513, 'Gouda');
INSERT INTO gemeente (code, naam) VALUES (531, 'Hendrik-Ido-Ambacht');
INSERT INTO gemeente (code, naam) VALUES (534, 'Hillegom');
INSERT INTO gemeente (code, naam) VALUES (5, 'Bedum');
INSERT INTO gemeente (code, naam) VALUES (9, 'Ten Boer');
INSERT INTO gemeente (code, naam) VALUES (18, 'Hoogezand-Sappemeer');
INSERT INTO gemeente (code, naam) VALUES (25, 'Marum');
INSERT INTO gemeente (code, naam) VALUES (40, 'Slochteren');
INSERT INTO gemeente (code, naam) VALUES (60, 'Ameland');
INSERT INTO gemeente (code, naam) VALUES (1891, 'Dantumadiel');
INSERT INTO gemeente (code, naam) VALUES (70, 'Franekeradeel');
INSERT INTO gemeente (code, naam) VALUES (93, 'Terschelling');
INSERT INTO gemeente (code, naam) VALUES (1681, 'Borger-Odoorn');
INSERT INTO gemeente (code, naam) VALUES (141, 'Almelo');
INSERT INTO gemeente (code, naam) VALUES (147, 'Borne');
INSERT INTO gemeente (code, naam) VALUES (1735, 'Hof van Twente');
INSERT INTO gemeente (code, naam) VALUES (1742, 'Rijssen-Holten');
INSERT INTO gemeente (code, naam) VALUES (183, 'Tubbergen');
INSERT INTO gemeente (code, naam) VALUES (34, 'Almere');
INSERT INTO gemeente (code, naam) VALUES (200, 'Apeldoorn');
INSERT INTO gemeente (code, naam) VALUES (203, 'Barneveld');
INSERT INTO gemeente (code, naam) VALUES (213, 'Brummen');
INSERT INTO gemeente (code, naam) VALUES (233, 'Ermelo');
INSERT INTO gemeente (code, naam) VALUES (252, 'Heumen');
INSERT INTO gemeente (code, naam) VALUES (1884, 'Kaag en Braassem');
INSERT INTO gemeente (code, naam) VALUES (537, 'Katwijk');
INSERT INTO gemeente (code, naam) VALUES (588, 'Korendijk');
INSERT INTO gemeente (code, naam) VALUES (542, 'Krimpen aan den IJssel');
INSERT INTO gemeente (code, naam) VALUES (1621, 'Lansingerland');
INSERT INTO gemeente (code, naam) VALUES (545, 'Leerdam');
INSERT INTO gemeente (code, naam) VALUES (546, 'Leiden');
INSERT INTO gemeente (code, naam) VALUES (547, 'Leiderdorp');
INSERT INTO gemeente (code, naam) VALUES (1916, 'Leidschendam-Voorburg');
INSERT INTO gemeente (code, naam) VALUES (797, 'Heusden');
INSERT INTO gemeente (code, naam) VALUES (1659, 'Laarbeek');
INSERT INTO gemeente (code, naam) VALUES (1685, 'Landerd');
INSERT INTO gemeente (code, naam) VALUES (1709, 'Moerdijk');
INSERT INTO gemeente (code, naam) VALUES (820, 'Nuenen, Gerwen en Nederwetten');
INSERT INTO gemeente (code, naam) VALUES (823, 'Oirschot');
INSERT INTO gemeente (code, naam) VALUES (824, 'Oisterwijk');
INSERT INTO gemeente (code, naam) VALUES (1667, 'Reusel-De Mierden');
INSERT INTO gemeente (code, naam) VALUES (840, 'Rucphen');
INSERT INTO gemeente (code, naam) VALUES (844, 'Schijndel');
INSERT INTO gemeente (code, naam) VALUES (1702, 'Sint Anthonis');
INSERT INTO gemeente (code, naam) VALUES (845, 'Sint-Michielsgestel');
INSERT INTO gemeente (code, naam) VALUES (847, 'Someren');
INSERT INTO gemeente (code, naam) VALUES (848, 'Son en Breugel');
INSERT INTO gemeente (code, naam) VALUES (851, 'Steenbergen');
INSERT INTO gemeente (code, naam) VALUES (856, 'Uden');
INSERT INTO gemeente (code, naam) VALUES (860, 'Veghel');
INSERT INTO gemeente (code, naam) VALUES (861, 'Veldhoven');
INSERT INTO gemeente (code, naam) VALUES (865, 'Vught');
INSERT INTO gemeente (code, naam) VALUES (866, 'Waalre');
INSERT INTO gemeente (code, naam) VALUES (867, 'Waalwijk');
INSERT INTO gemeente (code, naam) VALUES (870, 'Werkendam');
INSERT INTO gemeente (code, naam) VALUES (3, 'Appingedam');
INSERT INTO gemeente (code, naam) VALUES (7, 'Bellingwedde');
INSERT INTO gemeente (code, naam) VALUES (1651, 'Eemsmond');
INSERT INTO gemeente (code, naam) VALUES (81, 'Leeuwarderadeel');
INSERT INTO gemeente (code, naam) VALUES (1955, 'Montferland');
INSERT INTO gemeente (code, naam) VALUES (553, 'Lisse');
INSERT INTO gemeente (code, naam) VALUES (556, 'Maassluis');
INSERT INTO gemeente (code, naam) VALUES (1842, 'Midden-Delfland');
INSERT INTO gemeente (code, naam) VALUES (1927, 'Molenwaard');
INSERT INTO gemeente (code, naam) VALUES (569, 'Nieuwkoop');
INSERT INTO gemeente (code, naam) VALUES (575, 'Noordwijk');
INSERT INTO gemeente (code, naam) VALUES (576, 'Noordwijkerhout');
INSERT INTO gemeente (code, naam) VALUES (579, 'Oegstgeest');
INSERT INTO gemeente (code, naam) VALUES (584, 'Oud-Beijerland');
INSERT INTO gemeente (code, naam) VALUES (590, 'Papendrecht');
INSERT INTO gemeente (code, naam) VALUES (1926, 'Pijnacker-Nootdorp');
INSERT INTO gemeente (code, naam) VALUES (597, 'Ridderkerk');
INSERT INTO gemeente (code, naam) VALUES (603, 'Rijswijk');
INSERT INTO gemeente (code, naam) VALUES (599, 'Rotterdam');
INSERT INTO gemeente (code, naam) VALUES (606, 'Schiedam');
INSERT INTO gemeente (code, naam) VALUES (610, 'Sliedrecht');
INSERT INTO gemeente (code, naam) VALUES (617, 'Strijen');
INSERT INTO gemeente (code, naam) VALUES (1525, 'Teylingen');
INSERT INTO gemeente (code, naam) VALUES (622, 'Vlaardingen');
INSERT INTO gemeente (code, naam) VALUES (626, 'Voorschoten');
INSERT INTO gemeente (code, naam) VALUES (627, 'Waddinxveen');
INSERT INTO gemeente (code, naam) VALUES (629, 'Wassenaar');
INSERT INTO gemeente (code, naam) VALUES (1783, 'Westland');
INSERT INTO gemeente (code, naam) VALUES (614, 'Westvoorne');
INSERT INTO gemeente (code, naam) VALUES (707, 'Zederik');
INSERT INTO gemeente (code, naam) VALUES (637, 'Zoetermeer');
INSERT INTO gemeente (code, naam) VALUES (638, 'Zoeterwoude');
INSERT INTO gemeente (code, naam) VALUES (1892, 'Zuidplas');
INSERT INTO gemeente (code, naam) VALUES (642, 'Zwijndrecht');
INSERT INTO gemeente (code, naam) VALUES (654, 'Borsele');
INSERT INTO gemeente (code, naam) VALUES (664, 'Goes');
INSERT INTO gemeente (code, naam) VALUES (677, 'Hulst');
INSERT INTO gemeente (code, naam) VALUES (678, 'Kapelle');
INSERT INTO gemeente (code, naam) VALUES (687, 'Middelburg');
INSERT INTO gemeente (code, naam) VALUES (1695, 'Noord-Beveland');
INSERT INTO gemeente (code, naam) VALUES (703, 'Reimerswaal');
INSERT INTO gemeente (code, naam) VALUES (1676, 'Schouwen-Duiveland');
INSERT INTO gemeente (code, naam) VALUES (1714, 'Sluis');
INSERT INTO gemeente (code, naam) VALUES (715, 'Terneuzen');
INSERT INTO gemeente (code, naam) VALUES (716, 'Tholen');
INSERT INTO gemeente (code, naam) VALUES (717, 'Veere');
INSERT INTO gemeente (code, naam) VALUES (718, 'Vlissingen');
INSERT INTO gemeente (code, naam) VALUES (738, 'Aalburg');
INSERT INTO gemeente (code, naam) VALUES (1723, 'Alphen-Chaam');
INSERT INTO gemeente (code, naam) VALUES (743, 'Asten');
INSERT INTO gemeente (code, naam) VALUES (744, 'Baarle-Nassau');
INSERT INTO gemeente (code, naam) VALUES (1724, 'Bergeijk');
INSERT INTO gemeente (code, naam) VALUES (748, 'Bergen op Zoom');
INSERT INTO gemeente (code, naam) VALUES (1721, 'Bernheze');
INSERT INTO gemeente (code, naam) VALUES (753, 'Best');
INSERT INTO gemeente (code, naam) VALUES (1728, 'Bladel');
INSERT INTO gemeente (code, naam) VALUES (755, 'Boekel');
INSERT INTO gemeente (code, naam) VALUES (756, 'Boxmeer');
INSERT INTO gemeente (code, naam) VALUES (757, 'Boxtel');
INSERT INTO gemeente (code, naam) VALUES (758, 'Breda');
INSERT INTO gemeente (code, naam) VALUES (1706, 'Cranendonck');
INSERT INTO gemeente (code, naam) VALUES (1684, 'Cuijk');
INSERT INTO gemeente (code, naam) VALUES (762, 'Deurne');
INSERT INTO gemeente (code, naam) VALUES (766, 'Dongen');
INSERT INTO gemeente (code, naam) VALUES (1719, 'Drimmelen');
INSERT INTO gemeente (code, naam) VALUES (770, 'Eersel');
INSERT INTO gemeente (code, naam) VALUES (772, 'Eindhoven');
INSERT INTO gemeente (code, naam) VALUES (777, 'Etten-Leur');
INSERT INTO gemeente (code, naam) VALUES (779, 'Geertruidenberg');
INSERT INTO gemeente (code, naam) VALUES (1771, 'Geldrop-Mierlo');
INSERT INTO gemeente (code, naam) VALUES (1652, 'Gemert-Bakel');
INSERT INTO gemeente (code, naam) VALUES (784, 'Gilze en Rijen');
INSERT INTO gemeente (code, naam) VALUES (785, 'Goirle');
INSERT INTO gemeente (code, naam) VALUES (786, 'Grave');
INSERT INTO gemeente (code, naam) VALUES (788, 'Haaren');
INSERT INTO gemeente (code, naam) VALUES (1655, 'Halderberge');
INSERT INTO gemeente (code, naam) VALUES (1658, 'Heeze-Leende');
INSERT INTO gemeente (code, naam) VALUES (794, 'Helmond');
INSERT INTO gemeente (code, naam) VALUES (815, 'Mill en Sint Hubert');
INSERT INTO gemeente (code, naam) VALUES (858, 'Valkenswaard');
INSERT INTO gemeente (code, naam) VALUES (873, 'Woensdrecht');
INSERT INTO gemeente (code, naam) VALUES (874, 'Woudrichem');
INSERT INTO gemeente (code, naam) VALUES (879, 'Zundert');
INSERT INTO gemeente (code, naam) VALUES (888, 'Beek');
INSERT INTO gemeente (code, naam) VALUES (889, 'Beesel');
INSERT INTO gemeente (code, naam) VALUES (893, 'Bergen (L.)');
INSERT INTO gemeente (code, naam) VALUES (899, 'Brunssum');
INSERT INTO gemeente (code, naam) VALUES (1711, 'Echt-Susteren');
INSERT INTO gemeente (code, naam) VALUES (1903, 'Eijsden-Margraten');
INSERT INTO gemeente (code, naam) VALUES (907, 'Gennep');
INSERT INTO gemeente (code, naam) VALUES (1729, 'Gulpen-Wittem');
INSERT INTO gemeente (code, naam) VALUES (917, 'Heerlen');
INSERT INTO gemeente (code, naam) VALUES (1507, 'Horst aan de Maas');
INSERT INTO gemeente (code, naam) VALUES (928, 'Kerkrade');
INSERT INTO gemeente (code, naam) VALUES (882, 'Landgraaf');
INSERT INTO gemeente (code, naam) VALUES (1640, 'Leudal');
INSERT INTO gemeente (code, naam) VALUES (1641, 'Maasgouw');
INSERT INTO gemeente (code, naam) VALUES (935, 'Maastricht');
INSERT INTO gemeente (code, naam) VALUES (938, 'Meerssen');
INSERT INTO gemeente (code, naam) VALUES (944, 'Mook en Middelaar');
INSERT INTO gemeente (code, naam) VALUES (946, 'Nederweert');
INSERT INTO gemeente (code, naam) VALUES (951, 'Nuth');
INSERT INTO gemeente (code, naam) VALUES (881, 'Onderbanken');
INSERT INTO gemeente (code, naam) VALUES (1894, 'Peel en Maas');
INSERT INTO gemeente (code, naam) VALUES (1669, 'Roerdalen');
INSERT INTO gemeente (code, naam) VALUES (957, 'Roermond');
INSERT INTO gemeente (code, naam) VALUES (962, 'Schinnen');
INSERT INTO gemeente (code, naam) VALUES (965, 'Simpelveld');
INSERT INTO gemeente (code, naam) VALUES (1883, 'Sittard-Geleen');
INSERT INTO gemeente (code, naam) VALUES (971, 'Stein');
INSERT INTO gemeente (code, naam) VALUES (981, 'Vaals');
INSERT INTO gemeente (code, naam) VALUES (994, 'Valkenburg aan de Geul');
INSERT INTO gemeente (code, naam) VALUES (983, 'Venlo');
INSERT INTO gemeente (code, naam) VALUES (984, 'Venray');
INSERT INTO gemeente (code, naam) VALUES (986, 'Voerendaal');
INSERT INTO gemeente (code, naam) VALUES (988, 'Weert');
-- Script: 112_insert_buurt.sql

--ALTER TABLE buurt ALTER COLUMN code TYPE NUMERIC(8,0);
--ALTER TABLE buurt ALTER COLUMN naam TYPE CHARACTER VARYING(80);
INSERT INTO buurt (code, naam) VALUES (30000, 'Appingedam-Centrum');
INSERT INTO buurt (code, naam) VALUES (30001, 'Appingedam-West');
INSERT INTO buurt (code, naam) VALUES (30002, 'Appingedam-Oost');
INSERT INTO buurt (code, naam) VALUES (30007, 'Verspreide huizen Damsterdiep en Eemskanaal');
INSERT INTO buurt (code, naam) VALUES (30008, 'Verspreide huizen ten zuiden van Eemskanaal');
INSERT INTO buurt (code, naam) VALUES (30009, 'Verspreide huizen ten noorden van het Damsterdiep');
INSERT INTO buurt (code, naam) VALUES (50000, 'Bedum');
INSERT INTO buurt (code, naam) VALUES (50001, 'Verspreide huizen Bedum');
INSERT INTO buurt (code, naam) VALUES (50002, 'Zuidwolde');
INSERT INTO buurt (code, naam) VALUES (50003, 'Verspreide huizen Zuidwolde');
INSERT INTO buurt (code, naam) VALUES (50004, 'Onderdendam');
INSERT INTO buurt (code, naam) VALUES (50005, 'Verspreide huizen Onderdendam');
INSERT INTO buurt (code, naam) VALUES (50006, 'Noordwolde');
INSERT INTO buurt (code, naam) VALUES (50007, 'Verspreide huizen Noordwolde');
INSERT INTO buurt (code, naam) VALUES (70000, 'Bellingwolde');
INSERT INTO buurt (code, naam) VALUES (70001, 'Vriescheloo');
INSERT INTO buurt (code, naam) VALUES (70002, 'Rhederweg-West');
INSERT INTO buurt (code, naam) VALUES (70004, 'Vriescheloo-Zuid');
INSERT INTO buurt (code, naam) VALUES (70005, 'Oudeschans');
INSERT INTO buurt (code, naam) VALUES (70006, 'Klein-Ulsda');
INSERT INTO buurt (code, naam) VALUES (70007, 'Verspreide huizen ten zuidoosten van Bellingwolde');
INSERT INTO buurt (code, naam) VALUES (70008, 'Verspreide huizen ten zuidoosten van Vriescheloo');
INSERT INTO buurt (code, naam) VALUES (70009, 'Verspreide huizen Westerwoldse A');
INSERT INTO buurt (code, naam) VALUES (70100, 'Veelerveen');
INSERT INTO buurt (code, naam) VALUES (70101, 'Rhederbrug-Oost');
INSERT INTO buurt (code, naam) VALUES (70108, 'Verspreide huizen ten noordoosten van Rhederbrug');
INSERT INTO buurt (code, naam) VALUES (70109, 'Verspreide huizen Veelerveen');
INSERT INTO buurt (code, naam) VALUES (70200, 'Blijham');
INSERT INTO buurt (code, naam) VALUES (70201, 'Morige');
INSERT INTO buurt (code, naam) VALUES (70202, 'Wedde');
INSERT INTO buurt (code, naam) VALUES (70203, 'Wedderheide');
INSERT INTO buurt (code, naam) VALUES (70204, 'Wedderveer');
INSERT INTO buurt (code, naam) VALUES (70206, 'Verspreide huizen in de polder Blijham');
INSERT INTO buurt (code, naam) VALUES (70207, 'Verspreide huizen ten westen van Blijham');
INSERT INTO buurt (code, naam) VALUES (70208, 'Verspreide huizen Hoorn');
INSERT INTO buurt (code, naam) VALUES (70209, 'Verspreide huizen in de Weddermarke');
INSERT INTO buurt (code, naam) VALUES (90000, 'Ten Boer');
INSERT INTO buurt (code, naam) VALUES (90001, 'Garmerwolde');
INSERT INTO buurt (code, naam) VALUES (90002, 'Thesinge');
INSERT INTO buurt (code, naam) VALUES (90003, 'Sint-Annen');
INSERT INTO buurt (code, naam) VALUES (90005, 'Achter-Thesinge en Bovenrijge');
INSERT INTO buurt (code, naam) VALUES (90009, 'Verspreide huizen ten noorden van het Eemskanaal');
INSERT INTO buurt (code, naam) VALUES (90100, 'Ten Post');
INSERT INTO buurt (code, naam) VALUES (90101, 'Winneweer (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (90102, 'Woltersum');
INSERT INTO buurt (code, naam) VALUES (90104, 'Wittewierum');
INSERT INTO buurt (code, naam) VALUES (90106, 'Lellens');
INSERT INTO buurt (code, naam) VALUES (90109, 'Verspreide huizen ten noorden van het Eemskanaal');
INSERT INTO buurt (code, naam) VALUES (100000, 'Delfzijl-Centrum');
INSERT INTO buurt (code, naam) VALUES (100001, 'Farmsum');
INSERT INTO buurt (code, naam) VALUES (100002, 'Delfzijl-Noord');
INSERT INTO buurt (code, naam) VALUES (100003, 'Delfzijl-West');
INSERT INTO buurt (code, naam) VALUES (100004, 'Fivelzigt');
INSERT INTO buurt (code, naam) VALUES (100005, 'Tuikwerd');
INSERT INTO buurt (code, naam) VALUES (100103, 'Meedhuizen');
INSERT INTO buurt (code, naam) VALUES (100104, 'Uitwierde');
INSERT INTO buurt (code, naam) VALUES (100107, 'Verspreide huizen Eemskanaal (ten zuiden)');
INSERT INTO buurt (code, naam) VALUES (100108, 'Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (100109, 'Verspreide huizen in het noorden');
INSERT INTO buurt (code, naam) VALUES (100200, 'Woldendorp');
INSERT INTO buurt (code, naam) VALUES (100201, 'Termunten');
INSERT INTO buurt (code, naam) VALUES (100202, 'Termunterzijl');
INSERT INTO buurt (code, naam) VALUES (100203, 'Borgsweer');
INSERT INTO buurt (code, naam) VALUES (100205, 'Wagenborgen');
INSERT INTO buurt (code, naam) VALUES (100207, 'Verspreide huizen Wagenborgen');
INSERT INTO buurt (code, naam) VALUES (100209, 'Verspreide huizen Termunten');
INSERT INTO buurt (code, naam) VALUES (100300, 'Bierum');
INSERT INTO buurt (code, naam) VALUES (100301, 'Spijk');
INSERT INTO buurt (code, naam) VALUES (100302, 'Holwierde');
INSERT INTO buurt (code, naam) VALUES (100303, 'Godlinze');
INSERT INTO buurt (code, naam) VALUES (100304, 'Losdorp');
INSERT INTO buurt (code, naam) VALUES (100305, 'Krewerd');
INSERT INTO buurt (code, naam) VALUES (100309, 'Verspreide huizen Bierum');
INSERT INTO buurt (code, naam) VALUES (109998, '');
INSERT INTO buurt (code, naam) VALUES (140000, 'Stadscentrum');
INSERT INTO buurt (code, naam) VALUES (140001, 'Binnenstad-Zuid');
INSERT INTO buurt (code, naam) VALUES (140002, 'Binnenstad-Oost');
INSERT INTO buurt (code, naam) VALUES (140003, 'Binnenstad-West');
INSERT INTO buurt (code, naam) VALUES (140004, 'Binnenstad-Noord');
INSERT INTO buurt (code, naam) VALUES (140100, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (140101, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (140102, 'Friesestraatweg');
INSERT INTO buurt (code, naam) VALUES (140103, 'Kostverloren');
INSERT INTO buurt (code, naam) VALUES (140104, 'Vinkhuizen-Zuid');
INSERT INTO buurt (code, naam) VALUES (140105, 'Vinkhuizen-Noord');
INSERT INTO buurt (code, naam) VALUES (140106, 'Hoendiep');
INSERT INTO buurt (code, naam) VALUES (140200, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (140201, 'Concordiabuurt');
INSERT INTO buurt (code, naam) VALUES (140202, 'Selwerd');
INSERT INTO buurt (code, naam) VALUES (140203, 'Paddepoel-Zuid');
INSERT INTO buurt (code, naam) VALUES (140204, 'Paddepoel-Noord');
INSERT INTO buurt (code, naam) VALUES (140205, 'Noorderhoogebrug');
INSERT INTO buurt (code, naam) VALUES (140206, 'Universiteitscomplex');
INSERT INTO buurt (code, naam) VALUES (140207, 'Koningslaagte');
INSERT INTO buurt (code, naam) VALUES (140300, 'West-Indische buurt');
INSERT INTO buurt (code, naam) VALUES (140301, 'De Hoogte');
INSERT INTO buurt (code, naam) VALUES (140302, 'Oost-Indische buurt');
INSERT INTO buurt (code, naam) VALUES (140303, 'Korrewegbuurt');
INSERT INTO buurt (code, naam) VALUES (140400, 'Gorechtbuurt');
INSERT INTO buurt (code, naam) VALUES (140401, 'Oosterparkbuurt');
INSERT INTO buurt (code, naam) VALUES (140402, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (140403, 'Florabuurt');
INSERT INTO buurt (code, naam) VALUES (140404, 'Damsterbuurt');
INSERT INTO buurt (code, naam) VALUES (140500, 'Oosterpoortbuurt');
INSERT INTO buurt (code, naam) VALUES (140501, 'Industriebuurt');
INSERT INTO buurt (code, naam) VALUES (140502, 'Euvelgunne');
INSERT INTO buurt (code, naam) VALUES (140503, 'Middelbert');
INSERT INTO buurt (code, naam) VALUES (140504, 'Engelbert');
INSERT INTO buurt (code, naam) VALUES (140505, 'Roodehaan');
INSERT INTO buurt (code, naam) VALUES (140509, 'Woonschepenhaven');
INSERT INTO buurt (code, naam) VALUES (140600, 'Herewegbuurt');
INSERT INTO buurt (code, naam) VALUES (140601, 'Rivierenbuurt');
INSERT INTO buurt (code, naam) VALUES (140602, 'Helpman-West');
INSERT INTO buurt (code, naam) VALUES (140603, 'Villabuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (140604, 'Helpman-Oost');
INSERT INTO buurt (code, naam) VALUES (140605, 'Coendersborg');
INSERT INTO buurt (code, naam) VALUES (140606, 'De Wijert-Noord');
INSERT INTO buurt (code, naam) VALUES (140607, 'De Wijert-Zuid');
INSERT INTO buurt (code, naam) VALUES (140608, 'Villabuurt-West');
INSERT INTO buurt (code, naam) VALUES (140609, 'Woonwagenkamp');
INSERT INTO buurt (code, naam) VALUES (140700, 'Laanhuizen');
INSERT INTO buurt (code, naam) VALUES (140701, 'Grunobuurt');
INSERT INTO buurt (code, naam) VALUES (140702, 'Corpus Den Hoorn-Noord');
INSERT INTO buurt (code, naam) VALUES (140703, 'Corpus Den Hoorn-Zuid');
INSERT INTO buurt (code, naam) VALUES (140704, 'Stadspark');
INSERT INTO buurt (code, naam) VALUES (140705, 'Peizerweg');
INSERT INTO buurt (code, naam) VALUES (140709, 'Woonwagenkamp');
INSERT INTO buurt (code, naam) VALUES (140800, 'Hoogkerk-Dorp');
INSERT INTO buurt (code, naam) VALUES (140801, 'Hoogkerk-Zuid');
INSERT INTO buurt (code, naam) VALUES (140802, 'Vierverlaten');
INSERT INTO buurt (code, naam) VALUES (140803, 'Leegkerk');
INSERT INTO buurt (code, naam) VALUES (140804, 'Dorkwerd');
INSERT INTO buurt (code, naam) VALUES (140805, 'Bangeweer');
INSERT INTO buurt (code, naam) VALUES (140806, 'De Held');
INSERT INTO buurt (code, naam) VALUES (140807, 'Zuidwending');
INSERT INTO buurt (code, naam) VALUES (140900, 'Oosterhoogebrug');
INSERT INTO buurt (code, naam) VALUES (140901, 'Lewenborg-Zuid');
INSERT INTO buurt (code, naam) VALUES (140902, 'Lewenborg-Noord');
INSERT INTO buurt (code, naam) VALUES (140903, 'Lewenborg-West');
INSERT INTO buurt (code, naam) VALUES (140904, 'Bovenstreek');
INSERT INTO buurt (code, naam) VALUES (140905, 'Beijum-Oost');
INSERT INTO buurt (code, naam) VALUES (140906, 'Beijum-West');
INSERT INTO buurt (code, naam) VALUES (140907, 'Ulgersmabuurt');
INSERT INTO buurt (code, naam) VALUES (140908, 'Ruischerbrug');
INSERT INTO buurt (code, naam) VALUES (150000, 'Grootegast');
INSERT INTO buurt (code, naam) VALUES (150001, 'Doezum');
INSERT INTO buurt (code, naam) VALUES (150002, 'Sebaldeburen');
INSERT INTO buurt (code, naam) VALUES (150006, 'Het Peebos');
INSERT INTO buurt (code, naam) VALUES (150007, 'Verspreide huizen ten zuiden van Sebaldeburen');
INSERT INTO buurt (code, naam) VALUES (150008, 'Verspreide huizen ten zuiden van Grootegast');
INSERT INTO buurt (code, naam) VALUES (150009, 'Overige verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (150100, 'Lutjegast');
INSERT INTO buurt (code, naam) VALUES (150109, 'Verspreide huizen Lutjegast');
INSERT INTO buurt (code, naam) VALUES (150200, 'Opende-West');
INSERT INTO buurt (code, naam) VALUES (150201, 'Opende-Oost');
INSERT INTO buurt (code, naam) VALUES (150202, 'Kornhorn');
INSERT INTO buurt (code, naam) VALUES (150209, 'Verspreide huizen ten zuiden van Opende');
INSERT INTO buurt (code, naam) VALUES (150300, 'Niekerk');
INSERT INTO buurt (code, naam) VALUES (150301, 'Oldekerk');
INSERT INTO buurt (code, naam) VALUES (150309, 'Verspreide huizen Oldekerk');
INSERT INTO buurt (code, naam) VALUES (170000, 'Haren');
INSERT INTO buurt (code, naam) VALUES (170001, 'Oosterhaar');
INSERT INTO buurt (code, naam) VALUES (170002, 'Voorveld');
INSERT INTO buurt (code, naam) VALUES (170003, 'Harenermolen');
INSERT INTO buurt (code, naam) VALUES (170004, 'Glimmen');
INSERT INTO buurt (code, naam) VALUES (170005, 'Hemmen');
INSERT INTO buurt (code, naam) VALUES (170100, 'Noordlaren');
INSERT INTO buurt (code, naam) VALUES (170101, 'Onnen');
INSERT INTO buurt (code, naam) VALUES (170102, 'Paterswolde (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (170103, 'Essen');
INSERT INTO buurt (code, naam) VALUES (170106, 'Verspreide huizen ten westen van Noord-Willemskanaal');
INSERT INTO buurt (code, naam) VALUES (170107, 'Verspreide huizen op de Hondsrug');
INSERT INTO buurt (code, naam) VALUES (170108, 'Verspreide huizen Onner Esch');
INSERT INTO buurt (code, naam) VALUES (170109, 'Verspreide huizen ten oosten van de Hondsrug');
INSERT INTO buurt (code, naam) VALUES (180101, 'Noorderpark');
INSERT INTO buurt (code, naam) VALUES (180102, 'Westerpark');
INSERT INTO buurt (code, naam) VALUES (180103, 'Beukemabuurt');
INSERT INTO buurt (code, naam) VALUES (180104, 'Oosterpark');
INSERT INTO buurt (code, naam) VALUES (180105, 'Martenshoek');
INSERT INTO buurt (code, naam) VALUES (180106, 'Industriegebied Martenshoek');
INSERT INTO buurt (code, naam) VALUES (180107, 'Stadshart-Noord');
INSERT INTO buurt (code, naam) VALUES (180201, 'Spoorstraat en Kieldiep');
INSERT INTO buurt (code, naam) VALUES (180202, 'Burgemeester van Royenstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (180203, 'Gorecht-Noord');
INSERT INTO buurt (code, naam) VALUES (180204, 'Gorechtpark');
INSERT INTO buurt (code, naam) VALUES (180205, 'Gorecht-West');
INSERT INTO buurt (code, naam) VALUES (180206, 'Woldwijck-West');
INSERT INTO buurt (code, naam) VALUES (180207, 'Woldwijck-Midden');
INSERT INTO buurt (code, naam) VALUES (180208, 'Woldwijck-Oost');
INSERT INTO buurt (code, naam) VALUES (180209, 'Kropswolderpolder');
INSERT INTO buurt (code, naam) VALUES (180210, 'Gorechtpark-Oost');
INSERT INTO buurt (code, naam) VALUES (180301, 'Stadshart-Zuid');
INSERT INTO buurt (code, naam) VALUES (180302, 'Zuiderpark');
INSERT INTO buurt (code, naam) VALUES (180303, 'De Dreven');
INSERT INTO buurt (code, naam) VALUES (180304, 'De Vosholen-West');
INSERT INTO buurt (code, naam) VALUES (180305, 'Kalkwijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (180306, 'Kalkwijk-Noord');
INSERT INTO buurt (code, naam) VALUES (180501, 'Kiel-Windeweer');
INSERT INTO buurt (code, naam) VALUES (180502, 'Kiel-Windeweer Buiten');
INSERT INTO buurt (code, naam) VALUES (180601, 'Recreatiegebied Meerwijck');
INSERT INTO buurt (code, naam) VALUES (180602, 'Polder Kropswolde');
INSERT INTO buurt (code, naam) VALUES (180603, 'Meerwijck');
INSERT INTO buurt (code, naam) VALUES (180604, 'Polder Wolfsbarge');
INSERT INTO buurt (code, naam) VALUES (180605, 'Kropswolderbuitenpolder');
INSERT INTO buurt (code, naam) VALUES (180606, 'Kropswolde');
INSERT INTO buurt (code, naam) VALUES (180701, 'Foxhol');
INSERT INTO buurt (code, naam) VALUES (180702, 'Foxholsterbosch');
INSERT INTO buurt (code, naam) VALUES (180801, 'Westerbroekstermolenpolder');
INSERT INTO buurt (code, naam) VALUES (180802, 'Westerbroekstermadepolder');
INSERT INTO buurt (code, naam) VALUES (180803, 'Industriegebied Winschoterdiep');
INSERT INTO buurt (code, naam) VALUES (180804, 'Westerbroek');
INSERT INTO buurt (code, naam) VALUES (180901, 'Waterhuizen');
INSERT INTO buurt (code, naam) VALUES (181101, 'Magrietpark');
INSERT INTO buurt (code, naam) VALUES (181102, 'Sappemeer-Oost');
INSERT INTO buurt (code, naam) VALUES (181103, 'Boswijck-West');
INSERT INTO buurt (code, naam) VALUES (181104, 'Boswijck-Oost');
INSERT INTO buurt (code, naam) VALUES (181105, 'Compagniesterpark');
INSERT INTO buurt (code, naam) VALUES (181106, 'De Vosholen-Oost');
INSERT INTO buurt (code, naam) VALUES (181107, 'Nieuw Woelwijck');
INSERT INTO buurt (code, naam) VALUES (181108, 'Polder De Nijverheid');
INSERT INTO buurt (code, naam) VALUES (181109, 'Sappemeer-Noord');
INSERT INTO buurt (code, naam) VALUES (220001, 'Diepswal');
INSERT INTO buurt (code, naam) VALUES (220002, 'Centrum Leek en omgeving');
INSERT INTO buurt (code, naam) VALUES (220003, 'Rodenburg en omgeving');
INSERT INTO buurt (code, naam) VALUES (220004, 'Nienoordsrand');
INSERT INTO buurt (code, naam) VALUES (220008, 'Buitengebied ten oosten van Leek');
INSERT INTO buurt (code, naam) VALUES (220009, 'Buitengebied ten zuiden van Leek');
INSERT INTO buurt (code, naam) VALUES (220100, 'Bebouwde kom Zevenhuizen');
INSERT INTO buurt (code, naam) VALUES (220101, 'De Haspel');
INSERT INTO buurt (code, naam) VALUES (220102, 'Drostinnewijk');
INSERT INTO buurt (code, naam) VALUES (220103, 'Boerenstreek');
INSERT INTO buurt (code, naam) VALUES (220107, 'Buitengebied ten noorden van Zevenhuizen');
INSERT INTO buurt (code, naam) VALUES (220108, 'Buitengebied ten oosten van Zevenhuizen');
INSERT INTO buurt (code, naam) VALUES (220109, 'Buitengebied ten westen van Zevenhuizen');
INSERT INTO buurt (code, naam) VALUES (220200, 'Bebouwde kom Tolbert');
INSERT INTO buurt (code, naam) VALUES (220201, 'Sint Maheerdt');
INSERT INTO buurt (code, naam) VALUES (220209, 'Buitengebied Tolbert');
INSERT INTO buurt (code, naam) VALUES (220400, 'Bebouwde kom Midwolde');
INSERT INTO buurt (code, naam) VALUES (220401, 'Pasop');
INSERT INTO buurt (code, naam) VALUES (220409, 'Buitengebied Midwolde');
INSERT INTO buurt (code, naam) VALUES (220500, 'Bebouwde kom Lettelbert');
INSERT INTO buurt (code, naam) VALUES (220509, 'Buitengebied Lettelbert');
INSERT INTO buurt (code, naam) VALUES (220600, 'Bebouwde kom Oostwold');
INSERT INTO buurt (code, naam) VALUES (220609, 'Buitengebied-Oostwold');
INSERT INTO buurt (code, naam) VALUES (220700, 'Bebouwde kom Enumatil');
INSERT INTO buurt (code, naam) VALUES (220709, 'Buitengebied Enumatil');
INSERT INTO buurt (code, naam) VALUES (240000, 'Loppersum');
INSERT INTO buurt (code, naam) VALUES (240001, 'Garrelsweer');
INSERT INTO buurt (code, naam) VALUES (240002, 'Wirdum');
INSERT INTO buurt (code, naam) VALUES (240003, 'Wirdumerdraai');
INSERT INTO buurt (code, naam) VALUES (240005, 'Winneweer (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (240008, 'Verspreide huizen Eemskanaal en Damsterdiep');
INSERT INTO buurt (code, naam) VALUES (240009, 'Verspreide huizen ten noorden van het Damsterdiep');
INSERT INTO buurt (code, naam) VALUES (240100, 'Stedum');
INSERT INTO buurt (code, naam) VALUES (240101, 'Westeremden');
INSERT INTO buurt (code, naam) VALUES (240102, 'Garsthuizen (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (240109, 'Verspreide huizen Stedum inclusief Startenhuizen');
INSERT INTO buurt (code, naam) VALUES (240200, 'Middelstum');
INSERT INTO buurt (code, naam) VALUES (240201, 'Westerwijtwerd');
INSERT INTO buurt (code, naam) VALUES (240202, 'Huizinge');
INSERT INTO buurt (code, naam) VALUES (240203, 'Toornwerd');
INSERT INTO buurt (code, naam) VALUES (240209, 'Verspreide huizen Middelstum');
INSERT INTO buurt (code, naam) VALUES (240300, '''t Zandt');
INSERT INTO buurt (code, naam) VALUES (240301, 'Zeerijp');
INSERT INTO buurt (code, naam) VALUES (240302, 'Zijldijk');
INSERT INTO buurt (code, naam) VALUES (240303, 'Leermens');
INSERT INTO buurt (code, naam) VALUES (240304, 'Oosterwijtwerd');
INSERT INTO buurt (code, naam) VALUES (240305, 'Eenum');
INSERT INTO buurt (code, naam) VALUES (240309, 'Verspreide huizen ''t Zandt');
INSERT INTO buurt (code, naam) VALUES (250000, 'Marum');
INSERT INTO buurt (code, naam) VALUES (250002, 'Nuis');
INSERT INTO buurt (code, naam) VALUES (250003, 'Niebert');
INSERT INTO buurt (code, naam) VALUES (250004, 'Boerakker');
INSERT INTO buurt (code, naam) VALUES (250005, 'Lucaswolde');
INSERT INTO buurt (code, naam) VALUES (250006, 'Noordwijk');
INSERT INTO buurt (code, naam) VALUES (250007, 'De Haar');
INSERT INTO buurt (code, naam) VALUES (250008, 'Verspreide huizen in het noordwesten');
INSERT INTO buurt (code, naam) VALUES (250009, 'Verspreide huizen in het noordoosten');
INSERT INTO buurt (code, naam) VALUES (250100, 'De Wilp (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (250101, 'Wilpstervaart');
INSERT INTO buurt (code, naam) VALUES (250102, 'Keuningswijk');
INSERT INTO buurt (code, naam) VALUES (250104, 'Jonkersvaart');
INSERT INTO buurt (code, naam) VALUES (250108, 'Verspreide huizen ten noorden van Jonkersvaart');
INSERT INTO buurt (code, naam) VALUES (250109, 'Verspreide huizen ten noorden van de Wilp');
INSERT INTO buurt (code, naam) VALUES (340101, 'Centrum Almere-Haven');
INSERT INTO buurt (code, naam) VALUES (340102, 'De Werven');
INSERT INTO buurt (code, naam) VALUES (340103, 'De Hoven');
INSERT INTO buurt (code, naam) VALUES (340104, 'De Meenten');
INSERT INTO buurt (code, naam) VALUES (340105, 'De Grienden');
INSERT INTO buurt (code, naam) VALUES (340106, 'De Marken');
INSERT INTO buurt (code, naam) VALUES (340107, 'De Gouwen');
INSERT INTO buurt (code, naam) VALUES (340108, 'De Wierden');
INSERT INTO buurt (code, naam) VALUES (340109, 'De Velden');
INSERT INTO buurt (code, naam) VALUES (340110, 'Overgooi');
INSERT INTO buurt (code, naam) VALUES (340171, 'De Steiger');
INSERT INTO buurt (code, naam) VALUES (340173, 'Stichtsekant');
INSERT INTO buurt (code, naam) VALUES (340199, 'Verspreide Huizen Almere-Haven');
INSERT INTO buurt (code, naam) VALUES (340201, 'Centrum Almere-Stad');
INSERT INTO buurt (code, naam) VALUES (340202, 'Filmwijk');
INSERT INTO buurt (code, naam) VALUES (340203, 'Danswijk');
INSERT INTO buurt (code, naam) VALUES (340204, 'Parkwijk');
INSERT INTO buurt (code, naam) VALUES (340205, 'Verzetswijk');
INSERT INTO buurt (code, naam) VALUES (340206, 'Waterwijk');
INSERT INTO buurt (code, naam) VALUES (340209, 'Staatsliedenwijk');
INSERT INTO buurt (code, naam) VALUES (340210, 'Kruidenwijk');
INSERT INTO buurt (code, naam) VALUES (340211, 'Stedenwijk');
INSERT INTO buurt (code, naam) VALUES (340214, 'Literatuurwijk');
INSERT INTO buurt (code, naam) VALUES (340215, 'Noorderplassen');
INSERT INTO buurt (code, naam) VALUES (340220, 'Tussen de Vaarten');
INSERT INTO buurt (code, naam) VALUES (340221, 'Muziekwijk');
INSERT INTO buurt (code, naam) VALUES (340271, 'Randstad');
INSERT INTO buurt (code, naam) VALUES (340272, 'Markerkant');
INSERT INTO buurt (code, naam) VALUES (340273, 'Hollandsekant');
INSERT INTO buurt (code, naam) VALUES (340274, 'Gooisekant');
INSERT INTO buurt (code, naam) VALUES (340275, 'Veluwsekant');
INSERT INTO buurt (code, naam) VALUES (340276, 'Sallandsekant');
INSERT INTO buurt (code, naam) VALUES (340299, 'Verspreide huizen Almere-Stad');
INSERT INTO buurt (code, naam) VALUES (340301, 'Centrum Almere-Buiten');
INSERT INTO buurt (code, naam) VALUES (340302, 'Oostvaardersbuurt');
INSERT INTO buurt (code, naam) VALUES (340303, 'Seizoenenbuurt');
INSERT INTO buurt (code, naam) VALUES (340304, 'Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (340305, 'Bouwmeesterbuurt');
INSERT INTO buurt (code, naam) VALUES (340306, 'Landgoederenbuurt');
INSERT INTO buurt (code, naam) VALUES (340307, 'Faunabuurt');
INSERT INTO buurt (code, naam) VALUES (340308, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (340309, 'Regenboogbuurt');
INSERT INTO buurt (code, naam) VALUES (340310, 'Indischebuurt');
INSERT INTO buurt (code, naam) VALUES (340311, 'Eilandenbuurt');
INSERT INTO buurt (code, naam) VALUES (340312, 'Stripheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (340313, 'Sieradenbuurt');
INSERT INTO buurt (code, naam) VALUES (340371, 'Poldervlak');
INSERT INTO buurt (code, naam) VALUES (340372, 'De Vaart');
INSERT INTO buurt (code, naam) VALUES (340373, 'Buitenvaart');
INSERT INTO buurt (code, naam) VALUES (340399, 'Verspreide huizen Almere-Buiten');
INSERT INTO buurt (code, naam) VALUES (340402, 'Columbuskwartier');
INSERT INTO buurt (code, naam) VALUES (340403, 'Homeruskwartier');
INSERT INTO buurt (code, naam) VALUES (340405, 'Almeerderzand');
INSERT INTO buurt (code, naam) VALUES (340420, 'Europakwartier Oost');
INSERT INTO buurt (code, naam) VALUES (340421, 'Europakwartier West');
INSERT INTO buurt (code, naam) VALUES (340422, 'Olympiakwartier Oost');
INSERT INTO buurt (code, naam) VALUES (340423, 'Olympiakwartier West');
INSERT INTO buurt (code, naam) VALUES (340471, 'Hogekant');
INSERT INTO buurt (code, naam) VALUES (340472, 'Middenkant');
INSERT INTO buurt (code, naam) VALUES (340473, 'Lagekant');
INSERT INTO buurt (code, naam) VALUES (340499, 'Verspreide huizen Almere-Poort');
INSERT INTO buurt (code, naam) VALUES (340502, 'Vogelhorst');
INSERT INTO buurt (code, naam) VALUES (340503, 'Nobelhorst');
INSERT INTO buurt (code, naam) VALUES (340571, 'Twentsekant');
INSERT INTO buurt (code, naam) VALUES (340599, 'Verspreide huizen Almere-Hout');
INSERT INTO buurt (code, naam) VALUES (340699, 'Verspreide huizen Almere-Pampus');
INSERT INTO buurt (code, naam) VALUES (349997, '');
INSERT INTO buurt (code, naam) VALUES (370100, 'Stadskanaal Centrum');
INSERT INTO buurt (code, naam) VALUES (370101, 'Maarsstee');
INSERT INTO buurt (code, naam) VALUES (370102, 'Maarswold');
INSERT INTO buurt (code, naam) VALUES (370103, 'Maarsveld');
INSERT INTO buurt (code, naam) VALUES (370104, 'De Hagen');
INSERT INTO buurt (code, naam) VALUES (370105, 'Vogelwijk en de Borgen');
INSERT INTO buurt (code, naam) VALUES (370106, 'Industriegebied');
INSERT INTO buurt (code, naam) VALUES (370107, 'Dideldom');
INSERT INTO buurt (code, naam) VALUES (370108, 'Parkwijk');
INSERT INTO buurt (code, naam) VALUES (370109, 'Noord Landskant');
INSERT INTO buurt (code, naam) VALUES (370110, 'Centrum-Noord');
INSERT INTO buurt (code, naam) VALUES (370111, 'Noord');
INSERT INTO buurt (code, naam) VALUES (370112, 'Waterland');
INSERT INTO buurt (code, naam) VALUES (370200, 'Musselkanaal Centrum');
INSERT INTO buurt (code, naam) VALUES (370201, 'Zuid');
INSERT INTO buurt (code, naam) VALUES (370202, 'Noord');
INSERT INTO buurt (code, naam) VALUES (370203, 'Ceresdorp');
INSERT INTO buurt (code, naam) VALUES (370300, 'Onstwedde');
INSERT INTO buurt (code, naam) VALUES (370301, 'Holte');
INSERT INTO buurt (code, naam) VALUES (370308, 'Buitengebied-Noord');
INSERT INTO buurt (code, naam) VALUES (370309, 'Buitengebied-Zuid');
INSERT INTO buurt (code, naam) VALUES (370400, 'Mussel');
INSERT INTO buurt (code, naam) VALUES (370401, 'Kopstukken');
INSERT INTO buurt (code, naam) VALUES (370402, 'Vledderveen');
INSERT INTO buurt (code, naam) VALUES (370409, 'Verspreide huizen Mussel');
INSERT INTO buurt (code, naam) VALUES (370500, 'Alteveer');
INSERT INTO buurt (code, naam) VALUES (370509, 'Verspreide huizen Alteveer');
INSERT INTO buurt (code, naam) VALUES (400000, 'Slochteren');
INSERT INTO buurt (code, naam) VALUES (400001, 'Kolham');
INSERT INTO buurt (code, naam) VALUES (400002, '''s-Gravenschans en Ruiten');
INSERT INTO buurt (code, naam) VALUES (400003, 'Rengerslaan');
INSERT INTO buurt (code, naam) VALUES (400004, 'Knijpslaan');
INSERT INTO buurt (code, naam) VALUES (400006, 'Froombosch');
INSERT INTO buurt (code, naam) VALUES (400007, 'Verspreide huizen ten oosten van Slochteren');
INSERT INTO buurt (code, naam) VALUES (400008, 'Verspreide huizen ten zuiden van Kolham');
INSERT INTO buurt (code, naam) VALUES (400009, 'Verspreide huizen in de Hooilandspolder');
INSERT INTO buurt (code, naam) VALUES (400100, 'Schildwolde');
INSERT INTO buurt (code, naam) VALUES (400101, 'Hellum');
INSERT INTO buurt (code, naam) VALUES (400102, 'Meenteweg');
INSERT INTO buurt (code, naam) VALUES (400108, 'Verspreide huizen ten noorden van Het Siep');
INSERT INTO buurt (code, naam) VALUES (400109, 'Verspreide huizen in De Zanden');
INSERT INTO buurt (code, naam) VALUES (400200, 'Siddeburen');
INSERT INTO buurt (code, naam) VALUES (400201, 'Oudeweg en Hoofdweg en Oostwolderweg');
INSERT INTO buurt (code, naam) VALUES (400203, 'Steendam');
INSERT INTO buurt (code, naam) VALUES (400204, 'Tjuchem');
INSERT INTO buurt (code, naam) VALUES (400208, 'Verspreide huizen in het Siddebuursterveen');
INSERT INTO buurt (code, naam) VALUES (400209, 'Verspreide huizen ten noorden van Siddeburen');
INSERT INTO buurt (code, naam) VALUES (400300, 'Harkstede');
INSERT INTO buurt (code, naam) VALUES (400301, 'Scharmer');
INSERT INTO buurt (code, naam) VALUES (400302, 'Hamweg');
INSERT INTO buurt (code, naam) VALUES (400304, 'Borgweg (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (400308, 'Verspreide huizen ten oosten van Hamweg');
INSERT INTO buurt (code, naam) VALUES (400309, 'Verspreide huizen in het Westen');
INSERT INTO buurt (code, naam) VALUES (400400, 'Overschild');
INSERT INTO buurt (code, naam) VALUES (400409, 'Verspreide huizen Overschild');
INSERT INTO buurt (code, naam) VALUES (470000, 'Veendam-Centrum');
INSERT INTO buurt (code, naam) VALUES (470001, 'Veendam-Oude Ae');
INSERT INTO buurt (code, naam) VALUES (470002, 'Veendam-Middenweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (470003, 'Veendam en omgeving station');
INSERT INTO buurt (code, naam) VALUES (470004, 'Veendam-Zuid');
INSERT INTO buurt (code, naam) VALUES (470005, 'Veendam-Sorghvliet');
INSERT INTO buurt (code, naam) VALUES (470006, 'Veendam-industriegebied');
INSERT INTO buurt (code, naam) VALUES (470007, 'Buitenwoel');
INSERT INTO buurt (code, naam) VALUES (470100, 'Borgercompagnie (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (470101, 'Ommelanderwijk');
INSERT INTO buurt (code, naam) VALUES (470102, 'Zuidwending');
INSERT INTO buurt (code, naam) VALUES (470109, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (470200, 'Wildervank');
INSERT INTO buurt (code, naam) VALUES (470201, 'Boven-Wildervank');
INSERT INTO buurt (code, naam) VALUES (470202, 'Bareveld');
INSERT INTO buurt (code, naam) VALUES (470203, 'Wildervanksterdallen');
INSERT INTO buurt (code, naam) VALUES (470209, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (480000, 'Sellingen');
INSERT INTO buurt (code, naam) VALUES (480001, 'Laude');
INSERT INTO buurt (code, naam) VALUES (480004, 'Jipsinghuizen en Plaggenborg');
INSERT INTO buurt (code, naam) VALUES (480006, 'Leemdobben en Lammerweg');
INSERT INTO buurt (code, naam) VALUES (480008, 'Verspreide huizen ten oosten van Ruiten A-kanaal');
INSERT INTO buurt (code, naam) VALUES (480009, 'Verspreide huizen Sellingen');
INSERT INTO buurt (code, naam) VALUES (480100, 'Vlagtwedde');
INSERT INTO buurt (code, naam) VALUES (480101, 'Wollinghuizen');
INSERT INTO buurt (code, naam) VALUES (480102, 'Vlagtwedder-Veldhuis');
INSERT INTO buurt (code, naam) VALUES (480103, 'Veele');
INSERT INTO buurt (code, naam) VALUES (480104, 'Ellersinghuizen');
INSERT INTO buurt (code, naam) VALUES (480109, 'Verspreide huizen Vlagtwedde');
INSERT INTO buurt (code, naam) VALUES (480200, 'Bourtange');
INSERT INTO buurt (code, naam) VALUES (480201, 'Pallert');
INSERT INTO buurt (code, naam) VALUES (480202, 'Weite');
INSERT INTO buurt (code, naam) VALUES (480204, 'Stakenborg');
INSERT INTO buurt (code, naam) VALUES (480207, 'Verspreide huizen Hebrecht');
INSERT INTO buurt (code, naam) VALUES (480208, 'Verspreide huizen Bourtange');
INSERT INTO buurt (code, naam) VALUES (480209, 'Verspreide huizen ten noorden van Vlagtwedde');
INSERT INTO buurt (code, naam) VALUES (480300, 'Harpel');
INSERT INTO buurt (code, naam) VALUES (480301, 'Sellingerbeetse');
INSERT INTO buurt (code, naam) VALUES (480302, 'Jipsingboertange');
INSERT INTO buurt (code, naam) VALUES (480309, 'Verspreide huizen tussen Harpel en Sellingerbeetse');
INSERT INTO buurt (code, naam) VALUES (480400, 'Ter Apel');
INSERT INTO buurt (code, naam) VALUES (480401, 'Barnflair');
INSERT INTO buurt (code, naam) VALUES (480402, 'Ter Apelkanaal');
INSERT INTO buurt (code, naam) VALUES (480403, 'Ter Apel-West');
INSERT INTO buurt (code, naam) VALUES (480404, 'Jipsingboermussel en Zandberg');
INSERT INTO buurt (code, naam) VALUES (480405, 'Munnekemoer');
INSERT INTO buurt (code, naam) VALUES (480406, 'Burgemeester Beinsdorp');
INSERT INTO buurt (code, naam) VALUES (480407, 'Agobuurt');
INSERT INTO buurt (code, naam) VALUES (480408, 'Ter Apel ''t Heem');
INSERT INTO buurt (code, naam) VALUES (480409, 'Verspreide huizen Ter Apel en Ter Apelkanaal');
INSERT INTO buurt (code, naam) VALUES (480508, 'Verspreide huizen te Laudermarke');
INSERT INTO buurt (code, naam) VALUES (480509, 'Verspreide huizen Ter Wisch');
INSERT INTO buurt (code, naam) VALUES (480600, 'De Maten');
INSERT INTO buurt (code, naam) VALUES (480609, 'Verspreide huizen ten zuiden van Ter Apel');
INSERT INTO buurt (code, naam) VALUES (500000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (500001, 'Eerste woonwijk');
INSERT INTO buurt (code, naam) VALUES (500002, 'Tweede woonwijk');
INSERT INTO buurt (code, naam) VALUES (500003, 'Derde woonwijk');
INSERT INTO buurt (code, naam) VALUES (500004, 'Buurt 4');
INSERT INTO buurt (code, naam) VALUES (500005, 'Buurt 5');
INSERT INTO buurt (code, naam) VALUES (500006, 'Zuidlob');
INSERT INTO buurt (code, naam) VALUES (500007, 'Middengebied');
INSERT INTO buurt (code, naam) VALUES (500008, 'Knardijkgebied');
INSERT INTO buurt (code, naam) VALUES (500009, 'Trekkersveld');
INSERT INTO buurt (code, naam) VALUES (500010, 'Horstenparc');
INSERT INTO buurt (code, naam) VALUES (509997, '');
INSERT INTO buurt (code, naam) VALUES (530000, 'Winsum');
INSERT INTO buurt (code, naam) VALUES (530001, 'Obergum');
INSERT INTO buurt (code, naam) VALUES (530002, 'Ripperda');
INSERT INTO buurt (code, naam) VALUES (530003, 'Potmaar');
INSERT INTO buurt (code, naam) VALUES (530004, 'De Brake');
INSERT INTO buurt (code, naam) VALUES (530009, 'Verspreide huizen Winsum');
INSERT INTO buurt (code, naam) VALUES (530100, 'Ezinge');
INSERT INTO buurt (code, naam) VALUES (530101, 'Feerwerd');
INSERT INTO buurt (code, naam) VALUES (530102, 'Garnwerd');
INSERT INTO buurt (code, naam) VALUES (530109, 'Verspreide huizen Ezinge');
INSERT INTO buurt (code, naam) VALUES (530200, 'Baflo');
INSERT INTO buurt (code, naam) VALUES (530201, 'Den Andel');
INSERT INTO buurt (code, naam) VALUES (530202, 'Rasquert');
INSERT INTO buurt (code, naam) VALUES (530203, 'Tinallinge');
INSERT INTO buurt (code, naam) VALUES (530204, 'Saaxumhuizen');
INSERT INTO buurt (code, naam) VALUES (530209, 'Verspreide huizen Baflo');
INSERT INTO buurt (code, naam) VALUES (530300, 'Adorp');
INSERT INTO buurt (code, naam) VALUES (530301, 'Sauwerd');
INSERT INTO buurt (code, naam) VALUES (530302, 'Wetsinge');
INSERT INTO buurt (code, naam) VALUES (530309, 'Verspreide huizen Adorp');
INSERT INTO buurt (code, naam) VALUES (560000, 'Zuidhorn');
INSERT INTO buurt (code, naam) VALUES (560001, 'Noordhorn');
INSERT INTO buurt (code, naam) VALUES (560002, 'Niezijl');
INSERT INTO buurt (code, naam) VALUES (560003, 'Briltil');
INSERT INTO buurt (code, naam) VALUES (560009, 'Verspreide huizen Zuidhorn');
INSERT INTO buurt (code, naam) VALUES (560100, 'Grijpskerk');
INSERT INTO buurt (code, naam) VALUES (560102, 'Visvliet');
INSERT INTO buurt (code, naam) VALUES (560103, 'Kommerzijl');
INSERT INTO buurt (code, naam) VALUES (560104, 'Pieterzijl');
INSERT INTO buurt (code, naam) VALUES (560109, 'Verspreide huizen Grijpskerk');
INSERT INTO buurt (code, naam) VALUES (560200, 'Oldehove');
INSERT INTO buurt (code, naam) VALUES (560201, 'Niehove');
INSERT INTO buurt (code, naam) VALUES (560203, 'Saaksum');
INSERT INTO buurt (code, naam) VALUES (560204, 'Lauwerzijl');
INSERT INTO buurt (code, naam) VALUES (560208, 'Verspreide huizen Ruigezand en Nieuwe Ruigezand');
INSERT INTO buurt (code, naam) VALUES (560209, 'Overige verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (560300, 'Aduard');
INSERT INTO buurt (code, naam) VALUES (560301, 'Den Horn');
INSERT INTO buurt (code, naam) VALUES (560302, 'Den Ham');
INSERT INTO buurt (code, naam) VALUES (560309, 'Verspreide huizen Aduard');
INSERT INTO buurt (code, naam) VALUES (569997, '');
INSERT INTO buurt (code, naam) VALUES (580000, 'Dokkum binnen de Bolwerken');
INSERT INTO buurt (code, naam) VALUES (580001, 'Dokkum Noord');
INSERT INTO buurt (code, naam) VALUES (580002, 'Dokkum Fonteinslanden');
INSERT INTO buurt (code, naam) VALUES (580003, 'Dokkum Fugellan');
INSERT INTO buurt (code, naam) VALUES (580004, 'Dokkum Betterwird');
INSERT INTO buurt (code, naam) VALUES (580005, 'Dokkum Hoedemakerspolder');
INSERT INTO buurt (code, naam) VALUES (580006, 'Dokkum De Woudhorne');
INSERT INTO buurt (code, naam) VALUES (580007, 'De Trije Terpen');
INSERT INTO buurt (code, naam) VALUES (580008, 'Dokkum Weeshuislanden');
INSERT INTO buurt (code, naam) VALUES (580009, 'Dokkum Jantjeszeepolder');
INSERT INTO buurt (code, naam) VALUES (580010, 'Dokkum Kooilanden');
INSERT INTO buurt (code, naam) VALUES (580100, 'Metslawier');
INSERT INTO buurt (code, naam) VALUES (580101, 'Jouswier');
INSERT INTO buurt (code, naam) VALUES (580102, 'Niawier');
INSERT INTO buurt (code, naam) VALUES (580103, 'Wetsens');
INSERT INTO buurt (code, naam) VALUES (580104, 'Aalsum');
INSERT INTO buurt (code, naam) VALUES (580105, 'Oostrum');
INSERT INTO buurt (code, naam) VALUES (580107, 'Verspreide huizen Metslawier');
INSERT INTO buurt (code, naam) VALUES (580108, 'Verspreide huizen Niawier');
INSERT INTO buurt (code, naam) VALUES (580109, 'Verspreide huizen Oostrum');
INSERT INTO buurt (code, naam) VALUES (580200, 'Ee');
INSERT INTO buurt (code, naam) VALUES (580201, 'Engwierum');
INSERT INTO buurt (code, naam) VALUES (580202, 'Dokkumer Nieuwe Zijlen');
INSERT INTO buurt (code, naam) VALUES (580208, 'Verspreide huizen Ee');
INSERT INTO buurt (code, naam) VALUES (580209, 'Verspreide huizen Engwierum');
INSERT INTO buurt (code, naam) VALUES (580300, 'Anjum');
INSERT INTO buurt (code, naam) VALUES (580301, 'Lioessens');
INSERT INTO buurt (code, naam) VALUES (580302, 'Morra');
INSERT INTO buurt (code, naam) VALUES (580303, 'Oostmahorn');
INSERT INTO buurt (code, naam) VALUES (580307, 'Verspreide huizen Anjum');
INSERT INTO buurt (code, naam) VALUES (580308, 'Verspreide huizen Lioessens');
INSERT INTO buurt (code, naam) VALUES (580309, 'Verspreide huizen Morra');
INSERT INTO buurt (code, naam) VALUES (580400, 'Oosternijkerk');
INSERT INTO buurt (code, naam) VALUES (580401, 'Paesens');
INSERT INTO buurt (code, naam) VALUES (580408, 'Verspreide huizen Oosternijkerk');
INSERT INTO buurt (code, naam) VALUES (580409, 'Verspreide huizen Paesens');
INSERT INTO buurt (code, naam) VALUES (580500, 'Ternaard');
INSERT INTO buurt (code, naam) VALUES (580501, 'Wierum');
INSERT INTO buurt (code, naam) VALUES (580502, 'Nes');
INSERT INTO buurt (code, naam) VALUES (580503, 'Moddergat');
INSERT INTO buurt (code, naam) VALUES (580506, 'Verspreide huizen Ternaard');
INSERT INTO buurt (code, naam) VALUES (580507, 'Verspreide huizen Wierum');
INSERT INTO buurt (code, naam) VALUES (580508, 'Verspreide huizen Nes');
INSERT INTO buurt (code, naam) VALUES (580509, 'Verspreide huizen Moddergat');
INSERT INTO buurt (code, naam) VALUES (580600, 'Holwerd');
INSERT INTO buurt (code, naam) VALUES (580601, 'Waaxens');
INSERT INTO buurt (code, naam) VALUES (580602, 'Brantgum');
INSERT INTO buurt (code, naam) VALUES (580603, 'Foudgum');
INSERT INTO buurt (code, naam) VALUES (580604, 'Bornwird');
INSERT INTO buurt (code, naam) VALUES (580605, 'Raard');
INSERT INTO buurt (code, naam) VALUES (580608, 'Verspreide huizen Holwerd');
INSERT INTO buurt (code, naam) VALUES (580609, 'Verspreide huizen Brantgum');
INSERT INTO buurt (code, naam) VALUES (580700, 'Hantum');
INSERT INTO buurt (code, naam) VALUES (580701, 'Hantumhuizen');
INSERT INTO buurt (code, naam) VALUES (580702, 'Hantumeruitburen');
INSERT INTO buurt (code, naam) VALUES (580703, 'Hiaure');
INSERT INTO buurt (code, naam) VALUES (580708, 'Verspreide huizen Hantum');
INSERT INTO buurt (code, naam) VALUES (580709, 'Verspreide huizen Hantumhuizen');
INSERT INTO buurt (code, naam) VALUES (589997, '');
INSERT INTO buurt (code, naam) VALUES (589998, '');
INSERT INTO buurt (code, naam) VALUES (590000, 'Buitenpost');
INSERT INTO buurt (code, naam) VALUES (590001, 'Twijzel');
INSERT INTO buurt (code, naam) VALUES (590002, 'Kootstertille');
INSERT INTO buurt (code, naam) VALUES (590003, 'Twijzelerheide');
INSERT INTO buurt (code, naam) VALUES (590004, 'Gerkesklooster');
INSERT INTO buurt (code, naam) VALUES (590005, 'Verspreide huizen Buitenpost');
INSERT INTO buurt (code, naam) VALUES (590006, 'Verspreide huizen Twijzel');
INSERT INTO buurt (code, naam) VALUES (590007, 'Verspreide huizen Kootstertille');
INSERT INTO buurt (code, naam) VALUES (590008, 'Verspreide huizen Twijzelerheide');
INSERT INTO buurt (code, naam) VALUES (590009, 'Verspreide huizen Gerkesklooster');
INSERT INTO buurt (code, naam) VALUES (590100, 'Stroobos');
INSERT INTO buurt (code, naam) VALUES (590102, 'Drogeham');
INSERT INTO buurt (code, naam) VALUES (590103, 'Augustinusga');
INSERT INTO buurt (code, naam) VALUES (590107, 'Verspreide huizen Stroobos');
INSERT INTO buurt (code, naam) VALUES (590108, 'Verspreide huizen Drogeham');
INSERT INTO buurt (code, naam) VALUES (590109, 'Verspreide huizen Augustinusga');
INSERT INTO buurt (code, naam) VALUES (590200, 'Surhuisterveen');
INSERT INTO buurt (code, naam) VALUES (590201, 'Harkema');
INSERT INTO buurt (code, naam) VALUES (590202, 'Surhuizum');
INSERT INTO buurt (code, naam) VALUES (590203, 'Boelenslaan');
INSERT INTO buurt (code, naam) VALUES (590206, 'Verspreide huizen Surhuisterveen');
INSERT INTO buurt (code, naam) VALUES (590207, 'Verspreide huizen Harkema');
INSERT INTO buurt (code, naam) VALUES (590208, 'Verspreide huizen Surhuizum');
INSERT INTO buurt (code, naam) VALUES (590209, 'Verspreide huizen Boelenslaan');
INSERT INTO buurt (code, naam) VALUES (600000, 'Nes');
INSERT INTO buurt (code, naam) VALUES (600001, 'Buren');
INSERT INTO buurt (code, naam) VALUES (600002, 'Ballum');
INSERT INTO buurt (code, naam) VALUES (600003, 'Hollum');
INSERT INTO buurt (code, naam) VALUES (600007, 'Verspreide huizen Ballum');
INSERT INTO buurt (code, naam) VALUES (600008, 'Verspreide huizen Nes');
INSERT INTO buurt (code, naam) VALUES (600009, 'Verspreide huizen Hollum');
INSERT INTO buurt (code, naam) VALUES (609998, '');
INSERT INTO buurt (code, naam) VALUES (630000, 'Sint Annaparochie');
INSERT INTO buurt (code, naam) VALUES (630001, 'Oude Bildtdijk Sint Annaparochie');
INSERT INTO buurt (code, naam) VALUES (630002, 'Nieuwe Bildtdijk Sint Annaparochie');
INSERT INTO buurt (code, naam) VALUES (630003, 'Nij Altoenae');
INSERT INTO buurt (code, naam) VALUES (630004, 'Sint Jacobiparochie');
INSERT INTO buurt (code, naam) VALUES (630005, 'Oude Bildtdijk Sint Jacobiparochie');
INSERT INTO buurt (code, naam) VALUES (630008, 'Verspreide huizen Sint Annaparochie');
INSERT INTO buurt (code, naam) VALUES (630009, 'Verspreide huizen Sint Jacobiparochie');
INSERT INTO buurt (code, naam) VALUES (630100, 'Vrouwenparochie');
INSERT INTO buurt (code, naam) VALUES (630101, 'Oude Bildtzijl');
INSERT INTO buurt (code, naam) VALUES (630102, 'Oude Bildtdijk Oude Bildtzijl');
INSERT INTO buurt (code, naam) VALUES (630103, 'Nieuwe Bildtzijl en Nieuwe Bildtdijk');
INSERT INTO buurt (code, naam) VALUES (630108, 'Verspreide huizen Vrouwenparochie');
INSERT INTO buurt (code, naam) VALUES (630109, 'Verspreide huizen Oude Bildtzijl');
INSERT INTO buurt (code, naam) VALUES (630200, 'Minnertsga');
INSERT INTO buurt (code, naam) VALUES (630201, 'Verspreide huizen Minnertsga');
INSERT INTO buurt (code, naam) VALUES (639998, '');
INSERT INTO buurt (code, naam) VALUES (700000, 'Franeker Binnenstad');
INSERT INTO buurt (code, naam) VALUES (700001, 'Professorenbuurt');
INSERT INTO buurt (code, naam) VALUES (700002, 'Stationsbuurt, oostelijk en zuidelijk industrieterrein');
INSERT INTO buurt (code, naam) VALUES (700003, 'Vliet, Tuinen en Frisia');
INSERT INTO buurt (code, naam) VALUES (700004, 'Kaatsersbuurt');
INSERT INTO buurt (code, naam) VALUES (700005, 'C. van Saarloosstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (700006, 'Hamburgerrak en Het Want');
INSERT INTO buurt (code, naam) VALUES (700007, 'Schalsumerplan en Arkens');
INSERT INTO buurt (code, naam) VALUES (700008, 'Watertoren, Bloemketerp en Zevenhuizen');
INSERT INTO buurt (code, naam) VALUES (700009, 'Verspreide huizen Franeker');
INSERT INTO buurt (code, naam) VALUES (700100, 'Dongjum');
INSERT INTO buurt (code, naam) VALUES (700101, 'Firdgum');
INSERT INTO buurt (code, naam) VALUES (700102, 'Klooster-Lidlum');
INSERT INTO buurt (code, naam) VALUES (700103, 'Oosterbierum');
INSERT INTO buurt (code, naam) VALUES (700104, 'Tzummarum');
INSERT INTO buurt (code, naam) VALUES (700107, 'Verspreide huizen Dongjum');
INSERT INTO buurt (code, naam) VALUES (700108, 'Verspreide huizen Oosterbierum');
INSERT INTO buurt (code, naam) VALUES (700109, 'Verspreide huizen Tzummarum');
INSERT INTO buurt (code, naam) VALUES (700200, 'Boer');
INSERT INTO buurt (code, naam) VALUES (700201, 'Peins');
INSERT INTO buurt (code, naam) VALUES (700202, 'Ried');
INSERT INTO buurt (code, naam) VALUES (700203, 'Schalsum');
INSERT INTO buurt (code, naam) VALUES (700204, 'Zweins');
INSERT INTO buurt (code, naam) VALUES (700208, 'Verspreide huizen Peins');
INSERT INTO buurt (code, naam) VALUES (700209, 'Verspreide huizen Ried');
INSERT INTO buurt (code, naam) VALUES (700300, 'Achlum');
INSERT INTO buurt (code, naam) VALUES (700301, 'Hitzum');
INSERT INTO buurt (code, naam) VALUES (700302, 'Tzum');
INSERT INTO buurt (code, naam) VALUES (700307, 'Verspreide huizen Achlum');
INSERT INTO buurt (code, naam) VALUES (700308, 'Verspreide huizen Hitzum');
INSERT INTO buurt (code, naam) VALUES (700309, 'Verspreide huizen Tzum');
INSERT INTO buurt (code, naam) VALUES (700400, 'Herbaijum');
INSERT INTO buurt (code, naam) VALUES (700401, 'Pietersbierum');
INSERT INTO buurt (code, naam) VALUES (700402, 'Sexbierum');
INSERT INTO buurt (code, naam) VALUES (700407, 'Verspreide huizen Herbaijum');
INSERT INTO buurt (code, naam) VALUES (700408, 'Verspreide huizen Pietersbierum');
INSERT INTO buurt (code, naam) VALUES (700409, 'Verspreide huizen Sexbierum');
INSERT INTO buurt (code, naam) VALUES (700500, 'Sexbierumerplan');
INSERT INTO buurt (code, naam) VALUES (700501, '''t War, Witzens en Groot Lankum');
INSERT INTO buurt (code, naam) VALUES (700502, 'Franeker-Zuid');
INSERT INTO buurt (code, naam) VALUES (700503, 'Industriegebied West en bedrijventerrein Kie');
INSERT INTO buurt (code, naam) VALUES (709998, '');
INSERT INTO buurt (code, naam) VALUES (720001, 'De Spiker en het industrieterrein Hermes');
INSERT INTO buurt (code, naam) VALUES (720002, 'Trebolbuurt');
INSERT INTO buurt (code, naam) VALUES (720003, 'Plan-Zuid');
INSERT INTO buurt (code, naam) VALUES (720004, 'Oosterpark');
INSERT INTO buurt (code, naam) VALUES (720005, 'Koningsbuurt');
INSERT INTO buurt (code, naam) VALUES (720006, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (720007, 'Industriehaven en omgeving');
INSERT INTO buurt (code, naam) VALUES (720009, 'Verspreide huizen Harlingen');
INSERT INTO buurt (code, naam) VALUES (720100, 'Midlum');
INSERT INTO buurt (code, naam) VALUES (720109, 'Verspreide huizen Midlum');
INSERT INTO buurt (code, naam) VALUES (720200, 'Wijnaldum');
INSERT INTO buurt (code, naam) VALUES (720209, 'Verspreide huizen Wijnaldum');
INSERT INTO buurt (code, naam) VALUES (729998, '');
INSERT INTO buurt (code, naam) VALUES (740100, 'Noord');
INSERT INTO buurt (code, naam) VALUES (740101, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (740102, 'Midden');
INSERT INTO buurt (code, naam) VALUES (740103, 'Nijehaske');
INSERT INTO buurt (code, naam) VALUES (740104, 'De Greiden');
INSERT INTO buurt (code, naam) VALUES (740105, 'De Heide');
INSERT INTO buurt (code, naam) VALUES (740106, 'De Akkers');
INSERT INTO buurt (code, naam) VALUES (740107, 'Skoatterwald');
INSERT INTO buurt (code, naam) VALUES (740108, 'Het meer');
INSERT INTO buurt (code, naam) VALUES (740109, 'Nieuweschoot');
INSERT INTO buurt (code, naam) VALUES (740110, 'Haskerveen');
INSERT INTO buurt (code, naam) VALUES (740201, 'Terband');
INSERT INTO buurt (code, naam) VALUES (740202, 'Luinjeberd');
INSERT INTO buurt (code, naam) VALUES (740203, 'Tjalleberd');
INSERT INTO buurt (code, naam) VALUES (740204, 'Gersloot');
INSERT INTO buurt (code, naam) VALUES (740205, 'Gersloot-polder');
INSERT INTO buurt (code, naam) VALUES (740301, 'De Knipe');
INSERT INTO buurt (code, naam) VALUES (740302, 'Bontebok');
INSERT INTO buurt (code, naam) VALUES (740401, 'Oudeschoot');
INSERT INTO buurt (code, naam) VALUES (740402, 'Mildam');
INSERT INTO buurt (code, naam) VALUES (740403, 'Katlijk');
INSERT INTO buurt (code, naam) VALUES (740404, 'Nieuwehorne');
INSERT INTO buurt (code, naam) VALUES (740405, 'Oudehorne');
INSERT INTO buurt (code, naam) VALUES (740406, 'Jubbega');
INSERT INTO buurt (code, naam) VALUES (740407, 'Hoornsterzwaag');
INSERT INTO buurt (code, naam) VALUES (740601, 'Oranjewoud');
INSERT INTO buurt (code, naam) VALUES (740701, 'Haskerdijken');
INSERT INTO buurt (code, naam) VALUES (740702, 'Nieuwebrug');
INSERT INTO buurt (code, naam) VALUES (740901, 'Akkrum');
INSERT INTO buurt (code, naam) VALUES (740902, 'Nes');
INSERT INTO buurt (code, naam) VALUES (740903, 'Aldeboarn');
INSERT INTO buurt (code, naam) VALUES (790000, 'Kollum');
INSERT INTO buurt (code, naam) VALUES (790009, 'Verspreide huizen Kollum');
INSERT INTO buurt (code, naam) VALUES (790100, 'Burum');
INSERT INTO buurt (code, naam) VALUES (790101, 'Kollumerpomp');
INSERT INTO buurt (code, naam) VALUES (790102, 'Warfstermolen');
INSERT INTO buurt (code, naam) VALUES (790103, 'Munnekezijl');
INSERT INTO buurt (code, naam) VALUES (790104, 'Augsbuurt');
INSERT INTO buurt (code, naam) VALUES (790106, 'Verspreide huizen Burum');
INSERT INTO buurt (code, naam) VALUES (790107, 'Verspreide huizen Kollumerpomp');
INSERT INTO buurt (code, naam) VALUES (790108, 'Verspreide huizen Warfstermolen');
INSERT INTO buurt (code, naam) VALUES (790109, 'Verspreide huizen Munnekezijl');
INSERT INTO buurt (code, naam) VALUES (790200, 'Oudwoude');
INSERT INTO buurt (code, naam) VALUES (790201, 'Triemen');
INSERT INTO buurt (code, naam) VALUES (790202, 'Westergeest');
INSERT INTO buurt (code, naam) VALUES (790208, 'Verspreide huizen Oudwoude');
INSERT INTO buurt (code, naam) VALUES (790209, 'Verspreide huizen Westergeest');
INSERT INTO buurt (code, naam) VALUES (790300, 'Kollumerzwaag');
INSERT INTO buurt (code, naam) VALUES (790301, 'Zwagerbosch');
INSERT INTO buurt (code, naam) VALUES (790302, 'Veenklooster');
INSERT INTO buurt (code, naam) VALUES (790309, 'Verspreide huizen Kollumerzwaag');
INSERT INTO buurt (code, naam) VALUES (799997, '');
INSERT INTO buurt (code, naam) VALUES (801001, 'De Waag');
INSERT INTO buurt (code, naam) VALUES (801002, 'Nieuwestad');
INSERT INTO buurt (code, naam) VALUES (801003, 'Oldehove');
INSERT INTO buurt (code, naam) VALUES (801004, 'Grote Kerkbuurt');
INSERT INTO buurt (code, naam) VALUES (801005, 'Hoek');
INSERT INTO buurt (code, naam) VALUES (801006, 'Blokhuisplein');
INSERT INTO buurt (code, naam) VALUES (801007, 'Zaailand');
INSERT INTO buurt (code, naam) VALUES (801008, 'Stationskwartier');
INSERT INTO buurt (code, naam) VALUES (802001, 'Transvaalwijk');
INSERT INTO buurt (code, naam) VALUES (802002, 'Bonifatius');
INSERT INTO buurt (code, naam) VALUES (802003, 'Rengerspark');
INSERT INTO buurt (code, naam) VALUES (802101, 'Bilgaard');
INSERT INTO buurt (code, naam) VALUES (802102, 'Havankpark');
INSERT INTO buurt (code, naam) VALUES (802103, 'Vierhuisterweg e.o.');
INSERT INTO buurt (code, naam) VALUES (802201, 'Vrijheidswijk-West');
INSERT INTO buurt (code, naam) VALUES (802202, 'Vrijheidswijk-Oost');
INSERT INTO buurt (code, naam) VALUES (802301, 'Lekkum');
INSERT INTO buurt (code, naam) VALUES (802302, 'Snakkerburen');
INSERT INTO buurt (code, naam) VALUES (802303, 'Buitengebied Lekkum en Miedum');
INSERT INTO buurt (code, naam) VALUES (802401, 'Blitsaerd');
INSERT INTO buurt (code, naam) VALUES (803001, 'Oldegalileën');
INSERT INTO buurt (code, naam) VALUES (803002, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (803101, 'Cambuursterpad');
INSERT INTO buurt (code, naam) VALUES (803102, 'Zamenhofpark');
INSERT INTO buurt (code, naam) VALUES (803103, 'Cambuur');
INSERT INTO buurt (code, naam) VALUES (803201, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (803202, 'Indische buurt');
INSERT INTO buurt (code, naam) VALUES (803203, 'Molenpad');
INSERT INTO buurt (code, naam) VALUES (803204, 'Welgelegen');
INSERT INTO buurt (code, naam) VALUES (803301, 'Tulpenburg');
INSERT INTO buurt (code, naam) VALUES (803302, 'Oranjewijk');
INSERT INTO buurt (code, naam) VALUES (803401, 'Heechterp');
INSERT INTO buurt (code, naam) VALUES (803501, 'Schieringen');
INSERT INTO buurt (code, naam) VALUES (803502, 'De Centrale');
INSERT INTO buurt (code, naam) VALUES (803601, 'Camminghaburen-Noord');
INSERT INTO buurt (code, naam) VALUES (803602, 'Camminghaburen-Midden');
INSERT INTO buurt (code, naam) VALUES (803603, 'Camminghaburen-Zuid');
INSERT INTO buurt (code, naam) VALUES (803701, 'Grote Wielen');
INSERT INTO buurt (code, naam) VALUES (803702, 'De Groene Ster');
INSERT INTO buurt (code, naam) VALUES (803801, 'Hemrik');
INSERT INTO buurt (code, naam) VALUES (804001, 'Achter de Hoven');
INSERT INTO buurt (code, naam) VALUES (804101, 'Schepenbuurt');
INSERT INTO buurt (code, naam) VALUES (804201, 'Wielenpôlle');
INSERT INTO buurt (code, naam) VALUES (804301, 'Huizum-Dorp');
INSERT INTO buurt (code, naam) VALUES (804302, 'Huizum-Sixma');
INSERT INTO buurt (code, naam) VALUES (804303, 'Huizum-Bornia');
INSERT INTO buurt (code, naam) VALUES (804304, 'Huizum-Badweg');
INSERT INTO buurt (code, naam) VALUES (804401, 'Hollanderwijk');
INSERT INTO buurt (code, naam) VALUES (804402, 'Gerard Dou');
INSERT INTO buurt (code, naam) VALUES (804403, 'Julianapark');
INSERT INTO buurt (code, naam) VALUES (804404, 'Jan van Scorelbuurt');
INSERT INTO buurt (code, naam) VALUES (804501, 'Aldlân-Oost');
INSERT INTO buurt (code, naam) VALUES (804502, 'Aldlân-West');
INSERT INTO buurt (code, naam) VALUES (804503, 'Rapenburg');
INSERT INTO buurt (code, naam) VALUES (804601, 'Nijlân');
INSERT INTO buurt (code, naam) VALUES (805001, 'Hempens/Teerns');
INSERT INTO buurt (code, naam) VALUES (805002, 'Buitengebied Hempens');
INSERT INTO buurt (code, naam) VALUES (805003, 'Zuiderburen');
INSERT INTO buurt (code, naam) VALUES (805101, 'Wirdum');
INSERT INTO buurt (code, naam) VALUES (805102, 'Swichum');
INSERT INTO buurt (code, naam) VALUES (805103, 'Buitengebied Wirdum');
INSERT INTO buurt (code, naam) VALUES (805201, 'Wytgaard');
INSERT INTO buurt (code, naam) VALUES (805202, 'Buitengebied Wytgaard');
INSERT INTO buurt (code, naam) VALUES (805301, 'Goutum');
INSERT INTO buurt (code, naam) VALUES (805302, 'Buitengebied Goutum');
INSERT INTO buurt (code, naam) VALUES (805401, 'Techum');
INSERT INTO buurt (code, naam) VALUES (805406, 'Unia');
INSERT INTO buurt (code, naam) VALUES (805407, '"De Zuidlanden"');
INSERT INTO buurt (code, naam) VALUES (806001, 'Harlingervaart');
INSERT INTO buurt (code, naam) VALUES (806002, 'Zwette-Schenkenschans');
INSERT INTO buurt (code, naam) VALUES (806003, 'Businesspark Leeuwarden');
INSERT INTO buurt (code, naam) VALUES (806004, 'Newton');
INSERT INTO buurt (code, naam) VALUES (806101, 'Vossepark');
INSERT INTO buurt (code, naam) VALUES (806102, 'Helicon');
INSERT INTO buurt (code, naam) VALUES (806103, 'Harlingervaart Noord');
INSERT INTO buurt (code, naam) VALUES (806201, 'Vogelwijk');
INSERT INTO buurt (code, naam) VALUES (806202, 'Sonnenborgh');
INSERT INTO buurt (code, naam) VALUES (806301, 'Valeriuskwartier');
INSERT INTO buurt (code, naam) VALUES (806302, 'Magere Weide');
INSERT INTO buurt (code, naam) VALUES (806401, 'Westeinde');
INSERT INTO buurt (code, naam) VALUES (806501, 'Buitengebied Noordwest');
INSERT INTO buurt (code, naam) VALUES (807001, 'Wergea');
INSERT INTO buurt (code, naam) VALUES (807002, 'Buitengebied Wergea');
INSERT INTO buurt (code, naam) VALUES (807003, 'Warstiens');
INSERT INTO buurt (code, naam) VALUES (807004, 'Warten');
INSERT INTO buurt (code, naam) VALUES (807005, 'Buitengebied Warten');
INSERT INTO buurt (code, naam) VALUES (807101, 'Reduzum');
INSERT INTO buurt (code, naam) VALUES (807102, 'Buitengebied Reduzum');
INSERT INTO buurt (code, naam) VALUES (807103, 'Eagum');
INSERT INTO buurt (code, naam) VALUES (807104, 'Ideard');
INSERT INTO buurt (code, naam) VALUES (807105, 'Friens');
INSERT INTO buurt (code, naam) VALUES (807201, 'Grou');
INSERT INTO buurt (code, naam) VALUES (807202, 'Buitengebied Grou');
INSERT INTO buurt (code, naam) VALUES (807301, 'Jirnsum');
INSERT INTO buurt (code, naam) VALUES (807302, 'Buitengebied Jirnsum');
INSERT INTO buurt (code, naam) VALUES (810000, 'Stiens');
INSERT INTO buurt (code, naam) VALUES (810001, 'Finkum');
INSERT INTO buurt (code, naam) VALUES (810002, 'Hijum');
INSERT INTO buurt (code, naam) VALUES (810006, 'Verspreide huizen Stiens');
INSERT INTO buurt (code, naam) VALUES (810007, 'Verspreide huizen Finkum');
INSERT INTO buurt (code, naam) VALUES (810008, 'Verspreide huizen Hijum');
INSERT INTO buurt (code, naam) VALUES (810009, 'Oude Leije');
INSERT INTO buurt (code, naam) VALUES (810100, 'Britsum');
INSERT INTO buurt (code, naam) VALUES (810101, 'Cornjum');
INSERT INTO buurt (code, naam) VALUES (810102, 'Jelsum');
INSERT INTO buurt (code, naam) VALUES (810107, 'Verspreide huizen Britsum');
INSERT INTO buurt (code, naam) VALUES (810108, 'Verspreide huizen Cornjum');
INSERT INTO buurt (code, naam) VALUES (810109, 'Verspreide huizen Jelsum');
INSERT INTO buurt (code, naam) VALUES (850000, 'Oosterwolde');
INSERT INTO buurt (code, naam) VALUES (850008, 'Industriepark Oosterwolde');
INSERT INTO buurt (code, naam) VALUES (850009, 'Verspreide huizen Oosterwolde');
INSERT INTO buurt (code, naam) VALUES (850100, 'Donkerbroek');
INSERT INTO buurt (code, naam) VALUES (850101, 'Haule');
INSERT INTO buurt (code, naam) VALUES (850108, 'Verspreide huizen Donkerbroek');
INSERT INTO buurt (code, naam) VALUES (850109, 'Verspreide huizen Haule');
INSERT INTO buurt (code, naam) VALUES (850200, 'Makkinga');
INSERT INTO buurt (code, naam) VALUES (850201, 'Elsloo');
INSERT INTO buurt (code, naam) VALUES (850202, 'Langedijke');
INSERT INTO buurt (code, naam) VALUES (850208, 'Verspreide huizen Makkinga');
INSERT INTO buurt (code, naam) VALUES (850209, 'Verspreide huizen Elsloo');
INSERT INTO buurt (code, naam) VALUES (850300, 'Oldeberkoop');
INSERT INTO buurt (code, naam) VALUES (850301, 'Nijeberkoop');
INSERT INTO buurt (code, naam) VALUES (850302, 'Verspreide huizen Nijeberkoop');
INSERT INTO buurt (code, naam) VALUES (850309, 'Verspreide huizen Oldeberkoop');
INSERT INTO buurt (code, naam) VALUES (850400, 'Haulerwijk');
INSERT INTO buurt (code, naam) VALUES (850401, 'Waskemeer');
INSERT INTO buurt (code, naam) VALUES (850408, 'Verspreide huizen Haulerwijk');
INSERT INTO buurt (code, naam) VALUES (850409, 'Verspreide huizen Waskemeer');
INSERT INTO buurt (code, naam) VALUES (850500, 'Appelscha');
INSERT INTO buurt (code, naam) VALUES (850501, 'Ravenswoud');
INSERT INTO buurt (code, naam) VALUES (850502, 'Fochteloo');
INSERT INTO buurt (code, naam) VALUES (850504, 'Oud Appelscha');
INSERT INTO buurt (code, naam) VALUES (850507, 'Verspreide huizen Appelscha');
INSERT INTO buurt (code, naam) VALUES (850508, 'Verspreide huizen Ravenswoud');
INSERT INTO buurt (code, naam) VALUES (850509, 'Verspreide huizen Fochteloo');
INSERT INTO buurt (code, naam) VALUES (860000, 'Gorredijk');
INSERT INTO buurt (code, naam) VALUES (860009, 'Verspreide huizen Gorredijk');
INSERT INTO buurt (code, naam) VALUES (860100, 'Langezwaag');
INSERT INTO buurt (code, naam) VALUES (860101, 'Luxwoude');
INSERT INTO buurt (code, naam) VALUES (860102, 'Tijnje');
INSERT INTO buurt (code, naam) VALUES (860107, 'Verspreide huizen Langezwaag');
INSERT INTO buurt (code, naam) VALUES (860108, 'Verspreide huizen Luxwoude');
INSERT INTO buurt (code, naam) VALUES (860109, 'Verspreide huizen Tijnje');
INSERT INTO buurt (code, naam) VALUES (860200, 'Terwispel');
INSERT INTO buurt (code, naam) VALUES (860201, 'Nij beets');
INSERT INTO buurt (code, naam) VALUES (860208, 'Verspreide huizen Terwispel');
INSERT INTO buurt (code, naam) VALUES (860209, 'Verspreide huizen Nij Beets');
INSERT INTO buurt (code, naam) VALUES (860300, 'Beetsterzwaag');
INSERT INTO buurt (code, naam) VALUES (860301, 'Olterterp');
INSERT INTO buurt (code, naam) VALUES (860302, 'Lippenhuizen');
INSERT INTO buurt (code, naam) VALUES (860303, 'Hemrik');
INSERT INTO buurt (code, naam) VALUES (860307, 'Verspreide huizen Beetsterzwaag');
INSERT INTO buurt (code, naam) VALUES (860308, 'Verspreide huizen Lippenhuizen');
INSERT INTO buurt (code, naam) VALUES (860309, 'Verspreide huizen Hemrik');
INSERT INTO buurt (code, naam) VALUES (860400, 'Ureterp');
INSERT INTO buurt (code, naam) VALUES (860401, 'Frieschepalen');
INSERT INTO buurt (code, naam) VALUES (860402, 'Siegerswoude');
INSERT INTO buurt (code, naam) VALUES (860408, 'Verspreide huizen Ureterp');
INSERT INTO buurt (code, naam) VALUES (860409, 'Verspreide huizen Frieschepalen');
INSERT INTO buurt (code, naam) VALUES (860500, 'Bakkeveen');
INSERT INTO buurt (code, naam) VALUES (860501, 'Wijnjewoude');
INSERT INTO buurt (code, naam) VALUES (860507, 'Verspreide huizen Bakkeveen');
INSERT INTO buurt (code, naam) VALUES (860508, 'Verspreide huizen Wijnjewoude-Oost');
INSERT INTO buurt (code, naam) VALUES (860509, 'Verspreide huizen Wijnjewoude-West');
INSERT INTO buurt (code, naam) VALUES (880000, 'Schiermonnikoog');
INSERT INTO buurt (code, naam) VALUES (880009, 'Verspreide huizen Schiermonnikoog');
INSERT INTO buurt (code, naam) VALUES (889998, '');
INSERT INTO buurt (code, naam) VALUES (900001, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (900002, 'De Wiken');
INSERT INTO buurt (code, naam) VALUES (900003, 'De Singels');
INSERT INTO buurt (code, naam) VALUES (900004, 'De Drait');
INSERT INTO buurt (code, naam) VALUES (900005, 'De Wiken-Oost');
INSERT INTO buurt (code, naam) VALUES (900006, 'De Venen');
INSERT INTO buurt (code, naam) VALUES (900007, 'De Folgeren');
INSERT INTO buurt (code, naam) VALUES (900008, 'De Swetten');
INSERT INTO buurt (code, naam) VALUES (900009, 'De Bouwen');
INSERT INTO buurt (code, naam) VALUES (900010, 'Noordoost');
INSERT INTO buurt (code, naam) VALUES (900011, 'De Haven');
INSERT INTO buurt (code, naam) VALUES (900012, 'Buitengebied Drachten');
INSERT INTO buurt (code, naam) VALUES (900013, 'De Trisken');
INSERT INTO buurt (code, naam) VALUES (900014, 'Fennepark');
INSERT INTO buurt (code, naam) VALUES (900015, 'Himsterhout');
INSERT INTO buurt (code, naam) VALUES (900016, 'Bedrijvenpark');
INSERT INTO buurt (code, naam) VALUES (900017, 'Vrijburg');
INSERT INTO buurt (code, naam) VALUES (900018, 'Burmaniapark');
INSERT INTO buurt (code, naam) VALUES (900120, 'Opeinde');
INSERT INTO buurt (code, naam) VALUES (900121, 'Rottevalle');
INSERT INTO buurt (code, naam) VALUES (900122, 'Houtigehage');
INSERT INTO buurt (code, naam) VALUES (900123, 'Drachtstercompagnie');
INSERT INTO buurt (code, naam) VALUES (900124, 'Kortehemmen');
INSERT INTO buurt (code, naam) VALUES (900125, 'Boornbergum');
INSERT INTO buurt (code, naam) VALUES (900126, 'De Wilgen');
INSERT INTO buurt (code, naam) VALUES (900127, 'Smalle Ee');
INSERT INTO buurt (code, naam) VALUES (900128, 'De Veenhoop');
INSERT INTO buurt (code, naam) VALUES (900129, 'Goëngahuizen');
INSERT INTO buurt (code, naam) VALUES (900130, 'Oudega');
INSERT INTO buurt (code, naam) VALUES (900131, 'Nijega');
INSERT INTO buurt (code, naam) VALUES (900132, 'De Tike');
INSERT INTO buurt (code, naam) VALUES (930000, 'West-Terschelling');
INSERT INTO buurt (code, naam) VALUES (930002, 'Verspreide huizen West-Terschelling');
INSERT INTO buurt (code, naam) VALUES (930110, 'Midsland');
INSERT INTO buurt (code, naam) VALUES (930111, 'Verspreide huizen Midsland-Zuid');
INSERT INTO buurt (code, naam) VALUES (930112, 'Verspreide huizen Midsland-Noord');
INSERT INTO buurt (code, naam) VALUES (930213, 'Formerum');
INSERT INTO buurt (code, naam) VALUES (930214, 'Verspreide huizen Formerum-Zuid');
INSERT INTO buurt (code, naam) VALUES (930215, 'Verspreide huizen Formerum-Noord');
INSERT INTO buurt (code, naam) VALUES (930316, 'Lies');
INSERT INTO buurt (code, naam) VALUES (930317, 'Verspreide huizen Lies-Zuid');
INSERT INTO buurt (code, naam) VALUES (930418, 'Koegelwieck');
INSERT INTO buurt (code, naam) VALUES (930419, 'Hoorn');
INSERT INTO buurt (code, naam) VALUES (930420, 'Verspreide huizen Hoorn-Zuid');
INSERT INTO buurt (code, naam) VALUES (930521, 'Oosterend');
INSERT INTO buurt (code, naam) VALUES (930522, 'Verspreide huizen Oosterend-Zuid');
INSERT INTO buurt (code, naam) VALUES (930523, 'De Boschplaat');
INSERT INTO buurt (code, naam) VALUES (939998, '');
INSERT INTO buurt (code, naam) VALUES (960000, 'Oost-Vlieland');
INSERT INTO buurt (code, naam) VALUES (960009, 'Verspreide huizen Vlieland');
INSERT INTO buurt (code, naam) VALUES (969998, '');
INSERT INTO buurt (code, naam) VALUES (980000, 'Wolvega');
INSERT INTO buurt (code, naam) VALUES (980009, 'Verspreide huizen Wolvega');
INSERT INTO buurt (code, naam) VALUES (980100, 'Sonnega');
INSERT INTO buurt (code, naam) VALUES (980101, 'Nijelamer');
INSERT INTO buurt (code, naam) VALUES (980102, 'Nijeholtwolde');
INSERT INTO buurt (code, naam) VALUES (980103, 'Oldeholtwolde');
INSERT INTO buurt (code, naam) VALUES (980104, 'Ter Idzard');
INSERT INTO buurt (code, naam) VALUES (980105, 'Verspreide huizen Sonnega');
INSERT INTO buurt (code, naam) VALUES (980106, 'Verspreide huizen Nijelamer');
INSERT INTO buurt (code, naam) VALUES (980107, 'Verspreide huizen Nijeholtwolde');
INSERT INTO buurt (code, naam) VALUES (980108, 'Verspreide huizen Oldeholtwolde');
INSERT INTO buurt (code, naam) VALUES (980109, 'Verspreide huizen Ter Idzard');
INSERT INTO buurt (code, naam) VALUES (980200, 'Oldetrijne');
INSERT INTO buurt (code, naam) VALUES (980201, 'Oldelamer');
INSERT INTO buurt (code, naam) VALUES (980208, 'Verspreide huizen Oldetrijne');
INSERT INTO buurt (code, naam) VALUES (980209, 'Verspreide huizen Oldelamer');
INSERT INTO buurt (code, naam) VALUES (980300, 'Munnekeburen');
INSERT INTO buurt (code, naam) VALUES (980301, 'Nijetrijne');
INSERT INTO buurt (code, naam) VALUES (980302, 'Langelille');
INSERT INTO buurt (code, naam) VALUES (980307, 'Verspreide huizen Munnekeburen');
INSERT INTO buurt (code, naam) VALUES (980308, 'Verspreide huizen Nijetrijne');
INSERT INTO buurt (code, naam) VALUES (980309, 'Verspreide huizen Langelille');
INSERT INTO buurt (code, naam) VALUES (980400, 'Scherpenzeel');
INSERT INTO buurt (code, naam) VALUES (980401, 'Spanga');
INSERT INTO buurt (code, naam) VALUES (980402, 'Slijkenburg');
INSERT INTO buurt (code, naam) VALUES (980408, 'Verspreide huizen Scherpenzeel');
INSERT INTO buurt (code, naam) VALUES (980409, 'Verspreide huizen Spanga');
INSERT INTO buurt (code, naam) VALUES (980500, 'Oldeholtpade');
INSERT INTO buurt (code, naam) VALUES (980501, 'Nijeholtpade');
INSERT INTO buurt (code, naam) VALUES (980508, 'Verspreide huizen Oldeholtpade');
INSERT INTO buurt (code, naam) VALUES (980509, 'Verspreide huizen Nijeholtpade');
INSERT INTO buurt (code, naam) VALUES (980600, 'Blesdijke');
INSERT INTO buurt (code, naam) VALUES (980601, 'De Blesse');
INSERT INTO buurt (code, naam) VALUES (980602, 'Peperga');
INSERT INTO buurt (code, naam) VALUES (980607, 'Verspreide huizen De Blesse');
INSERT INTO buurt (code, naam) VALUES (980608, 'Verspreide huizen Blesdijke');
INSERT INTO buurt (code, naam) VALUES (980609, 'Verspreide huizen Peperga');
INSERT INTO buurt (code, naam) VALUES (980700, 'Steggerda');
INSERT INTO buurt (code, naam) VALUES (980701, 'Vinkega');
INSERT INTO buurt (code, naam) VALUES (980702, 'De Hoeve');
INSERT INTO buurt (code, naam) VALUES (980707, 'Verspreide huizen Steggerda');
INSERT INTO buurt (code, naam) VALUES (980708, 'Verspreide huizen Vinkega');
INSERT INTO buurt (code, naam) VALUES (980709, 'Verspreide huizen De Hoeve');
INSERT INTO buurt (code, naam) VALUES (980800, 'Noordwolde');
INSERT INTO buurt (code, naam) VALUES (980801, 'Boijl');
INSERT INTO buurt (code, naam) VALUES (980807, 'Oosterstreek');
INSERT INTO buurt (code, naam) VALUES (980808, 'Verspreide huizen Noordwolde en Zandhuizen');
INSERT INTO buurt (code, naam) VALUES (980809, 'Verspreide huizen Boijl');
INSERT INTO buurt (code, naam) VALUES (1060000, 'Brinkkwartier');
INSERT INTO buurt (code, naam) VALUES (1060001, 'Erfgoedkwartier');
INSERT INTO buurt (code, naam) VALUES (1060002, 'Overcingel');
INSERT INTO buurt (code, naam) VALUES (1060003, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (1060004, 'Galgenveld');
INSERT INTO buurt (code, naam) VALUES (1060005, 'Koopmanskwartier');
INSERT INTO buurt (code, naam) VALUES (1060006, 'Cultuureelkwartier');
INSERT INTO buurt (code, naam) VALUES (1060007, 'Oude Gasfabriek');
INSERT INTO buurt (code, naam) VALUES (1060008, 'De Hertenkamp');
INSERT INTO buurt (code, naam) VALUES (1060009, 'Asserbos');
INSERT INTO buurt (code, naam) VALUES (1060010, 'De Esch');
INSERT INTO buurt (code, naam) VALUES (1060011, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (1060012, 'Zuiderpark');
INSERT INTO buurt (code, naam) VALUES (1060100, 'De Lariks Oost');
INSERT INTO buurt (code, naam) VALUES (1060101, 'Landgoed Lariks');
INSERT INTO buurt (code, naam) VALUES (1060102, 'De Lariks West');
INSERT INTO buurt (code, naam) VALUES (1060103, 'Luchiesland Zuid');
INSERT INTO buurt (code, naam) VALUES (1060104, 'Zuid Molukse Buurt');
INSERT INTO buurt (code, naam) VALUES (1060105, 'Luchiesland Noord');
INSERT INTO buurt (code, naam) VALUES (1060200, 'Oude Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (1060201, 'Dichtershof');
INSERT INTO buurt (code, naam) VALUES (1060202, 'Veningerland');
INSERT INTO buurt (code, naam) VALUES (1060203, 'Zwarte Water');
INSERT INTO buurt (code, naam) VALUES (1060204, 'Componistenbuurt West');
INSERT INTO buurt (code, naam) VALUES (1060205, 'Componistenbuurt Oost');
INSERT INTO buurt (code, naam) VALUES (1060300, 'Dijkveld');
INSERT INTO buurt (code, naam) VALUES (1060301, 'Vreebergen');
INSERT INTO buurt (code, naam) VALUES (1060302, 'Houtlaan');
INSERT INTO buurt (code, naam) VALUES (1060303, 'Amelterhout');
INSERT INTO buurt (code, naam) VALUES (1060304, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (1060305, 'Vredeveld Noord');
INSERT INTO buurt (code, naam) VALUES (1060306, 'Sluisdennen');
INSERT INTO buurt (code, naam) VALUES (1060307, 'Vredeveld Zuid');
INSERT INTO buurt (code, naam) VALUES (1060308, 'De Dorpen');
INSERT INTO buurt (code, naam) VALUES (1060309, 'GGZ-terrein');
INSERT INTO buurt (code, naam) VALUES (1060310, 'Park Diepstroeten');
INSERT INTO buurt (code, naam) VALUES (1060400, 'Pittelo Zuid');
INSERT INTO buurt (code, naam) VALUES (1060401, 'Pittelo Midden');
INSERT INTO buurt (code, naam) VALUES (1060402, 'Pittelo Noord');
INSERT INTO buurt (code, naam) VALUES (1060403, 'Recreatiepark Pittelo');
INSERT INTO buurt (code, naam) VALUES (1060500, 'De Maten');
INSERT INTO buurt (code, naam) VALUES (1060501, 'De Boskamp');
INSERT INTO buurt (code, naam) VALUES (1060502, 'Baggelhuizen Zuid');
INSERT INTO buurt (code, naam) VALUES (1060503, 'Baggelhuizen Midden');
INSERT INTO buurt (code, naam) VALUES (1060504, 'Baggelhuizen Noord');
INSERT INTO buurt (code, naam) VALUES (1060505, 'Lauwers');
INSERT INTO buurt (code, naam) VALUES (1060506, 'Huize Nassau');
INSERT INTO buurt (code, naam) VALUES (1060507, 'Kazerneterrein');
INSERT INTO buurt (code, naam) VALUES (1060508, 'Westerpark');
INSERT INTO buurt (code, naam) VALUES (1060509, 'Sportpark Stadsbroek');
INSERT INTO buurt (code, naam) VALUES (1060600, 'De Venen/De Wallen');
INSERT INTO buurt (code, naam) VALUES (1060601, 'De Velden/De Stukken');
INSERT INTO buurt (code, naam) VALUES (1060602, 'De Landen/De Akkers');
INSERT INTO buurt (code, naam) VALUES (1060603, 'De Kampen/De Essen');
INSERT INTO buurt (code, naam) VALUES (1060604, 'Peelerpark');
INSERT INTO buurt (code, naam) VALUES (1060700, 'Messchenveld');
INSERT INTO buurt (code, naam) VALUES (1060701, 'De Messchen');
INSERT INTO buurt (code, naam) VALUES (1060702, 'De Hamels');
INSERT INTO buurt (code, naam) VALUES (1060703, 'De Kleuven');
INSERT INTO buurt (code, naam) VALUES (1060704, 'De Dreven');
INSERT INTO buurt (code, naam) VALUES (1060705, 'De Breeën');
INSERT INTO buurt (code, naam) VALUES (1060706, 'De Hoven');
INSERT INTO buurt (code, naam) VALUES (1060707, 'De Heugten');
INSERT INTO buurt (code, naam) VALUES (1060708, 'De Beemden');
INSERT INTO buurt (code, naam) VALUES (1060709, 'De Hullen');
INSERT INTO buurt (code, naam) VALUES (1060710, 'De Stoepen');
INSERT INTO buurt (code, naam) VALUES (1060711, 'De Goorns');
INSERT INTO buurt (code, naam) VALUES (1060712, 'Bedrijventerrein Marsdijk West');
INSERT INTO buurt (code, naam) VALUES (1060713, 'Bedrijventerrein West');
INSERT INTO buurt (code, naam) VALUES (1060714, 'Bedrijventerrein Oost');
INSERT INTO buurt (code, naam) VALUES (1060715, 'Bedrijventerrein Marsdijk Oost');
INSERT INTO buurt (code, naam) VALUES (1060716, 'Havenkanaal Noordzijde');
INSERT INTO buurt (code, naam) VALUES (1060717, 'Havenkanaal Zuidzijde');
INSERT INTO buurt (code, naam) VALUES (1060800, 'Kloosterveste');
INSERT INTO buurt (code, naam) VALUES (1060801, 'Kloostertuinen');
INSERT INTO buurt (code, naam) VALUES (1060802, 'Kloosterhaven');
INSERT INTO buurt (code, naam) VALUES (1060803, 'Kloosterlanen');
INSERT INTO buurt (code, naam) VALUES (1060804, 'Kloosterhoven');
INSERT INTO buurt (code, naam) VALUES (1060805, 'Kloosterstede');
INSERT INTO buurt (code, naam) VALUES (1060806, 'Kloostergaarde');
INSERT INTO buurt (code, naam) VALUES (1060807, 'Kloosterhage');
INSERT INTO buurt (code, naam) VALUES (1060808, 'Kloosterkade');
INSERT INTO buurt (code, naam) VALUES (1060809, 'Sterrenbeeldenbuurt');
INSERT INTO buurt (code, naam) VALUES (1060810, 'Planetenbuurt');
INSERT INTO buurt (code, naam) VALUES (1060811, 'De Zoom');
INSERT INTO buurt (code, naam) VALUES (1060812, 'De Hoogspanning');
INSERT INTO buurt (code, naam) VALUES (1060813, 'Groene Dijk');
INSERT INTO buurt (code, naam) VALUES (1060814, 'Recreatiepark Zeijerveen');
INSERT INTO buurt (code, naam) VALUES (1060815, 'Kloosterhout');
INSERT INTO buurt (code, naam) VALUES (1060816, 'Kloosterbos');
INSERT INTO buurt (code, naam) VALUES (1060817, 'Uitbreidingsgebied Kloosterveen');
INSERT INTO buurt (code, naam) VALUES (1069900, 'Loon');
INSERT INTO buurt (code, naam) VALUES (1069901, 'Verspreide huizen Loon');
INSERT INTO buurt (code, naam) VALUES (1069902, 'Het grote Veld');
INSERT INTO buurt (code, naam) VALUES (1069903, 'Verspreide huizen Ubbena Oost');
INSERT INTO buurt (code, naam) VALUES (1069904, 'Ubbena');
INSERT INTO buurt (code, naam) VALUES (1069905, 'Verspreide huizen Ubbena West');
INSERT INTO buurt (code, naam) VALUES (1069906, 'Rhee');
INSERT INTO buurt (code, naam) VALUES (1069907, 'Verspreide huizen Ter Aard');
INSERT INTO buurt (code, naam) VALUES (1069908, 'Ter Aard');
INSERT INTO buurt (code, naam) VALUES (1069909, 'Zeijerveld');
INSERT INTO buurt (code, naam) VALUES (1069910, 'Bos en Golf');
INSERT INTO buurt (code, naam) VALUES (1069911, 'Verspreide huizen Witten');
INSERT INTO buurt (code, naam) VALUES (1069912, 'Witten');
INSERT INTO buurt (code, naam) VALUES (1069913, 'Graswijkbuurt');
INSERT INTO buurt (code, naam) VALUES (1069914, 'Verspreide huizen Anreep');
INSERT INTO buurt (code, naam) VALUES (1069915, 'Anreep/Schieven');
INSERT INTO buurt (code, naam) VALUES (1069916, 'Verspreide huizen Schieven');
INSERT INTO buurt (code, naam) VALUES (1069917, 'Natuurgebied Amelte');
INSERT INTO buurt (code, naam) VALUES (1091000, 'Coevorden-Centrum');
INSERT INTO buurt (code, naam) VALUES (1091001, 'Lootuinen');
INSERT INTO buurt (code, naam) VALUES (1091002, 'Poppenhare');
INSERT INTO buurt (code, naam) VALUES (1091003, 'Binnenvree Buitenvree Pikveld');
INSERT INTO buurt (code, naam) VALUES (1091004, 'De Heege');
INSERT INTO buurt (code, naam) VALUES (1091006, 'Klooster');
INSERT INTO buurt (code, naam) VALUES (1091007, 'Ballast');
INSERT INTO buurt (code, naam) VALUES (1091008, 'De Loo');
INSERT INTO buurt (code, naam) VALUES (1091009, 'Verspreide huizen Coevorden');
INSERT INTO buurt (code, naam) VALUES (1091010, 'Holwert');
INSERT INTO buurt (code, naam) VALUES (1091011, 'Hare');
INSERT INTO buurt (code, naam) VALUES (1091012, 'Leeuwerikenveld');
INSERT INTO buurt (code, naam) VALUES (1091013, 'De Heege en De Mars');
INSERT INTO buurt (code, naam) VALUES (1091014, 'Klinkenvlier');
INSERT INTO buurt (code, naam) VALUES (1091015, 'Ossehaar');
INSERT INTO buurt (code, naam) VALUES (1091116, 'Steenwijksmoer');
INSERT INTO buurt (code, naam) VALUES (1091117, 'Verspreide huizen Steenwijksmoer');
INSERT INTO buurt (code, naam) VALUES (1091218, 'Nieuwe Krim');
INSERT INTO buurt (code, naam) VALUES (1091219, 'Verspreide huizen Nieuwe Krim');
INSERT INTO buurt (code, naam) VALUES (1091320, 'Verspreide huizen Weijerswold');
INSERT INTO buurt (code, naam) VALUES (1091421, 'Verspreide huizen Vlieghuis en Padhuis');
INSERT INTO buurt (code, naam) VALUES (1092022, 'Dalen');
INSERT INTO buurt (code, naam) VALUES (1092023, 'Verspreide huizen Dalen');
INSERT INTO buurt (code, naam) VALUES (1092024, 'Wachtum');
INSERT INTO buurt (code, naam) VALUES (1092025, 'Verspreide huizen Wachtum');
INSERT INTO buurt (code, naam) VALUES (1092026, 'Dalerpeel');
INSERT INTO buurt (code, naam) VALUES (1092027, 'Verspreide huizen Dalerpeel');
INSERT INTO buurt (code, naam) VALUES (1092028, 'Dalerveen');
INSERT INTO buurt (code, naam) VALUES (1092029, 'Verspreide huizen Dalerveen');
INSERT INTO buurt (code, naam) VALUES (1092030, 'Stieltjeskanaal');
INSERT INTO buurt (code, naam) VALUES (1092031, 'Verspreide huizen Stieltjeskanaal');
INSERT INTO buurt (code, naam) VALUES (1093032, 'Oosterhesselen');
INSERT INTO buurt (code, naam) VALUES (1093033, 'Verspreide huizen Oosterhesselen');
INSERT INTO buurt (code, naam) VALUES (1093034, 'Gees');
INSERT INTO buurt (code, naam) VALUES (1093035, 'Verspreide huizen Gees');
INSERT INTO buurt (code, naam) VALUES (1093036, 'Zwinderen');
INSERT INTO buurt (code, naam) VALUES (1093037, 'Verspreide huizen Zwinderen');
INSERT INTO buurt (code, naam) VALUES (1093038, 'Geesbrug');
INSERT INTO buurt (code, naam) VALUES (1093039, 'Verspreide huizen Geesbrug');
INSERT INTO buurt (code, naam) VALUES (1093068, 'Verspreide huizen Nieuwlande');
INSERT INTO buurt (code, naam) VALUES (1094040, 'Sleen');
INSERT INTO buurt (code, naam) VALUES (1094041, 'Diphoorn');
INSERT INTO buurt (code, naam) VALUES (1094042, 'Verspreide huizen Sleen');
INSERT INTO buurt (code, naam) VALUES (1094043, 'Noord-Sleen');
INSERT INTO buurt (code, naam) VALUES (1094044, '''t Haantje');
INSERT INTO buurt (code, naam) VALUES (1094045, 'Verspreide huizen ''t Haantje');
INSERT INTO buurt (code, naam) VALUES (1094046, 'Verspreide huizen Noord-Sleen');
INSERT INTO buurt (code, naam) VALUES (1094047, 'Schoonoord');
INSERT INTO buurt (code, naam) VALUES (1094048, 'De Kiel');
INSERT INTO buurt (code, naam) VALUES (1094049, 'Verspreide huizen De Kiel');
INSERT INTO buurt (code, naam) VALUES (1094050, 'Verspreide huizen Kibbelveen');
INSERT INTO buurt (code, naam) VALUES (1094051, 'Verspreide huizen Schoonoord');
INSERT INTO buurt (code, naam) VALUES (1094052, 'Verspreide huizen Veenoord');
INSERT INTO buurt (code, naam) VALUES (1094053, 'Erm');
INSERT INTO buurt (code, naam) VALUES (1094054, 'Achterste Erm');
INSERT INTO buurt (code, naam) VALUES (1094055, 'Holsloot');
INSERT INTO buurt (code, naam) VALUES (1094056, 'Verspreide huizen Holsloot');
INSERT INTO buurt (code, naam) VALUES (1094057, 'Verspreide huizen Elm');
INSERT INTO buurt (code, naam) VALUES (1095058, 'Zweeloo');
INSERT INTO buurt (code, naam) VALUES (1095059, 'Aalden');
INSERT INTO buurt (code, naam) VALUES (1095060, 'Verspreide huizen Zweeloo');
INSERT INTO buurt (code, naam) VALUES (1095061, 'Meppen');
INSERT INTO buurt (code, naam) VALUES (1095062, 'Verspreide huizen Meppen');
INSERT INTO buurt (code, naam) VALUES (1095063, 'Wezup');
INSERT INTO buurt (code, naam) VALUES (1095064, 'Wezuperbrug');
INSERT INTO buurt (code, naam) VALUES (1095065, 'Benneveld');
INSERT INTO buurt (code, naam) VALUES (1095066, 'Verspreide huizen Benneveld');
INSERT INTO buurt (code, naam) VALUES (1095067, 'Verspreide huizen Wezuperbrug');
INSERT INTO buurt (code, naam) VALUES (1140100, '3e Kruisdiep');
INSERT INTO buurt (code, naam) VALUES (1140101, '1e Kruisdiep');
INSERT INTO buurt (code, naam) VALUES (1140102, 'Tramwijk');
INSERT INTO buurt (code, naam) VALUES (1140103, 'Achterdiep');
INSERT INTO buurt (code, naam) VALUES (1140104, 'Weerdingerkanaal');
INSERT INTO buurt (code, naam) VALUES (1140106, 'Siepelveen');
INSERT INTO buurt (code, naam) VALUES (1140109, 'Verspreide huizen Nieuw-Weerdinge');
INSERT INTO buurt (code, naam) VALUES (1140200, 'Roswinkel-Centrum');
INSERT INTO buurt (code, naam) VALUES (1140206, 'Oude Schuttingskanaal');
INSERT INTO buurt (code, naam) VALUES (1140208, 'Roswinkelerstraat');
INSERT INTO buurt (code, naam) VALUES (1140209, 'Verspreide huizen Roswinkel');
INSERT INTO buurt (code, naam) VALUES (1140300, 'Emmer-Compascuum Centrum');
INSERT INTO buurt (code, naam) VALUES (1140301, 'Emmer-Erfscheidenveen');
INSERT INTO buurt (code, naam) VALUES (1140302, 'Foxel');
INSERT INTO buurt (code, naam) VALUES (1140303, 'Oosterdiep');
INSERT INTO buurt (code, naam) VALUES (1140304, 'Hoofdkanaal');
INSERT INTO buurt (code, naam) VALUES (1140309, 'Verspreide huizen Emmer-Compascuum');
INSERT INTO buurt (code, naam) VALUES (1140400, 'Barger-Compascuum-Centrum');
INSERT INTO buurt (code, naam) VALUES (1140401, 'Scholtenskanaal');
INSERT INTO buurt (code, naam) VALUES (1140402, 'Verlengde-Oosterdiep');
INSERT INTO buurt (code, naam) VALUES (1140408, 'Limietweg');
INSERT INTO buurt (code, naam) VALUES (1140409, 'Verspreide huizen Barger-Compascuum');
INSERT INTO buurt (code, naam) VALUES (1140500, 'Nieuw-Dordrecht');
INSERT INTO buurt (code, naam) VALUES (1140502, 'Oranjedorp');
INSERT INTO buurt (code, naam) VALUES (1140503, 'Vastenow');
INSERT INTO buurt (code, naam) VALUES (1140504, 'Herenstreek');
INSERT INTO buurt (code, naam) VALUES (1140509, 'Verspreide huizen Nieuw-Dordrecht');
INSERT INTO buurt (code, naam) VALUES (1140600, 'Nieuw-Amsterdam-Centrum');
INSERT INTO buurt (code, naam) VALUES (1140601, 'Barger-Erfscheidenveen');
INSERT INTO buurt (code, naam) VALUES (1140608, 'Langs de Vaart');
INSERT INTO buurt (code, naam) VALUES (1140609, 'Verspreide huizen Nieuw-Amsterdam');
INSERT INTO buurt (code, naam) VALUES (1140700, 'Erica-Centrum');
INSERT INTO buurt (code, naam) VALUES (1140701, 'Amsterdamscheveld');
INSERT INTO buurt (code, naam) VALUES (1140702, 'Beekweg');
INSERT INTO buurt (code, naam) VALUES (1140707, 'Verlengde Vaart');
INSERT INTO buurt (code, naam) VALUES (1140708, 'Ericasestraat');
INSERT INTO buurt (code, naam) VALUES (1140709, 'Verspreide huizen Erica');
INSERT INTO buurt (code, naam) VALUES (1140800, 'Klazienaveen-Noord');
INSERT INTO buurt (code, naam) VALUES (1140801, 'Klazienaveen-Zuid');
INSERT INTO buurt (code, naam) VALUES (1140802, 'Barger-Oosterveen');
INSERT INTO buurt (code, naam) VALUES (1140803, 'Kloostermanswijk');
INSERT INTO buurt (code, naam) VALUES (1140804, 'Dordse Dijk');
INSERT INTO buurt (code, naam) VALUES (1140806, 'Derksweg');
INSERT INTO buurt (code, naam) VALUES (1140807, 'Tuinbouwcentrum Klazienaveen');
INSERT INTO buurt (code, naam) VALUES (1140809, 'Verspreide huizen Klazienaveen');
INSERT INTO buurt (code, naam) VALUES (1140900, 'Zwartemeer-Centrum');
INSERT INTO buurt (code, naam) VALUES (1140901, 'Kamerlingswijk');
INSERT INTO buurt (code, naam) VALUES (1140909, 'Verspreide huizen Zwartemeer');
INSERT INTO buurt (code, naam) VALUES (1141000, 'Schoonebeek');
INSERT INTO buurt (code, naam) VALUES (1141001, 'Oosterse Bos en Middendorp');
INSERT INTO buurt (code, naam) VALUES (1141002, 'Westerse Bos');
INSERT INTO buurt (code, naam) VALUES (1141003, 'Zandpol');
INSERT INTO buurt (code, naam) VALUES (1141004, 'Industrieterrein De Vierslagen');
INSERT INTO buurt (code, naam) VALUES (1141009, 'Verspreide huizen Schoonebeek');
INSERT INTO buurt (code, naam) VALUES (1141300, 'Veenoord');
INSERT INTO buurt (code, naam) VALUES (1141308, 'Ermerveen');
INSERT INTO buurt (code, naam) VALUES (1141309, 'Verspreide huizen Veenoord');
INSERT INTO buurt (code, naam) VALUES (1142100, 'Nieuw-Schoonebeek');
INSERT INTO buurt (code, naam) VALUES (1142101, 'Westelijk Nieuw-Schoonebeek');
INSERT INTO buurt (code, naam) VALUES (1142102, 'Oostelijk Nieuw-Schoonebeek');
INSERT INTO buurt (code, naam) VALUES (1142109, 'Verspreide huizen Nieuw-Schoonebeek');
INSERT INTO buurt (code, naam) VALUES (1143200, 'Weiteveen');
INSERT INTO buurt (code, naam) VALUES (1143201, 'Oost- en West-Weiteveen');
INSERT INTO buurt (code, naam) VALUES (1143209, 'Verspreide huizen Weiteveen');
INSERT INTO buurt (code, naam) VALUES (1144000, 'Emmen Centrum');
INSERT INTO buurt (code, naam) VALUES (1144100, 'Emmen-Omgeving Oude Roswinkelerweg');
INSERT INTO buurt (code, naam) VALUES (1144101, 'Emmen over het spoor');
INSERT INTO buurt (code, naam) VALUES (1144200, 'Emmermeer');
INSERT INTO buurt (code, naam) VALUES (1144300, 'Angelslo');
INSERT INTO buurt (code, naam) VALUES (1144400, 'Emmerhout');
INSERT INTO buurt (code, naam) VALUES (1144500, 'Emmerschans');
INSERT INTO buurt (code, naam) VALUES (1144600, 'Bargeres');
INSERT INTO buurt (code, naam) VALUES (1144700, 'Rietlanden');
INSERT INTO buurt (code, naam) VALUES (1144800, 'Parc Sandur');
INSERT INTO buurt (code, naam) VALUES (1144900, 'Delftlanden');
INSERT INTO buurt (code, naam) VALUES (1145000, 'Barger-Oosterveld');
INSERT INTO buurt (code, naam) VALUES (1145100, 'Weerdinge');
INSERT INTO buurt (code, naam) VALUES (1145101, 'Westenesch');
INSERT INTO buurt (code, naam) VALUES (1145109, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (1145200, 'Noordbarge');
INSERT INTO buurt (code, naam) VALUES (1145201, 'Zuidbarge');
INSERT INTO buurt (code, naam) VALUES (1145300, 'Industrieterrein Bargermeer');
INSERT INTO buurt (code, naam) VALUES (1145301, 'Bedrijvenpark A37');
INSERT INTO buurt (code, naam) VALUES (1185000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (1185001, 'Noord');
INSERT INTO buurt (code, naam) VALUES (1185002, 'Bentinckspark');
INSERT INTO buurt (code, naam) VALUES (1185003, 'Krakeel');
INSERT INTO buurt (code, naam) VALUES (1185004, 'Wolfsbos');
INSERT INTO buurt (code, naam) VALUES (1185005, 'Zuid');
INSERT INTO buurt (code, naam) VALUES (1185006, 'Venesluis');
INSERT INTO buurt (code, naam) VALUES (1185007, 'West');
INSERT INTO buurt (code, naam) VALUES (1185008, 'Oost');
INSERT INTO buurt (code, naam) VALUES (1185100, 'Steenbergerweiden');
INSERT INTO buurt (code, naam) VALUES (1185101, 'Kinholt');
INSERT INTO buurt (code, naam) VALUES (1185102, 'Grittenhof');
INSERT INTO buurt (code, naam) VALUES (1185103, 'Schoonvelde-West');
INSERT INTO buurt (code, naam) VALUES (1185104, 'Schoonvelde-Oost');
INSERT INTO buurt (code, naam) VALUES (1185105, 'Schutlanden-Oost');
INSERT INTO buurt (code, naam) VALUES (1185106, 'Schutlanden-West');
INSERT INTO buurt (code, naam) VALUES (1185107, 'Kattouw');
INSERT INTO buurt (code, naam) VALUES (1185108, 'Trasselt');
INSERT INTO buurt (code, naam) VALUES (1185109, 'Erflanden');
INSERT INTO buurt (code, naam) VALUES (1185200, 'Fluitenberg kern');
INSERT INTO buurt (code, naam) VALUES (1185201, 'Verspreide huizen Fluitenberg');
INSERT INTO buurt (code, naam) VALUES (1185300, 'Elim Kern');
INSERT INTO buurt (code, naam) VALUES (1185301, 'Verspreide huizen Elim-Noord');
INSERT INTO buurt (code, naam) VALUES (1185302, 'Verspreide huizen Elim-Zuid');
INSERT INTO buurt (code, naam) VALUES (1185400, 'Hollandscheveld kern');
INSERT INTO buurt (code, naam) VALUES (1185401, 'Verspreide huizen Hollandscheveld-West');
INSERT INTO buurt (code, naam) VALUES (1185402, 'Verspreide huizen Hollandscheveld-Oost');
INSERT INTO buurt (code, naam) VALUES (1185500, 'Noordscheschut kern');
INSERT INTO buurt (code, naam) VALUES (1185501, 'Verspreide huizen Noordscheschut');
INSERT INTO buurt (code, naam) VALUES (1185600, 'Nieuwlande kern');
INSERT INTO buurt (code, naam) VALUES (1185601, 'Verspreide huizen Nieuwlande');
INSERT INTO buurt (code, naam) VALUES (1185700, 'Nieuweroord kern');
INSERT INTO buurt (code, naam) VALUES (1185701, 'Verspreide huizen Nieuweroord');
INSERT INTO buurt (code, naam) VALUES (1185800, 'Tiendeveen kern');
INSERT INTO buurt (code, naam) VALUES (1185801, 'Verspreide huizen Tiendeveen');
INSERT INTO buurt (code, naam) VALUES (1185900, 'Stuifzand kern');
INSERT INTO buurt (code, naam) VALUES (1185901, 'Verspreide huizen Stuifzand');
INSERT INTO buurt (code, naam) VALUES (1186000, 'Pesse kern');
INSERT INTO buurt (code, naam) VALUES (1186001, 'Verspreide huizen Pesse-Oost');
INSERT INTO buurt (code, naam) VALUES (1186002, 'Verspreide huizen Pesse-West');
INSERT INTO buurt (code, naam) VALUES (1186003, 'Verspreide huizen Pesse-Zuid');
INSERT INTO buurt (code, naam) VALUES (1186100, 'Zuideropgaande Nieuw Moscou');
INSERT INTO buurt (code, naam) VALUES (1186201, 'Industriegebied Toldijk');
INSERT INTO buurt (code, naam) VALUES (1186202, 'Industriegebied Noord A');
INSERT INTO buurt (code, naam) VALUES (1186203, 'Industriegebied Noord B');
INSERT INTO buurt (code, naam) VALUES (1186204, 'Industriegebied Buitenvaart');
INSERT INTO buurt (code, naam) VALUES (1186205, 'Verspreide huizen Alteveer');
INSERT INTO buurt (code, naam) VALUES (1186206, 'Verspreide huizen Nijstad');
INSERT INTO buurt (code, naam) VALUES (1190000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (1190001, 'Watertoren');
INSERT INTO buurt (code, naam) VALUES (1190002, 'Haveltermade');
INSERT INTO buurt (code, naam) VALUES (1190003, 'Koedijkslanden');
INSERT INTO buurt (code, naam) VALUES (1190004, 'Ezinge');
INSERT INTO buurt (code, naam) VALUES (1190005, 'Oosterboer');
INSERT INTO buurt (code, naam) VALUES (1190006, 'Industrieterrein Oevers en omgeving');
INSERT INTO buurt (code, naam) VALUES (1190007, 'Industrieterrein-Noord');
INSERT INTO buurt (code, naam) VALUES (1190008, 'Bedrijvenpark Blankenstein');
INSERT INTO buurt (code, naam) VALUES (1190009, 'Verspreide huizen Meppel');
INSERT INTO buurt (code, naam) VALUES (1190010, 'Berggierslanden');
INSERT INTO buurt (code, naam) VALUES (1190100, 'Kern Nijeveen');
INSERT INTO buurt (code, naam) VALUES (1190101, 'Nijeveen-Oost');
INSERT INTO buurt (code, naam) VALUES (1190102, 'Kolderveen');
INSERT INTO buurt (code, naam) VALUES (1190103, 'Kolderveense Bovenboer');
INSERT INTO buurt (code, naam) VALUES (1190104, 'Nijeveense Bovenboer');
INSERT INTO buurt (code, naam) VALUES (1190109, 'Verspreide huizen Nijeveen');
INSERT INTO buurt (code, naam) VALUES (1190200, 'Kern Rogat');
INSERT INTO buurt (code, naam) VALUES (1190209, 'Verspreide huizen Rogat');
INSERT INTO buurt (code, naam) VALUES (1400000, 'Wommels');
INSERT INTO buurt (code, naam) VALUES (1400001, 'Easterein');
INSERT INTO buurt (code, naam) VALUES (1400002, 'Hinnaard');
INSERT INTO buurt (code, naam) VALUES (1400003, 'Itens');
INSERT INTO buurt (code, naam) VALUES (1400004, 'Rien');
INSERT INTO buurt (code, naam) VALUES (1400005, 'Lytsewierrum');
INSERT INTO buurt (code, naam) VALUES (1400006, 'Hidaard');
INSERT INTO buurt (code, naam) VALUES (1400007, 'Reahûs');
INSERT INTO buurt (code, naam) VALUES (1400008, 'Verspreide huizen Wommels');
INSERT INTO buurt (code, naam) VALUES (1400009, 'Verspreide huizen Easterein');
INSERT INTO buurt (code, naam) VALUES (1400100, 'Wjelsryp');
INSERT INTO buurt (code, naam) VALUES (1400101, 'Baaium');
INSERT INTO buurt (code, naam) VALUES (1400102, 'Spannum');
INSERT INTO buurt (code, naam) VALUES (1400103, 'Iens');
INSERT INTO buurt (code, naam) VALUES (1400104, 'Kûbaard');
INSERT INTO buurt (code, naam) VALUES (1400105, 'Waaksens');
INSERT INTO buurt (code, naam) VALUES (1400107, 'Verspreide huizen Wjelsryp');
INSERT INTO buurt (code, naam) VALUES (1400108, 'Verspreide huizen Spannum');
INSERT INTO buurt (code, naam) VALUES (1400109, 'Verspreide huizen Kûbaard');
INSERT INTO buurt (code, naam) VALUES (1400200, 'Mantgum');
INSERT INTO buurt (code, naam) VALUES (1400209, 'Verspreide huizen Mantgum');
INSERT INTO buurt (code, naam) VALUES (1400300, 'Baard');
INSERT INTO buurt (code, naam) VALUES (1400301, 'Easterlittens');
INSERT INTO buurt (code, naam) VALUES (1400302, 'Winsum');
INSERT INTO buurt (code, naam) VALUES (1400303, 'Britswert');
INSERT INTO buurt (code, naam) VALUES (1400304, 'Wiuwert');
INSERT INTO buurt (code, naam) VALUES (1400305, 'Boazum');
INSERT INTO buurt (code, naam) VALUES (1400306, 'Easterwierrum');
INSERT INTO buurt (code, naam) VALUES (1400307, 'Verspreide huizen Easterlittens');
INSERT INTO buurt (code, naam) VALUES (1400308, 'Verspreide huizen Winsum');
INSERT INTO buurt (code, naam) VALUES (1400309, 'Verspreide huizen Boazum');
INSERT INTO buurt (code, naam) VALUES (1400400, 'Weidum');
INSERT INTO buurt (code, naam) VALUES (1400401, 'Jellum');
INSERT INTO buurt (code, naam) VALUES (1400402, 'Bears');
INSERT INTO buurt (code, naam) VALUES (1400403, 'Jorwert');
INSERT INTO buurt (code, naam) VALUES (1400404, 'Hilaard');
INSERT INTO buurt (code, naam) VALUES (1400405, 'Húns');
INSERT INTO buurt (code, naam) VALUES (1400406, 'Leons');
INSERT INTO buurt (code, naam) VALUES (1400407, 'Verspreide huizen Weidum');
INSERT INTO buurt (code, naam) VALUES (1400408, 'Verspreide huizen Jorwert');
INSERT INTO buurt (code, naam) VALUES (1400409, 'Verspreide huizen Hilaard');
INSERT INTO buurt (code, naam) VALUES (1411000, 'Binnenstad-Noord');
INSERT INTO buurt (code, naam) VALUES (1411001, 'Binnenstad-Zuid');
INSERT INTO buurt (code, naam) VALUES (1411002, 'Ulk en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411003, 'Java en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411100, 'Bornsestraat en omgeving Midden');
INSERT INTO buurt (code, naam) VALUES (1411101, 'Riet Noord');
INSERT INTO buurt (code, naam) VALUES (1411102, 'Arendsboer en omgeving Noord');
INSERT INTO buurt (code, naam) VALUES (1411103, 'Nieuwland');
INSERT INTO buurt (code, naam) VALUES (1411104, 'Arendsboer en omgeving Zuid');
INSERT INTO buurt (code, naam) VALUES (1411105, 'Riet Zuid');
INSERT INTO buurt (code, naam) VALUES (1411106, 'Bornsestraat en omgeving Zuid');
INSERT INTO buurt (code, naam) VALUES (1411109, 'Verspreide huizen wijk 11');
INSERT INTO buurt (code, naam) VALUES (1411200, 'Vriezenveenseweg en omgeving Haghoek Oost');
INSERT INTO buurt (code, naam) VALUES (1411201, 'Parkweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411202, 'Vriezenveenseweg en omgeving Haghoek West');
INSERT INTO buurt (code, naam) VALUES (1411209, 'Verspreide huizen wijk 12');
INSERT INTO buurt (code, naam) VALUES (1411300, 'Ootmarsumsestraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411301, 'Markgraven');
INSERT INTO buurt (code, naam) VALUES (1411302, 'Rumerslanden');
INSERT INTO buurt (code, naam) VALUES (1411303, 'Wester-Sluitersveldlanden');
INSERT INTO buurt (code, naam) VALUES (1411309, 'Verspreide huizen wijk 13');
INSERT INTO buurt (code, naam) VALUES (1411400, 'Dijkstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411401, 'Rohof en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411402, 'Kerkelanden');
INSERT INTO buurt (code, naam) VALUES (1411403, 'Aalderinkshoek Noordoost');
INSERT INTO buurt (code, naam) VALUES (1411404, 'Aalderinkshoek Zuidoost');
INSERT INTO buurt (code, naam) VALUES (1411405, 'Aalderinkshoek Noordwest');
INSERT INTO buurt (code, naam) VALUES (1411406, 'Aalderinkshoek Zuidwest');
INSERT INTO buurt (code, naam) VALUES (1411409, 'Verspreide huizen wijk 14');
INSERT INTO buurt (code, naam) VALUES (1411500, 'Nieuwstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411501, 'Wonde en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411502, 'Witvoet en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411503, 'Achterlanden en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411600, 'Boomplaats');
INSERT INTO buurt (code, naam) VALUES (1411601, 'Ossenkoppelerhoek-Oost');
INSERT INTO buurt (code, naam) VALUES (1411602, 'Beeklust');
INSERT INTO buurt (code, naam) VALUES (1411603, 'Ossenkoppelerhoek-Midden-Noord');
INSERT INTO buurt (code, naam) VALUES (1411604, 'Ossenkoppelerhoek-West');
INSERT INTO buurt (code, naam) VALUES (1411605, 'Ossenkoppelerhoek-Midden-Zuid');
INSERT INTO buurt (code, naam) VALUES (1411700, 'Hofkamp-West');
INSERT INTO buurt (code, naam) VALUES (1411701, 'Hofkamp-Oost');
INSERT INTO buurt (code, naam) VALUES (1411702, 'Paradijs');
INSERT INTO buurt (code, naam) VALUES (1411703, 'Kollenveld-Bolkshoek');
INSERT INTO buurt (code, naam) VALUES (1411709, 'Verspreide huizen Hofkamp');
INSERT INTO buurt (code, naam) VALUES (1411800, 'Schelfhorst-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (1411801, 'Drakensteyn en omgeving');
INSERT INTO buurt (code, naam) VALUES (1411802, 'Schelfhorst-Noordwest');
INSERT INTO buurt (code, naam) VALUES (1411803, 'Havezathe');
INSERT INTO buurt (code, naam) VALUES (1411804, 'Schelfhorst-Noordoost');
INSERT INTO buurt (code, naam) VALUES (1411805, 'Schelfhorst-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (1411806, 'Veenelanden');
INSERT INTO buurt (code, naam) VALUES (1411900, 'Groeneveld');
INSERT INTO buurt (code, naam) VALUES (1411901, 'Kanaalzijde');
INSERT INTO buurt (code, naam) VALUES (1411902, 'Leemslagen-Noord');
INSERT INTO buurt (code, naam) VALUES (1411903, 'Leemslagen-Zuid');
INSERT INTO buurt (code, naam) VALUES (1411904, 'Zeven Bosjes');
INSERT INTO buurt (code, naam) VALUES (1411905, 'Leemslagen-Oost');
INSERT INTO buurt (code, naam) VALUES (1411906, 'Huttenveld');
INSERT INTO buurt (code, naam) VALUES (1411907, 'Maardijk');
INSERT INTO buurt (code, naam) VALUES (1411908, 'De Grens');
INSERT INTO buurt (code, naam) VALUES (1411909, 'Nijrees');
INSERT INTO buurt (code, naam) VALUES (1411910, 'Verspreide huizen wijk 19');
INSERT INTO buurt (code, naam) VALUES (1412000, 'Aadorp-West');
INSERT INTO buurt (code, naam) VALUES (1412001, 'Aadorp-Oost');
INSERT INTO buurt (code, naam) VALUES (1412002, 'Bedrijvenpark Twente');
INSERT INTO buurt (code, naam) VALUES (1412009, 'Verspreide huizen wijk 20');
INSERT INTO buurt (code, naam) VALUES (1412100, 'Bornerbroek');
INSERT INTO buurt (code, naam) VALUES (1412109, 'Verspreide huizen wijk 21');
INSERT INTO buurt (code, naam) VALUES (1470000, 'Bornsche Maten');
INSERT INTO buurt (code, naam) VALUES (1470001, 'Borne Centrum');
INSERT INTO buurt (code, naam) VALUES (1470002, '''t Wensink Noord');
INSERT INTO buurt (code, naam) VALUES (1470003, '''t Wensink Zuid');
INSERT INTO buurt (code, naam) VALUES (1470004, 'Dikkerslaan-Molenkampsweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (1470005, 'Lettersveld I');
INSERT INTO buurt (code, naam) VALUES (1470006, 'Lettersveld II');
INSERT INTO buurt (code, naam) VALUES (1470007, 'Tichelkamp');
INSERT INTO buurt (code, naam) VALUES (1470008, 'Stroom-Esch');
INSERT INTO buurt (code, naam) VALUES (1470009, 'Verspreide huizen Borne-West');
INSERT INTO buurt (code, naam) VALUES (1470100, 'Verspreide huizen Borne-Oost');
INSERT INTO buurt (code, naam) VALUES (1470101, 'Zenderen');
INSERT INTO buurt (code, naam) VALUES (1470102, 'Verspreide huizen Zenderen');
INSERT INTO buurt (code, naam) VALUES (1470105, 'Hertme');
INSERT INTO buurt (code, naam) VALUES (1470106, 'Verspreide huizen Hertme');
INSERT INTO buurt (code, naam) VALUES (1480000, 'Dalfsen-Kom');
INSERT INTO buurt (code, naam) VALUES (1480001, 'Dalfsen-Vechtvliet');
INSERT INTO buurt (code, naam) VALUES (1480002, 'Dalfsen-Rondweg');
INSERT INTO buurt (code, naam) VALUES (1480003, 'Dalfsen-Pleijendal');
INSERT INTO buurt (code, naam) VALUES (1480004, 'Dalfsen-Leemcule');
INSERT INTO buurt (code, naam) VALUES (1480005, 'Dalfsen-Polhaar-Oost');
INSERT INTO buurt (code, naam) VALUES (1480006, 'Dalfsen-Polhaar-West');
INSERT INTO buurt (code, naam) VALUES (1480007, 'Dalfsen-Ankummer-Es I');
INSERT INTO buurt (code, naam) VALUES (1480008, 'Dalfsen-Ankummer-Es II');
INSERT INTO buurt (code, naam) VALUES (1480009, 'De Gerner Marke');
INSERT INTO buurt (code, naam) VALUES (1480100, 'Ankum-Kern');
INSERT INTO buurt (code, naam) VALUES (1480104, 'Verspreide huizen Ankum');
INSERT INTO buurt (code, naam) VALUES (1480105, 'Verspreide huizen Dalfserveld');
INSERT INTO buurt (code, naam) VALUES (1480106, 'Verspreide huizen Gerner-Welsum');
INSERT INTO buurt (code, naam) VALUES (1480107, 'Verspreide huizen Rechteren-Hessum');
INSERT INTO buurt (code, naam) VALUES (1480108, 'Verspreide huizen Milligen');
INSERT INTO buurt (code, naam) VALUES (1480109, 'Verspreide huizen Emmen-De Marshoek');
INSERT INTO buurt (code, naam) VALUES (1480200, 'Oudleusen kern');
INSERT INTO buurt (code, naam) VALUES (1480209, 'Verspreide huizen Oudleusenerveld');
INSERT INTO buurt (code, naam) VALUES (1480300, 'Hoonhorst kern');
INSERT INTO buurt (code, naam) VALUES (1480309, 'Verspreide huizen Lenthe');
INSERT INTO buurt (code, naam) VALUES (1480409, 'Verspreide huizen Lenthe-2');
INSERT INTO buurt (code, naam) VALUES (1480509, 'Verspreide huizen Kluinhaar');
INSERT INTO buurt (code, naam) VALUES (1480600, 'Lemelerveld kern');
INSERT INTO buurt (code, naam) VALUES (1480606, 'Miga, ''t Zwarte, Koelen en Schanebroek 1');
INSERT INTO buurt (code, naam) VALUES (1480607, 'Schanebroek 2 en Wolthaarshoek');
INSERT INTO buurt (code, naam) VALUES (1480608, 'Verspreide huizen Strenkhaar');
INSERT INTO buurt (code, naam) VALUES (1480609, 'Verspreide huizen Dalmsholte');
INSERT INTO buurt (code, naam) VALUES (1480700, 'Nieuwleusen-Zuid');
INSERT INTO buurt (code, naam) VALUES (1480701, 'Nieuwleusen-Noord');
INSERT INTO buurt (code, naam) VALUES (1480705, 'Verspreide huizen Nieuwleusen-Zuid (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (1480706, 'Verspreide huizen Nieuwleusen-Noord (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (1480707, 'Verspreide huizen Ruitenveen');
INSERT INTO buurt (code, naam) VALUES (1480708, 'Verspreide huizen De Meele');
INSERT INTO buurt (code, naam) VALUES (1480709, 'Veenekampen-De Ruiten');
INSERT INTO buurt (code, naam) VALUES (1500101, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (1500102, 'Bergkwartier');
INSERT INTO buurt (code, naam) VALUES (1500103, 'Noordenbergkwartier');
INSERT INTO buurt (code, naam) VALUES (1500104, 'Noordenbergsingel');
INSERT INTO buurt (code, naam) VALUES (1500105, 'Singel');
INSERT INTO buurt (code, naam) VALUES (1500106, 'Raambuurt');
INSERT INTO buurt (code, naam) VALUES (1500107, 'Knutteldorp');
INSERT INTO buurt (code, naam) VALUES (1500201, 'De Hoven');
INSERT INTO buurt (code, naam) VALUES (1500301, 'Noorderplein');
INSERT INTO buurt (code, naam) VALUES (1500302, 'Zwolseweg');
INSERT INTO buurt (code, naam) VALUES (1500303, 'Lange Zandstraat');
INSERT INTO buurt (code, naam) VALUES (1500304, 'Zandweerd-Zuid');
INSERT INTO buurt (code, naam) VALUES (1500305, 'Zandweerd-Noord');
INSERT INTO buurt (code, naam) VALUES (1500306, 'Schrijversbuurt');
INSERT INTO buurt (code, naam) VALUES (1500401, 'Rode Dorp');
INSERT INTO buurt (code, naam) VALUES (1500402, 'Oudegoedstraat');
INSERT INTO buurt (code, naam) VALUES (1500403, 'Burgemeestersbuurt');
INSERT INTO buurt (code, naam) VALUES (1500404, 'Oosterstraat');
INSERT INTO buurt (code, naam) VALUES (1500405, 'Rielerweg-West');
INSERT INTO buurt (code, naam) VALUES (1500406, 'Rielerweg-Oost');
INSERT INTO buurt (code, naam) VALUES (1500407, 'Brinkgreven');
INSERT INTO buurt (code, naam) VALUES (1500501, 'Borgele');
INSERT INTO buurt (code, naam) VALUES (1500502, 'Platvoet');
INSERT INTO buurt (code, naam) VALUES (1500601, 'Ludgeruskwartier');
INSERT INTO buurt (code, naam) VALUES (1500602, 'Tuindorp');
INSERT INTO buurt (code, naam) VALUES (1500603, 'Rollecatekwartier');
INSERT INTO buurt (code, naam) VALUES (1500604, 'Oranjekwartier');
INSERT INTO buurt (code, naam) VALUES (1500605, 'Landsherenkwartier');
INSERT INTO buurt (code, naam) VALUES (1500701, 'Rivierenbuurt');
INSERT INTO buurt (code, naam) VALUES (1500702, 'Deltabuurt');
INSERT INTO buurt (code, naam) VALUES (1500703, 'Hoornwerk');
INSERT INTO buurt (code, naam) VALUES (1500704, 'Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (1500705, 'Kloosterlanden');
INSERT INTO buurt (code, naam) VALUES (1500706, 'Epse-Noord');
INSERT INTO buurt (code, naam) VALUES (1500801, 'Het Oostrik');
INSERT INTO buurt (code, naam) VALUES (1500802, 'Groot Douwel');
INSERT INTO buurt (code, naam) VALUES (1500803, 'Blauwenoord');
INSERT INTO buurt (code, naam) VALUES (1500901, 'Op den Haar');
INSERT INTO buurt (code, naam) VALUES (1500902, 'Steinvoorde');
INSERT INTO buurt (code, naam) VALUES (1500903, 'Graveland');
INSERT INTO buurt (code, naam) VALUES (1500904, 'Het Jeurlink');
INSERT INTO buurt (code, naam) VALUES (1500905, 'Het Fetlaer en Spijkvoorder Enk');
INSERT INTO buurt (code, naam) VALUES (1500906, 'Spikvoorde');
INSERT INTO buurt (code, naam) VALUES (1500907, 'Overig Colmschate-Noord');
INSERT INTO buurt (code, naam) VALUES (1501001, 'Snipperling');
INSERT INTO buurt (code, naam) VALUES (1501002, 'Dorp Colmschate');
INSERT INTO buurt (code, naam) VALUES (1501003, 'De Scheg');
INSERT INTO buurt (code, naam) VALUES (1501004, 'Colmschaterenk');
INSERT INTO buurt (code, naam) VALUES (1501005, 'Roessink');
INSERT INTO buurt (code, naam) VALUES (1501006, 'Het Bramelt');
INSERT INTO buurt (code, naam) VALUES (1501007, 'Essenerveld');
INSERT INTO buurt (code, naam) VALUES (1501008, 'Swormink');
INSERT INTO buurt (code, naam) VALUES (1501009, 'Handelspark De Weteringen');
INSERT INTO buurt (code, naam) VALUES (1501010, 'Bannink');
INSERT INTO buurt (code, naam) VALUES (1501011, 'Oxerhof');
INSERT INTO buurt (code, naam) VALUES (1501101, 'Dorp Diepenveen');
INSERT INTO buurt (code, naam) VALUES (1501102, 'Rande');
INSERT INTO buurt (code, naam) VALUES (1501103, 'Tjoene');
INSERT INTO buurt (code, naam) VALUES (1501201, 'Dorp Schalkhaar');
INSERT INTO buurt (code, naam) VALUES (1501202, 'Averlo en Frieswijk');
INSERT INTO buurt (code, naam) VALUES (1501301, 'Okkenbroek');
INSERT INTO buurt (code, naam) VALUES (1501401, 'Dorp Lettele');
INSERT INTO buurt (code, naam) VALUES (1501402, 'Oude Molen');
INSERT INTO buurt (code, naam) VALUES (1501403, 'Buitengebied Lettele en Okkenbroek');
INSERT INTO buurt (code, naam) VALUES (1501501, 'Dorp Bathmen');
INSERT INTO buurt (code, naam) VALUES (1501502, 'Loo');
INSERT INTO buurt (code, naam) VALUES (1501503, 'Dortherhoek');
INSERT INTO buurt (code, naam) VALUES (1501504, 'Zuidloo');
INSERT INTO buurt (code, naam) VALUES (1530000, 'City');
INSERT INTO buurt (code, naam) VALUES (1530001, 'Lasonder, Zeggelt');
INSERT INTO buurt (code, naam) VALUES (1530002, 'De Laares');
INSERT INTO buurt (code, naam) VALUES (1530003, 'De Bothoven');
INSERT INTO buurt (code, naam) VALUES (1530004, 'Hogeland-Noord');
INSERT INTO buurt (code, naam) VALUES (1530005, 'Getfert');
INSERT INTO buurt (code, naam) VALUES (1530006, 'Veldkamp-Getfert-West');
INSERT INTO buurt (code, naam) VALUES (1530007, 'Horstlanden-Stadsweide');
INSERT INTO buurt (code, naam) VALUES (1530008, 'Boddenkamp');
INSERT INTO buurt (code, naam) VALUES (1530100, 'Velve-Lindenhof');
INSERT INTO buurt (code, naam) VALUES (1530101, 'Wooldrik');
INSERT INTO buurt (code, naam) VALUES (1530102, 'Hogeland-Zuid');
INSERT INTO buurt (code, naam) VALUES (1530103, 'Varvik-Diekman');
INSERT INTO buurt (code, naam) VALUES (1530104, 'Sleutelkamp');
INSERT INTO buurt (code, naam) VALUES (1530105, '''t Weldink');
INSERT INTO buurt (code, naam) VALUES (1530106, 'De Leuriks');
INSERT INTO buurt (code, naam) VALUES (1530200, 'Cromhoffsbleek-Kotman');
INSERT INTO buurt (code, naam) VALUES (1530201, 'Boswinkel-De Braker');
INSERT INTO buurt (code, naam) VALUES (1530202, 'Pathmos');
INSERT INTO buurt (code, naam) VALUES (1530203, 'Stevenfenne');
INSERT INTO buurt (code, naam) VALUES (1530204, 'Stadsveld-Zuid');
INSERT INTO buurt (code, naam) VALUES (1530205, 'Elferink-Heuwkamp');
INSERT INTO buurt (code, naam) VALUES (1530206, 'Stadsveld-Noord-Bruggert');
INSERT INTO buurt (code, naam) VALUES (1530207, '''t Zwering');
INSERT INTO buurt (code, naam) VALUES (1530208, 'Ruwenbos');
INSERT INTO buurt (code, naam) VALUES (1530300, 'Tubantia-Toekomst');
INSERT INTO buurt (code, naam) VALUES (1530301, 'Twekkelerveld');
INSERT INTO buurt (code, naam) VALUES (1530400, 'Walhof-Roessingh');
INSERT INTO buurt (code, naam) VALUES (1530401, 'Bolhaar');
INSERT INTO buurt (code, naam) VALUES (1530402, 'Roombeek-Roomveldje');
INSERT INTO buurt (code, naam) VALUES (1530403, 'Mekkelholt');
INSERT INTO buurt (code, naam) VALUES (1530404, 'Deppenbroek');
INSERT INTO buurt (code, naam) VALUES (1530405, 'Voortman-Amelink');
INSERT INTO buurt (code, naam) VALUES (1530406, 'Drienerveld-U.T.');
INSERT INTO buurt (code, naam) VALUES (1530500, 'Schreurserve');
INSERT INTO buurt (code, naam) VALUES (1530501, 'Ribbelt-Ribbelerbrink');
INSERT INTO buurt (code, naam) VALUES (1530502, 'Park Stokhorst');
INSERT INTO buurt (code, naam) VALUES (1530503, 'Stokhorst');
INSERT INTO buurt (code, naam) VALUES (1530600, 'Stroinkslanden Noord-Oost');
INSERT INTO buurt (code, naam) VALUES (1530601, 'Stroinkslanden-Zuid');
INSERT INTO buurt (code, naam) VALUES (1530602, 'Stroinkslanden Noord-West');
INSERT INTO buurt (code, naam) VALUES (1530603, 'Wesselerbrink Noord-Oost');
INSERT INTO buurt (code, naam) VALUES (1530604, 'Wesselerbrink Zuid-Oost');
INSERT INTO buurt (code, naam) VALUES (1530605, 'Wesselerbrink Zuid-West');
INSERT INTO buurt (code, naam) VALUES (1530606, 'Wesselerbrink Noord-West');
INSERT INTO buurt (code, naam) VALUES (1530607, 'Helmerhoek-Noord');
INSERT INTO buurt (code, naam) VALUES (1530608, 'Helmerhoek-Zuid');
INSERT INTO buurt (code, naam) VALUES (1530609, 'het Brunink');
INSERT INTO buurt (code, naam) VALUES (1530700, 'Industrie- en havengebied');
INSERT INTO buurt (code, naam) VALUES (1530701, 'Marssteden');
INSERT INTO buurt (code, naam) VALUES (1530702, 'Koekoeksbeekhoek');
INSERT INTO buurt (code, naam) VALUES (1530703, 'De Broeierd');
INSERT INTO buurt (code, naam) VALUES (1530800, 'Glanerveld');
INSERT INTO buurt (code, naam) VALUES (1530801, 'Bentveld-Bultserve');
INSERT INTO buurt (code, naam) VALUES (1530802, 'Schipholt-Glanermaten');
INSERT INTO buurt (code, naam) VALUES (1530803, 'Eekmaat');
INSERT INTO buurt (code, naam) VALUES (1530804, 'Oikos');
INSERT INTO buurt (code, naam) VALUES (1530805, 'Eilermarke');
INSERT INTO buurt (code, naam) VALUES (1530806, 'De Slank');
INSERT INTO buurt (code, naam) VALUES (1530807, 'Dolphia');
INSERT INTO buurt (code, naam) VALUES (1530808, 'Eekmaat West');
INSERT INTO buurt (code, naam) VALUES (1530900, 'Dorp Lonneker');
INSERT INTO buurt (code, naam) VALUES (1530901, 'Dorp Boekelo');
INSERT INTO buurt (code, naam) VALUES (1530902, 'Buurtschap Lonneker-West');
INSERT INTO buurt (code, naam) VALUES (1530903, 'Noord Esmarke');
INSERT INTO buurt (code, naam) VALUES (1530904, 'Buurtschap Zuid-Esmarke');
INSERT INTO buurt (code, naam) VALUES (1530905, 'Buurtschap Broekheurne');
INSERT INTO buurt (code, naam) VALUES (1530906, 'Buurtschap Usselo');
INSERT INTO buurt (code, naam) VALUES (1530907, 'Boekelerveld');
INSERT INTO buurt (code, naam) VALUES (1530908, 'Buurtschap Twekkelo');
INSERT INTO buurt (code, naam) VALUES (1580001, 'Haaksbergen Kern-1');
INSERT INTO buurt (code, naam) VALUES (1580002, 'Haaksbergen Kern-2');
INSERT INTO buurt (code, naam) VALUES (1580003, 'Haaksbergen Kern-3');
INSERT INTO buurt (code, naam) VALUES (1580004, 'Haaksbergen Kern-4');
INSERT INTO buurt (code, naam) VALUES (1580010, 'Veldmaat 1');
INSERT INTO buurt (code, naam) VALUES (1580011, 'Veldmaat 2');
INSERT INTO buurt (code, naam) VALUES (1580020, 'Leemdijk');
INSERT INTO buurt (code, naam) VALUES (1580030, 'Zienesch');
INSERT INTO buurt (code, naam) VALUES (1580040, 'De Pas');
INSERT INTO buurt (code, naam) VALUES (1580041, 'De Els');
INSERT INTO buurt (code, naam) VALUES (1580050, 'Wolferink 1 en 4');
INSERT INTO buurt (code, naam) VALUES (1580051, 'Wolferink 2');
INSERT INTO buurt (code, naam) VALUES (1580052, 'Wolferink 5');
INSERT INTO buurt (code, naam) VALUES (1580053, 'Wolferink 3');
INSERT INTO buurt (code, naam) VALUES (1580060, 'Hassinkbrink');
INSERT INTO buurt (code, naam) VALUES (1580090, 'Industriegebied West');
INSERT INTO buurt (code, naam) VALUES (1580091, 'Industriegebied Brammelo');
INSERT INTO buurt (code, naam) VALUES (1580160, 'Verspreide huizen Langelo ten noorden van de spoorlijn');
INSERT INTO buurt (code, naam) VALUES (1580170, 'Verspreide huizen Langelo (gedeeltelijk) en Honesch');
INSERT INTO buurt (code, naam) VALUES (1580180, 'Verspreide huizen Veldmaat ten zuiden van de spoorlijn');
INSERT INTO buurt (code, naam) VALUES (1580190, 'Verspreide huizen Veldmaat ten noorden van de spoorlijn');
INSERT INTO buurt (code, naam) VALUES (1580200, 'Sint Isidorushoeve kern');
INSERT INTO buurt (code, naam) VALUES (1580290, 'Verspreide huizen Sint Isidorushoeve');
INSERT INTO buurt (code, naam) VALUES (1580300, 'Buurse kern');
INSERT INTO buurt (code, naam) VALUES (1580390, 'Verspreide huizen Buurse');
INSERT INTO buurt (code, naam) VALUES (1580490, 'Verspreide huizen Brammelo');
INSERT INTO buurt (code, naam) VALUES (1580590, 'Verspreide huizen Bretelerveld');
INSERT INTO buurt (code, naam) VALUES (1580690, 'Verspreide huizen Stepelo (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (1580900, 'Haaksbergen Kern-Centrum');
INSERT INTO buurt (code, naam) VALUES (1600001, 'Overig Stad Hardenberg');
INSERT INTO buurt (code, naam) VALUES (1600002, 'Industriegebied');
INSERT INTO buurt (code, naam) VALUES (1600003, 'Norden en Hazenbos');
INSERT INTO buurt (code, naam) VALUES (1600004, 'Heemse-Oost Heemsermars');
INSERT INTO buurt (code, naam) VALUES (1600005, 'Heemse-West Heemserbos');
INSERT INTO buurt (code, naam) VALUES (1600006, 'Baalder');
INSERT INTO buurt (code, naam) VALUES (1600007, 'Baalderveld');
INSERT INTO buurt (code, naam) VALUES (1600008, 'Marslanden en bedrijventerrein Haardijk');
INSERT INTO buurt (code, naam) VALUES (1600009, 'Centrum saneringsgebied');
INSERT INTO buurt (code, naam) VALUES (1600107, 'Brucht');
INSERT INTO buurt (code, naam) VALUES (1600108, 'Rheeze');
INSERT INTO buurt (code, naam) VALUES (1600109, 'Diffelen');
INSERT INTO buurt (code, naam) VALUES (1600207, 'Collendoorn');
INSERT INTO buurt (code, naam) VALUES (1600208, 'Heemserveen');
INSERT INTO buurt (code, naam) VALUES (1600209, 'Rheezerveen');
INSERT INTO buurt (code, naam) VALUES (1600307, 'Hoogenweg');
INSERT INTO buurt (code, naam) VALUES (1600308, 'Venebrugge');
INSERT INTO buurt (code, naam) VALUES (1600309, 'Radewijk');
INSERT INTO buurt (code, naam) VALUES (1600400, 'Mariënberg Kern');
INSERT INTO buurt (code, naam) VALUES (1600401, 'Sibculo Kern');
INSERT INTO buurt (code, naam) VALUES (1600402, 'Kloosterhaar Kern');
INSERT INTO buurt (code, naam) VALUES (1600407, 'Verspreide huizen Kloosterhaar');
INSERT INTO buurt (code, naam) VALUES (1600408, 'Verspreide huizen Sibculo');
INSERT INTO buurt (code, naam) VALUES (1600409, 'Verspreide huizen Mariënberg');
INSERT INTO buurt (code, naam) VALUES (1600500, 'Bergentheim Kern');
INSERT INTO buurt (code, naam) VALUES (1600501, 'Bruchterveld Kern');
INSERT INTO buurt (code, naam) VALUES (1600507, 'Verspreide huizen Bruchterveld');
INSERT INTO buurt (code, naam) VALUES (1600508, 'Verspreide huizen Bergentheimerveen en omgeving');
INSERT INTO buurt (code, naam) VALUES (1600509, 'Verspreide huizen Oud-Bergentheim en omgeving');
INSERT INTO buurt (code, naam) VALUES (1600600, 'Lutten Kern');
INSERT INTO buurt (code, naam) VALUES (1600607, 'Verspreide huizen Lutten-West');
INSERT INTO buurt (code, naam) VALUES (1600608, 'Verspreide huizen Lutten-Oost');
INSERT INTO buurt (code, naam) VALUES (1600609, 'Verspreide huizen Oud-Lutten');
INSERT INTO buurt (code, naam) VALUES (1600700, 'Slagharen-Kern');
INSERT INTO buurt (code, naam) VALUES (1600701, 'Schuinesloot Kern');
INSERT INTO buurt (code, naam) VALUES (1600702, 'De Belt');
INSERT INTO buurt (code, naam) VALUES (1600703, 'De Krim');
INSERT INTO buurt (code, naam) VALUES (1600707, 'Verspreide huizen Schuinesloot');
INSERT INTO buurt (code, naam) VALUES (1600708, 'Verspreide huizen Slagharen-Oost');
INSERT INTO buurt (code, naam) VALUES (1600709, 'Verspreide huizen Slagharen-West');
INSERT INTO buurt (code, naam) VALUES (1600800, 'Gramsbergen Kern');
INSERT INTO buurt (code, naam) VALUES (1600801, 'Gramsbergen uitbreidingsplan');
INSERT INTO buurt (code, naam) VALUES (1600807, 'Verspreide huizen Den Velde');
INSERT INTO buurt (code, naam) VALUES (1600808, 'Verspreide huizen Holtheme-De Haandrik');
INSERT INTO buurt (code, naam) VALUES (1600809, 'Verspreide huizen Loozen');
INSERT INTO buurt (code, naam) VALUES (1600900, 'De Krim-Streekdorp');
INSERT INTO buurt (code, naam) VALUES (1600901, 'De Krim-Zuid');
INSERT INTO buurt (code, naam) VALUES (1600908, 'Verspreide huizen De Krim');
INSERT INTO buurt (code, naam) VALUES (1600909, 'Verspreide huizen Nieuwlande');
INSERT INTO buurt (code, naam) VALUES (1601000, 'Ane Dorp');
INSERT INTO buurt (code, naam) VALUES (1601006, 'Verspreide huizen Anevelde');
INSERT INTO buurt (code, naam) VALUES (1601007, 'Verspreide huizen Holthone');
INSERT INTO buurt (code, naam) VALUES (1601008, 'Verspreide huizen Anerveen');
INSERT INTO buurt (code, naam) VALUES (1601009, 'Verspreide huizen Ane');
INSERT INTO buurt (code, naam) VALUES (1601100, 'Dedemsvaart-Noord');
INSERT INTO buurt (code, naam) VALUES (1601101, 'Dedemsvaart-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (1601102, 'Dedemsvaart Zuidoost');
INSERT INTO buurt (code, naam) VALUES (1601103, 'Rheezerzand');
INSERT INTO buurt (code, naam) VALUES (1601104, 'Industriegebied Rollepaal');
INSERT INTO buurt (code, naam) VALUES (1601105, 'Verspreide huizen Colenbranderbos');
INSERT INTO buurt (code, naam) VALUES (1601106, 'Verspreide huizen Dedemsvaart');
INSERT INTO buurt (code, naam) VALUES (1601107, 'Verspreide huizen Beute en Ommerkanaal');
INSERT INTO buurt (code, naam) VALUES (1601108, 'Verspreide huizen Sponturfwijk en Reestgebied');
INSERT INTO buurt (code, naam) VALUES (1601109, 'Verspreide huizen De Kolonie');
INSERT INTO buurt (code, naam) VALUES (1601200, 'Balkbrug-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (1601201, 'Balkbrug-Noord');
INSERT INTO buurt (code, naam) VALUES (1601202, 'Balkbrug-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (1601203, 'Balkbrug Benedenvaart');
INSERT INTO buurt (code, naam) VALUES (1601208, 'Verspreide huizen Reestgebied (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (1601209, 'Verspreide huizen Westerhuizingerveld en omgeving');
INSERT INTO buurt (code, naam) VALUES (1630101, 'Hellendoorn-Centrum');
INSERT INTO buurt (code, naam) VALUES (1630102, 'De Höfte');
INSERT INTO buurt (code, naam) VALUES (1630103, 'Den Dam');
INSERT INTO buurt (code, naam) VALUES (1630104, 'De Blenke');
INSERT INTO buurt (code, naam) VALUES (1630105, 'De Zuid Es');
INSERT INTO buurt (code, naam) VALUES (1630106, 'De Noord Es');
INSERT INTO buurt (code, naam) VALUES (1630201, 'Zeeheldenwijk');
INSERT INTO buurt (code, naam) VALUES (1630202, 'Wilhelminawijk');
INSERT INTO buurt (code, naam) VALUES (1630203, 'Gagelman Industrieterrein-Noord');
INSERT INTO buurt (code, naam) VALUES (1630301, 'Nijverdal-Centrum');
INSERT INTO buurt (code, naam) VALUES (1630302, 'Bloemen-Schilderswijk');
INSERT INTO buurt (code, naam) VALUES (1630303, 'Noetsele I');
INSERT INTO buurt (code, naam) VALUES (1630304, 'Noetsele II en III');
INSERT INTO buurt (code, naam) VALUES (1630401, 'Prinsessenwijk');
INSERT INTO buurt (code, naam) VALUES (1630402, 'De Brake');
INSERT INTO buurt (code, naam) VALUES (1630403, 'Konijnenberg');
INSERT INTO buurt (code, naam) VALUES (1630404, 'Nijverdal Oost');
INSERT INTO buurt (code, naam) VALUES (1630405, 'De Blokken');
INSERT INTO buurt (code, naam) VALUES (1630406, 'Groot Lochter');
INSERT INTO buurt (code, naam) VALUES (1630407, '''t Lochter');
INSERT INTO buurt (code, naam) VALUES (1630408, '''n Oaln Diek');
INSERT INTO buurt (code, naam) VALUES (1630501, 'Hellendoorn');
INSERT INTO buurt (code, naam) VALUES (1630503, '''t Hexel');
INSERT INTO buurt (code, naam) VALUES (1630504, 'Boersingel');
INSERT INTO buurt (code, naam) VALUES (1630505, 'Egede, Elen en Rhaan');
INSERT INTO buurt (code, naam) VALUES (1630506, 'Hulsen');
INSERT INTO buurt (code, naam) VALUES (1630507, 'Haarle');
INSERT INTO buurt (code, naam) VALUES (1630508, 'Daarle');
INSERT INTO buurt (code, naam) VALUES (1630509, 'Daalerveen');
INSERT INTO buurt (code, naam) VALUES (1630510, 'Marle');
INSERT INTO buurt (code, naam) VALUES (1630601, 'Hulsen dorp');
INSERT INTO buurt (code, naam) VALUES (1630602, 'Kruidenwijk Oost');
INSERT INTO buurt (code, naam) VALUES (1630603, 'Kruidenwijk Centrum');
INSERT INTO buurt (code, naam) VALUES (1630604, 'Kruidenwijk Noord');
INSERT INTO buurt (code, naam) VALUES (1630605, 'Kruidenwijk West');
INSERT INTO buurt (code, naam) VALUES (1630606, 'Kruidenwijk Zuid');
INSERT INTO buurt (code, naam) VALUES (1630700, 'Dorp Haarle');
INSERT INTO buurt (code, naam) VALUES (1630800, 'Dorp Daarle');
INSERT INTO buurt (code, naam) VALUES (1630900, 'Dorp Daarlerveen');
INSERT INTO buurt (code, naam) VALUES (1640000, 'Binnenstad-Centrum');
INSERT INTO buurt (code, naam) VALUES (1640001, 'Binnenstad-West');
INSERT INTO buurt (code, naam) VALUES (1640002, 'Binnenstad-Oost');
INSERT INTO buurt (code, naam) VALUES (1640100, 'Hengelose Es-Noord');
INSERT INTO buurt (code, naam) VALUES (1640101, 'Tichelwerk');
INSERT INTO buurt (code, naam) VALUES (1640102, '''t Wilbert');
INSERT INTO buurt (code, naam) VALUES (1640103, 'Bedrijventerrein Timmersveld');
INSERT INTO buurt (code, naam) VALUES (1640200, 'Noord');
INSERT INTO buurt (code, naam) VALUES (1640201, 'Elsbeek');
INSERT INTO buurt (code, naam) VALUES (1640202, 'De Noork');
INSERT INTO buurt (code, naam) VALUES (1640203, 'Klein Driene');
INSERT INTO buurt (code, naam) VALUES (1640204, '''t Rot');
INSERT INTO buurt (code, naam) VALUES (1640300, 'Bovenhoek');
INSERT INTO buurt (code, naam) VALUES (1640301, 'Schothorsthoek');
INSERT INTO buurt (code, naam) VALUES (1640302, 'Bartelinkshoek');
INSERT INTO buurt (code, naam) VALUES (1640303, 'Tijertshoek');
INSERT INTO buurt (code, naam) VALUES (1640304, 'Sogtoenhoek');
INSERT INTO buurt (code, naam) VALUES (1640305, 'Bruninkshoek');
INSERT INTO buurt (code, naam) VALUES (1640306, 'Middelhoek');
INSERT INTO buurt (code, naam) VALUES (1640307, 'Molendijkhoek');
INSERT INTO buurt (code, naam) VALUES (1640308, 'Weijinkshoek');
INSERT INTO buurt (code, naam) VALUES (1640309, 'Oosterveld');
INSERT INTO buurt (code, naam) VALUES (1640400, 'Zwavertshoek');
INSERT INTO buurt (code, naam) VALUES (1640401, 'Anninks-/Nijhofshoek');
INSERT INTO buurt (code, naam) VALUES (1640402, 'Groot Driene-Zuid');
INSERT INTO buurt (code, naam) VALUES (1640403, 'Groot Driene-Noord');
INSERT INTO buurt (code, naam) VALUES (1640500, 'Bedrijventerrein Twentekanaal-Zuid II');
INSERT INTO buurt (code, naam) VALUES (1640501, 'Berflo Es Noord');
INSERT INTO buurt (code, naam) VALUES (1640502, 'Berflo Es Zuid');
INSERT INTO buurt (code, naam) VALUES (1640503, 'Bedrijventerrein Twentekanaal-Noord II');
INSERT INTO buurt (code, naam) VALUES (1640504, 'Veldwijk-Noord');
INSERT INTO buurt (code, naam) VALUES (1640505, 'Veldwijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (1640506, 'Boeldershoek');
INSERT INTO buurt (code, naam) VALUES (1640600, 'Bedrijventerrein Twentekanaal-Zuid I');
INSERT INTO buurt (code, naam) VALUES (1640601, 'Tuindorp ''t Lansink');
INSERT INTO buurt (code, naam) VALUES (1640602, 'Tuindorp-Zuid');
INSERT INTO buurt (code, naam) VALUES (1640603, 'Bedrijventerrein Twentekanaal-Noord I');
INSERT INTO buurt (code, naam) VALUES (1640604, 'Nijverheid');
INSERT INTO buurt (code, naam) VALUES (1640605, 'Vikkerhoek');
INSERT INTO buurt (code, naam) VALUES (1640606, 'Bedrijventerrein Zeggershoek');
INSERT INTO buurt (code, naam) VALUES (1640700, 'Bedrijventerrein Westermaat-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (1640701, 'Woolde');
INSERT INTO buurt (code, naam) VALUES (1640702, 'Woolder Es');
INSERT INTO buurt (code, naam) VALUES (1640703, 'Weidedorp');
INSERT INTO buurt (code, naam) VALUES (1640704, 'Bedrijvenpark Westermaat-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (1640705, 'Bedrijventerrein Westermaat-Noordoost');
INSERT INTO buurt (code, naam) VALUES (1640706, 'Bedrijventerrein Westermaat-Noordwest');
INSERT INTO buurt (code, naam) VALUES (1640800, 'Roershoek');
INSERT INTO buurt (code, naam) VALUES (1640801, 'Vossenbelt-Zuid');
INSERT INTO buurt (code, naam) VALUES (1640802, 'Vossenbelt-Noord');
INSERT INTO buurt (code, naam) VALUES (1640803, 'Het Broek');
INSERT INTO buurt (code, naam) VALUES (1640804, 'Kristenbos');
INSERT INTO buurt (code, naam) VALUES (1640805, 'Dalmeden');
INSERT INTO buurt (code, naam) VALUES (1640900, 'Beckum kern');
INSERT INTO buurt (code, naam) VALUES (1640901, 'Verspreide huizen Slangenbeek');
INSERT INTO buurt (code, naam) VALUES (1640902, 'Stadspark Weusthag-Noord');
INSERT INTO buurt (code, naam) VALUES (1640903, 'Stadspark Weusthag-Zuid');
INSERT INTO buurt (code, naam) VALUES (1640904, 'Verspreide huizen Driene');
INSERT INTO buurt (code, naam) VALUES (1640905, 'Verspreide huizen Twekkelo');
INSERT INTO buurt (code, naam) VALUES (1640906, 'Verspreide huizen Oele');
INSERT INTO buurt (code, naam) VALUES (1640907, 'Verspreide huizen Woolde');
INSERT INTO buurt (code, naam) VALUES (1640909, 'Verspreide huizen Beckum');
INSERT INTO buurt (code, naam) VALUES (1660000, 'Binnenstad Kampen');
INSERT INTO buurt (code, naam) VALUES (1660001, 'Brunnepe');
INSERT INTO buurt (code, naam) VALUES (1660002, 'Groene Hart');
INSERT INTO buurt (code, naam) VALUES (1660003, 'Hanzewijk en Greente');
INSERT INTO buurt (code, naam) VALUES (1660004, 'Kampen-Zuid');
INSERT INTO buurt (code, naam) VALUES (1660005, 'Flevowijk');
INSERT INTO buurt (code, naam) VALUES (1660006, 'Industrieterrein Kampen');
INSERT INTO buurt (code, naam) VALUES (1660007, 'Bovenbroek');
INSERT INTO buurt (code, naam) VALUES (1660008, 'Cellesbroek');
INSERT INTO buurt (code, naam) VALUES (1660009, 'Hagenbroek');
INSERT INTO buurt (code, naam) VALUES (1660010, 'De Maten');
INSERT INTO buurt (code, naam) VALUES (1660011, 'De Venen');
INSERT INTO buurt (code, naam) VALUES (1660012, 'Stationsplein');
INSERT INTO buurt (code, naam) VALUES (1660013, 'Stationskwartier');
INSERT INTO buurt (code, naam) VALUES (1660015, 'Het Onderdijks');
INSERT INTO buurt (code, naam) VALUES (1660016, 'Polder Dronthen');
INSERT INTO buurt (code, naam) VALUES (1660017, 'De Melm');
INSERT INTO buurt (code, naam) VALUES (1660018, 'Kampereiland');
INSERT INTO buurt (code, naam) VALUES (1660019, 'Mandjeswaard');
INSERT INTO buurt (code, naam) VALUES (1660300, 'Ijsselmuiden-Centrum');
INSERT INTO buurt (code, naam) VALUES (1660301, 'Losselanden');
INSERT INTO buurt (code, naam) VALUES (1660302, 'Industrieterrein IJsselmuiden');
INSERT INTO buurt (code, naam) VALUES (1660303, 'De Waard');
INSERT INTO buurt (code, naam) VALUES (1660304, 'De Koekoek');
INSERT INTO buurt (code, naam) VALUES (1660305, 'Oosterholt');
INSERT INTO buurt (code, naam) VALUES (1660306, 'Sonnenberg');
INSERT INTO buurt (code, naam) VALUES (1660307, 'Trekvaart');
INSERT INTO buurt (code, naam) VALUES (1660400, 'Zalk');
INSERT INTO buurt (code, naam) VALUES (1660401, 'Verspreide huizen Zalk');
INSERT INTO buurt (code, naam) VALUES (1660500, 'Wilsum');
INSERT INTO buurt (code, naam) VALUES (1660501, 'Verspreide huizen Wilsum');
INSERT INTO buurt (code, naam) VALUES (1660600, 'Grafhorst');
INSERT INTO buurt (code, naam) VALUES (1660700, 'Kamperveen');
INSERT INTO buurt (code, naam) VALUES (1660800, '''s-Heerenbroek');
INSERT INTO buurt (code, naam) VALUES (1660900, 'Verspreide huizen polder Mastenbroek');
INSERT INTO buurt (code, naam) VALUES (1669997, '');
INSERT INTO buurt (code, naam) VALUES (1680001, 'Losser-West');
INSERT INTO buurt (code, naam) VALUES (1680002, 'Bedrijfsterrein Losser');
INSERT INTO buurt (code, naam) VALUES (1680003, 'Losser-Oost');
INSERT INTO buurt (code, naam) VALUES (1680009, 'Verspreide huizen Losser');
INSERT INTO buurt (code, naam) VALUES (1680101, 'Glane kern');
INSERT INTO buurt (code, naam) VALUES (1680102, 'Glane-beekhoek');
INSERT INTO buurt (code, naam) VALUES (1680109, 'Verspreide huizen Glane');
INSERT INTO buurt (code, naam) VALUES (1680201, 'Overdinkel kern');
INSERT INTO buurt (code, naam) VALUES (1680209, 'Verspreide huizen Overdinkel');
INSERT INTO buurt (code, naam) VALUES (1680301, 'De Lutte kern');
INSERT INTO buurt (code, naam) VALUES (1680309, 'Verspreide huizen De Lutte');
INSERT INTO buurt (code, naam) VALUES (1680401, 'Beuningen kern');
INSERT INTO buurt (code, naam) VALUES (1680409, 'Verspreide huizen Beuningen');
INSERT INTO buurt (code, naam) VALUES (1710101, 'Emmeloord-Centrum-Tussen Gracht en Vaart');
INSERT INTO buurt (code, naam) VALUES (1710102, 'Emmeloord-Centrum-Centrum West');
INSERT INTO buurt (code, naam) VALUES (1710103, 'Emmeloord-Centrum-Bos en Gaard');
INSERT INTO buurt (code, naam) VALUES (1710104, 'Emmeloord-Centrum-Centrum Oost');
INSERT INTO buurt (code, naam) VALUES (1710105, 'Emmeloord-Revelsant-Noord');
INSERT INTO buurt (code, naam) VALUES (1710106, 'Emmeloord-Revelsant-Zuid');
INSERT INTO buurt (code, naam) VALUES (1710107, 'Emmeloord-Espelervaart-Bergenbuurt');
INSERT INTO buurt (code, naam) VALUES (1710108, 'Emmeloord-Espelervaart-Rivierenbuurt');
INSERT INTO buurt (code, naam) VALUES (1710109, 'Emmeloord-Espelervaart-Espelervaart West');
INSERT INTO buurt (code, naam) VALUES (1710110, 'Emmeloord-de Zuidert');
INSERT INTO buurt (code, naam) VALUES (1710111, 'Emmeloord-de Erven');
INSERT INTO buurt (code, naam) VALUES (1710112, 'Emmeloord-Waterland');
INSERT INTO buurt (code, naam) VALUES (1710113, 'Emmeloord-Emmelhage-Boswonen');
INSERT INTO buurt (code, naam) VALUES (1710114, 'Emmeloord-Emmelhage-Waterwonen/Polderwonen');
INSERT INTO buurt (code, naam) VALUES (1710115, 'Emmeloord-Bedrijventerrein de Munt');
INSERT INTO buurt (code, naam) VALUES (1710116, 'Emmeloord-Bedrijventerrein Nagelerweg');
INSERT INTO buurt (code, naam) VALUES (1710117, 'Emmeloord-Bedrijventerrein A6');
INSERT INTO buurt (code, naam) VALUES (1710118, 'Emmeloord-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1710219, 'Bant-woonkern');
INSERT INTO buurt (code, naam) VALUES (1710220, 'Bant-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1710221, 'Bant-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1710322, 'Luttelgeest-woonkern');
INSERT INTO buurt (code, naam) VALUES (1710323, 'Luttelgeest-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1710424, 'Marknesse-woonkern');
INSERT INTO buurt (code, naam) VALUES (1710425, 'Marknesse-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1710426, 'Marknesse-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1710527, 'Kraggenburg-woonkern');
INSERT INTO buurt (code, naam) VALUES (1710528, 'Kraggenburg-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1710529, 'Kraggenburg-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1710530, 'Kraggenburg-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1710631, 'Ens-woonkern');
INSERT INTO buurt (code, naam) VALUES (1710632, 'Ens-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1710633, 'Ens-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1710734, 'Nagele-woonkern');
INSERT INTO buurt (code, naam) VALUES (1710735, 'Nagele-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1710736, 'Nagele-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1710837, 'Tollebeek-woonkern');
INSERT INTO buurt (code, naam) VALUES (1710838, 'Tollebeek-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1710839, 'Tollebeek-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1710941, 'Espel-woonkern');
INSERT INTO buurt (code, naam) VALUES (1710942, 'Espel-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1710943, 'Espel-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1711045, 'Creil-woonkern');
INSERT INTO buurt (code, naam) VALUES (1711046, 'Creil-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1711047, 'Creil-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1711149, 'Rutten-woonkern');
INSERT INTO buurt (code, naam) VALUES (1711150, 'Rutten-bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (1711151, 'Rutten-landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (1711252, 'Schokland-woonkern');
INSERT INTO buurt (code, naam) VALUES (1719997, '');
INSERT INTO buurt (code, naam) VALUES (1730100, 'Binnenstad Oldenzaal');
INSERT INTO buurt (code, naam) VALUES (1730200, 'De inslag-De Kleies');
INSERT INTO buurt (code, naam) VALUES (1730300, 'Glinde-Hooiland');
INSERT INTO buurt (code, naam) VALUES (1730400, 'De Meijbree');
INSERT INTO buurt (code, naam) VALUES (1730500, 'Haerbroek-Scholtenhoek');
INSERT INTO buurt (code, naam) VALUES (1730600, 'Zuid-Bergenhuizen');
INSERT INTO buurt (code, naam) VALUES (1730700, 'Hanzepoort');
INSERT INTO buurt (code, naam) VALUES (1730800, 'Eekte-Hazewinkel');
INSERT INTO buurt (code, naam) VALUES (1730900, 'Jufferbeek');
INSERT INTO buurt (code, naam) VALUES (1731000, 'Het Hulsbeek');
INSERT INTO buurt (code, naam) VALUES (1731100, 'De Thij');
INSERT INTO buurt (code, naam) VALUES (1731200, 'De Graven Es');
INSERT INTO buurt (code, naam) VALUES (1731300, 'De Essen');
INSERT INTO buurt (code, naam) VALUES (1731400, 'Bekspring');
INSERT INTO buurt (code, naam) VALUES (1750100, 'Ommen Centrum');
INSERT INTO buurt (code, naam) VALUES (1750101, 'Buurtschap Ommeres');
INSERT INTO buurt (code, naam) VALUES (1750102, 'Kern Ommen - Laarakkers');
INSERT INTO buurt (code, naam) VALUES (1750103, 'Buurtschap Ommen ten zuiden van de Vecht');
INSERT INTO buurt (code, naam) VALUES (1750104, 'Kern Ommen - Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (1750105, 'Buurtschap Junne');
INSERT INTO buurt (code, naam) VALUES (1750106, 'Buurtschap Eerde');
INSERT INTO buurt (code, naam) VALUES (1750107, 'Buurtschap Bestmen');
INSERT INTO buurt (code, naam) VALUES (1750108, 'Buurtschap Varsen');
INSERT INTO buurt (code, naam) VALUES (1750109, 'Buurtschap Ommerbos - Ommerkanaal');
INSERT INTO buurt (code, naam) VALUES (1750110, 'Buurtschap Emsland');
INSERT INTO buurt (code, naam) VALUES (1750111, 'Buurtschap Zeesse');
INSERT INTO buurt (code, naam) VALUES (1750112, 'Kern Ommen Zuid - ten noorden van het spoor');
INSERT INTO buurt (code, naam) VALUES (1750113, 'Kern Ommen Zuid - ten zuiden van het spoor');
INSERT INTO buurt (code, naam) VALUES (1750114, 'Kern Ommen - Dante Noord');
INSERT INTO buurt (code, naam) VALUES (1750115, 'Kern Ommen - Dante Zuid');
INSERT INTO buurt (code, naam) VALUES (1750116, 'Kern Ommen - Zeeheldenbuurt - Lodderholt');
INSERT INTO buurt (code, naam) VALUES (1750117, 'Kern Ommen - Strangen');
INSERT INTO buurt (code, naam) VALUES (1750118, 'Kern Ommen - Alteveer Wonen 5-6');
INSERT INTO buurt (code, naam) VALUES (1750119, 'Kern Ommen - Rotbrink');
INSERT INTO buurt (code, naam) VALUES (1750120, 'Kern Ommen - Alteveer Wonen 1-4');
INSERT INTO buurt (code, naam) VALUES (1750121, 'Kern Ommen - Alteveer Bedrijven');
INSERT INTO buurt (code, naam) VALUES (1750122, 'Kern Ommen - Alteveer Voorzieningen');
INSERT INTO buurt (code, naam) VALUES (1750123, 'Kern Ommen - Havengebied');
INSERT INTO buurt (code, naam) VALUES (1750200, 'Buurtschap Arriën Sportpark Westbroek');
INSERT INTO buurt (code, naam) VALUES (1750201, 'Buurtschap Arriërveld');
INSERT INTO buurt (code, naam) VALUES (1750202, 'Buurtschap Arriën');
INSERT INTO buurt (code, naam) VALUES (1750300, 'Buurtschap Beerze');
INSERT INTO buurt (code, naam) VALUES (1750400, 'Kern Beerzerveld');
INSERT INTO buurt (code, naam) VALUES (1750401, 'Kern Kloosterdijk');
INSERT INTO buurt (code, naam) VALUES (1750402, 'Buurtschap Beerzerveld');
INSERT INTO buurt (code, naam) VALUES (1750500, 'Buurtschap Dalmsholte');
INSERT INTO buurt (code, naam) VALUES (1750600, 'Buurtschap Giethmen');
INSERT INTO buurt (code, naam) VALUES (1750700, 'Kern Lemele');
INSERT INTO buurt (code, naam) VALUES (1750701, 'Buurtschap Lemele');
INSERT INTO buurt (code, naam) VALUES (1750702, 'Buurtschap Archem');
INSERT INTO buurt (code, naam) VALUES (1750800, 'Buurtschap Stegerveld');
INSERT INTO buurt (code, naam) VALUES (1750801, 'Buurtschap Stegeren');
INSERT INTO buurt (code, naam) VALUES (1750900, 'Kern Vilsteren');
INSERT INTO buurt (code, naam) VALUES (1750901, 'Buurtschap Vilsteren');
INSERT INTO buurt (code, naam) VALUES (1751000, 'Buurtschap Vinkenbuurt');
INSERT INTO buurt (code, naam) VALUES (1751001, 'Buurtschap Ommerschans');
INSERT INTO buurt (code, naam) VALUES (1751100, 'Kern Witharen');
INSERT INTO buurt (code, naam) VALUES (1751101, 'Buurtschap Witharen');
INSERT INTO buurt (code, naam) VALUES (1751102, 'Buurtschap Ommerveld');
INSERT INTO buurt (code, naam) VALUES (1770000, 'Raalte Centrum');
INSERT INTO buurt (code, naam) VALUES (1770001, 'De Enk en industrieterrein-Noordoost');
INSERT INTO buurt (code, naam) VALUES (1770002, 'Blekkershoek');
INSERT INTO buurt (code, naam) VALUES (1770003, 'De Hofstee');
INSERT INTO buurt (code, naam) VALUES (1770004, 'Westdorp');
INSERT INTO buurt (code, naam) VALUES (1770005, 'De Olykampen');
INSERT INTO buurt (code, naam) VALUES (1770006, 'Hartkamp I');
INSERT INTO buurt (code, naam) VALUES (1770007, 'Langkamp II');
INSERT INTO buurt (code, naam) VALUES (1770008, 'Langkamp I');
INSERT INTO buurt (code, naam) VALUES (1770100, 'Industriegebied De Zegge I en II');
INSERT INTO buurt (code, naam) VALUES (1770101, 'Industriegebied De Zegge III');
INSERT INTO buurt (code, naam) VALUES (1770102, 'Plan De Vloedkampen');
INSERT INTO buurt (code, naam) VALUES (1770103, 'Hartkamp II');
INSERT INTO buurt (code, naam) VALUES (1770104, 'Drostenkamp en Tijenraan');
INSERT INTO buurt (code, naam) VALUES (1770105, 'Raan-West');
INSERT INTO buurt (code, naam) VALUES (1770106, 'Raan-Oost');
INSERT INTO buurt (code, naam) VALUES (1770107, 'Het Overstigt');
INSERT INTO buurt (code, naam) VALUES (1770109, 'Verspreide huizen buitengebied');
INSERT INTO buurt (code, naam) VALUES (1770200, 'Heeten-Kern');
INSERT INTO buurt (code, naam) VALUES (1770209, 'Verspreide huizen Heeten');
INSERT INTO buurt (code, naam) VALUES (1770300, 'Luttenberg-Kern');
INSERT INTO buurt (code, naam) VALUES (1770308, 'Verspreide huizen Luttenberg I');
INSERT INTO buurt (code, naam) VALUES (1770309, 'Verspreide huizen Luttenberg II');
INSERT INTO buurt (code, naam) VALUES (1770400, 'Broekland-Kern');
INSERT INTO buurt (code, naam) VALUES (1770407, 'Verspreide huizen Broekland I');
INSERT INTO buurt (code, naam) VALUES (1770408, 'Verspreide huizen Broekland II');
INSERT INTO buurt (code, naam) VALUES (1770409, 'Verspreide huizen Broekland III');
INSERT INTO buurt (code, naam) VALUES (1770500, 'Mariënheem-Kern');
INSERT INTO buurt (code, naam) VALUES (1770507, 'Verspreide huizen Mariënheem I');
INSERT INTO buurt (code, naam) VALUES (1770508, 'Verspreide huizen Mariënheem II');
INSERT INTO buurt (code, naam) VALUES (1770509, 'Verspreide huizen Mariënheem III');
INSERT INTO buurt (code, naam) VALUES (1770600, 'Nieuw Heeten');
INSERT INTO buurt (code, naam) VALUES (1770609, 'Verspreide huizen Nieuw Heeten');
INSERT INTO buurt (code, naam) VALUES (1770800, 'Heino-West');
INSERT INTO buurt (code, naam) VALUES (1770801, 'Heino-Oost');
INSERT INTO buurt (code, naam) VALUES (1770802, 'Heino-Noord');
INSERT INTO buurt (code, naam) VALUES (1770803, 'Heino-Zuid');
INSERT INTO buurt (code, naam) VALUES (1770806, 'Verspreide huizen Twentseweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (1770807, 'Verspreide huizen Veldhoek');
INSERT INTO buurt (code, naam) VALUES (1770808, 'Verspreide huizen Rozendaal');
INSERT INTO buurt (code, naam) VALUES (1770809, 'Verspreide huizen Woolthuis');
INSERT INTO buurt (code, naam) VALUES (1770900, 'Laag Zuthem-Kern');
INSERT INTO buurt (code, naam) VALUES (1770909, 'Verspreide huizen Laag Zuthem');
INSERT INTO buurt (code, naam) VALUES (1771000, 'Lierderholthuis-Kern');
INSERT INTO buurt (code, naam) VALUES (1771008, 'Verspreide huizen Lierderholthuis');
INSERT INTO buurt (code, naam) VALUES (1771009, 'Verspreide huizen Molenweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (1800000, 'Staphorst plan-Oost');
INSERT INTO buurt (code, naam) VALUES (1800001, 'Staphorst plan-West');
INSERT INTO buurt (code, naam) VALUES (1800002, 'Staphorst streek-West');
INSERT INTO buurt (code, naam) VALUES (1800003, 'Staphorst streek-Oost');
INSERT INTO buurt (code, naam) VALUES (1800004, 'Industrieterrein Staphorst');
INSERT INTO buurt (code, naam) VALUES (1800005, 'Staphorst-Zuid');
INSERT INTO buurt (code, naam) VALUES (1800006, 'Staphorst-Noord');
INSERT INTO buurt (code, naam) VALUES (1800007, 'De Slagen');
INSERT INTO buurt (code, naam) VALUES (1800100, 'Rouveen kern');
INSERT INTO buurt (code, naam) VALUES (1800101, 'Rouveen Streek-Zuid');
INSERT INTO buurt (code, naam) VALUES (1800102, 'Rouveen Streek-Noord');
INSERT INTO buurt (code, naam) VALUES (1800206, 'Verspreide huizen Dedemsvaart');
INSERT INTO buurt (code, naam) VALUES (1800207, 'Verspreide huizen Bisschops- en Munnikenslag');
INSERT INTO buurt (code, naam) VALUES (1800208, 'Verspreide huizen Geerenland');
INSERT INTO buurt (code, naam) VALUES (1800209, 'Verspreide huizen Oldmaten');
INSERT INTO buurt (code, naam) VALUES (1800305, 'Verspreide huizen Lankhorst');
INSERT INTO buurt (code, naam) VALUES (1800306, 'Verspreide huizen Leyen');
INSERT INTO buurt (code, naam) VALUES (1800307, 'Verspreide huizen Berger Achthoven en omgeving');
INSERT INTO buurt (code, naam) VALUES (1800308, 'Verspreide huizen Heidehoogten');
INSERT INTO buurt (code, naam) VALUES (1800309, 'Verspreide huizen Rechterensweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (1800400, 'IJhorst');
INSERT INTO buurt (code, naam) VALUES (1800409, 'Verspreide huizen IJhorst');
INSERT INTO buurt (code, naam) VALUES (1800509, 'Verspreide huizen Punthorst');
INSERT INTO buurt (code, naam) VALUES (1800609, 'Verspreide huizen Lankhorst');
INSERT INTO buurt (code, naam) VALUES (1800709, 'Verspreide huizen Zwartewatersklooster en Holtrust');
INSERT INTO buurt (code, naam) VALUES (1830000, 'Tubbergen-Dorp');
INSERT INTO buurt (code, naam) VALUES (1830008, 'Verspreide huizen Manderveen');
INSERT INTO buurt (code, naam) VALUES (1830009, 'Verspreide huizen Tubbergen');
INSERT INTO buurt (code, naam) VALUES (1830100, 'Albergen kern');
INSERT INTO buurt (code, naam) VALUES (1830109, 'Verspreide huizen Albergen');
INSERT INTO buurt (code, naam) VALUES (1830200, 'Harbrinkhoek kern');
INSERT INTO buurt (code, naam) VALUES (1830201, 'Mariaparochie');
INSERT INTO buurt (code, naam) VALUES (1830209, 'Verspreide huizen Harbrinkhoek');
INSERT INTO buurt (code, naam) VALUES (1830300, 'Geesteren kern');
INSERT INTO buurt (code, naam) VALUES (1830309, 'Verspreide huizen Geesteren');
INSERT INTO buurt (code, naam) VALUES (1830400, 'Langeveen kern');
INSERT INTO buurt (code, naam) VALUES (1830409, 'Verspreide huizen Langeveen');
INSERT INTO buurt (code, naam) VALUES (1830500, 'Vasse kern');
INSERT INTO buurt (code, naam) VALUES (1830507, 'Verspreide huizen Hezingen');
INSERT INTO buurt (code, naam) VALUES (1830508, 'Verspreide huizen Vasse');
INSERT INTO buurt (code, naam) VALUES (1830509, 'Verspreide huizen Mander');
INSERT INTO buurt (code, naam) VALUES (1830600, 'Reutum kern');
INSERT INTO buurt (code, naam) VALUES (1830608, 'Verspreide huizen Haarle');
INSERT INTO buurt (code, naam) VALUES (1830609, 'Verspreide huizen Reutum');
INSERT INTO buurt (code, naam) VALUES (1830700, 'Fleringen kern');
INSERT INTO buurt (code, naam) VALUES (1830709, 'Verspreide huizen Fleringen');
INSERT INTO buurt (code, naam) VALUES (1840000, 'Urk-Kom');
INSERT INTO buurt (code, naam) VALUES (1840002, 'Toppad');
INSERT INTO buurt (code, naam) VALUES (1840003, 'Urk-Noord');
INSERT INTO buurt (code, naam) VALUES (1840004, 'Havens en industrieterrein');
INSERT INTO buurt (code, naam) VALUES (1840006, 'De Reede');
INSERT INTO buurt (code, naam) VALUES (1840007, 'Urkerhard');
INSERT INTO buurt (code, naam) VALUES (1840008, 'De Top');
INSERT INTO buurt (code, naam) VALUES (1840009, 'Buitengebied');
INSERT INTO buurt (code, naam) VALUES (1840010, 'De Staart');
INSERT INTO buurt (code, naam) VALUES (1840011, 'Urkerland');
INSERT INTO buurt (code, naam) VALUES (1840015, 'Industrieterrein II');
INSERT INTO buurt (code, naam) VALUES (1849997, '');
INSERT INTO buurt (code, naam) VALUES (1890000, 'Wierden-Centrum');
INSERT INTO buurt (code, naam) VALUES (1890001, 'Wierden-Noord');
INSERT INTO buurt (code, naam) VALUES (1890002, 'Wierden-West');
INSERT INTO buurt (code, naam) VALUES (1890003, 'De Maaten');
INSERT INTO buurt (code, naam) VALUES (1890004, 'Wierden-Oost');
INSERT INTO buurt (code, naam) VALUES (1890005, 'De Stouwe');
INSERT INTO buurt (code, naam) VALUES (1890006, '''t Loo');
INSERT INTO buurt (code, naam) VALUES (1890007, 'De Hooilanden');
INSERT INTO buurt (code, naam) VALUES (1890008, 'Zuidbroek');
INSERT INTO buurt (code, naam) VALUES (1890105, 'Verspreide huizen Lage Egge en omgeving');
INSERT INTO buurt (code, naam) VALUES (1890106, 'Verspreide huizen Broeklanden');
INSERT INTO buurt (code, naam) VALUES (1890107, 'Verspreide huizen Huurne I');
INSERT INTO buurt (code, naam) VALUES (1890108, 'Verspreide huizen Huurne II');
INSERT INTO buurt (code, naam) VALUES (1890109, 'Verspreide huizen Wierdenseveld');
INSERT INTO buurt (code, naam) VALUES (1890200, 'Hooge-Hexel kern');
INSERT INTO buurt (code, naam) VALUES (1890209, 'Verspreide huizen Hooge-Hexel');
INSERT INTO buurt (code, naam) VALUES (1890300, 'Enter-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (1890301, 'Enter-Noordwest');
INSERT INTO buurt (code, naam) VALUES (1890302, 'Enter-Oost');
INSERT INTO buurt (code, naam) VALUES (1890303, 'Enter-West');
INSERT INTO buurt (code, naam) VALUES (1890405, 'Verspreide huizen IJpelo');
INSERT INTO buurt (code, naam) VALUES (1890406, 'Verspreide huizen Waterhoek');
INSERT INTO buurt (code, naam) VALUES (1890407, 'Verspreide huizen Enterveen en Elsslagen');
INSERT INTO buurt (code, naam) VALUES (1890408, 'Verspreide huizen Zuiderveld');
INSERT INTO buurt (code, naam) VALUES (1890409, 'Verspreide huizen Enterbroek en omgeving');
INSERT INTO buurt (code, naam) VALUES (1890507, 'Verspreide huizen Rectum');
INSERT INTO buurt (code, naam) VALUES (1890508, 'Verspreide huizen Notter');
INSERT INTO buurt (code, naam) VALUES (1890509, 'Verspreide huizen Zuna');
INSERT INTO buurt (code, naam) VALUES (1931000, 'Binnenstad-Zuid');
INSERT INTO buurt (code, naam) VALUES (1931010, 'Binnenstad-Noord');
INSERT INTO buurt (code, naam) VALUES (1931020, 'Noordereiland');
INSERT INTO buurt (code, naam) VALUES (1931100, 'Het Noorden');
INSERT INTO buurt (code, naam) VALUES (1931110, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (1931120, 'Bollebieste');
INSERT INTO buurt (code, naam) VALUES (1931130, 'Dieze-Centrum');
INSERT INTO buurt (code, naam) VALUES (1931140, 'Bagijneweide');
INSERT INTO buurt (code, naam) VALUES (1931150, 'Hogenkamp');
INSERT INTO buurt (code, naam) VALUES (1931160, 'Indischebuurt');
INSERT INTO buurt (code, naam) VALUES (1931170, 'Meppelerstraatweg-Zuid');
INSERT INTO buurt (code, naam) VALUES (1931180, 'Bedrijventerrein Floresstraat');
INSERT INTO buurt (code, naam) VALUES (1931200, 'Wipstrik-Noord');
INSERT INTO buurt (code, naam) VALUES (1931210, 'Wipstrik-Zuid');
INSERT INTO buurt (code, naam) VALUES (1931300, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (1931310, 'Oud-Assendorp');
INSERT INTO buurt (code, naam) VALUES (1931320, 'Nieuw-Assendorp');
INSERT INTO buurt (code, naam) VALUES (1931330, 'Wezenlanden');
INSERT INTO buurt (code, naam) VALUES (1931340, 'Pierik');
INSERT INTO buurt (code, naam) VALUES (1931350, 'Bedrijventerrein Marslanden-Noord');
INSERT INTO buurt (code, naam) VALUES (1931360, 'Hanzeland');
INSERT INTO buurt (code, naam) VALUES (1931400, 'Kamperpoort');
INSERT INTO buurt (code, naam) VALUES (1931410, 'Veerallee');
INSERT INTO buurt (code, naam) VALUES (1932000, 'Bedrijventerrein Voorst-A');
INSERT INTO buurt (code, naam) VALUES (1932010, 'Bedrijventerrein Voorst-B');
INSERT INTO buurt (code, naam) VALUES (1932020, 'Spoolde');
INSERT INTO buurt (code, naam) VALUES (1932100, 'Oud-Westenholte');
INSERT INTO buurt (code, naam) VALUES (1932110, 'Westenholte-Stins');
INSERT INTO buurt (code, naam) VALUES (1932120, 'Vreugderijk');
INSERT INTO buurt (code, naam) VALUES (1932130, 'Bedrijventerrein Voorst-C');
INSERT INTO buurt (code, naam) VALUES (1932140, 'Bedrijventerrein Voorst-D');
INSERT INTO buurt (code, naam) VALUES (1932200, 'Frankhuis');
INSERT INTO buurt (code, naam) VALUES (1932210, 'Mastenbroek');
INSERT INTO buurt (code, naam) VALUES (1932220, 'Schoonhorst');
INSERT INTO buurt (code, naam) VALUES (1932230, 'Werkeren');
INSERT INTO buurt (code, naam) VALUES (1932240, 'Millingen');
INSERT INTO buurt (code, naam) VALUES (1932250, 'Tippe bij de Ijssel');
INSERT INTO buurt (code, naam) VALUES (1932260, 'Breecamp');
INSERT INTO buurt (code, naam) VALUES (1932270, 'Breezicht');
INSERT INTO buurt (code, naam) VALUES (1932280, 'Stadsbroek');
INSERT INTO buurt (code, naam) VALUES (1933000, 'Holtenbroek IV');
INSERT INTO buurt (code, naam) VALUES (1933010, 'Holtenbroek I');
INSERT INTO buurt (code, naam) VALUES (1933020, 'Holtenbroek II');
INSERT INTO buurt (code, naam) VALUES (1933030, 'Holtenbroek III');
INSERT INTO buurt (code, naam) VALUES (1933100, 'Aalanden-Zuid');
INSERT INTO buurt (code, naam) VALUES (1933110, 'Aalanden-Midden');
INSERT INTO buurt (code, naam) VALUES (1933120, 'Aalanden-Noord');
INSERT INTO buurt (code, naam) VALUES (1933130, 'Aalanden-Oost');
INSERT INTO buurt (code, naam) VALUES (1933200, 'Brinkhoek');
INSERT INTO buurt (code, naam) VALUES (1933210, 'Langenholte');
INSERT INTO buurt (code, naam) VALUES (1933220, 'Haerst');
INSERT INTO buurt (code, naam) VALUES (1934000, 'Berkum');
INSERT INTO buurt (code, naam) VALUES (1934010, 'Bedrijventerrein de Vrolijkheid');
INSERT INTO buurt (code, naam) VALUES (1934020, 'Veldhoek');
INSERT INTO buurt (code, naam) VALUES (1934030, 'Kantorenterrein-Oosterenk');
INSERT INTO buurt (code, naam) VALUES (1934040, 'Bedrijventerrein Hessenpoort');
INSERT INTO buurt (code, naam) VALUES (1934050, 'Tolhuislanden');
INSERT INTO buurt (code, naam) VALUES (1934100, 'Herfte');
INSERT INTO buurt (code, naam) VALUES (1934110, 'Bedrijventerrein Marslanden-Zuid');
INSERT INTO buurt (code, naam) VALUES (1934120, 'Wijthmen');
INSERT INTO buurt (code, naam) VALUES (1935000, 'Oud Schelle');
INSERT INTO buurt (code, naam) VALUES (1935010, 'Schellerhoek');
INSERT INTO buurt (code, naam) VALUES (1935020, 'Schellerbroek');
INSERT INTO buurt (code, naam) VALUES (1935030, 'Schellerlanden');
INSERT INTO buurt (code, naam) VALUES (1935040, 'Oldenelerlanden-Oost');
INSERT INTO buurt (code, naam) VALUES (1935050, 'Oldenelerlanden-West');
INSERT INTO buurt (code, naam) VALUES (1935060, 'Oldenelerbroek');
INSERT INTO buurt (code, naam) VALUES (1935070, 'Schelle-Zuid en Oldeneel');
INSERT INTO buurt (code, naam) VALUES (1935080, 'Katerveer-Engelse Werk');
INSERT INTO buurt (code, naam) VALUES (1935100, 'Oud Ittersum');
INSERT INTO buurt (code, naam) VALUES (1935110, 'Ittersumerlanden');
INSERT INTO buurt (code, naam) VALUES (1935120, 'Ittersumerbroek');
INSERT INTO buurt (code, naam) VALUES (1935130, 'Geren');
INSERT INTO buurt (code, naam) VALUES (1935140, 'Gerenlanden');
INSERT INTO buurt (code, naam) VALUES (1935150, 'Gerenbroek');
INSERT INTO buurt (code, naam) VALUES (1935160, 'Oude Mars');
INSERT INTO buurt (code, naam) VALUES (1935200, 'Windesheim');
INSERT INTO buurt (code, naam) VALUES (1935210, 'Harculo en Hoogzutmen');
INSERT INTO buurt (code, naam) VALUES (1960000, 'Lobith');
INSERT INTO buurt (code, naam) VALUES (1960001, 'Tolkamer');
INSERT INTO buurt (code, naam) VALUES (1960002, 'Spijk');
INSERT INTO buurt (code, naam) VALUES (1960003, 'Herwen');
INSERT INTO buurt (code, naam) VALUES (1960004, 'Aerdt');
INSERT INTO buurt (code, naam) VALUES (1960005, 'Verspreide huizen Spijk');
INSERT INTO buurt (code, naam) VALUES (1960006, 'Verspreide huizen Herwen');
INSERT INTO buurt (code, naam) VALUES (1960007, 'Verspreide huizen Aerdt');
INSERT INTO buurt (code, naam) VALUES (1960008, 'Verspreide huizen Gelderse Waard');
INSERT INTO buurt (code, naam) VALUES (1960009, 'Verspreide huizen Geitenwaard');
INSERT INTO buurt (code, naam) VALUES (1960010, 'Verspreide huizen Bijland');
INSERT INTO buurt (code, naam) VALUES (1960011, 'Verspreide huizen Reimerswaard');
INSERT INTO buurt (code, naam) VALUES (1960012, 'Verspreide huizen Ossenwaard');
INSERT INTO buurt (code, naam) VALUES (1960013, 'Verspreide huizen Spijkse Buitenland');
INSERT INTO buurt (code, naam) VALUES (1960100, 'Pannerden');
INSERT INTO buurt (code, naam) VALUES (1960101, 'Verspreide huizen Pannerden');
INSERT INTO buurt (code, naam) VALUES (1960108, 'Verspreide huizen Pannerdense Waard');
INSERT INTO buurt (code, naam) VALUES (1960109, 'Verspreide huizen Lobberdense Waard');
INSERT INTO buurt (code, naam) VALUES (1970101, 'Barlo-Kern');
INSERT INTO buurt (code, naam) VALUES (1970102, 'Verspreide huizen Barlo');
INSERT INTO buurt (code, naam) VALUES (1970103, 'Verspreide huizen Heurne');
INSERT INTO buurt (code, naam) VALUES (1970104, 'Verspreide huizen IJzerlo');
INSERT INTO buurt (code, naam) VALUES (1970105, 'Ijzerlo-kern');
INSERT INTO buurt (code, naam) VALUES (1970106, 'Lintelo-kern');
INSERT INTO buurt (code, naam) VALUES (1970107, 'Verspreide huizen ten westen van Aalten');
INSERT INTO buurt (code, naam) VALUES (1970108, 'Verspreide huizen Lintelo');
INSERT INTO buurt (code, naam) VALUES (1970109, 'Verspreide huizen Dalese Veld');
INSERT INTO buurt (code, naam) VALUES (1970110, 'Verspreide huizen Dale');
INSERT INTO buurt (code, naam) VALUES (1970111, 'Verspreide huizen Haart');
INSERT INTO buurt (code, naam) VALUES (1970112, 'Haart-kern');
INSERT INTO buurt (code, naam) VALUES (1970201, 'Verspreide huizen Bredevoort');
INSERT INTO buurt (code, naam) VALUES (1970202, 'Verspreide huizen Hollenberg');
INSERT INTO buurt (code, naam) VALUES (1970203, 'Verspreide huizen Het Zwanenbroek');
INSERT INTO buurt (code, naam) VALUES (1970204, 'Bredevoort');
INSERT INTO buurt (code, naam) VALUES (1970301, 'Aalten-kern West');
INSERT INTO buurt (code, naam) VALUES (1970302, 'Aalten-kern Zuid 1');
INSERT INTO buurt (code, naam) VALUES (1970303, 'Aalten-kern Zuid 2');
INSERT INTO buurt (code, naam) VALUES (1970304, 'Aalten-kern Noord/Noordoost');
INSERT INTO buurt (code, naam) VALUES (1970305, 'Aalten Kern ''t Kobus');
INSERT INTO buurt (code, naam) VALUES (1970306, 'Aalten-kern Oost');
INSERT INTO buurt (code, naam) VALUES (1970307, 'Aalten-kern Centrum');
INSERT INTO buurt (code, naam) VALUES (1970400, 'Dinxperlo Centrum/Oost');
INSERT INTO buurt (code, naam) VALUES (1970401, 'Dinxperlo Noord');
INSERT INTO buurt (code, naam) VALUES (1970402, 'Dinxperlo West');
INSERT INTO buurt (code, naam) VALUES (1970403, 'De Heurne-kern');
INSERT INTO buurt (code, naam) VALUES (1970408, 'Verspreide huizen Dinxperlo');
INSERT INTO buurt (code, naam) VALUES (1970409, 'Verspreide huizen De Heurne');
INSERT INTO buurt (code, naam) VALUES (2000101, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (2000102, 'De Haven');
INSERT INTO buurt (code, naam) VALUES (2000201, 'Brinkhorst');
INSERT INTO buurt (code, naam) VALUES (2000202, 'Sprengenweg-Noord');
INSERT INTO buurt (code, naam) VALUES (2000203, 'Sprengenbos');
INSERT INTO buurt (code, naam) VALUES (2000204, 'Berg en Bos');
INSERT INTO buurt (code, naam) VALUES (2000205, 'Driehuizen');
INSERT INTO buurt (code, naam) VALUES (2000206, 'Orden');
INSERT INTO buurt (code, naam) VALUES (2000207, 'Park Berg en Bos');
INSERT INTO buurt (code, naam) VALUES (2000301, 'Ugchelen');
INSERT INTO buurt (code, naam) VALUES (2000302, 'Ugchelen-Zuid');
INSERT INTO buurt (code, naam) VALUES (2000303, 'De Heeze');
INSERT INTO buurt (code, naam) VALUES (2000304, 'Westenenk');
INSERT INTO buurt (code, naam) VALUES (2000305, 'Winkewijert');
INSERT INTO buurt (code, naam) VALUES (2000306, 'De Bouwhof');
INSERT INTO buurt (code, naam) VALUES (2000307, 'Brouwersmolen-Noord');
INSERT INTO buurt (code, naam) VALUES (2000308, 'Dennenheuvel');
INSERT INTO buurt (code, naam) VALUES (2000309, 'Holthuizen');
INSERT INTO buurt (code, naam) VALUES (2000310, 'Brouwersmolen-Zuid');
INSERT INTO buurt (code, naam) VALUES (2000311, 'Wernem');
INSERT INTO buurt (code, naam) VALUES (2000401, 'Brummelhof');
INSERT INTO buurt (code, naam) VALUES (2000402, 'Vogelkwartier');
INSERT INTO buurt (code, naam) VALUES (2000403, 'Staatsliedenkwartier');
INSERT INTO buurt (code, naam) VALUES (2000404, 'Componistenkwartier');
INSERT INTO buurt (code, naam) VALUES (2000405, 'Rivierenkwartier');
INSERT INTO buurt (code, naam) VALUES (2000406, 'Malkenschoten');
INSERT INTO buurt (code, naam) VALUES (2000407, 'Kayersmolen-Noord');
INSERT INTO buurt (code, naam) VALUES (2000408, 'Kayersmolen-Midden');
INSERT INTO buurt (code, naam) VALUES (2000409, 'Kayersmolen-Zuid');
INSERT INTO buurt (code, naam) VALUES (2000501, 'Matendreef');
INSERT INTO buurt (code, naam) VALUES (2000502, 'Matenhorst');
INSERT INTO buurt (code, naam) VALUES (2000503, 'Matendonk');
INSERT INTO buurt (code, naam) VALUES (2000504, 'Matenhoeve');
INSERT INTO buurt (code, naam) VALUES (2000505, 'Matenveld');
INSERT INTO buurt (code, naam) VALUES (2000506, 'Matengaarde');
INSERT INTO buurt (code, naam) VALUES (2000507, 'Matenhoek');
INSERT INTO buurt (code, naam) VALUES (2000508, 'Kuipersveld');
INSERT INTO buurt (code, naam) VALUES (2000601, 'Welgelegen');
INSERT INTO buurt (code, naam) VALUES (2000602, 'Osseveld-West');
INSERT INTO buurt (code, naam) VALUES (2000603, 'Osseveld-Oost');
INSERT INTO buurt (code, naam) VALUES (2000604, 'Woudhuis');
INSERT INTO buurt (code, naam) VALUES (2000605, 'Groot Zonnehoeve');
INSERT INTO buurt (code, naam) VALUES (2000606, 'De Voorwaarts');
INSERT INTO buurt (code, naam) VALUES (2000607, 'Bedrijvenpark Ecofactorij');
INSERT INTO buurt (code, naam) VALUES (2000608, 'Bedrijvenpark Oost');
INSERT INTO buurt (code, naam) VALUES (2000701, 'Zevenhuizen');
INSERT INTO buurt (code, naam) VALUES (2000702, 'Sluisoord');
INSERT INTO buurt (code, naam) VALUES (2000703, 'De Mheen');
INSERT INTO buurt (code, naam) VALUES (2000704, 'Anklaar');
INSERT INTO buurt (code, naam) VALUES (2000705, 'Sprenkelaar');
INSERT INTO buurt (code, naam) VALUES (2000706, 'Bedrijvenpark Apeldoorn-Noord');
INSERT INTO buurt (code, naam) VALUES (2000707, 'Sleutelbloem');
INSERT INTO buurt (code, naam) VALUES (2000708, 'Zuidbroek-Mozaïek & Rooster');
INSERT INTO buurt (code, naam) VALUES (2000709, 'Zuidbroek-De Wellen');
INSERT INTO buurt (code, naam) VALUES (2000801, 'Parken');
INSERT INTO buurt (code, naam) VALUES (2000802, 'Spainkbos');
INSERT INTO buurt (code, naam) VALUES (2000803, 'Loolaan-Noord');
INSERT INTO buurt (code, naam) VALUES (2000804, 'Het Loo');
INSERT INTO buurt (code, naam) VALUES (2000805, 'Kerschoten-West');
INSERT INTO buurt (code, naam) VALUES (2000806, 'Kerschoten');
INSERT INTO buurt (code, naam) VALUES (2000807, 'Paleispark');
INSERT INTO buurt (code, naam) VALUES (2000808, 'De Vlijt');
INSERT INTO buurt (code, naam) VALUES (2000809, 'Stadhoudersmolen');
INSERT INTO buurt (code, naam) VALUES (2000810, 'Hommelbrink');
INSERT INTO buurt (code, naam) VALUES (2001001, 'Uddel');
INSERT INTO buurt (code, naam) VALUES (2001002, 'Agrarisch gebied Uddel');
INSERT INTO buurt (code, naam) VALUES (2001003, 'Bosgebied Meerveld');
INSERT INTO buurt (code, naam) VALUES (2001004, 'Bosgebied Nieuw Milligen');
INSERT INTO buurt (code, naam) VALUES (2001101, 'Orderbos');
INSERT INTO buurt (code, naam) VALUES (2001102, 'Hoog Soeren');
INSERT INTO buurt (code, naam) VALUES (2001103, 'Bosgebied Hoog Soeren');
INSERT INTO buurt (code, naam) VALUES (2001104, 'Bosgebied Hoog Buurloo');
INSERT INTO buurt (code, naam) VALUES (2001201, 'Hoenderloo');
INSERT INTO buurt (code, naam) VALUES (2001202, 'Bosgebied Ugchelen');
INSERT INTO buurt (code, naam) VALUES (2001203, 'Bosgebied Hoenderloo');
INSERT INTO buurt (code, naam) VALUES (2001204, 'Miggelenberg');
INSERT INTO buurt (code, naam) VALUES (2001301, 'Het Goreld');
INSERT INTO buurt (code, naam) VALUES (2001302, 'Loenen');
INSERT INTO buurt (code, naam) VALUES (2001303, 'Bosgebied Loenen');
INSERT INTO buurt (code, naam) VALUES (2001401, 'Beekbergen');
INSERT INTO buurt (code, naam) VALUES (2001402, 'Bosgebied Beekbergen-West');
INSERT INTO buurt (code, naam) VALUES (2001403, 'Agrarisch gebied Beekbergen');
INSERT INTO buurt (code, naam) VALUES (2001404, 'Bosgebied Beekbergen-Zuid');
INSERT INTO buurt (code, naam) VALUES (2001501, 'Lieren');
INSERT INTO buurt (code, naam) VALUES (2001502, 'Agrarisch gebied Lieren en Oosterhuizen');
INSERT INTO buurt (code, naam) VALUES (2001503, 'Bosgebied Oosterhuizen');
INSERT INTO buurt (code, naam) VALUES (2001601, 'Woudhuis');
INSERT INTO buurt (code, naam) VALUES (2001602, 'Klarenbeek');
INSERT INTO buurt (code, naam) VALUES (2001603, 'De Hooilanden');
INSERT INTO buurt (code, naam) VALUES (2001604, 'De Hooilanden en Oosterhuizen');
INSERT INTO buurt (code, naam) VALUES (2001701, 'Wenum');
INSERT INTO buurt (code, naam) VALUES (2001702, 'Beemte');
INSERT INTO buurt (code, naam) VALUES (2001703, 'Bosgebied Wiesel');
INSERT INTO buurt (code, naam) VALUES (2001704, 'Agrarisch gebied Wiesel');
INSERT INTO buurt (code, naam) VALUES (2001705, 'Agrarisch gebied Wenum');
INSERT INTO buurt (code, naam) VALUES (2001706, 'Agrarisch gebied Beemte en Broekland');
INSERT INTO buurt (code, naam) VALUES (2020100, 'Markt');
INSERT INTO buurt (code, naam) VALUES (2020101, 'Weverstraat');
INSERT INTO buurt (code, naam) VALUES (2020102, 'Rijnstraat');
INSERT INTO buurt (code, naam) VALUES (2020103, 'Janssingel');
INSERT INTO buurt (code, naam) VALUES (2020104, 'Stationsplein');
INSERT INTO buurt (code, naam) VALUES (2020170, 'Utrechtsestraat');
INSERT INTO buurt (code, naam) VALUES (2020210, 'Hommelstraat');
INSERT INTO buurt (code, naam) VALUES (2020211, 'Spijkerbuurt');
INSERT INTO buurt (code, naam) VALUES (2020212, 'Boulevardwijk');
INSERT INTO buurt (code, naam) VALUES (2020313, 'Bij de John Frostbrug');
INSERT INTO buurt (code, naam) VALUES (2020314, 'Statenkwartier');
INSERT INTO buurt (code, naam) VALUES (2020320, 'Arnhemse Broek');
INSERT INTO buurt (code, naam) VALUES (2020321, 'Van Verschuerbuurt');
INSERT INTO buurt (code, naam) VALUES (2020322, 'Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (2020423, 'Presikhaaf I');
INSERT INTO buurt (code, naam) VALUES (2020424, 'Presikhaaf II');
INSERT INTO buurt (code, naam) VALUES (2020425, 'Presikhaaf III');
INSERT INTO buurt (code, naam) VALUES (2020526, 'Over het Lange Water');
INSERT INTO buurt (code, naam) VALUES (2020527, 'Elsweide');
INSERT INTO buurt (code, naam) VALUES (2020528, 'Winkelcentrum Presikhaaf');
INSERT INTO buurt (code, naam) VALUES (2020529, 'IJsseloord');
INSERT INTO buurt (code, naam) VALUES (2020630, 'Sint Marten');
INSERT INTO buurt (code, naam) VALUES (2020631, 'Graaf Ottoplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (2020732, 'Klarendal-Zuid');
INSERT INTO buurt (code, naam) VALUES (2020733, 'Klarendal-Noord');
INSERT INTO buurt (code, naam) VALUES (2020734, 'Onder de Linden');
INSERT INTO buurt (code, naam) VALUES (2020735, 'Sint Janskerkstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (2020840, 'Velperweg-Noord');
INSERT INTO buurt (code, naam) VALUES (2020841, 'Molenbeke');
INSERT INTO buurt (code, naam) VALUES (2020842, 'Fabrieksterrein Enka');
INSERT INTO buurt (code, naam) VALUES (2020843, 'Plattenburg');
INSERT INTO buurt (code, naam) VALUES (2020844, 'Angerenstein');
INSERT INTO buurt (code, naam) VALUES (2020845, 'Paasberg');
INSERT INTO buurt (code, naam) VALUES (2020950, 'Sonsbeek-Noord');
INSERT INTO buurt (code, naam) VALUES (2020951, 'Hazegrietje');
INSERT INTO buurt (code, naam) VALUES (2020952, 'Alteveer-Cranevelt');
INSERT INTO buurt (code, naam) VALUES (2021053, 'Geitenkamp');
INSERT INTO buurt (code, naam) VALUES (2021154, 'Monnikenhuizen');
INSERT INTO buurt (code, naam) VALUES (2021155, 'Arnhemse Allee');
INSERT INTO buurt (code, naam) VALUES (2021159, 'Klarenbeek');
INSERT INTO buurt (code, naam) VALUES (2021260, 'Transvaalbuurt');
INSERT INTO buurt (code, naam) VALUES (2021261, 'Burgemeesterswijk');
INSERT INTO buurt (code, naam) VALUES (2021262, 'Gulden Bodem');
INSERT INTO buurt (code, naam) VALUES (2021263, 'Sterrenberg');
INSERT INTO buurt (code, naam) VALUES (2021264, 'Hoogkamp');
INSERT INTO buurt (code, naam) VALUES (2021269, 'Sonsbeek, Zijpendaal');
INSERT INTO buurt (code, naam) VALUES (2021365, 'Bakenberg');
INSERT INTO buurt (code, naam) VALUES (2021366, 'Schaarsbergen');
INSERT INTO buurt (code, naam) VALUES (2021367, 'Westelijk van Schaarsbergen');
INSERT INTO buurt (code, naam) VALUES (2021368, 'Noordoostelijk van Schaarsbergen');
INSERT INTO buurt (code, naam) VALUES (2021471, 'Lombok');
INSERT INTO buurt (code, naam) VALUES (2021473, 'Brouwerijweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (2021474, 'Heijenoord');
INSERT INTO buurt (code, naam) VALUES (2021572, 'Klingelbeek');
INSERT INTO buurt (code, naam) VALUES (2021579, 'Het Dorp, Mariëndaal');
INSERT INTO buurt (code, naam) VALUES (2021681, 'Meinerswijk en De Praets');
INSERT INTO buurt (code, naam) VALUES (2021682, 'Malburgen West');
INSERT INTO buurt (code, naam) VALUES (2021780, 'Groene Weide');
INSERT INTO buurt (code, naam) VALUES (2021783, 'Kamillehof en Bakenhof');
INSERT INTO buurt (code, naam) VALUES (2021815, '''t Duifje');
INSERT INTO buurt (code, naam) VALUES (2021884, 'Immerloo I');
INSERT INTO buurt (code, naam) VALUES (2021885, 'Middelgraaflaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (2021886, 'Zeegsingel en omgeving');
INSERT INTO buurt (code, naam) VALUES (2021888, 'Immerloo II');
INSERT INTO buurt (code, naam) VALUES (2021987, 'Eimersweide');
INSERT INTO buurt (code, naam) VALUES (2021989, 'Holthuizen');
INSERT INTO buurt (code, naam) VALUES (2021990, 'Kronenburg');
INSERT INTO buurt (code, naam) VALUES (2021993, 'Vredenburg');
INSERT INTO buurt (code, naam) VALUES (2022092, 'Elden');
INSERT INTO buurt (code, naam) VALUES (2022191, 'Elderveld-Zuid');
INSERT INTO buurt (code, naam) VALUES (2022194, 'Elderveld-Noord');
INSERT INTO buurt (code, naam) VALUES (2022197, 'Elderhof');
INSERT INTO buurt (code, naam) VALUES (2022295, 'De Laar-West');
INSERT INTO buurt (code, naam) VALUES (2022296, 'De Laar-Oost');
INSERT INTO buurt (code, naam) VALUES (2022316, 'Rijkerswoerd-Oost');
INSERT INTO buurt (code, naam) VALUES (2022317, 'Rijkerswoerd-Midden');
INSERT INTO buurt (code, naam) VALUES (2022318, 'Rijkerswoerd-West');
INSERT INTO buurt (code, naam) VALUES (2022319, 'Overmaat');
INSERT INTO buurt (code, naam) VALUES (2022447, 'Schuytgraaf-Noord');
INSERT INTO buurt (code, naam) VALUES (2022448, 'Schuytgraaf-Centrum');
INSERT INTO buurt (code, naam) VALUES (2022449, 'Schuytgraaf-Zuid');
INSERT INTO buurt (code, naam) VALUES (2035400, 'Buitengebied Barneveld');
INSERT INTO buurt (code, naam) VALUES (2035401, 'Centrum Barneveld');
INSERT INTO buurt (code, naam) VALUES (2035402, 'De Koot');
INSERT INTO buurt (code, naam) VALUES (2035403, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (2035404, 'De Lors');
INSERT INTO buurt (code, naam) VALUES (2035405, 'Staatsliedenwijk');
INSERT INTO buurt (code, naam) VALUES (2035406, 'De Valk');
INSERT INTO buurt (code, naam) VALUES (2035407, 'Vliegersveld');
INSERT INTO buurt (code, naam) VALUES (2035408, 'Rootselaar-West');
INSERT INTO buurt (code, naam) VALUES (2035409, 'Rootselaar-Oost');
INSERT INTO buurt (code, naam) VALUES (2035410, 'Oldenbarneveld');
INSERT INTO buurt (code, naam) VALUES (2035411, 'De Vaarst');
INSERT INTO buurt (code, naam) VALUES (2035412, 'Norschoten');
INSERT INTO buurt (code, naam) VALUES (2035413, 'De Briellared');
INSERT INTO buurt (code, naam) VALUES (2035414, 'De Burgt');
INSERT INTO buurt (code, naam) VALUES (2035415, 'Veller');
INSERT INTO buurt (code, naam) VALUES (2035425, 'Harselaar-West');
INSERT INTO buurt (code, naam) VALUES (2035426, 'Harselaar-Oost');
INSERT INTO buurt (code, naam) VALUES (2035530, 'Buitengebied Voorthuizen');
INSERT INTO buurt (code, naam) VALUES (2035531, 'Centrum Voorthuizen');
INSERT INTO buurt (code, naam) VALUES (2035532, 'Haarkamp');
INSERT INTO buurt (code, naam) VALUES (2035533, 'Roeleneng');
INSERT INTO buurt (code, naam) VALUES (2035534, 'Prinsessenwijk');
INSERT INTO buurt (code, naam) VALUES (2035535, 'De Wheem');
INSERT INTO buurt (code, naam) VALUES (2035536, 'De Steenkamp');
INSERT INTO buurt (code, naam) VALUES (2035537, 'Zeeheldenwijk');
INSERT INTO buurt (code, naam) VALUES (2035538, 'Componistenwijk');
INSERT INTO buurt (code, naam) VALUES (2035539, 'De Maat');
INSERT INTO buurt (code, naam) VALUES (2035540, 'De Kromme Akker');
INSERT INTO buurt (code, naam) VALUES (2035541, 'Blankensgoed');
INSERT INTO buurt (code, naam) VALUES (2035650, 'Buitengebied Kootwijkerbroek');
INSERT INTO buurt (code, naam) VALUES (2035651, 'Kootwijkerbroek');
INSERT INTO buurt (code, naam) VALUES (2035652, 'Kootwijkerbroek-west');
INSERT INTO buurt (code, naam) VALUES (2035780, 'Buitengebied Garderen');
INSERT INTO buurt (code, naam) VALUES (2035781, 'Garderen');
INSERT INTO buurt (code, naam) VALUES (2035875, 'Buitengebied Terschuur');
INSERT INTO buurt (code, naam) VALUES (2035876, 'terschuur');
INSERT INTO buurt (code, naam) VALUES (2035877, 'Blankenhoef');
INSERT INTO buurt (code, naam) VALUES (2035960, 'Buitengebied Stroe');
INSERT INTO buurt (code, naam) VALUES (2035961, 'Stroe');
INSERT INTO buurt (code, naam) VALUES (2036070, 'Buitengebied Zwartebroek');
INSERT INTO buurt (code, naam) VALUES (2036071, 'Zwartebroek');
INSERT INTO buurt (code, naam) VALUES (2036190, 'Buitengebied De Glind');
INSERT INTO buurt (code, naam) VALUES (2036191, 'De Glind');
INSERT INTO buurt (code, naam) VALUES (2036265, 'Buitengebied kootwijk');
INSERT INTO buurt (code, naam) VALUES (2036266, 'Kootwijk');
INSERT INTO buurt (code, naam) VALUES (2036395, 'Buitengebied Achterveld');
INSERT INTO buurt (code, naam) VALUES (2090100, 'Beuningen Buitengebied Noord');
INSERT INTO buurt (code, naam) VALUES (2090101, 'Beuningen Buitengebied Zuid');
INSERT INTO buurt (code, naam) VALUES (2090110, 'Beuningse Plas');
INSERT INTO buurt (code, naam) VALUES (2090111, 'Beuningen Centrum');
INSERT INTO buurt (code, naam) VALUES (2090112, 'Beuningen Centrum Oost');
INSERT INTO buurt (code, naam) VALUES (2090113, 'Beuningen De Haaghe');
INSERT INTO buurt (code, naam) VALUES (2090114, 'Beuningen De Notenhof');
INSERT INTO buurt (code, naam) VALUES (2090121, 'Beuningen Duivenkamp');
INSERT INTO buurt (code, naam) VALUES (2090122, 'Beuningen de Linde');
INSERT INTO buurt (code, naam) VALUES (2090123, 'Beuningen Hoeve-1');
INSERT INTO buurt (code, naam) VALUES (2090124, 'Beuningen Hoeve-2');
INSERT INTO buurt (code, naam) VALUES (2090125, 'Beuningen Hoeve-3');
INSERT INTO buurt (code, naam) VALUES (2090131, 'Beuningen Schoenaker');
INSERT INTO buurt (code, naam) VALUES (2090141, 'Beuningen Aalstervelden');
INSERT INTO buurt (code, naam) VALUES (2090142, 'Beuningen Olden Tempel');
INSERT INTO buurt (code, naam) VALUES (2090143, 'Beuningen Blanckenburgh');
INSERT INTO buurt (code, naam) VALUES (2090144, 'Beuningen Viermorgen');
INSERT INTO buurt (code, naam) VALUES (2090145, 'Beuningen Tinnegieter');
INSERT INTO buurt (code, naam) VALUES (2090146, 'Beuningen Den Balmerd');
INSERT INTO buurt (code, naam) VALUES (2090147, 'Beuningen Sportpark De Ooigraaf');
INSERT INTO buurt (code, naam) VALUES (2090151, 'Beuningen Heuve-1');
INSERT INTO buurt (code, naam) VALUES (2090152, 'Beuningen Heuve-2');
INSERT INTO buurt (code, naam) VALUES (2090153, 'Beuningen Heuve-3');
INSERT INTO buurt (code, naam) VALUES (2090154, 'Beuningen Heuve-4');
INSERT INTO buurt (code, naam) VALUES (2090161, 'Beuningen Beuningse Plas');
INSERT INTO buurt (code, naam) VALUES (2090202, 'Ewijk Buitengebied Noord-1');
INSERT INTO buurt (code, naam) VALUES (2090203, 'Ewijk Buitengebied Zuid-1');
INSERT INTO buurt (code, naam) VALUES (2090204, 'Ewijk Buitengebied Zuid-2');
INSERT INTO buurt (code, naam) VALUES (2090271, 'Ewijk Centrum');
INSERT INTO buurt (code, naam) VALUES (2090272, 'Ewijk Vording-2');
INSERT INTO buurt (code, naam) VALUES (2090273, 'Ewijk Vording-3');
INSERT INTO buurt (code, naam) VALUES (2090274, 'Ewijk Veluwstraat');
INSERT INTO buurt (code, naam) VALUES (2090275, 'Ewijk Keizershoeve');
INSERT INTO buurt (code, naam) VALUES (2090276, 'Ewijk Den Elt');
INSERT INTO buurt (code, naam) VALUES (2090305, 'Weurt Buitengebied Noord');
INSERT INTO buurt (code, naam) VALUES (2090306, 'Weurt Buitengebied Zuid');
INSERT INTO buurt (code, naam) VALUES (2090381, 'Weurt Noord');
INSERT INTO buurt (code, naam) VALUES (2090382, 'Weurt Zuid');
INSERT INTO buurt (code, naam) VALUES (2090383, 'De Sluis');
INSERT INTO buurt (code, naam) VALUES (2090407, 'Winssen Buitengebied Noord');
INSERT INTO buurt (code, naam) VALUES (2090408, 'Winssen Buitengebied Zuid-1');
INSERT INTO buurt (code, naam) VALUES (2090409, 'Winssen Buitengebied Zuid-2');
INSERT INTO buurt (code, naam) VALUES (2090491, 'Winssen Centrum');
INSERT INTO buurt (code, naam) VALUES (2130100, 'Empe Kern');
INSERT INTO buurt (code, naam) VALUES (2130101, 'Verspreide huizen Empe');
INSERT INTO buurt (code, naam) VALUES (2130102, 'Dovenkamp');
INSERT INTO buurt (code, naam) VALUES (2130200, 'Tonden');
INSERT INTO buurt (code, naam) VALUES (2130300, 'Brummen Centrum');
INSERT INTO buurt (code, naam) VALUES (2130301, 'Brummense Enk West');
INSERT INTO buurt (code, naam) VALUES (2130302, 'Brummense Enk Oost');
INSERT INTO buurt (code, naam) VALUES (2130303, 'De Pothof');
INSERT INTO buurt (code, naam) VALUES (2130304, 'Koppelenburg');
INSERT INTO buurt (code, naam) VALUES (2130305, 'Verspreide huizen Brummen');
INSERT INTO buurt (code, naam) VALUES (2130306, 'Rhienderen Kern');
INSERT INTO buurt (code, naam) VALUES (2130307, 'Rhienderen Noord');
INSERT INTO buurt (code, naam) VALUES (2130308, 'Rhienderense Enk');
INSERT INTO buurt (code, naam) VALUES (2130309, 'Elzenbos');
INSERT INTO buurt (code, naam) VALUES (2130310, 'Hazenberg');
INSERT INTO buurt (code, naam) VALUES (2130311, 'Verspreide huizen Rhienderen');
INSERT INTO buurt (code, naam) VALUES (2130312, 'Rhienderense Broek');
INSERT INTO buurt (code, naam) VALUES (2130313, 'Oeken kern');
INSERT INTO buurt (code, naam) VALUES (2130314, 'Verspreide huizen Oeken');
INSERT INTO buurt (code, naam) VALUES (2130315, 'Wapsum');
INSERT INTO buurt (code, naam) VALUES (2130316, 'Voorstonden');
INSERT INTO buurt (code, naam) VALUES (2130317, 'Cortenoever');
INSERT INTO buurt (code, naam) VALUES (2130400, 'Leuvenheim kern');
INSERT INTO buurt (code, naam) VALUES (2130401, 'Verspreide huizen Leuvenheim');
INSERT INTO buurt (code, naam) VALUES (2130402, 'Lichtenbelt');
INSERT INTO buurt (code, naam) VALUES (2130500, 'Hall kern');
INSERT INTO buurt (code, naam) VALUES (2130501, 'Verspreide huizen Hall');
INSERT INTO buurt (code, naam) VALUES (2130502, 'Cellenrijk');
INSERT INTO buurt (code, naam) VALUES (2130600, 'Eerbeek centrum');
INSERT INTO buurt (code, naam) VALUES (2130601, 'Lombok');
INSERT INTO buurt (code, naam) VALUES (2130602, 'Noorder Enk');
INSERT INTO buurt (code, naam) VALUES (2130603, 'Werfakker');
INSERT INTO buurt (code, naam) VALUES (2130604, 'Veldkant');
INSERT INTO buurt (code, naam) VALUES (2130605, 'Eerbeekse Enk');
INSERT INTO buurt (code, naam) VALUES (2130606, 'Eerbeek Zuid');
INSERT INTO buurt (code, naam) VALUES (2130607, 'Het Hungeling');
INSERT INTO buurt (code, naam) VALUES (2130608, 'Wilhelminapark');
INSERT INTO buurt (code, naam) VALUES (2130609, 'Verspreide huizen Eerbeek');
INSERT INTO buurt (code, naam) VALUES (2130610, 'Coldenhove');
INSERT INTO buurt (code, naam) VALUES (2140000, 'Buren-Oude Kern');
INSERT INTO buurt (code, naam) VALUES (2140001, 'Buren Appelenboomgaard');
INSERT INTO buurt (code, naam) VALUES (2140002, 'Buren Tielseweg');
INSERT INTO buurt (code, naam) VALUES (2140003, 'Asch');
INSERT INTO buurt (code, naam) VALUES (2140004, 'Erichem');
INSERT INTO buurt (code, naam) VALUES (2140006, 'Verspreide huizen poldergebied Buurmalsen');
INSERT INTO buurt (code, naam) VALUES (2140007, 'Verspreide huizen Erichem');
INSERT INTO buurt (code, naam) VALUES (2140008, 'Verspreide huizen Asch');
INSERT INTO buurt (code, naam) VALUES (2140009, 'Verspreide huizen Buren');
INSERT INTO buurt (code, naam) VALUES (2140100, 'Beusichem');
INSERT INTO buurt (code, naam) VALUES (2140101, 'Zoelmond');
INSERT INTO buurt (code, naam) VALUES (2140109, 'Verspreide huizen Beusichem en Zoelmond');
INSERT INTO buurt (code, naam) VALUES (2140200, 'Zoelen');
INSERT INTO buurt (code, naam) VALUES (2140201, 'Kerk Avezaath');
INSERT INTO buurt (code, naam) VALUES (2140202, 'De Woerd');
INSERT INTO buurt (code, naam) VALUES (2140206, 'Verspreide huizen ten oosten van kanaal');
INSERT INTO buurt (code, naam) VALUES (2140207, 'Verspreide huizen Zoelen');
INSERT INTO buurt (code, naam) VALUES (2140208, 'Verspreide huizen Kerk Avezaath');
INSERT INTO buurt (code, naam) VALUES (2140209, 'Verspreide huizen Kapel Avezaath');
INSERT INTO buurt (code, naam) VALUES (2140300, 'Lienden');
INSERT INTO buurt (code, naam) VALUES (2140301, 'Ommeren met Den Eng');
INSERT INTO buurt (code, naam) VALUES (2140305, 'Ommerveld en verspreide huizen polder Meerten');
INSERT INTO buurt (code, naam) VALUES (2140306, 'Verspreide huizen Aalst Leutes polder Aalst');
INSERT INTO buurt (code, naam) VALUES (2140307, 'Verspreide huizen De Mars en Marsdijk');
INSERT INTO buurt (code, naam) VALUES (2140308, 'Verspreide huizen Lienden');
INSERT INTO buurt (code, naam) VALUES (2140400, 'Ingen');
INSERT INTO buurt (code, naam) VALUES (2140402, 'Klinkenberg');
INSERT INTO buurt (code, naam) VALUES (2140408, 'Verspreide huizen Klinkenberg');
INSERT INTO buurt (code, naam) VALUES (2140409, 'Verspreide huizen Ommerenveld en Zwarte Paard');
INSERT INTO buurt (code, naam) VALUES (2140500, 'Maurik');
INSERT INTO buurt (code, naam) VALUES (2140501, 'Rijswijk');
INSERT INTO buurt (code, naam) VALUES (2140502, 'Eck en Wiel');
INSERT INTO buurt (code, naam) VALUES (2140503, 'Ganzert');
INSERT INTO buurt (code, naam) VALUES (2140507, 'Verspreide huizen Rijswijk');
INSERT INTO buurt (code, naam) VALUES (2140508, 'Verspreide huizen Maurik');
INSERT INTO buurt (code, naam) VALUES (2140509, 'Verspreide huizen Eck en Wiel');
INSERT INTO buurt (code, naam) VALUES (2140600, 'Ravenswaaij');
INSERT INTO buurt (code, naam) VALUES (2140608, 'Verspreide huizen Ravenswaaij');
INSERT INTO buurt (code, naam) VALUES (2140609, 'Verspreide huizen poldergebied');
INSERT INTO buurt (code, naam) VALUES (2160000, 'Oude Binnenstad en Nieuwstad');
INSERT INTO buurt (code, naam) VALUES (2160001, 'Oude Buitenwijken');
INSERT INTO buurt (code, naam) VALUES (2160002, 'Noordoostelijke Buitenwijken');
INSERT INTO buurt (code, naam) VALUES (2160003, 'Zuidoostelijke Buitenwijken Ter Weijde');
INSERT INTO buurt (code, naam) VALUES (2160004, 'Industriegebied');
INSERT INTO buurt (code, naam) VALUES (2160005, 'Westelijke Buitenwijken');
INSERT INTO buurt (code, naam) VALUES (2160008, 'Verspreide huizen Redichem');
INSERT INTO buurt (code, naam) VALUES (2160009, 'Verspreide huizen ten westen en zuiden van Culemborg');
INSERT INTO buurt (code, naam) VALUES (2210100, 'De oude Stad binnen de gracht');
INSERT INTO buurt (code, naam) VALUES (2210101, 'Noordelijk Molenveld');
INSERT INTO buurt (code, naam) VALUES (2210102, 'Zuidelijk Molenveld');
INSERT INTO buurt (code, naam) VALUES (2210103, 'De Ooi');
INSERT INTO buurt (code, naam) VALUES (2210104, 'Beinum I');
INSERT INTO buurt (code, naam) VALUES (2210105, 'Beinum II');
INSERT INTO buurt (code, naam) VALUES (2210106, 'Bedrijventerrein Beinum');
INSERT INTO buurt (code, naam) VALUES (2210107, 'Bedrijventerrein Verhuellweg');
INSERT INTO buurt (code, naam) VALUES (2210108, 'Verspreide huizen Noordoost');
INSERT INTO buurt (code, naam) VALUES (2210109, 'Verspreide huizen Fraterswaard-Noordoost');
INSERT INTO buurt (code, naam) VALUES (2210110, 'Verspreide huizen IJssel en Oude IJssel');
INSERT INTO buurt (code, naam) VALUES (2220101, 'Stadscentrum-Zuid');
INSERT INTO buurt (code, naam) VALUES (2220102, 'Torenallee');
INSERT INTO buurt (code, naam) VALUES (2220103, 'Het Loo');
INSERT INTO buurt (code, naam) VALUES (2220104, 'Stadscentrum-Noord');
INSERT INTO buurt (code, naam) VALUES (2220105, 'De Pas-Noord');
INSERT INTO buurt (code, naam) VALUES (2220106, 'De Pas-Zuid');
INSERT INTO buurt (code, naam) VALUES (2220201, 'Muziekbuurt');
INSERT INTO buurt (code, naam) VALUES (2220202, 'Schrijvers en dichtersbuurt');
INSERT INTO buurt (code, naam) VALUES (2220203, 'Wiltinksbrug');
INSERT INTO buurt (code, naam) VALUES (2220204, 'Overstegen-West');
INSERT INTO buurt (code, naam) VALUES (2220205, 'Overstegen-Oost');
INSERT INTO buurt (code, naam) VALUES (2220206, 'Wonninkhage');
INSERT INTO buurt (code, naam) VALUES (2220207, 'Buitengebied de Gaarde');
INSERT INTO buurt (code, naam) VALUES (2220208, 'Wassinkbrink-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (2220301, 'Holterbroek');
INSERT INTO buurt (code, naam) VALUES (2220302, 'Schöneveld-Zuid');
INSERT INTO buurt (code, naam) VALUES (2220303, 'Schöneveld-Noord');
INSERT INTO buurt (code, naam) VALUES (2220401, 'Oosseld en Vijverberg-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (2220402, 'Buitengebied Polmanlaan');
INSERT INTO buurt (code, naam) VALUES (2220403, 'Buitengebied de Wrange');
INSERT INTO buurt (code, naam) VALUES (2220404, 'Koekendaal en Vijverberg-Noordoost');
INSERT INTO buurt (code, naam) VALUES (2220405, 'Buitengebied Vossenstraat');
INSERT INTO buurt (code, naam) VALUES (2220406, 'Buitengebied Nutselaer en Abdij');
INSERT INTO buurt (code, naam) VALUES (2220407, 'Buitengebied IJzevoorde');
INSERT INTO buurt (code, naam) VALUES (2220408, 'Buitengebied Slangenburg');
INSERT INTO buurt (code, naam) VALUES (2220501, 'Hamburgerbroek');
INSERT INTO buurt (code, naam) VALUES (2220502, 'Verheulsweide-Noord');
INSERT INTO buurt (code, naam) VALUES (2220503, 'Verheulsweide-Zuid');
INSERT INTO buurt (code, naam) VALUES (2220504, 'Buitengebied Kemnaderallee');
INSERT INTO buurt (code, naam) VALUES (2220601, 'De Hoop-Noord');
INSERT INTO buurt (code, naam) VALUES (2220602, 'De Huet fase 1 + 3');
INSERT INTO buurt (code, naam) VALUES (2220603, 'De Huet fase 2');
INSERT INTO buurt (code, naam) VALUES (2220604, 'De Huet fase 4');
INSERT INTO buurt (code, naam) VALUES (2220605, 'De Huet fase 6 + 7');
INSERT INTO buurt (code, naam) VALUES (2220606, 'De Huet fase 5');
INSERT INTO buurt (code, naam) VALUES (2220607, 'Sportpark Zuid');
INSERT INTO buurt (code, naam) VALUES (2220608, 'Bedrijventerrein De Huet');
INSERT INTO buurt (code, naam) VALUES (2220609, 'Buitengebied De Huet');
INSERT INTO buurt (code, naam) VALUES (2220701, 'Buitengebied Dichteren Noordwest');
INSERT INTO buurt (code, naam) VALUES (2220702, 'Romantische buurt Noord');
INSERT INTO buurt (code, naam) VALUES (2220703, 'Romantische buurt Zuid');
INSERT INTO buurt (code, naam) VALUES (2220704, 'Landelijk Wonen');
INSERT INTO buurt (code, naam) VALUES (2220705, 'Kleurrijke buurt');
INSERT INTO buurt (code, naam) VALUES (2220706, 'Stadskwartier-Zuid');
INSERT INTO buurt (code, naam) VALUES (2220707, 'Stadskwartier-Noord');
INSERT INTO buurt (code, naam) VALUES (2220708, 'Buitengebied en Dichterem-Oost');
INSERT INTO buurt (code, naam) VALUES (2220709, 'Bedrijventerrein en Wijnbergen');
INSERT INTO buurt (code, naam) VALUES (2220710, 'Wijnbergen-het Westem');
INSERT INTO buurt (code, naam) VALUES (2220711, 'Wijnbergen-het Midden');
INSERT INTO buurt (code, naam) VALUES (2220712, 'Wijnbergen-het Oosten');
INSERT INTO buurt (code, naam) VALUES (2220713, 'De Hoop-Zuid');
INSERT INTO buurt (code, naam) VALUES (2220801, 'IJsseltuin en Heelweg');
INSERT INTO buurt (code, naam) VALUES (2220802, 'Bedrijventerrein Keppelseweg');
INSERT INTO buurt (code, naam) VALUES (2220803, 'Buitengebied Keppelseweg');
INSERT INTO buurt (code, naam) VALUES (2220804, 'Langerak-Zuid');
INSERT INTO buurt (code, naam) VALUES (2220901, 'Het Loo');
INSERT INTO buurt (code, naam) VALUES (2220902, 'De Happert Ziekenhuis');
INSERT INTO buurt (code, naam) VALUES (2220903, 'De Kruisberg');
INSERT INTO buurt (code, naam) VALUES (2220904, 'De Happert Leerinkstraat');
INSERT INTO buurt (code, naam) VALUES (2220905, 'De IJkenberg');
INSERT INTO buurt (code, naam) VALUES (2220906, 'De Bezelhorst');
INSERT INTO buurt (code, naam) VALUES (2220907, 'Buitengebied De Kruisberg');
INSERT INTO buurt (code, naam) VALUES (2220908, 'Buitengebied Groot Hagen');
INSERT INTO buurt (code, naam) VALUES (2220909, 'Langerak-Noord');
INSERT INTO buurt (code, naam) VALUES (2220910, 'Buitengebied Christoffelstraat');
INSERT INTO buurt (code, naam) VALUES (2220911, 'Wassinkbrink-Noordwest');
INSERT INTO buurt (code, naam) VALUES (2221101, 'Vulcaansoord en het Richtersbos-Zuid');
INSERT INTO buurt (code, naam) VALUES (2221102, 'De Elshof-Zuid');
INSERT INTO buurt (code, naam) VALUES (2221103, 'De Pol en Akkermansweide');
INSERT INTO buurt (code, naam) VALUES (2221104, 'Het Hartger en de Elshof-Noord');
INSERT INTO buurt (code, naam) VALUES (2221105, 'Buitengebied ''t Klooster');
INSERT INTO buurt (code, naam) VALUES (2221106, 'Buitengebied Pierikstraat');
INSERT INTO buurt (code, naam) VALUES (2221107, 'Buitengebied Pinnedijk');
INSERT INTO buurt (code, naam) VALUES (2223101, 'Wehl-Centrum');
INSERT INTO buurt (code, naam) VALUES (2223102, 'Wehl-West');
INSERT INTO buurt (code, naam) VALUES (2223103, 'Wehl-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (2223104, 'Wehl-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (2223105, 'Wehl-Oost');
INSERT INTO buurt (code, naam) VALUES (2223106, 'Wehl-Noordoost');
INSERT INTO buurt (code, naam) VALUES (2223107, 'Wehl-Noord');
INSERT INTO buurt (code, naam) VALUES (2223108, 'Nieuw-Wehl-Centrum');
INSERT INTO buurt (code, naam) VALUES (2223109, 'Nieuw-Wehl-Noordoost');
INSERT INTO buurt (code, naam) VALUES (2223110, 'Nieuw-Wehl-Noord');
INSERT INTO buurt (code, naam) VALUES (2223111, 'A18 Bedrijvenpark');
INSERT INTO buurt (code, naam) VALUES (2250001, 'Druten');
INSERT INTO buurt (code, naam) VALUES (2250002, 'Druten Zuid');
INSERT INTO buurt (code, naam) VALUES (2250003, 'Druten Bouwing');
INSERT INTO buurt (code, naam) VALUES (2250004, 'Druten Westerhout');
INSERT INTO buurt (code, naam) VALUES (2250005, 'Druten Buitengebied');
INSERT INTO buurt (code, naam) VALUES (2250006, 'Drutense Waarden');
INSERT INTO buurt (code, naam) VALUES (2250101, 'Puiflijk');
INSERT INTO buurt (code, naam) VALUES (2250102, 'Puiflijk Buitengebied');
INSERT INTO buurt (code, naam) VALUES (2250201, 'Afferden');
INSERT INTO buurt (code, naam) VALUES (2250202, 'Afferden Buitengebied');
INSERT INTO buurt (code, naam) VALUES (2250203, 'Afferdense Waarden');
INSERT INTO buurt (code, naam) VALUES (2250301, 'Deest');
INSERT INTO buurt (code, naam) VALUES (2250302, 'Deest Buitengebied');
INSERT INTO buurt (code, naam) VALUES (2250303, 'Deestse Waarden');
INSERT INTO buurt (code, naam) VALUES (2250401, 'Horssen');
INSERT INTO buurt (code, naam) VALUES (2250402, 'Horssen Molenhoek');
INSERT INTO buurt (code, naam) VALUES (2250403, 'Horssen Buitengebied');
INSERT INTO buurt (code, naam) VALUES (2260101, 'Bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (2260201, 'Het Broek');
INSERT INTO buurt (code, naam) VALUES (2260301, 'West');
INSERT INTO buurt (code, naam) VALUES (2260302, 'Oud Zuid');
INSERT INTO buurt (code, naam) VALUES (2260303, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (2260304, 'De Vergert');
INSERT INTO buurt (code, naam) VALUES (2260305, 'De Nieuweling');
INSERT INTO buurt (code, naam) VALUES (2260306, 'De Ploen');
INSERT INTO buurt (code, naam) VALUES (2260307, 'Noord');
INSERT INTO buurt (code, naam) VALUES (2260308, 'Lommerweide');
INSERT INTO buurt (code, naam) VALUES (2260401, 'Zuidwest');
INSERT INTO buurt (code, naam) VALUES (2260402, 'Zuidoost');
INSERT INTO buurt (code, naam) VALUES (2260501, 'Groessen');
INSERT INTO buurt (code, naam) VALUES (2260601, 'Loo Gld');
INSERT INTO buurt (code, naam) VALUES (2280101, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (2280102, 'Bosrand');
INSERT INTO buurt (code, naam) VALUES (2280103, 'Componistenbuurt');
INSERT INTO buurt (code, naam) VALUES (2280104, 'Burgemeestersbuurt');
INSERT INTO buurt (code, naam) VALUES (2280105, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (2280201, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (2280202, 'Indische buurt');
INSERT INTO buurt (code, naam) VALUES (2280203, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (2280204, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (2280205, 'Beatrixpark');
INSERT INTO buurt (code, naam) VALUES (2280301, 'De Horsten');
INSERT INTO buurt (code, naam) VALUES (2280302, 'De Burgen');
INSERT INTO buurt (code, naam) VALUES (2280303, 'De Steinen');
INSERT INTO buurt (code, naam) VALUES (2280304, 'Klaphek');
INSERT INTO buurt (code, naam) VALUES (2280305, 'De Dalen');
INSERT INTO buurt (code, naam) VALUES (2280306, 'De Velden en Beken');
INSERT INTO buurt (code, naam) VALUES (2280307, 'De Hoven');
INSERT INTO buurt (code, naam) VALUES (2280401, 'De Bergen');
INSERT INTO buurt (code, naam) VALUES (2280402, 'De Bossen');
INSERT INTO buurt (code, naam) VALUES (2280403, 'De Venen en zanden');
INSERT INTO buurt (code, naam) VALUES (2280501, 'Veluwse Poort');
INSERT INTO buurt (code, naam) VALUES (2281001, 'Uitvindersbuurt');
INSERT INTO buurt (code, naam) VALUES (2281002, 'Hoogbouw-Zuid');
INSERT INTO buurt (code, naam) VALUES (2281003, 'Reehorst');
INSERT INTO buurt (code, naam) VALUES (2281004, 'Enka');
INSERT INTO buurt (code, naam) VALUES (2281101, 'Elskamp');
INSERT INTO buurt (code, naam) VALUES (2281102, 'Maandereng-Oost');
INSERT INTO buurt (code, naam) VALUES (2281103, 'De Hoef');
INSERT INTO buurt (code, naam) VALUES (2281201, 'De Parken');
INSERT INTO buurt (code, naam) VALUES (2281202, 'De Dreven');
INSERT INTO buurt (code, naam) VALUES (2281203, 'De Singels');
INSERT INTO buurt (code, naam) VALUES (2281204, 'De States');
INSERT INTO buurt (code, naam) VALUES (2281301, 'Frankeneng');
INSERT INTO buurt (code, naam) VALUES (2281302, 'Heestereng');
INSERT INTO buurt (code, naam) VALUES (2281303, 'De Vallei');
INSERT INTO buurt (code, naam) VALUES (2281304, 'Schuttersveld-Zuid');
INSERT INTO buurt (code, naam) VALUES (2281305, 'Schuttersveld-Noord');
INSERT INTO buurt (code, naam) VALUES (2281306, 'Kievitsmeent');
INSERT INTO buurt (code, naam) VALUES (2282031, 'Maanderbroek');
INSERT INTO buurt (code, naam) VALUES (2282032, 'Doesburg');
INSERT INTO buurt (code, naam) VALUES (2282051, 'Driesprong en Ginkel');
INSERT INTO buurt (code, naam) VALUES (2283001, 'De Laar');
INSERT INTO buurt (code, naam) VALUES (2283002, 'Bennekom-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (2283003, 'Boekelo');
INSERT INTO buurt (code, naam) VALUES (2283004, 'Halderbrink');
INSERT INTO buurt (code, naam) VALUES (2283031, 'De Kraats en Nergena');
INSERT INTO buurt (code, naam) VALUES (2283051, 'Dikkenberg');
INSERT INTO buurt (code, naam) VALUES (2284001, 'Centrum Lunteren');
INSERT INTO buurt (code, naam) VALUES (2284002, 'Wormshoef');
INSERT INTO buurt (code, naam) VALUES (2284003, 'Lunteren-Oost');
INSERT INTO buurt (code, naam) VALUES (2284031, 'Nederwoud');
INSERT INTO buurt (code, naam) VALUES (2284032, 'De Veenen');
INSERT INTO buurt (code, naam) VALUES (2284033, 'Lunterse Veld');
INSERT INTO buurt (code, naam) VALUES (2284034, 'Meulunteren de Valk');
INSERT INTO buurt (code, naam) VALUES (2284051, 'Lunterse Buurtbos');
INSERT INTO buurt (code, naam) VALUES (2285001, 'Ederveen-Dorp');
INSERT INTO buurt (code, naam) VALUES (2285031, 'Ederveen buitengebied');
INSERT INTO buurt (code, naam) VALUES (2286001, 'De Klompdorp');
INSERT INTO buurt (code, naam) VALUES (2286031, 'De Klomp buitengebied');
INSERT INTO buurt (code, naam) VALUES (2287001, 'Harskamp Dorp');
INSERT INTO buurt (code, naam) VALUES (2287002, 'Legerplaats Harskamp');
INSERT INTO buurt (code, naam) VALUES (2287031, 'Westeneng');
INSERT INTO buurt (code, naam) VALUES (2287051, 'Harskampse Zand');
INSERT INTO buurt (code, naam) VALUES (2288001, 'Wekerom Dorp');
INSERT INTO buurt (code, naam) VALUES (2288031, 'Wekeromse Meent');
INSERT INTO buurt (code, naam) VALUES (2288051, 'Wekeromse Zand');
INSERT INTO buurt (code, naam) VALUES (2289001, 'Otterlo Dorp');
INSERT INTO buurt (code, naam) VALUES (2289031, 'Eschoter Veld');
INSERT INTO buurt (code, naam) VALUES (2289051, 'Reemst');
INSERT INTO buurt (code, naam) VALUES (2289052, 'Hoog Baarlo');
INSERT INTO buurt (code, naam) VALUES (2289053, 'Deelen');
INSERT INTO buurt (code, naam) VALUES (2300100, 'Elburg Stad');
INSERT INTO buurt (code, naam) VALUES (2300101, 'Elburg West en havengebied');
INSERT INTO buurt (code, naam) VALUES (2300102, 'Elburg-Oosthoek');
INSERT INTO buurt (code, naam) VALUES (2300103, 'Elburg De Vrijheid');
INSERT INTO buurt (code, naam) VALUES (2300104, 'Oostendorp');
INSERT INTO buurt (code, naam) VALUES (2300105, 'Achterweg');
INSERT INTO buurt (code, naam) VALUES (2300108, 'Verspreide huizen Elburg-Zuid');
INSERT INTO buurt (code, naam) VALUES (2300109, 'Verspreide huizen Elburg-Noord');
INSERT INTO buurt (code, naam) VALUES (2300201, '''t Harde-Centrum');
INSERT INTO buurt (code, naam) VALUES (2300202, '''t Harde-West');
INSERT INTO buurt (code, naam) VALUES (2300203, '''t Harde-Oost');
INSERT INTO buurt (code, naam) VALUES (2300207, 'Verspreide huizen ''t Harde Noord-West');
INSERT INTO buurt (code, naam) VALUES (2300209, 'Verspreide huizen ''t Harde Zuid-Oost');
INSERT INTO buurt (code, naam) VALUES (2300300, 'Doornspijk');
INSERT INTO buurt (code, naam) VALUES (2300304, 'Hoge Enk');
INSERT INTO buurt (code, naam) VALUES (2300306, 'Verspreide huizen Doornspijk-West');
INSERT INTO buurt (code, naam) VALUES (2300308, 'Verspreide huizen Doornspijk-Oost');
INSERT INTO buurt (code, naam) VALUES (2309997, '');
INSERT INTO buurt (code, naam) VALUES (2320000, 'Epe-Centrum');
INSERT INTO buurt (code, naam) VALUES (2320001, 'Hogeland-Hoge Weerd');
INSERT INTO buurt (code, naam) VALUES (2320002, 'Epe-Zuid');
INSERT INTO buurt (code, naam) VALUES (2320003, 'Epe-Oost');
INSERT INTO buurt (code, naam) VALUES (2320004, 'Epe-Noord');
INSERT INTO buurt (code, naam) VALUES (2320008, 'Verspreide huizen Wissel');
INSERT INTO buurt (code, naam) VALUES (2320009, 'Verspreide huizen Vemde-Zuuk');
INSERT INTO buurt (code, naam) VALUES (2320100, 'Emst');
INSERT INTO buurt (code, naam) VALUES (2320101, 'Oene');
INSERT INTO buurt (code, naam) VALUES (2320107, 'Verspreide huizen Emst');
INSERT INTO buurt (code, naam) VALUES (2320108, 'Verspreide huizen Oene');
INSERT INTO buurt (code, naam) VALUES (2320109, 'Verspreide huizen Emsterbroek');
INSERT INTO buurt (code, naam) VALUES (2320200, 'Vaassen-Centrum');
INSERT INTO buurt (code, naam) VALUES (2320201, 'Vaassen-Noord-West');
INSERT INTO buurt (code, naam) VALUES (2320202, 'Vaassen-West');
INSERT INTO buurt (code, naam) VALUES (2320203, 'Oude Apeldoornseweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (2320204, 'Vaassen-Oosterhof');
INSERT INTO buurt (code, naam) VALUES (2320207, 'Verspreide huizen De Botterd');
INSERT INTO buurt (code, naam) VALUES (2320208, 'Verspreide huizen Vaassen');
INSERT INTO buurt (code, naam) VALUES (2320209, 'Verspreide huizen Geerstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (2320300, 'Tongeren');
INSERT INTO buurt (code, naam) VALUES (2320301, 'Gortel');
INSERT INTO buurt (code, naam) VALUES (2320308, 'Verspreide huizen bosgebied Niersen en Gortel');
INSERT INTO buurt (code, naam) VALUES (2320309, 'Verspreide huizen bosgebied Tongeren');
INSERT INTO buurt (code, naam) VALUES (2330000, 'Ermelo');
INSERT INTO buurt (code, naam) VALUES (2330001, 'Ermelo-Oost');
INSERT INTO buurt (code, naam) VALUES (2330002, 'Ermelo-West');
INSERT INTO buurt (code, naam) VALUES (2330003, 'Veldwijk-''s Heerenloo');
INSERT INTO buurt (code, naam) VALUES (2330004, 'Tonsel');
INSERT INTO buurt (code, naam) VALUES (2330005, 'Horst');
INSERT INTO buurt (code, naam) VALUES (2330006, 'Buurt Ermelo ten dele bij de kern');
INSERT INTO buurt (code, naam) VALUES (2330007, 'Verspreide huizen Telgt');
INSERT INTO buurt (code, naam) VALUES (2330008, 'Verspreide huizen Zuiderzeeland');
INSERT INTO buurt (code, naam) VALUES (2330009, 'Verspreide huizen bosgebied');
INSERT INTO buurt (code, naam) VALUES (2330100, 'Speuld');
INSERT INTO buurt (code, naam) VALUES (2330105, 'Verspreide huizen Staverden');
INSERT INTO buurt (code, naam) VALUES (2330106, 'Verspreide huizen Houtdorp');
INSERT INTO buurt (code, naam) VALUES (2330107, 'Verspreide huizen Leuvenum');
INSERT INTO buurt (code, naam) VALUES (2330108, 'Verspreide huizen De Beek');
INSERT INTO buurt (code, naam) VALUES (2330109, 'Verspreide huizen bosgebied');
INSERT INTO buurt (code, naam) VALUES (2339997, '');
INSERT INTO buurt (code, naam) VALUES (2360000, 'Geldermalsen-Centrum');
INSERT INTO buurt (code, naam) VALUES (2360001, 'Geldermalsen-West');
INSERT INTO buurt (code, naam) VALUES (2360002, 'Geldermalsen-Oost (''t Rot)');
INSERT INTO buurt (code, naam) VALUES (2360003, 'Geldermalsen-Zuid');
INSERT INTO buurt (code, naam) VALUES (2360004, 'Meteren');
INSERT INTO buurt (code, naam) VALUES (2360008, 'Verspreide huizen Meteren');
INSERT INTO buurt (code, naam) VALUES (2360009, 'Verspreide huizen Geldermalsen');
INSERT INTO buurt (code, naam) VALUES (2360100, 'Deil');
INSERT INTO buurt (code, naam) VALUES (2360101, 'Enspijk');
INSERT INTO buurt (code, naam) VALUES (2360102, 'Rumpt');
INSERT INTO buurt (code, naam) VALUES (2360103, 'Gellicum');
INSERT INTO buurt (code, naam) VALUES (2360106, 'Verspreide huizen Gellicum');
INSERT INTO buurt (code, naam) VALUES (2360107, 'Verspreide huizen Rumpt');
INSERT INTO buurt (code, naam) VALUES (2360108, 'Verspreide huizen Enspijk');
INSERT INTO buurt (code, naam) VALUES (2360109, 'Verspreide huizen poldergebied Deil');
INSERT INTO buurt (code, naam) VALUES (2360200, 'Beesd');
INSERT INTO buurt (code, naam) VALUES (2360201, 'Rhenoy');
INSERT INTO buurt (code, naam) VALUES (2360202, 'Acquoy');
INSERT INTO buurt (code, naam) VALUES (2360207, 'Verspreide huizen Acquoy');
INSERT INTO buurt (code, naam) VALUES (2360208, 'Verspreide huizen Rhenoy');
INSERT INTO buurt (code, naam) VALUES (2360209, 'Verspreide huizen Beesd');
INSERT INTO buurt (code, naam) VALUES (2360300, 'Buurmalsen');
INSERT INTO buurt (code, naam) VALUES (2360301, 'Tricht');
INSERT INTO buurt (code, naam) VALUES (2360308, 'Verspreide huizen Tricht');
INSERT INTO buurt (code, naam) VALUES (2360309, 'Verspreide huizen Buurmalsen');
INSERT INTO buurt (code, naam) VALUES (2410000, 'Groesbeek Centrum-Zuid');
INSERT INTO buurt (code, naam) VALUES (2410001, 'Groesbeek-Noord');
INSERT INTO buurt (code, naam) VALUES (2410002, 'Groesbeek-Centrum-Noord');
INSERT INTO buurt (code, naam) VALUES (2410003, 'Groesbeek De Drul');
INSERT INTO buurt (code, naam) VALUES (2410004, 'Groesbeek Nijerf');
INSERT INTO buurt (code, naam) VALUES (2410005, 'Heilig Landstichting');
INSERT INTO buurt (code, naam) VALUES (2410006, 'Berg en Dal');
INSERT INTO buurt (code, naam) VALUES (2410007, 'Verspreide huizen Groesbeek-Zuid');
INSERT INTO buurt (code, naam) VALUES (2410008, 'Verspreide huizen Groesbeek-Noord');
INSERT INTO buurt (code, naam) VALUES (2410009, 'Verspreide huizen Meerwijk');
INSERT INTO buurt (code, naam) VALUES (2410010, 'Verspreide huizen Meiberg');
INSERT INTO buurt (code, naam) VALUES (2410011, 'Verspreide huizen Hoge en Lage Langeberg');
INSERT INTO buurt (code, naam) VALUES (2410012, 'Bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (2410100, 'Breedeweg');
INSERT INTO buurt (code, naam) VALUES (2410101, 'Horst');
INSERT INTO buurt (code, naam) VALUES (2410108, 'Verspreide huizen Breedeweg');
INSERT INTO buurt (code, naam) VALUES (2410109, 'Verspreide huizen Horst');
INSERT INTO buurt (code, naam) VALUES (2430101, 'Binnenstad-Noord');
INSERT INTO buurt (code, naam) VALUES (2430102, 'Binnenstad-Zuid');
INSERT INTO buurt (code, naam) VALUES (2430201, 'De Eilanden');
INSERT INTO buurt (code, naam) VALUES (2430202, 'De Kades');
INSERT INTO buurt (code, naam) VALUES (2430203, 'Stadswerven');
INSERT INTO buurt (code, naam) VALUES (2430204, 'De Knar');
INSERT INTO buurt (code, naam) VALUES (2430301, 'Zeebuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (2430302, 'Zeebuurt-west');
INSERT INTO buurt (code, naam) VALUES (2430401, 'Friesegracht-Noord');
INSERT INTO buurt (code, naam) VALUES (2430402, 'Friesegracht-Zuid');
INSERT INTO buurt (code, naam) VALUES (2430501, 'Stadsdennen-Noord');
INSERT INTO buurt (code, naam) VALUES (2430502, 'Stadsdennen-Midden');
INSERT INTO buurt (code, naam) VALUES (2430503, 'Stadsdennen-Oost');
INSERT INTO buurt (code, naam) VALUES (2430504, 'Stadsdennen-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (2430601, 'Sypel-Oost');
INSERT INTO buurt (code, naam) VALUES (2430602, 'Sypel-West');
INSERT INTO buurt (code, naam) VALUES (2430701, 'nachthok');
INSERT INTO buurt (code, naam) VALUES (2430702, 'Weiburg');
INSERT INTO buurt (code, naam) VALUES (2430801, 'Kruithuis');
INSERT INTO buurt (code, naam) VALUES (2430802, 'Hanzewaard');
INSERT INTO buurt (code, naam) VALUES (2430803, 'Scheepswaard');
INSERT INTO buurt (code, naam) VALUES (2430804, 'Stedenwaard');
INSERT INTO buurt (code, naam) VALUES (2430805, 'Vogelwaard');
INSERT INTO buurt (code, naam) VALUES (2430806, 'Weidewaard');
INSERT INTO buurt (code, naam) VALUES (2430807, 'Drift');
INSERT INTO buurt (code, naam) VALUES (2430808, 'Stromenwaard');
INSERT INTO buurt (code, naam) VALUES (2430901, 'Slingerbos-Noord');
INSERT INTO buurt (code, naam) VALUES (2430902, 'Slingerbos-Zuid');
INSERT INTO buurt (code, naam) VALUES (2431001, 'Veldkamp');
INSERT INTO buurt (code, naam) VALUES (2431002, 'Kranenburg');
INSERT INTO buurt (code, naam) VALUES (2431003, 'Bedrijventerrein "De Sypel"');
INSERT INTO buurt (code, naam) VALUES (2431004, 'Tinnegieter');
INSERT INTO buurt (code, naam) VALUES (2431005, 'De Wittenhagen-Noord');
INSERT INTO buurt (code, naam) VALUES (2431006, 'De Wittenhagen-Zuid');
INSERT INTO buurt (code, naam) VALUES (2431101, 'Broekland');
INSERT INTO buurt (code, naam) VALUES (2431102, 'De Akker');
INSERT INTO buurt (code, naam) VALUES (2431103, 'Walstein');
INSERT INTO buurt (code, naam) VALUES (2431104, 'Overveld');
INSERT INTO buurt (code, naam) VALUES (2431201, 'Muziekland I');
INSERT INTO buurt (code, naam) VALUES (2431202, 'Muziekland II');
INSERT INTO buurt (code, naam) VALUES (2431203, 'Muziekland III');
INSERT INTO buurt (code, naam) VALUES (2431204, 'Muziekland IV');
INSERT INTO buurt (code, naam) VALUES (2431205, 'Drielanden-Centrum');
INSERT INTO buurt (code, naam) VALUES (2431206, 'Harderhout I');
INSERT INTO buurt (code, naam) VALUES (2431207, 'Harderhout II');
INSERT INTO buurt (code, naam) VALUES (2431208, 'De Burcht');
INSERT INTO buurt (code, naam) VALUES (2431209, 'De Gronden');
INSERT INTO buurt (code, naam) VALUES (2431210, 'Groerne Zoom');
INSERT INTO buurt (code, naam) VALUES (2431211, 'Tonsel');
INSERT INTO buurt (code, naam) VALUES (2431212, 'Weisteeg');
INSERT INTO buurt (code, naam) VALUES (2431301, 'Lorentz I');
INSERT INTO buurt (code, naam) VALUES (2431302, 'Lorentz II');
INSERT INTO buurt (code, naam) VALUES (2431303, 'Lorentz III');
INSERT INTO buurt (code, naam) VALUES (2431401, 'Strokel');
INSERT INTO buurt (code, naam) VALUES (2431402, 'Sonnevanck');
INSERT INTO buurt (code, naam) VALUES (2431403, 'Harderwijkerbos');
INSERT INTO buurt (code, naam) VALUES (2431501, 'Hierden-Dorp');
INSERT INTO buurt (code, naam) VALUES (2431502, 'Hierden Glindweg');
INSERT INTO buurt (code, naam) VALUES (2431503, 'Hierden Mheenlanden');
INSERT INTO buurt (code, naam) VALUES (2431504, 'Hierden de Enk');
INSERT INTO buurt (code, naam) VALUES (2431505, 'Hierden De Duinen');
INSERT INTO buurt (code, naam) VALUES (2431506, 'Hierden De Biest');
INSERT INTO buurt (code, naam) VALUES (2431601, 'Woldenwijd-Noord');
INSERT INTO buurt (code, naam) VALUES (2439997, '');
INSERT INTO buurt (code, naam) VALUES (2440000, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (2440001, 'Zandkamp en omgeving');
INSERT INTO buurt (code, naam) VALUES (2440002, 'Ten oosten van Apeldoornseweg');
INSERT INTO buurt (code, naam) VALUES (2440003, 'Hogenkamp en omgeving');
INSERT INTO buurt (code, naam) VALUES (2440004, 'Villapark');
INSERT INTO buurt (code, naam) VALUES (2440005, 'De Hilst');
INSERT INTO buurt (code, naam) VALUES (2440008, 'Verspreide huizen bosgebied');
INSERT INTO buurt (code, naam) VALUES (2440009, 'Verspreide huizen Hoenwaard');
INSERT INTO buurt (code, naam) VALUES (2440108, 'Verspreide huizen Koeweg en Molecaten');
INSERT INTO buurt (code, naam) VALUES (2440109, 'Verspreide huizen Gelderse Dijk en omgeving');
INSERT INTO buurt (code, naam) VALUES (2460000, 'Heerde');
INSERT INTO buurt (code, naam) VALUES (2460001, 'Veessen');
INSERT INTO buurt (code, naam) VALUES (2460002, 'Vorchten');
INSERT INTO buurt (code, naam) VALUES (2460003, 'Hoorn');
INSERT INTO buurt (code, naam) VALUES (2460004, 'Verspreide huizen Veessen');
INSERT INTO buurt (code, naam) VALUES (2460005, 'Verspreide huizen Heerde-Noord en Hoorn');
INSERT INTO buurt (code, naam) VALUES (2460006, 'Verspreide huizen Heerde-Zuid');
INSERT INTO buurt (code, naam) VALUES (2460007, 'Verspreide huizen Vorchten');
INSERT INTO buurt (code, naam) VALUES (2460008, 'Verspreide huizen Lage Land');
INSERT INTO buurt (code, naam) VALUES (2460009, 'Verspreide huizen bosgebied');
INSERT INTO buurt (code, naam) VALUES (2460100, 'Wapenveld');
INSERT INTO buurt (code, naam) VALUES (2460106, 'Verspreide huizen Wapenveld-Noord');
INSERT INTO buurt (code, naam) VALUES (2460107, 'Verspreide huizen Wapenveld-Zuid');
INSERT INTO buurt (code, naam) VALUES (2460108, 'Verspreide huizen Lage Land');
INSERT INTO buurt (code, naam) VALUES (2460109, 'Verspreide huizen bosgebied');
INSERT INTO buurt (code, naam) VALUES (2520000, 'Heumen');
INSERT INTO buurt (code, naam) VALUES (2520001, 'Malden-West');
INSERT INTO buurt (code, naam) VALUES (2520002, 'Malden-Oost');
INSERT INTO buurt (code, naam) VALUES (2520003, 'Broekkant en Droge');
INSERT INTO buurt (code, naam) VALUES (2520004, 'Molenhoek');
INSERT INTO buurt (code, naam) VALUES (2520005, 'Kluis');
INSERT INTO buurt (code, naam) VALUES (2520006, 'Verspreide huizen Malden');
INSERT INTO buurt (code, naam) VALUES (2520007, 'Verspreide huizen bosgebied ten oosten kanaal');
INSERT INTO buurt (code, naam) VALUES (2520008, 'Verspreide huizen Heumen');
INSERT INTO buurt (code, naam) VALUES (2520009, 'Verspreide huizen bosgebied ten westen kanaal');
INSERT INTO buurt (code, naam) VALUES (2520100, 'Overasselt');
INSERT INTO buurt (code, naam) VALUES (2520101, 'Nederasselt');
INSERT INTO buurt (code, naam) VALUES (2520103, 'Verspreide huizen Overasseltse Broek');
INSERT INTO buurt (code, naam) VALUES (2520104, 'Verspreide huizen Overasseltse Uiterwaarden');
INSERT INTO buurt (code, naam) VALUES (2520105, 'Verspreide huizen Valenberg en Heide');
INSERT INTO buurt (code, naam) VALUES (2520106, 'Verspreide huizen Nederasseltse Broek');
INSERT INTO buurt (code, naam) VALUES (2520107, 'Verspreide huizen Worsum');
INSERT INTO buurt (code, naam) VALUES (2520108, 'Verspreide huizen in de polder Balgoij en Einde');
INSERT INTO buurt (code, naam) VALUES (2520109, 'Verspreide huizen Nederasseltse Uiterwaarden');
INSERT INTO buurt (code, naam) VALUES (2620000, 'Vesting');
INSERT INTO buurt (code, naam) VALUES (2620001, 'Zuiderenk');
INSERT INTO buurt (code, naam) VALUES (2620002, 'Lochem-Zuid');
INSERT INTO buurt (code, naam) VALUES (2620003, 'Lochem-Oost');
INSERT INTO buurt (code, naam) VALUES (2620004, 'Lochem-West');
INSERT INTO buurt (code, naam) VALUES (2620005, 'Lochem-Noord');
INSERT INTO buurt (code, naam) VALUES (2620006, 'Molengronden');
INSERT INTO buurt (code, naam) VALUES (2620100, 'Zwiep');
INSERT INTO buurt (code, naam) VALUES (2620106, 'Verspreide huizen Het Veen en Grote Veld');
INSERT INTO buurt (code, naam) VALUES (2620107, 'Verspreide huizen Klein Dochteren');
INSERT INTO buurt (code, naam) VALUES (2620108, 'Verspreide huizen Ampsen');
INSERT INTO buurt (code, naam) VALUES (2620109, 'Verspreide huizen Nettelhorst, Langen en Zwiep');
INSERT INTO buurt (code, naam) VALUES (2620200, 'Laren');
INSERT INTO buurt (code, naam) VALUES (2620201, 'Exel');
INSERT INTO buurt (code, naam) VALUES (2620205, 'Verspreide huizen Groot Dochteren');
INSERT INTO buurt (code, naam) VALUES (2620206, 'Verspreide huizen Oolde');
INSERT INTO buurt (code, naam) VALUES (2620207, 'Verspreide huizen Verwolde');
INSERT INTO buurt (code, naam) VALUES (2620208, 'Verspreide huizen Exel');
INSERT INTO buurt (code, naam) VALUES (2620209, 'Exel Tol');
INSERT INTO buurt (code, naam) VALUES (2620300, 'Barchem');
INSERT INTO buurt (code, naam) VALUES (2620307, 'Verspreide huizen Lochemseweg');
INSERT INTO buurt (code, naam) VALUES (2620308, 'Verspreide huizen Zwarte Veen en Barchemse Enk');
INSERT INTO buurt (code, naam) VALUES (2620309, 'Verspreide huizen Boschheurne en Zwiepsche Broek');
INSERT INTO buurt (code, naam) VALUES (2620400, 'Gorssel');
INSERT INTO buurt (code, naam) VALUES (2620401, 'Eefde');
INSERT INTO buurt (code, naam) VALUES (2620402, 'Epse');
INSERT INTO buurt (code, naam) VALUES (2620406, 'Verspreide huizen Joppe');
INSERT INTO buurt (code, naam) VALUES (2620407, 'Verspreide huizen Gorssel');
INSERT INTO buurt (code, naam) VALUES (2620408, 'Verspreide huizen Epse');
INSERT INTO buurt (code, naam) VALUES (2620409, 'Verspreide huizen Eefde');
INSERT INTO buurt (code, naam) VALUES (2620500, 'Almen');
INSERT INTO buurt (code, naam) VALUES (2620501, 'Harfsen');
INSERT INTO buurt (code, naam) VALUES (2620506, 'Verspreide huizen Almen ten zuiden van Twentekanaal');
INSERT INTO buurt (code, naam) VALUES (2620507, 'Verspreide huizen Almen ten noorden van Twentekanaal');
INSERT INTO buurt (code, naam) VALUES (2620508, 'Verspreide huizen Harfsen');
INSERT INTO buurt (code, naam) VALUES (2620509, 'Verspreide huizen Kring van Dorth');
INSERT INTO buurt (code, naam) VALUES (2630000, 'Kerkdriel');
INSERT INTO buurt (code, naam) VALUES (2630001, 'Velddriel');
INSERT INTO buurt (code, naam) VALUES (2630002, 'Hoenzadriel');
INSERT INTO buurt (code, naam) VALUES (2630003, 'Alem');
INSERT INTO buurt (code, naam) VALUES (2630006, 'Verspreide huizen Noord Beemden');
INSERT INTO buurt (code, naam) VALUES (2630007, 'Verspreide huizen Kerkdriel, Berm en Hoorzik');
INSERT INTO buurt (code, naam) VALUES (2630008, 'Verspreide huizen Velddriel, Vlierd en Beemden');
INSERT INTO buurt (code, naam) VALUES (2630009, 'Verspreide huizen Maasdijk en Uiterwaarden');
INSERT INTO buurt (code, naam) VALUES (2630010, 'Verspreide huizen Alem');
INSERT INTO buurt (code, naam) VALUES (2630100, 'Ammerzoden');
INSERT INTO buurt (code, naam) VALUES (2630101, 'Well');
INSERT INTO buurt (code, naam) VALUES (2630102, 'Wellseind-Slijkwell');
INSERT INTO buurt (code, naam) VALUES (2630108, 'Verspreide huizen Het Heust');
INSERT INTO buurt (code, naam) VALUES (2630109, 'Verspreide huizen Uilecoten');
INSERT INTO buurt (code, naam) VALUES (2630200, 'Hedel');
INSERT INTO buurt (code, naam) VALUES (2630208, 'Verspreide huizen in het bouwgebied');
INSERT INTO buurt (code, naam) VALUES (2630209, 'Verspreide huizen in de polder Hedel');
INSERT INTO buurt (code, naam) VALUES (2630300, 'Heerewaarden');
INSERT INTO buurt (code, naam) VALUES (2630301, 'Huizendijk, Voorne, De Kop en Veluwe');
INSERT INTO buurt (code, naam) VALUES (2630309, 'Verspreide huizen Heerewaarden');
INSERT INTO buurt (code, naam) VALUES (2630400, 'Rossum');
INSERT INTO buurt (code, naam) VALUES (2630401, 'Hurwenen');
INSERT INTO buurt (code, naam) VALUES (2630408, 'Verspreide huizen Hurwenen en Rossum');
INSERT INTO buurt (code, naam) VALUES (2630409, 'Overige verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (2650000, 'Millingen aan de Rijn');
INSERT INTO buurt (code, naam) VALUES (2650008, 'Verspreide huizen in Millingerwaard');
INSERT INTO buurt (code, naam) VALUES (2650009, 'Verspreide huizen poldergebied');
INSERT INTO buurt (code, naam) VALUES (2670101, 'Industriegebied');
INSERT INTO buurt (code, naam) VALUES (2670102, 'Doornsteeg');
INSERT INTO buurt (code, naam) VALUES (2670103, 'Corlaer');
INSERT INTO buurt (code, naam) VALUES (2670104, 'Schulpkamp');
INSERT INTO buurt (code, naam) VALUES (2670105, 'Havenstraat');
INSERT INTO buurt (code, naam) VALUES (2670106, 'Centrum Nijkerk');
INSERT INTO buurt (code, naam) VALUES (2670107, 'Campenbuurt');
INSERT INTO buurt (code, naam) VALUES (2670108, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (2670109, 'Colthoflaan');
INSERT INTO buurt (code, naam) VALUES (2670110, 'Luxool');
INSERT INTO buurt (code, naam) VALUES (2670111, 'Paasbos-West');
INSERT INTO buurt (code, naam) VALUES (2670112, 'Paasbos-Oost');
INSERT INTO buurt (code, naam) VALUES (2670113, 'Strijland-West');
INSERT INTO buurt (code, naam) VALUES (2670114, 'Strijland-Oost');
INSERT INTO buurt (code, naam) VALUES (2670201, 'Kruishaar');
INSERT INTO buurt (code, naam) VALUES (2670202, 'Slichtenhorst');
INSERT INTO buurt (code, naam) VALUES (2670203, 'Appel');
INSERT INTO buurt (code, naam) VALUES (2670204, 'Prinsenkamp');
INSERT INTO buurt (code, naam) VALUES (2670301, 'Nijkerkerveen');
INSERT INTO buurt (code, naam) VALUES (2670302, 'Holkerveen');
INSERT INTO buurt (code, naam) VALUES (2670401, 'Arkemheen');
INSERT INTO buurt (code, naam) VALUES (2670402, 'De Veenhuis Achterhoek');
INSERT INTO buurt (code, naam) VALUES (2670501, 'Horstbeek');
INSERT INTO buurt (code, naam) VALUES (2670502, 'Overhorst');
INSERT INTO buurt (code, naam) VALUES (2670503, 'Kleinhoven');
INSERT INTO buurt (code, naam) VALUES (2670504, 'Hogenbrink');
INSERT INTO buurt (code, naam) VALUES (2679997, '');
INSERT INTO buurt (code, naam) VALUES (2680100, 'Benedenstad');
INSERT INTO buurt (code, naam) VALUES (2680101, 'Stadscentrum');
INSERT INTO buurt (code, naam) VALUES (2680202, 'Bottendaal');
INSERT INTO buurt (code, naam) VALUES (2680203, 'Galgenveld');
INSERT INTO buurt (code, naam) VALUES (2680204, 'Altrade');
INSERT INTO buurt (code, naam) VALUES (2680205, 'Hunnerberg');
INSERT INTO buurt (code, naam) VALUES (2680206, 'Hengstdal');
INSERT INTO buurt (code, naam) VALUES (2680207, 'Kwakkenberg');
INSERT INTO buurt (code, naam) VALUES (2680208, 'Groenewoud');
INSERT INTO buurt (code, naam) VALUES (2680209, 'Ooyse Schependom');
INSERT INTO buurt (code, naam) VALUES (2680320, 'Biezen');
INSERT INTO buurt (code, naam) VALUES (2680321, 'Wolfskuil');
INSERT INTO buurt (code, naam) VALUES (2680422, 'Hees');
INSERT INTO buurt (code, naam) VALUES (2680423, 'Heseveld');
INSERT INTO buurt (code, naam) VALUES (2680424, 'Neerbosch-Oost');
INSERT INTO buurt (code, naam) VALUES (2680425, 'Haven- en industrieterrein');
INSERT INTO buurt (code, naam) VALUES (2680510, 'Nije Veld');
INSERT INTO buurt (code, naam) VALUES (2680511, 'Hazenkamp');
INSERT INTO buurt (code, naam) VALUES (2680512, 'Goffert');
INSERT INTO buurt (code, naam) VALUES (2680513, 'St. Anna');
INSERT INTO buurt (code, naam) VALUES (2680517, 'Heijendaal');
INSERT INTO buurt (code, naam) VALUES (2680614, 'Hatertse Hei');
INSERT INTO buurt (code, naam) VALUES (2680615, 'Grootstal');
INSERT INTO buurt (code, naam) VALUES (2680616, 'Hatert');
INSERT INTO buurt (code, naam) VALUES (2680618, 'Brakkenstein');
INSERT INTO buurt (code, naam) VALUES (2680731, 'Tolhuis');
INSERT INTO buurt (code, naam) VALUES (2680732, 'Zwanenveld');
INSERT INTO buurt (code, naam) VALUES (2680733, 'Meijhorst');
INSERT INTO buurt (code, naam) VALUES (2680734, 'Lankforst');
INSERT INTO buurt (code, naam) VALUES (2680735, 'Aldenhof');
INSERT INTO buurt (code, naam) VALUES (2680736, 'Malvert');
INSERT INTO buurt (code, naam) VALUES (2680737, 'Weezenhof');
INSERT INTO buurt (code, naam) VALUES (2680738, 'Vogelzang');
INSERT INTO buurt (code, naam) VALUES (2680739, 'Staddijk');
INSERT INTO buurt (code, naam) VALUES (2680840, '''t Acker');
INSERT INTO buurt (code, naam) VALUES (2680841, 'De Kamp');
INSERT INTO buurt (code, naam) VALUES (2680842, '''t Broek');
INSERT INTO buurt (code, naam) VALUES (2680843, 'Kerkenbos');
INSERT INTO buurt (code, naam) VALUES (2680847, 'Westkanaaldijk');
INSERT INTO buurt (code, naam) VALUES (2680848, 'Neerbosch-West');
INSERT INTO buurt (code, naam) VALUES (2680849, 'Bijsterhuizen');
INSERT INTO buurt (code, naam) VALUES (2680950, 'Oosterhout');
INSERT INTO buurt (code, naam) VALUES (2680960, 'Ressen');
INSERT INTO buurt (code, naam) VALUES (2680970, 'Lent');
INSERT INTO buurt (code, naam) VALUES (2690000, 'Oldebroek');
INSERT INTO buurt (code, naam) VALUES (2690001, 'Bovenstreek');
INSERT INTO buurt (code, naam) VALUES (2690002, 'Broekdijk');
INSERT INTO buurt (code, naam) VALUES (2690004, '''t Loo');
INSERT INTO buurt (code, naam) VALUES (2690005, 'Verspreide huizen Oldebroek');
INSERT INTO buurt (code, naam) VALUES (2690006, 'Verspreide huizen Oldebroekse Heide');
INSERT INTO buurt (code, naam) VALUES (2690007, 'Verspreide huizen polder Oldebroek');
INSERT INTO buurt (code, naam) VALUES (2690008, 'Verspreide huizen ''t Loo');
INSERT INTO buurt (code, naam) VALUES (2690009, 'Verspreide huizen heide ''t Loo');
INSERT INTO buurt (code, naam) VALUES (2690100, 'Wezep-Centrum');
INSERT INTO buurt (code, naam) VALUES (2690101, 'Wezep-Oost');
INSERT INTO buurt (code, naam) VALUES (2690102, 'Hattemerbroek');
INSERT INTO buurt (code, naam) VALUES (2690103, 'Wezep-West');
INSERT INTO buurt (code, naam) VALUES (2690104, 'Wezep-Noord');
INSERT INTO buurt (code, naam) VALUES (2690105, 'Verspreide huizen Wezep');
INSERT INTO buurt (code, naam) VALUES (2690106, 'Verspreide huizen Duivendans');
INSERT INTO buurt (code, naam) VALUES (2690107, 'Verspreide huizen Wezepse Heide');
INSERT INTO buurt (code, naam) VALUES (2690108, 'Verspreide huizen polder Hattemerbroek');
INSERT INTO buurt (code, naam) VALUES (2690109, 'Verspreide huizen Hattemerbroekse Heide');
INSERT INTO buurt (code, naam) VALUES (2690110, 'Verspreide huizen Heide Hoek');
INSERT INTO buurt (code, naam) VALUES (2690200, 'Oosterwolde');
INSERT INTO buurt (code, naam) VALUES (2690201, 'Noordeinde');
INSERT INTO buurt (code, naam) VALUES (2690203, 'Eekt');
INSERT INTO buurt (code, naam) VALUES (2690208, 'Verspreide huizen Oosterwolde');
INSERT INTO buurt (code, naam) VALUES (2690209, 'Verspreide huizen Noordeinde');
INSERT INTO buurt (code, naam) VALUES (2690210, 'Verspreide huizen Oosterwolde');
INSERT INTO buurt (code, naam) VALUES (2699997, '');
INSERT INTO buurt (code, naam) VALUES (2730000, 'Putten-Centrum');
INSERT INTO buurt (code, naam) VALUES (2730001, 'Putten-Zuid-Oost');
INSERT INTO buurt (code, naam) VALUES (2730002, 'Putten-Noord');
INSERT INTO buurt (code, naam) VALUES (2730003, 'Putten-Zuid-West');
INSERT INTO buurt (code, naam) VALUES (2730004, 'Putten-Stationsstraat industriegebied');
INSERT INTO buurt (code, naam) VALUES (2730005, 'Verspreide huizen Hell en Diermen');
INSERT INTO buurt (code, naam) VALUES (2730006, 'Verspreide huizen Huinen en Halvinkhuizen');
INSERT INTO buurt (code, naam) VALUES (2730007, 'Verspreide huizen Gerven');
INSERT INTO buurt (code, naam) VALUES (2730008, 'Verspreide huizen Norden, Bijsteren en Hoef');
INSERT INTO buurt (code, naam) VALUES (2730009, 'Verspreide huizen Nulde');
INSERT INTO buurt (code, naam) VALUES (2730100, 'Koudhoorn');
INSERT INTO buurt (code, naam) VALUES (2730108, 'Verspreide huizen Krachtighuizen en omgeving');
INSERT INTO buurt (code, naam) VALUES (2730109, 'Verspreide huizen bosgebied');
INSERT INTO buurt (code, naam) VALUES (2739997, '');
INSERT INTO buurt (code, naam) VALUES (2740000, 'Renkum-Zuid');
INSERT INTO buurt (code, naam) VALUES (2740001, 'Renkum-Noord');
INSERT INTO buurt (code, naam) VALUES (2740002, 'Heelsum');
INSERT INTO buurt (code, naam) VALUES (2740006, 'Verspreide huizen Renkumse Heide');
INSERT INTO buurt (code, naam) VALUES (2740007, 'Verspreide huizen Keijenbergseweg');
INSERT INTO buurt (code, naam) VALUES (2740100, 'Oosterbeek ten zuiden van Utrechtseweg');
INSERT INTO buurt (code, naam) VALUES (2740101, 'Oosterbeek ten noorden van Utrechtseweg');
INSERT INTO buurt (code, naam) VALUES (2740106, 'Verspreide huizen Dreijen');
INSERT INTO buurt (code, naam) VALUES (2740107, 'Verspreide huizen De Bilderberg');
INSERT INTO buurt (code, naam) VALUES (2740108, 'Verspreide huizen De Oorsprong');
INSERT INTO buurt (code, naam) VALUES (2740109, 'Verspreide huizen Rosandepolder');
INSERT INTO buurt (code, naam) VALUES (2740200, 'Heveadorp');
INSERT INTO buurt (code, naam) VALUES (2740201, 'Wolfheze');
INSERT INTO buurt (code, naam) VALUES (2740202, 'Doorwerth');
INSERT INTO buurt (code, naam) VALUES (2740203, 'Kievitsdel');
INSERT INTO buurt (code, naam) VALUES (2740204, 'Verspreide huizen Reyerscamp');
INSERT INTO buurt (code, naam) VALUES (2740205, 'Verspreide huizen hotel Wolfheze');
INSERT INTO buurt (code, naam) VALUES (2740207, 'Verspreide huizen Buunderkamp');
INSERT INTO buurt (code, naam) VALUES (2740208, 'Verspreide huizen Doorwerthse bossen');
INSERT INTO buurt (code, naam) VALUES (2740209, 'Verspreide huizen Doorwerthse waarden');
INSERT INTO buurt (code, naam) VALUES (2750000, 'Dieren-Zuid beneden spoorlijn');
INSERT INTO buurt (code, naam) VALUES (2750001, 'Dieren-Noord boven spoorlijn');
INSERT INTO buurt (code, naam) VALUES (2750002, 'Dieren-West boven spoorlijn');
INSERT INTO buurt (code, naam) VALUES (2750003, 'Spankeren');
INSERT INTO buurt (code, naam) VALUES (2750004, 'Ellecom');
INSERT INTO buurt (code, naam) VALUES (2750005, 'Laag-Soeren');
INSERT INTO buurt (code, naam) VALUES (2750007, 'Verspreide huizen bosgebied Laag Soeren');
INSERT INTO buurt (code, naam) VALUES (2750008, 'Verspreide huizen Spankeren');
INSERT INTO buurt (code, naam) VALUES (2750009, 'Verspreide huizen Fraterwaard en Beimerwaard');
INSERT INTO buurt (code, naam) VALUES (2750010, 'Verspreide huizen bosgebied Ellecom');
INSERT INTO buurt (code, naam) VALUES (2750011, 'Verspreide huizen bosgebied Dieren');
INSERT INTO buurt (code, naam) VALUES (2750100, 'Rheden');
INSERT INTO buurt (code, naam) VALUES (2750101, 'Rheden-West ten westen van Oranjeweg en Haverweg');
INSERT INTO buurt (code, naam) VALUES (2750102, 'Verspreide huizen Rheden');
INSERT INTO buurt (code, naam) VALUES (2750103, 'De Steeg');
INSERT INTO buurt (code, naam) VALUES (2750106, 'Verspreide huizen bosgebied De Steeg');
INSERT INTO buurt (code, naam) VALUES (2750107, 'Verspreide huizen bosgebied Rheden');
INSERT INTO buurt (code, naam) VALUES (2750108, 'Verspreide huizen Havikerwaard en Middachten');
INSERT INTO buurt (code, naam) VALUES (2750200, 'Velp-Noord boven spoorlijn');
INSERT INTO buurt (code, naam) VALUES (2750201, 'Velp-Zuid beneden spoorlijn');
INSERT INTO buurt (code, naam) VALUES (2750202, 'Velp-Zuid ten zuiden van Waterstraat');
INSERT INTO buurt (code, naam) VALUES (2750208, 'Verspreide huizen Velp-Noordoost');
INSERT INTO buurt (code, naam) VALUES (2750209, 'Verspreide huizen Velp-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (2770000, 'Rozendaal');
INSERT INTO buurt (code, naam) VALUES (2770009, 'Verspreide huizen Imbosch en Terlet');
INSERT INTO buurt (code, naam) VALUES (2790000, 'Scherpenzeel');
INSERT INTO buurt (code, naam) VALUES (2790008, 'Verspreide huizen ten zuiden van Scherpenzeel');
INSERT INTO buurt (code, naam) VALUES (2790009, 'Verspreide huizen ten noorden van Scherpenzeel');
INSERT INTO buurt (code, naam) VALUES (2810000, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (2810001, 'Sterrebos');
INSERT INTO buurt (code, naam) VALUES (2810002, 'Hertogenwijk');
INSERT INTO buurt (code, naam) VALUES (2810003, 'Burgemeestersbuurt');
INSERT INTO buurt (code, naam) VALUES (2810004, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (2810005, 'Sandwijk');
INSERT INTO buurt (code, naam) VALUES (2810006, 'Lok');
INSERT INTO buurt (code, naam) VALUES (2810007, 'Ooij');
INSERT INTO buurt (code, naam) VALUES (2810008, 'Ridderweide en Tiel-West');
INSERT INTO buurt (code, naam) VALUES (2810009, 'Latenstein');
INSERT INTO buurt (code, naam) VALUES (2810100, 'Elzenpas');
INSERT INTO buurt (code, naam) VALUES (2810101, 'Westroijen');
INSERT INTO buurt (code, naam) VALUES (2810102, 'Uitbreiding ten zuiden van kanaal Passewaaij-Noord');
INSERT INTO buurt (code, naam) VALUES (2810103, 'Rauwenhof');
INSERT INTO buurt (code, naam) VALUES (2810104, 'Drumpt');
INSERT INTO buurt (code, naam) VALUES (2810105, 'Zennewijnen');
INSERT INTO buurt (code, naam) VALUES (2810106, 'Passewaay-Zuid');
INSERT INTO buurt (code, naam) VALUES (2810107, 'Verspreide huizen Passewaaij');
INSERT INTO buurt (code, naam) VALUES (2810108, 'Veluwe');
INSERT INTO buurt (code, naam) VALUES (2810109, 'Industrieterrein Kellen');
INSERT INTO buurt (code, naam) VALUES (2810200, 'Wadenoijen');
INSERT INTO buurt (code, naam) VALUES (2810201, 'Kapel-Avezaath');
INSERT INTO buurt (code, naam) VALUES (2810202, 'Industrieterrein Medel');
INSERT INTO buurt (code, naam) VALUES (2810208, 'Verspreide huizen Bergakker');
INSERT INTO buurt (code, naam) VALUES (2810209, 'Verspreide huizen Wadenoijen');
INSERT INTO buurt (code, naam) VALUES (2820000, 'Ubbergen');
INSERT INTO buurt (code, naam) VALUES (2820001, 'Beek');
INSERT INTO buurt (code, naam) VALUES (2820002, 'Berg en Dal (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (2820003, 'Ooij');
INSERT INTO buurt (code, naam) VALUES (2820004, 'Leuth');
INSERT INTO buurt (code, naam) VALUES (2820005, 'Kekerdom');
INSERT INTO buurt (code, naam) VALUES (2820006, 'Verspreide huizen Beek');
INSERT INTO buurt (code, naam) VALUES (2820007, 'Verspreide huizen Leuth');
INSERT INTO buurt (code, naam) VALUES (2820008, 'Verspreide huizen Kekerdom');
INSERT INTO buurt (code, naam) VALUES (2820009, 'Verspreide huizen Ooij, Persingen, Erlecom');
INSERT INTO buurt (code, naam) VALUES (2850000, 'Voorst');
INSERT INTO buurt (code, naam) VALUES (2850001, 'Bussloo');
INSERT INTO buurt (code, naam) VALUES (2850002, 'Gietelo');
INSERT INTO buurt (code, naam) VALUES (2850005, 'Verspreide huizen Voorst en Wilpse Klei');
INSERT INTO buurt (code, naam) VALUES (2850006, 'Verspreide huizen Gietelo-Bussloo');
INSERT INTO buurt (code, naam) VALUES (2850007, 'Verspreide huizen langs de IJssel Voorster Klei');
INSERT INTO buurt (code, naam) VALUES (2850008, 'Verspreide huizen Appensche Veld');
INSERT INTO buurt (code, naam) VALUES (2850009, 'Verspreide huizen akkerbouwgebied Noord-Empe');
INSERT INTO buurt (code, naam) VALUES (2850100, 'Twello-Midden');
INSERT INTO buurt (code, naam) VALUES (2850101, 'Twello-Zuid');
INSERT INTO buurt (code, naam) VALUES (2850102, 'Twello-Noord');
INSERT INTO buurt (code, naam) VALUES (2850103, 'Terwolde');
INSERT INTO buurt (code, naam) VALUES (2850104, 'Nijbroek');
INSERT INTO buurt (code, naam) VALUES (2850105, 'Verspreide huizen Twello-Zuid');
INSERT INTO buurt (code, naam) VALUES (2850106, 'Steenenkamer');
INSERT INTO buurt (code, naam) VALUES (2850107, 'Verspreide huizen Twello-Noord');
INSERT INTO buurt (code, naam) VALUES (2850108, 'Verspreide huizen Nijbroek');
INSERT INTO buurt (code, naam) VALUES (2850109, 'Verspreide huizen op de oeverwal Terwolde');
INSERT INTO buurt (code, naam) VALUES (2850200, 'Klarenbeek (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (2850201, 'Teuge');
INSERT INTO buurt (code, naam) VALUES (2850202, 'Wilp-Achterhoek');
INSERT INTO buurt (code, naam) VALUES (2850203, 'De Vecht');
INSERT INTO buurt (code, naam) VALUES (2850205, 'Verspreide huizen De Vecht, De Pol en omgeving');
INSERT INTO buurt (code, naam) VALUES (2850206, 'Verspreide huizen Teuge');
INSERT INTO buurt (code, naam) VALUES (2850207, 'Verspreide huizen Wilp-Achterhoek');
INSERT INTO buurt (code, naam) VALUES (2850208, 'Verspreide huizen Klarenbeek-Noord');
INSERT INTO buurt (code, naam) VALUES (2850209, 'Verspreide huizen Klarenbeek-Zuid');
INSERT INTO buurt (code, naam) VALUES (2850300, 'Wilp');
INSERT INTO buurt (code, naam) VALUES (2850301, 'Posterenk');
INSERT INTO buurt (code, naam) VALUES (2850308, 'Verspreide huizen Wilp en Posterenk');
INSERT INTO buurt (code, naam) VALUES (2850309, 'Verspreide huizen op de Wilpse Klei');
INSERT INTO buurt (code, naam) VALUES (2890000, 'Oude Stad Binnenstad');
INSERT INTO buurt (code, naam) VALUES (2890001, 'Buitenwijk Wageningen-Noord');
INSERT INTO buurt (code, naam) VALUES (2890002, 'Buitenwijk Wageningen-Oost');
INSERT INTO buurt (code, naam) VALUES (2890003, 'Buitenwijk Wageningen-West');
INSERT INTO buurt (code, naam) VALUES (2890004, 'Buitenwijk Wageningen-Noordwest');
INSERT INTO buurt (code, naam) VALUES (2890005, 'Buitenwijk Tarthorst-Roghorst-Haverlanden');
INSERT INTO buurt (code, naam) VALUES (2890006, 'Buitenwijk Wageningen-Noordoost');
INSERT INTO buurt (code, naam) VALUES (2890007, 'Uitbreidingsplan-Noordwest');
INSERT INTO buurt (code, naam) VALUES (2890100, 'Wageningen Hoog');
INSERT INTO buurt (code, naam) VALUES (2890105, 'Verspreide huizen Hogesteeg, De Keyzer en omgeving');
INSERT INTO buurt (code, naam) VALUES (2890106, 'Verspreide huizen vroegere Nude-gebied');
INSERT INTO buurt (code, naam) VALUES (2890107, 'Verspreide huizen Het Binnenveld');
INSERT INTO buurt (code, naam) VALUES (2890108, 'Verspreide huizen Wageningse Berg, De Eng en omgeving');
INSERT INTO buurt (code, naam) VALUES (2890109, 'Verspreide huizen Uiterwaarden');
INSERT INTO buurt (code, naam) VALUES (2930000, 'Westervoort');
INSERT INTO buurt (code, naam) VALUES (2930001, 'Westervoort-Broeklanden');
INSERT INTO buurt (code, naam) VALUES (2930002, 'Westervoort-Lange Maat en Hoogeind');
INSERT INTO buurt (code, naam) VALUES (2930003, 'De Leigraaf-De Steenderens');
INSERT INTO buurt (code, naam) VALUES (2930004, 'De Ganzepoel-Schans');
INSERT INTO buurt (code, naam) VALUES (2930009, 'Verspreide huizen Westervoort');
INSERT INTO buurt (code, naam) VALUES (2940000, 'Centrale deel');
INSERT INTO buurt (code, naam) VALUES (2940001, 'Winterswijk-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (2940002, 'Winterswijk-Noordwest');
INSERT INTO buurt (code, naam) VALUES (2940003, 'Winterswijk-Noordoost');
INSERT INTO buurt (code, naam) VALUES (2940004, 'Winterswijk-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (2940100, 'Meddo');
INSERT INTO buurt (code, naam) VALUES (2940101, 'Kotten');
INSERT INTO buurt (code, naam) VALUES (2940102, 'Miste');
INSERT INTO buurt (code, naam) VALUES (2940103, 'Verspreide huizen Brinkheurne en omgeving');
INSERT INTO buurt (code, naam) VALUES (2940104, 'Verspreide huizen Meddo');
INSERT INTO buurt (code, naam) VALUES (2940105, 'Verspreide huizen ten noorden van Winterswijk');
INSERT INTO buurt (code, naam) VALUES (2940106, 'Verspreide huizen Ratum, Henxel, Huppel');
INSERT INTO buurt (code, naam) VALUES (2940107, 'Verspreide huizen Kotten');
INSERT INTO buurt (code, naam) VALUES (2940108, 'Woold');
INSERT INTO buurt (code, naam) VALUES (2940109, 'Verspreide huizen Miste');
INSERT INTO buurt (code, naam) VALUES (2940120, 'Verspreide huizen Corle en omgeving');
INSERT INTO buurt (code, naam) VALUES (2940121, 'Verspreide huizen Woold');
INSERT INTO buurt (code, naam) VALUES (2960000, 'Verspreide huizen wezel');
INSERT INTO buurt (code, naam) VALUES (2960001, 'Verspreide huizen Vormer');
INSERT INTO buurt (code, naam) VALUES (2960002, 'Verspreide huizen Bankhoef');
INSERT INTO buurt (code, naam) VALUES (2960100, 'Saltshof');
INSERT INTO buurt (code, naam) VALUES (2960101, 'Bedrijventerrein Bijsterhuizen');
INSERT INTO buurt (code, naam) VALUES (2960102, 'Woezik');
INSERT INTO buurt (code, naam) VALUES (2960103, 'Veenhof');
INSERT INTO buurt (code, naam) VALUES (2960104, 'Verspreide huizen Woezik');
INSERT INTO buurt (code, naam) VALUES (2960105, 'Lambrasse');
INSERT INTO buurt (code, naam) VALUES (2960106, 'Kraaijenberg');
INSERT INTO buurt (code, naam) VALUES (2960107, 'Heilige Stoel');
INSERT INTO buurt (code, naam) VALUES (2960108, 'Homberg');
INSERT INTO buurt (code, naam) VALUES (2960109, 'Wijchen Noord');
INSERT INTO buurt (code, naam) VALUES (2960110, 'Hofsedam');
INSERT INTO buurt (code, naam) VALUES (2960111, 'Bedrijventerrein Zesweg');
INSERT INTO buurt (code, naam) VALUES (2960112, 'Blauwe Hof');
INSERT INTO buurt (code, naam) VALUES (2960113, 'Aalsburg');
INSERT INTO buurt (code, naam) VALUES (2960114, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (2960115, 'De Uilenboom');
INSERT INTO buurt (code, naam) VALUES (2960116, 'Valendries');
INSERT INTO buurt (code, naam) VALUES (2960117, 'Bedrijventerrein Nieuwenweg');
INSERT INTO buurt (code, naam) VALUES (2960118, 'Verspreide huizen Valendries');
INSERT INTO buurt (code, naam) VALUES (2960119, 'Zevendreef');
INSERT INTO buurt (code, naam) VALUES (2960120, 'Zesakkers');
INSERT INTO buurt (code, naam) VALUES (2960121, 'De Grippen');
INSERT INTO buurt (code, naam) VALUES (2960122, 'De Weertjes');
INSERT INTO buurt (code, naam) VALUES (2960123, 'Diepvoorde');
INSERT INTO buurt (code, naam) VALUES (2960124, 'Huissteden-Zuiderpoort');
INSERT INTO buurt (code, naam) VALUES (2960125, 'Hoogmeer');
INSERT INTO buurt (code, naam) VALUES (2960126, 'De Ververt');
INSERT INTO buurt (code, naam) VALUES (2960127, 'Sluiskamp');
INSERT INTO buurt (code, naam) VALUES (2960128, 'Oudelaan');
INSERT INTO buurt (code, naam) VALUES (2960129, 'Kronenland');
INSERT INTO buurt (code, naam) VALUES (2960130, 'Abersland');
INSERT INTO buurt (code, naam) VALUES (2960131, 'Elsland');
INSERT INTO buurt (code, naam) VALUES (2960132, 'De Geer');
INSERT INTO buurt (code, naam) VALUES (2960133, 'De gamert');
INSERT INTO buurt (code, naam) VALUES (2960134, 'De Meren');
INSERT INTO buurt (code, naam) VALUES (2960135, 'De Flier');
INSERT INTO buurt (code, naam) VALUES (2960136, 'Diemewei');
INSERT INTO buurt (code, naam) VALUES (2960137, 'De Lingert');
INSERT INTO buurt (code, naam) VALUES (2960138, 'Huurlingsedam');
INSERT INTO buurt (code, naam) VALUES (2960200, 'Balgoij');
INSERT INTO buurt (code, naam) VALUES (2960201, 'Verspreidehuizen Balgoij');
INSERT INTO buurt (code, naam) VALUES (2960300, 'Batenburg');
INSERT INTO buurt (code, naam) VALUES (2960301, 'Verspreide huizen Batenburg');
INSERT INTO buurt (code, naam) VALUES (2960400, 'Bergharen');
INSERT INTO buurt (code, naam) VALUES (2960401, 'Bedrijventerrein Breekwagen');
INSERT INTO buurt (code, naam) VALUES (2960402, 'Verspreide huizen Bergharen');
INSERT INTO buurt (code, naam) VALUES (2960500, 'Hernen');
INSERT INTO buurt (code, naam) VALUES (2960501, 'Verspreide huizen Hernen');
INSERT INTO buurt (code, naam) VALUES (2960600, 'Leur');
INSERT INTO buurt (code, naam) VALUES (2960601, 'Verspreide huizen Leur');
INSERT INTO buurt (code, naam) VALUES (2960700, 'Niftrik');
INSERT INTO buurt (code, naam) VALUES (2960701, 'Loonse Waard');
INSERT INTO buurt (code, naam) VALUES (2960702, 'Verspreide huizen Niftrik');
INSERT INTO buurt (code, naam) VALUES (2960800, 'Verspreide huizen Hoogbroek');
INSERT INTO buurt (code, naam) VALUES (2960801, 'Verspreide huizen Heumenseweg-Boskant');
INSERT INTO buurt (code, naam) VALUES (2960802, 'Verspreide huizen Lunen');
INSERT INTO buurt (code, naam) VALUES (2960803, 'Alverna');
INSERT INTO buurt (code, naam) VALUES (2970000, 'Zaltbommel Binnenstad');
INSERT INTO buurt (code, naam) VALUES (2970001, 'Zaltbommel Vergt en omgeving');
INSERT INTO buurt (code, naam) VALUES (2970002, 'Zaltbommel Spellewaard');
INSERT INTO buurt (code, naam) VALUES (2970007, 'Verspreide huizen Hoeven');
INSERT INTO buurt (code, naam) VALUES (2970008, 'Verspreide huizen Oostzijde');
INSERT INTO buurt (code, naam) VALUES (2970009, 'Verspreide huizen Westzijde');
INSERT INTO buurt (code, naam) VALUES (2970100, 'Brakel');
INSERT INTO buurt (code, naam) VALUES (2970101, 'Poederoijen');
INSERT INTO buurt (code, naam) VALUES (2970102, 'Aalst');
INSERT INTO buurt (code, naam) VALUES (2970103, 'Zuilichem');
INSERT INTO buurt (code, naam) VALUES (2970104, 'De Rietschoof');
INSERT INTO buurt (code, naam) VALUES (2970105, 'Verspreide huizen in de polder Aalst');
INSERT INTO buurt (code, naam) VALUES (2970106, 'Verspreide huizen in de polder Poederoijen');
INSERT INTO buurt (code, naam) VALUES (2970107, 'Verspreide huizen in de polder Brakel');
INSERT INTO buurt (code, naam) VALUES (2970108, 'Verspreide huizen in het Munnikenland');
INSERT INTO buurt (code, naam) VALUES (2970109, 'Verspreide huizen in de polder Zuilichem en omgeving');
INSERT INTO buurt (code, naam) VALUES (2970200, 'Kerkwijk');
INSERT INTO buurt (code, naam) VALUES (2970201, 'Bruchem');
INSERT INTO buurt (code, naam) VALUES (2970202, 'Beneden-Delwijnen');
INSERT INTO buurt (code, naam) VALUES (2970203, 'Gameren');
INSERT INTO buurt (code, naam) VALUES (2970204, 'Nieuwaal');
INSERT INTO buurt (code, naam) VALUES (2970207, 'Verspreide huizen polders Delwijnen en Bruchem');
INSERT INTO buurt (code, naam) VALUES (2970208, 'Verspreide huizen Kerkwijk en Bruchem');
INSERT INTO buurt (code, naam) VALUES (2970209, 'Verspreide huizen polders Gameren en Nieuwaal');
INSERT INTO buurt (code, naam) VALUES (2970300, 'Nederhemert-Noordzijde');
INSERT INTO buurt (code, naam) VALUES (2970301, 'Nederhemert-Zuidzijde');
INSERT INTO buurt (code, naam) VALUES (2970309, 'Verspreide huizen Nederhemert');
INSERT INTO buurt (code, naam) VALUES (2990000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (2990001, 'Molenwijk');
INSERT INTO buurt (code, naam) VALUES (2990002, 'Het Grieth');
INSERT INTO buurt (code, naam) VALUES (2990003, 'Schrijvershoek');
INSERT INTO buurt (code, naam) VALUES (2990004, 'Zonnemaat');
INSERT INTO buurt (code, naam) VALUES (2990005, 'Lentemorgen I');
INSERT INTO buurt (code, naam) VALUES (2990006, 'Stegeslag');
INSERT INTO buurt (code, naam) VALUES (2990007, 'Lentemorgen II');
INSERT INTO buurt (code, naam) VALUES (2990008, 'Tatelaar');
INSERT INTO buurt (code, naam) VALUES (2990009, 'De Horst');
INSERT INTO buurt (code, naam) VALUES (2990010, 'Methen');
INSERT INTO buurt (code, naam) VALUES (2990011, 'Mercurion');
INSERT INTO buurt (code, naam) VALUES (2990012, 'Hengelder');
INSERT INTO buurt (code, naam) VALUES (2990013, 'Zuidspoor');
INSERT INTO buurt (code, naam) VALUES (2990014, 'Oud-Zevenaar');
INSERT INTO buurt (code, naam) VALUES (2990015, 'Ooy');
INSERT INTO buurt (code, naam) VALUES (2990017, 'Zevenaars Broek');
INSERT INTO buurt (code, naam) VALUES (2990100, 'Babberich');
INSERT INTO buurt (code, naam) VALUES (2990101, 'Camphuizen');
INSERT INTO buurt (code, naam) VALUES (2990102, 'Steeg');
INSERT INTO buurt (code, naam) VALUES (2990103, 'Kwartier');
INSERT INTO buurt (code, naam) VALUES (2990200, 'Angerlo');
INSERT INTO buurt (code, naam) VALUES (2990201, 'Angerlo''s Broek');
INSERT INTO buurt (code, naam) VALUES (2990300, 'Giesbeek');
INSERT INTO buurt (code, naam) VALUES (2990301, 'Rhederlaag');
INSERT INTO buurt (code, naam) VALUES (2990400, 'Lathum');
INSERT INTO buurt (code, naam) VALUES (3010000, 'Stadskern');
INSERT INTO buurt (code, naam) VALUES (3010001, 'Laarstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (3010002, 'Marswegkwartier');
INSERT INTO buurt (code, naam) VALUES (3010003, 'Nieuwstad en Coehoornsingel');
INSERT INTO buurt (code, naam) VALUES (3010004, 'De Hoven');
INSERT INTO buurt (code, naam) VALUES (3010100, 'Vijver en omgeving');
INSERT INTO buurt (code, naam) VALUES (3010101, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (3010102, 'Helbergen');
INSERT INTO buurt (code, naam) VALUES (3010103, 'Warnsveldsewegkwartier-Zuid');
INSERT INTO buurt (code, naam) VALUES (3010104, 'Warnsveldsewegkwartier-Noord');
INSERT INTO buurt (code, naam) VALUES (3010105, 'Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (3010106, 'Pagemate en omgeving');
INSERT INTO buurt (code, naam) VALUES (3010200, 'Helleraetplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (3010201, 'Weg naar Laren en omgeving');
INSERT INTO buurt (code, naam) VALUES (3010202, 'Deventerweg en Polbeek');
INSERT INTO buurt (code, naam) VALUES (3010203, 'Voorsteralleekwartier');
INSERT INTO buurt (code, naam) VALUES (3010300, 'Moesmate en Tichelkuilen');
INSERT INTO buurt (code, naam) VALUES (3010301, 'Zwanevlot en De Brink');
INSERT INTO buurt (code, naam) VALUES (3010302, 'Braamkamp');
INSERT INTO buurt (code, naam) VALUES (3010303, 'Stokebrand, Balijnenland en Bronsbergen');
INSERT INTO buurt (code, naam) VALUES (3010304, 'Waarden en weerdslag');
INSERT INTO buurt (code, naam) VALUES (3010400, 'Ooyerhoek');
INSERT INTO buurt (code, naam) VALUES (3010401, 'De Enk');
INSERT INTO buurt (code, naam) VALUES (3010402, 'Eme en Broek');
INSERT INTO buurt (code, naam) VALUES (3010403, 'Looërenk en Woud');
INSERT INTO buurt (code, naam) VALUES (3010409, 'Vespreide huizen Leesten');
INSERT INTO buurt (code, naam) VALUES (3010500, 'Dorp Warnsveld');
INSERT INTO buurt (code, naam) VALUES (3010501, 'Welgelegen');
INSERT INTO buurt (code, naam) VALUES (3010502, 'Scheperkamp');
INSERT INTO buurt (code, naam) VALUES (3010503, 'Overkamp');
INSERT INTO buurt (code, naam) VALUES (3010509, 'Warken');
INSERT INTO buurt (code, naam) VALUES (3020000, 'Nunspeet-Oost');
INSERT INTO buurt (code, naam) VALUES (3020001, 'Nunspeet-West');
INSERT INTO buurt (code, naam) VALUES (3020002, 'Nunspeet-Zuid');
INSERT INTO buurt (code, naam) VALUES (3020003, 'Hulshorst');
INSERT INTO buurt (code, naam) VALUES (3020005, 'Verspreide huizen Hulshorst');
INSERT INTO buurt (code, naam) VALUES (3020006, 'Verspreide huizen Zuiderzeeland Nunspeet');
INSERT INTO buurt (code, naam) VALUES (3020007, 'Verspreide huizen Zuiderzeeland Hulshorst');
INSERT INTO buurt (code, naam) VALUES (3020008, 'Verspreide huizen bosgebied Nunspeet');
INSERT INTO buurt (code, naam) VALUES (3020009, 'Verspreide huizen bosgebied Hulshorst');
INSERT INTO buurt (code, naam) VALUES (3020100, 'Elspeet');
INSERT INTO buurt (code, naam) VALUES (3020101, 'Vierhouten');
INSERT INTO buurt (code, naam) VALUES (3020107, 'Verspreide huizen bosgebied Vierhouten');
INSERT INTO buurt (code, naam) VALUES (3020108, 'Verspreide huizen Elspeet en omgeving');
INSERT INTO buurt (code, naam) VALUES (3020109, 'Verspreide huizen Elspeetse Bos');
INSERT INTO buurt (code, naam) VALUES (3029997, '');
INSERT INTO buurt (code, naam) VALUES (3030101, 'Poort van Dronten');
INSERT INTO buurt (code, naam) VALUES (3030102, 'Business Zone Delta');
INSERT INTO buurt (code, naam) VALUES (3030103, 'De Gilden');
INSERT INTO buurt (code, naam) VALUES (3030104, 'De Munten');
INSERT INTO buurt (code, naam) VALUES (3030105, 'De Drieslag');
INSERT INTO buurt (code, naam) VALUES (3030210, 'Pioniersweg');
INSERT INTO buurt (code, naam) VALUES (3030211, 'Houtwijk');
INSERT INTO buurt (code, naam) VALUES (3030212, 'Hanzekwartier');
INSERT INTO buurt (code, naam) VALUES (3030213, 'De Oeverloperwijk');
INSERT INTO buurt (code, naam) VALUES (3030320, 'Centrum Dronten');
INSERT INTO buurt (code, naam) VALUES (3030321, 'Oud-Dronten');
INSERT INTO buurt (code, naam) VALUES (3030322, 'De Fazant');
INSERT INTO buurt (code, naam) VALUES (3030323, 'Bungalowpark');
INSERT INTO buurt (code, naam) VALUES (3030324, 'De Boeg');
INSERT INTO buurt (code, naam) VALUES (3030430, 'De Landmaten');
INSERT INTO buurt (code, naam) VALUES (3030431, 'De Manege');
INSERT INTO buurt (code, naam) VALUES (3030432, 'De Lancaster');
INSERT INTO buurt (code, naam) VALUES (3030433, 'De Landstreken');
INSERT INTO buurt (code, naam) VALUES (3030434, 'De Kruidentuin');
INSERT INTO buurt (code, naam) VALUES (3030435, 'Golfresidentie');
INSERT INTO buurt (code, naam) VALUES (3030548, 'AZC');
INSERT INTO buurt (code, naam) VALUES (3030549, 'Ketelhaven');
INSERT INTO buurt (code, naam) VALUES (3030550, 'Buitengebied Dronten');
INSERT INTO buurt (code, naam) VALUES (3030601, 'Oud-Biddinghuizen Buiten');
INSERT INTO buurt (code, naam) VALUES (3030602, 'Oud-Biddinghuizen');
INSERT INTO buurt (code, naam) VALUES (3030603, 'De Kaai');
INSERT INTO buurt (code, naam) VALUES (3030604, 'Centrum Biddinghuizen');
INSERT INTO buurt (code, naam) VALUES (3030605, 'De Baan');
INSERT INTO buurt (code, naam) VALUES (3030606, 'Bremerpark');
INSERT INTO buurt (code, naam) VALUES (3030607, 'De Graafschap');
INSERT INTO buurt (code, naam) VALUES (3030608, 'Noorderbaan');
INSERT INTO buurt (code, naam) VALUES (3030609, 'Oldebroekerweg');
INSERT INTO buurt (code, naam) VALUES (3030620, 'Buitengebied Biddinghuizen');
INSERT INTO buurt (code, naam) VALUES (3030701, 'Kampbuurt');
INSERT INTO buurt (code, naam) VALUES (3030702, 'Centrum Swifterbant');
INSERT INTO buurt (code, naam) VALUES (3030703, 'Oud-Swifterbant');
INSERT INTO buurt (code, naam) VALUES (3030704, 'Spelbuurt');
INSERT INTO buurt (code, naam) VALUES (3030705, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (3030706, 'De Kolk');
INSERT INTO buurt (code, naam) VALUES (3030707, 'Tarpan');
INSERT INTO buurt (code, naam) VALUES (3030708, 'Bedrijventerrein Spelwijk');
INSERT INTO buurt (code, naam) VALUES (3030720, 'Buitengebied Swifterbant');
INSERT INTO buurt (code, naam) VALUES (3039997, '');
INSERT INTO buurt (code, naam) VALUES (3040000, 'Haaften');
INSERT INTO buurt (code, naam) VALUES (3040001, 'Tuil');
INSERT INTO buurt (code, naam) VALUES (3040002, 'Hellouw');
INSERT INTO buurt (code, naam) VALUES (3040007, 'Verspreide huizen Tuil');
INSERT INTO buurt (code, naam) VALUES (3040008, 'Verspreide huizen Hellouw');
INSERT INTO buurt (code, naam) VALUES (3040009, 'Verspreide huizen Haaften');
INSERT INTO buurt (code, naam) VALUES (3040100, 'Waardenburg');
INSERT INTO buurt (code, naam) VALUES (3040101, 'Waardenburg-West');
INSERT INTO buurt (code, naam) VALUES (3040102, 'Neerijnen');
INSERT INTO buurt (code, naam) VALUES (3040103, 'Opijnen');
INSERT INTO buurt (code, naam) VALUES (3040104, 'Est');
INSERT INTO buurt (code, naam) VALUES (3040106, 'Verspreide huizen Est');
INSERT INTO buurt (code, naam) VALUES (3040107, 'Verspreide huizen Opijnen');
INSERT INTO buurt (code, naam) VALUES (3040108, 'Verspreide huizen Neerijnen');
INSERT INTO buurt (code, naam) VALUES (3040109, 'Verspreide huizen Waardenburg');
INSERT INTO buurt (code, naam) VALUES (3040200, 'Ophemert');
INSERT INTO buurt (code, naam) VALUES (3040201, 'Varik');
INSERT INTO buurt (code, naam) VALUES (3040202, 'Heesselt');
INSERT INTO buurt (code, naam) VALUES (3040207, 'Verspreide huizen Heesselt');
INSERT INTO buurt (code, naam) VALUES (3040208, 'Verspreide huizen Varik');
INSERT INTO buurt (code, naam) VALUES (3040209, 'Verspreide huizen Ophemert');
INSERT INTO buurt (code, naam) VALUES (3070100, 'Hof');
INSERT INTO buurt (code, naam) VALUES (3070101, 'Nieuwstraat');
INSERT INTO buurt (code, naam) VALUES (3070102, 'Mooierstraat');
INSERT INTO buurt (code, naam) VALUES (3070103, 'Lieve Vrouwekerkhof');
INSERT INTO buurt (code, naam) VALUES (3070104, 'Coninckstraat');
INSERT INTO buurt (code, naam) VALUES (3070105, 'Beestenmarkt');
INSERT INTO buurt (code, naam) VALUES (3070106, 'Gote Haag');
INSERT INTO buurt (code, naam) VALUES (3070107, 'Stadhuisplein');
INSERT INTO buurt (code, naam) VALUES (3070108, 'Schimmelpenninckstraat');
INSERT INTO buurt (code, naam) VALUES (3070200, 'Smallepad');
INSERT INTO buurt (code, naam) VALUES (3070202, 'Snouckaertlaan');
INSERT INTO buurt (code, naam) VALUES (3070204, 'Zonnehof');
INSERT INTO buurt (code, naam) VALUES (3070205, 'Weltevreden');
INSERT INTO buurt (code, naam) VALUES (3070206, 'Bloemweg');
INSERT INTO buurt (code, naam) VALUES (3070300, 'Rivierenbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (3070301, 'Rivierenbuurt-West');
INSERT INTO buurt (code, naam) VALUES (3070302, 'G. van Stellingwerfstraat');
INSERT INTO buurt (code, naam) VALUES (3070303, 'Bloemenbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (3070304, 'Bloemenbuurt-West');
INSERT INTO buurt (code, naam) VALUES (3070305, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (3070306, 'Puntenburg');
INSERT INTO buurt (code, naam) VALUES (3070307, 'Piet Mondriaanlaan');
INSERT INTO buurt (code, naam) VALUES (3070401, 'Eemplein');
INSERT INTO buurt (code, naam) VALUES (3070402, 'Geldersestraat');
INSERT INTO buurt (code, naam) VALUES (3070403, 'Chromiumweg');
INSERT INTO buurt (code, naam) VALUES (3070404, 'Uraniumweg');
INSERT INTO buurt (code, naam) VALUES (3070500, 'Birkhoven en Bokkeduinen');
INSERT INTO buurt (code, naam) VALUES (3070501, 'Vlasakkers');
INSERT INTO buurt (code, naam) VALUES (3070502, 'Zon en Schild');
INSERT INTO buurt (code, naam) VALUES (3070600, 'Jericho en Jeruzalem');
INSERT INTO buurt (code, naam) VALUES (3070601, 'Meridiaan');
INSERT INTO buurt (code, naam) VALUES (3070603, 'Gildekwartier');
INSERT INTO buurt (code, naam) VALUES (3070700, 'Evertsenstraat');
INSERT INTO buurt (code, naam) VALUES (3070701, 'Neptunusplein');
INSERT INTO buurt (code, naam) VALUES (3070702, 'Columbusweg');
INSERT INTO buurt (code, naam) VALUES (3070800, 'Vuurtoren');
INSERT INTO buurt (code, naam) VALUES (3070801, 'De Plaatsen');
INSERT INTO buurt (code, naam) VALUES (3070803, 'Koperhorst');
INSERT INTO buurt (code, naam) VALUES (3070900, 'Elly Takmastraat');
INSERT INTO buurt (code, naam) VALUES (3070902, 'Camera Obscurastraat');
INSERT INTO buurt (code, naam) VALUES (3070903, 'Queekhoven');
INSERT INTO buurt (code, naam) VALUES (3070905, 'Het Gein');
INSERT INTO buurt (code, naam) VALUES (3071000, 'Liendertsedreef');
INSERT INTO buurt (code, naam) VALUES (3071001, 'Vinkenbaan');
INSERT INTO buurt (code, naam) VALUES (3071002, 'De Horsten');
INSERT INTO buurt (code, naam) VALUES (3071003, 'Albatrosstraat');
INSERT INTO buurt (code, naam) VALUES (3071004, 'Zwaluwenstraat');
INSERT INTO buurt (code, naam) VALUES (3071100, 'Rustenburg-Noord');
INSERT INTO buurt (code, naam) VALUES (3071101, 'Rustenburg-Zuid');
INSERT INTO buurt (code, naam) VALUES (3071201, 'Bloeidaal');
INSERT INTO buurt (code, naam) VALUES (3071202, 'Stoutenburgerlaan');
INSERT INTO buurt (code, naam) VALUES (3071300, 'Romeostraat');
INSERT INTO buurt (code, naam) VALUES (3071301, 'Ariaweg');
INSERT INTO buurt (code, naam) VALUES (3071302, 'Verdiweg');
INSERT INTO buurt (code, naam) VALUES (3071400, 'Willem III');
INSERT INTO buurt (code, naam) VALUES (3071401, 'Randenbroekerweg');
INSERT INTO buurt (code, naam) VALUES (3071402, 'Bachweg-Zuid');
INSERT INTO buurt (code, naam) VALUES (3071403, 'Weberstraat');
INSERT INTO buurt (code, naam) VALUES (3071500, 'Bekenstein en De Luiaard');
INSERT INTO buurt (code, naam) VALUES (3071501, 'Rubensstraat');
INSERT INTO buurt (code, naam) VALUES (3071502, 'Albert Cuypstraat');
INSERT INTO buurt (code, naam) VALUES (3071503, 'Dorrestein');
INSERT INTO buurt (code, naam) VALUES (3071600, 'De Driehoek');
INSERT INTO buurt (code, naam) VALUES (3071601, 'Voltastraat');
INSERT INTO buurt (code, naam) VALUES (3071602, 'Bosweg');
INSERT INTO buurt (code, naam) VALUES (3071603, 'Nimmerdor');
INSERT INTO buurt (code, naam) VALUES (3071700, 'Westerstraat');
INSERT INTO buurt (code, naam) VALUES (3071701, 'Juliana van Stolberg');
INSERT INTO buurt (code, naam) VALUES (3071702, 'Huygenslaan');
INSERT INTO buurt (code, naam) VALUES (3071703, 'De Lichtenberg');
INSERT INTO buurt (code, naam) VALUES (3071704, 'Verhoevenstraat');
INSERT INTO buurt (code, naam) VALUES (3071705, 'Indische Buurt');
INSERT INTO buurt (code, naam) VALUES (3071706, 'Curacaolaan');
INSERT INTO buurt (code, naam) VALUES (3071707, 'Klein Zwitserland');
INSERT INTO buurt (code, naam) VALUES (3071800, 'Regentesselaan');
INSERT INTO buurt (code, naam) VALUES (3071801, 'Station Berkenweg');
INSERT INTO buurt (code, naam) VALUES (3071802, 'Thorbeckeplein');
INSERT INTO buurt (code, naam) VALUES (3071803, 'Mr. Th. Heemskerklaan');
INSERT INTO buurt (code, naam) VALUES (3071804, 'Oranjelaan');
INSERT INTO buurt (code, naam) VALUES (3071900, 'De Ham');
INSERT INTO buurt (code, naam) VALUES (3071901, 'Langenoord');
INSERT INTO buurt (code, naam) VALUES (3071902, 'Bieshaar-Noord');
INSERT INTO buurt (code, naam) VALUES (3071903, 'Bieshaar-Zuid');
INSERT INTO buurt (code, naam) VALUES (3071904, 'De Bik');
INSERT INTO buurt (code, naam) VALUES (3071905, 'De Brinken');
INSERT INTO buurt (code, naam) VALUES (3071906, 'De Biezen');
INSERT INTO buurt (code, naam) VALUES (3072000, 'Vlinderbuurt');
INSERT INTO buurt (code, naam) VALUES (3072001, 'Erasmusstraat');
INSERT INTO buurt (code, naam) VALUES (3072002, 'Muziekbuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (3072003, 'Muziekbuurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (3072004, 'Architectenbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (3072005, 'Architectenbuurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (3072006, 'Sportpark Zielhorst');
INSERT INTO buurt (code, naam) VALUES (3072100, 'Stille Steeg');
INSERT INTO buurt (code, naam) VALUES (3072101, 'Amaniet');
INSERT INTO buurt (code, naam) VALUES (3072102, 'Woudzoom');
INSERT INTO buurt (code, naam) VALUES (3072103, 'Gesloten Stad');
INSERT INTO buurt (code, naam) VALUES (3072104, 'De Verwondering');
INSERT INTO buurt (code, naam) VALUES (3072105, 'Emiclaer');
INSERT INTO buurt (code, naam) VALUES (3072106, 'Groote Kreek');
INSERT INTO buurt (code, naam) VALUES (3072107, 'Het Hallehuis');
INSERT INTO buurt (code, naam) VALUES (3072108, 'De Horizon');
INSERT INTO buurt (code, naam) VALUES (3072201, 'Calveen');
INSERT INTO buurt (code, naam) VALUES (3072300, 'Park Schothorst-Zuid');
INSERT INTO buurt (code, naam) VALUES (3072301, 'Park Schothorst-Noord');
INSERT INTO buurt (code, naam) VALUES (3072400, 'Stadskwartier');
INSERT INTO buurt (code, naam) VALUES (3072402, 'Hoge Hoven');
INSERT INTO buurt (code, naam) VALUES (3072403, 'Centrum-Wat');
INSERT INTO buurt (code, naam) VALUES (3072404, 'Stadstuin');
INSERT INTO buurt (code, naam) VALUES (3072405, 'Waterkwartier');
INSERT INTO buurt (code, naam) VALUES (3072407, 'Lage Hoven');
INSERT INTO buurt (code, naam) VALUES (3072500, 'De Hoef-West');
INSERT INTO buurt (code, naam) VALUES (3072501, 'De Hoef-Oost');
INSERT INTO buurt (code, naam) VALUES (3072502, 'De Wieken');
INSERT INTO buurt (code, naam) VALUES (3072503, 'Vinkenhoef');
INSERT INTO buurt (code, naam) VALUES (3072504, 'Nijkerkerstraat');
INSERT INTO buurt (code, naam) VALUES (3072505, 'Bedrijventerrein Vathorst-Zuid');
INSERT INTO buurt (code, naam) VALUES (3072506, 'Podium');
INSERT INTO buurt (code, naam) VALUES (3072507, 'Bedrijventerrein Vathorst-Noord');
INSERT INTO buurt (code, naam) VALUES (3072508, 'De Brand');
INSERT INTO buurt (code, naam) VALUES (3072600, 'Dorpskern Hooglanderveen');
INSERT INTO buurt (code, naam) VALUES (3072601, 'Lient');
INSERT INTO buurt (code, naam) VALUES (3072602, 'Hoekveen');
INSERT INTO buurt (code, naam) VALUES (3072603, 'Heideweg');
INSERT INTO buurt (code, naam) VALUES (3072700, 'Coelhorst');
INSERT INTO buurt (code, naam) VALUES (3072701, 'Zeldert');
INSERT INTO buurt (code, naam) VALUES (3072709, 'Maatweg');
INSERT INTO buurt (code, naam) VALUES (3072800, 'Leersumseberg');
INSERT INTO buurt (code, naam) VALUES (3072801, 'Emminkhuizerberg');
INSERT INTO buurt (code, naam) VALUES (3072802, 'Sprengenberg');
INSERT INTO buurt (code, naam) VALUES (3072803, 'Duisterweg');
INSERT INTO buurt (code, naam) VALUES (3072804, 'Cycladen');
INSERT INTO buurt (code, naam) VALUES (3072805, 'Reinier');
INSERT INTO buurt (code, naam) VALUES (3072806, 'Smink');
INSERT INTO buurt (code, naam) VALUES (3072900, 'Roevoeterstraat');
INSERT INTO buurt (code, naam) VALUES (3072901, 'Winkelcentrum');
INSERT INTO buurt (code, naam) VALUES (3072902, 'Damespolder');
INSERT INTO buurt (code, naam) VALUES (3073000, 'De Bron Noord');
INSERT INTO buurt (code, naam) VALUES (3073001, 'De Bron Zuid');
INSERT INTO buurt (code, naam) VALUES (3073100, 'De Laak Oost');
INSERT INTO buurt (code, naam) VALUES (3073101, 'Hoornplantsoen');
INSERT INTO buurt (code, naam) VALUES (3073102, 'Muidenkade');
INSERT INTO buurt (code, naam) VALUES (3073103, 'Hogesteeg');
INSERT INTO buurt (code, naam) VALUES (3073104, 'Vathorst-West');
INSERT INTO buurt (code, naam) VALUES (3073108, 'Vathorst-Noord');
INSERT INTO buurt (code, naam) VALUES (3080000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (3080001, 'Schoonoordpark');
INSERT INTO buurt (code, naam) VALUES (3080002, 'Transvaal');
INSERT INTO buurt (code, naam) VALUES (3080003, 'Zandvoort');
INSERT INTO buurt (code, naam) VALUES (3080004, 'Oude-Oosterhei');
INSERT INTO buurt (code, naam) VALUES (3080005, 'Nieuwe-Oosterhei');
INSERT INTO buurt (code, naam) VALUES (3080006, 'Pekingpark');
INSERT INTO buurt (code, naam) VALUES (3080007, 'Amaliapark');
INSERT INTO buurt (code, naam) VALUES (3080100, 'Componistenwijk');
INSERT INTO buurt (code, naam) VALUES (3080101, 'Professorenwijk');
INSERT INTO buurt (code, naam) VALUES (3080102, 'Staatsliedenwijk');
INSERT INTO buurt (code, naam) VALUES (3080103, 'Schilderswijk');
INSERT INTO buurt (code, naam) VALUES (3080104, 'Eemdal-Noord');
INSERT INTO buurt (code, naam) VALUES (3080105, 'Eemdal-Zuid');
INSERT INTO buurt (code, naam) VALUES (3080109, 'Eemland waaronder Eembrugge');
INSERT INTO buurt (code, naam) VALUES (3080200, 'Wilhelminapark');
INSERT INTO buurt (code, naam) VALUES (3080201, 'Pr. Hendrikpark');
INSERT INTO buurt (code, naam) VALUES (3080300, 'Lage Vuursche');
INSERT INTO buurt (code, naam) VALUES (3080301, 'Soestdijk');
INSERT INTO buurt (code, naam) VALUES (3080309, 'Verspreide huizen Lage Vuursche');
INSERT INTO buurt (code, naam) VALUES (3100001, 'Steinenburg');
INSERT INTO buurt (code, naam) VALUES (3100002, 'Weltevreden');
INSERT INTO buurt (code, naam) VALUES (3100008, 'De Bilt');
INSERT INTO buurt (code, naam) VALUES (3100009, 'Verspreide huizen Oostbroek');
INSERT INTO buurt (code, naam) VALUES (3100100, 'Bilthoven-Zuid');
INSERT INTO buurt (code, naam) VALUES (3100200, 'Bilthoven-Noord');
INSERT INTO buurt (code, naam) VALUES (3100201, 'De Leyen');
INSERT INTO buurt (code, naam) VALUES (3100209, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (3100300, 'Hollandsche Rading');
INSERT INTO buurt (code, naam) VALUES (3100309, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (3100400, 'Maartensdijk');
INSERT INTO buurt (code, naam) VALUES (3100401, 'Achterwetering');
INSERT INTO buurt (code, naam) VALUES (3100402, 'Nieuwe-Wetering');
INSERT INTO buurt (code, naam) VALUES (3100500, 'Groenekan');
INSERT INTO buurt (code, naam) VALUES (3100501, 'Blauwkapel');
INSERT INTO buurt (code, naam) VALUES (3100600, 'Achttienhoven-Westbroek');
INSERT INTO buurt (code, naam) VALUES (3120000, 'Bunnik');
INSERT INTO buurt (code, naam) VALUES (3120001, 'Vechten');
INSERT INTO buurt (code, naam) VALUES (3120008, 'Verspreide huizen in het noorden');
INSERT INTO buurt (code, naam) VALUES (3120009, 'Verspreide huizen in het zuiden');
INSERT INTO buurt (code, naam) VALUES (3120100, 'Odijk');
INSERT INTO buurt (code, naam) VALUES (3120109, 'Verspreide huizen van Odijk');
INSERT INTO buurt (code, naam) VALUES (3120200, 'Werkhoven');
INSERT INTO buurt (code, naam) VALUES (3120209, 'Verspreide huizen van Werkhoven');
INSERT INTO buurt (code, naam) VALUES (3130001, 'Bunschoten');
INSERT INTO buurt (code, naam) VALUES (3130002, 'Spakenburg');
INSERT INTO buurt (code, naam) VALUES (3130003, 'Eemdijk');
INSERT INTO buurt (code, naam) VALUES (3130004, 'Broerswetering');
INSERT INTO buurt (code, naam) VALUES (3130005, 'Bikkersvaart');
INSERT INTO buurt (code, naam) VALUES (3130006, 'Blokhuiswetering');
INSERT INTO buurt (code, naam) VALUES (3130007, 'De Haar');
INSERT INTO buurt (code, naam) VALUES (3130008, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (3130009, 'Koenraadswetering');
INSERT INTO buurt (code, naam) VALUES (3130011, 'Rengerswetering');
INSERT INTO buurt (code, naam) VALUES (3139997, '');
INSERT INTO buurt (code, naam) VALUES (3170000, 'Eemnes');
INSERT INTO buurt (code, naam) VALUES (3170001, 'Meentweg');
INSERT INTO buurt (code, naam) VALUES (3170002, 'Laarderweg');
INSERT INTO buurt (code, naam) VALUES (3170003, 'Wakkerendijk');
INSERT INTO buurt (code, naam) VALUES (3170004, 'Noordbuurt');
INSERT INTO buurt (code, naam) VALUES (3170005, 'Zuidbuurt');
INSERT INTO buurt (code, naam) VALUES (3170008, 'Verspreide huizen ten zuidwesten van de Rijksstraatweg');
INSERT INTO buurt (code, naam) VALUES (3170009, 'Overige verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (3179997, '');
INSERT INTO buurt (code, naam) VALUES (3211010, 'Oude Dorp');
INSERT INTO buurt (code, naam) VALUES (3211011, 'Oorden');
INSERT INTO buurt (code, naam) VALUES (3211012, 'Hoven');
INSERT INTO buurt (code, naam) VALUES (3211013, 'Gaarden');
INSERT INTO buurt (code, naam) VALUES (3211014, 'Hoeven');
INSERT INTO buurt (code, naam) VALUES (3211015, 'Erven');
INSERT INTO buurt (code, naam) VALUES (3211016, 'Poorten');
INSERT INTO buurt (code, naam) VALUES (3211017, 'Slagen');
INSERT INTO buurt (code, naam) VALUES (3211018, 'Borchen');
INSERT INTO buurt (code, naam) VALUES (3211019, 'Campen');
INSERT INTO buurt (code, naam) VALUES (3211050, 'Rondweg Noord-West');
INSERT INTO buurt (code, naam) VALUES (3211120, 'Centrum West');
INSERT INTO buurt (code, naam) VALUES (3211121, 'Centrum Oost');
INSERT INTO buurt (code, naam) VALUES (3211122, 'Molens');
INSERT INTO buurt (code, naam) VALUES (3211123, 'Hagen');
INSERT INTO buurt (code, naam) VALUES (3211124, 'weiden');
INSERT INTO buurt (code, naam) VALUES (3211125, 'Gilden');
INSERT INTO buurt (code, naam) VALUES (3211126, 'velden');
INSERT INTO buurt (code, naam) VALUES (3211127, 'Sloten');
INSERT INTO buurt (code, naam) VALUES (3211128, 'Bermen');
INSERT INTO buurt (code, naam) VALUES (3211129, 'Akkers');
INSERT INTO buurt (code, naam) VALUES (3211151, 'Rondweg Noord-Oost');
INSERT INTO buurt (code, naam) VALUES (3211230, 'Bouwen');
INSERT INTO buurt (code, naam) VALUES (3211231, 'Houten');
INSERT INTO buurt (code, naam) VALUES (3211232, 'Waters');
INSERT INTO buurt (code, naam) VALUES (3211233, 'Polders');
INSERT INTO buurt (code, naam) VALUES (3211234, 'Stenen');
INSERT INTO buurt (code, naam) VALUES (3211235, 'muren');
INSERT INTO buurt (code, naam) VALUES (3211236, 'Castel;lum West');
INSERT INTO buurt (code, naam) VALUES (3211237, 'Castellum Oost');
INSERT INTO buurt (code, naam) VALUES (3211238, 'Schaften');
INSERT INTO buurt (code, naam) VALUES (3211252, 'Rondweg Zuid-West');
INSERT INTO buurt (code, naam) VALUES (3211340, 'Landen');
INSERT INTO buurt (code, naam) VALUES (3211341, 'Tuinen');
INSERT INTO buurt (code, naam) VALUES (3211342, 'Sporen');
INSERT INTO buurt (code, naam) VALUES (3211343, 'Meren');
INSERT INTO buurt (code, naam) VALUES (3211344, 'Mossen');
INSERT INTO buurt (code, naam) VALUES (3211345, 'Grassen');
INSERT INTO buurt (code, naam) VALUES (3211353, 'Rondweg Zuid-Oost');
INSERT INTO buurt (code, naam) VALUES (3212054, 'De Staart');
INSERT INTO buurt (code, naam) VALUES (3212055, 'Kaden');
INSERT INTO buurt (code, naam) VALUES (3212056, 'vesten');
INSERT INTO buurt (code, naam) VALUES (3212057, 'Schepen');
INSERT INTO buurt (code, naam) VALUES (3212058, 'Boten');
INSERT INTO buurt (code, naam) VALUES (3212059, 'Honen');
INSERT INTO buurt (code, naam) VALUES (3212060, 'Hof van Wulven');
INSERT INTO buurt (code, naam) VALUES (3212061, 'Bruggen');
INSERT INTO buurt (code, naam) VALUES (3212062, 'Bogen');
INSERT INTO buurt (code, naam) VALUES (3212063, 'De Poel');
INSERT INTO buurt (code, naam) VALUES (3212064, 'Buitengebied Houten West');
INSERT INTO buurt (code, naam) VALUES (3212065, 'Buitengebied Houten Oost');
INSERT INTO buurt (code, naam) VALUES (3213070, 'Dorp ''t Goy');
INSERT INTO buurt (code, naam) VALUES (3213071, '''t Goysedorp');
INSERT INTO buurt (code, naam) VALUES (3213172, 'Buitengebied ''t Goy');
INSERT INTO buurt (code, naam) VALUES (3214080, '''t Waal');
INSERT INTO buurt (code, naam) VALUES (3214081, 'Tull');
INSERT INTO buurt (code, naam) VALUES (3214182, 'Buitengebied Tull en ''t Waal');
INSERT INTO buurt (code, naam) VALUES (3215090, 'Dorp Schalkwijk West');
INSERT INTO buurt (code, naam) VALUES (3215091, 'Dorp Schalkwijk Oost');
INSERT INTO buurt (code, naam) VALUES (3215192, 'Buitengebied Schalkwijk West');
INSERT INTO buurt (code, naam) VALUES (3215193, 'Buitengebied Schalkwijk Oost');
INSERT INTO buurt (code, naam) VALUES (3270000, 'Hamershof');
INSERT INTO buurt (code, naam) VALUES (3270001, 'Akkerhoeve');
INSERT INTO buurt (code, naam) VALUES (3270002, 'Noorwijck');
INSERT INTO buurt (code, naam) VALUES (3270003, 'Langenbeek');
INSERT INTO buurt (code, naam) VALUES (3270004, 'Zwanenburg');
INSERT INTO buurt (code, naam) VALUES (3270005, 'Munnikhove');
INSERT INTO buurt (code, naam) VALUES (3270006, 'Bosveld');
INSERT INTO buurt (code, naam) VALUES (3270007, 'Claverenblad');
INSERT INTO buurt (code, naam) VALUES (3270008, 'Wildenburg');
INSERT INTO buurt (code, naam) VALUES (3270009, 'Buitengebied Leusden-Centrum Oost');
INSERT INTO buurt (code, naam) VALUES (3270100, 'Hamersveld-Oud');
INSERT INTO buurt (code, naam) VALUES (3270101, 'Hamersveld-Nieuw');
INSERT INTO buurt (code, naam) VALUES (3270102, 'Rozenboom');
INSERT INTO buurt (code, naam) VALUES (3270103, 'Rozendaal');
INSERT INTO buurt (code, naam) VALUES (3270104, 'Alandsbeek-West');
INSERT INTO buurt (code, naam) VALUES (3270105, 'Alandsbeek-Oost');
INSERT INTO buurt (code, naam) VALUES (3270106, 'De Wetering');
INSERT INTO buurt (code, naam) VALUES (3270107, 'Rossenberg');
INSERT INTO buurt (code, naam) VALUES (3270108, 'Groenhouten');
INSERT INTO buurt (code, naam) VALUES (3270109, 'Buitengebied Leusden-Centrum West');
INSERT INTO buurt (code, naam) VALUES (3270200, 'Kern Leusden-Zuid');
INSERT INTO buurt (code, naam) VALUES (3270201, 'Tabaksteeg');
INSERT INTO buurt (code, naam) VALUES (3270209, 'Buitengebied Leusden-Zuid');
INSERT INTO buurt (code, naam) VALUES (3270300, 'Kern Achterveld');
INSERT INTO buurt (code, naam) VALUES (3270309, 'Buitengebied Achterveld');
INSERT INTO buurt (code, naam) VALUES (3270400, 'Stoutenburg');
INSERT INTO buurt (code, naam) VALUES (3270500, '''t Ruige Veld');
INSERT INTO buurt (code, naam) VALUES (3270501, '''t Vliet');
INSERT INTO buurt (code, naam) VALUES (3310000, 'Lopik-Dorp');
INSERT INTO buurt (code, naam) VALUES (3310001, 'Graaf');
INSERT INTO buurt (code, naam) VALUES (3310002, 'Uitweg');
INSERT INTO buurt (code, naam) VALUES (3310003, 'Lopikerkapel');
INSERT INTO buurt (code, naam) VALUES (3310004, 'Jaarsveld');
INSERT INTO buurt (code, naam) VALUES (3310005, 'Wielsekade');
INSERT INTO buurt (code, naam) VALUES (3310006, 'Cabauw');
INSERT INTO buurt (code, naam) VALUES (3310007, 'Zevender');
INSERT INTO buurt (code, naam) VALUES (3310008, 'Lekdijk tussen Jaarsveld en Schoonhoven');
INSERT INTO buurt (code, naam) VALUES (3310009, 'Langs de Lekdijk Lopikerwaard');
INSERT INTO buurt (code, naam) VALUES (3310010, 'Benschop-Dorp');
INSERT INTO buurt (code, naam) VALUES (3310019, 'Benschop Boveneind-Benedeneind');
INSERT INTO buurt (code, naam) VALUES (3310020, 'Polsbroek-Dorp');
INSERT INTO buurt (code, naam) VALUES (3310029, 'Polsbroek-Noordzijdseweg-Zuidzijdseweg');
INSERT INTO buurt (code, naam) VALUES (3350000, 'Montfoort');
INSERT INTO buurt (code, naam) VALUES (3350001, 'Tabakshof en Heeswijk (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (3350100, 'Linschoten');
INSERT INTO buurt (code, naam) VALUES (3350101, 'Polanen');
INSERT INTO buurt (code, naam) VALUES (3350102, 'Cattenbroek');
INSERT INTO buurt (code, naam) VALUES (3350103, 'Heeswijk');
INSERT INTO buurt (code, naam) VALUES (3350108, 'Verspreide huizen Linschoten');
INSERT INTO buurt (code, naam) VALUES (3350109, 'Verspreide huizen Mastwijk');
INSERT INTO buurt (code, naam) VALUES (3350200, 'Willeskop');
INSERT INTO buurt (code, naam) VALUES (3350201, 'Blokland');
INSERT INTO buurt (code, naam) VALUES (3350202, 'Beneden Kerkweg');
INSERT INTO buurt (code, naam) VALUES (3350209, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (3390000, 'Renswoude');
INSERT INTO buurt (code, naam) VALUES (3390009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (3400001, 'Rhenen Binnenstad');
INSERT INTO buurt (code, naam) VALUES (3400101, 'Cunera');
INSERT INTO buurt (code, naam) VALUES (3400102, 'Vogelenzang');
INSERT INTO buurt (code, naam) VALUES (3400103, 'Grebbekwartier Zuid');
INSERT INTO buurt (code, naam) VALUES (3400104, 'Grebbekwartier Noord');
INSERT INTO buurt (code, naam) VALUES (3400105, 'Bruine Eng');
INSERT INTO buurt (code, naam) VALUES (3400201, 'Molenberg');
INSERT INTO buurt (code, naam) VALUES (3400202, 'Donderberg');
INSERT INTO buurt (code, naam) VALUES (3400203, 'Koerheuvel');
INSERT INTO buurt (code, naam) VALUES (3400301, 'Rhenen Hoog');
INSERT INTO buurt (code, naam) VALUES (3400302, 'Domineesberg');
INSERT INTO buurt (code, naam) VALUES (3400303, 'Helling Bergweg');
INSERT INTO buurt (code, naam) VALUES (3400401, 'Grebbeberg');
INSERT INTO buurt (code, naam) VALUES (3400501, 'Randzone');
INSERT INTO buurt (code, naam) VALUES (3400502, 'Veeneind');
INSERT INTO buurt (code, naam) VALUES (3400503, 'Rhenendael');
INSERT INTO buurt (code, naam) VALUES (3400504, 'Prattenburg');
INSERT INTO buurt (code, naam) VALUES (3400601, 'Binnenveld');
INSERT INTO buurt (code, naam) VALUES (3400701, 'Achterberg');
INSERT INTO buurt (code, naam) VALUES (3400702, 'De Horst');
INSERT INTO buurt (code, naam) VALUES (3400703, 'Achterberg West');
INSERT INTO buurt (code, naam) VALUES (3400801, 'Uiterwaarden Rhenen');
INSERT INTO buurt (code, naam) VALUES (3400901, 'Remmerden');
INSERT INTO buurt (code, naam) VALUES (3401001, 'Heuvelrug Rhenen');
INSERT INTO buurt (code, naam) VALUES (3401101, 'Heuvelrug Elst');
INSERT INTO buurt (code, naam) VALUES (3401201, 'Uiterwaarden Elst');
INSERT INTO buurt (code, naam) VALUES (3401301, 'De Vordel');
INSERT INTO buurt (code, naam) VALUES (3401302, 'Elst Centrum');
INSERT INTO buurt (code, naam) VALUES (3401303, 'Het Bosje');
INSERT INTO buurt (code, naam) VALUES (3401304, 'Elst West');
INSERT INTO buurt (code, naam) VALUES (3420101, 'Industrieterrein Soest');
INSERT INTO buurt (code, naam) VALUES (3420102, '''t Hart');
INSERT INTO buurt (code, naam) VALUES (3420103, 'Soestdijk');
INSERT INTO buurt (code, naam) VALUES (3420201, 'Klaarwater');
INSERT INTO buurt (code, naam) VALUES (3420301, 'Pijnenburg');
INSERT INTO buurt (code, naam) VALUES (3420302, 'Het Soesterveen');
INSERT INTO buurt (code, naam) VALUES (3420303, 'De Grachten');
INSERT INTO buurt (code, naam) VALUES (3420304, 'Boerenstreek');
INSERT INTO buurt (code, naam) VALUES (3420401, 'De Eng Noord West');
INSERT INTO buurt (code, naam) VALUES (3420402, 'De Eng');
INSERT INTO buurt (code, naam) VALUES (3420403, 'Soest Midden');
INSERT INTO buurt (code, naam) VALUES (3420404, 'Eemgebied');
INSERT INTO buurt (code, naam) VALUES (3420405, 'De Eng Zuid');
INSERT INTO buurt (code, naam) VALUES (3420501, 'Smitsveen');
INSERT INTO buurt (code, naam) VALUES (3420601, 'De Zoom');
INSERT INTO buurt (code, naam) VALUES (3420602, 'Wieksloot');
INSERT INTO buurt (code, naam) VALUES (3420604, 'Hees');
INSERT INTO buurt (code, naam) VALUES (3420605, 'Klein Engendaal');
INSERT INTO buurt (code, naam) VALUES (3420606, 'Klein Engendaal Noord');
INSERT INTO buurt (code, naam) VALUES (3420701, 'Soest Zuid');
INSERT INTO buurt (code, naam) VALUES (3420702, 'De Birkt');
INSERT INTO buurt (code, naam) VALUES (3420703, 'Soestduinen');
INSERT INTO buurt (code, naam) VALUES (3420704, 'Duinen Gebied');
INSERT INTO buurt (code, naam) VALUES (3420705, 'Paltz');
INSERT INTO buurt (code, naam) VALUES (3420706, 'Vlasakkers');
INSERT INTO buurt (code, naam) VALUES (3420801, 'Soesterberg Noord');
INSERT INTO buurt (code, naam) VALUES (3420802, 'Soesterberg Oost');
INSERT INTO buurt (code, naam) VALUES (3420803, 'Leusderheide');
INSERT INTO buurt (code, naam) VALUES (3420804, 'Soesterberg Kom');
INSERT INTO buurt (code, naam) VALUES (3440111, 'Welgelegen, Den Hommel');
INSERT INTO buurt (code, naam) VALUES (3440112, 'Oog in Al');
INSERT INTO buurt (code, naam) VALUES (3440113, 'Halve Maan-Zuid');
INSERT INTO buurt (code, naam) VALUES (3440114, 'Halve Maan-Noord');
INSERT INTO buurt (code, naam) VALUES (3440121, 'Lombok-Oost');
INSERT INTO buurt (code, naam) VALUES (3440122, 'Leidseweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440123, 'Lombok-West');
INSERT INTO buurt (code, naam) VALUES (3440124, 'Laan van Nieuw Guinea-Spinozaplantsoen');
INSERT INTO buurt (code, naam) VALUES (3440131, 'Nieuw Engeland, Th. a. Kempisplantsoen en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440132, 'Schepenbuurt bedrijvengebied Cartesiusweg');
INSERT INTO buurt (code, naam) VALUES (3440133, 'Bedrijventerrein Lageweide');
INSERT INTO buurt (code, naam) VALUES (3440211, 'Pijlsweerd-Zuid');
INSERT INTO buurt (code, naam) VALUES (3440212, 'Pijlsweerd-Noord');
INSERT INTO buurt (code, naam) VALUES (3440221, 'Nijenoord, Hoogstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440222, 'Ondiep');
INSERT INTO buurt (code, naam) VALUES (3440223, '2e Daalsebuurt en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440224, 'Elegantierstraat, Mariëndaalstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440231, 'Julianapark en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440232, 'Elinkwijk en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440233, 'Prins Bernhardplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440241, 'Geuzenwijk');
INSERT INTO buurt (code, naam) VALUES (3440242, 'Schaakbuurt en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440243, 'Queeckhovenplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440244, 'Zuilen-Noord');
INSERT INTO buurt (code, naam) VALUES (3440311, 'Taag- en Rubicondreef en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440312, 'Wolga- en Donaudreef en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440321, 'Zamenhofdreef en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440322, 'Neckardreef en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440331, 'Vechtzoom-zuid');
INSERT INTO buurt (code, naam) VALUES (3440332, 'Vechtzoom-noord, Klopvaart');
INSERT INTO buurt (code, naam) VALUES (3440333, 'Bedrijventerrein en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440341, 'Zambesidreef en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440342, 'Tigrisdreef en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440343, 'Poldergebied Overvecht');
INSERT INTO buurt (code, naam) VALUES (3440411, 'Vogelenbuurt');
INSERT INTO buurt (code, naam) VALUES (3440412, 'Lauwerecht');
INSERT INTO buurt (code, naam) VALUES (3440413, 'Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (3440414, 'Tuinwijk-West');
INSERT INTO buurt (code, naam) VALUES (3440415, 'Tuinwijk-Oost');
INSERT INTO buurt (code, naam) VALUES (3440421, 'Tuindorp en Van Lieflandlaan-West');
INSERT INTO buurt (code, naam) VALUES (3440422, 'Tuindorp-Oost');
INSERT INTO buurt (code, naam) VALUES (3440423, 'Voordorp en Voorveldsepolder');
INSERT INTO buurt (code, naam) VALUES (3440431, 'Huizingalaan, K. Doormanlaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440432, 'Zeeheldenbuurt, Hengeveldstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440433, 'Wittevrouwen');
INSERT INTO buurt (code, naam) VALUES (3440511, 'Buiten Wittevrouwen');
INSERT INTO buurt (code, naam) VALUES (3440512, 'Oudwijk');
INSERT INTO buurt (code, naam) VALUES (3440521, 'Abstede');
INSERT INTO buurt (code, naam) VALUES (3440522, 'Tolsteegsingel');
INSERT INTO buurt (code, naam) VALUES (3440523, 'Rubenslaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440524, 'Watervogelbuurt');
INSERT INTO buurt (code, naam) VALUES (3440525, 'L. Napoleonplantsoen en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440526, 'Maarschalkerweerd en Mereveld');
INSERT INTO buurt (code, naam) VALUES (3440531, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (3440532, 'Wilhelminapark en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440533, 'De Uithof');
INSERT INTO buurt (code, naam) VALUES (3440534, 'Rijnsweerd');
INSERT INTO buurt (code, naam) VALUES (3440535, 'Galgenwaard en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440611, 'Domplein, Neude, Janskerkhof');
INSERT INTO buurt (code, naam) VALUES (3440612, 'Lange Elisabethstraat, Mariaplaats en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440613, 'Hoog-Catharijne NS en Jaarbeurs');
INSERT INTO buurt (code, naam) VALUES (3440621, 'Wijk C');
INSERT INTO buurt (code, naam) VALUES (3440622, 'Breedstraat en Plompetorengracht en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440623, 'Nobelstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440624, 'Springweg en omgeving Geertebuurt');
INSERT INTO buurt (code, naam) VALUES (3440625, 'Lange Nieuwstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440626, 'Nieuwegracht-Oost');
INSERT INTO buurt (code, naam) VALUES (3440627, 'Bleekstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (3440628, 'Hooch Boulandt');
INSERT INTO buurt (code, naam) VALUES (3440711, 'Lunetten-Noord');
INSERT INTO buurt (code, naam) VALUES (3440712, 'Lunetten-Zuid');
INSERT INTO buurt (code, naam) VALUES (3440721, 'Tolsteeg en Rotsoord');
INSERT INTO buurt (code, naam) VALUES (3440722, 'Oud Hoograven-Noord');
INSERT INTO buurt (code, naam) VALUES (3440723, 'Oud Hoograven-Zuid');
INSERT INTO buurt (code, naam) VALUES (3440731, 'Bokkenbuurt');
INSERT INTO buurt (code, naam) VALUES (3440732, 'Nieuw Hoograven-Noord');
INSERT INTO buurt (code, naam) VALUES (3440733, 'Nieuw Hoograven-Zuid');
INSERT INTO buurt (code, naam) VALUES (3440811, 'Dichterswijk');
INSERT INTO buurt (code, naam) VALUES (3440812, 'Rivierenwijk');
INSERT INTO buurt (code, naam) VALUES (3440821, 'Bedrijvengebied Kanaleneiland');
INSERT INTO buurt (code, naam) VALUES (3440822, 'Transwijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (3440823, 'Transwijk-Noord');
INSERT INTO buurt (code, naam) VALUES (3440831, 'Kanaleneiland-Zuid');
INSERT INTO buurt (code, naam) VALUES (3440832, 'Kanaleneiland-Noord');
INSERT INTO buurt (code, naam) VALUES (3440911, 'Bedrijventerrein De Wetering');
INSERT INTO buurt (code, naam) VALUES (3440912, 'Terwijde-West');
INSERT INTO buurt (code, naam) VALUES (3440913, 'Terwijde-Oost');
INSERT INTO buurt (code, naam) VALUES (3440921, 'Het Zand-West');
INSERT INTO buurt (code, naam) VALUES (3440922, 'Het Zand-Oost');
INSERT INTO buurt (code, naam) VALUES (3440931, 'Leidsche Rijn-Centrum');
INSERT INTO buurt (code, naam) VALUES (3440932, 'Grauwaart');
INSERT INTO buurt (code, naam) VALUES (3440933, 'Hoge Weide');
INSERT INTO buurt (code, naam) VALUES (3440934, 'Leeuwesteyn');
INSERT INTO buurt (code, naam) VALUES (3440941, 'Parkwijk-Noord');
INSERT INTO buurt (code, naam) VALUES (3440942, 'Parkwijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (3440943, 'Langerak');
INSERT INTO buurt (code, naam) VALUES (3440951, 'Rijnvliet');
INSERT INTO buurt (code, naam) VALUES (3440952, 'Bedrijvengebied Strijkviertel');
INSERT INTO buurt (code, naam) VALUES (3440953, 'Bedrijvengebied Papendorp');
INSERT INTO buurt (code, naam) VALUES (3441011, 'Haarrijn');
INSERT INTO buurt (code, naam) VALUES (3441012, 'Haarzuilens en omgeving');
INSERT INTO buurt (code, naam) VALUES (3441013, 'Vleuten');
INSERT INTO buurt (code, naam) VALUES (3441014, 'Leidsche Rijn Park');
INSERT INTO buurt (code, naam) VALUES (3441021, 'Vleuterweide-West');
INSERT INTO buurt (code, naam) VALUES (3441022, 'Vleuterweide-Noord/Oost/Centrum');
INSERT INTO buurt (code, naam) VALUES (3441023, 'Vleuterweide-Zuid');
INSERT INTO buurt (code, naam) VALUES (3441024, 'Veldhuizen');
INSERT INTO buurt (code, naam) VALUES (3441031, 'De Meern-Noord');
INSERT INTO buurt (code, naam) VALUES (3441032, 'De Meern-Zuid');
INSERT INTO buurt (code, naam) VALUES (3441033, 'Bedrijvengebied Oudenrijn');
INSERT INTO buurt (code, naam) VALUES (3441041, 'Rijnenburg');
INSERT INTO buurt (code, naam) VALUES (3450000, 'Koopcentrum');
INSERT INTO buurt (code, naam) VALUES (3450001, 'Vijgendam en omgeving');
INSERT INTO buurt (code, naam) VALUES (3450002, 'Schrijverswijk');
INSERT INTO buurt (code, naam) VALUES (3450003, 'Beatrixstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (3450100, 'Dragonder-Noord');
INSERT INTO buurt (code, naam) VALUES (3450101, 'Dragonder-Zuid');
INSERT INTO buurt (code, naam) VALUES (3450102, 'De Compagnie-Oost');
INSERT INTO buurt (code, naam) VALUES (3450103, 'Spitsbergen');
INSERT INTO buurt (code, naam) VALUES (3450104, 'Dragonder-Oost');
INSERT INTO buurt (code, naam) VALUES (3450105, 'Veenendaal-Oost');
INSERT INTO buurt (code, naam) VALUES (3450200, 'Engelenburg');
INSERT INTO buurt (code, naam) VALUES (3450201, 'Het Ambacht');
INSERT INTO buurt (code, naam) VALUES (3450202, 'Boslaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (3450203, 'Petenbos');
INSERT INTO buurt (code, naam) VALUES (3450204, 'Petenbos-Oost');
INSERT INTO buurt (code, naam) VALUES (3450205, 'Nijverkamp');
INSERT INTO buurt (code, naam) VALUES (3450206, 'De Groene Velden');
INSERT INTO buurt (code, naam) VALUES (3450207, 'De Blauwe Hel');
INSERT INTO buurt (code, naam) VALUES (3450208, 'Bezuiden de Middelbuurtseweg');
INSERT INTO buurt (code, naam) VALUES (3450300, '''t Goeie Spoor en omgeving');
INSERT INTO buurt (code, naam) VALUES (3450301, 'Franse Gat');
INSERT INTO buurt (code, naam) VALUES (3450302, 'Salamander');
INSERT INTO buurt (code, naam) VALUES (3450400, 'Molenbrug');
INSERT INTO buurt (code, naam) VALUES (3450401, '''t Hoorntje');
INSERT INTO buurt (code, naam) VALUES (3450402, 'De Pol');
INSERT INTO buurt (code, naam) VALUES (3450403, 'De Gelderse blom');
INSERT INTO buurt (code, naam) VALUES (3450404, 'De Compagnie');
INSERT INTO buurt (code, naam) VALUES (3450405, 'De Batterijen');
INSERT INTO buurt (code, naam) VALUES (3450500, 'Oudeveen en De Schans en omgeving');
INSERT INTO buurt (code, naam) VALUES (3450501, 'Componistenbuurt');
INSERT INTO buurt (code, naam) VALUES (3450502, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (3450503, 'Schepenbuurt');
INSERT INTO buurt (code, naam) VALUES (3450504, 'Dichtersbuurt');
INSERT INTO buurt (code, naam) VALUES (3450505, 'De Faktorij en De Vendel');
INSERT INTO buurt (code, naam) VALUES (3450506, 'Fort Buurtsteeg');
INSERT INTO buurt (code, naam) VALUES (3450507, 'Bezuiden de Dijkstraat');
INSERT INTO buurt (code, naam) VALUES (3510001, 'De Grift');
INSERT INTO buurt (code, naam) VALUES (3510002, 'Nico Bergsteijn');
INSERT INTO buurt (code, naam) VALUES (3510003, 'Nieuwoord');
INSERT INTO buurt (code, naam) VALUES (3510004, 'Laanzicht');
INSERT INTO buurt (code, naam) VALUES (3510005, 'Het Zeeland');
INSERT INTO buurt (code, naam) VALUES (3510006, 'Het Groene Woud');
INSERT INTO buurt (code, naam) VALUES (3510007, 'Woudenberg-Oost');
INSERT INTO buurt (code, naam) VALUES (3510008, 'Bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (3510009, 'Den Treek-Henschoten');
INSERT INTO buurt (code, naam) VALUES (3510010, 'Geersestein');
INSERT INTO buurt (code, naam) VALUES (3510011, 'Voskuilen');
INSERT INTO buurt (code, naam) VALUES (3510012, 'Rumelaar-Lambalgen');
INSERT INTO buurt (code, naam) VALUES (3520000, 'Wijk bij Duurstede');
INSERT INTO buurt (code, naam) VALUES (3520101, 'Gebied ten zuiden van Amsterdam-Rijnkanaal');
INSERT INTO buurt (code, naam) VALUES (3520109, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (3520200, 'Cothen');
INSERT INTO buurt (code, naam) VALUES (3520209, 'Verspreide huizen Cothen');
INSERT INTO buurt (code, naam) VALUES (3520300, 'Nederlangbroek');
INSERT INTO buurt (code, naam) VALUES (3520301, 'Nederlangbroek West- en Oostzijde');
INSERT INTO buurt (code, naam) VALUES (3520302, 'Overlangbroek');
INSERT INTO buurt (code, naam) VALUES (3520309, 'Verspreide huizen Langbroek');
INSERT INTO buurt (code, naam) VALUES (3530001, 'IJsselstein-Binnenstad');
INSERT INTO buurt (code, naam) VALUES (3530002, 'Nieuwpoort');
INSERT INTO buurt (code, naam) VALUES (3530003, 'Groenvliet');
INSERT INTO buurt (code, naam) VALUES (3530004, 'Kasteelkwartier');
INSERT INTO buurt (code, naam) VALUES (3530005, 'Europakwartier');
INSERT INTO buurt (code, naam) VALUES (3530006, 'Oranjekwartier');
INSERT INTO buurt (code, naam) VALUES (3530007, 'IJsselveld-Oost');
INSERT INTO buurt (code, naam) VALUES (3530008, 'IJsselveld-West');
INSERT INTO buurt (code, naam) VALUES (3530009, 'IJsseloevers');
INSERT INTO buurt (code, naam) VALUES (3530010, 'Hazenveld en Overwaard');
INSERT INTO buurt (code, naam) VALUES (3530011, 'Rijpickerwaard');
INSERT INTO buurt (code, naam) VALUES (3530012, 'Panoven');
INSERT INTO buurt (code, naam) VALUES (3530013, 'Paardenveld');
INSERT INTO buurt (code, naam) VALUES (3530014, 'Over Oudland');
INSERT INTO buurt (code, naam) VALUES (3530015, 'Industrieterrein Lage Dijk');
INSERT INTO buurt (code, naam) VALUES (3530016, 'Bedrijventerrein De Corridor');
INSERT INTO buurt (code, naam) VALUES (3530017, 'De Hoven en De Boomgaard');
INSERT INTO buurt (code, naam) VALUES (3530018, 'De Tuinen');
INSERT INTO buurt (code, naam) VALUES (3530019, 'Het Hart');
INSERT INTO buurt (code, naam) VALUES (3530020, 'De Wereldsteden');
INSERT INTO buurt (code, naam) VALUES (3530021, 'De Rivieren');
INSERT INTO buurt (code, naam) VALUES (3530022, 'Het Staatse');
INSERT INTO buurt (code, naam) VALUES (3530023, 'Benschopperpoort en Het Podium');
INSERT INTO buurt (code, naam) VALUES (3530024, 'Achterveld-Zuid');
INSERT INTO buurt (code, naam) VALUES (3530025, 'Achterveld-West');
INSERT INTO buurt (code, naam) VALUES (3530026, 'Achterveld-Noord');
INSERT INTO buurt (code, naam) VALUES (3530027, 'Achterveld-Oost');
INSERT INTO buurt (code, naam) VALUES (3530028, 'Eiterse Waard');
INSERT INTO buurt (code, naam) VALUES (3530029, 'Landelijk gebied Noord');
INSERT INTO buurt (code, naam) VALUES (3530030, 'Landelijk gebied Zuid');
INSERT INTO buurt (code, naam) VALUES (3550101, 'Carré');
INSERT INTO buurt (code, naam) VALUES (3550102, 'Centrumschil-Zuid');
INSERT INTO buurt (code, naam) VALUES (3550103, 'Centrumschil-Noord');
INSERT INTO buurt (code, naam) VALUES (3550104, 'Lyceumkwartier');
INSERT INTO buurt (code, naam) VALUES (3550105, 'Het Slot en omgeving');
INSERT INTO buurt (code, naam) VALUES (3550201, 'Patijnpark');
INSERT INTO buurt (code, naam) VALUES (3550202, 'Dijnselburg');
INSERT INTO buurt (code, naam) VALUES (3550203, 'Staatsliedenkwartier');
INSERT INTO buurt (code, naam) VALUES (3550204, 'Mooi Zeist');
INSERT INTO buurt (code, naam) VALUES (3550205, 'Vollenhove');
INSERT INTO buurt (code, naam) VALUES (3550206, 'Utrechtseweg');
INSERT INTO buurt (code, naam) VALUES (3550301, 'Griffensteijn en Kersbergen');
INSERT INTO buurt (code, naam) VALUES (3550302, 'Nijenheim');
INSERT INTO buurt (code, naam) VALUES (3550303, 'Crosesteijn');
INSERT INTO buurt (code, naam) VALUES (3550304, 'Vogelwijk');
INSERT INTO buurt (code, naam) VALUES (3550305, 'Brugakker');
INSERT INTO buurt (code, naam) VALUES (3550306, 'De Clomp');
INSERT INTO buurt (code, naam) VALUES (3550307, 'Couwenhoven');
INSERT INTO buurt (code, naam) VALUES (3550308, 'Blikkenburg e.o.');
INSERT INTO buurt (code, naam) VALUES (3550309, 'Weidegebied');
INSERT INTO buurt (code, naam) VALUES (3550401, 'Hoge Dennen');
INSERT INTO buurt (code, naam) VALUES (3550402, 'Kerckebosch');
INSERT INTO buurt (code, naam) VALUES (3550403, 'Driebergseweg');
INSERT INTO buurt (code, naam) VALUES (3550404, 'Station NS');
INSERT INTO buurt (code, naam) VALUES (3550405, 'Zeister Bos');
INSERT INTO buurt (code, naam) VALUES (3550406, 'Austerlitz');
INSERT INTO buurt (code, naam) VALUES (3550407, 'Verspreide huizen Austerlitz');
INSERT INTO buurt (code, naam) VALUES (3550501, 'Huis ter Heide-Zuid');
INSERT INTO buurt (code, naam) VALUES (3550502, 'Huis ter Heide-Noord');
INSERT INTO buurt (code, naam) VALUES (3550503, 'Bosch en Duin');
INSERT INTO buurt (code, naam) VALUES (3550504, 'Beukbergen');
INSERT INTO buurt (code, naam) VALUES (3550505, 'Den Dolder-Zuid');
INSERT INTO buurt (code, naam) VALUES (3550506, 'Den Dolder-Noord');
INSERT INTO buurt (code, naam) VALUES (3550507, 'Soestdijkerweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (3550508, 'Sterrenberg');
INSERT INTO buurt (code, naam) VALUES (3560100, 'Jutphaas Wijkersloot');
INSERT INTO buurt (code, naam) VALUES (3560200, 'Zuilenstein');
INSERT INTO buurt (code, naam) VALUES (3560300, 'Batau Zuid');
INSERT INTO buurt (code, naam) VALUES (3560400, 'Batau Noord');
INSERT INTO buurt (code, naam) VALUES (3560500, 'Doorslag');
INSERT INTO buurt (code, naam) VALUES (3560600, 'Huis de Geer');
INSERT INTO buurt (code, naam) VALUES (3560700, 'Blokhoeve');
INSERT INTO buurt (code, naam) VALUES (3560800, 'Galecop');
INSERT INTO buurt (code, naam) VALUES (3561000, 'Fokkesteeg');
INSERT INTO buurt (code, naam) VALUES (3561100, 'Hoogzandveld');
INSERT INTO buurt (code, naam) VALUES (3561200, 'Lekboulevard');
INSERT INTO buurt (code, naam) VALUES (3561300, 'Vreeswijk');
INSERT INTO buurt (code, naam) VALUES (3561400, 'Merwestein');
INSERT INTO buurt (code, naam) VALUES (3561500, 'Park Oudegein');
INSERT INTO buurt (code, naam) VALUES (3561600, 'Zandveld');
INSERT INTO buurt (code, naam) VALUES (3561800, 'Het Klooster');
INSERT INTO buurt (code, naam) VALUES (3562000, 'Laagraven');
INSERT INTO buurt (code, naam) VALUES (3562100, 'Plettenburg');
INSERT INTO buurt (code, naam) VALUES (3562200, 'De Wiers');
INSERT INTO buurt (code, naam) VALUES (3562300, 'Hoge Landen');
INSERT INTO buurt (code, naam) VALUES (3562400, 'Stadscentrum');
INSERT INTO buurt (code, naam) VALUES (3580000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (3580001, 'Stommeer');
INSERT INTO buurt (code, naam) VALUES (3580004, 'Hornmeer');
INSERT INTO buurt (code, naam) VALUES (3580005, 'Uiterweg');
INSERT INTO buurt (code, naam) VALUES (3580100, 'Kudelstaart');
INSERT INTO buurt (code, naam) VALUES (3580200, 'Bovenlanden');
INSERT INTO buurt (code, naam) VALUES (3580201, 'Greenpark');
INSERT INTO buurt (code, naam) VALUES (3580205, 'Oosteinde');
INSERT INTO buurt (code, naam) VALUES (3580206, 'Schinkelpolder');
INSERT INTO buurt (code, naam) VALUES (3610100, 'Kooimeer');
INSERT INTO buurt (code, naam) VALUES (3610101, 'Dillenburg en Stadhouderskwartier');
INSERT INTO buurt (code, naam) VALUES (3610102, 'Staatsliedenkwartier en Landstraten');
INSERT INTO buurt (code, naam) VALUES (3610103, 'Oud-Rochdale');
INSERT INTO buurt (code, naam) VALUES (3610104, 'Emmakwartier');
INSERT INTO buurt (code, naam) VALUES (3610105, 'Nassaukwartier en Hout');
INSERT INTO buurt (code, naam) VALUES (3610106, 'Oranjepark');
INSERT INTO buurt (code, naam) VALUES (3610107, 'Cranenbroek');
INSERT INTO buurt (code, naam) VALUES (3610108, 'Bloemwijk en Zocherkwartier');
INSERT INTO buurt (code, naam) VALUES (3610109, 'Burgemeesterskwartier');
INSERT INTO buurt (code, naam) VALUES (3610200, 'Rekerbuurt en Ooievaarsnest');
INSERT INTO buurt (code, naam) VALUES (3610201, 'Oudorp-Noord en Oudorp-Oost');
INSERT INTO buurt (code, naam) VALUES (3610202, 'Oudorp-Centrum');
INSERT INTO buurt (code, naam) VALUES (3610203, 'Schermereiland en Omval');
INSERT INTO buurt (code, naam) VALUES (3610204, 'Oudorperpolder-Zuid');
INSERT INTO buurt (code, naam) VALUES (3610205, 'Oudorperpolder-Midden');
INSERT INTO buurt (code, naam) VALUES (3610206, 'Oudorperpolder-Noord');
INSERT INTO buurt (code, naam) VALUES (3610208, 'De Nollen');
INSERT INTO buurt (code, naam) VALUES (3610209, 'Beverkoog');
INSERT INTO buurt (code, naam) VALUES (3610300, 'Oud-Overdie');
INSERT INTO buurt (code, naam) VALUES (3610301, 'Oosterhout');
INSERT INTO buurt (code, naam) VALUES (3610302, 'Overdie-Oost');
INSERT INTO buurt (code, naam) VALUES (3610303, 'Overdie-West');
INSERT INTO buurt (code, naam) VALUES (3610308, 'Boekelermeer-Zuid');
INSERT INTO buurt (code, naam) VALUES (3610309, 'Boekelermeer-Noord');
INSERT INTO buurt (code, naam) VALUES (3610400, 'De Hoef III en IV');
INSERT INTO buurt (code, naam) VALUES (3610401, 'De Hoef I en II');
INSERT INTO buurt (code, naam) VALUES (3610402, 'Bergerwegkwartier');
INSERT INTO buurt (code, naam) VALUES (3610403, 'Bergerhof en Blaeustraatkwartier');
INSERT INTO buurt (code, naam) VALUES (3610404, 'Bergermeer');
INSERT INTO buurt (code, naam) VALUES (3610409, 'Landelijk gebied-West');
INSERT INTO buurt (code, naam) VALUES (3610500, 'Huiswaard-1-Zuid');
INSERT INTO buurt (code, naam) VALUES (3610501, 'Muiderwaard');
INSERT INTO buurt (code, naam) VALUES (3610502, 'Huiswaard-2-West');
INSERT INTO buurt (code, naam) VALUES (3610503, 'Huiswaard-2-Oost');
INSERT INTO buurt (code, naam) VALUES (3610504, 'Vroonermeer-Zuid');
INSERT INTO buurt (code, naam) VALUES (3610505, 'Vroonermeer-Noord');
INSERT INTO buurt (code, naam) VALUES (3610600, '''t Rak-Zuid');
INSERT INTO buurt (code, naam) VALUES (3610601, '''t Rak-Noord');
INSERT INTO buurt (code, naam) VALUES (3610602, 'De Horn-Noord');
INSERT INTO buurt (code, naam) VALUES (3610603, 'De Horn-Zuid');
INSERT INTO buurt (code, naam) VALUES (3610604, 'De Mare');
INSERT INTO buurt (code, naam) VALUES (3610700, 'Daalmeer-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (3610701, 'Daalmeer-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (3610702, 'Koedijk en De Weijdt');
INSERT INTO buurt (code, naam) VALUES (3610703, 'Daalmeer-Noordwest');
INSERT INTO buurt (code, naam) VALUES (3610704, 'Daalmeer-Noordoost');
INSERT INTO buurt (code, naam) VALUES (3610709, 'Landelijk gebied Noord');
INSERT INTO buurt (code, naam) VALUES (3610800, 'Binnenstad-West');
INSERT INTO buurt (code, naam) VALUES (3610801, 'Binnenstad-Oost');
INSERT INTO buurt (code, naam) VALUES (3610802, 'Spoorbuurt');
INSERT INTO buurt (code, naam) VALUES (3610803, 'Overstad');
INSERT INTO buurt (code, naam) VALUES (3620001, 'Randwijck');
INSERT INTO buurt (code, naam) VALUES (3620002, 'Patrimonium');
INSERT INTO buurt (code, naam) VALUES (3620003, 'Elsrijk-West');
INSERT INTO buurt (code, naam) VALUES (3620004, 'Elsrijk-Oost');
INSERT INTO buurt (code, naam) VALUES (3620005, 'Stadshart');
INSERT INTO buurt (code, naam) VALUES (3620006, 'Uilenstede en Kronenburg');
INSERT INTO buurt (code, naam) VALUES (3620007, 'Kostverloren');
INSERT INTO buurt (code, naam) VALUES (3620008, 'Bankras');
INSERT INTO buurt (code, naam) VALUES (3620009, 'Buitengebied-Noord');
INSERT INTO buurt (code, naam) VALUES (3620010, 'Oude Dorp en Bovenkerk-Dorp');
INSERT INTO buurt (code, naam) VALUES (3620011, 'Keizer Karelpark-West');
INSERT INTO buurt (code, naam) VALUES (3620012, 'Keizer Karelpark-Oost');
INSERT INTO buurt (code, naam) VALUES (3620013, 'Groenelaan');
INSERT INTO buurt (code, naam) VALUES (3620014, 'Waardhuizen');
INSERT INTO buurt (code, naam) VALUES (3620015, 'Middenhoven');
INSERT INTO buurt (code, naam) VALUES (3620016, 'Bovenkerk en Legmeer');
INSERT INTO buurt (code, naam) VALUES (3620017, 'Westwijk-Oost');
INSERT INTO buurt (code, naam) VALUES (3620018, 'Westwijk-West');
INSERT INTO buurt (code, naam) VALUES (3620019, 'Buitengebied-Zuid');
INSERT INTO buurt (code, naam) VALUES (3620020, 'Amsterdamse Bos');
INSERT INTO buurt (code, naam) VALUES (3630000, 'Burgwallen-Oude Zijde');
INSERT INTO buurt (code, naam) VALUES (3630001, 'Burgwallen-Nieuwe Zijde');
INSERT INTO buurt (code, naam) VALUES (3630002, 'Grachtengordel-West');
INSERT INTO buurt (code, naam) VALUES (3630003, 'Grachtengordel-Zuid');
INSERT INTO buurt (code, naam) VALUES (3630004, 'Nieuwmarkt/Lastage');
INSERT INTO buurt (code, naam) VALUES (3630005, 'Haarlemmerbuurt');
INSERT INTO buurt (code, naam) VALUES (3630006, 'Jordaan');
INSERT INTO buurt (code, naam) VALUES (3630007, 'De Weteringschans');
INSERT INTO buurt (code, naam) VALUES (3630008, 'Weesperbuurt/Plantage');
INSERT INTO buurt (code, naam) VALUES (3630009, 'Oostelijke Eilanden/Kadijken');
INSERT INTO buurt (code, naam) VALUES (3630110, 'Westelijk Havengebied');
INSERT INTO buurt (code, naam) VALUES (3630111, 'Bedrijventerrein Sloterdijk');
INSERT INTO buurt (code, naam) VALUES (3630212, 'Houthavens');
INSERT INTO buurt (code, naam) VALUES (3630213, 'Spaarndammer- en Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (3630214, 'Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (3630215, 'Centrale Markt');
INSERT INTO buurt (code, naam) VALUES (3630216, 'Frederik Hendrikbuurt');
INSERT INTO buurt (code, naam) VALUES (3630217, 'Da Costabuurt');
INSERT INTO buurt (code, naam) VALUES (3630218, 'Kinkerbuurt');
INSERT INTO buurt (code, naam) VALUES (3630219, 'Van Lennepbuurt');
INSERT INTO buurt (code, naam) VALUES (3630220, 'Helmersbuurt');
INSERT INTO buurt (code, naam) VALUES (3630221, 'Overtoomse Sluis');
INSERT INTO buurt (code, naam) VALUES (3630222, 'Vondelbuurt');
INSERT INTO buurt (code, naam) VALUES (3630236, 'Sloterdijk');
INSERT INTO buurt (code, naam) VALUES (3630237, 'Landlust');
INSERT INTO buurt (code, naam) VALUES (3630238, 'Erasmuspark');
INSERT INTO buurt (code, naam) VALUES (3630239, 'De Kolenkit');
INSERT INTO buurt (code, naam) VALUES (3630240, 'De Krommert');
INSERT INTO buurt (code, naam) VALUES (3630241, 'Van Galenbuurt');
INSERT INTO buurt (code, naam) VALUES (3630242, 'Hoofdweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (3630243, 'Westindische buurt');
INSERT INTO buurt (code, naam) VALUES (3630375, 'Spieringhorn');
INSERT INTO buurt (code, naam) VALUES (3630376, 'Slotermeer-Noordoost');
INSERT INTO buurt (code, naam) VALUES (3630377, 'Slotermeer-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (3630378, 'Geuzenveld');
INSERT INTO buurt (code, naam) VALUES (3630379, 'Eendracht');
INSERT INTO buurt (code, naam) VALUES (3630380, 'Lutkemeer en Ookmeer');
INSERT INTO buurt (code, naam) VALUES (3630381, 'Osdorp-Oost');
INSERT INTO buurt (code, naam) VALUES (3630382, 'Osdorp-Midden');
INSERT INTO buurt (code, naam) VALUES (3630383, 'De Punt');
INSERT INTO buurt (code, naam) VALUES (3630384, 'Middelveldsche Akerpolder en Sloten');
INSERT INTO buurt (code, naam) VALUES (3630385, 'Slotervaart');
INSERT INTO buurt (code, naam) VALUES (3630386, 'Overtoomse Veld');
INSERT INTO buurt (code, naam) VALUES (3630387, 'Westlandgracht');
INSERT INTO buurt (code, naam) VALUES (3630388, 'Sloten- en Riekerpolder');
INSERT INTO buurt (code, naam) VALUES (3630424, 'Oude Pijp');
INSERT INTO buurt (code, naam) VALUES (3630425, 'Nieuwe Pijp');
INSERT INTO buurt (code, naam) VALUES (3630426, 'Diamantbuurt');
INSERT INTO buurt (code, naam) VALUES (3630444, 'Hoofddorppleinbuurt');
INSERT INTO buurt (code, naam) VALUES (3630445, 'Schinkelbuurt');
INSERT INTO buurt (code, naam) VALUES (3630446, 'Willemspark');
INSERT INTO buurt (code, naam) VALUES (3630447, 'Museumkwartier');
INSERT INTO buurt (code, naam) VALUES (3630448, 'Stadionbuurt');
INSERT INTO buurt (code, naam) VALUES (3630449, 'Apollobuurt');
INSERT INTO buurt (code, naam) VALUES (3630450, 'Duivelseiland');
INSERT INTO buurt (code, naam) VALUES (3630452, 'Scheldebuurt');
INSERT INTO buurt (code, naam) VALUES (3630453, 'IJselbuurt');
INSERT INTO buurt (code, naam) VALUES (3630454, 'Rijnbuurt');
INSERT INTO buurt (code, naam) VALUES (3630459, 'Station-Zuid WTC en omgeving');
INSERT INTO buurt (code, naam) VALUES (3630490, 'Buitenveldert-West');
INSERT INTO buurt (code, naam) VALUES (3630491, 'Buitenveldert-Oost');
INSERT INTO buurt (code, naam) VALUES (3630527, 'Weesperzijde');
INSERT INTO buurt (code, naam) VALUES (3630528, 'Oosterparkbuurt');
INSERT INTO buurt (code, naam) VALUES (3630529, 'Dapperbuurt');
INSERT INTO buurt (code, naam) VALUES (3630530, 'Transvaalbuurt');
INSERT INTO buurt (code, naam) VALUES (3630531, 'Indische Buurt West');
INSERT INTO buurt (code, naam) VALUES (3630532, 'Indische Buurt Oost');
INSERT INTO buurt (code, naam) VALUES (3630533, 'Oostelijk Havengebied');
INSERT INTO buurt (code, naam) VALUES (3630534, 'Zeeburgereiland/Nieuwe Diep');
INSERT INTO buurt (code, naam) VALUES (3630535, 'IJburg West');
INSERT INTO buurt (code, naam) VALUES (3630551, 'IJburg Zuid');
INSERT INTO buurt (code, naam) VALUES (3630555, 'Frankendael');
INSERT INTO buurt (code, naam) VALUES (3630556, 'Middenmeer');
INSERT INTO buurt (code, naam) VALUES (3630557, 'Betondorp');
INSERT INTO buurt (code, naam) VALUES (3630558, 'De Omval');
INSERT INTO buurt (code, naam) VALUES (3630574, 'IJburg Oost');
INSERT INTO buurt (code, naam) VALUES (3630660, 'Volewijck');
INSERT INTO buurt (code, naam) VALUES (3630661, 'Ijplein/Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (3630662, 'Tuindorp Nieuwendam');
INSERT INTO buurt (code, naam) VALUES (3630663, 'Tuindorp Buiksloot');
INSERT INTO buurt (code, naam) VALUES (3630664, 'Nieuwendammerdijk/Buiksloterdijk');
INSERT INTO buurt (code, naam) VALUES (3630665, 'Tuindorp Oostzaan');
INSERT INTO buurt (code, naam) VALUES (3630666, 'Oostzanerwerf');
INSERT INTO buurt (code, naam) VALUES (3630667, 'Kadoelen');
INSERT INTO buurt (code, naam) VALUES (3630668, 'Nieuwendam-Noord');
INSERT INTO buurt (code, naam) VALUES (3630669, 'Buikslotermeer');
INSERT INTO buurt (code, naam) VALUES (3630670, 'Banne Buiksloot');
INSERT INTO buurt (code, naam) VALUES (3630671, 'Buiksloterham');
INSERT INTO buurt (code, naam) VALUES (3630672, 'Nieuwendammerham');
INSERT INTO buurt (code, naam) VALUES (3630673, 'Waterland');
INSERT INTO buurt (code, naam) VALUES (3630792, 'Amstel III/Bullewijk');
INSERT INTO buurt (code, naam) VALUES (3630793, 'Bijlmer-Centrum (D, F, H)');
INSERT INTO buurt (code, naam) VALUES (3630794, 'Bijlmer-Oost (E, G, K)');
INSERT INTO buurt (code, naam) VALUES (3630795, 'Nellestein');
INSERT INTO buurt (code, naam) VALUES (3630796, 'Holendrecht/Reigersbos');
INSERT INTO buurt (code, naam) VALUES (3630797, 'Gein');
INSERT INTO buurt (code, naam) VALUES (3630798, 'Driemond');
INSERT INTO buurt (code, naam) VALUES (3639997, '');
INSERT INTO buurt (code, naam) VALUES (3650000, 'De Rijp');
INSERT INTO buurt (code, naam) VALUES (3650001, 'Zuideinde-Julianalaan');
INSERT INTO buurt (code, naam) VALUES (3650002, 'Bellesloot');
INSERT INTO buurt (code, naam) VALUES (3650100, 'Graft');
INSERT INTO buurt (code, naam) VALUES (3650101, 'Noordeinde');
INSERT INTO buurt (code, naam) VALUES (3650102, 'West-Graftdijk');
INSERT INTO buurt (code, naam) VALUES (3650103, 'Oost-Graftdijk');
INSERT INTO buurt (code, naam) VALUES (3650104, 'Markenbinnen');
INSERT INTO buurt (code, naam) VALUES (3650108, 'Verspreide huizen in de Starnmeerpolder');
INSERT INTO buurt (code, naam) VALUES (3650109, 'Verspreide huizen in de Graftermeerpolder');
INSERT INTO buurt (code, naam) VALUES (3700000, 'Middenbeemster');
INSERT INTO buurt (code, naam) VALUES (3700001, 'Westbeemster');
INSERT INTO buurt (code, naam) VALUES (3700002, 'Noordbeemster');
INSERT INTO buurt (code, naam) VALUES (3700003, 'Oostbeemster');
INSERT INTO buurt (code, naam) VALUES (3700006, 'Verspreide huizen ten zuiden en oosten van Middenbeemster');
INSERT INTO buurt (code, naam) VALUES (3700007, 'Verspreide huizen in het Noordoosten');
INSERT INTO buurt (code, naam) VALUES (3700008, 'Verspreide huizen in Noorden en Noordwesten');
INSERT INTO buurt (code, naam) VALUES (3700009, 'Verspreide huizen ten zuidwesten van Middenbeemster');
INSERT INTO buurt (code, naam) VALUES (3700100, 'Zuidoostbeemster Tuinhoek');
INSERT INTO buurt (code, naam) VALUES (3700109, 'Verspreide huizen Zuidoostbeemster');
INSERT INTO buurt (code, naam) VALUES (3730101, 'Bergen-Centrum');
INSERT INTO buurt (code, naam) VALUES (3730102, 'Van Reenen');
INSERT INTO buurt (code, naam) VALUES (3730103, 'Boschrand');
INSERT INTO buurt (code, naam) VALUES (3730104, 'Negen-Nessen');
INSERT INTO buurt (code, naam) VALUES (3730105, 'Landweg');
INSERT INTO buurt (code, naam) VALUES (3730106, 'Oudtburgh');
INSERT INTO buurt (code, naam) VALUES (3730107, 'De Rekere');
INSERT INTO buurt (code, naam) VALUES (3730108, 'Elkshove');
INSERT INTO buurt (code, naam) VALUES (3730109, 'Saenegheest');
INSERT INTO buurt (code, naam) VALUES (3730110, 'Tuin-en Oostdorp');
INSERT INTO buurt (code, naam) VALUES (3730111, 'Boendermaker');
INSERT INTO buurt (code, naam) VALUES (3730112, 'Kruidenbuurt');
INSERT INTO buurt (code, naam) VALUES (3730113, 'Conincx');
INSERT INTO buurt (code, naam) VALUES (3730114, 'Beekhove');
INSERT INTO buurt (code, naam) VALUES (3730115, 'Oldehove');
INSERT INTO buurt (code, naam) VALUES (3730116, 'Geest');
INSERT INTO buurt (code, naam) VALUES (3730117, 'Westdorp');
INSERT INTO buurt (code, naam) VALUES (3730200, 'Bergen aan Zee');
INSERT INTO buurt (code, naam) VALUES (3730300, 'Buitengebied Bergen');
INSERT INTO buurt (code, naam) VALUES (3730400, 'Egmond aan Zee');
INSERT INTO buurt (code, naam) VALUES (3730401, 'Prins Hendrik Stichting');
INSERT INTO buurt (code, naam) VALUES (3730402, 'Zuid I en II');
INSERT INTO buurt (code, naam) VALUES (3730403, 'Sportlaan');
INSERT INTO buurt (code, naam) VALUES (3730500, 'Egmond-Binnen');
INSERT INTO buurt (code, naam) VALUES (3730501, 'Rinnegom');
INSERT INTO buurt (code, naam) VALUES (3730600, 'Egmond aan Den Hoef');
INSERT INTO buurt (code, naam) VALUES (3730601, 'Slotplan');
INSERT INTO buurt (code, naam) VALUES (3730602, 'Wimmenum');
INSERT INTO buurt (code, naam) VALUES (3730609, 'Verspreide huizen Egmondermeer');
INSERT INTO buurt (code, naam) VALUES (3730700, 'Schoorl met Bregtdorp');
INSERT INTO buurt (code, naam) VALUES (3730701, 'Schoorldam (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (3730702, 'Aagtdorp');
INSERT INTO buurt (code, naam) VALUES (3730703, 'Catrijp');
INSERT INTO buurt (code, naam) VALUES (3730704, 'Groet met Hargen');
INSERT INTO buurt (code, naam) VALUES (3730705, 'Camperduin');
INSERT INTO buurt (code, naam) VALUES (3730709, 'Verspreide huizen in de polders');
INSERT INTO buurt (code, naam) VALUES (3739998, '');
INSERT INTO buurt (code, naam) VALUES (3750000, 'Wijkertoren');
INSERT INTO buurt (code, naam) VALUES (3750001, 'Meerplein');
INSERT INTO buurt (code, naam) VALUES (3750002, 'Koningstraat');
INSERT INTO buurt (code, naam) VALUES (3750003, 'Burgerhartstraat');
INSERT INTO buurt (code, naam) VALUES (3750004, 'Sint Aagtendorp');
INSERT INTO buurt (code, naam) VALUES (3750005, 'Reguliersstraat');
INSERT INTO buurt (code, naam) VALUES (3750100, 'Vondellaan');
INSERT INTO buurt (code, naam) VALUES (3750101, 'Ronde Boogaard');
INSERT INTO buurt (code, naam) VALUES (3750109, 'Westerhout');
INSERT INTO buurt (code, naam) VALUES (3750200, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (3750201, 'Oud Sportpark');
INSERT INTO buurt (code, naam) VALUES (3750202, 'Beijnes');
INSERT INTO buurt (code, naam) VALUES (3750300, 'Plantage');
INSERT INTO buurt (code, naam) VALUES (3750301, 'Oostertuinen');
INSERT INTO buurt (code, naam) VALUES (3750302, 'Kuenenplein');
INSERT INTO buurt (code, naam) VALUES (3750303, 'De Naald');
INSERT INTO buurt (code, naam) VALUES (3750400, 'Warande');
INSERT INTO buurt (code, naam) VALUES (3750401, 'De Horn');
INSERT INTO buurt (code, naam) VALUES (3750500, 'Westertuinen');
INSERT INTO buurt (code, naam) VALUES (3750501, 'Creutzberglaan');
INSERT INTO buurt (code, naam) VALUES (3750600, 'Oosterwijk');
INSERT INTO buurt (code, naam) VALUES (3750601, 'Zwaansmeer');
INSERT INTO buurt (code, naam) VALUES (3750700, 'Bleriotlaan');
INSERT INTO buurt (code, naam) VALUES (3750701, 'Fokkerlaan');
INSERT INTO buurt (code, naam) VALUES (3750702, 'Wijkerbaan');
INSERT INTO buurt (code, naam) VALUES (3750703, 'Overbos');
INSERT INTO buurt (code, naam) VALUES (3750800, 'Wijk aan Zee');
INSERT INTO buurt (code, naam) VALUES (3750801, 'Industriegebied Hoogovens');
INSERT INTO buurt (code, naam) VALUES (3750900, 'De Pijp');
INSERT INTO buurt (code, naam) VALUES (3750901, 'Kagerweg');
INSERT INTO buurt (code, naam) VALUES (3750909, 'Wijkerbroek');
INSERT INTO buurt (code, naam) VALUES (3759998, '');
INSERT INTO buurt (code, naam) VALUES (3760000, 'Blaricum');
INSERT INTO buurt (code, naam) VALUES (3760001, 'Bijvanck');
INSERT INTO buurt (code, naam) VALUES (3769997, '');
INSERT INTO buurt (code, naam) VALUES (3770000, 'Bloemendaal');
INSERT INTO buurt (code, naam) VALUES (3770001, 'Veen en Duin');
INSERT INTO buurt (code, naam) VALUES (3770002, 'Wildhoef');
INSERT INTO buurt (code, naam) VALUES (3770003, 'Duinlustpark');
INSERT INTO buurt (code, naam) VALUES (3770004, 'Provinciaal Ziekenhuis');
INSERT INTO buurt (code, naam) VALUES (3770005, 'De Rijp');
INSERT INTO buurt (code, naam) VALUES (3770009, 'Verspreide huizen Bloemendaal');
INSERT INTO buurt (code, naam) VALUES (3770100, 'Overveen');
INSERT INTO buurt (code, naam) VALUES (3770101, 'Oldenhove');
INSERT INTO buurt (code, naam) VALUES (3770109, 'Overveen-West');
INSERT INTO buurt (code, naam) VALUES (3770200, 'Aerdenhout-Centrum');
INSERT INTO buurt (code, naam) VALUES (3770201, 'Aerdenhout-West');
INSERT INTO buurt (code, naam) VALUES (3770202, 'Aerdenhout-Noord');
INSERT INTO buurt (code, naam) VALUES (3770209, 'Aerdenhout-Zuid');
INSERT INTO buurt (code, naam) VALUES (3770300, 'Vogelenzang');
INSERT INTO buurt (code, naam) VALUES (3770309, 'Verspreide huizen Vogelenzang');
INSERT INTO buurt (code, naam) VALUES (3770400, 'Oude Kern Bennebroek');
INSERT INTO buurt (code, naam) VALUES (3770401, 'Villawijk Het Duin');
INSERT INTO buurt (code, naam) VALUES (3770402, 'Leidsevaart- Bloemhof');
INSERT INTO buurt (code, naam) VALUES (3770403, 'Villawijk Bijweg');
INSERT INTO buurt (code, naam) VALUES (3770404, 'Meerwijk');
INSERT INTO buurt (code, naam) VALUES (3770409, 'Vogelenzang Psychiatrisch Ziekenhuis');
INSERT INTO buurt (code, naam) VALUES (3779998, '');
INSERT INTO buurt (code, naam) VALUES (3810000, 'Brink');
INSERT INTO buurt (code, naam) VALUES (3810001, 'Raadhuisplein');
INSERT INTO buurt (code, naam) VALUES (3810002, 'Verbindingslaan');
INSERT INTO buurt (code, naam) VALUES (3810003, 'Batterijlaan');
INSERT INTO buurt (code, naam) VALUES (3810004, 'Cereslaan');
INSERT INTO buurt (code, naam) VALUES (3810005, 'Bijlstraat');
INSERT INTO buurt (code, naam) VALUES (3810006, 'Nijverheidswerf');
INSERT INTO buurt (code, naam) VALUES (3810007, 'Laarderwegkwartier');
INSERT INTO buurt (code, naam) VALUES (3810008, 'Spiegelzicht');
INSERT INTO buurt (code, naam) VALUES (3810100, 'Prins Hendrikkwartier');
INSERT INTO buurt (code, naam) VALUES (3810101, 'Hooftlaan');
INSERT INTO buurt (code, naam) VALUES (3810102, 'Vondellaan');
INSERT INTO buurt (code, naam) VALUES (3810103, 'Bredius-West');
INSERT INTO buurt (code, naam) VALUES (3810104, 'Bredius-Oost');
INSERT INTO buurt (code, naam) VALUES (3810200, 'Sportpark-Zuid');
INSERT INTO buurt (code, naam) VALUES (3810201, 'Dondersstraat');
INSERT INTO buurt (code, naam) VALUES (3810202, 'Godelindebuurt');
INSERT INTO buurt (code, naam) VALUES (3810203, 'Waltherlaan');
INSERT INTO buurt (code, naam) VALUES (3810204, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (3810205, 'Ooster Eng-Noord');
INSERT INTO buurt (code, naam) VALUES (3810206, 'Ooster Eng-Zuid');
INSERT INTO buurt (code, naam) VALUES (3810207, 'Midden Eng-Oost');
INSERT INTO buurt (code, naam) VALUES (3810208, 'Midden Eng-West');
INSERT INTO buurt (code, naam) VALUES (3810209, 'Wester Eng');
INSERT INTO buurt (code, naam) VALUES (3810300, 'Lomanplein');
INSERT INTO buurt (code, naam) VALUES (3810301, 'Schimmellaan');
INSERT INTO buurt (code, naam) VALUES (3810302, 'Boslaan');
INSERT INTO buurt (code, naam) VALUES (3810303, 'Koedijk');
INSERT INTO buurt (code, naam) VALUES (3810304, 'Kom van Bieghel');
INSERT INTO buurt (code, naam) VALUES (3810305, 'Meijerkamp');
INSERT INTO buurt (code, naam) VALUES (3810306, 'Franse Kamp');
INSERT INTO buurt (code, naam) VALUES (3830001, 'Centrum-Noord');
INSERT INTO buurt (code, naam) VALUES (3830011, 'Centrum-Zuid');
INSERT INTO buurt (code, naam) VALUES (3830101, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (3830111, 'Kooiweg');
INSERT INTO buurt (code, naam) VALUES (3830201, 'Molendijk');
INSERT INTO buurt (code, naam) VALUES (3830211, 'Noord-End');
INSERT INTO buurt (code, naam) VALUES (3830221, 'Albert''s Hoeve');
INSERT INTO buurt (code, naam) VALUES (3830301, 'Beverwijkerstraatweg');
INSERT INTO buurt (code, naam) VALUES (3830311, 'Buitengebied');
INSERT INTO buurt (code, naam) VALUES (3830401, 'Bakkum-Noord');
INSERT INTO buurt (code, naam) VALUES (3830411, 'Bakkum-Zuid');
INSERT INTO buurt (code, naam) VALUES (3830421, 'Duin en Bosch');
INSERT INTO buurt (code, naam) VALUES (3830431, 'Duingebied');
INSERT INTO buurt (code, naam) VALUES (3830501, 'Akersloot Oost');
INSERT INTO buurt (code, naam) VALUES (3830511, 'Akersloot West');
INSERT INTO buurt (code, naam) VALUES (3830601, 'De Woude');
INSERT INTO buurt (code, naam) VALUES (3830701, 'Limmen West');
INSERT INTO buurt (code, naam) VALUES (3830711, 'Limmen Centrum');
INSERT INTO buurt (code, naam) VALUES (3830721, 'Limmen Oost');
INSERT INTO buurt (code, naam) VALUES (3839998, '');
INSERT INTO buurt (code, naam) VALUES (3840001, 'Biesbosch');
INSERT INTO buurt (code, naam) VALUES (3840002, 'Akkerland');
INSERT INTO buurt (code, naam) VALUES (3840003, 'Polderland');
INSERT INTO buurt (code, naam) VALUES (3840004, 'Kruidenhof');
INSERT INTO buurt (code, naam) VALUES (3840005, 'Bomenrijk');
INSERT INTO buurt (code, naam) VALUES (3840006, 'Beukenhorst');
INSERT INTO buurt (code, naam) VALUES (3840007, 'Schelpenhoek');
INSERT INTO buurt (code, naam) VALUES (3840008, 'Anne Frank');
INSERT INTO buurt (code, naam) VALUES (3840009, 'Sniep');
INSERT INTO buurt (code, naam) VALUES (3840010, 'Verrijn Stuart');
INSERT INTO buurt (code, naam) VALUES (3840011, 'Bergwijkpark');
INSERT INTO buurt (code, naam) VALUES (3840012, 'Stammerdijk');
INSERT INTO buurt (code, naam) VALUES (3840113, 'Overdiemerpolder');
INSERT INTO buurt (code, naam) VALUES (3840114, 'Centrum-Oost');
INSERT INTO buurt (code, naam) VALUES (3840115, 'Centrum-West');
INSERT INTO buurt (code, naam) VALUES (3840116, 'Ruimzicht-West');
INSERT INTO buurt (code, naam) VALUES (3840117, 'Ruimzicht-Oost');
INSERT INTO buurt (code, naam) VALUES (3840118, 'Studentenflats');
INSERT INTO buurt (code, naam) VALUES (3840219, 'Buitenlust');
INSERT INTO buurt (code, naam) VALUES (3840220, 'Spoorzicht');
INSERT INTO buurt (code, naam) VALUES (3840221, 'Oud-Diemen');
INSERT INTO buurt (code, naam) VALUES (3840222, 'Buytenstee');
INSERT INTO buurt (code, naam) VALUES (3840223, 'Vogelweide en Scheepskwartier-Noord');
INSERT INTO buurt (code, naam) VALUES (3840224, 'Vlindertuin en Scheepskwartier-Zuid');
INSERT INTO buurt (code, naam) VALUES (3840225, 'Diemerpolder');
INSERT INTO buurt (code, naam) VALUES (3849997, '');
INSERT INTO buurt (code, naam) VALUES (3850010, 'Edam-Oude kom');
INSERT INTO buurt (code, naam) VALUES (3850011, 'Industrieterrein-Oosthuizerweg');
INSERT INTO buurt (code, naam) VALUES (3850021, 'Edam III');
INSERT INTO buurt (code, naam) VALUES (3850031, 'Edam-Singelwijk');
INSERT INTO buurt (code, naam) VALUES (3850041, 'Edam-Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (3850071, 'Lange Weeren');
INSERT INTO buurt (code, naam) VALUES (3850081, 'Zeevangpolder');
INSERT INTO buurt (code, naam) VALUES (3850091, 'Zuidpolder');
INSERT INTO buurt (code, naam) VALUES (3850109, 'Purmerpolder');
INSERT INTO buurt (code, naam) VALUES (3850200, 'Volendam-Oude Kom');
INSERT INTO buurt (code, naam) VALUES (3850201, 'Volendam-Planetenbuurt');
INSERT INTO buurt (code, naam) VALUES (3850202, 'Volendam-Blokgouw 4, 5 en 6');
INSERT INTO buurt (code, naam) VALUES (3850203, 'Volendam-Blokgouw 7 en 8');
INSERT INTO buurt (code, naam) VALUES (3850204, 'Volendam-Blokgouw 3');
INSERT INTO buurt (code, naam) VALUES (3850205, 'Volendam-Blokgouw 1 en 2');
INSERT INTO buurt (code, naam) VALUES (3850206, 'Volendam-Rozettenbuurt');
INSERT INTO buurt (code, naam) VALUES (3850207, 'Volendam-Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (3850208, 'Volendam-Industriegebied');
INSERT INTO buurt (code, naam) VALUES (3850209, 'Volendam-Middengebied');
INSERT INTO buurt (code, naam) VALUES (3859997, '');
INSERT INTO buurt (code, naam) VALUES (3880000, 'Centrum Vissersbuurt Oosterhaven');
INSERT INTO buurt (code, naam) VALUES (3880001, 'Havenbuurt Snouck van Loosenpark');
INSERT INTO buurt (code, naam) VALUES (3880002, 'Boerenhoek Molenweg Burgwal');
INSERT INTO buurt (code, naam) VALUES (3880003, 'Enkhuizen-Noord');
INSERT INTO buurt (code, naam) VALUES (3880100, 'Westeinde');
INSERT INTO buurt (code, naam) VALUES (3880101, 'Kadijken');
INSERT INTO buurt (code, naam) VALUES (3880102, 'Oude Gouw-Gommerwijk');
INSERT INTO buurt (code, naam) VALUES (3880103, 'Oosterdijk');
INSERT INTO buurt (code, naam) VALUES (3889997, '');
INSERT INTO buurt (code, naam) VALUES (3920100, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (3920101, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (3920102, 'Spaarnwouderbuurt');
INSERT INTO buurt (code, naam) VALUES (3920200, 'Zijlweg-Oost');
INSERT INTO buurt (code, naam) VALUES (3920201, 'Leidsebuurt');
INSERT INTO buurt (code, naam) VALUES (3920202, 'Leidsevaartbuurt');
INSERT INTO buurt (code, naam) VALUES (3920203, 'Houtvaartkwartier');
INSERT INTO buurt (code, naam) VALUES (3920300, 'Oude Amsterdamsebuurt');
INSERT INTO buurt (code, naam) VALUES (3920301, 'Potgieterbuurt');
INSERT INTO buurt (code, naam) VALUES (3920302, 'Van Zeggelenbuurt');
INSERT INTO buurt (code, naam) VALUES (3920303, 'Slachthuisbuurt');
INSERT INTO buurt (code, naam) VALUES (3920304, 'Parkwijk');
INSERT INTO buurt (code, naam) VALUES (3920305, 'Waarderpolder');
INSERT INTO buurt (code, naam) VALUES (3920306, 'Zuiderpolder');
INSERT INTO buurt (code, naam) VALUES (3920400, 'Koninginnebuurt');
INSERT INTO buurt (code, naam) VALUES (3920401, 'Kleine Hout');
INSERT INTO buurt (code, naam) VALUES (3920402, 'Den Hout');
INSERT INTO buurt (code, naam) VALUES (3920403, 'Rozenprieel');
INSERT INTO buurt (code, naam) VALUES (3920500, 'Patrimoniumbuurt');
INSERT INTO buurt (code, naam) VALUES (3920501, 'Transvaalbuurt');
INSERT INTO buurt (code, naam) VALUES (3920502, 'Indische buurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (3920503, 'Indische buurt-Noord');
INSERT INTO buurt (code, naam) VALUES (3920504, 'Frans Halsbuurt');
INSERT INTO buurt (code, naam) VALUES (3920600, 'Kleverpark');
INSERT INTO buurt (code, naam) VALUES (3920601, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (3920602, 'Planetenwijk');
INSERT INTO buurt (code, naam) VALUES (3920603, 'Sinnevelt');
INSERT INTO buurt (code, naam) VALUES (3920604, 'Overdelft');
INSERT INTO buurt (code, naam) VALUES (3920700, 'Dietsveld');
INSERT INTO buurt (code, naam) VALUES (3920701, 'Vogelenbuurt');
INSERT INTO buurt (code, naam) VALUES (3920702, 'Delftwijk');
INSERT INTO buurt (code, naam) VALUES (3920703, 'Vondelkwartier');
INSERT INTO buurt (code, naam) VALUES (3920704, 'Spaarndam-West');
INSERT INTO buurt (code, naam) VALUES (3920800, 'Ramplaankwartier');
INSERT INTO buurt (code, naam) VALUES (3920801, 'Zijlweg-West');
INSERT INTO buurt (code, naam) VALUES (3920802, 'Oosterduin');
INSERT INTO buurt (code, naam) VALUES (3920900, 'Europawijk');
INSERT INTO buurt (code, naam) VALUES (3920901, 'Boerhaavewijk');
INSERT INTO buurt (code, naam) VALUES (3920902, 'Molenwijk');
INSERT INTO buurt (code, naam) VALUES (3920903, 'Meerwijk');
INSERT INTO buurt (code, naam) VALUES (3930000, 'Halfweg');
INSERT INTO buurt (code, naam) VALUES (3930002, 'Spaarnwoude');
INSERT INTO buurt (code, naam) VALUES (3930003, 'Spaarndam (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (3930004, 'Haarlemmerliede en Penningsveer');
INSERT INTO buurt (code, naam) VALUES (3930008, 'Oostelijke Liede Oever');
INSERT INTO buurt (code, naam) VALUES (3930009, 'Verspreide huizen Houtrakpolder');
INSERT INTO buurt (code, naam) VALUES (3940101, 'Hoofddorp West');
INSERT INTO buurt (code, naam) VALUES (3940102, 'Hoofddorp Zuid');
INSERT INTO buurt (code, naam) VALUES (3940103, 'Hoofddorp Graan voor Visch');
INSERT INTO buurt (code, naam) VALUES (3940104, 'Hoofddorp Oost');
INSERT INTO buurt (code, naam) VALUES (3940105, 'Hoofddorp Noord');
INSERT INTO buurt (code, naam) VALUES (3940106, 'Hoofddorp Pax West');
INSERT INTO buurt (code, naam) VALUES (3940107, 'Hoofddorp Pax Oost');
INSERT INTO buurt (code, naam) VALUES (3940108, 'Hoofddorp Bornholm West');
INSERT INTO buurt (code, naam) VALUES (3940109, 'Hoofddorp Bornholm Oost');
INSERT INTO buurt (code, naam) VALUES (3940111, 'Hoofddorp Overbos Noord');
INSERT INTO buurt (code, naam) VALUES (3940112, 'Hoofddorp Overbos Zuid');
INSERT INTO buurt (code, naam) VALUES (3940113, 'Hoofddorp Toolenburg West');
INSERT INTO buurt (code, naam) VALUES (3940114, 'Hoofddorp Toolenburg Oost');
INSERT INTO buurt (code, naam) VALUES (3940115, 'Hoofddorp Vrijschot Noord');
INSERT INTO buurt (code, naam) VALUES (3940116, 'Hoofddorp Floriande West');
INSERT INTO buurt (code, naam) VALUES (3940117, 'Hoofddorp Floriande Oost');
INSERT INTO buurt (code, naam) VALUES (3940118, 'Hoofddorp Toolenburg Zuid');
INSERT INTO buurt (code, naam) VALUES (3940119, 'Hoofddorp De Landman');
INSERT INTO buurt (code, naam) VALUES (3940122, 'Hoofddorp Omgeving');
INSERT INTO buurt (code, naam) VALUES (3940123, 'Hoofddorp De Hoek');
INSERT INTO buurt (code, naam) VALUES (3940124, 'Hoofddorp Graan voor Visch Zuid');
INSERT INTO buurt (code, naam) VALUES (3940125, 'Hoofddorp Beukenhorst Oost');
INSERT INTO buurt (code, naam) VALUES (3940126, 'Hoofddorp De President');
INSERT INTO buurt (code, naam) VALUES (3940127, 'Hoofddorp Buiten');
INSERT INTO buurt (code, naam) VALUES (3940230, 'Nieuw-Vennep Oost');
INSERT INTO buurt (code, naam) VALUES (3940231, 'Nieuw-Vennep Welgelegen');
INSERT INTO buurt (code, naam) VALUES (3940232, 'Nieuw-Vennep Welgelegen Noord');
INSERT INTO buurt (code, naam) VALUES (3940233, 'Nieuw-Vennep West');
INSERT INTO buurt (code, naam) VALUES (3940234, 'Nieuw-Vennep Zuid');
INSERT INTO buurt (code, naam) VALUES (3940235, 'Nieuw-Vennep Linquenda');
INSERT INTO buurt (code, naam) VALUES (3940236, 'Nieuw-Vennep Getsewoud Noord');
INSERT INTO buurt (code, naam) VALUES (3940237, 'Nieuw-Vennep Getsewoud Zuid');
INSERT INTO buurt (code, naam) VALUES (3940239, 'Nieuw-Vennep Wilhelminahoeve');
INSERT INTO buurt (code, naam) VALUES (3940240, 'Nieuw-Vennep Omgeving');
INSERT INTO buurt (code, naam) VALUES (3940241, 'Nieuw-Vennep ''t Kabel');
INSERT INTO buurt (code, naam) VALUES (3940343, 'Zwanenburg West');
INSERT INTO buurt (code, naam) VALUES (3940344, 'Zwanenburg Zuidwest');
INSERT INTO buurt (code, naam) VALUES (3940345, 'Zwanenburg Zuidoost');
INSERT INTO buurt (code, naam) VALUES (3940346, 'Zwanenburg Oost');
INSERT INTO buurt (code, naam) VALUES (3940347, 'Zwanenburg Noordoost');
INSERT INTO buurt (code, naam) VALUES (3940348, 'Zwanenburg Noordwest');
INSERT INTO buurt (code, naam) VALUES (3940349, 'Zwanenburg Dijk');
INSERT INTO buurt (code, naam) VALUES (3940350, 'Zwanenburg Omgeving');
INSERT INTO buurt (code, naam) VALUES (3940429, 'Lijnden Omgeving');
INSERT INTO buurt (code, naam) VALUES (3940465, 'Lijnden');
INSERT INTO buurt (code, naam) VALUES (3940466, 'Boesingheliede');
INSERT INTO buurt (code, naam) VALUES (3940551, 'Badhoevedorp Omgeving');
INSERT INTO buurt (code, naam) VALUES (3940552, 'Badhoevedorp Noordwest');
INSERT INTO buurt (code, naam) VALUES (3940553, 'Badhoevedorp West');
INSERT INTO buurt (code, naam) VALUES (3940554, 'Badhoevedorp Bouwlust');
INSERT INTO buurt (code, naam) VALUES (3940556, 'Badhoevedorp Zuid');
INSERT INTO buurt (code, naam) VALUES (3940557, 'Badhoevedorp Centrum');
INSERT INTO buurt (code, naam) VALUES (3940558, 'Badhoevedorp Noordoost');
INSERT INTO buurt (code, naam) VALUES (3940559, 'Badhoevedorp Antoniushoeve');
INSERT INTO buurt (code, naam) VALUES (3940560, 'Badhoevedorp Oost');
INSERT INTO buurt (code, naam) VALUES (3940561, 'Badhoevedorp Schuilhoeve');
INSERT INTO buurt (code, naam) VALUES (3940562, 'Badhoevedorp Dijk');
INSERT INTO buurt (code, naam) VALUES (3940563, 'Schiphol');
INSERT INTO buurt (code, naam) VALUES (3940564, 'Badhoevedorp Nieuwe Meer');
INSERT INTO buurt (code, naam) VALUES (3940674, 'Schiphol-Rijk');
INSERT INTO buurt (code, naam) VALUES (3940675, 'Oude Meer');
INSERT INTO buurt (code, naam) VALUES (3940676, 'Aalsmeerderbrug');
INSERT INTO buurt (code, naam) VALUES (3940677, 'Rozenburg Noord');
INSERT INTO buurt (code, naam) VALUES (3940678, 'Rozenburg Omgeving');
INSERT INTO buurt (code, naam) VALUES (3940779, 'Rijsenhout Dorp');
INSERT INTO buurt (code, naam) VALUES (3940780, 'Rijsenhout Zuid');
INSERT INTO buurt (code, naam) VALUES (3940781, 'Rijsenhout Dijk');
INSERT INTO buurt (code, naam) VALUES (3940782, 'Rijsenhout Omgeving');
INSERT INTO buurt (code, naam) VALUES (3940883, 'Burgerveen');
INSERT INTO buurt (code, naam) VALUES (3940884, 'Leimuiderbrug');
INSERT INTO buurt (code, naam) VALUES (3940885, 'Weteringbrug');
INSERT INTO buurt (code, naam) VALUES (3940986, 'Abbenes');
INSERT INTO buurt (code, naam) VALUES (3940987, 'Abbenes Omgeving');
INSERT INTO buurt (code, naam) VALUES (3940988, 'Buitenkaag');
INSERT INTO buurt (code, naam) VALUES (3940989, 'Abbenes Dijk');
INSERT INTO buurt (code, naam) VALUES (3941090, 'Lisserbroek');
INSERT INTO buurt (code, naam) VALUES (3941091, 'Lisserbroek Omgeving');
INSERT INTO buurt (code, naam) VALUES (3941192, 'Beinsdorp Omgeving');
INSERT INTO buurt (code, naam) VALUES (3941193, 'Beinsdorp');
INSERT INTO buurt (code, naam) VALUES (3941294, 'Zwaanshoek');
INSERT INTO buurt (code, naam) VALUES (3941295, 'Zwaanshoek Omgeving');
INSERT INTO buurt (code, naam) VALUES (3941397, 'Cruquius');
INSERT INTO buurt (code, naam) VALUES (3941398, 'Cruquius Omgeving');
INSERT INTO buurt (code, naam) VALUES (3941399, 'Cruquius Cruqiushoeve');
INSERT INTO buurt (code, naam) VALUES (3941567, 'Vijfhuizen');
INSERT INTO buurt (code, naam) VALUES (3941569, 'Vijfhuizen Stellinghof');
INSERT INTO buurt (code, naam) VALUES (3941570, 'Vijfhuizen Omgeving');
INSERT INTO buurt (code, naam) VALUES (3941571, 'Vijfhuizen Nieuwe Brug');
INSERT INTO buurt (code, naam) VALUES (3960100, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (3960101, 'Zaalbergkwartier');
INSERT INTO buurt (code, naam) VALUES (3960200, 'Commandeurs');
INSERT INTO buurt (code, naam) VALUES (3960201, 'Eikenhof');
INSERT INTO buurt (code, naam) VALUES (3960202, 'Landgoed Marquette');
INSERT INTO buurt (code, naam) VALUES (3960300, 'Oud Haarlem');
INSERT INTO buurt (code, naam) VALUES (3960301, 'Harteheem');
INSERT INTO buurt (code, naam) VALUES (3960302, 'Oosterwijk');
INSERT INTO buurt (code, naam) VALUES (3960303, 'Zuidbroek');
INSERT INTO buurt (code, naam) VALUES (3960400, 'De Houtwegen');
INSERT INTO buurt (code, naam) VALUES (3960401, 'Industriegebied');
INSERT INTO buurt (code, naam) VALUES (3960402, 'Heemskerkerduin');
INSERT INTO buurt (code, naam) VALUES (3960403, 'Noorddorp');
INSERT INTO buurt (code, naam) VALUES (3960404, 'Westertuinen');
INSERT INTO buurt (code, naam) VALUES (3960408, 'Business park Ijmond');
INSERT INTO buurt (code, naam) VALUES (3960409, 'Duingebied');
INSERT INTO buurt (code, naam) VALUES (3960500, 'Poelenburg');
INSERT INTO buurt (code, naam) VALUES (3960501, 'Oosterzij');
INSERT INTO buurt (code, naam) VALUES (3960502, 'Neksloot');
INSERT INTO buurt (code, naam) VALUES (3960503, 'Steenstrapark');
INSERT INTO buurt (code, naam) VALUES (3960600, 'De Maer');
INSERT INTO buurt (code, naam) VALUES (3960601, 'De Die');
INSERT INTO buurt (code, naam) VALUES (3960602, 'Rendorppark');
INSERT INTO buurt (code, naam) VALUES (3960603, 'Breedweer');
INSERT INTO buurt (code, naam) VALUES (3960604, 'Tolhek');
INSERT INTO buurt (code, naam) VALUES (3960605, 'De Trompet');
INSERT INTO buurt (code, naam) VALUES (3960607, 'Noorderveld');
INSERT INTO buurt (code, naam) VALUES (3960700, 'Onderwijzersbuurt');
INSERT INTO buurt (code, naam) VALUES (3960701, 'Villabuurt');
INSERT INTO buurt (code, naam) VALUES (3960702, 'Beijnesbuurt');
INSERT INTO buurt (code, naam) VALUES (3960800, 'Slotherenbuurt');
INSERT INTO buurt (code, naam) VALUES (3960801, 'Verzetstrijdersbuurt');
INSERT INTO buurt (code, naam) VALUES (3960802, 'Beijerlust');
INSERT INTO buurt (code, naam) VALUES (3960900, 'Hoogdorp');
INSERT INTO buurt (code, naam) VALUES (3960901, 'Waterakkers');
INSERT INTO buurt (code, naam) VALUES (3961001, 'De Citadel');
INSERT INTO buurt (code, naam) VALUES (3961002, 'De Wadden');
INSERT INTO buurt (code, naam) VALUES (3961100, 'Landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (3969998, '');
INSERT INTO buurt (code, naam) VALUES (3970000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (3970001, 'Oude Dorp, Indische buurt en omgeving');
INSERT INTO buurt (code, naam) VALUES (3970002, 'Zandvoortselaan en Berkenrode en omgeving');
INSERT INTO buurt (code, naam) VALUES (3970003, 'Heemsteedse Dreef, Schildersbuurt en omgeving');
INSERT INTO buurt (code, naam) VALUES (3970004, 'Van Merlenbuurt en Valkenburgerplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (3970005, 'Schouwbroekerpolder');
INSERT INTO buurt (code, naam) VALUES (3970006, 'Rivierenbuurt');
INSERT INTO buurt (code, naam) VALUES (3970007, 'Kennemerduin en omgeving');
INSERT INTO buurt (code, naam) VALUES (3970008, 'Provincienbuurt');
INSERT INTO buurt (code, naam) VALUES (3970009, 'Geleerdenbuurt');
INSERT INTO buurt (code, naam) VALUES (3970100, 'De Glip');
INSERT INTO buurt (code, naam) VALUES (3970101, 'Glipper Dreef en Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (3970102, 'Manpad en Hartekamp');
INSERT INTO buurt (code, naam) VALUES (3970200, 'Dichters- en Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (3980100, 'Schrijverswijk');
INSERT INTO buurt (code, naam) VALUES (3980201, 'Schilderswijk 1');
INSERT INTO buurt (code, naam) VALUES (3980202, 'Schilderswijk 2');
INSERT INTO buurt (code, naam) VALUES (3980400, 'Planetenwijk');
INSERT INTO buurt (code, naam) VALUES (3980601, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (3980602, 'Recreatiebuurt');
INSERT INTO buurt (code, naam) VALUES (3980603, 'Waarderhout');
INSERT INTO buurt (code, naam) VALUES (3980701, 'Centrumwaard');
INSERT INTO buurt (code, naam) VALUES (3980702, 'Heemradenbuurt');
INSERT INTO buurt (code, naam) VALUES (3980800, 'Edelstenenwijk');
INSERT INTO buurt (code, naam) VALUES (3980901, 'Stadshart');
INSERT INTO buurt (code, naam) VALUES (3980902, 'Stationsplein');
INSERT INTO buurt (code, naam) VALUES (3981000, 'Molenwijk');
INSERT INTO buurt (code, naam) VALUES (3981100, 'Rivierenwijk');
INSERT INTO buurt (code, naam) VALUES (3981201, 'Zandhorst 1');
INSERT INTO buurt (code, naam) VALUES (3981202, 'Zandhorst 2');
INSERT INTO buurt (code, naam) VALUES (3981203, 'Zandhorst 3');
INSERT INTO buurt (code, naam) VALUES (3981204, 'De Frans');
INSERT INTO buurt (code, naam) VALUES (3981205, 'Beveland');
INSERT INTO buurt (code, naam) VALUES (3981206, 'De Vaandel');
INSERT INTO buurt (code, naam) VALUES (3981207, 'Overtoom');
INSERT INTO buurt (code, naam) VALUES (3981301, 'Butterhuizen 1');
INSERT INTO buurt (code, naam) VALUES (3981302, 'Butterhuizen 2');
INSERT INTO buurt (code, naam) VALUES (3981400, 'Oostertocht');
INSERT INTO buurt (code, naam) VALUES (3981501, 'Zuidwijk 1');
INSERT INTO buurt (code, naam) VALUES (3981502, 'Zuidwijk 2');
INSERT INTO buurt (code, naam) VALUES (3981601, 'Huygenhoek 1');
INSERT INTO buurt (code, naam) VALUES (3981602, 'Huygenhoek 2');
INSERT INTO buurt (code, naam) VALUES (3981603, 'Huygenhoek 3');
INSERT INTO buurt (code, naam) VALUES (3981701, 'Stad van de Zon');
INSERT INTO buurt (code, naam) VALUES (3981702, 'Park van Luna');
INSERT INTO buurt (code, naam) VALUES (3981801, 'De Draai Noord');
INSERT INTO buurt (code, naam) VALUES (3981802, 'De Draai Midden');
INSERT INTO buurt (code, naam) VALUES (3981803, 'De Draai Zuid');
INSERT INTO buurt (code, naam) VALUES (3981900, 'Broekhorn');
INSERT INTO buurt (code, naam) VALUES (3982000, 'De Noord');
INSERT INTO buurt (code, naam) VALUES (3983000, 'Buitengebied Noord');
INSERT INTO buurt (code, naam) VALUES (3984000, '''t Kruis');
INSERT INTO buurt (code, naam) VALUES (3985000, 'Buitengebied Zuid');
INSERT INTO buurt (code, naam) VALUES (3990101, 'Blockhovepark');
INSERT INTO buurt (code, naam) VALUES (3990201, 'Noorderneg');
INSERT INTO buurt (code, naam) VALUES (3990202, 'Oud West');
INSERT INTO buurt (code, naam) VALUES (3990301, 'Tuindorp');
INSERT INTO buurt (code, naam) VALUES (3990302, 'Gemeentebos');
INSERT INTO buurt (code, naam) VALUES (3990303, 'Plan Oost');
INSERT INTO buurt (code, naam) VALUES (3990304, 'Nijenburg');
INSERT INTO buurt (code, naam) VALUES (3990401, 'Zuiderneg');
INSERT INTO buurt (code, naam) VALUES (3990402, 'Zuid West');
INSERT INTO buurt (code, naam) VALUES (3990501, 'Akkerbuurt');
INSERT INTO buurt (code, naam) VALUES (3990502, 'Oud Zuid');
INSERT INTO buurt (code, naam) VALUES (3990503, 'Vennewater');
INSERT INTO buurt (code, naam) VALUES (3990504, 'Zuiderloo');
INSERT INTO buurt (code, naam) VALUES (3990601, 'Willibrord');
INSERT INTO buurt (code, naam) VALUES (3990602, 'Oude Werf');
INSERT INTO buurt (code, naam) VALUES (3990603, 'Zuid Oost');
INSERT INTO buurt (code, naam) VALUES (3990604, 'Oosterzij');
INSERT INTO buurt (code, naam) VALUES (3990701, 'Het Die');
INSERT INTO buurt (code, naam) VALUES (3990801, 'De Volkstuinen');
INSERT INTO buurt (code, naam) VALUES (3990802, 'Kapelbuurt');
INSERT INTO buurt (code, naam) VALUES (4000100, 'Marinehaven');
INSERT INTO buurt (code, naam) VALUES (4000101, 'Oostsloot');
INSERT INTO buurt (code, naam) VALUES (4000102, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (4000103, 'Willemsoord');
INSERT INTO buurt (code, naam) VALUES (4000104, 'Sluisdijk');
INSERT INTO buurt (code, naam) VALUES (4000105, 'Visbuurt');
INSERT INTO buurt (code, naam) VALUES (4000106, 'Grachtengordel');
INSERT INTO buurt (code, naam) VALUES (4000107, 'Havenbuurt');
INSERT INTO buurt (code, naam) VALUES (4000108, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (4000109, 'Mijnendienst');
INSERT INTO buurt (code, naam) VALUES (4000200, 'Oud Den Helder');
INSERT INTO buurt (code, naam) VALUES (4000201, 'Van Galenbuurt');
INSERT INTO buurt (code, naam) VALUES (4000202, 'Indische buurt-Noord');
INSERT INTO buurt (code, naam) VALUES (4000203, 'Indische buurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (4000204, 'Geleerdenbuurt');
INSERT INTO buurt (code, naam) VALUES (4000205, 'Tuindorp-West');
INSERT INTO buurt (code, naam) VALUES (4000206, 'Tuindorp-Oost');
INSERT INTO buurt (code, naam) VALUES (4000207, 'Fort Erfprins');
INSERT INTO buurt (code, naam) VALUES (4000208, 'Fort Dirksz Admiraal');
INSERT INTO buurt (code, naam) VALUES (4000300, 'Huisduinen');
INSERT INTO buurt (code, naam) VALUES (4000301, 'Liniebuurt');
INSERT INTO buurt (code, naam) VALUES (4000302, 'Jeruzalem');
INSERT INTO buurt (code, naam) VALUES (4000303, 'Duinbuurt');
INSERT INTO buurt (code, naam) VALUES (4000304, 'Donkere Duinen');
INSERT INTO buurt (code, naam) VALUES (4000400, 'Nieuwlandbuurt');
INSERT INTO buurt (code, naam) VALUES (4000401, 'Golfstroombuurt');
INSERT INTO buurt (code, naam) VALUES (4000402, 'Grote Rivierenbuurt');
INSERT INTO buurt (code, naam) VALUES (4000403, 'Kleine Rivierenbuurt');
INSERT INTO buurt (code, naam) VALUES (4000404, 'Deltabuurt');
INSERT INTO buurt (code, naam) VALUES (4000405, 'Falga');
INSERT INTO buurt (code, naam) VALUES (4000406, 'Zuiderzeebuurt');
INSERT INTO buurt (code, naam) VALUES (4000407, 'Schepenbuurt');
INSERT INTO buurt (code, naam) VALUES (4000408, 'Nieuw Den Helder Zuid-Oost');
INSERT INTO buurt (code, naam) VALUES (4000409, 'Dirksz Admiraal');
INSERT INTO buurt (code, naam) VALUES (4000500, 'Westoever');
INSERT INTO buurt (code, naam) VALUES (4000501, 'Marina');
INSERT INTO buurt (code, naam) VALUES (4000502, 'Schouten en Schepenenbuurt');
INSERT INTO buurt (code, naam) VALUES (4000503, 'Walvisvaarderbuurt');
INSERT INTO buurt (code, naam) VALUES (4000504, 'Zeeloodsenbuurt');
INSERT INTO buurt (code, naam) VALUES (4000505, 'Boerderijbuurt');
INSERT INTO buurt (code, naam) VALUES (4000506, 'Schooten-Centrum');
INSERT INTO buurt (code, naam) VALUES (4000507, 'Landmetersbuurt');
INSERT INTO buurt (code, naam) VALUES (4000508, 'Waterkeringsbuurt');
INSERT INTO buurt (code, naam) VALUES (4000509, 'Guldemond');
INSERT INTO buurt (code, naam) VALUES (4000600, 'Julianadorp-Oost');
INSERT INTO buurt (code, naam) VALUES (4000601, 'Oostoever');
INSERT INTO buurt (code, naam) VALUES (4000602, 'Friesebuurt');
INSERT INTO buurt (code, naam) VALUES (4000603, 'Kooypunt');
INSERT INTO buurt (code, naam) VALUES (4000604, 'Koegras-Noord');
INSERT INTO buurt (code, naam) VALUES (4000605, 'Blauwe Keet');
INSERT INTO buurt (code, naam) VALUES (4000606, 'Koegras-Zuid');
INSERT INTO buurt (code, naam) VALUES (4000607, 'De Kooy');
INSERT INTO buurt (code, naam) VALUES (4000700, 'Mariëndal');
INSERT INTO buurt (code, naam) VALUES (4000701, 'De Zandloper');
INSERT INTO buurt (code, naam) VALUES (4000702, 'Ooghduyne');
INSERT INTO buurt (code, naam) VALUES (4000800, 'Julianadorp-West');
INSERT INTO buurt (code, naam) VALUES (4000801, 'Middelzand');
INSERT INTO buurt (code, naam) VALUES (4000802, 'Vogelzand');
INSERT INTO buurt (code, naam) VALUES (4000803, 'Doorzwin');
INSERT INTO buurt (code, naam) VALUES (4000804, 'Kruiszwin');
INSERT INTO buurt (code, naam) VALUES (4000805, 'Wierbalg');
INSERT INTO buurt (code, naam) VALUES (4000806, 'Malzwin');
INSERT INTO buurt (code, naam) VALUES (4000807, 'Boterzwin');
INSERT INTO buurt (code, naam) VALUES (4000808, 'Zwanenbalg');
INSERT INTO buurt (code, naam) VALUES (4000809, 'Noorderhaven');
INSERT INTO buurt (code, naam) VALUES (4009998, '');
INSERT INTO buurt (code, naam) VALUES (4020101, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (4020102, 'Havenstraatbuurt');
INSERT INTO buurt (code, naam) VALUES (4020103, 'Sint Vitusbuurt');
INSERT INTO buurt (code, naam) VALUES (4020104, 'Langgewenstbuurt');
INSERT INTO buurt (code, naam) VALUES (4020201, 'Boomberg');
INSERT INTO buurt (code, naam) VALUES (4020202, 'Raadhuiskwartier');
INSERT INTO buurt (code, naam) VALUES (4020203, 'Trompenberg-Zuid');
INSERT INTO buurt (code, naam) VALUES (4020204, 'Villaparken');
INSERT INTO buurt (code, naam) VALUES (4020205, 'Trompenberg-Noord');
INSERT INTO buurt (code, naam) VALUES (4020206, 'Mediapark');
INSERT INTO buurt (code, naam) VALUES (4020301, 'Havenkwartier');
INSERT INTO buurt (code, naam) VALUES (4020302, 'Het Rode Dorp');
INSERT INTO buurt (code, naam) VALUES (4020303, 'Zeverijn');
INSERT INTO buurt (code, naam) VALUES (4020304, 'Kerkelanden');
INSERT INTO buurt (code, naam) VALUES (4020401, 'Bloemenkwartier Noord');
INSERT INTO buurt (code, naam) VALUES (4020402, 'Bloemenkwartier Zuid');
INSERT INTO buurt (code, naam) VALUES (4020403, 'Schrijverskwartier');
INSERT INTO buurt (code, naam) VALUES (4020404, 'Staatsliedenkwartier');
INSERT INTO buurt (code, naam) VALUES (4020405, 'Zeeheldenkwartier');
INSERT INTO buurt (code, naam) VALUES (4020501, 'Schilderskwartier');
INSERT INTO buurt (code, naam) VALUES (4020502, '''t Hoogt van ''t Kruis');
INSERT INTO buurt (code, naam) VALUES (4020503, 'Arenaparkkwartier');
INSERT INTO buurt (code, naam) VALUES (4020504, 'West-Indiëkwartier');
INSERT INTO buurt (code, naam) VALUES (4020505, 'Van Riebeeckkwartier');
INSERT INTO buurt (code, naam) VALUES (4020506, 'Egelshoek');
INSERT INTO buurt (code, naam) VALUES (4020601, 'Geuzenbuurt');
INSERT INTO buurt (code, naam) VALUES (4020602, 'Electrobuurt');
INSERT INTO buurt (code, naam) VALUES (4020603, 'Kleine Driftbuurt');
INSERT INTO buurt (code, naam) VALUES (4020604, 'Liebergen');
INSERT INTO buurt (code, naam) VALUES (4020605, 'Astronomischebuurt');
INSERT INTO buurt (code, naam) VALUES (4020701, 'Johannes Geradtswegbuurt');
INSERT INTO buurt (code, naam) VALUES (4020702, 'Erfgooiersbuurt');
INSERT INTO buurt (code, naam) VALUES (4020703, 'Noord');
INSERT INTO buurt (code, naam) VALUES (4020704, 'AZC Crailo');
INSERT INTO buurt (code, naam) VALUES (4020801, 'Hilversumse Meent');
INSERT INTO buurt (code, naam) VALUES (4020901, 'Landelijk gebied 91');
INSERT INTO buurt (code, naam) VALUES (4020902, 'Landelijk gebied 92');
INSERT INTO buurt (code, naam) VALUES (4020903, 'Landelijk gebied 93');
INSERT INTO buurt (code, naam) VALUES (4020904, 'Landelijk gebied 94');
INSERT INTO buurt (code, naam) VALUES (4020905, 'Landelijk gebied 95');
INSERT INTO buurt (code, naam) VALUES (4020906, 'Landelijk gebied 96');
INSERT INTO buurt (code, naam) VALUES (4020907, 'Landelijk gebied 97');
INSERT INTO buurt (code, naam) VALUES (4051000, 'Binnenstad - Buurt 10 00');
INSERT INTO buurt (code, naam) VALUES (4051001, 'Binnenstad - Buurt 10 01');
INSERT INTO buurt (code, naam) VALUES (4051002, 'Binnenstad - Buurt 10 02');
INSERT INTO buurt (code, naam) VALUES (4051003, 'Binnenstad - Buurt 10 03');
INSERT INTO buurt (code, naam) VALUES (4051100, 'Venelaankwartier - Buurt 11 00');
INSERT INTO buurt (code, naam) VALUES (4051101, 'Venelaankwartier - Buurt 11 01');
INSERT INTO buurt (code, naam) VALUES (4051102, 'Venelaankwartier - Buurt 11 02');
INSERT INTO buurt (code, naam) VALUES (4051103, 'Venelaankwartier - Buurt 11 03');
INSERT INTO buurt (code, naam) VALUES (4051200, 'Hoorn Noord - Buurt 12 00');
INSERT INTO buurt (code, naam) VALUES (4051201, 'Hoorn Noord - Buurt 12 01');
INSERT INTO buurt (code, naam) VALUES (4051202, 'Hoorn Noord - Buurt 12 02');
INSERT INTO buurt (code, naam) VALUES (4051203, 'Hoorn Noord - Buurt 12 03');
INSERT INTO buurt (code, naam) VALUES (4051204, 'Hoorn Noord - Buurt 12 04');
INSERT INTO buurt (code, naam) VALUES (4051300, 'Grote Waal - Buurt 13 00');
INSERT INTO buurt (code, naam) VALUES (4051301, 'Grote Waal - Buurt 13 01');
INSERT INTO buurt (code, naam) VALUES (4051302, 'Grote Waal - Buurt 13 02');
INSERT INTO buurt (code, naam) VALUES (4051303, 'Grote Waal - Buurt 13 03');
INSERT INTO buurt (code, naam) VALUES (4051304, 'Grote Waal - Buurt 13 04');
INSERT INTO buurt (code, naam) VALUES (4051305, 'Grote Waal - Buurt 13 05');
INSERT INTO buurt (code, naam) VALUES (4051306, 'Grote Waal - Buurt 13 06');
INSERT INTO buurt (code, naam) VALUES (4051307, 'Grote Waal - Buurt 13 07');
INSERT INTO buurt (code, naam) VALUES (4051308, 'Grote Waal - Buurt 13 08');
INSERT INTO buurt (code, naam) VALUES (4052000, 'Risdam-Zuid - Buurt 20 00');
INSERT INTO buurt (code, naam) VALUES (4052001, 'Risdam-Zuid - Buurt 20 01');
INSERT INTO buurt (code, naam) VALUES (4052002, 'Risdam-Zuid - Buurt 20 02');
INSERT INTO buurt (code, naam) VALUES (4052003, 'Risdam-Zuid - Buurt 20 03');
INSERT INTO buurt (code, naam) VALUES (4052004, 'Risdam-Zuid - Buurt 20 04');
INSERT INTO buurt (code, naam) VALUES (4052005, 'Risdam-Zuid - Buurt 20 05');
INSERT INTO buurt (code, naam) VALUES (4052006, 'Risdam-Zuid - Buurt 20 06');
INSERT INTO buurt (code, naam) VALUES (4052007, 'Risdam-Zuid - Buurt 20 07');
INSERT INTO buurt (code, naam) VALUES (4052008, 'Risdam-Zuid - Buurt 20 08');
INSERT INTO buurt (code, naam) VALUES (4052100, 'Risdam-Noord - Buurt 21 00');
INSERT INTO buurt (code, naam) VALUES (4052101, 'Risdam-Noord - Buurt 21 01');
INSERT INTO buurt (code, naam) VALUES (4052102, 'Risdam-Noord - Buurt 21 02');
INSERT INTO buurt (code, naam) VALUES (4052103, 'Risdam-Noord - Buurt 21 03');
INSERT INTO buurt (code, naam) VALUES (4052104, 'Risdam-Noord - Buurt 21 04');
INSERT INTO buurt (code, naam) VALUES (4052105, 'Risdam-Noord - Buurt 21 05');
INSERT INTO buurt (code, naam) VALUES (4052200, 'Nieuwe Steen - Buurt 22 00');
INSERT INTO buurt (code, naam) VALUES (4052201, 'Nieuwe Steen - Buurt 22 01');
INSERT INTO buurt (code, naam) VALUES (4053000, 'Zwaag - Buurt 30 00');
INSERT INTO buurt (code, naam) VALUES (4053001, 'Zwaag - Buurt 30 01');
INSERT INTO buurt (code, naam) VALUES (4053002, 'Zwaag - Buurt 30 02');
INSERT INTO buurt (code, naam) VALUES (4053004, 'Zwaag - Buurt 30 04');
INSERT INTO buurt (code, naam) VALUES (4053005, 'Zwaag - Buurt 30 05');
INSERT INTO buurt (code, naam) VALUES (4053006, 'Zwaag - Buurt 30 06');
INSERT INTO buurt (code, naam) VALUES (4053100, 'Blokker - Buurt 31 00');
INSERT INTO buurt (code, naam) VALUES (4053101, 'Blokker - Buurt 31 01');
INSERT INTO buurt (code, naam) VALUES (4053102, 'Blokker - Buurt 31 02');
INSERT INTO buurt (code, naam) VALUES (4053103, 'Blokker - Buurt 31 03');
INSERT INTO buurt (code, naam) VALUES (4053104, 'Blokker - Buurt 31 04');
INSERT INTO buurt (code, naam) VALUES (4053200, 'Kersenboogerd-Noord - Buurt 32 00');
INSERT INTO buurt (code, naam) VALUES (4053201, 'Kersenboogerd-Noord - Buurt 32 01');
INSERT INTO buurt (code, naam) VALUES (4053202, 'Kersenboogerd-Noord - Buurt 32 02');
INSERT INTO buurt (code, naam) VALUES (4053203, 'Kersenboogerd-Noord - Buurt 32 03');
INSERT INTO buurt (code, naam) VALUES (4053300, 'Kersenboogerd-Zuid - Buurt 33 00');
INSERT INTO buurt (code, naam) VALUES (4053301, 'Kersenboogerd-Zuid - Buurt 33 01');
INSERT INTO buurt (code, naam) VALUES (4053302, 'Kersenboogerd-Zuid - Buurt 33 02');
INSERT INTO buurt (code, naam) VALUES (4053303, 'Kersenboogerd-Zuid - Buurt 33 03');
INSERT INTO buurt (code, naam) VALUES (4053304, 'Kersenboogerd-Zuid - Buurt 33 04');
INSERT INTO buurt (code, naam) VALUES (4053305, 'Kersenboogerd-Zuid - Buurt 33 05');
INSERT INTO buurt (code, naam) VALUES (4053306, 'Kersenboogerd-Zuid - Buurt 33 06');
INSERT INTO buurt (code, naam) VALUES (4053307, 'Kersenboogerd-Zuid - Buurt 33 07');
INSERT INTO buurt (code, naam) VALUES (4053308, 'Kersenboogerd-Zuid - Buurt 33 08');
INSERT INTO buurt (code, naam) VALUES (4053309, 'Kersenboogerd-Zuid - Buurt 33 09');
INSERT INTO buurt (code, naam) VALUES (4053400, 'Hoorn 80 - Buurt 34 00');
INSERT INTO buurt (code, naam) VALUES (4053401, 'Hoorn 80 - Buurt 34 01');
INSERT INTO buurt (code, naam) VALUES (4053402, 'Hoorn 80 - Buurt 34 02');
INSERT INTO buurt (code, naam) VALUES (4053501, 'Bangert en Oosterpolder - Buurt 35 01');
INSERT INTO buurt (code, naam) VALUES (4053502, 'Bangert en Oosterpolder - Buurt 35 02');
INSERT INTO buurt (code, naam) VALUES (4053503, 'Bangert en Oosterpolder - Buurt 35 03');
INSERT INTO buurt (code, naam) VALUES (4053504, 'Bangert en Oosterpolder - Buurt 35 04');
INSERT INTO buurt (code, naam) VALUES (4053505, 'Bangert en Oosterpolder - Buurt 35 05');
INSERT INTO buurt (code, naam) VALUES (4053506, 'Bangert en Oosterpolder - Buurt 35 06');
INSERT INTO buurt (code, naam) VALUES (4053600, 'Zevenhuis - Buurt 36 00');
INSERT INTO buurt (code, naam) VALUES (4059997, '');
INSERT INTO buurt (code, naam) VALUES (4060001, 'De Noord');
INSERT INTO buurt (code, naam) VALUES (4060002, 'De Zuid');
INSERT INTO buurt (code, naam) VALUES (4060103, 'Westereng');
INSERT INTO buurt (code, naam) VALUES (4060204, 'Flevo');
INSERT INTO buurt (code, naam) VALUES (4060205, 'Bikbergen');
INSERT INTO buurt (code, naam) VALUES (4060206, 'Crailo');
INSERT INTO buurt (code, naam) VALUES (4060307, 'Thames');
INSERT INTO buurt (code, naam) VALUES (4060308, 'IJzeren veld');
INSERT INTO buurt (code, naam) VALUES (4060327, 'Parrewijn');
INSERT INTO buurt (code, naam) VALUES (4060328, 'Tafelberger Heide');
INSERT INTO buurt (code, naam) VALUES (4060329, 'Rijsbergen');
INSERT INTO buurt (code, naam) VALUES (4060330, 'Huizerhoogt');
INSERT INTO buurt (code, naam) VALUES (4060409, 'Sijsjesberg');
INSERT INTO buurt (code, naam) VALUES (4060410, 'Zuidereng');
INSERT INTO buurt (code, naam) VALUES (4060511, 'Gooierhoofd');
INSERT INTO buurt (code, naam) VALUES (4060512, 'Wolfskamer');
INSERT INTO buurt (code, naam) VALUES (4060513, 'Industriewijk ''t Plaveen');
INSERT INTO buurt (code, naam) VALUES (4060614, 'Bovenweg');
INSERT INTO buurt (code, naam) VALUES (4060615, 'Zenderwijk');
INSERT INTO buurt (code, naam) VALUES (4060716, 'Stad en Lande');
INSERT INTO buurt (code, naam) VALUES (4060817, 'Huizermaat West');
INSERT INTO buurt (code, naam) VALUES (4060818, 'Huizermaat Zuid');
INSERT INTO buurt (code, naam) VALUES (4060919, 'Huizermaat Noord');
INSERT INTO buurt (code, naam) VALUES (4061020, 'Bijvanck Noord');
INSERT INTO buurt (code, naam) VALUES (4061021, 'Bijvanck West');
INSERT INTO buurt (code, naam) VALUES (4061123, 'Bovenmaat Noord');
INSERT INTO buurt (code, naam) VALUES (4061124, 'Bovenmaat West');
INSERT INTO buurt (code, naam) VALUES (4061125, 'Bovenmaat-Oost');
INSERT INTO buurt (code, naam) VALUES (4061226, 'Filosofenbuurt');
INSERT INTO buurt (code, naam) VALUES (4061231, 'De Tuit');
INSERT INTO buurt (code, naam) VALUES (4069997, '');
INSERT INTO buurt (code, naam) VALUES (4150000, 'Landsmeer');
INSERT INTO buurt (code, naam) VALUES (4150001, 'Plan Centrum-Noord');
INSERT INTO buurt (code, naam) VALUES (4150002, 'Plan Centrum-Zuid');
INSERT INTO buurt (code, naam) VALUES (4150003, 'Plan Centrum-West');
INSERT INTO buurt (code, naam) VALUES (4150009, 'Verspreide huizen ten oosten van Landsmeer');
INSERT INTO buurt (code, naam) VALUES (4150101, 'Purmerland');
INSERT INTO buurt (code, naam) VALUES (4150102, 'Den Ilp');
INSERT INTO buurt (code, naam) VALUES (4160000, 'Oudkarspel');
INSERT INTO buurt (code, naam) VALUES (4160001, 'Noord-Scharwoude');
INSERT INTO buurt (code, naam) VALUES (4160002, 'Zuid-Scharwoude');
INSERT INTO buurt (code, naam) VALUES (4160003, 'Broek op Langedijk');
INSERT INTO buurt (code, naam) VALUES (4160004, 'Laanweg en Waarddijk');
INSERT INTO buurt (code, naam) VALUES (4160005, 'Sint Pancras');
INSERT INTO buurt (code, naam) VALUES (4160006, 'Koedijk');
INSERT INTO buurt (code, naam) VALUES (4170000, 'Laren-Dorpskern');
INSERT INTO buurt (code, naam) VALUES (4170001, 'Laren-Zevenend');
INSERT INTO buurt (code, naam) VALUES (4170002, 'Laren-Oostereng');
INSERT INTO buurt (code, naam) VALUES (4170003, 'Laren-Steenbergen');
INSERT INTO buurt (code, naam) VALUES (4170004, 'Laren-Zwarte Berg');
INSERT INTO buurt (code, naam) VALUES (4170005, 'Laren-Omloop');
INSERT INTO buurt (code, naam) VALUES (4170006, 'Laren-Rijksweg');
INSERT INTO buurt (code, naam) VALUES (4170007, 'Laren-Natuurgebied');
INSERT INTO buurt (code, naam) VALUES (4200000, 'Oude Stad');
INSERT INTO buurt (code, naam) VALUES (4200001, 'Koggenwijk');
INSERT INTO buurt (code, naam) VALUES (4200002, 'Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (4200003, 'Randwijk en Gildewijk');
INSERT INTO buurt (code, naam) VALUES (4200004, 'Vlietwijk');
INSERT INTO buurt (code, naam) VALUES (4200009, 'Brake');
INSERT INTO buurt (code, naam) VALUES (4200100, 'Centrum Wognum');
INSERT INTO buurt (code, naam) VALUES (4200101, 'Oosteinde');
INSERT INTO buurt (code, naam) VALUES (4200102, 'Wadway (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (4200109, 'Verspreide huizen langs Zomerdijk');
INSERT INTO buurt (code, naam) VALUES (4200200, 'Nibbixwoud en Wijzend');
INSERT INTO buurt (code, naam) VALUES (4200300, 'Zwaagdijk-West');
INSERT INTO buurt (code, naam) VALUES (4200400, 'Midwoud');
INSERT INTO buurt (code, naam) VALUES (4200401, 'Oostwoud');
INSERT INTO buurt (code, naam) VALUES (4200500, 'Sijbekarspel');
INSERT INTO buurt (code, naam) VALUES (4200501, 'Benningbroek-West');
INSERT INTO buurt (code, naam) VALUES (4200502, 'Benningbroek-Oost');
INSERT INTO buurt (code, naam) VALUES (4200600, 'Hauwert');
INSERT INTO buurt (code, naam) VALUES (4200700, 'Twisk');
INSERT INTO buurt (code, naam) VALUES (4200800, 'Opperdoes');
INSERT INTO buurt (code, naam) VALUES (4200900, 'Abbekerk');
INSERT INTO buurt (code, naam) VALUES (4200901, 'Lambertschaag');
INSERT INTO buurt (code, naam) VALUES (4201000, 'Centrum Andijk');
INSERT INTO buurt (code, naam) VALUES (4201001, 'Midden');
INSERT INTO buurt (code, naam) VALUES (4201002, 'Oost');
INSERT INTO buurt (code, naam) VALUES (4201003, 'Bangert');
INSERT INTO buurt (code, naam) VALUES (4201100, 'Centrum (West) Wervershoof');
INSERT INTO buurt (code, naam) VALUES (4201101, 'Onderdijk');
INSERT INTO buurt (code, naam) VALUES (4201102, 'Centrum (Oost) wervershoof');
INSERT INTO buurt (code, naam) VALUES (4201103, 'Driehuizen');
INSERT INTO buurt (code, naam) VALUES (4201200, 'Zwaagdijk-Oost');
INSERT INTO buurt (code, naam) VALUES (4209997, '');
INSERT INTO buurt (code, naam) VALUES (4240000, 'Vesting Muiden');
INSERT INTO buurt (code, naam) VALUES (4240001, 'Nieuw Muiden');
INSERT INTO buurt (code, naam) VALUES (4240002, 'Muiderberg');
INSERT INTO buurt (code, naam) VALUES (4240003, 'Mariahoeve Muiden');
INSERT INTO buurt (code, naam) VALUES (4240004, 'Buitendijken Muiderberg');
INSERT INTO buurt (code, naam) VALUES (4240008, 'Verspreide huizen ten westen van de Vecht');
INSERT INTO buurt (code, naam) VALUES (4240009, 'Verspreide huizen ten oosten van de Vecht');
INSERT INTO buurt (code, naam) VALUES (4249997, '');
INSERT INTO buurt (code, naam) VALUES (4250001, 'Naarden Vesting');
INSERT INTO buurt (code, naam) VALUES (4250002, 'Tuindorp Keverdijk');
INSERT INTO buurt (code, naam) VALUES (4250003, 'Naarderbos');
INSERT INTO buurt (code, naam) VALUES (4250004, 'Industriepark Naarden');
INSERT INTO buurt (code, naam) VALUES (4250006, 'Oranje Nassaupark Noord');
INSERT INTO buurt (code, naam) VALUES (4250007, 'Oranje Nassaupark Zuid');
INSERT INTO buurt (code, naam) VALUES (4250008, 'Ministerpark');
INSERT INTO buurt (code, naam) VALUES (4250009, 'Beethovenpark');
INSERT INTO buurt (code, naam) VALUES (4250010, 'Rembrandtpark');
INSERT INTO buurt (code, naam) VALUES (4250011, 'Bos van Bredius');
INSERT INTO buurt (code, naam) VALUES (4250012, 'Valkeveen');
INSERT INTO buurt (code, naam) VALUES (4250013, 'Naardermeer');
INSERT INTO buurt (code, naam) VALUES (4250055, 'Bedrijvenpark Gooimeer');
INSERT INTO buurt (code, naam) VALUES (4250065, 'Vierhoven');
INSERT INTO buurt (code, naam) VALUES (4250085, 'Zuid-West III');
INSERT INTO buurt (code, naam) VALUES (4259997, '');
INSERT INTO buurt (code, naam) VALUES (4310000, 'Kerkbuurt');
INSERT INTO buurt (code, naam) VALUES (4310001, 'Zuideinde');
INSERT INTO buurt (code, naam) VALUES (4310002, 'Kerkstraat');
INSERT INTO buurt (code, naam) VALUES (4310003, 'De Haal en De Heul en Noordeinde');
INSERT INTO buurt (code, naam) VALUES (4320000, 'Opmeer-Noord');
INSERT INTO buurt (code, naam) VALUES (4320001, 'Opmeer-Zuid, Spanbroek (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (4320002, 'Zandwerven en Lutkedijk');
INSERT INTO buurt (code, naam) VALUES (4320003, 'Wadway');
INSERT INTO buurt (code, naam) VALUES (4320007, 'Verspreide huizen in De Kaag');
INSERT INTO buurt (code, naam) VALUES (4320009, 'Overige verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (4320100, 'Hoogwoud');
INSERT INTO buurt (code, naam) VALUES (4320101, 'Aartswoud');
INSERT INTO buurt (code, naam) VALUES (4320102, 'Langereis (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (4320103, 'Gouwe');
INSERT INTO buurt (code, naam) VALUES (4320200, 'De Weere');
INSERT INTO buurt (code, naam) VALUES (4370000, 'Ouderkerk aan de Amstel');
INSERT INTO buurt (code, naam) VALUES (4370001, 'Duivendrecht');
INSERT INTO buurt (code, naam) VALUES (4370002, 'Industriegebied Amstel');
INSERT INTO buurt (code, naam) VALUES (4370006, 'Verspreide huizen in de Rondehoeppolder');
INSERT INTO buurt (code, naam) VALUES (4370007, 'Verspreide huizen in de Duivendrechtsche polder');
INSERT INTO buurt (code, naam) VALUES (4370008, 'Verspreide huizen in de Bullewijker polder');
INSERT INTO buurt (code, naam) VALUES (4370009, 'Verspreide huizen langs De Bullewijk en De Hole');
INSERT INTO buurt (code, naam) VALUES (4390101, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (4390102, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (4390103, 'Zuiderpolder');
INSERT INTO buurt (code, naam) VALUES (4390201, 'Overwhere-Zuid');
INSERT INTO buurt (code, naam) VALUES (4390202, 'De Koog');
INSERT INTO buurt (code, naam) VALUES (4390203, 'Wagenweg');
INSERT INTO buurt (code, naam) VALUES (4390204, 'Overwhere-Noord');
INSERT INTO buurt (code, naam) VALUES (4390205, 'Molenkoog');
INSERT INTO buurt (code, naam) VALUES (4390301, 'Wheermolen-West');
INSERT INTO buurt (code, naam) VALUES (4390302, 'Wheermolen-Oost');
INSERT INTO buurt (code, naam) VALUES (4390303, 'Dwarsgouw');
INSERT INTO buurt (code, naam) VALUES (4390401, 'Gors-Zuid');
INSERT INTO buurt (code, naam) VALUES (4390402, 'Gors-Noord');
INSERT INTO buurt (code, naam) VALUES (4390501, 'Overlanderstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (4390502, 'Werktuigenbuurt');
INSERT INTO buurt (code, naam) VALUES (4390503, 'Maten- en Zuivelbuurt');
INSERT INTO buurt (code, naam) VALUES (4390504, 'De Graeffweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (4390505, 'Baanstee en omgeving');
INSERT INTO buurt (code, naam) VALUES (4390506, 'Golfterrein en verspreide bebouwing');
INSERT INTO buurt (code, naam) VALUES (4390601, 'Purmer-Zuid/Noord');
INSERT INTO buurt (code, naam) VALUES (4390602, 'Purmer-Zuid/Zuid');
INSERT INTO buurt (code, naam) VALUES (4390603, 'Purmerbos en verspreide bebouwing');
INSERT INTO buurt (code, naam) VALUES (4390701, 'Hazepolder');
INSERT INTO buurt (code, naam) VALUES (4390702, 'Azië');
INSERT INTO buurt (code, naam) VALUES (4390703, 'Amerika');
INSERT INTO buurt (code, naam) VALUES (4390704, 'Afrika');
INSERT INTO buurt (code, naam) VALUES (4390705, 'Europa');
INSERT INTO buurt (code, naam) VALUES (4410000, 'Schagen');
INSERT INTO buurt (code, naam) VALUES (4410001, 'Nesdijk');
INSERT INTO buurt (code, naam) VALUES (4410002, 'Groeneweg');
INSERT INTO buurt (code, naam) VALUES (4410003, 'Waldervaart-Noord');
INSERT INTO buurt (code, naam) VALUES (4410004, 'Waldervaart-Zuid');
INSERT INTO buurt (code, naam) VALUES (4410005, 'Muggenburg');
INSERT INTO buurt (code, naam) VALUES (4410006, 'Verspreide huizen ten oosten van Schagen');
INSERT INTO buurt (code, naam) VALUES (4410007, 'Verspreide huizen ten zuiden van Schagen');
INSERT INTO buurt (code, naam) VALUES (4410008, 'Verspreide huizen ten noorden van het kanaal Stolpen');
INSERT INTO buurt (code, naam) VALUES (4410009, 'Verspreide huizen ten westen van Schagen');
INSERT INTO buurt (code, naam) VALUES (4410101, 'Tuitjenhorn en Kerkbuurt');
INSERT INTO buurt (code, naam) VALUES (4410102, 'Dirkshorn');
INSERT INTO buurt (code, naam) VALUES (4410103, 'Landelijk gebied Dirkshorn');
INSERT INTO buurt (code, naam) VALUES (4410104, 'Landelijk gebied Waarland');
INSERT INTO buurt (code, naam) VALUES (4410105, 'Waarland');
INSERT INTO buurt (code, naam) VALUES (4410106, 'Kalverdijk');
INSERT INTO buurt (code, naam) VALUES (4410201, 'Sint Maarten');
INSERT INTO buurt (code, naam) VALUES (4410202, 'Stroet');
INSERT INTO buurt (code, naam) VALUES (4410203, 'Valkkoog');
INSERT INTO buurt (code, naam) VALUES (4410204, 'Eenigenburg');
INSERT INTO buurt (code, naam) VALUES (4410205, 'Verspreide huizen Rijpje');
INSERT INTO buurt (code, naam) VALUES (4410206, 'Verspreide huizen Groenveld');
INSERT INTO buurt (code, naam) VALUES (4410301, 'Warmenhuizen-West');
INSERT INTO buurt (code, naam) VALUES (4410302, 'Warmenhuizen-Oost');
INSERT INTO buurt (code, naam) VALUES (4410303, 'Schoorldam (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (4410304, 'Krabbendam');
INSERT INTO buurt (code, naam) VALUES (4410305, 'Rekerlanden');
INSERT INTO buurt (code, naam) VALUES (4410306, 'Landelijk gebied Warmenhuizen');
INSERT INTO buurt (code, naam) VALUES (4410401, 'Schagerbrug');
INSERT INTO buurt (code, naam) VALUES (4410402, 'Sint Maartensbrug');
INSERT INTO buurt (code, naam) VALUES (4410403, 'Burgerbrug');
INSERT INTO buurt (code, naam) VALUES (4410404, '''t Zand');
INSERT INTO buurt (code, naam) VALUES (4410405, 'Oudesluis');
INSERT INTO buurt (code, naam) VALUES (4410406, 'Petten');
INSERT INTO buurt (code, naam) VALUES (4410407, 'Callantsoog');
INSERT INTO buurt (code, naam) VALUES (4410408, 'Sint Maartensvlotbrug');
INSERT INTO buurt (code, naam) VALUES (4410409, 'Burgervlotbrug');
INSERT INTO buurt (code, naam) VALUES (4419998, '');
INSERT INTO buurt (code, naam) VALUES (4480000, 'Den Burg');
INSERT INTO buurt (code, naam) VALUES (4480001, 'De Koog');
INSERT INTO buurt (code, naam) VALUES (4480002, 'Oosterend');
INSERT INTO buurt (code, naam) VALUES (4480003, 'De Waal');
INSERT INTO buurt (code, naam) VALUES (4480004, 'Oudeschild');
INSERT INTO buurt (code, naam) VALUES (4480005, 'Den Hoorn');
INSERT INTO buurt (code, naam) VALUES (4480007, 'Verspreide huizen Op Het Oude Land');
INSERT INTO buurt (code, naam) VALUES (4480008, 'Verspreide huizen De Kuil, Hoornder Nieuwland');
INSERT INTO buurt (code, naam) VALUES (4480009, 'Verspreide huizen De Koog en het Duingebied');
INSERT INTO buurt (code, naam) VALUES (4480100, 'De Cocksdorp');
INSERT INTO buurt (code, naam) VALUES (4480107, 'Verspreide huizen in de polders Eierland en Eendracht');
INSERT INTO buurt (code, naam) VALUES (4480108, 'Verspreide huizen in de polder Het Noorden');
INSERT INTO buurt (code, naam) VALUES (4480109, 'Verspreide huizen in de polders Burger Nieuwland');
INSERT INTO buurt (code, naam) VALUES (4489998, '');
INSERT INTO buurt (code, naam) VALUES (4500001, 'De Koog');
INSERT INTO buurt (code, naam) VALUES (4500002, 'De Kleis');
INSERT INTO buurt (code, naam) VALUES (4500003, 'Waldijk');
INSERT INTO buurt (code, naam) VALUES (4500004, 'Oude Dorp');
INSERT INTO buurt (code, naam) VALUES (4500005, 'Bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (4500006, 'Buitengebied');
INSERT INTO buurt (code, naam) VALUES (4511500, 'Dorpscentrumcentrum');
INSERT INTO buurt (code, naam) VALUES (4512500, 'Thamerdal');
INSERT INTO buurt (code, naam) VALUES (4513500, 'Zijdelwaard');
INSERT INTO buurt (code, naam) VALUES (4514500, 'Legmeer');
INSERT INTO buurt (code, naam) VALUES (4515000, 'Langs de Vuurlinie');
INSERT INTO buurt (code, naam) VALUES (4515500, 'Veilinggebied');
INSERT INTO buurt (code, naam) VALUES (4516500, 'Meerwijk');
INSERT INTO buurt (code, naam) VALUES (4517500, 'Bedrijventerrein');
INSERT INTO buurt (code, naam) VALUES (4518500, 'Meerwijk');
INSERT INTO buurt (code, naam) VALUES (4519000, 'Glastuinbouwgebied');
INSERT INTO buurt (code, naam) VALUES (4519500, 'Veenweidegebied');
INSERT INTO buurt (code, naam) VALUES (4530000, 'Velsen-Dorp');
INSERT INTO buurt (code, naam) VALUES (4530001, 'Velserbeek');
INSERT INTO buurt (code, naam) VALUES (4530002, 'Velsen-Oost');
INSERT INTO buurt (code, naam) VALUES (4530003, 'Kapelbuurt');
INSERT INTO buurt (code, naam) VALUES (4530004, 'Kriemhildebuurt');
INSERT INTO buurt (code, naam) VALUES (4530005, 'Driehuis-Dorp');
INSERT INTO buurt (code, naam) VALUES (4530100, 'Lagersbuurt');
INSERT INTO buurt (code, naam) VALUES (4530101, 'Heidebuurt');
INSERT INTO buurt (code, naam) VALUES (4530102, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (4530103, 'Verzetsheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (4530104, 'Natuurkundigenbuurt');
INSERT INTO buurt (code, naam) VALUES (4530105, 'Kikvorsbuurt');
INSERT INTO buurt (code, naam) VALUES (4530106, 'Stadhuisbuurt');
INSERT INTO buurt (code, naam) VALUES (4530200, 'Tussenbeeksbuurt');
INSERT INTO buurt (code, naam) VALUES (4530201, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (4530202, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (4530203, 'Velseroord');
INSERT INTO buurt (code, naam) VALUES (4530204, 'Paterskerkbuurt');
INSERT INTO buurt (code, naam) VALUES (4530205, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (4530206, 'Rivierenbuurt');
INSERT INTO buurt (code, naam) VALUES (4530300, 'Moerbergbuurt');
INSERT INTO buurt (code, naam) VALUES (4530301, 'Vissersbuurt');
INSERT INTO buurt (code, naam) VALUES (4530302, 'Oud-IJmuiden');
INSERT INTO buurt (code, naam) VALUES (4530303, 'Zuidzijdebuurt');
INSERT INTO buurt (code, naam) VALUES (4530400, 'Herculesbuurt');
INSERT INTO buurt (code, naam) VALUES (4530401, 'Canopusbuurt');
INSERT INTO buurt (code, naam) VALUES (4530402, 'Saturnusbuurt');
INSERT INTO buurt (code, naam) VALUES (4530403, 'Schiplaanbuurt');
INSERT INTO buurt (code, naam) VALUES (4530404, 'Bellatrixbuurt');
INSERT INTO buurt (code, naam) VALUES (4530405, 'Kruisbergbuurt');
INSERT INTO buurt (code, naam) VALUES (4530406, 'Keetbergbuurt');
INSERT INTO buurt (code, naam) VALUES (4530500, 'Gildenbuurt');
INSERT INTO buurt (code, naam) VALUES (4530501, 'Westerwijkbuurt');
INSERT INTO buurt (code, naam) VALUES (4530502, 'Van Gelderbuurt');
INSERT INTO buurt (code, naam) VALUES (4530503, 'Duinvlietbuurt');
INSERT INTO buurt (code, naam) VALUES (4530504, 'Watervlietbuurt');
INSERT INTO buurt (code, naam) VALUES (4530505, 'Wijkermeerbuurt');
INSERT INTO buurt (code, naam) VALUES (4530506, 'Staalbuurt');
INSERT INTO buurt (code, naam) VALUES (4530507, 'Reyndersbuurt');
INSERT INTO buurt (code, naam) VALUES (4530600, 'Kerkpadbuurt');
INSERT INTO buurt (code, naam) VALUES (4530601, 'Biezenbuurt');
INSERT INTO buurt (code, naam) VALUES (4530602, 'West-Indische buurt');
INSERT INTO buurt (code, naam) VALUES (4530603, 'Santpoort-Dorp');
INSERT INTO buurt (code, naam) VALUES (4530604, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (4530605, 'Kerkerinkbuurt');
INSERT INTO buurt (code, naam) VALUES (4530606, 'Spanjaardsbergbuurt');
INSERT INTO buurt (code, naam) VALUES (4530607, 'Santhaesbuurt');
INSERT INTO buurt (code, naam) VALUES (4530608, 'Duinenbuurt');
INSERT INTO buurt (code, naam) VALUES (4530700, 'Neethofbuurt');
INSERT INTO buurt (code, naam) VALUES (4530701, 'Rijkersparkbuurt');
INSERT INTO buurt (code, naam) VALUES (4530702, 'Blekersbuurt');
INSERT INTO buurt (code, naam) VALUES (4530703, 'Eltabuurt');
INSERT INTO buurt (code, naam) VALUES (4530800, 'Hofgeest');
INSERT INTO buurt (code, naam) VALUES (4530801, 'Maadbuurt');
INSERT INTO buurt (code, naam) VALUES (4530802, 'Weidbuurt');
INSERT INTO buurt (code, naam) VALUES (4530803, 'Pijlkruidbuurt');
INSERT INTO buurt (code, naam) VALUES (4530804, 'Florarondebuurt');
INSERT INTO buurt (code, naam) VALUES (4530805, 'Bastionbuurt');
INSERT INTO buurt (code, naam) VALUES (4530806, 'Springerbuurt');
INSERT INTO buurt (code, naam) VALUES (4530807, 'Tjotterbuurt');
INSERT INTO buurt (code, naam) VALUES (4530808, 'Westbroekbuurt');
INSERT INTO buurt (code, naam) VALUES (4530900, 'Noord-Spaarndammerpolder');
INSERT INTO buurt (code, naam) VALUES (4530901, 'Zuid-Spaarndammerpolder');
INSERT INTO buurt (code, naam) VALUES (4539998, '');
INSERT INTO buurt (code, naam) VALUES (4570000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (4570001, 'Plan Zuid');
INSERT INTO buurt (code, naam) VALUES (4570002, 'Plan Noord');
INSERT INTO buurt (code, naam) VALUES (4570003, 'Hogewey');
INSERT INTO buurt (code, naam) VALUES (4570004, 'Aetsveld');
INSERT INTO buurt (code, naam) VALUES (4570007, 'Verspreide huizen Aetsveldsepolder');
INSERT INTO buurt (code, naam) VALUES (4570008, 'Verspreide huizen oostelijke Vechtoever');
INSERT INTO buurt (code, naam) VALUES (4570009, 'Bloemendalerpolder');
INSERT INTO buurt (code, naam) VALUES (4580000, 'Oterleek');
INSERT INTO buurt (code, naam) VALUES (4580100, 'Schermerhorn');
INSERT INTO buurt (code, naam) VALUES (4580101, 'Schermerhorn-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (4580109, 'Verspreide huizen in de polder Mijzen');
INSERT INTO buurt (code, naam) VALUES (4580200, 'Grootschermer');
INSERT INTO buurt (code, naam) VALUES (4580201, 'Driehuizen');
INSERT INTO buurt (code, naam) VALUES (4580202, 'Zuidschermer');
INSERT INTO buurt (code, naam) VALUES (4580209, 'Verspreide huizen in de Noordeindermeerpolder');
INSERT INTO buurt (code, naam) VALUES (4580300, 'Stompetoren');
INSERT INTO buurt (code, naam) VALUES (4580301, 'Schermeer Schermerhorn');
INSERT INTO buurt (code, naam) VALUES (4580302, 'Schermeer Zuid- en Noord-Schermer');
INSERT INTO buurt (code, naam) VALUES (4580307, 'Verspreide huizen in de polder Schermeer');
INSERT INTO buurt (code, naam) VALUES (4580308, 'Oudorp en Omval');
INSERT INTO buurt (code, naam) VALUES (4580309, 'Verspreide huizen Lange Molenweg, Korte Molenweg');
INSERT INTO buurt (code, naam) VALUES (4730000, 'Zandvoort Oude Kern');
INSERT INTO buurt (code, naam) VALUES (4730001, 'Buurt ten noorden van busstation');
INSERT INTO buurt (code, naam) VALUES (4730002, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (4730003, 'Boulevard');
INSERT INTO buurt (code, naam) VALUES (4730004, 'Hogeweg-Haarlemmerstraat');
INSERT INTO buurt (code, naam) VALUES (4730005, 'Kostverloren');
INSERT INTO buurt (code, naam) VALUES (4730006, 'Letterkundigenbuurt');
INSERT INTO buurt (code, naam) VALUES (4730007, 'Plan Zuid');
INSERT INTO buurt (code, naam) VALUES (4730008, 'Vijverparkbuurt');
INSERT INTO buurt (code, naam) VALUES (4730009, 'Nieuw-Noord');
INSERT INTO buurt (code, naam) VALUES (4730100, 'Bentveld');
INSERT INTO buurt (code, naam) VALUES (4730109, 'Verspreide huizen in het duingebied');
INSERT INTO buurt (code, naam) VALUES (4739998, '');
INSERT INTO buurt (code, naam) VALUES (4780000, 'Beets');
INSERT INTO buurt (code, naam) VALUES (4780100, 'Oosthuizen');
INSERT INTO buurt (code, naam) VALUES (4780101, 'De Watering');
INSERT INTO buurt (code, naam) VALUES (4780200, 'Warder');
INSERT INTO buurt (code, naam) VALUES (4780300, 'Middelie');
INSERT INTO buurt (code, naam) VALUES (4780400, 'Kwadijk');
INSERT INTO buurt (code, naam) VALUES (4780500, 'Schardam');
INSERT INTO buurt (code, naam) VALUES (4780600, 'Hobrede');
INSERT INTO buurt (code, naam) VALUES (4789997, '');
INSERT INTO buurt (code, naam) VALUES (4791110, 'Achtersluispolder');
INSERT INTO buurt (code, naam) VALUES (4791120, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (4791130, 'Burgemeestersbuurt');
INSERT INTO buurt (code, naam) VALUES (4791210, 'Poelenburg');
INSERT INTO buurt (code, naam) VALUES (4791310, 'Peldersveld');
INSERT INTO buurt (code, naam) VALUES (4791320, 'Hoornseveld');
INSERT INTO buurt (code, naam) VALUES (4791410, 'Rosmolenbuurt');
INSERT INTO buurt (code, naam) VALUES (4791510, 'Kogerveld');
INSERT INTO buurt (code, naam) VALUES (4791520, 'Boerejonkerbuurt');
INSERT INTO buurt (code, naam) VALUES (4791610, 'Kalf');
INSERT INTO buurt (code, naam) VALUES (4791620, 'Kalverpolder');
INSERT INTO buurt (code, naam) VALUES (4792110, 'Havenbuurt');
INSERT INTO buurt (code, naam) VALUES (4792120, 'Zuiderhout');
INSERT INTO buurt (code, naam) VALUES (4792130, 'Het Eiland');
INSERT INTO buurt (code, naam) VALUES (4792140, 'Russische buurt');
INSERT INTO buurt (code, naam) VALUES (4792210, 'Oud West');
INSERT INTO buurt (code, naam) VALUES (4792220, 'Spoorbuurt');
INSERT INTO buurt (code, naam) VALUES (4792230, 'Schilders- en Waddenbuurt');
INSERT INTO buurt (code, naam) VALUES (4792310, 'Westerspoor');
INSERT INTO buurt (code, naam) VALUES (4792320, 'Westerwatering');
INSERT INTO buurt (code, naam) VALUES (4793110, 'Oud Koog');
INSERT INTO buurt (code, naam) VALUES (4793210, 'Westerkoog');
INSERT INTO buurt (code, naam) VALUES (4794110, 'Oud Zaandijk');
INSERT INTO buurt (code, naam) VALUES (4794210, 'Rooswijk');
INSERT INTO buurt (code, naam) VALUES (4794220, 'Rooswijk Noord');
INSERT INTO buurt (code, naam) VALUES (4795110, 'Wormerveer Zuid');
INSERT INTO buurt (code, naam) VALUES (4795120, 'Guisveld');
INSERT INTO buurt (code, naam) VALUES (4795130, 'Wormerveer Noord');
INSERT INTO buurt (code, naam) VALUES (4795140, 'Karnemelksepolder');
INSERT INTO buurt (code, naam) VALUES (4795150, 'Westknollendam');
INSERT INTO buurt (code, naam) VALUES (4795160, 'Industriebuurt');
INSERT INTO buurt (code, naam) VALUES (4796110, 'Zuiderhoofdbuurt');
INSERT INTO buurt (code, naam) VALUES (4796120, 'Noorderhoofdbuurt');
INSERT INTO buurt (code, naam) VALUES (4796130, 'Snuiverbuurt');
INSERT INTO buurt (code, naam) VALUES (4796140, 'Rosariumbuurt');
INSERT INTO buurt (code, naam) VALUES (4796210, 'Zuiderham');
INSERT INTO buurt (code, naam) VALUES (4796220, 'Noorderham');
INSERT INTO buurt (code, naam) VALUES (4796230, 'Krommeniedijk');
INSERT INTO buurt (code, naam) VALUES (4796240, 'Willis');
INSERT INTO buurt (code, naam) VALUES (4797110, 'De Zuid');
INSERT INTO buurt (code, naam) VALUES (4797120, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (4797130, 'Westerpolder');
INSERT INTO buurt (code, naam) VALUES (4797210, 'Waterrijk');
INSERT INTO buurt (code, naam) VALUES (4797220, 'Langeheit');
INSERT INTO buurt (code, naam) VALUES (4797230, 'Parkrijk');
INSERT INTO buurt (code, naam) VALUES (4798110, 'Westzanerpolder');
INSERT INTO buurt (code, naam) VALUES (4798120, 'Westzaan Zuid');
INSERT INTO buurt (code, naam) VALUES (4798130, 'J.J. Allanbuurt');
INSERT INTO buurt (code, naam) VALUES (4798140, 'Westzaan Noord');
INSERT INTO buurt (code, naam) VALUES (4798150, 'Middel');
INSERT INTO buurt (code, naam) VALUES (4820101, 'Cortgene');
INSERT INTO buurt (code, naam) VALUES (4820102, 'Redersbuurt');
INSERT INTO buurt (code, naam) VALUES (4820103, 'kerkbuurt');
INSERT INTO buurt (code, naam) VALUES (4820104, 'Polderbuurt');
INSERT INTO buurt (code, naam) VALUES (4820105, 'De Werven');
INSERT INTO buurt (code, naam) VALUES (4820201, 'Dijk');
INSERT INTO buurt (code, naam) VALUES (4820202, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (4820203, 'Waterland');
INSERT INTO buurt (code, naam) VALUES (4820204, 'Groene Long');
INSERT INTO buurt (code, naam) VALUES (4820205, 'Rivierenbuurt');
INSERT INTO buurt (code, naam) VALUES (4820206, 'Nieuw Kinderdijk');
INSERT INTO buurt (code, naam) VALUES (4820301, 'Zeelt');
INSERT INTO buurt (code, naam) VALUES (4820302, 'Middelland');
INSERT INTO buurt (code, naam) VALUES (4820303, 'Blokweer Noord');
INSERT INTO buurt (code, naam) VALUES (4820304, 'Blokweer Zuid');
INSERT INTO buurt (code, naam) VALUES (4820305, 'Drentsebuurt');
INSERT INTO buurt (code, naam) VALUES (4820306, 'Florabuurt');
INSERT INTO buurt (code, naam) VALUES (4820307, 'Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (4820401, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (4820402, 'Schrijversbuurt');
INSERT INTO buurt (code, naam) VALUES (4820403, 'Klein Alblas');
INSERT INTO buurt (code, naam) VALUES (4820404, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (4820501, 'Vinkenwaard');
INSERT INTO buurt (code, naam) VALUES (4820502, 'Hoogendijk');
INSERT INTO buurt (code, naam) VALUES (4820503, 'Nieuwland');
INSERT INTO buurt (code, naam) VALUES (4820601, 'Polder Blokweer');
INSERT INTO buurt (code, naam) VALUES (4820602, 'Polder Kortland');
INSERT INTO buurt (code, naam) VALUES (4820603, 'Polder Souburgh');
INSERT INTO buurt (code, naam) VALUES (4820604, 'Polder Vinkenwaard');
INSERT INTO buurt (code, naam) VALUES (4840101, 'Gnephoek');
INSERT INTO buurt (code, naam) VALUES (4840102, 'Woubrugseweg');
INSERT INTO buurt (code, naam) VALUES (4840103, 'Heuvelweg');
INSERT INTO buurt (code, naam) VALUES (4840104, 'Weteringpark');
INSERT INTO buurt (code, naam) VALUES (4840105, 'Ambachtenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840106, 'Heimanswetering');
INSERT INTO buurt (code, naam) VALUES (4840107, 'Stromenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840108, 'Nuovaweg');
INSERT INTO buurt (code, naam) VALUES (4840109, 'Groenoord');
INSERT INTO buurt (code, naam) VALUES (4840110, 'De Heul');
INSERT INTO buurt (code, naam) VALUES (4840201, 'Ridderbuurt');
INSERT INTO buurt (code, naam) VALUES (4840202, 'Herenweg');
INSERT INTO buurt (code, naam) VALUES (4840203, 'Horstenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840204, 'Burgtenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840205, 'Preludeweg');
INSERT INTO buurt (code, naam) VALUES (4840206, 'Componistenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840207, 'Rijnoord');
INSERT INTO buurt (code, naam) VALUES (4840208, 'Planetenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840301, 'Steinenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840302, 'Paddestoelenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840303, 'Ericapark');
INSERT INTO buurt (code, naam) VALUES (4840304, 'Weidebloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840305, 'Kromme Aar');
INSERT INTO buurt (code, naam) VALUES (4840306, 'Edelstenenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840401, 'Leidse Schouw');
INSERT INTO buurt (code, naam) VALUES (4840402, 'Rijnhaven');
INSERT INTO buurt (code, naam) VALUES (4840403, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840404, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (4840405, 'Bospark');
INSERT INTO buurt (code, naam) VALUES (4840501, 'Emmalaan');
INSERT INTO buurt (code, naam) VALUES (4840502, 'Burgemeester Visserpark');
INSERT INTO buurt (code, naam) VALUES (4840503, 'Paradijslaan');
INSERT INTO buurt (code, naam) VALUES (4840504, 'Hazeveld');
INSERT INTO buurt (code, naam) VALUES (4840505, 'Gouwsluis');
INSERT INTO buurt (code, naam) VALUES (4840506, 'De Schans');
INSERT INTO buurt (code, naam) VALUES (4840601, 'Nieuwe Sloot');
INSERT INTO buurt (code, naam) VALUES (4840602, 'Lijsterlaan');
INSERT INTO buurt (code, naam) VALUES (4840603, 'De Bijlen');
INSERT INTO buurt (code, naam) VALUES (4840604, 'Van Boetzelaerstraat');
INSERT INTO buurt (code, naam) VALUES (4840605, 'Beerendrecht');
INSERT INTO buurt (code, naam) VALUES (4840701, 'Kortsteekterbuurt');
INSERT INTO buurt (code, naam) VALUES (4840702, 'Steekterbuurt');
INSERT INTO buurt (code, naam) VALUES (4840703, 'Hoogendoornlaan');
INSERT INTO buurt (code, naam) VALUES (4840801, 'Molenwetering');
INSERT INTO buurt (code, naam) VALUES (4840802, 'Europaplein');
INSERT INTO buurt (code, naam) VALUES (4840803, 'Evenaar West');
INSERT INTO buurt (code, naam) VALUES (4840804, 'De Oude Wereld');
INSERT INTO buurt (code, naam) VALUES (4840805, 'Evenaar Oost');
INSERT INTO buurt (code, naam) VALUES (4840806, 'Zefierzijde');
INSERT INTO buurt (code, naam) VALUES (4840807, 'Archeon');
INSERT INTO buurt (code, naam) VALUES (4840808, 'Polderpeil');
INSERT INTO buurt (code, naam) VALUES (4840809, 'De Vork');
INSERT INTO buurt (code, naam) VALUES (4840901, 'Rietveldsepad');
INSERT INTO buurt (code, naam) VALUES (4843166, 'Benthuizen-Dorp');
INSERT INTO buurt (code, naam) VALUES (4843167, 'Noordpolder');
INSERT INTO buurt (code, naam) VALUES (4843168, 'Bentwoud');
INSERT INTO buurt (code, naam) VALUES (4844592, 'Noordeinde');
INSERT INTO buurt (code, naam) VALUES (4844593, 'Hoge Dijk');
INSERT INTO buurt (code, naam) VALUES (4844594, 'Aarlanderveen Dorp');
INSERT INTO buurt (code, naam) VALUES (4844595, 'Zuideinde');
INSERT INTO buurt (code, naam) VALUES (4847046, 'Boskoop');
INSERT INTO buurt (code, naam) VALUES (4847047, 'Snijdelwijk');
INSERT INTO buurt (code, naam) VALUES (4847048, 'Otweg en Rijneveld');
INSERT INTO buurt (code, naam) VALUES (4847049, 'Nesse en Halve Raak');
INSERT INTO buurt (code, naam) VALUES (4847050, 'Spoelwijk');
INSERT INTO buurt (code, naam) VALUES (4847196, 'Ziende');
INSERT INTO buurt (code, naam) VALUES (4847197, 'Zwammerdam Dorp');
INSERT INTO buurt (code, naam) VALUES (4847198, 'Hooge Burch');
INSERT INTO buurt (code, naam) VALUES (4847199, 'De Burcht');
INSERT INTO buurt (code, naam) VALUES (4849101, 'Dorpsstraat');
INSERT INTO buurt (code, naam) VALUES (4849102, 'Voorweg');
INSERT INTO buurt (code, naam) VALUES (4849103, 'Rietveld');
INSERT INTO buurt (code, naam) VALUES (4849104, 'Plan Zuid');
INSERT INTO buurt (code, naam) VALUES (4849105, 'Hazerswoude-Dorp West');
INSERT INTO buurt (code, naam) VALUES (4849106, 'Buitengebied Hazerswoude-Dorp Noord');
INSERT INTO buurt (code, naam) VALUES (4849107, 'Buitengebied Hazerswoude-Dorp Zuid');
INSERT INTO buurt (code, naam) VALUES (4849437, 'Rijndijk');
INSERT INTO buurt (code, naam) VALUES (4849438, 'Rhynenburch');
INSERT INTO buurt (code, naam) VALUES (4849439, 'Zonneveld');
INSERT INTO buurt (code, naam) VALUES (4849440, 'Buitengebied Hazerswoude-Rijndijk');
INSERT INTO buurt (code, naam) VALUES (4849674, 'Dorpsstraat Koudekerk');
INSERT INTO buurt (code, naam) VALUES (4849675, 'Plan Dorp Oost');
INSERT INTO buurt (code, naam) VALUES (4849676, 'Weidedreef');
INSERT INTO buurt (code, naam) VALUES (4849677, 'Hoogewaard');
INSERT INTO buurt (code, naam) VALUES (4849678, 'Hondsdijk');
INSERT INTO buurt (code, naam) VALUES (4849679, 'Lagewaard');
INSERT INTO buurt (code, naam) VALUES (4849680, 'Buitengebied Koudekerk');
INSERT INTO buurt (code, naam) VALUES (4890101, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (4890102, 'Centrum Oost');
INSERT INTO buurt (code, naam) VALUES (4890103, 'Centrum West');
INSERT INTO buurt (code, naam) VALUES (4890204, 'Noord 1');
INSERT INTO buurt (code, naam) VALUES (4890205, 'Noord 2');
INSERT INTO buurt (code, naam) VALUES (4890206, 'Noord 3');
INSERT INTO buurt (code, naam) VALUES (4890207, 'Noord 4');
INSERT INTO buurt (code, naam) VALUES (4890308, 'Binnenland');
INSERT INTO buurt (code, naam) VALUES (4890409, 'Oranjewijk 1');
INSERT INTO buurt (code, naam) VALUES (4890410, 'Oranjewijk 2');
INSERT INTO buurt (code, naam) VALUES (4890511, 'Buitenoord 1');
INSERT INTO buurt (code, naam) VALUES (4890512, 'Buitenoord 2');
INSERT INTO buurt (code, naam) VALUES (4890513, 'Buitenoord 3');
INSERT INTO buurt (code, naam) VALUES (4890614, 'Ter Leede');
INSERT INTO buurt (code, naam) VALUES (4890715, 'Paddewei');
INSERT INTO buurt (code, naam) VALUES (4890816, 'Molenvliet 1');
INSERT INTO buurt (code, naam) VALUES (4890817, 'Molenvliet 2');
INSERT INTO buurt (code, naam) VALUES (4890918, 'Nieuweland 1');
INSERT INTO buurt (code, naam) VALUES (4890919, 'Nieuweland 2');
INSERT INTO buurt (code, naam) VALUES (4890920, 'Nieuweland 3');
INSERT INTO buurt (code, naam) VALUES (4890921, 'Nieuweland 4');
INSERT INTO buurt (code, naam) VALUES (4890922, 'Nieuweland 5');
INSERT INTO buurt (code, naam) VALUES (4891023, 'Dorpzicht');
INSERT INTO buurt (code, naam) VALUES (4891124, 'Bijdorp');
INSERT INTO buurt (code, naam) VALUES (4891225, 'Smitshoek');
INSERT INTO buurt (code, naam) VALUES (4891226, 'Smitshoek 1');
INSERT INTO buurt (code, naam) VALUES (4891227, 'Smitshoek 2');
INSERT INTO buurt (code, naam) VALUES (4891328, 'Voordijk');
INSERT INTO buurt (code, naam) VALUES (4891429, 'Meerwede Noordoost');
INSERT INTO buurt (code, naam) VALUES (4891430, 'Meerwede Noordwest');
INSERT INTO buurt (code, naam) VALUES (4891431, 'Meerwede Zuidoost');
INSERT INTO buurt (code, naam) VALUES (4891432, 'Meerwede Zuidwest');
INSERT INTO buurt (code, naam) VALUES (4891533, 'Waterkant');
INSERT INTO buurt (code, naam) VALUES (4891634, 'Havenkwartier');
INSERT INTO buurt (code, naam) VALUES (4891735, 'Gaatkensoog');
INSERT INTO buurt (code, naam) VALUES (4891836, 'Riederhoek');
INSERT INTO buurt (code, naam) VALUES (4891937, 'Vrijheidsakker');
INSERT INTO buurt (code, naam) VALUES (4892039, 'Vrijenburg');
INSERT INTO buurt (code, naam) VALUES (4893050, 'Sportpark Smitshoek');
INSERT INTO buurt (code, naam) VALUES (4893051, 'Sint Clarabos');
INSERT INTO buurt (code, naam) VALUES (4893052, 'Vrijenburgbos');
INSERT INTO buurt (code, naam) VALUES (4893053, 'Kooiwalbos');
INSERT INTO buurt (code, naam) VALUES (4893054, 'Dordtsestraatweg');
INSERT INTO buurt (code, naam) VALUES (4893160, 'Koedood');
INSERT INTO buurt (code, naam) VALUES (4893161, 'Achterzeedijk West');
INSERT INTO buurt (code, naam) VALUES (4893162, 'Achterzeedijk Oost');
INSERT INTO buurt (code, naam) VALUES (4893163, 'Noldijk');
INSERT INTO buurt (code, naam) VALUES (4893164, 'Kilweg');
INSERT INTO buurt (code, naam) VALUES (4895070, 'BT Reijerswaard');
INSERT INTO buurt (code, naam) VALUES (4895071, 'BT Cornelisland');
INSERT INTO buurt (code, naam) VALUES (4895072, 'BT Dierenstein');
INSERT INTO buurt (code, naam) VALUES (4895073, 'BT Veiling');
INSERT INTO buurt (code, naam) VALUES (4895074, 'BT Handelscentrum');
INSERT INTO buurt (code, naam) VALUES (4895075, 'BT Gebroken Meeldijk');
INSERT INTO buurt (code, naam) VALUES (4895076, 'BT Ziedewij');
INSERT INTO buurt (code, naam) VALUES (4895077, 'BT Bijdorp');
INSERT INTO buurt (code, naam) VALUES (4895078, 'BT Kilweg Noord');
INSERT INTO buurt (code, naam) VALUES (4895080, 'BT Achterzeedijk');
INSERT INTO buurt (code, naam) VALUES (4895081, 'BT Vaanpark 1');
INSERT INTO buurt (code, naam) VALUES (4895082, 'BT Vaanpark 2');
INSERT INTO buurt (code, naam) VALUES (4895083, 'BT Vaanpark 3');
INSERT INTO buurt (code, naam) VALUES (4895084, 'BT Vaanpark 4');
INSERT INTO buurt (code, naam) VALUES (4910000, 'Bergambacht-Dorp');
INSERT INTO buurt (code, naam) VALUES (4910001, 'Kadijk en Kadijkselaan (gedeeltelijk) en Opweg');
INSERT INTO buurt (code, naam) VALUES (4910002, 'Uitbreiding Dorp');
INSERT INTO buurt (code, naam) VALUES (4910003, 'Benedenberg en Zuidbroek');
INSERT INTO buurt (code, naam) VALUES (4910004, 'Tussenlanen');
INSERT INTO buurt (code, naam) VALUES (4910009, 'Bovenberg westelijk van de Fransekade');
INSERT INTO buurt (code, naam) VALUES (4910100, 'Bergstoep');
INSERT INTO buurt (code, naam) VALUES (4910101, 'Lekdijk-West en Provinciale weg (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (4910102, 'Lekdijk-Oost en Provinciale weg (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (4910103, 'Bovenstad');
INSERT INTO buurt (code, naam) VALUES (4910104, 'Provinciale weg (ged.) De Hem en Hogedijk (ged.)');
INSERT INTO buurt (code, naam) VALUES (4910200, 'Ammerstol');
INSERT INTO buurt (code, naam) VALUES (4910300, 'Berkenwoude');
INSERT INTO buurt (code, naam) VALUES (4910301, 'Achterbroek');
INSERT INTO buurt (code, naam) VALUES (4980000, 'Centrum Hoogkarspel');
INSERT INTO buurt (code, naam) VALUES (4980001, 'Ten westen van Tolweg');
INSERT INTO buurt (code, naam) VALUES (4980009, 'Wijzend');
INSERT INTO buurt (code, naam) VALUES (4980100, 'Westwoud');
INSERT INTO buurt (code, naam) VALUES (4980101, 'Oudijk');
INSERT INTO buurt (code, naam) VALUES (4980109, 'Binnenwijzend');
INSERT INTO buurt (code, naam) VALUES (4980200, 'Oosterblokker');
INSERT INTO buurt (code, naam) VALUES (4980300, 'Centrum Venhuizen');
INSERT INTO buurt (code, naam) VALUES (4980301, 'De Buurt');
INSERT INTO buurt (code, naam) VALUES (4980302, 'Hem');
INSERT INTO buurt (code, naam) VALUES (4980306, 'De Hout en Blokdijk');
INSERT INTO buurt (code, naam) VALUES (4980307, 'Drieban (gedeeltelijk), Hem');
INSERT INTO buurt (code, naam) VALUES (4980308, 'Drieban (gedeeltelijk), Venhuizen');
INSERT INTO buurt (code, naam) VALUES (4980309, 'Zuiderdijk');
INSERT INTO buurt (code, naam) VALUES (4980400, 'Wijdenes');
INSERT INTO buurt (code, naam) VALUES (4980401, 'Oosterleek');
INSERT INTO buurt (code, naam) VALUES (4980500, 'Schellinkhout');
INSERT INTO buurt (code, naam) VALUES (4989997, '');
INSERT INTO buurt (code, naam) VALUES (5010000, 'Brielle');
INSERT INTO buurt (code, naam) VALUES (5010001, 'Spuilaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (5010002, 'De Kapel en omgeving');
INSERT INTO buurt (code, naam) VALUES (5010003, 'Rugge');
INSERT INTO buurt (code, naam) VALUES (5010004, 'Noord Meeuwenoord');
INSERT INTO buurt (code, naam) VALUES (5010005, 'Kleine Goote');
INSERT INTO buurt (code, naam) VALUES (5010006, 'Nieuwland');
INSERT INTO buurt (code, naam) VALUES (5010009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (5010100, 'Vierpolders');
INSERT INTO buurt (code, naam) VALUES (5010109, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (5010200, 'Zwartewaal');
INSERT INTO buurt (code, naam) VALUES (5010201, 'Tuindorp-Hofstede');
INSERT INTO buurt (code, naam) VALUES (5010202, 'Zalmlaan');
INSERT INTO buurt (code, naam) VALUES (5010209, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (5010300, 'Recreatiestrook Brielse Maas');
INSERT INTO buurt (code, naam) VALUES (5020100, 'IJsseldijk');
INSERT INTO buurt (code, naam) VALUES (5020101, 'Redebuurt');
INSERT INTO buurt (code, naam) VALUES (5020102, 'Industrieterrein-West');
INSERT INTO buurt (code, naam) VALUES (5020103, 'Zeeheldenbuurt-West');
INSERT INTO buurt (code, naam) VALUES (5020104, 'Zeeheldenbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (5020105, 'Chopin-buurt');
INSERT INTO buurt (code, naam) VALUES (5020106, 'Bizet-buurt');
INSERT INTO buurt (code, naam) VALUES (5020107, 'Paganini-buurt');
INSERT INTO buurt (code, naam) VALUES (5020108, 'Rossini-buurt');
INSERT INTO buurt (code, naam) VALUES (5020109, 'Puccini-buurt');
INSERT INTO buurt (code, naam) VALUES (5020201, '''s-Gravenweg en Alexanderlaan');
INSERT INTO buurt (code, naam) VALUES (5020202, '''s-Gravenpark');
INSERT INTO buurt (code, naam) VALUES (5020203, 'Reviusbuurt');
INSERT INTO buurt (code, naam) VALUES (5020204, 'Dichtersbuurt');
INSERT INTO buurt (code, naam) VALUES (5020205, 'Merelbuurt');
INSERT INTO buurt (code, naam) VALUES (5020206, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (5020207, 'Valeriusbuurt');
INSERT INTO buurt (code, naam) VALUES (5020208, 'Rozenburcht');
INSERT INTO buurt (code, naam) VALUES (5020209, 'Oude plaats');
INSERT INTO buurt (code, naam) VALUES (5020301, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (5020302, 'Hovenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020303, 'Koperwiek');
INSERT INTO buurt (code, naam) VALUES (5020304, 'Meeuwenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020305, 'Alkenoord');
INSERT INTO buurt (code, naam) VALUES (5020306, 'Vuykterrein');
INSERT INTO buurt (code, naam) VALUES (5020307, 'Oude Kern');
INSERT INTO buurt (code, naam) VALUES (5020308, 'Kievitlaan');
INSERT INTO buurt (code, naam) VALUES (5020401, 'De Baronie');
INSERT INTO buurt (code, naam) VALUES (5020402, 'Diepenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020403, 'Dalenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020404, 'Sportpark Couwenhoek');
INSERT INTO buurt (code, naam) VALUES (5020405, 'Eilandenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020406, 'Waardenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020407, 'AWZI Oostgaarde');
INSERT INTO buurt (code, naam) VALUES (5020408, 'Baaienbuurt');
INSERT INTO buurt (code, naam) VALUES (5020409, 'Paradijssel');
INSERT INTO buurt (code, naam) VALUES (5020501, 'Beemster en Purmerhoek');
INSERT INTO buurt (code, naam) VALUES (5020502, 'Schermerhoek');
INSERT INTO buurt (code, naam) VALUES (5020503, 'Wormerhoek');
INSERT INTO buurt (code, naam) VALUES (5020504, 'Scandinavischebuurt');
INSERT INTO buurt (code, naam) VALUES (5020505, 'Amerikaansebuurt');
INSERT INTO buurt (code, naam) VALUES (5020506, 'Bergenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020507, 'Molukkenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020508, 'Klaverweide');
INSERT INTO buurt (code, naam) VALUES (5020509, 'Klinkert');
INSERT INTO buurt (code, naam) VALUES (5020601, 'Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020602, 'Florabuurt');
INSERT INTO buurt (code, naam) VALUES (5020603, 'Bloemenbuurt-West');
INSERT INTO buurt (code, naam) VALUES (5020604, 'Bloemenbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (5020605, 'Akker- en Haagwinde');
INSERT INTO buurt (code, naam) VALUES (5020606, 'Sportpark Schenkel');
INSERT INTO buurt (code, naam) VALUES (5020700, 'Dansenbuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (5020701, 'Burgenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020702, 'Dansenbuurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (5020703, 'Ervenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020704, 'Stadsdeelpark');
INSERT INTO buurt (code, naam) VALUES (5020705, 'Instrumentenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020706, 'Kunstenaarsbuurt');
INSERT INTO buurt (code, naam) VALUES (5020707, 'Operabuurt');
INSERT INTO buurt (code, naam) VALUES (5020708, 'Gebouwenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020709, 'Schildersvormenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020800, 'Hoofdweg Sector E en F');
INSERT INTO buurt (code, naam) VALUES (5020801, 'Hoofdweg Sector A');
INSERT INTO buurt (code, naam) VALUES (5020802, 'Hoofdweg Sector B');
INSERT INTO buurt (code, naam) VALUES (5020803, 'Hoofdweg Sector C');
INSERT INTO buurt (code, naam) VALUES (5020804, 'Hoofdweg Sector D');
INSERT INTO buurt (code, naam) VALUES (5020805, 'Hoofdweg Sector G');
INSERT INTO buurt (code, naam) VALUES (5020806, 'Sporenbuurt-West');
INSERT INTO buurt (code, naam) VALUES (5020807, 'Sporenbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (5020808, 'Tuinenbuurt');
INSERT INTO buurt (code, naam) VALUES (5020809, 'Kunstenaarsbuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (5020901, 'Fascinatio West');
INSERT INTO buurt (code, naam) VALUES (5020902, 'Fascinatio Oost');
INSERT INTO buurt (code, naam) VALUES (5020903, 'Capelsebrug');
INSERT INTO buurt (code, naam) VALUES (5020904, 'Rijckevorselpark');
INSERT INTO buurt (code, naam) VALUES (5020905, 'Rivium 1e straat');
INSERT INTO buurt (code, naam) VALUES (5020906, 'AWZI Rivium');
INSERT INTO buurt (code, naam) VALUES (5020907, 'Rivium 2e straat');
INSERT INTO buurt (code, naam) VALUES (5020908, 'Rivium Promenade');
INSERT INTO buurt (code, naam) VALUES (5031100, 'Bedrijventerrein Wateringseweg');
INSERT INTO buurt (code, naam) VALUES (5031101, 'Centrum-Noord');
INSERT INTO buurt (code, naam) VALUES (5031102, 'Centrum-West');
INSERT INTO buurt (code, naam) VALUES (5031103, 'Centrum-Oost');
INSERT INTO buurt (code, naam) VALUES (5031104, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (5031105, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (5031106, 'Centrum-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (5031107, 'In de Veste');
INSERT INTO buurt (code, naam) VALUES (5031108, 'Centrum-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (5031109, 'Zuidpoort');
INSERT INTO buurt (code, naam) VALUES (5031200, 'Bedrijventerrein Haagweg');
INSERT INTO buurt (code, naam) VALUES (5031201, 'Indische Buurt-Noord');
INSERT INTO buurt (code, naam) VALUES (5031202, 'Indische Buurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (5031203, 'Sint Joris');
INSERT INTO buurt (code, naam) VALUES (5031204, 'Koepoort');
INSERT INTO buurt (code, naam) VALUES (5031205, 'Bomenwijk');
INSERT INTO buurt (code, naam) VALUES (5031206, 'Biesland');
INSERT INTO buurt (code, naam) VALUES (5031207, 'Heilige Land');
INSERT INTO buurt (code, naam) VALUES (5031208, 'Bedrijventerrein Delftse Poort-West');
INSERT INTO buurt (code, naam) VALUES (5031300, 'Bedrijventerrein Altena');
INSERT INTO buurt (code, naam) VALUES (5031301, 'Agnetaparkbuurt');
INSERT INTO buurt (code, naam) VALUES (5031302, 'Ministersbuurt-West');
INSERT INTO buurt (code, naam) VALUES (5031303, 'Ministersbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (5031304, 'Westeindebuurt');
INSERT INTO buurt (code, naam) VALUES (5031305, 'Olofsbuurt');
INSERT INTO buurt (code, naam) VALUES (5031306, 'Krakeelpolder');
INSERT INTO buurt (code, naam) VALUES (5031307, 'Westerkwartier');
INSERT INTO buurt (code, naam) VALUES (5031400, 'Kuyperwijk-Noord');
INSERT INTO buurt (code, naam) VALUES (5031401, 'Kuyperwijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (5031402, 'Ecodus');
INSERT INTO buurt (code, naam) VALUES (5031403, 'Marlot');
INSERT INTO buurt (code, naam) VALUES (5031404, 'Westlandhof');
INSERT INTO buurt (code, naam) VALUES (5031405, 'Hoornse Hof');
INSERT INTO buurt (code, naam) VALUES (5031406, 'Den Hoorn');
INSERT INTO buurt (code, naam) VALUES (5031407, 'Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (5031600, 'De Bras');
INSERT INTO buurt (code, naam) VALUES (5031601, 'Bedrijventerrein Ypenburgsepoort');
INSERT INTO buurt (code, naam) VALUES (5031602, 'De Grote Plas');
INSERT INTO buurt (code, naam) VALUES (5031603, 'Bedrijventerrein Delftse Poort-Oost');
INSERT INTO buurt (code, naam) VALUES (5031604, 'Hoflaan');
INSERT INTO buurt (code, naam) VALUES (5032200, 'Bedrijventerrein Tanthof-West');
INSERT INTO buurt (code, naam) VALUES (5032201, 'Afrikabuurt-West');
INSERT INTO buurt (code, naam) VALUES (5032202, 'Afrikabuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (5032203, 'Latijns Amerikabuurt');
INSERT INTO buurt (code, naam) VALUES (5032204, 'Aziëbuurt');
INSERT INTO buurt (code, naam) VALUES (5032205, 'Tanthofkadebuurt');
INSERT INTO buurt (code, naam) VALUES (5032300, 'Bedrijventerrein Tanthof-Oost');
INSERT INTO buurt (code, naam) VALUES (5032301, 'Boerderijbuurt');
INSERT INTO buurt (code, naam) VALUES (5032302, 'Dierenbuurt');
INSERT INTO buurt (code, naam) VALUES (5032303, 'Vogelbuurt-West');
INSERT INTO buurt (code, naam) VALUES (5032304, 'Vogelbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (5032305, 'Bosrand');
INSERT INTO buurt (code, naam) VALUES (5032400, 'Poptahof-Noord');
INSERT INTO buurt (code, naam) VALUES (5032401, 'Poptahof-Zuid');
INSERT INTO buurt (code, naam) VALUES (5032402, 'Bedrijventerrein Voorhof');
INSERT INTO buurt (code, naam) VALUES (5032403, 'Mythologiebuurt');
INSERT INTO buurt (code, naam) VALUES (5032404, 'Aart van der Leeuwbuurt');
INSERT INTO buurt (code, naam) VALUES (5032405, 'Roland Holstbuurt');
INSERT INTO buurt (code, naam) VALUES (5032406, 'Voorhof-Hoogbouw');
INSERT INTO buurt (code, naam) VALUES (5032407, 'Multatulibuurt');
INSERT INTO buurt (code, naam) VALUES (5032408, 'Bedrijventerrein Vulcanusweg');
INSERT INTO buurt (code, naam) VALUES (5032500, 'Reinier de Graafbuurt');
INSERT INTO buurt (code, naam) VALUES (5032501, 'Buitenhof-Noord');
INSERT INTO buurt (code, naam) VALUES (5032502, 'Juniusbuurt');
INSERT INTO buurt (code, naam) VALUES (5032503, 'Gillisbuurt');
INSERT INTO buurt (code, naam) VALUES (5032504, 'Fledderusbuurt');
INSERT INTO buurt (code, naam) VALUES (5032505, 'Het Rode Dorp');
INSERT INTO buurt (code, naam) VALUES (5032506, 'Pijperring');
INSERT INTO buurt (code, naam) VALUES (5032507, 'Verzetstrijdersbuurt');
INSERT INTO buurt (code, naam) VALUES (5032508, 'Vrijheidsbuurt');
INSERT INTO buurt (code, naam) VALUES (5032509, 'Buitenhof-Zuid');
INSERT INTO buurt (code, naam) VALUES (5032510, 'Kerkpolder');
INSERT INTO buurt (code, naam) VALUES (5032600, 'Abtswoude');
INSERT INTO buurt (code, naam) VALUES (5032700, 'Delftzicht');
INSERT INTO buurt (code, naam) VALUES (5032701, 'Bedrijventerrein Zuideinde');
INSERT INTO buurt (code, naam) VALUES (5032702, 'Bedrijventerrein Schieweg-Noord');
INSERT INTO buurt (code, naam) VALUES (5032703, 'Bedrijventerrein Schieweg-Zuid');
INSERT INTO buurt (code, naam) VALUES (5032704, 'Schieweg-Polder');
INSERT INTO buurt (code, naam) VALUES (5032800, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (5032801, 'TU-Noord');
INSERT INTO buurt (code, naam) VALUES (5032802, 'Wippolder-Noord');
INSERT INTO buurt (code, naam) VALUES (5032803, 'Wippolder-Zuid');
INSERT INTO buurt (code, naam) VALUES (5032804, 'Bedrijventerrein Rotterdamseweg-Noord');
INSERT INTO buurt (code, naam) VALUES (5032805, 'TU-Campus');
INSERT INTO buurt (code, naam) VALUES (5032806, 'Professorenbuurt');
INSERT INTO buurt (code, naam) VALUES (5032807, 'Bedrijventerrein Delftech');
INSERT INTO buurt (code, naam) VALUES (5032808, 'Pauwmolen');
INSERT INTO buurt (code, naam) VALUES (5032809, 'Koningsveldbuurt');
INSERT INTO buurt (code, naam) VALUES (5032900, 'Bedrijventerrein Rotterdamseweg-Zuid');
INSERT INTO buurt (code, naam) VALUES (5032901, 'Bedrijventerrein Technopolis');
INSERT INTO buurt (code, naam) VALUES (5032902, 'Ackersdijk');
INSERT INTO buurt (code, naam) VALUES (5050100, 'Nieuwe Haven en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050101, 'Groenmarkt en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050102, 'Grote Markt en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050103, 'Wijnstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050104, 'Kalkhaven');
INSERT INTO buurt (code, naam) VALUES (5050105, 'Achterhakkers en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050106, 'Boogjes en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050107, 'Lombard en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050108, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (5050109, 'Augustijnenkamp en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050110, 'Geldelozepad en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050111, 'Rozenhof en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050112, 'Beverwijcksplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050113, 'Burgemeester de Raadtsingel en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050114, 'Kon. Wilhelminastraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050200, 'Bleijenhoek');
INSERT INTO buurt (code, naam) VALUES (5050201, 'Stadswerven');
INSERT INTO buurt (code, naam) VALUES (5050202, 'Lijnbaan');
INSERT INTO buurt (code, naam) VALUES (5050203, 'Matena''s Pad en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050204, 'Merwestein-Noord');
INSERT INTO buurt (code, naam) VALUES (5050205, 'Kasperspad en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050206, 'Park Merwestein en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050300, 'Zuidendijk');
INSERT INTO buurt (code, naam) VALUES (5050301, 'Viottakade en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050302, 'Erasmuslaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050303, 'Breitnerstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050304, 'Jacob Marisstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050305, 'Krispijnse Driehoek');
INSERT INTO buurt (code, naam) VALUES (5050306, 'Jacob Catsstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050307, 'Rembrandtlaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050400, 'Pr. Bernhardstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050401, 'Waldeck Pyrmontweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050402, 'Anna Paulownastraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050403, 'Emmastraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050404, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (5050405, 'Weizigtpark');
INSERT INTO buurt (code, naam) VALUES (5050406, 'Nieuweweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050500, 'Wantijpark en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050501, 'Transvaalstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050502, 'Indische Buurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (5050503, 'Indische Buurt-Noord');
INSERT INTO buurt (code, naam) VALUES (5050504, 'Boeroestraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050505, 'Vogelplein-Aalscholverstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050506, 'Hoekenessestraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050507, 'Standhasenstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050508, 'Heysterbachstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050509, 'Maria Montessorilaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050510, 'Sportterrein Krommedijk');
INSERT INTO buurt (code, naam) VALUES (5050600, 'Plein 1940-1945 en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050601, 'Beekmanstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050602, 'Noorderkwartier');
INSERT INTO buurt (code, naam) VALUES (5050603, 'Amerstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050604, 'Merwedepolder-West');
INSERT INTO buurt (code, naam) VALUES (5050605, 'Merwedepolder-Oost');
INSERT INTO buurt (code, naam) VALUES (5050606, 'Spaarbekken');
INSERT INTO buurt (code, naam) VALUES (5050607, '1e Merwedehaven en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050608, '2e Merwedehaven en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050700, 'Admiraalsplein');
INSERT INTO buurt (code, naam) VALUES (5050701, 'Van Kinsbergenstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050702, 'Cornelis Evertsenstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050703, 'Dorus Rijkersstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050704, 'Van Ewijckstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050705, 'Zeehavenlaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050706, 'Laan der Verenigde Naties Noord');
INSERT INTO buurt (code, naam) VALUES (5050707, 'Dordtse Hout');
INSERT INTO buurt (code, naam) VALUES (5050800, 'Crabbehof-Zuid');
INSERT INTO buurt (code, naam) VALUES (5050801, 'Crabbehof-Noord');
INSERT INTO buurt (code, naam) VALUES (5050802, 'Zuidhoven');
INSERT INTO buurt (code, naam) VALUES (5050900, 'Sterrenburg 1-West');
INSERT INTO buurt (code, naam) VALUES (5050901, 'Sterrenburg 1-Oost');
INSERT INTO buurt (code, naam) VALUES (5050902, 'Waterman en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050903, 'Driehoek en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050904, 'Blaauwweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050905, 'Minnaertweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050906, 'Mildenburg en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050907, 'Zuilenburg en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050908, 'Vredenburg en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050909, 'Wittenstein en omgeving');
INSERT INTO buurt (code, naam) VALUES (5050910, 'Smitsweg');
INSERT INTO buurt (code, naam) VALUES (5051000, 'Vissersdijk-West');
INSERT INTO buurt (code, naam) VALUES (5051001, 'Vissersdijk-Beneden');
INSERT INTO buurt (code, naam) VALUES (5051002, 'Vissersdijk-Oost');
INSERT INTO buurt (code, naam) VALUES (5051003, 'Egstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051004, 'Oudendijk en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051005, 'Vissersdijk-Noord');
INSERT INTO buurt (code, naam) VALUES (5051006, 'Dubbeldam-Noord');
INSERT INTO buurt (code, naam) VALUES (5051007, 'Dubbeldam-Zuid');
INSERT INTO buurt (code, naam) VALUES (5051008, 'Bastion locatie');
INSERT INTO buurt (code, naam) VALUES (5051009, 'Locatie Karel Lotsyweg');
INSERT INTO buurt (code, naam) VALUES (5051010, 'Albert Schweitzerplaats');
INSERT INTO buurt (code, naam) VALUES (5051011, 'De Hoven');
INSERT INTO buurt (code, naam) VALUES (5051012, 'Zuidpolder');
INSERT INTO buurt (code, naam) VALUES (5051013, 'Belthure Park');
INSERT INTO buurt (code, naam) VALUES (5051100, 'Amazone en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051101, 'Palissander en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051102, 'Azobe en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051103, 'Iroko en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051104, 'Bedrijventerrein Groene Zoom');
INSERT INTO buurt (code, naam) VALUES (5051105, 'Van Ravesteijn-erf en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051106, 'Van den Broek-erf en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051107, 'Suze Groeneweg-erf en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051108, 'Joke Smit-erf en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051109, 'Pearl Buck-erf en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051110, 'Aletta Jacobs-erf en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051111, 'Johanna Naber-erf en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051112, 'Bildersteeg en omgeving');
INSERT INTO buurt (code, naam) VALUES (5051900, 'Weeskinderendijk en Dokweg');
INSERT INTO buurt (code, naam) VALUES (5051901, 'Handelskade en ''s-Gravendeelsedijk');
INSERT INTO buurt (code, naam) VALUES (5051902, 'Voltastraat en omgeving - De Put');
INSERT INTO buurt (code, naam) VALUES (5051903, 'Louterbloemen');
INSERT INTO buurt (code, naam) VALUES (5051904, 'Wilhelminahaven');
INSERT INTO buurt (code, naam) VALUES (5051905, 'Julianahaven');
INSERT INTO buurt (code, naam) VALUES (5051906, 'Krabbegors');
INSERT INTO buurt (code, naam) VALUES (5051907, 'Krabbepolder');
INSERT INTO buurt (code, naam) VALUES (5051909, 'Wieldrecht');
INSERT INTO buurt (code, naam) VALUES (5051910, 'Dordtse Kil I');
INSERT INTO buurt (code, naam) VALUES (5051911, 'Amstelwijck-West');
INSERT INTO buurt (code, naam) VALUES (5051912, 'Schotman terrein');
INSERT INTO buurt (code, naam) VALUES (5051913, 'Locatie Refaja');
INSERT INTO buurt (code, naam) VALUES (5051914, 'Amstelwijck');
INSERT INTO buurt (code, naam) VALUES (5051915, 'Tweede Tol');
INSERT INTO buurt (code, naam) VALUES (5051916, 'Dordtse Kil II');
INSERT INTO buurt (code, naam) VALUES (5051917, 'Dordtse Kil III');
INSERT INTO buurt (code, naam) VALUES (5051918, 'Oostkil');
INSERT INTO buurt (code, naam) VALUES (5051919, 'Dordtse Kil IV');
INSERT INTO buurt (code, naam) VALUES (5059800, 'Merwelanden');
INSERT INTO buurt (code, naam) VALUES (5059801, '3e Merwedehaven');
INSERT INTO buurt (code, naam) VALUES (5059804, 'Dordtse Biesbosch');
INSERT INTO buurt (code, naam) VALUES (5059805, 'Bovenpolder');
INSERT INTO buurt (code, naam) VALUES (5059997, '');
INSERT INTO buurt (code, naam) VALUES (5120101, 'Bovenstad');
INSERT INTO buurt (code, naam) VALUES (5120102, 'Benedenstad');
INSERT INTO buurt (code, naam) VALUES (5120200, 'Wijdschild');
INSERT INTO buurt (code, naam) VALUES (5120300, 'Lingewijk');
INSERT INTO buurt (code, naam) VALUES (5120403, 'Haarwijk West');
INSERT INTO buurt (code, naam) VALUES (5120404, 'Haarwijk Oost');
INSERT INTO buurt (code, naam) VALUES (5120500, 'Stalkaarsen');
INSERT INTO buurt (code, naam) VALUES (5120600, 'Gildenwijk');
INSERT INTO buurt (code, naam) VALUES (5120700, 'Schelluinsestraat');
INSERT INTO buurt (code, naam) VALUES (5120800, 'Avelingen Oost');
INSERT INTO buurt (code, naam) VALUES (5120900, 'Avelingen West');
INSERT INTO buurt (code, naam) VALUES (5121000, 'Molenvliet');
INSERT INTO buurt (code, naam) VALUES (5121105, 'Laag Dalem I');
INSERT INTO buurt (code, naam) VALUES (5121106, 'Laag Dalem II');
INSERT INTO buurt (code, naam) VALUES (5121107, 'Laag Dalem Oost');
INSERT INTO buurt (code, naam) VALUES (5121108, 'Laag Dalem Zuid');
INSERT INTO buurt (code, naam) VALUES (5121200, 'Dalem');
INSERT INTO buurt (code, naam) VALUES (5121300, 'Hoog Dalem');
INSERT INTO buurt (code, naam) VALUES (5121409, 'Linge');
INSERT INTO buurt (code, naam) VALUES (5121410, 'Oost I');
INSERT INTO buurt (code, naam) VALUES (5121411, 'Oost II');
INSERT INTO buurt (code, naam) VALUES (5121500, 'Papland');
INSERT INTO buurt (code, naam) VALUES (5121600, 'Schotdeuren');
INSERT INTO buurt (code, naam) VALUES (5121700, 'Bedrijventerrein Noord');
INSERT INTO buurt (code, naam) VALUES (5121800, 'Landelijk gebied West');
INSERT INTO buurt (code, naam) VALUES (5121900, 'Landelijk gebied Noord');
INSERT INTO buurt (code, naam) VALUES (5122000, 'Landelijk gebied Oost');
INSERT INTO buurt (code, naam) VALUES (5122100, 'Landelijk gebied Zuid');
INSERT INTO buurt (code, naam) VALUES (5130100, 'Nieuwe Markt en omgeving');
INSERT INTO buurt (code, naam) VALUES (5130101, 'De Baan en omgeving');
INSERT INTO buurt (code, naam) VALUES (5130102, 'Turfmarkt en omgeving');
INSERT INTO buurt (code, naam) VALUES (5130103, 'Raam en omgeving');
INSERT INTO buurt (code, naam) VALUES (5130104, 'Nieuwe Park-Oost');
INSERT INTO buurt (code, naam) VALUES (5130105, 'Nieuwe Park-West');
INSERT INTO buurt (code, naam) VALUES (5130200, 'De Korte Akkeren-Oud');
INSERT INTO buurt (code, naam) VALUES (5130201, 'De Korte Akkeren-Nieuw');
INSERT INTO buurt (code, naam) VALUES (5130202, 'Industrieterrein Kromme Gouwe Oost West');
INSERT INTO buurt (code, naam) VALUES (5130203, 'Industrieterrein de Hollandsche IJssel');
INSERT INTO buurt (code, naam) VALUES (5130204, 'Weidebloemkwartier');
INSERT INTO buurt (code, naam) VALUES (5130300, 'Boerhaavekwartier');
INSERT INTO buurt (code, naam) VALUES (5130301, 'Windrooskwartier en Heesterbuurt');
INSERT INTO buurt (code, naam) VALUES (5130302, 'Groenhovenkwartier');
INSERT INTO buurt (code, naam) VALUES (5130303, 'Bloemendaalseweg');
INSERT INTO buurt (code, naam) VALUES (5130304, 'De Goudse Poort');
INSERT INTO buurt (code, naam) VALUES (5130305, 'De Gaardenbuurt');
INSERT INTO buurt (code, naam) VALUES (5130400, 'Hoef- en Veldbuurt');
INSERT INTO buurt (code, naam) VALUES (5130401, 'Zomenbuurt');
INSERT INTO buurt (code, naam) VALUES (5130402, 'Hoevenbuurt');
INSERT INTO buurt (code, naam) VALUES (5130403, 'Lusten-, Burgen- en Steinenbuurt');
INSERT INTO buurt (code, naam) VALUES (5130404, 'Grassen- en Waterbuurt');
INSERT INTO buurt (code, naam) VALUES (5130405, 'Bodegraafsestraatweg');
INSERT INTO buurt (code, naam) VALUES (5130406, 'Mammoet');
INSERT INTO buurt (code, naam) VALUES (5130407, 'Wervenbuurt');
INSERT INTO buurt (code, naam) VALUES (5130500, 'Ouwe Gouwe');
INSERT INTO buurt (code, naam) VALUES (5130501, 'Statensingel');
INSERT INTO buurt (code, naam) VALUES (5130502, 'Wethouder Venteweg');
INSERT INTO buurt (code, naam) VALUES (5130503, 'Achterwillenseweg');
INSERT INTO buurt (code, naam) VALUES (5130504, 'Slagenbuurt');
INSERT INTO buurt (code, naam) VALUES (5130509, 'De Goudse Hout');
INSERT INTO buurt (code, naam) VALUES (5130600, 'Oosterwei');
INSERT INTO buurt (code, naam) VALUES (5130601, 'Vreewijk');
INSERT INTO buurt (code, naam) VALUES (5130602, 'Voorwillenseweg');
INSERT INTO buurt (code, naam) VALUES (5130603, 'Kadenbuurt');
INSERT INTO buurt (code, naam) VALUES (5130604, 'Kort Haarlem');
INSERT INTO buurt (code, naam) VALUES (5130700, 'Sportbuurt');
INSERT INTO buurt (code, naam) VALUES (5130701, 'Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (5130702, 'Polderbuurt');
INSERT INTO buurt (code, naam) VALUES (5130703, 'Vrijheidsbuurt');
INSERT INTO buurt (code, naam) VALUES (5130704, 'Componistenbuurt');
INSERT INTO buurt (code, naam) VALUES (5130705, 'Muziekbuurt');
INSERT INTO buurt (code, naam) VALUES (5130800, 'Stolwijkersluis-Oost');
INSERT INTO buurt (code, naam) VALUES (5130809, 'Stolwijkersluis-West');
INSERT INTO buurt (code, naam) VALUES (5130900, 'Gouwestroom');
INSERT INTO buurt (code, naam) VALUES (5130901, 'Ringvaartbocht');
INSERT INTO buurt (code, naam) VALUES (5130909, 'Oostpolder in Schieland');
INSERT INTO buurt (code, naam) VALUES (5180170, 'Oostduinen');
INSERT INTO buurt (code, naam) VALUES (5180271, 'Belgisch Park');
INSERT INTO buurt (code, naam) VALUES (5180373, 'Westbroekpark');
INSERT INTO buurt (code, naam) VALUES (5180374, 'Duttendel');
INSERT INTO buurt (code, naam) VALUES (5180448, 'Nassaubuurt');
INSERT INTO buurt (code, naam) VALUES (5180475, 'Uilennest');
INSERT INTO buurt (code, naam) VALUES (5180476, 'Duinzigt');
INSERT INTO buurt (code, naam) VALUES (5180477, 'Waalsdorp');
INSERT INTO buurt (code, naam) VALUES (5180478, 'Arendsdorp');
INSERT INTO buurt (code, naam) VALUES (5180479, 'Van Hoytemastraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (5180546, 'Archipelbuurt');
INSERT INTO buurt (code, naam) VALUES (5180605, 'Van Stolkpark en Scheveningse Bosjes');
INSERT INTO buurt (code, naam) VALUES (5180701, 'Oud Scheveningen');
INSERT INTO buurt (code, naam) VALUES (5180702, 'Vissershaven');
INSERT INTO buurt (code, naam) VALUES (5180703, 'Scheveningen Badplaats');
INSERT INTO buurt (code, naam) VALUES (5180704, 'Visserijbuurt');
INSERT INTO buurt (code, naam) VALUES (5180772, 'Rijslag');
INSERT INTO buurt (code, naam) VALUES (5180800, 'Duindorp');
INSERT INTO buurt (code, naam) VALUES (5180907, 'Statenkwartier');
INSERT INTO buurt (code, naam) VALUES (5180908, 'Geuzenkwartier');
INSERT INTO buurt (code, naam) VALUES (5181041, 'Zorgvliet');
INSERT INTO buurt (code, naam) VALUES (5181142, 'Stadhoudersplantsoen');
INSERT INTO buurt (code, naam) VALUES (5181143, 'Sweelinckplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (5181250, 'Bloemenbuurt-West');
INSERT INTO buurt (code, naam) VALUES (5181251, 'Bloemenbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (5181252, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (5181309, 'Vogelwijk');
INSERT INTO buurt (code, naam) VALUES (5181481, 'Bosjes van Pex');
INSERT INTO buurt (code, naam) VALUES (5181492, 'Bohemen en Meer en Bos');
INSERT INTO buurt (code, naam) VALUES (5181590, 'Ockenburgh');
INSERT INTO buurt (code, naam) VALUES (5181591, 'Kijkduin');
INSERT INTO buurt (code, naam) VALUES (5181697, 'Kraayenstein');
INSERT INTO buurt (code, naam) VALUES (5181785, 'Kerketuinen en Zichtenburg');
INSERT INTO buurt (code, naam) VALUES (5181786, 'Houtwijk');
INSERT INTO buurt (code, naam) VALUES (5181795, 'Kom Loosduinen');
INSERT INTO buurt (code, naam) VALUES (5181806, 'Waldeck-Zuid');
INSERT INTO buurt (code, naam) VALUES (5181840, 'Nieuw Waldeck');
INSERT INTO buurt (code, naam) VALUES (5181882, 'Rosenburg');
INSERT INTO buurt (code, naam) VALUES (5181893, 'Componistenbuurt');
INSERT INTO buurt (code, naam) VALUES (5181894, 'Waldeck-Noord');
INSERT INTO buurt (code, naam) VALUES (5181953, 'Vruchtenbuurt');
INSERT INTO buurt (code, naam) VALUES (5181983, 'Eykenduinen');
INSERT INTO buurt (code, naam) VALUES (5182054, 'Heesterbuurt');
INSERT INTO buurt (code, naam) VALUES (5182055, 'Valkenboskwartier');
INSERT INTO buurt (code, naam) VALUES (5182110, 'Rond de Energiecentrale');
INSERT INTO buurt (code, naam) VALUES (5182144, 'Koningsplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (5182245, 'Zeeheldenkwartier');
INSERT INTO buurt (code, naam) VALUES (5182347, 'Willemspark');
INSERT INTO buurt (code, naam) VALUES (5182449, 'Haagse Bos');
INSERT INTO buurt (code, naam) VALUES (5182561, 'Landen');
INSERT INTO buurt (code, naam) VALUES (5182567, 'Kampen');
INSERT INTO buurt (code, naam) VALUES (5182568, 'Marlot');
INSERT INTO buurt (code, naam) VALUES (5182569, 'Burgen en Horsten');
INSERT INTO buurt (code, naam) VALUES (5182664, 'Bezuidenhout-West');
INSERT INTO buurt (code, naam) VALUES (5182665, 'Bezuidenhout-Midden');
INSERT INTO buurt (code, naam) VALUES (5182666, 'Bezuidenhout-Oost');
INSERT INTO buurt (code, naam) VALUES (5182718, 'Huygenspark');
INSERT INTO buurt (code, naam) VALUES (5182762, 'Rivierenbuurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (5182763, 'Rivierenbuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (5182811, 'Kortenbos');
INSERT INTO buurt (code, naam) VALUES (5182812, 'Voorhout');
INSERT INTO buurt (code, naam) VALUES (5182813, 'Uilebomen');
INSERT INTO buurt (code, naam) VALUES (5182814, 'Zuidwal');
INSERT INTO buurt (code, naam) VALUES (5182915, 'Schildersbuurt-West');
INSERT INTO buurt (code, naam) VALUES (5182916, 'Schildersbuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (5182917, 'Schildersbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (5183032, 'Transvaalkwartier-Noord');
INSERT INTO buurt (code, naam) VALUES (5183033, 'Transvaalkwartier-Midden');
INSERT INTO buurt (code, naam) VALUES (5183034, 'Transvaalkwartier-Zuid');
INSERT INTO buurt (code, naam) VALUES (5183130, 'Rustenburg');
INSERT INTO buurt (code, naam) VALUES (5183131, 'Oostbroek-Noord');
INSERT INTO buurt (code, naam) VALUES (5183135, 'Oostbroek-Zuid');
INSERT INTO buurt (code, naam) VALUES (5183284, 'Leyenburg');
INSERT INTO buurt (code, naam) VALUES (5183387, 'Venen, Oorden en Raden');
INSERT INTO buurt (code, naam) VALUES (5183396, 'Zijden, Steden en Zichten');
INSERT INTO buurt (code, naam) VALUES (5183398, 'Dreven en Gaarden');
INSERT INTO buurt (code, naam) VALUES (5183399, 'De Uithof');
INSERT INTO buurt (code, naam) VALUES (5183480, 'Morgenstond-Zuid');
INSERT INTO buurt (code, naam) VALUES (5183488, 'Morgenstond-West');
INSERT INTO buurt (code, naam) VALUES (5183489, 'Morgenstond-Oost');
INSERT INTO buurt (code, naam) VALUES (5183536, 'Zuiderpark');
INSERT INTO buurt (code, naam) VALUES (5183620, 'Moerwijk-Oost');
INSERT INTO buurt (code, naam) VALUES (5183637, 'Moerwijk-West');
INSERT INTO buurt (code, naam) VALUES (5183638, 'Moerwijk-Noord');
INSERT INTO buurt (code, naam) VALUES (5183639, 'Moerwijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (5183721, 'Groente- en Fruitmarkt');
INSERT INTO buurt (code, naam) VALUES (5183819, 'Laakhaven-Oost');
INSERT INTO buurt (code, naam) VALUES (5183822, 'Laakhaven-West');
INSERT INTO buurt (code, naam) VALUES (5183823, 'Spoorwijk');
INSERT INTO buurt (code, naam) VALUES (5183824, 'Laakkwartier-West');
INSERT INTO buurt (code, naam) VALUES (5183825, 'Laakkwartier-Oost');
INSERT INTO buurt (code, naam) VALUES (5183826, 'Noordpolderbuurt');
INSERT INTO buurt (code, naam) VALUES (5183960, 'Binckhorst');
INSERT INTO buurt (code, naam) VALUES (5184001, 'Erasmus Veld');
INSERT INTO buurt (code, naam) VALUES (5184002, 'Hoge Veld');
INSERT INTO buurt (code, naam) VALUES (5184003, 'Parkbuurt oosteinde');
INSERT INTO buurt (code, naam) VALUES (5184004, 'Lage Veld');
INSERT INTO buurt (code, naam) VALUES (5184005, 'Zonne Veld');
INSERT INTO buurt (code, naam) VALUES (5184106, 'Vlietbuurt');
INSERT INTO buurt (code, naam) VALUES (5184107, 'Vliegeniersbuurt');
INSERT INTO buurt (code, naam) VALUES (5184110, 'De Reef');
INSERT INTO buurt (code, naam) VALUES (5184208, 'Bosweide');
INSERT INTO buurt (code, naam) VALUES (5184209, 'Tedingerbuurt');
INSERT INTO buurt (code, naam) VALUES (5184211, 'De Venen');
INSERT INTO buurt (code, naam) VALUES (5184212, 'Morgenweide');
INSERT INTO buurt (code, naam) VALUES (5184213, 'Singels');
INSERT INTO buurt (code, naam) VALUES (5184214, 'Waterbuurt');
INSERT INTO buurt (code, naam) VALUES (5184215, 'De Bras');
INSERT INTO buurt (code, naam) VALUES (5184316, 'Westvliet');
INSERT INTO buurt (code, naam) VALUES (5184317, 'De Rivieren');
INSERT INTO buurt (code, naam) VALUES (5184418, 'De Lanen');
INSERT INTO buurt (code, naam) VALUES (5184419, 'De Velden');
INSERT INTO buurt (code, naam) VALUES (5184420, 'De Vissen');
INSERT INTO buurt (code, naam) VALUES (5184421, 'Rietbuurt');
INSERT INTO buurt (code, naam) VALUES (5189998, '');
INSERT INTO buurt (code, naam) VALUES (5230000, 'Boven-Hardinxveld');
INSERT INTO buurt (code, naam) VALUES (5230001, 'Neder-Hardinxveld');
INSERT INTO buurt (code, naam) VALUES (5230002, 'Giessendam');
INSERT INTO buurt (code, naam) VALUES (5230003, 'De Peulen');
INSERT INTO buurt (code, naam) VALUES (5300000, 'De Vesting');
INSERT INTO buurt (code, naam) VALUES (5300001, 'Glaciswijk');
INSERT INTO buurt (code, naam) VALUES (5300003, 'Groote Weergors');
INSERT INTO buurt (code, naam) VALUES (5300004, 'Marinebuurt');
INSERT INTO buurt (code, naam) VALUES (5300005, 'Dichters- en Schrijversbuurt');
INSERT INTO buurt (code, naam) VALUES (5300100, 'Nieuw-Helvoet');
INSERT INTO buurt (code, naam) VALUES (5300101, 'Bloemen- en Plantenbuurt');
INSERT INTO buurt (code, naam) VALUES (5300102, 'Kulck-Noord');
INSERT INTO buurt (code, naam) VALUES (5300103, 'Kulck-Zuid');
INSERT INTO buurt (code, naam) VALUES (5300104, 'Rijksstraatweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (5300105, 'Dorp en Hoonaart');
INSERT INTO buurt (code, naam) VALUES (5300106, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (5300107, 'Boomgaard');
INSERT INTO buurt (code, naam) VALUES (5300200, 'Nieuwenhoorn');
INSERT INTO buurt (code, naam) VALUES (5300201, '''t Lange Land');
INSERT INTO buurt (code, naam) VALUES (5300300, 'Kanaalzicht');
INSERT INTO buurt (code, naam) VALUES (5300301, 'Wittens Hoeck');
INSERT INTO buurt (code, naam) VALUES (5300302, 'Gorsingen Hoeck');
INSERT INTO buurt (code, naam) VALUES (5300303, 'Hooghen Hoeck');
INSERT INTO buurt (code, naam) VALUES (5300400, 'Hout Hoeffe');
INSERT INTO buurt (code, naam) VALUES (5300401, 'Koele Nacht');
INSERT INTO buurt (code, naam) VALUES (5300402, 'Morgen Stont');
INSERT INTO buurt (code, naam) VALUES (5300404, 'Vlotbrug');
INSERT INTO buurt (code, naam) VALUES (5300500, 'Tolhoeck');
INSERT INTO buurt (code, naam) VALUES (5300502, 'Out Jaar');
INSERT INTO buurt (code, naam) VALUES (5300503, 'Logendal');
INSERT INTO buurt (code, naam) VALUES (5300504, 'Kruis Hoeffe');
INSERT INTO buurt (code, naam) VALUES (5300505, 'Salem');
INSERT INTO buurt (code, naam) VALUES (5300600, 'Wagenzicht');
INSERT INTO buurt (code, naam) VALUES (5300601, 'Altena');
INSERT INTO buurt (code, naam) VALUES (5300700, 'Centrumgebied-West');
INSERT INTO buurt (code, naam) VALUES (5300701, 'Centrumgebied-Oost');
INSERT INTO buurt (code, naam) VALUES (5300800, 'Kickers Bloem');
INSERT INTO buurt (code, naam) VALUES (5300900, 'Duinhoeck');
INSERT INTO buurt (code, naam) VALUES (5300901, 'Buitengebied');
INSERT INTO buurt (code, naam) VALUES (5300902, 'Heliushaven');
INSERT INTO buurt (code, naam) VALUES (5309997, '');
INSERT INTO buurt (code, naam) VALUES (5309998, '');
INSERT INTO buurt (code, naam) VALUES (5310101, 'Dorp');
INSERT INTO buurt (code, naam) VALUES (5310102, 'Oostendam');
INSERT INTO buurt (code, naam) VALUES (5310103, 'Kruiswiel');
INSERT INTO buurt (code, naam) VALUES (5310201, 'Krommeweg-Noord');
INSERT INTO buurt (code, naam) VALUES (5310202, 'Krommeweg-Zuid');
INSERT INTO buurt (code, naam) VALUES (5310203, 'De Sandeling');
INSERT INTO buurt (code, naam) VALUES (5310204, 'Ambachtszone');
INSERT INTO buurt (code, naam) VALUES (5310301, 'Volgerlanden-West');
INSERT INTO buurt (code, naam) VALUES (5310302, 'Volgerlanden-Oost');
INSERT INTO buurt (code, naam) VALUES (5310400, 'Sandelingen-Ambacht');
INSERT INTO buurt (code, naam) VALUES (5310501, 'Antoniapolder');
INSERT INTO buurt (code, naam) VALUES (5310502, 'Noordoevers');
INSERT INTO buurt (code, naam) VALUES (5320000, 'Centrum Grootebroek');
INSERT INTO buurt (code, naam) VALUES (5320001, 'Lutjebroek');
INSERT INTO buurt (code, naam) VALUES (5320002, 'Kloosterhof en Oostersluis');
INSERT INTO buurt (code, naam) VALUES (5320100, 'Bovenkarspel-Centrum');
INSERT INTO buurt (code, naam) VALUES (5320101, 'Broekerhaven');
INSERT INTO buurt (code, naam) VALUES (5320102, 'Plan Zuid en Princenhof');
INSERT INTO buurt (code, naam) VALUES (5320103, 'Rozeboom');
INSERT INTO buurt (code, naam) VALUES (5329997, '');
INSERT INTO buurt (code, naam) VALUES (5340000, 'Hillegom');
INSERT INTO buurt (code, naam) VALUES (5340001, 'Arnoud');
INSERT INTO buurt (code, naam) VALUES (5340002, 'Oosteinde');
INSERT INTO buurt (code, naam) VALUES (5340003, 'Meer en Dorp');
INSERT INTO buurt (code, naam) VALUES (5340004, 'Elsbroeker polder');
INSERT INTO buurt (code, naam) VALUES (5340005, 'Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (5340008, 'Verspreide huizen in het Oosten');
INSERT INTO buurt (code, naam) VALUES (5340009, 'Verspreide huizen in het Westen');
INSERT INTO buurt (code, naam) VALUES (5370101, 'Rijnsoever-West');
INSERT INTO buurt (code, naam) VALUES (5370102, 'Rijnsoever-Oost');
INSERT INTO buurt (code, naam) VALUES (5370103, 'Hoornes-West');
INSERT INTO buurt (code, naam) VALUES (5370104, 'Hoornes-Oost');
INSERT INTO buurt (code, naam) VALUES (5370201, '''t Heen-Zuid');
INSERT INTO buurt (code, naam) VALUES (5370202, '''t Heen-Noord');
INSERT INTO buurt (code, naam) VALUES (5370301, 'Dorp');
INSERT INTO buurt (code, naam) VALUES (5370302, '''t Sandt');
INSERT INTO buurt (code, naam) VALUES (5370303, 'Molenwijk');
INSERT INTO buurt (code, naam) VALUES (5370401, 'Witte Hek');
INSERT INTO buurt (code, naam) VALUES (5370402, 'Cleijn Duin');
INSERT INTO buurt (code, naam) VALUES (5370403, 'Overduin');
INSERT INTO buurt (code, naam) VALUES (5370404, 'Koestal');
INSERT INTO buurt (code, naam) VALUES (5370501, 'Strand');
INSERT INTO buurt (code, naam) VALUES (5370502, 'De Noord');
INSERT INTO buurt (code, naam) VALUES (5370503, 'Noord-Oost');
INSERT INTO buurt (code, naam) VALUES (5370504, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (5370505, 'Midden');
INSERT INTO buurt (code, naam) VALUES (5370506, 'Zuid-West');
INSERT INTO buurt (code, naam) VALUES (5370507, 'Zuid-Oost');
INSERT INTO buurt (code, naam) VALUES (5370601, 'Noordduinen');
INSERT INTO buurt (code, naam) VALUES (5370602, 'Zuidduinen');
INSERT INTO buurt (code, naam) VALUES (5370603, 'Zanderij Westerbaan');
INSERT INTO buurt (code, naam) VALUES (5370604, 'De Mient en Kooltuin');
INSERT INTO buurt (code, naam) VALUES (5370700, 'Rijnsburg');
INSERT INTO buurt (code, naam) VALUES (5370701, 'Valkenburgerweg');
INSERT INTO buurt (code, naam) VALUES (5370708, 'Polder Kamphuizen');
INSERT INTO buurt (code, naam) VALUES (5370709, 'Verspreide huizen Rijnsburg');
INSERT INTO buurt (code, naam) VALUES (5370800, 'Valkenburg');
INSERT INTO buurt (code, naam) VALUES (5370808, 'Verspreide huizen Ommedijkse Polder');
INSERT INTO buurt (code, naam) VALUES (5370809, 'Overige verspreide huizen Valkenburg');
INSERT INTO buurt (code, naam) VALUES (5379998, '');
INSERT INTO buurt (code, naam) VALUES (5420000, 'Oud Krimpen');
INSERT INTO buurt (code, naam) VALUES (5420001, 'Kortland-Noord');
INSERT INTO buurt (code, naam) VALUES (5420002, 'Kortland-Zuid');
INSERT INTO buurt (code, naam) VALUES (5420003, 'Boveneind');
INSERT INTO buurt (code, naam) VALUES (5420004, 'Langeland');
INSERT INTO buurt (code, naam) VALUES (5420005, 'Lansingh-Zuid');
INSERT INTO buurt (code, naam) VALUES (5450001, 'Leerdam-Centrum');
INSERT INTO buurt (code, naam) VALUES (5450002, 'Leerdam-West');
INSERT INTO buurt (code, naam) VALUES (5450003, 'Leerdam-Oost');
INSERT INTO buurt (code, naam) VALUES (5450004, 'Leerdam-Noord');
INSERT INTO buurt (code, naam) VALUES (5450005, 'Verspreide huizen Leerdam');
INSERT INTO buurt (code, naam) VALUES (5450006, 'Kedichem');
INSERT INTO buurt (code, naam) VALUES (5450007, 'Schoonrewoerd');
INSERT INTO buurt (code, naam) VALUES (5460000, 'Pieterswijk');
INSERT INTO buurt (code, naam) VALUES (5460001, 'Academiewijk');
INSERT INTO buurt (code, naam) VALUES (5460002, 'Levendaal-West');
INSERT INTO buurt (code, naam) VALUES (5460003, 'Levendaal-Oost');
INSERT INTO buurt (code, naam) VALUES (5460100, 'De Camp');
INSERT INTO buurt (code, naam) VALUES (5460101, 'Marewijk');
INSERT INTO buurt (code, naam) VALUES (5460102, 'Pancras-West');
INSERT INTO buurt (code, naam) VALUES (5460103, 'Pancras-Oost');
INSERT INTO buurt (code, naam) VALUES (5460104, 'D''Oude Morsch');
INSERT INTO buurt (code, naam) VALUES (5460105, 'Noordvest');
INSERT INTO buurt (code, naam) VALUES (5460106, 'Havenwijk-Noord');
INSERT INTO buurt (code, naam) VALUES (5460107, 'Havenwijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (5460108, 'Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (5460109, 'De Waard');
INSERT INTO buurt (code, naam) VALUES (5460200, 'Stationskwartier');
INSERT INTO buurt (code, naam) VALUES (5460300, 'Groenoord');
INSERT INTO buurt (code, naam) VALUES (5460301, 'Noorderkwartier');
INSERT INTO buurt (code, naam) VALUES (5460302, 'De Kooi');
INSERT INTO buurt (code, naam) VALUES (5460400, 'Meerburg');
INSERT INTO buurt (code, naam) VALUES (5460401, 'Rijndijkbuurt');
INSERT INTO buurt (code, naam) VALUES (5460402, 'Professorenwijk-Oost');
INSERT INTO buurt (code, naam) VALUES (5460403, 'Burgemeesterswijk');
INSERT INTO buurt (code, naam) VALUES (5460404, 'Professorenwijk-West');
INSERT INTO buurt (code, naam) VALUES (5460405, 'Tuinstadwijk');
INSERT INTO buurt (code, naam) VALUES (5460406, 'Cronestein');
INSERT INTO buurt (code, naam) VALUES (5460407, 'Klein Cronestein');
INSERT INTO buurt (code, naam) VALUES (5460408, 'Roomburg');
INSERT INTO buurt (code, naam) VALUES (5460409, 'Waardeiland');
INSERT INTO buurt (code, naam) VALUES (5460500, 'Vreewijk');
INSERT INTO buurt (code, naam) VALUES (5460501, 'Haagweg-Noord');
INSERT INTO buurt (code, naam) VALUES (5460502, 'Gasthuiswijk');
INSERT INTO buurt (code, naam) VALUES (5460503, 'Fortuinwijk-Noord');
INSERT INTO buurt (code, naam) VALUES (5460504, 'Boshuizen');
INSERT INTO buurt (code, naam) VALUES (5460505, 'Oostvliet');
INSERT INTO buurt (code, naam) VALUES (5460506, 'Haagweg-Zuid');
INSERT INTO buurt (code, naam) VALUES (5460507, 'Fortuinwijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (5460600, 'Transvaalbuurt');
INSERT INTO buurt (code, naam) VALUES (5460601, 'Lage Mors');
INSERT INTO buurt (code, naam) VALUES (5460602, 'Hoge Mors');
INSERT INTO buurt (code, naam) VALUES (5460700, 'Pesthuiswijk');
INSERT INTO buurt (code, naam) VALUES (5460701, 'Houtkwartier');
INSERT INTO buurt (code, naam) VALUES (5460702, 'Raadsherenbuurt');
INSERT INTO buurt (code, naam) VALUES (5460703, 'Vogelwijk');
INSERT INTO buurt (code, naam) VALUES (5460704, 'Leeuwenhoek');
INSERT INTO buurt (code, naam) VALUES (5460800, 'Slaaghwijk');
INSERT INTO buurt (code, naam) VALUES (5460801, 'Zijlwijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (5460802, 'Zijlwijk-Noord');
INSERT INTO buurt (code, naam) VALUES (5460803, 'Merenwijk-Centrum');
INSERT INTO buurt (code, naam) VALUES (5460804, 'Leedewijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (5460805, 'Leedewijk-Noord');
INSERT INTO buurt (code, naam) VALUES (5460900, 'Schenkwijk');
INSERT INTO buurt (code, naam) VALUES (5460901, 'Kloosterhof');
INSERT INTO buurt (code, naam) VALUES (5460902, 'Dobbewijk-Noord');
INSERT INTO buurt (code, naam) VALUES (5460903, 'Dobbewijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (5470000, 'Kerkwijk');
INSERT INTO buurt (code, naam) VALUES (5470001, 'Ouderzorg inclusief De Houtkamp');
INSERT INTO buurt (code, naam) VALUES (5470002, 'Zijlkwartier');
INSERT INTO buurt (code, naam) VALUES (5470003, 'De Vogelwijk');
INSERT INTO buurt (code, naam) VALUES (5470004, 'De Baanderij');
INSERT INTO buurt (code, naam) VALUES (5470005, 'De Schansen');
INSERT INTO buurt (code, naam) VALUES (5470006, 'Winkelhof');
INSERT INTO buurt (code, naam) VALUES (5470007, 'Binnenhof');
INSERT INTO buurt (code, naam) VALUES (5470008, 'Voorhof');
INSERT INTO buurt (code, naam) VALUES (5470009, 'Elizabethhof');
INSERT INTO buurt (code, naam) VALUES (5470100, 'Oranjewijk');
INSERT INTO buurt (code, naam) VALUES (5470101, 'Doeskwartier');
INSERT INTO buurt (code, naam) VALUES (5470109, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (5470200, 'Buitenhof-Oost-Zuid');
INSERT INTO buurt (code, naam) VALUES (5470201, 'Buitenhof-Midden-West');
INSERT INTO buurt (code, naam) VALUES (5470202, 'Leyhof');
INSERT INTO buurt (code, naam) VALUES (5530100, 'De Loosters');
INSERT INTO buurt (code, naam) VALUES (5530200, 'Halfweg');
INSERT INTO buurt (code, naam) VALUES (5530300, 'Meer en Duin');
INSERT INTO buurt (code, naam) VALUES (5530400, 'De Blinkerd');
INSERT INTO buurt (code, naam) VALUES (5530500, 'Meerenburgh');
INSERT INTO buurt (code, naam) VALUES (5530600, 'Oranjewijk');
INSERT INTO buurt (code, naam) VALUES (5530700, 'Zeeheldenwijk');
INSERT INTO buurt (code, naam) VALUES (5530800, 'Bloemenwijk');
INSERT INTO buurt (code, naam) VALUES (5530900, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (5531000, 'Berkhout');
INSERT INTO buurt (code, naam) VALUES (5531100, 'Van Rijckevorsel');
INSERT INTO buurt (code, naam) VALUES (5531200, 'Componistenwijk');
INSERT INTO buurt (code, naam) VALUES (5531300, 'Schilderswijk');
INSERT INTO buurt (code, naam) VALUES (5531400, 'Vogelwijk');
INSERT INTO buurt (code, naam) VALUES (5531500, 'Dever');
INSERT INTO buurt (code, naam) VALUES (5531600, 'Geestwater');
INSERT INTO buurt (code, naam) VALUES (5531700, 'Vrouwenpolder');
INSERT INTO buurt (code, naam) VALUES (5531800, 'Lisse Rond');
INSERT INTO buurt (code, naam) VALUES (5531900, 'De Engel');
INSERT INTO buurt (code, naam) VALUES (5532000, 'Ter Beek');
INSERT INTO buurt (code, naam) VALUES (5532100, 'Roovers Broek');
INSERT INTO buurt (code, naam) VALUES (5560101, 'Taanschuurpolder');
INSERT INTO buurt (code, naam) VALUES (5560201, 'Vertobuurt');
INSERT INTO buurt (code, naam) VALUES (5560202, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (5560203, 'Bomendal');
INSERT INTO buurt (code, naam) VALUES (5560301, 'Sluispolder Oost');
INSERT INTO buurt (code, naam) VALUES (5560302, 'Sluispolder West');
INSERT INTO buurt (code, naam) VALUES (5560303, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (5560401, 'Kapelpolder');
INSERT INTO buurt (code, naam) VALUES (5560402, 'Componistenbuurt');
INSERT INTO buurt (code, naam) VALUES (5560403, 'Koningshoek');
INSERT INTO buurt (code, naam) VALUES (5560404, 'Het Balkon');
INSERT INTO buurt (code, naam) VALUES (5560405, 'Nieuwe waterweg');
INSERT INTO buurt (code, naam) VALUES (5560501, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (5560502, 'Burgemeesterswijk');
INSERT INTO buurt (code, naam) VALUES (5560601, 'Steendijkpolder Noord');
INSERT INTO buurt (code, naam) VALUES (5560602, 'Steendijkpolder Zuid');
INSERT INTO buurt (code, naam) VALUES (5560701, 'Zuidbuurt');
INSERT INTO buurt (code, naam) VALUES (5560702, 'De Dijk');
INSERT INTO buurt (code, naam) VALUES (5560801, 'Wilgenrijk');
INSERT INTO buurt (code, naam) VALUES (5680000, 'Abbenbroek');
INSERT INTO buurt (code, naam) VALUES (5680001, 'Poldergebied Abbenbroek');
INSERT INTO buurt (code, naam) VALUES (5680100, 'Heenvliet');
INSERT INTO buurt (code, naam) VALUES (5680101, 'Bloemendaele');
INSERT INTO buurt (code, naam) VALUES (5680102, 'Ravensteijn-West');
INSERT INTO buurt (code, naam) VALUES (5680103, 'Poldergebied Heenvliet');
INSERT INTO buurt (code, naam) VALUES (5680200, 'Geervliet');
INSERT INTO buurt (code, naam) VALUES (5680201, 'Geervliet-Noordoost');
INSERT INTO buurt (code, naam) VALUES (5680202, 'Simonshaven');
INSERT INTO buurt (code, naam) VALUES (5680203, 'Poldergebied Geervliet');
INSERT INTO buurt (code, naam) VALUES (5680300, 'Zuidland');
INSERT INTO buurt (code, naam) VALUES (5680301, 'De Kerckhoek');
INSERT INTO buurt (code, naam) VALUES (5680302, 'Poldergebied Zuidland');
INSERT INTO buurt (code, naam) VALUES (5680400, 'Oudenhoorn');
INSERT INTO buurt (code, naam) VALUES (5680401, 'Polder Nieuwenhoorn');
INSERT INTO buurt (code, naam) VALUES (5680402, 'Polder Oudenhoorn');
INSERT INTO buurt (code, naam) VALUES (5689997, '');
INSERT INTO buurt (code, naam) VALUES (5690000, 'Nieuwkoop');
INSERT INTO buurt (code, naam) VALUES (5690001, 'Noorden (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5690002, 'Nieuwveenseweg');
INSERT INTO buurt (code, naam) VALUES (5690003, 'Uitbreiding dorpskern Nieuwkoop');
INSERT INTO buurt (code, naam) VALUES (5690004, 'Achttienhoven');
INSERT INTO buurt (code, naam) VALUES (5690005, 'Uitbreiding dorpskern Noorden');
INSERT INTO buurt (code, naam) VALUES (5690006, 'Woerdense Verlaat');
INSERT INTO buurt (code, naam) VALUES (5690008, 'Verspreide huizen in het Noorden');
INSERT INTO buurt (code, naam) VALUES (5690009, 'Verspreide huizen en Nieuwkoop Plassengebied');
INSERT INTO buurt (code, naam) VALUES (5690100, 'Nieuwveen');
INSERT INTO buurt (code, naam) VALUES (5690101, 'Schoterveld');
INSERT INTO buurt (code, naam) VALUES (5690104, 'Vrouwenakker');
INSERT INTO buurt (code, naam) VALUES (5690108, 'Verspreide huizen in het Oosten en Zuiden');
INSERT INTO buurt (code, naam) VALUES (5690109, 'Verspreide huizen in het Noorden');
INSERT INTO buurt (code, naam) VALUES (5690200, 'Zevenhoven');
INSERT INTO buurt (code, naam) VALUES (5690201, 'Noordse Dorp');
INSERT INTO buurt (code, naam) VALUES (5690202, 'Recreatiegebied');
INSERT INTO buurt (code, naam) VALUES (5690203, 'Noordse Buurt');
INSERT INTO buurt (code, naam) VALUES (5690208, 'Verspreide huizen in het Westen');
INSERT INTO buurt (code, naam) VALUES (5690209, 'Verspreide huizen in het Oosten');
INSERT INTO buurt (code, naam) VALUES (5690300, 'Ter Aar (buitengebied)');
INSERT INTO buurt (code, naam) VALUES (5690301, 'Langeraar');
INSERT INTO buurt (code, naam) VALUES (5690302, 'Papenveer');
INSERT INTO buurt (code, naam) VALUES (5690303, 'Korteraar');
INSERT INTO buurt (code, naam) VALUES (5690305, 'Ter Aar-Centrum (voorheen Aardam)');
INSERT INTO buurt (code, naam) VALUES (5690306, 'Langeraar-Nieuwbouw');
INSERT INTO buurt (code, naam) VALUES (5690309, 'Verspreide huizen Ter Aar');
INSERT INTO buurt (code, naam) VALUES (5750000, 'Dorpskern');
INSERT INTO buurt (code, naam) VALUES (5750001, 'Beeklaan-kwartier');
INSERT INTO buurt (code, naam) VALUES (5750002, 'Boerenburg en Grashoek');
INSERT INTO buurt (code, naam) VALUES (5750004, 'Estec');
INSERT INTO buurt (code, naam) VALUES (5750005, 'Dr. Mr. W. van den Berghstichting');
INSERT INTO buurt (code, naam) VALUES (5750009, 'Verspreide huizen Zuiden en Oosten');
INSERT INTO buurt (code, naam) VALUES (5750100, 'Dorpskern');
INSERT INTO buurt (code, naam) VALUES (5750101, 'Villawijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (5750102, 'De Noord');
INSERT INTO buurt (code, naam) VALUES (5750108, 'Sancta Maria');
INSERT INTO buurt (code, naam) VALUES (5750109, 'Verspreide huizen Langeveld');
INSERT INTO buurt (code, naam) VALUES (5759998, '');
INSERT INTO buurt (code, naam) VALUES (5760000, 'Noordwijkerhout');
INSERT INTO buurt (code, naam) VALUES (5760001, 'Kleine Zilk');
INSERT INTO buurt (code, naam) VALUES (5760002, 'Grote Zilk');
INSERT INTO buurt (code, naam) VALUES (5760008, 'Verspreide huizen ten zuiden van de gemeente');
INSERT INTO buurt (code, naam) VALUES (5760009, 'Verspreide huizen in het Centrum');
INSERT INTO buurt (code, naam) VALUES (5790001, 'Rhijngeest');
INSERT INTO buurt (code, naam) VALUES (5790002, 'Rijnfront');
INSERT INTO buurt (code, naam) VALUES (5790003, 'Buitengebied');
INSERT INTO buurt (code, naam) VALUES (5790011, 'Oranje Nassau');
INSERT INTO buurt (code, naam) VALUES (5790012, 'Oudenhof');
INSERT INTO buurt (code, naam) VALUES (5790013, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (5790014, 'Voscuyl');
INSERT INTO buurt (code, naam) VALUES (5790015, 'Buitenlust');
INSERT INTO buurt (code, naam) VALUES (5790021, 'Haaswijk-West');
INSERT INTO buurt (code, naam) VALUES (5790022, 'Haaswijk-Oost');
INSERT INTO buurt (code, naam) VALUES (5790023, 'De Morsebel');
INSERT INTO buurt (code, naam) VALUES (5790024, 'Poelgeest');
INSERT INTO buurt (code, naam) VALUES (5840001, 'Bedrijventerrein De Bosschen');
INSERT INTO buurt (code, naam) VALUES (5840002, 'Oosterse Gorzenwijk');
INSERT INTO buurt (code, naam) VALUES (5840003, 'Centrum-Noord');
INSERT INTO buurt (code, naam) VALUES (5840004, 'Croonenburghwijk');
INSERT INTO buurt (code, naam) VALUES (5840005, 'Centrum-Zuid');
INSERT INTO buurt (code, naam) VALUES (5840006, 'Zeeheldenwijk');
INSERT INTO buurt (code, naam) VALUES (5840007, 'Zuidwijk');
INSERT INTO buurt (code, naam) VALUES (5840008, 'Zoomwijck');
INSERT INTO buurt (code, naam) VALUES (5840009, 'Spuioeverwijk');
INSERT INTO buurt (code, naam) VALUES (5840010, 'Bedrijventerrein Langeweg, Rembrandtstraat');
INSERT INTO buurt (code, naam) VALUES (5840011, 'Poortwijk');
INSERT INTO buurt (code, naam) VALUES (5840012, 'Zinkweg buurtschap');
INSERT INTO buurt (code, naam) VALUES (5840013, 'Landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (5850000, 'Heinenoord');
INSERT INTO buurt (code, naam) VALUES (5850001, 'Goidschalxoord');
INSERT INTO buurt (code, naam) VALUES (5850002, 'Blaak');
INSERT INTO buurt (code, naam) VALUES (5850003, 'Uitbreiding Dorp Heinenoord');
INSERT INTO buurt (code, naam) VALUES (5850004, 'Uitbreiding Dorp na 1971');
INSERT INTO buurt (code, naam) VALUES (5850009, 'Verspreide huizen Heinenoord');
INSERT INTO buurt (code, naam) VALUES (5850100, 'Mijnsheerenland');
INSERT INTO buurt (code, naam) VALUES (5850101, 'Westdijk');
INSERT INTO buurt (code, naam) VALUES (5850102, 'Stougjesdijk (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5850103, 'Blaaksedijk (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5850104, 'Uitbreiding Dorp');
INSERT INTO buurt (code, naam) VALUES (5850108, 'Verspreide huizen Westmaas-Nieuwlandse polder');
INSERT INTO buurt (code, naam) VALUES (5850109, 'Verspreide huizen Moerkerken');
INSERT INTO buurt (code, naam) VALUES (5850200, 'Westmaas');
INSERT INTO buurt (code, naam) VALUES (5850201, 'Greup');
INSERT INTO buurt (code, naam) VALUES (5850202, 'Grote Riethure');
INSERT INTO buurt (code, naam) VALUES (5850208, 'Verspreide huizen polder Munnikenland');
INSERT INTO buurt (code, naam) VALUES (5850209, 'Verspreide huizen in het Westen');
INSERT INTO buurt (code, naam) VALUES (5850300, 'Maasdam');
INSERT INTO buurt (code, naam) VALUES (5850301, 'Cillaarshoek (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5850302, 'Sint Anthoniepolder');
INSERT INTO buurt (code, naam) VALUES (5850303, 'Maasdam nieuwbouw');
INSERT INTO buurt (code, naam) VALUES (5850304, 'Bungalow plan');
INSERT INTO buurt (code, naam) VALUES (5850307, 'Bedrijfsterreinen');
INSERT INTO buurt (code, naam) VALUES (5850309, 'Verspreide huizen Maasdam');
INSERT INTO buurt (code, naam) VALUES (5850400, 'Bebouwde Kom, oud gedeelte');
INSERT INTO buurt (code, naam) VALUES (5850401, 'Rustenburgstraat (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5850402, 'Bebouwde Kom Plan Dorp');
INSERT INTO buurt (code, naam) VALUES (5850403, 'Bebouwde Kom Plan Oudeland');
INSERT INTO buurt (code, naam) VALUES (5850405, 'Plan De Grienden');
INSERT INTO buurt (code, naam) VALUES (5850406, 'Plan Zijdewinde');
INSERT INTO buurt (code, naam) VALUES (5850408, 'Verspreide huizen in het Zuidoosten');
INSERT INTO buurt (code, naam) VALUES (5850409, 'Suikerfabriek en verspreide huizen Noordwesten');
INSERT INTO buurt (code, naam) VALUES (5850500, '''s-Gravendeel');
INSERT INTO buurt (code, naam) VALUES (5850501, 'Boendersweg-Strijensedijk (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5850502, 'Nieuw Bonaventura');
INSERT INTO buurt (code, naam) VALUES (5850503, 'Schenkeldijk');
INSERT INTO buurt (code, naam) VALUES (5850504, 'Mijlpolder');
INSERT INTO buurt (code, naam) VALUES (5850505, 'Groot en Klein Koninkrijk');
INSERT INTO buurt (code, naam) VALUES (5850506, 'Schuilingen');
INSERT INTO buurt (code, naam) VALUES (5850509, 'Verspreide huizen ''s-Gravendeel');
INSERT INTO buurt (code, naam) VALUES (5880000, 'Nieuw-Beijerland');
INSERT INTO buurt (code, naam) VALUES (5880001, 'Zuidzijde (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5880009, 'Verspreide huizen Nieuw-Beijerland');
INSERT INTO buurt (code, naam) VALUES (5880100, 'Piershil');
INSERT INTO buurt (code, naam) VALUES (5880103, 'Zwartsluisje (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5880109, 'Verspreide huizen Piershil');
INSERT INTO buurt (code, naam) VALUES (5880200, 'Goudswaard');
INSERT INTO buurt (code, naam) VALUES (5880201, 'Nieuwendijk (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5880202, 'Oudendijk');
INSERT INTO buurt (code, naam) VALUES (5880208, 'Verspreide huizen Eiland Tiengemeten (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5880209, 'Overige verspreide huizen Goudswaard');
INSERT INTO buurt (code, naam) VALUES (5880300, 'Zuid-Beijerland');
INSERT INTO buurt (code, naam) VALUES (5880301, 'Zwartsluisje (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5880302, 'Zuidzijde (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5880303, 'Schenkeldijk');
INSERT INTO buurt (code, naam) VALUES (5880304, 'Nieuwendijk (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5880308, 'Verspreide huizen Eiland Tiengemeten (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (5880309, 'Overige verspreide huizen Zuid-Beijerland');
INSERT INTO buurt (code, naam) VALUES (5889997, '');
INSERT INTO buurt (code, naam) VALUES (5890000, 'Oudewater');
INSERT INTO buurt (code, naam) VALUES (5890001, 'Brede Dijk');
INSERT INTO buurt (code, naam) VALUES (5890002, 'Klein Hekendorp');
INSERT INTO buurt (code, naam) VALUES (5890100, 'Hoenkoopse Buurtweg');
INSERT INTO buurt (code, naam) VALUES (5890101, 'Goudse Straatweg');
INSERT INTO buurt (code, naam) VALUES (5890109, 'Verspreide huizen Rozendaal');
INSERT INTO buurt (code, naam) VALUES (5890200, 'Snelrewaard');
INSERT INTO buurt (code, naam) VALUES (5890201, 'Lange Linschoten');
INSERT INTO buurt (code, naam) VALUES (5890202, 'Snelrewaard-West');
INSERT INTO buurt (code, naam) VALUES (5890300, 'Hekendorp');
INSERT INTO buurt (code, naam) VALUES (5890301, 'Papekop');
INSERT INTO buurt (code, naam) VALUES (5890302, 'Hekendorpse buurt');
INSERT INTO buurt (code, naam) VALUES (5890303, 'Ruigeweide');
INSERT INTO buurt (code, naam) VALUES (5890304, 'Diemerbroek');
INSERT INTO buurt (code, naam) VALUES (5890305, 'Papekopperstraatweg');
INSERT INTO buurt (code, naam) VALUES (5900001, 'Westpolder');
INSERT INTO buurt (code, naam) VALUES (5900002, 'Molenvliet');
INSERT INTO buurt (code, naam) VALUES (5900003, 'Kraaihoek');
INSERT INTO buurt (code, naam) VALUES (5900004, 'Middenpolder');
INSERT INTO buurt (code, naam) VALUES (5900005, 'Wilgendonk');
INSERT INTO buurt (code, naam) VALUES (5900006, 'Oosteind en De Kooy');
INSERT INTO buurt (code, naam) VALUES (5900007, 'Oostpolder');
INSERT INTO buurt (code, naam) VALUES (5900008, 'Vriesenpolder');
INSERT INTO buurt (code, naam) VALUES (5970001, 'Ridderkerk-Centrum');
INSERT INTO buurt (code, naam) VALUES (5970002, 'Ridderkerk-West');
INSERT INTO buurt (code, naam) VALUES (5970003, 'Ridderkerk-Oost');
INSERT INTO buurt (code, naam) VALUES (5970004, 'Drievliet');
INSERT INTO buurt (code, naam) VALUES (5970005, 'Het Zand');
INSERT INTO buurt (code, naam) VALUES (5970006, 'Slikkeveer');
INSERT INTO buurt (code, naam) VALUES (5970007, 'Bolnes');
INSERT INTO buurt (code, naam) VALUES (5970008, 'Rijsoord');
INSERT INTO buurt (code, naam) VALUES (5970009, 'Oostendam');
INSERT INTO buurt (code, naam) VALUES (5970010, 'Donkersloot');
INSERT INTO buurt (code, naam) VALUES (5970011, 'Verenambacht');
INSERT INTO buurt (code, naam) VALUES (5970012, 'Cornelisland');
INSERT INTO buurt (code, naam) VALUES (5990110, 'Stadsdriehoek');
INSERT INTO buurt (code, naam) VALUES (5990111, 'Oude Westen');
INSERT INTO buurt (code, naam) VALUES (5990112, 'Cool');
INSERT INTO buurt (code, naam) VALUES (5990113, 'C.S. kwartier');
INSERT INTO buurt (code, naam) VALUES (5990118, 'Nieuwe Werk');
INSERT INTO buurt (code, naam) VALUES (5990119, 'Dijkzigt');
INSERT INTO buurt (code, naam) VALUES (5990320, 'Delfshaven');
INSERT INTO buurt (code, naam) VALUES (5990321, 'Bospolder');
INSERT INTO buurt (code, naam) VALUES (5990322, 'Tussendijken');
INSERT INTO buurt (code, naam) VALUES (5990323, 'Spangen');
INSERT INTO buurt (code, naam) VALUES (5990324, 'Nieuwe Westen');
INSERT INTO buurt (code, naam) VALUES (5990325, 'Middelland');
INSERT INTO buurt (code, naam) VALUES (5990327, 'Oud-Mathenesse');
INSERT INTO buurt (code, naam) VALUES (5990328, 'Witte Dorp');
INSERT INTO buurt (code, naam) VALUES (5990329, 'Schiemond');
INSERT INTO buurt (code, naam) VALUES (5990451, 'Kleinpolder');
INSERT INTO buurt (code, naam) VALUES (5990452, 'Noord-Kethel');
INSERT INTO buurt (code, naam) VALUES (5990454, 'Schieveen');
INSERT INTO buurt (code, naam) VALUES (5990455, 'Zestienhoven');
INSERT INTO buurt (code, naam) VALUES (5990456, 'Overschie');
INSERT INTO buurt (code, naam) VALUES (5990457, 'Landzicht');
INSERT INTO buurt (code, naam) VALUES (5990515, 'Agniesebuurt');
INSERT INTO buurt (code, naam) VALUES (5990516, 'Provenierswijk');
INSERT INTO buurt (code, naam) VALUES (5990531, 'Bergpolder');
INSERT INTO buurt (code, naam) VALUES (5990532, 'Blijdorp');
INSERT INTO buurt (code, naam) VALUES (5990534, 'Liskwartier');
INSERT INTO buurt (code, naam) VALUES (5990535, 'Oude Noorden');
INSERT INTO buurt (code, naam) VALUES (5990558, 'Blijdorpse Polder');
INSERT INTO buurt (code, naam) VALUES (5990660, 'Schiebroek');
INSERT INTO buurt (code, naam) VALUES (5990661, 'Hillegersberg-Zuid');
INSERT INTO buurt (code, naam) VALUES (5990662, 'Hillegersberg-Noord');
INSERT INTO buurt (code, naam) VALUES (5990664, 'Terbregge');
INSERT INTO buurt (code, naam) VALUES (5990665, 'Molenlaankwartier');
INSERT INTO buurt (code, naam) VALUES (5990814, 'Rubroek');
INSERT INTO buurt (code, naam) VALUES (5990836, 'Nieuw-Crooswijk');
INSERT INTO buurt (code, naam) VALUES (5990837, 'Oud-Crooswijk');
INSERT INTO buurt (code, naam) VALUES (5990841, 'Kralingen-West');
INSERT INTO buurt (code, naam) VALUES (5990842, 'Kralingen-Oost');
INSERT INTO buurt (code, naam) VALUES (5990843, 'Kralingse Bos');
INSERT INTO buurt (code, naam) VALUES (5990845, 'De Esch');
INSERT INTO buurt (code, naam) VALUES (5990847, 'Struisenburg');
INSERT INTO buurt (code, naam) VALUES (5991017, 'Kop van Zuid');
INSERT INTO buurt (code, naam) VALUES (5991079, 'Kop van Zuid-Entrepot');
INSERT INTO buurt (code, naam) VALUES (5991080, 'Vreewijk');
INSERT INTO buurt (code, naam) VALUES (5991081, 'Bloemhof');
INSERT INTO buurt (code, naam) VALUES (5991082, 'Hillesluis');
INSERT INTO buurt (code, naam) VALUES (5991085, 'Katendrecht');
INSERT INTO buurt (code, naam) VALUES (5991086, 'Afrikaanderwijk');
INSERT INTO buurt (code, naam) VALUES (5991087, 'Feijenoord');
INSERT INTO buurt (code, naam) VALUES (5991088, 'Noordereiland');
INSERT INTO buurt (code, naam) VALUES (5991283, 'Oud-IJsselmonde');
INSERT INTO buurt (code, naam) VALUES (5991284, 'Lombardijen');
INSERT INTO buurt (code, naam) VALUES (5991289, 'Groot-IJsselmonde');
INSERT INTO buurt (code, naam) VALUES (5991290, 'Beverwaard');
INSERT INTO buurt (code, naam) VALUES (5991391, 'Pernis');
INSERT INTO buurt (code, naam) VALUES (5991444, '''s-Gravenland');
INSERT INTO buurt (code, naam) VALUES (5991446, 'Kralingse Veer');
INSERT INTO buurt (code, naam) VALUES (5991448, 'Prinsenland');
INSERT INTO buurt (code, naam) VALUES (5991449, 'Het Lage Land');
INSERT INTO buurt (code, naam) VALUES (5991463, 'Ommoord');
INSERT INTO buurt (code, naam) VALUES (5991466, 'Zevenkamp');
INSERT INTO buurt (code, naam) VALUES (5991467, 'Oosterflank');
INSERT INTO buurt (code, naam) VALUES (5991468, 'Nesselande');
INSERT INTO buurt (code, naam) VALUES (5991570, 'Charlois Zuidrand');
INSERT INTO buurt (code, naam) VALUES (5991571, 'Tarwewijk');
INSERT INTO buurt (code, naam) VALUES (5991572, 'Carnisse');
INSERT INTO buurt (code, naam) VALUES (5991573, 'Zuidwijk');
INSERT INTO buurt (code, naam) VALUES (5991574, 'Oud-Charlois');
INSERT INTO buurt (code, naam) VALUES (5991575, 'Wielewaal');
INSERT INTO buurt (code, naam) VALUES (5991576, 'Zuidplein');
INSERT INTO buurt (code, naam) VALUES (5991577, 'Pendrecht');
INSERT INTO buurt (code, naam) VALUES (5991578, 'Zuiderpark');
INSERT INTO buurt (code, naam) VALUES (5991593, 'Heijplaat');
INSERT INTO buurt (code, naam) VALUES (5991692, 'Hoogvliet-Noord');
INSERT INTO buurt (code, naam) VALUES (5991699, 'Hoogvliet-Zuid');
INSERT INTO buurt (code, naam) VALUES (5991701, 'Strand en Duin');
INSERT INTO buurt (code, naam) VALUES (5991702, 'Dorp');
INSERT INTO buurt (code, naam) VALUES (5991703, 'Rijnpoort');
INSERT INTO buurt (code, naam) VALUES (5991853, 'Spaanse Polder');
INSERT INTO buurt (code, naam) VALUES (5991926, 'Nieuw-Mathenesse');
INSERT INTO buurt (code, naam) VALUES (5992194, 'Waalhaven');
INSERT INTO buurt (code, naam) VALUES (5992196, 'Eemhaven');
INSERT INTO buurt (code, naam) VALUES (5992198, 'Waalhaven-Zuid');
INSERT INTO buurt (code, naam) VALUES (5992295, 'Vondelingenplaat');
INSERT INTO buurt (code, naam) VALUES (5992306, 'Botlek');
INSERT INTO buurt (code, naam) VALUES (5992307, 'Europoort');
INSERT INTO buurt (code, naam) VALUES (5992308, 'Maasvlakte');
INSERT INTO buurt (code, naam) VALUES (5992459, 'Bedrijventerrein Rotterdam Noord-West');
INSERT INTO buurt (code, naam) VALUES (5992540, 'Rivium');
INSERT INTO buurt (code, naam) VALUES (5992650, 'Bedrijventerrein Schieveen');
INSERT INTO buurt (code, naam) VALUES (5992704, 'Rozenburg');
INSERT INTO buurt (code, naam) VALUES (5992705, 'Noordzeeweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (6030111, 'Cromvliet');
INSERT INTO buurt (code, naam) VALUES (6030112, 'Leeuwendaal');
INSERT INTO buurt (code, naam) VALUES (6030221, 'Oud-Rijswijk');
INSERT INTO buurt (code, naam) VALUES (6030222, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (6030223, 'Welgelegen');
INSERT INTO buurt (code, naam) VALUES (6030224, 'Rembrandtkwartier');
INSERT INTO buurt (code, naam) VALUES (6030225, 'Havenkwartier');
INSERT INTO buurt (code, naam) VALUES (6030331, 'Julianapark');
INSERT INTO buurt (code, naam) VALUES (6030332, 'Huis te Lande');
INSERT INTO buurt (code, naam) VALUES (6030333, 'Stationskwartier');
INSERT INTO buurt (code, naam) VALUES (6030334, 'Te Werve');
INSERT INTO buurt (code, naam) VALUES (6030441, 'Spoorzicht');
INSERT INTO buurt (code, naam) VALUES (6030442, 'Kleurenbuurt');
INSERT INTO buurt (code, naam) VALUES (6030443, 'Artiestenbuurt');
INSERT INTO buurt (code, naam) VALUES (6030551, 'Overvoorde');
INSERT INTO buurt (code, naam) VALUES (6030552, 'Strijp');
INSERT INTO buurt (code, naam) VALUES (6030553, 'Presidentenbuurt');
INSERT INTO buurt (code, naam) VALUES (6030554, 'Ministerbuurt');
INSERT INTO buurt (code, naam) VALUES (6030661, 'Stervoorde');
INSERT INTO buurt (code, naam) VALUES (6030662, 'Eikelenburg');
INSERT INTO buurt (code, naam) VALUES (6030663, 'Hoekpolder');
INSERT INTO buurt (code, naam) VALUES (6030664, 'Sion');
INSERT INTO buurt (code, naam) VALUES (6030771, 'Muziekbuurt');
INSERT INTO buurt (code, naam) VALUES (6030772, 'Wilhelminapark');
INSERT INTO buurt (code, naam) VALUES (6030881, 'Plaspoelpolder');
INSERT INTO buurt (code, naam) VALUES (6030882, 'Elsenburg');
INSERT INTO buurt (code, naam) VALUES (6030883, 'Pasgeld');
INSERT INTO buurt (code, naam) VALUES (6030884, 'Haantje');
INSERT INTO buurt (code, naam) VALUES (6030991, 'Hoornwijck');
INSERT INTO buurt (code, naam) VALUES (6030992, 'Broekpolder');
INSERT INTO buurt (code, naam) VALUES (6030993, 'Kraayenburg');
INSERT INTO buurt (code, naam) VALUES (6030994, 'Vrijenban');
INSERT INTO buurt (code, naam) VALUES (6060000, 'Buurt 00');
INSERT INTO buurt (code, naam) VALUES (6060101, 'Stadserf');
INSERT INTO buurt (code, naam) VALUES (6060102, 'Natuurkundigenbuurt');
INSERT INTO buurt (code, naam) VALUES (6060103, 'Singelkwartier');
INSERT INTO buurt (code, naam) VALUES (6060104, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (6060105, 'Wetenschappersbuurt');
INSERT INTO buurt (code, naam) VALUES (6060106, 'Newtonbuurt');
INSERT INTO buurt (code, naam) VALUES (6060107, 'Rotterdamsedijk');
INSERT INTO buurt (code, naam) VALUES (6060201, 'Brandersbuurt');
INSERT INTO buurt (code, naam) VALUES (6060202, 'Walvisbuurt');
INSERT INTO buurt (code, naam) VALUES (6060203, 'De Plantage');
INSERT INTO buurt (code, naam) VALUES (6060301, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (6060302, 'Schrijversbuurt');
INSERT INTO buurt (code, naam) VALUES (6060303, 'Fabribuurt');
INSERT INTO buurt (code, naam) VALUES (6060304, 'Frankenland');
INSERT INTO buurt (code, naam) VALUES (6060305, 'Liduinabuurt');
INSERT INTO buurt (code, naam) VALUES (6060306, 'Nassaubuurt');
INSERT INTO buurt (code, naam) VALUES (6060307, 'Oranjekwartier');
INSERT INTO buurt (code, naam) VALUES (6060308, 'Haverschmidtkwartier');
INSERT INTO buurt (code, naam) VALUES (6060309, 'Distillateursbuurt');
INSERT INTO buurt (code, naam) VALUES (6060401, 'Noletbuurt');
INSERT INTO buurt (code, naam) VALUES (6060402, 'Eilandenbuurt');
INSERT INTO buurt (code, naam) VALUES (6060403, 'Piet Sandersbuurt');
INSERT INTO buurt (code, naam) VALUES (6060404, 'Maasboulevard');
INSERT INTO buurt (code, naam) VALUES (6060405, 'Havenbuurt');
INSERT INTO buurt (code, naam) VALUES (6060500, 'Nieuw-Mathenesse');
INSERT INTO buurt (code, naam) VALUES (6060602, 'Spieringshoek');
INSERT INTO buurt (code, naam) VALUES (6060603, 'Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (6060604, 'Vakbondsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (6060605, 'Hollandiabuurt');
INSERT INTO buurt (code, naam) VALUES (6060606, 'Schiehart');
INSERT INTO buurt (code, naam) VALUES (6060607, 'Nolensbuurt');
INSERT INTO buurt (code, naam) VALUES (6060608, 'Wibautbuurt');
INSERT INTO buurt (code, naam) VALUES (6060701, 'Parkenbuurt/Bijdorp');
INSERT INTO buurt (code, naam) VALUES (6060702, 'Groenoord-Zuid');
INSERT INTO buurt (code, naam) VALUES (6060703, 'Groenoord-Midden');
INSERT INTO buurt (code, naam) VALUES (6060704, 'Groenoord-Noord');
INSERT INTO buurt (code, naam) VALUES (6060705, 'Kethel-dorp');
INSERT INTO buurt (code, naam) VALUES (6060706, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (6060707, 'Tuindorp');
INSERT INTO buurt (code, naam) VALUES (6060801, 'Spaanse Polder');
INSERT INTO buurt (code, naam) VALUES (6060802, '''s-Gravelandsepolder');
INSERT INTO buurt (code, naam) VALUES (6060803, 'Polderwetering');
INSERT INTO buurt (code, naam) VALUES (6060901, 'Toneelspelersbuurt');
INSERT INTO buurt (code, naam) VALUES (6060902, 'Ambachtenbuurt');
INSERT INTO buurt (code, naam) VALUES (6060903, 'Kastelenbuurt');
INSERT INTO buurt (code, naam) VALUES (6060904, 'Botenbuurt');
INSERT INTO buurt (code, naam) VALUES (6060905, 'De Gaarden/Sveafors');
INSERT INTO buurt (code, naam) VALUES (6060906, 'De Vlinderhoven/Sveaholm');
INSERT INTO buurt (code, naam) VALUES (6060907, 'De Akkers en De Velden');
INSERT INTO buurt (code, naam) VALUES (6060908, 'Sveaborg en -Dal');
INSERT INTO buurt (code, naam) VALUES (6060909, 'Noordkethelpolder');
INSERT INTO buurt (code, naam) VALUES (6080000, 'Schoonhoven-Oude Stad');
INSERT INTO buurt (code, naam) VALUES (6080001, 'Schoonhoven-Noord');
INSERT INTO buurt (code, naam) VALUES (6080002, 'Schoonhoven-West');
INSERT INTO buurt (code, naam) VALUES (6080003, 'Zevender (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (6080004, 'Willige-Langerak');
INSERT INTO buurt (code, naam) VALUES (6080005, 'Vlist, Bovenberg en Lekdijk');
INSERT INTO buurt (code, naam) VALUES (6100101, 'Baanhoek-West');
INSERT INTO buurt (code, naam) VALUES (6100102, 'Baanhoek-Bedrijven');
INSERT INTO buurt (code, naam) VALUES (6100103, 'De Weren');
INSERT INTO buurt (code, naam) VALUES (6100104, 'Benedenveer');
INSERT INTO buurt (code, naam) VALUES (6100105, 'Baanhoek-Oost');
INSERT INTO buurt (code, naam) VALUES (6100106, 'Prickwaert en Weresteijn');
INSERT INTO buurt (code, naam) VALUES (6100107, 'De Hoven');
INSERT INTO buurt (code, naam) VALUES (6100108, 'Molendijk');
INSERT INTO buurt (code, naam) VALUES (6100109, 'Bedrijventerrein Het Plaatje');
INSERT INTO buurt (code, naam) VALUES (6100201, 'Rivierenbuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (6100202, 'Rivierenbuurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (6100203, 'Kerkbuurt-West');
INSERT INTO buurt (code, naam) VALUES (6100204, 'Buitenuitbreiding-West');
INSERT INTO buurt (code, naam) VALUES (6100205, 'Bedrijventerrein Kerkerak');
INSERT INTO buurt (code, naam) VALUES (6100206, 'Stationsweg');
INSERT INTO buurt (code, naam) VALUES (6100207, 'Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (6100208, 'Winklerplein-Noord');
INSERT INTO buurt (code, naam) VALUES (6100209, 'Winklerplein-Zuid');
INSERT INTO buurt (code, naam) VALUES (6100210, 'Kerkbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (6100211, 'Buitenuitbreiding-Oost');
INSERT INTO buurt (code, naam) VALUES (6100301, 'Vogelbuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (6100302, 'Vogelbuurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (6100303, 'Middenveer');
INSERT INTO buurt (code, naam) VALUES (6100304, 'Rivierdijk-West');
INSERT INTO buurt (code, naam) VALUES (6100305, 'De Grienden');
INSERT INTO buurt (code, naam) VALUES (6100306, 'Rivierdijk-Midden');
INSERT INTO buurt (code, naam) VALUES (6100307, 'Rivierdijk-Oost');
INSERT INTO buurt (code, naam) VALUES (6100401, 'Het Buitengebied');
INSERT INTO buurt (code, naam) VALUES (6100402, 'Bedrijventerrein De Driehoek');
INSERT INTO buurt (code, naam) VALUES (6100403, 'Bedrijventerrein Nijverwaard');
INSERT INTO buurt (code, naam) VALUES (6100404, 'Bedrijventerrein Stationspark');
INSERT INTO buurt (code, naam) VALUES (6100405, 'Sportpark');
INSERT INTO buurt (code, naam) VALUES (6100406, 'Bedrijventerrein Noordoost-Kwadrant');
INSERT INTO buurt (code, naam) VALUES (6110000, 'Nieuwbouw Dorp');
INSERT INTO buurt (code, naam) VALUES (6110001, 'Middelsluis');
INSERT INTO buurt (code, naam) VALUES (6110003, 'Schuring');
INSERT INTO buurt (code, naam) VALUES (6110004, 'Numansdorp');
INSERT INTO buurt (code, naam) VALUES (6110009, 'Verspreide huizen Numansdorp');
INSERT INTO buurt (code, naam) VALUES (6110100, 'Klaaswaal');
INSERT INTO buurt (code, naam) VALUES (6110101, 'Oude Sluis');
INSERT INTO buurt (code, naam) VALUES (6110108, 'Verspreide huizen West');
INSERT INTO buurt (code, naam) VALUES (6110109, 'Verspreide huizen Oost');
INSERT INTO buurt (code, naam) VALUES (6119997, '');
INSERT INTO buurt (code, naam) VALUES (6120101, 'Kern');
INSERT INTO buurt (code, naam) VALUES (6120102, 'Molenwei');
INSERT INTO buurt (code, naam) VALUES (6120103, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (6120104, 'Vogelbuurt .');
INSERT INTO buurt (code, naam) VALUES (6120105, 'Centrum-Oost');
INSERT INTO buurt (code, naam) VALUES (6120106, 'Centrum-Zuid');
INSERT INTO buurt (code, naam) VALUES (6120201, 'Schiekamp-Noord');
INSERT INTO buurt (code, naam) VALUES (6120202, 'Schiekamp-Zuid');
INSERT INTO buurt (code, naam) VALUES (6120301, 'Hoogwerf-Noord');
INSERT INTO buurt (code, naam) VALUES (6120302, 'Hoogwerf-Zuid');
INSERT INTO buurt (code, naam) VALUES (6120401, 'Vierambachten');
INSERT INTO buurt (code, naam) VALUES (6120501, 'De Hoek-1');
INSERT INTO buurt (code, naam) VALUES (6120502, 'De Hoek-2');
INSERT INTO buurt (code, naam) VALUES (6120503, 'De Hoek-3');
INSERT INTO buurt (code, naam) VALUES (6120504, 'De Hoek-4');
INSERT INTO buurt (code, naam) VALUES (6120601, 'Gildenwijk-Oost');
INSERT INTO buurt (code, naam) VALUES (6120602, 'Gildenwijk-West');
INSERT INTO buurt (code, naam) VALUES (6120603, 'Ziekenhuis');
INSERT INTO buurt (code, naam) VALUES (6120701, 'Groenewoud-Hoog');
INSERT INTO buurt (code, naam) VALUES (6120702, 'Groenewoud-Huur');
INSERT INTO buurt (code, naam) VALUES (6120703, 'Groenewoud-Koop');
INSERT INTO buurt (code, naam) VALUES (6120801, 'Sterrenkwartier-Hoog');
INSERT INTO buurt (code, naam) VALUES (6120802, 'Sterrenkwartier-Midden');
INSERT INTO buurt (code, naam) VALUES (6120803, 'Sterrenkwartier-Oost');
INSERT INTO buurt (code, naam) VALUES (6120804, 'Sterrenkwartier-Zuid');
INSERT INTO buurt (code, naam) VALUES (6120805, 'Sterrenkwartier-West');
INSERT INTO buurt (code, naam) VALUES (6120901, 'Schenkel-Noordwest');
INSERT INTO buurt (code, naam) VALUES (6120902, 'Schenkel-Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (6120903, 'Schenkel-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (6120904, 'Schenkel-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (6120905, 'Schenkel-Noordoost');
INSERT INTO buurt (code, naam) VALUES (6121001, 'De Dijk');
INSERT INTO buurt (code, naam) VALUES (6121002, 'Bedrijventerrein Haven-Noord');
INSERT INTO buurt (code, naam) VALUES (6121003, 'De Haven');
INSERT INTO buurt (code, naam) VALUES (6121004, 'Het Land');
INSERT INTO buurt (code, naam) VALUES (6121101, 'Vogelenzang-Zuid');
INSERT INTO buurt (code, naam) VALUES (6121102, 'Vogelenzang-Noord');
INSERT INTO buurt (code, naam) VALUES (6121201, 'Gaarden');
INSERT INTO buurt (code, naam) VALUES (6121202, 'Dreven');
INSERT INTO buurt (code, naam) VALUES (6121203, 'Voorden');
INSERT INTO buurt (code, naam) VALUES (6121204, 'Akkers-Centrum');
INSERT INTO buurt (code, naam) VALUES (6121205, 'Donken');
INSERT INTO buurt (code, naam) VALUES (6121206, 'Kreken');
INSERT INTO buurt (code, naam) VALUES (6121301, 'Vriesland');
INSERT INTO buurt (code, naam) VALUES (6121401, 'Ottersveen');
INSERT INTO buurt (code, naam) VALUES (6121402, 'Kikkerveen');
INSERT INTO buurt (code, naam) VALUES (6121403, 'Beverveen');
INSERT INTO buurt (code, naam) VALUES (6121404, 'Egel- en salamanderveen');
INSERT INTO buurt (code, naam) VALUES (6121405, 'Krekelveen');
INSERT INTO buurt (code, naam) VALUES (6121406, 'Slakkenveen');
INSERT INTO buurt (code, naam) VALUES (6121407, 'Middenveen');
INSERT INTO buurt (code, naam) VALUES (6121408, 'Karperveen');
INSERT INTO buurt (code, naam) VALUES (6121409, 'Snoekenveen');
INSERT INTO buurt (code, naam) VALUES (6121410, 'Baarsveen');
INSERT INTO buurt (code, naam) VALUES (6121411, 'Park Waterland');
INSERT INTO buurt (code, naam) VALUES (6121501, 'Maaswijk-Noordoost');
INSERT INTO buurt (code, naam) VALUES (6121502, 'Maaswijk-Noordwest');
INSERT INTO buurt (code, naam) VALUES (6121503, 'Maaswijk-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (6121504, 'Maaswijk-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (6121505, 'Maaswijktuinen');
INSERT INTO buurt (code, naam) VALUES (6121506, 'Park Welgelegen');
INSERT INTO buurt (code, naam) VALUES (6121601, 'Industrieterrein Halfweg');
INSERT INTO buurt (code, naam) VALUES (6121701, 'Oostbroek');
INSERT INTO buurt (code, naam) VALUES (6121702, 'landtong');
INSERT INTO buurt (code, naam) VALUES (6121703, 'Hartelpark-Oost');
INSERT INTO buurt (code, naam) VALUES (6121704, 'Hartelpark-West');
INSERT INTO buurt (code, naam) VALUES (6121705, 'markenburg');
INSERT INTO buurt (code, naam) VALUES (6121706, 'Westrand');
INSERT INTO buurt (code, naam) VALUES (6121707, 'Waterrijk');
INSERT INTO buurt (code, naam) VALUES (6121708, 'Berenplaat');
INSERT INTO buurt (code, naam) VALUES (6125001, 'Hekelingen-Dorp');
INSERT INTO buurt (code, naam) VALUES (6125002, 'Uitslag van Putten-Zuid');
INSERT INTO buurt (code, naam) VALUES (6125003, 'Oud-Schuddebeurs');
INSERT INTO buurt (code, naam) VALUES (6130101, 'Valckesteyn');
INSERT INTO buurt (code, naam) VALUES (6130102, 'Zwaardijk-Kruisdijk');
INSERT INTO buurt (code, naam) VALUES (6130103, 'Poortugaal');
INSERT INTO buurt (code, naam) VALUES (6130104, 'Buitengebied Poortugaal');
INSERT INTO buurt (code, naam) VALUES (6130205, 'Rhoon Noord');
INSERT INTO buurt (code, naam) VALUES (6130207, 'Buitengebied Rhoon-Noord');
INSERT INTO buurt (code, naam) VALUES (6130308, 'Beatrixstraat');
INSERT INTO buurt (code, naam) VALUES (6130309, 'Landweg');
INSERT INTO buurt (code, naam) VALUES (6130310, 'Poortugaal-Centrum');
INSERT INTO buurt (code, naam) VALUES (6130311, 'Poortugaal Zuid');
INSERT INTO buurt (code, naam) VALUES (6130312, 'Polder Albrandswaard');
INSERT INTO buurt (code, naam) VALUES (6130313, 'Kijvelanden');
INSERT INTO buurt (code, naam) VALUES (6130414, 'Rhoon-Centrum');
INSERT INTO buurt (code, naam) VALUES (6130415, 'Ghijseland');
INSERT INTO buurt (code, naam) VALUES (6130416, 'Overhoeken');
INSERT INTO buurt (code, naam) VALUES (6130417, 'Park Rhoon');
INSERT INTO buurt (code, naam) VALUES (6130418, 'Rhoon-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (6130419, 'Tijsjesdijk');
INSERT INTO buurt (code, naam) VALUES (6130420, 'Buitengebied Rhoon-Zuid');
INSERT INTO buurt (code, naam) VALUES (6130521, 'Portland-Koedoodzone');
INSERT INTO buurt (code, naam) VALUES (6130522, 'Buitengebied');
INSERT INTO buurt (code, naam) VALUES (6130623, 'Driehoek');
INSERT INTO buurt (code, naam) VALUES (6130624, 'Portland-Centrum');
INSERT INTO buurt (code, naam) VALUES (6130625, 'Wijkpark Portland');
INSERT INTO buurt (code, naam) VALUES (6130626, 'De Eilanden');
INSERT INTO buurt (code, naam) VALUES (6130706, 'Distripark');
INSERT INTO buurt (code, naam) VALUES (6140000, 'Rockanje');
INSERT INTO buurt (code, naam) VALUES (6140001, 'Helhoek');
INSERT INTO buurt (code, naam) VALUES (6140002, 'Strijpe');
INSERT INTO buurt (code, naam) VALUES (6140003, 'Stuifakker');
INSERT INTO buurt (code, naam) VALUES (6140004, 'Zuidhoek');
INSERT INTO buurt (code, naam) VALUES (6140005, 'Nieuw gebied');
INSERT INTO buurt (code, naam) VALUES (6140009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (6140100, 'Oostvoorne');
INSERT INTO buurt (code, naam) VALUES (6140101, 'De Waranda');
INSERT INTO buurt (code, naam) VALUES (6140102, 'Kruiningergors');
INSERT INTO buurt (code, naam) VALUES (6140103, 'Tinte');
INSERT INTO buurt (code, naam) VALUES (6140104, 'Goudhoek');
INSERT INTO buurt (code, naam) VALUES (6140105, 'Vogelenzang');
INSERT INTO buurt (code, naam) VALUES (6140106, 'Duinoord');
INSERT INTO buurt (code, naam) VALUES (6140108, 'Verspreide huizen in het Westen');
INSERT INTO buurt (code, naam) VALUES (6140109, 'Verspreide huizen in het Oosten');
INSERT INTO buurt (code, naam) VALUES (6149998, '');
INSERT INTO buurt (code, naam) VALUES (6170001, 'Strijen-Centrum');
INSERT INTO buurt (code, naam) VALUES (6170002, 'Oranjewijk');
INSERT INTO buurt (code, naam) VALUES (6170003, 'Land van Essche');
INSERT INTO buurt (code, naam) VALUES (6170004, 'Over de Keen');
INSERT INTO buurt (code, naam) VALUES (6170005, 'Noord');
INSERT INTO buurt (code, naam) VALUES (6170007, 'Oud Bonaventura (bedrijfsterrein)');
INSERT INTO buurt (code, naam) VALUES (6170008, 'Strijensas');
INSERT INTO buurt (code, naam) VALUES (6170009, 'Mookhoek');
INSERT INTO buurt (code, naam) VALUES (6170010, 'Cillaarshoek');
INSERT INTO buurt (code, naam) VALUES (6170011, 'Klem');
INSERT INTO buurt (code, naam) VALUES (6170012, 'Buitengebied-Zuid');
INSERT INTO buurt (code, naam) VALUES (6170013, 'Buitengebied-West');
INSERT INTO buurt (code, naam) VALUES (6170014, 'Buitengebied-Oost');
INSERT INTO buurt (code, naam) VALUES (6179997, '');
INSERT INTO buurt (code, naam) VALUES (6200000, 'Oude Stad');
INSERT INTO buurt (code, naam) VALUES (6200001, 'Zederik');
INSERT INTO buurt (code, naam) VALUES (6200002, 'De Hagen');
INSERT INTO buurt (code, naam) VALUES (6200003, 'Vijfheerenlanden');
INSERT INTO buurt (code, naam) VALUES (6200004, 'Industrieterrein Vianen');
INSERT INTO buurt (code, naam) VALUES (6200005, 'Monnikenhof en Amaliastein');
INSERT INTO buurt (code, naam) VALUES (6200007, 'Verspreide huizen Helsdingen');
INSERT INTO buurt (code, naam) VALUES (6200009, 'Overige verspreide huizen Vianen');
INSERT INTO buurt (code, naam) VALUES (6200100, 'Hagestein');
INSERT INTO buurt (code, naam) VALUES (6200101, 'Industrieterrein Hagestein');
INSERT INTO buurt (code, naam) VALUES (6200107, 'Verspreide huizen in het Oosten');
INSERT INTO buurt (code, naam) VALUES (6200108, 'Verspreide huizen in het Noorden');
INSERT INTO buurt (code, naam) VALUES (6200109, 'Verspreide huizen in het Zuidwesten');
INSERT INTO buurt (code, naam) VALUES (6200200, 'Everdingen');
INSERT INTO buurt (code, naam) VALUES (6200201, 'Zijderveld');
INSERT INTO buurt (code, naam) VALUES (6200202, 'Diefdijk (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (6200209, 'Verspreide huizen Everdingen');
INSERT INTO buurt (code, naam) VALUES (6220101, 'Indische buurt');
INSERT INTO buurt (code, naam) VALUES (6220102, 'Vettenoordse polder Oost');
INSERT INTO buurt (code, naam) VALUES (6220103, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (6220104, 'Hoogstad');
INSERT INTO buurt (code, naam) VALUES (6220201, 'Hoogkamer');
INSERT INTO buurt (code, naam) VALUES (6220202, 'Zuidbuurt');
INSERT INTO buurt (code, naam) VALUES (6220203, 'Wetering');
INSERT INTO buurt (code, naam) VALUES (6220204, 'Lage welde');
INSERT INTO buurt (code, naam) VALUES (6220205, 'Buitengebied Zuidbuurt');
INSERT INTO buurt (code, naam) VALUES (6220301, 'De vergulde Hand');
INSERT INTO buurt (code, naam) VALUES (6220302, 'Lickebaert');
INSERT INTO buurt (code, naam) VALUES (6220303, '''t Scheur');
INSERT INTO buurt (code, naam) VALUES (6220304, 'Deltagebied');
INSERT INTO buurt (code, naam) VALUES (6220305, 'Park Zuidbuurt');
INSERT INTO buurt (code, naam) VALUES (6220306, 'Vettenoordse polder West');
INSERT INTO buurt (code, naam) VALUES (6220307, 'Maasboulevard');
INSERT INTO buurt (code, naam) VALUES (6220401, 'Hofbuurt');
INSERT INTO buurt (code, naam) VALUES (6220402, 'Oostbuurt');
INSERT INTO buurt (code, naam) VALUES (6220403, 'Havengebied Oost');
INSERT INTO buurt (code, naam) VALUES (6220404, 'Vijfsluizen');
INSERT INTO buurt (code, naam) VALUES (6220501, 'Babberspolder Noord');
INSERT INTO buurt (code, naam) VALUES (6220502, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (6220503, 'Babberspolder West');
INSERT INTO buurt (code, naam) VALUES (6220504, 'Babberspolder Oost');
INSERT INTO buurt (code, naam) VALUES (6220505, '''t Nieuwe Lant');
INSERT INTO buurt (code, naam) VALUES (6220601, 'Vaart Zuid');
INSERT INTO buurt (code, naam) VALUES (6220602, 'Statenbuurt');
INSERT INTO buurt (code, naam) VALUES (6220603, 'Loper Zuid');
INSERT INTO buurt (code, naam) VALUES (6220604, 'Vogelbuurt Noord');
INSERT INTO buurt (code, naam) VALUES (6220605, 'Sportpark Holy');
INSERT INTO buurt (code, naam) VALUES (6220606, 'Vogelbuurt Zuid');
INSERT INTO buurt (code, naam) VALUES (6220701, 'Drevenbuurt');
INSERT INTO buurt (code, naam) VALUES (6220702, 'Kruidenbuurt');
INSERT INTO buurt (code, naam) VALUES (6220703, 'Loper Noord');
INSERT INTO buurt (code, naam) VALUES (6220704, 'Hoofdstedenbuurt');
INSERT INTO buurt (code, naam) VALUES (6220705, 'Park Holy Noord');
INSERT INTO buurt (code, naam) VALUES (6220706, 'Hoevenbuurt');
INSERT INTO buurt (code, naam) VALUES (6220707, 'Hollerhoekse polder');
INSERT INTO buurt (code, naam) VALUES (6220708, 'Vaart Noord');
INSERT INTO buurt (code, naam) VALUES (6220801, 'Broekpolder gebied');
INSERT INTO buurt (code, naam) VALUES (6230000, 'Haastrecht-Dorpskern');
INSERT INTO buurt (code, naam) VALUES (6230001, 'Boven-Haastrecht');
INSERT INTO buurt (code, naam) VALUES (6230002, 'Beneden-Haastrecht');
INSERT INTO buurt (code, naam) VALUES (6230003, 'Rozendaal');
INSERT INTO buurt (code, naam) VALUES (6230004, 'Stolwijkersluis (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (6230005, 'Hofkamp');
INSERT INTO buurt (code, naam) VALUES (6230006, 'Agterpoort');
INSERT INTO buurt (code, naam) VALUES (6230007, 'Stein');
INSERT INTO buurt (code, naam) VALUES (6230008, 'Verspreide huizen Noord');
INSERT INTO buurt (code, naam) VALUES (6230009, 'Verspreide huizen Zuid');
INSERT INTO buurt (code, naam) VALUES (6230100, 'Bergvliet');
INSERT INTO buurt (code, naam) VALUES (6230200, 'Stolwijk');
INSERT INTO buurt (code, naam) VALUES (6230201, 'Bovenkerk');
INSERT INTO buurt (code, naam) VALUES (6230202, 'Benedenkerk');
INSERT INTO buurt (code, naam) VALUES (6230203, 'Benedenheul');
INSERT INTO buurt (code, naam) VALUES (6230204, 'Goudseweg');
INSERT INTO buurt (code, naam) VALUES (6230205, 'Het Beijersche');
INSERT INTO buurt (code, naam) VALUES (6230206, 'Koolwijk');
INSERT INTO buurt (code, naam) VALUES (6230207, 'Schoonouwen');
INSERT INTO buurt (code, naam) VALUES (6230208, 'Bilwijk');
INSERT INTO buurt (code, naam) VALUES (6230300, 'Vlist');
INSERT INTO buurt (code, naam) VALUES (6230301, 'Bonrepas');
INSERT INTO buurt (code, naam) VALUES (6260001, 'Noord-Hofland');
INSERT INTO buurt (code, naam) VALUES (6260002, 'Adegeest');
INSERT INTO buurt (code, naam) VALUES (6260004, 'Boschgeest');
INSERT INTO buurt (code, naam) VALUES (6260006, 'Bijdorp');
INSERT INTO buurt (code, naam) VALUES (6260007, 'Vlietwijk');
INSERT INTO buurt (code, naam) VALUES (6260008, 'Starrenburg');
INSERT INTO buurt (code, naam) VALUES (6260009, 'Dobbewijk');
INSERT INTO buurt (code, naam) VALUES (6260010, 'Krimwijk');
INSERT INTO buurt (code, naam) VALUES (6260011, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (6260012, 'Nassauwijk');
INSERT INTO buurt (code, naam) VALUES (6260013, 'Bloemenwijk');
INSERT INTO buurt (code, naam) VALUES (6260014, 'Buitengebied');
INSERT INTO buurt (code, naam) VALUES (6270101, 'Groenswaard 1');
INSERT INTO buurt (code, naam) VALUES (6270102, 'Groenswaard 2');
INSERT INTO buurt (code, naam) VALUES (6270103, 'Groenswaard 3');
INSERT INTO buurt (code, naam) VALUES (6270104, 'Peter Zuidlaan en Horstenbuurt');
INSERT INTO buurt (code, naam) VALUES (6270105, 'West 1');
INSERT INTO buurt (code, naam) VALUES (6270201, 'Bomenwijk');
INSERT INTO buurt (code, naam) VALUES (6270202, 'Zuidplas 80');
INSERT INTO buurt (code, naam) VALUES (6270203, 'Zuidplas 90');
INSERT INTO buurt (code, naam) VALUES (6270204, 'Triangel');
INSERT INTO buurt (code, naam) VALUES (6270205, 'West 2');
INSERT INTO buurt (code, naam) VALUES (6270301, 'Oranjewijk Zuid');
INSERT INTO buurt (code, naam) VALUES (6270302, 'Oranjewijk Noord');
INSERT INTO buurt (code, naam) VALUES (6270303, 'Vondelwijk');
INSERT INTO buurt (code, naam) VALUES (6270304, 'Noordkade');
INSERT INTO buurt (code, naam) VALUES (6270401, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (6270402, 'Oostpolderwijk');
INSERT INTO buurt (code, naam) VALUES (6270403, 'Bedrijventerrein Mercuriusweg');
INSERT INTO buurt (code, naam) VALUES (6270404, 'Zuid');
INSERT INTO buurt (code, naam) VALUES (6270405, 'Coenecoop');
INSERT INTO buurt (code, naam) VALUES (6270406, '''t Weegje');
INSERT INTO buurt (code, naam) VALUES (6270407, 'Oost');
INSERT INTO buurt (code, naam) VALUES (6270408, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (6290000, 'Drie Papegaaien');
INSERT INTO buurt (code, naam) VALUES (6290001, 'Oud-Wassenaar');
INSERT INTO buurt (code, naam) VALUES (6290002, 'Nieuw-Wassenaar');
INSERT INTO buurt (code, naam) VALUES (6290003, 'Duindigt met Groenendaal');
INSERT INTO buurt (code, naam) VALUES (6290004, 'Oud-Clingendaal');
INSERT INTO buurt (code, naam) VALUES (6290005, 'De Kieviet');
INSERT INTO buurt (code, naam) VALUES (6290006, 'Kerkehout');
INSERT INTO buurt (code, naam) VALUES (6290007, 'Klingenbosch');
INSERT INTO buurt (code, naam) VALUES (6290008, 'Verspreide huizen Eikenhorst');
INSERT INTO buurt (code, naam) VALUES (6290009, 'Verspreide huizen Meijendel');
INSERT INTO buurt (code, naam) VALUES (6290100, 'De Paauw');
INSERT INTO buurt (code, naam) VALUES (6290101, 'Dorp Wassenaar');
INSERT INTO buurt (code, naam) VALUES (6290102, 'Oostdorp');
INSERT INTO buurt (code, naam) VALUES (6290103, 'Zijlwatering en haven');
INSERT INTO buurt (code, naam) VALUES (6290104, 'De Deijl');
INSERT INTO buurt (code, naam) VALUES (6290105, 'Groot Deijleroord en Ter Weer');
INSERT INTO buurt (code, naam) VALUES (6290106, 'Rijksdorp met De Pan');
INSERT INTO buurt (code, naam) VALUES (6290107, 'Maaldrift');
INSERT INTO buurt (code, naam) VALUES (6290108, 'Verspreide huizen Raaphorst en in poldergebied');
INSERT INTO buurt (code, naam) VALUES (6290109, 'Verspreide huizen Duinrell Wassenaarse Slag');
INSERT INTO buurt (code, naam) VALUES (6290110, 'Weteringpark');
INSERT INTO buurt (code, naam) VALUES (6299998, '');
INSERT INTO buurt (code, naam) VALUES (6320101, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (6320102, 'Bloemen- en Bomenkwartier');
INSERT INTO buurt (code, naam) VALUES (6320103, 'Bedrijventerrein Honthorst');
INSERT INTO buurt (code, naam) VALUES (6320104, 'Staatsliedenkwartier');
INSERT INTO buurt (code, naam) VALUES (6320105, 'Vogelkwartier');
INSERT INTO buurt (code, naam) VALUES (6320106, 'Schilderskwartier');
INSERT INTO buurt (code, naam) VALUES (6320201, 'Bedrijventerrein Barwoutsw');
INSERT INTO buurt (code, naam) VALUES (6320202, 'Molenvliet-West');
INSERT INTO buurt (code, naam) VALUES (6320203, 'Molenvliet-Oost');
INSERT INTO buurt (code, naam) VALUES (6320204, 'Kromwijk');
INSERT INTO buurt (code, naam) VALUES (6320301, 'Middelland-Noord');
INSERT INTO buurt (code, naam) VALUES (6320302, 'Middelland-Zuid');
INSERT INTO buurt (code, naam) VALUES (6320303, 'Snel en Polanen');
INSERT INTO buurt (code, naam) VALUES (6320304, 'Bedrijventerrein Pollanen');
INSERT INTO buurt (code, naam) VALUES (6320305, 'Waterrijk');
INSERT INTO buurt (code, naam) VALUES (6320401, 'Rietveld');
INSERT INTO buurt (code, naam) VALUES (6320402, 'Barwoutswaarder');
INSERT INTO buurt (code, naam) VALUES (6320501, 'Geestdorp');
INSERT INTO buurt (code, naam) VALUES (6320502, 'Breeveld');
INSERT INTO buurt (code, naam) VALUES (6320503, 'Cattenbroek');
INSERT INTO buurt (code, naam) VALUES (6320601, 'Harmelen-Noord (dorp)');
INSERT INTO buurt (code, naam) VALUES (6320602, 'Harmelen-Zuid (dorp)');
INSERT INTO buurt (code, naam) VALUES (6320603, 'Putkop');
INSERT INTO buurt (code, naam) VALUES (6320604, 'Buitengebied Harmelen');
INSERT INTO buurt (code, naam) VALUES (6320605, 'Reijerscop');
INSERT INTO buurt (code, naam) VALUES (6320606, 'Gerverscop');
INSERT INTO buurt (code, naam) VALUES (6320701, 'Kamerik (dorp)');
INSERT INTO buurt (code, naam) VALUES (6320702, 'Kanis');
INSERT INTO buurt (code, naam) VALUES (6320703, 'Buitengebied Kamerik');
INSERT INTO buurt (code, naam) VALUES (6320801, 'Zegveld (dorp)');
INSERT INTO buurt (code, naam) VALUES (6320802, 'Buitengebied Zegveld');
INSERT INTO buurt (code, naam) VALUES (6370001, 'Dorp');
INSERT INTO buurt (code, naam) VALUES (6370002, 'Stadscentrum');
INSERT INTO buurt (code, naam) VALUES (6370003, 'Palenstein');
INSERT INTO buurt (code, naam) VALUES (6370004, 'Driemanspolder');
INSERT INTO buurt (code, naam) VALUES (6370100, 'Meerzicht-West');
INSERT INTO buurt (code, naam) VALUES (6370101, 'Meerzicht-Oost');
INSERT INTO buurt (code, naam) VALUES (6370200, 'Buytenwegh');
INSERT INTO buurt (code, naam) VALUES (6370201, 'De Leyens');
INSERT INTO buurt (code, naam) VALUES (6370300, 'Seghwaert-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (6370301, 'Seghwaert-Noordoost');
INSERT INTO buurt (code, naam) VALUES (6370400, 'Noordhove-West');
INSERT INTO buurt (code, naam) VALUES (6370401, 'Noordhove-Oost');
INSERT INTO buurt (code, naam) VALUES (6370500, 'Rokkeveen-West');
INSERT INTO buurt (code, naam) VALUES (6370501, 'Rokkeveen-Oost');
INSERT INTO buurt (code, naam) VALUES (6370600, 'Oosterheem-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (6370601, 'Oosterheem-Noordoost');
INSERT INTO buurt (code, naam) VALUES (6370800, 'Rokkehage');
INSERT INTO buurt (code, naam) VALUES (6370801, 'Lansinghage');
INSERT INTO buurt (code, naam) VALUES (6370802, 'Zoeterhage');
INSERT INTO buurt (code, naam) VALUES (6370803, 'Hoornerhage');
INSERT INTO buurt (code, naam) VALUES (6370902, 'Balijbos');
INSERT INTO buurt (code, naam) VALUES (6370903, 'Westerpark en omgeving');
INSERT INTO buurt (code, naam) VALUES (6370904, 'Buitengebied-West');
INSERT INTO buurt (code, naam) VALUES (6370905, 'Meerpolder');
INSERT INTO buurt (code, naam) VALUES (6370906, 'Scheidingszone');
INSERT INTO buurt (code, naam) VALUES (6370907, 'Van Tuyllpark');
INSERT INTO buurt (code, naam) VALUES (6380000, 'Zoeterwoude-Dorp');
INSERT INTO buurt (code, naam) VALUES (6380001, 'Westeinde');
INSERT INTO buurt (code, naam) VALUES (6380002, 'Zuidbuurt');
INSERT INTO buurt (code, naam) VALUES (6380003, 'Weipoort');
INSERT INTO buurt (code, naam) VALUES (6380004, 'Gelderswoude');
INSERT INTO buurt (code, naam) VALUES (6380009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (6380100, 'Hoge Rijndijk');
INSERT INTO buurt (code, naam) VALUES (6420101, 'Slagveld en Omgeving');
INSERT INTO buurt (code, naam) VALUES (6420102, 'Veerplein - Oostkeetshaven');
INSERT INTO buurt (code, naam) VALUES (6420103, 'Drinkwaterbedrijf');
INSERT INTO buurt (code, naam) VALUES (6420104, 'Balkengat');
INSERT INTO buurt (code, naam) VALUES (6420105, 'Noordpark');
INSERT INTO buurt (code, naam) VALUES (6420106, 'Industriegebied Ringdijk');
INSERT INTO buurt (code, naam) VALUES (6420107, 'Staatsliedenbuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (6420108, 'Europesebuurt');
INSERT INTO buurt (code, naam) VALUES (6420109, 'Staatsliedenbuurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (6420110, 'Oud- en Gerbrandyplein');
INSERT INTO buurt (code, naam) VALUES (6420111, 'Winkelcentrum Walburg');
INSERT INTO buurt (code, naam) VALUES (6420112, 'De Were en omgeving');
INSERT INTO buurt (code, naam) VALUES (6420113, 'Lievershil en omgeving');
INSERT INTO buurt (code, naam) VALUES (6420114, 'Eem- en Zonnestein');
INSERT INTO buurt (code, naam) VALUES (6420115, 'Swanendrif-Zuid');
INSERT INTO buurt (code, naam) VALUES (6420201, 'Veerplein - De Werf');
INSERT INTO buurt (code, naam) VALUES (6420202, 'Euryza');
INSERT INTO buurt (code, naam) VALUES (6420203, 'Westkeetshaven');
INSERT INTO buurt (code, naam) VALUES (6420204, 'Brugweg');
INSERT INTO buurt (code, naam) VALUES (6420205, 'Corridor-Oost');
INSERT INTO buurt (code, naam) VALUES (6420206, 'Voormalig veilingterrein');
INSERT INTO buurt (code, naam) VALUES (6420207, 'Burgemeester Doornplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (6420208, 'Prins Bernhardstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (6420209, 'Juliandorp');
INSERT INTO buurt (code, naam) VALUES (6420301, 'Industriegebied Develpoort');
INSERT INTO buurt (code, naam) VALUES (6420302, 'Corridor-West');
INSERT INTO buurt (code, naam) VALUES (6420303, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (6420304, 'Sterrenbeeldenbuurt');
INSERT INTO buurt (code, naam) VALUES (6420305, 'Planetenbuurt');
INSERT INTO buurt (code, naam) VALUES (6420306, 'Begraafplaats Noord');
INSERT INTO buurt (code, naam) VALUES (6420307, 'Officiervliet-Oost');
INSERT INTO buurt (code, naam) VALUES (6420308, 'Officiervliet-West');
INSERT INTO buurt (code, naam) VALUES (6420309, 'Ter Steeghe');
INSERT INTO buurt (code, naam) VALUES (6420310, 'Pilotenbuurt');
INSERT INTO buurt (code, naam) VALUES (6420311, 'Langeraarstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (6420312, 'Hoveniersplein - Griend');
INSERT INTO buurt (code, naam) VALUES (6420313, 'Prinsessenbuurt');
INSERT INTO buurt (code, naam) VALUES (6420401, 'De Hoge Devel');
INSERT INTO buurt (code, naam) VALUES (6420402, 'Componistenbuurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (6420403, 'Componistenbuurt-Midden');
INSERT INTO buurt (code, naam) VALUES (6420404, 'Componistenbuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (6420405, 'Oudeland en Meubelmaker');
INSERT INTO buurt (code, naam) VALUES (6420406, 'Klarinetsingel en omgeving');
INSERT INTO buurt (code, naam) VALUES (6420407, 'Sonate en omgeving');
INSERT INTO buurt (code, naam) VALUES (6420408, 'De As');
INSERT INTO buurt (code, naam) VALUES (6420409, 'Park Molenvliet');
INSERT INTO buurt (code, naam) VALUES (6420410, 'Industriegebied Molenvliet');
INSERT INTO buurt (code, naam) VALUES (6420501, 'Noordzijde De Hoge Devel');
INSERT INTO buurt (code, naam) VALUES (6420502, 'Develsteincollege');
INSERT INTO buurt (code, naam) VALUES (6420503, 'Swinhove - De Lus');
INSERT INTO buurt (code, naam) VALUES (6420504, 'Koloniënbuurt');
INSERT INTO buurt (code, naam) VALUES (6420505, 'Meerdervoort');
INSERT INTO buurt (code, naam) VALUES (6420506, 'Dichtersbuurt-Midden');
INSERT INTO buurt (code, naam) VALUES (6420507, 'Dichtersbuurt-West');
INSERT INTO buurt (code, naam) VALUES (6420508, 'Verzetsheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (6420509, 'Kapiteinflats');
INSERT INTO buurt (code, naam) VALUES (6420510, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (6420511, 'Bloemenbuurt M(adelief) - Z(onnenbloem)');
INSERT INTO buurt (code, naam) VALUES (6420512, 'Bloemenbuurt D(ahlia) - G(eranium)');
INSERT INTO buurt (code, naam) VALUES (6420513, 'Bloemenbuurt B(egonia) - C(rocus)');
INSERT INTO buurt (code, naam) VALUES (6420514, 'Bloemenbuurt H(yacinth) - L(Obelia)');
INSERT INTO buurt (code, naam) VALUES (6420515, 'Bloemenbuurt A(kelei)');
INSERT INTO buurt (code, naam) VALUES (6420601, 'IJsvogelplein');
INSERT INTO buurt (code, naam) VALUES (6420602, 'Vogelbuurt-Oost');
INSERT INTO buurt (code, naam) VALUES (6420603, 'Ooievaar- en Vinkplein');
INSERT INTO buurt (code, naam) VALUES (6420604, 'Vogelbuurt-West');
INSERT INTO buurt (code, naam) VALUES (6420605, 'Leeuwerik- en Fazantplein');
INSERT INTO buurt (code, naam) VALUES (6420606, 'Moermond-Zuid');
INSERT INTO buurt (code, naam) VALUES (6420607, 'Boshuizen - Rechteren');
INSERT INTO buurt (code, naam) VALUES (6420608, 'Assumburg - Lunenburg');
INSERT INTO buurt (code, naam) VALUES (6420609, 'Hilverbeek en omgeving');
INSERT INTO buurt (code, naam) VALUES (6420610, 'Develzijde Nederhoven');
INSERT INTO buurt (code, naam) VALUES (6420701, 'Industriegebied Groote Lindt');
INSERT INTO buurt (code, naam) VALUES (6420702, 'De Geer-Oost');
INSERT INTO buurt (code, naam) VALUES (6420703, 'De Geer-West');
INSERT INTO buurt (code, naam) VALUES (6420704, 'Achterlindtsestraat');
INSERT INTO buurt (code, naam) VALUES (6420705, 'Kijfhoek');
INSERT INTO buurt (code, naam) VALUES (6420706, 'Emplacement "Kijfhoek"');
INSERT INTO buurt (code, naam) VALUES (6420707, 'Groenesteeg - Langeweg');
INSERT INTO buurt (code, naam) VALUES (6420708, 'Bakestein');
INSERT INTO buurt (code, naam) VALUES (6420801, 'Molenweg-West');
INSERT INTO buurt (code, naam) VALUES (6420802, 'Dorp-Noordoost');
INSERT INTO buurt (code, naam) VALUES (6420803, 'Dorp-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (6420804, 'Dorp-Zuid');
INSERT INTO buurt (code, naam) VALUES (6420805, 'Bedrijventerrein Gors-Noord');
INSERT INTO buurt (code, naam) VALUES (6420901, 'Emplacement Kijfhoek en Langeweg');
INSERT INTO buurt (code, naam) VALUES (6420902, 'Sportcomplex "De Molenwei"');
INSERT INTO buurt (code, naam) VALUES (6420903, 'Polder Heerjansdam');
INSERT INTO buurt (code, naam) VALUES (6420904, 'Kleine Lindt Polder');
INSERT INTO buurt (code, naam) VALUES (6420905, 'Hooge Nespolder');
INSERT INTO buurt (code, naam) VALUES (6420906, 'Het Buitenland en omgeving');
INSERT INTO buurt (code, naam) VALUES (6420907, 'Bedrijventerrein Gors-Zuid');
INSERT INTO buurt (code, naam) VALUES (6430000, 'Tiendhoek');
INSERT INTO buurt (code, naam) VALUES (6430001, 'Schuwacht');
INSERT INTO buurt (code, naam) VALUES (6430002, 'Opperduit');
INSERT INTO buurt (code, naam) VALUES (6430003, 'Tiendweg-West');
INSERT INTO buurt (code, naam) VALUES (6430004, 'Lekkerkerk-Oost');
INSERT INTO buurt (code, naam) VALUES (6430005, 'Prinsessenbuurt');
INSERT INTO buurt (code, naam) VALUES (6430006, 'Koninginnenbuurt');
INSERT INTO buurt (code, naam) VALUES (6430007, 'Wibautsraat en Lorentzweg');
INSERT INTO buurt (code, naam) VALUES (6430008, 'Molenwerf en omstreken');
INSERT INTO buurt (code, naam) VALUES (6430009, 'Voorstraat en Centrum');
INSERT INTO buurt (code, naam) VALUES (6430010, 'Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (6430011, 'Versrpeide huizen Lekkerkerk');
INSERT INTO buurt (code, naam) VALUES (6430100, 'Hoofdstraat');
INSERT INTO buurt (code, naam) VALUES (6430101, 'Binnen Krimpen');
INSERT INTO buurt (code, naam) VALUES (6430102, 'Beroepenbuurt');
INSERT INTO buurt (code, naam) VALUES (6430103, 'Krimpen-Oost');
INSERT INTO buurt (code, naam) VALUES (6430104, 'Zaag');
INSERT INTO buurt (code, naam) VALUES (6430105, 'Tiendweg Noord');
INSERT INTO buurt (code, naam) VALUES (6430106, 'Krimpen Centrum');
INSERT INTO buurt (code, naam) VALUES (6430107, 'Industrieterrein Krimpen');
INSERT INTO buurt (code, naam) VALUES (6430108, 'Lekdijk');
INSERT INTO buurt (code, naam) VALUES (6430109, 'Verspreide huizen Krimpen aan de Lek');
INSERT INTO buurt (code, naam) VALUES (6440000, 'Ouderkerk aan de IJssel');
INSERT INTO buurt (code, naam) VALUES (6440008, 'Verspreide huizen in het Noorden');
INSERT INTO buurt (code, naam) VALUES (6440009, 'Verspreide huizen in het Oosten');
INSERT INTO buurt (code, naam) VALUES (6440100, 'Gouderak');
INSERT INTO buurt (code, naam) VALUES (6540000, '''s-Heerenhoek');
INSERT INTO buurt (code, naam) VALUES (6540001, 'Borssele');
INSERT INTO buurt (code, naam) VALUES (6540002, 'Nieuwdorp');
INSERT INTO buurt (code, naam) VALUES (6540003, 'Lewedorp');
INSERT INTO buurt (code, naam) VALUES (6540004, 'Havengebied Sloe');
INSERT INTO buurt (code, naam) VALUES (6540006, 'Verspreide huizen ''s-Heerenhoek');
INSERT INTO buurt (code, naam) VALUES (6540007, 'Verspreide huizen Borssele');
INSERT INTO buurt (code, naam) VALUES (6540008, 'Verspreide huizen Nieuwdorp');
INSERT INTO buurt (code, naam) VALUES (6540009, 'Verspreide huizen Lewedorp');
INSERT INTO buurt (code, naam) VALUES (6540100, 'Heinkenszand');
INSERT INTO buurt (code, naam) VALUES (6540101, '''s-Gravenpolder');
INSERT INTO buurt (code, naam) VALUES (6540102, 'Nisse');
INSERT INTO buurt (code, naam) VALUES (6540103, '''s-Heer-Abtskerke');
INSERT INTO buurt (code, naam) VALUES (6540106, 'Verspreide huizen Heinkenszand');
INSERT INTO buurt (code, naam) VALUES (6540107, 'Verspreide huizen ''s-Gravenpolder');
INSERT INTO buurt (code, naam) VALUES (6540108, 'Verspreide huizen Nisse');
INSERT INTO buurt (code, naam) VALUES (6540109, 'Verspreide huizen ''s Heer-Abtskerke');
INSERT INTO buurt (code, naam) VALUES (6540200, 'Ovezande');
INSERT INTO buurt (code, naam) VALUES (6540201, 'Hoedekenskerke');
INSERT INTO buurt (code, naam) VALUES (6540202, 'Kwadendamme');
INSERT INTO buurt (code, naam) VALUES (6540207, 'Verspreide huizen Ovezande');
INSERT INTO buurt (code, naam) VALUES (6540208, 'Verspreide huizen Hoedekenskerke');
INSERT INTO buurt (code, naam) VALUES (6540209, 'Verspreide huizen Kwadendamme');
INSERT INTO buurt (code, naam) VALUES (6540300, 'Baarland');
INSERT INTO buurt (code, naam) VALUES (6540301, 'Oudelande');
INSERT INTO buurt (code, naam) VALUES (6540302, 'Driewegen');
INSERT INTO buurt (code, naam) VALUES (6540303, 'Ellewoutsdijk');
INSERT INTO buurt (code, naam) VALUES (6540306, 'Verspreide huizen Baarland');
INSERT INTO buurt (code, naam) VALUES (6540307, 'Verspreide huizen Oudelande');
INSERT INTO buurt (code, naam) VALUES (6540308, 'Verspreide huizen Driewegen');
INSERT INTO buurt (code, naam) VALUES (6540309, 'Verspreide huizen Ellewoutsdijk');
INSERT INTO buurt (code, naam) VALUES (6549998, '');
INSERT INTO buurt (code, naam) VALUES (6640101, 'Goes-Centrum');
INSERT INTO buurt (code, naam) VALUES (6640102, 'Goes-Oost');
INSERT INTO buurt (code, naam) VALUES (6640103, 'Goes-Zuid');
INSERT INTO buurt (code, naam) VALUES (6640104, 'Goes-West');
INSERT INTO buurt (code, naam) VALUES (6640105, 'Goes-Noordwest');
INSERT INTO buurt (code, naam) VALUES (6640106, 'Goes-Noordoost');
INSERT INTO buurt (code, naam) VALUES (6640107, 'Industrieterrein De Poel');
INSERT INTO buurt (code, naam) VALUES (6640108, 'Industrieterrein Haven');
INSERT INTO buurt (code, naam) VALUES (6640109, 'Goese Meer');
INSERT INTO buurt (code, naam) VALUES (6640110, 'Overzuid');
INSERT INTO buurt (code, naam) VALUES (6640111, 'Mannee');
INSERT INTO buurt (code, naam) VALUES (6640200, 'Wilhelminadorp');
INSERT INTO buurt (code, naam) VALUES (6640209, 'Verspreide huizen Wilhelminadorp');
INSERT INTO buurt (code, naam) VALUES (6640300, 'Kloetinge');
INSERT INTO buurt (code, naam) VALUES (6640301, 'Oostmolenpark');
INSERT INTO buurt (code, naam) VALUES (6640308, 'Verspreide huizen in het Oosten');
INSERT INTO buurt (code, naam) VALUES (6640309, 'Verspreide huizen in het Zuiden');
INSERT INTO buurt (code, naam) VALUES (6640400, 'Kattendijke');
INSERT INTO buurt (code, naam) VALUES (6640409, 'Verspreide huizen Kattendijke');
INSERT INTO buurt (code, naam) VALUES (6640500, '''s-Heer-Arendskerke');
INSERT INTO buurt (code, naam) VALUES (6640501, 'De Schenge');
INSERT INTO buurt (code, naam) VALUES (6640509, 'Verspreide huizen in het Westen');
INSERT INTO buurt (code, naam) VALUES (6640600, 'Eindewege');
INSERT INTO buurt (code, naam) VALUES (6640700, '''s-Heer-Hendrikskinderen');
INSERT INTO buurt (code, naam) VALUES (6640708, 'Verspreide huizen ten noorden van ''s-Heer-Hendrikskinderen');
INSERT INTO buurt (code, naam) VALUES (6640709, 'Verspreide huizen ten zuiden van ''s-Heer-Hendrikskinderen');
INSERT INTO buurt (code, naam) VALUES (6640800, 'Wolphaartsdijk');
INSERT INTO buurt (code, naam) VALUES (6640809, 'Verspreide huizen Wolphaartsdijk');
INSERT INTO buurt (code, naam) VALUES (6640900, 'Oud-Sabbinge');
INSERT INTO buurt (code, naam) VALUES (6649997, '');
INSERT INTO buurt (code, naam) VALUES (6649998, '');
INSERT INTO buurt (code, naam) VALUES (6680100, 'Kern Alphen');
INSERT INTO buurt (code, naam) VALUES (6680101, 'Buitengebied Alphen');
INSERT INTO buurt (code, naam) VALUES (6680200, 'Kern Altforst');
INSERT INTO buurt (code, naam) VALUES (6680201, 'Buitengebied Altforst');
INSERT INTO buurt (code, naam) VALUES (6680300, 'Kern Appeltern');
INSERT INTO buurt (code, naam) VALUES (6680301, 'Buitengebied Appeltern');
INSERT INTO buurt (code, naam) VALUES (6680400, 'Kern Beneden-Leeuwen');
INSERT INTO buurt (code, naam) VALUES (6680401, 'Buitengebied Beneden-Leeuwen');
INSERT INTO buurt (code, naam) VALUES (6680500, 'Kern Boven-Leeuwen');
INSERT INTO buurt (code, naam) VALUES (6680501, 'Buitengebied Boven-Leeuwen');
INSERT INTO buurt (code, naam) VALUES (6680600, 'Kern Dreumel');
INSERT INTO buurt (code, naam) VALUES (6680601, 'Buitengebied Dreumel');
INSERT INTO buurt (code, naam) VALUES (6680700, 'Kern Maasbommel');
INSERT INTO buurt (code, naam) VALUES (6680701, 'Buitengebied Maasbommel');
INSERT INTO buurt (code, naam) VALUES (6680800, 'Kern Wamel');
INSERT INTO buurt (code, naam) VALUES (6680801, 'Buitengebied Wamel');
INSERT INTO buurt (code, naam) VALUES (6770101, 'Hulst');
INSERT INTO buurt (code, naam) VALUES (6770102, 'Linie');
INSERT INTO buurt (code, naam) VALUES (6770103, '''t Jagertje-Schuddebeurs');
INSERT INTO buurt (code, naam) VALUES (6770104, 'Carmel');
INSERT INTO buurt (code, naam) VALUES (6770105, 'Dullaert');
INSERT INTO buurt (code, naam) VALUES (6770106, 'Absdaalseweg');
INSERT INTO buurt (code, naam) VALUES (6770107, 'Hogeweg');
INSERT INTO buurt (code, naam) VALUES (6770108, 'Zoetevaart');
INSERT INTO buurt (code, naam) VALUES (6770109, 'Groote Kreek');
INSERT INTO buurt (code, naam) VALUES (6770110, 'Absdale');
INSERT INTO buurt (code, naam) VALUES (6770112, 'Buitengebied Hulst');
INSERT INTO buurt (code, naam) VALUES (6770213, 'Kern Sint Jansteen');
INSERT INTO buurt (code, naam) VALUES (6770214, 'Buitengebied Sint Jansteen');
INSERT INTO buurt (code, naam) VALUES (6770315, 'Kern Clinge');
INSERT INTO buurt (code, naam) VALUES (6770316, 'Buitengebied Clinge');
INSERT INTO buurt (code, naam) VALUES (6770417, 'Kern Graauw');
INSERT INTO buurt (code, naam) VALUES (6770418, 'Kern Zandberg');
INSERT INTO buurt (code, naam) VALUES (6770419, 'Kern Paal');
INSERT INTO buurt (code, naam) VALUES (6770420, 'Buitengebied Graauw');
INSERT INTO buurt (code, naam) VALUES (6770521, 'Kern Heikant');
INSERT INTO buurt (code, naam) VALUES (6770522, 'Buitengebied Heikant');
INSERT INTO buurt (code, naam) VALUES (6770623, 'Kern Nieuw Namen');
INSERT INTO buurt (code, naam) VALUES (6770624, 'Buitengebied Nieuw Namen');
INSERT INTO buurt (code, naam) VALUES (6770725, 'Kern Kapellebrug');
INSERT INTO buurt (code, naam) VALUES (6770826, 'Kern Kloosterzande');
INSERT INTO buurt (code, naam) VALUES (6770827, 'Walsoorden');
INSERT INTO buurt (code, naam) VALUES (6770828, 'Buitengebied Kloosterzande');
INSERT INTO buurt (code, naam) VALUES (6770929, 'Kern Lamswaarde');
INSERT INTO buurt (code, naam) VALUES (6770930, 'Kuitaart');
INSERT INTO buurt (code, naam) VALUES (6770931, 'Buitengebied Lamswaarde');
INSERT INTO buurt (code, naam) VALUES (6770932, 'Kruispolder');
INSERT INTO buurt (code, naam) VALUES (6771033, 'Kern Terhole');
INSERT INTO buurt (code, naam) VALUES (6771034, 'Buitengebied Terhole');
INSERT INTO buurt (code, naam) VALUES (6771135, 'Kern Vogelwaarde');
INSERT INTO buurt (code, naam) VALUES (6771136, 'Buitengebied Vogelwaarde');
INSERT INTO buurt (code, naam) VALUES (6771237, 'Kern Hengstdijk');
INSERT INTO buurt (code, naam) VALUES (6771238, 'Buitengebied Hengstdijk');
INSERT INTO buurt (code, naam) VALUES (6771339, 'Kern Ossenisse');
INSERT INTO buurt (code, naam) VALUES (6771340, 'Buitengebied Ossenisse');
INSERT INTO buurt (code, naam) VALUES (6779998, '');
INSERT INTO buurt (code, naam) VALUES (6780000, 'Kapelle');
INSERT INTO buurt (code, naam) VALUES (6780009, 'Verspreide huizen Kapelle');
INSERT INTO buurt (code, naam) VALUES (6780100, 'Wemeldinge');
INSERT INTO buurt (code, naam) VALUES (6780109, 'Verspreide huizen Wemeldinge');
INSERT INTO buurt (code, naam) VALUES (6780200, 'Schore');
INSERT INTO buurt (code, naam) VALUES (6780209, 'Verspreide huizen Schore');
INSERT INTO buurt (code, naam) VALUES (6789998, '');
INSERT INTO buurt (code, naam) VALUES (6870000, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (6870100, 'Griffioen');
INSERT INTO buurt (code, naam) VALUES (6870101, 'Klarenbeek');
INSERT INTO buurt (code, naam) VALUES (6870102, 'Nieuw Middelburg');
INSERT INTO buurt (code, naam) VALUES (6870103, 'Brigdamme');
INSERT INTO buurt (code, naam) VALUES (6870104, 'Sint Laurens');
INSERT INTO buurt (code, naam) VALUES (6870105, 'Ramsburg');
INSERT INTO buurt (code, naam) VALUES (6870106, 'Veersepoort');
INSERT INTO buurt (code, naam) VALUES (6870107, 'Verspreide huizen in het Noorden');
INSERT INTO buurt (code, naam) VALUES (6870108, 'Verspreide huizen in het Noordwesten');
INSERT INTO buurt (code, naam) VALUES (6870109, 'Verspreide huizen in het Noordoosten');
INSERT INTO buurt (code, naam) VALUES (6870200, 'Stromenwijk/''t Zand');
INSERT INTO buurt (code, naam) VALUES (6870209, 'Verspreide huizen in het Zuidwesten');
INSERT INTO buurt (code, naam) VALUES (6870300, 'Middelburg-Zuid');
INSERT INTO buurt (code, naam) VALUES (6870301, 'Dauwendaele');
INSERT INTO buurt (code, naam) VALUES (6870302, 'Arnestein');
INSERT INTO buurt (code, naam) VALUES (6870309, 'Mortiere');
INSERT INTO buurt (code, naam) VALUES (6870400, 'Nieuw- en Sint Joosland');
INSERT INTO buurt (code, naam) VALUES (6870409, 'Verspreide huizen Nieuw- en Sint Joosland');
INSERT INTO buurt (code, naam) VALUES (6870500, 'Arnemuiden');
INSERT INTO buurt (code, naam) VALUES (6870501, 'Kleverskerke');
INSERT INTO buurt (code, naam) VALUES (6870502, 'Oranjeplaat');
INSERT INTO buurt (code, naam) VALUES (6870503, 'Veerse Meer');
INSERT INTO buurt (code, naam) VALUES (6870509, 'Verspreide huizen Arnemuiden');
INSERT INTO buurt (code, naam) VALUES (6879997, '');
INSERT INTO buurt (code, naam) VALUES (6890000, 'Giessenburg en Nieuwkerk');
INSERT INTO buurt (code, naam) VALUES (6890001, 'Peursum');
INSERT INTO buurt (code, naam) VALUES (6890002, 'Giessen en Oude-Bovenkerk');
INSERT INTO buurt (code, naam) VALUES (6890100, 'Giessen en Oudekerk');
INSERT INTO buurt (code, naam) VALUES (6890101, 'Neerpolder en Parallelweg');
INSERT INTO buurt (code, naam) VALUES (6890200, 'Muisbroek');
INSERT INTO buurt (code, naam) VALUES (6890201, 'Neder-Slingeland');
INSERT INTO buurt (code, naam) VALUES (6890308, 'Verspreide huizen polder Giessen en Nieuwkerk');
INSERT INTO buurt (code, naam) VALUES (6890309, 'Verspreide huizen ten noorden van De Giessen');
INSERT INTO buurt (code, naam) VALUES (6890400, 'Arkel');
INSERT INTO buurt (code, naam) VALUES (6890401, 'Rietveld');
INSERT INTO buurt (code, naam) VALUES (6890402, 'Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (6890500, 'Hoogblokland');
INSERT INTO buurt (code, naam) VALUES (6890501, 'Verspreide huizen Bazeldijk (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (6890502, 'Minkeloos (gedeeltelijk) Hoge Giessen (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (6890509, 'Overige verspreide huizen Hoogblokland');
INSERT INTO buurt (code, naam) VALUES (6890600, 'Hoornaar');
INSERT INTO buurt (code, naam) VALUES (6890601, 'Lage Giessen');
INSERT INTO buurt (code, naam) VALUES (6890602, 'Hoge Giessen (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (6890603, 'Hoornaar-Nieuw');
INSERT INTO buurt (code, naam) VALUES (6890700, 'Noordeloos');
INSERT INTO buurt (code, naam) VALUES (6890701, 'Overslingeland');
INSERT INTO buurt (code, naam) VALUES (6890702, 'Minkeloos (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (6890800, 'Schelluinen');
INSERT INTO buurt (code, naam) VALUES (7030000, 'Yerseke');
INSERT INTO buurt (code, naam) VALUES (7030009, 'Verspreide huizen Yerseke');
INSERT INTO buurt (code, naam) VALUES (7030100, 'Kruiningen');
INSERT INTO buurt (code, naam) VALUES (7030101, 'Hansweert');
INSERT INTO buurt (code, naam) VALUES (7030109, 'Verspreide huizen Kruiningen');
INSERT INTO buurt (code, naam) VALUES (7030200, 'Krabbendijke');
INSERT INTO buurt (code, naam) VALUES (7030201, 'Oostdijk');
INSERT INTO buurt (code, naam) VALUES (7030208, 'Verspreide huizen Oostdijk');
INSERT INTO buurt (code, naam) VALUES (7030209, 'Verspreide huizen Krabbendijke');
INSERT INTO buurt (code, naam) VALUES (7030300, 'Waarde');
INSERT INTO buurt (code, naam) VALUES (7030309, 'Verspreide huizen Waarde');
INSERT INTO buurt (code, naam) VALUES (7030400, 'Rilland');
INSERT INTO buurt (code, naam) VALUES (7030401, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (7030402, 'Bath');
INSERT INTO buurt (code, naam) VALUES (7030408, 'Verspreide huizen ten westen van Schelde-Rijnkanaal');
INSERT INTO buurt (code, naam) VALUES (7030409, 'Verspreide huizen ten oosten van Schelde-Rijnkanaal');
INSERT INTO buurt (code, naam) VALUES (7039998, '');
INSERT INTO buurt (code, naam) VALUES (7070100, 'Lexmond Kern');
INSERT INTO buurt (code, naam) VALUES (7070101, 'Achthoven');
INSERT INTO buurt (code, naam) VALUES (7070102, 'Lakerveld');
INSERT INTO buurt (code, naam) VALUES (7070103, 'Lexmond Polder');
INSERT INTO buurt (code, naam) VALUES (7070200, 'Ameide Kern');
INSERT INTO buurt (code, naam) VALUES (7070201, 'Sluis');
INSERT INTO buurt (code, naam) VALUES (7070202, 'Sluis Polder');
INSERT INTO buurt (code, naam) VALUES (7070203, 'Ameide Polder');
INSERT INTO buurt (code, naam) VALUES (7070300, 'Tienhoven Kern');
INSERT INTO buurt (code, naam) VALUES (7070301, 'Hogewaard');
INSERT INTO buurt (code, naam) VALUES (7070302, 'Tienhoven Polder');
INSERT INTO buurt (code, naam) VALUES (7070400, 'Meerkerk kern');
INSERT INTO buurt (code, naam) VALUES (7070401, 'Meerkers Broek');
INSERT INTO buurt (code, naam) VALUES (7070402, 'Meerkerk Polder');
INSERT INTO buurt (code, naam) VALUES (7070500, 'Hei- en Boeicop Kern');
INSERT INTO buurt (code, naam) VALUES (7070501, 'Hei- en Boeicop Polder');
INSERT INTO buurt (code, naam) VALUES (7070600, 'Leerbroek kern');
INSERT INTO buurt (code, naam) VALUES (7070601, 'Middelkoop');
INSERT INTO buurt (code, naam) VALUES (7070602, 'Weverwijk');
INSERT INTO buurt (code, naam) VALUES (7070603, 'Leerbroek Polder');
INSERT INTO buurt (code, naam) VALUES (7070700, 'Nieuwland Kern');
INSERT INTO buurt (code, naam) VALUES (7070701, 'Achterdijk');
INSERT INTO buurt (code, naam) VALUES (7070702, 'Geer');
INSERT INTO buurt (code, naam) VALUES (7070703, 'Nieuwland Polder');
INSERT INTO buurt (code, naam) VALUES (7151000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (7151100, 'West');
INSERT INTO buurt (code, naam) VALUES (7151900, 'Noord');
INSERT INTO buurt (code, naam) VALUES (7152000, 'Zuid');
INSERT INTO buurt (code, naam) VALUES (7152600, 'Oost');
INSERT INTO buurt (code, naam) VALUES (7152900, 'Spui-centrum');
INSERT INTO buurt (code, naam) VALUES (7153000, 'Biervliet');
INSERT INTO buurt (code, naam) VALUES (7153400, 'Biervliet (buitengebied)');
INSERT INTO buurt (code, naam) VALUES (7153500, 'Hoek');
INSERT INTO buurt (code, naam) VALUES (7153900, 'Hoek (buitengebied Noord)');
INSERT INTO buurt (code, naam) VALUES (7154000, 'Sluiskil');
INSERT INTO buurt (code, naam) VALUES (7154100, 'Sluiskil (buitengebied Oost)');
INSERT INTO buurt (code, naam) VALUES (7154500, 'Zaamslag');
INSERT INTO buurt (code, naam) VALUES (7154700, 'Zaamslag (buitengebied Noord)');
INSERT INTO buurt (code, naam) VALUES (7154900, 'Zaamslag (buitengebied Zuid)');
INSERT INTO buurt (code, naam) VALUES (7155000, 'Axel');
INSERT INTO buurt (code, naam) VALUES (7155100, 'Spui');
INSERT INTO buurt (code, naam) VALUES (7155400, 'Verspreide huizen Oost Axel');
INSERT INTO buurt (code, naam) VALUES (7155500, 'Koewacht');
INSERT INTO buurt (code, naam) VALUES (7155900, 'Verspreide huizen Koewacht');
INSERT INTO buurt (code, naam) VALUES (7156000, 'Zuiddorpe');
INSERT INTO buurt (code, naam) VALUES (7156400, 'Verspreide huizen Zuiddorpe');
INSERT INTO buurt (code, naam) VALUES (7156500, 'Overslag');
INSERT INTO buurt (code, naam) VALUES (7156900, 'Verspreide huizen Overslag');
INSERT INTO buurt (code, naam) VALUES (7157000, 'Sas van Gent');
INSERT INTO buurt (code, naam) VALUES (7157200, 'Buitengebied Sas van Gent-Zuid');
INSERT INTO buurt (code, naam) VALUES (7157400, 'Buitengebied Sas van Gent-Noord');
INSERT INTO buurt (code, naam) VALUES (7157500, 'Westdorpe');
INSERT INTO buurt (code, naam) VALUES (7157900, 'Buitengebied Westdorpe');
INSERT INTO buurt (code, naam) VALUES (7158000, 'Philippine');
INSERT INTO buurt (code, naam) VALUES (7158400, 'Buitengebied Philippine');
INSERT INTO buurt (code, naam) VALUES (7159998, '');
INSERT INTO buurt (code, naam) VALUES (7160000, 'Tholen');
INSERT INTO buurt (code, naam) VALUES (7160009, 'Verspreide huizen Tholen');
INSERT INTO buurt (code, naam) VALUES (7160100, 'Poortvliet');
INSERT INTO buurt (code, naam) VALUES (7160109, 'Verspreide huizen Poortvliet');
INSERT INTO buurt (code, naam) VALUES (7160200, 'Scherpenisse');
INSERT INTO buurt (code, naam) VALUES (7160209, 'Verspreide huizen Scherpenisse');
INSERT INTO buurt (code, naam) VALUES (7160300, 'Sint Maartensdijk');
INSERT INTO buurt (code, naam) VALUES (7160309, 'Verspreide huizen Sint Maartensdijk');
INSERT INTO buurt (code, naam) VALUES (7160400, 'Stavenisse');
INSERT INTO buurt (code, naam) VALUES (7160409, 'Verspreide huizen Stavenisse');
INSERT INTO buurt (code, naam) VALUES (7160500, 'Sint Annaland');
INSERT INTO buurt (code, naam) VALUES (7160509, 'Verspreide huizen Sint Annaland');
INSERT INTO buurt (code, naam) VALUES (7160600, 'Oud-Vossemeer');
INSERT INTO buurt (code, naam) VALUES (7160609, 'Verspreide huizen Oud-Vossemeer');
INSERT INTO buurt (code, naam) VALUES (7160700, 'Sint Philipsland');
INSERT INTO buurt (code, naam) VALUES (7160709, 'Verspreide huizen Sint Philipsland');
INSERT INTO buurt (code, naam) VALUES (7160800, 'Anna Jacobapolder');
INSERT INTO buurt (code, naam) VALUES (7160809, 'Verspreide huizen Anna Jacobapolder');
INSERT INTO buurt (code, naam) VALUES (7169997, '');
INSERT INTO buurt (code, naam) VALUES (7169998, '');
INSERT INTO buurt (code, naam) VALUES (7170000, 'Veere');
INSERT INTO buurt (code, naam) VALUES (7170001, 'Zanddijk');
INSERT INTO buurt (code, naam) VALUES (7170002, 'Buiten de Veste');
INSERT INTO buurt (code, naam) VALUES (7170009, 'Verspreide huizen Veere');
INSERT INTO buurt (code, naam) VALUES (7170100, 'Gapinge');
INSERT INTO buurt (code, naam) VALUES (7170109, 'Verspreide huizen Gapinge');
INSERT INTO buurt (code, naam) VALUES (7170200, 'Vrouwenpolder');
INSERT INTO buurt (code, naam) VALUES (7170201, 'Breezand');
INSERT INTO buurt (code, naam) VALUES (7170209, 'Verspreide huizen Vrouwenpolder');
INSERT INTO buurt (code, naam) VALUES (7170300, 'Serooskerke');
INSERT INTO buurt (code, naam) VALUES (7170309, 'Verspreide huizen Serooskerke');
INSERT INTO buurt (code, naam) VALUES (7170400, 'Domburg');
INSERT INTO buurt (code, naam) VALUES (7170409, 'Verspreide huizen Domburg');
INSERT INTO buurt (code, naam) VALUES (7170500, 'Oostkapelle');
INSERT INTO buurt (code, naam) VALUES (7170501, 'Randduin');
INSERT INTO buurt (code, naam) VALUES (7170502, 'Duno');
INSERT INTO buurt (code, naam) VALUES (7170508, 'Verspreide huizen in het Zuiden');
INSERT INTO buurt (code, naam) VALUES (7170509, 'Verspreide huizen in het Noorden');
INSERT INTO buurt (code, naam) VALUES (7170600, 'Aagtekerke');
INSERT INTO buurt (code, naam) VALUES (7170609, 'Verspreide huizen Aagtekerke');
INSERT INTO buurt (code, naam) VALUES (7170700, 'Grijpskerke');
INSERT INTO buurt (code, naam) VALUES (7170709, 'Verspreide huizen Grijpskerke');
INSERT INTO buurt (code, naam) VALUES (7170800, 'Meliskerke');
INSERT INTO buurt (code, naam) VALUES (7170809, 'Verspreide huizen Meliskerke');
INSERT INTO buurt (code, naam) VALUES (7170900, 'Koudekerke');
INSERT INTO buurt (code, naam) VALUES (7170901, 'Dishoek');
INSERT INTO buurt (code, naam) VALUES (7170908, 'Verspreide huizen recreatiegebied van Koudekerke');
INSERT INTO buurt (code, naam) VALUES (7170909, 'Verspreide huizen buiten recreatiegebied Koudekerke');
INSERT INTO buurt (code, naam) VALUES (7171000, 'Biggekerke');
INSERT INTO buurt (code, naam) VALUES (7171001, 'De Ruiser');
INSERT INTO buurt (code, naam) VALUES (7171008, 'Verspreide huizen in recreatiegebied van Biggekerke');
INSERT INTO buurt (code, naam) VALUES (7171009, 'Verspreide huizen buiten recreatiegebied Biggekerke');
INSERT INTO buurt (code, naam) VALUES (7171100, 'Zoutelande');
INSERT INTO buurt (code, naam) VALUES (7171101, 'Kustlicht');
INSERT INTO buurt (code, naam) VALUES (7171109, 'Verspreide huizen Zoutelande');
INSERT INTO buurt (code, naam) VALUES (7171200, 'Westkapelle');
INSERT INTO buurt (code, naam) VALUES (7171201, 'Joossesweg');
INSERT INTO buurt (code, naam) VALUES (7171209, 'Verspreide huizen Westkapelle');
INSERT INTO buurt (code, naam) VALUES (7179997, '');
INSERT INTO buurt (code, naam) VALUES (7179998, '');
INSERT INTO buurt (code, naam) VALUES (7180100, 'Oude Binnenstad');
INSERT INTO buurt (code, naam) VALUES (7180101, 'Scheldestraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (7180102, 'Stadhuisplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (7180200, 'Boulevard Spuikom en Vredehof Zuid');
INSERT INTO buurt (code, naam) VALUES (7180201, 'Bonedijksestraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (7180202, 'Bloemenlaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (7180203, 'Baskensburg-Zuid');
INSERT INTO buurt (code, naam) VALUES (7180204, 'Vredehof-Noord');
INSERT INTO buurt (code, naam) VALUES (7180205, 'Het Fort en omgeving');
INSERT INTO buurt (code, naam) VALUES (7180206, 'Herc. Segherslaan en omgeving');
INSERT INTO buurt (code, naam) VALUES (7180207, 'Baskensburg-Noord');
INSERT INTO buurt (code, naam) VALUES (7180300, 'Paauwenburg-Oost');
INSERT INTO buurt (code, naam) VALUES (7180301, 'Paauwenburg-West');
INSERT INTO buurt (code, naam) VALUES (7180302, 'Westduin');
INSERT INTO buurt (code, naam) VALUES (7180400, 'Rosenburgh');
INSERT INTO buurt (code, naam) VALUES (7180401, 'Bossenburgh-Weyevliet');
INSERT INTO buurt (code, naam) VALUES (7180402, 'Westerzicht');
INSERT INTO buurt (code, naam) VALUES (7180403, 'Lammerenburg B.P.');
INSERT INTO buurt (code, naam) VALUES (7180404, 'Zuidbeek');
INSERT INTO buurt (code, naam) VALUES (7180405, 'Papagaaienburg-Hofwijk');
INSERT INTO buurt (code, naam) VALUES (7180406, 'West-Souburg');
INSERT INTO buurt (code, naam) VALUES (7180407, 'Landelijk gebied Lammerenburg');
INSERT INTO buurt (code, naam) VALUES (7180408, 'Vrijburg');
INSERT INTO buurt (code, naam) VALUES (7180500, 'Kern-Oost-Souburg');
INSERT INTO buurt (code, naam) VALUES (7180501, 'Zeewijksingel');
INSERT INTO buurt (code, naam) VALUES (7180502, 'Schoonenburg-Groot Abeele');
INSERT INTO buurt (code, naam) VALUES (7180503, 'Molenweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (7180504, 'Landelijk gebied Oost-Souburg');
INSERT INTO buurt (code, naam) VALUES (7180600, 'Ritthem');
INSERT INTO buurt (code, naam) VALUES (7180602, 'Landelijk gebied Ritthem-Noord');
INSERT INTO buurt (code, naam) VALUES (7180603, 'Landelijk gebied Ritthem-Zuid');
INSERT INTO buurt (code, naam) VALUES (7180700, 'Binnen- en Buitenhavens');
INSERT INTO buurt (code, naam) VALUES (7180800, 'Sloegebied');
INSERT INTO buurt (code, naam) VALUES (7189998, '');
INSERT INTO buurt (code, naam) VALUES (7330000, 'Asperen Oude Kern');
INSERT INTO buurt (code, naam) VALUES (7330001, 'Westelijke uitbreiding Asperen');
INSERT INTO buurt (code, naam) VALUES (7330002, 'Noord uitbreiding Asperen industrieterrein');
INSERT INTO buurt (code, naam) VALUES (7330009, 'Verspreide huizen Asperen');
INSERT INTO buurt (code, naam) VALUES (7330100, 'Heukelum Oude Kern');
INSERT INTO buurt (code, naam) VALUES (7330101, 'Uitbreiding Heukelum');
INSERT INTO buurt (code, naam) VALUES (7330102, 'Spijk en Boveneind Spijk en Vogelswerf');
INSERT INTO buurt (code, naam) VALUES (7330109, 'Verspreide huizen Heukelum en Friezenwijk');
INSERT INTO buurt (code, naam) VALUES (7330200, 'Vuren');
INSERT INTO buurt (code, naam) VALUES (7330209, 'Verspreide huizen Vuren');
INSERT INTO buurt (code, naam) VALUES (7330300, 'Herwijnen');
INSERT INTO buurt (code, naam) VALUES (7330309, 'Verspreide huizen Herwijnen');
INSERT INTO buurt (code, naam) VALUES (7360000, 'Mijdrecht');
INSERT INTO buurt (code, naam) VALUES (7360001, 'Verspreide huizen 1e 2e 3e Bedijking');
INSERT INTO buurt (code, naam) VALUES (7360003, 'Kromme Mijdrecht en De Hoef');
INSERT INTO buurt (code, naam) VALUES (7360004, 'Vrouwenakker (gedeeltelijk) en Blokland');
INSERT INTO buurt (code, naam) VALUES (7360100, 'Mennonietenbuurt');
INSERT INTO buurt (code, naam) VALUES (7360101, 'Amstelhoek en Amstelkade');
INSERT INTO buurt (code, naam) VALUES (7360200, 'Vinkeveen');
INSERT INTO buurt (code, naam) VALUES (7360201, 'Zuiderwaart');
INSERT INTO buurt (code, naam) VALUES (7360202, 'Baambrugse Zuwe');
INSERT INTO buurt (code, naam) VALUES (7360203, 'Groenlandsekade en Vinkenkade');
INSERT INTO buurt (code, naam) VALUES (7360204, 'Nessersluis');
INSERT INTO buurt (code, naam) VALUES (7360207, 'Westerheul');
INSERT INTO buurt (code, naam) VALUES (7360208, 'Verspreide huizen Groot-Mijdrecht Waverveen');
INSERT INTO buurt (code, naam) VALUES (7360209, 'Demmerik en Plassen');
INSERT INTO buurt (code, naam) VALUES (7360300, 'Wilnis');
INSERT INTO buurt (code, naam) VALUES (7360308, 'Verspreide huizen in de polder Groot-Mijdrecht');
INSERT INTO buurt (code, naam) VALUES (7360309, 'Overige verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (7360400, 'Abcoude');
INSERT INTO buurt (code, naam) VALUES (7360401, 'Verspreide huizen langs het Gein');
INSERT INTO buurt (code, naam) VALUES (7360402, 'Verspreide huizen langs de Winkel en Stokkelaar');
INSERT INTO buurt (code, naam) VALUES (7360405, 'Baambrugge');
INSERT INTO buurt (code, naam) VALUES (7360406, 'Rijksstraatweg-Noord');
INSERT INTO buurt (code, naam) VALUES (7360407, 'Rijksstraatweg-Zuid en langs de Angstel');
INSERT INTO buurt (code, naam) VALUES (7360409, 'Overige verspreide huizen Abcoude');
INSERT INTO buurt (code, naam) VALUES (7370000, 'Burgum');
INSERT INTO buurt (code, naam) VALUES (7370009, 'Verspreide huizen Burgum');
INSERT INTO buurt (code, naam) VALUES (7370100, 'Aldtsjerk');
INSERT INTO buurt (code, naam) VALUES (7370101, 'Oentsjerk');
INSERT INTO buurt (code, naam) VALUES (7370102, 'Verspreide huizen Wyns');
INSERT INTO buurt (code, naam) VALUES (7370108, 'Verspreide huizen Aldtsjerk');
INSERT INTO buurt (code, naam) VALUES (7370109, 'Verspreide huizen Oentsjerk');
INSERT INTO buurt (code, naam) VALUES (7370200, 'Mûnein');
INSERT INTO buurt (code, naam) VALUES (7370201, 'Gytsjerk');
INSERT INTO buurt (code, naam) VALUES (7370208, 'Verspreide huizen Mûnein');
INSERT INTO buurt (code, naam) VALUES (7370209, 'Verspreide huizen Gytsjerk');
INSERT INTO buurt (code, naam) VALUES (7370300, 'Rypsjerk');
INSERT INTO buurt (code, naam) VALUES (7370309, 'Verspreide huizen Ryptsjerk');
INSERT INTO buurt (code, naam) VALUES (7370400, 'Tytsjerk');
INSERT INTO buurt (code, naam) VALUES (7370401, 'Suwâld');
INSERT INTO buurt (code, naam) VALUES (7370408, 'Verspreide huizen Tytsjerk');
INSERT INTO buurt (code, naam) VALUES (7370409, 'Verspreide huizen Suwâld');
INSERT INTO buurt (code, naam) VALUES (7370500, 'Earnewâld');
INSERT INTO buurt (code, naam) VALUES (7370501, 'Garyp');
INSERT INTO buurt (code, naam) VALUES (7370508, 'Verspreide huizen Earnewâld');
INSERT INTO buurt (code, naam) VALUES (7370509, 'Verspreide huizen Garyp');
INSERT INTO buurt (code, naam) VALUES (7370600, 'Sumar');
INSERT INTO buurt (code, naam) VALUES (7370609, 'Verspreide huizen Sumar');
INSERT INTO buurt (code, naam) VALUES (7370700, 'Eastermar');
INSERT INTO buurt (code, naam) VALUES (7370701, 'Jistrum');
INSERT INTO buurt (code, naam) VALUES (7370708, 'Verspreide huizen Eastermar');
INSERT INTO buurt (code, naam) VALUES (7370709, 'Verspreide huizen Jistrum');
INSERT INTO buurt (code, naam) VALUES (7370800, 'Noordburgum');
INSERT INTO buurt (code, naam) VALUES (7370809, 'Verspreide huizen Noordburgum');
INSERT INTO buurt (code, naam) VALUES (7370900, 'Hurdegaryp');
INSERT INTO buurt (code, naam) VALUES (7370909, 'Verspreide huizen Hurdegaryp');
INSERT INTO buurt (code, naam) VALUES (7380000, 'Wijk en Aalburg');
INSERT INTO buurt (code, naam) VALUES (7380001, 'Spijk');
INSERT INTO buurt (code, naam) VALUES (7380009, 'Verspreide huizen Wijk en Aalburg');
INSERT INTO buurt (code, naam) VALUES (7380100, 'Veen');
INSERT INTO buurt (code, naam) VALUES (7380109, 'Verspreide huizen Veen');
INSERT INTO buurt (code, naam) VALUES (7380200, 'Genderen');
INSERT INTO buurt (code, naam) VALUES (7380209, 'Verspreide huizen Genderen');
INSERT INTO buurt (code, naam) VALUES (7380300, 'Eethen');
INSERT INTO buurt (code, naam) VALUES (7380309, 'Verspreide huizen Eethen');
INSERT INTO buurt (code, naam) VALUES (7380400, 'Meeuwen');
INSERT INTO buurt (code, naam) VALUES (7380409, 'Verspreide huizen Meeuwen');
INSERT INTO buurt (code, naam) VALUES (7380500, 'Drongelen');
INSERT INTO buurt (code, naam) VALUES (7380509, 'Verspreide huizen Drongelen');
INSERT INTO buurt (code, naam) VALUES (7380600, 'Babyloniënbroek');
INSERT INTO buurt (code, naam) VALUES (7380609, 'Verspreide huizen Babyloniënbroek');
INSERT INTO buurt (code, naam) VALUES (7430000, 'Asten');
INSERT INTO buurt (code, naam) VALUES (7430001, 'De Loverbosch');
INSERT INTO buurt (code, naam) VALUES (7430002, 'Nobis');
INSERT INTO buurt (code, naam) VALUES (7430008, 'Verspreide huizen Achterbosch en Rinkveld');
INSERT INTO buurt (code, naam) VALUES (7430009, 'Verspreide huizen Asten');
INSERT INTO buurt (code, naam) VALUES (7430100, 'Heusden');
INSERT INTO buurt (code, naam) VALUES (7430109, 'Verspreide huizen Heusden');
INSERT INTO buurt (code, naam) VALUES (7430200, 'Ommel');
INSERT INTO buurt (code, naam) VALUES (7430209, 'Verspreide huizen Ommel');
INSERT INTO buurt (code, naam) VALUES (7430809, 'Verspreide huizen Kleine Heitrak en omgeving');
INSERT INTO buurt (code, naam) VALUES (7430909, 'Verspreide huizen Leensel en Hutten');
INSERT INTO buurt (code, naam) VALUES (7440000, 'Baarle-Nassau');
INSERT INTO buurt (code, naam) VALUES (7440001, 'Bungalowpark');
INSERT INTO buurt (code, naam) VALUES (7440002, 'Hoogbraak');
INSERT INTO buurt (code, naam) VALUES (7440009, 'Verspreide huizen Baarle-Nassau');
INSERT INTO buurt (code, naam) VALUES (7440100, 'Ulicoten');
INSERT INTO buurt (code, naam) VALUES (7440109, 'Verspreide huizen Ulicoten');
INSERT INTO buurt (code, naam) VALUES (7440209, 'Verspreide huizen Castelre');
INSERT INTO buurt (code, naam) VALUES (7480000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (7480001, 'Havenkwartier');
INSERT INTO buurt (code, naam) VALUES (7480002, 'Vestinggronden-Noord');
INSERT INTO buurt (code, naam) VALUES (7480003, 'Vestinggronden-Zuid');
INSERT INTO buurt (code, naam) VALUES (7480004, 'Het Fort');
INSERT INTO buurt (code, naam) VALUES (7480005, 'Zeekant');
INSERT INTO buurt (code, naam) VALUES (7480006, 'Het Glacis');
INSERT INTO buurt (code, naam) VALUES (7480100, 'Meilust Zuid');
INSERT INTO buurt (code, naam) VALUES (7480101, 'Meilust Noord');
INSERT INTO buurt (code, naam) VALUES (7480102, 'Tuinwijk');
INSERT INTO buurt (code, naam) VALUES (7480103, 'Noordgeest');
INSERT INTO buurt (code, naam) VALUES (7480200, 'Gageldonk-West');
INSERT INTO buurt (code, naam) VALUES (7480201, 'Warande-West');
INSERT INTO buurt (code, naam) VALUES (7480202, 'Gageldonk-Oost');
INSERT INTO buurt (code, naam) VALUES (7480203, 'Warande-Oost');
INSERT INTO buurt (code, naam) VALUES (7480204, 'Nieuw Borgvliet');
INSERT INTO buurt (code, naam) VALUES (7480205, 'Langeweg');
INSERT INTO buurt (code, naam) VALUES (7480206, 'Lage Meren');
INSERT INTO buurt (code, naam) VALUES (7480208, 'Verspreide huizen Heimolen');
INSERT INTO buurt (code, naam) VALUES (7480209, 'Buitengebied-Oost');
INSERT INTO buurt (code, naam) VALUES (7480300, 'Bergse Plaat');
INSERT INTO buurt (code, naam) VALUES (7480301, 'De Markiezaten');
INSERT INTO buurt (code, naam) VALUES (7480302, 'Schelde Vesting');
INSERT INTO buurt (code, naam) VALUES (7480306, 'Waterfront-Industriegebied');
INSERT INTO buurt (code, naam) VALUES (7480308, 'Augustapolder');
INSERT INTO buurt (code, naam) VALUES (7480309, 'Buitengebied-West');
INSERT INTO buurt (code, naam) VALUES (7480400, 'Halsteren-Centrum');
INSERT INTO buurt (code, naam) VALUES (7480401, 'De Beek');
INSERT INTO buurt (code, naam) VALUES (7480402, 'Nieuwe Molen');
INSERT INTO buurt (code, naam) VALUES (7480403, 'Jankenberg');
INSERT INTO buurt (code, naam) VALUES (7480404, 'Rode Schouw');
INSERT INTO buurt (code, naam) VALUES (7480405, 'De Schans en Oude Molen');
INSERT INTO buurt (code, naam) VALUES (7480408, 'Verspreide huizen Vrederust');
INSERT INTO buurt (code, naam) VALUES (7480409, 'Verspreide huizen Halsterse Polders');
INSERT INTO buurt (code, naam) VALUES (7480500, 'Lepelstraat');
INSERT INTO buurt (code, naam) VALUES (7480507, 'Verspreide huizen Kladde');
INSERT INTO buurt (code, naam) VALUES (7480508, 'Verspreide huizen Klutsdorp');
INSERT INTO buurt (code, naam) VALUES (7480509, 'Verspreide huizen Oud Glymespolder');
INSERT INTO buurt (code, naam) VALUES (7530001, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (7530002, 'Hoge Akker');
INSERT INTO buurt (code, naam) VALUES (7530003, 'Speelheide');
INSERT INTO buurt (code, naam) VALUES (7530004, 'De Leeuwerik');
INSERT INTO buurt (code, naam) VALUES (7530005, 'Villawijk');
INSERT INTO buurt (code, naam) VALUES (7530006, 'Batadorp');
INSERT INTO buurt (code, naam) VALUES (7530007, 'Salderes');
INSERT INTO buurt (code, naam) VALUES (7530008, 'Wilhelminadorp');
INSERT INTO buurt (code, naam) VALUES (7530009, 'Naastenbest');
INSERT INTO buurt (code, naam) VALUES (7530010, '''t Zand');
INSERT INTO buurt (code, naam) VALUES (7530011, 'Breeven');
INSERT INTO buurt (code, naam) VALUES (7530012, 'Heide');
INSERT INTO buurt (code, naam) VALUES (7530013, 'Heuveleind');
INSERT INTO buurt (code, naam) VALUES (7530014, 'Heivelden');
INSERT INTO buurt (code, naam) VALUES (7530015, 'Buitengebied');
INSERT INTO buurt (code, naam) VALUES (7530016, 'Dijkstraten');
INSERT INTO buurt (code, naam) VALUES (7530017, 'Kantonnier');
INSERT INTO buurt (code, naam) VALUES (7550000, 'Boekel');
INSERT INTO buurt (code, naam) VALUES (7550005, 'Verspreide huizen Logt en Berkhoek');
INSERT INTO buurt (code, naam) VALUES (7550006, 'Verspreide huizen Arendnest-Zijp');
INSERT INTO buurt (code, naam) VALUES (7550007, 'Verspreide huizen Zandhoek en Peelstraat');
INSERT INTO buurt (code, naam) VALUES (7550008, 'Verspreide huizen Molenwijk, Elzen en Neerbroek');
INSERT INTO buurt (code, naam) VALUES (7550009, 'Verspreide huizen Bovenstehuis en Peelsehuis');
INSERT INTO buurt (code, naam) VALUES (7550100, 'Venhorst');
INSERT INTO buurt (code, naam) VALUES (7550109, 'Verspreide huizen Venhorst');
INSERT INTO buurt (code, naam) VALUES (7560000, 'Boxmeer Centrum');
INSERT INTO buurt (code, naam) VALUES (7560001, 'Bakelgeert-Noord');
INSERT INTO buurt (code, naam) VALUES (7560002, 'Bakelgeert-Zuid');
INSERT INTO buurt (code, naam) VALUES (7560003, 'De Elzen');
INSERT INTO buurt (code, naam) VALUES (7560004, 'Villapark ''t Zand');
INSERT INTO buurt (code, naam) VALUES (7560005, 'Luneven');
INSERT INTO buurt (code, naam) VALUES (7560006, 'Hollesteeg');
INSERT INTO buurt (code, naam) VALUES (7560007, 'Maasbroeksche Blokken');
INSERT INTO buurt (code, naam) VALUES (7560008, 'Bedrijventerrein Saxa Gotha');
INSERT INTO buurt (code, naam) VALUES (7560009, 'Verspreide huizen Boxmeer');
INSERT INTO buurt (code, naam) VALUES (7560100, 'Sambeek Centrum');
INSERT INTO buurt (code, naam) VALUES (7560109, 'Verspreide huizen Sambeek');
INSERT INTO buurt (code, naam) VALUES (7560200, 'Beugen Centrum');
INSERT INTO buurt (code, naam) VALUES (7560209, 'Verspreide huizen Beugen');
INSERT INTO buurt (code, naam) VALUES (7560300, 'Oeffelt Centrum');
INSERT INTO buurt (code, naam) VALUES (7560309, 'Verspreide huizen Oeffelt');
INSERT INTO buurt (code, naam) VALUES (7560400, 'Rijkevoort Centrum');
INSERT INTO buurt (code, naam) VALUES (7560409, 'Verspreide huizen Rijkevoort');
INSERT INTO buurt (code, naam) VALUES (7560500, 'Vortum-Mullem Centrum');
INSERT INTO buurt (code, naam) VALUES (7560509, 'Verspreide huizen Vortum-Mullem');
INSERT INTO buurt (code, naam) VALUES (7560600, 'Vierlingsbeek Centrum');
INSERT INTO buurt (code, naam) VALUES (7560601, 'Groeningen Centrum');
INSERT INTO buurt (code, naam) VALUES (7560609, 'Verspreide huizen Vierlingsbeek en Groeningen');
INSERT INTO buurt (code, naam) VALUES (7560700, 'Overloon Centrum');
INSERT INTO buurt (code, naam) VALUES (7560707, 'Verspreide huizen Westerbeek');
INSERT INTO buurt (code, naam) VALUES (7560708, 'Verspreide huizen Stevensbeek');
INSERT INTO buurt (code, naam) VALUES (7560709, 'Verspreide huizen Overloon');
INSERT INTO buurt (code, naam) VALUES (7560800, 'Maashees Centrum');
INSERT INTO buurt (code, naam) VALUES (7560809, 'Verspreide huizen Maashees');
INSERT INTO buurt (code, naam) VALUES (7560900, 'Holthees Centrum');
INSERT INTO buurt (code, naam) VALUES (7560909, 'Verspreide Huizen Holthees');
INSERT INTO buurt (code, naam) VALUES (7570000, 'Boxtel-Centrum');
INSERT INTO buurt (code, naam) VALUES (7570001, 'Boxtel-Oost');
INSERT INTO buurt (code, naam) VALUES (7570002, 'Boxtel-Noord');
INSERT INTO buurt (code, naam) VALUES (7570003, 'Munsel-Selissen');
INSERT INTO buurt (code, naam) VALUES (7570004, 'Industrieterrein Boxtel');
INSERT INTO buurt (code, naam) VALUES (7570005, 'Verspreide huizen Kleinderliempde');
INSERT INTO buurt (code, naam) VALUES (7570006, 'Verspreide huizen Tongeren, Luissel en Nergena');
INSERT INTO buurt (code, naam) VALUES (7570007, 'Verspreide huizen Hal en Heult');
INSERT INTO buurt (code, naam) VALUES (7570008, 'Verspreide huizen Langenberg');
INSERT INTO buurt (code, naam) VALUES (7570009, 'Verspreide huizen Roond');
INSERT INTO buurt (code, naam) VALUES (7570100, 'Lennisheuvel');
INSERT INTO buurt (code, naam) VALUES (7570109, 'Verspreide huizen Lennisheuvel');
INSERT INTO buurt (code, naam) VALUES (7570200, 'Liempde');
INSERT INTO buurt (code, naam) VALUES (7570206, 'Hezelaar');
INSERT INTO buurt (code, naam) VALUES (7570207, 'Vrilkhoven');
INSERT INTO buurt (code, naam) VALUES (7570208, 'Verspreide huizen Kasteren en Berg');
INSERT INTO buurt (code, naam) VALUES (7570209, 'Verspreide huizen Velders, Bosch en De Scheeken');
INSERT INTO buurt (code, naam) VALUES (7580001, 'Valkenberg');
INSERT INTO buurt (code, naam) VALUES (7580002, 'Chassé');
INSERT INTO buurt (code, naam) VALUES (7580003, 'Fellenoord');
INSERT INTO buurt (code, naam) VALUES (7580004, 'Schorsmolen');
INSERT INTO buurt (code, naam) VALUES (7580005, 'Station');
INSERT INTO buurt (code, naam) VALUES (7580006, 'City');
INSERT INTO buurt (code, naam) VALUES (7580100, 'Belcrum');
INSERT INTO buurt (code, naam) VALUES (7580101, 'Doornbos-Linie');
INSERT INTO buurt (code, naam) VALUES (7580102, 'Biesdonk');
INSERT INTO buurt (code, naam) VALUES (7580103, 'Geeren-Zuid');
INSERT INTO buurt (code, naam) VALUES (7580104, 'Wisselaar');
INSERT INTO buurt (code, naam) VALUES (7580105, 'Krogten');
INSERT INTO buurt (code, naam) VALUES (7580106, 'Geeren-Noord');
INSERT INTO buurt (code, naam) VALUES (7580107, 'Waterdonken');
INSERT INTO buurt (code, naam) VALUES (7580200, 'Brabantpark');
INSERT INTO buurt (code, naam) VALUES (7580201, 'Sportpark');
INSERT INTO buurt (code, naam) VALUES (7580202, 'Zandberg');
INSERT INTO buurt (code, naam) VALUES (7580203, 'Heusdenhout');
INSERT INTO buurt (code, naam) VALUES (7580204, 'Moleneind-Oost');
INSERT INTO buurt (code, naam) VALUES (7580205, 'Hoogeind');
INSERT INTO buurt (code, naam) VALUES (7580300, 'Blauwe Kei');
INSERT INTO buurt (code, naam) VALUES (7580301, 'Ypelaar');
INSERT INTO buurt (code, naam) VALUES (7580302, 'Overakker');
INSERT INTO buurt (code, naam) VALUES (7580303, 'Ginneken');
INSERT INTO buurt (code, naam) VALUES (7580309, 'Mastbos');
INSERT INTO buurt (code, naam) VALUES (7580400, 'Boeimeer');
INSERT INTO buurt (code, naam) VALUES (7580401, 'Ruitersbos');
INSERT INTO buurt (code, naam) VALUES (7580500, 'Haagpoort');
INSERT INTO buurt (code, naam) VALUES (7580501, 'Heuvel');
INSERT INTO buurt (code, naam) VALUES (7580502, 'Tuinzigt');
INSERT INTO buurt (code, naam) VALUES (7580503, 'Princenhage');
INSERT INTO buurt (code, naam) VALUES (7580504, 'Westerpark');
INSERT INTO buurt (code, naam) VALUES (7580505, 'Heilaar');
INSERT INTO buurt (code, naam) VALUES (7580506, 'Hazeldonk');
INSERT INTO buurt (code, naam) VALUES (7580507, 'Steenakker');
INSERT INTO buurt (code, naam) VALUES (7580508, 'Effen-Rith');
INSERT INTO buurt (code, naam) VALUES (7580509, 'Liesbos');
INSERT INTO buurt (code, naam) VALUES (7580600, 'Gageldonk');
INSERT INTO buurt (code, naam) VALUES (7580601, 'Kievitsloop');
INSERT INTO buurt (code, naam) VALUES (7580602, 'Kesteren');
INSERT INTO buurt (code, naam) VALUES (7580603, 'Muizenberg');
INSERT INTO buurt (code, naam) VALUES (7580604, 'Heksenwiel');
INSERT INTO buurt (code, naam) VALUES (7580605, 'Overkroeten');
INSERT INTO buurt (code, naam) VALUES (7580606, 'Kroeten');
INSERT INTO buurt (code, naam) VALUES (7580607, 'Emer');
INSERT INTO buurt (code, naam) VALUES (7580609, 'Hagebeemd');
INSERT INTO buurt (code, naam) VALUES (7580700, 'Bavel');
INSERT INTO buurt (code, naam) VALUES (7580701, 'Nieuw Wolfslaar');
INSERT INTO buurt (code, naam) VALUES (7580709, 'Buitengebied Bavel');
INSERT INTO buurt (code, naam) VALUES (7580800, 'Ulvenhout');
INSERT INTO buurt (code, naam) VALUES (7580809, 'Buitengebied Ulvenhout');
INSERT INTO buurt (code, naam) VALUES (7580900, 'Prinsenbeek');
INSERT INTO buurt (code, naam) VALUES (7580909, 'Buitengebied Prinsenbeek');
INSERT INTO buurt (code, naam) VALUES (7581000, 'Teteringen');
INSERT INTO buurt (code, naam) VALUES (7581008, 'Vuchtpolder');
INSERT INTO buurt (code, naam) VALUES (7581009, 'Buitengebied Teteringen');
INSERT INTO buurt (code, naam) VALUES (7620000, 'Deurne-Centrum');
INSERT INTO buurt (code, naam) VALUES (7620001, 'Sint Jozefparochie');
INSERT INTO buurt (code, naam) VALUES (7620002, 'Zeilberg');
INSERT INTO buurt (code, naam) VALUES (7620003, 'Walsberg');
INSERT INTO buurt (code, naam) VALUES (7620004, 'Koolhof');
INSERT INTO buurt (code, naam) VALUES (7620005, 'Heiakker');
INSERT INTO buurt (code, naam) VALUES (7620006, 'Industrieterrein');
INSERT INTO buurt (code, naam) VALUES (7620007, 'De Vennen');
INSERT INTO buurt (code, naam) VALUES (7620009, 'Verspreide huizen Deurne');
INSERT INTO buurt (code, naam) VALUES (7620100, 'Vlierden');
INSERT INTO buurt (code, naam) VALUES (7620109, 'Verspreide huizen Vlierden');
INSERT INTO buurt (code, naam) VALUES (7620200, 'Liessel');
INSERT INTO buurt (code, naam) VALUES (7620209, 'Verspreide huizen Liessel');
INSERT INTO buurt (code, naam) VALUES (7620300, 'Neerkant');
INSERT INTO buurt (code, naam) VALUES (7620309, 'Verspreide huizen Neerkant');
INSERT INTO buurt (code, naam) VALUES (7620400, 'Helenaveen');
INSERT INTO buurt (code, naam) VALUES (7620409, 'Verspreide huizen Helenaveen');
INSERT INTO buurt (code, naam) VALUES (7650000, 'Oude Pekela');
INSERT INTO buurt (code, naam) VALUES (7650009, 'Verspreide huizen Oude Pekela');
INSERT INTO buurt (code, naam) VALUES (7650100, 'Nieuwe Pekela');
INSERT INTO buurt (code, naam) VALUES (7650101, 'Boven-Pekela');
INSERT INTO buurt (code, naam) VALUES (7650109, 'Verspreide huizen Nieuwe Pekela');
INSERT INTO buurt (code, naam) VALUES (7660101, 'West 1');
INSERT INTO buurt (code, naam) VALUES (7660102, 'Verspreide huizen West 1');
INSERT INTO buurt (code, naam) VALUES (7660103, 'west 2');
INSERT INTO buurt (code, naam) VALUES (7660104, 'Verspreide huizen West 2');
INSERT INTO buurt (code, naam) VALUES (7660105, 'Centrum Dongen');
INSERT INTO buurt (code, naam) VALUES (7660106, 'Beljaart');
INSERT INTO buurt (code, naam) VALUES (7660107, 'Biezen');
INSERT INTO buurt (code, naam) VALUES (7660108, 'Hoge Akker');
INSERT INTO buurt (code, naam) VALUES (7660109, 'Oud Dongen');
INSERT INTO buurt (code, naam) VALUES (7660110, 'Verspreide huizen Oost');
INSERT INTO buurt (code, naam) VALUES (7660111, 'Klein Dongen');
INSERT INTO buurt (code, naam) VALUES (7660112, 'Dongen-Vaart');
INSERT INTO buurt (code, naam) VALUES (7660113, 'Verspreide huizen Klein Dongen/Vaart');
INSERT INTO buurt (code, naam) VALUES (7660114, 'Tichelrijt');
INSERT INTO buurt (code, naam) VALUES (7660115, 'Wildert');
INSERT INTO buurt (code, naam) VALUES (7660216, '''s-Gravenmoer');
INSERT INTO buurt (code, naam) VALUES (7660217, 'Verspreide huizen ''s-Gravenmoer');
INSERT INTO buurt (code, naam) VALUES (7700000, 'Eersel-kom en Lindeakkers');
INSERT INTO buurt (code, naam) VALUES (7700001, 'Molenakkers');
INSERT INTO buurt (code, naam) VALUES (7700002, 'Eersel-Zuid');
INSERT INTO buurt (code, naam) VALUES (7700003, 'De Dijken');
INSERT INTO buurt (code, naam) VALUES (7700004, 'Kortkruis');
INSERT INTO buurt (code, naam) VALUES (7700005, 'Bedrijventerrein Eersel');
INSERT INTO buurt (code, naam) VALUES (7700006, 'Molenveld en Schadewijkstraat');
INSERT INTO buurt (code, naam) VALUES (7700007, 'Stokkelen en Hoogstraat');
INSERT INTO buurt (code, naam) VALUES (7700008, 'De Hees en Genderweg');
INSERT INTO buurt (code, naam) VALUES (7700009, 'Verspreide huizen Eersel');
INSERT INTO buurt (code, naam) VALUES (7700100, 'Duizel');
INSERT INTO buurt (code, naam) VALUES (7700101, 'De Donksbergen');
INSERT INTO buurt (code, naam) VALUES (7700102, 'Bedrijventerrein Duizel');
INSERT INTO buurt (code, naam) VALUES (7700109, 'Verspreide huizen Duizel');
INSERT INTO buurt (code, naam) VALUES (7700200, 'Steensel');
INSERT INTO buurt (code, naam) VALUES (7700209, 'Verspreide huizen Steensel');
INSERT INTO buurt (code, naam) VALUES (7700300, 'Vessem-kom');
INSERT INTO buurt (code, naam) VALUES (7700309, 'Verspreide huizen Vessem');
INSERT INTO buurt (code, naam) VALUES (7700400, 'Wintelre-kom');
INSERT INTO buurt (code, naam) VALUES (7700409, 'Verspreide huizen Wintelre');
INSERT INTO buurt (code, naam) VALUES (7700500, 'Knegsel-kom');
INSERT INTO buurt (code, naam) VALUES (7700501, 'Knegsel-Oeyenbos');
INSERT INTO buurt (code, naam) VALUES (7700509, 'Verspreide huizen Knegsel');
INSERT INTO buurt (code, naam) VALUES (7721111, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (7721112, 'Bergen');
INSERT INTO buurt (code, naam) VALUES (7721113, 'Witte Dame');
INSERT INTO buurt (code, naam) VALUES (7721114, 'Fellenoord');
INSERT INTO buurt (code, naam) VALUES (7721115, 'TU-terrein');
INSERT INTO buurt (code, naam) VALUES (7721211, 'Irisbuurt');
INSERT INTO buurt (code, naam) VALUES (7721212, 'Rochusbuurt');
INSERT INTO buurt (code, naam) VALUES (7721213, 'Elzent-Noord');
INSERT INTO buurt (code, naam) VALUES (7721214, 'Tuindorp');
INSERT INTO buurt (code, naam) VALUES (7721215, 'Joriskwartier');
INSERT INTO buurt (code, naam) VALUES (7721216, 'Bloemenplein');
INSERT INTO buurt (code, naam) VALUES (7721217, 'Looiakkers');
INSERT INTO buurt (code, naam) VALUES (7721218, 'Elzent-Zuid');
INSERT INTO buurt (code, naam) VALUES (7721221, 'Kerstroosplein');
INSERT INTO buurt (code, naam) VALUES (7721222, 'Gerardusplein');
INSERT INTO buurt (code, naam) VALUES (7721223, 'Genneperzijde');
INSERT INTO buurt (code, naam) VALUES (7721224, 'Roosten');
INSERT INTO buurt (code, naam) VALUES (7721225, 'Eikenburg');
INSERT INTO buurt (code, naam) VALUES (7721226, 'Sportpark Aalsterweg');
INSERT INTO buurt (code, naam) VALUES (7721230, 'Puttense Dreef');
INSERT INTO buurt (code, naam) VALUES (7721231, 'Poeijers');
INSERT INTO buurt (code, naam) VALUES (7721232, 'Burghplan');
INSERT INTO buurt (code, naam) VALUES (7721233, 'Sintenbuurt');
INSERT INTO buurt (code, naam) VALUES (7721234, 'Tivoli');
INSERT INTO buurt (code, naam) VALUES (7721235, 'Gijzenrooi');
INSERT INTO buurt (code, naam) VALUES (7721236, 'Nieuwe Erven');
INSERT INTO buurt (code, naam) VALUES (7721237, 'Kruidenbuurt');
INSERT INTO buurt (code, naam) VALUES (7721238, 'Schuttersbosch');
INSERT INTO buurt (code, naam) VALUES (7721239, 'Leenderheide');
INSERT INTO buurt (code, naam) VALUES (7721240, 'Riel');
INSERT INTO buurt (code, naam) VALUES (7721311, 'Villapark');
INSERT INTO buurt (code, naam) VALUES (7721312, 'Lakerlopen');
INSERT INTO buurt (code, naam) VALUES (7721321, 'Doornakkers-West');
INSERT INTO buurt (code, naam) VALUES (7721322, 'Doornakkers-Oost');
INSERT INTO buurt (code, naam) VALUES (7721328, 'Tongelresche Akkers');
INSERT INTO buurt (code, naam) VALUES (7721333, 'Muschberg Geestenberg');
INSERT INTO buurt (code, naam) VALUES (7721334, 'Urkhoven');
INSERT INTO buurt (code, naam) VALUES (7721335, '''t Hofke');
INSERT INTO buurt (code, naam) VALUES (7721336, 'Karpen');
INSERT INTO buurt (code, naam) VALUES (7721337, 'Koudenhoven');
INSERT INTO buurt (code, naam) VALUES (7721410, 'Limbeek-Zuid');
INSERT INTO buurt (code, naam) VALUES (7721411, 'Limbeek-Noord');
INSERT INTO buurt (code, naam) VALUES (7721412, 'Hemelrijken');
INSERT INTO buurt (code, naam) VALUES (7721413, 'Gildebuurt');
INSERT INTO buurt (code, naam) VALUES (7721414, 'Woenselse Watermolen');
INSERT INTO buurt (code, naam) VALUES (7721421, 'Groenewoud');
INSERT INTO buurt (code, naam) VALUES (7721422, 'Kronehoef');
INSERT INTO buurt (code, naam) VALUES (7721423, 'Barrier');
INSERT INTO buurt (code, naam) VALUES (7721424, 'Mensfoort');
INSERT INTO buurt (code, naam) VALUES (7721425, 'Rapenland');
INSERT INTO buurt (code, naam) VALUES (7721426, 'Vredeoord');
INSERT INTO buurt (code, naam) VALUES (7721431, 'Generalenbuurt');
INSERT INTO buurt (code, naam) VALUES (7721432, 'Oude Toren');
INSERT INTO buurt (code, naam) VALUES (7721433, 'Hondsheuvels');
INSERT INTO buurt (code, naam) VALUES (7721434, 'Oude Gracht-West');
INSERT INTO buurt (code, naam) VALUES (7721435, 'Oude Gracht-Oost');
INSERT INTO buurt (code, naam) VALUES (7721436, 'Eckartdal');
INSERT INTO buurt (code, naam) VALUES (7721511, 'Driehoeksbos');
INSERT INTO buurt (code, naam) VALUES (7721512, 'Prinsejagt');
INSERT INTO buurt (code, naam) VALUES (7721513, 'Jagershoef');
INSERT INTO buurt (code, naam) VALUES (7721514, '''t Hool');
INSERT INTO buurt (code, naam) VALUES (7721515, 'Winkelcentrum');
INSERT INTO buurt (code, naam) VALUES (7721516, 'Vlokhoven');
INSERT INTO buurt (code, naam) VALUES (7721520, 'Kapelbeemd');
INSERT INTO buurt (code, naam) VALUES (7721521, 'Kerkdorp Acht');
INSERT INTO buurt (code, naam) VALUES (7721522, 'Achtse Barrier-Gunterslaer');
INSERT INTO buurt (code, naam) VALUES (7721523, 'Achtse Barrier-Spaaihoef');
INSERT INTO buurt (code, naam) VALUES (7721524, 'Achtse Barrier-Hoeven');
INSERT INTO buurt (code, naam) VALUES (7721531, 'Woenselse Heide');
INSERT INTO buurt (code, naam) VALUES (7721532, 'Tempel');
INSERT INTO buurt (code, naam) VALUES (7721533, 'Blixembosch-West');
INSERT INTO buurt (code, naam) VALUES (7721534, 'Blixembosch-Oost');
INSERT INTO buurt (code, naam) VALUES (7721535, 'Castilielaan');
INSERT INTO buurt (code, naam) VALUES (7721541, 'Eckart');
INSERT INTO buurt (code, naam) VALUES (7721542, 'Luytelaer');
INSERT INTO buurt (code, naam) VALUES (7721543, 'Vaartbroek');
INSERT INTO buurt (code, naam) VALUES (7721544, 'Heesterakker');
INSERT INTO buurt (code, naam) VALUES (7721545, 'Esp');
INSERT INTO buurt (code, naam) VALUES (7721546, 'Bokt');
INSERT INTO buurt (code, naam) VALUES (7721611, 'Eliasterrein, Vonderkwartier');
INSERT INTO buurt (code, naam) VALUES (7721612, 'Philipsdorp');
INSERT INTO buurt (code, naam) VALUES (7721613, 'Engelsbergen');
INSERT INTO buurt (code, naam) VALUES (7721614, 'Schouwbroek');
INSERT INTO buurt (code, naam) VALUES (7721615, 'Schoot');
INSERT INTO buurt (code, naam) VALUES (7721616, 'Strijp S');
INSERT INTO buurt (code, naam) VALUES (7721621, 'Hurk');
INSERT INTO buurt (code, naam) VALUES (7721622, 'Het Ven');
INSERT INTO buurt (code, naam) VALUES (7721623, 'Lievendaal');
INSERT INTO buurt (code, naam) VALUES (7721624, 'Drents Dorp');
INSERT INTO buurt (code, naam) VALUES (7721625, 'Zwaanstraat');
INSERT INTO buurt (code, naam) VALUES (7721626, 'Wielewaal');
INSERT INTO buurt (code, naam) VALUES (7721627, 'Herdgang');
INSERT INTO buurt (code, naam) VALUES (7721628, 'Mispelhoef');
INSERT INTO buurt (code, naam) VALUES (7721631, 'Beatrixkanaal-A2');
INSERT INTO buurt (code, naam) VALUES (7721632, 'Meerbos');
INSERT INTO buurt (code, naam) VALUES (7721633, 'Grasrijk');
INSERT INTO buurt (code, naam) VALUES (7721634, 'Bos- en Zandrijk');
INSERT INTO buurt (code, naam) VALUES (7721635, 'Waterrijk');
INSERT INTO buurt (code, naam) VALUES (7721636, 'Park Forum');
INSERT INTO buurt (code, naam) VALUES (7721637, 'Flight Forum');
INSERT INTO buurt (code, naam) VALUES (7721638, 'Eindhoven Airport');
INSERT INTO buurt (code, naam) VALUES (7721639, 'Bosrijk');
INSERT INTO buurt (code, naam) VALUES (7721640, 'Meerrijk');
INSERT INTO buurt (code, naam) VALUES (7721711, 'Schrijversbuurt');
INSERT INTO buurt (code, naam) VALUES (7721712, 'Oude Spoorbaan');
INSERT INTO buurt (code, naam) VALUES (7721713, 'Hagenkamp');
INSERT INTO buurt (code, naam) VALUES (7721721, 'Genderdal');
INSERT INTO buurt (code, naam) VALUES (7721722, 'Blaarthem');
INSERT INTO buurt (code, naam) VALUES (7721723, 'Rapelenburg');
INSERT INTO buurt (code, naam) VALUES (7721724, 'Bennekel-Oost');
INSERT INTO buurt (code, naam) VALUES (7721725, 'Bennekel-West, Gagelbosch');
INSERT INTO buurt (code, naam) VALUES (7721726, 'Gennep');
INSERT INTO buurt (code, naam) VALUES (7721727, 'Beemden');
INSERT INTO buurt (code, naam) VALUES (7721731, 'Genderbeemd');
INSERT INTO buurt (code, naam) VALUES (7721732, 'Hanevoet');
INSERT INTO buurt (code, naam) VALUES (7721733, 'Ooievaarsnest');
INSERT INTO buurt (code, naam) VALUES (7770000, 'Centrum Oost 1');
INSERT INTO buurt (code, naam) VALUES (7770001, 'Centrum Oost 2');
INSERT INTO buurt (code, naam) VALUES (7770002, 'Centrum Oost 3');
INSERT INTO buurt (code, naam) VALUES (7770003, 'Centrum West 1');
INSERT INTO buurt (code, naam) VALUES (7770004, 'Centrum West 2');
INSERT INTO buurt (code, naam) VALUES (7770005, 'Het Hooghuis');
INSERT INTO buurt (code, naam) VALUES (7770100, 'Bedrijventerrein Vosdonk');
INSERT INTO buurt (code, naam) VALUES (7770200, 'Etten-Leur Midden landelijk gebied');
INSERT INTO buurt (code, naam) VALUES (7771000, 'Noord 1');
INSERT INTO buurt (code, naam) VALUES (7771001, 'Noord 2');
INSERT INTO buurt (code, naam) VALUES (7771002, 'Noord 3');
INSERT INTO buurt (code, naam) VALUES (7771003, 'Noord 4, Stichting Het Hooghuys');
INSERT INTO buurt (code, naam) VALUES (7771004, 'Baai 1');
INSERT INTO buurt (code, naam) VALUES (7771005, 'Baai 2');
INSERT INTO buurt (code, naam) VALUES (7771006, 'Baai 3');
INSERT INTO buurt (code, naam) VALUES (7771007, 'Baai 4, Markenland');
INSERT INTO buurt (code, naam) VALUES (7771008, 'Sander-Banken 1, Broeders Internaat');
INSERT INTO buurt (code, naam) VALUES (7771009, 'Sander-Banken 2, Klein Sander');
INSERT INTO buurt (code, naam) VALUES (7771010, 'Sander-Banken 3, Groot Sander');
INSERT INTO buurt (code, naam) VALUES (7771011, 'Sander-Banken 4, Lage Banken');
INSERT INTO buurt (code, naam) VALUES (7771012, 'De Grient');
INSERT INTO buurt (code, naam) VALUES (7771013, 'De Keen');
INSERT INTO buurt (code, naam) VALUES (7771014, 'Attelaken');
INSERT INTO buurt (code, naam) VALUES (7771015, 'Schoenmakershoek');
INSERT INTO buurt (code, naam) VALUES (7771100, 'Bedrijventerrein Vossendaal');
INSERT INTO buurt (code, naam) VALUES (7771200, 'Landelijk gebied 1 (Noord)');
INSERT INTO buurt (code, naam) VALUES (7771201, 'Landelijk gebied 2 (Noord)');
INSERT INTO buurt (code, naam) VALUES (7771202, 'Landelijk gebied 3 (Noord)');
INSERT INTO buurt (code, naam) VALUES (7771203, 'Landelijk gebied 4 (Noord)');
INSERT INTO buurt (code, naam) VALUES (7772000, 'Banakkers 1');
INSERT INTO buurt (code, naam) VALUES (7772001, 'Banakkers 2');
INSERT INTO buurt (code, naam) VALUES (7772002, 'Banakkers 3');
INSERT INTO buurt (code, naam) VALUES (7772003, 'Banakkers 4, Achter de Molen');
INSERT INTO buurt (code, naam) VALUES (7772004, 'Grauwe Polder 1');
INSERT INTO buurt (code, naam) VALUES (7772005, 'Grauwe Polder 2');
INSERT INTO buurt (code, naam) VALUES (7772006, 'Grauwe Polder 3');
INSERT INTO buurt (code, naam) VALUES (7772007, 'Grauwe Polder 4');
INSERT INTO buurt (code, naam) VALUES (7772008, 'Grauwe Polder 5, ''t Winhof');
INSERT INTO buurt (code, naam) VALUES (7772009, 'Hoge Neerstraat');
INSERT INTO buurt (code, naam) VALUES (7772010, 'Centrumplan');
INSERT INTO buurt (code, naam) VALUES (7772100, 'Bedrijventerrein Vosdonk-Zuid');
INSERT INTO buurt (code, naam) VALUES (7772200, 'Bedrijventerrein Trivium');
INSERT INTO buurt (code, naam) VALUES (7772300, 'Landelijk gebied 1 (Zuid)');
INSERT INTO buurt (code, naam) VALUES (7772301, 'Landelijk gebied 2 (Zuid)');
INSERT INTO buurt (code, naam) VALUES (7772302, 'Landelijk gebied 3 (Zuid)');
INSERT INTO buurt (code, naam) VALUES (7772303, 'Landelijk gebied 4 (Zuid)');
INSERT INTO buurt (code, naam) VALUES (7790000, 'Raamsdonksveer');
INSERT INTO buurt (code, naam) VALUES (7790001, 'Hooipolder en De Hoeven');
INSERT INTO buurt (code, naam) VALUES (7790002, 'Industrieterrein Dombosch');
INSERT INTO buurt (code, naam) VALUES (7790009, 'Verspreide huizen Raamsdonksveer');
INSERT INTO buurt (code, naam) VALUES (7790100, 'Raamsdonk');
INSERT INTO buurt (code, naam) VALUES (7790109, 'Verspreide huizen Raamsdonk');
INSERT INTO buurt (code, naam) VALUES (7790200, 'Geertruidenberg-Kom');
INSERT INTO buurt (code, naam) VALUES (7790201, 'Geertruidenberg-West');
INSERT INTO buurt (code, naam) VALUES (7790202, 'Geertruidenberg-Noord');
INSERT INTO buurt (code, naam) VALUES (7790203, 'Industrieterrein Dongeoever Amerkant');
INSERT INTO buurt (code, naam) VALUES (7790209, 'Verspreide huizen Geertruidenberg');
INSERT INTO buurt (code, naam) VALUES (7840000, 'Rijen');
INSERT INTO buurt (code, naam) VALUES (7840007, 'Bedrijventerrein Haansberg');
INSERT INTO buurt (code, naam) VALUES (7840009, 'Verspreide huizen Rijen');
INSERT INTO buurt (code, naam) VALUES (7840100, 'Gilze');
INSERT INTO buurt (code, naam) VALUES (7840107, 'Bedrijventerrein Broekakkers');
INSERT INTO buurt (code, naam) VALUES (7840109, 'Verspreide huizen Gilze');
INSERT INTO buurt (code, naam) VALUES (7840200, 'Molenschot');
INSERT INTO buurt (code, naam) VALUES (7840209, 'Verspreide huizen Molenschot');
INSERT INTO buurt (code, naam) VALUES (7840300, 'Hulten');
INSERT INTO buurt (code, naam) VALUES (7840309, 'Verspreide huizen Hulten');
INSERT INTO buurt (code, naam) VALUES (7850101, 'Goirle-Centrum');
INSERT INTO buurt (code, naam) VALUES (7850202, 'Grobbendonck');
INSERT INTO buurt (code, naam) VALUES (7850303, 'De Groote Akkers');
INSERT INTO buurt (code, naam) VALUES (7850304, 'De Leijzoom');
INSERT INTO buurt (code, naam) VALUES (7850405, 'De Hoogte');
INSERT INTO buurt (code, naam) VALUES (7850406, 'De Vallei');
INSERT INTO buurt (code, naam) VALUES (7850507, 'Abcoven');
INSERT INTO buurt (code, naam) VALUES (7850608, 'Wildackers');
INSERT INTO buurt (code, naam) VALUES (7850709, '''t Ven');
INSERT INTO buurt (code, naam) VALUES (7850710, 'Burgemeesters');
INSERT INTO buurt (code, naam) VALUES (7850811, 'Tilburgseweg');
INSERT INTO buurt (code, naam) VALUES (7850812, 'De Boschkens-West');
INSERT INTO buurt (code, naam) VALUES (7850813, 'De Boschkens-Oost');
INSERT INTO buurt (code, naam) VALUES (7850914, 'Vennen');
INSERT INTO buurt (code, naam) VALUES (7850915, 'Bomen');
INSERT INTO buurt (code, naam) VALUES (7850916, 'De Villa');
INSERT INTO buurt (code, naam) VALUES (7850917, 'Rivieren');
INSERT INTO buurt (code, naam) VALUES (7850918, 'Kruiden');
INSERT INTO buurt (code, naam) VALUES (7851019, 'De Nieuwe Erven');
INSERT INTO buurt (code, naam) VALUES (7851120, 'Hoogeind');
INSERT INTO buurt (code, naam) VALUES (7851121, 'Geestelijken');
INSERT INTO buurt (code, naam) VALUES (7851122, 'Herstallen');
INSERT INTO buurt (code, naam) VALUES (7851223, 'Sportpark Van den Wildenberg');
INSERT INTO buurt (code, naam) VALUES (7851324, 'Tijlvoort-Noort');
INSERT INTO buurt (code, naam) VALUES (7851325, 'Tijlvoort-Zuid');
INSERT INTO buurt (code, naam) VALUES (7851426, 'Verspreide huizen Goirle');
INSERT INTO buurt (code, naam) VALUES (7852027, 'Riel-Dorp');
INSERT INTO buurt (code, naam) VALUES (7852028, 'Spaansehoek');
INSERT INTO buurt (code, naam) VALUES (7852129, 'Bedrijventerrein Riel');
INSERT INTO buurt (code, naam) VALUES (7852230, 'Sportpark De Krim');
INSERT INTO buurt (code, naam) VALUES (7852331, 'Verspreide huizen Riel');
INSERT INTO buurt (code, naam) VALUES (7860000, 'Binnenstad-Grave');
INSERT INTO buurt (code, naam) VALUES (7860001, 'Mars');
INSERT INTO buurt (code, naam) VALUES (7860002, 'Bikkelkamp');
INSERT INTO buurt (code, naam) VALUES (7860003, 'Esterveld');
INSERT INTO buurt (code, naam) VALUES (7860004, 'Zittert');
INSERT INTO buurt (code, naam) VALUES (7860005, 'De Stoof');
INSERT INTO buurt (code, naam) VALUES (7860006, 'Industrieterrein Wisseveld');
INSERT INTO buurt (code, naam) VALUES (7860100, 'Escharen kom');
INSERT INTO buurt (code, naam) VALUES (7860101, 'Buitengebied West inclusief Raam');
INSERT INTO buurt (code, naam) VALUES (7860102, 'Buitengebied-Oost');
INSERT INTO buurt (code, naam) VALUES (7860200, 'Oud Velp');
INSERT INTO buurt (code, naam) VALUES (7860201, 'Nieuw Veld');
INSERT INTO buurt (code, naam) VALUES (7860202, 'Buitengebied-Noord inclusief rijksweg');
INSERT INTO buurt (code, naam) VALUES (7860203, 'Buitengebied Zuid');
INSERT INTO buurt (code, naam) VALUES (7860204, 'Industrieterrein De Eek');
INSERT INTO buurt (code, naam) VALUES (7860300, 'Gassel kom');
INSERT INTO buurt (code, naam) VALUES (7860301, 'Buitengebied Gassel');
INSERT INTO buurt (code, naam) VALUES (7880100, 'Haaren');
INSERT INTO buurt (code, naam) VALUES (7880101, '''t Eind');
INSERT INTO buurt (code, naam) VALUES (7880108, 'Verspreide huizen in het Westen');
INSERT INTO buurt (code, naam) VALUES (7880109, 'Verspreide huizen in het Oosten');
INSERT INTO buurt (code, naam) VALUES (7880110, 'Noenes');
INSERT INTO buurt (code, naam) VALUES (7880200, 'Helvoirt');
INSERT INTO buurt (code, naam) VALUES (7880201, 'Distelberg');
INSERT INTO buurt (code, naam) VALUES (7880207, 'Verspreide huizen Helvoirtse Heide');
INSERT INTO buurt (code, naam) VALUES (7880208, 'Verspreide huizen Brokkenbroek en Laar');
INSERT INTO buurt (code, naam) VALUES (7880209, 'Verspreide huizen Gijzel, Raam en Molenstraat');
INSERT INTO buurt (code, naam) VALUES (7880300, 'Esch');
INSERT INTO buurt (code, naam) VALUES (7880309, 'Verspreide huizen Esch');
INSERT INTO buurt (code, naam) VALUES (7880400, 'Biezenmortel');
INSERT INTO buurt (code, naam) VALUES (7880401, 'Huize Assisië');
INSERT INTO buurt (code, naam) VALUES (7880409, 'Verspreide huizen Biezenmortel');
INSERT INTO buurt (code, naam) VALUES (7941000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (7941002, 'Leonardus');
INSERT INTO buurt (code, naam) VALUES (7941003, 'Heipoort');
INSERT INTO buurt (code, naam) VALUES (7941004, 'Stationsgebied');
INSERT INTO buurt (code, naam) VALUES (7941005, 'Vossenberg');
INSERT INTO buurt (code, naam) VALUES (7941006, 'Annabuurt en Suytkade');
INSERT INTO buurt (code, naam) VALUES (7941007, 'Steenweg en omgeving');
INSERT INTO buurt (code, naam) VALUES (7941100, 'Beisterveld');
INSERT INTO buurt (code, naam) VALUES (7941101, 'Beisterveldse Broek');
INSERT INTO buurt (code, naam) VALUES (7941102, 'Straakven');
INSERT INTO buurt (code, naam) VALUES (7941200, 'Bloemvelden');
INSERT INTO buurt (code, naam) VALUES (7941201, 'Binderen');
INSERT INTO buurt (code, naam) VALUES (7941202, 'Eeuwsels');
INSERT INTO buurt (code, naam) VALUES (7941300, '''t Hout-Centrum');
INSERT INTO buurt (code, naam) VALUES (7941301, 'Kroon');
INSERT INTO buurt (code, naam) VALUES (7941302, 'Akkers');
INSERT INTO buurt (code, naam) VALUES (7941303, 'Gansenwinkel');
INSERT INTO buurt (code, naam) VALUES (7941309, 'Groot Goor');
INSERT INTO buurt (code, naam) VALUES (7941400, 'Brouwhuis-Dorp');
INSERT INTO buurt (code, naam) VALUES (7941401, 'Brouwhuis-West');
INSERT INTO buurt (code, naam) VALUES (7941402, 'Brouwhuis-Oost');
INSERT INTO buurt (code, naam) VALUES (7941404, 'Brouwhorst');
INSERT INTO buurt (code, naam) VALUES (7941409, 'Kloostereind');
INSERT INTO buurt (code, naam) VALUES (7941500, 'West');
INSERT INTO buurt (code, naam) VALUES (7941501, 'Houtsdonk');
INSERT INTO buurt (code, naam) VALUES (7941600, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (7941601, 'Zwanenbeemd');
INSERT INTO buurt (code, naam) VALUES (7941609, 'Overbrug');
INSERT INTO buurt (code, naam) VALUES (7941700, 'Stiphout-Dorp');
INSERT INTO buurt (code, naam) VALUES (7941701, 'Schooten');
INSERT INTO buurt (code, naam) VALUES (7941709, 'Geeneind');
INSERT INTO buurt (code, naam) VALUES (7941801, 'Rijpelberg-Oost');
INSERT INTO buurt (code, naam) VALUES (7941802, 'Rijpelberg-West');
INSERT INTO buurt (code, naam) VALUES (7941809, 'Berkendonk');
INSERT INTO buurt (code, naam) VALUES (7941900, 'Kern Dierdonk');
INSERT INTO buurt (code, naam) VALUES (7941909, 'Scheepstal');
INSERT INTO buurt (code, naam) VALUES (7942100, 'Brand');
INSERT INTO buurt (code, naam) VALUES (7942101, 'De Veste');
INSERT INTO buurt (code, naam) VALUES (7942102, 'Schutsboom');
INSERT INTO buurt (code, naam) VALUES (7942103, 'Stepekolk');
INSERT INTO buurt (code, naam) VALUES (7942104, 'Berenbroek');
INSERT INTO buurt (code, naam) VALUES (7942105, 'De marke');
INSERT INTO buurt (code, naam) VALUES (7942901, 'Hoogeind');
INSERT INTO buurt (code, naam) VALUES (7942902, 'B.Z.O.B.');
INSERT INTO buurt (code, naam) VALUES (7960101, 'Binnenstad-Centrum');
INSERT INTO buurt (code, naam) VALUES (7960102, 'Binnenstad-Oost');
INSERT INTO buurt (code, naam) VALUES (7960103, 'De Hofstad');
INSERT INTO buurt (code, naam) VALUES (7960104, 'Binnenstad-Noord');
INSERT INTO buurt (code, naam) VALUES (7960105, 'Het Zand');
INSERT INTO buurt (code, naam) VALUES (7960106, 'Vughterpoort');
INSERT INTO buurt (code, naam) VALUES (7960201, 'Het Bossche Broek');
INSERT INTO buurt (code, naam) VALUES (7960202, 'Zuid');
INSERT INTO buurt (code, naam) VALUES (7960203, 'Bazeldonk');
INSERT INTO buurt (code, naam) VALUES (7960204, 'Bedrijventerrein-Zuid');
INSERT INTO buurt (code, naam) VALUES (7960205, 'De Gestelse Buurt');
INSERT INTO buurt (code, naam) VALUES (7960206, 'Pettelaarpark');
INSERT INTO buurt (code, naam) VALUES (7960207, 'De Meerendonk');
INSERT INTO buurt (code, naam) VALUES (7960208, 'Eikendonk en Kloosterstraat');
INSERT INTO buurt (code, naam) VALUES (7960209, 'De Bossche Pad');
INSERT INTO buurt (code, naam) VALUES (7960210, 'Grevelingen');
INSERT INTO buurt (code, naam) VALUES (7960211, 'Aawijk-Zuid');
INSERT INTO buurt (code, naam) VALUES (7960212, 'Bedrijvenpark De Brand');
INSERT INTO buurt (code, naam) VALUES (7960301, 'De Hinthamerpoort');
INSERT INTO buurt (code, naam) VALUES (7960302, 'Graafsebuurt-Zuid');
INSERT INTO buurt (code, naam) VALUES (7960303, 'Aawijk-Noord');
INSERT INTO buurt (code, naam) VALUES (7960304, 'Graafsebuurt-Noord');
INSERT INTO buurt (code, naam) VALUES (7960305, 'Hintham-Zuid');
INSERT INTO buurt (code, naam) VALUES (7960306, 'Hintham-Noord');
INSERT INTO buurt (code, naam) VALUES (7960401, 'De Muntel');
INSERT INTO buurt (code, naam) VALUES (7960402, 'De Vliert');
INSERT INTO buurt (code, naam) VALUES (7960403, 'Orthenpoort');
INSERT INTO buurt (code, naam) VALUES (7960501, 'Maliskamp-West');
INSERT INTO buurt (code, naam) VALUES (7960502, 'Maliskamp-Oost');
INSERT INTO buurt (code, naam) VALUES (7960503, 'Het Vinkel');
INSERT INTO buurt (code, naam) VALUES (7960504, 'Binckhorst');
INSERT INTO buurt (code, naam) VALUES (7960505, 'Sparrenburg');
INSERT INTO buurt (code, naam) VALUES (7960506, 'Molenhoek');
INSERT INTO buurt (code, naam) VALUES (7960507, 'A2 zone Rosmalen-Zuid');
INSERT INTO buurt (code, naam) VALUES (7960601, '''t Ven');
INSERT INTO buurt (code, naam) VALUES (7960602, 'Rosmalen-Centrum');
INSERT INTO buurt (code, naam) VALUES (7960603, 'Hondsberg');
INSERT INTO buurt (code, naam) VALUES (7960604, 'Kruisstraat');
INSERT INTO buurt (code, naam) VALUES (7960605, 'Bedrijventerrein Kruisstraat');
INSERT INTO buurt (code, naam) VALUES (7960606, 'De Overlaet-Oost');
INSERT INTO buurt (code, naam) VALUES (7960607, 'De Overlaet-West');
INSERT INTO buurt (code, naam) VALUES (7960608, 'A2 zone Rosmalen Noord');
INSERT INTO buurt (code, naam) VALUES (7960609, 'Rosmalense Polder');
INSERT INTO buurt (code, naam) VALUES (7960701, 'Brabantpoort');
INSERT INTO buurt (code, naam) VALUES (7960702, 'De Groote Vliet');
INSERT INTO buurt (code, naam) VALUES (7960703, 'Vlietdijk');
INSERT INTO buurt (code, naam) VALUES (7960704, 'Broekland');
INSERT INTO buurt (code, naam) VALUES (7960705, 'De Watertuinen');
INSERT INTO buurt (code, naam) VALUES (7960706, 'De Hoven');
INSERT INTO buurt (code, naam) VALUES (7960799, 'Landelijk gebied De Groote Wielen');
INSERT INTO buurt (code, naam) VALUES (7960801, 'Kom Empel');
INSERT INTO buurt (code, naam) VALUES (7960802, 'Maasakker');
INSERT INTO buurt (code, naam) VALUES (7960803, 'Empel-Oost');
INSERT INTO buurt (code, naam) VALUES (7960804, 'De Koornwaard');
INSERT INTO buurt (code, naam) VALUES (7960901, 'De Buitenpepers');
INSERT INTO buurt (code, naam) VALUES (7960902, 'De Herven');
INSERT INTO buurt (code, naam) VALUES (7960903, 'Bedrijventerrein De Herven');
INSERT INTO buurt (code, naam) VALUES (7960904, 'De Slagen');
INSERT INTO buurt (code, naam) VALUES (7960905, 'De Haren');
INSERT INTO buurt (code, naam) VALUES (7960906, 'De Reit');
INSERT INTO buurt (code, naam) VALUES (7960907, 'De Donk');
INSERT INTO buurt (code, naam) VALUES (7960908, 'De Rompert');
INSERT INTO buurt (code, naam) VALUES (7960909, 'De Hambaken');
INSERT INTO buurt (code, naam) VALUES (7960910, 'De Sprookjesbuurt');
INSERT INTO buurt (code, naam) VALUES (7960911, 'De Muziekinstrumentenbuurt');
INSERT INTO buurt (code, naam) VALUES (7960912, 'De Edelstenenbuurt');
INSERT INTO buurt (code, naam) VALUES (7960913, 'Orthen');
INSERT INTO buurt (code, naam) VALUES (7960914, 'Orthen-West');
INSERT INTO buurt (code, naam) VALUES (7960915, 'Bedrijventerrein-Noord');
INSERT INTO buurt (code, naam) VALUES (7961001, 'De Italiaanse buurt');
INSERT INTO buurt (code, naam) VALUES (7961002, 'Maasdal');
INSERT INTO buurt (code, naam) VALUES (7961003, 'Abdijenbuurt');
INSERT INTO buurt (code, naam) VALUES (7961004, 'Lokeren');
INSERT INTO buurt (code, naam) VALUES (7961005, 'Maasstroom');
INSERT INTO buurt (code, naam) VALUES (7961006, 'De Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (7961007, 'Het Zilverpark');
INSERT INTO buurt (code, naam) VALUES (7961008, 'Maasvallei');
INSERT INTO buurt (code, naam) VALUES (7961009, 'Maasoever');
INSERT INTO buurt (code, naam) VALUES (7961010, 'Bedrijventerrein Maaspoort');
INSERT INTO buurt (code, naam) VALUES (7961011, 'Oud Empel');
INSERT INTO buurt (code, naam) VALUES (7961101, 'Boschveld');
INSERT INTO buurt (code, naam) VALUES (7961102, 'Paleiskwartier');
INSERT INTO buurt (code, naam) VALUES (7961103, 'Willemspoort');
INSERT INTO buurt (code, naam) VALUES (7961104, 'Deuteren');
INSERT INTO buurt (code, naam) VALUES (7961105, 'De Moerputten');
INSERT INTO buurt (code, naam) VALUES (7961106, 'De Schutskamp');
INSERT INTO buurt (code, naam) VALUES (7961107, 'De Kruiskamp');
INSERT INTO buurt (code, naam) VALUES (7961108, 'De Rietvelden-Oost');
INSERT INTO buurt (code, naam) VALUES (7961109, 'De Rietvelden-West');
INSERT INTO buurt (code, naam) VALUES (7961110, 'Veemarktkwartier');
INSERT INTO buurt (code, naam) VALUES (7961111, 'Ertveld');
INSERT INTO buurt (code, naam) VALUES (7961201, 'Kom Engelen');
INSERT INTO buurt (code, naam) VALUES (7961202, 'De Vutter');
INSERT INTO buurt (code, naam) VALUES (7961203, 'Henriëttewaard');
INSERT INTO buurt (code, naam) VALUES (7961204, 'De Haverleij');
INSERT INTO buurt (code, naam) VALUES (7961205, 'Bokhoven');
INSERT INTO buurt (code, naam) VALUES (7961206, 'Engelermeer');
INSERT INTO buurt (code, naam) VALUES (7970101, 'Braken-West');
INSERT INTO buurt (code, naam) VALUES (7970102, 'Braken-Oost');
INSERT INTO buurt (code, naam) VALUES (7970103, 'Centrum Drunen');
INSERT INTO buurt (code, naam) VALUES (7970104, 'Venne-West');
INSERT INTO buurt (code, naam) VALUES (7970105, 'Venne-Oost');
INSERT INTO buurt (code, naam) VALUES (7970200, 'Elshout');
INSERT INTO buurt (code, naam) VALUES (7970300, 'Haarsteeg');
INSERT INTO buurt (code, naam) VALUES (7970400, 'Nieuwkuijk');
INSERT INTO buurt (code, naam) VALUES (7970501, 'Vijfhoeven');
INSERT INTO buurt (code, naam) VALUES (7970502, 'Vlijmen-Dorp');
INSERT INTO buurt (code, naam) VALUES (7970503, 'Vliedberg');
INSERT INTO buurt (code, naam) VALUES (7970600, 'Doeveren');
INSERT INTO buurt (code, naam) VALUES (7970700, 'Hedikhuizen');
INSERT INTO buurt (code, naam) VALUES (7970800, 'Heesbeen');
INSERT INTO buurt (code, naam) VALUES (7970900, 'Herpt');
INSERT INTO buurt (code, naam) VALUES (7971000, 'Heusden');
INSERT INTO buurt (code, naam) VALUES (7971100, 'Oudheusden');
INSERT INTO buurt (code, naam) VALUES (7980000, 'Hilvarenbeek');
INSERT INTO buurt (code, naam) VALUES (7980009, 'Verspreide huizen Hilvarenbeek');
INSERT INTO buurt (code, naam) VALUES (7980100, 'Esbeek');
INSERT INTO buurt (code, naam) VALUES (7980109, 'Verspreide huizen Esbeek');
INSERT INTO buurt (code, naam) VALUES (7980200, 'Biest-Houtakker');
INSERT INTO buurt (code, naam) VALUES (7980209, 'Verspreide huizen Biest-Houtakker');
INSERT INTO buurt (code, naam) VALUES (7980300, 'Diessen');
INSERT INTO buurt (code, naam) VALUES (7980301, 'Baarschot');
INSERT INTO buurt (code, naam) VALUES (7980309, 'Verspreide huizen Baarschot');
INSERT INTO buurt (code, naam) VALUES (7980400, 'Haghorst');
INSERT INTO buurt (code, naam) VALUES (7980409, 'Verspreide huizen Haghorst');
INSERT INTO buurt (code, naam) VALUES (8091001, 'Draaiboom');
INSERT INTO buurt (code, naam) VALUES (8091005, 'Hil (noord)');
INSERT INTO buurt (code, naam) VALUES (8091006, 'Hil (zuid)');
INSERT INTO buurt (code, naam) VALUES (8091010, 'Pannenhoef (west)');
INSERT INTO buurt (code, naam) VALUES (8091011, 'Pannenhoef (oost)');
INSERT INTO buurt (code, naam) VALUES (8091015, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (8091020, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (8091021, 'Schrijversbuurt');
INSERT INTO buurt (code, naam) VALUES (8091025, 'Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (8091030, 'Vossenberg (west)');
INSERT INTO buurt (code, naam) VALUES (8091031, 'Vossenberg (oost)');
INSERT INTO buurt (code, naam) VALUES (8091035, 'De Kets (industrieterrein)');
INSERT INTO buurt (code, naam) VALUES (8091040, 'De Zandschel');
INSERT INTO buurt (code, naam) VALUES (8091041, 'De Baan');
INSERT INTO buurt (code, naam) VALUES (8092045, 'Heikant');
INSERT INTO buurt (code, naam) VALUES (8092048, 'Els (west)');
INSERT INTO buurt (code, naam) VALUES (8092049, 'Els (oost)');
INSERT INTO buurt (code, naam) VALUES (8092052, 'Rooi Dorp');
INSERT INTO buurt (code, naam) VALUES (8092055, 'Loonse Vaart');
INSERT INTO buurt (code, naam) VALUES (8092058, 'De Oude Omdraaier');
INSERT INTO buurt (code, naam) VALUES (8092061, 'Prinsessenbuurt');
INSERT INTO buurt (code, naam) VALUES (8092063, 'Het Hoekske');
INSERT INTO buurt (code, naam) VALUES (8092066, 'De Klinkenpolder');
INSERT INTO buurt (code, naam) VALUES (8093070, 'Oud-Loon');
INSERT INTO buurt (code, naam) VALUES (8093071, 'Mussenhoek');
INSERT INTO buurt (code, naam) VALUES (8093080, 'Molenwijk (noord)');
INSERT INTO buurt (code, naam) VALUES (8093081, 'Molenwijk (zuid)');
INSERT INTO buurt (code, naam) VALUES (8093085, 'De Hoogt (Industrieterrein)');
INSERT INTO buurt (code, naam) VALUES (8093090, 'Bergeind');
INSERT INTO buurt (code, naam) VALUES (8093091, 'Oost-Loon');
INSERT INTO buurt (code, naam) VALUES (8093092, 'De Plakken');
INSERT INTO buurt (code, naam) VALUES (8094095, 'De Moer');
INSERT INTO buurt (code, naam) VALUES (8150000, 'Mill-Centrum');
INSERT INTO buurt (code, naam) VALUES (8150001, 'Mill-West');
INSERT INTO buurt (code, naam) VALUES (8150002, 'Brugse Berg');
INSERT INTO buurt (code, naam) VALUES (8150003, 'Mill-Zuid');
INSERT INTO buurt (code, naam) VALUES (8150004, 'Bedrijventerrein Het Spoor');
INSERT INTO buurt (code, naam) VALUES (8150005, 'Bedrijventerrein De Meeren');
INSERT INTO buurt (code, naam) VALUES (8150007, 'Verspreide huizen Groespeel');
INSERT INTO buurt (code, naam) VALUES (8150008, 'Verspreide huizen Achterdijk-Roijendijk');
INSERT INTO buurt (code, naam) VALUES (8150009, 'Verspreide huizen Meren-De Gagel');
INSERT INTO buurt (code, naam) VALUES (8150100, 'Langenboom');
INSERT INTO buurt (code, naam) VALUES (8150109, 'Verspreide huizen Langenboom');
INSERT INTO buurt (code, naam) VALUES (8150200, 'Sint Hubert');
INSERT INTO buurt (code, naam) VALUES (8150209, 'Verspreide huizen Sint Hubert');
INSERT INTO buurt (code, naam) VALUES (8150300, 'Wilbertoord');
INSERT INTO buurt (code, naam) VALUES (8150309, 'Verspreide huizen Wilbertoord');
INSERT INTO buurt (code, naam) VALUES (8200000, 'Nuenen-Noord');
INSERT INTO buurt (code, naam) VALUES (8200001, 'Nuenen-Zuid');
INSERT INTO buurt (code, naam) VALUES (8200002, 'Nuenen-Oost');
INSERT INTO buurt (code, naam) VALUES (8200003, 'Eeneind');
INSERT INTO buurt (code, naam) VALUES (8200008, 'Verspreide huizen Boord, Opwetten');
INSERT INTO buurt (code, naam) VALUES (8200009, 'Verspreide huizen ten zuidoosten van Nuenen');
INSERT INTO buurt (code, naam) VALUES (8200100, 'Gerwen');
INSERT INTO buurt (code, naam) VALUES (8200109, 'Verspreide huizen Gerwen');
INSERT INTO buurt (code, naam) VALUES (8200200, 'Nederwetten');
INSERT INTO buurt (code, naam) VALUES (8200209, 'Verspreide huizen Nederwetten');
INSERT INTO buurt (code, naam) VALUES (8230000, 'Oirschot-Centrum');
INSERT INTO buurt (code, naam) VALUES (8230001, 'Oirschot Noordoost');
INSERT INTO buurt (code, naam) VALUES (8230002, 'De Notel');
INSERT INTO buurt (code, naam) VALUES (8230003, 'Industrieterrein De Stad');
INSERT INTO buurt (code, naam) VALUES (8230004, 'Snepseind en Bijsterveld');
INSERT INTO buurt (code, naam) VALUES (8230005, 'Straten met Moleneind');
INSERT INTO buurt (code, naam) VALUES (8230008, 'Verspreide huizen Zuid-Oirschotse Heide');
INSERT INTO buurt (code, naam) VALUES (8230009, 'Verspreide huizen Noord en De Mortelen');
INSERT INTO buurt (code, naam) VALUES (8230100, 'Spoordonk');
INSERT INTO buurt (code, naam) VALUES (8230109, 'Verspreide huizen Spoordonk');
INSERT INTO buurt (code, naam) VALUES (8230200, 'Middelbeers');
INSERT INTO buurt (code, naam) VALUES (8230208, 'Verspreide huizen Westelbeers');
INSERT INTO buurt (code, naam) VALUES (8230209, 'Verspreide huizen Middelbeers');
INSERT INTO buurt (code, naam) VALUES (8230300, 'Oostelbeers');
INSERT INTO buurt (code, naam) VALUES (8230309, 'Verspreide huizen Oostelbeers');
INSERT INTO buurt (code, naam) VALUES (8240000, 'Oisterwijk-Centrum');
INSERT INTO buurt (code, naam) VALUES (8240001, 'Omgeving Waterhoef en Klompven');
INSERT INTO buurt (code, naam) VALUES (8240002, 'Omgeving Bunders en Levenskerk');
INSERT INTO buurt (code, naam) VALUES (8240003, 'Omgeving ''t Westend en ''t Seuverick');
INSERT INTO buurt (code, naam) VALUES (8240004, 'Pannenschuur');
INSERT INTO buurt (code, naam) VALUES (8240005, 'Industrieterrein Kerckhoven Laarakkers');
INSERT INTO buurt (code, naam) VALUES (8240006, 'Omgeving George Perklaan');
INSERT INTO buurt (code, naam) VALUES (8240007, 'Verspreide huizen Heukelom');
INSERT INTO buurt (code, naam) VALUES (8240008, 'Verspreide huizen Kerkhoven');
INSERT INTO buurt (code, naam) VALUES (8240009, 'Verspreide huizen bosgebied');
INSERT INTO buurt (code, naam) VALUES (8240100, 'Moergestel');
INSERT INTO buurt (code, naam) VALUES (8240101, 'Omgeving Vinkenberg en Heuvelstraat');
INSERT INTO buurt (code, naam) VALUES (8240102, 'Omgeving Broekzijde');
INSERT INTO buurt (code, naam) VALUES (8240108, 'Verspreide huizen in het Westen en Noorden');
INSERT INTO buurt (code, naam) VALUES (8240109, 'Verspreide huizen in het Oosten en Zuiden');
INSERT INTO buurt (code, naam) VALUES (8260000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (8260100, 'Slotjes-Oost');
INSERT INTO buurt (code, naam) VALUES (8260101, 'Slotjes-Midden');
INSERT INTO buurt (code, naam) VALUES (8260102, 'Slotjes-West');
INSERT INTO buurt (code, naam) VALUES (8260200, 'Oud-West');
INSERT INTO buurt (code, naam) VALUES (8260201, 'Kanaleneiland');
INSERT INTO buurt (code, naam) VALUES (8260300, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (8260301, 'Kastelenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260400, 'Leijsenakkers');
INSERT INTO buurt (code, naam) VALUES (8260401, 'Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260500, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260501, 'Schrijversbuurt');
INSERT INTO buurt (code, naam) VALUES (8260502, 'Natuurkundigenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260503, 'Componistenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260504, 'De Warande');
INSERT INTO buurt (code, naam) VALUES (8260505, 'Paterserf');
INSERT INTO buurt (code, naam) VALUES (8260600, 'Kruidenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260601, 'Sterrenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260602, 'Donkenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260603, 'Larenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260604, 'Beemdenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260605, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (8260606, 'Dammenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260607, 'Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (8260700, 'Vrachelen-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (8260701, 'Vrachelen-Noord');
INSERT INTO buurt (code, naam) VALUES (8260702, 'Vrachelen-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (8260703, 'Vrachelen-Noordwest');
INSERT INTO buurt (code, naam) VALUES (8260800, 'Industrieterrein Vijf Eiken');
INSERT INTO buurt (code, naam) VALUES (8260801, 'Industrieterrein Heikant');
INSERT INTO buurt (code, naam) VALUES (8260900, 'Industrieterrein Statendam');
INSERT INTO buurt (code, naam) VALUES (8260901, 'Industrieterrein Weststad-Zuid');
INSERT INTO buurt (code, naam) VALUES (8260902, 'Industrieterrein Weststad-Noord');
INSERT INTO buurt (code, naam) VALUES (8261000, 'Oranjepolder');
INSERT INTO buurt (code, naam) VALUES (8261001, 'Bosgebied-Oosterhout');
INSERT INTO buurt (code, naam) VALUES (8261100, 'Den Hout');
INSERT INTO buurt (code, naam) VALUES (8261109, 'Buitengebied Den Hout');
INSERT INTO buurt (code, naam) VALUES (8261200, 'Oosteind');
INSERT INTO buurt (code, naam) VALUES (8261208, 'Buitengebied-Oosteind-Zuid');
INSERT INTO buurt (code, naam) VALUES (8261209, 'Willemspolder');
INSERT INTO buurt (code, naam) VALUES (8261300, 'Dorst');
INSERT INTO buurt (code, naam) VALUES (8261307, 'Buitengebied Dorst-Zuid');
INSERT INTO buurt (code, naam) VALUES (8261308, 'Bosgebied Dorst');
INSERT INTO buurt (code, naam) VALUES (8261309, 'Steenoven');
INSERT INTO buurt (code, naam) VALUES (8280000, 'Centrum West');
INSERT INTO buurt (code, naam) VALUES (8280001, 'Centrum Noord');
INSERT INTO buurt (code, naam) VALUES (8280002, 'Centrum Zuid');
INSERT INTO buurt (code, naam) VALUES (8280100, 'Verzetsheldenbuurt I');
INSERT INTO buurt (code, naam) VALUES (8280101, 'Berghemseweg Zuid');
INSERT INTO buurt (code, naam) VALUES (8280102, 'Verzetsheldenbuurt II');
INSERT INTO buurt (code, naam) VALUES (8280103, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (8280104, 'Roofvogelbuurt');
INSERT INTO buurt (code, naam) VALUES (8280105, 'Schadewijk Noord-Oost');
INSERT INTO buurt (code, naam) VALUES (8280106, 'De Horzak');
INSERT INTO buurt (code, naam) VALUES (8280200, 'Moleneind');
INSERT INTO buurt (code, naam) VALUES (8280201, 'Landweer');
INSERT INTO buurt (code, naam) VALUES (8280202, 'Danenhoef');
INSERT INTO buurt (code, naam) VALUES (8280300, 'Kortfoort');
INSERT INTO buurt (code, naam) VALUES (8280301, 'Oranjebuurt I en Ruivert');
INSERT INTO buurt (code, naam) VALUES (8280302, 'Zeeheldenbuurt I');
INSERT INTO buurt (code, naam) VALUES (8280303, 'Zeeheldenbuurt II');
INSERT INTO buurt (code, naam) VALUES (8280304, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (8280305, 'Oranjebuurt II');
INSERT INTO buurt (code, naam) VALUES (8280306, 'Willibrordusweg-Oost');
INSERT INTO buurt (code, naam) VALUES (8280307, 'Willibrordusweg-West');
INSERT INTO buurt (code, naam) VALUES (8280400, 'Oorlogsheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (8280401, 'Hertogenbuurt');
INSERT INTO buurt (code, naam) VALUES (8280402, 'Mettegeupel');
INSERT INTO buurt (code, naam) VALUES (8280403, 'De Noord');
INSERT INTO buurt (code, naam) VALUES (8280404, 'Rusheuvel');
INSERT INTO buurt (code, naam) VALUES (8280500, 'Elzenburg');
INSERT INTO buurt (code, naam) VALUES (8280501, 'De Winkel');
INSERT INTO buurt (code, naam) VALUES (8280502, 'Hooimeer');
INSERT INTO buurt (code, naam) VALUES (8280503, 'De Geer');
INSERT INTO buurt (code, naam) VALUES (8280600, 'Staatsliedenbuurt');
INSERT INTO buurt (code, naam) VALUES (8280601, 'Van Hogendorplaan-West');
INSERT INTO buurt (code, naam) VALUES (8280602, 'Dichtersbuurt');
INSERT INTO buurt (code, naam) VALUES (8280603, 'Wagenaarstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (8280604, 'Vondellaan-Zuid');
INSERT INTO buurt (code, naam) VALUES (8280605, 'Euterpelaan-Noord');
INSERT INTO buurt (code, naam) VALUES (8280606, 'Beethovengaarde en Lisztgaarde');
INSERT INTO buurt (code, naam) VALUES (8280607, 'Witte Hoef');
INSERT INTO buurt (code, naam) VALUES (8280608, 'Het Woud');
INSERT INTO buurt (code, naam) VALUES (8280609, 'De Elzen');
INSERT INTO buurt (code, naam) VALUES (8280700, 'Vlashoek');
INSERT INTO buurt (code, naam) VALUES (8280701, 'Heihoek');
INSERT INTO buurt (code, naam) VALUES (8280702, 'Hoefeind');
INSERT INTO buurt (code, naam) VALUES (8280703, 'Amsteleind');
INSERT INTO buurt (code, naam) VALUES (8280704, 'Hazenkamp');
INSERT INTO buurt (code, naam) VALUES (8280705, 'Loovelt');
INSERT INTO buurt (code, naam) VALUES (8280706, 'Lockaert');
INSERT INTO buurt (code, naam) VALUES (8280707, 'Westerveld');
INSERT INTO buurt (code, naam) VALUES (8280708, 'Klein Mikkeldonk');
INSERT INTO buurt (code, naam) VALUES (8280709, 'Schalkskamp');
INSERT INTO buurt (code, naam) VALUES (8280806, 'Meerdijk');
INSERT INTO buurt (code, naam) VALUES (8280807, 'Frankenbeemd');
INSERT INTO buurt (code, naam) VALUES (8280808, 'Langendonk');
INSERT INTO buurt (code, naam) VALUES (8280809, 'Buitengebied-West');
INSERT INTO buurt (code, naam) VALUES (8280905, 'Geffense Bosjes');
INSERT INTO buurt (code, naam) VALUES (8280906, 'De Tillaard');
INSERT INTO buurt (code, naam) VALUES (8280907, 'De Haag');
INSERT INTO buurt (code, naam) VALUES (8280908, 'Vierwinden');
INSERT INTO buurt (code, naam) VALUES (8280909, 'Vorstengraf');
INSERT INTO buurt (code, naam) VALUES (8281000, 'Berghem-Noord');
INSERT INTO buurt (code, naam) VALUES (8281001, 'Berghem-Zuid');
INSERT INTO buurt (code, naam) VALUES (8281007, 'Verspreide huizen Duurendseind');
INSERT INTO buurt (code, naam) VALUES (8281008, 'Verspreide huizen Voorste en Achterste Heide');
INSERT INTO buurt (code, naam) VALUES (8281009, 'Verspreide huizen Gement');
INSERT INTO buurt (code, naam) VALUES (8281100, 'Haren');
INSERT INTO buurt (code, naam) VALUES (8281108, 'Verspreide huizen Stijbeemden');
INSERT INTO buurt (code, naam) VALUES (8281109, 'Verspreide huizen Ossekampen');
INSERT INTO buurt (code, naam) VALUES (8281200, 'Macharen');
INSERT INTO buurt (code, naam) VALUES (8281208, 'Verspreide huizen Harense Broek');
INSERT INTO buurt (code, naam) VALUES (8281209, 'Verspreide huizen De Tuinlangel');
INSERT INTO buurt (code, naam) VALUES (8281300, 'Megen');
INSERT INTO buurt (code, naam) VALUES (8281308, 'Verspreide huizen Maasakker');
INSERT INTO buurt (code, naam) VALUES (8281309, 'Verspreide huizen De Waarden');
INSERT INTO buurt (code, naam) VALUES (8281400, 'Ravenstein');
INSERT INTO buurt (code, naam) VALUES (8281401, 'Ravenstein De Kolk en Schonenberg');
INSERT INTO buurt (code, naam) VALUES (8281402, 'De Weem');
INSERT INTO buurt (code, naam) VALUES (8281403, 'Huisseling');
INSERT INTO buurt (code, naam) VALUES (8281409, 'Verspreide huizen Ravenstein en Huisseling');
INSERT INTO buurt (code, naam) VALUES (8281500, 'Herpen');
INSERT INTO buurt (code, naam) VALUES (8281508, 'Koolwijk en Bossen');
INSERT INTO buurt (code, naam) VALUES (8281509, 'Verspreide huizen Herpen');
INSERT INTO buurt (code, naam) VALUES (8281600, 'Overlangel');
INSERT INTO buurt (code, naam) VALUES (8281601, 'Neerloon');
INSERT INTO buurt (code, naam) VALUES (8281609, 'Verspreide huizen Keent');
INSERT INTO buurt (code, naam) VALUES (8281700, 'Deursen en Dennenburg');
INSERT INTO buurt (code, naam) VALUES (8281701, 'Dieden');
INSERT INTO buurt (code, naam) VALUES (8281702, 'Demen');
INSERT INTO buurt (code, naam) VALUES (8281703, 'Neerlangel');
INSERT INTO buurt (code, naam) VALUES (8281709, 'Verspreide huizen Deursen en Dennenburg');
INSERT INTO buurt (code, naam) VALUES (8281800, 'Lith');
INSERT INTO buurt (code, naam) VALUES (8281809, 'Verspreide huizen Polder van Lith');
INSERT INTO buurt (code, naam) VALUES (8281900, 'Lithoijen');
INSERT INTO buurt (code, naam) VALUES (8281901, 'Teeffelen');
INSERT INTO buurt (code, naam) VALUES (8281908, 'Verspreide huizen Polder van Teeffelen');
INSERT INTO buurt (code, naam) VALUES (8281909, 'Verspreide huizen Polder van Lithoijen');
INSERT INTO buurt (code, naam) VALUES (8282000, 'Oijen');
INSERT INTO buurt (code, naam) VALUES (8282009, 'Verspreide huizen Polder Oijen');
INSERT INTO buurt (code, naam) VALUES (8282100, 'Maren-Kessel');
INSERT INTO buurt (code, naam) VALUES (8282101, 'Maren');
INSERT INTO buurt (code, naam) VALUES (8282102, 'Kessel');
INSERT INTO buurt (code, naam) VALUES (8282103, '''t Wild');
INSERT INTO buurt (code, naam) VALUES (8282109, 'Verspreide huizen Polder van het Laag Heemaal');
INSERT INTO buurt (code, naam) VALUES (8400000, 'Rucphen');
INSERT INTO buurt (code, naam) VALUES (8400009, 'Verspreide huizen Rucphen');
INSERT INTO buurt (code, naam) VALUES (8400100, 'Sint Willebrord');
INSERT INTO buurt (code, naam) VALUES (8400109, 'Verspreide huizen Sint Willebrord');
INSERT INTO buurt (code, naam) VALUES (8400200, 'Sprundel');
INSERT INTO buurt (code, naam) VALUES (8400201, 'Bedrijventerrein De Nijverhei');
INSERT INTO buurt (code, naam) VALUES (8400209, 'Verspreide huizen Sprundel');
INSERT INTO buurt (code, naam) VALUES (8400300, 'Schijf');
INSERT INTO buurt (code, naam) VALUES (8400309, 'Verspreide huizen Schijf');
INSERT INTO buurt (code, naam) VALUES (8400400, 'Zegge');
INSERT INTO buurt (code, naam) VALUES (8400409, 'Verspreide huizen Zegge');
INSERT INTO buurt (code, naam) VALUES (8440000, 'Boschweg Noordoost');
INSERT INTO buurt (code, naam) VALUES (8440010, 'Boschweg Zuidwest');
INSERT INTO buurt (code, naam) VALUES (8440020, 'Grevekeur');
INSERT INTO buurt (code, naam) VALUES (8440030, 'Molendijk');
INSERT INTO buurt (code, naam) VALUES (8440091, 'Buitengebied Noordwest 1');
INSERT INTO buurt (code, naam) VALUES (8440092, 'Buitengebied Noordwest 2');
INSERT INTO buurt (code, naam) VALUES (8440093, 'Buitengebied Zuidwest');
INSERT INTO buurt (code, naam) VALUES (8440101, 'Centrum 1');
INSERT INTO buurt (code, naam) VALUES (8440102, 'Centrum 2');
INSERT INTO buurt (code, naam) VALUES (8440103, 'Centrum 3');
INSERT INTO buurt (code, naam) VALUES (8440104, 'Centrum 4');
INSERT INTO buurt (code, naam) VALUES (8440111, 'De Borne 1');
INSERT INTO buurt (code, naam) VALUES (8440112, 'De Borne 2');
INSERT INTO buurt (code, naam) VALUES (8440113, 'De Borne 3');
INSERT INTO buurt (code, naam) VALUES (8440120, 'Hopstraat');
INSERT INTO buurt (code, naam) VALUES (8440191, 'Buitengebeid Zuid 1');
INSERT INTO buurt (code, naam) VALUES (8440192, 'Buitengebied Zuid 2');
INSERT INTO buurt (code, naam) VALUES (8440201, 'De Beemd 1');
INSERT INTO buurt (code, naam) VALUES (8440202, 'De Beemd 2');
INSERT INTO buurt (code, naam) VALUES (8440203, 'De Beemd 3');
INSERT INTO buurt (code, naam) VALUES (8440210, 'Hoevenbraak');
INSERT INTO buurt (code, naam) VALUES (8440221, 'Plein 1');
INSERT INTO buurt (code, naam) VALUES (8440222, 'Plein 2');
INSERT INTO buurt (code, naam) VALUES (8440223, 'Plein 3');
INSERT INTO buurt (code, naam) VALUES (8440230, 'Hulzebraak');
INSERT INTO buurt (code, naam) VALUES (8440240, 'Rooiseheide');
INSERT INTO buurt (code, naam) VALUES (8440251, 'Duin 1');
INSERT INTO buurt (code, naam) VALUES (8440252, 'Duin 2');
INSERT INTO buurt (code, naam) VALUES (8440253, 'Duin Noord');
INSERT INTO buurt (code, naam) VALUES (8440291, 'Buitengebied Noordoost');
INSERT INTO buurt (code, naam) VALUES (8440292, 'Buitengebied Zuidoost');
INSERT INTO buurt (code, naam) VALUES (8440300, 'Wijbosch');
INSERT INTO buurt (code, naam) VALUES (8450000, 'Sint-Michielsgestel');
INSERT INTO buurt (code, naam) VALUES (8450001, 'Theereheide');
INSERT INTO buurt (code, naam) VALUES (8450002, 'Venkant, Beekkant en Beekvliet');
INSERT INTO buurt (code, naam) VALUES (8450003, 'Halder');
INSERT INTO buurt (code, naam) VALUES (8450007, 'Verspreide huizen Theereheide en Zegenwerp');
INSERT INTO buurt (code, naam) VALUES (8450008, 'Verspreide huizen Genenberg');
INSERT INTO buurt (code, naam) VALUES (8450009, 'Verspreide huizen Sint-Michielsgestelse polders');
INSERT INTO buurt (code, naam) VALUES (8450100, 'Gemonde');
INSERT INTO buurt (code, naam) VALUES (8450108, 'Verspreide huizen ten oosten van Gemonde');
INSERT INTO buurt (code, naam) VALUES (8450109, 'Verspreide huizen ten westen van Gemonde');
INSERT INTO buurt (code, naam) VALUES (8450200, 'Den Dungen');
INSERT INTO buurt (code, naam) VALUES (8450201, 'Maaskantje');
INSERT INTO buurt (code, naam) VALUES (8450207, 'Verspreide huizen Spurk en ''t Woud');
INSERT INTO buurt (code, naam) VALUES (8450208, 'Verspreide huizen Poeldonk');
INSERT INTO buurt (code, naam) VALUES (8450209, 'Verspreide huizen Maaskantje');
INSERT INTO buurt (code, naam) VALUES (8450300, 'Berlicum');
INSERT INTO buurt (code, naam) VALUES (8450301, 'Westakkers');
INSERT INTO buurt (code, naam) VALUES (8450302, 'Westerbroek en Beekveld');
INSERT INTO buurt (code, naam) VALUES (8450308, 'Verspreide huizen Beekveld-Hersend');
INSERT INTO buurt (code, naam) VALUES (8450309, 'Verspreide huizen ten noorden van Berlicum');
INSERT INTO buurt (code, naam) VALUES (8450400, 'Middelrode');
INSERT INTO buurt (code, naam) VALUES (8450408, 'Verspreide huizen Middelrode');
INSERT INTO buurt (code, naam) VALUES (8450409, 'Verspreide huizen Heikantse Hoeve');
INSERT INTO buurt (code, naam) VALUES (8460000, 'Sint-Oedenrode Centrum');
INSERT INTO buurt (code, naam) VALUES (8460001, 'Eerschot');
INSERT INTO buurt (code, naam) VALUES (8460002, 'Kienehoef en Armenhoef');
INSERT INTO buurt (code, naam) VALUES (8460003, 'Cathalijne-Kinderbos');
INSERT INTO buurt (code, naam) VALUES (8460004, 'Vogelenzang');
INSERT INTO buurt (code, naam) VALUES (8460005, 'Everse en Koevering');
INSERT INTO buurt (code, naam) VALUES (8460006, 'Sloef');
INSERT INTO buurt (code, naam) VALUES (8460007, 'Verspreide huizen Rijsingen en Heide');
INSERT INTO buurt (code, naam) VALUES (8460008, 'Verspreide huizen Veerse Heide en Heikant');
INSERT INTO buurt (code, naam) VALUES (8460009, 'Verspreide huizen Jekschot');
INSERT INTO buurt (code, naam) VALUES (8460100, 'Nijnsel');
INSERT INTO buurt (code, naam) VALUES (8460107, 'Verspreide huizen Hoogstraat, Laar en Zandhoef');
INSERT INTO buurt (code, naam) VALUES (8460108, 'Verspreide huizen Vressel en Zwijnsbergen');
INSERT INTO buurt (code, naam) VALUES (8460109, 'Verspreide huizen Vresselse Heide');
INSERT INTO buurt (code, naam) VALUES (8460200, 'Boskant');
INSERT INTO buurt (code, naam) VALUES (8460209, 'Verspreide huizen Boskant');
INSERT INTO buurt (code, naam) VALUES (8460300, 'Olland');
INSERT INTO buurt (code, naam) VALUES (8460309, 'Verspreide huizen Olland');
INSERT INTO buurt (code, naam) VALUES (8470000, 'Someren');
INSERT INTO buurt (code, naam) VALUES (8470008, 'Verspreide huizen Hoeven');
INSERT INTO buurt (code, naam) VALUES (8470009, 'Verspreide huizen Slieven');
INSERT INTO buurt (code, naam) VALUES (8470100, 'Lierop');
INSERT INTO buurt (code, naam) VALUES (8470108, 'Verspreide huizen Meerven');
INSERT INTO buurt (code, naam) VALUES (8470109, 'Verspreide huizen Hersel');
INSERT INTO buurt (code, naam) VALUES (8470200, 'Someren-Eind');
INSERT INTO buurt (code, naam) VALUES (8470208, 'Verspreide huizen Sluis 12/13');
INSERT INTO buurt (code, naam) VALUES (8470209, 'Verspreide huizen Diepenhoek');
INSERT INTO buurt (code, naam) VALUES (8470300, 'Somerense Heide');
INSERT INTO buurt (code, naam) VALUES (8470309, 'Verspreide huizen Somerense Heide');
INSERT INTO buurt (code, naam) VALUES (8470909, 'Verspreide huizen Lungendonk');
INSERT INTO buurt (code, naam) VALUES (8480000, 'Son');
INSERT INTO buurt (code, naam) VALUES (8480001, 'De Gentiaan');
INSERT INTO buurt (code, naam) VALUES (8480002, 'Industrieterrein Ekkersrijt');
INSERT INTO buurt (code, naam) VALUES (8480003, '''t Zand');
INSERT INTO buurt (code, naam) VALUES (8480009, 'Verspreide huizen Son');
INSERT INTO buurt (code, naam) VALUES (8480100, 'Breugel');
INSERT INTO buurt (code, naam) VALUES (8480101, '''t Eigen en Hoogstraat');
INSERT INTO buurt (code, naam) VALUES (8480109, 'Verspreide huizen Breugel');
INSERT INTO buurt (code, naam) VALUES (8510000, 'Steenbergen-Centrum');
INSERT INTO buurt (code, naam) VALUES (8510001, 'Welberg');
INSERT INTO buurt (code, naam) VALUES (8510002, 'Steenbergen-Zuid');
INSERT INTO buurt (code, naam) VALUES (8510003, 'Steenbergen-Noord');
INSERT INTO buurt (code, naam) VALUES (8510004, 'Industrieterrein Reinierpolder');
INSERT INTO buurt (code, naam) VALUES (8510007, 'Graaf Hendrik- en Triangelpolder');
INSERT INTO buurt (code, naam) VALUES (8510008, 'Westelijke polders');
INSERT INTO buurt (code, naam) VALUES (8510009, 'Het Oudland');
INSERT INTO buurt (code, naam) VALUES (8510100, 'Kruisland');
INSERT INTO buurt (code, naam) VALUES (8510109, 'Kruislandse polders');
INSERT INTO buurt (code, naam) VALUES (8510200, 'De Heen');
INSERT INTO buurt (code, naam) VALUES (8510209, 'Heense polders');
INSERT INTO buurt (code, naam) VALUES (8510300, 'Dinteloord');
INSERT INTO buurt (code, naam) VALUES (8510301, 'Boompjesdijk');
INSERT INTO buurt (code, naam) VALUES (8510308, 'Verspreide huizen in het Oosten');
INSERT INTO buurt (code, naam) VALUES (8510309, 'Verspreide huizen in het Westen');
INSERT INTO buurt (code, naam) VALUES (8510400, 'Nieuw-Vossemeer');
INSERT INTO buurt (code, naam) VALUES (8510409, 'Verspreide huizen waaronder Pelsendijk en Rolaf');
INSERT INTO buurt (code, naam) VALUES (8519997, '');
INSERT INTO buurt (code, naam) VALUES (8520000, 'Monnickendam');
INSERT INTO buurt (code, naam) VALUES (8520001, 'Oranjewijk');
INSERT INTO buurt (code, naam) VALUES (8520002, 'Markgouw');
INSERT INTO buurt (code, naam) VALUES (8520003, 'Ringshemmen');
INSERT INTO buurt (code, naam) VALUES (8520004, 'Ooster Ee');
INSERT INTO buurt (code, naam) VALUES (8520005, '''t Spil');
INSERT INTO buurt (code, naam) VALUES (8520006, 'Binnengouw');
INSERT INTO buurt (code, naam) VALUES (8520007, 'Buitengouw');
INSERT INTO buurt (code, naam) VALUES (8520009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (8520010, 'De Purmer (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (8520100, 'Katwoude');
INSERT INTO buurt (code, naam) VALUES (8520200, 'Havenbuurt en Kerkbuurt');
INSERT INTO buurt (code, naam) VALUES (8520201, 'Verspreide huizen Op de Werven ten zuiden van kanaal');
INSERT INTO buurt (code, naam) VALUES (8520300, 'Broek in Waterland');
INSERT INTO buurt (code, naam) VALUES (8520301, 'Zuiderwoude');
INSERT INTO buurt (code, naam) VALUES (8520302, 'Uitdam');
INSERT INTO buurt (code, naam) VALUES (8520400, 'Ilpendam');
INSERT INTO buurt (code, naam) VALUES (8520401, 'De Purmer (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (8520500, 'Watergang');
INSERT INTO buurt (code, naam) VALUES (8529997, '');
INSERT INTO buurt (code, naam) VALUES (8550000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (8550100, 'Tivoli');
INSERT INTO buurt (code, naam) VALUES (8550101, 'Armhoef');
INSERT INTO buurt (code, naam) VALUES (8550102, 'Jeruzalem');
INSERT INTO buurt (code, naam) VALUES (8550103, 'Hoevenseweg');
INSERT INTO buurt (code, naam) VALUES (8550104, 'Broekhoven');
INSERT INTO buurt (code, naam) VALUES (8550105, 'Oude Dijk');
INSERT INTO buurt (code, naam) VALUES (8550106, 'Trouwlaan');
INSERT INTO buurt (code, naam) VALUES (8550107, 'Korvel');
INSERT INTO buurt (code, naam) VALUES (8550108, 'Rooi Harten');
INSERT INTO buurt (code, naam) VALUES (8550109, 'Hagelkruis');
INSERT INTO buurt (code, naam) VALUES (8550200, 'Besterd');
INSERT INTO buurt (code, naam) VALUES (8550201, 'Gasthuisstraat');
INSERT INTO buurt (code, naam) VALUES (8550202, 'De Hasselt');
INSERT INTO buurt (code, naam) VALUES (8550203, 'Het Goirke');
INSERT INTO buurt (code, naam) VALUES (8550204, 'Groeseind');
INSERT INTO buurt (code, naam) VALUES (8550205, 'Hoefstraat');
INSERT INTO buurt (code, naam) VALUES (8550206, 'Koestraat');
INSERT INTO buurt (code, naam) VALUES (8550207, 'Loven');
INSERT INTO buurt (code, naam) VALUES (8550208, 'Industriestrook GoirkeKanaaldijk');
INSERT INTO buurt (code, naam) VALUES (8550209, 'Industriestrook LovenseKanaaldijk');
INSERT INTO buurt (code, naam) VALUES (8550300, 'Zorgvlied');
INSERT INTO buurt (code, naam) VALUES (8550301, 'De Reit');
INSERT INTO buurt (code, naam) VALUES (8550302, 'TweeSteden Ziekenhuis - De Rooi Pannen');
INSERT INTO buurt (code, naam) VALUES (8550303, 'Het Zand');
INSERT INTO buurt (code, naam) VALUES (8550304, 'Wandelbos-Noord');
INSERT INTO buurt (code, naam) VALUES (8550305, 'De Oude Warande');
INSERT INTO buurt (code, naam) VALUES (8550306, 'Wandelbos-Zuid');
INSERT INTO buurt (code, naam) VALUES (8550400, 'Industrieterrein Vossenberg');
INSERT INTO buurt (code, naam) VALUES (8550401, 'Industrieterrein Kraaiven');
INSERT INTO buurt (code, naam) VALUES (8550402, 'Stokhasselt-Noord');
INSERT INTO buurt (code, naam) VALUES (8550403, 'Vlashof');
INSERT INTO buurt (code, naam) VALUES (8550404, 'De Schans');
INSERT INTO buurt (code, naam) VALUES (8550405, 'De Lijnse Hoek');
INSERT INTO buurt (code, naam) VALUES (8550406, 'Quirijnstok');
INSERT INTO buurt (code, naam) VALUES (8550407, 'Stokhasselt-Zuid');
INSERT INTO buurt (code, naam) VALUES (8550408, 'Buitengebied Noordoost');
INSERT INTO buurt (code, naam) VALUES (8550409, 'Buitengebied Noordwest');
INSERT INTO buurt (code, naam) VALUES (8550500, 'Industrieterrein-Oost');
INSERT INTO buurt (code, naam) VALUES (8550501, 'Industrieterrein Loven');
INSERT INTO buurt (code, naam) VALUES (8550502, 'Bosscheweg');
INSERT INTO buurt (code, naam) VALUES (8550503, 'Moerenburg');
INSERT INTO buurt (code, naam) VALUES (8550600, 'Koningshoeven');
INSERT INTO buurt (code, naam) VALUES (8550601, 'Groenewoud');
INSERT INTO buurt (code, naam) VALUES (8550602, 'Het Laar');
INSERT INTO buurt (code, naam) VALUES (8550603, 'De Blaak');
INSERT INTO buurt (code, naam) VALUES (8550604, 'Katsbogten - Bakerland');
INSERT INTO buurt (code, naam) VALUES (8550609, 'Buitengebied Zuidwest');
INSERT INTO buurt (code, naam) VALUES (8550700, 'Berkel');
INSERT INTO buurt (code, naam) VALUES (8550701, 'Enschot');
INSERT INTO buurt (code, naam) VALUES (8550702, 'Eikenbosch');
INSERT INTO buurt (code, naam) VALUES (8550703, 'Ruiven');
INSERT INTO buurt (code, naam) VALUES (8550704, 'Berkelse Akkers');
INSERT INTO buurt (code, naam) VALUES (8550708, 'Verspreide huizen ten noorden van Berkel-Enschot');
INSERT INTO buurt (code, naam) VALUES (8550709, 'Verspreide huizen ten zuiden van Berkel-Enschot');
INSERT INTO buurt (code, naam) VALUES (8550800, 'Heyhoef');
INSERT INTO buurt (code, naam) VALUES (8550801, 'Gesworen Hoek');
INSERT INTO buurt (code, naam) VALUES (8550802, 'Huibeven');
INSERT INTO buurt (code, naam) VALUES (8550803, 'Heerevelden');
INSERT INTO buurt (code, naam) VALUES (8550804, 'Campenhoef');
INSERT INTO buurt (code, naam) VALUES (8550805, 'Tuindorp de Kievit');
INSERT INTO buurt (code, naam) VALUES (8550806, 'Dongewijk');
INSERT INTO buurt (code, naam) VALUES (8550807, 'Dalem');
INSERT INTO buurt (code, naam) VALUES (8550808, 'Koolhoven');
INSERT INTO buurt (code, naam) VALUES (8550809, 'Witbrant');
INSERT INTO buurt (code, naam) VALUES (8550900, 'Udenhout');
INSERT INTO buurt (code, naam) VALUES (8550909, 'Verspreide huizen Udenhout');
INSERT INTO buurt (code, naam) VALUES (8560101, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (8560102, 'Bogerd-Vijfhuis');
INSERT INTO buurt (code, naam) VALUES (8560103, 'Moleneind-Groenewoud');
INSERT INTO buurt (code, naam) VALUES (8560104, 'Flatwijk');
INSERT INTO buurt (code, naam) VALUES (8560105, 'Bitswijk');
INSERT INTO buurt (code, naam) VALUES (8560106, 'Hoevenseveld');
INSERT INTO buurt (code, naam) VALUES (8560107, 'Schutveld');
INSERT INTO buurt (code, naam) VALUES (8560108, 'Buurtschap Hoeven');
INSERT INTO buurt (code, naam) VALUES (8560109, 'Hoeven');
INSERT INTO buurt (code, naam) VALUES (8560110, 'Melle');
INSERT INTO buurt (code, naam) VALUES (8560111, 'Raam');
INSERT INTO buurt (code, naam) VALUES (8560112, 'Sportpark Volkelseweg');
INSERT INTO buurt (code, naam) VALUES (8560113, 'Zoggel');
INSERT INTO buurt (code, naam) VALUES (8560114, 'Vluchtoord');
INSERT INTO buurt (code, naam) VALUES (8560115, 'Loopkant-Liessent-Goorkens');
INSERT INTO buurt (code, naam) VALUES (8560116, 'Hoenderbos-Velmolen');
INSERT INTO buurt (code, naam) VALUES (8560117, 'Eikenheuvel');
INSERT INTO buurt (code, naam) VALUES (8560196, 'Buitengebied Uden-Oost');
INSERT INTO buurt (code, naam) VALUES (8560197, 'Buitengebied Uden-Zuid');
INSERT INTO buurt (code, naam) VALUES (8560198, 'Buitengebied Uden-West');
INSERT INTO buurt (code, naam) VALUES (8560199, 'Buitengebied Maashorst');
INSERT INTO buurt (code, naam) VALUES (8560201, 'Kom Volkel');
INSERT INTO buurt (code, naam) VALUES (8560298, 'Vliegbasis Volkel');
INSERT INTO buurt (code, naam) VALUES (8560299, 'Buitengebied-Volkel');
INSERT INTO buurt (code, naam) VALUES (8560301, 'Odiliapeel');
INSERT INTO buurt (code, naam) VALUES (8560399, 'Buitengebied-Odiliapeel');
INSERT INTO buurt (code, naam) VALUES (8580000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (8580001, 'Geenhoven');
INSERT INTO buurt (code, naam) VALUES (8580002, 'Turfberg-Noord');
INSERT INTO buurt (code, naam) VALUES (8580003, 'Turfberg-Zuid');
INSERT INTO buurt (code, naam) VALUES (8580004, 'Hoge Akkers');
INSERT INTO buurt (code, naam) VALUES (8580005, 'Kerkakkers');
INSERT INTO buurt (code, naam) VALUES (8580006, 'Het Gegraaf');
INSERT INTO buurt (code, naam) VALUES (8580007, 'Industrieterrein Schaapsloop');
INSERT INTO buurt (code, naam) VALUES (8580009, 'Verspreide huizen Turfbergse Heide Nederheide');
INSERT INTO buurt (code, naam) VALUES (8580100, 'De Belleman');
INSERT INTO buurt (code, naam) VALUES (8580101, 'Agnetendal');
INSERT INTO buurt (code, naam) VALUES (8580102, 'Schepelweijen');
INSERT INTO buurt (code, naam) VALUES (8580103, 'Brouwershof');
INSERT INTO buurt (code, naam) VALUES (8580104, 'Keersop');
INSERT INTO buurt (code, naam) VALUES (8580105, 'Keersopperbeemden');
INSERT INTO buurt (code, naam) VALUES (8580106, 'Dommelen');
INSERT INTO buurt (code, naam) VALUES (8580200, 'Borkel');
INSERT INTO buurt (code, naam) VALUES (8580201, 'Schaft');
INSERT INTO buurt (code, naam) VALUES (8580208, 'Verspreide huizen Klein Borkel en Achterste Brug');
INSERT INTO buurt (code, naam) VALUES (8580209, 'Verspreide huizen Malpiebergse- en Opperheide');
INSERT INTO buurt (code, naam) VALUES (8600000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (8600001, 'West');
INSERT INTO buurt (code, naam) VALUES (8600002, 'Leest');
INSERT INTO buurt (code, naam) VALUES (8600003, 'Veghel-Zuid');
INSERT INTO buurt (code, naam) VALUES (8600004, 'Bunders');
INSERT INTO buurt (code, naam) VALUES (8600005, 'Amert-Dorshout');
INSERT INTO buurt (code, naam) VALUES (8600006, 'Dubbelen');
INSERT INTO buurt (code, naam) VALUES (8600007, 'Ven');
INSERT INTO buurt (code, naam) VALUES (8600008, 'Noord');
INSERT INTO buurt (code, naam) VALUES (8600009, 'Heuvel-Havelt');
INSERT INTO buurt (code, naam) VALUES (8600010, 'Sportpark-Knokert');
INSERT INTO buurt (code, naam) VALUES (8600011, 'Doornhoek-Kempkens');
INSERT INTO buurt (code, naam) VALUES (8600100, 'Mariaheide');
INSERT INTO buurt (code, naam) VALUES (8600101, 'Verspreide huizen Mariaheide');
INSERT INTO buurt (code, naam) VALUES (8600200, 'Zijtaart');
INSERT INTO buurt (code, naam) VALUES (8600201, 'Zondveld');
INSERT INTO buurt (code, naam) VALUES (8600202, 'Jekschot');
INSERT INTO buurt (code, naam) VALUES (8600300, 'Eerde');
INSERT INTO buurt (code, naam) VALUES (8600301, 'Verspreide huizen Eerde');
INSERT INTO buurt (code, naam) VALUES (8600400, 'Erp');
INSERT INTO buurt (code, naam) VALUES (8600401, 'Erp-Zuid');
INSERT INTO buurt (code, naam) VALUES (8600402, 'Bolst-Ham');
INSERT INTO buurt (code, naam) VALUES (8600403, 'Kraanmeer-Veluwe');
INSERT INTO buurt (code, naam) VALUES (8600404, 'Bossen');
INSERT INTO buurt (code, naam) VALUES (8600500, 'Keldonk');
INSERT INTO buurt (code, naam) VALUES (8600501, 'Verspreide huizen Keldonk');
INSERT INTO buurt (code, naam) VALUES (8600502, 'Geregt');
INSERT INTO buurt (code, naam) VALUES (8600600, 'Boerdonk');
INSERT INTO buurt (code, naam) VALUES (8600601, 'Verspreide huizen Boerdonk');
INSERT INTO buurt (code, naam) VALUES (8610000, 'Veldhoven');
INSERT INTO buurt (code, naam) VALUES (8610001, 'Meerveldhoven');
INSERT INTO buurt (code, naam) VALUES (8610002, 'Zeelst');
INSERT INTO buurt (code, naam) VALUES (8610003, 'D''Ekker');
INSERT INTO buurt (code, naam) VALUES (8610004, 'Zonderwijk');
INSERT INTO buurt (code, naam) VALUES (8610005, '''t Look');
INSERT INTO buurt (code, naam) VALUES (8610006, 'Cobbeek en Centrum');
INSERT INTO buurt (code, naam) VALUES (8610009, 'Verspreide huizen ten zuiden van de E3-weg');
INSERT INTO buurt (code, naam) VALUES (8610100, 'Heikant-West');
INSERT INTO buurt (code, naam) VALUES (8610101, 'Heikant-Oost');
INSERT INTO buurt (code, naam) VALUES (8610102, 'De Kelen');
INSERT INTO buurt (code, naam) VALUES (8610103, 'De Polders');
INSERT INTO buurt (code, naam) VALUES (8610200, 'Oerle');
INSERT INTO buurt (code, naam) VALUES (8610201, 'Zandoerle');
INSERT INTO buurt (code, naam) VALUES (8610207, 'Verspreide huizen Zittard');
INSERT INTO buurt (code, naam) VALUES (8610208, 'Verspreide huizen Groote Aard en Vliet');
INSERT INTO buurt (code, naam) VALUES (8610209, 'Verspreide huizen Scherpenering en Landsaard');
INSERT INTO buurt (code, naam) VALUES (8650000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (8650001, 'Taalstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (8650002, 'Loyola en omgeving');
INSERT INTO buurt (code, naam) VALUES (8650003, 'Loonsebaan');
INSERT INTO buurt (code, naam) VALUES (8650004, 'Villapark');
INSERT INTO buurt (code, naam) VALUES (8650005, 'Schoonveld');
INSERT INTO buurt (code, naam) VALUES (8650008, 'Vughtse Heide en Lunetten');
INSERT INTO buurt (code, naam) VALUES (8650009, 'Gement');
INSERT INTO buurt (code, naam) VALUES (8650100, 'Voorburg en omgeving');
INSERT INTO buurt (code, naam) VALUES (8650101, 'Molenstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (8650102, 'De Baarzen');
INSERT INTO buurt (code, naam) VALUES (8650103, 'Vijverhof');
INSERT INTO buurt (code, naam) VALUES (8650104, 'De Vughtse Hoeven');
INSERT INTO buurt (code, naam) VALUES (8650108, 'Bleijendijk');
INSERT INTO buurt (code, naam) VALUES (8650109, 'Bergenshuizen');
INSERT INTO buurt (code, naam) VALUES (8650200, 'Cromvoirt');
INSERT INTO buurt (code, naam) VALUES (8650209, 'Verspreide huizen Cromvoirt');
INSERT INTO buurt (code, naam) VALUES (8660000, 'Waalre');
INSERT INTO buurt (code, naam) VALUES (8660001, 'Aalst');
INSERT INTO buurt (code, naam) VALUES (8660002, 'Voldijn');
INSERT INTO buurt (code, naam) VALUES (8660003, 'Ekenrooi');
INSERT INTO buurt (code, naam) VALUES (8660009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (8670000, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (8670001, 'Besoijen');
INSERT INTO buurt (code, naam) VALUES (8670002, 'Baardwijk');
INSERT INTO buurt (code, naam) VALUES (8670003, 'Laageinde');
INSERT INTO buurt (code, naam) VALUES (8670004, 'Antoniusparochie');
INSERT INTO buurt (code, naam) VALUES (8670005, 'Bloemenoord');
INSERT INTO buurt (code, naam) VALUES (8670006, 'Zanddonk');
INSERT INTO buurt (code, naam) VALUES (8670007, 'Meerdijk');
INSERT INTO buurt (code, naam) VALUES (8670008, 'De Hoef');
INSERT INTO buurt (code, naam) VALUES (8670009, 'Industrieterrein Zanddonk');
INSERT INTO buurt (code, naam) VALUES (8670010, 'Industrieterrein Haven');
INSERT INTO buurt (code, naam) VALUES (8670011, 'Buitengebied Waalwijk Noord');
INSERT INTO buurt (code, naam) VALUES (8670012, 'Eikendonk');
INSERT INTO buurt (code, naam) VALUES (8670013, 'Recreatieoord');
INSERT INTO buurt (code, naam) VALUES (8670100, 'Sprang');
INSERT INTO buurt (code, naam) VALUES (8670101, 'Vrijhoeve');
INSERT INTO buurt (code, naam) VALUES (8670102, 'Capelle / Nieuwe Vaart');
INSERT INTO buurt (code, naam) VALUES (8670103, 'Buitengebeid Capelle');
INSERT INTO buurt (code, naam) VALUES (8670104, 'Landgoed Driessen');
INSERT INTO buurt (code, naam) VALUES (8670200, 'Waspik Beneden');
INSERT INTO buurt (code, naam) VALUES (8670201, 'Waspik Boven');
INSERT INTO buurt (code, naam) VALUES (8670202, 'Industrieterrein Waspik');
INSERT INTO buurt (code, naam) VALUES (8670203, 'Buitengebied Waspik');
INSERT INTO buurt (code, naam) VALUES (8700101, 'Centrum Werkendam');
INSERT INTO buurt (code, naam) VALUES (8700102, 'Burchtpolder');
INSERT INTO buurt (code, naam) VALUES (8700103, 'Welgelegen');
INSERT INTO buurt (code, naam) VALUES (8700104, 'Vervoornepolder');
INSERT INTO buurt (code, naam) VALUES (8700105, 'Werkensepolder');
INSERT INTO buurt (code, naam) VALUES (8700106, 'Bedrijventerreinen Werkendam');
INSERT INTO buurt (code, naam) VALUES (8700191, 'Binnenvliet');
INSERT INTO buurt (code, naam) VALUES (8700192, 'Zevenban');
INSERT INTO buurt (code, naam) VALUES (8700193, 'Grote Waard');
INSERT INTO buurt (code, naam) VALUES (8700194, 'Noordwaard');
INSERT INTO buurt (code, naam) VALUES (8700195, 'Oude Hardenhoek');
INSERT INTO buurt (code, naam) VALUES (8700196, 'Spie Deen');
INSERT INTO buurt (code, naam) VALUES (8700201, 'Kern Sleeuwijk');
INSERT INTO buurt (code, naam) VALUES (8700202, 'Bedrijventerrein Sleeuwijk');
INSERT INTO buurt (code, naam) VALUES (8700291, 'Sleeuwijksepolder');
INSERT INTO buurt (code, naam) VALUES (8700292, 'Nieuwe Ban');
INSERT INTO buurt (code, naam) VALUES (8700301, 'Kern Nieuwendijk');
INSERT INTO buurt (code, naam) VALUES (8700302, 'Bedrijventerrein Nieuwendijk');
INSERT INTO buurt (code, naam) VALUES (8700391, 'Karnemelkpolder');
INSERT INTO buurt (code, naam) VALUES (8700392, 'Gantel');
INSERT INTO buurt (code, naam) VALUES (8700401, 'Kern Hank');
INSERT INTO buurt (code, naam) VALUES (8700402, 'Bedrijventerrein Hank');
INSERT INTO buurt (code, naam) VALUES (8700491, 'Vierbannen');
INSERT INTO buurt (code, naam) VALUES (8700492, 'Jannezand');
INSERT INTO buurt (code, naam) VALUES (8700493, 'Aakvlaai');
INSERT INTO buurt (code, naam) VALUES (8700494, 'Kurenpolder');
INSERT INTO buurt (code, naam) VALUES (8700495, 'Zuidhollandschepolder');
INSERT INTO buurt (code, naam) VALUES (8700501, 'Kern Dussen');
INSERT INTO buurt (code, naam) VALUES (8700502, 'Bedrijventerrein Dussen');
INSERT INTO buurt (code, naam) VALUES (8700591, 'Noordeveld');
INSERT INTO buurt (code, naam) VALUES (8730000, 'Hoogerheide');
INSERT INTO buurt (code, naam) VALUES (8730001, 'Woensdrecht');
INSERT INTO buurt (code, naam) VALUES (8730002, 'Hoogerheide-Noord');
INSERT INTO buurt (code, naam) VALUES (8730003, 'Industrieterrein De Kooy');
INSERT INTO buurt (code, naam) VALUES (8730008, 'Verspreide huizen Woensdrecht');
INSERT INTO buurt (code, naam) VALUES (8730009, 'Verspreide huizen Hoogerheide');
INSERT INTO buurt (code, naam) VALUES (8730100, 'Huijbergen');
INSERT INTO buurt (code, naam) VALUES (8730101, 'Eiland');
INSERT INTO buurt (code, naam) VALUES (8730108, 'Verspreide huizen ten zuiden van Huijbergen');
INSERT INTO buurt (code, naam) VALUES (8730109, 'Verspreide huizen ten noorden van Huijbergen');
INSERT INTO buurt (code, naam) VALUES (8730200, 'Ossendrecht');
INSERT INTO buurt (code, naam) VALUES (8730201, 'Calfven');
INSERT INTO buurt (code, naam) VALUES (8730208, 'Verspreide huizen ten westen van Ossendrecht');
INSERT INTO buurt (code, naam) VALUES (8730209, 'Verspreide huizen ten oosten van Ossendrecht');
INSERT INTO buurt (code, naam) VALUES (8730300, 'Putte');
INSERT INTO buurt (code, naam) VALUES (8730309, 'Verspreide huizen Putte');
INSERT INTO buurt (code, naam) VALUES (8740000, 'Woudrichem binnen de vesting');
INSERT INTO buurt (code, naam) VALUES (8740001, 'Woudrichem buiten de vesting');
INSERT INTO buurt (code, naam) VALUES (8740002, 'Oudendijk');
INSERT INTO buurt (code, naam) VALUES (8740009, 'Verspreide huizen in buitengebied');
INSERT INTO buurt (code, naam) VALUES (8740100, 'Almkerk');
INSERT INTO buurt (code, naam) VALUES (8740107, 'Verspreide huizen Zandwijk en omgeving');
INSERT INTO buurt (code, naam) VALUES (8740108, 'Verspreide huizen Provincialeweg-Noord en omgeving');
INSERT INTO buurt (code, naam) VALUES (8740109, 'Verspreide huizen Provincialeweg-Zuid en omgeving');
INSERT INTO buurt (code, naam) VALUES (8740200, 'Rijswijk');
INSERT INTO buurt (code, naam) VALUES (8740209, 'Verspreide huizen in buitengebied');
INSERT INTO buurt (code, naam) VALUES (8740300, 'Giessen');
INSERT INTO buurt (code, naam) VALUES (8740309, 'Verspreide huizen in buitengebied');
INSERT INTO buurt (code, naam) VALUES (8740400, 'Andel');
INSERT INTO buurt (code, naam) VALUES (8740409, 'Verspreide huizen in buitengebied');
INSERT INTO buurt (code, naam) VALUES (8740500, 'Uitwijk');
INSERT INTO buurt (code, naam) VALUES (8740501, 'Waardhuizen');
INSERT INTO buurt (code, naam) VALUES (8740509, 'Verspreide huizen in buitengebied');
INSERT INTO buurt (code, naam) VALUES (8790000, 'Zundert');
INSERT INTO buurt (code, naam) VALUES (8790009, 'Verspreide huizen Zundert');
INSERT INTO buurt (code, naam) VALUES (8790100, 'Klein-Zundert');
INSERT INTO buurt (code, naam) VALUES (8790109, 'Verspreide huizen Klein-Zundert');
INSERT INTO buurt (code, naam) VALUES (8790200, 'Wernhout');
INSERT INTO buurt (code, naam) VALUES (8790209, 'Verspreide huizen Wernhout');
INSERT INTO buurt (code, naam) VALUES (8790300, 'Achtmaal');
INSERT INTO buurt (code, naam) VALUES (8790309, 'Verspreide huizen Achtmaal');
INSERT INTO buurt (code, naam) VALUES (8790400, 'Rijsbergen');
INSERT INTO buurt (code, naam) VALUES (8790408, 'Verspreide huizen in het Oosten');
INSERT INTO buurt (code, naam) VALUES (8790409, 'Verspreide huizen in het Westen');
INSERT INTO buurt (code, naam) VALUES (8800000, 'Oosteinde');
INSERT INTO buurt (code, naam) VALUES (8800001, 'Westeinde');
INSERT INTO buurt (code, naam) VALUES (8800002, 'Oost-Knollendam');
INSERT INTO buurt (code, naam) VALUES (8800003, 'Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (8800004, 'Plaszoom');
INSERT INTO buurt (code, naam) VALUES (8800005, 'Middentil');
INSERT INTO buurt (code, naam) VALUES (8800009, 'Verspreide huizen in de polder Engewormer');
INSERT INTO buurt (code, naam) VALUES (8800100, 'Neck (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (8800108, 'Verspreide huizen ten zuiden van De Middentocht');
INSERT INTO buurt (code, naam) VALUES (8800109, 'Verspreide huizen ten noorden van De Middentocht');
INSERT INTO buurt (code, naam) VALUES (8800200, 'Jisp');
INSERT INTO buurt (code, naam) VALUES (8800201, 'Uitbreiding-Jisp');
INSERT INTO buurt (code, naam) VALUES (8800208, 'Spijkerboor');
INSERT INTO buurt (code, naam) VALUES (8800209, 'Verspreide huizen Kanaal- en Oudelandsdijk');
INSERT INTO buurt (code, naam) VALUES (8810000, 'Schinveld');
INSERT INTO buurt (code, naam) VALUES (8810001, 'Jabeek');
INSERT INTO buurt (code, naam) VALUES (8810002, 'Bingelrade');
INSERT INTO buurt (code, naam) VALUES (8810003, 'Merkelbeek-Douvergenhout');
INSERT INTO buurt (code, naam) VALUES (8810009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (8820001, 'Kakert');
INSERT INTO buurt (code, naam) VALUES (8820002, 'Lichtenberg');
INSERT INTO buurt (code, naam) VALUES (8820003, 'De Dormig');
INSERT INTO buurt (code, naam) VALUES (8820004, 'De Streep');
INSERT INTO buurt (code, naam) VALUES (8820005, 'Klinkerkwartier');
INSERT INTO buurt (code, naam) VALUES (8820006, 'Achter de Haesen');
INSERT INTO buurt (code, naam) VALUES (8820007, 'Leenhof');
INSERT INTO buurt (code, naam) VALUES (8820008, 'Schaesberg Centrum');
INSERT INTO buurt (code, naam) VALUES (8820009, 'Achter den Winkel');
INSERT INTO buurt (code, naam) VALUES (8820010, 'Mijnbuurt');
INSERT INTO buurt (code, naam) VALUES (8820011, 'Eiske');
INSERT INTO buurt (code, naam) VALUES (8820012, 'Heistraat');
INSERT INTO buurt (code, naam) VALUES (8820020, 'Gravenrode');
INSERT INTO buurt (code, naam) VALUES (8820101, 'Nieuwenhagerheide');
INSERT INTO buurt (code, naam) VALUES (8820102, 'Oud Nieuwenhagen');
INSERT INTO buurt (code, naam) VALUES (8820103, 'Hoefveld');
INSERT INTO buurt (code, naam) VALUES (8820104, 'Op de Kamp');
INSERT INTO buurt (code, naam) VALUES (8820105, 'Exdel');
INSERT INTO buurt (code, naam) VALUES (8820120, 'Buitengebied Brunssumerheide (2)');
INSERT INTO buurt (code, naam) VALUES (8820201, 'Abdissenbosch');
INSERT INTO buurt (code, naam) VALUES (8820202, 'Parkheide');
INSERT INTO buurt (code, naam) VALUES (8820203, 'Namiddagsche Driessen');
INSERT INTO buurt (code, naam) VALUES (8820204, 'Lauradorp');
INSERT INTO buurt (code, naam) VALUES (8820205, 'Waubach');
INSERT INTO buurt (code, naam) VALUES (8820206, 'Groenstraat');
INSERT INTO buurt (code, naam) VALUES (8820207, 'Rimburg');
INSERT INTO buurt (code, naam) VALUES (8820220, 'Brunssumerheide (1)');
INSERT INTO buurt (code, naam) VALUES (8880000, 'Beek');
INSERT INTO buurt (code, naam) VALUES (8880001, 'Neerbeek');
INSERT INTO buurt (code, naam) VALUES (8880002, 'Spaubeek');
INSERT INTO buurt (code, naam) VALUES (8880100, 'Geverik');
INSERT INTO buurt (code, naam) VALUES (8880101, 'Grootgenhout');
INSERT INTO buurt (code, naam) VALUES (8880102, 'Kleingenhout');
INSERT INTO buurt (code, naam) VALUES (8880103, 'Kelmond');
INSERT INTO buurt (code, naam) VALUES (8880109, 'Verspreide huizen Vliegbasis Zuid-Limburg');
INSERT INTO buurt (code, naam) VALUES (8890000, 'Reuver');
INSERT INTO buurt (code, naam) VALUES (8890001, 'Offenbeek');
INSERT INTO buurt (code, naam) VALUES (8890008, 'Verspreide huizen ten oosten en zuiden van de spoorlijn');
INSERT INTO buurt (code, naam) VALUES (8890009, 'Overige verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (8890100, 'Beesel');
INSERT INTO buurt (code, naam) VALUES (8890101, 'Bussereind');
INSERT INTO buurt (code, naam) VALUES (8890102, 'Rijkel');
INSERT INTO buurt (code, naam) VALUES (8890109, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (8930000, 'Siebengewald');
INSERT INTO buurt (code, naam) VALUES (8930003, 'Groote Horst-Kleine Horst');
INSERT INTO buurt (code, naam) VALUES (8930008, 'Verspreide huizen Vrij-Op de Belt');
INSERT INTO buurt (code, naam) VALUES (8930100, 'Afferden');
INSERT INTO buurt (code, naam) VALUES (8930101, 'Heukelom-Gening-Berkenkamp');
INSERT INTO buurt (code, naam) VALUES (8930102, 'Rimpeld-Bleijenbeek');
INSERT INTO buurt (code, naam) VALUES (8930108, 'Verspreide huizen ten noorden van Afferden');
INSERT INTO buurt (code, naam) VALUES (8930200, 'Bergen');
INSERT INTO buurt (code, naam) VALUES (8930201, 'Aijen');
INSERT INTO buurt (code, naam) VALUES (8930202, 'Rijksweg, Bergsche Heide en Op de Paal');
INSERT INTO buurt (code, naam) VALUES (8930203, 'Nieuw-Bergen');
INSERT INTO buurt (code, naam) VALUES (8930209, 'Verspreide huizen Ceres-Lackbar');
INSERT INTO buurt (code, naam) VALUES (8930300, 'Papenbeek');
INSERT INTO buurt (code, naam) VALUES (8930301, 'Well waaronder Elsteren');
INSERT INTO buurt (code, naam) VALUES (8930308, 'Verspreide huizen Knikkerdorp-Wellsmeer');
INSERT INTO buurt (code, naam) VALUES (8930309, 'Verspreide huizen Leuken-Kamp-Bosserheide');
INSERT INTO buurt (code, naam) VALUES (8930400, 'Wellerlooi');
INSERT INTO buurt (code, naam) VALUES (8930408, 'Verspreide huizen Wellerlooi Tuindorp');
INSERT INTO buurt (code, naam) VALUES (8930409, 'Verspreide huizen De Hamert');
INSERT INTO buurt (code, naam) VALUES (8990124, 'Klingelsberg');
INSERT INTO buurt (code, naam) VALUES (8990126, 'Op de Vos');
INSERT INTO buurt (code, naam) VALUES (8990134, 'Treebeek-Zuid');
INSERT INTO buurt (code, naam) VALUES (8990135, 'Emma');
INSERT INTO buurt (code, naam) VALUES (8990136, 'Amstenraderveld');
INSERT INTO buurt (code, naam) VALUES (8990144, 'Treebeek-Noord');
INSERT INTO buurt (code, naam) VALUES (8990201, 'Houserveld');
INSERT INTO buurt (code, naam) VALUES (8990202, 'Klingbemden');
INSERT INTO buurt (code, naam) VALUES (8990203, 'Rozengaard');
INSERT INTO buurt (code, naam) VALUES (8990204, 'De Kling');
INSERT INTO buurt (code, naam) VALUES (8990205, 'Op den Haan');
INSERT INTO buurt (code, naam) VALUES (8990207, 'Lemmender');
INSERT INTO buurt (code, naam) VALUES (8990208, 'De Streek');
INSERT INTO buurt (code, naam) VALUES (8990209, 'Het Heufken');
INSERT INTO buurt (code, naam) VALUES (8990225, 'Bexdelle');
INSERT INTO buurt (code, naam) VALUES (8990242, 'Merkelbeekerdal');
INSERT INTO buurt (code, naam) VALUES (8990243, 'Buitengebied');
INSERT INTO buurt (code, naam) VALUES (8990314, 'Rode Beek');
INSERT INTO buurt (code, naam) VALUES (8990315, 'Op gen Hoes');
INSERT INTO buurt (code, naam) VALUES (8990316, 'Oeloven');
INSERT INTO buurt (code, naam) VALUES (8990317, 'De Eggen');
INSERT INTO buurt (code, naam) VALUES (8990318, 'Schuttersveld');
INSERT INTO buurt (code, naam) VALUES (8990332, 'De Kattekoelen');
INSERT INTO buurt (code, naam) VALUES (8990333, 'Bouwberg');
INSERT INTO buurt (code, naam) VALUES (8990337, 'Ora et Labora');
INSERT INTO buurt (code, naam) VALUES (8990339, 'Hendrik en omgeving');
INSERT INTO buurt (code, naam) VALUES (8990340, 'De Heide');
INSERT INTO buurt (code, naam) VALUES (8990345, 'Kleikoelen');
INSERT INTO buurt (code, naam) VALUES (8990428, 'Vondelstraat');
INSERT INTO buurt (code, naam) VALUES (8990429, 'Langenberg');
INSERT INTO buurt (code, naam) VALUES (8990430, 'De Struiken');
INSERT INTO buurt (code, naam) VALUES (8990431, 'Douvenberg');
INSERT INTO buurt (code, naam) VALUES (8990438, 'Brandenberg');
INSERT INTO buurt (code, naam) VALUES (8990441, 'Brunssumer Heide');
INSERT INTO buurt (code, naam) VALUES (8990506, 'Hofpoel');
INSERT INTO buurt (code, naam) VALUES (8990510, 'Op de Vaard');
INSERT INTO buurt (code, naam) VALUES (8990511, 'Koutenveld');
INSERT INTO buurt (code, naam) VALUES (8990512, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (8990513, 'Kerkeveld');
INSERT INTO buurt (code, naam) VALUES (8990519, 'Kruisberg');
INSERT INTO buurt (code, naam) VALUES (8990520, 'Achter de Put');
INSERT INTO buurt (code, naam) VALUES (8990521, 'Haansberg');
INSERT INTO buurt (code, naam) VALUES (8990522, 'Vijverpark');
INSERT INTO buurt (code, naam) VALUES (8990523, 'Rumpener Beemden');
INSERT INTO buurt (code, naam) VALUES (8990527, 'De Hemelder');
INSERT INTO buurt (code, naam) VALUES (9070000, 'Milsbeek');
INSERT INTO buurt (code, naam) VALUES (9070001, 'Sprokkelveld');
INSERT INTO buurt (code, naam) VALUES (9070009, 'Bloemenstraat-Zwarteweg');
INSERT INTO buurt (code, naam) VALUES (9070100, 'Ottersum');
INSERT INTO buurt (code, naam) VALUES (9070108, 'Aaldonk-Violenberg');
INSERT INTO buurt (code, naam) VALUES (9070109, 'Looierheide');
INSERT INTO buurt (code, naam) VALUES (9070200, 'Ven-Zelderheide');
INSERT INTO buurt (code, naam) VALUES (9070209, 'Langehorst-Zelder');
INSERT INTO buurt (code, naam) VALUES (9070300, 'Oude Stadskern');
INSERT INTO buurt (code, naam) VALUES (9070301, 'Noord');
INSERT INTO buurt (code, naam) VALUES (9070302, 'Midden');
INSERT INTO buurt (code, naam) VALUES (9070303, 'Zuid');
INSERT INTO buurt (code, naam) VALUES (9070309, 'Panoven-Maaskemp');
INSERT INTO buurt (code, naam) VALUES (9070400, 'Heijen');
INSERT INTO buurt (code, naam) VALUES (9070408, 'Heijensebos');
INSERT INTO buurt (code, naam) VALUES (9070409, 'Diekendaal-Nieuwerf');
INSERT INTO buurt (code, naam) VALUES (9171000, 'Maria Gewanden');
INSERT INTO buurt (code, naam) VALUES (9171001, 'Terschuren');
INSERT INTO buurt (code, naam) VALUES (9171100, 'Mariarade-Noord');
INSERT INTO buurt (code, naam) VALUES (9171101, 'Mariarade-Zuid');
INSERT INTO buurt (code, naam) VALUES (9171200, 'Hoensbroek-Centrum');
INSERT INTO buurt (code, naam) VALUES (9171201, 'De Dem en omgeving');
INSERT INTO buurt (code, naam) VALUES (9171300, 'Nieuw Lotbroek-Noord');
INSERT INTO buurt (code, naam) VALUES (9171301, 'Nieuw Lotbroek-Zuid');
INSERT INTO buurt (code, naam) VALUES (9171400, 'De Koumen');
INSERT INTO buurt (code, naam) VALUES (9172000, 'Weggebekker');
INSERT INTO buurt (code, naam) VALUES (9172001, 'Uterweg');
INSERT INTO buurt (code, naam) VALUES (9172002, 'Nieuw-Einde');
INSERT INTO buurt (code, naam) VALUES (9172003, 'Versiliënbosch');
INSERT INTO buurt (code, naam) VALUES (9172004, 'Vrieheide');
INSERT INTO buurt (code, naam) VALUES (9172100, 'Passart');
INSERT INTO buurt (code, naam) VALUES (9172101, 'Heerlerheide Kom');
INSERT INTO buurt (code, naam) VALUES (9172200, 'Heksenberg');
INSERT INTO buurt (code, naam) VALUES (9172201, 'Pronsebroek');
INSERT INTO buurt (code, naam) VALUES (9172300, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (9172400, 'Groot Rennemig');
INSERT INTO buurt (code, naam) VALUES (9172401, 'Beersdal');
INSERT INTO buurt (code, naam) VALUES (9172402, 'Schelsberg');
INSERT INTO buurt (code, naam) VALUES (9173000, 'Husken');
INSERT INTO buurt (code, naam) VALUES (9173001, 'Zeswegen');
INSERT INTO buurt (code, naam) VALUES (9173002, 'In de Cramer');
INSERT INTO buurt (code, naam) VALUES (9173100, 'Musschemig');
INSERT INTO buurt (code, naam) VALUES (9173101, 'Grasbroek');
INSERT INTO buurt (code, naam) VALUES (9173102, 'Schandelen');
INSERT INTO buurt (code, naam) VALUES (9173103, 'Hoppersgraaf');
INSERT INTO buurt (code, naam) VALUES (9173200, 'Palemig');
INSERT INTO buurt (code, naam) VALUES (9173201, 'Burettestraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (9173202, 'Meezenbroek');
INSERT INTO buurt (code, naam) VALUES (9173203, 'Schaesbergerveld');
INSERT INTO buurt (code, naam) VALUES (9173300, 'Heerlen-Centrum');
INSERT INTO buurt (code, naam) VALUES (9173301, 'Op de Nobel');
INSERT INTO buurt (code, naam) VALUES (9173302, '''t Loon');
INSERT INTO buurt (code, naam) VALUES (9173303, 'Lindeveld');
INSERT INTO buurt (code, naam) VALUES (9173400, 'Eikenderveld');
INSERT INTO buurt (code, naam) VALUES (9173500, 'Ten Esschen');
INSERT INTO buurt (code, naam) VALUES (9173600, 'Terworm');
INSERT INTO buurt (code, naam) VALUES (9173601, 'Welten-Dorp');
INSERT INTO buurt (code, naam) VALUES (9173602, 'Ziekenhuis');
INSERT INTO buurt (code, naam) VALUES (9173603, 'Benzenrade');
INSERT INTO buurt (code, naam) VALUES (9173700, 'Bekkerveld');
INSERT INTO buurt (code, naam) VALUES (9173701, 'Aarveld');
INSERT INTO buurt (code, naam) VALUES (9173800, 'Caumerveld');
INSERT INTO buurt (code, naam) VALUES (9173801, 'Douve Weien');
INSERT INTO buurt (code, naam) VALUES (9173900, 'Molenbergpark');
INSERT INTO buurt (code, naam) VALUES (9173901, 'Dr. Nolensplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (9173902, 'Dr. Schaepmanplein en omgeving');
INSERT INTO buurt (code, naam) VALUES (9173903, 'Schiffelerveld');
INSERT INTO buurt (code, naam) VALUES (9174000, 'Heerlerbaan-Oost');
INSERT INTO buurt (code, naam) VALUES (9174100, 'Egstraat en omgeving');
INSERT INTO buurt (code, naam) VALUES (9174101, 'Giezenveld');
INSERT INTO buurt (code, naam) VALUES (9174102, 'Heerlerbaan-West');
INSERT INTO buurt (code, naam) VALUES (9174103, 'Imstenrade');
INSERT INTO buurt (code, naam) VALUES (9174200, 'Beitel');
INSERT INTO buurt (code, naam) VALUES (9280000, 'Spekholzerheide');
INSERT INTO buurt (code, naam) VALUES (9280001, 'Heilust');
INSERT INTO buurt (code, naam) VALUES (9280002, 'Terwinselen');
INSERT INTO buurt (code, naam) VALUES (9280003, 'Kaalheide');
INSERT INTO buurt (code, naam) VALUES (9280004, 'Gracht');
INSERT INTO buurt (code, naam) VALUES (9280009, 'Verspreide huizen Dentgenbach');
INSERT INTO buurt (code, naam) VALUES (9280100, 'Kerkrade-Centrum');
INSERT INTO buurt (code, naam) VALUES (9280101, 'Erenstein');
INSERT INTO buurt (code, naam) VALUES (9280102, 'Rolduckerveld');
INSERT INTO buurt (code, naam) VALUES (9280103, 'Holz');
INSERT INTO buurt (code, naam) VALUES (9280104, 'Nulland');
INSERT INTO buurt (code, naam) VALUES (9280105, 'Bleijerheide');
INSERT INTO buurt (code, naam) VALUES (9280200, 'Eygelshoven-Kom');
INSERT INTO buurt (code, naam) VALUES (9280201, 'Hopel');
INSERT INTO buurt (code, naam) VALUES (9280202, 'Waubacherveld');
INSERT INTO buurt (code, naam) VALUES (9280203, 'Vink');
INSERT INTO buurt (code, naam) VALUES (9280204, 'Chevremont');
INSERT INTO buurt (code, naam) VALUES (9280205, 'Haanrade');
INSERT INTO buurt (code, naam) VALUES (9350000, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (9350001, 'Jekerkwartier');
INSERT INTO buurt (code, naam) VALUES (9350002, 'Kommelkwartier');
INSERT INTO buurt (code, naam) VALUES (9350003, 'Statenkwartier');
INSERT INTO buurt (code, naam) VALUES (9350004, 'Boschstraatkwartier');
INSERT INTO buurt (code, naam) VALUES (9350005, 'Sint Maartenspoort');
INSERT INTO buurt (code, naam) VALUES (9350006, 'Wyck');
INSERT INTO buurt (code, naam) VALUES (9350100, 'Villapark');
INSERT INTO buurt (code, naam) VALUES (9350101, 'Jekerdal');
INSERT INTO buurt (code, naam) VALUES (9350102, 'Biesland');
INSERT INTO buurt (code, naam) VALUES (9350103, 'Campagne');
INSERT INTO buurt (code, naam) VALUES (9350104, 'Wolder');
INSERT INTO buurt (code, naam) VALUES (9350105, 'Sint Pieter');
INSERT INTO buurt (code, naam) VALUES (9350200, 'Brusselsepoort');
INSERT INTO buurt (code, naam) VALUES (9350201, 'Mariaberg');
INSERT INTO buurt (code, naam) VALUES (9350202, 'Belfort');
INSERT INTO buurt (code, naam) VALUES (9350203, 'Pottenberg');
INSERT INTO buurt (code, naam) VALUES (9350204, 'Malpertuis');
INSERT INTO buurt (code, naam) VALUES (9350205, 'Caberg');
INSERT INTO buurt (code, naam) VALUES (9350206, 'Oud-Caberg');
INSERT INTO buurt (code, naam) VALUES (9350207, 'Malberg');
INSERT INTO buurt (code, naam) VALUES (9350208, 'Dousberg-Hazendans');
INSERT INTO buurt (code, naam) VALUES (9350209, 'Daalhof');
INSERT INTO buurt (code, naam) VALUES (9350300, 'Boschpoort');
INSERT INTO buurt (code, naam) VALUES (9350301, 'Bosscherveld');
INSERT INTO buurt (code, naam) VALUES (9350302, 'Frontenkwartier');
INSERT INTO buurt (code, naam) VALUES (9350303, 'Belvédère');
INSERT INTO buurt (code, naam) VALUES (9350304, 'Lanakerveld');
INSERT INTO buurt (code, naam) VALUES (9350400, 'Wyckerpoort');
INSERT INTO buurt (code, naam) VALUES (9350401, 'Heugemerveld');
INSERT INTO buurt (code, naam) VALUES (9350402, 'Wittevrouwenveld');
INSERT INTO buurt (code, naam) VALUES (9350403, 'Nazareth');
INSERT INTO buurt (code, naam) VALUES (9350404, 'Limmel');
INSERT INTO buurt (code, naam) VALUES (9350405, 'Scharn');
INSERT INTO buurt (code, naam) VALUES (9350406, 'Amby');
INSERT INTO buurt (code, naam) VALUES (9350500, 'Beatrixhaven');
INSERT INTO buurt (code, naam) VALUES (9350501, 'Borgharen');
INSERT INTO buurt (code, naam) VALUES (9350502, 'Itteren');
INSERT INTO buurt (code, naam) VALUES (9350503, 'Meerssenhoven');
INSERT INTO buurt (code, naam) VALUES (9350600, 'Randwyck');
INSERT INTO buurt (code, naam) VALUES (9350601, 'Heugem');
INSERT INTO buurt (code, naam) VALUES (9350602, 'Heer');
INSERT INTO buurt (code, naam) VALUES (9350603, 'De Heeg');
INSERT INTO buurt (code, naam) VALUES (9350604, 'Vroendaal');
INSERT INTO buurt (code, naam) VALUES (9380000, 'Meerssen');
INSERT INTO buurt (code, naam) VALUES (9380001, 'Rothem');
INSERT INTO buurt (code, naam) VALUES (9380002, 'Weert');
INSERT INTO buurt (code, naam) VALUES (9380003, 'Raar');
INSERT INTO buurt (code, naam) VALUES (9380009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (9380100, 'Ulestraten');
INSERT INTO buurt (code, naam) VALUES (9380109, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (9380200, 'Bunde');
INSERT INTO buurt (code, naam) VALUES (9380201, 'Kasen');
INSERT INTO buurt (code, naam) VALUES (9380202, 'Geulle');
INSERT INTO buurt (code, naam) VALUES (9380203, 'Hussenberg met Snijdersberg');
INSERT INTO buurt (code, naam) VALUES (9380204, 'Hulsen-Oostbroek');
INSERT INTO buurt (code, naam) VALUES (9380205, 'Moorveld');
INSERT INTO buurt (code, naam) VALUES (9380206, 'Brommelen-Westbroek');
INSERT INTO buurt (code, naam) VALUES (9440000, 'Molenhoek');
INSERT INTO buurt (code, naam) VALUES (9440001, 'Mook');
INSERT INTO buurt (code, naam) VALUES (9440009, 'Verspreide huizen Bisselt');
INSERT INTO buurt (code, naam) VALUES (9440100, 'Riethorst-Plasmolen');
INSERT INTO buurt (code, naam) VALUES (9440101, 'Middelaar Katerbosch en Heikant');
INSERT INTO buurt (code, naam) VALUES (9460101, 'Nederweert');
INSERT INTO buurt (code, naam) VALUES (9460102, 'Boeket-Hoogbosweg');
INSERT INTO buurt (code, naam) VALUES (9460103, 'Bosserstraat-Lage Kuilen');
INSERT INTO buurt (code, naam) VALUES (9460104, 'Schoor-Mildert');
INSERT INTO buurt (code, naam) VALUES (9460201, 'Budschop');
INSERT INTO buurt (code, naam) VALUES (9460202, 'Winnerstraat-Eindhovensebaan');
INSERT INTO buurt (code, naam) VALUES (9460301, 'Ospel');
INSERT INTO buurt (code, naam) VALUES (9460302, 'Ospeldijk');
INSERT INTO buurt (code, naam) VALUES (9460303, 'Nieuwstraat-Horick-Kampersweg');
INSERT INTO buurt (code, naam) VALUES (9460304, 'Waatskamp-Bientjesweg');
INSERT INTO buurt (code, naam) VALUES (9460305, 'Moostdijk-Kruisvennendijk');
INSERT INTO buurt (code, naam) VALUES (9460401, 'Nederweert-Eind');
INSERT INTO buurt (code, naam) VALUES (9460402, 'Wellenstein-Aan ''t Kruis');
INSERT INTO buurt (code, naam) VALUES (9460501, 'Leveroy');
INSERT INTO buurt (code, naam) VALUES (9460502, 'Deckerstraat-Bergdijk');
INSERT INTO buurt (code, naam) VALUES (9510000, 'Nuth');
INSERT INTO buurt (code, naam) VALUES (9510001, 'Tervoorst en omgeving');
INSERT INTO buurt (code, naam) VALUES (9510002, 'Industrieterrein De Horsel');
INSERT INTO buurt (code, naam) VALUES (9510003, 'Vaesrade');
INSERT INTO buurt (code, naam) VALUES (9510004, 'Hommert (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (9510100, 'Wijnandsrade');
INSERT INTO buurt (code, naam) VALUES (9510101, 'Swier');
INSERT INTO buurt (code, naam) VALUES (9510200, 'Hulsberg');
INSERT INTO buurt (code, naam) VALUES (9510201, 'Aalbeek');
INSERT INTO buurt (code, naam) VALUES (9510202, 'Arensgenhout');
INSERT INTO buurt (code, naam) VALUES (9510300, 'Schimmert');
INSERT INTO buurt (code, naam) VALUES (9510301, 'Haasdal');
INSERT INTO buurt (code, naam) VALUES (9510302, 'Oensel');
INSERT INTO buurt (code, naam) VALUES (9570000, 'Binnenstad');
INSERT INTO buurt (code, naam) VALUES (9570001, 'Roerzicht-Voorstad');
INSERT INTO buurt (code, naam) VALUES (9570002, 'Roer-Roer-Zuid');
INSERT INTO buurt (code, naam) VALUES (9570004, 'Willem-Alexander');
INSERT INTO buurt (code, naam) VALUES (9570100, 'Roermondse Veld');
INSERT INTO buurt (code, naam) VALUES (9570101, 'Vrijveld');
INSERT INTO buurt (code, naam) VALUES (9570200, 'Kapel-Muggenbroek');
INSERT INTO buurt (code, naam) VALUES (9570201, 'De Kemp');
INSERT INTO buurt (code, naam) VALUES (9570202, 'Roerstreek');
INSERT INTO buurt (code, naam) VALUES (9570203, 'Kitskensdal');
INSERT INTO buurt (code, naam) VALUES (9570204, 'Kitskensberg');
INSERT INTO buurt (code, naam) VALUES (9570300, 'Kern Maasniel');
INSERT INTO buurt (code, naam) VALUES (9570301, 'Leeuwen');
INSERT INTO buurt (code, naam) VALUES (9570302, 'Tegelarijeveld-Broekhin');
INSERT INTO buurt (code, naam) VALUES (9570303, 'De Wijher en omgeving');
INSERT INTO buurt (code, naam) VALUES (9570304, 'Stasrandzone-Noord');
INSERT INTO buurt (code, naam) VALUES (9570400, 'Componistenbuurt');
INSERT INTO buurt (code, naam) VALUES (9570401, 'Vliegeniersbuurt');
INSERT INTO buurt (code, naam) VALUES (9570402, 'Kastelenbuurt');
INSERT INTO buurt (code, naam) VALUES (9570500, 'Sterrenberg');
INSERT INTO buurt (code, naam) VALUES (9570501, 'Hoogvonderen');
INSERT INTO buurt (code, naam) VALUES (9570600, 'Asenray buitengebied');
INSERT INTO buurt (code, naam) VALUES (9570601, 'Asenray');
INSERT INTO buurt (code, naam) VALUES (9570700, 'Ool');
INSERT INTO buurt (code, naam) VALUES (9570701, 'Herten');
INSERT INTO buurt (code, naam) VALUES (9570702, 'Merum');
INSERT INTO buurt (code, naam) VALUES (9570703, 'Oolderplas');
INSERT INTO buurt (code, naam) VALUES (9570800, 'Swalmen-Centrum');
INSERT INTO buurt (code, naam) VALUES (9570801, 'Groenekruisgebied');
INSERT INTO buurt (code, naam) VALUES (9570802, 'Heide');
INSERT INTO buurt (code, naam) VALUES (9570804, 'Asselt');
INSERT INTO buurt (code, naam) VALUES (9570805, 'Martin Giessen-Bosstraat');
INSERT INTO buurt (code, naam) VALUES (9570806, 'Boukoul');
INSERT INTO buurt (code, naam) VALUES (9570809, 'Verspreide huizen Swalmen');
INSERT INTO buurt (code, naam) VALUES (9570900, 'Maasplassen');
INSERT INTO buurt (code, naam) VALUES (9620000, 'Schinnen');
INSERT INTO buurt (code, naam) VALUES (9620001, 'Puth');
INSERT INTO buurt (code, naam) VALUES (9620002, 'Nagelbeek-Hegge');
INSERT INTO buurt (code, naam) VALUES (9620003, 'Sweikhuizen');
INSERT INTO buurt (code, naam) VALUES (9620004, 'Thull');
INSERT INTO buurt (code, naam) VALUES (9620005, 'Hommert (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (9620009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (9620100, 'Amstenrade');
INSERT INTO buurt (code, naam) VALUES (9620101, 'Oirsbeek');
INSERT INTO buurt (code, naam) VALUES (9620102, 'Klein-Doenrade');
INSERT INTO buurt (code, naam) VALUES (9620103, 'Groot-Doenrade');
INSERT INTO buurt (code, naam) VALUES (9650000, 'Simpelveld');
INSERT INTO buurt (code, naam) VALUES (9650001, 'Hulsveld');
INSERT INTO buurt (code, naam) VALUES (9650002, 'Huls');
INSERT INTO buurt (code, naam) VALUES (9650003, 'Molsberg-Rodeput');
INSERT INTO buurt (code, naam) VALUES (9650009, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (9650100, 'Bocholtz');
INSERT INTO buurt (code, naam) VALUES (9650101, 'Bocholtzerheide');
INSERT INTO buurt (code, naam) VALUES (9650102, 'Prickart-Broek');
INSERT INTO buurt (code, naam) VALUES (9650103, 'Baneheide');
INSERT INTO buurt (code, naam) VALUES (9710000, 'Oud-Stein');
INSERT INTO buurt (code, naam) VALUES (9710001, 'Kerensheide');
INSERT INTO buurt (code, naam) VALUES (9710002, 'Nieuwdorp');
INSERT INTO buurt (code, naam) VALUES (9710003, 'Kleine Meers en Veldschuur');
INSERT INTO buurt (code, naam) VALUES (9710004, 'Maasband');
INSERT INTO buurt (code, naam) VALUES (9710005, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (9710100, 'Elsloo');
INSERT INTO buurt (code, naam) VALUES (9710101, 'Meers');
INSERT INTO buurt (code, naam) VALUES (9710102, 'Catsop');
INSERT INTO buurt (code, naam) VALUES (9710200, 'Berg');
INSERT INTO buurt (code, naam) VALUES (9710201, 'Urmond ten westen van Julianakanaal');
INSERT INTO buurt (code, naam) VALUES (9710202, 'Urmond ten oosten van Julianakanaal');
INSERT INTO buurt (code, naam) VALUES (9710203, 'Nattenhoven');
INSERT INTO buurt (code, naam) VALUES (9810000, 'Vijlen');
INSERT INTO buurt (code, naam) VALUES (9810001, 'Mamelis');
INSERT INTO buurt (code, naam) VALUES (9810003, 'Harles');
INSERT INTO buurt (code, naam) VALUES (9810005, 'Lemiers');
INSERT INTO buurt (code, naam) VALUES (9810006, 'Holset');
INSERT INTO buurt (code, naam) VALUES (9810007, 'Raren');
INSERT INTO buurt (code, naam) VALUES (9810008, 'Wolfhaag');
INSERT INTO buurt (code, naam) VALUES (9810009, 'Verspreide huizen Cottessen-Camerig');
INSERT INTO buurt (code, naam) VALUES (9810100, 'Vaals');
INSERT INTO buurt (code, naam) VALUES (9831101, 'Winkelcentrum');
INSERT INTO buurt (code, naam) VALUES (9831102, 'Q4');
INSERT INTO buurt (code, naam) VALUES (9831103, 'Rosarium');
INSERT INTO buurt (code, naam) VALUES (9831104, 'Binnenstad-Noord');
INSERT INTO buurt (code, naam) VALUES (9831201, 'Sinselveld');
INSERT INTO buurt (code, naam) VALUES (9831202, 'Maaswaard');
INSERT INTO buurt (code, naam) VALUES (9831203, 'Spoorsingel');
INSERT INTO buurt (code, naam) VALUES (9831204, 'Hagerbroek');
INSERT INTO buurt (code, naam) VALUES (9831205, 'Hagerhof-oost');
INSERT INTO buurt (code, naam) VALUES (9831206, 'Hagerhof-West');
INSERT INTO buurt (code, naam) VALUES (9831207, 'Wylrehof');
INSERT INTO buurt (code, naam) VALUES (9831208, 'bedrijventerrein Hagerhof');
INSERT INTO buurt (code, naam) VALUES (9831209, 'Onderste en Bovenste Molen');
INSERT INTO buurt (code, naam) VALUES (9831210, 'Krekelveld');
INSERT INTO buurt (code, naam) VALUES (9831301, 'De Tichelarij');
INSERT INTO buurt (code, naam) VALUES (9831302, 'Rijnbeek');
INSERT INTO buurt (code, naam) VALUES (9831303, 'Groenstraat-Noord');
INSERT INTO buurt (code, naam) VALUES (9831304, 'Groenstraat-Zuid');
INSERT INTO buurt (code, naam) VALUES (9831305, 'Stalberg-West');
INSERT INTO buurt (code, naam) VALUES (9831306, 'Groeneveld');
INSERT INTO buurt (code, naam) VALUES (9831307, 'Hogekamp');
INSERT INTO buurt (code, naam) VALUES (9831308, 'Stalberg-Noord');
INSERT INTO buurt (code, naam) VALUES (9831401, 'Craneveld');
INSERT INTO buurt (code, naam) VALUES (9831402, 'Withuis');
INSERT INTO buurt (code, naam) VALUES (9831403, '''t Zand');
INSERT INTO buurt (code, naam) VALUES (9831404, 'Genooybergen');
INSERT INTO buurt (code, naam) VALUES (9831405, 'Genooy');
INSERT INTO buurt (code, naam) VALUES (9831501, 'Vierpaardjes');
INSERT INTO buurt (code, naam) VALUES (9831502, 'Dr. Poelsplein e.o.');
INSERT INTO buurt (code, naam) VALUES (9831503, 'Jezuïtenbuurt');
INSERT INTO buurt (code, naam) VALUES (9831504, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (9831505, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (9831506, 'Casinoflat');
INSERT INTO buurt (code, naam) VALUES (9831507, 'Postwegflat');
INSERT INTO buurt (code, naam) VALUES (9831508, 'Stalberg (midden)');
INSERT INTO buurt (code, naam) VALUES (9831509, 'Stalberg-oost');
INSERT INTO buurt (code, naam) VALUES (9831510, 'Grote Hei');
INSERT INTO buurt (code, naam) VALUES (9831511, 'Keulse Barriére');
INSERT INTO buurt (code, naam) VALUES (9831512, 'Auxillatrix');
INSERT INTO buurt (code, naam) VALUES (9831601, 'Kern ''t Ven');
INSERT INTO buurt (code, naam) VALUES (9831602, 'Arenborg');
INSERT INTO buurt (code, naam) VALUES (9831603, 'Herungerberg');
INSERT INTO buurt (code, naam) VALUES (9831604, 'Veegtes');
INSERT INTO buurt (code, naam) VALUES (9831605, 'Noorderpoort');
INSERT INTO buurt (code, naam) VALUES (9831606, 'Venkoelen');
INSERT INTO buurt (code, naam) VALUES (9831607, 'AZC');
INSERT INTO buurt (code, naam) VALUES (9832101, 'Blerick-Centrum');
INSERT INTO buurt (code, naam) VALUES (9832102, 'gazenkamp');
INSERT INTO buurt (code, naam) VALUES (9832201, 'Smeliënkamp');
INSERT INTO buurt (code, naam) VALUES (9832202, 'Vastenavondkamp-Noord');
INSERT INTO buurt (code, naam) VALUES (9832203, 'Vastenavondkamp-Zuid');
INSERT INTO buurt (code, naam) VALUES (9832301, 'Molenbossen');
INSERT INTO buurt (code, naam) VALUES (9832302, 'Annakamp-Oost');
INSERT INTO buurt (code, naam) VALUES (9832303, 'Annakamp-West');
INSERT INTO buurt (code, naam) VALUES (9832304, 'Zonneveld');
INSERT INTO buurt (code, naam) VALUES (9832401, 'Vossener-Centrum');
INSERT INTO buurt (code, naam) VALUES (9832402, 'Vossener-Noord');
INSERT INTO buurt (code, naam) VALUES (9832403, 'Vossener-West');
INSERT INTO buurt (code, naam) VALUES (9832404, 'Vossener-Zuid');
INSERT INTO buurt (code, naam) VALUES (9832501, 'Klingerberg-Zuid');
INSERT INTO buurt (code, naam) VALUES (9832502, 'Klingerberg-Noord');
INSERT INTO buurt (code, naam) VALUES (9832601, 'Kern Hout-Blerick');
INSERT INTO buurt (code, naam) VALUES (9832602, 'Verspreide huizen Hout-Blerick');
INSERT INTO buurt (code, naam) VALUES (9832603, 'Meuleveld');
INSERT INTO buurt (code, naam) VALUES (9832701, 'Kern Boekend');
INSERT INTO buurt (code, naam) VALUES (9832702, 'Verspreide huizen Boekend');
INSERT INTO buurt (code, naam) VALUES (9832801, 'Horsterweg');
INSERT INTO buurt (code, naam) VALUES (9832802, 'Kazerneterrein');
INSERT INTO buurt (code, naam) VALUES (9832803, 'Ubroek');
INSERT INTO buurt (code, naam) VALUES (9832804, 'Groot Boller');
INSERT INTO buurt (code, naam) VALUES (9832805, 'Havengebied');
INSERT INTO buurt (code, naam) VALUES (9832806, 'Ecopark');
INSERT INTO buurt (code, naam) VALUES (9832807, 'Heierhoeve');
INSERT INTO buurt (code, naam) VALUES (9832808, 'Fresh Park');
INSERT INTO buurt (code, naam) VALUES (9832809, 'Trade-Port-Oost');
INSERT INTO buurt (code, naam) VALUES (9832810, 'Trade-Port-Noord');
INSERT INTO buurt (code, naam) VALUES (9832811, 'Floriade Park');
INSERT INTO buurt (code, naam) VALUES (9832812, 'Zaarderheiken');
INSERT INTO buurt (code, naam) VALUES (9833101, 'Bosserhof');
INSERT INTO buurt (code, naam) VALUES (9833102, 'Tegelen-Centrum');
INSERT INTO buurt (code, naam) VALUES (9833103, 'Krekelsberg');
INSERT INTO buurt (code, naam) VALUES (9833104, 'Maasveld I');
INSERT INTO buurt (code, naam) VALUES (9833105, 'Maasveld II');
INSERT INTO buurt (code, naam) VALUES (9833201, 'Lage Heide');
INSERT INTO buurt (code, naam) VALUES (9833202, 'Bedrijventerrein Windhond');
INSERT INTO buurt (code, naam) VALUES (9833203, 'Kaldenkerkerweg-West');
INSERT INTO buurt (code, naam) VALUES (9833204, 'Op de Heide');
INSERT INTO buurt (code, naam) VALUES (9833205, 'Kaldenkerkerweg-Oost');
INSERT INTO buurt (code, naam) VALUES (9833206, 'Ulingsheid');
INSERT INTO buurt (code, naam) VALUES (9833207, 'Snelle Sprong');
INSERT INTO buurt (code, naam) VALUES (9833501, 'Kloosterdorp');
INSERT INTO buurt (code, naam) VALUES (9833502, 'Nieuw-Steyl');
INSERT INTO buurt (code, naam) VALUES (9834101, 'Velden-West');
INSERT INTO buurt (code, naam) VALUES (9834102, 'Velden-Oost');
INSERT INTO buurt (code, naam) VALUES (9834103, 'Hasselderheide');
INSERT INTO buurt (code, naam) VALUES (9834104, 'Schandelo');
INSERT INTO buurt (code, naam) VALUES (9834105, 'Hasselt en Het Vorst');
INSERT INTO buurt (code, naam) VALUES (9834106, 'De Krosselt');
INSERT INTO buurt (code, naam) VALUES (9834107, 'Verspreide huizen Velden');
INSERT INTO buurt (code, naam) VALUES (9834301, 'Kern Lomm');
INSERT INTO buurt (code, naam) VALUES (9834302, 'Spikweinen');
INSERT INTO buurt (code, naam) VALUES (9834303, 'Verspreide huizen Lomm');
INSERT INTO buurt (code, naam) VALUES (9834401, 'Kern Arcen');
INSERT INTO buurt (code, naam) VALUES (9834402, 'Lingsfort');
INSERT INTO buurt (code, naam) VALUES (9834403, 'Brandemolen en Veld');
INSERT INTO buurt (code, naam) VALUES (9834404, 'Verspreide huizen arcen');
INSERT INTO buurt (code, naam) VALUES (9835101, 'Kern Belfeld');
INSERT INTO buurt (code, naam) VALUES (9835102, 'Gebied patersweg');
INSERT INTO buurt (code, naam) VALUES (9835103, 'Bolenberg');
INSERT INTO buurt (code, naam) VALUES (9835104, 'Aan de Stuw');
INSERT INTO buurt (code, naam) VALUES (9835105, 'Witveld');
INSERT INTO buurt (code, naam) VALUES (9835106, 'Geloérveld / Pannenberg');
INSERT INTO buurt (code, naam) VALUES (9835107, 'Geloö');
INSERT INTO buurt (code, naam) VALUES (9835108, 'Maalbeek');
INSERT INTO buurt (code, naam) VALUES (9841011, 'Venray-Centrum');
INSERT INTO buurt (code, naam) VALUES (9841012, 'Venray-Oost');
INSERT INTO buurt (code, naam) VALUES (9841013, 'Venray-West');
INSERT INTO buurt (code, naam) VALUES (9841014, 'Vlakwater');
INSERT INTO buurt (code, naam) VALUES (9841015, 'Veltum');
INSERT INTO buurt (code, naam) VALUES (9841016, 'Brukske');
INSERT INTO buurt (code, naam) VALUES (9841017, 'Landweert');
INSERT INTO buurt (code, naam) VALUES (9841018, 'Smakterheide');
INSERT INTO buurt (code, naam) VALUES (9841019, 'Brabander');
INSERT INTO buurt (code, naam) VALUES (9841020, 'Sint Antoniusveld');
INSERT INTO buurt (code, naam) VALUES (9842001, 'Heide');
INSERT INTO buurt (code, naam) VALUES (9842002, 'Ysselsteyn');
INSERT INTO buurt (code, naam) VALUES (9842003, 'Merselo');
INSERT INTO buurt (code, naam) VALUES (9842004, 'Vredepeel');
INSERT INTO buurt (code, naam) VALUES (9842005, 'Smakt');
INSERT INTO buurt (code, naam) VALUES (9842006, 'Oostrum');
INSERT INTO buurt (code, naam) VALUES (9842007, 'Oirlo');
INSERT INTO buurt (code, naam) VALUES (9842008, 'Castenray');
INSERT INTO buurt (code, naam) VALUES (9842009, 'Veulen');
INSERT INTO buurt (code, naam) VALUES (9842010, 'Leunen');
INSERT INTO buurt (code, naam) VALUES (9842021, 'Wanssum');
INSERT INTO buurt (code, naam) VALUES (9842022, 'Geysteren');
INSERT INTO buurt (code, naam) VALUES (9842023, 'Blitterswijck');
INSERT INTO buurt (code, naam) VALUES (9860101, 'Voerendaal');
INSERT INTO buurt (code, naam) VALUES (9860102, 'Fromberg');
INSERT INTO buurt (code, naam) VALUES (9860201, 'Kunrade');
INSERT INTO buurt (code, naam) VALUES (9860202, 'Kunderberg');
INSERT INTO buurt (code, naam) VALUES (9860203, 'Winthagen');
INSERT INTO buurt (code, naam) VALUES (9860301, 'Ubachsberg');
INSERT INTO buurt (code, naam) VALUES (9860302, 'Colmont');
INSERT INTO buurt (code, naam) VALUES (9860303, 'Mingersborg');
INSERT INTO buurt (code, naam) VALUES (9860401, 'Klimmen');
INSERT INTO buurt (code, naam) VALUES (9860402, 'Craubeek');
INSERT INTO buurt (code, naam) VALUES (9860403, 'Hellebeek');
INSERT INTO buurt (code, naam) VALUES (9860404, 'Retersbeek');
INSERT INTO buurt (code, naam) VALUES (9860405, 'Termaar');
INSERT INTO buurt (code, naam) VALUES (9860406, 'Weustenrade');
INSERT INTO buurt (code, naam) VALUES (9860501, 'Ransdaal');
INSERT INTO buurt (code, naam) VALUES (9860900, 'Verspreide huizen Voerendaal');
INSERT INTO buurt (code, naam) VALUES (9880101, 'Boshoven-Vrakker');
INSERT INTO buurt (code, naam) VALUES (9880102, 'Oud-Boshoven');
INSERT INTO buurt (code, naam) VALUES (9880103, 'Centrum-Noord');
INSERT INTO buurt (code, naam) VALUES (9880104, 'Boshoven buitengebied');
INSERT INTO buurt (code, naam) VALUES (9880105, 'Industrieterrein Boshoverheide');
INSERT INTO buurt (code, naam) VALUES (9880201, 'Laar');
INSERT INTO buurt (code, naam) VALUES (9880202, 'Hushoven');
INSERT INTO buurt (code, naam) VALUES (9880203, 'Laar buitengebied');
INSERT INTO buurt (code, naam) VALUES (9880204, 'Hulshoven buitengebied');
INSERT INTO buurt (code, naam) VALUES (9880205, 'Laarveld');
INSERT INTO buurt (code, naam) VALUES (9880301, 'Molenakker');
INSERT INTO buurt (code, naam) VALUES (9880302, 'Kampershoek');
INSERT INTO buurt (code, naam) VALUES (9880303, 'Kampershoek-Noord');
INSERT INTO buurt (code, naam) VALUES (9881101, 'Weert-Centrum');
INSERT INTO buurt (code, naam) VALUES (9881102, 'Maaspoort');
INSERT INTO buurt (code, naam) VALUES (9881201, 'Biest');
INSERT INTO buurt (code, naam) VALUES (9881301, 'Groenewoud-Noord');
INSERT INTO buurt (code, naam) VALUES (9881302, 'Groenewoud-Zuid');
INSERT INTO buurt (code, naam) VALUES (9881401, 'Fatima');
INSERT INTO buurt (code, naam) VALUES (9881402, 'Industrieterrein Fatima');
INSERT INTO buurt (code, naam) VALUES (9882101, 'Keent');
INSERT INTO buurt (code, naam) VALUES (9882102, 'Keent buitengebied');
INSERT INTO buurt (code, naam) VALUES (9882201, 'Moesel');
INSERT INTO buurt (code, naam) VALUES (9882202, 'Moesel buitengebied');
INSERT INTO buurt (code, naam) VALUES (9882301, 'Graswinkel');
INSERT INTO buurt (code, naam) VALUES (9882401, 'Leuken');
INSERT INTO buurt (code, naam) VALUES (9882402, 'Industrieterrein Leuken');
INSERT INTO buurt (code, naam) VALUES (9882403, 'Leuken buitengebied');
INSERT INTO buurt (code, naam) VALUES (9882501, 'Kazernelaan');
INSERT INTO buurt (code, naam) VALUES (9882502, 'Industrieterrein Boshoverbeek-Lozerweg');
INSERT INTO buurt (code, naam) VALUES (9883101, 'Altweerterheide');
INSERT INTO buurt (code, naam) VALUES (9883102, 'Altweerterheide buitengebied');
INSERT INTO buurt (code, naam) VALUES (9883201, 'Tungelroy');
INSERT INTO buurt (code, naam) VALUES (9883202, 'Tungelroy buitengebied');
INSERT INTO buurt (code, naam) VALUES (9883301, 'Swartbroek');
INSERT INTO buurt (code, naam) VALUES (9883302, 'Swartbroek buitengebied');
INSERT INTO buurt (code, naam) VALUES (9883401, 'Stramproy');
INSERT INTO buurt (code, naam) VALUES (9883402, 'Stramproy buitengebied');
INSERT INTO buurt (code, naam) VALUES (9940000, 'Valkenburg');
INSERT INTO buurt (code, naam) VALUES (9940001, 'Broekhem-Plenkert');
INSERT INTO buurt (code, naam) VALUES (9940002, 'Stoepert');
INSERT INTO buurt (code, naam) VALUES (9940003, 'Emmaberg');
INSERT INTO buurt (code, naam) VALUES (9940004, 'De Heek (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (9940100, 'Sint Gerlach');
INSERT INTO buurt (code, naam) VALUES (9940101, 'Vroenhof');
INSERT INTO buurt (code, naam) VALUES (9940102, 'Strabeek');
INSERT INTO buurt (code, naam) VALUES (9940109, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (9940200, 'Schin op Geul-Strucht');
INSERT INTO buurt (code, naam) VALUES (9940201, 'Schoonbron');
INSERT INTO buurt (code, naam) VALUES (9940202, 'Oud-Valkenburg');
INSERT INTO buurt (code, naam) VALUES (9940203, 'Walem');
INSERT INTO buurt (code, naam) VALUES (9940209, 'Verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (9940300, 'Sibbe');
INSERT INTO buurt (code, naam) VALUES (9940301, 'IJzeren en Heerstraat');
INSERT INTO buurt (code, naam) VALUES (9940400, 'Berg');
INSERT INTO buurt (code, naam) VALUES (9940401, 'Terblijt');
INSERT INTO buurt (code, naam) VALUES (9940402, 'Vilt');
INSERT INTO buurt (code, naam) VALUES (9951010, 'Kofschip');
INSERT INTO buurt (code, naam) VALUES (9951020, 'Vest-Schans-Stelling');
INSERT INTO buurt (code, naam) VALUES (9951100, 'Lelycentre');
INSERT INTO buurt (code, naam) VALUES (9951110, 'Zuiderzeewijk');
INSERT INTO buurt (code, naam) VALUES (9951120, 'Atolwijk-Oostrandpark');
INSERT INTO buurt (code, naam) VALUES (9951130, 'Bronsweg-Jupiterweg');
INSERT INTO buurt (code, naam) VALUES (9951170, 'Gelderse en Overijsselse Hout');
INSERT INTO buurt (code, naam) VALUES (9951180, 'Oostervaart');
INSERT INTO buurt (code, naam) VALUES (9952210, 'Boeier-Karveel-Golfpark');
INSERT INTO buurt (code, naam) VALUES (9952220, 'Kempenaar-Kogge-Gondel-Schouw');
INSERT INTO buurt (code, naam) VALUES (9952230, 'Punter-Jol-Galjoen-Kuststrook');
INSERT INTO buurt (code, naam) VALUES (9952250, 'Houtribhoogte-Parkhaven');
INSERT INTO buurt (code, naam) VALUES (9952270, 'Golfresort-Zuigerplasbos');
INSERT INTO buurt (code, naam) VALUES (9952710, 'Visvijverbos');
INSERT INTO buurt (code, naam) VALUES (9953000, 'De Hoven - Ziekenhuis');
INSERT INTO buurt (code, naam) VALUES (9953030, 'Grientenij');
INSERT INTO buurt (code, naam) VALUES (9953240, 'Botter-Tjalk-Schoener');
INSERT INTO buurt (code, naam) VALUES (9953310, 'Landstrekenwijk');
INSERT INTO buurt (code, naam) VALUES (9953320, 'Hollandse Hout');
INSERT INTO buurt (code, naam) VALUES (9953350, 'Lelystad-Haven');
INSERT INTO buurt (code, naam) VALUES (9953370, 'Uilenweg');
INSERT INTO buurt (code, naam) VALUES (9953380, 'Noordersluis');
INSERT INTO buurt (code, naam) VALUES (9954410, 'Boswijk');
INSERT INTO buurt (code, naam) VALUES (9954420, 'Waterwijk');
INSERT INTO buurt (code, naam) VALUES (9954430, 'De Landerijen');
INSERT INTO buurt (code, naam) VALUES (9954470, 'Larserplein-Flevohout');
INSERT INTO buurt (code, naam) VALUES (9955000, 'Stadshart');
INSERT INTO buurt (code, naam) VALUES (9956500, 'Waranda Centrum');
INSERT INTO buurt (code, naam) VALUES (9956510, 'Florawijk Noord/West');
INSERT INTO buurt (code, naam) VALUES (9956520, 'Florawijk Zuid/West');
INSERT INTO buurt (code, naam) VALUES (9956530, 'Faunawijk Noord/Oost');
INSERT INTO buurt (code, naam) VALUES (9956540, 'Faunawijk Zuid/Oost');
INSERT INTO buurt (code, naam) VALUES (9956570, 'Hollandse Hout-bos');
INSERT INTO buurt (code, naam) VALUES (9956580, 'Flevopoort');
INSERT INTO buurt (code, naam) VALUES (9957710, 'Plavuizenweg-Visvijverweg');
INSERT INTO buurt (code, naam) VALUES (9957720, 'Edelhertweg-Runderweg');
INSERT INTO buurt (code, naam) VALUES (9957730, 'Dronterweg-Zeeasterweg');
INSERT INTO buurt (code, naam) VALUES (9957740, 'Vlotgrasweg-Natuurpark Lelystad');
INSERT INTO buurt (code, naam) VALUES (9957750, 'Vliegveld');
INSERT INTO buurt (code, naam) VALUES (9957760, 'Vogelweg');
INSERT INTO buurt (code, naam) VALUES (9957770, 'Pijlstaartweg');
INSERT INTO buurt (code, naam) VALUES (9957780, 'Larserpoort');
INSERT INTO buurt (code, naam) VALUES (9957790, 'Oostvaardersplassen');
INSERT INTO buurt (code, naam) VALUES (9959997, '');
INSERT INTO buurt (code, naam) VALUES (15070000, 'Griendtsveen');
INSERT INTO buurt (code, naam) VALUES (15070009, 'Verspreide huizen Griendtsveen');
INSERT INTO buurt (code, naam) VALUES (15070100, 'America');
INSERT INTO buurt (code, naam) VALUES (15070101, 'Meerdal');
INSERT INTO buurt (code, naam) VALUES (15070102, 'Loohorst');
INSERT INTO buurt (code, naam) VALUES (15070109, 'Verspreide huizen America');
INSERT INTO buurt (code, naam) VALUES (15070200, 'Meterik');
INSERT INTO buurt (code, naam) VALUES (15070209, 'Verspreide huizen Meterik');
INSERT INTO buurt (code, naam) VALUES (15070300, 'Hegelsom');
INSERT INTO buurt (code, naam) VALUES (15070309, 'Verspreide huizen Hegelsom');
INSERT INTO buurt (code, naam) VALUES (15070400, 'Horst-Centrum');
INSERT INTO buurt (code, naam) VALUES (15070401, 'Molenveld');
INSERT INTO buurt (code, naam) VALUES (15070402, 'De Riet');
INSERT INTO buurt (code, naam) VALUES (15070403, 'Weisterbeek');
INSERT INTO buurt (code, naam) VALUES (15070404, 'Nieuwstraat');
INSERT INTO buurt (code, naam) VALUES (15070405, 'Kapellerhof');
INSERT INTO buurt (code, naam) VALUES (15070406, 'Berkelsbroek');
INSERT INTO buurt (code, naam) VALUES (15070407, 'Stuksbeemden');
INSERT INTO buurt (code, naam) VALUES (15070408, 'De Risselt');
INSERT INTO buurt (code, naam) VALUES (15070409, 'De Afhang');
INSERT INTO buurt (code, naam) VALUES (15070410, 'Hoogveld');
INSERT INTO buurt (code, naam) VALUES (15070419, 'Verspreide huizen Horst');
INSERT INTO buurt (code, naam) VALUES (15070500, 'Melderslo');
INSERT INTO buurt (code, naam) VALUES (15070509, 'Verspreide huizen Melderslo');
INSERT INTO buurt (code, naam) VALUES (15070600, 'Broekhuizenvorst');
INSERT INTO buurt (code, naam) VALUES (15070609, 'Verspreide huizen Broekhuizenvorst');
INSERT INTO buurt (code, naam) VALUES (15070700, 'Lottum');
INSERT INTO buurt (code, naam) VALUES (15070709, 'Verspreide huizen Lottum');
INSERT INTO buurt (code, naam) VALUES (15070800, 'Grubbenvorst-Centrum');
INSERT INTO buurt (code, naam) VALUES (15070801, 'De Comert');
INSERT INTO buurt (code, naam) VALUES (15070802, '''t Reuvelt');
INSERT INTO buurt (code, naam) VALUES (15070803, 'Middelreuvelt');
INSERT INTO buurt (code, naam) VALUES (15070804, 'Tuinhaversveld');
INSERT INTO buurt (code, naam) VALUES (15070809, 'Verspreide huizen Grubbenvorst');
INSERT INTO buurt (code, naam) VALUES (15070900, 'Broekhuizen');
INSERT INTO buurt (code, naam) VALUES (15070909, 'Verspreide huizen Broekhuizen');
INSERT INTO buurt (code, naam) VALUES (15071000, 'Sevenum');
INSERT INTO buurt (code, naam) VALUES (15071001, 'De Schatberg');
INSERT INTO buurt (code, naam) VALUES (15071009, 'Verspreide huizen Sevenum');
INSERT INTO buurt (code, naam) VALUES (15071100, 'Kronenberg');
INSERT INTO buurt (code, naam) VALUES (15071109, 'Verspreide huizen Kronenberg');
INSERT INTO buurt (code, naam) VALUES (15071200, 'Everstoord');
INSERT INTO buurt (code, naam) VALUES (15071209, 'Verspreide huizen Eversoord');
INSERT INTO buurt (code, naam) VALUES (15071300, 'Meerlo');
INSERT INTO buurt (code, naam) VALUES (15071309, 'Verspreide huizen Meerlo');
INSERT INTO buurt (code, naam) VALUES (15071400, 'Tienray');
INSERT INTO buurt (code, naam) VALUES (15071409, 'Verspreide huizen Tienray');
INSERT INTO buurt (code, naam) VALUES (15071500, 'Swolgen');
INSERT INTO buurt (code, naam) VALUES (15071509, 'Verspreide huizen Swolgen');
INSERT INTO buurt (code, naam) VALUES (15090000, 'Ulft-Centrum en Ulft-Oost');
INSERT INTO buurt (code, naam) VALUES (15090001, 'Ulft-West');
INSERT INTO buurt (code, naam) VALUES (15090002, 'Ulft-Noord');
INSERT INTO buurt (code, naam) VALUES (15090003, 'Etten');
INSERT INTO buurt (code, naam) VALUES (15090004, 'Varsselder en Veldhunten');
INSERT INTO buurt (code, naam) VALUES (15090007, 'Verspreide huizen Varsselder');
INSERT INTO buurt (code, naam) VALUES (15090008, 'Verspreide huizen Etten');
INSERT INTO buurt (code, naam) VALUES (15090009, 'Verspreide huizen Ulft');
INSERT INTO buurt (code, naam) VALUES (15090100, 'Gendringen');
INSERT INTO buurt (code, naam) VALUES (15090101, 'Megchelen');
INSERT INTO buurt (code, naam) VALUES (15090102, 'Netterden');
INSERT INTO buurt (code, naam) VALUES (15090103, 'Milt en Wieken');
INSERT INTO buurt (code, naam) VALUES (15090104, 'Breedenbroek');
INSERT INTO buurt (code, naam) VALUES (15090105, 'Verspreide huizen Megchelen');
INSERT INTO buurt (code, naam) VALUES (15090106, 'Verspreide huizen Gendringen');
INSERT INTO buurt (code, naam) VALUES (15090107, 'Verspreide huizen Netterden');
INSERT INTO buurt (code, naam) VALUES (15090108, 'Verspreide huizen Voorst');
INSERT INTO buurt (code, naam) VALUES (15090109, 'Verspreide huizen Breedenbroek');
INSERT INTO buurt (code, naam) VALUES (15090200, 'Terborg');
INSERT INTO buurt (code, naam) VALUES (15090201, 'Terborg-Oost');
INSERT INTO buurt (code, naam) VALUES (15090202, 'Silvolde');
INSERT INTO buurt (code, naam) VALUES (15090203, 'Nieuwdorp Bontebrug');
INSERT INTO buurt (code, naam) VALUES (15090207, 'Verspreide huizen Terborg en Heuven');
INSERT INTO buurt (code, naam) VALUES (15090208, 'Verspreide huizen Silvolde');
INSERT INTO buurt (code, naam) VALUES (15090300, 'Varsseveld');
INSERT INTO buurt (code, naam) VALUES (15090301, 'Westendorp');
INSERT INTO buurt (code, naam) VALUES (15090302, 'Sinderen');
INSERT INTO buurt (code, naam) VALUES (15090303, 'Heelweg');
INSERT INTO buurt (code, naam) VALUES (15090306, 'Verspreide huizen Westendorp');
INSERT INTO buurt (code, naam) VALUES (15090307, 'Verspreide huizen Heelweg');
INSERT INTO buurt (code, naam) VALUES (15090308, 'Verspreide huizen Varsseveld');
INSERT INTO buurt (code, naam) VALUES (15090309, 'Verspreide huizen Sinderen');
INSERT INTO buurt (code, naam) VALUES (15250000, 'Sassenheim');
INSERT INTO buurt (code, naam) VALUES (15250009, 'Verspreide huizen Sassenheim');
INSERT INTO buurt (code, naam) VALUES (15250100, 'Voorhout');
INSERT INTO buurt (code, naam) VALUES (15250101, 'Toegangsweg');
INSERT INTO buurt (code, naam) VALUES (15250102, '''s-Gravendamseweg');
INSERT INTO buurt (code, naam) VALUES (15250103, 'Hoogh Teylingen');
INSERT INTO buurt (code, naam) VALUES (15250107, 'Oosthout');
INSERT INTO buurt (code, naam) VALUES (15250109, 'Verspreide huizen Voorhout');
INSERT INTO buurt (code, naam) VALUES (15250200, 'Warmond');
INSERT INTO buurt (code, naam) VALUES (15250201, 'Oosteinde');
INSERT INTO buurt (code, naam) VALUES (15250209, 'Verspreide huizen Warmond');
INSERT INTO buurt (code, naam) VALUES (15810000, 'Doorn-Centrum');
INSERT INTO buurt (code, naam) VALUES (15810001, 'Oudeweg');
INSERT INTO buurt (code, naam) VALUES (15810002, 'Doorn-West');
INSERT INTO buurt (code, naam) VALUES (15810003, 'Doorn-Zuid');
INSERT INTO buurt (code, naam) VALUES (15810004, 'De Wijngaard');
INSERT INTO buurt (code, naam) VALUES (15810007, 'Verspreide huizen op de Heuvelrug-Oost');
INSERT INTO buurt (code, naam) VALUES (15810008, 'Verspreide huizen op de Heuvelrug-West');
INSERT INTO buurt (code, naam) VALUES (15810009, 'Verspreide huizen in het Lage Land');
INSERT INTO buurt (code, naam) VALUES (15810101, 'Landelijk Gebied noordzijde');
INSERT INTO buurt (code, naam) VALUES (15810102, 'Landelijk Gebied zuidzijde');
INSERT INTO buurt (code, naam) VALUES (15810103, 'Driebergen-Noord');
INSERT INTO buurt (code, naam) VALUES (15810104, 'Drift-Sportlaan en Bornia');
INSERT INTO buurt (code, naam) VALUES (15810105, 'Loolaankwartier en Beukenstein');
INSERT INTO buurt (code, naam) VALUES (15810106, 'Kom Driebergen en Seminarie');
INSERT INTO buurt (code, naam) VALUES (15810107, 'Hoenderdaal en Emmalaan');
INSERT INTO buurt (code, naam) VALUES (15810108, 'Wildbaan-Dennenburg');
INSERT INTO buurt (code, naam) VALUES (15810109, 'Welgelegen-Rosarium');
INSERT INTO buurt (code, naam) VALUES (15810110, 'De Horst en De Akker');
INSERT INTO buurt (code, naam) VALUES (15810200, 'Leersum');
INSERT INTO buurt (code, naam) VALUES (15810201, 'Breedeveen');
INSERT INTO buurt (code, naam) VALUES (15810207, 'Verspreide huizen in het Lage Gebied Darthuizen');
INSERT INTO buurt (code, naam) VALUES (15810208, 'Verspreide huizen op de Heuvelrug');
INSERT INTO buurt (code, naam) VALUES (15810209, 'Verspreide huizen in de Geldersche Vallei Overberg');
INSERT INTO buurt (code, naam) VALUES (15810300, 'Amerongen');
INSERT INTO buurt (code, naam) VALUES (15810302, 'Verspreide huizen Overberg en De Haar');
INSERT INTO buurt (code, naam) VALUES (15810308, 'Verspreide huizen Heuvelrug');
INSERT INTO buurt (code, naam) VALUES (15810309, 'Verspreide huizen Lekdijk');
INSERT INTO buurt (code, naam) VALUES (15810400, 'Maarn waaronder Klein Amsterdam');
INSERT INTO buurt (code, naam) VALUES (15810402, 'Maarsbergen');
INSERT INTO buurt (code, naam) VALUES (15810403, 'Valkenheide');
INSERT INTO buurt (code, naam) VALUES (15810408, 'Verspreide huizen op de Heuvelrug');
INSERT INTO buurt (code, naam) VALUES (15810409, 'Verspreide huizen in de Geldersche Vallei');
INSERT INTO buurt (code, naam) VALUES (15860101, '''t Zand');
INSERT INTO buurt (code, naam) VALUES (15860102, 'Schatberg');
INSERT INTO buurt (code, naam) VALUES (15860103, 'Den Esch');
INSERT INTO buurt (code, naam) VALUES (15860104, 'Hooiland');
INSERT INTO buurt (code, naam) VALUES (15860105, 'Centrum');
INSERT INTO buurt (code, naam) VALUES (15860106, 'Veld Oost');
INSERT INTO buurt (code, naam) VALUES (15860107, 'Veld West');
INSERT INTO buurt (code, naam) VALUES (15860108, 'Broek');
INSERT INTO buurt (code, naam) VALUES (15860109, 'Broekdijk');
INSERT INTO buurt (code, naam) VALUES (15860110, 'Zuid-West');
INSERT INTO buurt (code, naam) VALUES (15860111, 'Flierbeek');
INSERT INTO buurt (code, naam) VALUES (15860112, 'Lindebrook');
INSERT INTO buurt (code, naam) VALUES (15860113, 'Nieuwe Kamp');
INSERT INTO buurt (code, naam) VALUES (15860114, 'Oude Kamp');
INSERT INTO buurt (code, naam) VALUES (15860115, 'De Kamp Zuid');
INSERT INTO buurt (code, naam) VALUES (15860116, 'Buitengebied Lichtenvoorde');
INSERT INTO buurt (code, naam) VALUES (15860201, 'Bebouwde kom Harreveld');
INSERT INTO buurt (code, naam) VALUES (15860202, 'Buitengebied Harreveld');
INSERT INTO buurt (code, naam) VALUES (15860301, 'Bebouwde kom Zieuwent');
INSERT INTO buurt (code, naam) VALUES (15860302, 'Buitengebied Zieuwent');
INSERT INTO buurt (code, naam) VALUES (15860401, 'Bebouwde kom Lievelde');
INSERT INTO buurt (code, naam) VALUES (15860402, 'Buitengebied Lievelde');
INSERT INTO buurt (code, naam) VALUES (15860501, 'Bebouwde kom Vragender');
INSERT INTO buurt (code, naam) VALUES (15860502, 'Buitengebied Vragender');
INSERT INTO buurt (code, naam) VALUES (15860601, 'Binnenstad Groenlo');
INSERT INTO buurt (code, naam) VALUES (15860602, 'Het Blik');
INSERT INTO buurt (code, naam) VALUES (15860603, 'Noord-West');
INSERT INTO buurt (code, naam) VALUES (15860604, 'Banninghof');
INSERT INTO buurt (code, naam) VALUES (15860605, 'Papendijk');
INSERT INTO buurt (code, naam) VALUES (15860606, 'hartreize');
INSERT INTO buurt (code, naam) VALUES (15860607, 'Groenlo-Zuid');
INSERT INTO buurt (code, naam) VALUES (15860608, 'Marveld');
INSERT INTO buurt (code, naam) VALUES (15860609, 'Bedrijventerrein Brandemat');
INSERT INTO buurt (code, naam) VALUES (15860610, 'Oosteres');
INSERT INTO buurt (code, naam) VALUES (15860611, 'Noordrand');
INSERT INTO buurt (code, naam) VALUES (15860612, 'IndustrieterreinDen Sliem');
INSERT INTO buurt (code, naam) VALUES (15860613, 'Industrieterrein Laarberg');
INSERT INTO buurt (code, naam) VALUES (15860614, 'Zwolle');
INSERT INTO buurt (code, naam) VALUES (15860615, 'Buitengebied Groenlo');
INSERT INTO buurt (code, naam) VALUES (15860701, 'Bebowde kom Marienvelde');
INSERT INTO buurt (code, naam) VALUES (15860702, 'Buitengebied Marienvelde');
INSERT INTO buurt (code, naam) VALUES (15980001, 'De Goorn');
INSERT INTO buurt (code, naam) VALUES (15980002, 'Berkhout');
INSERT INTO buurt (code, naam) VALUES (15980003, 'Bobeldijk');
INSERT INTO buurt (code, naam) VALUES (15980100, 'Spierdijk');
INSERT INTO buurt (code, naam) VALUES (15980200, 'Zuidermeer en omgeving');
INSERT INTO buurt (code, naam) VALUES (15980300, 'Ursem-Centrum');
INSERT INTO buurt (code, naam) VALUES (15980301, 'Rustenburg');
INSERT INTO buurt (code, naam) VALUES (15980308, 'Noorddijk en omgeving');
INSERT INTO buurt (code, naam) VALUES (15980309, 'Mijzer polder');
INSERT INTO buurt (code, naam) VALUES (15980400, 'Avenhorn');
INSERT INTO buurt (code, naam) VALUES (15980401, 'Scharwoude');
INSERT INTO buurt (code, naam) VALUES (15980402, 'Grosthuizen');
INSERT INTO buurt (code, naam) VALUES (15980500, 'Oudendijk');
INSERT INTO buurt (code, naam) VALUES (15980600, 'Obdam');
INSERT INTO buurt (code, naam) VALUES (15980608, 'Verspreide huizen langs Obdammerdijk');
INSERT INTO buurt (code, naam) VALUES (15980609, 'Verspreide huizen in Berkmeer polder');
INSERT INTO buurt (code, naam) VALUES (15980700, 'Hensbroek');
INSERT INTO buurt (code, naam) VALUES (15980701, 'Wogmeer');
INSERT INTO buurt (code, naam) VALUES (15989997, '');
INSERT INTO buurt (code, naam) VALUES (16211111, 'Dorp Bergschenhoek');
INSERT INTO buurt (code, naam) VALUES (16211121, 'De Driehoek');
INSERT INTO buurt (code, naam) VALUES (16211211, 'Bergsche Ackers');
INSERT INTO buurt (code, naam) VALUES (16211221, 'Oosteindsche Ackers');
INSERT INTO buurt (code, naam) VALUES (16211231, 'Ackerse Zoom');
INSERT INTO buurt (code, naam) VALUES (16211311, 'Beemdenbuurt');
INSERT INTO buurt (code, naam) VALUES (16211321, 'Eilandenbuurt');
INSERT INTO buurt (code, naam) VALUES (16211331, 'Boterdorpse Zoom');
INSERT INTO buurt (code, naam) VALUES (16211411, 'Wilderszijde');
INSERT INTO buurt (code, naam) VALUES (16211514, 'Bergse Nos');
INSERT INTO buurt (code, naam) VALUES (16211522, 'Schreyracker');
INSERT INTO buurt (code, naam) VALUES (16211531, 'Hoeksekade');
INSERT INTO buurt (code, naam) VALUES (16211543, 'Weg en Land');
INSERT INTO buurt (code, naam) VALUES (16211552, 'Warmoeziersweg');
INSERT INTO buurt (code, naam) VALUES (16212111, 'Berkel Dorp');
INSERT INTO buurt (code, naam) VALUES (16212121, 'Parkbuurt');
INSERT INTO buurt (code, naam) VALUES (16212131, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (16212144, 'Annie M.G. Schmidtpark Midden');
INSERT INTO buurt (code, naam) VALUES (16212211, 'Bomen- en Struikenbuurt');
INSERT INTO buurt (code, naam) VALUES (16212221, 'Sterrenbuurt');
INSERT INTO buurt (code, naam) VALUES (16212231, 'Edelsteenbuurt');
INSERT INTO buurt (code, naam) VALUES (16212241, 'Componistenbuurt');
INSERT INTO buurt (code, naam) VALUES (16212254, 'Annie M.G. Schmidtpark Noord');
INSERT INTO buurt (code, naam) VALUES (16212311, 'Merenbuurt');
INSERT INTO buurt (code, naam) VALUES (16212321, 'Rivierenbuurt');
INSERT INTO buurt (code, naam) VALUES (16212331, 'Havenbuurt');
INSERT INTO buurt (code, naam) VALUES (16212412, 'Noordeinde');
INSERT INTO buurt (code, naam) VALUES (16212511, 'Bloemenbuurt');
INSERT INTO buurt (code, naam) VALUES (16212521, 'Parc Rodenrijs');
INSERT INTO buurt (code, naam) VALUES (16212531, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (16212541, 'Weidebloembuurt');
INSERT INTO buurt (code, naam) VALUES (16212611, 'Rodenrijse Zoom');
INSERT INTO buurt (code, naam) VALUES (16212621, 'Bonfut');
INSERT INTO buurt (code, naam) VALUES (16212633, 'Berkelse Poort');
INSERT INTO buurt (code, naam) VALUES (16212644, 'Annie M.G. Schmidtpark Zuid');
INSERT INTO buurt (code, naam) VALUES (16212711, 'Bolwerk');
INSERT INTO buurt (code, naam) VALUES (16212721, 'Gouden Griffelbuurt');
INSERT INTO buurt (code, naam) VALUES (16212731, 'Gouden Uilbuurt');
INSERT INTO buurt (code, naam) VALUES (16212741, 'Buurt 2741');
INSERT INTO buurt (code, naam) VALUES (16212814, 'Vlinderstrik');
INSERT INTO buurt (code, naam) VALUES (16212823, 'Spoorhaven');
INSERT INTO buurt (code, naam) VALUES (16212833, 'Bedrijventerrein Rodenrijs');
INSERT INTO buurt (code, naam) VALUES (16212843, 'Oudeland');
INSERT INTO buurt (code, naam) VALUES (16212851, 'Buurt 2851');
INSERT INTO buurt (code, naam) VALUES (16212864, 'Bergboezem');
INSERT INTO buurt (code, naam) VALUES (16213111, 'Schildersbuurt');
INSERT INTO buurt (code, naam) VALUES (16213121, 'Zeeheldenbuurt');
INSERT INTO buurt (code, naam) VALUES (16213133, 'De Hoefslag');
INSERT INTO buurt (code, naam) VALUES (16213141, 'Oranjebuurt');
INSERT INTO buurt (code, naam) VALUES (16213162, 'Zeldenrust');
INSERT INTO buurt (code, naam) VALUES (16213211, 'Molenbuurt');
INSERT INTO buurt (code, naam) VALUES (16213221, 'Sterrenbuurt');
INSERT INTO buurt (code, naam) VALUES (16213231, 'Bomenbuurt');
INSERT INTO buurt (code, naam) VALUES (16213242, 'Merenveld');
INSERT INTO buurt (code, naam) VALUES (16213251, 'Vogelbuurt');
INSERT INTO buurt (code, naam) VALUES (16213261, 'De Tuinen');
INSERT INTO buurt (code, naam) VALUES (16213312, 'Overbuurtse Polder');
INSERT INTO buurt (code, naam) VALUES (16213323, 'Klappolder');
INSERT INTO buurt (code, naam) VALUES (16213334, 'Rotte Zoom');
INSERT INTO buurt (code, naam) VALUES (16213344, 'Kruisweg');
INSERT INTO buurt (code, naam) VALUES (16213353, 'Prisma');
INSERT INTO buurt (code, naam) VALUES (16400000, 'Kern Heythuysen');
INSERT INTO buurt (code, naam) VALUES (16400001, 'Verspreide huizen Heythuysen');
INSERT INTO buurt (code, naam) VALUES (16400100, 'Kern Heibloem');
INSERT INTO buurt (code, naam) VALUES (16400101, 'Verspreide huizen Heibloem');
INSERT INTO buurt (code, naam) VALUES (16400200, 'Kern Roggel');
INSERT INTO buurt (code, naam) VALUES (16400201, 'Verspreide huizen Roggel');
INSERT INTO buurt (code, naam) VALUES (16400300, 'Kern Neer');
INSERT INTO buurt (code, naam) VALUES (16400301, 'Verspreide huizen Neer');
INSERT INTO buurt (code, naam) VALUES (16400400, 'Kern Nunhem');
INSERT INTO buurt (code, naam) VALUES (16400401, 'Verspreide huizen Nunhem');
INSERT INTO buurt (code, naam) VALUES (16400500, 'Kern Haelen');
INSERT INTO buurt (code, naam) VALUES (16400501, 'Verspreide huizen Haelen');
INSERT INTO buurt (code, naam) VALUES (16400600, 'Kern Buggenum');
INSERT INTO buurt (code, naam) VALUES (16400601, 'Verspreide huizen Buggenum');
INSERT INTO buurt (code, naam) VALUES (16400700, 'Kern Horn');
INSERT INTO buurt (code, naam) VALUES (16400701, 'Verspreide huizen Horn');
INSERT INTO buurt (code, naam) VALUES (16400800, 'Kern Baexem');
INSERT INTO buurt (code, naam) VALUES (16400801, 'Verspreide huizen Baexem');
INSERT INTO buurt (code, naam) VALUES (16400900, 'Kern Kelpen-Oler');
INSERT INTO buurt (code, naam) VALUES (16400901, 'Verspreide huizen Kelpen-Oler');
INSERT INTO buurt (code, naam) VALUES (16401000, 'Kern Grathem');
INSERT INTO buurt (code, naam) VALUES (16401001, 'Verspreide huizen Grathem');
INSERT INTO buurt (code, naam) VALUES (16401100, 'Kern Ell');
INSERT INTO buurt (code, naam) VALUES (16401101, 'Verspreide huizen Ell');
INSERT INTO buurt (code, naam) VALUES (16401200, 'Kern Haler');
INSERT INTO buurt (code, naam) VALUES (16401201, 'Verspreide huizen Haler');
INSERT INTO buurt (code, naam) VALUES (16401300, 'Kern Hunsel');
INSERT INTO buurt (code, naam) VALUES (16401301, 'Verspreide huizen Hunsel');
INSERT INTO buurt (code, naam) VALUES (16401400, 'Kern Neeritter');
INSERT INTO buurt (code, naam) VALUES (16401401, 'Verspreide huizen Neeritter');
INSERT INTO buurt (code, naam) VALUES (16401500, 'Kern Ittervoort');
INSERT INTO buurt (code, naam) VALUES (16401501, 'Verspreide huizen Ittervoort');
INSERT INTO buurt (code, naam) VALUES (16410000, 'Maasbracht');
INSERT INTO buurt (code, naam) VALUES (16410001, 'Brachterbeek');
INSERT INTO buurt (code, naam) VALUES (16410009, 'Verspreide huizen Het Vonderen');
INSERT INTO buurt (code, naam) VALUES (16410100, 'Linne');
INSERT INTO buurt (code, naam) VALUES (16410109, 'Verspreide huizen Linnerveld en Weerd');
INSERT INTO buurt (code, naam) VALUES (16410200, 'Stevensweert waaronder Bilt');
INSERT INTO buurt (code, naam) VALUES (16410201, 'Eiland-Brandt');
INSERT INTO buurt (code, naam) VALUES (16410300, 'Laak');
INSERT INTO buurt (code, naam) VALUES (16410301, 'Ohé');
INSERT INTO buurt (code, naam) VALUES (16410400, 'Thorn');
INSERT INTO buurt (code, naam) VALUES (16410409, 'Verspreide huizen Thorn');
INSERT INTO buurt (code, naam) VALUES (16410500, 'Heel');
INSERT INTO buurt (code, naam) VALUES (16410501, 'Panheel');
INSERT INTO buurt (code, naam) VALUES (16410509, 'Verspreide huizen Heel');
INSERT INTO buurt (code, naam) VALUES (16410600, 'Beegden');
INSERT INTO buurt (code, naam) VALUES (16410700, 'Wessem');
INSERT INTO buurt (code, naam) VALUES (16510001, 'Uithuizen');
INSERT INTO buurt (code, naam) VALUES (16510002, '''t Lage van de Weg');
INSERT INTO buurt (code, naam) VALUES (16510008, 'Verspreide huizen in de nieuwe polders');
INSERT INTO buurt (code, naam) VALUES (16510009, 'Overige verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (16510100, 'Uithuizermeeden');
INSERT INTO buurt (code, naam) VALUES (16510101, 'Oosternieland');
INSERT INTO buurt (code, naam) VALUES (16510102, 'Roodeschool');
INSERT INTO buurt (code, naam) VALUES (16510103, 'Oosteinde');
INSERT INTO buurt (code, naam) VALUES (16510104, 'Hooilandseweg');
INSERT INTO buurt (code, naam) VALUES (16510105, 'Hefswal');
INSERT INTO buurt (code, naam) VALUES (16510106, 'Oudeschip');
INSERT INTO buurt (code, naam) VALUES (16510107, 'Oldenzijl');
INSERT INTO buurt (code, naam) VALUES (16510108, 'Eemshavengebied');
INSERT INTO buurt (code, naam) VALUES (16510109, 'Verspreide huizen Uithuizermeeden');
INSERT INTO buurt (code, naam) VALUES (16510200, 'Kantens');
INSERT INTO buurt (code, naam) VALUES (16510201, 'Zandeweer');
INSERT INTO buurt (code, naam) VALUES (16510202, 'Rottum');
INSERT INTO buurt (code, naam) VALUES (16510203, 'Stitswerd');
INSERT INTO buurt (code, naam) VALUES (16510204, 'Doodstil');
INSERT INTO buurt (code, naam) VALUES (16510205, 'Eppenhuizen');
INSERT INTO buurt (code, naam) VALUES (16510206, 'Garsthuizen (gedeeltelijk)');
INSERT INTO buurt (code, naam) VALUES (16510209, 'Verspreide huizen Kantens');
INSERT INTO buurt (code, naam) VALUES (16510300, 'Usquert');
INSERT INTO buurt (code, naam) VALUES (16510308, 'Verspreide huizen in de nieuwe polders');
INSERT INTO buurt (code, naam) VALUES (16510309, 'Overige verspreide huizen');
INSERT INTO buurt (code, naam) VALUES (16510400, 'Warffum');
INSERT INTO buurt (code, naam) VALUES (16510409, 'Verspreide huizen Warffum');
INSERT INTO buurt (code, naam) VALUES (16519998, '');
INSERT INTO buurt (code, naam) VALUES (16520000, 'Gemert-Centrum');
INSERT INTO buurt (code, naam) VALUES (16520001, 'Gemert-Noord');
INSERT INTO buurt (code, naam) VALUES (16520002, 'Gemert-Oost');
INSERT INTO buurt (code, naam) VALUES (16520003, 'Industrieterrein Scheiweg');
INSERT INTO buurt (code, naam) VALUES (16520004, 'Doonheide');
INSERT INTO buurt (code, naam) VALUES (16520007, 'Verspreide huizen Kampen-Esdonk');
INSERT INTO buurt (code, naam) VALUES (16520008, 'Verspreide huizen Broekkant');
INSERT INTO buurt (code, naam) VALUES (16520009, 'Verspreide huizen Rooije Hoef');
INSERT INTO buurt (code, naam) VALUES (16520100, 'Handel');
INSERT INTO buurt (code, naam) VALUES (16520108, 'Verspreide huizen Verreheide');
INSERT INTO buurt (code, naam) VALUES (16520109, 'Verspreide huizen Heereveld');
INSERT INTO buurt (code, naam) VALUES (16520200, 'De Mortel');
INSERT INTO buurt (code, naam) VALUES (16520208, 'Verspreide huizen Milschot-Tereyken');
INSERT INTO buurt (code, naam) VALUES (16520209, 'Verspreide huizen Mortelse Peel');
INSERT INTO buurt (code, naam) VALUES (16520300, 'Elsendorp');
INSERT INTO buurt (code, naam) VALUES (16520309, 'Verspreide huizen Elsendorp');
INSERT INTO buurt (code, naam) VALUES (16520400, 'Bakel');
INSERT INTO buurt (code, naam) VALUES (16520408, 'Verspreide huizen Grotelse Heide en Esp');
INSERT INTO buurt (code, naam) VALUES (16520409, 'Verspreide huizen ten zuidwesten van Bakel');
INSERT INTO buurt (code, naam) VALUES (16520500, 'Milheeze');
INSERT INTO buurt (code, naam) VALUES (16520508, 'Verspreide huizen Groote Peel');
INSERT INTO buurt (code, naam) VALUES (16520509, 'Verspreide huizen Milheeze');
INSERT INTO buurt (code, naam) VALUES (16520600, 'De Rips');
INSERT INTO buurt (code, naam) VALUES (16520609, 'Verspreide huizen Rips');
INSERT INTO buurt (code, naam) VALUES (16550101, 'Oud Gastel');
INSERT INTO buurt (code, naam) VALUES (16550102, 'Stoof');
INSERT INTO buurt (code, naam) VALUES (16550109, 'Verspreide huizen Oud Gastel');
INSERT INTO buurt (code, naam) VALUES (16550201, 'Stampersgat');
INSERT INTO buurt (code, naam) VALUES (16550209, 'Verspreide huizen Stampersgat');
INSERT INTO buurt (code, naam) VALUES (16550301, 'Oudenbosch-Centrum');
INSERT INTO buurt (code, naam) VALUES (16550302, 'Pagnevaart');
INSERT INTO buurt (code, naam) VALUES (16550303, 'Velletri');
INSERT INTO buurt (code, naam) VALUES (16550304, 'Spui');
INSERT INTO buurt (code, naam) VALUES (16550305, 'Albano');
INSERT INTO buurt (code, naam) VALUES (16550307, 'Verspreide huizen Kuivezand en omgeving');
INSERT INTO buurt (code, naam) VALUES (16550308, 'Verspreide huizen ten noorden van Oudenbosch');
INSERT INTO buurt (code, naam) VALUES (16550309, 'Verspreide huizen ten zuiden van Oudenbosch');
INSERT INTO buurt (code, naam) VALUES (16550401, 'Hoeven');
INSERT INTO buurt (code, naam) VALUES (16550402, 'Achter ''t Hof');
INSERT INTO buurt (code, naam) VALUES (16550403, 'Kruisstraat');
INSERT INTO buurt (code, naam) VALUES (16550408, 'Verspreide huizen ten zuiden van Hoeven');
INSERT INTO buurt (code, naam) VALUES (16550409, 'Verspreide huizen ten noorden van Hoeven');
INSERT INTO buurt (code, naam) VALUES (16550501, 'Bosschenhoofd');
INSERT INTO buurt (code, naam) VALUES (16550509, 'Verspreide huizen Bosschenhoofd');
INSERT INTO buurt (code, naam) VALUES (16580000, 'Heeze');
INSERT INTO buurt (code, naam) VALUES (16580001, 'Bedrijventerrein De Poortmannen');
INSERT INTO buurt (code, naam) VALUES (16580009, 'Verspreide huizen Heeze');
INSERT INTO buurt (code, naam) VALUES (16580100, 'Leende');
INSERT INTO buurt (code, naam) VALUES (16580101, 'Villawijk Boschhoven');
INSERT INTO buurt (code, naam) VALUES (16580108, 'Verspreide huizen Groote Heide');
INSERT INTO buurt (code, naam) VALUES (16580109, 'Verspreide huizen Zevenhuizense Heide');
INSERT INTO buurt (code, naam) VALUES (16580200, 'Leenderstrijp');
INSERT INTO buurt (code, naam) VALUES (16580209, 'Verspreide huizen Dijkse Heide');
INSERT INTO buurt (code, naam) VALUES (16580300, 'Sterksel');
INSERT INTO buurt (code, naam) VALUES (16580308, 'Verspreide huizen ten zuiden van Sterksel');
INSERT INTO buurt (code, naam) VALUES (16580309, 'Verspreide huizen ten oosten van Sterksel');
INSERT INTO buurt (code, naam) VALUES (16590000, 'Beek');
INSERT INTO buurt (code, naam) VALUES (16590001, 'Donk');
INSERT INTO buurt (code, naam) VALUES (16590002, 'Bedrijventerrein Beekerheide');
INSERT INTO buurt (code, naam) VALUES (16590003, 'Bedrijventerrein Bemmer');
INSERT INTO buurt (code, naam) VALUES (16590009, 'Verspreide huizen Beek en Donk');
INSERT INTO buurt (code, naam) VALUES (16590100, 'Aarle-Rixtel');
INSERT INTO buurt (code, naam) VALUES (16590101, 'Bedrijventerrein Torenakker');
INSERT INTO buurt (code, naam) VALUES (16590102, 'Bedrijventerrein Duivenakker');
INSERT INTO buurt (code, naam) VALUES (16590108, 'Verspreide huizen Laar en Strijp');
INSERT INTO buurt (code, naam) VALUES (16590109, 'Verspreide huizen Heikant');
INSERT INTO buurt (code, naam) VALUES (16590200, 'Lieshout');
INSERT INTO buurt (code, naam) VALUES (16590201, 'Industrieterrein Bavaria');
INSERT INTO buurt (code, naam) VALUES (16590209, 'Verspreide huizen Lieshout');
INSERT INTO buurt (code, naam) VALUES (16590300, 'Mariahout');
INSERT INTO buurt (code, naam) VALUES (16590309, 'Verspreide huizen Mariahout');
INSERT INTO buurt (code, naam) VALUES (16630000, 'Ulrum');
INSERT INTO buurt (code, naam) VALUES (16630001, 'Zoutkamp');
INSERT INTO buurt (code, naam) VALUES (16630002, 'Houwerzijl');
INSERT INTO buurt (code, naam) VALUES (16630003, 'Vierhuizen');
INSERT INTO buurt (code, naam) VALUES (16630004, 'Niekerk');
INSERT INTO buurt (code, naam) VALUES (16630005, 'Lauwersoog');
INSERT INTO buurt (code, naam) VALUES (16630006, 'Haven Lauwersoog');
INSERT INTO buurt (code, naam) VALUES (16630008, 'Landelijk gebied Lauwersmeer');
INSERT INTO buurt (code, naam) VALUES (16630009, 'Verspreide huizen Ulrum');
INSERT INTO buurt (code, naam) VALUES (16630100, 'Wehe-Den Hoorn-West');
INSERT INTO buurt (code, naam) VALUES (16630101, 'Leens');
INSERT INTO buurt (code, naam) VALUES (16630102, 'Warfhuizen');
INSERT INTO buurt (code, naam) VALUES (16630103, 'Mensingeweer');
INSERT INTO buurt (code, naam) VALUES (16630104, 'Schouwerzijl');
INSERT INTO buurt (code, naam) VALUES (16630105, 'Wehe-Den Hoorn-Oost');
INSERT INTO buurt (code, naam) VALUES (16630106, 'Zuurdijk');
INSERT INTO buurt (code, naam) VALUES (16630109, 'Verspreide huizen Leens');
INSERT INTO buurt (code, naam) VALUES (16630200, 'Eenrum');
INSERT INTO buurt (code, naam) VALUES (16630201, 'Pieterburen');
INSERT INTO buurt (code, naam) VALUES (16630202, 'Westernieland');
INSERT INTO buurt (code, naam) VALUES (16630203, 'Kaakhorn');
INSERT INTO buurt (code, naam) VALUES (16630208, 'Verspreide huizen Oude Land');
INSERT INTO buurt (code, naam) VALUES (16630209, 'Verspreide huizen in het Noorden');
INSERT INTO buurt (code, naam) VALUES (16630300, 'Kloosterburen');
INSERT INTO buurt (code, naam) VALUES (16630301, 'Hornhuizen');
INSERT INTO buurt (code, naam) VALUES (16630302, 'Kruisweg');
INSERT INTO buurt (code, naam) VALUES (16630303, 'Molenrij');
INSERT INTO buurt (code, naam) VALUES (16630304, 'Kleine Huisjes');
INSERT INTO buurt (code, naam) VALUES (16630309, 'Verspreide huizen Kloosterburen');
INSERT INTO buurt (code, naam) VALUES (16639997, '');
INSERT INTO buurt (code, naam) VALUES (16639998, '');
INSERT INTO buurt (code, naam) VALUES (16670000, 'Reusel');
INSERT INTO buurt (code, naam) VALUES (16670001, 'Voorste Heikant en Weijereind');
INSERT INTO buurt (code, naam) VALUES (16670002, 'De Voort en Achterste Heikant');
INSERT INTO buurt (code, naam) VALUES (16670008, 'Buitengebied ten noorden van Reusel');
INSERT INTO buurt (code, naam) VALUES (16670009, 'Buitengebied ten zuiden van Reusel');
INSERT INTO buurt (code, naam) VALUES (16670100, 'Hooge Mierde');
INSERT INTO buurt (code, naam) VALUES (16670109, 'Verspreide huizen Hooge Mierde');
INSERT INTO buurt (code, naam) VALUES (16670200, 'Lage Mierde');
INSERT INTO buurt (code, naam) VALUES (16670209, 'Verspreide huizen Lage Mierde');
INSERT INTO buurt (code, naam) VALUES (16670300, 'Hulsel');
INSERT INTO buurt (code, naam) VALUES (16670309, 'Verspreide huizen Hulsel');
INSERT INTO buurt (code, naam) VALUES (16690000, 'Melick');
INSERT INTO buurt (code, naam) VALUES (16690001, 'Herkenbosch');
INSERT INTO buurt (code, naam) VALUES (16690008, 'Verspreide huizen Herkenbosch');
INSERT INTO buurt (code, naam) VALUES (16690009, 'Verspreide huizen Melick');
INSERT INTO buurt (code, naam) VALUES (16690100, 'Vlodrop');
INSERT INTO buurt (code, naam) VALUES (16690101, 'Etsberg');
INSERT INTO buurt (code, naam) VALUES (16690109, 'Verspreide huizen Vlodrop');
INSERT INTO buurt (code, naam) VALUES (16690200, 'Posterholt De Donk');
INSERT INTO buurt (code, naam) VALUES (16690201, 'Holst');
INSERT INTO buurt (code, naam) VALUES (16690202, 'Posterholt-Dorp');
INSERT INTO buurt (code, naam) VALUES (16690203, 'Voorst-Voorsterveld');
INSERT INTO buurt (code, naam) VALUES (16690204, 'Posterholt De Winkel');
INSERT INTO buurt (code, naam) VALUES (16690205, 'Sint Odiliënberg');
INSERT INTO buurt (code, naam) VALUES (16690206, 'Reutje');
INSERT INTO buurt (code, naam) VALUES (16690207, 'Paarlo');
INSERT INTO buurt (code, naam) VALUES (16690208, 'Lerop');
INSERT INTO buurt (code, naam) VALUES (16690209, 'Montfort');
INSERT INTO buurt (code, naam) VALUES (16690210, 'Aan de Berg');
INSERT INTO buurt (code, naam) VALUES (16710000, 'Geffen');
INSERT INTO buurt (code, naam) VALUES (16710001, 'Runrot en Papendijk');
INSERT INTO buurt (code, naam) VALUES (16710008, 'Verspreide huizen ten oosten van Geffen');
INSERT INTO buurt (code, naam) VALUES (16710009, 'Verspreide huizen ten noorden van Geffen');
INSERT INTO buurt (code, naam) VALUES (16710100, 'Nuland');
INSERT INTO buurt (code, naam) VALUES (16710101, 'Bedrijventerrein Nuland');
INSERT INTO buurt (code, naam) VALUES (16710108, 'Verspreide huizen ten westen van Nuland');
INSERT INTO buurt (code, naam) VALUES (16710109, 'Verspreide huizen ten oosten van Nuland');
INSERT INTO buurt (code, naam) VALUES (16710200, 'Vinkel');
INSERT INTO buurt (code, naam) VALUES (16710209, 'Verspreide huizen Vinkel');
INSERT INTO buurt (code, naam) VALUES (16740000, 'Centrum-Oud');
INSERT INTO buurt (code, naam) VALUES (16740001, 'Centrum-Nieuw');
INSERT INTO buurt (code, naam) VALUES (16740002, 'Stationsbuurt');
INSERT INTO buurt (code, naam) VALUES (16740003, 'Vrouwenhof');
INSERT INTO buurt (code, naam) VALUES (16740100, 'Sint Josephbuurt');
INSERT INTO buurt (code, naam) VALUES (16740101, 'Fatima-villapark');
INSERT INTO buurt (code, naam) VALUES (16740102, 'Keijenburg');
INSERT INTO buurt (code, naam) VALUES (16740200, 'Parklaan-Hoogstraat');
INSERT INTO buurt (code, naam) VALUES (16740201, 'Spoorstraat-Van Coothlaan');
INSERT INTO buurt (code, naam) VALUES (16740202, 'Kalsdonk');
INSERT INTO buurt (code, naam) VALUES (16740209, 'Nieuwenberg');
INSERT INTO buurt (code, naam) VALUES (16740300, 'Heerma van Vossstraat-Molenbeek');
INSERT INTO buurt (code, naam) VALUES (16740301, 'Herreweg');
INSERT INTO buurt (code, naam) VALUES (16740302, 'Ettingen');
INSERT INTO buurt (code, naam) VALUES (16740303, 'Scherpdeel');
INSERT INTO buurt (code, naam) VALUES (16740309, 'Vroenhout');
INSERT INTO buurt (code, naam) VALUES (16740400, 'Kroeven-Noordwest');
INSERT INTO buurt (code, naam) VALUES (16740401, 'Kroeven-Noordoost');
INSERT INTO buurt (code, naam) VALUES (16740402, 'Kroeven-Zuidwest');
INSERT INTO buurt (code, naam) VALUES (16740403, 'Kroeven-Zuidoost');
INSERT INTO buurt (code, naam) VALUES (16740404, 'Minnebeek-Watermolen');
INSERT INTO buurt (code, naam) VALUES (16740405, 'De Krogten');
INSERT INTO buurt (code, naam) VALUES (16740409, 'Borteldonk');
INSERT INTO buurt (code, naam) VALUES (16740500, 'Bovendonk');
INSERT INTO buurt (code, naam) VALUES (16740501, 'Langdonk-West');
INSERT INTO buurt (code, naam) VALUES (16740502, 'Langdonk-Oost');
INSERT INTO buurt (code, naam) VALUES (16740509, 'Vierhoeven');
INSERT INTO buurt (code, naam) VALUES (16740600, 'Kortendijk A');
INSERT INTO buurt (code, naam) VALUES (16740601, 'Kortendijk C');
INSERT INTO buurt (code, naam) VALUES (16740602, 'Kortendijk L');
INSERT INTO buurt (code, naam) VALUES (16740603, 'Landerije');
INSERT INTO buurt (code, naam) VALUES (16740609, 'Bakkersberg-Langendijk');
INSERT INTO buurt (code, naam) VALUES (16740700, 'Hulsdonk');
INSERT INTO buurt (code, naam) VALUES (16740701, 'Tolberg-Oost');
INSERT INTO buurt (code, naam) VALUES (16740702, 'Tolberg-Centrum');
INSERT INTO buurt (code, naam) VALUES (16740703, 'Tolberg-West');
INSERT INTO buurt (code, naam) VALUES (16740705, 'Weihoek-Oost');
INSERT INTO buurt (code, naam) VALUES (16740706, 'Weihoek-West');
INSERT INTO buurt (code, naam) VALUES (16740709, 'Haiink');
INSERT INTO buurt (code, naam) VALUES (16740800, 'Borchwerf-Noord');
INSERT INTO buurt (code, naam) VALUES (16740801, 'Borchwerf-Zuid');
INSERT INTO buurt (code, naam) VALUES (16740802, 'Majoppeveld-Noord');
INSERT INTO buurt (code, naam) VALUES (16740803, 'Majoppeveld-Zuid');
INSERT INTO buurt (code, naam) VALUES (16740804, 'Vijfhuizenberg');
INSERT INTO buurt (code, naam) VALUES (16741000, 'Nispen');
INSERT INTO buurt (code, naam) VALUES (16741009, 'Verspreide huizen Nispen');
INSERT INTO buurt (code, naam) VALUES (16741100, 'Wouw');
INSERT INTO buurt (code, naam) VALUES (16741108, 'Verspreide huizen Wouw in het Noorden');
INSERT INTO buurt (code, naam) VALUES (16741109, 'Verspreide huizen Wouw in het Zuiden');
INSERT INTO buurt (code, naam) VALUES (16741200, 'Heerle');
INSERT INTO buurt (code, naam) VALUES (16741209, 'Verspreide huizen Heerle');
INSERT INTO buurt (code, naam) VALUES (16741300, 'Moerstraten');
INSERT INTO buurt (code, naam) VALUES (16741309, 'Verspreide huizen Moerstraten');
INSERT INTO buurt (code, naam) VALUES (16741400, 'Wouwse Plantage');
INSERT INTO buurt (code, naam) VALUES (16741409, 'Verspreide huizen Wouwse Plantage');
INSERT INTO buurt (code, naam) VALUES (16760000, 'Zierikzee binnen de vesten');
INSERT INTO buurt (code, naam) VALUES (16760001, 'Malta');
INSERT INTO buurt (code, naam) VALUES (16760002, 'Poortambacht');
INSERT INTO buurt (code, naam) VALUES (16760003, 'Zuidhoek');
INSERT INTO buurt (code, naam) VALUES (16760004, 'Kaaskenswater');
INSERT INTO buurt (code, naa