--
-- BRMO BGT/RSGB3 create script voor: sqlserver
-- Applicatie versie: 1.4.4
-- Gegenereerd op: 2017-03-16T11:19:09.654+01:00
--
CREATE TABLE brmo_metadata (
        naam VARCHAR(255) NOT NULL,
        waarde VARCHAR(255),
        PRIMARY KEY (naam)
);

GO

EXEC sys.sp_addextendedproperty @name=N'comment', @value=N'BRMO metadata en versie gegevens' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'brmo_metadata'

GO

-- brmo versienummer
INSERT INTO brmo_metadata (naam, waarde) VALUES ('brmoversie','1.4.4');

-- Klasse: Bak
CREATE TABLE bak (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX bak_geom2d_idx ON bak(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX bak_lod0geom_idx ON bak(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: BegroeidTerreindeel
CREATE TABLE begroeid_terreindeel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        optalud varchar(5),
        bgt_fysiekvoorkomen varchar(255),
        plus_fysiekvoorkomen varchar(255),
        geom2d geometry,
        lod0geom geometry,
        kruinlijn geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX begroeid_terreindeel_geom2d_idx ON begroeid_terreindeel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX begroeid_terreindeel_lod0geom_idx ON begroeid_terreindeel(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX begroeid_terreindeel_kruinlijn_idx ON begroeid_terreindeel(kruinlijn) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Bord
CREATE TABLE bord (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX bord_geom2d_idx ON bord(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX bord_lod0geom_idx ON bord(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: FunctioneelGebied
CREATE TABLE functioneelgebied (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        naam varchar(255),
        geom2d geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX functioneelgebied_geom2d_idx ON functioneelgebied(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: GebouwInstallatie
CREATE TABLE gebouw_installatie (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX gebouw_installatie_geom2d_idx ON gebouw_installatie(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX gebouw_installatie_lod0geom_idx ON gebouw_installatie(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Installatie
CREATE TABLE installatie (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX installatie_geom2d_idx ON installatie(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX installatie_lod0geom_idx ON installatie(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Kast
CREATE TABLE kast (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX kast_geom2d_idx ON kast(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX kast_lod0geom_idx ON kast(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Mast
CREATE TABLE mast (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX mast_geom2d_idx ON mast(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX mast_lod0geom_idx ON mast(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Paal
CREATE TABLE paal (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        hectometeraanduiding varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX paal_geom2d_idx ON paal(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX paal_lod0geom_idx ON paal(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Put
CREATE TABLE put (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX put_geom2d_idx ON put(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX put_lod0geom_idx ON put(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Sensor
CREATE TABLE sensor (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX sensor_geom2d_idx ON sensor(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX sensor_lod0geom_idx ON sensor(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: OpenbareRuimteLabel
CREATE TABLE openbareruimtelabel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        identif_bagopr varchar(255),
        oprnm_tekst varchar(255),
        geom2d geometry,
        oprnm_pos_1_hoek float(23),
        oprnm_pos_2_punt geometry,
        oprnm_pos_2_hoek float(23),
        oprnm_pos_3_punt geometry,
        oprnm_pos_3_hoek float(23),
        oprtype varchar(255),
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX openbareruimtelabel_geom2d_idx ON openbareruimtelabel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX openbareruimtelabel_oprnm_pos_2_punt_idx ON openbareruimtelabel(oprnm_pos_2_punt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX openbareruimtelabel_oprnm_pos_3_punt_idx ON openbareruimtelabel(oprnm_pos_3_punt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: OverigeScheiding
CREATE TABLE overige_scheiding (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX overige_scheiding_geom2d_idx ON overige_scheiding(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Scheiding
CREATE TABLE scheiding (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX scheiding_geom2d_idx ON scheiding(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: OverigBouwwerk
CREATE TABLE overig_bouwwerk (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX overig_bouwwerk_geom2d_idx ON overig_bouwwerk(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: OngeclassificeerdObject
CREATE TABLE ongeclassificeerdobject (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        geom2d geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX ongeclassificeerdobject_geom2d_idx ON ongeclassificeerdobject(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Waterdeel
CREATE TABLE waterdeel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX waterdeel_geom2d_idx ON waterdeel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Kunstwerkdeel
CREATE TABLE kunstwerkdeel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX kunstwerkdeel_geom2d_idx ON kunstwerkdeel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: OnbegroeidTerreindeel
CREATE TABLE onbegroeid_terreindeel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        optalud varchar(5),
        bgt_fysiekvoorkomen varchar(255),
        plus_fysiekvoorkomen varchar(255),
        geom2d geometry,
        kruinlijn geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX onbegroeid_terreindeel_geom2d_idx ON onbegroeid_terreindeel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX onbegroeid_terreindeel_kruinlijn_idx ON onbegroeid_terreindeel(kruinlijn) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Overbruggingsdeel
CREATE TABLE overbruggingsdeel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        otype varchar(255),
        hoortbijtype varchar(255),
        isbeweegbaar varchar(5),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX overbruggingsdeel_geom2d_idx ON overbruggingsdeel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX overbruggingsdeel_lod0geom_idx ON overbruggingsdeel(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Straatmeubilair
CREATE TABLE straatmeubilair (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX straatmeubilair_geom2d_idx ON straatmeubilair(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX straatmeubilair_lod0geom_idx ON straatmeubilair(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: OndersteunendWaterdeel
CREATE TABLE ondersteunend_waterdeel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX ondersteunend_waterdeel_geom2d_idx ON ondersteunend_waterdeel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: OndersteunendWegdeel
CREATE TABLE ondersteunend_wegdeel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        optalud varchar(5),
        bgtfunctie varchar(255),
        bgt_fysiekvoorkomen varchar(255),
        plus_functie varchar(255),
        plus_fysiekvoorkomen varchar(255),
        geom2d geometry,
        lod0geom geometry,
        kruinlijn geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX ondersteunend_wegdeel_geom2d_idx ON ondersteunend_wegdeel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX ondersteunend_wegdeel_lod0geom_idx ON ondersteunend_wegdeel(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX ondersteunend_wegdeel_kruinlijn_idx ON ondersteunend_wegdeel(kruinlijn) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Spoor
CREATE TABLE spoor (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgtfunctie varchar(255),
        plus_functie varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX spoor_geom2d_idx ON spoor(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX spoor_lod0geom_idx ON spoor(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Weginrichtingselement
CREATE TABLE weginrichtingselement (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX weginrichtingselement_geom2d_idx ON weginrichtingselement(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX weginrichtingselement_lod0geom_idx ON weginrichtingselement(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: VegetatieObject
CREATE TABLE vegetatieobject (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX vegetatieobject_geom2d_idx ON vegetatieobject(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX vegetatieobject_lod0geom_idx ON vegetatieobject(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Tunneldeel
CREATE TABLE tunneldeel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX tunneldeel_geom2d_idx ON tunneldeel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX tunneldeel_lod0geom_idx ON tunneldeel(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Waterinrichtingselement
CREATE TABLE waterinrichtingselement (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        bgt_type varchar(255),
        plus_type varchar(255),
        geom2d geometry,
        lod0geom geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX waterinrichtingselement_geom2d_idx ON waterinrichtingselement(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX waterinrichtingselement_lod0geom_idx ON waterinrichtingselement(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Wegdeel
CREATE TABLE wegdeel (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        optalud varchar(5),
        bgtfunctie varchar(255),
        plus_functie varchar(255),
        bgt_fysiekvoorkomen varchar(255),
        plus_fysiekvoorkomen varchar(255),
        geom2d geometry,
        lod0geom geometry,
        kruinlijn geometry,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX wegdeel_geom2d_idx ON wegdeel(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX wegdeel_lod0geom_idx ON wegdeel(lod0geom) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX wegdeel_kruinlijn_idx ON wegdeel(kruinlijn) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));

-- Klasse: Pand
CREATE TABLE pand (
        identif varchar(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging integer,
        bgt_status varchar(255),
        plus_status varchar(255),
        identif_bagpnd varchar(255),
        geom2d geometry,
        nrar_1_tekst varchar(255),
        nrar_1_pos_1_pnt geometry,
        nrar_1_pos_1_hoek float(23),
        nrar_1_pos_2_pnt geometry,
        nrar_1_pos_2_hoek float(23),
        nrar_1_pos_3_pnt geometry,
        nrar_1_pos_3_hoek float(23),
        nrar_1_id_bagvbo_min_huisnr varchar(255),
        nrar_1_id_bagvbo_max_huisnr varchar(255),
        nrar_2_tekst varchar(255),
        nrar_2_pos_1_pnt geometry,
        nrar_2_pos_1_hoek float(23),
        nrar_2_pos_2_pnt geometry,
        nrar_2_pos_2_hoek float(23),
        nrar_2_pos_3_pnt geometry,
        nrar_2_pos_3_hoek float(23),
        nrar_2_id_bagvbo_min_huisnr varchar(255),
        nrar_2_id_bagvbo_max_huisnr varchar(255),
        nrar_3_tekst varchar(255),
        nrar_3_pos_1_pnt geometry,
        nrar_3_pos_1_hoek float(23),
        nrar_3_pos_2_pnt geometry,
        nrar_3_pos_2_hoek float(23),
        nrar_3_pos_3_pnt geometry,
        nrar_3_pos_3_hoek float(23),
        nrar_3_id_bagvbo_min_huisnr varchar(255),
        nrar_3_id_bagvbo_max_huisnr varchar(255),
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

CREATE SPATIAL INDEX pand_geom2d_idx ON pand(geom2d) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX pand_nrar_1_pos_1_pnt_idx ON pand(nrar_1_pos_1_pnt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX pand_nrar_1_pos_2_pnt_idx ON pand(nrar_1_pos_2_pnt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX pand_nrar_1_pos_3_pnt_idx ON pand(nrar_1_pos_3_pnt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX pand_nrar_2_pos_1_pnt_idx ON pand(nrar_2_pos_1_pnt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX pand_nrar_2_pos_2_pnt_idx ON pand(nrar_2_pos_2_pnt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX pand_nrar_2_pos_3_pnt_idx ON pand(nrar_2_pos_3_pnt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX pand_nrar_3_pos_1_pnt_idx ON pand(nrar_3_pos_1_pnt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX pand_nrar_3_pos_2_pnt_idx ON pand(nrar_3_pos_2_pnt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
CREATE SPATIAL INDEX pand_nrar_3_pos_3_pnt_idx ON pand(nrar_3_pos_3_pnt) WITH ( BOUNDING_BOX = (12000,304000,280000,620000));
