--
-- BRMO BGT/RSGB3 create script voor: oracle
-- Applicatie versie: 1.5.2.1
-- Gegenereerd op: 2018-04-19T17:35:10.165+02:00
--
CREATE TABLE GEOMETRY_COLUMNS (
    F_TABLE_SCHEMA VARCHAR(30) NOT NULL,
    F_TABLE_NAME VARCHAR(30) NOT NULL,
    F_GEOMETRY_COLUMN VARCHAR(30) NOT NULL,
    COORD_DIMENSION INTEGER,
    SRID INTEGER NOT NULL,
    TYPE VARCHAR(30) NOT NULL,
    UNIQUE(F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN),
    CHECK(TYPE IN ('POINT',
                   'LINE',
                   'POLYGON',
                   'COLLECTION',
                   'MULTIPOINT',
                   'MULTILINE',
                   'MULTIPOLYGON',
                   'GEOMETRY'))
);

CREATE TABLE GT_PK_METADATA (
    table_schema VARCHAR2(32) NOT NULL,
    table_name VARCHAR2(32) NOT NULL,
    pk_column VARCHAR2(32) NOT NULL,
    pk_column_idx NUMBER(38),
    pk_policy VARCHAR2(32),
    pk_sequence VARCHAR2(64),
    CONSTRAINT  chk_pk_policy CHECK (pk_policy IN ('sequence', 'assigned', 'autoincrement')));

CREATE UNIQUE INDEX gt_pk_metadata_table_idx01 ON GT_PK_METADATA (table_schema, table_name, pk_column);

CREATE TABLE BRMO_METADATA (
        NAAM VARCHAR2(255 CHAR) NOT NULL,
        WAARDE VARCHAR2(255 CHAR),
        PRIMARY KEY (NAAM)
);
COMMENT ON TABLE BRMO_METADATA IS 'BRMO metadata en versie gegevens';

-- brmo versienummer
INSERT INTO brmo_metadata (naam, waarde) VALUES ('brmoversie','1.5.2.1');

-- Klasse: Bak
CREATE TABLE bak (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'BAK', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('BAK', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BAK', 'GEOM2D', 2, 28992,'POINT');
CREATE INDEX BAK_GEOM2D_IDX ON BAK (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('BAK', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BAK', 'LOD0GEOM', 2, 28992,'POINT');
CREATE INDEX BAK_LOD0GEOM_IDX ON BAK (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: BegroeidTerreindeel
CREATE TABLE begroeid_terreindeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        OPTALUD VARCHAR2(5),
        BGT_FYSIEKVOORKOMEN VARCHAR2(255),
        PLUS_FYSIEKVOORKOMEN VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        KRUINLIJN MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'BEGROEID_TERREINDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('BEGROEID_TERREINDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BEGROEID_TERREINDEEL', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX BEGROEID_TERREINDEEL_GEOM2_IDX ON BEGROEID_TERREINDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('BEGROEID_TERREINDEEL', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BEGROEID_TERREINDEEL', 'LOD0GEOM', 2, 28992,'MULTIPOLYGON');
CREATE INDEX BEGROEID_TERREINDEEL_LOD0G_IDX ON BEGROEID_TERREINDEEL (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=MULTIPOLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('BEGROEID_TERREINDEEL', 'KRUINLIJN',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BEGROEID_TERREINDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
CREATE INDEX BEGROEID_TERREINDEEL_KRUIN_IDX ON BEGROEID_TERREINDEEL (KRUINLIJN)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: Bord
CREATE TABLE bord (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'BORD', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('BORD', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BORD', 'GEOM2D', 2, 28992,'POINT');
CREATE INDEX BORD_GEOM2D_IDX ON BORD (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('BORD', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BORD', 'LOD0GEOM', 2, 28992,'POINT');
CREATE INDEX BORD_LOD0GEOM_IDX ON BORD (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: FunctioneelGebied
CREATE TABLE functioneelgebied (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        NAAM VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'FUNCTIONEELGEBIED', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('FUNCTIONEELGEBIED', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','FUNCTIONEELGEBIED', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX FUNCTIONEELGEBIED_GEOM2D_IDX ON FUNCTIONEELGEBIED (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');

-- Klasse: GebouwInstallatie
CREATE TABLE gebouw_installatie (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'GEBOUW_INSTALLATIE', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('GEBOUW_INSTALLATIE', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','GEBOUW_INSTALLATIE', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX GEBOUW_INSTALLATIE_GEOM2D_IDX ON GEBOUW_INSTALLATIE (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('GEBOUW_INSTALLATIE', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','GEBOUW_INSTALLATIE', 'LOD0GEOM', 2, 28992,'POLYGON');
CREATE INDEX GEBOUW_INSTALLATIE_LOD0GEO_IDX ON GEBOUW_INSTALLATIE (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');

-- Klasse: Installatie
CREATE TABLE installatie (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'INSTALLATIE', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('INSTALLATIE', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','INSTALLATIE', 'GEOM2D', 2, 28992,'POINT');
CREATE INDEX INSTALLATIE_GEOM2D_IDX ON INSTALLATIE (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('INSTALLATIE', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','INSTALLATIE', 'LOD0GEOM', 2, 28992,'POINT');
CREATE INDEX INSTALLATIE_LOD0GEOM_IDX ON INSTALLATIE (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: Kast
CREATE TABLE kast (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'KAST', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('KAST', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','KAST', 'GEOM2D', 2, 28992,'POINT');
CREATE INDEX KAST_GEOM2D_IDX ON KAST (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('KAST', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','KAST', 'LOD0GEOM', 2, 28992,'POINT');
CREATE INDEX KAST_LOD0GEOM_IDX ON KAST (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: Mast
CREATE TABLE mast (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'MAST', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('MAST', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','MAST', 'GEOM2D', 2, 28992,'POINT');
CREATE INDEX MAST_GEOM2D_IDX ON MAST (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('MAST', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','MAST', 'LOD0GEOM', 2, 28992,'POINT');
CREATE INDEX MAST_LOD0GEOM_IDX ON MAST (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: Paal
CREATE TABLE paal (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        HECTOMETERAANDUIDING VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'PAAL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAAL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAAL', 'GEOM2D', 2, 28992,'POINT');
CREATE INDEX PAAL_GEOM2D_IDX ON PAAL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAAL', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAAL', 'LOD0GEOM', 2, 28992,'POINT');
CREATE INDEX PAAL_LOD0GEOM_IDX ON PAAL (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: Put
CREATE TABLE put (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'PUT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PUT', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PUT', 'GEOM2D', 2, 28992,'POINT');
CREATE INDEX PUT_GEOM2D_IDX ON PUT (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PUT', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PUT', 'LOD0GEOM', 2, 28992,'POINT');
CREATE INDEX PUT_LOD0GEOM_IDX ON PUT (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: Sensor
CREATE TABLE sensor (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'SENSOR', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('SENSOR', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SENSOR', 'GEOM2D', 2, 28992,'GEOMETRY');
CREATE INDEX SENSOR_GEOM2D_IDX ON SENSOR (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('SENSOR', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SENSOR', 'LOD0GEOM', 2, 28992,'GEOMETRY');
CREATE INDEX SENSOR_LOD0GEOM_IDX ON SENSOR (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: OpenbareRuimteLabel
CREATE TABLE openbareruimtelabel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        IDENTIF_BAGOPR VARCHAR2(255),
        OPRNM_TEKST VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        OPRNM_POS_1_HOEK float(23),
        OPRNM_POS_2_PUNT MDSYS.SDO_GEOMETRY,
        OPRNM_POS_2_HOEK float(23),
        OPRNM_POS_3_PUNT MDSYS.SDO_GEOMETRY,
        OPRNM_POS_3_HOEK float(23),
        OPRTYPE VARCHAR2(255),
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OPENBARERUIMTELABEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('OPENBARERUIMTELABEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OPENBARERUIMTELABEL', 'GEOM2D', 2, 28992,'POINT');
CREATE INDEX OPRLBL_GEOM2D_IDX ON OPENBARERUIMTELABEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('OPENBARERUIMTELABEL', 'OPRNM_POS_2_PUNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OPENBARERUIMTELABEL', 'OPRNM_POS_2_PUNT', 2, 28992,'POINT');
CREATE INDEX OPRLBL_OPRNM_POS_2_PUNT_IDX ON OPENBARERUIMTELABEL (OPRNM_POS_2_PUNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('OPENBARERUIMTELABEL', 'OPRNM_POS_3_PUNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OPENBARERUIMTELABEL', 'OPRNM_POS_3_PUNT', 2, 28992,'POINT');
CREATE INDEX OPRLBL_OPRNM_POS_3_PUNT_IDX ON OPENBARERUIMTELABEL (OPRNM_POS_3_PUNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: OverigeScheiding
CREATE TABLE overige_scheiding (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OVERIGE_SCHEIDING', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('OVERIGE_SCHEIDING', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OVERIGE_SCHEIDING', 'GEOM2D', 2, 28992,'GEOMETRY');
CREATE INDEX OVERIGE_SCHEIDING_GEOM2D_IDX ON OVERIGE_SCHEIDING (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: Scheiding
CREATE TABLE scheiding (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'SCHEIDING', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('SCHEIDING', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SCHEIDING', 'GEOM2D', 2, 28992,'GEOMETRY');
CREATE INDEX SCHEIDING_GEOM2D_IDX ON SCHEIDING (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: OverigBouwwerk
CREATE TABLE overig_bouwwerk (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OVERIG_BOUWWERK', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('OVERIG_BOUWWERK', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OVERIG_BOUWWERK', 'GEOM2D', 2, 28992,'GEOMETRY');
CREATE INDEX OVERIG_BOUWWERK_GEOM2D_IDX ON OVERIG_BOUWWERK (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: OngeclassificeerdObject
CREATE TABLE ongeclassificeerdobject (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'ONGECLASSIFICEERDOBJECT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('ONGECLASSIFICEERDOBJECT', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONGECLASSIFICEERDOBJECT', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX OCLASOBJECT_GEOM2D_IDX ON ONGECLASSIFICEERDOBJECT (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');

-- Klasse: Waterdeel
CREATE TABLE waterdeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WATERDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('WATERDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WATERDEEL', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX WATERDEEL_GEOM2D_IDX ON WATERDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');

-- Klasse: Kunstwerkdeel
CREATE TABLE kunstwerkdeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'KUNSTWERKDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('KUNSTWERKDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','KUNSTWERKDEEL', 'GEOM2D', 2, 28992,'GEOMETRY');
CREATE INDEX KUNSTWERKDEEL_GEOM2D_IDX ON KUNSTWERKDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: OnbegroeidTerreindeel
CREATE TABLE onbegroeid_terreindeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        OPTALUD VARCHAR2(5),
        BGT_FYSIEKVOORKOMEN VARCHAR2(255),
        PLUS_FYSIEKVOORKOMEN VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        KRUINLIJN MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'ONBEGROEID_TERREINDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('ONBEGROEID_TERREINDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONBEGROEID_TERREINDEEL', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX ONBEGROEID_TERREINDEEL_GEO_IDX ON ONBEGROEID_TERREINDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('ONBEGROEID_TERREINDEEL', 'KRUINLIJN',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONBEGROEID_TERREINDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
CREATE INDEX ONBEGROEID_TERREINDEEL_KRU_IDX ON ONBEGROEID_TERREINDEEL (KRUINLIJN)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: Overbruggingsdeel
CREATE TABLE overbruggingsdeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        OTYPE VARCHAR2(255),
        HOORTBIJTYPE VARCHAR2(255),
        ISBEWEEGBAAR VARCHAR2(5),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OVERBRUGGINGSDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('OVERBRUGGINGSDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OVERBRUGGINGSDEEL', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX OVERBRUGGINGSDEEL_GEOM2D_IDX ON OVERBRUGGINGSDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('OVERBRUGGINGSDEEL', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OVERBRUGGINGSDEEL', 'LOD0GEOM', 2, 28992,'POLYGON');
CREATE INDEX OVERBRUGGINGSDEEL_LOD0GEOM_IDX ON OVERBRUGGINGSDEEL (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');

-- Klasse: Straatmeubilair
CREATE TABLE straatmeubilair (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'STRAATMEUBILAIR', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('STRAATMEUBILAIR', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','STRAATMEUBILAIR', 'GEOM2D', 2, 28992,'POINT');
CREATE INDEX STRAATMEUBILAIR_GEOM2D_IDX ON STRAATMEUBILAIR (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('STRAATMEUBILAIR', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','STRAATMEUBILAIR', 'LOD0GEOM', 2, 28992,'POINT');
CREATE INDEX STRAATMEUBILAIR_LOD0GEOM_IDX ON STRAATMEUBILAIR (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: OndersteunendWaterdeel
CREATE TABLE ondersteunend_waterdeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'ONDERSTEUNEND_WATERDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('ONDERSTEUNEND_WATERDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONDERSTEUNEND_WATERDEEL', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX ODRSTEUN_WATERDEEL_GEOM2D_IDX ON ONDERSTEUNEND_WATERDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');

-- Klasse: OndersteunendWegdeel
CREATE TABLE ondersteunend_wegdeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        OPTALUD VARCHAR2(5),
        BGTFUNCTIE VARCHAR2(255),
        BGT_FYSIEKVOORKOMEN VARCHAR2(255),
        PLUS_FUNCTIE VARCHAR2(255),
        PLUS_FYSIEKVOORKOMEN VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        KRUINLIJN MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'ONDERSTEUNEND_WEGDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('ONDERSTEUNEND_WEGDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONDERSTEUNEND_WEGDEEL', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX ODRSTEUN_WEGDEEL_GEOM2D_IDX ON ONDERSTEUNEND_WEGDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('ONDERSTEUNEND_WEGDEEL', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONDERSTEUNEND_WEGDEEL', 'LOD0GEOM', 2, 28992,'POLYGON');
CREATE INDEX ODRSTEUN_WEGDEEL_LOD0GEOM_IDX ON ONDERSTEUNEND_WEGDEEL (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('ONDERSTEUNEND_WEGDEEL', 'KRUINLIJN',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONDERSTEUNEND_WEGDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
CREATE INDEX ODRSTEUN_WEGDEEL_KRUINLIJN_IDX ON ONDERSTEUNEND_WEGDEEL (KRUINLIJN)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: Spoor
CREATE TABLE spoor (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGTFUNCTIE VARCHAR2(255),
        PLUS_FUNCTIE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'SPOOR', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('SPOOR', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SPOOR', 'GEOM2D', 2, 28992,'COLLECTION');
CREATE INDEX SPOOR_GEOM2D_IDX ON SPOOR (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=MULTICURVE');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('SPOOR', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SPOOR', 'LOD0GEOM', 2, 28992,'COLLECTION');
CREATE INDEX SPOOR_LOD0GEOM_IDX ON SPOOR (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=MULTICURVE');

-- Klasse: Weginrichtingselement
CREATE TABLE weginrichtingselement (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WEGINRICHTINGSELEMENT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('WEGINRICHTINGSELEMENT', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGINRICHTINGSELEMENT', 'GEOM2D', 2, 28992,'GEOMETRY');
CREATE INDEX WEGINRICHTINGSELEMENT_GEOM_IDX ON WEGINRICHTINGSELEMENT (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('WEGINRICHTINGSELEMENT', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGINRICHTINGSELEMENT', 'LOD0GEOM', 2, 28992,'GEOMETRY');
CREATE INDEX WEGINRICHTINGSELEMENT_LOD0_IDX ON WEGINRICHTINGSELEMENT (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: VegetatieObject
CREATE TABLE vegetatieobject (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'VEGETATIEOBJECT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('VEGETATIEOBJECT', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','VEGETATIEOBJECT', 'GEOM2D', 2, 28992,'GEOMETRY');
CREATE INDEX VEGETATIEOBJECT_GEOM2D_IDX ON VEGETATIEOBJECT (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('VEGETATIEOBJECT', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','VEGETATIEOBJECT', 'LOD0GEOM', 2, 28992,'GEOMETRY');
CREATE INDEX VEGETATIEOBJECT_LOD0GEOM_IDX ON VEGETATIEOBJECT (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: Tunneldeel
CREATE TABLE tunneldeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'TUNNELDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('TUNNELDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','TUNNELDEEL', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX TUNNELDEEL_GEOM2D_IDX ON TUNNELDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('TUNNELDEEL', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','TUNNELDEEL', 'LOD0GEOM', 2, 28992,'POLYGON');
CREATE INDEX TUNNELDEEL_LOD0GEOM_IDX ON TUNNELDEEL (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');

-- Klasse: Waterinrichtingselement
CREATE TABLE waterinrichtingselement (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BGT_TYPE VARCHAR2(255),
        PLUS_TYPE VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WATERINRICHTINGSELEMENT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('WATERINRICHTINGSELEMENT', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WATERINRICHTINGSELEMENT', 'GEOM2D', 2, 28992,'GEOMETRY');
CREATE INDEX WATERINRICHTINGSELEMENT_GE_IDX ON WATERINRICHTINGSELEMENT (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('WATERINRICHTINGSELEMENT', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WATERINRICHTINGSELEMENT', 'LOD0GEOM', 2, 28992,'GEOMETRY');
CREATE INDEX WATERINRICHTINGSELEMENT_LO_IDX ON WATERINRICHTINGSELEMENT (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: Wegdeel
CREATE TABLE wegdeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        OPTALUD VARCHAR2(5),
        BGTFUNCTIE VARCHAR2(255),
        PLUS_FUNCTIE VARCHAR2(255),
        BGT_FYSIEKVOORKOMEN VARCHAR2(255),
        PLUS_FYSIEKVOORKOMEN VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        LOD0GEOM MDSYS.SDO_GEOMETRY,
        KRUINLIJN MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WEGDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('WEGDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGDEEL', 'GEOM2D', 2, 28992,'POLYGON');
CREATE INDEX WEGDEEL_GEOM2D_IDX ON WEGDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('WEGDEEL', 'LOD0GEOM',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGDEEL', 'LOD0GEOM', 2, 28992,'POLYGON');
CREATE INDEX WEGDEEL_LOD0GEOM_IDX ON WEGDEEL (LOD0GEOM)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('WEGDEEL', 'KRUINLIJN',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
CREATE INDEX WEGDEEL_KRUINLIJN_IDX ON WEGDEEL (KRUINLIJN)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

-- Klasse: Pand
CREATE TABLE pand (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        IDENTIF_BAGPND VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        NRAR_1_TEKST VARCHAR2(255),
        NRAR_1_POS_1_PNT MDSYS.SDO_GEOMETRY,
        NRAR_1_POS_1_HOEK float(23),
        NRAR_1_POS_2_PNT MDSYS.SDO_GEOMETRY,
        NRAR_1_POS_2_HOEK float(23),
        NRAR_1_POS_3_PNT MDSYS.SDO_GEOMETRY,
        NRAR_1_POS_3_HOEK float(23),
        NRAR_1_ID_BAGVBO_MIN_HUISNR VARCHAR2(255),
        NRAR_1_ID_BAGVBO_MAX_HUISNR VARCHAR2(255),
        NRAR_2_TEKST VARCHAR2(255),
        NRAR_2_POS_1_PNT MDSYS.SDO_GEOMETRY,
        NRAR_2_POS_1_HOEK float(23),
        NRAR_2_POS_2_PNT MDSYS.SDO_GEOMETRY,
        NRAR_2_POS_2_HOEK float(23),
        NRAR_2_POS_3_PNT MDSYS.SDO_GEOMETRY,
        NRAR_2_POS_3_HOEK float(23),
        NRAR_2_ID_BAGVBO_MIN_HUISNR VARCHAR2(255),
        NRAR_2_ID_BAGVBO_MAX_HUISNR VARCHAR2(255),
        NRAR_3_TEKST VARCHAR2(255),
        NRAR_3_POS_1_PNT MDSYS.SDO_GEOMETRY,
        NRAR_3_POS_1_HOEK float(23),
        NRAR_3_POS_2_PNT MDSYS.SDO_GEOMETRY,
        NRAR_3_POS_2_HOEK float(23),
        NRAR_3_POS_3_PNT MDSYS.SDO_GEOMETRY,
        NRAR_3_POS_3_HOEK float(23),
        NRAR_3_ID_BAGVBO_MIN_HUISNR VARCHAR2(255),
        NRAR_3_ID_BAGVBO_MAX_HUISNR VARCHAR2(255),
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'PAND', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'GEOM2D', 2, 28992,'MULTIPOLYGON');
CREATE INDEX PAND_GEOM2D_IDX ON PAND (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=MULTIPOLYGON');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'NRAR_1_POS_1_PNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_1_POS_1_PNT', 2, 28992,'POINT');
CREATE INDEX PAND_NRAR_1_POS_1_PNT_IDX ON PAND (NRAR_1_POS_1_PNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'NRAR_1_POS_2_PNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_1_POS_2_PNT', 2, 28992,'POINT');
CREATE INDEX PAND_NRAR_1_POS_2_PNT_IDX ON PAND (NRAR_1_POS_2_PNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'NRAR_1_POS_3_PNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_1_POS_3_PNT', 2, 28992,'POINT');
CREATE INDEX PAND_NRAR_1_POS_3_PNT_IDX ON PAND (NRAR_1_POS_3_PNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'NRAR_2_POS_1_PNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_2_POS_1_PNT', 2, 28992,'POINT');
CREATE INDEX PAND_NRAR_2_POS_1_PNT_IDX ON PAND (NRAR_2_POS_1_PNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'NRAR_2_POS_2_PNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_2_POS_2_PNT', 2, 28992,'POINT');
CREATE INDEX PAND_NRAR_2_POS_2_PNT_IDX ON PAND (NRAR_2_POS_2_PNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'NRAR_2_POS_3_PNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_2_POS_3_PNT', 2, 28992,'POINT');
CREATE INDEX PAND_NRAR_2_POS_3_PNT_IDX ON PAND (NRAR_2_POS_3_PNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'NRAR_3_POS_1_PNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_3_POS_1_PNT', 2, 28992,'POINT');
CREATE INDEX PAND_NRAR_3_POS_1_PNT_IDX ON PAND (NRAR_3_POS_1_PNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'NRAR_3_POS_2_PNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_3_POS_2_PNT', 2, 28992,'POINT');
CREATE INDEX PAND_NRAR_3_POS_2_PNT_IDX ON PAND (NRAR_3_POS_2_PNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');
INSERT INTO USER_SDO_GEOM_METADATA VALUES('PAND', 'NRAR_3_POS_3_PNT',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_3_POS_3_PNT', 2, 28992,'POINT');
CREATE INDEX PAND_NRAR_3_POS_3_PNT_IDX ON PAND (NRAR_3_POS_3_PNT)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=POINT');

-- Klasse: Buurt
CREATE TABLE buurt (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        BUURTCODE VARCHAR2(255),
        NAAM VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        WIJK VARCHAR2(255),
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'BUURT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('BUURT', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BUURT', 'GEOM2D', 2, 28992,'MULTIPOLYGON');
CREATE INDEX BUURT_GEOM2D_IDX ON BUURT (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=MULTIPOLYGON');

-- Klasse: Wijk
CREATE TABLE wijk (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        WIJKCODE VARCHAR2(255),
        NAAM VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        STADSDEEL VARCHAR2(255),
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WIJK', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('WIJK', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WIJK', 'GEOM2D', 2, 28992,'MULTIPOLYGON');
CREATE INDEX WIJK_GEOM2D_IDX ON WIJK (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=MULTIPOLYGON');

-- Klasse: OpenbareRuimte
CREATE TABLE openbareruimte (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        datum_einde_geldh date,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        NAAM VARCHAR2(255),
        NAAM_ID_OPR VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        bijwerkdatum date,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OPENBARERUIMTE', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('OPENBARERUIMTE', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);            
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OPENBARERUIMTE', 'GEOM2D', 2, 28992,'MULTIPOLYGON');
CREATE INDEX OPENBARERUIMTE_GEOM2D_IDX ON OPENBARERUIMTE (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=MULTIPOLYGON');
