--
-- BRMO BGT/RSGB3 create script voor: postgresql
-- Applicatie versie: 1.6.0
-- Gegenereerd op: 2018-08-31T17:47:56.11+02:00
--
CREATE TABLE brmo_metadata (
        naam CHARACTER VARYING(255) NOT NULL,
        waarde CHARACTER VARYING(255),
        CONSTRAINT brmo_metadata_pk PRIMARY KEY (naam)
);
COMMENT ON TABLE brmo_metadata IS 'BRMO metadata en versie gegevens';

-- brmo versienummer
INSERT INTO brmo_metadata (naam, waarde) VALUES ('brmoversie','1.6.0');
-- gemeente data versie
INSERT INTO brmo_metadata (naam, waarde) VALUES ('update_gem_tabel', '1.6.0');

-- Klasse: Bak
CREATE TABLE bak (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POINT,28992),
        lod0geom geometry(POINT,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX bak_geom2d_idx on bak USING GIST (geom2d);
CREATE INDEX bak_lod0geom_idx on bak USING GIST (lod0geom);

-- Klasse: BegroeidTerreindeel
CREATE TABLE begroeid_terreindeel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        optalud boolean,
        bgt_fysiekvoorkomen character varying(255),
        plus_fysiekvoorkomen character varying(255),
        geom2d geometry(POLYGON,28992),
        lod0geom geometry(MULTIPOLYGON,28992),
        kruinlijn geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX begroeid_terreindeel_geom2d_idx on begroeid_terreindeel USING GIST (geom2d);
CREATE INDEX begroeid_terreindeel_lod0geom_idx on begroeid_terreindeel USING GIST (lod0geom);
CREATE INDEX begroeid_terreindeel_kruinlijn_idx on begroeid_terreindeel USING GIST (kruinlijn);

-- Klasse: Bord
CREATE TABLE bord (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POINT,28992),
        lod0geom geometry(POINT,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX bord_geom2d_idx on bord USING GIST (geom2d);
CREATE INDEX bord_lod0geom_idx on bord USING GIST (lod0geom);

-- Klasse: FunctioneelGebied
CREATE TABLE functioneelgebied (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        naam character varying(255),
        geom2d geometry(POLYGON,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX functioneelgebied_geom2d_idx on functioneelgebied USING GIST (geom2d);

-- Klasse: GebouwInstallatie
CREATE TABLE gebouw_installatie (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POLYGON,28992),
        lod0geom geometry(POLYGON,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX gebouw_installatie_geom2d_idx on gebouw_installatie USING GIST (geom2d);
CREATE INDEX gebouw_installatie_lod0geom_idx on gebouw_installatie USING GIST (lod0geom);

-- Klasse: Installatie
CREATE TABLE installatie (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POINT,28992),
        lod0geom geometry(POINT,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX installatie_geom2d_idx on installatie USING GIST (geom2d);
CREATE INDEX installatie_lod0geom_idx on installatie USING GIST (lod0geom);

-- Klasse: Kast
CREATE TABLE kast (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POINT,28992),
        lod0geom geometry(POINT,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX kast_geom2d_idx on kast USING GIST (geom2d);
CREATE INDEX kast_lod0geom_idx on kast USING GIST (lod0geom);

-- Klasse: Mast
CREATE TABLE mast (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POINT,28992),
        lod0geom geometry(POINT,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX mast_geom2d_idx on mast USING GIST (geom2d);
CREATE INDEX mast_lod0geom_idx on mast USING GIST (lod0geom);

-- Klasse: Paal
CREATE TABLE paal (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        hectometeraanduiding character varying(255),
        geom2d geometry(POINT,28992),
        lod0geom geometry(POINT,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX paal_geom2d_idx on paal USING GIST (geom2d);
CREATE INDEX paal_lod0geom_idx on paal USING GIST (lod0geom);

-- Klasse: Put
CREATE TABLE put (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POINT,28992),
        lod0geom geometry(POINT,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX put_geom2d_idx on put USING GIST (geom2d);
CREATE INDEX put_lod0geom_idx on put USING GIST (lod0geom);

-- Klasse: Sensor
CREATE TABLE sensor (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(GEOMETRY,28992),
        lod0geom geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX sensor_geom2d_idx on sensor USING GIST (geom2d);
CREATE INDEX sensor_lod0geom_idx on sensor USING GIST (lod0geom);

-- Klasse: OpenbareRuimteLabel
CREATE TABLE openbareruimtelabel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        identif_bagopr character varying(255),
        oprnm_tekst character varying(255),
        geom2d geometry(POINT,28992),
        oprnm_pos_1_hoek float(23),
        oprnm_pos_2_punt geometry(POINT,28992),
        oprnm_pos_2_hoek float(23),
        oprnm_pos_3_punt geometry(POINT,28992),
        oprnm_pos_3_hoek float(23),
        oprtype character varying(255),
        PRIMARY KEY (identif)
);

CREATE INDEX openbareruimtelabel_geom2d_idx on openbareruimtelabel USING GIST (geom2d);
CREATE INDEX openbareruimtelabel_oprnm_pos_2_punt_idx on openbareruimtelabel USING GIST (oprnm_pos_2_punt);
CREATE INDEX openbareruimtelabel_oprnm_pos_3_punt_idx on openbareruimtelabel USING GIST (oprnm_pos_3_punt);

-- Klasse: OverigeScheiding
CREATE TABLE overige_scheiding (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        plus_type character varying(255),
        geom2d geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX overige_scheiding_geom2d_idx on overige_scheiding USING GIST (geom2d);

-- Klasse: Scheiding
CREATE TABLE scheiding (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX scheiding_geom2d_idx on scheiding USING GIST (geom2d);

-- Klasse: OverigBouwwerk
CREATE TABLE overig_bouwwerk (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX overig_bouwwerk_geom2d_idx on overig_bouwwerk USING GIST (geom2d);

-- Klasse: OngeclassificeerdObject
CREATE TABLE ongeclassificeerdobject (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        geom2d geometry(POLYGON,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX ongeclassificeerdobject_geom2d_idx on ongeclassificeerdobject USING GIST (geom2d);

-- Klasse: Waterdeel
CREATE TABLE waterdeel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POLYGON,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX waterdeel_geom2d_idx on waterdeel USING GIST (geom2d);

-- Klasse: Kunstwerkdeel
CREATE TABLE kunstwerkdeel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX kunstwerkdeel_geom2d_idx on kunstwerkdeel USING GIST (geom2d);

-- Klasse: OnbegroeidTerreindeel
CREATE TABLE onbegroeid_terreindeel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        optalud boolean,
        bgt_fysiekvoorkomen character varying(255),
        plus_fysiekvoorkomen character varying(255),
        geom2d geometry(POLYGON,28992),
        kruinlijn geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX onbegroeid_terreindeel_geom2d_idx on onbegroeid_terreindeel USING GIST (geom2d);
CREATE INDEX onbegroeid_terreindeel_kruinlijn_idx on onbegroeid_terreindeel USING GIST (kruinlijn);

-- Klasse: Overbruggingsdeel
CREATE TABLE overbruggingsdeel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        otype character varying(255),
        hoortbijtype character varying(255),
        isbeweegbaar boolean,
        geom2d geometry(POLYGON,28992),
        lod0geom geometry(POLYGON,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX overbruggingsdeel_geom2d_idx on overbruggingsdeel USING GIST (geom2d);
CREATE INDEX overbruggingsdeel_lod0geom_idx on overbruggingsdeel USING GIST (lod0geom);

-- Klasse: Straatmeubilair
CREATE TABLE straatmeubilair (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POINT,28992),
        lod0geom geometry(POINT,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX straatmeubilair_geom2d_idx on straatmeubilair USING GIST (geom2d);
CREATE INDEX straatmeubilair_lod0geom_idx on straatmeubilair USING GIST (lod0geom);

-- Klasse: OndersteunendWaterdeel
CREATE TABLE ondersteunend_waterdeel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(POLYGON,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX ondersteunend_waterdeel_geom2d_idx on ondersteunend_waterdeel USING GIST (geom2d);

-- Klasse: OndersteunendWegdeel
CREATE TABLE ondersteunend_wegdeel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        optalud boolean,
        bgtfunctie character varying(255),
        bgt_fysiekvoorkomen character varying(255),
        plus_functie character varying(255),
        plus_fysiekvoorkomen character varying(255),
        geom2d geometry(POLYGON,28992),
        lod0geom geometry(POLYGON,28992),
        kruinlijn geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX ondersteunend_wegdeel_geom2d_idx on ondersteunend_wegdeel USING GIST (geom2d);
CREATE INDEX ondersteunend_wegdeel_lod0geom_idx on ondersteunend_wegdeel USING GIST (lod0geom);
CREATE INDEX ondersteunend_wegdeel_kruinlijn_idx on ondersteunend_wegdeel USING GIST (kruinlijn);

-- Klasse: Spoor
CREATE TABLE spoor (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgtfunctie character varying(255),
        plus_functie character varying(255),
        geom2d geometry(GEOMETRY,28992),
        lod0geom geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX spoor_geom2d_idx on spoor USING GIST (geom2d);
CREATE INDEX spoor_lod0geom_idx on spoor USING GIST (lod0geom);

-- Klasse: Weginrichtingselement
CREATE TABLE weginrichtingselement (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(GEOMETRY,28992),
        lod0geom geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX weginrichtingselement_geom2d_idx on weginrichtingselement USING GIST (geom2d);
CREATE INDEX weginrichtingselement_lod0geom_idx on weginrichtingselement USING GIST (lod0geom);

-- Klasse: VegetatieObject
CREATE TABLE vegetatieobject (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(GEOMETRY,28992),
        lod0geom geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX vegetatieobject_geom2d_idx on vegetatieobject USING GIST (geom2d);
CREATE INDEX vegetatieobject_lod0geom_idx on vegetatieobject USING GIST (lod0geom);

-- Klasse: Tunneldeel
CREATE TABLE tunneldeel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        geom2d geometry(POLYGON,28992),
        lod0geom geometry(POLYGON,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX tunneldeel_geom2d_idx on tunneldeel USING GIST (geom2d);
CREATE INDEX tunneldeel_lod0geom_idx on tunneldeel USING GIST (lod0geom);

-- Klasse: Waterinrichtingselement
CREATE TABLE waterinrichtingselement (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        bgt_type character varying(255),
        plus_type character varying(255),
        geom2d geometry(GEOMETRY,28992),
        lod0geom geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX waterinrichtingselement_geom2d_idx on waterinrichtingselement USING GIST (geom2d);
CREATE INDEX waterinrichtingselement_lod0geom_idx on waterinrichtingselement USING GIST (lod0geom);

-- Klasse: Wegdeel
CREATE TABLE wegdeel (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        optalud boolean,
        bgtfunctie character varying(255),
        plus_functie character varying(255),
        bgt_fysiekvoorkomen character varying(255),
        plus_fysiekvoorkomen character varying(255),
        geom2d geometry(POLYGON,28992),
        lod0geom geometry(POLYGON,28992),
        kruinlijn geometry(GEOMETRY,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX wegdeel_geom2d_idx on wegdeel USING GIST (geom2d);
CREATE INDEX wegdeel_lod0geom_idx on wegdeel USING GIST (lod0geom);
CREATE INDEX wegdeel_kruinlijn_idx on wegdeel USING GIST (kruinlijn);

-- Klasse: Pand
CREATE TABLE pand (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        identif_bagpnd character varying(255),
        geom2d geometry(MULTIPOLYGON,28992),
        nrar_1_tekst character varying(255),
        nrar_1_pos_1_pnt geometry(POINT,28992),
        nrar_1_pos_1_hoek float(23),
        nrar_1_pos_2_pnt geometry(POINT,28992),
        nrar_1_pos_2_hoek float(23),
        nrar_1_pos_3_pnt geometry(POINT,28992),
        nrar_1_pos_3_hoek float(23),
        nrar_1_id_bagvbo_min_huisnr character varying(255),
        nrar_1_id_bagvbo_max_huisnr character varying(255),
        nrar_2_tekst character varying(255),
        nrar_2_pos_1_pnt geometry(POINT,28992),
        nrar_2_pos_1_hoek float(23),
        nrar_2_pos_2_pnt geometry(POINT,28992),
        nrar_2_pos_2_hoek float(23),
        nrar_2_pos_3_pnt geometry(POINT,28992),
        nrar_2_pos_3_hoek float(23),
        nrar_2_id_bagvbo_min_huisnr character varying(255),
        nrar_2_id_bagvbo_max_huisnr character varying(255),
        nrar_3_tekst character varying(255),
        nrar_3_pos_1_pnt geometry(POINT,28992),
        nrar_3_pos_1_hoek float(23),
        nrar_3_pos_2_pnt geometry(POINT,28992),
        nrar_3_pos_2_hoek float(23),
        nrar_3_pos_3_pnt geometry(POINT,28992),
        nrar_3_pos_3_hoek float(23),
        nrar_3_id_bagvbo_min_huisnr character varying(255),
        nrar_3_id_bagvbo_max_huisnr character varying(255),
        PRIMARY KEY (identif)
);

CREATE INDEX pand_geom2d_idx on pand USING GIST (geom2d);
CREATE INDEX pand_nrar_1_pos_1_pnt_idx on pand USING GIST (nrar_1_pos_1_pnt);
CREATE INDEX pand_nrar_1_pos_2_pnt_idx on pand USING GIST (nrar_1_pos_2_pnt);
CREATE INDEX pand_nrar_1_pos_3_pnt_idx on pand USING GIST (nrar_1_pos_3_pnt);
CREATE INDEX pand_nrar_2_pos_1_pnt_idx on pand USING GIST (nrar_2_pos_1_pnt);
CREATE INDEX pand_nrar_2_pos_2_pnt_idx on pand USING GIST (nrar_2_pos_2_pnt);
CREATE INDEX pand_nrar_2_pos_3_pnt_idx on pand USING GIST (nrar_2_pos_3_pnt);
CREATE INDEX pand_nrar_3_pos_1_pnt_idx on pand USING GIST (nrar_3_pos_1_pnt);
CREATE INDEX pand_nrar_3_pos_2_pnt_idx on pand USING GIST (nrar_3_pos_2_pnt);
CREATE INDEX pand_nrar_3_pos_3_pnt_idx on pand USING GIST (nrar_3_pos_3_pnt);

-- Klasse: Buurt
CREATE TABLE buurt (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        buurtcode character varying(255),
        naam character varying(255),
        geom2d geometry(MULTIPOLYGON,28992),
        wijk character varying(255),
        PRIMARY KEY (identif)
);

CREATE INDEX buurt_geom2d_idx on buurt USING GIST (geom2d);

-- Klasse: Wijk
CREATE TABLE wijk (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        wijkcode character varying(255),
        naam character varying(255),
        geom2d geometry(MULTIPOLYGON,28992),
        stadsdeel character varying(255),
        PRIMARY KEY (identif)
);

CREATE INDEX wijk_geom2d_idx on wijk USING GIST (geom2d);

-- Klasse: OpenbareRuimte
CREATE TABLE openbareruimte (
        identif character varying(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging integer,
        bgt_status character varying(255),
        plus_status character varying(255),
        naam character varying(255),
        naam_id_opr character varying(255),
        geom2d geometry(MULTIPOLYGON,28992),
        PRIMARY KEY (identif)
);

CREATE INDEX openbareruimte_geom2d_idx on openbareruimte USING GIST (geom2d);
