-- upgrade RSGBBGT datamodel van 1.3.3 naar 1.3.4 (Oracle)

DELETE FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = 'RSGBBGT' AND F_TABLE_NAME = 'BEGROEID_TERREINDEEL' AND F_GEOMETRY_COLUMN = 'KRUINLIJN';
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('RSGBBGT','BEGROEID_TERREINDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');

DELETE FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = 'RSGBBGT' AND F_TABLE_NAME = 'ONDERSTEUNEND_WEGDEEL' AND F_GEOMETRY_COLUMN = 'KRUINLIJN';
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE) 
            VALUES ('RSGBBGT','ONDERSTEUNEND_WEGDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
            
DELETE FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = 'RSGBBGT' AND F_TABLE_NAME = 'ONBEGROEID_TERREINDEEL' AND F_GEOMETRY_COLUMN = 'KRUINLIJN';
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('RSGBBGT','ONBEGROEID_TERREINDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
            
DELETE FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = 'RSGBBGT' AND F_TABLE_NAME = 'WEGDEEL' AND F_GEOMETRY_COLUMN = 'KRUINLIJN';
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('RSGBBGT','WEGDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');


DROP INDEX BEGROEID_TERREINDEEL_KRUIN_IDX;
CREATE INDEX BEGROEID_TERREINDEEL_KRUIN_IDX ON BEGROEID_TERREINDEEL (KRUINLIJN)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

DROP INDEX ONBEGROEID_TERREINDEEL_KRU_IDX; 
CREATE INDEX ONBEGROEID_TERREINDEEL_KRU_IDX ON ONBEGROEID_TERREINDEEL (KRUINLIJN)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

DROP INDEX ODRSTEUN_WEGDEEL_KRUINLIJN_IDX;
CREATE INDEX ODRSTEUN_WEGDEEL_KRUINLIJN_IDX ON ONDERSTEUNEND_WEGDEEL (KRUINLIJN)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');

DROP INDEX WEGDEEL_KRUINLIJN_IDX;
CREATE INDEX WEGDEEL_KRUINLIJN_IDX ON WEGDEEL (KRUINLIJN)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=COLLECTION');
