/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEvent;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ExecutionEventNotifier;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.DatabaseSessionState;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.internal.StateSignatures;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.EndReplayCallback;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;
import oracle.jdbc.replay.driver.TxnFailoverManager;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableBfile;
import oracle.jdbc.replay.driver.TxnReplayableBlob;
import oracle.jdbc.replay.driver.TxnReplayableClob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableNClob;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;

public class TxnFailoverManagerImpl
implements TxnFailoverManager,
LogicalTransactionIdEventListener,
Monitor,
Diagnosable {
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private CallHistoryEntry sssHead;
    private CallHistoryEntry sssTail;
    private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
    private static final int DIRECTIVE_ENQUEUE_CALL = 1;
    private static final int DIRECTIVE_SESSSTATE_STABLE_CRSR = 2;
    private static final int DIRECTIVE_REQ_SCOPE_CRSR = 2;
    private static final int DIRECTIVE_REPLAY_ENABLED = 4;
    private static final int DIRECTIVE_EMPTY_QUEUE = 8;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout = 300L;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries = 0;
    private LogicalTransactionId ltxid = null;
    private LogicalTransactionId oldLtxidForPrepareReplay = null;
    private LogicalTransactionId ltxidAtOriginalOutage = null;
    private ReplayContext[] replayContext = null;
    private ReplayContext cxtBeforePrepareReplay;
    private OracleDataSource replayDataSource = null;
    private TxnReplayableBase connectionProxy;
    private oracle.jdbc.internal.OracleConnection originalOconn = null;
    private int lastCxtLenAtOriginalOutage = 0;
    private Method callHittingOutage;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private boolean doNotAbortConn = false;
    private boolean isReplayInDynamicMode = true;
    private ReplayableConnection.StateRestorationType stateRestorationType = ReplayableConnection.StateRestorationType.NONE;
    boolean isAutoAC = false;
    boolean isSSSCursorEnabled = false;
    boolean isHybrid = false;
    private Properties savedSessionProps = null;
    private Properties savedClientInfo = null;
    private boolean savedAutoCommit = true;
    private static final long SIG_FLAGS_NO_CHANGES = 1L;
    private static final long SIG_FLAGS_CLIENT_RESTORABLE_CHANGES = 2L;
    private static final long SIG_FLAGS_SERVER_RESTORABLE_CHANGES = 4L;
    private static final long SIG_FLAGS_SIDE_EFFECT_CHANGES = 8L;
    private static final long SIG_FLAGS_CAN_CHANGE_STATE = 16L;
    private static final long SIG_FLAGS_UNRESTORABLE_CHANGES = 32L;
    private static final long SIG_FLAGS_OVERFLOW_FULL = 64L;
    boolean needStateSignatureSyncUp = false;
    private DatabaseSessionState savedDatabaseSessionState = null;
    private static final int QUEUE_NUMBER = 2;
    private static final int NOT_IN_QUEUE = -1;
    private static int activeQueues = 2;
    private static final int INIT_EMPTY_COUNT = 0;
    private static final int NA_EMPTY_COUNT = -1;
    private static final int REQ_SCOPE_EMPTY_COUNT = Integer.MAX_VALUE;
    private int[] queueEmptyCounts = new int[2];
    boolean seenRoundtripCallInRequest = false;
    boolean originalSeenRoundtripCallInRequest = false;
    boolean didReplayingLastCallDisableReplay = false;
    short nestedLevelOfTopLevelCalls = 0;
    private static final HashSet<String> postExecuteGetCalls = new HashSet<String>(Arrays.asList("getGeneratedKeys", "getMoreResults", "getResultSet", "getUpdateCount", "getMetaData", "getArray", "getBigDecimal", "getBlob", "getBoolean", "getByte", "getBytes", "getCharacterStream", "getClob", "getDate", "getDouble", "getFloat", "getInt", "getLong", "getNCharacterStream", "getNClob", "getNString", "getObject", "getRef", "getRowId", "getShort", "getSQLXML", "getString", "getTime", "getTimestamp", "getURL", "wasNull", "getReturnResultSet", "getARRAY", "getAsciiStream", "getBFILE", "getBfile", "getBinaryStream", "getBLOB", "getCHAR", "getCLOB", "getCursor", "getCustomDatum", "getORAData", "getAnyDataEmbeddedObject", "getDATE", "getNUMBER", "getOPAQUE", "getOracleObject", "getRAW", "getREF", "getROWID", "getSTRUCT", "getINTERVALYM", "getINTERVALDS", "getTIMESTAMP", "getTIMESTAMPTZ", "getTIMESTAMPLTZ", "getUnicodeStream", "getPlsqlIndexTable", "getOraclePlsqlIndexTable"));
    private static final String NULL_METHOD_NAME = "NULL METHOD";
    ReplayStatisticsImpl acStatistics = null;
    private boolean callingDisableFromEndRequest = false;
    boolean lobStreamInRequest = false;
    int originalReadTimeout = 0;
    private static final int MIN_READ_TIMEOUT_RAC_DG = 120000;
    int requestSizeLimit = 0;
    int requestSize = 0;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";

        @Override
        public Thread newThread(Runnable r) {
            Thread newT = new Thread(null, r, THREAD_NAME);
            newT.setPriority(5);
            newT.setDaemon(true);
            return newT;
        }
    });
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();
    private boolean svrSupportsSignature = true;
    boolean inExplicitRequest = false;
    private int purgeCountForMain = 0;
    boolean replayingSSSQueue = false;
    boolean sssFetchOutage = false;
    ResultSet sssSavedRsetProxy = null;
    private Object userContext;
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnFailoverManagerImpl";
    static boolean seenMemoryPressure = false;
    static long seenMemoryPressureTS = 0L;
    static final long MEMORY_PRESSURE_REPORT_WINDOW = 120000L;
    private static final String PREPARE_REPLAY = "DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?); END;";
    private static final String PREPARE_REPLAY_2 = "DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER, sig_flags IN NUMBER, client_sig IN NUMBER, server_sig IN NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded, sig_flags, client_sig, server_sig); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?,?,?,?); END;";
    static final String NLS_CALENDAR_PROPERTY = "AUTH_NLS_LXCCALENDAR";
    static final String NLS_CURRENCY_PROPERTY = "AUTH_NLS_LXCCURRENCY";
    static final String NLS_DATE_FORMAT_PROPERTY = "AUTH_NLS_LXCDATEFM";
    static final String NLS_DATE_LANGUAGE_PROPERTY = "AUTH_NLS_LXCDATELANG";
    static final String NLS_DUAL_CURRENCY_PROPERTY = "AUTH_NLS_LXCUNIONCUR";
    static final String NLS_ISO_CURRENCY_PROPERTY = "AUTH_NLS_LXCISOCURR";
    static final String NLS_LANGUAGE_PROPERTY = "AUTH_NLS_LXLAN";
    static final String NLS_LENGTH_SEMANTICS_PROPERTY = "SESSION_NLS_LXCNLSLENSEM";
    static final String NLS_NCHAR_CONV_EXCP_PROPERTY = "SESSION_NLS_LXCNCHAREXCP";
    static final String NLS_NUMERIC_CHARACTERS_PROPERTY = "AUTH_NLS_LXCNUMERICS";
    static final String NLS_SORT_PROPERTY = "AUTH_NLS_LXCSORT";
    static final String NLS_TERRITORY_PROPERTY = "AUTH_NLS_LXCTERRITORY";
    static final String NLS_TIME_FORMAT_PROPERTY = "AUTH_NLS_LXCTIMEFM";
    static final String NLS_TIME_TZ_FORMAT_PROPERTY = "AUTH_NLS_LXCTTZNFM";
    static final String NLS_TIMESTAMP_FORMAT_PROPERTY = "AUTH_NLS_LXCSTMPFM";
    static final String NLS_TIMESTAMP_TZ_FORMAT_PROPERTY = "AUTH_NLS_LXCSTZNFM";
    static final String TIME_ZONE_PROPERTY = "SESSION_TIME_ZONE";
    static final String CONTAINER_PROPERTY = "CONTAINER_NAME";
    static final String SERVICE_PROPERTY = "SERVICE_NAME";
    static final String ERROR_OVERLAP_PROPERTY = "AL8KW_ERR_OVLAP";
    static final String SCHEMA_NAME_PROPERTY = "AL8KW_SCHEMA_NAME";
    static final String ENABLED_ROLE_NAMES_PROPERTY = "AL8KW_ENABLED_ROLE_NAMES";
    static final String EDITION_PROPERTY = "AUTH_ORA_EDITION";
    static final String SQL_TXLP_PROPERTY = "AL8KW_SQL_TXLP";
    static final String FSQL_SNTX_PROPERTY = "AL8KW_FSQL_SNTX";
    static final String ROW_ARCHIVAL_PROPERTY = "AL8KW_ROW_ARCHIVAL";
    static final String OPENCURSORS_PROPERTY = "AL8KW_OPENCURSORS";
    static final String CLIENT_INFO_PROPERTY = "AL8KW_CLIENT_INFO";
    private static final String CONTAINER_QUERY = "select sys_context('userenv','con_name') from dual";
    private static final String FAILOVER_TYPE_PROPERTY = "AUTH_FAILOVER_TYPE";
    private static final int FAILOVER_TYPE_TRANSACTION = 8;
    private static final int SESSION_STATE_CONSISTENCY_STATIC = 16;
    private static final int FAILOVER_TYPE_AUTO = 32;
    private static final int KWFCSFLAGS_RESTORE_AUTO = 2;
    private static final BigInteger MASK = new BigInteger("18446744073709551616");
    private static final MemGuardListener MEMGUARD_LISTENER = MemGuardListener.SOLE_INSTANCE;

    private TxnFailoverManagerImpl(TxnReplayableBase connProxy, OracleDataSource rds) throws SQLException {
        this.connectionProxy = connProxy;
        this.replayDataSource = rds;
        oracle.jdbc.internal.OracleConnection pconn = (oracle.jdbc.internal.OracleConnection)connProxy.getDelegate();
        this.ltxid = pconn.getLogicalTransactionId();
        this.replayContext = null;
        activeQueues = 2;
        this.queueEmptyCounts = new int[2];
        for (int i = 0; i < activeQueues; ++i) {
            this.queueEmptyCounts[i] = 0;
        }
        pconn.addLogicalTransactionIdEventListener(this);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "TxnFailoverManagerImpl", "On {0}, registered LTXID callback", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        this.acStatistics = new ReplayStatisticsImpl();
        this.replayDataSource.updateReplayStatistics(this.acStatistics);
        this.svrSupportsSignature = pconn.getVersionNumber() >= 18100;
    }

    static TxnFailoverManager getFailoverManager(TxnReplayableBase connProxy, OracleDataSource rds) throws SQLException {
        return new TxnFailoverManagerImpl(connProxy, rds);
    }

    private void append(CallHistoryEntry entry) {
        JDBCReplayable jdbcProxy;
        entry.prevEntry = this.tail;
        entry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = entry;
        }
        this.tail = entry;
        if (this.head == null) {
            this.head = entry;
        }
        if (!this.isSessionStateConsistencyDynamic()) {
            JDBCReplayable jdbcProxy2 = (JDBCReplayable)entry.jdbcProxy;
            jdbcProxy2.addToSameProxyList(entry);
        } else if (this.isAutoAC && this.isSSSCursorEnabled && (jdbcProxy = (JDBCReplayable)entry.jdbcProxy) instanceof TxnReplayableStatement) {
            jdbcProxy.addToSameProxyList(entry);
        }
    }

    private void remove(CallHistoryEntry entry) {
        if (entry.nextEntry != null) {
            entry.nextEntry.prevEntry = entry.prevEntry;
        }
        if (entry.prevEntry != null) {
            entry.prevEntry.nextEntry = entry.nextEntry;
        }
        if (this.head == entry) {
            this.head = entry.nextEntry;
        }
        if (this.tail == entry) {
            this.tail = entry.prevEntry;
        }
        if (this.isAutoAC && this.isSSSCursorEnabled || !this.isSessionStateConsistencyDynamic()) {
            JDBCReplayable jdbcProxy = (JDBCReplayable)entry.jdbcProxy;
            jdbcProxy.removeFromSameProxyList(entry);
        }
    }

    private void sssAppend(SSSCallHistoryEntry entry) {
        entry.prevEntry = this.sssTail;
        entry.nextEntry = null;
        if (this.sssTail != null) {
            this.sssTail.nextEntry = entry;
        }
        this.sssTail = entry;
        if (this.sssHead == null) {
            this.sssHead = entry;
        }
        TxnReplayableBase jdbcProxy = (TxnReplayableBase)entry.jdbcProxy;
        jdbcProxy.addToSSSSameProxyList(entry);
    }

    void sssRemove(SSSCallHistoryEntry entry) {
        if (entry.nextEntry != null) {
            entry.nextEntry.prevEntry = entry.prevEntry;
        }
        if (entry.prevEntry != null) {
            entry.prevEntry.nextEntry = entry.nextEntry;
        }
        if (this.sssHead == entry) {
            this.sssHead = entry.nextEntry;
        }
        if (this.sssTail == entry) {
            this.sssTail = entry.prevEntry;
        }
    }

    CallHistoryEntry record(Object jdbcProxy, Method m, Object[] args, String callStatus) {
        String threadName = Thread.currentThread().getName();
        if (threadName.startsWith("UCP-worker-thread-")) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "record", "On {0}, UCP thread {1} making unexpected capturing call, SKIP recording method {2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), threadName, m.getName()});
            return null;
        }
        this.checkMemoryPressureAndLog();
        if (this.tail != null && this.tail.method != null && "started".equals(this.tail.callStatus)) {
            this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls + 1);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "record", "On {0}, SKIP recording method {1}, nested-level: {2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), m.getName(), this.nestedLevelOfTopLevelCalls});
            return null;
        }
        if (++this.requestSize > this.requestSizeLimit) {
            this.disableReplayInternal(m, 367, "Replay disabled because request size exceeded limit", null);
            return null;
        }
        this.acStatistics.incrementTotalProtectedCalls();
        this.acStatistics.incrementCurrentRequestSize();
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            CallHistoryEntry entry = new CallHistoryEntry(jdbcProxy, m, args, callStatus);
            this.append(entry);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "record", "On {0}, recording method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), m.getName()});
            CallHistoryEntry callHistoryEntry = entry;
            return callHistoryEntry;
        }
    }

    private String dumpHistory() {
        Object ret = "Dump History: \n";
        if (this.head != null) {
            CallHistoryEntry entry = this.head;
            while (true) {
                ret = (String)ret + entry.toString();
                if (entry == this.tail) break;
                entry = entry.nextEntry;
            }
        }
        return ret;
    }

    String dumpSSSHistory() {
        Object ret = "Dump SSS History: \n";
        if (this.sssHead != null) {
            CallHistoryEntry entry = this.sssHead;
            while (true) {
                ret = (String)ret + entry.toString();
                if (entry == this.sssTail) break;
                entry = entry.nextEntry;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Object jdbcProxy, CallHistoryEntry e, Object result, String callStatus, long checksum, SQLException sqlexc) {
        OracleStatement ostmt;
        TxnReplayableStatement stmtProxy;
        short thisReplayQueueId;
        int replayDirective;
        ReplayContext thisReplayContext;
        int i;
        CallHistoryEntry entry;
        String threadName = Thread.currentThread().getName();
        if (threadName.startsWith("UCP-worker-thread-")) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, UCP thread {1} making unexpected capturing call, SKIP updating method {2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), threadName, this.tail != null ? this.tail.method.getName() : "NULL_METHOD"});
            return;
        }
        if (this.nestedLevelOfTopLevelCalls > 0) {
            this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls - 1);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, SKIP updating method", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
            return;
        }
        ReplayContext[] drvrReplayContext = null;
        boolean disableReplayFlag = false;
        ReplayContext[] contextToRecord = null;
        int queueIdToRecord = -1;
        int queueEmptyCountToRecord = 0;
        boolean requestScopeCursor = false;
        boolean serverAsksToEnqueue = false;
        try {
            oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
            drvrReplayContext = oconn.getReplayContext();
            CallHistoryEntry callHistoryEntry = entry = e == null ? this.tail : e;
        }
        catch (SQLException exc) {
            try {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, could not get ReplayContext: {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), exc});
                disableReplayFlag = true;
                CallHistoryEntry callHistoryEntry = entry = e == null ? this.tail : e;
            }
            catch (Throwable throwable) {
                CallHistoryEntry entry2;
                CallHistoryEntry callHistoryEntry = entry2 = e == null ? this.tail : e;
                if (!disableReplayFlag) {
                    if (drvrReplayContext != null) {
                        this.replayContext = drvrReplayContext;
                        contextToRecord = new ReplayContext[drvrReplayContext.length];
                        if (drvrReplayContext.length > 0) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, roundtrip in current request", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                            this.seenRoundtripCallInRequest = true;
                            this.needStateSignatureSyncUp = false;
                        }
                        for (int i2 = 0; i2 < drvrReplayContext.length; ++i2) {
                            ReplayContext thisReplayContext2 = drvrReplayContext[i2];
                            int replayDirective2 = (int)thisReplayContext2.getDirectives();
                            short thisReplayQueueId2 = thisReplayContext2.getQueue();
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, new CM directive (in binary): {1}, queue Id: {2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), Integer.toBinaryString(replayDirective2), (int)thisReplayQueueId2});
                            if ((replayDirective2 & 4) == 0) {
                                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: DISABLE REPLAY", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                                disableReplayFlag = true;
                                if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                    this.didReplayingLastCallDisableReplay = true;
                                }
                                long svrErrorCode = thisReplayContext2.getErrorCode();
                                this.disableReplayInternal(entry2.method, 384, "Replay disabled by server Continuity Management", null);
                                return;
                            }
                            if ((replayDirective2 & 8) == 8) {
                                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: EMPTY_QUEUE({1})", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), (int)thisReplayQueueId2});
                                short s = thisReplayQueueId2;
                                this.queueEmptyCounts[s] = this.queueEmptyCounts[s] + 1;
                            }
                            assert ((replayDirective2 & 1) == 1 || !serverAsksToEnqueue) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                            if ((replayDirective2 & 1) == 1) {
                                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: RECORD CALL", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                                contextToRecord[i2] = thisReplayContext2;
                                queueIdToRecord = thisReplayQueueId2;
                                queueEmptyCountToRecord = this.queueEmptyCounts[thisReplayQueueId2];
                                serverAsksToEnqueue = true;
                            }
                            if (this.isSSSCursorEnabled && (replayDirective2 & 2) == 2) {
                                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: SESSION STATE STABLE CURSOR", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                                if (jdbcProxy instanceof TxnReplayableStatement) {
                                    TxnReplayableStatement stmtProxy2 = (TxnReplayableStatement)jdbcProxy;
                                    stmtProxy2.isSSSCursor = true;
                                    OracleStatement ostmt2 = (OracleStatement)stmtProxy2.getDelegate();
                                    try {
                                        ostmt2.markSSSCursor();
                                    }
                                    catch (SQLException sQLException) {}
                                } else {
                                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server sent SESSION STATE STABLE CURSOR directive on wrong calls", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                                }
                            }
                            if (this.isSSSCursorEnabled || (replayDirective2 & 2) != 2) continue;
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: REQUEST-SCOPE CURSOR", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                            requestScopeCursor = true;
                        }
                    } else {
                        if (entry2.replayContext != null) {
                            return;
                        }
                        queueIdToRecord = -1;
                        queueEmptyCountToRecord = 0;
                    }
                } else {
                    this.disableReplayInternal(entry2.method, 383, "Replay disabled because getting replay context failed", null);
                }
                throw throwable;
            }
            if (!disableReplayFlag) {
                if (drvrReplayContext != null) {
                    this.replayContext = drvrReplayContext;
                    contextToRecord = new ReplayContext[drvrReplayContext.length];
                    if (drvrReplayContext.length > 0) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, roundtrip in current request", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                        this.seenRoundtripCallInRequest = true;
                        this.needStateSignatureSyncUp = false;
                    }
                    for (i = 0; i < drvrReplayContext.length; ++i) {
                        thisReplayContext = drvrReplayContext[i];
                        replayDirective = (int)thisReplayContext.getDirectives();
                        thisReplayQueueId = thisReplayContext.getQueue();
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, new CM directive (in binary): {1}, queue Id: {2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), Integer.toBinaryString(replayDirective), (int)thisReplayQueueId});
                        if ((replayDirective & 4) == 0) {
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: DISABLE REPLAY", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                            disableReplayFlag = true;
                            if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                this.didReplayingLastCallDisableReplay = true;
                            }
                            long svrErrorCode = thisReplayContext.getErrorCode();
                            this.disableReplayInternal(entry.method, 384, "Replay disabled by server Continuity Management", null);
                            return;
                        }
                        if ((replayDirective & 8) == 8) {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: EMPTY_QUEUE({1})", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), (int)thisReplayQueueId});
                            short s = thisReplayQueueId;
                            this.queueEmptyCounts[s] = this.queueEmptyCounts[s] + 1;
                        }
                        assert ((replayDirective & 1) == 1 || !serverAsksToEnqueue) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                        if ((replayDirective & 1) == 1) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: RECORD CALL", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                            contextToRecord[i] = thisReplayContext;
                            queueIdToRecord = thisReplayQueueId;
                            queueEmptyCountToRecord = this.queueEmptyCounts[thisReplayQueueId];
                            serverAsksToEnqueue = true;
                        }
                        if (this.isSSSCursorEnabled && (replayDirective & 2) == 2) {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: SESSION STATE STABLE CURSOR", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                            if (jdbcProxy instanceof TxnReplayableStatement) {
                                stmtProxy = (TxnReplayableStatement)jdbcProxy;
                                stmtProxy.isSSSCursor = true;
                                ostmt = (OracleStatement)stmtProxy.getDelegate();
                                try {
                                    ostmt.markSSSCursor();
                                }
                                catch (SQLException sQLException) {}
                            } else {
                                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server sent SESSION STATE STABLE CURSOR directive on wrong calls", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                            }
                        }
                        if (this.isSSSCursorEnabled || (replayDirective & 2) != 2) continue;
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: REQUEST-SCOPE CURSOR", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                        requestScopeCursor = true;
                    }
                } else {
                    if (entry.replayContext != null) {
                        return;
                    }
                    queueIdToRecord = -1;
                    queueEmptyCountToRecord = 0;
                }
            } else {
                this.disableReplayInternal(entry.method, 383, "Replay disabled because getting replay context failed", null);
            }
        }
        if (!disableReplayFlag) {
            if (drvrReplayContext != null) {
                this.replayContext = drvrReplayContext;
                contextToRecord = new ReplayContext[drvrReplayContext.length];
                if (drvrReplayContext.length > 0) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, roundtrip in current request", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                    this.seenRoundtripCallInRequest = true;
                    this.needStateSignatureSyncUp = false;
                }
                for (i = 0; i < drvrReplayContext.length; ++i) {
                    thisReplayContext = drvrReplayContext[i];
                    replayDirective = (int)thisReplayContext.getDirectives();
                    thisReplayQueueId = thisReplayContext.getQueue();
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, new CM directive (in binary): {1}, queue Id: {2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), Integer.toBinaryString(replayDirective), (int)thisReplayQueueId});
                    if ((replayDirective & 4) == 0) {
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: DISABLE REPLAY", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                        disableReplayFlag = true;
                        if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                            this.didReplayingLastCallDisableReplay = true;
                        }
                        long svrErrorCode = thisReplayContext.getErrorCode();
                        this.disableReplayInternal(entry.method, 384, "Replay disabled by server Continuity Management", null);
                        return;
                    }
                    if ((replayDirective & 8) == 8) {
                        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: EMPTY_QUEUE({1})", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), (int)thisReplayQueueId});
                        short s = thisReplayQueueId;
                        this.queueEmptyCounts[s] = this.queueEmptyCounts[s] + 1;
                    }
                    assert ((replayDirective & 1) == 1 || !serverAsksToEnqueue) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                    if ((replayDirective & 1) == 1) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: RECORD CALL", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                        contextToRecord[i] = thisReplayContext;
                        queueIdToRecord = thisReplayQueueId;
                        queueEmptyCountToRecord = this.queueEmptyCounts[thisReplayQueueId];
                        serverAsksToEnqueue = true;
                    }
                    if (this.isSSSCursorEnabled && (replayDirective & 2) == 2) {
                        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: SESSION STATE STABLE CURSOR", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                        if (jdbcProxy instanceof TxnReplayableStatement) {
                            stmtProxy = (TxnReplayableStatement)jdbcProxy;
                            stmtProxy.isSSSCursor = true;
                            ostmt = (OracleStatement)stmtProxy.getDelegate();
                            try {
                                ostmt.markSSSCursor();
                            }
                            catch (SQLException sQLException) {}
                        } else {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server sent SESSION STATE STABLE CURSOR directive on wrong calls", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                        }
                    }
                    if (this.isSSSCursorEnabled || (replayDirective & 2) != 2) continue;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, server instructs: REQUEST-SCOPE CURSOR", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                    requestScopeCursor = true;
                }
            } else {
                if (entry.replayContext != null) {
                    return;
                }
                queueIdToRecord = -1;
                queueEmptyCountToRecord = 0;
            }
        } else {
            this.disableReplayInternal(entry.method, 383, "Replay disabled because getting replay context failed", null);
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED && this.tail != null) {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                CallHistoryEntry entry3 = e == null ? this.tail : e;
                String methodName = entry3 == null || entry3.method == null ? NULL_METHOD_NAME : entry3.method.getName();
                entry3.result = result instanceof TxnReplayableBase || result instanceof OracleConcreteProxy ? result : null;
                entry3.checksum = checksum;
                if (contextToRecord != null) {
                    if (entry3.replayContext == null) {
                        entry3.replayContext = contextToRecord;
                    } else {
                        ReplayContext[] multipleRPCContexts = new ReplayContext[entry3.replayContext.length + contextToRecord.length];
                        System.arraycopy(entry3.replayContext, 0, multipleRPCContexts, 0, entry3.replayContext.length);
                        System.arraycopy(contextToRecord, 0, multipleRPCContexts, entry3.replayContext.length, contextToRecord.length);
                        entry3.replayContext = multipleRPCContexts;
                    }
                }
                entry3.callException = sqlexc;
                entry3.queueId = queueIdToRecord;
                entry3.queueEmptyCount = queueEmptyCountToRecord;
                entry3.serverAsksToEnqueue = serverAsksToEnqueue;
                entry3.callStatus = callStatus;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, updated method {1} - result: {2}, ReplayContext: {3}, checksum: {4}, SQLException: {5}, queue Id: {6}, empty count: {7}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), methodName, result, contextToRecord, checksum, sqlexc, queueIdToRecord, queueEmptyCountToRecord});
                if (contextToRecord != null) {
                    for (ReplayContext thisReplayContext3 : contextToRecord) {
                        if (thisReplayContext3 == null) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, updated replay context: NULL", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                            continue;
                        }
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "update", "On {0}, updated replay context: NOT NULL", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                    }
                }
                if (!this.isSessionStateConsistencyDynamic() && requestScopeCursor) {
                    CallHistoryEntry stmtExecEntry = ((TxnReplayableResultSet)entry3.jdbcProxy).creatorCallEntry;
                    stmtExecEntry.queueEmptyCount = Integer.MAX_VALUE;
                }
            }
        }
    }

    void purge() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.head = null;
            this.tail = null;
            this.connectionProxy.headSameProxy = null;
            this.connectionProxy.tailSameProxy = null;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "purge", "On {0}, explicit purge succeeds", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        }
    }

    void sssPurge() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            CallHistoryEntry entry = this.sssHead;
            while (entry != null) {
                this.sssRemove((SSSCallHistoryEntry)entry);
                JDBCReplayable jdbcProxy = (JDBCReplayable)entry.jdbcProxy;
                if (jdbcProxy instanceof TxnReplayableStatement && entry.method.getName().startsWith("execute")) {
                    ((TxnReplayableStatement)jdbcProxy).sssHeadSameProxy = null;
                    ((TxnReplayableStatement)jdbcProxy).sssTailSameProxy = null;
                }
                entry = entry.nextEntry;
            }
            this.sssHead = null;
            this.sssTail = null;
            this.connectionProxy.sssHeadSameProxy = null;
            this.connectionProxy.sssTailSameProxy = null;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "sssPurge", "On {0}, explicit purge on SSS queue succeeds", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        }
    }

    void purgeForSameProxy(Set<Object> visitedProxies, CallHistoryEntry headForProxy) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Object jproxy = headForProxy == null ? null : headForProxy.jdbcProxy;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "purgeForSameProxy", "On {0}, implicit purge for {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), jproxy});
            CallHistoryEntry entry = headForProxy;
            while (entry != null) {
                Object callResult = entry.result;
                if (callResult != null && callResult instanceof JDBCReplayable && !visitedProxies.contains(callResult)) {
                    JDBCReplayable resultProxy = (JDBCReplayable)callResult;
                    resultProxy.purgeSameProxyList();
                    visitedProxies.add(resultProxy);
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "purgeForSameProxy", "On {0}, implicit purge method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), entry.method.getName()});
                this.remove(entry);
                entry = entry.nextEntrySameProxy;
            }
        }
    }

    void purgeForSSSSameProxy(Set<Object> visitedProxies, CallHistoryEntry headForProxy) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Object jproxy = headForProxy == null ? null : headForProxy.jdbcProxy;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "purgeForSSSSameProxy", "On {0}, implicit SSS purge for {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), jproxy});
            CallHistoryEntry entry = headForProxy;
            while (entry != null) {
                Object callResult = entry.result;
                if (callResult != null && callResult instanceof TxnReplayableBase && !visitedProxies.contains(callResult)) {
                    TxnReplayableBase resultProxy = (TxnReplayableBase)callResult;
                    resultProxy.purgeSSSSameProxyList();
                    visitedProxies.add(resultProxy);
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "purgeForSSSSameProxy", "On {0}, implicit purge SSS method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), entry.method.getName()});
                this.sssRemove((SSSCallHistoryEntry)entry);
                entry = entry.nextEntrySameProxy;
            }
        }
    }

    SSSCallHistoryEntry copyFromMainToSSSQueue(CallHistoryEntry entry) {
        SSSCallHistoryEntry newEntry = new SSSCallHistoryEntry(entry);
        this.sssAppend(newEntry);
        newEntry.queueEmptyCount = this.purgeCountForMain;
        entry.openAcrossPurge = true;
        return newEntry;
    }

    void copyExecCallFromMainToSSSQueue(CallHistoryEntry entry) {
        SSSCallHistoryEntry newEntry = new SSSCallHistoryEntry(entry);
        this.sssAppend(newEntry);
        newEntry.queueEmptyCount = this.purgeCountForMain;
        entry.openAcrossPurge = true;
    }

    boolean isEmpty() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.head == null;
            return bl;
        }
    }

    boolean isSSSQueueEmpty() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.sssHead == null;
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    Object handleOutage(Method failedCall, SQLRecoverableException origError) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Object handleOutageInternal(SQLRecoverableException origError, int currentRetries) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On {0}, Entering replay, original error={1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), origError});
            this.acStatistics.incrementTotalReplayAttempts();
            this.didReplayingLastCallDisableReplay = false;
            if (currentRetries == 0) {
                this.ltxidAtOriginalOutage = this.ltxid;
                if (this.tail != null) {
                    this.lastCxtLenAtOriginalOutage = this.tail.replayContext == null ? 0 : this.tail.replayContext.length;
                }
            }
            ReplayLifecycle curLifecycle = this.lifecycle;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "current lifecycle:{0}", (String)null, (Throwable)null, (Object)curLifecycle);
            if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                if (this.replayErrorCode == 0) {
                    this.doNotAbortConn = true;
                    this.replayErrorCode = 370;
                    this.replayErrorMessage = "Replay disabled";
                }
                this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, origError);
            }
            if (this.lifecycle == ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                this.acStatistics.incrementTotalCallsTriggeringReplay();
            }
            if (currentRetries == 0) {
                this.originalOconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
                this.originalSeenRoundtripCallInRequest = this.seenRoundtripCallInRequest;
            }
            short fncode = this.originalOconn.getExecutingRPCFunctionCode();
            TraceEventListener traceEventListener = this.originalOconn.getTraceEventListener();
            this.userContext = new ExecutionEventNotifier().setTraceEventListener(traceEventListener).setJdbcExecutionEvent(TraceEventListener.JdbcExecutionEvent.AC_REPLAY_STARTED).setUserContext(this.userContext).addParam(origError.getMessage()).addParam(origError.getErrorCode()).addParam(origError.getSQLState()).addParam(currentRetries).sendNotification();
            if (!(this.originalSeenRoundtripCallInRequest || fncode != 0 || this.isSSSCursorEnabled && this.sssFetchOutage)) {
                this.replayResult = this.replayWithLocalCallsOnly(origError, currentRetries);
            } else {
                oracle.jdbc.internal.OracleConnection newConn;
                boolean wasOldConnProxySession = this.originalOconn.isProxySession();
                boolean ac = ((TxnReplayableConnection)this.connectionProxy).autoCommitBeforeOutage;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On {0}, original connection: {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), this.originalOconn});
                fncode = this.originalOconn.getExecutingRPCFunctionCode();
                String sql = this.originalOconn.getExecutingRPCSQL();
                this.cxtBeforePrepareReplay = this.originalOconn.getLastReplayContext();
                if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL && this.tail.replayContext != null && this.tail.replayContext.length > this.lastCxtLenAtOriginalOutage) {
                    if (this.lastCxtLenAtOriginalOutage == 0) {
                        this.tail.replayContext = null;
                    } else {
                        for (int i = this.lastCxtLenAtOriginalOutage; i < this.tail.replayContext.length; ++i) {
                            this.tail.replayContext[i] = null;
                        }
                    }
                }
                if ((newConn = (oracle.jdbc.internal.OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalConnectionBuilder)) == null) {
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "FAILOVER_RETRIES exceeded", null, null);
                    this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", origError);
                }
                if (!this.checkACChange(newConn)) {
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "Reconnected to instance with different AC configuration", null, null);
                    this.disableReplayAndThrowException(null, 369, "Replay disabled because it reconnected to AC-disabled instance", origError);
                }
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "Reconnect succeeded, new connection={0}", (String)null, (Throwable)null, (Object)newConn);
                newConn.enableDiagnoseFirstFailureDump(false);
                this.connectionProxy.setDelegate(newConn);
                newConn.setACProxy(this.connectionProxy);
                if (this.isAutoAC && this.isSSSCursorEnabled && this.isHybrid) {
                    newConn.setSSSHybrid(this.isHybrid);
                }
                this.originalReadTimeout = ((OracleConnection)newConn).getNetworkTimeout();
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On reconnect, original READ_TIMEOUT={0}", (String)null, (Throwable)null, (Object)this.originalReadTimeout);
                if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                    ((OracleConnection)newConn).setNetworkTimeout(executor, 120000);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On reconnect, new temporary READ_TIMEOUT={0}", (String)null, (Throwable)null, (Object)((OracleConnection)newConn).getNetworkTimeout());
                }
                newConn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
                this.oldLtxidForPrepareReplay = this.ltxid;
                if (wasOldConnProxySession) {
                    this.invokeCallbackAfterReconnect(newConn, false, origError, true);
                    this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
                }
                this.ltxid = newConn.getLogicalTransactionId();
                newConn.addLogicalTransactionIdEventListener(this);
                String mname = this.isSSSCursorEnabled && this.sssFetchOutage ? "next" : this.tail.method.getName();
                newConn.setReplayContext(new ReplayContext[]{this.cxtBeforePrepareReplay});
                ReplayContext lastCxtInTail = this.lastCxtLenAtOriginalOutage == 0 ? null : (this.tail.replayContext == null ? null : this.tail.replayContext[this.lastCxtLenAtOriginalOutage - 1]);
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On {0}, PREPARE_REPLAY replay-context: {1}, last context in failed call: {2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), this.cxtBeforePrepareReplay, lastCxtInTail});
                boolean committed = this.prepareReplay(newConn, origError, ac, fncode, sql);
                if (committed) {
                    if (this.isSessionStateConsistencyDynamic()) {
                        if (mname.equals("execute")) {
                            Boolean bl = false;
                            return bl;
                        }
                        if (mname.equals("commit")) {
                            Object var14_19 = null;
                            return var14_19;
                        }
                        Object var14_20 = null;
                        return var14_20;
                    }
                    this.queueEmptyCounts[1] = this.queueEmptyCounts[1] + 1;
                }
                long currentTimestamp = System.currentTimeMillis();
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "timestamp at replay start: {0}", (String)null, (Throwable)null, (Object)currentTimestamp);
                if (this.requestStartTime + this.replayInitiationTimeout * 1000L < currentTimestamp) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "ReplayInitiationTimeout exceeded", null, null);
                    this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", origError);
                }
                if (wasOldConnProxySession && this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.LEVEL1) >= 0) {
                    newConn.setDatabaseSessionState(this.savedDatabaseSessionState);
                }
                newConn.getReplayContext();
                if (!wasOldConnProxySession) {
                    this.invokeCallbackAfterReconnect(newConn, true, origError, false);
                }
                this.lifecycle = ReplayLifecycle.REPLAYING;
                this.beginReplay(newConn, origError);
                if (this.isAutoAC && this.isSSSCursorEnabled && this.sssHead != null) {
                    this.replayResult = this.replayAllInSSSQueue(origError);
                }
                this.replayResult = this.replayAllBeforeLastCall(origError);
                if (this.isSSSCursorEnabled && this.sssFetchOutage) {
                    this.replayResult = this.replayLastCall(origError);
                }
                if (this.isSSSCursorEnabled && this.sssFetchOutage || this.tail.replayContext == null || this.tail.replayContext.length == 0) {
                    this.endReplay(newConn, origError);
                } else {
                    newConn.registerEndReplayCallback(new EndReplayCallback(this, newConn, origError));
                }
                if (!committed) {
                    if (this.isSSSCursorEnabled && this.sssFetchOutage) {
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On {0}, SSS-cursor fetch outage, SKIP replaying next() as last call", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                        this.replayResult = true;
                    } else {
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On {0}, replaying last call", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                        this.replayResult = this.replayLastCall(origError);
                    }
                } else if (!this.isSessionStateConsistencyDynamic()) {
                    this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On {0}, last call committed, skipping replay", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                    this.tail.callStatus = "completed";
                    this.tail.queueId = 1;
                    this.tail.queueEmptyCount = this.queueEmptyCounts[1];
                    this.tail.serverAsksToEnqueue = false;
                    this.replayResult = mname.equals("execute") ? Boolean.valueOf(false) : (mname.equals("commit") ? null : null);
                } else {
                    this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On {0}, unexpected case: replay after committed in dynamic mode", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                }
                if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                    ((OracleConnection)newConn).setNetworkTimeout(executor, this.originalReadTimeout);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "Reset to original READ_TIMEOUT={0}", (String)null, (Throwable)null, (Object)((OracleConnection)newConn).getNetworkTimeout());
                }
                if (!(this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL || this.sssFetchOutage || this.tail == null || this.tail.replayContext != null && this.tail.replayContext.length != 0)) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "last call was local, copy over last replay context: {0}", (String)null, (Throwable)null, (Object)this.cxtBeforePrepareReplay);
                    newConn.setLastReplayContext(this.cxtBeforePrepareReplay);
                }
            }
            if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
            }
            this.acStatistics.incrementSuccessfulReplayCount();
            this.originalOconn = null;
            this.sssFetchOutage = false;
            this.sssSavedRsetProxy = null;
            this.userContext = new ExecutionEventNotifier().setTraceEventListener(traceEventListener).setJdbcExecutionEvent(TraceEventListener.JdbcExecutionEvent.AC_REPLAY_SUCCESSFUL).setUserContext(this.userContext).addParam(origError.getMessage()).addParam(origError).addParam(currentRetries).sendNotification();
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On {0}, replay succeeds", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "handleOutageInternal", "On {0}, Exiting replay, result={1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), this.replayResult});
            Object object = this.replayResult;
            return object;
        }
    }

    Object replayWithLocalCallsOnly(SQLRecoverableException origError, int currentRetries) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean wasOldConnProxySession = this.originalOconn.isProxySession();
            oracle.jdbc.internal.OracleConnection newConn = (oracle.jdbc.internal.OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalConnectionBuilder);
            if (newConn == null) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "FAILOVER_RETRIES exceeded", null, null);
                this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", origError);
            }
            if (!this.checkACChange(newConn)) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "Reconnected to instance with different AC configuration", null, null);
                this.disableReplayAndThrowException(null, 369, "Replay disabled because it reconnected to AC-disabled instance", origError);
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "Reconnect succeeded (LOCAL CALLS ONLY), new connection={0}", (String)null, (Throwable)null, (Object)newConn);
            newConn.enableDiagnoseFirstFailureDump(false);
            this.connectionProxy.setDelegate(newConn);
            newConn.setACProxy(this.connectionProxy);
            if (this.isAutoAC && this.isSSSCursorEnabled && this.isHybrid) {
                newConn.setSSSHybrid(this.isHybrid);
            }
            this.originalReadTimeout = ((OracleConnection)newConn).getNetworkTimeout();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "On reconnect, original READ_TIMEOUT={0}", (String)null, (Throwable)null, (Object)this.originalReadTimeout);
            if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                ((OracleConnection)newConn).setNetworkTimeout(executor, 120000);
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "On reconnect, new temporary READ_TIMEOUT={0}", (String)null, (Throwable)null, (Object)((OracleConnection)newConn).getNetworkTimeout());
            }
            newConn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
            if (wasOldConnProxySession) {
                this.invokeCallbackAfterReconnect(newConn, false, origError, true);
                this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
            }
            this.ltxid = newConn.getLogicalTransactionId();
            newConn.addLogicalTransactionIdEventListener(this);
            long currentTimestamp = System.currentTimeMillis();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "timestamp at replay start: {0}", (String)null, (Throwable)null, (Object)currentTimestamp);
            if (this.requestStartTime + this.replayInitiationTimeout * 1000L < currentTimestamp) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "ReplayInitiationTimeout exceeded", null, null);
                this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", origError);
            }
            if (!wasOldConnProxySession) {
                this.invokeCallbackAfterReconnect(newConn, false, origError, false);
            }
            newConn.getReplayContext();
            if (newConn.serverSupportsExplicitBoundaryBit()) {
                if (this.isReplayInDynamicMode) {
                    newConn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_EXPL_BOUND));
                } else {
                    newConn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_EXPL_BOUND));
                }
            } else if (this.isReplayInDynamicMode) {
                newConn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            } else {
                newConn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "Sent BEGIN_REQUEST and ENABLE to server", null, null);
            this.lifecycle = ReplayLifecycle.REPLAYING;
            this.replayResult = this.replayAllBeforeLastCall(origError);
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "On {0}, replaying last call", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
            this.replayResult = this.replayLastCall(origError);
            if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                ((OracleConnection)newConn).setNetworkTimeout(executor, this.originalReadTimeout);
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "replayWithLocalCallsOnly", "Reset to original READ_TIMEOUT={0}", (String)null, (Throwable)null, (Object)((OracleConnection)newConn).getNetworkTimeout());
            }
            Object object = this.replayResult;
            return object;
        }
    }

    private void invokeCallbackAfterReconnect(oracle.jdbc.internal.OracleConnection newConnection, boolean sendTemplate, SQLRecoverableException originalError, boolean wasOldConnProxySession) throws SQLException {
        this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
        switch (this.stateRestorationType) {
            case NONE: {
                this.restoreAutoCommit(newConnection);
                break;
            }
            case LEVEL1: 
            case LEVEL2: 
            case AUTO: {
                if (wasOldConnProxySession) break;
                this.restoreCommonSessionState(newConnection, sendTemplate);
            }
        }
        ConnectionInitializationCallback initCbk = this.replayDataSource.getConnectionInitializationCallback();
        if (initCbk != null) {
            try {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "invokeCallbackAfterReconnect", "Invoking Replay Driver initialization callback with {0}", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                initCbk.initialize((Connection)((Object)this.connectionProxy));
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "invokeCallbackAfterReconnect", "Invoking initialization callback with {0} succeeded", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
            }
            catch (SQLRecoverableException sqlrexc) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "invokeCallbackAfterReconnect", "Invoking initialization callback with {0} hit outage", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                throw sqlrexc;
            }
            catch (SQLException sqlexc) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "invokeCallbackAfterReconnect", "Invoking initialization callback with {0} failed", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", originalError);
            }
            if (newConnection.inLocalTransaction()) {
                this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", originalError);
            }
        }
        switch (this.stateRestorationType) {
            case LEVEL1: 
            case LEVEL2: 
            case AUTO: {
                if (!wasOldConnProxySession) break;
                this.restoreCommonSessionState(newConnection, sendTemplate);
            }
        }
    }

    private Object replayAllInSSSQueue(SQLRecoverableException origError) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            TxnReplayableBase jproxy;
            String methodName;
            Object replayResult = null;
            this.replayingSSSQueue = true;
            CallHistoryEntry entry = this.sssHead;
            while (entry != this.sssTail) {
                methodName = entry.method == null ? NULL_METHOD_NAME : entry.method.getName();
                jproxy = (TxnReplayableBase)entry.jdbcProxy;
                this.checkMemoryPressureAndLog();
                if (entry.queueEmptyCount < this.purgeCountForMain) {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayAllInSSSQueue", "On {0}, replaying SSS method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), methodName});
                    replayResult = jproxy.replayOneCall(entry, origError);
                    if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                        this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, origError);
                    }
                } else {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayAllInSSSQueue", "On {0}, SKIP replaying SSS method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), methodName});
                }
                entry = entry.nextEntry;
            }
            entry = this.sssTail;
            methodName = entry.method == null ? NULL_METHOD_NAME : entry.method.getName();
            jproxy = (TxnReplayableBase)entry.jdbcProxy;
            if (entry.queueEmptyCount < this.purgeCountForMain) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayAllInSSSQueue", "On {0}, replaying last SSS method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), methodName});
                replayResult = jproxy.replayOneCall(entry, origError);
                if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                    this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, origError);
                }
            } else {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayAllInSSSQueue", "On {0}, SKIP replaying last SSS method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), methodName});
            }
            Object object = replayResult;
            return object;
        }
    }

    private Object replayAllBeforeLastCall(SQLRecoverableException origError) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Object replayResult = null;
            this.replayingSSSQueue = false;
            CallHistoryEntry entry = this.head;
            while (entry != this.tail) {
                TxnReplayableBase concreteProxy;
                String methodName = entry.method == null ? NULL_METHOD_NAME : entry.method.getName();
                TxnReplayableBase jproxy = (TxnReplayableBase)entry.jdbcProxy;
                this.checkMemoryPressureAndLog();
                if (this.isSessionStateConsistencyDynamic() && (entry.replayContext == null || entry.serverAsksToEnqueue) || !this.isSessionStateConsistencyDynamic() && jproxy.isCreatingCallReplayable && jproxy.isProxyReplayable && (entry.replayContext == null && !postExecuteGetCalls.contains(methodName) || entry.replayContext == null && postExecuteGetCalls.contains(methodName) && jproxy.isCurrentExecuteReplayable || entry.serverAsksToEnqueue && entry.replayContext != null && entry.queueId >= 0 && entry.queueId < this.queueEmptyCounts.length && entry.queueEmptyCount == this.queueEmptyCounts[entry.queueId] || entry.queueEmptyCount == Integer.MAX_VALUE)) {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayAllBeforeLastCall", "On {0}, replaying method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), methodName});
                    replayResult = jproxy.replayOneCall(entry, origError);
                    if (!this.isSessionStateConsistencyDynamic() && jproxy instanceof TxnReplayableStatement && methodName.startsWith("execute")) {
                        jproxy.isCurrentExecuteReplayable = true;
                    }
                    if (!this.isSessionStateConsistencyDynamic() && entry.result != null) {
                        if (entry.result instanceof TxnReplayableBase) {
                            ((TxnReplayableBase)entry.result).isCreatingCallReplayable = true;
                        } else if (entry.result instanceof OracleConcreteProxy && (concreteProxy = ((OracleConcreteProxy)entry.result).getConcreteProxy()) != null) {
                            concreteProxy.isCreatingCallReplayable = true;
                        }
                    }
                    if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                        this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, origError);
                    }
                } else {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayAllBeforeLastCall", "On {0}, skipping method {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), methodName});
                    if (!this.isSessionStateConsistencyDynamic() && jproxy instanceof TxnReplayableStatement && methodName.startsWith("execute")) {
                        jproxy.isCurrentExecuteReplayable = false;
                    }
                    if (!this.isSessionStateConsistencyDynamic() && (jproxy instanceof TxnReplayableBlob || jproxy instanceof TxnReplayableClob || jproxy instanceof TxnReplayableNClob || jproxy instanceof TxnReplayableBfile) && jproxy.isProxyReplayable) {
                        jproxy.isProxyReplayable = false;
                    }
                    if (!this.isSessionStateConsistencyDynamic() && entry.result != null) {
                        if (entry.result instanceof TxnReplayableBase) {
                            ((TxnReplayableBase)entry.result).isCreatingCallReplayable = false;
                        } else if (entry.result instanceof OracleConcreteProxy && (concreteProxy = ((OracleConcreteProxy)entry.result).getConcreteProxy()) != null) {
                            concreteProxy.isCreatingCallReplayable = false;
                        }
                    }
                    if (!this.isSessionStateConsistencyDynamic() && !jproxy.isCreatingCallReplayable && !"next".equals(methodName) && entry.serverAsksToEnqueue && entry.replayContext != null && entry.queueId >= 0 && entry.queueId < this.queueEmptyCounts.length && entry.queueEmptyCount == this.queueEmptyCounts[entry.queueId]) {
                        this.disableReplayAndThrowException(entry.method, 399, "Replay disabled because server sent conflicting queueing instructions", origError);
                    }
                }
                entry = entry.nextEntry;
            }
            Object object = replayResult;
            return object;
        }
    }

    private Object replayLastCall(SQLRecoverableException origError) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Object replayResult = null;
            if (this.tail != null) {
                CallHistoryEntry entry = this.tail;
                String methodName = entry.method == null ? NULL_METHOD_NAME : entry.method.getName();
                TxnReplayableBase jproxy = (TxnReplayableBase)entry.jdbcProxy;
                if (this.isSessionStateConsistencyDynamic() && (entry.replayContext == null || entry.serverAsksToEnqueue) || !this.isSessionStateConsistencyDynamic() && jproxy.isCreatingCallReplayable && (entry.replayContext == null && !postExecuteGetCalls.contains(methodName) || entry.replayContext == null && postExecuteGetCalls.contains(methodName) && jproxy.isCurrentExecuteReplayable || entry.serverAsksToEnqueue && entry.replayContext != null && entry.queueId >= 0 && entry.queueId < this.queueEmptyCounts.length && entry.queueEmptyCount == this.queueEmptyCounts[entry.queueId] || entry.queueEmptyCount == Integer.MAX_VALUE)) {
                    replayResult = ((JDBCReplayable)this.tail.jdbcProxy).replayOneCall(this.tail, origError);
                } else {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "replayLastCall", "On {0}, replaying last method {1}: NO replay because this method is not replayable", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), methodName});
                    this.disableReplayAndThrowException(this.tail.method, 372, "Replay disabled because of nonreplayable call", origError);
                }
            }
            Object object = replayResult;
            return object;
        }
    }

    ReplayLifecycle getReplayLifecycle() {
        return this.lifecycle;
    }

    void setDataSource(OracleDataSource rds) {
        this.replayDataSource = rds;
    }

    void setReplayInitiationTimeout(int timeout) throws SQLException {
        this.replayInitiationTimeout = timeout;
    }

    boolean isSessionStateConsistencyDynamic() {
        return this.isReplayInDynamicMode;
    }

    void setSessionStateConsistency(boolean isStatic) throws SQLException {
        this.isReplayInDynamicMode = !isStatic;
    }

    void setSessionStateRestoration(ReplayableConnection.StateRestorationType type) throws SQLException {
        this.stateRestorationType = type;
    }

    void setAutoAC(boolean isAutoAC) throws SQLException {
        this.isAutoAC = isAutoAC;
    }

    void setSSSCursorEnabled(boolean isSSSCursorEnabled) throws SQLException {
        this.isSSSCursorEnabled = isSSSCursorEnabled;
    }

    void setHybrid(boolean isHybrid) throws SQLException {
        this.isHybrid = isHybrid;
        oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
        oconn.setSSSHybrid(isHybrid);
    }

    void setRequestSizeLimit(int limit) {
        this.requestSizeLimit = limit;
    }

    void beginRequest() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.beginRequest(false);
        }
    }

    void beginRequest(boolean isImplicit) throws SQLException {
        boolean sendEnable = true;
        this.doNotAbortConn = false;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            oracle.jdbc.internal.OracleConnection oconn;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "On {0}, Entering beginRequest(), isImplicit: {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), isImplicit});
            if (this.lifecycle == ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "Exiting beginRequest(), redundant beginRequest call, no-op", null, null);
                return;
            }
            if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED && this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
                throw DatabaseError.createSqlException(391);
            }
            if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "replay is always disabled", null, null);
                sendEnable = false;
            }
            if (!(oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate()).serverSupportsRequestBoundaries()) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "Exiting beginRequest(), server does not support request boundaries", null, null);
                return;
            }
            if (this.isAutoAC || this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.LEVEL1) >= 0) {
                this.saveCurrentSessionState(oconn);
            } else {
                this.saveAutoCommitAndStateSignatures(oconn);
            }
            this.requestStartTime = System.currentTimeMillis();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "Request start timestamp: {0}", (String)null, (Throwable)null, (Object)this.requestStartTime);
            oconn.getReplayContext();
            if (this.isAutoAC && (this.savedDatabaseSessionState.getStateSignatures().getSignatureFlags() & 0x20L) == 32L) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "state unrestorable, replay remains disabled", null, null);
                sendEnable = false;
            }
            EnumSet<OracleConnection.ReplayOperation> opSet = EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN);
            if (oconn.serverSupportsExplicitBoundaryBit()) {
                if (!isImplicit) {
                    opSet.add(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_EXPL_BOUND);
                }
            } else if (isImplicit) {
                opSet.add(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_NO_OPEN_HANDLES);
            }
            if (sendEnable) {
                opSet.add(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED);
                if (!this.isAutoAC && !this.isReplayInDynamicMode) {
                    opSet.add(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC);
                }
            }
            oconn.setReplayOperations(opSet);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "Sending BEGIN_REQUEST to server: {0}", (String)null, (Throwable)null, (Object)opSet);
            if (oconn.inLocalTransaction()) {
                SQLException sqlexc = DatabaseError.createSqlException(392);
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "beginRequest", null, sqlexc);
                throw sqlexc;
            }
            this.replayErrorCode = 0;
            this.replayErrorMessage = "";
            this.callCausingReplayError = null;
            this.seenRoundtripCallInRequest = false;
            this.needStateSignatureSyncUp = false;
            this.callingDisableFromEndRequest = false;
            oconn.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
            this.lobStreamInRequest = false;
            this.requestSize = 0;
            this.acStatistics.clearCurrentRequestSize();
            if (sendEnable) {
                this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "On {0}, Recording begins", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                if (!isImplicit) {
                    this.inExplicitRequest = true;
                }
            }
            this.acStatistics.incrementTotalRequests();
            if (!isImplicit) {
                this.purgeCountForMain = 0;
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginRequest", "On {0}, Exiting beginRequest()", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        }
    }

    void endRequest() throws SQLException {
        this.endRequest(false);
    }

    void endRequest(boolean isImplicit) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean isConnClosed;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "On {0}, Entering endRequest(), isImplicit: {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), isImplicit});
            oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
            if (!oconn.serverSupportsRequestBoundaries()) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "Exiting endRequest(), server does not support request boundaries", null, null);
                return;
            }
            if (oconn.serverSupportsExplicitBoundaryBit() && !isImplicit) {
                oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_EXPL_BOUND));
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "Set END_REQUEST+EXPLICIT bits on client-side", null, null);
            } else {
                oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END));
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "Set END_REQUEST bit on client-side", null, null);
            }
            this.callingDisableFromEndRequest = true;
            if (!isImplicit) {
                this.inExplicitRequest = false;
            }
            if (!(isConnClosed = oconn.isClosed())) {
                boolean autoCommitMode = oconn.getAutoCommit();
                int txnMode = oconn.getTxnMode();
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "auto-commit: {0}, transaction mode: {1}", (String)null, (Throwable)null, new Object[]{autoCommitMode, txnMode});
                if (!autoCommitMode && txnMode != 1 && oconn.inLocalTransaction()) {
                    try {
                        oconn.rollback();
                    }
                    catch (SQLException sqlexc) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "Rollback open transaction failed before throwing exception", null, null);
                    }
                    SQLException sqlexc = DatabaseError.createSqlException(393);
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "endRequest", null, sqlexc);
                    throw sqlexc;
                }
            }
            this.acStatistics.incrementTotalCompletedRequests();
            this.acStatistics.updateRequestSizeHistogram(this.requestSize);
            this.requestSize = 0;
            this.acStatistics.clearCurrentRequestSize();
            this.lobStreamInRequest = false;
            if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "Exiting endRequest() -- MONITOR_TXN failed", null, null);
                return;
            }
            if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED || this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "Exiting endRequest() -- replay already disabled", null, null);
                this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
                return;
            }
            this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
            this.callingDisableFromEndRequest = false;
            if (isImplicit) {
                ++this.purgeCountForMain;
            } else if (this.isAutoAC && this.isSSSCursorEnabled) {
                this.sssPurge();
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endRequest", "On {0}, Exiting endRequest()", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        }
    }

    void disableReplay() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplay", "On {0}, Entering disableReplay()", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplay", "Exiting disableReplay(), MONITOR_TXN failed, no-op", null, null);
            return;
        }
        this.disableReplayInternal(null, 370, "Replay disabled", null);
        this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplay", "On {0}, replay is externally disabled", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplay", "On {0}, Exiting disableReplay()", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
    }

    void disableReplayInternal(Method m, int errCode, String errMesg, SQLRecoverableException origError) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "On {0}, Entering disableReplayInternal", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        if (!this.callingDisableFromEndRequest) {
            this.acStatistics.incrementReplayDisablingCount();
        }
        ReplayLifecycle curLifecycle = this.lifecycle;
        oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
        if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
        }
        this.purge();
        this.replayErrorCode = errCode;
        this.replayErrorMessage = errMesg;
        this.callCausingReplayError = m;
        for (int i = 0; i < activeQueues; ++i) {
            this.queueEmptyCounts[i] = 0;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "On {0}, replay is internally disabled", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        try {
            oconn.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
            if (!this.seenRoundtripCallInRequest) {
                if (!this.isReplayInDynamicMode) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "On {0}, STATIC + no roundtrip in current request", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                    oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                } else {
                    EnumSet<OracleConnection.ReplayOperation> opSet = EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN);
                    if (oconn.serverSupportsExplicitBoundaryBit()) {
                        opSet.add(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_EXPL_BOUND);
                    }
                    oconn.setReplayOperations(opSet);
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "On {0}, DYNAMIC + no roundtrip in current request, set {1} after CLIENT-disable", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), opSet});
                }
            } else if (!this.isReplayInDynamicMode) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "On {0}, STATIC + with roundtrip in current request", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                if (!this.callingDisableFromEndRequest) {
                    oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "On {0}, still within request, sending STATIC", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                } else {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "On {0}, after endRequest, no STATIC sent", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                }
            } else {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "On {0}, DYNAMIC + with roundtrip in current request", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
                oconn.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "Cleared ENABLED bit for driver and server", null, null);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplayInternal", "On {0}, Exiting disableReplayInternal", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
    }

    void failReplayInternal(Method m, int errCode, String errMesg, SQLRecoverableException origError) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "failReplayInternal", "Entering failReplayInternal", null, null);
        ReplayLifecycle curLifecycle = this.lifecycle;
        if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
        }
        this.replayErrorCode = errCode;
        this.replayErrorMessage = errMesg;
        this.callCausingReplayError = m;
        this.originalOconn = null;
        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "failReplayInternal", "On {0}, replay failed", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "failReplayInternal", "Exiting failReplayInternal", null, null);
    }

    void throwReplayExceptionInternal(int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        if (errCode == 0) {
            return;
        }
        String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
        throw replayErr;
    }

    void disableReplayAndThrowException(Method m, int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        this.disableReplayInternal(m, errCode, errMesg, origError);
        this.throwReplayExceptionInternal(errCode, errMesg, origError);
    }

    void disableReplayAndThrowSQLException(Method m, int errCode, String errMesg, SQLException origError) throws SQLException {
        this.disableReplayInternal(m, errCode, errMesg, null);
        this.killConnectionBeforeReplayDisabledException();
        throw origError;
    }

    void disableReplayAndThrowOriginalError(Method m, int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        this.disableReplayInternal(m, errCode, errMesg, origError);
        this.throwOriginalExceptionWithReplayError(errCode, errMesg, origError);
    }

    void failReplayAndThrowException(Method m, int errCode, String errMesg, SQLRecoverableException origError) throws SQLException {
        this.failReplayInternal(m, errCode, errMesg, origError);
        this.throwReplayExceptionInternal(errCode, errMesg, origError);
    }

    void throwOriginalExceptionWithReplayError(int errCode, String errMesg, SQLRecoverableException origError) throws SQLRecoverableException {
        if (!this.doNotAbortConn) {
            this.killConnectionBeforeReplayDisabledException();
        }
        String callNameCausingException = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException replayErr = DatabaseError.createSqlException(this.replayErrorCode, callNameCausingException);
        origError.setNextException(replayErr);
        this.acStatistics.incrementFailedReplayCount();
        this.sssFetchOutage = false;
        this.sssSavedRsetProxy = null;
        assert (this.callHittingOutage != null) : "Failed-call Method object is null";
        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "throwOriginalExceptionWithReplayError", "On {0}, replay failed in method {1}, error code: {2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), this.callHittingOutage.getName(), this.replayErrorCode});
        this.trace(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "throwOriginalExceptionWithReplayError", "On {0}, replay failed in method {1}, error code: {2}, reason: {3}", null, null, this.connectionProxy.hashCode(), this.callHittingOutage.getName(), this.replayErrorCode, replayErr);
        try {
            if (this.originalOconn != null) {
                this.originalOconn.dumpLog();
            }
        }
        catch (SQLException e) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "throwOriginalExceptionWithReplayError", "exception occured while dumping trace data", null, e);
        }
        this.originalOconn = null;
        throw origError;
    }

    void killConnectionBeforeReplayDisabledException() {
        final oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
        try {
            oconn.abort();
        }
        catch (SQLException sqlexc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "killConnectionBeforeReplayDisabledException", "Aborting connection failed before throwing replay-disabled exception", null, null);
        }
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    TxnFailoverManagerImpl.this.closePhysicalConnection(oconn);
                }
            });
        }
        catch (Exception exc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "killConnectionBeforeReplayDisabledException", "On {0}, ASYNC close() submission during replay failed", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        }
    }

    void enableTxnMonitoring(oracle.jdbc.internal.OracleConnection oconn) throws SQLException {
        try {
            Statement stmt = oconn.createStatement();
            stmt.execute(MONITOR_TXN);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "enableTxnMonitoring", "MONITOR_TXN succeeded", null, null);
            stmt.close();
        }
        catch (SQLException sqlexc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "enableTxnMonitoring", "MONITOR_TXN failed", null, null);
            this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
            this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            throw DatabaseError.createSqlException(395);
        }
    }

    void beginReplay(oracle.jdbc.internal.OracleConnection oconn, SQLRecoverableException origError) throws SQLException {
        try {
            Statement stmt = oconn.createStatement();
            stmt.execute(BEGIN_REPLAY);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginReplay", "BEGIN_REPLAY succeeded", null, null);
            stmt.close();
            oconn.setReplayingMode(true);
            this.lifecycle = ReplayLifecycle.REPLAYING;
        }
        catch (SQLRecoverableException sqlrexc) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "beginReplay", "BEGIN_REPLAY hit outage", null, null);
            throw sqlrexc;
        }
        catch (SQLException sqlexc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "beginReplay", "BEGIN_REPLAY failed", null, null);
            this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", origError);
        }
    }

    void endReplay(oracle.jdbc.internal.OracleConnection oconn, SQLRecoverableException origError) throws SQLException {
        try {
            Statement stmt = oconn.createStatement();
            stmt.execute(END_REPLAY);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endReplay", "END_REPLAY succeeded", null, null);
            stmt.close();
            oconn.setReplayingMode(false);
            oconn.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
            if (!this.isReplayInDynamicMode) {
                oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            } else {
                oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            }
            oconn.getReplayContext();
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        }
        catch (SQLRecoverableException sqlrexc) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "endReplay", "END_REPLAY hit outage", null, null);
            throw sqlrexc;
        }
        catch (SQLException sqlexc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "endReplay", "END_REPLAY failed", null, null);
            this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", origError);
        }
    }

    boolean prepareReplay(oracle.jdbc.internal.OracleConnection oconn, SQLRecoverableException origError, boolean ac, short fncode, String sqlString) throws SQLException {
        boolean committed = false;
        boolean embedded = false;
        try {
            if (!this.isReplayInDynamicMode) {
                oconn.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
            }
            StateSignatures sigs = this.savedDatabaseSessionState == null ? null : this.savedDatabaseSessionState.getStateSignatures();
            OracleCallableStatement cstmt = (OracleCallableStatement)(sigs != null ? oconn.prepareCall(PREPARE_REPLAY_2) : oconn.prepareCall(PREPARE_REPLAY));
            cstmt.setObject(1, (Object)this.oldLtxidForPrepareReplay);
            cstmt.setInt(2, this.originalSeenRoundtripCallInRequest ? 1 : 0);
            cstmt.setInt(3, ac ? 1 : 0);
            cstmt.setInt(4, (int)fncode);
            cstmt.setString(5, sqlString);
            if (sigs != null) {
                BigDecimal ub8Flags = this.longToUB8(sigs.getSignatureFlags());
                BigDecimal ub8ClientSig = this.longToUB8(sigs.getClientSignature());
                BigDecimal ub8ServerSig = this.longToUB8(sigs.getServerSignature());
                cstmt.setBigDecimal(8, ub8Flags);
                cstmt.setBigDecimal(9, ub8ClientSig);
                cstmt.setBigDecimal(10, ub8ServerSig);
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareReplay", "On {0}, PREPARE_REPLAY RPC code: {1}, SQL text: {2}, {3}, (converted) SignatureFlags: {4}, ClientSignature: {5}, ServerSignature: {6}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), fncode, sqlString, sigs, ub8Flags, ub8ClientSig, ub8ServerSig});
            } else {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareReplay", "On {0}, PREPARE_REPLAY RPC code: {1}, SQL text: {2}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), fncode, sqlString});
            }
            cstmt.registerOutParameter(6, -7);
            cstmt.registerOutParameter(7, -7);
            cstmt.execute();
            committed = cstmt.getBoolean(6);
            embedded = cstmt.getBoolean(7);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareReplay", "PREPARE_REPLAY succeeded, committed: {0}, embedded: {1}", (String)null, (Throwable)null, new Object[]{committed, embedded});
            cstmt.close();
        }
        catch (SQLRecoverableException sqlrexc) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareReplay", "PREPARE_REPLAY hit outage", null, null);
            throw sqlrexc;
        }
        catch (SQLException sqlexc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareReplay", "PREPARE_REPLAY failed", null, sqlexc);
            sqlexc.printStackTrace();
            this.disableReplayAndThrowException(null, 385, "Replay disabled because server prepare_replay call failed", origError);
        }
        if (!embedded) {
            return committed;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareReplay", "EMBEDDED-COMMIT completed", null, null);
        this.disableReplayAndThrowException(null, 386, "Replay disabled because of embedded commit", origError);
        return false;
    }

    JDBCReplayable getConnectionProxy() {
        return this.connectionProxy;
    }

    private boolean isReplayFailure(SQLException t) {
        int errCode;
        boolean result = false;
        if (t != null && (errCode = t.getErrorCode()) >= 370 && errCode < 400) {
            result = true;
        }
        return result;
    }

    private void closePhysicalConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sqlexc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "closePhysicalConnection", "On {0}, connection close() during replay failed", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        }
    }

    LogicalTransactionId getLogicalTransactionId() {
        return this.ltxid;
    }

    LogicalTransactionId getLtxidAtOriginalOutage() {
        return this.ltxidAtOriginalOutage;
    }

    void setLogicalTransactionId(LogicalTransactionId newLtxid) {
        this.ltxid = newLtxid;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "setLogicalTransactionId", "On {0}, new LTXID set: {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), this.ltxid});
    }

    @Override
    public void onLogicalTransactionIdEvent(LogicalTransactionIdEvent ltxidEvent) {
        LogicalTransactionId newLtxid = ltxidEvent.getLogicalTransactionId();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "onLogicalTransactionIdEvent", "On {0}, LTXID in new LTXID event: {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), newLtxid});
        this.setLogicalTransactionId(newLtxid);
    }

    ReplayContext[] getReplayContext() {
        return this.replayContext;
    }

    void setReplayContext(ReplayContext[] newReplayContext) {
        this.replayContext = newReplayContext;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "setReplayContext", "On {0}, new ReplayContext set: {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), this.replayContext});
    }

    void addActiveQueues(int maxQueueId) {
        int i;
        int addedLen = (maxQueueId + 1 - this.queueEmptyCounts.length) / 2 * 2;
        int newArrayLen = this.queueEmptyCounts.length + addedLen;
        int[] newQueueEmptyCounts = new int[newArrayLen];
        System.arraycopy(this.queueEmptyCounts, 0, newQueueEmptyCounts, 0, this.queueEmptyCounts.length);
        for (i = this.queueEmptyCounts.length; i <= maxQueueId; ++i) {
            newQueueEmptyCounts[i] = 0;
        }
        for (i = maxQueueId + 1; i <= newArrayLen; ++i) {
            newQueueEmptyCounts[i] = 0;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.queueEmptyCounts = newQueueEmptyCounts;
            activeQueues = newArrayLen;
        }
    }

    ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType reportType) {
        ReplayStatistics acStats = null;
        switch (reportType) {
            case FOR_CURRENT_CONNECTION: {
                acStats = this.acStatistics;
                break;
            }
            case FOR_ALL_CONNECTIONS: {
                acStats = this.replayDataSource.getReplayStatistics();
            }
        }
        return acStats;
    }

    void clearReplayStatistics(ReplayableConnection.StatisticsReportType reportType) {
        switch (reportType) {
            case FOR_CURRENT_CONNECTION: {
                this.acStatistics.clear();
                break;
            }
            case FOR_ALL_CONNECTIONS: {
                this.replayDataSource.clearReplayStatistics();
            }
        }
    }

    protected ProxyFactory getProxyFactory() throws SQLException {
        return this.replayDataSource.getProxyFactory();
    }

    boolean isLobStreamInRequest() {
        return this.lobStreamInRequest;
    }

    void setLobStreamInRequest(boolean streamPresent) {
        this.lobStreamInRequest = streamPresent;
    }

    void saveAutoCommitAndStateSignatures(oracle.jdbc.internal.OracleConnection oconn) throws SQLException {
        this.savedAutoCommit = oconn.getAutoCommitInternal();
        if (this.svrSupportsSignature) {
            this.savedDatabaseSessionState = oconn.getDatabaseSessionState();
        }
    }

    void saveCurrentSessionState(oracle.jdbc.internal.OracleConnection oconn) throws SQLException {
        this.savedSessionProps = oconn.getSessionInfoInternal();
        this.savedClientInfo = oconn.getClientInfoInternal();
        this.saveAutoCommitAndStateSignatures(oconn);
    }

    void restoreAutoCommit(oracle.jdbc.internal.OracleConnection newConnection) throws SQLException {
        newConnection.setAutoCommit(this.savedAutoCommit);
    }

    void restoreCommonSessionState(oracle.jdbc.internal.OracleConnection newConnection, boolean sendTemplate) throws SQLException {
        String _rolesStr;
        if (sendTemplate) {
            newConnection.setDatabaseSessionState(this.savedDatabaseSessionState);
        }
        boolean restoreClientRestorableValues = this.savedDatabaseSessionState != null && this.savedDatabaseSessionState.getId() == 0L;
        StringBuilder sqlBuilder = new StringBuilder("ALTER SESSION SET");
        if (restoreClientRestorableValues) {
            String _row_archival;
            String _sql_txlp;
            String _edition;
            String _err_ovlap;
            sqlBuilder.append(" NLS_CALENDAR = '").append(this.savedSessionProps.get(NLS_CALENDAR_PROPERTY)).append("'").append(" NLS_CURRENCY = '").append(this.savedSessionProps.get(NLS_CURRENCY_PROPERTY)).append("'").append(" NLS_DATE_FORMAT = '").append(this.savedSessionProps.get(NLS_DATE_FORMAT_PROPERTY)).append("'").append(" NLS_DATE_LANGUAGE = '").append(this.savedSessionProps.get(NLS_DATE_LANGUAGE_PROPERTY)).append("'").append(" NLS_DUAL_CURRENCY = '").append(this.savedSessionProps.get(NLS_DUAL_CURRENCY_PROPERTY)).append("'").append(" NLS_ISO_CURRENCY = '").append(this.savedSessionProps.get(NLS_ISO_CURRENCY_PROPERTY)).append("'").append(" NLS_LANGUAGE = '").append(this.savedSessionProps.get(NLS_LANGUAGE_PROPERTY)).append("'").append(" NLS_LENGTH_SEMANTICS = '").append(this.savedSessionProps.get(NLS_LENGTH_SEMANTICS_PROPERTY)).append("'").append(" NLS_NCHAR_CONV_EXCP = '").append(this.savedSessionProps.get(NLS_NCHAR_CONV_EXCP_PROPERTY)).append("'").append(" NLS_NUMERIC_CHARACTERS = '").append(this.savedSessionProps.get(NLS_NUMERIC_CHARACTERS_PROPERTY)).append("'").append(" NLS_SORT = '").append(this.savedSessionProps.get(NLS_SORT_PROPERTY)).append("'").append(" NLS_TERRITORY = '").append(this.savedSessionProps.get(NLS_TERRITORY_PROPERTY)).append("'").append(" NLS_TIME_FORMAT = '").append(this.savedSessionProps.get(NLS_TIME_FORMAT_PROPERTY)).append("'").append(" NLS_TIME_TZ_FORMAT = '").append(this.savedSessionProps.get(NLS_TIME_TZ_FORMAT_PROPERTY)).append("'").append(" NLS_TIMESTAMP_FORMAT = '").append(this.savedSessionProps.get(NLS_TIMESTAMP_FORMAT_PROPERTY)).append("'").append(" NLS_TIMESTAMP_TZ_FORMAT = '").append(this.savedSessionProps.get(NLS_TIMESTAMP_TZ_FORMAT_PROPERTY)).append("'");
            String tzString = this.savedSessionProps.getProperty(TIME_ZONE_PROPERTY);
            if (tzString != null && tzString.length() > 3 && tzString.startsWith("GMT")) {
                tzString = tzString.substring(3);
            }
            sqlBuilder.append(" TIME_ZONE = '").append(tzString).append("'");
            String currentSchema = this.savedSessionProps.getProperty(SCHEMA_NAME_PROPERTY);
            if (currentSchema != null && !"".equals(currentSchema) && !currentSchema.equals(newConnection.getCurrentSchema())) {
                sqlBuilder.append(" CURRENT_SCHEMA = ").append(currentSchema);
            }
            if ((_err_ovlap = this.savedSessionProps.getProperty(ERROR_OVERLAP_PROPERTY)) != null && !"".equals(_err_ovlap)) {
                sqlBuilder.append(" ERROR_ON_OVERLAP_TIME = ").append(_err_ovlap);
            }
            if ((_edition = this.savedSessionProps.getProperty(EDITION_PROPERTY)) != null && !"".equals(_edition)) {
                sqlBuilder.append(" EDITION = ").append(_edition);
            }
            if ((_sql_txlp = this.savedSessionProps.getProperty(SQL_TXLP_PROPERTY)) != null && !"".equals(_sql_txlp)) {
                sqlBuilder.append(" SQL_TRANSLATION_PROFILE = ").append(_sql_txlp);
            }
            if ((_row_archival = this.savedSessionProps.getProperty(ROW_ARCHIVAL_PROPERTY)) != null && !"".equals(_row_archival)) {
                sqlBuilder.append(" ROW ARCHIVAL VISIBILITY = ").append(_row_archival);
            }
        }
        String savedContainer = this.savedSessionProps.getProperty(CONTAINER_PROPERTY);
        String savedService = this.savedSessionProps.getProperty(SERVICE_PROPERTY);
        Object setContainerSql = "";
        if (savedContainer != null && !"".equals(savedContainer)) {
            String containerOnNew = this.getContainer(newConnection);
            String serviceOnNew = this.getService(newConnection);
            if (!savedContainer.equals(containerOnNew) || !savedService.equals(serviceOnNew)) {
                setContainerSql = "ALTER SESSION SET CONTAINER = " + savedContainer + " SERVICE = \"" + savedService + "\"";
            }
        }
        String alterSessionSql = sqlBuilder.toString();
        try (Statement stmt = newConnection.createStatement();){
            if (restoreClientRestorableValues) {
                stmt.execute(alterSessionSql);
            }
            if (!"".equals(setContainerSql)) {
                stmt.execute((String)setContainerSql);
            }
        }
        if (restoreClientRestorableValues && (_rolesStr = this.savedSessionProps.getProperty(ENABLED_ROLE_NAMES_PROPERTY)) != null && !"".equals(_rolesStr)) {
            String _roles = _rolesStr.replaceAll("\"", "");
            String setRoleSql = "SET ROLE " + _roles;
            try (Statement stmt = newConnection.createStatement();){
                stmt.execute(setRoleSql);
            }
        }
        newConnection.setClientInfo(this.savedClientInfo);
        String _clntInfoStr = this.savedSessionProps.getProperty(CLIENT_INFO_PROPERTY);
        if (_clntInfoStr != null && !"".equals(_clntInfoStr)) {
            String setClntInfoSql = "begin dbms_application_info.set_client_info(?); end;";
            try (CallableStatement cstmt = newConnection.prepareCall(setClntInfoSql);){
                cstmt.setString(1, _clntInfoStr);
                cstmt.execute();
            }
        }
        this.restoreAutoCommit(newConnection);
    }

    private String getContainer(oracle.jdbc.internal.OracleConnection newConnection) throws SQLException {
        String containerName = "";
        try (Statement stmt = newConnection.createStatement();
             ResultSet rs = stmt.executeQuery(CONTAINER_QUERY);){
            if (rs.next()) {
                containerName = rs.getString(1);
            }
        }
        return containerName;
    }

    private String getService(oracle.jdbc.internal.OracleConnection newConnection) throws SQLException {
        return newConnection.getServerSessionInfo(SERVICE_PROPERTY);
    }

    void restoreSessionState(oracle.jdbc.internal.OracleConnection newConnection) throws SQLException {
        newConnection.setClientInfo(this.savedClientInfo);
        this.restoreAutoCommit(newConnection);
    }

    private boolean checkACChange(oracle.jdbc.internal.OracleConnection oconn) throws SQLException {
        String failoverType = oconn.getServerSessionInfo(FAILOVER_TYPE_PROPERTY);
        if (failoverType != null && !"".equals(failoverType)) {
            int wiredValue;
            try {
                wiredValue = Integer.parseInt(failoverType);
            }
            catch (NumberFormatException exc) {
                wiredValue = 0;
            }
            if (!this.isAutoAC) {
                return (wiredValue & 8) == 8 && this.isReplayInDynamicMode == ((wiredValue & 0x10) == 0) || (wiredValue & 0x20) == 32;
            }
            return (wiredValue & 0x20) == 32;
        }
        return false;
    }

    void setStateSignatureSyncUp() {
        if (this.tail.callException == null) {
            this.needStateSignatureSyncUp = true;
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "setStateSignatureSyncUp", "On {0}, need state signature sync up", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
        }
    }

    void checkStateSignatureSyncUp() {
        if (this.needStateSignatureSyncUp) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "checkStateSignatureSyncUp", "On {0}, need state signature sync at endRequest, forcing roundtrip", (String)null, (Throwable)null, (Object)this.connectionProxy.hashCode());
            oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
            try {
                oconn.pingDatabase();
            }
            catch (Throwable error) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "checkStateSignatureSyncUp", "On {0}, forced state signature sync at endRequest failed: {1}", (String)null, (Throwable)null, new Object[]{this.connectionProxy.hashCode(), error});
            }
        }
    }

    void checkMemoryPressureAndLog() {
        if (seenMemoryPressure) {
            String reportString = this.replayDataSource.getReplayStatisticsString();
            if (reportString != null) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "checkMemoryPressureAndLog", "Detected memory pressure, dumping AC statistics for data source {0}:\n{1}", (String)null, (Throwable)null, new Object[]{this.replayDataSource, reportString});
            }
            if (System.currentTimeMillis() - seenMemoryPressureTS >= 120000L) {
                seenMemoryPressure = false;
                this.replayDataSource.clearDoneDumpOnMemoryPressure();
            }
        }
    }

    private BigDecimal longToUB8(long orig) {
        BigInteger origBInt = BigInteger.valueOf(orig);
        BigInteger convertedBInt = orig >= 0L ? origBInt : origBInt.add(MASK);
        return new BigDecimal(convertedBInt);
    }

    public static void cleanup() {
        MEMGUARD_LISTENER.unregister();
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    final CallHistoryEntry getCallHistoryTail() {
        return this.tail;
    }

    final void removeReplayStatistics() {
        this.replayDataSource.removeReplayStatistics(this.acStatistics);
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    private static final class MemGuardListener
    implements NotificationListener,
    Diagnosable {
        private static final MemGuardListener SOLE_INSTANCE = new MemGuardListener();
        private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnFailoverManagerImpl.MemGuardListener";

        private MemGuardListener() {
            MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
            NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
            emitter.addNotificationListener(this, null, null);
            Pattern old = Pattern.compile(".*Old.*");
            for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                if (pool.getType() != MemoryType.HEAP || !pool.isCollectionUsageThresholdSupported() || !old.matcher(pool.getName()).matches() || pool.getCollectionUsageThreshold() != 0L) continue;
                MemoryUsage usage = pool.getUsage();
                final long threshold = (long)(usage.getMax() == -1L ? (double)Runtime.getRuntime().maxMemory() * 0.9 : (double)usage.getMax() * 0.9);
                final MemoryPoolMXBean memoryPool = pool;
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "MemGuardListener", "MEMGUARD: setCollectionUsageThreshold<" + pool.getName() + ">(" + threshold + ")", null, null);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        memoryPool.setCollectionUsageThreshold(threshold);
                        return null;
                    }
                });
            }
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            String notifType = notification.getType();
            if (notifType.equals("java.management.memory.collection.threshold.exceeded")) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "handleNotification", "MEMGUARD: MEMORY_COLLECTION_THRESHOLD_EXCEEDED", null, null);
                seenMemoryPressureTS = System.currentTimeMillis();
                seenMemoryPressure = true;
            }
        }

        public void unregister() {
            MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
            NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "unregister", "MEMGUARD: removeNotificationListener", null, null);
            try {
                emitter.removeNotificationListener(this, null, null);
            }
            catch (ListenerNotFoundException e) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "unregister", e.getMessage(), null, e);
            }
        }

        @Override
        public Diagnosable getDiagnosable() {
            return CommonDiagnosable.getInstance();
        }
    }

    static enum ReplayLifecycle {
        ENABLED_NOT_REPLAYING,
        INTERNALLY_FAILED,
        INTERNALLY_DISABLED,
        ALWAYS_DISABLED,
        EXTERNALLY_DISABLED,
        REPLAYING_CALLBACK,
        REPLAYING,
        REPLAYING_LASTCALL;

    }

    static class SSSCallHistoryEntry
    extends CallHistoryEntry {
        DatabaseSessionState stateBeforeExec;
        long sssChecksum;
        long fetchedRowsCount;

        SSSCallHistoryEntry(Object jdbcProxy, Method m, Object[] args, String callStatus) {
            super(jdbcProxy, m, args, callStatus);
            this.stateBeforeExec = null;
            this.sssChecksum = 0L;
            this.fetchedRowsCount = 0L;
        }

        SSSCallHistoryEntry(CallHistoryEntry original) {
            super(original.jdbcProxy, original.method, original.args, original.callStatus);
            this.result = original.result;
            this.checksum = original.checksum;
            this.openAcrossPurge = original.openAcrossPurge;
            this.queueId = original.queueId;
            this.queueEmptyCount = original.queueEmptyCount;
            this.replayContext = original.replayContext;
            this.serverAsksToEnqueue = original.serverAsksToEnqueue;
            this.callException = original.callException;
            this.stateBeforeExec = null;
            this.sssChecksum = 0L;
            this.fetchedRowsCount = 0L;
        }

        @Override
        public String toString() {
            String ret = "SSSCallHistoryEntry: method.getName()=" + this.method.getName() + ", queueId=" + this.queueId + ", queueEmptyCount=" + this.queueEmptyCount + ", serverAsksToEnqueue=" + this.serverAsksToEnqueue + ", stateBeforeExec=" + this.stateBeforeExec + ", sssChecksum=" + this.sssChecksum + ", fetchedRowsCount=" + this.fetchedRowsCount + ", result=" + this.result + ", replayContext=" + this.replayContext;
            if (this.replayContext != null) {
                for (int i = 0; i < this.replayContext.length; ++i) {
                    ret = ret + this.replayContext[i];
                }
            }
            return ret + "\n";
        }
    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long checksum;
        boolean openAcrossPurge;
        int queueId;
        int queueEmptyCount;
        ReplayContext[] replayContext;
        boolean serverAsksToEnqueue;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;

        CallHistoryEntry(Object jdbcProxy, Method m, Object[] args, String callStatus) {
            this.jdbcProxy = jdbcProxy;
            this.method = m;
            this.args = args;
            this.result = null;
            this.callStatus = callStatus;
            this.openAcrossPurge = false;
        }

        public String toString() {
            String ret = "CallHistoryEntry: method.getName()=" + this.method.getName() + ", queueId=" + this.queueId + ", queueEmptyCount=" + this.queueEmptyCount + ", serverAsksToEnqueue=" + this.serverAsksToEnqueue + ", replayContext=" + this.replayContext;
            if (this.replayContext != null) {
                for (int i = 0; i < this.replayContext.length; ++i) {
                    ret = ret + this.replayContext[i];
                }
            }
            return ret + "\n";
        }
    }
}

