/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.ExecutionContext;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.BooleanAccessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.CancelLock;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.GeneratedStatement;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleReturnResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatementWrapper;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.Pipeline;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.ReadOnlyByteArray;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetCache;
import oracle.jdbc.driver.ResultSetCacheEntry;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;
import oracle.jdbc.driver.VectorAccessor;
import oracle.jdbc.driver.Wrappable;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

abstract class OracleStatement
extends GeneratedStatement
implements oracle.jdbc.internal.OracleStatement,
Wrappable<OracleStatementWrapper> {
    private static final String CLASS_NAME = OracleStatement.class.getName();
    private static final int DEFAULT_ROW_PREFETCH_SIZE = Integer.parseInt("10");
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    int[] returnParamMeta;
    byte[] shardingKeyRpnTokens;
    private ErrorSet continueOnErrorSet = null;
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    static final int METADATALENGTH = 1;
    static final int VALID_ROWS_UNINIT = -999;
    static final long VALID_ROWS_STREAM = -2L;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    static final int DMLR_METADATA_PREFIX_SIZE = 3;
    static final int DMLR_METADATA_NUM_OF_RETURN_PARAMS = 0;
    static final int DMLR_METADATA_ROW_BIND_BYTES = 1;
    static final int DMLR_METADATA_ROW_BIND_CHARS = 2;
    static final int DMLR_METADATA_TYPE_OFFSET = 0;
    static final int DMLR_METADATA_IS_CHAR_TYPE_OFFSET = 1;
    static final int DMLR_METADATA_BIND_SIZE_OFFSET = 2;
    static final int DMLR_METADATA_FORM_OF_USE_OFFSET = 3;
    static final int DMLR_METADATA_PER_POSITION_SIZE = 4;
    static final String SYS_ODCIVARCHAR2LIST = "SYS.ODCIVARCHAR2LIST";
    static final OracleResultSet.ResultSetType DEFAULT_RESULT_SET_TYPE = OracleResultSet.ResultSetType.FORWARD_READ_ONLY;
    boolean closed;
    protected boolean isAllFetched;
    int cursorId;
    int refCursorRowNumber;
    ByteArray rowData = null;
    long rowDataMaxBytesSize = Long.MAX_VALUE;
    ByteArray bindData = null;
    boolean bindUseDBA = false;
    long[] bindDataOffsets = null;
    int[] bindDataLengths = null;
    long beyondBindData = 0L;
    int[] parameterMaxLength = null;
    int numberOfDefinePositions;
    int definesBatchSize;
    boolean described = false;
    boolean describedWithNames = false;
    boolean executeDoneForDefines = false;
    protected FetchMode fetchMode = FetchMode.OVERWRITE;
    protected long indexOfFirstRow = 0L;
    long rowsProcessed;
    protected long validRows;
    protected int storedRowCount;
    protected int currentCapacity = -1;
    private int numberOfUserColumns = -1;
    boolean isStreaming;
    boolean isFetchStreams;
    OracleStatement children = null;
    OracleStatement parent = null;
    OracleStatement nextChild = null;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int numberOfBindPositions;
    int bindDBAOffset;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    Object[][] userStream;
    int firstRowInBatch;
    boolean hasIbtBind = false;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    OracleInputStream nextStream;
    OracleResultSet currentResultSet;
    ArrayDeque<OracleStatement> implicitResultSetStatements = null;
    Iterator<OracleStatement> implicitResultSetIterator = null;
    ArrayDeque<OracleResultSet> openImplicitResultSets = null;
    boolean processEscapes;
    boolean convertNcharLiterals;
    int queryTimeout;
    int maxFieldSize;
    long maxRows;
    boolean batchWasExecuted = false;
    int numberOfExecutedElementsInBatch = -1;
    int[] indexOfFailedElementsInBatch = null;
    int currentRank;
    boolean bsendBatchInProgress = false;
    long[] batchRowsUpdatedArray;
    int rowPrefetch;
    int rowPrefetchInLastFetch = -1;
    int defaultRowPrefetch;
    boolean rowPrefetchChanged;
    boolean autoTuneRowPrefetch = true;
    boolean rowPrefetchTuningDone = false;
    private static final int PER_COLUMN_OVERHEAD = 16;
    private static final int FETCH_RETUNE_UPPERBOUND = 250;
    private static final int FETCH_RETUNE_LOWERBOUND = 4;
    private List<Integer> tunedFetchSizeList = new ArrayList<Integer>();
    private static final int TUNED_FETCH_SIZE_SAMPLE_COUNT = 3;
    int defaultLobPrefetchSize;
    OracleSql sqlObject;
    boolean needToParse;
    boolean needToPrepareDefineBuffer;
    boolean columnsDefinedByUser;
    boolean gotLastBatch;
    boolean clearParameters;
    OracleStatement.SqlKind sqlKind = OracleStatement.SqlKind.SELECT;
    byte sqlKindByte = 1;
    boolean serverCursor;
    boolean fixedString = false;
    boolean noMoreUpdateCounts = false;
    protected CancelLock cancelLock = new CancelLock(this);
    OracleStatementWrapper wrapper;
    byte executionType = (byte)-1;
    OracleResultSet.ResultSetType userRsetType;
    OracleResultSet.ResultSetType realRsetType;
    boolean isRowidPrepended = false;
    SQLWarning sqlWarning;
    int cacheState = 3;
    int creationState = 0;
    boolean isOpen = false;
    int statementType = 0;
    boolean columnSetNull = false;
    boolean isDmlReturning = false;
    boolean returnParamsFetched;
    int rowsDmlReturned;
    int numReturnParams;
    protected AutoKeyInfo autoKeyInfo;
    TimeZone defaultTimeZone = null;
    String defaultTimeZoneName = null;
    Calendar defaultCalendar = null;
    Calendar gmtCalendar = null;
    long inScn = 0L;
    protected ResultSetCacheEntry cachedQueryResult = null;
    boolean resultFromCache = false;
    protected QueryCacheState queryCacheState = QueryCacheState.UNKNOWN;
    private static int COLUMN_NAME_CACHE_INITIAL_SIZE = 4;
    private IdentityHashMap<String, Integer> columnNameCache = new IdentityHashMap(COLUMN_NAME_CACHE_INITIAL_SIZE);
    static int GLOBAL_STATEMENT_NUMBER = 1;
    DMSFactory.DMSState dmsSqlText = null;
    DMSFactory.DMSPhase dmsExecute = null;
    DMSFactory.DMSPhase dmsFetch = null;
    ByteBuffer[] nioBuffers = null;
    Object[] lobPrefetchMetaData = null;
    boolean hasStream;
    byte[] tmpByteArray;
    int sizeTmpByteArray = 0;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch = false;
    int[] definedColumnType = null;
    int[] definedColumnSize = null;
    int[] definedColumnFormOfUse = null;
    T4CTTIoac[] oacdefSent = null;
    int[] nbPostPonedColumns = null;
    int[][] indexOfPostPonedColumn = null;
    boolean aFetchWasDoneDuringDescribe = false;
    boolean implicitDefineForLobPrefetchDone = false;
    long checkSum = 0L;
    boolean checkSumComputationFailure = false;
    protected long sssCursorChecksum = 0L;
    protected boolean isSSSCursor = false;
    protected long sssCursorPosition = -1L;
    protected boolean isFetchSizeSet = false;
    protected boolean isFetchingValueBasedLob = false;
    Vector<String> m_batchItems = null;
    ArrayList<CLOB> tempStmtClobsToFree = null;
    ArrayList<BLOB> tempStmtBlobsToFree = null;
    ArrayList<CLOB> oldTempClobsToFree = null;
    ArrayList<BLOB> oldTempBlobsToFree = null;
    ArrayList<CLOB> tempRowClobsToFree = new ArrayList();
    ArrayList<BLOB> tempRowBlobsToFree = new ArrayList();
    NTFDCNRegistration registration = null;
    String[] dcnTableName = null;
    long dcnQueryId = -1L;
    long localCheckSum = 0L;
    OracleStatement.BindChecksumListener bindChecksumListener;
    boolean isCloseOnCompletion = false;
    protected Object acProxy;
    private byte[] querycacheCompileKey;
    private long queryId;
    byte[] runtimeKey = null;
    MessageDigest md = null;

    abstract void doDescribe(boolean var1) throws SQLException;

    abstract void executeForDescribe() throws SQLException;

    abstract void executeForDescribeAsync(Consumer<Throwable> var1);

    abstract void executeForRows(boolean var1) throws SQLException;

    abstract void executeForRowsAsync(boolean var1, Consumer<Throwable> var2);

    protected abstract void fetch(int var1) throws SQLException;

    protected abstract void fetchAsync(int var1, Consumer<Throwable> var2);

    abstract boolean isFetchAsyncSupported();

    abstract void doClose() throws SQLException;

    abstract void closeQuery() throws SQLException;

    public int cursorIfRefCursor() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "cursorIfRefCursor not implemented").fillInStackTrace();
    }

    void continueReadRow(int start) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "continueReadRow is only implemented by the T4C statements.").fillInStackTrace();
    }

    void closeCursorOnPlainStatement() throws SQLException {
    }

    static final byte convertSqlKindEnumToByte(OracleStatement.SqlKind kind) {
        return kind.getKind();
    }

    static final OracleStatement.SqlKind convertSqlKindByteToEnum(byte kind) {
        return OracleStatement.SqlKind.valueOf(kind);
    }

    OracleStatement(PhysicalConnection connection, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        super(connection);
        connection.needLine();
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "<init>", "resultSetType={0}", (String)null, (Throwable)null, (Object)resultSetType);
        this.sqlObject = new OracleSql(connection.conversion, connection.allowMixingJdbcAndNamedBinds);
        this.processEscapes = connection.processEscapes;
        this.convertNcharLiterals = connection.convertNcharLiterals;
        this.gotLastBatch = false;
        this.closed = false;
        this.clearParameters = true;
        this.serverCursor = connection.getCreateStatementAsRefCursor();
        this.fixedString = connection.getDefaultFixedString();
        this.rowPrefetchChanged = false;
        this.currentCapacity = this.rowPrefetch = connection.defaultRowPrefetch;
        this.defaultRowPrefetch = this.rowPrefetch;
        this.autoTuneRowPrefetch = this.rowPrefetch == DEFAULT_ROW_PREFETCH_SIZE && connection.fetchSizeTuning > 0;
        this.userRsetType = resultSetType;
        if (this.userRsetType == OracleResultSet.ResultSetType.UNKNOWN) {
            this.userRsetType = DEFAULT_RESULT_SET_TYPE;
            this.realRsetType = DEFAULT_RESULT_SET_TYPE;
        } else {
            this.realRsetType = OracleResultSet.ResultSetType.UNKNOWN;
        }
        this.isFetchStreams = connection.useFetchSizeWithLongColumn || this.userRsetType != DEFAULT_RESULT_SET_TYPE;
        this.defaultLobPrefetchSize = connection.getVersionNumber() >= 11000 ? connection.defaultLobPrefetchSize : -1;
        this.needToParse = true;
        this.needToPrepareDefineBuffer = true;
        this.columnsDefinedByUser = false;
        this.rowData = this.createRowData();
        this.bindData = this.createBindData();
        connection.addStatement(this);
        this.createDMSSensors();
    }

    @Override
    public void setWrapper(OracleStatementWrapper w) {
        this.wrapper = w;
    }

    @Override
    public void setSnapshotSCN(long scn) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setSnapshotSCN", "scn={0}. ", (String)null, (Throwable)null, (Object)scn);
        this.connection.isResultSetCacheEnabled = false;
        this.doSetSnapshotSCN(scn);
    }

    void doSetSnapshotSCN(long scn) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("doSetSnapshotSCN").fillInStackTrace();
    }

    void createDMSSensors() throws SQLException {
        this.dmsSqlText = this.connection.commonDmsSqlText;
        if (this.connection.dmsUpdateSqlText()) {
            this.dmsSqlText.update(this.sqlObject.toString());
        }
        this.dmsExecute = this.connection.commonDmsExecute;
        this.dmsFetch = this.connection.commonDmsFetch;
    }

    void destroyDMSSensors() throws SQLException {
        if (this.dmsSqlText != null && this.dmsSqlText != this.connection.commonDmsSqlText) {
            this.dmsSqlText.destroy();
            this.dmsSqlText = null;
        }
        if (this.dmsExecute != null && this.dmsExecute != this.connection.commonDmsExecute) {
            this.dmsExecute.destroy();
            this.dmsExecute = null;
        }
        if (this.dmsFetch != null && this.dmsFetch != this.connection.commonDmsFetch) {
            this.dmsFetch.destroy();
            this.dmsFetch = null;
        }
    }

    protected ByteArray createBindData() {
        return DynamicByteArray.createDynamicByteArray(this.connection.getDiagnosable(), this.connection.getBlockSource());
    }

    protected ByteArray createRowData() {
        return DynamicByteArray.createDynamicByteArray(this.connection.getDiagnosable(), this.connection.getBlockSource());
    }

    void prepareAccessors() throws SQLException {
        int preFetchSize;
        if (this.accessors == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        this.isFetchingValueBasedLob = false;
        block4: for (int i = 0; i < this.numberOfDefinePositions; ++i) {
            Accessor accessor = this.accessors[i];
            if (accessor == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
            }
            switch (accessor.internalType) {
                case 8: 
                case 24: {
                    this.hasStream = true;
                    continue block4;
                }
                case 119: 
                case 127: {
                    this.isFetchingValueBasedLob = true;
                }
            }
        }
        if (this.streamList != null && !this.isFetchStreams) {
            this.rowPrefetch = 1;
        }
        this.definesBatchSize = preFetchSize = this.rowPrefetch;
        for (int i = 0; i < this.numberOfDefinePositions; ++i) {
            Accessor accessor = this.accessors[i];
            accessor.setCapacity(preFetchSize);
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareAccessors", "return rowPrefetch={0}, needToPrepareDefineBuffer={1}. ", (String)null, (Throwable)null, (Object)this.rowPrefetch, (Object)this.needToPrepareDefineBuffer);
    }

    boolean checkAccessorsUsable() throws SQLException {
        int len = this.accessors.length;
        if (len < this.numberOfDefinePositions) {
            return false;
        }
        boolean allHaveExternalType = true;
        boolean anyHaveExternalType = false;
        boolean result = false;
        for (int i = 0; i < this.numberOfDefinePositions; ++i) {
            Accessor accessor = this.accessors[i];
            if (accessor == null || accessor.externalType == 0) {
                allHaveExternalType = false;
                continue;
            }
            anyHaveExternalType = true;
        }
        if (allHaveExternalType) {
            result = true;
        } else {
            if (anyHaveExternalType) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
            }
            this.columnsDefinedByUser = false;
        }
        return result;
    }

    void executeMaybeDescribe() throws SQLException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "executeMaybeDescribe", "rowPrefetchChanged={0}, needToParse={1}, needToPrepareDefineBuffer={2}, columnsDefinedByUser={3}. ", (String)null, (Throwable)null, (Object)this.rowPrefetchChanged, (Object)this.needToParse, (Object)this.needToPrepareDefineBuffer, (Object)this.columnsDefinedByUser);
        this.needToPrepareDefineBuffer = !this.isDefineBufferPreparedForExecute();
        this.rowPrefetchChanged = false;
        try {
            this.cancelLock.enterExecuting();
            if (this.needToPrepareDefineBuffer) {
                this.prepareDefineBufferAndExecute();
            } else {
                this.markDanglingAccessors();
                this.rowData.startFetch(this.rowDataMaxBytesSize);
                this.executeForRows(false);
            }
            this.handleExecuteMaybeDescribeCompletion();
        }
        catch (SQLException ea) {
            this.needToParse = true;
            throw ea;
        }
        finally {
            this.rowData.endFetch();
            this.cancelLock.exitExecuting();
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "executeMaybeDescribe", "validRows={0}, needToPrepareDefineBuffer={1}. ", (String)null, (Throwable)null, (Object)this.validRows, (Object)this.needToPrepareDefineBuffer);
    }

    private void executeMaybeDescribeAsync(Consumer<Throwable> callback) {
        try {
            this.needToPrepareDefineBuffer = !this.isDefineBufferPreparedForExecute();
            this.rowPrefetchChanged = false;
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        Consumer<Throwable> executeCallback = error -> {
            try {
                if (error == null) {
                    this.handleExecuteMaybeDescribeCompletion();
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            if (error instanceof SQLException) {
                this.needToParse = true;
            }
            try {
                this.cancelLock.exitExecuting();
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            callback.accept((Throwable)error);
        };
        this.cancelLock.enterExecuting();
        if (this.needToPrepareDefineBuffer) {
            this.prepareDefineBufferAndExecuteAsync(executeCallback);
        } else {
            this.markDanglingAccessors();
            this.executeForRowsAsync(false, executeCallback);
        }
    }

    protected boolean isDefineBufferPreparedForExecute() throws SQLException {
        if (this.needToPrepareDefineBuffer) {
            return false;
        }
        if (this.rowPrefetchChanged && this.streamList == null && this.rowPrefetch > this.definesBatchSize) {
            return false;
        }
        if (this.accessors == null) {
            return false;
        }
        if (this.columnsDefinedByUser) {
            return this.checkAccessorsUsable();
        }
        return true;
    }

    private void prepareDefineBufferAndExecute() throws SQLException {
        boolean isDescribed = false;
        boolean needExplicitFetch = true;
        try {
            this.rowData.startFetch(this.rowDataMaxBytesSize);
            if (!this.columnsDefinedByUser) {
                this.executeForDescribe();
                isDescribed = true;
                boolean bl = needExplicitFetch = !this.aFetchWasDoneDuringDescribe;
            }
            if (this.needToPrepareDefineBuffer) {
                this.prepareAccessors();
            }
            this.markDanglingAccessors();
            if (needExplicitFetch) {
                this.executeForRows(isDescribed);
            }
        }
        finally {
            this.rowData.endFetch();
        }
    }

    private void prepareDefineBufferAndExecuteAsync(Consumer<Throwable> callback) {
        boolean executedForDescribe = !this.columnsDefinedByUser;
        Consumer<Throwable> describeCallback = error -> {
            boolean needExplicitFetch = !executedForDescribe || !this.aFetchWasDoneDuringDescribe;
            try {
                if (error == null) {
                    if (this.needToPrepareDefineBuffer) {
                        this.prepareAccessors();
                    }
                    this.markDanglingAccessors();
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            if (error == null && needExplicitFetch) {
                this.executeForRowsAsync(executedForDescribe, callback);
            } else {
                callback.accept((Throwable)error);
            }
        };
        if (executedForDescribe) {
            this.executeForDescribeAsync(describeCallback);
        } else {
            describeCallback.accept(null);
        }
    }

    private void markDanglingAccessors() {
        int len = this.accessors.length;
        for (int i = this.numberOfDefinePositions; i < len; ++i) {
            Accessor accessor = this.accessors[i];
            if (accessor == null) continue;
            accessor.rowSpaceIndicator = null;
        }
    }

    private void handleExecuteMaybeDescribeCompletion() {
        this.currentCapacity = this.rowPrefetch;
        this.storedRowCount = this.validRows == -2L ? 1 : (int)this.validRows;
        this.indexOfFirstRow = 0L;
    }

    void adjustGotLastBatch() {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "adjustGotLastBatch", "do nothing. ", null, null);
    }

    abstract void locationToPutBytes(Accessor var1, int var2, int var3) throws SQLException;

    protected boolean isQueryResultCached() throws SQLException {
        return false;
    }

    protected void cacheQueryResultIfAppropriate() throws SQLException {
    }

    protected void useCachedQueryResult() throws SQLException {
        this.freeRowData();
        this.rowData = this.cachedQueryResult.getRowData();
        this.accessors = this.cachedQueryResult.newAccessors(this);
        this.storedRowCount = this.cachedQueryResult.getNumberOfRows();
        this.validRows = this.cachedQueryResult.getNumberOfRows();
        this.cachedQueryResult = null;
        this.isAllFetched = true;
        this.resultFromCache = true;
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "useCachedQueryResult", "resultFromCache={0}, sql={1}. ", (String)null, null, (Object)this.resultFromCache, (Object)this.sqlObject.getOriginalSql());
    }

    private void logSQL(Logger logger, String sql) {
        if (logger == null || sql == null) {
            return;
        }
        logger.log(Level.CONFIG, Integer.toHexString(this.hashCode()).toUpperCase() + " SQL: " + this.sqlObject.getOriginalSql());
    }

    void doExecuteWithTimeout() throws SQLException {
        this.prepareForExecuteWithTimeout();
        long startToken = this.prepareDmsForExecution();
        try {
            this.prepareDmsSystemForExecution();
            this.cleanOldTempLobs();
            this.rowsProcessed = 0L;
            if (this.sqlKind.isSELECT()) {
                this.executeSQLSelect();
            } else {
                this.executeSQLStatement();
            }
            this.updateDmsSystemAfterExecution();
        }
        catch (SQLException ea) {
            this.connection.resetSystemContext();
            this.resetOnExceptionDuringExecute();
            throw ea;
        }
        catch (OutOfMemoryError oom) {
            this.freeRowData(false);
            if (this.bindData != null && this.bindData != this.rowData) {
                this.bindData.free(false);
            }
            this.hardClose(true);
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 17401) {
                    throw e;
                }
                this.connection.cleanup();
            }
            throw oom;
        }
        finally {
            this.updateDmsAfterExecution(startToken);
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doExecuteWithTimeout", "validRows={0}, needToPrepareDefineBuffer={1}. ", (String)null, (Throwable)null, (Object)this.validRows, (Object)this.needToPrepareDefineBuffer);
    }

    final void doExecuteWithTimeoutAsync(Consumer<Throwable> callback) {
        try {
            this.prepareForExecuteWithTimeout();
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        long startToken = this.prepareDmsForExecution();
        try {
            this.prepareDmsSystemForExecution();
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        this.cleanOldTempLobs();
        this.rowsProcessed = 0L;
        Consumer<Throwable> executeCallback = error -> {
            try {
                if (error == null) {
                    this.updateDmsSystemAfterExecution();
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            try {
                if (error instanceof SQLException) {
                    this.connection.resetSystemContext();
                    this.resetOnExceptionDuringExecute();
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            try {
                this.updateDmsAfterExecution(startToken);
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            callback.accept((Throwable)error);
        };
        if (this.sqlKind.isSELECT()) {
            this.executeSQLSelectAsync(executeCallback);
        } else {
            this.executeSQLStatementAsync(executeCallback);
        }
    }

    protected void prepareForExecuteWithDRCP() throws SQLException {
    }

    private void prepareForExecuteWithTimeout() throws SQLException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareForExecuteWithTimeout", "needToPrepareDefineBuffer={0}. ", (String)null, (Throwable)null, (Object)this.needToPrepareDefineBuffer);
        this.logSQL(null, this.sqlObject.getOriginalSql());
        if (this.sqlObject.isConnectionValidationSql()) {
            this.connection.checkAndDrain();
        }
        if (this.realRsetType == OracleResultSet.ResultSetType.UNKNOWN) {
            this.realRsetType = this.userRsetType;
        }
    }

    private long prepareDmsForExecution() {
        if (this.dmsExecute != null) {
            return this.dmsExecute.start();
        }
        return 0L;
    }

    private void updateDmsAfterExecution(long startToken) {
        if (this.dmsExecute != null) {
            this.dmsExecute.stop(startToken);
        }
    }

    private void prepareDmsSystemForExecution() throws SQLException {
        this.connection.updateSystemContext();
        if (this.connection.dmsUpdateSqlText()) {
            this.dmsSqlText.update(this.sqlObject.toString());
        }
    }

    private void updateDmsSystemAfterExecution() {
        if (this.connection.dmsVersion.equals((Object)DMSFactory.DMSVersion.v10G)) {
            ExecutionContext.get().setECIDSequenceNumber((int)this.connection.endToEndECIDSequenceNumber);
        } else if (this.connection.dmsVersion.equals((Object)DMSFactory.DMSVersion.v11)) {
            DMSFactory.Context.getECForJDBC().finished();
        }
    }

    private void executeSQLSelect() throws SQLException {
        if (this.connection.j2ee13Compliant) {
            this.ensureJ2EE13ComplianceForSelectSQL();
        }
        if (this.isQueryResultCached()) {
            this.useCachedQueryResult();
        } else {
            this.handleResultSetCacheMiss();
            OracleTimeout timeout = null;
            try {
                this.open();
                timeout = this.beginTimeout();
                this.executeMaybeDescribe();
            }
            finally {
                if (timeout != null) {
                    timeout.cancelTimeout();
                }
            }
            this.handleExecuteSQLSelectCompletion();
        }
        if (this.serverCursor) {
            this.adjustGotLastBatch();
        }
    }

    private void executeSQLSelectAsync(Consumer<Throwable> callback) {
        OracleTimeout timeout;
        try {
            if (this.connection.j2ee13Compliant) {
                this.ensureJ2EE13ComplianceForSelectSQL();
            }
            if (this.isQueryResultCached()) {
                this.useCachedQueryResult();
                if (this.serverCursor) {
                    this.adjustGotLastBatch();
                }
                callback.accept(null);
                return;
            }
            this.handleResultSetCacheMiss();
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        try {
            this.open();
            timeout = this.beginTimeout();
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        this.executeMaybeDescribeAsync(error -> {
            try {
                if (timeout != null) {
                    timeout.cancelTimeout();
                }
                if (error == null) {
                    this.handleExecuteSQLSelectCompletion();
                    if (this.serverCursor) {
                        this.adjustGotLastBatch();
                    }
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            callback.accept((Throwable)error);
        });
    }

    private void ensureJ2EE13ComplianceForSelectSQL() throws SQLException {
        if (this.executionType == 2) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 129).fillInStackTrace();
        }
    }

    private void handleResultSetCacheMiss() throws SQLException {
        if (!(this.rowData instanceof ReadOnlyByteArray)) {
            return;
        }
        this.rowData = this.createRowData();
        if (this.accessors == null) {
            return;
        }
        for (Accessor a : this.accessors) {
            if (a == null) continue;
            a.reinitForResultSetCache(this.rowData, this);
        }
    }

    protected final OracleTimeout beginTimeout() throws SQLException {
        if (this.queryTimeout == 0) {
            return null;
        }
        OracleTimeout timeout = this.connection.getTimeout();
        timeout.setTimeout((long)this.queryTimeout * 1000L, this);
        return timeout;
    }

    private void handleExecuteSQLSelectCompletion() throws SQLException {
        this.cacheQueryResultIfAppropriate();
        this.checkValidRowsStatus();
        this.cacheCompleteResultSet();
    }

    private void executeSQLStatement() throws SQLException {
        if (this.connection.j2ee13Compliant) {
            this.ensureJ2EE13ComplianceForNonSelectSQL();
        }
        ++this.currentRank;
        OracleTimeout timeout = null;
        try {
            this.cancelLock.enterExecuting();
            this.open();
            timeout = this.beginTimeout();
            this.rowData.startFetch(this.rowDataMaxBytesSize);
            this.executeForRows(false);
        }
        catch (SQLException ea) {
            this.handleExecuteSQLStatementFailure(ea);
            throw ea;
        }
        finally {
            this.rowData.endFetch();
            this.cancelLock.exitExecuting();
            if (timeout != null) {
                timeout.cancelTimeout();
            }
            this.handleExecuteSQLStatementCompletionAlways();
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "executeSQLStatement", "need to rebind the define Accessors and buffer={0}. ", (String)null, (Throwable)null, (Object)this.needToPrepareDefineBuffer);
    }

    private void executeSQLStatementAsync(Consumer<Throwable> callback) {
        OracleTimeout timeout;
        try {
            if (this.connection.j2ee13Compliant) {
                this.ensureJ2EE13ComplianceForNonSelectSQL();
            }
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        ++this.currentRank;
        this.cancelLock.enterExecuting();
        try {
            this.open();
            timeout = this.beginTimeout();
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(preExecutionFailure);
            return;
        }
        this.executeForRowsAsync(false, error -> {
            try {
                if (error instanceof SQLException) {
                    this.handleExecuteSQLStatementFailure((SQLException)error);
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            try {
                this.cancelLock.exitExecuting();
                if (timeout != null) {
                    timeout.cancelTimeout();
                }
                this.handleExecuteSQLStatementCompletionAlways();
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            callback.accept((Throwable)error);
        });
    }

    private void ensureJ2EE13ComplianceForNonSelectSQL() throws SQLException {
        if (!this.sqlKind.isPlsqlOrCall() && this.executionType == 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128).fillInStackTrace();
        }
    }

    private void handleExecuteSQLStatementFailure(SQLException sqlException) throws SQLException {
        this.needToParse = true;
        this.resetCurrentRowBinders();
    }

    private void handleExecuteSQLStatementCompletionAlways() throws SQLException {
        this.currentRank = 0;
        this.checkValidRowsStatus();
        this.cacheCompleteResultSet();
    }

    void resetOnExceptionDuringExecute() {
        this.needToParse = true;
    }

    void resetCurrentRowBinders() {
    }

    private void open() throws SQLException {
        this.connection.needLine();
        if (!this.isOpen) {
            this.connection.open(this);
            this.isOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OracleResultSet oracleResultSet;
            this.beginCurrentSql(sql);
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeQuery", null, null, null);
            try {
                this.cleanUpBeforeExecute();
                OracleResultSet result = null;
                this.realRsetType = OracleResultSet.ResultSetType.UNKNOWN;
                try {
                    this.executionType = 1;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "executeQuery", "needToPrepareDefineBuffer={0}. ", (String)null, (Throwable)null, (Object)this.needToPrepareDefineBuffer);
                    this.noMoreUpdateCounts = false;
                    this.ensureOpen();
                    this.checkIfBatchExists();
                    this.sendBatch();
                    this.hasStream = false;
                    this.sqlObject.initialize(sql);
                    this.sqlKind = this.sqlObject.getSqlKind();
                    this.needToParse = true;
                    this.prepareForNewResults(true, true, true);
                    if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
                        this.doExecuteWithTimeout();
                        if (this.implicitResultSetStatements == null) {
                            if (this.sqlKind.isPlsqlOrCall()) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128).fillInStackTrace();
                            }
                            if (this.validRows < 1L && this.validRows != -2L) {
                                this.isAllFetched = true;
                            }
                            result = this.currentResultSet = this.createResultSet();
                        }
                    } else {
                        result = this.doScrollStmtExecuteQuery();
                        if (result == null && this.implicitResultSetStatements == null) {
                            if (this.sqlKind.isPlsqlOrCall()) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 128).fillInStackTrace();
                            }
                            if (this.validRows < 1L && this.validRows != -2L) {
                                this.isAllFetched = true;
                            }
                            result = this.currentResultSet = this.createResultSet();
                        }
                    }
                }
                finally {
                    this.executionType = (byte)-1;
                }
                oracleResultSet = result;
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return oracleResultSet;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeQuery", null, null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void closeWithKey(String key) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("closeWithKey").fillInStackTrace();
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.closeOrCache(null);
        }
    }

    void closeWrapper(boolean isConnClosed) throws SQLException {
        if (this.wrapper != null) {
            this.wrapper.beClosed(isConnClosed);
        }
    }

    protected void closeOrCache(String key) throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        if (this.closed) {
            return;
        }
        if (this.connection.getLifecycle() == 2) {
            this.connection.needLineUnchecked();
        } else {
            this.connection.needLine();
        }
        if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "closeOrCache", "caching stmt={0}. ", (String)null, (Throwable)null, (Object)this);
            if (key == null) {
                if (this.connection.getImplicitCachingEnabled()) {
                    this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.sqlObject.getOriginalSql(), this.statementType, this.userRsetType);
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "closeOrCache", "statement is cached for sql={0}, state={1}. ", (String)null, null, (Object)this.sqlObject.getOriginalSql(), (Object)this.cacheState);
                } else {
                    this.cacheState = 0;
                    this.hardClose();
                }
            } else if (this.connection.getExplicitCachingEnabled()) {
                this.connection.cacheExplicitStatement((OraclePreparedStatement)this, key);
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "closeOrCache", "statement is cached for sql={0}, key={1}, state={2}. ", (String)null, null, (Object)this.sqlObject.getOriginalSql(), (Object)key, (Object)this.cacheState);
            } else {
                this.cacheState = 0;
                this.hardClose();
            }
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "closeOrCache", "closing stmt. {0}. ", (String)null, (Throwable)null, (Object)this);
            this.hardClose();
        }
    }

    protected void hardClose() throws SQLException {
        this.hardClose(true);
    }

    private void hardClose(boolean closeCursor) throws SQLException {
        this.alwaysOnClose();
        this.describedWithNames = false;
        this.described = false;
        this.connection.removeStatement(this);
        this.doClearDefines();
        if (this.isOpen && closeCursor && (this.connection.getLifecycle() == 1 || this.connection.getLifecycle() == 16 || this.connection.getLifecycle() == 8 || this.connection.getLifecycle() == 2)) {
            this.doClose();
            this.isOpen = false;
        }
        this.sqlObject = null;
        this.destroyDMSSensors();
    }

    protected void alwaysOnClose() throws SQLException {
        this.closeImplicitResults();
        OracleStatement child = this.children;
        while (child != null) {
            OracleStatement n = child.nextChild;
            child.close();
            child = n;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.closed = true;
        if (this.connection != null && (this.connection.getLifecycle() == 1 || this.connection.getLifecycle() == 2 || this.connection.getLifecycle() == 8) && this.currentResultSet != null) {
            this.currentResultSet.doneFetchingRows(false);
            this.currentResultSet.doClose();
            this.currentResultSet = null;
        }
        this.sqlWarning = null;
        this.m_batchItems = null;
    }

    void closeLeaveCursorOpen() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "closeLeaveCursorOpen", "needToPrepareDefineBuffer={0}. ", (String)null, (Throwable)null, (Object)this.needToPrepareDefineBuffer);
            if (this.closed) {
                return;
            }
            this.hardClose(false);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (int)this.executeLargeUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            long l;
            this.beginCurrentSql(sql);
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate", null, null, null);
            try {
                this.cleanUpBeforeExecute();
                l = this.executeUpdateInternal(sql);
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return l;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate", null, null, e, new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long executeUpdateInternal(String sql) throws SQLException {
        try {
            if (this.executionType == -1) {
                this.executionType = (byte)2;
            }
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfBatchExists();
            this.sendBatch();
            this.hasStream = false;
            this.sqlObject.initialize(sql);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true, true);
            if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            long l = this.validRows;
            return l;
        }
        finally {
            this.executionType = (byte)-1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl;
            this.beginCurrentSql(sql);
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute", null, null, null);
            try {
                this.cleanUpBeforeExecute();
                bl = this.executeInternal(sql);
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return bl;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute", null, null, e, new Object[0]);
            throw e;
        }
    }

    boolean executeInternal(String sql) throws SQLException {
        try {
            this.executionType = (byte)3;
            this.checkSum = 0L;
            this.checkSumComputationFailure = false;
            this.noMoreUpdateCounts = false;
            this.ensureOpen();
            this.checkIfBatchExists();
            this.sendBatch();
            this.hasStream = false;
            this.sqlObject.initialize(sql);
            this.sqlKind = this.sqlObject.getSqlKind();
            this.needToParse = true;
            this.prepareForNewResults(true, true, true);
            if (this.isCloseOnCompletion) {
                this.ensureOpen();
            }
            this.runtimeKey = null;
            if (this.userRsetType == DEFAULT_RESULT_SET_TYPE) {
                this.doExecuteWithTimeout();
            } else {
                this.doScrollStmtExecuteQuery();
            }
            boolean bl = this.sqlKind.isSELECT() || this.implicitResultSetStatements != null;
            return bl;
        }
        finally {
            this.executionType = (byte)-1;
        }
    }

    OracleResultSet createResultSet() throws SQLException {
        if (this.sqlKind.isSELECT() && this.batchWasExecuted) {
            return null;
        }
        this.computeOffsetOfFirstUserColumn();
        this.computeNumberOfUserColumns();
        if (this.realRsetType.isScrollable()) {
            this.fetchMode = FetchMode.APPEND;
        } else if (this.cachedQueryResult != null && this.cachedQueryResult.isFetching()) {
            this.fetchMode = FetchMode.APPEND;
        }
        return OracleResultSet.createResultSet(this);
    }

    final int getNumberOfUserColumns() throws SQLException {
        return this.numberOfUserColumns;
    }

    protected final void computeNumberOfUserColumns() throws SQLException {
        if (this.serverCursor) {
            this.numberOfUserColumns = this.accessors == null ? 0 : this.accessors.length;
        } else if (this.sqlKind.isSELECT()) {
            this.ensureOpen();
            if (!this.described) {
                try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                    this.doDescribe(false);
                    this.described = true;
                }
            }
            this.numberOfUserColumns = this.numberOfDefinePositions - (1 + this.offsetOfFirstUserColumn);
        } else {
            this.numberOfUserColumns = this.numReturnParams;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "computeNumberOfUserColumns", "numberOfUserColumns={0}. ", (String)null, (Throwable)null, (Object)this.numberOfUserColumns);
    }

    Accessor[] getDescription() throws SQLException {
        this.ensureOpen();
        if (!this.described) {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                this.doDescribe(false);
                this.described = true;
            }
        }
        return this.accessors;
    }

    Accessor[] getDescriptionWithNames() throws SQLException {
        this.ensureOpen();
        if (!this.describedWithNames) {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
            }
        }
        return this.accessors;
    }

    @Override
    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        return this.sqlObject.getSqlKind();
    }

    @Override
    public void clearDefines() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.doClearDefines();
        }
    }

    protected void doClearDefines() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        this.freeLine();
        this.streamList = null;
        this.columnsDefinedByUser = false;
        this.needToPrepareDefineBuffer = true;
        this.numberOfDefinePositions = 0;
        this.definesBatchSize = 0;
        this.described = false;
        this.describedWithNames = false;
        this.cleanupDefines();
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "reparseOnRedefineIfNeeded", "do nothing. ", null, null);
    }

    void defineColumnTypeInternal(int column_index, int type, int size, boolean sizeNotGiven, String typeName) throws SQLException {
        this.defineColumnTypeInternal(column_index, type, size, (short)1, sizeNotGiven, typeName);
    }

    void defineColumnTypeInternal(int column_index, int type, int size, short form, boolean sizeNotGiven, String typeName) throws SQLException {
        int max_len;
        if (this.connection.disableDefinecolumntype) {
            return;
        }
        if (column_index < 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (type == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
        int idx = column_index - 1;
        int n = max_len = this.maxFieldSize > 0 ? this.maxFieldSize : -1;
        if (!sizeNotGiven) {
            if (size < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53).fillInStackTrace();
            }
            if (type == 2005 || type == 2004) {
                if (max_len == -1 && size > 0 || max_len > 0 && size < max_len) {
                    max_len = size;
                }
            } else {
                max_len = -1;
            }
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 28).fillInStackTrace();
        }
        if (!this.columnsDefinedByUser) {
            this.doClearDefines();
            this.columnsDefinedByUser = true;
        }
        if (this.numberOfDefinePositions < column_index) {
            if (this.accessors == null || this.accessors.length < column_index) {
                Accessor[] na = new Accessor[column_index << 1];
                if (this.accessors != null) {
                    System.arraycopy(this.accessors, 0, na, 0, this.numberOfDefinePositions);
                }
                this.accessors = na;
            }
            this.numberOfDefinePositions = column_index;
        }
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                form = (short)2;
                break;
            }
            case 2009: {
                typeName = "SYS.XMLTYPE";
                break;
            }
        }
        int internal_type = this.getInternalType(type);
        if (!(internal_type != 109 && internal_type != 111 || typeName != null && !typeName.equals(""))) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
        }
        Accessor accessor = this.accessors[idx];
        boolean need_to_prepare = true;
        if (accessor != null) {
            int reusability = accessor.useForDataAccessIfPossible(internal_type, type, max_len, typeName);
            if (reusability == 0) {
                form = accessor.formOfUse;
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (reusability == 1) {
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (reusability == 2) {
                need_to_prepare = false;
            }
        }
        if (need_to_prepare) {
            this.needToPrepareDefineBuffer = true;
        }
        if (accessor == null) {
            this.accessors[idx] = this.allocateAccessor(internal_type, type, column_index, max_len, form, typeName, false);
            this.described = false;
            this.describedWithNames = false;
        }
        this.executeDoneForDefines = false;
    }

    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean isOutBind) throws SQLException {
        switch (internal_type) {
            case 96: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new CharAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 8: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                if (!isOutBind) {
                    return new LongAccessor(this, col_index, max_len, form, external_type, false, false);
                }
            }
            case 1: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new VarcharAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 2: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new NumberAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 252: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new BooleanAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 6: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new VarnumAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 24: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                if (!isOutBind) {
                    return new LongRawAccessor(this, col_index, max_len, form, external_type, false, false);
                }
            }
            case 23: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                if (isOutBind) {
                    return new OutRawAccessor(this, max_len, form, external_type);
                }
                return new RawAccessor(this, max_len, form, external_type, false, false);
            }
            case 100: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new BinaryFloatAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 101: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new BinaryDoubleAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 104: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
                    max_len = 18;
                    VarcharAccessor result = new VarcharAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
                    result.definedColumnType = -8;
                    return result;
                }
                return new RowidAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 102: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new ResultSetAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 12: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new DateAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 113: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                BlobAccessor result = new BlobAccessor(this, -1, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
                return result;
            }
            case 112: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                ClobAccessor result = new ClobAccessor(this, -1, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
                return result;
            }
            case 114: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                BfileAccessor result = new BfileAccessor(this, -1, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
                return result;
            }
            case 109: {
                if (typeName == null) {
                    if (isOutBind) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"").fillInStackTrace();
                }
                NamedTypeAccessor result = new NamedTypeAccessor(this, typeName, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
                ((Accessor)result).initMetadata();
                return result;
            }
            case 111: {
                if (typeName == null) {
                    if (isOutBind) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"null\"").fillInStackTrace();
                }
                RefTypeAccessor result = new RefTypeAccessor(this, typeName, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
                ((Accessor)result).initMetadata();
                return result;
            }
            case 180: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new TimestampAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 181: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new TimestamptzAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 231: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new TimestampltzAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 182: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new IntervalymAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 183: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new IntervaldsAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 127: {
                if (isOutBind && typeName != null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + external_type).fillInStackTrace();
                }
                return new VectorAccessor(this, max_len, form, external_type, isOutBind, isOutBind ? this.areOutBindsStoredInBindData() : false);
            }
            case 995: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89).fillInStackTrace();
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    void setDriverSpecificData(Accessor accessor) {
    }

    @Override
    public void defineColumnType(int column_index, int type) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.defineColumnTypeInternal(column_index, type, -1, true, null);
        }
    }

    @Override
    public void defineColumnType(int column_index, int type, int max_size) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.defineColumnTypeInternal(column_index, type, max_size, false, null);
        }
    }

    @Override
    public void defineColumnType(int column_index, int type, int max_size, short form_of_use) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.defineColumnTypeInternal(column_index, type, max_size, form_of_use, false, null);
        }
    }

    @Override
    @Deprecated
    public void defineColumnTypeBytes(int column_index, int type, int max_size) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "defineColumnTypeBytes", "call to defineColumnTypeBytes which is deprecated and may not behave as expected. ", null, null);
            this.defineColumnTypeInternal(column_index, type, max_size, false, null);
        }
    }

    @Override
    @Deprecated
    public void defineColumnTypeChars(int column_index, int type, int max_size) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.defineColumnTypeInternal(column_index, type, max_size, false, null);
        }
    }

    @Override
    public void defineColumnType(int column_index, int typeCode, String typeName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.defineColumnTypeInternal(column_index, typeCode, -1, true, typeName);
        }
    }

    void setCursorId(int id) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "setCursorId", "cursor id={0}. ", (String)null, (Throwable)null, (Object)id);
        this.cursorId = id;
    }

    void setPrefetchInternal(int new_value, boolean setRowPrefetch, boolean statement) throws SQLException {
        if (setRowPrefetch) {
            if (new_value <= 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 20).fillInStackTrace();
            }
        } else {
            if (new_value < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize").fillInStackTrace();
            }
            if (new_value == 0) {
                new_value = this.connection.getDefaultRowPrefetch();
            }
        }
        if (statement) {
            if (new_value != this.defaultRowPrefetch) {
                this.defaultRowPrefetch = new_value;
                if (this.currentResultSet == null || this.currentResultSet.closed) {
                    this.rowPrefetchChanged = true;
                }
            }
        } else if (new_value != this.rowPrefetch && (this.streamList == null || this.isFetchStreams)) {
            this.rowPrefetch = new_value;
            this.rowPrefetchChanged = true;
        }
    }

    @Override
    public void setRowPrefetch(int value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setPrefetchInternal(value, true, true);
            this.autoTuneRowPrefetch = false;
        }
    }

    @Override
    public void setLobPrefetchSize(int value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setLobPrefetchSize", "lob prefetch size={0}. ", (String)null, (Throwable)null, (Object)value);
            if (value < -1) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 267).fillInStackTrace();
            }
            this.defaultLobPrefetchSize = value;
        }
    }

    @Override
    public int getLobPrefetchSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int n = this.defaultLobPrefetchSize;
            return n;
        }
    }

    int getPrefetchInternal(boolean statement) {
        int ret_val = statement ? this.defaultRowPrefetch : this.rowPrefetch;
        return ret_val;
    }

    @Override
    public int getRowPrefetch() {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int n = this.getPrefetchInternal(true);
            return n;
        }
    }

    @Override
    public void setFixedString(boolean fixedString_value) {
        this.fixedString = fixedString_value;
    }

    @Override
    public boolean getFixedString() {
        return this.fixedString;
    }

    void check_row_prefetch_changed() throws SQLException {
        if (this.rowPrefetchChanged) {
            if (this.streamList == null) {
                this.prepareAccessors();
                if (this.prepareDefineBufferOnRowPrefetchChange()) {
                    this.needToPrepareDefineBuffer = true;
                }
            }
            this.rowPrefetchChanged = false;
        }
    }

    protected boolean prepareDefineBufferOnRowPrefetchChange() {
        return true;
    }

    void setDefinesInitialized(boolean value) {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "setDefinesInitialized", "no implemetation for kprb and thin, implemented only in OCI. ", null, null);
    }

    void checkValidRowsStatus() throws SQLException {
        if (this.validRows == -2L) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "checkValidRowsStatus", "nextStream={0}. ", (String)null, (Throwable)null, (Object)this.nextStream);
            this.validRows = 1L;
            this.connection.holdLine(this);
            OracleInputStream is = this.streamList;
            while (is != null) {
                if (is.hasBeenOpen) {
                    is = is.accessor.initForNewRow();
                }
                is.closed = false;
                is.hasBeenOpen = true;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "checkValidRowsStatus", "opens={0}. ", (String)null, (Throwable)null, (Object)is);
                is = is.nextStream;
            }
            this.nextStream = this.streamList;
        } else if (this.sqlKind.isSELECT()) {
            if (this.validRows < (long)this.rowPrefetch) {
                this.gotLastBatch = true;
            }
        } else if (!this.sqlKind.isPlsqlOrCall()) {
            this.rowsProcessed = this.validRows;
        }
    }

    void cacheCompleteResultSet() throws SQLException {
        if (!this.gotLastBatch) {
            return;
        }
        if (this.cachedQueryResult != null) {
            long sizeInMemory = this.rowData.length();
            for (Accessor accessor : this.accessors) {
                if (accessor == null) continue;
                sizeInMemory += (long)(24 + this.storedRowCount * 14);
            }
            ResultSetCache resultSetCache = this.connection.getResultSetCacheInternal();
            long sizeRemaining = resultSetCache.getMaxCacheSize() - resultSetCache.getCurrentCacheSize();
            if (sizeInMemory <= sizeRemaining) {
                ByteArray newRowData;
                this.rowData = newRowData = this.rowData.compact();
                this.rowData = ReadOnlyByteArray.newReadOnlyByteArray(this.connection.getDiagnosable(), this.rowData);
                this.cachedQueryResult.initialize(this.storedRowCount, this.rowData, this.accessors, sizeInMemory);
                resultSetCache.updateCurrentCacheSize(sizeInMemory);
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "cacheCompleteResultSet", "added resultset in cache for sql={0}. ", (String)null, null, (Object)this.sqlObject.getOriginalSql());
                this.cachedQueryResult = null;
            }
        }
    }

    void cleanupDefines() {
        this.freeRowData();
        this.accessors = null;
        this.isFetchingValueBasedLob = false;
        if (this.columnNameCache.size() > 0) {
            this.columnNameCache = new IdentityHashMap(COLUMN_NAME_CACHE_INITIAL_SIZE);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            int n = this.maxFieldSize;
            return n;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (max < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            this.maxFieldSize = max;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.getLargeMaxRows();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.ensureOpen();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (max < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.processEscapes = enable;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int n = this.doGetQueryTimeout();
            return n;
        }
    }

    public int doGetQueryTimeout() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        this.ensureOpen();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int max) throws SQLException {
        this.debug(Level.FINER, SecurityLabel.CONFIG, CLASS_NAME, "setQueryTimeout", "query timeout={0}. ", (String)null, (Throwable)null, (Object)max);
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.doSetQueryTimeout(max);
        }
    }

    protected void doSetQueryTimeout(int max) throws SQLException {
        this.ensureOpen();
        if (max < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.queryTimeout = max;
    }

    @Override
    public void cancel() throws SQLException {
        this.ensureOpen();
        this.doCancel();
    }

    boolean doCancel() throws SQLException {
        boolean connectionHasBeenCancelled = false;
        if (this.closed) {
            return connectionHasBeenCancelled;
        }
        if (this.connection.statementHoldingLine != null) {
            this.freeLine();
        } else if (this.cancelLock.enterCanceling()) {
            try {
                connectionHasBeenCancelled = true;
                this.connection.cancelOperationOnServer(true);
            }
            finally {
                this.cancelLock.exitCanceling();
            }
        } else {
            return connectionHasBeenCancelled;
        }
        OracleStatement s = this.children;
        while (s != null) {
            connectionHasBeenCancelled = connectionHasBeenCancelled || s.doCancel();
            s = s.nextChild;
        }
        this.connection.releaseLineForCancel();
        return connectionHasBeenCancelled;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return this.sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
        this.sqlWarning = null;
    }

    void foundPlsqlCompilerWarning() throws SQLException {
        SQLWarning w = DatabaseError.addSqlWarning(this.sqlWarning, "Found Plsql compiler warnings.", 24439);
        if (this.sqlWarning != null) {
            this.sqlWarning.setNextWarning(w);
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "foundPlsqlCompilerWarning", "found Plsql compile warning. ", null, null);
        } else {
            this.sqlWarning = w;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("setCursorName").fillInStackTrace();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.implicitResultSetStatements != null) {
                if (this.currentResultSet != null) {
                    OracleResultSet oracleResultSet = this.currentResultSet;
                    return oracleResultSet;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 283).fillInStackTrace();
            }
            if (this.sqlKind.isSELECT()) {
                if (this.currentResultSet == null) {
                    this.currentResultSet = this.createResultSet();
                }
                OracleResultSet oracleResultSet = this.currentResultSet;
                return oracleResultSet;
            }
            ResultSet resultSet = null;
            return resultSet;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int n = (int)this.getLargeUpdateCount();
            return n;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            long updateCount = 0L;
            switch (this.sqlKind) {
                case UNINITIALIZED: 
                case SELECT_FOR_UPDATE: 
                case SELECT: {
                    updateCount = -1L;
                    break;
                }
                case ALTER_SESSION: 
                case OTHER: {
                    updateCount = !this.noMoreUpdateCounts ? this.rowsProcessed : -1L;
                    this.noMoreUpdateCounts = true;
                    break;
                }
                case PLSQL_BLOCK: 
                case CALL_BLOCK: {
                    updateCount = -1L;
                    this.noMoreUpdateCounts = true;
                    break;
                }
                case DELETE: 
                case INSERT: 
                case MERGE: 
                case UPDATE: {
                    updateCount = !this.noMoreUpdateCounts ? this.rowsProcessed : -1L;
                    this.noMoreUpdateCounts = true;
                }
            }
            long l = updateCount;
            return l;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureOpen();
        return this.getMoreResults(1);
    }

    @Override
    public int sendBatch() throws SQLException {
        return 0;
    }

    protected void increaseCapacity(int numberOfRows) {
        if (this.storedRowCount + numberOfRows > this.currentCapacity) {
            if (this.currentCapacity < 1024) {
                int n = this.currentCapacity * 4;
            }
            int newCapacity = this.currentCapacity < 16384 ? (int)((double)this.currentCapacity * 1.5) : (int)((double)this.currentCapacity * 1.2);
            newCapacity = Math.max(this.storedRowCount + numberOfRows, newCapacity);
            newCapacity = (newCapacity / this.rowPrefetch + 1) * this.rowPrefetch;
            for (Accessor a : this.accessors) {
                if (a == null) continue;
                a.setCapacity(newCapacity);
            }
            this.currentCapacity = newCapacity;
        }
        assert (this.currentCapacity >= this.storedRowCount + numberOfRows) : "currentCapacity: " + this.currentCapacity + " storedRowCount: " + this.storedRowCount + ", numberOfRows: " + numberOfRows;
    }

    protected void drainStreams() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    @Override
    final int physicalRowIndex(long logicalRowIndex) {
        return (int)(logicalRowIndex - this.indexOfFirstRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long fetchMoreRows(long firstRow) throws SQLException {
        assert (!this.isAllFetched) : "isAllFetched: " + this.isAllFetched;
        this.cleanTempLobsBeforeFetchMoreRows();
        long startToken = 0L;
        if (this.dmsFetch != null) {
            startToken = this.dmsFetch.start();
        }
        try {
            this.connection.updateSystemContext();
            this.prepareAccessorsBeforeFetchMoreRows();
            this.drainStreams();
            this.connection.needLine();
            OracleTimeout timeout = null;
            try {
                int firstRowStorageOffset;
                this.cancelLock.enterExecuting();
                assert (this.fetchMode != FetchMode.APPEND || firstRow <= Integer.MAX_VALUE) : "firstRow:" + firstRow;
                int n = firstRowStorageOffset = this.fetchMode == FetchMode.APPEND ? (int)firstRow : 0;
                if (this.serverCursor && this.validRows == 0L) {
                    timeout = this.beginTimeout();
                }
                this.fetch(firstRowStorageOffset);
                assert (this.validRows != -2L || this.rowPrefetch == 1) : "validRows: " + this.validRows + " rowPrefetch: " + this.rowPrefetch;
            }
            finally {
                this.cancelLock.exitExecuting();
                if (timeout != null) {
                    timeout.cancelTimeout();
                }
            }
            this.handleFetchMoreRowsCompletion(firstRow);
            long l = this.validRows;
            return l;
        }
        finally {
            if (this.dmsFetch != null) {
                this.dmsFetch.stop(startToken);
            }
        }
    }

    final void fetchMoreRowsAsync(long firstRow, BiConsumer<Long, Throwable> callback) {
        try {
            this.cleanTempLobsBeforeFetchMoreRows();
        }
        catch (SQLException preExecutionFailure) {
            callback.accept(null, preExecutionFailure);
            return;
        }
        long startToken = this.dmsFetch != null ? this.dmsFetch.start() : 0L;
        try {
            assert (this.fetchMode != FetchMode.APPEND || firstRow <= Integer.MAX_VALUE) : "firstRow:" + firstRow;
            this.prepareAccessorsBeforeFetchMoreRows();
            this.drainStreams();
            this.connection.needLine();
        }
        catch (SQLException preExecutionFailure) {
            if (this.dmsFetch != null) {
                this.dmsFetch.stop(startToken);
            }
            callback.accept(null, preExecutionFailure);
            return;
        }
        this.cancelLock.enterExecuting();
        assert (this.fetchMode != FetchMode.APPEND || firstRow <= Integer.MAX_VALUE) : "firstRow:" + firstRow;
        int firstRowStorageOffset = this.fetchMode == FetchMode.APPEND ? (int)firstRow : 0;
        this.fetchAsync(firstRowStorageOffset, error -> {
            Long result = null;
            try {
                this.cancelLock.exitExecuting();
                if (error == null) {
                    assert (this.validRows != -2L || this.rowPrefetch == 1) : "validRows: " + this.validRows + " rowPrefetch: " + this.rowPrefetch;
                    this.handleFetchMoreRowsCompletion(firstRow);
                    result = this.validRows;
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
                result = null;
            }
            try {
                if (this.dmsFetch != null) {
                    this.dmsFetch.stop(startToken);
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
                result = null;
            }
            callback.accept(result, (Throwable)error);
        });
    }

    private void cleanTempLobsBeforeFetchMoreRows() throws SQLException {
        if (this.currentResultSet != null && this.currentResultSet.doGetType() == 1003) {
            if (!this.tempRowClobsToFree.isEmpty()) {
                this.cleanTempClobs(this.tempRowClobsToFree);
                this.tempRowClobsToFree.clear();
            }
            if (!this.tempRowBlobsToFree.isEmpty()) {
                this.cleanTempBlobs(this.tempRowBlobsToFree);
                this.tempRowBlobsToFree.clear();
            }
        }
    }

    private void prepareAccessorsBeforeFetchMoreRows() throws SQLException {
        if (this.fetchMode == FetchMode.OVERWRITE) {
            this.prepareForNewRowData();
        } else if (this.fetchMode == FetchMode.APPEND) {
            this.increaseCapacity(this.rowPrefetch);
        }
        this.check_row_prefetch_changed();
    }

    private void updateRowStorageCountAfterFetchMoreRows() {
        if (this.fetchMode == FetchMode.APPEND) {
            this.storedRowCount += (int)this.validRows;
        } else {
            this.indexOfFirstRow += (long)this.storedRowCount;
            this.storedRowCount = (int)this.validRows;
        }
    }

    private void updateIsAllFetchedAfterFetchMoreRows() {
        if (this.maxRows > 0L && this.indexOfFirstRow + (long)this.storedRowCount >= this.maxRows) {
            this.isAllFetched = true;
        }
    }

    private void handleFetchMoreRowsCompletion(long firstRow) throws SQLException {
        this.checkValidRowsStatus();
        this.updateRowStorageCountAfterFetchMoreRows();
        this.updateIsAllFetchedAfterFetchMoreRows();
        this.cacheCompleteResultSet();
        assert (this.physicalRowIndex(firstRow) >= 0) : "firstRow: " + firstRow + " indexOfFirstRow: " + this.indexOfFirstRow;
        assert (this.physicalRowIndex(firstRow) < this.currentCapacity) : "firstRow: " + firstRow + " indexOfFirstRow: " + this.indexOfFirstRow + " currentCapacity: " + this.currentCapacity;
        assert (this.validRows >= 0L) : "validRows: " + this.validRows;
        assert (this.validRows > 0L || this.isAllFetched) : "validRows: " + this.validRows + ", isAllFetched: " + this.isAllFetched;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "handleFetchMoreRowsCompletion", "firstRow={0}, validRows={1}. ", (String)null, (Throwable)null, (Object)firstRow, (Object)this.validRows);
    }

    int storedRowCount() {
        return this.storedRowCount;
    }

    int refreshRows(long firstRow, int numberOfRows) throws SQLException {
        ARRAY keys = this.connection.createARRAY(SYS_ODCIVARCHAR2LIST, this.getRowKeys(this.physicalRowIndex(firstRow), numberOfRows));
        return this.refreshRowsInternal(keys, this.physicalRowIndex(firstRow), numberOfRows);
    }

    void insertRow(long row, RowId rowId) throws SQLException {
        if (this.currentCapacity < this.storedRowCount + 1) {
            this.increaseCapacity(this.storedRowCount + 1);
        }
        RowId[] keyArray = new RowId[]{rowId};
        ARRAY keys = this.connection.createARRAY(SYS_ODCIVARCHAR2LIST, keyArray);
        for (Accessor a : this.accessors) {
            if (a == null) continue;
            a.insertNull(this.physicalRowIndex(row));
        }
        int count = this.refreshRowsInternal(keys, this.physicalRowIndex(row), 1);
        assert (count == 1) : "count: " + count;
        this.storedRowCount += count;
    }

    /*
     * Exception decompiling
     */
    protected int refreshRowsInternal(Array keys, int destRow, int numberOfRows) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String[] getRowKeys(int firstRow, int numberOfRows) throws SQLException {
        ArrayList<String> a = new ArrayList<String>(numberOfRows);
        int stop = Math.min(numberOfRows, this.storedRowCount - firstRow);
        for (int i = 0; i < stop; ++i) {
            a.add(this.accessors[0].getString(firstRow + i));
        }
        return a.toArray(new String[0]);
    }

    void removeRowFromCache(long row) throws SQLException {
        if (row < this.indexOfFirstRow) {
            --this.indexOfFirstRow;
        } else if (row >= this.indexOfFirstRow) {
            assert (row < this.indexOfFirstRow + (long)this.storedRowCount) : "row: " + row + " indexOfFirstRow: " + this.indexOfFirstRow + " storedRowCount: " + this.storedRowCount;
            for (Accessor a : this.accessors) {
                if (a == null) continue;
                this.deleteRow(a, this.physicalRowIndex(row));
            }
            --this.storedRowCount;
        }
    }

    void deleteRow(Accessor accessor, int row) throws SQLException {
        accessor.deleteRow(row);
    }

    void prepareForNewResults(boolean resetPrefetch, boolean clearStreamList, boolean clearImplicitResults) throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareForNewResults", "resetPrefetch={0}, clearStreamList={1}, clearImplicitResults={2}. ", (String)null, (Throwable)null, (Object)resetPrefetch, (Object)clearStreamList, (Object)clearImplicitResults);
        if (!this.closed) {
            this.clearWarnings();
        }
        if (clearImplicitResults) {
            this.closeImplicitResults();
        }
        this.closeAllStreams(clearStreamList);
        if (this.currentResultSet != null) {
            this.connection.assertLockHeldByCurrentThread();
            this.currentResultSet.doClose();
            this.currentResultSet = null;
        }
        this.prepareForNewRowData();
        this.rowData.reset();
        this.storedRowCount = 0;
        this.indexOfFirstRow = 0L;
        this.isAllFetched = false;
        this.checkSum = 0L;
        this.checkSumComputationFailure = false;
        this.validRows = 0L;
        this.batchRowsUpdatedArray = null;
        this.gotLastBatch = false;
        if (resetPrefetch) {
            this.offsetOfFirstUserColumn = -1;
            this.numberOfUserColumns = -1;
        }
        if (this.needToParse && !this.columnsDefinedByUser) {
            if (clearStreamList && this.numberOfDefinePositions != 0) {
                this.numberOfDefinePositions = 0;
            }
            this.needToPrepareDefineBuffer = true;
        }
        if (resetPrefetch && this.rowPrefetch != this.defaultRowPrefetch && this.streamList == null) {
            this.rowPrefetch = this.defaultRowPrefetch;
            this.rowPrefetchChanged = true;
        }
        this.rowPrefetchTuningDone = false;
        this.tunedFetchSizeList.clear();
    }

    protected void prepareForNewRowData() {
        if (this.accessors != null) {
            for (Accessor accessor : this.accessors) {
                if (accessor == null) continue;
                accessor.releaseRowData();
            }
        }
        this.fetchMode = FetchMode.OVERWRITE;
    }

    void closeAllStreams(boolean clearStreamList) throws SQLException {
        this.drainStreams();
        if (clearStreamList) {
            OracleInputStream s = this.streamList;
            OracleInputStream prev = null;
            this.streamList = null;
            while (s != null) {
                if (!s.hasBeenOpen) {
                    if (prev == null) {
                        this.streamList = s;
                    } else {
                        prev.nextStream = s;
                    }
                    prev = s;
                }
                s = s.nextStream;
            }
        }
    }

    void reopenStreams() throws SQLException {
        OracleInputStream is = this.streamList;
        while (is != null) {
            if (is.hasBeenOpen) {
                is = is.accessor.initForNewRow();
            }
            is.closed = false;
            is.hasBeenOpen = true;
            is = is.nextStream;
        }
        this.nextStream = this.streamList;
    }

    void endOfResultSet() throws SQLException {
        this.prepareForNewResults(false, false, false);
        this.doClearDefines();
        this.rowPrefetchInLastFetch = -1;
    }

    boolean wasNullValue(long row) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "wasNull").fillInStackTrace();
        }
        if (this.lastIndex < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24).fillInStackTrace();
        }
        return this.isNull(row, this.lastIndex);
    }

    boolean isNull(long rowIndex, int columnIndex) throws SQLException {
        if (this.sqlKind.isSELECT() || this.isDmlReturning) {
            return this.accessors[columnIndex + this.offsetOfFirstUserColumn].isNull(this.physicalRowIndex(rowIndex));
        }
        assert (rowIndex == (long)this.currentRank) : "rowIndex: " + rowIndex + " currentRank: " + this.currentRank;
        return this.outBindAccessors[columnIndex - 1].isNull(this.currentRank);
    }

    int getColumnIndex(String columnName) throws SQLException {
        this.ensureOpen();
        Integer index = this.columnNameCache.get(columnName);
        if (index == null) {
            String localColName = columnName;
            if (localColName != null) {
                localColName = this.enquoteIdentifier(localColName, true);
                localColName = localColName.substring(1, localColName.length() - 1);
            }
            index = this.getColumnIndexPrimitive(localColName);
            if (this.columnNameCache.size() <= this.accessors.length) {
                this.columnNameCache.put(columnName, index);
            }
        }
        return index;
    }

    private int getColumnIndexPrimitive(String columnName) throws SQLException {
        if (!this.describedWithNames) {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                this.doDescribe(true);
                this.described = true;
                this.describedWithNames = true;
            }
        }
        for (int index = 1 + this.offsetOfFirstUserColumn; index < this.numberOfDefinePositions; ++index) {
            if (!this.accessors[index].columnName.equalsIgnoreCase(columnName)) continue;
            return index - this.offsetOfFirstUserColumn;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
    }

    int getJDBCType(int internalType) throws SQLException {
        int result = 0;
        switch (internalType) {
            case 6: {
                result = 2;
                break;
            }
            case 100: {
                result = 100;
                break;
            }
            case 101: {
                result = 101;
                break;
            }
            case 999: {
                result = 999;
                break;
            }
            case 96: {
                result = 1;
                break;
            }
            case 1: {
                result = 12;
                break;
            }
            case 8: {
                result = -1;
                break;
            }
            case 12: {
                result = 91;
                break;
            }
            case 180: {
                result = 93;
                break;
            }
            case 181: {
                result = -101;
                break;
            }
            case 231: {
                result = -102;
                break;
            }
            case 182: {
                result = -103;
                break;
            }
            case 183: {
                result = -104;
                break;
            }
            case 23: {
                result = -2;
                break;
            }
            case 24: {
                result = -4;
                break;
            }
            case 104: {
                result = -8;
                break;
            }
            case 113: {
                result = 2004;
                break;
            }
            case 119: {
                result = 2016;
                break;
            }
            case 112: {
                result = 2005;
                break;
            }
            case 114: {
                result = -13;
                break;
            }
            case 102: {
                result = -10;
                break;
            }
            case 109: {
                result = 2002;
                break;
            }
            case 111: {
                result = 2006;
                break;
            }
            case 998: {
                result = -14;
                break;
            }
            case 995: {
                result = 0;
                break;
            }
            case 127: {
                result = -105;
                break;
            }
            default: {
                result = internalType;
            }
        }
        return result;
    }

    int getInternalType(int externalType) throws SQLException {
        int result = 0;
        switch (externalType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                result = 6;
                break;
            }
            case 100: {
                result = 100;
                break;
            }
            case 101: {
                result = 101;
                break;
            }
            case 252: {
                result = 252;
                break;
            }
            case 999: {
                result = 999;
                break;
            }
            case 1: {
                result = 96;
                break;
            }
            case -15: 
            case -9: 
            case 12: {
                result = 1;
                break;
            }
            case -16: 
            case -1: {
                result = 8;
                break;
            }
            case 91: 
            case 92: {
                result = 12;
                break;
            }
            case -100: 
            case 93: {
                result = 180;
                break;
            }
            case -101: 
            case 2013: 
            case 2014: {
                result = 181;
                break;
            }
            case -102: {
                result = 231;
                break;
            }
            case -103: {
                result = 182;
                break;
            }
            case -104: {
                result = 183;
                break;
            }
            case -3: 
            case -2: {
                result = 23;
                break;
            }
            case -4: {
                result = 24;
                break;
            }
            case -8: {
                result = 104;
                break;
            }
            case 2004: {
                result = 113;
                break;
            }
            case 2016: {
                result = 119;
                break;
            }
            case 2005: 
            case 2011: {
                result = 112;
                break;
            }
            case -13: {
                result = 114;
                break;
            }
            case -10: 
            case 2012: {
                result = 102;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: 
            case 2009: {
                result = 109;
                break;
            }
            case 2006: {
                result = 111;
                break;
            }
            case -14: {
                result = 998;
                break;
            }
            case 70: {
                result = 1;
                break;
            }
            case 0: {
                result = 995;
                break;
            }
            case 16: {
                result = 252;
                break;
            }
            case -109: 
            case -108: 
            case -107: 
            case -106: 
            case -105: {
                result = 127;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, Integer.toString(externalType)).fillInStackTrace();
            }
        }
        return result;
    }

    ResultSetMetaData getResultSetMetaData() throws SQLException {
        return new OracleResultSetMetaData(this.connection, this, this.offsetOfFirstUserColumn);
    }

    void describe() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        this.ensureOpen();
        if (!this.described) {
            this.doDescribe(false);
        }
    }

    void freeLine() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    @Override
    void closeUsedStreams(int columnIndex) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < columnIndex) {
            try {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "closeUsedStreams", "closing. stream={0}, index={1}. ", (String)null, (Throwable)null, (Object)this.nextStream, (Object)this.nextStream.columnIndex);
                this.nextStream.close();
            }
            catch (IOException exc) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
            }
            this.nextStream = this.nextStream.nextStream;
        }
    }

    final void ensureOpen() throws SQLException {
        if (this.connection.getLifecycle() != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    void allocateTmpByteArray() {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "allocateTmpByteArray", "for Thin only. ", null, null);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        block8: {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                this.ensureOpen();
                if (direction == 1000) {
                    break block8;
                }
                if (direction == 1001 || direction == 1002) {
                    this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
                    break block8;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection").fillInStackTrace();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.setPrefetchInternal(rows, false, true);
            this.isFetchSizeSet = rows != 0;
            this.autoTuneRowPrefetch = false;
        }
    }

    final boolean isFetchSizeSet() {
        return this.isFetchSizeSet;
    }

    @Override
    public final int getFetchSize() throws SQLException {
        this.ensureOpen();
        return this.getPrefetchInternal(true);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return this.userRsetType.getConcur();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return this.userRsetType.getType();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureOpen();
        return this.connection.getWrapper();
    }

    boolean isOracleBatchStyle() {
        return false;
    }

    void initBatch() {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initBatch", "do nothing. ", null, null);
    }

    int getBatchSize() {
        if (this.m_batchItems == null) {
            return 0;
        }
        return this.m_batchItems.size();
    }

    void addBatchItem(String sql) {
        if (this.m_batchItems == null) {
            this.m_batchItems = new Vector();
        }
        this.m_batchItems.addElement(sql);
    }

    String getBatchItem(int index) {
        if (this.m_batchItems == null) {
            return null;
        }
        return this.m_batchItems.elementAt(index);
    }

    void clearBatchItems() {
        if (this.m_batchItems != null) {
            this.m_batchItems.removeAllElements();
        }
    }

    void checkIfBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 81, "batch must be either executed or cleared").fillInStackTrace();
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.addBatchItem(sql);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.clearBatchCritical();
        }
    }

    void clearBatchCritical() throws SQLException {
        this.ensureOpen();
        this.clearBatchItems();
    }

    int[] toIntArray(long[] la) {
        int[] ia = new int[la.length];
        for (int i = 0; i < la.length; ++i) {
            ia[i] = (int)la[i];
        }
        return ia;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int[] nArray = this.toIntArray(this.executeLargeBatch());
            return nArray;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long[] executeForLargeBatch() throws SQLException {
        int numberOfDefinePositionsSaved = this.numberOfDefinePositions;
        int validRowsTotal = 0;
        int i = 0;
        long[] results = new long[this.getBatchSize()];
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeBatch", "batch size={0}. ", (String)null, (Throwable)null, (Object)results.length);
        try {
            Object timeout;
            this.connection.needLine();
            for (i = 0; i < results.length; ++i) {
                this.sqlObject.initialize(this.getBatchItem(i));
                this.sqlKind = this.sqlObject.getSqlKind();
                if (this.connection.dmsUpdateSqlText()) {
                    this.dmsSqlText.update(this.sqlObject.toString());
                }
                this.needToParse = true;
                this.numberOfDefinePositions = 0;
                this.rowsProcessed = 0L;
                this.currentRank = 1;
                OracleStatement.requireValidBatchCommand(this, i);
                if (!this.isOpen) {
                    this.connection.open(this);
                    this.isOpen = true;
                }
                timeout = null;
                try {
                    this.cancelLock.enterExecuting();
                    timeout = this.beginTimeout();
                    this.rowData.startFetch(this.rowDataMaxBytesSize);
                    this.executeForRows(false);
                    results[i] = this.validRows;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "executeForLargeBatch", "batch item={0}, return={1}. ", (String)null, (Throwable)null, (Object)i, (Object)this.validRows);
                    if (this.validRows > 0L) {
                        validRowsTotal = (int)((long)validRowsTotal + this.validRows);
                    }
                }
                catch (SQLException sqlException) {
                    this.needToParse = true;
                    this.resetCurrentRowBinders();
                    throw sqlException;
                }
                finally {
                    this.rowData.endFetch();
                    this.cancelLock.exitExecuting();
                    if (timeout != null) {
                        ((OracleTimeout)timeout).cancelTimeout();
                    }
                    this.validRows = validRowsTotal;
                    this.checkValidRowsStatus();
                    this.cacheCompleteResultSet();
                }
                if (results[i] >= 0L) continue;
                throw (SQLException)DatabaseError.createBatchUpdateException(81, (Object)("command return value " + results[i]), i, results).fillInStackTrace();
            }
            timeout = results;
            return timeout;
        }
        catch (SQLException sqlException) {
            throw OracleStatement.batchUpdateException(sqlException, i, results);
        }
        finally {
            this.numberOfDefinePositions = numberOfDefinePositionsSaved;
        }
    }

    protected static void requireValidBatchCommand(OracleStatement statement, int index) throws SQLException {
        if (statement.sqlKind.isSELECT()) {
            throw (SQLException)DatabaseError.createSqlException(80, "invalid SELECT batch command at index " + index).fillInStackTrace();
        }
    }

    protected static BatchUpdateException batchUpdateException(SQLException sqlException, int resultIndex, long[] results) {
        BatchUpdateException batchUpdateException = DatabaseError.createBatchUpdateException(81, (Object)sqlException.getMessage(), resultIndex, results);
        batchUpdateException.setNextException(sqlException);
        batchUpdateException.fillInStackTrace();
        return batchUpdateException;
    }

    void copyDefines(OracleStatement src, int numRows) throws SQLException {
        if (src.columnsDefinedByUser) {
            Accessor[] srcAcc = src.accessors;
            this.accessors = new Accessor[srcAcc.length];
            for (int i = 0; i < srcAcc.length; ++i) {
                if (srcAcc[i] == null) continue;
                this.accessors[i] = srcAcc[i].copyForDefine(this);
                this.accessors[i].setCapacity(numRows);
            }
            this.numberOfDefinePositions = src.numberOfDefinePositions;
            this.definedColumnType = src.definedColumnType;
            this.definedColumnSize = src.definedColumnSize;
            this.definedColumnFormOfUse = src.definedColumnFormOfUse;
            this.columnsDefinedByUser = true;
        }
    }

    int copyBinds(Statement toStmt, int offset) throws SQLException {
        return 0;
    }

    public void notifyCloseRset() throws SQLException {
        this.endOfResultSet();
    }

    public String getOriginalSql() throws SQLException {
        if (this.sqlObject == null) {
            return null;
        }
        return this.sqlObject.getOriginalSql();
    }

    boolean isRowidPrepended() {
        return this.isRowidPrepended;
    }

    void computeOffsetOfFirstUserColumn() {
        this.offsetOfFirstUserColumn = -1;
        if (this.sqlKind.isSELECT()) {
            if (this.isRowidPrepended) {
                ++this.offsetOfFirstUserColumn;
            }
        } else if (this.numReturnParams > 0) {
            this.offsetOfFirstUserColumn = this.numberOfBindPositions - this.numReturnParams - 1;
        }
    }

    private boolean needRowId() {
        return (this.realRsetType == OracleResultSet.ResultSetType.UNKNOWN ? this.userRsetType : this.realRsetType).isIdentifierRequired();
    }

    void doScrollExecuteCommon() throws SQLException {
        if (!this.sqlKind.isSELECT()) {
            this.doExecuteWithTimeout();
            return;
        }
        if (!this.needRowId()) {
            this.doExecuteWithTimeout();
            this.currentResultSet = this.createResultSet();
            this.realRsetType = this.userRsetType;
        } else {
            try {
                this.sqlObject.setIncludeRowid(true);
                this.isRowidPrepended = true;
                this.needToParse = true;
                this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doScrollExecuteCommon", "revised SQL={0}. ", null, null, () -> {
                    try {
                        return new Object[]{this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals)};
                    }
                    catch (SQLException e) {
                        return new Object[]{e.getMessage()};
                    }
                });
                this.prepareForNewResults(true, false, true);
                if (this.columnsDefinedByUser) {
                    Accessor[] oldaccs = this.accessors;
                    if (this.accessors == null || this.accessors.length <= this.numberOfDefinePositions) {
                        this.accessors = new Accessor[this.numberOfDefinePositions + 1];
                    }
                    if (oldaccs != null) {
                        for (int i = this.numberOfDefinePositions; i > 0; --i) {
                            Accessor accessor;
                            this.accessors[i] = accessor = oldaccs[i - 1];
                            if (!accessor.isColumnNumberAware) continue;
                            accessor.updateColumnNumber(i);
                        }
                    }
                    this.allocateRowidAccessor();
                    ++this.numberOfDefinePositions;
                }
                this.doExecuteWithTimeout();
                this.currentResultSet = this.createResultSet();
                this.realRsetType = this.userRsetType;
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 30006 || e.getMessage() != null && e.getMessage().contains("ORA-30006")) {
                    throw e;
                }
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "doScrollExecuteCommon", "Downgrading ResultSet type/concurrence due to {0}. ", (String)null, e, (Object)e.getMessage());
                this.realRsetType = this.userRsetType.downgrade();
                this.isRowidPrepended = this.realRsetType.isIdentifierRequired();
                this.sqlObject.setIncludeRowid(this.isRowidPrepended);
                this.needToParse = true;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "doScrollExecuteCommon", "Trying type={0}. ", (String)null, (Throwable)null, (Object)this.realRsetType);
                this.prepareForNewResults(true, false, true);
                if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = true;
                    --this.numberOfDefinePositions;
                    System.arraycopy(this.accessors, 1, this.accessors, 0, this.numberOfDefinePositions);
                    this.accessors[this.numberOfDefinePositions] = null;
                    for (int i = 0; i < this.numberOfDefinePositions; ++i) {
                        Accessor accessor = this.accessors[i];
                        if (!accessor.isColumnNumberAware) continue;
                        accessor.updateColumnNumber(i);
                    }
                }
                this.moveAllTempLobsToFree();
                this.doExecuteWithTimeout();
                this.currentResultSet = this.createResultSet();
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 91, e.getMessage());
            }
        }
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
    }

    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        this.doScrollExecuteCommon();
        return this.currentResultSet;
    }

    void processDmlReturningBind() throws SQLException {
        this.returnParamsFetched = false;
        if (this.autoKeyInfo != null) {
            this.numReturnParams = this.autoKeyInfo.returnParameterCount();
        } else {
            int count = 0;
            for (int i = 0; i < this.numberOfBindPositions; ++i) {
                if (this.accessors[i] == null) continue;
                ++count;
            }
            if (this.numReturnParams <= 0) {
                this.numReturnParams = this.sqlObject.getReturnParameterCount();
            }
            if (this.numReturnParams != count) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 173).fillInStackTrace();
            }
        }
        this.allocateReturnParamMeta();
        this.returnParamMeta[0] = this.numReturnParams;
    }

    private void allocateReturnParamMeta() {
        if (this.returnParamMeta == null) {
            this.returnParamMeta = new int[3 + this.numberOfBindPositions * 4];
        }
    }

    void allocateDmlReturnStorage() {
    }

    void fetchDmlReturnParams() throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("fetchDmlReturnParams").fillInStackTrace();
    }

    abstract boolean areOutBindsStoredInBindData();

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINE)
    void registerReturnParameterInternal(int n, int n2, int n3, int n4, short s, String string) throws SQLException {
        try {
            void maxSize;
            void index;
            void internalType;
            String typeName;
            int form;
            void externalType;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.jdbc.driver.OracleStatement", "registerReturnParameterInternal", "entering args ({0}, {1}, {2}, {3}, {4}, {5})", (String)null, null, new Object[]{n, n2, n3, n4, s, string});
            this.isDmlReturning = true;
            if (this.accessors == null) {
                this.accessors = new Accessor[this.numberOfBindPositions];
            }
            this.allocateReturnParamMeta();
            switch (externalType) {
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    form = 2;
                    break;
                }
                case 2009: {
                    typeName = "SYS.XMLTYPE";
                    break;
                }
            }
            Accessor accessor = this.allocateAccessor((int)internalType, (int)externalType, (int)(index + true), (int)maxSize, (short)form, typeName, true);
            accessor.isDMLReturnedParam = true;
            accessor.setCapacity(this.currentCapacity);
            this.accessors[index] = accessor;
            boolean isCharType = accessor.charLength > 0;
            this.returnParamMeta[3 + index * 4 + 0] = accessor.defineType;
            this.returnParamMeta[3 + index * 4 + 1] = isCharType ? 1 : 0;
            this.returnParamMeta[3 + index * 4 + 2] = isCharType ? accessor.charLength : accessor.byteLength;
            this.returnParamMeta[3 + index * 4 + 3] = form;
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.jdbc.driver.OracleStatement", "registerReturnParameterInternal", "returning void", (String)null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINE, SecurityLabel.INTERNAL, "oracle.jdbc.driver.OracleStatement", "registerReturnParameterInternal", "throwing", (String)null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public int creationState() {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int n = this.creationState;
            return n;
        }
    }

    public boolean isColumnSetNull(int index) {
        return this.columnSetNull;
    }

    @Override
    public boolean isNCHAR(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int index;
            if (!this.described) {
                this.describe();
            }
            if ((index = columnIndex - 1) < 0 || index >= this.numberOfDefinePositions) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            boolean bl = this.accessors[index].formOfUse == 2;
            return bl;
        }
    }

    void addChild(OracleStatement child) {
        child.nextChild = this.children;
        this.children = child;
        child.parent = this;
    }

    void addImplicitResultSetStmt(OracleStatement child) {
        this.implicitResultSetStatements.add(child);
    }

    void removeChild(OracleStatement child) {
        if (child == this.children) {
            this.children = child.nextChild;
        } else {
            OracleStatement c = this.children;
            while (c.nextChild != child) {
                c = c.nextChild;
            }
            c.nextChild = child.nextChild;
        }
        child.parent = null;
        child.nextChild = null;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        OracleStatement stmt;
        this.ensureOpen();
        switch (current) {
            case 1: {
                if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                this.currentResultSet.close();
                break;
            }
            case 2: {
                if (this.currentResultSet == null || this.currentResultSet.isClosed()) break;
                if (this.openImplicitResultSets == null) {
                    this.openImplicitResultSets = new ArrayDeque(this.implicitResultSetStatements == null ? 1 : this.implicitResultSetStatements.size());
                }
                this.openImplicitResultSets.add(this.currentResultSet);
                this.currentResultSet = null;
                break;
            }
            case 3: {
                while (this.openImplicitResultSets != null && this.openImplicitResultSets.size() != 0) {
                    OracleResultSet rs = this.openImplicitResultSets.remove();
                    rs.close();
                }
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getMoreResults").fillInStackTrace();
            }
        }
        if (this.implicitResultSetIterator != null && this.implicitResultSetIterator.hasNext() && (stmt = this.implicitResultSetIterator.next()) != null) {
            this.currentResultSet = stmt.createResultSet();
            return true;
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.autoKeyInfo == null) {
                ArrayDataResultSet emptyRS;
                ArrayDataResultSet arrayDataResultSet = emptyRS = new ArrayDataResultSet(this.connection, null, null);
                return arrayDataResultSet;
            }
            if (this.accessors == null || this.numReturnParams == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 144).fillInStackTrace();
            }
            if (this.currentResultSet == null) {
                this.isAllFetched = true;
                this.currentResultSet = new OracleReturnResultSet(this.connection, this);
                this.computeOffsetOfFirstUserColumn();
                this.computeNumberOfUserColumns();
            }
            OracleResultSet oracleResultSet = this.currentResultSet;
            return oracleResultSet;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (int)this.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, autoGeneratedKeys);
        if (autoKeyInfo == null) {
            return this.executeLargeUpdate(sql);
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            long l;
            this.beginCurrentSql(sql);
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate(String, int)", null, null, null);
            try {
                this.cleanUpBeforeExecute();
                this.setAutoKeyInfo(autoKeyInfo);
                String newSql = autoKeyInfo.getNewSql();
                l = this.executeUpdateInternal(newSql);
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return l;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate", null, null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, columnIndexes);
        if (autoKeyInfo == null) {
            return this.executeLargeUpdate(sql);
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            long l;
            this.beginCurrentSql(sql);
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate(String, int[])", null, null, null);
            try {
                this.cleanUpBeforeExecute();
                this.setAutoKeyInfo(autoKeyInfo);
                String newSql = autoKeyInfo.getNewSql();
                l = this.executeUpdateInternal(newSql);
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return l;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate", null, null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, columnNames);
        if (autoKeyInfo == null) {
            return this.executeLargeUpdate(sql);
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            long l;
            this.beginCurrentSql(sql);
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate(String, String[])", null, null, null);
            try {
                this.cleanUpBeforeExecute();
                this.setAutoKeyInfo(autoKeyInfo);
                String newSql = autoKeyInfo.getNewSql();
                l = this.executeUpdateInternal(newSql);
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return l;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeLargeUpdate", null, null, e, new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, autoGeneratedKeys);
        if (autoKeyInfo == null) {
            return this.execute(sql);
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl;
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute(String, int)", null, null, null);
            this.beginCurrentSql(sql);
            try {
                this.cleanUpBeforeExecute();
                this.setAutoKeyInfo(autoKeyInfo);
                String newSql = autoKeyInfo.getNewSql();
                bl = this.executeInternal(newSql);
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return bl;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute", null, null, e, new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, columnIndexes);
        if (autoKeyInfo == null) {
            return this.execute(sql);
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl;
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute(String, int[])", null, null, null);
            this.beginCurrentSql(sql);
            try {
                this.cleanUpBeforeExecute();
                this.setAutoKeyInfo(autoKeyInfo);
                String newSql = autoKeyInfo.getNewSql();
                bl = this.executeInternal(newSql);
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return bl;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute", null, null, e, new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        AutoKeyInfo autoKeyInfo = AutoKeyInfo.create(sql, columnNames);
        if (autoKeyInfo == null) {
            return this.execute(sql);
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl;
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute(String, String[])", null, null, null);
            this.beginCurrentSql(sql);
            try {
                this.cleanUpBeforeExecute();
                this.setAutoKeyInfo(autoKeyInfo);
                String newSql = autoKeyInfo.getNewSql();
                bl = this.executeInternal(newSql);
            }
            catch (Throwable throwable) {
                this.endCurrentSql();
                throw throwable;
            }
            this.endCurrentSql();
            return bl;
        }
        catch (SQLException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute", null, null, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureOpen();
        return 1;
    }

    @Override
    public int getcacheState() {
        return this.cacheState;
    }

    @Override
    public int getstatementType() {
        return this.statementType;
    }

    @Override
    public boolean getserverCursor() {
        return this.serverCursor;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = 0;
    }

    private void registerGeneratedKeysParameters() throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
        }
        this.initializeIndicatorSubRange();
        int preambleSize = this.bindIndicatorSubRange + 5 + this.numberOfBindPositions * 10;
        int indicatorSize = preambleSize + 2 * this.numberOfBindPositions;
        this.bindIndicators = new short[indicatorSize];
        int metadataOffset = this.bindIndicatorSubRange;
        this.bindIndicators[metadataOffset + 0] = (short)this.numberOfBindPositions;
        this.bindIndicators[metadataOffset + 1] = 0;
        this.bindIndicators[metadataOffset + 2] = 1;
        this.bindIndicators[metadataOffset + 3] = 0;
        this.bindIndicators[metadataOffset + 4] = 1;
        metadataOffset += 5;
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            this.registerGeneratedKeysParameter(i);
            this.bindIndicators[metadataOffset + 0] = 994;
            if (this.autoKeyInfo.isNChar(i)) {
                this.bindIndicators[metadataOffset + 9] = 2;
            }
            metadataOffset += 10;
        }
    }

    protected final void registerGeneratedKeysParameter(int returnParameterIndex) throws SQLException {
        short form = this.autoKeyInfo.isNChar(returnParameterIndex) ? (short)2 : (this.connection.defaultnchar ? (short)2 : 1);
        int internalTypeCode = this.autoKeyInfo.getInternalTypeCode(returnParameterIndex);
        this.checkTypeForAutoKey(internalTypeCode);
        String typeName = null;
        if (internalTypeCode == 111) {
            typeName = this.autoKeyInfo.getTypeName(returnParameterIndex);
        }
        int outParameterIndex = this.numberOfBindPositions - this.autoKeyInfo.returnParameterCount() + returnParameterIndex;
        this.registerReturnParameterInternal(outParameterIndex, internalTypeCode, internalTypeCode, -1, form, typeName);
    }

    private void cleanUpBeforeExecute() throws SQLException {
        this.awaitResultSetPublishing();
        if (this.connection.isDRCPEnabled()) {
            this.prepareForExecuteWithDRCP();
        }
        if (this.currentResultSet != null && this.isCloseOnCompletion) {
            this.currentResultSet.close();
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        this.autoKeyInfo = null;
        this.numberOfBindPositions = 0;
        this.bindIndicators = null;
        this.returnParamMeta = null;
        if (this.executeDoneForDefines) {
            this.doClearDefines();
        } else {
            this.executeDoneForDefines = true;
        }
        this.batchWasExecuted = false;
    }

    final void checkTypeForAutoKey(int type) throws SQLException {
        if (type == 109) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 5).fillInStackTrace();
        }
    }

    void moveAllTempLobsToFree() {
        if (this.oldTempClobsToFree != null) {
            if (this.tempStmtClobsToFree == null) {
                this.tempStmtClobsToFree = this.oldTempClobsToFree;
            } else {
                this.tempStmtClobsToFree.addAll(this.oldTempClobsToFree);
            }
            this.oldTempClobsToFree = null;
        }
        if (this.oldTempBlobsToFree != null) {
            if (this.tempStmtBlobsToFree == null) {
                this.tempStmtBlobsToFree = this.oldTempBlobsToFree;
            } else {
                this.tempStmtBlobsToFree.addAll(this.oldTempBlobsToFree);
            }
            this.oldTempBlobsToFree = null;
        }
    }

    void moveTempLobsToFree(CLOB tclob) {
        int index;
        if (this.oldTempClobsToFree != null && (index = this.oldTempClobsToFree.indexOf(tclob)) != -1) {
            this.addToTempLobsToFree(tclob);
            this.oldTempClobsToFree.remove(index);
        }
    }

    void moveTempLobsToFree(BLOB tblob) {
        int index;
        if (this.oldTempBlobsToFree != null && (index = this.oldTempBlobsToFree.indexOf(tblob)) != -1) {
            this.addToTempLobsToFree(tblob);
            this.oldTempBlobsToFree.remove(index);
        }
    }

    void addToTempLobsToFree(CLOB tclob) {
        try {
            if (this.currentResultSet != null && this.currentResultSet.getType() == 1003 && !this.sqlKind.isPlsqlOrCall()) {
                this.tempRowClobsToFree.add(tclob);
            } else {
                if (this.tempStmtClobsToFree == null) {
                    this.tempStmtClobsToFree = new ArrayList();
                }
                this.tempStmtClobsToFree.add(tclob);
            }
        }
        catch (SQLException ea) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "addToTempLobsToFree", "exception occured while adding temp Clob to free list={0}. ", (String)null, (Throwable)null, (Object)ea.getMessage());
        }
    }

    void addToTempLobsToFree(BLOB tblob) {
        try {
            if (this.currentResultSet != null && this.currentResultSet.getType() == 1003 && !this.sqlKind.isPlsqlOrCall()) {
                this.tempRowBlobsToFree.add(tblob);
            } else {
                if (this.tempStmtBlobsToFree == null) {
                    this.tempStmtBlobsToFree = new ArrayList();
                }
                this.tempStmtBlobsToFree.add(tblob);
            }
        }
        catch (SQLException ea) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "addToTempLobsToFree", "exception occured while adding temp Blob to free list={0}. ", (String)null, (Throwable)null, (Object)ea.getMessage());
        }
    }

    void cleanAllTempLobs() {
        this.cleanTempClobs(this.tempStmtClobsToFree);
        this.tempStmtClobsToFree = null;
        this.cleanTempBlobs(this.tempStmtBlobsToFree);
        this.tempStmtBlobsToFree = null;
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.oldTempClobsToFree = null;
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempBlobsToFree = null;
        this.cleanAllRowLobs();
    }

    void cleanAllRowLobs() {
        if (!this.tempRowClobsToFree.isEmpty()) {
            this.cleanTempClobs(this.tempRowClobsToFree);
            this.tempRowClobsToFree.clear();
        }
        if (!this.tempRowBlobsToFree.isEmpty()) {
            this.cleanTempBlobs(this.tempRowBlobsToFree);
            this.tempRowBlobsToFree.clear();
        }
    }

    void cleanOldTempLobs() {
        this.cleanTempClobs(this.oldTempClobsToFree);
        this.cleanTempBlobs(this.oldTempBlobsToFree);
        this.oldTempClobsToFree = this.tempStmtClobsToFree;
        this.tempStmtClobsToFree = null;
        this.oldTempBlobsToFree = this.tempStmtBlobsToFree;
        this.tempStmtBlobsToFree = null;
    }

    void cleanTempClobs(ArrayList<CLOB> x) {
        if (x != null) {
            Iterator<CLOB> iter = x.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().freeLOB();
                }
                catch (SQLException e) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanTempClobs", "exception occured while freeing temp Clob={0}. ", (String)null, (Throwable)null, (Object)e.getMessage());
                }
            }
        }
    }

    void cleanTempBlobs(ArrayList<BLOB> x) {
        if (x != null) {
            Iterator<BLOB> iter = x.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().freeLOB();
                }
                catch (SQLException e) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanTempBlobs", "exception occured while freeing temp Blob={0}. ", (String)null, (Throwable)null, (Object)e.getMessage());
                }
            }
        }
    }

    TimeZone getDefaultTimeZone() throws SQLException {
        return this.getDefaultTimeZone(false);
    }

    TimeZone getDefaultTimeZone(boolean processDST) throws SQLException {
        if (this.defaultTimeZone == null) {
            try {
                this.defaultTimeZone = this.connection.getDefaultTimeZone();
            }
            catch (SQLException ea) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "getDefaultTimeZone", " error retriving default timezone using connection={0}. ", (String)null, (Throwable)null, (Object)ea.getMessage());
            }
            if (this.defaultTimeZone == null) {
                this.defaultTimeZone = TimeZone.getDefault();
            }
        }
        return this.defaultTimeZone;
    }

    @Override
    public void setDatabaseChangeRegistration(DatabaseChangeRegistration _registration) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.registration = (NTFDCNRegistration)_registration;
            if (this.registration != null) {
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "setDatabaseChangeRegistration", "dcnRegistrationState={0}. ", (String)null, null, (Object)this.registration.getState());
            } else {
                this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "setDatabaseChangeRegistration", "registration is null. ", null, null);
            }
        }
    }

    @Override
    public String[] getRegisteredTableNames() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String[] stringArray = this.dcnTableName;
            return stringArray;
        }
    }

    @Override
    public long getRegisteredQueryId() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            long l = this.dcnQueryId;
            return l;
        }
    }

    @Override
    public String getSqlId() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.needRowId()) {
                this.sqlObject.setIncludeRowid(true);
            }
            String string = this.sqlObject.getSqlId(this.connection.processEscapes, this.connection.convertNcharLiterals);
            return string;
        }
    }

    Calendar getDefaultCalendar() throws SQLException {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance(this.getDefaultTimeZone(), Locale.US);
        }
        return this.defaultCalendar;
    }

    void releaseBuffers() {
        this.freeRowData();
        if (this.bindData != null && this.bindData != this.rowData) {
            this.bindData.free();
        }
    }

    protected void freeRowData() {
        this.freeRowData(true);
    }

    protected void freeRowData(boolean returnBlocksToSource) {
        if (this.rowData != null) {
            this.prepareForNewRowData();
            this.rowData.free(returnBlocksToSource);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        return this.cacheState != 3;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        this.cacheState = poolable ? 1 : 3;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    <T> T getObject(long rowIndex, int columnIndex, Class<T> type) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getObject(this.physicalRowIndex(rowIndex), type);
    }

    int getBytes(long rowIndex, int columnIndex, byte[] buffer, int offset) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.lastIndex = columnIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(columnIndex);
            }
            int n = this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBytes(this.physicalRowIndex(rowIndex), buffer, offset);
            return n;
        }
    }

    RowId getPrependedRowId(long rowIndex) throws SQLException {
        assert (this.isRowidPrepended) : "no rowid";
        return this.accessors[0].getROWID(this.physicalRowIndex(rowIndex));
    }

    OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex - 1].getAuthorizationIndicator(this.physicalRowIndex(rowIndex));
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    Calendar getGMTCalendar() {
        if (this.gmtCalendar == null) {
            this.gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        }
        return this.gmtCalendar;
    }

    void extractNioDefineBuffers(int value) throws SQLException {
    }

    void processLobPrefetchMetaData(Object[] lobPrefetchMetaData) throws SQLException {
    }

    void internalClose() throws SQLException {
        this.closed = true;
        if (this.currentResultSet != null) {
            this.currentResultSet.closed = true;
        }
        this.cleanupDefines();
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        this.outBindAccessors = null;
        this.parameterStream = null;
        this.userStream = null;
        this.ibtBindBytes = null;
        this.ibtBindChars = null;
        this.ibtBindIndicators = null;
        this.lobPrefetchMetaData = null;
        this.tmpByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        if (this.wrapper != null) {
            this.wrapper.endAsyncExecution();
            this.wrapper.close();
        }
    }

    void calculateCheckSum() throws SQLException {
        if (!this.connection.checksumMode.needToCalculateFetchChecksum()) {
            return;
        }
        this.localCheckSum = this.checkSum;
        if (this.accessors != null && !this.isDmlReturning) {
            this.accessorChecksum(this.accessors);
        }
        if (this.outBindAccessors != null) {
            this.accessorChecksum(this.outBindAccessors);
        }
        if (this.accessors != null && this.returnParamsFetched && this.isDmlReturning) {
            this.accessorChecksum(this.accessors);
        }
        this.checkSum = this.localCheckSum = CRC64.updateChecksum(this.localCheckSum, this.validRows);
        this.localCheckSum = 0L;
    }

    void accessorChecksum(Accessor[] _accessors) throws SQLException {
        int count = 0;
        boolean areAllColumnsLobs = false;
        block4: for (Accessor a : _accessors) {
            if (a == null) continue;
            switch (a.internalType) {
                case 112: 
                case 113: 
                case 114: 
                case 119: 
                case 127: {
                    if (count != 0) continue block4;
                    areAllColumnsLobs = true;
                    continue block4;
                }
                case 8: 
                case 24: {
                    areAllColumnsLobs = false;
                    break block4;
                }
                default: {
                    areAllColumnsLobs = false;
                    ++count;
                    int row = 0;
                    while ((long)row < this.validRows) {
                        this.localCheckSum = a.updateChecksum(this.localCheckSum, row);
                        ++row;
                    }
                    break block0;
                }
            }
        }
        if (areAllColumnsLobs) {
            this.checkSumComputationFailure = true;
        }
    }

    @Override
    public long getChecksum() throws SQLException {
        if (this.checkSumComputationFailure) {
            throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getChecksum").fillInStackTrace();
        }
        return this.checkSum;
    }

    @Override
    public long getSSSCursorChecksum() throws SQLException {
        return this.sssCursorChecksum;
    }

    @Override
    public void markSSSCursor() throws SQLException {
        this.isSSSCursor = true;
    }

    public boolean checkSSSCursor() throws SQLException {
        return this.isSSSCursor;
    }

    @Override
    public void setSSSCursorPosition(long pos) throws SQLException {
        this.sssCursorPosition = pos;
    }

    @Override
    public boolean allRowsFetched() throws SQLException {
        return this.isAllFetched;
    }

    @Override
    public void registerBindChecksumListener(OracleStatement.BindChecksumListener value) throws SQLException {
        this.bindChecksumListener = value;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.isCloseOnCompletion = true;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.isCloseOnCompletion;
    }

    boolean closeByDependent() throws SQLException {
        if (this.isCloseOnCompletion && (this.currentResultSet == null || this.currentResultSet.isComplete())) {
            if (this.parent == null || !this.parent.closeByDependent()) {
                this.closeOrCache(null);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return this.connection.isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String string = this.connection.enquoteLiteral(val);
            return string;
        }
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        return this.connection.enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public final long getQueryId() throws SQLException {
        return this.queryId;
    }

    @Override
    public final byte[] getCompileKey() throws SQLException {
        return this.querycacheCompileKey;
    }

    final void setQueryCompileKey(byte[] dcbqcky) {
        if (this.connection.isResultSetCacheEnabled && dcbqcky != null) {
            this.querycacheCompileKey = dcbqcky;
        }
    }

    final void setQueryId(long queryId) {
        this.queryId = queryId;
    }

    byte[] getRuntimeKey() throws SQLException {
        return null;
    }

    void clearCursorId() {
        this.cursorId = 0;
        this.needToParse = true;
    }

    abstract long allocateRowDataSpace(int var1);

    @Override
    public void setShardingKeyRpnTokens(byte[] shardingKeyRpnTokens) throws SQLException {
        this.shardingKeyRpnTokens = shardingKeyRpnTokens;
    }

    @Override
    public byte[] getShardingKeyRpnTokens() throws SQLException {
        return this.shardingKeyRpnTokens;
    }

    protected final void awaitResultSetPublishing() throws SQLException {
        if (this.currentResultSet == null) {
            return;
        }
        this.currentResultSet.awaitPublishing();
    }

    final boolean isSqlRewritten() {
        return this.autoKeyInfo != null || this.sqlObject.includeRowid;
    }

    private long computeAverageRowSize() {
        long curRowDataOffSet = this.rowData.length();
        if (curRowDataOffSet == 0L || this.storedRowCount == 0) {
            return 0L;
        }
        return curRowDataOffSet / (long)this.storedRowCount;
    }

    private int computeQueryColumnCount() {
        if (this.accessors != null) {
            return this.numberOfDefinePositions - (1 + this.offsetOfFirstUserColumn);
        }
        return 0;
    }

    void tuneRowPrefetch() throws SQLException {
        if (this.rowPrefetchTuningDone) {
            return;
        }
        long averageRowSize = this.computeAverageRowSize();
        if (averageRowSize == 0L) {
            return;
        }
        int columnCount = this.computeQueryColumnCount();
        if (columnCount == 0) {
            this.rowPrefetchTuningDone = true;
            return;
        }
        long heapSizePerQuery = Math.min(this.connection.fetchSizeTuning, 62) * 32768;
        int estimate1 = (int)(heapSizePerQuery / (averageRowSize + (long)(columnCount * 16)));
        int tunedFetchSize = Math.min(Math.max(estimate1, 4), 250);
        this.tunedFetchSizeList.add(tunedFetchSize);
        if (this.tunedFetchSizeList.size() < 3) {
            return;
        }
        tunedFetchSize = this.tunedFetchSizeList.stream().mapToInt(i -> i).sum() / this.tunedFetchSizeList.size();
        this.tunedFetchSizeList.clear();
        if (tunedFetchSize == this.rowPrefetch) {
            this.rowPrefetchTuningDone = true;
            return;
        }
        this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "tuneRowPrefetch", "current rowPrefetch={0}, tunedFetchSize={1}. ", null, null, this.rowPrefetch, tunedFetchSize);
        this.setPrefetchInternal(tunedFetchSize, false, false);
        this.increaseCapacity(this.rowPrefetch);
        this.rowPrefetchTuningDone = true;
    }

    @Override
    public final void continueOnError(ErrorSet errorSet) throws SQLException {
        this.ensureOpen();
        if (!this.isFetchAsyncSupported()) {
            throw new UnsupportedOperationException("Asynchronous execution is not supported by jdbc:oracle:" + this.connection.getProtocolType());
        }
        this.setContinueOnErrorSet(Pipeline.requireSupportedErrorSet(errorSet));
    }

    final void setContinueOnErrorSet(ErrorSet errorSet) {
        this.continueOnErrorSet = errorSet;
    }

    final ErrorSet getContinueOnErrorSet() {
        return this.continueOnErrorSet != null ? this.continueOnErrorSet : this.connection.getContinueOnErrorSetInternal();
    }

    protected final void requireOpenStatement() throws SQLException {
        if (this.isClosed()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    static void closeAll(Statement ... statements) throws SQLException {
        SQLException closeException = null;
        for (Statement statement : statements) {
            if (statement == null || statement.isClosed()) continue;
            try {
                statement.close();
            }
            catch (SQLException sqlException) {
                if (closeException == null) {
                    closeException = sqlException;
                    continue;
                }
                closeException.addSuppressed(sqlException);
            }
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    private void closeImplicitResults() throws SQLException {
        if (this.implicitResultSetStatements != null) {
            for (OracleStatement statement : this.implicitResultSetStatements) {
                statement.close();
            }
            this.implicitResultSetStatements = null;
            this.implicitResultSetIterator = null;
        }
        if (this.openImplicitResultSets != null) {
            for (OracleResultSet resultSet : this.openImplicitResultSets) {
                resultSet.close();
            }
            this.openImplicitResultSets = null;
        }
    }

    @Override
    public void setLongPrefetch(boolean isEnabled) {
        this.isFetchStreams = isEnabled;
    }

    private void setAutoKeyInfo(AutoKeyInfo autoKeyInfo) throws SQLException {
        this.autoKeyInfo = autoKeyInfo;
        autoKeyInfo.initialize(this.connection);
        this.numberOfBindPositions = autoKeyInfo.returnParameterCount();
        this.registerGeneratedKeysParameters();
        this.processDmlReturningBind();
    }

    final AutoKeyInfo getAutoKeyInfo() {
        return this.autoKeyInfo;
    }

    @Override
    public void setRowDataLimit(long numBytes) throws SQLException {
        this.rowDataMaxBytesSize = numBytes;
    }

    protected void convertBindRow(int index) throws SQLException {
    }

    static enum QueryCacheState {
        UNKNOWN,
        CACHEABLE,
        UNCACHEABLE;

    }

    static enum FetchMode {
        OVERWRITE,
        APPEND;

    }
}

