-- 
-- upgrade Oracle RSGBBGT datamodel van 1.6.0 naar 1.6.1 
--

-- herstel de inhoud van de GT_PK_METADATA en GEOMETRY_COLUMNS tabellen
--
-- LET OP: als de naam van het RSGBBGT schema anders is dan 'BRMO_RSGBBGT' dan moeten
--         onderstaande inserts aangepast worden
-- LET OP: Als er geen BGTlight is verwerkt met versie 1.6.0 dan zullen de meeste van onderstaande insert statements
--         een "ORA-00001: unique constraint violation" opleveren omdat de inhoud van de tabellen dan niet gewist is
-- zie #543
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'BAK', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'BEGROEID_TERREINDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'BORD', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'FUNCTIONEELGEBIED', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'GEBOUW_INSTALLATIE', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'INSTALLATIE', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'KAST', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'MAST', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'PAAL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'PUT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'SENSOR', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OPENBARERUIMTELABEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OVERIGE_SCHEIDING', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'SCHEIDING', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OVERIG_BOUWWERK', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'ONGECLASSIFICEERDOBJECT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WATERDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'KUNSTWERKDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'ONBEGROEID_TERREINDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OVERBRUGGINGSDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'STRAATMEUBILAIR', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'ONDERSTEUNEND_WATERDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'ONDERSTEUNEND_WEGDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'SPOOR', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WEGINRICHTINGSELEMENT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'VEGETATIEOBJECT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'TUNNELDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WATERINRICHTINGSELEMENT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WEGDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'PAND', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'BUURT', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'WIJK', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'OPENBARERUIMTE', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BAK', 'GEOM2D', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BAK', 'LOD0GEOM', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BEGROEID_TERREINDEEL', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BEGROEID_TERREINDEEL', 'LOD0GEOM', 2, 28992,'MULTIPOLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BEGROEID_TERREINDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BORD', 'GEOM2D', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BORD', 'LOD0GEOM', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','FUNCTIONEELGEBIED', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','GEBOUW_INSTALLATIE', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','GEBOUW_INSTALLATIE', 'LOD0GEOM', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','INSTALLATIE', 'GEOM2D', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','INSTALLATIE', 'LOD0GEOM', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','KAST', 'GEOM2D', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','KAST', 'LOD0GEOM', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','MAST', 'GEOM2D', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','MAST', 'LOD0GEOM', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAAL', 'GEOM2D', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAAL', 'LOD0GEOM', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PUT', 'GEOM2D', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PUT', 'LOD0GEOM', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SENSOR', 'GEOM2D', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SENSOR', 'LOD0GEOM', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OPENBARERUIMTELABEL', 'GEOM2D', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OPENBARERUIMTELABEL', 'OPRNM_POS_2_PUNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OPENBARERUIMTELABEL', 'OPRNM_POS_3_PUNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OVERIGE_SCHEIDING', 'GEOM2D', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SCHEIDING', 'GEOM2D', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OVERIG_BOUWWERK', 'GEOM2D', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONGECLASSIFICEERDOBJECT', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WATERDEEL', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','KUNSTWERKDEEL', 'GEOM2D', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONBEGROEID_TERREINDEEL', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONBEGROEID_TERREINDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OVERBRUGGINGSDEEL', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OVERBRUGGINGSDEEL', 'LOD0GEOM', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','STRAATMEUBILAIR', 'GEOM2D', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','STRAATMEUBILAIR', 'LOD0GEOM', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONDERSTEUNEND_WATERDEEL', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONDERSTEUNEND_WEGDEEL', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONDERSTEUNEND_WEGDEEL', 'LOD0GEOM', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','ONDERSTEUNEND_WEGDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SPOOR', 'GEOM2D', 2, 28992,'COLLECTION');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','SPOOR', 'LOD0GEOM', 2, 28992,'COLLECTION');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGINRICHTINGSELEMENT', 'GEOM2D', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGINRICHTINGSELEMENT', 'LOD0GEOM', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','VEGETATIEOBJECT', 'GEOM2D', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','VEGETATIEOBJECT', 'LOD0GEOM', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','TUNNELDEEL', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','TUNNELDEEL', 'LOD0GEOM', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WATERINRICHTINGSELEMENT', 'GEOM2D', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WATERINRICHTINGSELEMENT', 'LOD0GEOM', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGDEEL', 'GEOM2D', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGDEEL', 'LOD0GEOM', 2, 28992,'POLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WEGDEEL', 'KRUINLIJN', 2, 28992,'GEOMETRY');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'GEOM2D', 2, 28992,'MULTIPOLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_1_POS_1_PNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_1_POS_2_PNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_1_POS_3_PNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_2_POS_1_PNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_2_POS_2_PNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_2_POS_3_PNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_3_POS_1_PNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_3_POS_2_PNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','PAND', 'NRAR_3_POS_3_PNT', 2, 28992,'POINT');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','BUURT', 'GEOM2D', 2, 28992,'MULTIPOLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','WIJK', 'GEOM2D', 2, 28992,'MULTIPOLYGON');
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','OPENBARERUIMTE', 'GEOM2D', 2, 28992,'MULTIPOLYGON');

-- herstel brmo versie metadata, zie: #543
INSERT INTO brmo_metadata SELECT 'brmoversie', '1.6.0' FROM dual
            WHERE NOT EXISTS (SELECT naam FROM brmo_metadata WHERE naam = 'brmoversie');
COMMIT;




-- voeg tabel voor klasse Stadsdeel toe
-- #546
CREATE TABLE stadsdeel (
        identif VARCHAR2(255) NOT NULL,
        dat_beg_geldh date,
        tijdstip_registratie timestamp,
        relve_hoogteligging NUMBER(10),
        bgt_status VARCHAR2(255),
        plus_status VARCHAR2(255),
        NAAM VARCHAR2(255),
        GEOM2D MDSYS.SDO_GEOMETRY,
        PRIMARY KEY (identif)
);

INSERT INTO GT_PK_METADATA VALUES ('BRMO_RSGBBGT', 'STADSDEEL', 'IDENTIF', NULL, 'assigned', NULL);
INSERT INTO USER_SDO_GEOM_METADATA VALUES('STADSDEEL', 'GEOM2D',
        MDSYS.SDO_DIM_ARRAY(
            MDSYS.SDO_DIM_ELEMENT('X', 12000, 280000, .1),
            MDSYS.SDO_DIM_ELEMENT('Y', 304000, 620000, .1)
        ), 28992);
INSERT INTO GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, TYPE)
            VALUES ('BRMO_RSGBBGT','STADSDEEL', 'GEOM2D', 2, 28992,'MULTIPOLYGON');
CREATE INDEX STADSDEEL_GEOM2D_IDX ON STADSDEEL (GEOM2D)
        INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=2 LAYER_GTYPE=MULTIPOLYGON');

-- onderstaande dienen als laatste stappen van een upgrade uitgevoerd
INSERT INTO brmo_metadata (naam,waarde) SELECT 'upgrade_1.6.0_naar_1.6.1','vorige versie was ' || waarde FROM brmo_metadata WHERE naam='brmoversie';
-- versienummer update
UPDATE brmo_metadata SET waarde='1.6.1' WHERE naam='brmoversie';
