/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.util;

import java.io.IOException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.util.BrmoException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigUtil
implements Servlet {
    private static final Log log = LogFactory.getLog(ConfigUtil.class);
    private static final String JNDI_NAME = "java:comp/env";
    private static final String JDBC_NAME_STAGING = "jdbc/brmo/staging";
    private static final String JDBC_NAME_RSGB = "jdbc/brmo/rsgb";
    private static final String JDBC_NAME_RSGBBRK = "jdbc/brmo/rsgbbrk";
    private static final String JDBC_NAME_RSGB_BAG = "jdbc/brmo/rsgbbag";
    private static final String JDBC_NAME_RSGB_BGT = "jdbc/brmo/rsgbbgt";
    private static DataSource datasourceStaging = null;
    private static DataSource datasourceRsgb = null;
    private static DataSource datasourceRsgbBrk = null;
    private static DataSource datasourceRsgbBag = null;
    private static DataSource datasourceRsgbBgt = null;
    public static Long MAX_UPLOAD_SIZE;
    public static String TEMP_FOLDER;

    public void init(ServletConfig config) throws ServletException {
        String tempSize = config.getInitParameter("max_upload_size");
        MAX_UPLOAD_SIZE = tempSize != null && !tempSize.isEmpty() ? Long.valueOf(Long.parseLong(tempSize) * 1024L * 1024L) : Long.valueOf(10485760000L);
        String tempFolder = config.getInitParameter("temp_folder");
        TEMP_FOLDER = tempFolder != null && !tempFolder.isEmpty() ? tempFolder : System.getProperty("java.io.tmpdir");
    }

    public static DataSource getDataSourceStaging() throws BrmoException {
        try {
            if (datasourceStaging == null) {
                InitialContext ic = new InitialContext();
                Context xmlContext = (Context)ic.lookup(JNDI_NAME);
                datasourceStaging = (DataSource)xmlContext.lookup(JDBC_NAME_STAGING);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Fout verbinden naar staging db. ", (Throwable)ex);
            throw new BrmoException((Throwable)ex);
        }
        return datasourceStaging;
    }

    public static DataSource getDataSourceRsgb() throws BrmoException {
        try {
            if (datasourceRsgb == null) {
                InitialContext ic = new InitialContext();
                Context xmlContext = (Context)ic.lookup(JNDI_NAME);
                datasourceRsgb = (DataSource)xmlContext.lookup(JDBC_NAME_RSGB);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Fout verbinden naar rsgb db. ", (Throwable)ex);
            throw new BrmoException((Throwable)ex);
        }
        return datasourceRsgb;
    }

    public static DataSource getDataSourceRsgbBrk() throws BrmoException {
        try {
            if (datasourceRsgbBrk == null) {
                InitialContext ic = new InitialContext();
                Context xmlContext = (Context)ic.lookup(JNDI_NAME);
                datasourceRsgbBrk = (DataSource)xmlContext.lookup(JDBC_NAME_RSGBBRK);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Fout verbinden naar rsgb db. ", (Throwable)ex);
            throw new BrmoException((Throwable)ex);
        }
        return datasourceRsgbBrk;
    }

    public static DataSource getDataSourceRsgbBag() throws BrmoException {
        return ConfigUtil.getDataSourceRsgbBag(true);
    }

    public static DataSource getDataSourceRsgbBag(boolean logErrors) throws BrmoException {
        try {
            if (datasourceRsgbBag == null) {
                InitialContext ic = new InitialContext();
                Context context = (Context)ic.lookup(JNDI_NAME);
                datasourceRsgbBag = (DataSource)context.lookup(JDBC_NAME_RSGB_BAG);
            }
        }
        catch (Exception ex) {
            if (logErrors) {
                log.error((Object)"Fout verbinden naar 'rsgbbag' schema.", (Throwable)ex);
            }
            throw new BrmoException("Fout verbinden naar 'rsgbbag' schema: ", (Throwable)ex);
        }
        return datasourceRsgbBag;
    }

    public static DataSource getDataSourceRsgbBgt() throws BrmoException {
        try {
            if (datasourceRsgbBgt == null) {
                InitialContext ic = new InitialContext();
                Context xmlContext = (Context)ic.lookup(JNDI_NAME);
                datasourceRsgbBgt = (DataSource)xmlContext.lookup(JDBC_NAME_RSGB_BGT);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Fout verbinden naar 'rsgbbgt' schema.", (Throwable)ex);
            throw new BrmoException("Fout verbinden naar 'rsgbbgt' schema.", (Throwable)ex);
        }
        return datasourceRsgbBgt;
    }

    public ServletConfig getServletConfig() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void service(ServletRequest sr, ServletResponse sr1) throws ServletException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getServletInfo() {
        return "Servlet voor configuratie parameters in web.xml";
    }

    public void destroy() {
    }
}

