/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.util;

import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersieInfo
implements Servlet {
    private static final Log LOG = LogFactory.getLog(VersieInfo.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        BrmoFramework brmo = null;
        String appVersie = "mislukt";
        Properties props = new Properties();
        try {
            props.load(VersieInfo.class.getClassLoader().getResourceAsStream("git.properties"));
            appVersie = props.getProperty("builddetails.build.version", "onbekend");
        }
        catch (IOException ex) {
            String name = config.getServletContext().getContextPath();
            name = name.startsWith("/") ? name.substring(1).toUpperCase(Locale.ROOT) : "ROOT";
            LOG.warn((Object)("Ophalen " + name + " applicatie versie informatie is mislukt."), (Throwable)ex);
        }
        try {
            brmo = new BrmoFramework(ConfigUtil.getDataSourceStaging(), ConfigUtil.getDataSourceRsgb(), ConfigUtil.getDataSourceRsgbBgt(), ConfigUtil.getDataSourceRsgbBrk());
            LOG.info((Object)"BRMO versie informatie:");
            LOG.info((Object)("  brmo applicatie versie is: " + appVersie));
            LOG.info((Object)("  staging schema versie is:  " + brmo.getStagingVersion()));
            LOG.info((Object)("  rsgb schema versie is:     " + brmo.getRsgbVersion()));
            LOG.info((Object)("  rsgb brk schema versie is: " + brmo.getRsgbBrkVersion()));
            LOG.info((Object)("  rsgbbgt schema versie is:  " + brmo.getRsgbBgtVersion()));
        }
        catch (BrmoException ex) {
            LOG.warn((Object)"Ophalen BRMO schema versie informatie is mislukt.", (Throwable)ex);
        }
        finally {
            if (brmo != null) {
                brmo.closeBrmoFramework();
            }
        }
    }

    public ServletConfig getServletConfig() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getServletInfo() {
        return "Versie info logging servlet";
    }

    public void destroy() {
    }
}

