/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.pipeline;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import nl.b3p.brmo.loader.BerichtenHandler;
import nl.b3p.brmo.loader.pipeline.BerichtWorkUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.javasimon.SimonManager;
import org.javasimon.Split;

public abstract class BerichtPipelineThread
extends Thread {
    final Log log = LogFactory.getLog(this.getClass());
    private final BlockingQueue<BerichtWorkUnit> queue;
    final BerichtenHandler handler;
    private final String stopwatchPrefix;
    private boolean stopWhenQueueEmpty = false;
    private boolean abort = false;

    public BerichtPipelineThread(BerichtenHandler handler, int capacity, String stopwatchPrefix) {
        this.queue = new LinkedBlockingQueue<BerichtWorkUnit>(capacity);
        this.handler = handler;
        this.stopwatchPrefix = stopwatchPrefix;
    }

    public void stopWhenQueueEmpty() {
        this.stopWhenQueueEmpty = true;
    }

    public void setAbortFlag() {
        this.abort = true;
    }

    public BlockingQueue<BerichtWorkUnit> getQueue() {
        return this.queue;
    }

    abstract void work(BerichtWorkUnit var1) throws Exception;

    @Override
    public void run() {
        this.log.info((Object)"started, waiting for work");
        while (true) {
            BerichtWorkUnit workUnit = null;
            try {
                Split poll = SimonManager.getStopwatch((String)(this.stopwatchPrefix + ".poll")).start();
                workUnit = this.queue.poll(1L, TimeUnit.SECONDS);
                poll.stop();
            }
            catch (InterruptedException e) {
                this.log.info((Object)"interrupted while polling work queue");
            }
            if (this.abort) {
                this.log.info((Object)"aborting!");
                return;
            }
            if (this.stopWhenQueueEmpty && workUnit == null) {
                this.log.info((Object)"work queue empty, stopping");
                return;
            }
            if (workUnit == null) continue;
            int queueSize = this.queue.size();
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)String.format("processing %s for work unit bericht id %d, %s (queue size %d)", workUnit.getTypeOfWork().toString(), workUnit.getBericht().getId(), workUnit.getBericht().getObjectRef(), queueSize));
            }
            SimonManager.getCounter((String)(this.stopwatchPrefix + ".queuesize")).set((long)queueSize);
            try {
                this.work(workUnit);
            }
            catch (Exception e) {
                this.log.error((Object)("work method threw exception (continuing): " + e.getClass() + ": " + e.getMessage()));
            }
            try {
                if (workUnit.getRunAfterWork() == null) continue;
                workUnit.getRunAfterWork().run();
                workUnit.setRunAfterWork(null);
            }
            catch (Exception e) {
                this.log.error((Object)"run after work method threw exception, aborting", (Throwable)e);
                return;
            }
        }
    }
}

