/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import nl.b3p.brmo.loader.entity.BagBericht;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BagXMLReader
extends BrmoXMLReader {
    private static final Log log = LogFactory.getLog(BagXMLReader.class);
    private final XMLInputFactory factory = XMLInputFactory.newInstance();
    private final XMLStreamReader streamReader;
    private final Transformer transformer;
    private final DocumentBuilder builder;
    private final XMLOutputFactory xmlof;
    private String soort = "bag";
    public static final String MUTATIE_PRODUCT = "Mutatie-product";
    public static final String LVC_PRODUCT = "LVC-product";
    private static final String DATUM_TIJD_LV = "datumtijdstempelLV";
    private static final String MUTATIE_DATUMTOT = "MutatiedatumTot";
    private static final String STAND_PEILDATUM = "StandPeildatum";
    private static final String STAND_TECHNISCHEDATUM = "StandTechnischeDatum";
    private BagBericht nextBericht = null;
    public static final Map<String, String> lvcProductToObjectType;

    public BagXMLReader(InputStream in) throws XMLStreamException, TransformerConfigurationException, ParserConfigurationException {
        this.streamReader = this.factory.createXMLStreamReader(in);
        TransformerFactory tf = TransformerFactory.newInstance();
        this.transformer = tf.newTransformer();
        this.xmlof = XMLOutputFactory.newInstance();
        this.xmlof.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        dbfactory.setNamespaceAware(true);
        dbfactory.setNamespaceAware(true);
        this.builder = dbfactory.newDocumentBuilder();
        this.init();
    }

    @Override
    public void init() {
        String technischeDatum = null;
        String peilDatum = null;
        String mutatieDatumTot = null;
        try {
            while (this.streamReader.hasNext()) {
                if (this.streamReader.isStartElement()) {
                    String localName = this.streamReader.getLocalName();
                    if (localName.equals(MUTATIE_PRODUCT) || localName.equals(LVC_PRODUCT)) break;
                    if (localName.equals(DATUM_TIJD_LV)) {
                        this.setDatumAsString(this.streamReader.getElementText());
                    }
                    if (localName.equals(STAND_TECHNISCHEDATUM)) {
                        technischeDatum = this.streamReader.getElementText();
                    }
                    if (localName.equals(STAND_PEILDATUM)) {
                        peilDatum = this.streamReader.getElementText();
                    }
                    if (localName.equals(MUTATIE_DATUMTOT)) {
                        mutatieDatumTot = this.streamReader.getElementText();
                    }
                }
                this.streamReader.next();
            }
        }
        catch (XMLStreamException ex) {
            log.error((Object)"Error while streaming XML", (Throwable)ex);
        }
        if (peilDatum != null) {
            this.setDatumAsString(peilDatum, "yyyyMMdd");
        } else if (technischeDatum != null) {
            this.setDatumAsString(technischeDatum, "yyyyMMdd");
        } else if (mutatieDatumTot != null) {
            this.setDatumAsString(mutatieDatumTot, "yyyy-MM-dd");
        } else {
            this.setBestandsDatum(new Date());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() throws SAXException, IOException, TransformerException {
        if (this.nextBericht != null) {
            return true;
        }
        try {
            while (this.streamReader.hasNext()) {
                NodeList children;
                Document d;
                StringWriter sw;
                if (this.streamReader.isStartElement() && this.streamReader.getLocalName().equals(MUTATIE_PRODUCT)) {
                    sw = new StringWriter();
                    this.transformer.transform(new StAXSource(this.streamReader), new StAXResult(this.xmlof.createXMLStreamWriter(sw)));
                    d = this.builder.parse(new InputSource(new StringReader(sw.toString())));
                    children = d.getDocumentElement().getChildNodes();
                } else {
                    if (this.streamReader.isStartElement() && lvcProductToObjectType.containsKey(this.streamReader.getLocalName())) {
                        sw = new StringWriter();
                        this.transformer.transform(new StAXSource(this.streamReader), new StAXResult(this.xmlof.createXMLStreamWriter(sw)));
                        d = this.builder.parse(new InputSource(new StringReader(sw.toString())));
                        this.nextBericht = new BagBericht(sw.toString(), d);
                        this.nextBericht.setDatum(this.getBestandsDatum());
                        return true;
                    }
                    this.streamReader.next();
                    continue;
                }
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (!"Nieuw".equals(child.getLocalName())) continue;
                    this.nextBericht = new BagBericht(sw.toString(), d);
                    return true;
                }
            }
            return false;
        }
        catch (XMLStreamException ex) {
            log.error((Object)"Error while streaming XML", (Throwable)ex);
        }
        return false;
    }

    @Override
    public BagBericht next() throws TransformerException, XMLStreamException {
        BagBericht b = this.nextBericht;
        this.nextBericht = null;
        return b;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("Standplaats", "STA");
        m.put("Ligplaats", "LIG");
        m.put("Nummeraanduiding", "NUM");
        m.put("OpenbareRuimte", "OPR");
        m.put("Pand", "PND");
        m.put("Verblijfsobject", "VBO");
        m.put("Standplaats", "STA");
        m.put("Woonplaats", "WPL");
        lvcProductToObjectType = Collections.unmodifiableMap(m);
    }
}

