/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.transform.TransformerException;
import nl.b3p.brmo.loader.BerichtenHandler;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.RsgbProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.entity.BerichtenSorter;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.brmo.loader.pipeline.BerichtTypeOfWork;
import nl.b3p.brmo.loader.pipeline.BerichtWorkUnit;
import nl.b3p.brmo.loader.pipeline.ProcessDbXmlPipeline;
import nl.b3p.brmo.loader.util.BrmoDuplicaatLaadprocesException;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.BrmoLeegBestandException;
import nl.b3p.brmo.loader.util.RsgbTransformer;
import nl.b3p.brmo.loader.util.StagingRowHandler;
import nl.b3p.brmo.loader.util.TableData;
import nl.b3p.brmo.loader.xml.BagXMLReader;
import nl.b3p.brmo.loader.xml.BrkSnapshotXMLReader;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.xml.sax.SAXException;

public class StagingProxy {
    private static final Log log = LogFactory.getLog(StagingProxy.class);
    private Connection connStaging = null;
    private DataSource dataSourceStaging = null;
    private String dbType;
    private PreparedStatement getOldBerichtStatement;

    public StagingProxy(DataSource dataSourceStaging) throws SQLException, BrmoException {
        this.dataSourceStaging = dataSourceStaging;
        this.setDbType();
    }

    public void closeStagingProxy() {
        if (this.getOldBerichtStatement != null) {
            DbUtils.closeQuietly((Statement)this.getOldBerichtStatement);
        }
        DbUtils.closeQuietly((Connection)this.connStaging);
    }

    private Connection getConnection() throws SQLException {
        if (this.connStaging == null || this.connStaging.isClosed()) {
            this.connStaging = this.dataSourceStaging.getConnection();
        }
        return this.connStaging;
    }

    private void setDbType() throws SQLException, BrmoException {
        String productName = this.getConnection().getMetaData().getDatabaseProductName();
        if (productName.contains("PostgreSQL")) {
            this.dbType = "postgres";
        } else if (productName.contains("Oracle")) {
            this.dbType = "oracle";
        } else {
            throw new BrmoException("Database niet ondersteund: " + productName);
        }
    }

    public LaadProces getLaadProcesById(Long id) throws SQLException {
        BeanListHandler h = new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler());
        List processen = (List)new QueryRunner().query(this.getConnection(), "SELECT * FROM laadproces WHERE id = ?", (ResultSetHandler)h, new Object[]{id});
        if (processen != null && processen.size() == 1) {
            return (LaadProces)processen.get(0);
        }
        return null;
    }

    public Bericht getBerichtById(Long id) throws SQLException {
        BeanListHandler h = new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler());
        List berichten = (List)new QueryRunner().query(this.getConnection(), "SELECT * FROM bericht WHERE id = ?", (ResultSetHandler)h, new Object[]{id});
        if (berichten != null && berichten.size() == 1) {
            return (Bericht)berichten.get(0);
        }
        return null;
    }

    public LaadProces getLaadProcesByFileName(String name) throws SQLException {
        BeanListHandler h = new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler());
        List processen = (List)new QueryRunner().query(this.getConnection(), "SELECT * FROM laadproces WHERE bestand_naam = ?", (ResultSetHandler)h, new Object[]{name});
        if (processen != null && processen.size() == 1) {
            return (LaadProces)processen.get(0);
        }
        return null;
    }

    private LaadProces getLaadProcesByNaturalKey(String name, long date) throws SQLException {
        BeanListHandler h = new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler());
        List processen = (List)new QueryRunner().query(this.getConnection(), "SELECT * FROM laadproces WHERE bestand_naam = ? AND bestand_datum = ?", (ResultSetHandler)h, new Object[]{name, new Timestamp(date)});
        if (processen != null && processen.size() == 1) {
            return (LaadProces)processen.get(0);
        }
        return null;
    }

    private Bericht getBerichtByNaturalKey(String name, long date) throws SQLException {
        BeanListHandler h = new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler());
        List processen = (List)new QueryRunner().query(this.getConnection(), "SELECT * FROM bericht WHERE bestand_naam = ? AND bestand_datum = ?", (ResultSetHandler)h, new Object[]{name, new Timestamp(date)});
        if (processen != null && processen.size() == 1) {
            return (Bericht)processen.get(0);
        }
        return null;
    }

    public void setBerichtenJobByStatus(Bericht.STATUS status, String jobId) throws SQLException {
        new QueryRunner().update(this.getConnection(), "update bericht set status = ?, job_id = ? where status = ?", new Object[]{Bericht.STATUS.RSGB_WAITING.toString(), jobId, status.toString()});
    }

    public void setBerichtenJobForUpdate(String jobId, String soort) throws SQLException {
        new QueryRunner().update(this.getConnection(), "update bericht set job_id = ? where status = ? and soort = ?", new Object[]{jobId, Bericht.STATUS.RSGB_OK.toString(), soort});
    }

    public void setBerichtenJobByIds(long[] ids, String jobId) throws SQLException {
        StringBuilder q = new StringBuilder("update bericht set status = ?, job_id = ? where id in (");
        for (int i = 0; i < ids.length; ++i) {
            if (i != 0) {
                q.append(",");
            }
            q.append(ids[i]);
        }
        q.append(")");
        new QueryRunner().update(this.getConnection(), q.toString(), new Object[]{Bericht.STATUS.RSGB_WAITING.toString(), jobId});
    }

    public void setBerichtenJobByLaadprocessen(long[] laadprocesIds, String jobId) throws SQLException {
        StringBuilder q = new StringBuilder("update bericht set status = ?, job_id = ? where laadprocesid in (");
        for (int i = 0; i < laadprocesIds.length; ++i) {
            if (i != 0) {
                q.append(",");
            }
            q.append(laadprocesIds[i]);
        }
        q.append(") and status = ?");
        new QueryRunner().update(this.getConnection(), q.toString(), new Object[]{Bericht.STATUS.RSGB_WAITING.toString(), jobId, Bericht.STATUS.STAGING_OK.toString()});
    }

    public long getBerichtenCountByJob(String jobId) throws SQLException {
        Object o = new QueryRunner().query(this.getConnection(), "select count(*) from bericht where job_id = ?", (ResultSetHandler)new ScalarHandler(), new Object[]{jobId});
        return o instanceof BigDecimal ? ((BigDecimal)o).longValue() : ((Long)o).longValue();
    }

    public void handleBerichtenByJob(String jobId, long total, BerichtenHandler handler, boolean enablePipeline, int transformPipelineCapacity) throws Exception {
        Split split = SimonManager.getStopwatch((String)"b3p.rsgb.job").start();
        final String dateTime = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        Split jobSplit = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime)).start();
        ((RsgbProxy)handler).setSimonNamePrefix("b3p.rsgb.job." + dateTime + ".");
        StagingRowHandler processor = new StagingRowHandler();
        ProcessDbXmlPipeline processDbXmlPipeline = new ProcessDbXmlPipeline(handler, transformPipelineCapacity, "b3p.rsgb.job." + dateTime + ".pipeline");
        if (enablePipeline) {
            processDbXmlPipeline.start();
        }
        int offset = 0;
        int batch = 250;
        MutableInt processed = new MutableInt(0);
        boolean abort = false;
        try {
            do {
                log.debug((Object)String.format("Ophalen berichten batch voor job %s, offset %d, limit %d", jobId, offset, batch));
                String sql = "select * from bericht where job_id = ? order by " + BerichtenSorter.SQL_ORDER_BY;
                sql = this.dbType.contains("oracle") ? this.buildPaginationSqlOracle(sql, offset, batch) : sql + " limit " + batch + " offset " + offset;
                log.debug((Object)("SQL voor ophalen berichten batch: " + sql));
                processed.setValue(0);
                final Split getBerichten = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime + ".staging.berichten.getbatch")).start();
                Exception e = (Exception)new QueryRunner().query(this.getConnection(), sql, (ResultSetHandler)new ResultSetHandler<Exception>((RowProcessor)processor, handler, enablePipeline, processDbXmlPipeline, processed){
                    final /* synthetic */ RowProcessor val$processor;
                    final /* synthetic */ BerichtenHandler val$handler;
                    final /* synthetic */ boolean val$enablePipeline;
                    final /* synthetic */ ProcessDbXmlPipeline val$processDbXmlPipeline;
                    final /* synthetic */ MutableInt val$processed;
                    {
                        this.val$processor = rowProcessor;
                        this.val$handler = berichtenHandler;
                        this.val$enablePipeline = bl;
                        this.val$processDbXmlPipeline = processDbXmlPipeline;
                        this.val$processed = mutableInt;
                    }

                    public Exception handle(ResultSet rs) throws SQLException {
                        getBerichten.stop();
                        Split processResultSet = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime + ".staging.berichten.processresultset")).start();
                        while (rs.next()) {
                            try {
                                Bericht bericht = (Bericht)this.val$processor.toBean(rs, Bericht.class);
                                BerichtWorkUnit workUnit = new BerichtWorkUnit(bericht);
                                this.val$handler.updateBerichtProcessing(bericht);
                                if (this.val$enablePipeline) {
                                    List<TableData> tableData = this.val$handler.transformToTableData(bericht);
                                    if (tableData == null) continue;
                                    workUnit.setTableData(tableData);
                                    workUnit.setTypeOfWork(BerichtTypeOfWork.PROCESS_DBXML);
                                    Split pipelinePut = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime + ".pipeline.processdbxml.put")).start();
                                    this.val$processDbXmlPipeline.getQueue().put(workUnit);
                                    pipelinePut.stop();
                                } else {
                                    Split berichtSplit = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime + ".bericht")).start();
                                    this.val$handler.handle(bericht, null, true);
                                    berichtSplit.stop();
                                }
                            }
                            catch (Exception e) {
                                return e;
                            }
                            this.val$processed.increment();
                        }
                        processResultSet.stop();
                        return null;
                    }
                }, new Object[]{jobId});
                offset += processed.intValue();
                if (e == null) continue;
                throw e;
            } while (processed.intValue() > 0 && (long)offset < total);
            if ((long)offset < total) {
                log.warn((Object)String.format("Minder berichten verwerkt (%d) dan verwacht (%d)!", offset, total));
            }
        }
        catch (Exception t) {
            abort = true;
            throw t;
        }
        finally {
            if (enablePipeline) {
                if (abort) {
                    processDbXmlPipeline.setAbortFlag();
                } else {
                    processDbXmlPipeline.stopWhenQueueEmpty();
                    try {
                        processDbXmlPipeline.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        jobSplit.stop();
        split.stop();
    }

    public void updateBerichtenDbXml(List<Bericht> berichten, RsgbTransformer transformer) throws SQLException, SAXException, IOException, TransformerException {
        for (Bericht ber : berichten) {
            Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.dbxml.transform").start();
            String dbxml = transformer.transformToDbXml(ber);
            ber.setDbXml(dbxml);
            split.stop();
        }
    }

    public Bericht getOldBericht(Bericht nieuwBericht, StringBuilder loadLog) throws SQLException {
        Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.getold").start();
        Bericht bericht = null;
        BeanListHandler h = new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler());
        if (this.getOldBerichtStatement == null) {
            String sql = null;
            sql = this.dbType.contains("postgres") ? "SELECT * FROM bericht WHERE object_ref = ? ORDER BY datum desc, volgordenummer desc" : "SELECT * FROM bericht WHERE object_ref = ? ORDER BY datum desc, volgordenummer desc";
            this.getOldBerichtStatement = this.getConnection().prepareStatement(sql);
        } else {
            this.getOldBerichtStatement.clearParameters();
        }
        this.getOldBerichtStatement.setString(1, nieuwBericht.getObjectRef());
        ResultSet rs = this.getOldBerichtStatement.executeQuery();
        List list = (List)h.handle(rs);
        rs.close();
        if (!list.isEmpty()) {
            loadLog.append("Vorige berichten gevonden:\n");
            for (Bericht b : list) {
                if (Bericht.STATUS.RSGB_OK.equals((Object)b.getStatus()) && bericht == null) {
                    loadLog.append("Recentste bericht gevonden met RSGB_OK: ").append(b).append("\n");
                    bericht = b;
                    continue;
                }
                loadLog.append("Niet geschikt bericht: ").append(b).append("\n");
            }
        }
        split.stop();
        return bericht;
    }

    public void updateBericht(Bericht b) throws SQLException {
        Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.update").start();
        new QueryRunner().update(this.getConnection(), "UPDATE bericht set object_ref = ?, datum = ?, volgordenummer = ?, soort = ?, opmerking = ?, status = ?, status_datum = ?, br_xml = ?, br_orgineel_xml = ?, db_xml = ?, xsl_version = ? WHERE id = ?", new Object[]{b.getObjectRef(), new Timestamp(b.getDatum().getTime()), b.getVolgordeNummer(), b.getSoort(), b.getOpmerking(), b.getStatus().toString(), new Timestamp(b.getStatusDatum().getTime()), b.getBrXml(), b.getBrOrgineelXml(), b.getDbXml(), b.getXslVersion(), b.getId()});
        split.stop();
    }

    public void updateBerichtProcessing(Bericht b) throws SQLException {
        Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.updateprocessing").start();
        new QueryRunner().update(this.getConnection(), "UPDATE bericht set opmerking = ?, status = ?, status_datum = ?, db_xml = ? WHERE id = ?", new Object[]{b.getOpmerking(), b.getStatus().toString(), new Timestamp(b.getStatusDatum().getTime()), b.getDbXml(), b.getId()});
        split.stop();
    }

    public void deleteByLaadProcesId(Long id) throws SQLException {
        new QueryRunner().update(this.getConnection(), "DELETE FROM bericht WHERE laadprocesid = ?", (Object)id);
        new QueryRunner().update(this.getConnection(), "DELETE FROM laadproces WHERE id = ?", (Object)id);
    }

    public List<LaadProces> getLaadProcessen() throws SQLException {
        BeanListHandler h = new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler());
        List list = (List)new QueryRunner().query(this.getConnection(), "select * from laadproces", (ResultSetHandler)h);
        return list;
    }

    public List<Bericht> getBerichten() throws SQLException {
        BeanListHandler h = new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler());
        List berichten = (List)new QueryRunner().query(this.getConnection(), "select * from bericht", (ResultSetHandler)h);
        return berichten;
    }

    public void loadBr(InputStream stream, String type, String fileName, ProgressUpdateListener listener) throws Exception {
        CountingInputStream cis = new CountingInputStream(stream);
        BrmoXMLReader brmoXMLReader = null;
        if (type.equals("brk")) {
            brmoXMLReader = new BrkSnapshotXMLReader((InputStream)cis);
        } else if (type.equals("bag")) {
            brmoXMLReader = new BagXMLReader((InputStream)cis);
        } else {
            throw new UnsupportedOperationException("Ongeldige basisregistratie: " + type);
        }
        if (brmoXMLReader.getBestandsDatum() == null) {
            throw new BrmoException("Header van bestand bevat geen datum, verkeerd formaat?");
        }
        LaadProces lp = new LaadProces();
        lp.setBestandNaam(fileName);
        lp.setBestandDatum(brmoXMLReader.getBestandsDatum());
        lp.setSoort(type);
        lp.setGebied(brmoXMLReader.getGebied());
        lp.setStatus(LaadProces.STATUS.STAGING_OK);
        lp.setStatusDatum(new Date());
        if (this.laadProcesExists(lp)) {
            throw new BrmoDuplicaatLaadprocesException("Laadproces al gerund voor bestand " + fileName);
        }
        lp = this.writeLaadProces(lp);
        boolean isBerichtGeschreven = false;
        if (!brmoXMLReader.hasNext()) {
            throw new BrmoLeegBestandException("Leeg bestand, geen berichten gevonden in " + fileName);
        }
        int berichten = 0;
        while (brmoXMLReader.hasNext()) {
            Bericht b = null;
            try {
                b = brmoXMLReader.next();
                b.setLaadProcesId(lp.getId().intValue());
                b.setStatus(Bericht.STATUS.STAGING_OK);
                b.setStatusDatum(new Date());
                b.setSoort(type);
                if (!this.berichtExists(b)) {
                    this.writeBericht(b);
                    isBerichtGeschreven = true;
                }
                if (listener != null) {
                    listener.progress(cis.getByteCount());
                }
                ++berichten;
            }
            catch (Exception e) {
                log.error((Object)("Bericht mislukt vanwege " + e.getLocalizedMessage()));
                if (listener == null) continue;
                listener.exception(e);
            }
        }
        if (listener != null) {
            listener.total(berichten);
        }
        if (!isBerichtGeschreven) {
            this.updateLaadProcesStatus(lp, LaadProces.STATUS.STAGING_DUPLICAAT);
        }
    }

    public boolean berichtExists(Bericht b) throws SQLException {
        Object o = new QueryRunner().query(this.getConnection(), "SELECT 1 FROM bericht WHERE object_ref = ? AND datum = ? AND volgordenummer = ?", (ResultSetHandler)new ScalarHandler(), new Object[]{b.getObjectRef(), new Timestamp(b.getDatum().getTime()), b.getVolgordeNummer()});
        return o != null;
    }

    public void writeBericht(Bericht b) throws SQLException {
        new QueryRunner().update(this.getConnection(), "INSERT INTO bericht(laadprocesid, object_ref, datum, volgordenummer, soort, opmerking, status, status_datum, br_xml, br_orgineel_xml, db_xml, xsl_version) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{b.getLaadProcesId(), b.getObjectRef(), new Timestamp(b.getDatum().getTime()), b.getVolgordeNummer(), b.getSoort(), b.getOpmerking(), b.getStatus().toString(), new Timestamp(b.getStatusDatum().getTime()), b.getBrXml(), b.getBrOrgineelXml(), b.getDbXml(), b.getXslVersion()});
    }

    private boolean laadProcesExists(LaadProces lp) throws SQLException {
        Object o = new QueryRunner().query(this.getConnection(), "select 1 from laadproces where bestand_naam = ? and bestand_datum = ?", (ResultSetHandler)new ScalarHandler(), new Object[]{lp.getBestandNaam(), new Timestamp(lp.getBestandDatum().getTime())});
        return o != null;
    }

    private LaadProces writeLaadProces(LaadProces lp) throws SQLException {
        if (lp == null) {
            return null;
        }
        new QueryRunner().update(this.getConnection(), "INSERT INTO laadproces(bestand_naam,bestand_datum, soort, gebied, opmerking, status,status_datum, contact_email) VALUES (?,?,?,?,?,?,?,?)", new Object[]{lp.getBestandNaam(), new Timestamp(lp.getBestandDatum().getTime()), lp.getSoort(), lp.getGebied(), lp.getOpmerking(), lp.getStatus().toString(), new Timestamp(lp.getStatusDatum().getTime()), lp.getContactEmail()});
        return this.getLaadProcesByNaturalKey(lp.getBestandNaam(), lp.getBestandDatum().getTime());
    }

    private void updateLaadProcesStatus(LaadProces lp, LaadProces.STATUS status) throws SQLException {
        new QueryRunner().update(this.getConnection(), "update laadproces set status = ? where id = ?", new Object[]{status.toString(), lp.getId()});
    }

    public void emptyStagingDb() throws SQLException {
        new QueryRunner().update(this.getConnection(), "DELETE FROM bericht");
        new QueryRunner().update(this.getConnection(), "DELETE FROM laadproces");
    }

    public List<Bericht> getBerichten(int page, int start, int limit, String sort, String dir, String filterSoort, String filterStatus) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        String sql = "SELECT * FROM bericht" + this.buildFilterSql(page, start, limit, sort, dir, filterSoort, filterStatus, false, params);
        if (this.dbType.contains("oracle") && (start > 0 || limit > 0)) {
            sql = this.buildPaginationSqlOracle(sql, start, limit);
        }
        return (List)new QueryRunner().query(this.getConnection(), sql, (ResultSetHandler)new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler()), params.toArray());
    }

    private String buildPaginationSqlOracle(String sql, int offset, int limit) {
        StringBuilder builder = new StringBuilder();
        builder.append("select * from (");
        builder.append("select /*+ FIRST_ROWS(n) */");
        builder.append(" a.*, ROWNUM rnum from (");
        builder.append(sql);
        builder.append(" ) a where ROWNUM <=");
        builder.append(offset + limit);
        builder.append(" )");
        builder.append(" where rnum  > ");
        builder.append(offset);
        return builder.toString();
    }

    public long getCountBerichten(String sort, String dir, String filterSoort, String filterStatus) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        String sql = "SELECT count(*) FROM bericht" + this.buildFilterSql(0, 0, 0, null, null, filterSoort, filterStatus, true, params);
        Object o = new QueryRunner().query(this.getConnection(), sql, (ResultSetHandler)new ScalarHandler(), params.toArray());
        return o instanceof BigDecimal ? ((BigDecimal)o).longValue() : ((Long)o).longValue();
    }

    private String buildFilterSql(int page, int start, int limit, String sort, String dir, String filterSoort, String filterStatus, boolean useForCount, List<String> params) {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> conjunctions = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)filterSoort)) {
            String[] soorten = filterSoort.split(",");
            params.addAll(Arrays.asList(soorten));
            conjunctions.add("soort in (" + StringUtils.repeat((String)"?", (String)", ", (int)soorten.length) + ")");
        }
        if (!StringUtils.isBlank((CharSequence)filterStatus)) {
            String[] statussen = filterStatus.split(",");
            params.addAll(Arrays.asList(statussen));
            conjunctions.add("status in (" + StringUtils.repeat((String)"?", (String)", ", (int)statussen.length) + ")");
        }
        if (!conjunctions.isEmpty()) {
            builder.append(" where ");
            builder.append(StringUtils.join((Object[])conjunctions.toArray(), (String)" and "));
        }
        if (sort != null && dir != null) {
            builder.append(" ORDER BY ");
            builder.append(sort);
            builder.append(" ");
            builder.append(dir);
        }
        if ((!useForCount && start > 0 || limit > 0) && this.dbType.contains("postgres")) {
            builder.append(" LIMIT ");
            builder.append(limit);
            builder.append(" OFFSET ");
            builder.append(start);
        }
        return builder.toString();
    }

    public long getCountLaadProces(String sort, String dir, String filterSoort, String filterStatus) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        String sql = "SELECT count(*) FROM laadproces" + this.buildFilterSql(0, 0, 0, null, null, filterSoort, filterStatus, true, params);
        Object o = new QueryRunner().query(this.getConnection(), sql, (ResultSetHandler)new ScalarHandler(), params.toArray());
        return o instanceof BigDecimal ? ((BigDecimal)o).longValue() : ((Long)o).longValue();
    }

    public List<LaadProces> getLaadprocessen(int page, int start, int limit, String sort, String dir, String filterSoort, String filterStatus) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        String sql = "SELECT * FROM laadproces" + this.buildFilterSql(page, start, limit, sort, dir, filterSoort, filterStatus, false, params);
        if (this.dbType.contains("oracle") && (start > 0 || limit > 0)) {
            sql = this.buildPaginationSqlOracle(sql, start, limit);
        }
        return (List)new QueryRunner().query(this.getConnection(), sql, (ResultSetHandler)new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler()), params.toArray());
    }

    Bericht getOldBericht(Bericht nieuwBericht) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

