/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader;

import com.vividsolutions.jts.io.ParseException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.sql.DataSource;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.brmo.loader.BerichtenHandler;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.jdbc.ColumnMetadata;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.brmo.loader.jdbc.OracleJdbcConverter;
import nl.b3p.brmo.loader.updates.UpdateProcess;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.DataComfortXMLReader;
import nl.b3p.brmo.loader.util.RsgbTransformer;
import nl.b3p.brmo.loader.util.TableData;
import nl.b3p.brmo.loader.util.TableRow;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.w3c.dom.Node;

public class RsgbProxy
implements Runnable,
BerichtenHandler {
    private static final Log log = LogFactory.getLog(RsgbProxy.class);
    private final String jobId = Thread.currentThread().getId() + System.currentTimeMillis() + "";
    private final boolean alsoExecuteSql = true;
    private final ProgressUpdateListener listener;
    private int processed;
    private final BerichtSelectMode mode;
    private final UpdateProcess updateProcess;
    private Bericht.STATUS status;
    private long[] berichtIds;
    private long[] laadprocesIds;
    private DatabaseMetaData dbMetadata = null;
    private Map<String, String> tables = new HashMap<String, String>();
    private Map<String, SortedSet<ColumnMetadata>> tableColumns = new HashMap<String, SortedSet<ColumnMetadata>>();
    private Connection connRsgb = null;
    private GeometryJdbcConverter geomToJdbc = null;
    private Savepoint recentSavepoint = null;
    private String herkomstMetadata = null;
    private DataSource dataSourceRsgb = null;
    private StagingProxy stagingProxy = null;
    private boolean enablePipeline = false;
    private int pipelineCapacity = 25;
    private Map<String, RsgbTransformer> rsgbTransformers = new HashMap<String, RsgbTransformer>();
    private String simonNamePrefix = "b3p.rsgb.";
    private final DataComfortXMLReader dbXmlReader = new DataComfortXMLReader();
    private final DataComfortXMLReader oldDbXmlReader = new DataComfortXMLReader();
    private final Map<String, PreparedStatement> insertSqlPreparedStatements = new HashMap<String, PreparedStatement>();
    private final Map<String, PreparedStatement> updateSqlPreparedStatements = new HashMap<String, PreparedStatement>();
    private PreparedStatement insertMetadataStatement;
    private final Map<String, PreparedStatement> checkRowExistsStatements = new HashMap<String, PreparedStatement>();
    private final Map<String, PreparedStatement> getTableRowStatements = new HashMap<String, PreparedStatement>();
    private final Map<String, List<String>> primaryKeyCache = new HashMap<String, List<String>>();

    public RsgbProxy(DataSource dataSourceRsgb, StagingProxy stagingProxy, Bericht.STATUS status, ProgressUpdateListener listener) {
        this.stagingProxy = stagingProxy;
        this.dataSourceRsgb = dataSourceRsgb;
        this.mode = BerichtSelectMode.BY_STATUS;
        this.status = status;
        this.listener = listener;
        this.updateProcess = null;
    }

    public RsgbProxy(DataSource dataSourceRsgb, StagingProxy stagingProxy, BerichtSelectMode mode, long[] ids, ProgressUpdateListener listener) {
        this.stagingProxy = stagingProxy;
        this.dataSourceRsgb = dataSourceRsgb;
        this.mode = mode;
        if (mode == BerichtSelectMode.BY_LAADPROCES) {
            this.laadprocesIds = ids;
        } else if (mode == BerichtSelectMode.BY_IDS) {
            this.berichtIds = ids;
        }
        this.listener = listener;
        this.updateProcess = null;
    }

    public RsgbProxy(DataSource dataSourceRsgb, StagingProxy stagingProxy, UpdateProcess updateProcess, ProgressUpdateListener listener) {
        this.stagingProxy = stagingProxy;
        this.dataSourceRsgb = dataSourceRsgb;
        this.mode = BerichtSelectMode.FOR_UPDATE;
        this.updateProcess = updateProcess;
        this.listener = listener;
    }

    public void setSimonNamePrefix(String prefix) {
        this.simonNamePrefix = prefix;
    }

    public void setEnablePipeline(boolean enablePipeline) {
        this.enablePipeline = enablePipeline;
    }

    public void setPipelineCapacity(int pipelineCapacity) {
        this.pipelineCapacity = pipelineCapacity;
    }

    public void init() throws SQLException {
        this.connRsgb = this.dataSourceRsgb.getConnection();
        this.geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter(this.connRsgb);
        try {
            this.dbMetadata = this.connRsgb.getMetaData();
            ResultSet tablesRs = this.dbMetadata.getTables(null, this.geomToJdbc.getSchema(), "%", new String[]{"TABLE"});
            while (tablesRs.next()) {
                this.tables.put(tablesRs.getString("TABLE_NAME").toLowerCase(), tablesRs.getString("TABLE_NAME"));
            }
        }
        catch (SQLException sqlEx) {
            throw new SQLException("Fout bij ophalen tabellen: ", sqlEx);
        }
    }

    public void close() {
        for (PreparedStatement stmt : this.checkRowExistsStatements.values()) {
            DbUtils.closeQuietly((Statement)stmt);
        }
        for (PreparedStatement stmt : this.insertSqlPreparedStatements.values()) {
            DbUtils.closeQuietly((Statement)stmt);
        }
        for (PreparedStatement stmt : this.updateSqlPreparedStatements.values()) {
            DbUtils.closeQuietly((Statement)stmt);
        }
        if (this.insertMetadataStatement != null) {
            DbUtils.closeQuietly((Statement)this.insertMetadataStatement);
        }
        DbUtils.closeQuietly((Connection)this.connRsgb);
    }

    @Override
    public void run() {
        block3: {
            try {
                this.init();
                this.setWaitingStatus();
                long total = this.stagingProxy.getBerichtenCountByJob(this.jobId);
                if (this.listener != null) {
                    this.listener.total(total);
                }
                this.stagingProxy.handleBerichtenByJob(this.jobId, total, this, this.enablePipeline, this.pipelineCapacity);
            }
            catch (Exception e) {
                log.error((Object)"Fout tijdens verwerken berichten", (Throwable)e);
                if (this.listener == null) break block3;
                this.listener.exception(e);
            }
        }
        this.close();
    }

    private void setWaitingStatus() throws SQLException {
        switch (this.mode) {
            case BY_STATUS: {
                this.stagingProxy.setBerichtenJobByStatus(this.status, this.jobId);
                break;
            }
            case BY_IDS: {
                this.stagingProxy.setBerichtenJobByIds(this.berichtIds, this.jobId);
                break;
            }
            case BY_LAADPROCES: {
                this.stagingProxy.setBerichtenJobByLaadprocessen(this.laadprocesIds, this.jobId);
                break;
            }
            case FOR_UPDATE: {
                this.stagingProxy.setBerichtenJobForUpdate(this.jobId, this.updateProcess.getSoort());
            }
        }
    }

    @Override
    public void updateProcessingResult(Bericht ber) {
        if (this.updateProcess != null) {
            return;
        }
        ber.setStatusDatum(new java.util.Date());
        try {
            this.stagingProxy.updateBericht(ber);
        }
        catch (SQLException ex) {
            log.error((Object)"Kan status niet updaten", (Throwable)ex);
        }
    }

    @Override
    public List<TableData> transformToTableData(Bericht ber) throws BrmoException {
        RsgbTransformer transformer;
        if (this.updateProcess != null) {
            return this.transformUpdateTableData(ber);
        }
        try {
            transformer = this.getTransformer(ber.getSoort());
        }
        catch (Exception e) {
            throw new BrmoException("Fout bij laden " + ber.getSoort() + " XSL stylesheet", e);
        }
        try {
            StringBuilder loadLog = new StringBuilder();
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            loadLog.append(String.format("%s: transformeren %s bericht object ref %s, met id %s, berichtdatum %s\n", dateTimeFormat.format(new java.util.Date()), ber.getSoort(), ber.getObjectRef(), ber.getId(), dateFormat.format(ber.getDatum())));
            long startTime = System.currentTimeMillis();
            this.stagingProxy.updateBerichtenDbXml(Collections.singletonList(ber), transformer);
            Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.dbxml.read").start();
            StringReader nReader = new StringReader(ber.getDbXml());
            List<TableData> data = this.dbXmlReader.readDataXML(new StreamSource(nReader));
            split.stop();
            loadLog.append(String.format("Transformeren naar RSGB database-xml en lezen resultaat: %4.1fs\n\n", (double)(System.currentTimeMillis() - startTime) / 1000.0));
            ber.setOpmerking(loadLog.toString());
            return data;
        }
        catch (Exception e) {
            this.updateBerichtException(ber, e);
            this.updateProcessingResult(ber);
            return null;
        }
    }

    public List<TableData> transformUpdateTableData(Bericht ber) throws BrmoException {
        RsgbTransformer transformer = this.rsgbTransformers.get(this.updateProcess.getName());
        if (transformer == null) {
            try {
                transformer = new RsgbTransformer(this.updateProcess.getXsl());
            }
            catch (Exception e) {
                throw new BrmoException("Fout bij laden XSL stylesheet: " + this.updateProcess.getXsl(), e);
            }
            this.rsgbTransformers.put(this.updateProcess.getName(), transformer);
        }
        try {
            Node dbxml = transformer.transformToDbXmlNode(ber);
            List<TableData> data = this.dbXmlReader.readDataXML(new DOMSource(dbxml));
            return data;
        }
        catch (Exception e) {
            log.error((Object)("Fout bij transformeren bericht #" + ber.getId() + " voor update"), (Throwable)e);
            throw new BrmoException("Fout bij transformeren bericht #" + ber.getId() + " voor update: " + e.getClass() + ": " + e.getMessage());
        }
    }

    public void updateBerichtException(Bericht ber, Throwable e) {
        ber.setStatus(Bericht.STATUS.RSGB_NOK);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        ber.setOpmerking(ber.getOpmerking() + "\nFout: " + sw.toString());
    }

    @Override
    public void updateBerichtProcessing(Bericht ber) throws Exception {
        if (this.updateProcess != null) {
            return;
        }
        ber.setStatus(Bericht.STATUS.RSGB_PROCESSING);
        ber.setOpmerking("");
        ber.setStatusDatum(new java.util.Date());
        ber.setDbXml(null);
        this.stagingProxy.updateBerichtProcessing(ber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Bericht ber, List<TableData> pretransformedTableData, boolean updateResult) throws BrmoException {
        if (this.updateProcess != null) {
            this.update(ber, pretransformedTableData);
            return;
        }
        Bericht.STATUS newStatus = Bericht.STATUS.RSGB_OK;
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:SSS");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        log.debug((Object)String.format("RSGB verwerking van %s bericht met id %s, object_ref %s", ber.getSoort(), ber.getId(), ber.getObjectRef()));
        StringBuilder loadLog = pretransformedTableData == null ? new StringBuilder() : new StringBuilder(ber.getOpmerking());
        loadLog.append(String.format("%s: start verwerking %s bericht object ref %s, met id %s, berichtdatum %s\n", dateTimeFormat.format(new java.util.Date()), ber.getSoort(), ber.getObjectRef(), ber.getId(), dateFormat.format(ber.getDatum())));
        this.setHerkomstMetadata(ber.getSoort());
        long startTime = 0L;
        try {
            List<TableData> newList;
            if (this.connRsgb.getAutoCommit()) {
                this.connRsgb.setAutoCommit(false);
            }
            if (pretransformedTableData != null) {
                loadLog.append("Bericht was al getransformeerd in pipeline\n");
                newList = pretransformedTableData;
            } else {
                loadLog.append("Transformeren naar RSGB database-xml en lezen resultaat... ");
                startTime = System.currentTimeMillis();
                newList = this.transformToTableData(ber);
                loadLog.append(String.format("%4.1fs\n", (double)(System.currentTimeMillis() - startTime) / 1000.0));
            }
            startTime = System.currentTimeMillis();
            Bericht oud = this.stagingProxy.getOldBericht(ber, loadLog);
            if (oud != null) {
                loadLog.append(String.format("Eerder bericht (id: %d) voor zelfde object gevonden van datum %s, volgnummer %d,status %s op %s\n", oud.getId(), dateFormat.format(oud.getDatum()), oud.getVolgordeNummer(), oud.getStatus().toString(), dateTimeFormat.format(oud.getStatusDatum())));
                if (ber.getDatum().equals(oud.getDatum()) && ber.getVolgordeNummer().equals(oud.getVolgordeNummer())) {
                    loadLog.append("Datum en volgordenummer van nieuw bericht hetzelfde als de oude, negeer update van dit bericht!\n");
                    boolean dbXmlEquals = ber.getDbXml().equals(oud.getDbXml());
                    if (!dbXmlEquals) {
                        String s = String.format("Bericht %d met zelfde datum en volgnummer als eerder verwerkt bericht %d heeft andere db xml! Object ref %s", ber.getId(), oud.getId(), ber.getObjectRef());
                        log.warn((Object)s);
                        loadLog.append("Waarschuwing: ").append(s).append("\n");
                    }
                } else if (oud.getDatum().after(ber.getDatum())) {
                    newStatus = Bericht.STATUS.RSGB_OUTDATED;
                    loadLog.append("Bericht bevat oudere data dan eerder verwerkt bericht, status RSGB_OUTDATED\n");
                } else {
                    StringReader oReader = new StringReader(oud.getDbXml());
                    List<TableData> oudList = this.oldDbXmlReader.readDataXML(new StreamSource(oReader));
                    this.parseNewData(oudList, newList, dateFormat.format(oud.getDatum()), loadLog);
                    this.parseOldData(oudList, newList, dateFormat.format(ber.getDatum()), dateFormat.format(oud.getDatum()), loadLog);
                }
            } else {
                loadLog.append("Geen eerder bericht voor zelfde object gevonden!\n");
                this.parseNewData(null, newList, null, loadLog);
            }
            Split commit = SimonManager.getStopwatch((String)(this.simonNamePrefix + "commit")).start();
            this.connRsgb.commit();
            commit.stop();
            ber.setStatus(newStatus);
            ++this.processed;
            if (this.listener != null) {
                this.listener.progress(this.processed);
            }
            if (loadLog == null) {
                loadLog = new StringBuilder(ber.getOpmerking());
            }
            loadLog.append("\n\n");
        }
        catch (Throwable ex) {
            try {
                log.error((Object)("Fout bij verwerking bericht met id " + ber.getId()), ex);
                try {
                    this.connRsgb.rollback();
                }
                catch (SQLException e) {
                    log.debug((Object)"Rollback exception", (Throwable)e);
                }
                ber.setOpmerking(loadLog.toString());
                loadLog = null;
                this.updateBerichtException(ber, ex);
                if (loadLog == null) {
                    loadLog = new StringBuilder(ber.getOpmerking());
                }
                loadLog.append("\n\n");
            }
            catch (Throwable throwable) {
                if (loadLog == null) {
                    loadLog = new StringBuilder(ber.getOpmerking());
                }
                loadLog.append("\n\n");
                loadLog.append(String.format("%s: einde verwerking, duur: %4.1fs", dateTimeFormat.format(new java.util.Date()), (double)(System.currentTimeMillis() - startTime) / 1000.0));
                ber.setOpmerking(loadLog.toString());
                if (updateResult) {
                    this.updateProcessingResult(ber);
                }
                if (this.recentSavepoint != null) {
                    this.recentSavepoint = null;
                }
                throw throwable;
            }
            loadLog.append(String.format("%s: einde verwerking, duur: %4.1fs", dateTimeFormat.format(new java.util.Date()), (double)(System.currentTimeMillis() - startTime) / 1000.0));
            ber.setOpmerking(loadLog.toString());
            if (updateResult) {
                this.updateProcessingResult(ber);
            }
            if (this.recentSavepoint != null) {
                this.recentSavepoint = null;
            }
        }
        loadLog.append(String.format("%s: einde verwerking, duur: %4.1fs", dateTimeFormat.format(new java.util.Date()), (double)(System.currentTimeMillis() - startTime) / 1000.0));
        ber.setOpmerking(loadLog.toString());
        if (updateResult) {
            this.updateProcessingResult(ber);
        }
        if (this.recentSavepoint != null) {
            this.recentSavepoint = null;
        }
    }

    public void update(Bericht ber, List<TableData> pretransformedTableData) throws BrmoException {
        try {
            if (this.connRsgb.getAutoCommit()) {
                this.connRsgb.setAutoCommit(false);
            }
            List<TableData> newList = pretransformedTableData != null ? pretransformedTableData : this.transformUpdateTableData(ber);
            for (TableData newData : newList) {
                for (TableRow row : newData.getRows()) {
                    this.createUpdateSql(row, new StringBuilder());
                }
            }
            this.connRsgb.commit();
            ++this.processed;
            if (this.listener != null) {
                this.listener.progress(this.processed);
            }
        }
        catch (Throwable ex) {
            log.error((Object)("Fout bij updaten bericht met id " + ber.getId()), ex);
            try {
                this.connRsgb.rollback();
            }
            catch (SQLException e) {
                log.debug((Object)"Rollback exception", (Throwable)e);
            }
        }
    }

    private RsgbTransformer getTransformer(String brType) throws TransformerConfigurationException, ParserConfigurationException {
        RsgbTransformer t = this.rsgbTransformers.get(brType);
        if (t == null) {
            if (brType.equals("brk")) {
                t = new RsgbTransformer("/xsl/brk-snapshot-to-rsgb-xml.xsl");
            } else if (brType.equals("bag")) {
                t = new RsgbTransformer("/xsl/bag-mutatie-to-rsgb-xml.xsl");
            } else {
                throw new IllegalArgumentException("Onbekende basisregistratie: " + brType);
            }
            this.rsgbTransformers.put(brType, t);
        }
        return t;
    }

    private StringBuilder parseNewData(List<TableData> oldList, List<TableData> newList, String oldDate, StringBuilder loadLog) throws SQLException, ParseException, BrmoException {
        Split split = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata")).start();
        loadLog.append("\nVerwerk nieuw bericht");
        if (newList == null || newList.isEmpty()) {
            split.stop();
            return loadLog;
        }
        String lastExistingBrondocumentId = null;
        for (TableData newData : newList) {
            if (!newData.isComfortData()) {
                Split splitAuthentic = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic")).start();
                loadLog.append("\n");
                for (TableRow row : newData.getRows()) {
                    if (lastExistingBrondocumentId != null && "brondocument".equalsIgnoreCase(row.getTable()) && lastExistingBrondocumentId.equals(row.getColumnValue("tabel_identificatie"))) {
                        loadLog.append("\nOverslaan stukdeel voor stuk ").append(lastExistingBrondocumentId);
                        SimonManager.getCounter((String)(this.simonNamePrefix + "parsenewdata.authentic.skipstukdeel")).increase();
                        continue;
                    }
                    lastExistingBrondocumentId = null;
                    Split split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.getpk")).start();
                    List<String> pkColumns = this.getPrimaryKeys(row.getTable());
                    split2.stop();
                    boolean existsInOldList = this.doesRowExist(row, pkColumns, oldList);
                    split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.rowexistsindb")).start();
                    boolean doInsert = !this.rowExistsInDb(row, loadLog);
                    split2.stop();
                    if (doInsert) {
                        if (existsInOldList) {
                            loadLog.append("\nOud bericht bestaat, maar staat niet (meer) in database, daarom toevoeging van object aan tabel: ");
                        } else {
                            loadLog.append("\nNormale toevoeging van object aan tabel: ");
                        }
                        loadLog.append(row.getTable());
                        split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.insert")).start();
                        this.createInsertSql(row, false, loadLog);
                        split2.stop();
                        continue;
                    }
                    if ("brondocument".equalsIgnoreCase(row.getTable())) {
                        lastExistingBrondocumentId = row.getColumnValue("tabel_identificatie");
                        loadLog.append("\nRij voor stukdeel ").append(lastExistingBrondocumentId).append(" bestaat al, geen update");
                        continue;
                    }
                    if (existsInOldList) {
                        loadLog.append("\nUpdate einddatum in vorige versie object");
                        TableRow oldRow = this.getMatchingRowFromTableData(row, pkColumns, oldList);
                        String newBeginDate = this.getValueFromTableRow(row, row.getColumnDatumBeginGeldigheid());
                        this.updateValueInTableRow(oldRow, oldRow.getColumnDatumEindeGeldigheid(), newBeginDate);
                        loadLog.append("\nSchrijf vorige versie naar archief tabel");
                        oldRow.setIgnoreDuplicates(true);
                        if (oldRow.getTable().equals("kad_perceel") && !oldRow.getColumns().contains("sc_dat_beg_geldh")) {
                            oldRow.getColumns().add("sc_dat_beg_geldh");
                            oldRow.getValues().add(oldDate);
                        }
                        split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.archive")).start();
                        this.createInsertSql(oldRow, true, loadLog);
                        split2.stop();
                        loadLog.append("\nUpdate object in tabel: ");
                    } else {
                        loadLog.append("\nUpdate object (zonder vastlegging historie) in tabel: ");
                    }
                    loadLog.append(row.getTable());
                    split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.update." + row.getTable())).start();
                    this.createUpdateSql(row, loadLog);
                    split2.stop();
                }
                splitAuthentic.stop();
                continue;
            }
            Split splitComfort = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort")).start();
            String subclass = newData.getRows().get(newData.getRows().size() - 1).getTable();
            String tabel = newData.getComfortSearchTable();
            String kolom = newData.getComfortSearchColumn();
            String waarde = newData.getComfortSearchValue();
            String datum = newData.getComfortSnapshotDate();
            loadLog.append(String.format("\n\nComfort data voor %s (superclass: %s, %s=%s), controleer aanwezigheid in superclass tabel", subclass, tabel, kolom, waarde));
            Split split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort.exists")).start();
            boolean comfortFound = this.rowExistsInDb(newData.getRows().get(0), loadLog);
            split2.stop();
            for (TableRow row : newData.getRows()) {
                if (comfortFound) {
                    split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort.update")).start();
                    this.createUpdateSql(row, loadLog);
                    split2.stop();
                    continue;
                }
                split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort.insert")).start();
                this.createInsertSql(row, false, loadLog);
                split2.stop();
            }
            split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort.metadata")).start();
            this.createInsertMetadataSql(tabel, kolom, waarde, datum, loadLog);
            split2.stop();
            splitComfort.stop();
            loadLog.append("\n");
        }
        split.stop();
        return loadLog;
    }

    private StringBuilder parseOldData(List<TableData> oldList, List<TableData> newList, String newDate, String oldDate, StringBuilder loadLog) throws SQLException, ParseException {
        ArrayList<TableRow> rowsToDelete = new ArrayList<TableRow>();
        loadLog.append("\nControleren te verwijderen gegevens vorig bericht...\n");
        for (TableData oldData : oldList) {
            if (oldData.isComfortData()) continue;
            for (TableRow oldRow : oldData.getRows()) {
                List<String> pkColumns;
                boolean exists = this.doesRowExist(oldRow, pkColumns = this.getPrimaryKeys(oldRow.getTable()), newList);
                if (exists) continue;
                loadLog.append("Vervallen record te verwijderen: ").append(oldRow.toString(pkColumns)).append("\n");
                rowsToDelete.add(oldRow);
            }
        }
        if (!rowsToDelete.isEmpty()) {
            loadLog.append("Verwijder rijen in omgekeerde volgorde...\n");
            Collections.reverse(rowsToDelete);
            for (TableRow rowToDelete : rowsToDelete) {
                Split split = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parseolddata.delete")).start();
                this.createDeleteSql(rowToDelete, loadLog);
                split.stop();
                this.updateValueInTableRow(rowToDelete, rowToDelete.getColumnDatumEindeGeldigheid(), newDate);
                if (rowToDelete.getTable().equals("kad_perceel") && !rowToDelete.getColumns().contains("sc_dat_beg_geldh")) {
                    rowToDelete.getColumns().add("sc_dat_beg_geldh");
                    rowToDelete.getValues().add(oldDate);
                }
                split = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parseolddata.archive")).start();
                rowToDelete.setIgnoreDuplicates(true);
                this.createInsertSql(rowToDelete, true, loadLog);
                split.stop();
            }
        }
        return loadLog;
    }

    private String getValueFromTableRow(TableRow row, String column) {
        int i = 0;
        for (String c : row.getColumns()) {
            if (c.equalsIgnoreCase(column)) {
                return row.getValues().get(i);
            }
            ++i;
        }
        return null;
    }

    private void updateValueInTableRow(TableRow row, String column, String newValue) {
        int i = 0;
        for (String c : row.getColumns()) {
            if (c.equalsIgnoreCase(column)) {
                row.getValues().set(i, newValue);
                return;
            }
            ++i;
        }
    }

    private TableRow getMatchingRowFromTableData(TableRow row, List<String> pkColumns, List<TableData> testList) {
        TableRow newRow = null;
        for (TableData data : testList) {
            for (TableRow testRow : data.getRows()) {
                if (!row.getTable().equals(testRow.getTable())) continue;
                int matches = 0;
                for (String pkColumn : pkColumns) {
                    String testVal;
                    int rowIdx = row.getColumns().indexOf(pkColumn);
                    int testIdx = testRow.getColumns().indexOf(pkColumn);
                    String val = row.getValues().get(rowIdx);
                    if (!val.equals(testVal = testRow.getValues().get(testIdx))) continue;
                    ++matches;
                }
                if (matches != pkColumns.size()) continue;
                newRow = testRow;
            }
        }
        return newRow;
    }

    private boolean doesRowExist(TableRow row, List<String> pkColumns, List<TableData> testList) {
        boolean found = false;
        if (testList != null && testList.size() > 0) {
            for (TableData data : testList) {
                for (TableRow testRow : data.getRows()) {
                    if (!row.getTable().equals(testRow.getTable())) continue;
                    int matches = 0;
                    for (String pkColumn : pkColumns) {
                        String testVal;
                        int rowIdx = row.getColumns().indexOf(pkColumn);
                        int testIdx = testRow.getColumns().indexOf(pkColumn);
                        String val = row.getValues().get(rowIdx);
                        if (!val.equals(testVal = testRow.getValues().get(testIdx))) continue;
                        ++matches;
                    }
                    if (matches != pkColumns.size()) continue;
                    found = true;
                }
            }
        }
        return found;
    }

    private void createInsertSql(TableRow row, boolean useArchiveTable, StringBuilder loadLog) throws SQLException, ParseException {
        StringBuilder sql = new StringBuilder("insert into ");
        String tableName = !useArchiveTable ? row.getTable() : row.getTable() + "_archief";
        sql.append(tableName);
        SortedSet<ColumnMetadata> tableColumnMetadata = null;
        tableColumnMetadata = this.getTableColumnMetadata(tableName);
        if (tableColumnMetadata == null) {
            if (useArchiveTable) {
                return;
            }
            throw new IllegalStateException("Kan tabel metadata niet vinden voor tabel " + tableName);
        }
        sql.append(" (");
        StringBuilder valuesSql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        Iterator<String> valuesIt = row.getValues().iterator();
        Iterator<String> it = row.getColumns().iterator();
        while (it.hasNext()) {
            String column = it.next();
            String stringValue = valuesIt.next();
            if (row.isAlleenArchiefColumn(column) && !useArchiveTable) continue;
            ColumnMetadata cm = this.findColumnMetadata(tableColumnMetadata, column);
            Object param = this.getValueAsObject(tableName, column, stringValue, cm);
            params.add(param);
            sql.append(cm.getName());
            String insertValuePlaceholder = "?";
            if (cm.getTypeName().equals(this.geomToJdbc.getGeomTypeName())) {
                insertValuePlaceholder = this.geomToJdbc.createPSGeometryPlaceholder();
            }
            valuesSql.append(insertValuePlaceholder);
            if (!it.hasNext()) continue;
            sql.append(", ");
            valuesSql.append(", ");
        }
        boolean conditionalInsert = row.isIgnoreDuplicates();
        if (!conditionalInsert) {
            sql.append(") values (");
            sql.append((CharSequence)valuesSql);
            sql.append(")");
        } else {
            sql.append(") select ");
            sql.append((CharSequence)valuesSql);
            if (this.geomToJdbc instanceof OracleJdbcConverter) {
                sql.append(" from dual");
            }
            sql.append(" where not exists (select 1 from ");
            sql.append(tableName);
            sql.append(" where ");
            boolean first = true;
            for (String column : this.getPrimaryKeys(tableName)) {
                if (first) {
                    first = false;
                } else {
                    sql.append(" and ");
                }
                sql.append(column);
                sql.append(" = ? ");
                String val = this.getValueFromTableRow(row, column);
                Object obj = this.getValueAsObject(tableName, column, val, null);
                params.add(obj);
            }
            sql.append(")");
        }
        PreparedStatement stm = this.insertSqlPreparedStatements.get(sql.toString());
        if (stm == null || stm.isClosed()) {
            SimonManager.getCounter((String)"b3p.rsgb.insertsql.preparestatement").increase();
            stm = this.connRsgb.prepareStatement(sql.toString());
            this.insertSqlPreparedStatements.put(sql.toString(), stm);
        } else {
            SimonManager.getCounter((String)"b3p.rsgb.insertsql.reusestatement").increase();
            stm.clearParameters();
        }
        loadLog.append("\nSQL: ");
        loadLog.append((CharSequence)sql);
        loadLog.append(", params (");
        loadLog.append(((Object)params).toString());
        loadLog.append(")");
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            stm.setObject(i + 1, param);
        }
        int count = -1;
        try {
            count = stm.executeUpdate();
        }
        catch (SQLException e) {
            String message = e.getMessage();
            if (this.geomToJdbc.isDuplicateKeyViolationMessage(message)) {
                if (row.isIgnoreDuplicates() && this.recentSavepoint != null) {
                    log.debug((Object)("Ignoring duplicate key violation by rolling back to savepoint with id " + this.recentSavepoint.getSavepointId()));
                    this.connRsgb.rollback(this.recentSavepoint);
                }
            }
            throw e;
        }
        loadLog.append("\nAantal toegevoegde records: " + count);
    }

    private void createUpdateSql(TableRow row, StringBuilder loadLog) throws SQLException, ParseException {
        StringBuilder sql = new StringBuilder("update ");
        String tableName = row.getTable();
        sql.append(tableName);
        SortedSet<ColumnMetadata> tableColumnMetadata = null;
        tableColumnMetadata = this.getTableColumnMetadata(tableName);
        if (tableColumnMetadata == null) {
            throw new IllegalStateException("Kan tabel metadata niet vinden voor tabel " + tableName);
        }
        sql.append(" set ");
        ArrayList<Object> params = new ArrayList<Object>();
        Iterator<String> valuesIt = row.getValues().iterator();
        Iterator<String> it = row.getColumns().iterator();
        while (it.hasNext()) {
            String column = it.next();
            String stringValue = valuesIt.next();
            if (row.isAlleenArchiefColumn(column)) continue;
            ColumnMetadata cm = this.findColumnMetadata(tableColumnMetadata, column);
            Object param = this.getValueAsObject(tableName, column, stringValue, cm);
            params.add(param);
            sql.append(cm.getName());
            sql.append(" = ");
            String insertValuePlaceholder = "?";
            if (cm.getTypeName().equals(this.geomToJdbc.getGeomTypeName())) {
                insertValuePlaceholder = this.geomToJdbc.createPSGeometryPlaceholder();
            }
            sql.append(insertValuePlaceholder);
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(" where ");
        boolean first = true;
        for (String column : this.getPrimaryKeys(tableName)) {
            if (first) {
                first = false;
            } else {
                sql.append(" and ");
            }
            sql.append(column);
            sql.append(" = ? ");
            String val = this.getValueFromTableRow(row, column);
            Object obj = this.getValueAsObject(tableName, column, val, null);
            params.add(obj);
        }
        PreparedStatement stm = this.updateSqlPreparedStatements.get(sql.toString());
        if (stm == null || stm.isClosed()) {
            SimonManager.getCounter((String)"b3p.rsgb.updatesql.preparestatement").increase();
            stm = this.connRsgb.prepareStatement(sql.toString());
            this.updateSqlPreparedStatements.put(sql.toString(), stm);
        } else {
            SimonManager.getCounter((String)"b3p.rsgb.updatesql.reusestatement").increase();
            stm.clearParameters();
        }
        loadLog.append("\nSQL: ");
        loadLog.append((CharSequence)sql);
        loadLog.append(", params (");
        loadLog.append(((Object)params).toString());
        loadLog.append(")");
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            stm.setObject(i + 1, param);
        }
        int count = stm.executeUpdate();
        loadLog.append("\nAantal record updates: " + count);
    }

    private boolean createInsertMetadataSql(String tabel, String kolom, String waarde, String datum, StringBuilder loadLog) throws SQLException, ParseException {
        if (this.insertMetadataStatement == null) {
            StringBuilder sql = new StringBuilder("insert into herkomst_metadata (tabel, kolom, waarde, herkomst_br, datum) ").append("select ?, ?, ?, ?, ? ").append(this.geomToJdbc instanceof OracleJdbcConverter ? "from dual" : "").append(" where not exists (").append("  select 1 from herkomst_metadata where tabel = ? and kolom = ? and waarde = ? and herkomst_br = ? and datum = ?").append(")");
            this.insertMetadataStatement = this.connRsgb.prepareStatement(sql.toString());
        } else {
            this.insertMetadataStatement.clearParameters();
        }
        Date date = null;
        Calendar calendar = DatatypeConverter.parseDateTime((String)datum);
        if (calendar != null) {
            Calendar cal = calendar;
            date = new Date(cal.getTimeInMillis());
        }
        this.insertMetadataStatement.setString(1, tabel);
        this.insertMetadataStatement.setString(2, kolom);
        this.insertMetadataStatement.setString(3, waarde);
        this.insertMetadataStatement.setString(4, this.getHerkomstMetadata());
        this.insertMetadataStatement.setObject(5, date);
        this.insertMetadataStatement.setString(6, tabel);
        this.insertMetadataStatement.setString(7, kolom);
        this.insertMetadataStatement.setString(8, waarde);
        this.insertMetadataStatement.setString(9, this.getHerkomstMetadata());
        this.insertMetadataStatement.setObject(10, date);
        loadLog.append(String.format("\nConditioneel toevoegen herkomst metadata tabel=%s, kolom=%s, waarde=%s, herkomst_br=%s, datum=%s", tabel, kolom, waarde, this.getHerkomstMetadata(), datum));
        int count = this.insertMetadataStatement.executeUpdate();
        loadLog.append(": record geinsert: ").append(count > 0 ? "ja" : "nee (rij bestond al)");
        return count > 0;
    }

    private boolean rowExistsInDb(TableRow row, StringBuilder loadLog) throws SQLException, ParseException {
        String tableName = row.getTable();
        List<String> pkColumns = this.getPrimaryKeys(tableName);
        ArrayList<Object> params = new ArrayList<Object>();
        for (String column : pkColumns) {
            String val = this.getValueFromTableRow(row, column);
            Object object = this.getValueAsObject(row.getTable(), column, val, null);
            params.add(object);
        }
        loadLog.append("\nControleer ").append(tableName).append(" op primary key: ").append(((Object)params).toString());
        PreparedStatement stm = this.checkRowExistsStatements.get(tableName);
        if (stm == null) {
            StringBuilder sql = new StringBuilder("select 1 from ").append(tableName);
            boolean first = true;
            for (String column : pkColumns) {
                if (first) {
                    sql.append(" where ").append(column).append(" = ?");
                    first = false;
                    continue;
                }
                sql.append(" and ").append(column).append(" = ?");
            }
            stm = this.connRsgb.prepareStatement(sql.toString(), 1004, 1007);
            this.checkRowExistsStatements.put(tableName, stm);
        } else {
            stm.clearParameters();
        }
        int i = 1;
        for (Object e : params) {
            stm.setObject(i++, e);
        }
        ResultSet rs = stm.executeQuery();
        boolean bl = rs.next();
        rs.close();
        loadLog.append(", rij bestaat: ").append(bl ? "ja" : "nee");
        return bl;
    }

    private TableRow getTableRowFromDb(TableRow row, StringBuilder loadLog) throws SQLException, ParseException {
        String tableName = row.getTable();
        List<String> pkColumns = this.getPrimaryKeys(tableName);
        ArrayList<Object> params = new ArrayList<Object>();
        for (String column : pkColumns) {
            String val = this.getValueFromTableRow(row, column);
            Object object = this.getValueAsObject(row.getTable(), column, val, null);
            params.add(object);
        }
        loadLog.append("\nControleer ").append(tableName).append(" op primary key: ").append(((Object)params).toString());
        PreparedStatement stm = this.checkRowExistsStatements.get(tableName);
        if (stm == null) {
            StringBuilder sql = new StringBuilder("select * from ").append(tableName);
            boolean first = true;
            for (String column : pkColumns) {
                if (first) {
                    sql.append(" where ").append(column).append(" = ?");
                    first = false;
                    continue;
                }
                sql.append(" and ").append(column).append(" = ?");
            }
            stm = this.connRsgb.prepareStatement(sql.toString(), 1004, 1007);
            this.checkRowExistsStatements.put(tableName, stm);
        } else {
            stm.clearParameters();
        }
        int i = 1;
        for (Object e : params) {
            stm.setObject(i++, e);
        }
        ResultSet rs = stm.executeQuery();
        boolean bl = rs.next();
        TableRow existing = null;
        if (bl) {
            existing = new TableRow();
            existing.setTable(tableName);
            for (ColumnMetadata columnMd : this.getTableColumnMetadata(row.getTable())) {
                existing.getColumns().add(columnMd.getName());
                existing.getValues().add(this.getValueAsString(columnMd, rs.getObject(columnMd.getName())));
            }
        }
        rs.close();
        loadLog.append(", rij bestaat: ").append(bl ? "ja" : "nee");
        return existing;
    }

    public boolean isAlreadyInMetadata(TableRow row, StringBuilder loadLog) throws SQLException, ParseException, BrmoException {
        if (this.connRsgb == null || this.connRsgb.isClosed()) {
            throw new BrmoException("No connection found");
        }
        StringBuilder sql = new StringBuilder("select 1 from ");
        String metadataTable = "herkomst_metadata";
        sql.append(metadataTable);
        String tableName = row.getTable();
        sql.append(" WHERE tabel = ?");
        ArrayList<String> params = new ArrayList<String>();
        params.add(tableName);
        List<String> pkColumns = this.getPrimaryKeys(tableName);
        String waarde = null;
        for (String column : pkColumns) {
            sql.append(" AND kolom = ?");
            params.add(column);
            waarde = this.getValueFromTableRow(row, column);
        }
        if (waarde != null) {
            sql.append(" AND waarde = ?");
            params.add(waarde);
        }
        PreparedStatement stm = this.getPreparedStatement(row, sql.toString(), params, null, loadLog);
        ResultSet results = stm.executeQuery();
        int count = this.getRowCount(results);
        DbUtils.closeQuietly((ResultSet)results);
        return count > 0;
    }

    private boolean deleteFromMetadata(TableRow row, StringBuilder loadLog) throws SQLException, ParseException {
        StringBuilder sql = new StringBuilder("delete from ");
        String metadataTable = "herkomst_metadata";
        sql.append(metadataTable);
        String tableName = row.getTable();
        sql.append(" WHERE tabel = ?");
        ArrayList<String> params = new ArrayList<String>();
        params.add(tableName);
        List<String> pkColumns = this.getPrimaryKeys(tableName);
        String waarde = null;
        for (String column : pkColumns) {
            sql.append(" AND kolom = ?");
            params.add(column);
            waarde = this.getValueFromTableRow(row, column);
        }
        if (waarde != null) {
            sql.append(" AND waarde = ?");
            params.add(waarde);
        }
        PreparedStatement stm = this.getPreparedStatement(row, sql.toString(), params, null, loadLog);
        int count = 1;
        count = stm.executeUpdate();
        return count > 0;
    }

    private boolean createDeleteSql(TableRow row, StringBuilder loadLog) throws SQLException, ParseException {
        this.doSavePoint(row);
        StringBuilder sql = new StringBuilder("delete from ");
        String tableName = row.getTable();
        sql.append(tableName);
        SortedSet<ColumnMetadata> tableColumnMetadata = null;
        tableColumnMetadata = this.getTableColumnMetadata(tableName);
        List<String> pkColumns = this.getPrimaryKeys(tableName);
        int i = 0;
        for (String column : pkColumns) {
            if (i < 1) {
                sql.append(" WHERE " + column + " = ?");
            } else {
                sql.append(" AND " + column + " = ?");
            }
            ++i;
        }
        PreparedStatement stm = this.getPreparedStatement(row, sql.toString(), null, pkColumns, loadLog);
        int count = 1;
        count = stm.executeUpdate();
        return count > 0;
    }

    private List<String> getPrimaryKeys(String tableName) throws SQLException {
        List<String> pks = this.primaryKeyCache.get(tableName);
        if (pks != null) {
            return pks;
        }
        pks = new ArrayList<String>();
        String origName = this.tables.get(tableName);
        ResultSet set = this.dbMetadata.getPrimaryKeys(null, this.geomToJdbc.getSchema(), origName);
        while (set.next()) {
            String column = set.getString("COLUMN_NAME");
            pks.add(column.toLowerCase());
        }
        set.close();
        this.primaryKeyCache.put(tableName, pks);
        return pks;
    }

    private SortedSet<ColumnMetadata> getTableColumnMetadata(String table) throws SQLException {
        if (!this.tables.containsKey(table = table.toLowerCase())) {
            return null;
        }
        SortedSet<ColumnMetadata> columnMetadata = this.tableColumns.get(table);
        if (columnMetadata == null) {
            columnMetadata = new TreeSet<ColumnMetadata>();
            this.tableColumns.put(table, columnMetadata);
            ResultSet columnsRs = this.dbMetadata.getColumns(null, this.geomToJdbc.getSchema(), this.tables.get(table), "%");
            while (columnsRs.next()) {
                ColumnMetadata cm = new ColumnMetadata(columnsRs);
                columnMetadata.add(cm);
            }
            columnsRs.close();
        }
        return columnMetadata;
    }

    private ColumnMetadata findColumnMetadata(SortedSet<ColumnMetadata> tableColumnMetadata, String columnName) {
        if (tableColumnMetadata == null || tableColumnMetadata.size() < 1) {
            return null;
        }
        for (ColumnMetadata cm : tableColumnMetadata) {
            if (!cm.getName().toLowerCase().equals(columnName.toLowerCase())) continue;
            return cm;
        }
        return null;
    }

    public String getHerkomstMetadata() {
        return this.herkomstMetadata;
    }

    public void setHerkomstMetadata(String herkomstMetadata) {
        this.herkomstMetadata = herkomstMetadata;
    }

    private void doSavePoint(TableRow row) throws SQLException {
        if (this.geomToJdbc.useSavepoints()) {
            if (row.isIgnoreDuplicates()) {
                if (this.recentSavepoint == null) {
                    this.recentSavepoint = this.connRsgb.setSavepoint();
                    log.debug((Object)("Created savepoint with id: " + this.recentSavepoint.getSavepointId()));
                } else {
                    log.debug((Object)("No need for new savepoint, previous insert caused rollback to recent savepoint with id " + this.recentSavepoint.getSavepointId()));
                }
            } else if (this.recentSavepoint != null) {
                log.debug((Object)("About to insert non-recoverable row, discarding savepoint with id " + this.recentSavepoint.getSavepointId()));
                this.connRsgb.releaseSavepoint(this.recentSavepoint);
                this.recentSavepoint = null;
            }
        }
    }

    private PreparedStatement getPreparedStatement(TableRow row, String sql, List params, List<String> pkColumns, StringBuilder loadLog) throws SQLException, ParseException {
        loadLog.append("\nSQL: ");
        loadLog.append(sql);
        loadLog.append(", params (");
        loadLog.append(params == null ? "" : params.toString());
        loadLog.append(")");
        loadLog.append(", duplikaat negeren (");
        loadLog.append(row.isIgnoreDuplicates() ? "ja" : "nee");
        loadLog.append(")");
        PreparedStatement stmt = null;
        stmt = sql.contains("select") ? this.connRsgb.prepareStatement(sql, 1004, 1007) : this.connRsgb.prepareStatement(sql);
        int counter = 0;
        if (params != null && params.size() > 0) {
            for (int i = 0; i < params.size(); ++i) {
                Object param = params.get(i);
                stmt.setObject(i + 1, param);
                counter = i + 1;
            }
        }
        if (pkColumns != null && pkColumns.size() > 0) {
            loadLog.append(", pkeys (");
            for (String column : pkColumns) {
                loadLog.append("[");
                loadLog.append(column);
                loadLog.append("=");
                String val = this.getValueFromTableRow(row, column);
                Object obj = this.getValueAsObject(row.getTable(), column, val, null);
                loadLog.append(obj == null ? "" : obj.toString());
                loadLog.append("] ");
                stmt.setObject(counter + 1, obj);
                ++counter;
            }
            loadLog.append(")");
        }
        return stmt;
    }

    private Object getValueAsObject(String tableName, String column, String value, ColumnMetadata cm) throws SQLException, ParseException {
        if (cm == null) {
            SortedSet<ColumnMetadata> tableColumnMetadata = null;
            tableColumnMetadata = this.getTableColumnMetadata(tableName);
            cm = this.findColumnMetadata(tableColumnMetadata, column);
        }
        Object param = null;
        if (cm == null) {
            throw new IllegalArgumentException("Column not found: " + column + " in table " + tableName);
        }
        if (cm.getTypeName().equals(this.geomToJdbc.getGeomTypeName())) {
            param = this.geomToJdbc.convertToNativeGeometryObject(value);
        } else if (value != null) {
            param = GeometryJdbcConverter.convertToSQLObject(value, cm, tableName, column);
        }
        return param;
    }

    private String getValueAsString(ColumnMetadata cm, Object object) throws SQLException {
        String value = null;
        if (object != null) {
            switch (cm.getDataType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 12: {
                    value = object.toString();
                    break;
                }
                case 91: 
                case 93: 
                case 1111: 
                case 2002: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Data type %s (#%d) of column \"%s\" not supported", cm.getTypeName(), cm.getDataType(), cm.getName()));
                }
            }
        }
        return value;
    }

    private int getRowCount(ResultSet rs) throws SQLException {
        int size = 0;
        try {
            if (rs != null && rs.next()) {
                size = rs.getInt(1);
            }
        }
        catch (SQLException ex) {
            throw new SQLException("Fout ophalen row count: ", ex);
        }
        return size;
    }

    private static enum STATEMENT_TYPE {
        INSERT,
        UPDATE,
        SELECT,
        DELETE;

    }

    public static enum BerichtSelectMode {
        BY_STATUS,
        BY_IDS,
        BY_LAADPROCES,
        FOR_UPDATE;

    }
}

