/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.WKTReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;
import nl.b3p.brmo.loader.jdbc.ColumnMetadata;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.brmo.loader.util.TableRow;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.jts.JTSFactoryFinder;

public class TableRowInserter {
    private static final Log log = LogFactory.getLog(TableRowInserter.class);
    private final GeometryJdbcConverter geomToJdbc;
    private final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    private final Connection c;
    private final String schema;
    private final boolean useSavepoints;
    private Savepoint recentSavepoint = null;
    private final DatabaseMetaData dbMetadata;
    private final Map<String, String> tables = new HashMap<String, String>();
    private final Map<String, SortedSet<ColumnMetadata>> tableColumns = new HashMap<String, SortedSet<ColumnMetadata>>();

    public TableRowInserter(Connection c, GeometryJdbcConverter geomToJdbc, boolean useSavepoints, String schema) throws SQLException {
        this.c = c;
        this.geomToJdbc = geomToJdbc;
        this.schema = schema;
        this.useSavepoints = useSavepoints;
        this.dbMetadata = c.getMetaData();
        this.dbMetadata.getDatabaseProductName();
        log.debug((Object)String.format("Database metadata: product %s, version %s, driver %s, version %s", this.dbMetadata.getDatabaseProductName(), this.dbMetadata.getDatabaseProductVersion(), this.dbMetadata.getDriverName(), this.dbMetadata.getDriverVersion()));
        ResultSet tablesRs = this.dbMetadata.getTables("", schema, "%", new String[]{"TABLE"});
        while (tablesRs.next()) {
            this.tables.put(tablesRs.getString("TABLE_NAME").toLowerCase(), tablesRs.getString("TABLE_NAME"));
        }
        tablesRs.close();
        log.debug((Object)String.format("Tables found for schema %s: %d, list: %s", schema, this.tables.size(), this.tables.toString()));
    }

    public void insertRows(List<TableRow> rows) throws Exception {
        if (this.c.getAutoCommit()) {
            this.c.setAutoCommit(false);
        }
        for (TableRow row : rows) {
            try {
                this.insertRow(row);
            }
            catch (Exception e) {
                try {
                    this.c.rollback();
                }
                catch (SQLException rbe) {
                    log.error((Object)"Error rolling back transaction", (Throwable)rbe);
                }
                throw new Exception(String.format("Error inserting row into %s (%s) values (%s)", row.getTable(), row.getColumns().toString(), row.getValues().toString()), e);
            }
        }
        if (this.recentSavepoint != null) {
            this.c.releaseSavepoint(this.recentSavepoint);
        }
        this.c.commit();
    }

    private SortedSet<ColumnMetadata> getTableColumnMetadata(String table) throws SQLException {
        if (!this.tables.containsKey(table = table.toLowerCase())) {
            throw new IllegalArgumentException("Table does not exist in schema " + this.schema + ": " + table);
        }
        log.debug((Object)("Getting column metadata for table " + table));
        SortedSet<ColumnMetadata> columnMetadata = this.tableColumns.get(table);
        if (columnMetadata == null) {
            columnMetadata = new TreeSet<ColumnMetadata>();
            this.tableColumns.put(table, columnMetadata);
            ResultSet columnsRs = this.dbMetadata.getColumns(null, this.schema, this.tables.get(table), "%");
            while (columnsRs.next()) {
                ColumnMetadata cm = new ColumnMetadata(columnsRs);
                columnMetadata.add(cm);
            }
            for (ColumnMetadata cm : columnMetadata) {
                log.debug((Object)("  " + cm.toStringFixedWidth(columnMetadata)));
            }
            columnsRs.close();
        }
        return columnMetadata;
    }

    private ColumnMetadata findColumnMetadata(SortedSet<ColumnMetadata> tableColumnMetadata, String columnName) {
        for (ColumnMetadata cm : tableColumnMetadata) {
            if (!cm.getName().toLowerCase().equals(columnName.toLowerCase())) continue;
            return cm;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertRow(TableRow row) throws Exception {
        if (this.useSavepoints) {
            if (row.isIgnoreDuplicates()) {
                if (this.recentSavepoint == null) {
                    this.recentSavepoint = this.c.setSavepoint();
                    log.debug((Object)("Created savepoint with id: " + this.recentSavepoint.getSavepointId()));
                } else {
                    log.debug((Object)("No need for new savepoint, previous insert caused rollback to recent savepoint with id " + this.recentSavepoint.getSavepointId()));
                }
            } else if (this.recentSavepoint != null) {
                log.debug((Object)("About to insert non-recoverable row, discarding savepoint with id " + this.recentSavepoint.getSavepointId()));
                this.c.releaseSavepoint(this.recentSavepoint);
                this.recentSavepoint = null;
            }
        }
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(row.getTable());
        SortedSet<ColumnMetadata> tableColumnMetadata = this.getTableColumnMetadata(row.getTable());
        sql.append(" (");
        StringBuilder valuesSql = new StringBuilder(") values (");
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<Boolean> isGeometry = new ArrayList<Boolean>();
        Iterator<String> valuesIt = row.getValues().iterator();
        Iterator<String> it = row.getColumns().iterator();
        while (it.hasNext()) {
            Object param;
            boolean isThisGeometry;
            String insertValueSql;
            ColumnMetadata cm;
            block29: {
                block28: {
                    String column = it.next();
                    String stringValue = valuesIt.next();
                    cm = this.findColumnMetadata(tableColumnMetadata, column);
                    if (cm == null) {
                        throw new IllegalArgumentException("Column not found: " + column + " in table " + row.getTable());
                    }
                    insertValueSql = "?";
                    isThisGeometry = false;
                    param = null;
                    if (stringValue == null) break block28;
                    stringValue = stringValue.trim();
                    switch (cm.getDataType()) {
                        case 2: 
                        case 3: 
                        case 4: {
                            try {
                                param = new BigDecimal(stringValue);
                            }
                            catch (NumberFormatException nfe) {
                                log.error((Object)String.format("Cannot convert value \"%s\" to type %s for %s.%s", stringValue, cm.getTypeName(), row.getTable(), cm.getName()));
                            }
                            break block29;
                        }
                        case 1: 
                        case 12: {
                            param = stringValue;
                            break block29;
                        }
                        case 1111: {
                            if (!cm.getTypeName().equals("SDO_GEOMETRY") && !cm.getTypeName().equals("geometry")) throw new IllegalStateException(String.format("Column \"%s\" (value to insert \"%s\") type other but not geometry!", column, param));
                            param = stringValue;
                            isThisGeometry = true;
                            break block29;
                        }
                        case 91: 
                        case 93: {
                            param = DatatypeConverter.parseDateTime((String)stringValue);
                            if (param != null) {
                                Calendar cal = (Calendar)param;
                                param = new Date(cal.getTimeInMillis());
                            }
                            break block29;
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("Data type %s (#%d) of column \"%s\" not supported", cm.getTypeName(), cm.getDataType(), column));
                        }
                    }
                }
                isThisGeometry = cm.getTypeName().equals("SDO_GEOMETRY");
            }
            params.add((String)param);
            isGeometry.add(isThisGeometry);
            sql.append(cm.getName());
            valuesSql.append(insertValueSql);
            if (!it.hasNext()) continue;
            sql.append(", ");
            valuesSql.append(", ");
        }
        sql.append((CharSequence)valuesSql);
        sql.append(")");
        log.debug((Object)("SQL: " + sql));
        PreparedStatement stmt = null;
        try {
            stmt = this.c.prepareStatement(sql.toString());
            for (int i = 0; i < params.size(); ++i) {
                Object param = params.get(i);
                if (Boolean.TRUE.equals(isGeometry.get(i))) {
                    if (this.geomToJdbc.convertsGeometryInsteadOfWkt()) {
                        WKTReader reader = new WKTReader(this.geometryFactory);
                        Geometry geom = param == null || ((String)param).trim().length() == 0 ? null : reader.read((String)param);
                        stmt.setObject(i + 1, this.geomToJdbc.convertGeometry(geom));
                        continue;
                    }
                    stmt.setObject(i + 1, this.geomToJdbc.convertWkt((String)param));
                    continue;
                }
                stmt.setObject(i + 1, param);
            }
            stmt.executeUpdate();
            if (this.recentSavepoint != null) {
                log.debug((Object)("Releasing savepoint with id " + this.recentSavepoint.getSavepointId()));
                this.c.releaseSavepoint(this.recentSavepoint);
                this.recentSavepoint = null;
            }
        }
        catch (Exception e) {
            block26: {
                block27: {
                    try {
                        String message;
                        if (!(e instanceof SQLException) || !(message = ((SQLException)e).getMessage()).startsWith("ORA-00001:") && !message.startsWith("ERROR: duplicate key value violates unique constraint") || !row.isIgnoreDuplicates()) break block26;
                        if (this.recentSavepoint == null) break block27;
                        log.debug((Object)("Rolling back to savepoint with id " + this.recentSavepoint.getSavepointId()));
                        this.c.rollback(this.recentSavepoint);
                    }
                    catch (Throwable throwable) {
                        DbUtils.closeQuietly(stmt);
                        throw throwable;
                    }
                }
                DbUtils.closeQuietly((Statement)stmt);
                return;
            }
            log.error((Object)("Error executing statement: " + sql));
            log.error((Object)("                   params: " + ((Object)params).toString()));
            log.error((Object)("        ignore duplicates: " + row.isIgnoreDuplicates()));
            throw e;
        }
        DbUtils.closeQuietly((Statement)stmt);
    }
}

