/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.RsgbProxy;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.brmo.loader.updates.UpdateProcess;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.RsgbTransformer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrmoFramework {
    private static final Log log = LogFactory.getLog(BrmoFramework.class);
    public static final String BR_BAG = "bag";
    public static final String BR_BRK = "brk";
    public static final String XSL_BRK = "/xsl/brk-snapshot-to-rsgb-xml.xsl";
    public static final String XSL_BAG = "/xsl/bag-mutatie-to-rsgb-xml.xsl";
    public static final String LAADPROCES_TABEL = "laadproces";
    public static final String BERICHT_TABLE = "bericht";
    private StagingProxy stagingProxy = null;
    private DataSource dataSourceRsgb = null;
    private boolean enablePipeline = false;
    private Integer pipelineCapacity;
    private boolean orderBerichten = true;

    public BrmoFramework(DataSource dataSourceStaging, DataSource dataSourceRsgb) throws BrmoException {
        if (dataSourceStaging != null) {
            try {
                this.stagingProxy = new StagingProxy(dataSourceStaging);
            }
            catch (SQLException ex) {
                throw new BrmoException(ex);
            }
        }
        this.dataSourceRsgb = dataSourceRsgb;
    }

    public void setEnablePipeline(boolean enablePipeline) {
        this.enablePipeline = enablePipeline;
    }

    public void setTransformPipelineCapacity(int pipelineCapacity) {
        this.pipelineCapacity = pipelineCapacity;
    }

    public void setOrderBerichten(boolean orderBerichten) {
        this.orderBerichten = orderBerichten;
    }

    public void closeBrmoFramework() {
        if (this.stagingProxy != null) {
            this.stagingProxy.closeStagingProxy();
        }
    }

    public Thread toRsgb() throws BrmoException {
        return this.toRsgb(null);
    }

    public Thread toRsgb(ProgressUpdateListener listener) throws BrmoException {
        return this.toRsgb(Bericht.STATUS.STAGING_OK, listener);
    }

    public Thread toRsgb(Bericht.STATUS status, ProgressUpdateListener listener) throws BrmoException {
        RsgbProxy rsgbProxy = new RsgbProxy(this.dataSourceRsgb, this.stagingProxy, status, listener);
        rsgbProxy.setEnablePipeline(this.enablePipeline);
        if (this.pipelineCapacity != null) {
            rsgbProxy.setPipelineCapacity(this.pipelineCapacity);
        }
        rsgbProxy.setOrderBerichten(this.orderBerichten);
        Thread t = new Thread(rsgbProxy);
        t.start();
        return t;
    }

    public Thread toRsgb(RsgbProxy.BerichtSelectMode mode, long[] ids, ProgressUpdateListener listener) throws BrmoException {
        RsgbProxy rsgbProxy = new RsgbProxy(this.dataSourceRsgb, this.stagingProxy, mode, ids, listener);
        rsgbProxy.setEnablePipeline(this.enablePipeline);
        if (this.pipelineCapacity != null) {
            rsgbProxy.setPipelineCapacity(this.pipelineCapacity);
        }
        rsgbProxy.setOrderBerichten(this.orderBerichten);
        Thread t = new Thread(rsgbProxy);
        t.start();
        return t;
    }

    public Thread toRsgb(UpdateProcess updateProcess, ProgressUpdateListener listener) throws BrmoException {
        RsgbProxy rsgbProxy = new RsgbProxy(this.dataSourceRsgb, this.stagingProxy, updateProcess, listener);
        rsgbProxy.setEnablePipeline(this.enablePipeline);
        if (this.pipelineCapacity != null) {
            rsgbProxy.setPipelineCapacity(this.pipelineCapacity);
        }
        rsgbProxy.setOrderBerichten(this.orderBerichten);
        Thread t = new Thread(rsgbProxy);
        t.start();
        return t;
    }

    public void delete(Long id) throws BrmoException {
        if (id != null) {
            try {
                this.stagingProxy.deleteByLaadProcesId(id);
            }
            catch (SQLException ex) {
                throw new BrmoException(ex);
            }
        }
    }

    public List<LaadProces> listLaadProcessen() throws BrmoException {
        try {
            return this.stagingProxy.getLaadProcessen();
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public List<Bericht> listBerichten() throws BrmoException {
        try {
            return this.stagingProxy.getBerichten();
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public void loadFromFile(String type, String fileName) throws BrmoException {
        try {
            this.loadFromFile(type, fileName, null);
        }
        catch (Exception e) {
            if (e instanceof BrmoException) {
                throw (BrmoException)e;
            }
            throw new BrmoException("Fout bij loaden basisregistratie gegevens", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(String type, String fileName, final ProgressUpdateListener listener) throws BrmoException {
        block15: {
            try {
                if (fileName.toLowerCase().endsWith(".zip")) {
                    log.info((Object)("Openen ZIP bestand " + fileName));
                    try (ZipInputStream zip = null;){
                        File f = new File(fileName);
                        if (listener != null) {
                            listener.total(f.length());
                        }
                        CountingInputStream zipCis = new CountingInputStream(new FileInputStream(f)){

                            protected void afterRead(int n) {
                                super.afterRead(n);
                                if (listener != null) {
                                    listener.progress(this.getByteCount());
                                }
                            }
                        };
                        zip = new ZipInputStream((InputStream)zipCis);
                        ZipEntry entry = zip.getNextEntry();
                        while (entry != null) {
                            if (!entry.getName().toLowerCase().endsWith(".xml")) {
                                log.warn((Object)("Overslaan zip entry geen XML: " + entry.getName()));
                            } else {
                                log.info((Object)("Lezen XML bestand uit zip: " + entry.getName()));
                                this.stagingProxy.loadBr((InputStream)new CloseShieldInputStream((InputStream)zip), type, fileName + "/" + entry.getName(), null);
                            }
                            entry = zip.getNextEntry();
                        }
                        break block15;
                    }
                }
                File f = new File(fileName);
                if (listener != null) {
                    listener.total(f.length());
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(fileName);
                    this.stagingProxy.loadBr(fis, type, fileName, listener);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            catch (Exception e) {
                if (e instanceof BrmoException) {
                    throw (BrmoException)e;
                }
                throw new BrmoException("Fout bij loaden basisregistratie gegevens", e);
            }
        }
    }

    public void loadFromStream(String type, InputStream stream, String fileName) throws BrmoException {
        try {
            this.stagingProxy.loadBr(stream, type, fileName, null);
        }
        catch (Exception e) {
            throw new BrmoException("Fout bij loaden basisregistratie gegevens", e);
        }
    }

    public void loadFromStream(String type, InputStream stream, String fileName, ProgressUpdateListener listener) throws BrmoException {
        try {
            this.stagingProxy.loadBr(stream, type, fileName, listener);
        }
        catch (Exception e) {
            throw new BrmoException("Fout bij loaden basisregistratie gegevens", e);
        }
    }

    public void emptyStagingDb() throws BrmoException {
        try {
            this.stagingProxy.emptyStagingDb();
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public Long getLaadProcesIdByFileName(String name) throws BrmoException {
        LaadProces lp;
        Long id = null;
        try {
            lp = this.stagingProxy.getLaadProcesByFileName(name);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
        if (lp != null) {
            id = lp.getId();
        }
        return id;
    }

    public Bericht getBerichtById(long id) throws BrmoException {
        try {
            return this.stagingProxy.getBerichtById(id);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public List<Bericht> getBerichten(int page, int start, int limit, String sort, String dir, String filterSoort, String filterStatus) throws BrmoException {
        try {
            return this.stagingProxy.getBerichten(page, start, limit, sort, dir, filterSoort, filterStatus);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public List<LaadProces> getLaadprocessen(int page, int start, int limit, String sort, String dir, String filterSoort, String filterStatus) throws BrmoException {
        try {
            return this.stagingProxy.getLaadprocessen(page, start, limit, sort, dir, filterSoort, filterStatus);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public long getCountBerichten(String sort, String dir, String filterSoort, String filterStatus) throws BrmoException {
        try {
            return this.stagingProxy.getCountBerichten(sort, dir, filterSoort, filterStatus);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public long getCountLaadProcessen(String sort, String dir, String filterSoort, String filterStatus) throws BrmoException {
        try {
            return this.stagingProxy.getCountLaadProces(sort, dir, filterSoort, filterStatus);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    private RsgbTransformer getTransformer(String brType) throws BrmoException {
        try {
            RsgbTransformer transformer = null;
            if (brType.equalsIgnoreCase(BR_BRK)) {
                transformer = new RsgbTransformer(XSL_BRK);
            } else if (brType.equalsIgnoreCase(BR_BAG)) {
                transformer = new RsgbTransformer(XSL_BAG);
            }
            return transformer;
        }
        catch (Exception ex) {
            if (ex instanceof BrmoException) {
                throw (BrmoException)ex;
            }
            throw new BrmoException(ex);
        }
    }
}

