/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.brmo.loader.jdbc.MssqlJdbcConverter;
import nl.b3p.brmo.loader.jdbc.OracleConnectionUnwrapper;
import nl.b3p.brmo.loader.jdbc.OracleJdbcConverter;
import nl.b3p.brmo.loader.jdbc.PostgisJdbcConverter;
import oracle.jdbc.OracleConnection;

public class GeometryJdbcConverterFactory {
    public static GeometryJdbcConverter getGeometryJdbcConverter(Connection conn) {
        String databaseProductName = null;
        try {
            databaseProductName = conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException ex) {
            throw new UnsupportedOperationException("Cannot get database product name", ex);
        }
        if (databaseProductName.contains("PostgreSQL")) {
            return new PostgisJdbcConverter();
        }
        if (databaseProductName.contains("Oracle")) {
            try {
                OracleConnection oc = OracleConnectionUnwrapper.unwrap(conn);
                OracleJdbcConverter geomToJdbc = new OracleJdbcConverter(oc);
                geomToJdbc.setSchema(oc.getCurrentSchema());
                return geomToJdbc;
            }
            catch (SQLException ex) {
                throw new UnsupportedOperationException("Cannot get connection: " + databaseProductName, ex);
            }
        }
        if (databaseProductName.contains("Microsoft SQL Server")) {
            return new MssqlJdbcConverter();
        }
        throw new UnsupportedOperationException("Unknown database: " + databaseProductName);
    }
}

