/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import net.sourceforge.jtds.jdbc.JtdsConnection;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.brmo.loader.gml.BGTGMLLightLoader;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverterFactory;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BGTLightRsgbTransformer
implements Runnable {
    private static final Log LOG = LogFactory.getLog(BGTLightRsgbTransformer.class);
    private final StagingProxy stagingProxy;
    private final DataSource dataSourceRsgbBgt;
    private final ProgressUpdateListener listener;
    private final long[] lpIDs;
    private final Properties params = new Properties();
    private GeometryJdbcConverter geomjdbc = null;
    private final BGTGMLLightLoader gmlLoader = new BGTGMLLightLoader();

    public BGTLightRsgbTransformer(DataSource dataSourceRsgbBgt, StagingProxy stagingProxy, long[] lpIDs, ProgressUpdateListener listener) {
        this.stagingProxy = stagingProxy;
        this.dataSourceRsgbBgt = dataSourceRsgbBgt;
        this.lpIDs = lpIDs;
        this.listener = listener;
    }

    private void transform(long lpID) throws SQLException {
        LaadProces lp = this.stagingProxy.getLaadProcesById(lpID);
        if (lp.getSoort().equalsIgnoreCase("bgtlight") && lp.getStatus() == LaadProces.STATUS.STAGING_OK) {
            File zip = new File(lp.getBestandNaam());
            this.stagingProxy.updateLaadProcesStatus(lp, LaadProces.STATUS.RSGB_BGT_WAITING, "Transformatie loopt...");
            try {
                int total = this.gmlLoader.processZipFile(zip);
                String opmerking = this.gmlLoader.getOpmerkingen();
                LOG.info((Object)opmerking);
                this.stagingProxy.updateLaadProcesStatus(lp, LaadProces.STATUS.RSGB_BGT_OK, opmerking);
            }
            catch (IOException | IllegalArgumentException ex) {
                String opmerking = "Laden van bestand " + zip + " is mislukt.\n" + ex.getLocalizedMessage();
                LOG.error((Object)opmerking, (Throwable)ex);
                this.stagingProxy.updateLaadProcesStatus(lp, LaadProces.STATUS.RSGB_BGT_NOK, opmerking);
            }
        } else {
            LOG.warn((Object)("LaadProces " + lp.getId() + " van soort " + lp.getSoort() + " met status: " + (Object)((Object)lp.getStatus()) + " is overgeslagen."));
        }
    }

    public void init() throws SQLException {
        this.geomjdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter(this.dataSourceRsgbBgt.getConnection());
        boolean isMSSQL = this.geomjdbc.getGeotoolsDBTypeName().toLowerCase().contains("sqlserver");
        if (isMSSQL) {
            String dbName = this.dataSourceRsgbBgt.getConnection().getCatalog();
            this.params.put("database", dbName);
            String url = this.dataSourceRsgbBgt.getConnection().getMetaData().getURL();
            URI uri = URI.create(url.substring(10));
            this.params.put("host", uri.getHost());
            this.params.put("port", (Object)uri.getPort());
            this.params.put("instance", uri.getPath().substring(1 + dbName.length() + 10));
            this.params.put("user", this.dataSourceRsgbBgt.getConnection().getMetaData().getUserName());
            try {
                JtdsConnection oc = this.dataSourceRsgbBgt.getConnection().unwrap(JtdsConnection.class);
                String pwd = (String)FieldUtils.readField((Object)oc, (String)"password", (boolean)isMSSQL);
                this.params.put("passwd", pwd);
            }
            catch (IllegalAccessException ex) {
                LOG.error((Object)"wachtwoord kon niet worden ingesteld", (Throwable)ex);
            }
        } else {
            this.params.put("jndiReferenceName", "java:comp/env/jdbc/brmo/rsgbbgt");
        }
        this.params.put("dbtype", this.geomjdbc.getGeotoolsDBTypeName());
        this.params.put("schema", this.geomjdbc.getSchema());
        this.gmlLoader.setDbConnProps(this.params);
        this.gmlLoader.setBijwerkDatum(new Date());
        this.gmlLoader.setIsOracle(this.geomjdbc.getGeotoolsDBTypeName().toLowerCase().contains("oracle"));
        this.gmlLoader.setIsMSSQL(isMSSQL);
    }

    public void setLoadingUpdate(boolean loadingUpdate) {
        this.gmlLoader.setLoadingUpdate(loadingUpdate);
    }

    @Override
    public void run() {
        block4: {
            try {
                this.init();
                int count = 0;
                if (this.listener != null) {
                    this.listener.total(this.lpIDs.length);
                    this.listener.progress(count);
                }
                for (long id : this.lpIDs) {
                    this.transform(id);
                    ++count;
                    if (this.listener == null) continue;
                    this.listener.progress(count);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Fout tijdens verwerken BGT laadprocessen", (Throwable)e);
                if (this.listener == null) break block4;
                this.listener.exception(e);
            }
        }
    }
}

