/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import nl.b3p.brmo.loader.util.TableData;
import nl.b3p.brmo.loader.util.TableRow;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.xml.sax.SAXException;

public class DataComfortXMLReader {
    private static final int LEVEL_ROOT = 0;
    private static final int LEVEL_DATA = 1;
    private static final int LEVEL_COMFORT = 2;
    private static final int LEVEL_TABLE = 3;
    private static final int LEVEL_DELETE = 4;
    private final TransformerFactory tf = TransformerFactory.newInstance();
    private final XMLInputFactory xif = XMLInputFactory.newInstance();
    private final GeometryFactory gf;
    private final Parser gmlParser;

    public DataComfortXMLReader() {
        GMLConfiguration gml = new GMLConfiguration();
        this.gf = new GeometryFactory(new PrecisionModel(), 28992);
        gml.getContext().registerComponentInstance((Object)this.gf);
        this.gmlParser = new Parser((Configuration)gml);
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<TableData> readDataXML(Source dataXML) throws XMLStreamException, TransformerConfigurationException, TransformerException, IOException, SAXException, ParserConfigurationException {
        Split split = SimonManager.getStopwatch((String)"b3p.util.datacomfortxmlreader").start();
        XMLStreamReader xer = this.xif.createXMLStreamReader(dataXML);
        int level = 0;
        ArrayList<TableData> list = new ArrayList<TableData>();
        TableData data = null;
        TableRow row = null;
        boolean inComfortData = false;
        boolean inDeleteData = false;
        block7: while (xer.hasNext()) {
            xer.nextTag();
            String tag = xer.getLocalName();
            switch (level) {
                case 0: {
                    if (!"data".equals(tag)) break;
                    level = 1;
                    break;
                }
                case 1: {
                    if (xer.isEndElement()) break block7;
                    if ("comfort".equals(tag)) {
                        String comfortSearchTable = xer.getAttributeValue(null, "search-table");
                        String comfortSearchColumn = xer.getAttributeValue(null, "search-column");
                        String comfortSearchValue = xer.getAttributeValue(null, "search-value");
                        String snapshotDate = xer.getAttributeValue(null, "snapshot-date");
                        data = new TableData(comfortSearchTable, comfortSearchColumn, comfortSearchValue, snapshotDate);
                        level = 2;
                        inComfortData = true;
                        inDeleteData = false;
                    } else if ("delete".equals(tag)) {
                        data = new TableData();
                        level = 4;
                        inComfortData = false;
                        inDeleteData = true;
                    } else {
                        row = new TableRow();
                        row.setTable(tag);
                        row.setIgnoreDuplicates("yes".equals(xer.getAttributeValue(null, "ignore-duplicates")));
                        String beginDatumColumn = xer.getAttributeValue(null, "column-dat-beg-geldh");
                        String eindeDatumColumn = xer.getAttributeValue(null, "column-datum-einde-geldh");
                        row.setColumnDatumBeginGeldigheid(beginDatumColumn);
                        row.setColumnDatumEindeGeldigheid(eindeDatumColumn);
                        data = new TableData(row);
                        level = 3;
                        inComfortData = false;
                        inDeleteData = false;
                    }
                    list.add(data);
                    break;
                }
                case 2: {
                    if (xer.isEndElement() && "comfort".equals(tag)) {
                        level = 1;
                        break;
                    }
                    row = new TableRow();
                    row.setTable(tag);
                    data.addRow(row);
                    level = 3;
                    break;
                }
                case 4: {
                    if (xer.isEndElement() && "delete".equals(tag)) {
                        level = 1;
                        break;
                    }
                    row = new TableRow();
                    row.setTable(tag);
                    data.addRow(row);
                    level = 3;
                    break;
                }
                case 3: {
                    if (xer.isEndElement()) {
                        if (inComfortData) {
                            level = 2;
                            break;
                        }
                        if (inDeleteData) {
                            level = 4;
                            break;
                        }
                        level = 1;
                        break;
                    }
                    data = (TableData)list.get(list.size() - 1);
                    row.getColumns().add(tag);
                    String alleenArchief = xer.getAttributeValue(null, "alleen-archief");
                    if ("true".equals(alleenArchief)) {
                        row.setAlleenArchiefColumn(tag);
                    }
                    xer.next();
                    if (xer.isStartElement()) {
                        Split split2 = SimonManager.getStopwatch((String)"b3p.util.datacomfortxmlreader.parsegml").start();
                        Transformer transformer = this.tf.newTransformer();
                        StringWriter sw = new StringWriter();
                        transformer.transform(new StAXSource(xer), new StreamResult(sw));
                        Geometry geom = (Geometry)this.gmlParser.parse((Reader)new StringReader(sw.toString()));
                        if (geom instanceof Polygon) {
                            Polygon[] polygons = new Polygon[]{(Polygon)geom};
                            geom = this.gf.createMultiPolygon(polygons);
                        }
                        row.getValues().add(geom.toString());
                        split2.stop();
                        break;
                    }
                    if (xer.isCharacters()) {
                        StringBuilder t = new StringBuilder();
                        do {
                            t.append(xer.getText());
                            xer.next();
                        } while (xer.isCharacters());
                        row.getValues().add(t.toString());
                        break;
                    }
                    assert (xer.isEndElement());
                    row.getValues().add(null);
                }
            }
        }
        split.stop();
        return list;
    }
}

