/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.entity;

import java.io.StringReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.xml.BagXMLReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class BagBericht
extends Bericht {
    private Document doc;
    private boolean xpathEvaluated = false;
    private static final Log log = LogFactory.getLog(BagBericht.class);
    private static XPathExpression mutTijdstipVerwerking = null;
    private static XPathExpression mutVolgnr = null;
    private static XPathExpression mutObjectType = null;
    private static XPathExpression idXPath = null;
    private static XPathExpression mutIdXPath = null;

    public BagBericht(String brXml) {
        super(brXml);
        this.setSoort("bag");
    }

    public BagBericht(String brXml, Document doc) {
        super(brXml);
        this.setSoort("bag");
        this.doc = doc;
    }

    private void evaluateXPath() {
        if (this.xpathEvaluated) {
            return;
        }
        this.xpathEvaluated = true;
        try {
            String objectType;
            if (this.doc == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.doc = builder.parse(new InputSource(new StringReader(this.getBrXml())));
            }
            String id = null;
            if (this.doc.getDocumentElement().getLocalName().equals("Mutatie-product")) {
                String d = mutTijdstipVerwerking.evaluate(this.doc);
                this.setDatumAsString(d);
                this.setVolgordeNummer(new Integer(mutVolgnr.evaluate(this.doc)));
                objectType = mutObjectType.evaluate(this.doc);
                id = mutIdXPath.evaluate(this.doc);
            } else if (BagXMLReader.lvcProductToObjectType.containsKey(this.doc.getDocumentElement().getLocalName())) {
                objectType = BagXMLReader.lvcProductToObjectType.get(this.doc.getDocumentElement().getLocalName());
                id = idXPath.evaluate(this.doc);
            } else {
                throw new IllegalArgumentException("Onbekend BAG bericht: verwacht Mutatie-product of " + BagXMLReader.lvcProductToObjectType.keySet().toString() + " maar \"" + this.doc.getDocumentElement().getLocalName() + "\" gevonden");
            }
            this.setObjectRef(objectType + ":" + id);
        }
        catch (Exception e) {
            log.error((Object)"Error while getting bag referentie", (Throwable)e);
        }
    }

    public void setDatumAsString(String d) {
        if (d == null || d.isEmpty()) {
            return;
        }
        DateTime date = new DateTime((Object)d);
        Date date2 = new Date(date.getMillis());
        this.setDatum(date2);
    }

    @Override
    public String getObjectRef() {
        this.evaluateXPath();
        return super.getObjectRef();
    }

    @Override
    public Date getDatum() {
        this.evaluateXPath();
        return super.getDatum();
    }

    @Override
    public Integer getVolgordeNummer() {
        this.evaluateXPath();
        return super.getVolgordeNummer();
    }

    static {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        try {
            mutTijdstipVerwerking = xpath.compile("/*[local-name() = 'Mutatie-product']/*[local-name()= 'Verwerking']/*[local-name() = 'TijdstipVerwerking']/text()");
            mutVolgnr = xpath.compile("/*[local-name() = 'Mutatie-product']/*[local-name()= 'Verwerking']/*[local-name() = 'VolgnrVerwerking']/text()");
            mutObjectType = xpath.compile("/*[local-name() = 'Mutatie-product']/*[local-name()= 'Verwerking']/*[local-name() = 'ObjectType']/text()");
            mutIdXPath = xpath.compile("/*[local-name() = 'Mutatie-product']/*[local-name() = 'Nieuw']/*/*[local-name() = 'identificatie']/text()");
            idXPath = xpath.compile("/*/*[local-name() = 'identificatie']/text()");
        }
        catch (XPathExpressionException ex) {
            log.fatal((Object)"Fout bij initialiseren XPath expressies", (Throwable)ex);
        }
    }
}

