/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.transform.TransformerException;
import nl.b3p.brmo.loader.BerichtenHandler;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.RsgbProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.entity.BerichtenSorter;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.brmo.loader.jdbc.MssqlJdbcConverter;
import nl.b3p.brmo.loader.jdbc.OracleJdbcConverter;
import nl.b3p.brmo.loader.jdbc.PostgisJdbcConverter;
import nl.b3p.brmo.loader.pipeline.BerichtTypeOfWork;
import nl.b3p.brmo.loader.pipeline.BerichtWorkUnit;
import nl.b3p.brmo.loader.pipeline.ProcessDbXmlPipeline;
import nl.b3p.brmo.loader.util.BrmoDuplicaatLaadprocesException;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.BrmoLeegBestandException;
import nl.b3p.brmo.loader.util.RsgbTransformer;
import nl.b3p.brmo.loader.util.StagingRowHandler;
import nl.b3p.brmo.loader.util.TableData;
import nl.b3p.brmo.loader.xml.BGTLightFileReader;
import nl.b3p.brmo.loader.xml.BagXMLReader;
import nl.b3p.brmo.loader.xml.BrkSnapshotXMLReader;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;
import nl.b3p.brmo.loader.xml.NhrXMLReader;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.xml.sax.SAXException;

public class StagingProxy {
    private static final Log log = LogFactory.getLog(StagingProxy.class);
    private Connection connStaging = null;
    private DataSource dataSourceStaging = null;
    private GeometryJdbcConverter geomToJdbc = null;
    private Integer batchCapacity = 150;
    private PreparedStatement getOldBerichtStatement;
    private PreparedStatement getOldBerichtStatementById;

    public StagingProxy(DataSource dataSourceStaging) throws SQLException, BrmoException {
        this.dataSourceStaging = dataSourceStaging;
        this.connStaging = this.getConnection();
        this.geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter(this.connStaging);
    }

    public void closeStagingProxy() {
        if (this.getOldBerichtStatement != null) {
            DbUtils.closeQuietly((Statement)this.getOldBerichtStatement);
        }
        DbUtils.closeQuietly((Connection)this.connStaging);
    }

    private Connection getConnection() throws SQLException {
        if (this.connStaging == null || this.connStaging.isClosed()) {
            this.connStaging = this.dataSourceStaging.getConnection();
        }
        return this.connStaging;
    }

    public LaadProces getLaadProcesById(Long id) throws SQLException {
        BeanListHandler h = new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler());
        List processen = (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), "SELECT * FROM laadproces WHERE id = ?", (ResultSetHandler)h, new Object[]{id});
        if (processen != null && processen.size() == 1) {
            return (LaadProces)processen.get(0);
        }
        return null;
    }

    public Bericht getBerichtById(Long id) throws SQLException {
        BeanListHandler h = new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler());
        List berichten = (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), "SELECT * FROM bericht WHERE id = ?", (ResultSetHandler)h, new Object[]{id});
        if (berichten != null && berichten.size() == 1) {
            return (Bericht)berichten.get(0);
        }
        return null;
    }

    public LaadProces getLaadProcesByFileName(String name) throws SQLException {
        BeanListHandler h = new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler());
        List processen = (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), "SELECT * FROM laadproces WHERE bestand_naam = ?", (ResultSetHandler)h, new Object[]{name});
        if (processen != null && processen.size() == 1) {
            return (LaadProces)processen.get(0);
        }
        return null;
    }

    private LaadProces getLaadProcesByNaturalKey(String name, long date) throws SQLException {
        BeanListHandler h = new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler());
        List processen = (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), "SELECT * FROM laadproces WHERE bestand_naam = ? AND bestand_datum = ?", (ResultSetHandler)h, new Object[]{name, new Timestamp(date)});
        if (processen != null && processen.size() > 0) {
            return (LaadProces)processen.get(0);
        }
        return null;
    }

    public Bericht getExistingBericht(Bericht b) throws SQLException {
        Bericht b2 = this.getBerichtByNaturalKey(b.getObjectRef(), b.getDatum().getTime(), b.getVolgordeNummer());
        return b2;
    }

    private Bericht getBerichtByNaturalKey(String object_ref, long date, Integer volgnr) throws SQLException {
        BeanListHandler h = new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler());
        List processen = (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), "SELECT * FROM bericht WHERE object_ref = ? AND datum = ? and volgordenummer = ?", (ResultSetHandler)h, new Object[]{object_ref, new Timestamp(date), volgnr});
        if (processen != null && processen.size() > 0) {
            return (Bericht)processen.get(0);
        }
        return null;
    }

    public long getCountJob() throws SQLException {
        Object o = new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), "select count(*) from job", (ResultSetHandler)new ScalarHandler());
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).longValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        return (Long)o;
    }

    public boolean removeJob() throws SQLException {
        int count = new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "truncate table job");
        return count > 0;
    }

    public boolean cleanJob() throws SQLException {
        int count = 0;
        count = this.geomToJdbc instanceof OracleJdbcConverter ? new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "delete from job j where j.id in (select b.id from bericht b  where b.id = j.id and status != 'STAGING_OK')") : (this.geomToJdbc instanceof MssqlJdbcConverter ? new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "delete j from dbo.job j where j.id in (select b.id from dbo.bericht b  where b.id = j.id and status != ?)", (Object)Bericht.STATUS.STAGING_OK.toString()) : new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "delete from job j where j.id in (select b.id from bericht b  where b.id = j.id and status != ?)", (Object)Bericht.STATUS.STAGING_OK.toString()));
        return count > 0;
    }

    public long setBerichtenJobByStatus(Bericht.STATUS status, boolean orderBerichten) throws SQLException {
        StringBuilder q = new StringBuilder("insert into job (id, datum, volgordenummer, object_ref, br_xml, soort)  select id, datum, volgordenummer, object_ref, br_xml, soort from bericht where status = ? and datum <= ? ");
        if (orderBerichten) {
            q.append(" order by " + BerichtenSorter.SQL_ORDER_BY);
        } else {
            q.append(" and volgordenummer < 0 ");
        }
        return new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), q.toString(), new Object[]{status.toString(), new Date(new java.util.Date().getTime())});
    }

    public long setBerichtenJobForUpdate(String soort, boolean orderBerichten) throws SQLException {
        StringBuilder q = new StringBuilder("insert into job (id, datum, volgordenummer, object_ref, br_xml, soort)  select id, datum, volgordenummer, object_ref, br_xml, soort from bericht where status = ? and soort = ? and datum <= ? ");
        if (orderBerichten) {
            q.append(" order by " + BerichtenSorter.SQL_ORDER_BY);
        } else {
            q.append(" and volgordenummer < 0 ");
        }
        return new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), q.toString(), new Object[]{Bericht.STATUS.RSGB_OK.toString(), soort, new Date(new java.util.Date().getTime())});
    }

    public long setBerichtenJobByIds(long[] ids, boolean orderBerichten) throws SQLException {
        StringBuilder q = new StringBuilder("insert into job (id, datum, volgordenummer, object_ref, br_xml, soort)  select id, datum, volgordenummer, object_ref, br_xml, soort from bericht where id in (");
        for (int i = 0; i < ids.length; ++i) {
            if (i != 0) {
                q.append(",");
            }
            q.append(ids[i]);
        }
        q.append(") and datum <= ? ");
        if (orderBerichten) {
            q.append(" order by " + BerichtenSorter.SQL_ORDER_BY);
        } else {
            q.append(" and volgordenummer < 0 ");
        }
        return new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), q.toString(), (Object)new Date(new java.util.Date().getTime()));
    }

    public long setBerichtenJobByLaadprocessen(long[] laadprocesIds, boolean orderBerichten) throws SQLException {
        StringBuilder q = new StringBuilder("insert into job (id, datum, volgordenummer, object_ref, br_xml, soort)  select id, datum, volgordenummer, object_ref, br_xml, soort from bericht where laadprocesid in (");
        for (int i = 0; i < laadprocesIds.length; ++i) {
            if (i != 0) {
                q.append(",");
            }
            q.append(laadprocesIds[i]);
        }
        q.append(") and status = ? and datum <= ? ");
        if (orderBerichten) {
            q.append(" order by " + BerichtenSorter.SQL_ORDER_BY);
        } else {
            q.append(" and volgordenummer < 0 ");
        }
        return new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), q.toString(), new Object[]{Bericht.STATUS.STAGING_OK.toString(), new Date(new java.util.Date().getTime())});
    }

    public void handleBerichtenByJob(long total, BerichtenHandler handler, boolean enablePipeline, int transformPipelineCapacity, boolean orderBerichten) throws Exception {
        Split split = SimonManager.getStopwatch((String)"b3p.rsgb.job").start();
        final String dateTime = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new java.util.Date());
        Split jobSplit = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime)).start();
        ((RsgbProxy)handler).setSimonNamePrefix("b3p.rsgb.job." + dateTime + ".");
        StagingRowHandler processor = new StagingRowHandler();
        ProcessDbXmlPipeline processDbXmlPipeline = new ProcessDbXmlPipeline(handler, transformPipelineCapacity, "b3p.rsgb.job." + dateTime + ".pipeline");
        if (enablePipeline) {
            processDbXmlPipeline.start();
        }
        int offset = 0;
        int batch = this.batchCapacity;
        MutableInt processed = new MutableInt(0);
        MutableInt lastJid = new MutableInt(0);
        boolean doOrderBerichten = orderBerichten;
        boolean abort = false;
        try {
            do {
                log.debug((Object)String.format("Ophalen berichten batch Job tabel, offset %d, limit %d", lastJid.intValue(), batch));
                String sql = "select jid, id, datum, volgordenummer, object_ref, br_xml, soort from job where jid > " + lastJid.intValue() + " order by jid ";
                sql = this.geomToJdbc.buildPaginationSql(sql, 0, batch);
                log.debug((Object)("SQL voor ophalen berichten batch: " + sql));
                processed.setValue(0);
                final Split getBerichten = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime + ".staging.berichten.getbatch")).start();
                Exception e = (Exception)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), sql, (ResultSetHandler)new ResultSetHandler<Exception>((RowProcessor)processor, doOrderBerichten, handler, enablePipeline, processDbXmlPipeline, lastJid, processed){
                    final /* synthetic */ RowProcessor val$processor;
                    final /* synthetic */ boolean val$doOrderBerichten;
                    final /* synthetic */ BerichtenHandler val$handler;
                    final /* synthetic */ boolean val$enablePipeline;
                    final /* synthetic */ ProcessDbXmlPipeline val$processDbXmlPipeline;
                    final /* synthetic */ MutableInt val$lastJid;
                    final /* synthetic */ MutableInt val$processed;
                    {
                        this.val$processor = rowProcessor;
                        this.val$doOrderBerichten = bl;
                        this.val$handler = berichtenHandler;
                        this.val$enablePipeline = bl2;
                        this.val$processDbXmlPipeline = processDbXmlPipeline;
                        this.val$lastJid = mutableInt;
                        this.val$processed = mutableInt2;
                    }

                    public Exception handle(ResultSet rs) throws SQLException {
                        getBerichten.stop();
                        Split processResultSet = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime + ".staging.berichten.processresultset")).start();
                        while (rs.next()) {
                            try {
                                Bericht bericht = (Bericht)this.val$processor.toBean(rs, Bericht.class);
                                if (bericht.getVolgordeNummer() >= 0 && !this.val$doOrderBerichten) {
                                    throw new Exception(String.format("Het sorteren van berichten staat uit, terwijl bericht (id: %d) geen standbericht is (volgnummer >=0)", bericht.getId()));
                                }
                                BerichtWorkUnit workUnit = new BerichtWorkUnit(bericht);
                                this.val$handler.updateBerichtProcessing(bericht);
                                if (this.val$enablePipeline) {
                                    List<TableData> tableData = this.val$handler.transformToTableData(bericht);
                                    if (tableData == null) continue;
                                    workUnit.setTableData(tableData);
                                    workUnit.setTypeOfWork(BerichtTypeOfWork.PROCESS_DBXML);
                                    Split pipelinePut = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime + ".pipeline.processdbxml.put")).start();
                                    this.val$processDbXmlPipeline.getQueue().put(workUnit);
                                    pipelinePut.stop();
                                } else {
                                    Split berichtSplit = SimonManager.getStopwatch((String)("b3p.rsgb.job." + dateTime + ".bericht")).start();
                                    this.val$handler.handle(bericht, null, true);
                                    berichtSplit.stop();
                                }
                                this.val$lastJid.setValue(rs.getInt("jid"));
                            }
                            catch (Exception e) {
                                return e;
                            }
                            this.val$processed.increment();
                        }
                        processResultSet.stop();
                        return null;
                    }
                });
                offset += processed.intValue();
                if (e == null) continue;
                throw e;
            } while (processed.intValue() > 0 && (long)offset < total);
            if ((long)offset < total) {
                log.warn((Object)String.format("Minder berichten verwerkt (%d) dan verwacht (%d)!", offset, total));
            }
            this.removeJob();
        }
        catch (Exception t) {
            abort = true;
            throw t;
        }
        finally {
            if (enablePipeline) {
                if (abort) {
                    processDbXmlPipeline.setAbortFlag();
                } else {
                    processDbXmlPipeline.stopWhenQueueEmpty();
                    try {
                        processDbXmlPipeline.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        jobSplit.stop();
        split.stop();
    }

    public void updateBerichtenDbXml(List<Bericht> berichten, RsgbTransformer transformer) throws SQLException, SAXException, IOException, TransformerException {
        for (Bericht ber : berichten) {
            Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.dbxml.transform").start();
            String dbxml = transformer.transformToDbXml(ber);
            if (this.geomToJdbc instanceof OracleJdbcConverter && dbxml != null && dbxml.length() == 8000) {
                dbxml = dbxml + " ";
            }
            ber.setDbXml(dbxml);
            split.stop();
        }
    }

    public Bericht getOldBericht(Bericht nieuwBericht, StringBuilder loadLog) throws SQLException {
        Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.getold").start();
        Bericht bericht = null;
        BeanListHandler h = new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler());
        if (this.getOldBerichtStatement == null) {
            String sql = "SELECT id, object_ref, datum, volgordenummer, soort, status, job_id, status_datum FROM bericht WHERE object_ref = ? AND status in ('RSGB_OK', 'ARCHIVE') ORDER BY datum desc, volgordenummer desc";
            sql = this.geomToJdbc.buildPaginationSql(sql, 0, 1);
            this.getOldBerichtStatement = this.getConnection().prepareStatement(sql);
        } else {
            this.getOldBerichtStatement.clearParameters();
        }
        this.getOldBerichtStatement.setString(1, nieuwBericht.getObjectRef());
        ResultSet rs = this.getOldBerichtStatement.executeQuery();
        List list = (List)h.handle(rs);
        rs.close();
        if (!list.isEmpty()) {
            loadLog.append("Vorig bericht gevonden:\n");
            for (Bericht b : list) {
                if ((Bericht.STATUS.RSGB_OK.equals((Object)b.getStatus()) || Bericht.STATUS.ARCHIVE.equals((Object)b.getStatus())) && bericht == null) {
                    loadLog.append("Meest recent bericht gevonden: ").append(b).append("\n");
                    bericht = b;
                    continue;
                }
                loadLog.append("Niet geschikt bericht: ").append(b).append("\n");
            }
        }
        if (bericht != null) {
            if (this.getOldBerichtStatementById == null) {
                String sql = "SELECT * FROM bericht WHERE id = ?";
                this.getOldBerichtStatementById = this.getConnection().prepareStatement(sql);
            } else {
                this.getOldBerichtStatementById.clearParameters();
            }
            this.getOldBerichtStatementById.setLong(1, bericht.getId());
            ResultSet rs2 = this.getOldBerichtStatementById.executeQuery();
            List list2 = (List)h.handle(rs2);
            rs2.close();
            if (!list2.isEmpty()) {
                bericht = (Bericht)list2.get(0);
            }
        }
        split.stop();
        return bericht;
    }

    public void updateBericht(Bericht b) throws SQLException {
        Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.update").start();
        new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "UPDATE bericht set object_ref = ?, datum = ?, volgordenummer = ?, soort = ?, opmerking = ?, status = ?, status_datum = ?, br_xml = ?, br_orgineel_xml = ?, db_xml = ?, xsl_version = ? WHERE id = ?", new Object[]{b.getObjectRef(), new Timestamp(b.getDatum().getTime()), b.getVolgordeNummer(), b.getSoort(), b.getOpmerking(), b.getStatus().toString(), new Timestamp(b.getStatusDatum().getTime()), b.getBrXml(), b.getBrOrgineelXml(), b.getDbXml(), b.getXslVersion(), b.getId()});
        split.stop();
    }

    public void updateBerichtProcessing(Bericht b) throws SQLException {
        Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.updateprocessing").start();
        new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "UPDATE bericht set opmerking = ?, status = ?, status_datum = ?, db_xml = ? WHERE id = ?", new Object[]{b.getOpmerking(), b.getStatus().toString(), new Timestamp(b.getStatusDatum().getTime()), b.getDbXml(), b.getId()});
        split.stop();
    }

    public void deleteByLaadProcesId(Long id) throws SQLException {
        new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "DELETE FROM bericht WHERE laadprocesid = ?", (Object)id);
        new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "DELETE FROM laadproces WHERE id = ?", (Object)id);
    }

    public List<LaadProces> getLaadProcessen() throws SQLException {
        BeanListHandler h = new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler());
        List list = (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), "select * from laadproces", (ResultSetHandler)h);
        return list;
    }

    public List<Bericht> getBerichten() throws SQLException {
        BeanListHandler h = new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler());
        List berichten = (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), "select * from bericht", (ResultSetHandler)h);
        return berichten;
    }

    public void loadBr(InputStream stream, String type, String fileName, ProgressUpdateListener listener) throws Exception {
        CountingInputStream cis = new CountingInputStream(stream);
        BrmoXMLReader brmoXMLReader = null;
        if (type.equals("brk")) {
            brmoXMLReader = new BrkSnapshotXMLReader((InputStream)cis);
        } else if (type.equals("bag")) {
            brmoXMLReader = new BagXMLReader((InputStream)cis);
        } else if (type.equals("nhr")) {
            brmoXMLReader = new NhrXMLReader((InputStream)cis);
        } else if (type.equals("bgtlight")) {
            brmoXMLReader = new BGTLightFileReader(fileName);
        } else {
            throw new UnsupportedOperationException("Ongeldige basisregistratie: " + type);
        }
        if (brmoXMLReader.getBestandsDatum() == null) {
            throw new BrmoException("Header van bestand bevat geen datum, verkeerd formaat?");
        }
        LaadProces lp = new LaadProces();
        lp.setBestandNaam(fileName);
        lp.setBestandDatum(brmoXMLReader.getBestandsDatum());
        lp.setSoort(type);
        lp.setGebied(brmoXMLReader.getGebied());
        lp.setStatus(LaadProces.STATUS.STAGING_OK);
        lp.setStatusDatum(new java.util.Date());
        if (this.laadProcesExists(lp)) {
            throw new BrmoDuplicaatLaadprocesException("Laadproces al gerund voor bestand " + fileName);
        }
        lp = this.writeLaadProces(lp);
        if (type.equalsIgnoreCase("bgtlight")) {
            if (listener != null) {
                listener.total(((BGTLightFileReader)brmoXMLReader).getFileSize());
                listener.progress(((BGTLightFileReader)brmoXMLReader).getFileSize());
            }
        } else {
            String opmerking;
            if (!brmoXMLReader.hasNext()) {
                throw new BrmoLeegBestandException("Leeg bestand, geen berichten gevonden in " + fileName);
            }
            boolean isBerichtGeschreven = false;
            int berichten = 0;
            int foutBerichten = 0;
            String lastErrorMessage = null;
            while (brmoXMLReader.hasNext()) {
                Bericht b = null;
                try {
                    b = brmoXMLReader.next();
                    b.setLaadProcesId(lp.getId().intValue());
                    b.setStatus(Bericht.STATUS.STAGING_OK);
                    b.setStatusDatum(new java.util.Date());
                    b.setSoort(type);
                    if (b.getDatum() == null) {
                        throw new BrmoException("Datum bericht is null");
                    }
                    Bericht existingBericht = this.getExistingBericht(b);
                    if (existingBericht == null) {
                        this.writeBericht(b);
                        isBerichtGeschreven = true;
                    } else if (existingBericht.getStatus().equals((Object)Bericht.STATUS.STAGING_OK)) {
                        b.setId(existingBericht.getId());
                        this.updateBericht(b);
                    }
                    if (listener != null) {
                        listener.progress(cis.getByteCount());
                    }
                    ++berichten;
                }
                catch (Exception e) {
                    lastErrorMessage = String.format("Laden bericht uit %s mislukt vanwege: %s", fileName, e.getLocalizedMessage());
                    log.error((Object)lastErrorMessage);
                    if (listener != null) {
                        listener.exception(e);
                    }
                    ++foutBerichten;
                }
            }
            if (listener != null) {
                listener.total(berichten);
            }
            if (foutBerichten > 0) {
                opmerking = "Laden van " + foutBerichten + " bericht(en) mislukt, laatste melding: " + lastErrorMessage + ", zie logs voor meer info.";
                this.updateLaadProcesStatus(lp, LaadProces.STATUS.STAGING_NOK, opmerking);
            } else if (!isBerichtGeschreven) {
                opmerking = "Dit bestand is waarschijnlijk al eerder geladen.";
                this.updateLaadProcesStatus(lp, LaadProces.STATUS.STAGING_DUPLICAAT, opmerking);
            }
        }
    }

    public void writeBericht(Bericht b) throws SQLException {
        new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "INSERT INTO bericht(laadprocesid, object_ref, datum, volgordenummer, soort, opmerking, status, status_datum, br_xml, br_orgineel_xml, db_xml, xsl_version) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{b.getLaadProcesId(), b.getObjectRef(), new Timestamp(b.getDatum().getTime()), b.getVolgordeNummer(), b.getSoort(), b.getOpmerking(), b.getStatus().toString(), new Timestamp(b.getStatusDatum().getTime()), b.getBrXml(), b.getBrOrgineelXml(), b.getDbXml(), b.getXslVersion()});
    }

    private boolean laadProcesExists(LaadProces lp) throws SQLException {
        Object o = new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), "select 1 from laadproces where bestand_naam = ? and bestand_datum = ?", (ResultSetHandler)new ScalarHandler(), new Object[]{lp.getBestandNaam(), new Timestamp(lp.getBestandDatum().getTime())});
        return o != null;
    }

    private LaadProces writeLaadProces(LaadProces lp) throws SQLException {
        if (lp == null) {
            return null;
        }
        String sql = "INSERT INTO laadproces(bestand_naam,bestand_datum, soort, gebied, opmerking, status,status_datum, contact_email) VALUES (?,?,?,?,?,?,?,?)";
        new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), sql, new Object[]{lp.getBestandNaam(), new Timestamp(lp.getBestandDatum().getTime()), lp.getSoort(), lp.getGebied(), lp.getOpmerking(), lp.getStatus().toString(), new Timestamp(lp.getStatusDatum().getTime()), lp.getContactEmail()});
        return this.getLaadProcesByNaturalKey(lp.getBestandNaam(), lp.getBestandDatum().getTime());
    }

    public void updateLaadProcesStatus(LaadProces lp, LaadProces.STATUS status, String opmerking) throws SQLException {
        new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "update laadproces set status = ?, opmerking = ? where id = ?", new Object[]{status.toString(), opmerking, lp.getId()});
    }

    public void emptyStagingDb() throws SQLException {
        new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "DELETE FROM bericht");
        new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).update(this.getConnection(), "DELETE FROM laadproces");
    }

    public List<Bericht> getBerichten(int page, int start, int limit, String sort, String dir, String filterSoort, String filterStatus) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        if (sort == null || sort.trim().isEmpty()) {
            sort = "id";
        }
        if (dir == null || dir.trim().isEmpty()) {
            sort = "asc";
        }
        String sql = "SELECT * FROM bericht" + this.buildFilterSql(page, sort, dir, filterSoort, filterStatus, params);
        sql = this.geomToJdbc.buildPaginationSql(sql, start, limit);
        return (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), sql, (ResultSetHandler)new BeanListHandler(Bericht.class, (RowProcessor)new StagingRowHandler()), params.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getCountBerichten(String sort, String dir, String filterSoort, String filterStatus) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        String filter = this.buildFilterSql(0, null, null, filterSoort, filterStatus, params);
        String sql = StringUtils.isBlank((CharSequence)filter) && this.geomToJdbc instanceof PostgisJdbcConverter ? "SELECT reltuples::BIGINT AS estimate FROM pg_class WHERE relname= 'bericht'" : "SELECT count(*) FROM bericht" + filter;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = this.getConnection().prepareStatement(sql);
            try {
                pstmt.setQueryTimeout(300);
            }
            catch (Exception e) {
                log.warn((Object)"Driver does not support setQueryTimeout, please update driver.");
            }
            if (!params.isEmpty()) {
                for (int i = 0; i < params.size(); ++i) {
                    if (params.get(i) != null) {
                        pstmt.setObject(i + 1, params.get(i));
                        continue;
                    }
                    pstmt.setNull(i + 1, 12);
                }
            }
            if ((rs = pstmt.executeQuery()).next()) {
                Object o = rs.getObject(1);
                if (o instanceof BigDecimal) {
                    long l = ((BigDecimal)o).longValue();
                    return l;
                }
                if (o instanceof Integer) {
                    long l = ((Integer)o).longValue();
                    return l;
                }
                long l = (Long)o;
                return l;
            }
            long o = -1L;
            return o;
        }
        catch (Exception e) {
            long l = -1L;
            return l;
        }
        finally {
            try {
                if (rs != null && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (pstmt != null && !pstmt.isClosed()) {
                    pstmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private String buildFilterSql(int page, String sort, String dir, String filterSoort, String filterStatus, List<String> params) {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> conjunctions = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)filterSoort)) {
            String[] soorten = filterSoort.split(",");
            params.addAll(Arrays.asList(soorten));
            conjunctions.add("soort in (" + StringUtils.repeat((String)"?", (String)", ", (int)soorten.length) + ")");
        }
        if (!StringUtils.isBlank((CharSequence)filterStatus)) {
            String[] statussen = filterStatus.split(",");
            params.addAll(Arrays.asList(statussen));
            conjunctions.add("status in (" + StringUtils.repeat((String)"?", (String)", ", (int)statussen.length) + ")");
        }
        if (!conjunctions.isEmpty()) {
            builder.append(" where ");
            builder.append(StringUtils.join((Object[])conjunctions.toArray(), (String)" and "));
        }
        if (sort != null && dir != null) {
            builder.append(" ORDER BY ");
            builder.append(sort);
            builder.append(" ");
            builder.append(dir);
        }
        return builder.toString();
    }

    public long getCountLaadProces(String sort, String dir, String filterSoort, String filterStatus) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        String sql = "SELECT count(*) FROM laadproces" + this.buildFilterSql(0, null, null, filterSoort, filterStatus, params);
        Object o = new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), sql, (ResultSetHandler)new ScalarHandler(), params.toArray());
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).longValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        return (Long)o;
    }

    public List<LaadProces> getLaadprocessen(int page, int start, int limit, String sort, String dir, String filterSoort, String filterStatus) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        if (sort == null || sort.trim().isEmpty()) {
            sort = "id";
        }
        if (dir == null || dir.trim().isEmpty()) {
            sort = "asc";
        }
        String sql = "SELECT * FROM laadproces" + this.buildFilterSql(page, sort, dir, filterSoort, filterStatus, params);
        sql = this.geomToJdbc.buildPaginationSql(sql, start, limit);
        return (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), sql, (ResultSetHandler)new BeanListHandler(LaadProces.class, (RowProcessor)new StagingRowHandler()), params.toArray());
    }

    public Long[] getLaadProcessenIds(String sort, String dir, String filterSoort, String filterStatus) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        if (sort == null || sort.trim().isEmpty()) {
            sort = "id";
        }
        if (dir == null || dir.trim().isEmpty()) {
            sort = "asc";
        }
        String sql = "SELECT ID FROM laadproces" + this.buildFilterSql(-1, sort, dir, filterSoort, filterStatus, params);
        List ids = (List)new QueryRunner(this.geomToJdbc.isPmdKnownBroken()).query(this.getConnection(), sql, (ResultSetHandler)new ColumnListHandler("id"), params.toArray());
        return ids.toArray(new Long[ids.size()]);
    }

    Bericht getOldBericht(Bericht nieuwBericht) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setBatchCapacity(Integer batchCapacity) {
        this.batchCapacity = batchCapacity;
    }
}

