/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.xml;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;

public final class BGTLightFileReader
extends BrmoXMLReader {
    private long fileSize = 0L;

    public BGTLightFileReader(String fileName) throws Exception {
        if (fileName != null) {
            this.setBestandsNaam(fileName);
        }
        this.init();
    }

    @Override
    public void init() throws Exception {
        this.soort = "bgtlight";
        File input = new File(this.getBestandsNaam());
        try (ZipInputStream zip = new ZipInputStream(new FileInputStream(input));){
            this.fileSize = input.length();
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (!entry.getName().toLowerCase().endsWith(".gml")) continue;
                long t = entry.getTime();
                if (t < 0L) {
                    entry = zip.getNextEntry();
                    continue;
                }
                this.setBestandsDatum(new Date(t));
                break;
            }
        }
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setBestandsNaam(String naam) {
        super.setBestandsNaam(naam);
        StringTokenizer parts = new StringTokenizer(naam.substring(naam.lastIndexOf(File.separator) + 1, naam.length()), "_-.", false);
        if (parts.countTokens() > 3) {
            this.setGebied("grid " + parts.nextToken() + " aggrlevel " + parts.nextToken());
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return false;
    }

    @Override
    public Bericht next() throws Exception {
        return null;
    }
}

