/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import javax.xml.bind.JAXBException;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.RsgbProxy;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.brmo.loader.updates.UpdateProcess;
import nl.b3p.brmo.loader.util.BGTLightRsgbTransformer;
import nl.b3p.brmo.loader.util.BrmoDuplicaatLaadprocesException;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.BrmoLeegBestandException;
import nl.b3p.brmo.loader.util.TopNLRsgbTransformer;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.topnl.TopNLType;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrmoFramework {
    private static final Log log = LogFactory.getLog(BrmoFramework.class);
    public static final String BR_BAG = "bag";
    public static final String BR_BRK = "brk";
    public static final String BR_NHR = "nhr";
    public static final String BR_BGTLIGHT = "bgtlight";
    public static final String BR_TOPNL = "topnl";
    public static final String BR_BRP = "brp";
    public static final String BR_GBAV = "gbav";
    public static final String XSL_BRK = "/xsl/brk-snapshot-to-rsgb-xml.xsl";
    public static final String XSL_BAG = "/xsl/bag-mutatie-to-rsgb-xml.xsl";
    public static final String XSL_NHR = "/xsl/nhr-to-rsgb-xml-3.0.xsl";
    public static final String XSL_BRP = "/xsl/brp-to-rsgb-xml.xsl";
    public static final String XSL_GBAV = "/xsl/gbav-to-rsgb-xml.xsl";
    public static final String LAADPROCES_TABEL = "laadproces";
    public static final String BERICHT_TABLE = "bericht";
    public static final String JOB_TABLE = "job";
    public static final String BRMO_METADATA_TABEL = "brmo_metadata";
    private StagingProxy stagingProxy = null;
    private DataSource dataSourceRsgb = null;
    private DataSource dataSourceRsgbBgt = null;
    private DataSource dataSourceStaging = null;
    private DataSource dataSourceTopNL = null;
    private boolean enablePipeline = false;
    private Integer pipelineCapacity;
    private boolean renewConnectionAfterCommit = false;
    private boolean orderBerichten = true;
    private String errorState = null;

    public BrmoFramework(DataSource dataSourceStaging, DataSource dataSourceRsgb) throws BrmoException {
        if (dataSourceStaging != null) {
            try {
                this.stagingProxy = new StagingProxy(dataSourceStaging);
            }
            catch (SQLException ex) {
                throw new BrmoException(ex);
            }
        }
        this.dataSourceRsgb = dataSourceRsgb;
    }

    public BrmoFramework(DataSource dataSourceStaging, DataSource dataSourceRsgb, DataSource dataSourceRsgbBgt) throws BrmoException {
        if (dataSourceStaging != null) {
            try {
                this.stagingProxy = new StagingProxy(dataSourceStaging);
            }
            catch (SQLException ex) {
                throw new BrmoException(ex);
            }
        }
        this.dataSourceRsgb = dataSourceRsgb;
        this.dataSourceRsgbBgt = dataSourceRsgbBgt;
        this.dataSourceStaging = dataSourceStaging;
    }

    public BrmoFramework(DataSource dataSourceStaging, DataSource dataSourceRsgb, DataSource dataSourceRsgbBgt, DataSource dataSourceTopNL) throws BrmoException {
        if (dataSourceStaging != null) {
            try {
                this.stagingProxy = new StagingProxy(dataSourceStaging);
            }
            catch (SQLException ex) {
                throw new BrmoException(ex);
            }
        }
        this.dataSourceRsgb = dataSourceRsgb;
        this.dataSourceRsgbBgt = dataSourceRsgbBgt;
        this.dataSourceStaging = dataSourceStaging;
        this.dataSourceTopNL = dataSourceTopNL;
    }

    public void setDataSourceRsgbBgt(DataSource dataSourceRsgbBgt) {
        this.dataSourceRsgbBgt = dataSourceRsgbBgt;
    }

    public void setDataSourceTopNL(DataSource dataSourceTopNL) {
        this.dataSourceTopNL = dataSourceTopNL;
    }

    public String getStagingVersion() {
        try {
            return this.getVersion(this.dataSourceStaging);
        }
        catch (SQLException ex) {
            log.error((Object)"Versienummer kon niet uit de STAGING database worden gelezen.", (Throwable)ex);
            return "";
        }
    }

    public String getRsgbVersion() {
        try {
            return this.getVersion(this.dataSourceRsgb);
        }
        catch (SQLException ex) {
            log.error((Object)"Versienummer kon niet uit de RSGB database worden gelezen.", (Throwable)ex);
            return "";
        }
    }

    public String getRsgbBgtVersion() {
        try {
            return this.getVersion(this.dataSourceRsgbBgt);
        }
        catch (SQLException ex) {
            log.error((Object)"Versienummer kon niet uit de RSGBBGT database worden gelezen.", (Throwable)ex);
            return "";
        }
    }

    private String getVersion(DataSource dataSource) throws SQLException {
        String sql = "SELECT waarde FROM brmo_metadata WHERE naam = 'brmoversie'";
        Connection c = dataSource.getConnection();
        GeometryJdbcConverter geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)c);
        Object o = new QueryRunner(geomToJdbc.isPmdKnownBroken()).query(c, sql, (ResultSetHandler)new ScalarHandler());
        DbUtils.closeQuietly((Connection)c);
        return o.toString();
    }

    public void setEnablePipeline(boolean enablePipeline) {
        this.enablePipeline = enablePipeline;
    }

    public void setRenewConnectionAfterCommit(boolean renewConnectionAfterCommit) {
        this.renewConnectionAfterCommit = renewConnectionAfterCommit;
    }

    public void setTransformPipelineCapacity(int pipelineCapacity) {
        this.pipelineCapacity = pipelineCapacity;
    }

    public void setBatchCapacity(int batchCapacity) {
        if (this.stagingProxy != null) {
            this.stagingProxy.setBatchCapacity(batchCapacity);
        }
    }

    public void setLimitStandBerichtenToTransform(Integer limitStandBerichtenToTransform) {
        if (this.stagingProxy != null) {
            this.stagingProxy.setLimitStandBerichtenToTransform(limitStandBerichtenToTransform);
        }
    }

    public void setOrderBerichten(boolean orderBerichten) {
        this.orderBerichten = orderBerichten;
    }

    public void setErrorState(String errorState) {
        this.errorState = errorState;
    }

    public void closeBrmoFramework() {
        if (this.stagingProxy != null) {
            this.stagingProxy.closeStagingProxy();
        }
    }

    public Thread toRsgb() throws BrmoException {
        return this.toRsgb(null);
    }

    public Thread toRsgb(ProgressUpdateListener listener) throws BrmoException {
        return this.toRsgb(Bericht.STATUS.STAGING_OK, listener);
    }

    public Thread toRsgb(Bericht.STATUS status, ProgressUpdateListener listener) throws BrmoException {
        RsgbProxy rsgbProxy = new RsgbProxy(this.dataSourceRsgb, this.stagingProxy, status, listener);
        rsgbProxy.setEnablePipeline(this.enablePipeline);
        if (this.pipelineCapacity != null) {
            rsgbProxy.setPipelineCapacity(this.pipelineCapacity);
        }
        rsgbProxy.setRenewConnectionAfterCommit(this.renewConnectionAfterCommit);
        rsgbProxy.setOrderBerichten(this.orderBerichten);
        rsgbProxy.setErrorState(this.errorState);
        Thread t = new Thread(rsgbProxy);
        t.start();
        return t;
    }

    public Thread toRsgb(RsgbProxy.BerichtSelectMode mode, long[] ids, ProgressUpdateListener listener) throws BrmoException {
        Runnable worker;
        String soort = "";
        if (mode == RsgbProxy.BerichtSelectMode.BY_LAADPROCES) {
            try {
                soort = this.stagingProxy.getLaadProcesById(ids[0]).getSoort();
            }
            catch (SQLException ex) {
                throw new BrmoException(ex);
            }
        }
        if (soort.equalsIgnoreCase(BR_BGTLIGHT)) {
            worker = new BGTLightRsgbTransformer(this.dataSourceRsgbBgt, this.stagingProxy, ids, listener);
        } else if (TopNLType.isTopNLType((String)soort)) {
            try {
                worker = new TopNLRsgbTransformer(this.dataSourceTopNL, this.stagingProxy, ids, listener);
            }
            catch (SQLException | JAXBException ex) {
                throw new BrmoException("Probleem met topparser initialiseren: ", ex);
            }
        } else {
            worker = new RsgbProxy(this.dataSourceRsgb, this.stagingProxy, mode, ids, listener);
            ((RsgbProxy)worker).setEnablePipeline(this.enablePipeline);
            if (this.pipelineCapacity != null) {
                ((RsgbProxy)worker).setPipelineCapacity(this.pipelineCapacity);
            }
            ((RsgbProxy)worker).setRenewConnectionAfterCommit(this.renewConnectionAfterCommit);
            ((RsgbProxy)worker).setOrderBerichten(this.orderBerichten);
            ((RsgbProxy)worker).setErrorState(this.errorState);
        }
        Thread t = new Thread(worker);
        t.start();
        return t;
    }

    public Thread toRsgb(UpdateProcess updateProcess, ProgressUpdateListener listener) throws BrmoException {
        RsgbProxy rsgbProxy = new RsgbProxy(this.dataSourceRsgb, this.stagingProxy, updateProcess, listener);
        rsgbProxy.setEnablePipeline(this.enablePipeline);
        if (this.pipelineCapacity != null) {
            rsgbProxy.setPipelineCapacity(this.pipelineCapacity);
        }
        rsgbProxy.setRenewConnectionAfterCommit(this.renewConnectionAfterCommit);
        rsgbProxy.setOrderBerichten(this.orderBerichten);
        rsgbProxy.setErrorState(this.errorState);
        Thread t = new Thread(rsgbProxy);
        t.start();
        return t;
    }

    public void delete(Long id) throws BrmoException {
        if (id != null) {
            try {
                this.stagingProxy.deleteByLaadProcesId(id);
            }
            catch (SQLException ex) {
                throw new BrmoException(ex);
            }
        }
    }

    public List<LaadProces> listLaadProcessen() throws BrmoException {
        try {
            return this.stagingProxy.getLaadProcessen();
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public List<Bericht> listBerichten() throws BrmoException {
        try {
            return this.stagingProxy.getBerichten();
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public void loadFromFile(String type, String fileName) throws BrmoException {
        try {
            this.loadFromFile(type, fileName, null);
        }
        catch (Exception e) {
            if (e instanceof BrmoException) {
                throw (BrmoException)e;
            }
            throw new BrmoException("Fout bij loaden basisregistratie gegevens", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(String type, String fileName, final ProgressUpdateListener listener) throws BrmoException {
        block16: {
            try {
                if (fileName.toLowerCase().endsWith(".zip") && !type.equalsIgnoreCase(BR_BGTLIGHT)) {
                    log.info((Object)("Openen ZIP bestand " + fileName));
                    try (ZipInputStream zip = null;){
                        File f = new File(fileName);
                        if (listener != null) {
                            listener.total(f.length());
                        }
                        CountingInputStream zipCis = new CountingInputStream(new FileInputStream(f)){

                            protected void afterRead(int n) {
                                super.afterRead(n);
                                if (listener != null) {
                                    listener.progress(this.getByteCount());
                                }
                            }
                        };
                        zip = new ZipInputStream((InputStream)zipCis);
                        ZipEntry entry = zip.getNextEntry();
                        while (entry != null) {
                            if (!entry.getName().toLowerCase().endsWith(".xml")) {
                                log.warn((Object)("Overslaan zip entry geen XML: " + entry.getName()));
                            } else {
                                log.info((Object)("Lezen XML bestand uit zip: " + entry.getName()));
                                this.stagingProxy.loadBr((InputStream)new CloseShieldInputStream((InputStream)zip), type, fileName + "/" + entry.getName(), null, null);
                            }
                            entry = zip.getNextEntry();
                        }
                    }
                    log.info((Object)("Klaar met ZIP bestand " + fileName));
                    break block16;
                }
                File f = new File(fileName);
                if (listener != null) {
                    listener.total(f.length());
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(fileName);
                    this.stagingProxy.loadBr(fis, type, fileName, null, listener);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            catch (Exception e) {
                if (e instanceof BrmoException) {
                    throw (BrmoException)e;
                }
                throw new BrmoException("Fout bij loaden basisregistratie gegevens", e);
            }
        }
    }

    public void loadFromStream(String type, InputStream stream, String fileName) throws BrmoException, BrmoDuplicaatLaadprocesException, BrmoLeegBestandException {
        try {
            this.stagingProxy.loadBr(stream, type, fileName, null, null);
        }
        catch (Exception e) {
            if (e instanceof BrmoDuplicaatLaadprocesException) {
                throw (BrmoDuplicaatLaadprocesException)e;
            }
            if (e instanceof BrmoLeegBestandException) {
                throw (BrmoLeegBestandException)e;
            }
            throw new BrmoException("Fout bij laden " + type + " berichten uit bestand " + fileName, e);
        }
    }

    public void loadFromStream(String type, InputStream stream, String fileName, Date d) throws BrmoException, BrmoDuplicaatLaadprocesException, BrmoLeegBestandException {
        try {
            this.stagingProxy.loadBr(stream, type, fileName, d, null);
        }
        catch (Exception e) {
            if (e instanceof BrmoDuplicaatLaadprocesException) {
                throw (BrmoDuplicaatLaadprocesException)e;
            }
            if (e instanceof BrmoLeegBestandException) {
                throw (BrmoLeegBestandException)e;
            }
            throw new BrmoException("Fout bij laden " + type + " berichten uit bestand " + fileName, e);
        }
    }

    public void loadFromStream(String type, InputStream stream, String fileName, ProgressUpdateListener listener) throws BrmoException, BrmoDuplicaatLaadprocesException, BrmoLeegBestandException {
        try {
            this.stagingProxy.loadBr(stream, type, fileName, null, listener);
        }
        catch (Exception e) {
            if (e instanceof BrmoDuplicaatLaadprocesException) {
                throw (BrmoDuplicaatLaadprocesException)e;
            }
            if (e instanceof BrmoLeegBestandException) {
                throw (BrmoLeegBestandException)e;
            }
            throw new BrmoException("Fout bij laden " + type + " berichten uit bestand " + fileName, e);
        }
    }

    public void emptyStagingDb() throws BrmoException {
        try {
            this.stagingProxy.emptyStagingDb();
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public Long getLaadProcesIdByFileName(String name) throws BrmoException {
        LaadProces lp;
        Long id = null;
        try {
            lp = this.stagingProxy.getLaadProcesByFileName(name);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
        if (lp != null) {
            id = lp.getId();
        }
        return id;
    }

    public Bericht getBerichtById(long id) throws BrmoException {
        try {
            return this.stagingProxy.getBerichtById(id);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public LaadProces getLaadProcesById(long id) throws BrmoException {
        try {
            return this.stagingProxy.getLaadProcesById(id);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public List<Bericht> getBerichten(int page, int start, int limit, String sort, String dir, String filterSoort, String filterStatus) throws BrmoException {
        try {
            return this.stagingProxy.getBerichten(page, start, limit, sort, dir, filterSoort, filterStatus);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public List<LaadProces> getLaadprocessen(int page, int start, int limit, String sort, String dir, String filterSoort, String filterStatus) throws BrmoException {
        try {
            return this.stagingProxy.getLaadprocessen(page, start, limit, sort, dir, filterSoort, filterStatus);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public Long[] getLaadProcessenIds(String sort, String dir, String filterSoort, String filterStatus) throws BrmoException {
        try {
            return this.stagingProxy.getLaadProcessenIds(sort, dir, filterSoort, filterStatus);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public long getCountBerichten(String sort, String dir, String filterSoort, String filterStatus) throws BrmoException {
        try {
            return this.stagingProxy.getCountBerichten(sort, dir, filterSoort, filterStatus);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public long getCountLaadProcessen(String sort, String dir, String filterSoort, String filterStatus) throws BrmoException {
        try {
            return this.stagingProxy.getCountLaadProces(sort, dir, filterSoort, filterStatus);
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }

    public long getCountJob() throws BrmoException {
        try {
            return this.stagingProxy.getCountJob();
        }
        catch (SQLException ex) {
            throw new BrmoException(ex);
        }
    }
}

