/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.util;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.brmo.loader.gml.BGTGMLLightLoader;
import nl.b3p.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.loader.jdbc.GeometryJdbcConverterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BGTLightRsgbTransformer
implements Runnable {
    private static final Log LOG = LogFactory.getLog(BGTLightRsgbTransformer.class);
    private final StagingProxy stagingProxy;
    private final DataSource dataSourceRsgbBgt;
    private final ProgressUpdateListener listener;
    private final long[] lpIDs;
    private final Properties params = new Properties();
    private GeometryJdbcConverter geomjdbc = null;
    private final BGTGMLLightLoader gmlLoader = new BGTGMLLightLoader();

    public BGTLightRsgbTransformer(DataSource dataSourceRsgbBgt, StagingProxy stagingProxy, long[] lpIDs, ProgressUpdateListener listener) {
        this.stagingProxy = stagingProxy;
        this.dataSourceRsgbBgt = dataSourceRsgbBgt;
        this.lpIDs = lpIDs;
        this.listener = listener;
    }

    private void transform(long lpID) throws SQLException {
        LaadProces lp = this.stagingProxy.getLaadProcesById(lpID);
        if (lp.getSoort().equalsIgnoreCase("bgtlight") && lp.getStatus() == LaadProces.STATUS.STAGING_OK) {
            File zip = new File(lp.getBestandNaam());
            this.stagingProxy.updateLaadProcesStatus(lp, LaadProces.STATUS.RSGB_BGT_WAITING, "Transformatie loopt...");
            try {
                LaadProces.STATUS status;
                int total = this.gmlLoader.processZipFile(zip);
                switch (this.gmlLoader.getStatus()) {
                    case OK: {
                        status = LaadProces.STATUS.RSGB_BGT_OK;
                        break;
                    }
                    default: {
                        status = LaadProces.STATUS.RSGB_BGT_NOK;
                    }
                }
                this.stagingProxy.updateLaadProcesStatus(lp, status, this.gmlLoader.getOpmerkingen());
            }
            catch (IOException | IllegalArgumentException ex) {
                LOG.error((Object)("Laden van bestand " + zip + " is mislukt."), (Throwable)ex);
                String opmerkingen = this.gmlLoader.getOpmerkingen() + "\nLaden van bestand " + zip + " is mislukt: " + ex.getLocalizedMessage();
                this.stagingProxy.updateLaadProcesStatus(lp, LaadProces.STATUS.RSGB_BGT_NOK, opmerkingen);
            }
        } else {
            LOG.warn((Object)("LaadProces " + lp.getId() + " van soort " + lp.getSoort() + " met status: " + (Object)((Object)lp.getStatus()) + " is overgeslagen."));
        }
    }

    public void init() throws SQLException, IOException {
        this.geomjdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)this.dataSourceRsgbBgt.getConnection());
        this.params.put("jndiReferenceName", "java:comp/env/jdbc/brmo/rsgbbgt");
        this.params.put("dbtype", this.geomjdbc.getGeotoolsDBTypeName());
        this.params.put("schema", this.geomjdbc.getSchema());
        this.gmlLoader.setDbConnProps(this.params);
        this.gmlLoader.setIsOracle(this.geomjdbc.getGeotoolsDBTypeName().toLowerCase().contains("oracle"));
        this.gmlLoader.setIsMSSQL(this.geomjdbc.getGeotoolsDBTypeName().toLowerCase().contains("sqlserver"));
        LOG.info((Object)String.format("Alle BGT tabellen worden nu leeggemaakt voordat %d laadprocessen worden getransformeerd (Let op! Transformeer alle laadprocessen voor BGT kaartbladen tegelijkertijd)", this.lpIDs.length));
        this.gmlLoader.truncateTables();
    }

    @Override
    public void run() {
        block4: {
            try {
                this.init();
                int count = 0;
                if (this.listener != null) {
                    this.listener.total(this.lpIDs.length);
                    this.listener.progress(count);
                }
                for (long id : this.lpIDs) {
                    this.transform(id);
                    ++count;
                    if (this.listener == null) continue;
                    this.listener.progress(count);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Fout tijdens verwerken BGT laadprocessen", (Throwable)e);
                if (this.listener == null) break block4;
                this.listener.exception(e);
            }
        }
    }
}

