/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.entity.NhrBericht;
import nl.b3p.brmo.loader.entity.NhrBerichten;
import nl.b3p.brmo.loader.util.BrmoLeegBestandException;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NhrXMLReader
extends BrmoXMLReader {
    public static final String PREFIX = "nhr.bsn.natPers.";
    private static final Log LOG = LogFactory.getLog(NhrXMLReader.class);
    private static Templates splitTemplates;
    private static Transformer t;
    private Iterator<NhrBericht> iterator;
    private int volgorde = 0;
    private String brOrigXML = null;

    public NhrXMLReader(InputStream in) throws Exception {
        this.initTemplates();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        in = new TeeInputStream(in, (OutputStream)bos, true);
        DOMResult r = new DOMResult();
        splitTemplates.newTransformer().transform(new StreamSource(in), r);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{NhrBerichten.class, NhrBericht.class, Bericht.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        NhrBerichten b = (NhrBerichten)unmarshaller.unmarshal((Source)new DOMSource(r.getNode()));
        if (b == null || b.berichten == null) {
            throw new BrmoLeegBestandException("Geen BRMO berichten gevonden in NHR XML");
        }
        if (!b.berichten.isEmpty()) {
            this.setBestandsDatum(b.berichten.get(0).getDatum());
        }
        this.iterator = b.berichten.iterator();
        this.brOrigXML = bos.toString(StandardCharsets.UTF_8.name());
        LOG.debug((Object)("Originele nHR xml is: \n" + this.brOrigXML));
        this.init();
    }

    private synchronized void initTemplates() throws Exception {
        if (splitTemplates == null) {
            LOG.info((Object)"Initializing NHR split XSL templates...");
            StreamSource xsl = new StreamSource(this.getClass().getResourceAsStream("/xsl/nhr-split-3.0.xsl"));
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    return new StreamSource(NhrXMLReader.class.getResourceAsStream("/xsl/" + href));
                }
            });
            splitTemplates = tf.newTemplates(xsl);
            t = TransformerFactory.newInstance().newTransformer();
        }
    }

    @Override
    public void init() throws Exception {
        this.soort = "nhr";
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.iterator.hasNext();
    }

    @Override
    public NhrBericht next() throws Exception {
        NhrBericht b = this.iterator.next();
        StringWriter sw = new StringWriter();
        t.transform(new DOMSource(b.getNode().getFirstChild()), new StreamResult(sw));
        StringBuilder xml = new StringBuilder(sw.toString());
        String bsns = this.getXML(this.extractBSN(xml.toString()));
        xml.insert(xml.lastIndexOf("</"), bsns);
        b.setBrXml(xml.toString());
        if (this.volgorde == 0) {
            b.setBrOrgineelXml(this.brOrigXML);
        }
        b.setVolgordeNummer(this.volgorde++);
        return b;
    }

    public Map<String, String> extractBSN(String brXml) {
        HashMap<String, String> bsnHashes = new HashMap<String, String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(brXml)));
            NodeList nodeList = doc.getElementsByTagName("cat:bsn");
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                LOG.debug((Object)nodeList.item(i).getTextContent());
                bsnHashes.put(nodeList.item(i).getTextContent(), this.getHash(nodeList.item(i).getTextContent()));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error((Object)"Fout tijdens toevoegen bsn hashes", (Throwable)e);
        }
        return bsnHashes;
    }

    public String getXML(Map<String, String> map) throws ParserConfigurationException {
        StringBuilder root = new StringBuilder();
        if (!map.isEmpty()) {
            root.append("<cat:bsnhashes>");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey().isEmpty() || entry.getValue().isEmpty()) continue;
                root.append("<cat:").append(PREFIX).append(entry.getKey()).append(">").append(entry.getValue()).append("</cat:").append(PREFIX).append(entry.getKey()).append(">");
            }
            root.append("</cat:bsnhashes>");
        }
        return root.toString();
    }
}

