/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.xml;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.util.RsgbTransformer;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BRPXMLReader
extends BrmoXMLReader {
    private InputStream in;
    private NodeList nodes = null;
    private int index;
    private Templates template;
    private final String pathToXsl = "/xsl/brp-brxml-preprocessor.xsl";
    public static final String PREFIX = "NL.BRP.Persoon.";
    private StagingProxy staging;

    public BRPXMLReader(InputStream in, Date d, StagingProxy staging) throws Exception {
        this.in = in;
        this.staging = staging;
        this.setBestandsDatum(d);
        this.init();
    }

    @Override
    public void init() throws Exception {
        this.soort = "brp";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(this.in);
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                return new StreamSource(RsgbTransformer.class.getResourceAsStream("/xsl/" + href));
            }
        });
        StreamSource xsl = new StreamSource(this.getClass().getResourceAsStream("/xsl/brp-brxml-preprocessor.xsl"));
        this.template = tf.newTemplates(xsl);
        this.nodes = doc.getDocumentElement().getChildNodes();
        this.index = 0;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.index < this.nodes.getLength();
    }

    @Override
    public Bericht next() throws Exception {
        Node n = this.nodes.item(this.index);
        ++this.index;
        String object_ref = this.getObjectRef(n);
        StringWriter sw = new StringWriter();
        Bericht old = this.staging.getPreviousBericht(object_ref, this.getBestandsDatum(), -1L, new StringBuilder());
        Transformer t = old != null ? this.template.newTransformer() : TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.transform(new DOMSource(n), new StreamResult(sw));
        Map<String, String> bsns = this.extractBSN(n);
        String el = this.getXML(bsns);
        String origXML = sw.toString();
        String brXML = "<root>" + origXML;
        brXML = brXML + el + "</root>";
        Bericht b = new Bericht(brXML);
        b.setBrOrgineelXml(origXML);
        b.setVolgordeNummer(this.index);
        b.setObjectRef(object_ref);
        b.setSoort("brp");
        b.setDatum(this.getBestandsDatum());
        return b;
    }

    private String getObjectRef(Node n) {
        NodeList childs = n.getChildNodes();
        String hash = null;
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            String name = child.getNodeName();
            if (!name.contains("bsn-nummer")) continue;
            hash = child.getTextContent();
            hash = this.getHash(hash);
            break;
        }
        return PREFIX + hash;
    }

    public Map<String, String> extractBSN(Node n) throws XPathExpressionException {
        HashMap<String, String> hashes = new HashMap<String, String>();
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile("//*[local-name() = 'bsn-nummer']");
        NodeList nodelist = (NodeList)expr.evaluate(n, XPathConstants.NODESET);
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node bsn = nodelist.item(i);
            String bsnString = bsn.getTextContent();
            String hash = this.getHash(bsnString);
            hashes.put(bsnString, hash);
        }
        return hashes;
    }

    public String getXML(Map<String, String> map) throws ParserConfigurationException {
        String root = "<bsnhashes>";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().isEmpty() || entry.getValue().isEmpty()) continue;
            String hash = entry.getValue();
            String el = "<NL.BRP.Persoon." + entry.getKey() + ">" + hash + "</" + PREFIX + entry.getKey() + ">";
            root = root + el;
        }
        root = root + "</bsnhashes>";
        return root;
    }
}

