/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.xml;

import java.io.File;
import java.util.Date;
import java.util.StringTokenizer;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;

public class TopNLFileReader
extends BrmoXMLReader {
    private long fileSize = 0L;

    public TopNLFileReader(String fileName, String soort) throws Exception {
        if (fileName != null) {
            this.setBestandsNaam(fileName);
        }
        this.soort = soort == null ? "topnl" : soort;
        this.init();
    }

    @Override
    public void init() throws Exception {
        File input = new File(this.getBestandsNaam());
        this.fileSize = input.length();
        this.setBestandsDatum(new Date());
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setBestandsNaam(String naam) {
        super.setBestandsNaam(naam);
        StringTokenizer parts = new StringTokenizer(naam.substring(naam.lastIndexOf(File.separator) + 1, naam.length()), "_-.", false);
        if (parts.countTokens() > 2) {
            this.setGebied(parts.nextToken() + " blad " + parts.nextToken());
        } else {
            this.setGebied("Nederland");
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return false;
    }

    @Override
    public Bericht next() throws Exception {
        return null;
    }
}

