/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.checks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.checks.Afgifte;
import nl.b3p.brmo.loader.checks.AfgiftelijstParser;
import nl.b3p.brmo.loader.checks.AfgiftelijstReport;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.entity.LaadProces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AfgifteChecker {
    private static final Log log = LogFactory.getLog(AfgifteChecker.class);
    private List<Afgifte> afgiftes;
    private StagingProxy staging;

    public void init(String input, StagingProxy staging) throws IOException {
        try (FileInputStream fin = new FileInputStream(new File(input));){
            this.init(fin, staging);
        }
    }

    public void init(InputStream input, StagingProxy staging) throws IOException {
        this.staging = staging;
        AfgiftelijstParser ap = new AfgiftelijstParser();
        this.afgiftes = ap.parse(input);
    }

    public void check() {
        this.afgiftes.forEach(afgifte -> this.check((Afgifte)afgifte));
    }

    private void check(Afgifte afgifte) {
        try {
            LaadProces lp = this.staging.getLaadProcesByRestoredFilename(afgifte.getBestandsnaam());
            if (lp != null) {
                afgifte.setFoundInStaging(true);
                this.processFoundLaadprocess(afgifte, lp);
            }
        }
        catch (SQLException ex) {
            log.error((Object)("Error querying staging for laadproces for afgifte: " + afgifte.toString()), (Throwable)ex);
        }
    }

    private void processFoundLaadprocess(Afgifte afgifte, LaadProces lp) throws SQLException {
        List<Bericht> berichten = this.staging.getBerichtByLaadProces(lp);
        Map<Bericht.STATUS, Integer> counts = afgifte.getStatussen();
        berichten.stream().map(bericht -> {
            if (!counts.containsKey((Object)bericht.getStatus())) {
                counts.put(bericht.getStatus(), 0);
            }
            return bericht;
        }).forEachOrdered(bericht -> counts.put(bericht.getStatus(), (Integer)counts.get((Object)bericht.getStatus()) + 1));
    }

    public File getResults(String input, String f) throws FileNotFoundException {
        return this.getResults(input, new File(f));
    }

    public File getResults(String input, File f) throws FileNotFoundException {
        AfgiftelijstReport reporter = new AfgiftelijstReport();
        reporter.createReport(this.afgiftes, input, f);
        return f;
    }
}

