/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import nl.b3p.brmo.loader.entity.BagBericht;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BagXMLReader
extends BrmoXMLReader {
    private static final Log log = LogFactory.getLog(BagXMLReader.class);
    private final XMLInputFactory factory = XMLInputFactory.newInstance();
    private final XMLStreamReader streamReader;
    private final Transformer transformer;
    private final DocumentBuilder builder;
    private final XMLOutputFactory xmlof;
    public static final String MUTATIE_PRODUCT = "Mutatie-product";
    public static final String LVC_PRODUCT = "LVC-product";
    private static final String DATUM_TIJD_LV = "datumtijdstempelLV";
    private static final String MUTATIE_DATUMTOT = "MutatiedatumTot";
    private static final String STAND_PEILDATUM = "StandPeildatum";
    private static final String STAND_TECHNISCHEDATUM = "StandTechnischeDatum";
    private BagBericht nextBericht = null;
    public static final Map<String, String> lvcProductToObjectType = Map.of("Ligplaats", "LIG", "Nummeraanduiding", "NUM", "OpenbareRuimte", "OPR", "Pand", "PND", "Verblijfsobject", "VBO", "Standplaats", "STA", "Woonplaats", "WPL");

    public BagXMLReader(InputStream in) throws XMLStreamException, TransformerConfigurationException, ParserConfigurationException {
        this.streamReader = this.factory.createXMLStreamReader(in);
        TransformerFactory tf = TransformerFactory.newInstance();
        this.transformer = tf.newTransformer();
        this.xmlof = XMLOutputFactory.newInstance();
        this.xmlof.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        dbfactory.setNamespaceAware(true);
        this.builder = dbfactory.newDocumentBuilder();
        this.init();
    }

    @Override
    public void init() {
        this.soort = "bag";
        String technischeDatum = null;
        String peilDatum = null;
        String mutatieDatumTot = null;
        boolean firstStartElement = true;
        try {
            while (this.streamReader.hasNext()) {
                if (this.streamReader.isStartElement()) {
                    String localName = this.streamReader.getLocalName();
                    if (localName.equals(MUTATIE_PRODUCT) || localName.equals(LVC_PRODUCT) || lvcProductToObjectType.containsKey(localName) && firstStartElement) break;
                    if (localName.equals(DATUM_TIJD_LV)) {
                        this.setDatumAsString(this.streamReader.getElementText());
                    }
                    if (localName.equals(STAND_TECHNISCHEDATUM)) {
                        technischeDatum = this.streamReader.getElementText();
                    }
                    if (localName.equals(STAND_PEILDATUM)) {
                        peilDatum = this.streamReader.getElementText();
                    }
                    if (localName.equals(MUTATIE_DATUMTOT)) {
                        mutatieDatumTot = this.streamReader.getElementText();
                    }
                    firstStartElement = false;
                }
                this.streamReader.next();
            }
        }
        catch (XMLStreamException ex) {
            log.error((Object)"Error while streaming XML", (Throwable)ex);
        }
        if (peilDatum != null) {
            this.setDatumAsString(peilDatum, "yyyyMMdd");
        } else if (technischeDatum != null) {
            this.setDatumAsString(technischeDatum, "yyyyMMdd");
        } else if (mutatieDatumTot != null) {
            this.setDatumAsString(mutatieDatumTot, "yyyy-MM-dd");
        } else {
            this.setBestandsDatum(new Date());
        }
    }

    @Override
    public boolean hasNext() throws SAXException, IOException, TransformerException {
        if (this.nextBericht != null) {
            return true;
        }
        try {
            while (this.streamReader.hasNext()) {
                Document d;
                StringWriter sw;
                if (this.streamReader.isStartElement() && this.streamReader.getLocalName().equals(MUTATIE_PRODUCT)) {
                    sw = new StringWriter();
                    this.transformer.transform(new StAXSource(this.streamReader), new StAXResult(this.xmlof.createXMLStreamWriter(sw)));
                    d = this.builder.parse(new InputSource(new StringReader(sw.toString())));
                    if (!this.createMutatieBagBericht(sw.toString(), d)) continue;
                    return true;
                }
                if (this.streamReader.isStartElement() && lvcProductToObjectType.containsKey(this.streamReader.getLocalName())) {
                    sw = new StringWriter();
                    this.transformer.transform(new StAXSource(this.streamReader), new StAXResult(this.xmlof.createXMLStreamWriter(sw)));
                    d = this.builder.parse(new InputSource(new StringReader(sw.toString())));
                    if (!this.createStandBagBericht(sw.toString(), d)) continue;
                    return true;
                }
                this.streamReader.next();
            }
        }
        catch (XMLStreamException ex) {
            log.error((Object)"Error while streaming XML", (Throwable)ex);
        }
        return false;
    }

    @Override
    public BagBericht next() throws TransformerException, XMLStreamException {
        BagBericht b = this.nextBericht;
        this.nextBericht = null;
        return b;
    }

    private boolean createStandBagBericht(String brXml, Document d) {
        if (this.gebruikStandBericht(d.getDocumentElement())) {
            this.nextBericht = new BagBericht(brXml, d);
            Date datBegGeld = this.getBerichtBeginGeldigheid(d.getDocumentElement());
            if (datBegGeld != null && this.getBestandsDatum().before(datBegGeld)) {
                this.nextBericht.setDatum(datBegGeld);
                this.nextBericht.setVolgordeNummer(0);
            } else {
                this.nextBericht.setDatum(this.getBestandsDatum());
                this.nextBericht.setVolgordeNummer(-1);
            }
            return true;
        }
        return false;
    }

    private boolean createMutatieBagBericht(String brXml, Document d) {
        NodeList children = d.getDocumentElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"Nieuw".equals(child.getLocalName())) continue;
            NodeList grandchildren = child.getChildNodes();
            for (int j = 0; j < grandchildren.getLength(); ++j) {
                Node grandchild = grandchildren.item(j);
                if (grandchild.getNodeType() != 1) continue;
                this.nextBericht = new BagBericht(brXml, d);
                Date datBegGeld = this.getBerichtBeginGeldigheid(grandchild);
                if (datBegGeld != null && this.getBestandsDatum().before(datBegGeld)) {
                    this.nextBericht.setDatum(datBegGeld);
                }
                return true;
            }
        }
        return false;
    }

    private boolean gebruikStandBericht(Node n) {
        String soort = n.getLocalName();
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("tijdvakgeldigheid".equals(child.getLocalName())) {
                NodeList grandchildren = child.getChildNodes();
                for (int j = 0; j < grandchildren.getLength(); ++j) {
                    Node grandchild = grandchildren.item(j);
                    if (!"einddatumTijdvakGeldigheid".equals(grandchild.getLocalName())) continue;
                    String dateString = grandchild.getTextContent().substring(0, 8);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    Date eindGeldigheidDatum = null;
                    try {
                        eindGeldigheidDatum = sdf.parse(dateString);
                    }
                    catch (ParseException pe) {
                        log.error((Object)("Fout bij parsen datum \"" + dateString + "\" met formaat yyyyMMdd"), (Throwable)pe);
                    }
                    if (eindGeldigheidDatum == null || !this.getBestandsDatum().after(eindGeldigheidDatum)) continue;
                    return false;
                }
            }
            if (!"aanduidingRecordInactief".equals(child.getLocalName()) || !child.getTextContent().equalsIgnoreCase("J")) continue;
            return false;
        }
        return true;
    }

    private Date getBerichtBeginGeldigheid(Node n) {
        NodeList children = n.getChildNodes();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date beginGeldigheid = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"tijdvakgeldigheid".equals(child.getLocalName())) continue;
            NodeList grandchildren = child.getChildNodes();
            for (int j = 0; j < grandchildren.getLength(); ++j) {
                Node grandchild = grandchildren.item(j);
                if (!"begindatumTijdvakGeldigheid".equals(grandchild.getLocalName())) continue;
                String dateString = grandchild.getTextContent().substring(0, 8);
                try {
                    beginGeldigheid = sdf.parse(dateString);
                    continue;
                }
                catch (ParseException pe) {
                    log.error((Object)("Fout bij parsen datum \"" + dateString + "\" met formaat yyyyMMdd"), (Throwable)pe);
                }
            }
        }
        return beginGeldigheid;
    }
}

