/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.sql.DataSource;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.brmo.loader.BerichtenHandler;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.updates.UpdateProcess;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.loader.util.DataComfortXMLReader;
import nl.b3p.brmo.loader.util.RsgbBRPTransformer;
import nl.b3p.brmo.loader.util.RsgbTransformer;
import nl.b3p.brmo.loader.util.RsgbWOZTransformer;
import nl.b3p.brmo.loader.util.TableData;
import nl.b3p.brmo.loader.util.TableRow;
import nl.b3p.jdbc.util.converter.ColumnMetadata;
import nl.b3p.jdbc.util.converter.GeometryJdbcConverter;
import nl.b3p.jdbc.util.converter.GeometryJdbcConverterFactory;
import nl.b3p.jdbc.util.converter.OracleJdbcConverter;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RsgbProxy
implements Runnable,
BerichtenHandler {
    private static final Log log = LogFactory.getLog(RsgbProxy.class);
    private final boolean alsoExecuteSql = true;
    private final ProgressUpdateListener listener;
    private final BerichtSelectMode mode;
    private final UpdateProcess updateProcess;
    private final Map<String, PreparedStatement> checkRowExistsStatements = new HashMap<String, PreparedStatement>();
    private final Map<String, PreparedStatement> insertSqlPreparedStatements = new HashMap<String, PreparedStatement>();
    private final Map<String, PreparedStatement> updateSqlPreparedStatements = new HashMap<String, PreparedStatement>();
    private final Map<String, PreparedStatement> createDeleteSqlStatements = new HashMap<String, PreparedStatement>();
    private final Map<String, List<String>> primaryKeyCache = new HashMap<String, List<String>>();
    private final DataComfortXMLReader dbXmlReader = new DataComfortXMLReader();
    private final DataComfortXMLReader oldDbXmlReader = new DataComfortXMLReader();
    private int processed;
    private Bericht.STATUS status;
    private long[] berichtIds;
    private long[] laadprocesIds;
    private PreparedStatement insertMetadataStatement;
    private DatabaseMetaData dbMetadata = null;
    private DatabaseMetaData dbMetadataBrk = null;
    private final Map<String, String> tables = new HashMap<String, String>();
    private final Map<String, SortedSet<ColumnMetadata>> tableColumns = new HashMap<String, SortedSet<ColumnMetadata>>();
    private Connection connRsgb = null;
    private Connection connRsgbBrk = null;
    private GeometryJdbcConverter geomToJdbc = null;
    private GeometryJdbcConverter geomToJdbcBrk = null;
    private Savepoint recentSavepoint = null;
    private String herkomstMetadata = null;
    private final DataSource dataSourceRsgb;
    private final DataSource dataSourceRsgbBrk;
    private final StagingProxy stagingProxy;
    private boolean enablePipeline = false;
    private int pipelineCapacity = 25;
    private boolean renewConnectionAfterCommit = false;
    private boolean orderBerichten = true;
    private String errorState = null;
    private final Map<String, RsgbTransformer> rsgbTransformers = new HashMap<String, RsgbTransformer>();
    private String simonNamePrefix = "b3p.rsgb.";

    public RsgbProxy(DataSource dataSourceRsgb, DataSource dataSourceRsgbBrk, StagingProxy stagingProxy, Bericht.STATUS status, ProgressUpdateListener listener) {
        this.stagingProxy = stagingProxy;
        this.dataSourceRsgb = dataSourceRsgb;
        this.dataSourceRsgbBrk = dataSourceRsgbBrk;
        this.mode = BerichtSelectMode.BY_STATUS;
        this.status = status;
        this.listener = listener;
        this.updateProcess = null;
    }

    public RsgbProxy(DataSource dataSourceRsgb, DataSource dataSourceRsgbBrk, StagingProxy stagingProxy, BerichtSelectMode mode, long[] ids, ProgressUpdateListener listener) {
        this.stagingProxy = stagingProxy;
        this.dataSourceRsgb = dataSourceRsgb;
        this.dataSourceRsgbBrk = dataSourceRsgbBrk;
        this.mode = mode;
        if (mode == BerichtSelectMode.BY_LAADPROCES) {
            this.laadprocesIds = ids;
        } else if (mode == BerichtSelectMode.BY_IDS) {
            this.berichtIds = ids;
        }
        this.listener = listener;
        this.updateProcess = null;
    }

    public RsgbProxy(DataSource dataSourceRsgb, DataSource dataSourceRsgbBrk, StagingProxy stagingProxy, UpdateProcess updateProcess, ProgressUpdateListener listener) {
        this.stagingProxy = stagingProxy;
        this.dataSourceRsgb = dataSourceRsgb;
        this.dataSourceRsgbBrk = dataSourceRsgbBrk;
        this.mode = BerichtSelectMode.FOR_UPDATE;
        this.updateProcess = updateProcess;
        this.listener = listener;
    }

    public void setSimonNamePrefix(String prefix) {
        this.simonNamePrefix = prefix;
    }

    public void setEnablePipeline(boolean enablePipeline) {
        this.enablePipeline = enablePipeline;
    }

    public void setPipelineCapacity(int pipelineCapacity) {
        this.pipelineCapacity = pipelineCapacity;
    }

    public void setRenewConnectionAfterCommit(boolean renewConnectionAfterCommit) {
        this.renewConnectionAfterCommit = renewConnectionAfterCommit;
    }

    public void setOrderBerichten(boolean orderBerichten) {
        this.orderBerichten = orderBerichten;
    }

    public void setErrorState(String errorState) {
        this.errorState = errorState;
    }

    public void init() throws SQLException {
        ResultSet tablesRs = null;
        if (null != this.dataSourceRsgb) {
            this.connRsgb = this.dataSourceRsgb.getConnection();
            this.geomToJdbc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)this.connRsgb);
            try {
                this.dbMetadata = this.connRsgb.getMetaData();
                tablesRs = this.dbMetadata.getTables(null, this.geomToJdbc.getSchema(), "%", new String[]{"TABLE"});
                while (tablesRs.next()) {
                    this.tables.put(tablesRs.getString("TABLE_NAME").toLowerCase(), tablesRs.getString("TABLE_NAME"));
                }
            }
            catch (SQLException sqlEx) {
                try {
                    throw new SQLException("Fout bij ophalen rsgb tabellen: ", sqlEx);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(tablesRs);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly((ResultSet)tablesRs);
        }
        if (null != this.dataSourceRsgbBrk) {
            this.connRsgbBrk = this.dataSourceRsgbBrk.getConnection();
            this.geomToJdbcBrk = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)this.connRsgbBrk);
            try {
                this.dbMetadataBrk = this.connRsgbBrk.getMetaData();
                tablesRs = this.dbMetadataBrk.getTables(null, this.geomToJdbcBrk.getSchema(), "%", new String[]{"TABLE"});
                while (tablesRs.next()) {
                    this.tables.put(tablesRs.getString("TABLE_NAME").toLowerCase(), tablesRs.getString("TABLE_NAME"));
                }
            }
            catch (SQLException sqlEx) {
                try {
                    throw new SQLException("Fout bij ophalen rsgb brk tabellen: ", sqlEx);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(tablesRs);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly((ResultSet)tablesRs);
        }
    }

    private PreparedStatement checkAndGetPreparedStatement(Map<String, PreparedStatement> m, String name) throws SQLException {
        PreparedStatement stm = m.get(name);
        if (stm == null || stm.isClosed()) {
            return null;
        }
        stm.clearParameters();
        return stm;
    }

    public void checkAndAddStatement(Map<String, PreparedStatement> m, String tableName, PreparedStatement stmt) {
        m.put(tableName, stmt);
    }

    public void close() {
        for (PreparedStatement stmt : this.checkRowExistsStatements.values()) {
            DbUtils.closeQuietly((Statement)stmt);
        }
        this.checkRowExistsStatements.clear();
        for (PreparedStatement stmt : this.insertSqlPreparedStatements.values()) {
            DbUtils.closeQuietly((Statement)stmt);
        }
        this.insertSqlPreparedStatements.clear();
        for (PreparedStatement stmt : this.updateSqlPreparedStatements.values()) {
            DbUtils.closeQuietly((Statement)stmt);
        }
        this.updateSqlPreparedStatements.clear();
        for (PreparedStatement stmt : this.createDeleteSqlStatements.values()) {
            DbUtils.closeQuietly((Statement)stmt);
        }
        this.createDeleteSqlStatements.clear();
        if (this.insertMetadataStatement != null) {
            DbUtils.closeQuietly((Statement)this.insertMetadataStatement);
        }
        this.insertMetadataStatement = null;
        DbUtils.closeQuietly((Connection)this.connRsgb);
        this.connRsgb = null;
        DbUtils.closeQuietly((Connection)this.connRsgbBrk);
        this.connRsgbBrk = null;
    }

    @Override
    public void renewConnection() throws SQLException {
        this.close();
        this.init();
    }

    @Override
    public void run() {
        block4: {
            try {
                this.init();
                long total = this.setWaitingStatus();
                if (this.listener != null) {
                    this.listener.total(total);
                }
                if (total > 0L) {
                    this.stagingProxy.handleBerichtenByJob(total, this, this.enablePipeline, this.pipelineCapacity, this.orderBerichten);
                }
            }
            catch (Exception e) {
                log.error((Object)"Fout tijdens verwerken berichten", (Throwable)e);
                if (this.listener == null) break block4;
                this.listener.exception(e);
            }
        }
        this.close();
    }

    private long setWaitingStatus() throws SQLException, BrmoException {
        this.stagingProxy.cleanJob();
        long count = this.stagingProxy.getCountJob();
        if (count > 0L && !this.mode.equals((Object)BerichtSelectMode.RETRY_WAITING)) {
            throw new BrmoException("Vorige transformatie is afgebroken, verwerk eerst die berichten (zie job-tabel)!");
        }
        switch (this.mode) {
            case BY_STATUS: {
                return this.stagingProxy.setBerichtenJobByStatus(this.status, this.orderBerichten);
            }
            case BY_IDS: {
                return this.stagingProxy.setBerichtenJobByIds(this.berichtIds, this.orderBerichten);
            }
            case BY_LAADPROCES: {
                return this.stagingProxy.setBerichtenJobByLaadprocessen(this.laadprocesIds, this.orderBerichten);
            }
            case FOR_UPDATE: {
                return this.stagingProxy.setBerichtenJobForUpdate(this.updateProcess.getSoort(), this.orderBerichten);
            }
            case RETRY_WAITING: {
                return count;
            }
        }
        return 0L;
    }

    @Override
    public void updateProcessingResult(Bericht ber) {
        if (this.updateProcess != null) {
            return;
        }
        ber.setStatusDatum(new java.util.Date());
        try {
            this.stagingProxy.updateBerichtProcessing(ber);
        }
        catch (SQLException ex) {
            log.error((Object)"Kan status niet updaten", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableData> transformToTableData(Bericht ber) throws BrmoException {
        if (this.updateProcess != null) {
            return this.transformUpdateTableData(ber);
        }
        StringBuilder loadLog = new StringBuilder();
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
        try {
            loadLog.append(String.format("%s: transformeren %s bericht object ref %s, met id %s, berichtdatum %s\n", dateTimeFormat.format(new java.util.Date()), ber.getSoort(), ber.getObjectRef(), ber.getId(), dateFormat.format(ber.getDatum())));
            RsgbTransformer transformer = this.getTransformer(ber.getSoort());
            long startTime = System.currentTimeMillis();
            this.stagingProxy.updateBerichtenDbXml(Collections.singletonList(ber), transformer);
            Split split = SimonManager.getStopwatch((String)"b3p.staging.bericht.dbxml.read").start();
            StringReader nReader = new StringReader(ber.getDbXml());
            List<TableData> data = this.dbXmlReader.readDataXML(new StreamSource(nReader));
            split.stop();
            loadLog.append(String.format("Transformeren naar RSGB database-xml en lezen resultaat: %4.1fs\n\n", (double)(System.currentTimeMillis() - startTime) / 1000.0));
            ber.setOpmerking(loadLog.toString());
            return data;
        }
        catch (Exception e) {
            try {
                this.updateBerichtException(ber, e);
            }
            finally {
                this.updateProcessingResult(ber);
            }
            return null;
        }
    }

    public List<TableData> transformUpdateTableData(Bericht ber) throws BrmoException {
        RsgbTransformer transformer = this.rsgbTransformers.get(this.updateProcess.getName());
        if (transformer == null) {
            try {
                transformer = new RsgbTransformer(this.updateProcess.getXsl());
            }
            catch (Exception e) {
                throw new BrmoException("Fout bij laden XSL stylesheet: " + this.updateProcess.getXsl(), e);
            }
            this.rsgbTransformers.put(this.updateProcess.getName(), transformer);
        }
        try {
            Node dbxml = transformer.transformToDbXmlNode(ber);
            return this.dbXmlReader.readDataXML(new DOMSource(dbxml));
        }
        catch (Exception e) {
            log.error((Object)("Fout bij transformeren bericht #" + ber.getId() + " voor update"), (Throwable)e);
            throw new BrmoException("Fout bij transformeren bericht #" + ber.getId() + " voor update: " + e.getClass() + ": " + e.getMessage());
        }
    }

    public void updateBerichtException(Bericht ber, Throwable e) throws BrmoException {
        ber.setStatus(Bericht.STATUS.RSGB_NOK);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        ber.setOpmerking(ber.getOpmerking() + "\nFout: " + sw);
        if (this.orderBerichten && (this.errorState == null || !this.errorState.equalsIgnoreCase("ignore"))) {
            log.fatal((Object)"Mutatieverwerking en foutief bericht, dus stoppen!", e);
            throw new BrmoException("Mutatieverwerking en foutief bericht, dus stoppen!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Bericht ber, List<TableData> pretransformedTableData, boolean updateResult) throws BrmoException {
        block46: {
            if (this.updateProcess != null) {
                this.update(ber, pretransformedTableData);
                return;
            }
            Connection conn = this.connRsgb;
            GeometryJdbcConverter jdbcConverter = this.geomToJdbc;
            DatabaseMetaData metaData = this.dbMetadata;
            if (ber.getSoort().equalsIgnoreCase("brk2")) {
                conn = this.connRsgbBrk;
                jdbcConverter = this.geomToJdbcBrk;
                metaData = this.dbMetadataBrk;
            }
            Bericht.STATUS newStatus = Bericht.STATUS.RSGB_OK;
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:SSS");
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            log.debug((Object)String.format("RSGB verwerking van %s bericht met id %s, object_ref %s, datum %tc", ber.getSoort(), ber.getId(), ber.getObjectRef(), ber.getDatum()));
            StringBuilder loadLog = pretransformedTableData == null ? new StringBuilder() : new StringBuilder(ber.getOpmerking());
            loadLog.append(String.format("%s: start verwerking %s bericht object ref %s, met id %s, berichtdatum %s\n", dateTimeFormat.format(new java.util.Date()), ber.getSoort(), ber.getObjectRef(), ber.getId(), dateFormat.format(ber.getDatum())));
            this.setHerkomstMetadata(ber.getSoort());
            long startTime = 0L;
            try {
                List<TableData> newList;
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                if (pretransformedTableData != null) {
                    loadLog.append("Bericht was al getransformeerd in pipeline\n");
                    newList = pretransformedTableData;
                } else {
                    loadLog.append("Transformeren naar RSGB database-xml en lezen resultaat... ");
                    startTime = System.currentTimeMillis();
                    newList = this.transformToTableData(ber);
                    loadLog.append(String.format("%4.1fs\n", (double)(System.currentTimeMillis() - startTime) / 1000.0));
                }
                startTime = System.currentTimeMillis();
                Bericht oud = null;
                if (this.orderBerichten) {
                    oud = this.stagingProxy.getOldBericht(ber, loadLog);
                } else {
                    if (ber.getVolgordeNummer() >= 0) {
                        throw new BrmoException("Standverwerking, maar bericht is mutatie: niet verwerken!");
                    }
                    loadLog.append("Standverwerking, gegevens worden alleen toegevoegd als ze nog niet bestaan!\n");
                }
                if (oud != null) {
                    loadLog.append(String.format("Eerder bericht (id: %d) voor zelfde object gevonden van datum %s, volgnummer %d,status %s op %s\n", oud.getId(), dateTimeFormat.format(oud.getDatum()), oud.getVolgordeNummer(), oud.getStatus().toString(), dateTimeFormat.format(oud.getStatusDatum())));
                    if (ber.getDatum().equals(oud.getDatum()) && ber.getVolgordeNummer().equals(oud.getVolgordeNummer())) {
                        if (Objects.equals(ber.getId(), oud.getId())) {
                            loadLog.append(oud.getOpmerking());
                        } else {
                            loadLog.append("Datum en volgordenummer van nieuw bericht hetzelfde als de oude, negeer dit bericht!\n");
                            boolean dbXmlEquals = ber.getDbXml().equals(oud.getDbXml());
                            if (!dbXmlEquals) {
                                String s = String.format("Bericht %d met zelfde datum en volgnummer als eerder verwerkt bericht %d heeft andere db xml! Object ref %s", ber.getId(), oud.getId(), ber.getObjectRef());
                                log.warn((Object)s);
                                loadLog.append("Waarschuwing: ").append(s).append("\n");
                            }
                        }
                    } else if (oud.getDatum().after(ber.getDatum())) {
                        newStatus = Bericht.STATUS.RSGB_OUTDATED;
                        loadLog.append("Bericht bevat oudere data dan eerder verwerkt bericht, status RSGB_OUTDATED\n");
                    } else if (oud.getDatum().equals(ber.getDatum()) && oud.getVolgordeNummer() > ber.getVolgordeNummer()) {
                        newStatus = Bericht.STATUS.RSGB_OUTDATED;
                        loadLog.append("Bericht bevat oudere data dan eerder verwerkt bericht met hoger volgnummer, status RSGB_OUTDATED\n");
                    } else {
                        StringReader oReader = new StringReader(oud.getDbXml());
                        List<TableData> oudList = this.oldDbXmlReader.readDataXML(new StreamSource(oReader));
                        this.parseNewData(oudList, newList, loadLog, jdbcConverter, conn, metaData);
                        this.parseOldData(oudList, newList, ber.getDatum(), loadLog, jdbcConverter, conn, metaData);
                    }
                } else {
                    this.parseNewData(null, newList, loadLog, jdbcConverter, conn, metaData);
                }
                Split commit = SimonManager.getStopwatch((String)(this.simonNamePrefix + "commit")).start();
                conn.commit();
                commit.stop();
                ber.setStatus(newStatus);
                ++this.processed;
                if (this.listener != null) {
                    this.listener.progress(this.processed);
                }
                if (loadLog == null) {
                    loadLog = new StringBuilder(ber.getOpmerking());
                }
                loadLog.append("\n\n");
            }
            catch (Throwable ex) {
                try {
                    log.error((Object)("Fout bij verwerking bericht met id " + ber.getId() + ", melding: " + ex.getLocalizedMessage()));
                    log.debug((Object)("Fout bij verwerking bericht met id " + ber.getId()), ex);
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        log.debug((Object)"Rollback exception", (Throwable)e);
                    }
                    ber.setOpmerking(loadLog.toString());
                    loadLog = null;
                    this.updateBerichtException(ber, ex);
                    if (loadLog == null) {
                        loadLog = new StringBuilder(ber.getOpmerking());
                    }
                    loadLog.append("\n\n");
                }
                catch (Throwable throwable) {
                    if (loadLog == null) {
                        loadLog = new StringBuilder(ber.getOpmerking());
                    }
                    loadLog.append("\n\n");
                    loadLog.append(String.format("%s: einde verwerking, duur: %4.1fs", dateTimeFormat.format(new java.util.Date()), (double)(System.currentTimeMillis() - startTime) / 1000.0));
                    ber.setOpmerking(loadLog.toString());
                    if (updateResult) {
                        this.updateProcessingResult(ber);
                    }
                    if (this.recentSavepoint != null) {
                        this.recentSavepoint = null;
                    }
                    if (this.renewConnectionAfterCommit) {
                        log.debug((Object)"Vernieuwen van verbinding om cursors in Oracle vrij te geven!");
                        if (!(jdbcConverter instanceof OracleJdbcConverter)) {
                            log.info((Object)"Vernieuwen van verbinding is alleen nodig bij sommige Oracle implementeties: lijkt hier overbodig!");
                        }
                        try {
                            this.renewConnection();
                        }
                        catch (SQLException ex2) {
                            throw new BrmoException("Error renewing connection", ex2);
                        }
                    }
                    throw throwable;
                }
                loadLog.append(String.format("%s: einde verwerking, duur: %4.1fs", dateTimeFormat.format(new java.util.Date()), (double)(System.currentTimeMillis() - startTime) / 1000.0));
                ber.setOpmerking(loadLog.toString());
                if (updateResult) {
                    this.updateProcessingResult(ber);
                }
                if (this.recentSavepoint != null) {
                    this.recentSavepoint = null;
                }
                if (!this.renewConnectionAfterCommit) break block46;
                log.debug((Object)"Vernieuwen van verbinding om cursors in Oracle vrij te geven!");
                if (!(jdbcConverter instanceof OracleJdbcConverter)) {
                    log.info((Object)"Vernieuwen van verbinding is alleen nodig bij sommige Oracle implementeties: lijkt hier overbodig!");
                }
                try {
                    this.renewConnection();
                }
                catch (SQLException ex3) {
                    throw new BrmoException("Error renewing connection", ex3);
                }
            }
            loadLog.append(String.format("%s: einde verwerking, duur: %4.1fs", dateTimeFormat.format(new java.util.Date()), (double)(System.currentTimeMillis() - startTime) / 1000.0));
            ber.setOpmerking(loadLog.toString());
            if (updateResult) {
                this.updateProcessingResult(ber);
            }
            if (this.recentSavepoint != null) {
                this.recentSavepoint = null;
            }
            if (this.renewConnectionAfterCommit) {
                log.debug((Object)"Vernieuwen van verbinding om cursors in Oracle vrij te geven!");
                if (!(jdbcConverter instanceof OracleJdbcConverter)) {
                    log.info((Object)"Vernieuwen van verbinding is alleen nodig bij sommige Oracle implementeties: lijkt hier overbodig!");
                }
                try {
                    this.renewConnection();
                }
                catch (SQLException ex) {
                    throw new BrmoException("Error renewing connection", ex);
                }
            }
        }
    }

    public void update(Bericht jobBericht, List<TableData> pretransformedTableData) throws BrmoException {
        Connection conn = this.connRsgb;
        GeometryJdbcConverter jdbcConverter = this.geomToJdbc;
        DatabaseMetaData metaData = this.dbMetadata;
        if (jobBericht.getSoort().equalsIgnoreCase("brk2")) {
            conn = this.connRsgbBrk;
            jdbcConverter = this.geomToJdbcBrk;
            metaData = this.dbMetadataBrk;
        }
        if (this.updateProcess.isUpdateDbXml() && jobBericht.getSoort().equals("brk")) {
            try {
                Bericht berichtBericht = this.stagingProxy.getBerichtById(jobBericht.getId());
                log.trace((Object)("job bericht: " + jobBericht));
                log.trace((Object)("origineel bericht: " + berichtBericht));
                RsgbTransformer t = new RsgbTransformer("/xsl/brk-snapshot-to-rsgb-xml.xsl");
                String newDbXml = t.transformToDbXml(berichtBericht);
                berichtBericht.setDbXml(newDbXml);
                jobBericht.setDbXml(newDbXml);
                berichtBericht.setStatus(Bericht.STATUS.RSGB_OK);
                berichtBericht.setStatusDatum(new java.util.Date());
                SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                berichtBericht.setOpmerking(String.format("%s: Middels update proces '%s' her-verwerkt.\nDe eerdere db_xml van dit bericht is vervangen door nieuwe.\n\nOude verwerkingslog\n\n%s", dateTimeFormat.format(new java.util.Date()), this.updateProcess.getName(), berichtBericht.getOpmerking()));
                log.trace((Object)("updated bericht: " + jobBericht));
                log.trace((Object)("job bericht: " + jobBericht));
                this.stagingProxy.updateBerichtProcessing(berichtBericht);
            }
            catch (IOException | SQLException | ParserConfigurationException | TransformerException | SAXException e) {
                log.error((Object)("Bijwerken van db_xml is mislukt voor bericht " + jobBericht.getId()), (Throwable)e);
            }
        }
        try {
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            List<TableData> newList = pretransformedTableData != null ? pretransformedTableData : this.transformUpdateTableData(jobBericht);
            log.trace((Object)("data voor update: " + newList));
            for (TableData newData : newList) {
                for (TableRow row : newData.getRows()) {
                    boolean comfortFound = this.rowExistsInDb(row, new StringBuilder(), jdbcConverter, conn, metaData);
                    if (comfortFound) {
                        this.createUpdateSql(row, new StringBuilder(), jdbcConverter, conn, metaData);
                        continue;
                    }
                    this.createInsertSql(row, false, new StringBuilder(), jdbcConverter, conn, metaData);
                }
            }
            conn.commit();
            ++this.processed;
            if (this.listener != null) {
                this.listener.progress(this.processed);
            }
        }
        catch (Throwable ex) {
            log.error((Object)("Fout bij updaten bericht met id " + jobBericht.getId()), ex);
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                log.debug((Object)"Rollback exception", (Throwable)e);
            }
        }
    }

    private RsgbTransformer getTransformer(String brType) throws TransformerConfigurationException, ParserConfigurationException {
        RsgbTransformer t = this.rsgbTransformers.get(brType);
        if (t == null) {
            switch (brType) {
                case "brk": {
                    t = new RsgbTransformer("/xsl/brk-snapshot-to-rsgb-xml.xsl");
                    break;
                }
                case "brk2": {
                    t = new RsgbTransformer("/xsl/brk2-snapshot-to-rsgb-xml.xsl");
                    break;
                }
                case "brp": {
                    t = new RsgbBRPTransformer("/xsl/brp-to-rsgb-xml.xsl", this.stagingProxy);
                    break;
                }
                case "nhr": {
                    t = new RsgbTransformer("/xsl/nhr-to-rsgb-xml-3.0.xsl");
                    break;
                }
                case "gbav": {
                    t = new RsgbTransformer("/xsl/gbav-to-rsgb-xml.xsl");
                    break;
                }
                case "woz": {
                    t = new RsgbWOZTransformer("/xsl/woz-to-rsgb.xsl", this.stagingProxy);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Onbekende basisregistratie: " + brType);
                }
            }
            this.rsgbTransformers.put(brType, t);
        }
        return t;
    }

    private StringBuilder parseNewData(List<TableData> oldList, List<TableData> newList, StringBuilder loadLog, GeometryJdbcConverter jdbcConverter, Connection conn, DatabaseMetaData metaData) throws SQLException, org.locationtech.jts.io.ParseException, BrmoException {
        Split split = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata")).start();
        loadLog.append("\nVerwerk nieuw bericht");
        if (newList == null || newList.isEmpty()) {
            if (oldList == null || oldList.isEmpty()) {
                throw new BrmoException("Bericht verwijdert object waarvoor geen eerder bericht gevonden is!");
            }
            split.stop();
            return loadLog;
        }
        String lastExistingBrondocumentId = null;
        for (TableData newData : newList) {
            Split split2;
            if (!newData.isComfortData() && !newData.isDeleteData()) {
                Split splitAuthentic = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic")).start();
                loadLog.append("\n");
                for (TableRow row : newData.getRows()) {
                    if (lastExistingBrondocumentId != null && "brondocument".equalsIgnoreCase(row.getTable()) && lastExistingBrondocumentId.equals(row.getColumnValue("tabel_identificatie"))) {
                        loadLog.append("\nOverslaan stukdeel voor stuk ").append(lastExistingBrondocumentId);
                        SimonManager.getCounter((String)(this.simonNamePrefix + "parsenewdata.authentic.skipstukdeel")).increase();
                        continue;
                    }
                    lastExistingBrondocumentId = null;
                    split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.getpk")).start();
                    List<String> pkColumns = this.getPrimaryKeys(row.getTable(), jdbcConverter, metaData);
                    split2.stop();
                    boolean existsInOldList = this.doesRowExist(row, pkColumns, oldList);
                    split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.rowexistsindb")).start();
                    boolean doInsert = !this.rowExistsInDb(row, loadLog, jdbcConverter, conn, metaData);
                    split2.stop();
                    if (doInsert) {
                        if (existsInOldList) {
                            loadLog.append("\nOud bericht bestaat, maar staat niet (meer) in database, daarom toevoeging van object aan tabel: ");
                        } else {
                            loadLog.append("\nNormale toevoeging van object aan tabel: ");
                        }
                        loadLog.append(row.getTable());
                        split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.insert")).start();
                        this.createInsertSql(row, false, loadLog, jdbcConverter, conn, metaData);
                        split2.stop();
                        continue;
                    }
                    split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.isalreadyinmetadata")).start();
                    boolean inMetaDataTable = this.isAlreadyInMetadata(row, loadLog, jdbcConverter, conn, metaData);
                    split2.stop();
                    if (inMetaDataTable) {
                        loadLog.append("\nwis uit metadata tabel (upgrade van comfort naar authentiek). ");
                        split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.deletefrommetadata")).start();
                        this.deleteFromMetadata(row, loadLog, jdbcConverter, conn, metaData);
                        split2.stop();
                    }
                    if ("brondocument".equalsIgnoreCase(row.getTable())) {
                        lastExistingBrondocumentId = row.getColumnValue("tabel_identificatie");
                        loadLog.append("\nRij voor stukdeel ").append(lastExistingBrondocumentId).append(" bestaat al, geen update");
                        continue;
                    }
                    if (existsInOldList) {
                        loadLog.append("\nUpdate einddatum in vorige versie object");
                        TableRow oldRow = this.getMatchingRowFromTableData(row, pkColumns, oldList);
                        String newBeginDate = this.getValueFromTableRow(row, row.getColumnDatumBeginGeldigheid());
                        this.updateValueInTableRow(oldRow, row.getColumnDatumEindeGeldigheid(), newBeginDate);
                        loadLog.append("\nSchrijf vorige versie naar archief tabel");
                        oldRow.setIgnoreDuplicates(true);
                        split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.archive")).start();
                        this.createInsertSql(oldRow, true, loadLog, jdbcConverter, conn, metaData);
                        split2.stop();
                        loadLog.append("\nUpdate object in tabel: ");
                    } else {
                        loadLog.append("\nUpdate object (zonder vastlegging historie) in tabel: ");
                    }
                    loadLog.append(row.getTable());
                    split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.authentic.update." + row.getTable())).start();
                    this.createUpdateSql(row, loadLog, jdbcConverter, conn, metaData);
                    split2.stop();
                }
                splitAuthentic.stop();
                continue;
            }
            if (!newData.isDeleteData()) {
                Split split22;
                Split splitComfort = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort")).start();
                String tabel = newData.getComfortSearchTable();
                String kolom = newData.getComfortSearchColumn();
                String waarde = newData.getComfortSearchValue();
                String datum = newData.getComfortSnapshotDate();
                for (TableRow row : newData.getRows()) {
                    String subclass = row.getTable();
                    loadLog.append(String.format("\n\nComfort data voor %s (class: %s, %s=%s), controleer aanwezigheid in tabel", subclass, tabel, kolom, waarde));
                    split22 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort.exists")).start();
                    boolean comfortFound = this.rowExistsInDb(row, loadLog, jdbcConverter, conn, metaData);
                    split22.stop();
                    if (comfortFound) {
                        split22 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort.update")).start();
                        this.createUpdateSql(row, loadLog, jdbcConverter, conn, metaData);
                        split22.stop();
                        continue;
                    }
                    split22 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort.insert")).start();
                    this.createInsertSql(row, false, loadLog, jdbcConverter, conn, metaData);
                    split22.stop();
                }
                split22 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.comfort.metadata")).start();
                if (metaData != this.dbMetadataBrk) {
                    this.createInsertMetadataSql(tabel, kolom, waarde, datum, loadLog, jdbcConverter, conn);
                }
                split22.stop();
                splitComfort.stop();
                loadLog.append("\n");
                continue;
            }
            if (!newData.isDeleteData() || oldList != null && !oldList.isEmpty()) continue;
            Split splitDelete = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.delete")).start();
            loadLog.append("\n\nWissen van object zonder oud record.");
            for (TableRow row : newData.getRows()) {
                if (this.rowExistsInDb(row, loadLog, jdbcConverter, conn, metaData)) {
                    split2 = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parsenewdata.delete.update")).start();
                    this.createDeleteSql(row, loadLog, jdbcConverter, conn, metaData);
                    split2.stop();
                    continue;
                }
                loadLog.append("\nTe wissen record niet in database.");
            }
            splitDelete.stop();
            loadLog.append("\n");
        }
        split.stop();
        return loadLog;
    }

    private StringBuilder parseOldData(List<TableData> oldList, List<TableData> newList, java.util.Date newDate, StringBuilder loadLog, GeometryJdbcConverter jdbcConverter, Connection connection, DatabaseMetaData metaData) throws SQLException, org.locationtech.jts.io.ParseException {
        ArrayList<TableRow> rowsToDelete = new ArrayList<TableRow>();
        boolean deleteAll = !newList.isEmpty() && newList.get(0).isDeleteData();
        loadLog.append("\nControleren te verwijderen gegevens vorig bericht...\n");
        for (TableData oldData : oldList) {
            if (oldData.isComfortData()) continue;
            for (TableRow oldRow : oldData.getRows()) {
                List<String> pkColumns = this.getPrimaryKeys(oldRow.getTable(), jdbcConverter, metaData);
                boolean exists = this.doesRowExist(oldRow, pkColumns, newList);
                if (!deleteAll && exists) continue;
                loadLog.append("Vervallen record te verwijderen: ").append(oldRow.toString(pkColumns)).append("\n");
                rowsToDelete.add(oldRow);
            }
        }
        if (!rowsToDelete.isEmpty()) {
            loadLog.append("Verwijder rijen in omgekeerde volgorde...\n");
            Collections.reverse(rowsToDelete);
            for (TableRow rowToDelete : rowsToDelete) {
                Split split = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parseolddata.delete")).start();
                this.createDeleteSql(rowToDelete, loadLog, jdbcConverter, connection, metaData);
                split.stop();
                String beginDate = this.getValueFromTableRow(rowToDelete, rowToDelete.getColumnDatumBeginGeldigheid());
                String endDate = this.formatDateLikeOtherDate(newDate, beginDate);
                this.updateValueInTableRow(rowToDelete, rowToDelete.getColumnDatumEindeGeldigheid(), endDate);
                split = SimonManager.getStopwatch((String)(this.simonNamePrefix + "parseolddata.archive")).start();
                rowToDelete.setIgnoreDuplicates(true);
                this.createInsertSql(rowToDelete, true, loadLog, jdbcConverter, connection, metaData);
                split.stop();
            }
        }
        return loadLog;
    }

    private String formatDateLikeOtherDate(java.util.Date newDate, String otherDate) {
        SimpleDateFormat dfltFmt = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat f2 = new SimpleDateFormat("yyyyMMddHHmmssSSS0");
        if (otherDate == null || otherDate.isEmpty()) {
            return dfltFmt.format(newDate);
        }
        try {
            f2.parse(otherDate);
            return f2.format(newDate);
        }
        catch (ParseException parseException) {
            return dfltFmt.format(newDate);
        }
    }

    private String getValueFromTableRow(TableRow row, String column) {
        int i = 0;
        for (String c : row.getColumns()) {
            if (c.equalsIgnoreCase(column)) {
                return row.getValues().get(i);
            }
            ++i;
        }
        return null;
    }

    private void updateValueInTableRow(TableRow row, String column, String newValue) {
        this.repairOldRowIfRequired(row, newValue);
        if (column == null) {
            return;
        }
        int i = 0;
        for (String c : row.getColumns()) {
            if (c.equalsIgnoreCase(column)) {
                row.getValues().set(i, newValue);
                return;
            }
            ++i;
        }
    }

    private void repairOldRowIfRequired(TableRow row, String guessDate) {
        if ((row.getTable().equals("kad_perceel") || row.getTable().equals("app_re") || row.getTable().equals("nummeraand") || row.getTable().equals("ligplaats") || row.getTable().equals("standplaats") || row.getTable().equals("verblijfsobj")) && !row.getColumns().contains("sc_dat_beg_geldh")) {
            row.getColumns().add("sc_dat_beg_geldh");
            row.getValues().add(guessDate);
        }
    }

    private TableRow getMatchingRowFromTableData(TableRow row, List<String> pkColumns, List<TableData> testList) {
        TableRow newRow = null;
        for (TableData data : testList) {
            for (TableRow testRow : data.getRows()) {
                if (!row.getTable().equals(testRow.getTable())) continue;
                int matches = 0;
                for (String pkColumn : pkColumns) {
                    String testVal;
                    int rowIdx = row.getColumns().indexOf(pkColumn);
                    int testIdx = testRow.getColumns().indexOf(pkColumn);
                    String val = row.getValues().get(rowIdx);
                    if (!val.equals(testVal = testRow.getValues().get(testIdx))) continue;
                    ++matches;
                }
                if (matches != pkColumns.size()) continue;
                newRow = testRow;
            }
        }
        return newRow;
    }

    private boolean doesRowExist(TableRow row, List<String> pkColumns, List<TableData> testList) {
        boolean found = false;
        if (testList != null && testList.size() > 0) {
            for (TableData data : testList) {
                for (TableRow testRow : data.getRows()) {
                    if (!row.getTable().equals(testRow.getTable())) continue;
                    int matches = 0;
                    for (String pkColumn : pkColumns) {
                        String testVal;
                        int rowIdx = row.getColumns().indexOf(pkColumn);
                        int testIdx = testRow.getColumns().indexOf(pkColumn);
                        String val = row.getValues().get(rowIdx);
                        if (!val.equals(testVal = testRow.getValues().get(testIdx))) continue;
                        ++matches;
                    }
                    if (matches != pkColumns.size()) continue;
                    found = true;
                }
            }
        }
        return found;
    }

    private void createInsertSql(TableRow row, boolean useArchiveTable, StringBuilder loadLog, GeometryJdbcConverter jdbcConverter, Connection connection, DatabaseMetaData metaData) throws SQLException, org.locationtech.jts.io.ParseException {
        StringBuilder sql = new StringBuilder("insert into ");
        Object tableName = !useArchiveTable ? row.getTable() : row.getTable() + "_archief";
        sql.append((String)tableName);
        SortedSet<ColumnMetadata> tableColumnMetadata = this.getTableColumnMetadata((String)tableName, jdbcConverter, metaData);
        if (tableColumnMetadata == null) {
            if (useArchiveTable) {
                return;
            }
            throw new IllegalStateException("Kan tabel metadata niet vinden voor tabel " + (String)tableName);
        }
        sql.append(" (");
        StringBuilder valuesSql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        Iterator<String> valuesIt = row.getValues().iterator();
        Iterator<String> it = row.getColumns().iterator();
        while (it.hasNext()) {
            String column = it.next();
            String stringValue = valuesIt.next();
            if (row.isAlleenArchiefColumn(column) && !useArchiveTable) continue;
            ColumnMetadata cm = this.findColumnMetadata(tableColumnMetadata, column);
            Object param = this.getValueAsObject((String)tableName, column, stringValue, cm, jdbcConverter, metaData);
            params.add(param);
            sql.append(cm.getName());
            String insertValuePlaceholder = "?";
            if (cm.getTypeName().equals(jdbcConverter.getGeomTypeName()) || cm.getTypeName().replace("\"", "").equals("public." + jdbcConverter.getGeomTypeName())) {
                insertValuePlaceholder = jdbcConverter.createPSGeometryPlaceholder();
            }
            valuesSql.append(insertValuePlaceholder);
            if (!it.hasNext()) continue;
            sql.append(", ");
            valuesSql.append(", ");
        }
        boolean conditionalInsert = row.isIgnoreDuplicates();
        if (!conditionalInsert) {
            sql.append(") values (");
            sql.append((CharSequence)valuesSql);
            sql.append(")");
        } else {
            sql.append(") select ");
            sql.append((CharSequence)valuesSql);
            if (jdbcConverter instanceof OracleJdbcConverter) {
                sql.append(" from dual");
            }
            sql.append(" where not exists (select 1 from ");
            sql.append((String)tableName);
            sql.append(" where ");
            boolean first = true;
            for (String column : this.getPrimaryKeys((String)tableName, jdbcConverter, metaData)) {
                if (first) {
                    first = false;
                } else {
                    sql.append(" and ");
                }
                sql.append(column);
                sql.append(" = ? ");
                String val = this.getValueFromTableRow(row, column);
                Object obj = this.getValueAsObject((String)tableName, column, val, null, jdbcConverter, metaData);
                params.add(obj);
            }
            sql.append(")");
        }
        PreparedStatement stm = this.checkAndGetPreparedStatement(this.insertSqlPreparedStatements, sql.toString());
        if (stm == null) {
            SimonManager.getCounter((String)"b3p.rsgb.insertsql.preparestatement").increase();
            stm = connection.prepareStatement(sql.toString());
            this.checkAndAddStatement(this.insertSqlPreparedStatements, sql.toString(), stm);
        } else {
            SimonManager.getCounter((String)"b3p.rsgb.insertsql.reusestatement").increase();
        }
        loadLog.append("\nSQL: ");
        loadLog.append((CharSequence)sql);
        loadLog.append(", params (");
        loadLog.append(params);
        loadLog.append(")");
        log.trace((Object)("insert SQL: " + sql + ", params: " + params));
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            if (null == param && (this.findColumnMetadata(tableColumnMetadata, row.getColumns().get(i)).getTypeName().equals(jdbcConverter.getGeomTypeName()) || this.findColumnMetadata(tableColumnMetadata, row.getColumns().get(i)).getTypeName().replace("\"", "").equals("public." + jdbcConverter.getGeomTypeName()))) {
                if (jdbcConverter instanceof OracleJdbcConverter) {
                    stm.setNull(i + 1, 2002, "MDSYS.SDO_GEOMETRY");
                    continue;
                }
                stm.setNull(i + 1, stm.getParameterMetaData().getParameterType(i + 1));
                continue;
            }
            stm.setObject(i + 1, param);
        }
        int count = -1;
        try {
            count = stm.executeUpdate();
        }
        catch (SQLException e) {
            String message = e.getMessage();
            if (jdbcConverter.isDuplicateKeyViolationMessage(message) && row.isIgnoreDuplicates()) {
                if (this.recentSavepoint != null) {
                    log.debug((Object)("Ignoring duplicate key violation by rolling back to savepoint with id " + this.recentSavepoint.getSavepointId()));
                    connection.rollback(this.recentSavepoint);
                }
            }
            throw e;
        }
        loadLog.append("\nAantal toegevoegde records: ").append(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createUpdateSql(TableRow row, StringBuilder loadLog, GeometryJdbcConverter jdbcConverter, Connection connection, DatabaseMetaData metaData) throws SQLException, org.locationtech.jts.io.ParseException {
        StringBuilder sql = new StringBuilder("update ");
        String tableName = row.getTable();
        sql.append(tableName);
        SortedSet<ColumnMetadata> tableColumnMetadata = this.getTableColumnMetadata(tableName, jdbcConverter, metaData);
        if (tableColumnMetadata == null) {
            throw new IllegalStateException("Kan tabel metadata niet vinden voor tabel " + tableName);
        }
        sql.append(" set ");
        ArrayList<Object> params = new ArrayList<Object>();
        Iterator<String> valuesIt = row.getValues().iterator();
        Iterator<String> it = row.getColumns().iterator();
        while (it.hasNext()) {
            String column = it.next();
            String stringValue = valuesIt.next();
            if (row.isAlleenArchiefColumn(column)) continue;
            ColumnMetadata cm = this.findColumnMetadata(tableColumnMetadata, column);
            Object param = this.getValueAsObject(tableName, column, stringValue, cm, jdbcConverter, metaData);
            params.add(param);
            sql.append(cm.getName());
            sql.append(" = ");
            String insertValuePlaceholder = "?";
            if (cm.getTypeName().equals(jdbcConverter.getGeomTypeName()) || cm.getTypeName().replace("\"", "").equals("public." + jdbcConverter.getGeomTypeName())) {
                insertValuePlaceholder = jdbcConverter.createPSGeometryPlaceholder();
            }
            sql.append(insertValuePlaceholder);
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(" where ");
        boolean first = true;
        for (String column : this.getPrimaryKeys(tableName, jdbcConverter, metaData)) {
            if (first) {
                first = false;
            } else {
                sql.append(" and ");
            }
            sql.append(column);
            sql.append(" = ? ");
            String val = this.getValueFromTableRow(row, column);
            Object obj = this.getValueAsObject(tableName, column, val, null, jdbcConverter, metaData);
            params.add(obj);
        }
        PreparedStatement stm = this.checkAndGetPreparedStatement(this.updateSqlPreparedStatements, sql.toString());
        if (stm == null) {
            SimonManager.getCounter((String)"b3p.rsgb.updatesql.preparestatement").increase();
            stm = connection.prepareStatement(sql.toString());
            this.checkAndAddStatement(this.updateSqlPreparedStatements, sql.toString(), stm);
        } else {
            SimonManager.getCounter((String)"b3p.rsgb.updatesql.reusestatement").increase();
        }
        loadLog.append("\nSQL: ");
        loadLog.append((CharSequence)sql);
        loadLog.append(", params (");
        loadLog.append(params);
        loadLog.append(")");
        log.debug((Object)("update SQL: " + sql + ", params: " + params));
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            if (null == param && (stm.getParameterMetaData().getParameterTypeName(i + 1).equals(jdbcConverter.getGeomTypeName()) || stm.getParameterMetaData().getParameterTypeName(i + 1).replace("\"", "").equals("public." + jdbcConverter.getGeomTypeName()))) {
                log.trace((Object)("gebruik `setNull` voor kolom: " + i + " " + row.getColumns().get(i) + ", waarde " + param + "(" + stm.getParameterMetaData().getParameterTypeName(i + 1) + ")"));
                if (jdbcConverter instanceof OracleJdbcConverter) {
                    stm.setNull(i + 1, 2002, "MDSYS.SDO_GEOMETRY");
                    continue;
                }
                stm.setNull(i + 1, stm.getParameterMetaData().getParameterType(i + 1));
                continue;
            }
            stm.setObject(i + 1, param, stm.getParameterMetaData().getParameterType(i + 1));
        }
        int count = -1;
        try {
            count = stm.executeUpdate();
        }
        finally {
            loadLog.append("\nAantal record updates: ").append(count);
        }
    }

    private boolean createInsertMetadataSql(String tabel, String kolom, String waarde, String datum, StringBuilder loadLog, GeometryJdbcConverter jdbcConverter, Connection connection) throws SQLException {
        if (this.insertMetadataStatement == null || this.insertMetadataStatement.isClosed()) {
            String sql = "insert into herkomst_metadata (tabel, kolom, waarde, herkomst_br, datum) select ?, ?, ?, ?, ? " + (jdbcConverter instanceof OracleJdbcConverter ? "from dual" : "") + " where not exists (  select 1 from herkomst_metadata where tabel = ? and kolom = ? and waarde = ? and herkomst_br = ? and datum = ?)";
            this.insertMetadataStatement = connection.prepareStatement(sql);
        } else {
            this.insertMetadataStatement.clearParameters();
        }
        Date date = null;
        Calendar calendar = DatatypeConverter.parseDateTime((String)datum);
        if (calendar != null) {
            date = new Date(calendar.getTimeInMillis());
        }
        this.insertMetadataStatement.setString(1, tabel);
        this.insertMetadataStatement.setString(2, kolom);
        this.insertMetadataStatement.setString(3, waarde);
        this.insertMetadataStatement.setString(4, this.getHerkomstMetadata());
        this.insertMetadataStatement.setObject(5, date);
        this.insertMetadataStatement.setString(6, tabel);
        this.insertMetadataStatement.setString(7, kolom);
        this.insertMetadataStatement.setString(8, waarde);
        this.insertMetadataStatement.setString(9, this.getHerkomstMetadata());
        this.insertMetadataStatement.setObject(10, date);
        loadLog.append(String.format("\nConditioneel toevoegen herkomst metadata tabel=%s, kolom=%s, waarde=%s, herkomst_br=%s, datum=%s", tabel, kolom, waarde, this.getHerkomstMetadata(), datum));
        int count = this.insertMetadataStatement.executeUpdate();
        loadLog.append(": record geinsert: ").append(count > 0 ? "ja" : "nee (rij bestond al)");
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rowExistsInDb(TableRow row, StringBuilder loadLog, GeometryJdbcConverter jdbcConverter, Connection conn, DatabaseMetaData metaData) throws SQLException, org.locationtech.jts.io.ParseException {
        boolean bl;
        String tableName = row.getTable();
        List<String> pkColumns = this.getPrimaryKeys(tableName, jdbcConverter, metaData);
        ArrayList<Object> params = new ArrayList<Object>();
        for (String column : pkColumns) {
            String val = this.getValueFromTableRow(row, column);
            Object object = this.getValueAsObject(row.getTable(), column, val, null, jdbcConverter, metaData);
            params.add(object);
        }
        loadLog.append("\nControleer ").append(tableName).append(" op primary key: ").append(params);
        PreparedStatement stm = this.checkAndGetPreparedStatement(this.checkRowExistsStatements, tableName);
        if (stm == null) {
            StringBuilder sql = new StringBuilder("select 1 from ").append(tableName);
            boolean first = true;
            for (String column : pkColumns) {
                if (first) {
                    sql.append(" where ").append(column).append(" = ?");
                    first = false;
                    continue;
                }
                sql.append(" and ").append(column).append(" = ?");
            }
            stm = conn.prepareStatement(sql.toString(), 1004, 1007);
            this.checkAndAddStatement(this.checkRowExistsStatements, tableName, stm);
        }
        int i = 1;
        for (Object e : params) {
            stm.setObject(i++, e);
        }
        boolean bl2 = false;
        try (ResultSet rs = null;){
            rs = stm.executeQuery();
            bl = rs.next();
        }
        loadLog.append(", rij bestaat: ").append(bl ? "ja" : "nee");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlreadyInMetadata(TableRow row, StringBuilder loadLog, GeometryJdbcConverter jdbcConverter, Connection connection, DatabaseMetaData metaData) throws SQLException, BrmoException {
        boolean bl;
        if (metaData == this.dbMetadataBrk) {
            return false;
        }
        if (connection == null || connection.isClosed()) {
            throw new BrmoException("No connection found");
        }
        ArrayList<String> params = new ArrayList<String>();
        String herkomstTableName = "herkomst_metadata";
        String tableName = row.getTable();
        params.add(tableName);
        List<String> pkColumns = this.getPrimaryKeys(tableName, jdbcConverter, metaData);
        String column = null;
        if (pkColumns.size() == 1) {
            column = pkColumns.get(0);
        }
        params.add(column);
        String waarde = this.getValueFromTableRow(row, column);
        params.add(waarde);
        loadLog.append("\nControleer ").append(herkomstTableName).append(" op primary key: ").append(params);
        PreparedStatement stm = this.checkAndGetPreparedStatement(this.checkRowExistsStatements, herkomstTableName);
        if (stm == null) {
            String sql = "select 1 from " + herkomstTableName + " WHERE tabel = ? AND kolom = ? AND kolom = ?";
            stm = connection.prepareStatement(sql, 1004, 1007);
            this.checkAndAddStatement(this.checkRowExistsStatements, herkomstTableName, stm);
        }
        int i = 1;
        for (Object e : params) {
            stm.setObject(i++, e);
        }
        boolean bl2 = false;
        try (ResultSet rs = null;){
            rs = stm.executeQuery();
            bl = rs.next();
        }
        loadLog.append(", rij bestaat: ").append(bl ? "ja" : "nee");
        return bl;
    }

    private boolean createDeleteSql(TableRow row, StringBuilder loadLog, GeometryJdbcConverter jdbcConverter, Connection connection, DatabaseMetaData metaData) throws SQLException, org.locationtech.jts.io.ParseException {
        this.doSavePoint(row, jdbcConverter, connection);
        String tableName = row.getTable();
        List<String> pkColumns = this.getPrimaryKeys(tableName, jdbcConverter, metaData);
        ArrayList<Object> params = new ArrayList<Object>();
        for (String column : pkColumns) {
            String val = this.getValueFromTableRow(row, column);
            Object object = this.getValueAsObject(row.getTable(), column, val, null, jdbcConverter, metaData);
            params.add(object);
        }
        loadLog.append("\nVerwijderen rij uit ").append(tableName).append(" met primary key: ").append(params);
        PreparedStatement stm = this.checkAndGetPreparedStatement(this.createDeleteSqlStatements, tableName);
        if (stm == null) {
            StringBuilder sql = new StringBuilder("delete from ").append(tableName);
            boolean first = true;
            for (String column : pkColumns) {
                if (first) {
                    sql.append(" where ").append(column).append(" = ?");
                    first = false;
                    continue;
                }
                sql.append(" and ").append(column).append(" = ?");
            }
            stm = connection.prepareStatement(sql.toString(), 1004, 1007);
            this.checkAndAddStatement(this.createDeleteSqlStatements, tableName, stm);
        }
        int i = 1;
        for (Object e : params) {
            stm.setObject(i++, e);
        }
        int count = 1;
        try {
            count = stm.executeUpdate();
        }
        catch (SQLException sQLException) {
            log.error((Object)"Error executing delete statement", (Throwable)sQLException);
        }
        loadLog.append(", aantal rijen verwijderd: ").append(count);
        return count > 0;
    }

    private boolean deleteFromMetadata(TableRow row, StringBuilder loadLog, GeometryJdbcConverter jdbcConverter, Connection connection, DatabaseMetaData metaData) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        String herkomstTableName = "herkomst_metadata";
        String tableName = row.getTable();
        params.add(tableName);
        List<String> pkColumns = this.getPrimaryKeys(tableName, jdbcConverter, metaData);
        String column = null;
        if (pkColumns.size() == 1) {
            column = pkColumns.get(0);
        }
        params.add(column);
        String waarde = this.getValueFromTableRow(row, column);
        params.add(waarde);
        loadLog.append("\nVerwijder rij uit ").append(herkomstTableName).append(" met primary key: ").append(params);
        PreparedStatement stm = this.checkAndGetPreparedStatement(this.createDeleteSqlStatements, herkomstTableName);
        if (stm == null) {
            String sql = "delete from " + herkomstTableName + " WHERE tabel = ? AND kolom = ? AND kolom = ?";
            stm = connection.prepareStatement(sql, 1004, 1007);
            this.checkAndAddStatement(this.createDeleteSqlStatements, herkomstTableName, stm);
        }
        int i = 1;
        for (Object e : params) {
            stm.setObject(i++, e);
        }
        int count = 1;
        try {
            count = stm.executeUpdate();
        }
        catch (SQLException sQLException) {
            log.error((Object)"Error executing delete statement", (Throwable)sQLException);
        }
        loadLog.append(", aantal rijen verwijderd: ").append(count);
        return count > 0;
    }

    private List<String> getPrimaryKeys(String tableName, GeometryJdbcConverter jdbcConverter, DatabaseMetaData metaData) throws SQLException {
        List<String> pks = this.primaryKeyCache.get(tableName);
        if (pks != null) {
            return pks;
        }
        pks = new ArrayList<String>();
        String origName = this.tables.get(tableName);
        if (origName == null) {
            throw new IllegalArgumentException("Tabel bestaat niet: " + tableName);
        }
        ResultSet set = metaData.getPrimaryKeys(null, jdbcConverter.getSchema(), origName);
        while (set.next()) {
            String column = set.getString("COLUMN_NAME");
            pks.add(column.toLowerCase());
        }
        set.close();
        this.primaryKeyCache.put(tableName, pks);
        return pks;
    }

    private SortedSet<ColumnMetadata> getTableColumnMetadata(String table, GeometryJdbcConverter jdbcConverter, DatabaseMetaData metaData) throws SQLException {
        if (!this.tables.containsKey(table = table.toLowerCase())) {
            return null;
        }
        SortedSet<ColumnMetadata> columnMetadata = this.tableColumns.get(table);
        if (columnMetadata == null) {
            columnMetadata = new TreeSet<ColumnMetadata>();
            this.tableColumns.put(table, columnMetadata);
            ResultSet columnsRs = metaData.getColumns(null, jdbcConverter.getSchema(), this.tables.get(table), "%");
            while (columnsRs.next()) {
                ColumnMetadata cm = new ColumnMetadata(columnsRs);
                columnMetadata.add(cm);
            }
            columnsRs.close();
        }
        return columnMetadata;
    }

    private ColumnMetadata findColumnMetadata(SortedSet<ColumnMetadata> tableColumnMetadata, String columnName) {
        if (tableColumnMetadata == null || tableColumnMetadata.size() < 1) {
            return null;
        }
        for (ColumnMetadata cm : tableColumnMetadata) {
            if (!cm.getName().equalsIgnoreCase(columnName)) continue;
            return cm;
        }
        return null;
    }

    public String getHerkomstMetadata() {
        return this.herkomstMetadata;
    }

    public void setHerkomstMetadata(String herkomstMetadata) {
        this.herkomstMetadata = herkomstMetadata;
    }

    private void doSavePoint(TableRow row, GeometryJdbcConverter jdbcConverter, Connection connection) throws SQLException {
        if (jdbcConverter.useSavepoints()) {
            if (row.isIgnoreDuplicates()) {
                if (this.recentSavepoint == null) {
                    this.recentSavepoint = connection.setSavepoint();
                    log.trace((Object)("Created savepoint with id: " + this.recentSavepoint.getSavepointId()));
                } else {
                    log.trace((Object)("No need for new savepoint, previous insert caused rollback to recent savepoint with id " + this.recentSavepoint.getSavepointId()));
                }
            } else if (this.recentSavepoint != null) {
                log.trace((Object)("About to insert non-recoverable row, discarding savepoint with id " + this.recentSavepoint.getSavepointId()));
                connection.releaseSavepoint(this.recentSavepoint);
                this.recentSavepoint = null;
            }
        }
    }

    private Object getValueAsObject(String tableName, String column, String value, ColumnMetadata cm, GeometryJdbcConverter jdbcConverter, DatabaseMetaData metaData) throws SQLException, org.locationtech.jts.io.ParseException {
        if (cm == null) {
            SortedSet<ColumnMetadata> tableColumnMetadata = this.getTableColumnMetadata(tableName, jdbcConverter, metaData);
            cm = this.findColumnMetadata(tableColumnMetadata, column);
        }
        Object param = null;
        if (cm == null) {
            throw new IllegalArgumentException("Column not found: " + column + " in table " + tableName);
        }
        if (cm.getTypeName().equals(jdbcConverter.getGeomTypeName()) || cm.getTypeName().replace("\"", "").equals("public." + jdbcConverter.getGeomTypeName())) {
            param = jdbcConverter.convertToNativeGeometryObject(value);
        } else if (value != null) {
            param = GeometryJdbcConverter.convertToSQLObject((String)value, (ColumnMetadata)cm, (String)tableName, (String)column);
        }
        return param;
    }

    public static enum BerichtSelectMode {
        BY_STATUS,
        BY_IDS,
        BY_LAADPROCES,
        FOR_UPDATE,
        RETRY_WAITING;

    }
}

