/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.util;

import java.io.File;
import java.net.MalformedURLException;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.xml.bind.JAXBException;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.LaadProces;
import nl.b3p.topnl.Processor;
import nl.b3p.topnl.TopNLType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.JDOMException;

public class TopNLRsgbTransformer
implements Runnable {
    private static final Log LOG = LogFactory.getLog(TopNLRsgbTransformer.class);
    private final StagingProxy stagingProxy;
    private final DataSource dataSourceTopNL;
    private final ProgressUpdateListener listener;
    private final long[] lpIDs;
    private Processor processor = null;

    public TopNLRsgbTransformer(DataSource dataSourceTopNL, StagingProxy stagingProxy, long[] lpIDs, ProgressUpdateListener listener) throws JAXBException, SQLException {
        this.stagingProxy = stagingProxy;
        this.dataSourceTopNL = dataSourceTopNL;
        this.lpIDs = lpIDs;
        this.listener = listener;
        this.processor = new Processor(this.dataSourceTopNL);
    }

    private void transform(long lpID) throws SQLException {
        LaadProces lp = this.stagingProxy.getLaadProcesById(lpID);
        if (TopNLType.isTopNLType((String)lp.getSoort()) && lp.getStatus() == LaadProces.STATUS.STAGING_OK) {
            this.stagingProxy.updateLaadProcesStatus(lp, LaadProces.STATUS.RSGB_TOPNL_WAITING, "Transformatie loopt...");
            File gml = new File(lp.getBestandNaam());
            try {
                LaadProces.STATUS status;
                this.processor.importIntoDb(gml.toURI().toURL(), TopNLType.valueOf((String)lp.getSoort().toUpperCase()));
                this.stagingProxy.updateLaadProcesStatus(lp, status, (String)(switch (this.processor.getStatus()) {
                    case Processor.STATUS.OK -> {
                        status = LaadProces.STATUS.RSGB_TOPNL_OK;
                        yield "Geen fouten bij inladen.";
                    }
                    default -> {
                        status = LaadProces.STATUS.RSGB_TOPNL_NOK;
                        yield "Er zijn herstelbare fouten bij inladen opgetreden. Waarschijnlijk is niet alle data geladen van bestand " + gml;
                    }
                }));
            }
            catch (MalformedURLException | JDOMException ex) {
                LOG.debug((Object)"Error loading gml file", ex);
                String opmerkingen = "Laden van bestand " + gml + " is mislukt: " + ex.getLocalizedMessage();
                LaadProces.STATUS status = LaadProces.STATUS.RSGB_TOPNL_NOK;
                this.stagingProxy.updateLaadProcesStatus(lp, status, opmerkingen);
            }
        } else {
            LOG.warn((Object)("LaadProces " + lp.getId() + " van soort " + lp.getSoort() + " met status: " + lp.getStatus() + " is overgeslagen."));
        }
    }

    public void init() throws SQLException {
    }

    @Override
    public void run() {
        block4: {
            try {
                this.init();
                int count = 0;
                if (this.listener != null) {
                    this.listener.total(this.lpIDs.length);
                    this.listener.progress(count);
                }
                for (long id : this.lpIDs) {
                    this.transform(id);
                    ++count;
                    if (this.listener == null) continue;
                    this.listener.progress(count);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Fout tijdens verwerken TOPNL laadprocessen", (Throwable)e);
                if (this.listener == null) break block4;
                this.listener.exception(e);
            }
        }
    }
}

