/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.xml;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import nl.b3p.brmo.loader.entity.GbavBericht;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GbavXMLReader
extends BrmoXMLReader {
    private static final Log log = LogFactory.getLog(GbavXMLReader.class);
    private static final String PERSOON = "persoon";
    public static final String PREFIX = "NL.BRP.Persoon.";
    private final XMLInputFactory factory = XMLInputFactory.newInstance();
    private final XMLStreamReader streamReader;
    private final Transformer transformer;
    private final XMLOutputFactory xmlof;
    private GbavBericht nextBericht = null;
    private int volgordeNummer = 0;

    public GbavXMLReader(InputStream in) throws XMLStreamException, TransformerConfigurationException {
        this.factory.setProperty("javax.xml.stream.supportDTD", false);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        this.streamReader = this.factory.createXMLStreamReader(in);
        TransformerFactory tf = TransformerFactory.newInstance();
        this.transformer = tf.newTransformer();
        this.xmlof = XMLOutputFactory.newInstance();
        this.init();
    }

    @Override
    public void init() throws XMLStreamException {
        this.soort = "gbav";
        try {
            String localName;
            while (!(!this.streamReader.hasNext() || this.streamReader.isStartElement() && (localName = this.streamReader.getLocalName()).equals(PERSOON))) {
                this.streamReader.next();
            }
        }
        catch (XMLStreamException ex) {
            log.error((Object)"Error while streaming XML", (Throwable)ex);
        }
        if (this.getBestandsDatum() == null) {
            this.setBestandsDatum(new Date());
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.nextBericht != null) {
            return true;
        }
        try {
            while (this.streamReader.hasNext()) {
                if (this.streamReader.isStartElement() && this.streamReader.getLocalName().equals(PERSOON)) {
                    StringWriter sw = new StringWriter();
                    this.transformer.transform(new StAXSource(this.streamReader), new StAXResult(this.xmlof.createXMLStreamWriter(sw)));
                    this.nextBericht = new GbavBericht(sw.toString());
                    this.nextBericht.setDatum(this.nextBericht.parseDatum());
                    if (this.nextBericht.getDatum() == null) {
                        this.nextBericht.setDatum(new Date());
                    }
                    this.nextBericht.setVolgordeNummer(this.volgordeNummer);
                    String bsn = this.nextBericht.getBsn();
                    String bsnHash = this.getHash(bsn);
                    this.nextBericht.setObjectRef(PREFIX + bsnHash);
                    HashMap<String, String> bsns = new HashMap<String, String>();
                    this.nextBericht.getBsnList().forEach(_bsn -> {
                        log.debug((Object)("toevoegen bsn en hash: " + _bsn + ":" + this.getHash((String)_bsn)));
                        bsns.put((String)_bsn, this.getHash((String)_bsn));
                    });
                    log.debug((Object)("aantal BSN in bericht:" + bsns.size()));
                    this.nextBericht.setBsnMap(bsns);
                    return true;
                }
                this.streamReader.next();
            }
        }
        catch (XMLStreamException ex) {
            log.error((Object)"Streamfout tijdens parsen GBA-V XML", (Throwable)ex);
        }
        return false;
    }

    @Override
    public GbavBericht next() throws Exception {
        GbavBericht b = this.nextBericht;
        this.nextBericht = null;
        ++this.volgordeNummer;
        return b;
    }
}

