/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.persistence.staging;

import javax.persistence.Entity;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.ClobElement;

@Entity
public class MailRapportageProces
extends AutomatischProces {
    public static final String DELIM = ",";
    public static final String EMAIL = "email";
    public static final String PIDS = "pIDS";
    public static final String FOR_STATUS = "forStatus";

    public String getMailAdressen() {
        return ClobElement.nullSafeGet(this.getConfig().get(EMAIL));
    }

    public String[] getMailAdressenArray() {
        String adreslijst = this.getMailAdressen();
        if (adreslijst != null) {
            return adreslijst.split(DELIM);
        }
        return null;
    }

    public void setMailAdressen(String ... adressen) {
        StringBuilder sb = new StringBuilder();
        for (String adres : adressen) {
            sb.append(adres.trim()).append(DELIM);
        }
        sb.setLength(sb.length() - 1);
        this.getConfig().put(EMAIL, new ClobElement(sb.toString()));
    }

    public void setMailAdressen(String adres) {
        if (adres == null) {
            this.getConfig().put(EMAIL, null);
        } else if (adres.contains(DELIM)) {
            this.setMailAdressen(adres.split(DELIM));
        } else {
            this.getConfig().put(EMAIL, new ClobElement(adres.trim()));
        }
    }

    public void setForStatus(AutomatischProces.ProcessingStatus status) {
        if (status == null) {
            this.getConfig().put(FOR_STATUS, null);
        } else {
            this.getConfig().put(FOR_STATUS, new ClobElement(status.name()));
        }
    }

    public AutomatischProces.ProcessingStatus getForStatus() {
        if (this.getConfig().get(FOR_STATUS) == null) {
            return null;
        }
        return AutomatischProces.ProcessingStatus.valueOf(this.getConfig().get(FOR_STATUS).getValue());
    }
}

