/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.persistence.auth;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import nl.b3p.brmo.persistence.auth.Groep;

@Entity
@Table(name="gebruiker_")
public class Gebruiker
implements Serializable {
    public static final int MIN_PASSWORD_LENGTH = 8;
    private static final String DIGEST_ALGORITM = "SHA-1";
    private static final String DIGEST_CHARSET = "UTF-8";
    @Id
    private String gebruikersnaam;
    private String wachtwoord;
    @ManyToMany
    @JoinTable(name="gebruiker_groepen", joinColumns={@JoinColumn(name="gebruikersnaam")}, inverseJoinColumns={@JoinColumn(name="groep_")})
    private Set<Groep> groepen = new HashSet<Groep>();

    public void changePassword(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITM);
        md.update(password.getBytes(DIGEST_CHARSET));
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toHexString(digest[i] >> 4 & 0xF));
            sb.append(Integer.toHexString(digest[i] & 0xF));
        }
        this.setWachtwoord(sb.toString());
    }

    public String getWachtwoord() {
        return this.wachtwoord;
    }

    public void setWachtwoord(String wachtwoord) {
        this.wachtwoord = wachtwoord;
    }

    public Set<Groep> getGroepen() {
        return this.groepen;
    }

    public void setGroepen(Set<Groep> groepen) {
        this.groepen = groepen;
    }

    public String getGebruikersnaam() {
        return this.gebruikersnaam;
    }

    public void setGebruikersnaam(String gebruikersnaam) {
        this.gebruikersnaam = gebruikersnaam;
    }
}

