/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.persistence;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;

public class SnakeCasePhysicalNamingStrategy
extends PhysicalNamingStrategyStandardImpl {
    public Identifier toPhysicalCatalogName(Identifier name, JdbcEnvironment context) {
        return super.toPhysicalCatalogName(this.toSnakeCase(name), context);
    }

    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment context) {
        return super.toPhysicalColumnName(this.toSnakeCase(name), context);
    }

    public Identifier toPhysicalSchemaName(Identifier name, JdbcEnvironment context) {
        return super.toPhysicalSchemaName(this.toSnakeCase(name), context);
    }

    public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment context) {
        return super.toPhysicalSequenceName(this.toSnakeCase(name), context);
    }

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment context) {
        return super.toPhysicalTableName(this.toSnakeCase(name), context);
    }

    private Identifier toSnakeCase(Identifier id) {
        if (id == null) {
            return id;
        }
        String name = id.getText();
        String snakeName = name.replaceAll("([a-z]+)([A-Z]+)", "$1\\_$2").toLowerCase();
        if (!snakeName.equals(name)) {
            return new Identifier(snakeName, id.isQuoted());
        }
        return id;
    }
}

