/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.persistence.staging;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.ElementCollection;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import nl.b3p.brmo.persistence.staging.ClobElement;
import org.hibernate.annotations.Type;

@MappedSuperclass
@DiscriminatorColumn(name="dtype", discriminatorType=DiscriminatorType.STRING, length=255)
public abstract class AutomatischProces
implements Serializable {
    public static final String LOG_NEWLINE = "\n";
    @Id
    @GeneratedValue
    private Long id;
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="proces_id")})
    @MapKeyJoinColumn
    private Map<String, ClobElement> config = new HashMap<String, ClobElement>();
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastrun;
    @Enumerated(value=EnumType.STRING)
    private ProcessingStatus status = ProcessingStatus.WAITING;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String samenvatting;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String logfile;
    private String cronExpressie;

    public void updateSamenvattingEnLogfile(String samenvatting) {
        if (samenvatting == null) {
            samenvatting = "";
        }
        this.setSamenvatting(samenvatting);
        if (this.logfile == null) {
            this.setLogfile(samenvatting);
        } else {
            this.setLogfile(this.logfile + LOG_NEWLINE + samenvatting);
        }
    }

    public Map<String, ClobElement> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, ClobElement> config) {
        this.config = config;
    }

    public Date getLastrun() {
        return this.lastrun;
    }

    public void setLastrun(Date lastrun) {
        this.lastrun = lastrun;
    }

    public ProcessingStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcessingStatus status) {
        this.status = status;
    }

    public String getSamenvatting() {
        return this.samenvatting;
    }

    public void setSamenvatting(String samenvatting) {
        this.samenvatting = samenvatting;
    }

    public String getLogfile() {
        return this.logfile;
    }

    public void setLogfile(String logfile) {
        this.logfile = logfile;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCronExpressie() {
        return this.cronExpressie;
    }

    public void setCronExpressie(String cronExpressie) {
        this.cronExpressie = cronExpressie;
    }

    public static enum ProcessingStatus {
        PROCESSING("PROCESSING"),
        WAITING("WAITING"),
        ONBEKEND("ONBEKEND"),
        ERROR("ERROR");

        private final String status;

        private ProcessingStatus(String status) {
            this.status = status;
        }
    }
}

