/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.proxy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BerichtEndpointFileServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(BerichtEndpointFileServlet.class);
    private static final String SAVE_DIR = "save_dir";
    private static final String MAX_UPLOAD_SIZE = "max_upload_size";
    private File saveDir;
    private int maxUploadSize;

    public void init() throws ServletException {
        String _saveDir = this.getInitParameter(SAVE_DIR);
        if (_saveDir == null && !_saveDir.isEmpty()) {
            throw new ServletException("De parameter 'save_dir' is benodigd.");
        }
        this.saveDir = new File(_saveDir);
        try {
            FileUtils.forceMkdir((File)this.saveDir);
            log.info((Object)("Initialisatie met directory: " + this.saveDir));
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
        if (!this.saveDir.canWrite()) {
            throw new ServletException("De directory '" + _saveDir + "' is niet schrijfbaar.");
        }
        try {
            this.maxUploadSize = Integer.parseInt(this.getInitParameter(MAX_UPLOAD_SIZE)) * 1024;
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)nfe);
            this.maxUploadSize = 0x1900000;
            log.warn((Object)"De maximale upload size is ingesteld op 25 MB (default).");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getContentLength() > this.maxUploadSize) {
            throw new ServletException("De 'max_upload_size' van " + this.maxUploadSize + " is overschreden.");
        }
        Object in = request.getInputStream();
        if ("gzip".equals(request.getHeader("Content-Encoding"))) {
            in = new GZIPInputStream((InputStream)in);
        }
        File _tmpfile = File.createTempFile(this.getFileName(), ".xml", FileUtils.getTempDirectory());
        FileUtils.copyInputStreamToFile((InputStream)in, (File)_tmpfile);
        FileUtils.moveToDirectory((File)_tmpfile, (File)this.saveDir, (boolean)true);
        log.info((Object)String.format("Aangeboden bestand '%s' opgeslagen in directory: %s.", _tmpfile.getName(), this.saveDir));
        response.setStatus(200);
    }

    private String getFileName() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS");
        return "post-op_" + sdf.format(new Date()) + "_";
    }
}

