/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BerichtEndpointProxyServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(BerichtEndpointProxyServlet.class);
    private static final String PROXY_FOR_URL = "proxy_for_url";
    private URL proxyForUrl;
    private static final String MAX_UPLOAD_SIZE = "max_upload_size";
    private int maxUploadSize;

    public void init() throws ServletException {
        try {
            this.maxUploadSize = Integer.parseInt(this.getInitParameter(MAX_UPLOAD_SIZE)) * 1024;
        }
        catch (NumberFormatException nfe) {
            this.maxUploadSize = 0x1900000;
            log.warn((Object)"De maximale upload size is ingesteld op 25 MB (default).");
        }
        try {
            this.proxyForUrl = new URL(this.getInitParameter(PROXY_FOR_URL));
        }
        catch (MalformedURLException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getContentLength() > this.maxUploadSize) {
            throw new ServletException("De 'max_upload_size' is overschreden.");
        }
        HttpURLConnection conn = (HttpURLConnection)this.proxyForUrl.openConnection();
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Length", "" + request.getContentLength());
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        Object in = request.getInputStream();
        if ("gzip".equals(request.getHeader("Content-Encoding"))) {
            in = new GZIPInputStream((InputStream)in);
        }
        int copied = IOUtils.copy((InputStream)in, (OutputStream)conn.getOutputStream());
        conn.disconnect();
        log.info((Object)String.format("BRMO response status: %d: %s (%d bytes).", conn.getResponseCode(), conn.getResponseMessage(), copied));
        response.setStatus(200);
    }
}

