/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.SimpleError;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.persistence.staging.AutomatischProces;
import nl.b3p.brmo.persistence.staging.MailRapportageProces;
import nl.b3p.brmo.service.scanner.AbstractExecutableProces;
import nl.b3p.brmo.service.scanner.MailRapportage;
import org.stripesstuff.stripersist.EntityTypeConverter;
import org.stripesstuff.stripersist.Stripersist;

@StrictBinding
public class MailProcesUitvoerActionBean
implements ActionBean {
    private static final String JSP = "/WEB-INF/jsp/beheer/mailprocesuitvoeren.jsp";
    @Validate(converter=EntityTypeConverter.class)
    private MailRapportageProces proces;
    private ActionBeanContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultHandler
    public Resolution execute() {
        if (this.proces == null) {
            this.getContext().getMessages().add(new SimpleMessage("Proces ongeldig!", new Object[0]));
            return new ForwardResolution(JSP);
        }
        MailRapportage _proces = (MailRapportage)AbstractExecutableProces.getProces((AutomatischProces)this.proces);
        try {
            _proces.execute();
            this.getContext().getMessages().add(new SimpleMessage("De mail is verstuurd.", new Object[0]));
        }
        catch (BrmoException ex) {
            this.proces.setStatus(AutomatischProces.ProcessingStatus.ERROR);
            this.getContext().getMessages().add(new SimpleError("Er is een fout opgetreden tijdens het verturen van de mail. {2}", new Object[]{ex.getMessage()}));
        }
        finally {
            Stripersist.getEntityManager().merge((Object)this.proces);
            Stripersist.getEntityManager().getTransaction().commit();
        }
        return new ForwardResolution(JSP);
    }

    public MailRapportageProces getProces() {
        return this.proces;
    }

    public void setProces(MailRapportageProces proces) {
        this.proces = proces;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }
}

