/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.service.stripes;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.SimpleMessage;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.loader.ProgressUpdateListener;
import nl.b3p.brmo.loader.util.BrmoException;
import nl.b3p.brmo.service.stripes.BasisregistratieFileUploadActionBean;
import nl.b3p.brmo.service.util.ConfigUtil;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@StrictBinding
public class BasisregistratieFileUploadActionBean
implements ActionBean {
    private static final int ZIP_HEADER = 1347093252;
    private static final Log log = LogFactory.getLog(BasisregistratieFileUploadActionBean.class);
    private ActionBeanContext context;
    @Validate(required=true)
    private String basisregistratie;
    @Validate(required=true)
    private FileBean bestand;

    @DefaultHandler
    @DontValidate
    public Resolution form() {
        return new ForwardResolution("/WEB-INF/jsp/bestand/form.jsp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resolution upload() throws BrmoException {
        DataSource ds = ConfigUtil.getDataSourceStaging();
        BrmoFramework brmo = null;
        brmo = new BrmoFramework(ds, null);
        try {
            MutableLong theTotal = new MutableLong(0L);
            int extractedFiles = 0;
            1 totalAdder = new /* Unavailable Anonymous Inner Class!! */;
            BufferedInputStream in = new BufferedInputStream(this.bestand.getInputStream());
            ((InputStream)in).mark(4);
            int header = new DataInputStream(in).readInt();
            ((InputStream)in).reset();
            Object unzippedFile = null;
            if (header == 1347093252) {
                try (ZipInputStream zip = new ZipInputStream(in);){
                    ZipEntry entry = zip.getNextEntry();
                    while (entry != null) {
                        if (!entry.getName().toLowerCase().endsWith(".xml")) {
                            log.warn((Object)("Overslaan zip entry geen XML: " + entry.getName()));
                        } else {
                            log.debug((Object)("Lezen XML bestand uit zip: " + entry.getName()));
                            brmo.loadFromStream(this.basisregistratie, (InputStream)new CloseShieldInputStream((InputStream)zip), this.bestand.getFileName() + "/" + entry.getName(), (ProgressUpdateListener)totalAdder);
                            ++extractedFiles;
                        }
                        entry = zip.getNextEntry();
                    }
                }
            } else {
                brmo.loadFromStream(this.basisregistratie, (InputStream)in, this.bestand.getFileName());
            }
            this.getContext().getMessages().add(new SimpleMessage("Bestand " + this.bestand.getFileName() + " is ingelezen, " + theTotal.getValue() + " berichten" + (extractedFiles > 0 ? " (uit " + extractedFiles + " uitgepakte XML bestanden)" : ""), new Object[0]));
            log.info((Object)String.format("Stored %s data from file \"%s\" uploaded via form", this.basisregistratie, this.bestand.getFileName()));
        }
        catch (Exception ex) {
            log.error((Object)"Fout bij inlezen bestand", (Throwable)ex);
            this.getContext().getMessages().add(new SimpleMessage("Fout bij inlezen bestand: " + ExceptionUtils.getRootCauseMessage((Throwable)ex), new Object[0]));
        }
        finally {
            try {
                this.bestand.delete();
            }
            catch (IOException iOException) {}
            brmo.closeBrmoFramework();
        }
        return new ForwardResolution("/WEB-INF/jsp/bestand/form.jsp");
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public String getBasisregistratie() {
        return this.basisregistratie;
    }

    public void setBasisregistratie(String basisregistratie) {
        this.basisregistratie = basisregistratie;
    }

    public FileBean getBestand() {
        return this.bestand;
    }

    public void setBestand(FileBean bestand) {
        this.bestand = bestand;
    }
}

